/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./Form','./FormContainer','./FormElement','./FormLayout','sap/ui/base/ManagedObjectObserver','sap/ui/layout/library','sap/ui/core/ResizeHandler','./SimpleFormRenderer'],function(q,C,F,a,b,c,M,l,R,S){"use strict";var B=l.BackgroundDesign;var d=l.form.SimpleFormLayout;var e;var f;var g;var G;var h;var m;var n=C.extend("sap.ui.layout.form.SimpleForm",{metadata:{library:"sap.ui.layout",properties:{maxContainerCols:{type:"int",group:"Appearance",defaultValue:2},minWidth:{type:"int",group:"Appearance",defaultValue:-1},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:null},labelMinWidth:{type:"int",group:"Misc",defaultValue:192},layout:{type:"sap.ui.layout.form.SimpleFormLayout",group:"Misc",defaultValue:d.ResponsiveLayout},labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600},backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:B.Translucent}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Element",multiple:true,singularName:"content"},form:{type:"sap.ui.layout.form.Form",multiple:false,visibility:"hidden"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/ui/layout/designtime/form/SimpleForm.designtime"}});n.prototype.init=function(){this._iMaxWeight=8;this._iLabelWeight=3;this._iCurrentWidth=0;var i=new F(this.getId()+"--Form");i.getTitle=function(){return this.getParent().getTitle();};i._origInvalidate=i.invalidate;i.invalidate=function(j){if(this.bOutput){this._origInvalidate(j);}if(this._bIsBeingDestroyed){return;}var k=this.getParent();if(k){k._formInvalidated(j);}};i.getAriaLabelledBy=function(){var j=this.getParent();if(j){return j.getAriaLabelledBy();}else{return null;}};i._origOnLayoutDataChange=i.onLayoutDataChange;i.onLayoutDataChange=function(j){this._origOnLayoutDataChange(j);var k=this.getParent();if(k){k._onLayoutDataChange(j);}};this.setAggregation("form",i);this._aElements=null;this._aLayouts=[];this._changedFormContainers=[];this._changedFormElements=[];this._oObserver=new M(T.bind(this));};n.prototype.exit=function(){var j=this.getAggregation("form");j.invalidate=j._origInvalidate;P.call(this);for(var i=0;i<this._aLayouts.length;i++){var k=sap.ui.getCore().byId(this._aLayouts[i]);if(k&&k.destroy){k.destroy();}}this._aLayouts=[];this._aElements=null;this._changedFormContainers=[];this._changedFormElements=[];this._oObserver.disconnect();this._oObserver=undefined;};n.prototype.onBeforeRendering=function(){P.call(this);var i=this.getAggregation("form");if(!this._bResponsiveLayoutRequested&&!this._bGridLayoutRequested&&!this._bResponsiveGridLayoutRequested){var j=true;if(!i.getLayout()){j=_.call(this);}if(j){v.call(this);}}};n.prototype.onAfterRendering=function(){if(this.getLayout()==d.ResponsiveLayout){this._bChangedByMe=true;this.$().css("visibility","hidden");this._applyLinebreaks();this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._resize,this));this._bChangedByMe=false;}};n.prototype.setEditable=function(i){this._bChangedByMe=true;this.setProperty("editable",i,true);var j=this.getAggregation("form");j.setEditable(i);this._bChangedByMe=false;return this;};n.prototype.setToolbar=function(i){this._bChangedByMe=true;var j=this.getAggregation("form");j.setToolbar(i);this._bChangedByMe=false;return this;};n.prototype.getToolbar=function(){var i=this.getAggregation("form");return i.getToolbar();};n.prototype.destroyToolbar=function(){this._bChangedByMe=true;var i=this.getAggregation("form");i.destroyToolbar();this._bChangedByMe=false;return this;};n.prototype.setLabelMinWidth=function(j){this.setProperty("labelMinWidth",j,true);if(this.getLayout()==d.ResponsiveLayout){this._bLayoutDataChangedByMe=true;var k=this.getContent();for(var i=0;i<k.length;i++){var W=k[i];if(W.getMetadata().isInstanceOf("sap.ui.core.Label")){var X=y.call(this,W);if(V(X,"sap/ui/layout/ResponsiveFlowLayoutData")&&w.call(this,X)){X.setMinWidth(j);}}}this._bLayoutDataChangedByMe=false;}return this;};n.prototype.indexOfContent=function(j){var k=this._aElements;if(k){for(var i=0;i<k.length;i++){if(k[i]==j){return i;}}}return-1;};n.prototype.addContent=function(i){i=this.validateAggregation("content",i,true);if(this.indexOfContent(i)>=0){q.sap.log.warning("SimpleForm.addContent: Content element '"+i+"' already assigned. Please remove before adding!",this);this.removeContent(i);}if(!this._aElements){this._aElements=[];}this._bChangedByMe=true;var j=this._aElements.length;var k;var W=this.getAggregation("form");var X;var Y;var Z;var $;if(V(i,"sap/ui/core/Title")||i.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){X=L.call(this,i);W.addFormContainer(X);this._changedFormContainers.push(X);}else if(i.getMetadata().isInstanceOf("sap.ui.core.Label")){if(j>0){k=this._aElements[j-1];Z=k.getParent();if(Z instanceof b){X=Z.getParent();}else if(Z instanceof a){X=Z;}}if(!X){X=L.call(this);W.addFormContainer(X);this._changedFormContainers.push(X);}Y=I.call(this,X,i);}else{if(j>0){k=this._aElements[j-1];Z=k.getParent();if(Z instanceof b){X=Z.getParent();Y=Z;$=y.call(this,i);if(V($,"sap/ui/layout/ResponsiveFlowLayoutData")&&!w.call(this,$)&&$.getLinebreak()){Y=I.call(this,X);}}else if(Z instanceof a){X=Z;Y=I.call(this,X);}}else{X=L.call(this);W.addFormContainer(X);this._changedFormContainers.push(X);Y=I.call(this,X);}A.call(this,i,5,false,true);Y.addField(i);Q(this._changedFormElements,Y);}this._aElements.push(i);this._oObserver.observe(i,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this;};n.prototype.insertContent=function(j,k){j=this.validateAggregation("content",j,true);if(this.indexOfContent(j)>=0){q.sap.log.warning("SimpleForm.insertContent: Content element '"+j+"' already assigned. Please remove before insert!",this);this.removeContent(j);}if(!this._aElements){this._aElements=[];}var W=this._aElements.length;var X;if(k<0){X=0;}else if(k>W){X=W;}else{X=k;}if(X!==k){q.sap.log.warning("SimpleForm.insertContent: index '"+k+"' out of range [0,"+W+"], forced to "+X);}if(X==W){this.addContent(j);return this;}this._bChangedByMe=true;var Y=this._aElements[X];var Z=this.getAggregation("form");var $;var a1;var b1;var c1;var d1;var e1=0;var f1;var g1;var h1;var i1;var i=0;var j1;var k1;if(V(j,"sap/ui/core/Title")||j.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){if(k==0&&!(V(Y,"sap/ui/core/Title")||Y.getMetadata().isInstanceOf("sap.ui.core.Toolbar"))){$=Y.getParent().getParent();if(V(j,"sap/ui/core/Title")){$.setTitle(j);}else{$.setToolbar(j);}}else{$=L.call(this,j);if(V(Y,"sap/ui/core/Title")||Y.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){b1=Y.getParent();d1=Z.indexOfFormContainer(b1);}else{c1=Y.getParent();b1=c1.getParent();d1=Z.indexOfFormContainer(b1)+1;e1=b1.indexOfFormElement(c1);if(!Y.getMetadata().isInstanceOf("sap.ui.core.Label")){f1=c1.indexOfField(Y);if(f1>0||c1.getLabel()){a1=I.call(this,$);this._changedFormElements.push(a1);Q(this._changedFormElements,c1);g1=c1.getFields();for(i=f1;i<g1.length;i++){j1=g1[i];a1.addField(j1);}e1++;}}h1=b1.getFormElements();for(i=e1;i<h1.length;i++){$.addFormElement(h1[i]);}}Z.insertFormContainer($,d1);}this._changedFormContainers.push($);}else if(j.getMetadata().isInstanceOf("sap.ui.core.Label")){if(V(Y,"sap/ui/core/Title")||Y.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){b1=Y.getParent();d1=Z.indexOfFormContainer(b1);i1=Z.getFormContainers();if(d1==0){$=L.call(this);Z.insertFormContainer($,d1);this._changedFormContainers.push($);}else{$=i1[d1-1];}a1=I.call(this,$,j);}else if(Y.getMetadata().isInstanceOf("sap.ui.core.Label")){b1=Y.getParent().getParent();e1=b1.indexOfFormElement(Y.getParent());a1=J.call(this,b1,j,e1);}else{c1=Y.getParent();b1=c1.getParent();e1=b1.indexOfFormElement(c1)+1;f1=c1.indexOfField(Y);if(f1==0&&!c1.getLabel()){a1=c1;a1.setLabel(j);A.call(this,j,this._iLabelWeight,false,true,this.getLabelMinWidth());}else{a1=J.call(this,b1,j,e1);Q(this._changedFormElements,c1);g1=c1.getFields();for(i=f1;i<g1.length;i++){j1=g1[i];a1.addField(j1);}}}this._changedFormElements.push(a1);}else{k1=y.call(this,j);if(V(Y,"sap/ui/core/Title")||Y.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){b1=Y.getParent();d1=Z.indexOfFormContainer(b1);if(d1==0){$=L.call(this);Z.insertFormContainer($,d1);this._changedFormContainers.push($);}else{i1=Z.getFormContainers();$=i1[d1-1];}h1=$.getFormElements();if(h1.length==0){a1=I.call(this,$);}else if(V(k1,"sap/ui/layout/ResponsiveFlowLayoutData")&&!w.call(this,k1)&&k1.getLinebreak()){a1=I.call(this,$);}else{a1=h1[h1.length-1];}a1.addField(j);}else if(Y.getMetadata().isInstanceOf("sap.ui.core.Label")){c1=Y.getParent();$=c1.getParent();e1=$.indexOfFormElement(c1);if(e1==0){a1=J.call(this,$,null,0);}else if(V(k1,"sap/ui/layout/ResponsiveFlowLayoutData")&&!w.call(this,k1)&&k1.getLinebreak()){a1=J.call(this,$,null,e1);}else{h1=$.getFormElements();a1=h1[e1-1];}a1.addField(j);}else{a1=Y.getParent();f1=a1.indexOfField(Y);if(V(k1,"sap/ui/layout/ResponsiveFlowLayoutData")&&!w.call(this,k1)&&k1.getLinebreak()&&f1>0){$=a1.getParent();e1=$.indexOfFormElement(a1);Q(this._changedFormElements,a1);g1=a1.getFields();a1=J.call(this,$,undefined,e1+1);a1.addField(j);for(i=f1;i<g1.length;i++){j1=g1[i];a1.addField(j1);}}else{a1.insertField(j,f1);}}Q(this._changedFormElements,a1);A.call(this,j,5,false,true);}this._aElements.splice(X,0,j);this._oObserver.observe(j,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this;};n.prototype.removeContent=function(j){var k=null;var W=-1;var i=0;if(this._aElements){if(typeof(j)=="string"){j=sap.ui.getCore().byId(j);}if(typeof(j)=="object"){for(i=0;i<this._aElements.length;i++){if(this._aElements[i]==j){j=i;break;}}}if(typeof(j)=="number"){if(j<0||j>=this._aElements.length){q.sap.log.warning("Element.removeAggregation called with invalid index: Items, "+j);}else{W=j;k=this._aElements[W];}}}if(k){this._bChangedByMe=true;var X=this.getAggregation("form");var Y;var Z;var $;var a1;if(V(k,"sap/ui/core/Title")||k.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){Y=k.getParent();Y.setTitle(null);Y.setToolbar(null);if(W>0){$=Y.getFormElements();var b1=X.indexOfFormContainer(Y);var c1=X.getFormContainers()[b1-1];if($.length>0&&!$[0].getLabel()){var d1=c1.getFormElements();var e1=d1[d1.length-1];a1=$[0].getFields();for(i=0;i<a1.length;i++){e1.addField(a1[i]);}Q(this._changedFormElements,e1);Y.removeFormElement($[0]);$[0].destroy();$.splice(0,1);}for(i=0;i<$.length;i++){c1.addFormElement($[i]);}Q(this._changedFormContainers,c1);X.removeFormContainer(Y);Y.destroy();}else if(Y.getFormElements().length==0){X.removeFormContainer(Y);Y.destroy();}}else if(k.getMetadata().isInstanceOf("sap.ui.core.Label")){Z=k.getParent();Y=Z.getParent();Z.setLabel(null);var f1=Y.indexOfFormElement(Z);if(f1==0){if(Z.getFields().length==0){Y.removeFormElement(Z);Z.destroy();if(Y.getFormElements().length==0&&!Y.getTitle()&&!Y.getToolbar()){X.removeFormContainer(Y);Y.destroy();}}else{Q(this._changedFormElements,Z);}}else{$=Y.getFormElements();var g1=$[f1-1];a1=Z.getFields();for(i=0;i<a1.length;i++){g1.addField(a1[i]);}Q(this._changedFormElements,g1);Y.removeFormElement(Z);Z.destroy();}}else{Z=k.getParent();Z.removeField(k);if(Z.getFields().length==0&&!Z.getLabel()){Y=Z.getParent();Y.removeFormElement(Z);Z.destroy();if(Y.getFormElements().length==0&&!Y.getTitle()&&!Y.getToolbar()){X.removeFormContainer(Y);Y.destroy();}}else{Q(this._changedFormElements,Z);}}this._aElements.splice(W,1);k.setParent(null);this._oObserver.unobserve(k);H.call(this,k);this.invalidate();this._bChangedByMe=false;return k;}return null;};n.prototype.removeAllContent=function(){var i=0;if(this._aElements){this._bChangedByMe=true;var k=this.getAggregation("form");var W=k.getFormContainers();for(i=0;i<W.length;i++){var X=W[i];X.setTitle(null);X.setToolbar(null);var Y=X.getFormElements();for(var j=0;j<Y.length;j++){var Z=Y[j];Z.setLabel(null);Z.removeAllFields();}X.destroyFormElements();}k.destroyFormContainers();for(i=0;i<this._aElements.length;i++){var $=this._aElements[i];H.call(this,$);this._oObserver.unobserve($);}var a1=this._aElements;this._aElements=null;this.invalidate();this._bChangedByMe=false;return a1;}else{return[];}};n.prototype.destroyContent=function(){var j=this.removeAllContent();if(j){this._bChangedByMe=true;for(var i=0;i<j.length;i++){j[i].destroy();}this.invalidate();this._bChangedByMe=false;}return this;};n.prototype.getContent=function(){if(!this._aElements){this._aElements=this.getAggregation("content",[]);}return this._aElements.slice();};n.prototype.setLayout=function(i){var j=this.getLayout();if(i!=j){t.call(this);}this.setProperty("layout",i);if(i!=j){var k=_.call(this);if(k){u.call(this);}}return this;};n.prototype.clone=function(k){this._bChangedByMe=true;var W=C.prototype.clone.apply(this,arguments);var X=this.getContent();for(var i=0;i<X.length;i++){var Y=X[i];var Z=Y.getLayoutData();this._oObserver.unobserve(Y);var $=Y.clone(k);this._oObserver.observe(Y,{properties:["visible"]});if(Z){if(V(Z,"sap/ui/core/VariantLayoutData")){var a1=Z.getMultipleLayoutData();for(var j=0;j<a1.length;j++){if(w.call(this,a1[j])){W._aLayouts.push($.getLayoutData().getMultipleLayoutData()[j].getId());}}}else if(w.call(this,Z)){W._aLayouts.push($.getLayoutData().getId());}}W.addContent($);}this._bChangedByMe=false;return W;};function _(){var i=this.getAggregation("form");if(i.getLayout()){this._bChangedByMe=true;i.destroyLayout();P.call(this);this._bChangedByMe=false;}var j;switch(this.getLayout()){case d.ResponsiveLayout:if((!e||!f)&&!this._bResponsiveLayoutRequested){e=sap.ui.require("sap/ui/layout/form/ResponsiveLayout");f=sap.ui.require("sap/ui/layout/ResponsiveFlowLayoutData");if(!e||!f){sap.ui.require(["sap/ui/layout/form/ResponsiveLayout","sap/ui/layout/ResponsiveFlowLayoutData"],o.bind(this));this._bResponsiveLayoutRequested=true;}}if(e&&f){j=new e(this.getId()+"--Layout");}break;case d.GridLayout:if((!G||!h||!m)&&!this._bGridLayoutRequested){G=sap.ui.require("sap/ui/layout/form/GridLayout");h=sap.ui.require("sap/ui/layout/form/GridContainerData");m=sap.ui.require("sap/ui/layout/form/GridElementData");if(!G||!h||!m){sap.ui.require(["sap/ui/layout/form/GridLayout","sap/ui/layout/form/GridContainerData","sap/ui/layout/form/GridElementData"],p.bind(this));this._bGridLayoutRequested=true;}}if(G&&h&&m){j=new G(this.getId()+"--Layout");}break;case d.ResponsiveGridLayout:if(!g&&!this._bResponsiveGridLayoutRequested){g=sap.ui.require("sap/ui/layout/form/ResponsiveGridLayout");if(!g){sap.ui.require(["sap/ui/layout/form/ResponsiveGridLayout"],r.bind(this));this._bResponsiveGridLayoutRequested=true;}}if(g){j=new g(this.getId()+"--Layout");}break;}if(j){this._bChangedByMe=true;i.setLayout(j);this._bChangedByMe=false;return true;}return false;}function o(i,j){e=i;f=j;this._bResponsiveLayoutRequested=false;if(this.getLayout()==d.ResponsiveLayout){s.call(this);}}function p(i,j,k){G=i;h=j;m=k;this._bGridLayoutRequested=false;if(this.getLayout()==d.GridLayout){s.call(this);}}function r(i){g=i;this._bResponsiveGridLayoutRequested=false;if(this.getLayout()==d.ResponsiveGridLayout){s.call(this);}}function s(){if(!this._bIsBeingDestroyed){_.call(this);u.call(this);if(this.getDomRef()){v.call(this);}}}function t(){this._bChangedByMe=true;var W=this.getAggregation("form");var X=W.getFormContainers();for(var i=0;i<X.length;i++){var Y=X[i];Q(this._changedFormContainers,Y);if(Y.getLayoutData()){Y.destroyLayoutData();}var Z=Y.getFormElements();for(var j=0;j<Z.length;j++){var $=Z[j];Q(this._changedFormElements,$);if($.getLayoutData()){$.destroyLayoutData();}var a1=$.getLabel();if(a1){H.call(this,a1);}var b1=$.getFields();for(var k=0;k<b1.length;k++){var c1=b1[k];H.call(this,c1);}}}this._bChangedByMe=false;}function u(){this._bChangedByMe=true;var W=this.getAggregation("form");var X=W.getFormContainers();for(var i=0;i<X.length;i++){var Y=X[i];Q(this._changedFormContainers,Y);E.call(this,Y);var Z=Y.getFormElements();for(var j=0;j<Z.length;j++){var $=Z[j];Q(this._changedFormElements,$);D.call(this,$);var a1=$.getLabel();if(a1){A.call(this,a1,this._iLabelWeight,false,true,this.getLabelMinWidth());}var b1=$.getFields();for(var k=0;k<b1.length;k++){var c1=b1[k];A.call(this,c1,5,false,true);}}}this._bChangedByMe=false;}function v(){this._bChangedByMe=true;this._changedFormContainers=[];var j=this.getLayout();var k=this.getAggregation("form").getLayout();k.setBackgroundDesign(this.getBackgroundDesign());switch(j){case d.ResponsiveLayout:this._applyLinebreaks();for(var i=0;i<this._changedFormElements.length;i++){var W=this._changedFormElements[i];N.call(this,W);}break;case d.GridLayout:O.call(this);break;case d.ResponsiveGridLayout:k.setLabelSpanXL(this.getLabelSpanXL());k.setLabelSpanL(this.getLabelSpanL());k.setLabelSpanM(this.getLabelSpanM());k.setLabelSpanS(this.getLabelSpanS());k.setAdjustLabelSpan(this.getAdjustLabelSpan());k.setEmptySpanXL(this.getEmptySpanXL());k.setEmptySpanL(this.getEmptySpanL());k.setEmptySpanM(this.getEmptySpanM());k.setEmptySpanS(this.getEmptySpanS());k.setColumnsXL(this.getColumnsXL());k.setColumnsL(this.getColumnsL());k.setColumnsM(this.getColumnsM());k.setSingleContainerFullSize(this.getSingleContainerFullSize());k.setBreakpointXL(this.getBreakpointXL());k.setBreakpointL(this.getBreakpointL());k.setBreakpointM(this.getBreakpointM());break;}this._changedFormElements=[];this._bChangedByMe=false;}function w(i){var j=i.getId(),k=" "+this._aLayouts.join(" ")+" ";return k.indexOf(" "+j+" ")>-1;}function x(W,i,j,k){var X=new f({weight:W,linebreak:i===true,linebreakable:j===true});if(k){X.setMinWidth(k);}this._aLayouts.push(X.getId());return X;}function y(i){var j;switch(this.getLayout()){case d.ResponsiveLayout:j=c.prototype.getLayoutDataForElement(i,"sap/ui/layout/ResponsiveFlowLayoutData");break;case d.GridLayout:j=c.prototype.getLayoutDataForElement(i,"sap/ui/layout/form/GridElementData");break;case d.ResponsiveGridLayout:j=c.prototype.getLayoutDataForElement(i,"sap/ui/layout/GridData");break;}return j;}function z(){if(this._bResponsiveLayoutRequested||this._bGridLayoutRequested||this._bResponsiveGridLayoutRequested){return false;}if(!this.getAggregation("form").getLayout()){var i=this._bChangedByMe;var j=_.call(this);this._bChangedByMe=i;if(!j){return false;}}return true;}function A(i,W,j,k,X){if(this.getLayout()!=d.ResponsiveLayout){return;}if(!z.call(this)){return;}this._bLayoutDataChangedByMe=true;var Y=y.call(this,i);if(!Y||!w.call(this,Y)){Y=i.getLayoutData();if(V(Y,"sap/ui/core/VariantLayoutData")){Y.addMultipleLayoutData(x.call(this,W,j,k,X));}else if(!Y){i.setLayoutData(x.call(this,W,j,k,X));}else{q.sap.log.warning("ResponsiveFlowLayoutData can not be set on Field "+i.getId(),"_createFieldLayoutData","SimpleForm");}}this._bLayoutDataChangedByMe=false;}function D(i){if(this.getLayout()!=d.ResponsiveLayout){return;}if(!z.call(this)){return;}this._bLayoutDataChangedByMe=true;i.setLayoutData(new f({linebreak:true,margin:false}));this._bLayoutDataChangedByMe=false;}function E(i){var j=this.getLayout();if(j!=d.ResponsiveLayout&&j!=d.GridLayout){return;}if(!z.call(this)){return;}this._bLayoutDataChangedByMe=true;switch(j){case d.ResponsiveLayout:i.setLayoutData(new f({minWidth:280}));break;case d.GridLayout:if(this.getMaxContainerCols()>1){i.setLayoutData(new h({halfGrid:true}));}else{i.setLayoutData(new h({halfGrid:false}));}break;}this._bLayoutDataChangedByMe=false;}function H(j){this._bLayoutDataChangedByMe=true;var k=y.call(this,j);if(k){var W=k.getId();for(var i=0;i<this._aLayouts.length;i++){var X=this._aLayouts[i];if(W==X){k.destroy();this._aLayouts.splice(i,1);break;}}}this._bLayoutDataChangedByMe=false;}function I(i,j){var k=K.call(this,j);i.addFormElement(k);return k;}function J(i,j,k){var W=K.call(this,j);i.insertFormElement(W,k);return W;}function K(j){var k=new b();D.call(this,k);if(j){j.addStyleClass("sapUiFormLabel-CTX");k.setLabel(j);if(!y.call(this,j)){A.call(this,j,this._iLabelWeight,false,true,this.getLabelMinWidth());}}k.isVisible=function(){var W=this.getFields();var X=false;for(var i=0;i<W.length;i++){var Y=W[i];if(Y.getVisible()){X=true;break;}}return X;};return k;}function L(i){var j=new a();E.call(this,j);j.getAriaLabelledBy=function(){var k=this.getToolbar();if(k){return k.getAriaLabelledBy();}else{return[];}};if(i){if(V(i,"sap/ui/core/Title")){j.setTitle(i);}else if(i.getMetadata().isInstanceOf("sap.ui.core.Toolbar")){j.setToolbar(i);}}return j;}function N(j){var k=this._iMaxWeight;var W=j.getFields();var X;var Y=W.length;var Z=j.getLabel();var $;var i=0;this._bLayoutDataChangedByMe=true;if(Z&&y.call(this,Z)){k=k-y.call(this,Z).getWeight();}for(i=0;i<W.length;i++){X=W[i];$=y.call(this,X);if(V($,"sap/ui/layout/ResponsiveFlowLayoutData")&&!w.call(this,$)){k=k-$.getWeight();Y--;}}var a1=Math.floor(k/Y);var b1=k%Y;for(i=0;i<W.length;i++){X=W[i];$=y.call(this,X);var c1=a1;if(!$){A.call(this,X,c1,false,i==0);}else if(w.call(this,$)&&V($,"sap/ui/layout/ResponsiveFlowLayoutData")){if(b1>0){c1++;b1--;}$.setWeight(c1);}}this._bLayoutDataChangedByMe=false;}n.prototype._applyLinebreaks=function(){if(!e||this._bResponsiveLayoutRequested){return;}this._bLayoutDataChangedByMe=true;var j=this.getAggregation("form"),k=j.getFormContainers();var W=this.getDomRef();var X=this.$();for(var i=1;i<k.length;i++){var Y=k[i],Z=Y.getLayoutData();if(!W||X.outerWidth(true)>this.getMinWidth()){if(i%this.getMaxContainerCols()==0){Z.setLinebreak(true);}else{Z.setLinebreak(false);}}else{Z.setLinebreak(true);}}if(W&&X.css("visibility")=="hidden"){var $=this;setTimeout(function(){if($.getDomRef()){$.$().css("visibility","");}},10);}this._bLayoutDataChangedByMe=false;};function O(){this._bLayoutDataChangedByMe=true;var j=this.getAggregation("form");var k=j.getFormContainers();var W=k.length;for(var i=0;i<W;i++){var X=k[i];if((this.getMaxContainerCols()<=1)||((i==W-1)&&(W%2>0))){X.getLayoutData().setHalfGrid(false);}else if(!X.getLayoutData().getHalfGrid()){X.getLayoutData().setHalfGrid(true);}}this._bLayoutDataChangedByMe=false;}n.prototype._resize=function(i){this._bChangedByMe=true;if(this._iCurrentWidth==i.size.width){return;}this._iCurrentWidth=i.size.width;this._applyLinebreaks();this._bChangedByMe=false;};function P(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}}function Q(j,k){var W=false;for(var i=0;i<j.length;i++){var X=j[i];if(X==k){W=true;break;}}if(!W){j.push(k);}}function T(i){if(i.name=="visible"){var j=i.object.getParent();j.invalidate();}}function U(W){var X=[];var Y=W.getFormContainers();for(var i=0;i<Y.length;i++){var Z=Y[i];var $=Z.getTitle();if($){X.push($);}else{var a1=Z.getToolbar();if(a1){X.push(a1);}}var b1=Z.getFormElements();for(var j=0;j<b1.length;j++){var c1=b1[j];var d1=c1.getLabel();if(d1){X.push(d1);}var e1=c1.getFields();for(var k=0;k<e1.length;k++){var f1=e1[k];X.push(f1);}}}return X;}n.prototype._formInvalidated=function(k){if(!this._bChangedByMe){var W=U(this.getAggregation("form"));var i=0;var j=0;var X=false;if(!this._aElements||W.length<this._aElements.length){X=true;}else{for(i=0;i<W.length;i++){var Y=W[i];var Z=this._aElements[j];if(Y===Z){j++;}else{var $=W[i+1];if($===Z){this.insertContent(Y,i);break;}$=this._aElements[j+1];if($===Y){X=true;break;}break;}}}if(X){this.removeAllContent();for(i=0;i<W.length;i++){var a1=W[i];this.addContent(a1);}}}};n.prototype._onLayoutDataChange=function(i){if(!this._bLayoutDataChangedByMe&&!this._bIsBeingDestroyed){switch(this.getLayout()){case d.ResponsiveLayout:var j=i.srcControl;var k=j.getParent();if(k instanceof b){var W=this.indexOfContent(j);this.removeContent(j);this.insertContent(j,W);}break;}}};function V(i,j){var k=sap.ui.require(j);return i&&typeof k==='function'&&(i instanceof k);}return n;});
