/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/SyncPromise","sap/ui/model/BindingMode","sap/ui/model/ChangeReason","sap/ui/model/ClientListBinding","sap/ui/model/ClientPropertyBinding","sap/ui/model/ContextBinding","sap/ui/model/Context","sap/ui/model/MetaModel","sap/ui/model/odata/OperationMode","sap/ui/model/odata/type/Int64","sap/ui/thirdparty/URI","./lib/_Helper","./ValueListType"],function(q,S,B,C,a,b,c,d,M,O,I,U,_,V){"use strict";var f,D=q.sap.log.Level.DEBUG,g,h,s="sap.ui.model.odata.v4.ODataMetaModel",j,r=/^-?\d+$/,m={messageChange:true},u={"Edm.Boolean":{type:"sap.ui.model.odata.type.Boolean"},"Edm.Byte":{type:"sap.ui.model.odata.type.Byte"},"Edm.Date":{type:"sap.ui.model.odata.type.Date"},"Edm.DateTimeOffset":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.DateTimeOffset"},"Edm.Decimal":{constraints:{"@Org.OData.Validation.V1.Minimum/$Decimal":"minimum","@Org.OData.Validation.V1.Minimum@Org.OData.Validation.V1.Exclusive":"minimumExclusive","@Org.OData.Validation.V1.Maximum/$Decimal":"maximum","@Org.OData.Validation.V1.Maximum@Org.OData.Validation.V1.Exclusive":"maximumExclusive","$Precision":"precision","$Scale":"scale"},type:"sap.ui.model.odata.type.Decimal"},"Edm.Double":{type:"sap.ui.model.odata.type.Double"},"Edm.Guid":{type:"sap.ui.model.odata.type.Guid"},"Edm.Int16":{type:"sap.ui.model.odata.type.Int16"},"Edm.Int32":{type:"sap.ui.model.odata.type.Int32"},"Edm.Int64":{type:"sap.ui.model.odata.type.Int64"},"Edm.SByte":{type:"sap.ui.model.odata.type.SByte"},"Edm.Single":{type:"sap.ui.model.odata.type.Single"},"Edm.Stream":{type:"sap.ui.model.odata.type.Stream"},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence","$MaxLength":"maxLength"},type:"sap.ui.model.odata.type.String"},"Edm.TimeOfDay":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.TimeOfDay"}},k={},v="@com.sap.vocabularies.Common.v1.ValueListMapping",l={},p="@com.sap.vocabularies.Common.v1.ValueListReferences",t="@com.sap.vocabularies.Common.v1.ValueListWithFixedValues",W=q.sap.log.Level.WARNING;function w(o,e,R,i){var n,G=o.mSchema2MetadataUrl[e];if(!G){G=o.mSchema2MetadataUrl[e]={};G[R]=false;}else if(!(R in G)){n=Object.keys(G)[0];if(G[n]){z("A schema cannot span more than one document: "+e+" - expected reference URI "+n+" but instead saw "+R,i);}G[R]=false;}}function x(o,e,i,L){var P,n,G,H;function J(R){var K,N;if(!(i in R)){L(W,n," does not contain ",i);return;}L(D,"Including ",i," from ",n);for(N in R){if(N[0]!=="$"&&E(N)===i){K=R[N];e[N]=K;A(K,e.$Annotations);}}}if(i in e){return e[i];}H=o.mSchema2MetadataUrl[i];if(H){G=Object.keys(H);if(G.length>1){z("A schema cannot span more than one document: schema is referenced"+" by following URLs: "+G.join(", "),i);}n=G[0];H[n]=true;L(D,"Namespace ",i," found in $Include of ",n);P=o.mMetadataUrl2Promise[n];if(!P){L(D,"Reading ",n);P=o.mMetadataUrl2Promise[n]=S.resolve(o.oRequestor.read(n)).then(o.validate.bind(o,n));}P=P.then(J);if(i in e){return e[i];}e[i]=P;return P;}}function y(T,e){if(T===e){return"";}if(T.indexOf(e)===0&&T[e.length]==="#"&&T.indexOf("@",e.length)<0){return T.slice(e.length+1);}}function z(e,i){q.sap.log.error(e,i,s);throw new Error(i+": "+e);}function A(o,e){var T;for(T in o.$Annotations){if(T in e){q.extend(e[T],o.$Annotations[T]);}else{e[T]=o.$Annotations[T];}}delete o.$Annotations;}function E(Q){return Q.slice(0,Q.lastIndexOf(".")+1);}g=c.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(o,P,e){c.call(this,o,P,e);},initialize:function(){var e=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(e!==this.oElementContext){this.oElementContext=e;this._fireChange();}},setContext:function(o){if(o!==this.oContext){this.oContext=o;if(!this.bInitial){this.initialize();}}}});h=a.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{constructor:function(){a.apply(this,arguments);},_fireFilter:function(){},_fireSort:function(){},checkUpdate:function(e){var P=this.oList.length;this.update();if(e||this.oList.length!==P){this._fireChange({reason:C.Change});}},fetchContexts:function(){var i,R=this.oModel.resolve(this.sPath,this.oContext),e=this;if(!R){return S.resolve([]);}i=R.slice(-1)==="@";if(!i&&R!=="/"){R+="/";}return this.oModel.fetchObject(R).then(function(o){if(!o){return[];}if(i){R=R.slice(0,-1);}return Object.keys(o).filter(function(K){return K[0]!=="$"&&i!==(K[0]!=="@");}).map(function(K){return new d(e.oModel,R+K);});});},getContexts:function(i,L){this.iCurrentStart=i||0;this.iCurrentLength=Math.min(L||Infinity,this.iLength,this.oModel.iSizeLimit);return this.getCurrentContexts();},getCurrentContexts:function(){var e=[],i,n=this.iCurrentStart+this.iCurrentLength;for(i=this.iCurrentStart;i<n;i++){e.push(this.oList[this.aIndices[i]]);}return e;},setContexts:function(e){this.oList=e;this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();},update:function(){var e=[],P=this.fetchContexts(),i=this;if(P.isFulfilled()){e=P.getResult();}else{P.then(function(e){i.setContexts(e);i._fireChange({reason:C.Change});});}this.setContexts(e);}});j=b.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){b.apply(this,arguments);},_getValue:function(){var P,e=this;P=this.oModel.fetchObject(this.sPath,this.oContext,this.mParameters);if(P.isFulfilled()){return P.getResult();}P.then(function(){e.checkUpdate();});return undefined;},checkUpdate:function(e){var i=this._getValue();if(e||i!==this.oValue){this.oValue=i;this._fireChange({reason:C.Change});}},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue");}});var F=M.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:function(R,e,i,o,n){M.call(this);this.aAnnotationUris=i&&!Array.isArray(i)?[i]:i;this.sDefaultBindingMode=B.OneTime;this.mETags={};this.dLastModified=new Date(0);this.oMetadataPromise=null;this.oModel=o;this.mMetadataUrl2Promise={};this.oRequestor=R;this.mSchema2MetadataUrl={};this.mSupportedBindingModes={"OneTime":true,"OneWay":true};this.bSupportReferences=n!==false;this.sUrl=e;}});F.prototype._mergeAnnotations=function(e,n){var o=this;this.validate(this.sUrl,e);e.$Annotations={};Object.keys(e).forEach(function(i){if(e[i].$kind==="Schema"){w(o,i,o.sUrl);A(e[i],e.$Annotations);}});n.forEach(function(G,i){var H,Q;o.validate(o.aAnnotationUris[i],G);for(Q in G){if(Q[0]!=="$"){if(Q in e){z("A schema cannot span more than one document: "+Q,o.aAnnotationUris[i]);}H=G[Q];e[Q]=H;if(H.$kind==="Schema"){w(o,Q,o.aAnnotationUris[i]);A(H,e.$Annotations);}}}});};F.prototype.attachEvent=function(e){if(!(e in m)){throw new Error("Unsupported event '"+e+"': v4.ODataMetaModel#attachEvent");}return M.prototype.attachEvent.apply(this,arguments);};F.prototype.bindContext=function(P,o){return new g(this,P,o);};F.prototype.bindList=function(P,o,e,i){return new h(this,P,o,e,i);};F.prototype.bindProperty=function(P,o,e){return new j(this,P,o,e);};F.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree");};F.prototype.fetchCanonicalPath=function(o){return this.fetchUpdateData("",o).then(function(R){if(R.propertyPath){throw new Error("Context "+o.getPath()+" does not point to an entity. It should be "+R.entityPath);}return"/"+R.editUrl;});};F.prototype.fetchEntityContainer=function(P){var e,i=this;if(!this.oMetadataPromise){e=[S.resolve(this.oRequestor.read(this.sUrl,false,P))];if(this.aAnnotationUris){this.aAnnotationUris.forEach(function(n){e.push(S.resolve(i.oRequestor.read(n,true,P)));});}if(!P){this.oMetadataPromise=S.all(e).then(function(n){var o=n[0];i._mergeAnnotations(o,n.slice(1));return o;});}}return this.oMetadataPromise;};F.prototype.fetchModule=function(e){var i;e=e.replace(/\./g,"/");i=sap.ui.require(e);if(i){return S.resolve(i);}return S.resolve(new Promise(function(n,o){sap.ui.require([e],n);}));};F.prototype.fetchObject=function(P,n,G){var R=this.resolve(P,n),H=this;if(!R){q.sap.log.error("Invalid relative path w/o context",P,s);return S.resolve(null);}return this.fetchEntityContainer().then(function(J){var K,L,N,Q=true,T,X,Y,Z=J;function $(i,P){var o,g1=i.indexOf("@",2);if(g1>-1){return c1(W,"Unsupported path after ",i.slice(0,g1));}i=i.slice(2);o=i[0]==="."?q.sap.getObject(i.slice(1),undefined,G.scope):q.sap.getObject(i);if(typeof o!=="function"){return c1(W,i," is not a function but: "+o);}try{Z=o(Z,{context:new d(H,P),schemaChildName:X});}catch(e){c1(W,"Error calling ",i,": ",e);}return false;}function a1(o){return o.$kind!=="Action"||(!o.$IsBound&&K===k||o.$IsBound&&K===o.$Parameter[0].$Type);}function b1(o){return o&&typeof o.then==="function";}function c1(i){var e;if(q.sap.log.isLoggable(i,s)){e=Array.isArray(L)?L.join("/"):L;q.sap.log[i===D?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(e?" at /"+e:""),R,s);}if(i===W){Z=undefined;}return false;}function d1(e,i){var o;function g1(){L=L||Y&&i&&Y+"/"+i;return c1.apply(this,arguments);}K=Z&&Z.$Type;if(H.bSupportReferences&&!(e in J)){o=E(e);Z=x(H,J,o,g1);}if(e in J){Y=N=X=e;Z=T=J[X];if(!b1(Z)){return true;}}if(b1(Z)&&Z.isPending()){return g1(D,"Waiting for ",o);}return g1(W,"Unknown qualified name ",e);}function e1(e,i,o){var g1,h1;if(e==="$Annotations"){return c1(W,"Invalid segment: $Annotations");}if(Z!==J&&typeof Z==="object"&&e in Z){if(e[0]==="$"||r.test(e)){Q=false;}}else{g1=e.indexOf("@@");if(g1<0){if(e.length>11&&e.slice(-11)==="@sapui.name"){g1=e.length-11;}else{g1=e.indexOf("@");}}if(g1>0){if(!e1(e.slice(0,g1),i,o)){return false;}e=e.slice(g1);h1=true;}if(typeof Z==="string"&&!(h1&&e[0]==="@"&&(e==="@sapui.name"||e[1]==="@"))&&!f1(Z,o.slice(0,i))){return false;}if(Q){if(e[0]==="$"||r.test(e)){Q=false;}else if(!h1){if(e[0]!=="@"&&e.indexOf(".")>0){return d1(e);}else if(Z&&"$Type"in Z){if(!d1(Z.$Type,"$Type")){return false;}}else if(Z&&"$Action"in Z){if(!d1(Z.$Action,"$Action")){return false;}K=k;}else if(Z&&"$Function"in Z){if(!d1(Z.$Function,"$Function")){return false;}}else if(i===0){Y=N=X=X||J.$EntityContainer;Z=T=T||J[X];if(e&&e[0]!=="@"&&!(e in T)){return c1(W,"Unknown child ",e," of ",X);}}if(Array.isArray(Z)){Z=Z.filter(a1);if(e==="@$ui5.overload"){return true;}if(Z.length!==1){return c1(W,"Unsupported overloads");}Z=Z[0].$ReturnType;Y=Y+"/0/$ReturnType";if(Z){if(e==="value"&&!(J[Z.$Type]&&J[Z.$Type].value)){N=undefined;return true;}if(!d1(Z.$Type,"$Type")){return false;}}}}}if(!e){return i+1>=o.length||c1(W,"Invalid empty segment");}if(e[0]==="@"){if(e==="@sapui.name"){Z=N;if(Z===undefined){c1(W,"Unsupported path before @sapui.name");}else if(i+1<o.length){c1(W,"Unsupported path after @sapui.name");}return false;}if(e[1]==="@"){if(i+1<o.length){return c1(W,"Unsupported path after ",e);}return $(e,"/"+o.slice(0,i).join("/")+"/"+o[i].slice(0,g1));}}if(!Z||typeof Z!=="object"){Z=undefined;return c1(D,"Invalid segment: ",e);}if(Q&&e[0]==="@"){Z=(J.$Annotations||{})[Y]||{};Q=false;}}if(e!=="@"){N=Q||e[0]==="@"?e:undefined;Y=Q?Y+"/"+e:undefined;Z=Z[e];}return true;}function f1(e,i){var o;if(L){return c1(W,"Invalid recursion");}L=i;Q=true;Z=J;o=e.split("/").every(e1);L=undefined;return o;}f1(R.slice(1));if(b1(Z)){Z=Z.then(function(){return H.fetchObject(P,n,G);});}return Z;});};F.prototype.fetchUI5Type=function(P){var o=this.getMetaContext(P),e=this;if(q.sap.endsWith(P,"/$count")){f=f||new I();return S.resolve(f);}return this.fetchObject(undefined,o).then(function(i){var n,G,T=i["$ui5.type"],H,J="sap.ui.model.odata.type.Raw";function K(L,N){if(N!==undefined){n=n||{};n[L]=N;}}if(T){return T;}if(i.$isCollection){q.sap.log.warning("Unsupported collection type, using "+J,P,s);}else{H=u[i.$Type];if(H){J=H.type;for(G in H.constraints){K(H.constraints[G],G[0]==="@"?e.getObject(G,o):i[G]);}if(i.$Nullable===false){K("nullable",false);}}else{q.sap.log.warning("Unsupported type '"+i.$Type+"', using "+J,P,s);}}i["$ui5.type"]=e.fetchModule(J).then(function(L){T=new L(undefined,n);i["$ui5.type"]=T;return T;});return i["$ui5.type"];});};F.prototype.fetchUpdateData=function(P,o){var R=this.resolve(P,o),e=this;function n(i){q.sap.log.error(i,R,s);throw new Error(R+": "+i);}return this.fetchObject(this.getMetaPath(R)).then(function(){return e.fetchEntityContainer();}).then(function(G){var H,J=G[G.$EntityContainer],K,L,N,Q,T,X,Y=false,Z;function $(){H.push({path:Q,prefix:H.pop(),type:Z});}function a1(c1){var i=c1.indexOf("(");return i>=0?c1.slice(i):"";}function b1(c1){var i=c1.indexOf("(");return i>=0?c1.slice(0,i):c1;}X=R.slice(1).split("/");H=[X.shift()];Q="/"+H[0];K=Q;N=decodeURIComponent(b1(H[0]));L=J[N];if(!L){n("Not an entity set: "+N);}Z=G[L.$Type];P="";T="";X.forEach(function(i){var c1,d1;Q+="/"+i;if(r.test(i)){$();K+="/"+i;}else{d1=decodeURIComponent(b1(i));T=_.buildPath(T,d1);c1=Z[d1];if(!c1){n("Not a (navigation) property: "+d1);}Z=G[c1.$Type];if(c1.$kind==="NavigationProperty"){if(T in L.$NavigationPropertyBinding){N=L.$NavigationPropertyBinding[T];L=J[N];T="";H=[encodeURIComponent(N)+a1(i)];if(!c1.$isCollection){$();}}else{H.push(i);}K=Q;P="";}else{P=_.buildPath(P,i);}}});return S.all(H.map(function(i){if(typeof i==="string"){return i;}return o.fetchValue(i.path).then(function(c1){if(!c1){n("No instance to calculate key predicate at "+i.path);}if("@$ui5.transient"in c1){Y=true;return undefined;}if(!c1["@$ui5.predicate"]){n("No key predicate known at "+i.path);}return i.prefix+c1["@$ui5.predicate"];},function(c1){n(c1.message+" at "+i.path);});})).then(function(i){return{editUrl:Y?undefined:i.join("/"),entityPath:K,propertyPath:P};});});};F.prototype.fetchValueListMappings=function(o,n,P){var e=this,i=o.getMetaModel();return i.fetchEntityContainer().then(function(G){var H,J=G.$Annotations,K={},L=e===i,T;T=Object.keys(J).filter(function(N){if(_.namespace(N)===n){if(e.getObject("/"+N)===P){return true;}if(!L){throw new Error("Unexpected annotation target '"+N+"' with namespace of data service in "+o.sServiceUrl);}}return false;});if(!T.length){throw new Error("No annotation '"+v.slice(1)+"' in "+o.sServiceUrl);}H=J[T[0]];Object.keys(H).forEach(function(N){var Q=y(N,v);if(Q!==undefined){K[Q]=H[N];}else if(!L){throw new Error("Unexpected annotation '"+N.slice(1)+"' for target '"+T[0]+"' with namespace of data service in "+o.sServiceUrl);}});return K;});};F.prototype.fetchValueListType=function(P){var o=this.getMetaContext(P),e=this;return this.fetchObject(undefined,o).then(function(i){var n,T;if(!i){throw new Error("No metadata for "+P);}n=e.getObject("@",o);if(n[t]){return V.Fixed;}for(T in n){if(y(T,p)!==undefined||y(T,v)!==undefined){return V.Standard;}}return V.None;});};F.prototype.getETags=function(){return this.mETags;};F.prototype.getLastModified=function(){return this.dLastModified;};F.prototype.getMetaContext=function(P){return new d(this,this.getMetaPath(P));};F.prototype.getMetaPath=function(P){return _.getMetaPath(P);};F.prototype.getOrCreateValueListModel=function(e){var i=new U(this.sUrl).absoluteTo(document.baseURI).pathname().toString(),o,n;n=new U(e).absoluteTo(i).filename("").toString();o=l[n];if(!o){o=new this.oModel.constructor({operationMode:O.Server,serviceUrl:n,synchronizationMode:"None"});o.setDefaultBindingMode(B.OneWay);l[n]=o;o.oRequestor.mHeaders["X-CSRF-Token"]=this.oModel.oRequestor.mHeaders["X-CSRF-Token"];}return o;};F.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty");};F.prototype.getObject=_.createGetMethod("fetchObject");F.prototype.getProperty=F.prototype.getObject;F.prototype.getUI5Type=_.createGetMethod("fetchUI5Type",true);F.prototype.getValueListType=_.createGetMethod("fetchValueListType",true);F.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList");};F.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh");};F.prototype.requestObject=_.createRequestMethod("fetchObject");F.prototype.requestUI5Type=_.createRequestMethod("fetchUI5Type");F.prototype.requestValueListType=_.createRequestMethod("fetchValueListType");F.prototype.requestValueListInfo=function(P){var e=this.getMetaPath(P),T=e.slice(0,e.lastIndexOf("/")+1),i=this;return Promise.all([this.requestObject(T+"@sapui.name"),this.requestObject(e),this.requestObject(e+"@"),this.requestObject(e+t)]).then(function(R){var n=R[2],o=R[3],G={},N=_.namespace(R[0]),H=R[1],J={};function K(L,Q,X,Y){if(G[Q]){throw new Error("Annotations '"+v.slice(1)+"' with identical qualifier '"+Q+"' for property "+P+" in "+G[Q]+" and "+X);}if(o&&J[""]){throw new Error("Annotation '"+t.slice(1)+"' but multiple '"+v.slice(1)+"' for property "+P);}G[Q]=X;J[o?"":Q]=q.extend(true,{$model:Y},L);}if(!H){throw new Error("No metadata for "+P);}Object.keys(n).filter(function(L){return y(L,v)!==undefined;}).forEach(function(L){K(n[L],y(L,v),i.sUrl,i.oModel);});return Promise.all(Object.keys(n).filter(function(L){return y(L,p)!==undefined;}).map(function(L){var Q=n[L];return Promise.all(Q.map(function(X){var Y=i.getOrCreateValueListModel(X);return i.fetchValueListMappings(Y,N,H).then(function(Z){Object.keys(Z).forEach(function($){K(Z[$],$,X,Y);});});}));})).then(function(){if(!Object.keys(J).length){throw new Error("No annotation '"+p.slice(1)+"' for "+P);}return J;});});};F.prototype.resolve=function(P,o){var e,i;if(!P){return o?o.getPath():undefined;}i=P[0];if(i==="/"){return P;}if(!o){return undefined;}if(i==="."){if(P[1]!=="/"){throw new Error("Unsupported relative path: "+P);}P=P.slice(2);}e=o.getPath();return i==="@"||e.slice(-1)==="/"?e+P:e+"/"+P;};F.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax");};F.prototype.toString=function(){return s+": "+this.sUrl;};F.prototype.validate=function(e,n){var i,o,L,G,R,H;if(!this.bSupportReferences){return n;}for(H in n.$Reference){R=n.$Reference[H];H=new U(H).absoluteTo(this.sUrl).toString();if("$IncludeAnnotations"in R){z("Unsupported IncludeAnnotations",e);}for(i in R.$Include){G=R.$Include[i];if(G in n){z("A schema cannot span more than one document: "+G+" - is both included and defined",e);}w(this,G,H,e);}}L=n.$LastModified?new Date(n.$LastModified):null;this.mETags[e]=n.$ETag?n.$ETag:L;o=n.$Date?new Date(n.$Date):new Date();L=L||o;if(this.dLastModified<L){this.dLastModified=L;}delete n.$Date;delete n.$ETag;delete n.$LastModified;return n;};return F;});
