/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/SyncPromise","./_Batch","./_Helper","./_V2Requestor"],function(q,S,_,a,b){"use strict";var B={"Accept":"multipart/mixed"},c;function d(r,G){var e=r.mBatchQueue[G];if(e[0].length===0&&e.length===1){delete r.mBatchQueue[G];}}function g(h){var r;h=h.toLowerCase();for(r in this.headers){if(r.toLowerCase()===h){return this.headers[r];}}}function R(s,h,Q,m){this.mBatchQueue={};this.mHeaders=h||{};this.oModelInterface=m;this.sQueryParams=a.buildQuery(Q);this.mRunningChangeRequests={};this.oSecurityTokenPromise=null;this.sServiceUrl=s;}R.prototype.mFinalHeaders={"Content-Type":"application/json;charset=UTF-8;IEEE754Compatible=true"};R.prototype.mPredefinedPartHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true"};R.prototype.mPredefinedRequestHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true","OData-MaxVersion":"4.0","OData-Version":"4.0","X-CSRF-Token":"Fetch"};R.prototype.batchRequestSent=function(G,h){if(h){if(G in this.mRunningChangeRequests){this.mRunningChangeRequests[G]+=1;}else{this.mRunningChangeRequests[G]=1;}}};R.prototype.batchResponseReceived=function(G,h){if(h){this.mRunningChangeRequests[G]-=1;if(this.mRunningChangeRequests[G]===0){delete this.mRunningChangeRequests[G];}}};R.prototype.buildQueryString=function(m,Q,D,s){return a.buildQuery(this.convertQueryOptions(m,Q,D,s));};R.prototype.cancelChanges=function(G){if(this.mRunningChangeRequests[G]){throw new Error("Cannot cancel the changes for group '"+G+"', the batch request is running");}this.cancelChangesByFilter(function(){return true;},G);};R.prototype.cancelChangesByFilter=function(f,G){var C=false,t=this;function e(s){var h=t.mBatchQueue[s],o,j,E,i;j=h[0];for(i=j.length-1;i>=0;i--){o=j[i];if(o.$cancel&&f(o)){o.$cancel();E=new Error("Request canceled: "+o.method+" "+o.url+"; group: "+s);E.canceled=true;o.$reject(E);j.splice(i,1);C=true;}}d(t,s);}if(G){if(this.mBatchQueue[G]){e(G);}}else{for(G in this.mBatchQueue){e(G);}}return C;};R.prototype.convertExpand=function(e,s){var k,r=[],t=this;if(!e||typeof e!=="object"){throw new Error("$expand must be a valid object");}k=Object.keys(e);if(s){k=k.sort();}k.forEach(function(E){var v=e[E];if(v&&typeof v==="object"){r.push(t.convertExpandOptions(E,v,s));}else{r.push(E);}});return r.join(",");};R.prototype.convertExpandOptions=function(e,E,s){var f=[];this.doConvertSystemQueryOptions(undefined,E,function(o,O){f.push(o+'='+O);},undefined,s);return f.length?e+"("+f.join(";")+")":e;};R.prototype.convertQueryOptions=function(m,Q,D,s){var C={};if(!Q){return undefined;}this.doConvertSystemQueryOptions(m,Q,function(k,v){C[k]=v;},D,s);return C;};R.prototype.convertResourcePath=function(r){return r;};R.prototype.doCheckVersionHeader=function(G,r,v){var o=G("OData-Version"),D=!o&&G("DataServiceVersion");if(D){throw new Error("Expected 'OData-Version' header with value '4.0' but received"+" 'DataServiceVersion' header with value '"+D+"' in response for "+this.sServiceUrl+r);}if(o==="4.0"||!o&&v){return;}throw new Error("Expected 'OData-Version' header with value '4.0' but received value '"+o+"' in response for "+this.sServiceUrl+r);};R.prototype.doConvertSystemQueryOptions=function(m,Q,r,D,s){var t=this;Object.keys(Q).forEach(function(k){var v=Q[k];if(D&&k[0]==='$'){return;}switch(k){case"$expand":v=t.convertExpand(v,s);break;case"$select":if(Array.isArray(v)){v=s?v.sort().join(","):v.join(",");}break;default:}r(k,v);});};R.prototype.doConvertResponse=function(r,m){return r;};R.prototype.fetchTypeForPath=function(m,A){return this.oModelInterface.fnFetchMetadata(m+(A?"/$Type":"/"));};R.prototype.formatPropertyAsLiteral=function(v,p){return a.formatLiteral(v,p.$Type);};R.prototype.getGroupSubmitMode=function(G){return this.oModelInterface.fnGetGroupProperty(G,"submit");};R.prototype.getPathAndAddQueryOptions=function(p,o,P){var A=[],n,N={},e,t=this;p=p.slice(1,-5);if(o.$Parameter){o.$Parameter.forEach(function(e){N[e.$Name]=e;});}if(o.$kind==="Function"){for(n in P){e=N[n];if(e){if(e.$IsCollection){throw new Error("Unsupported collection-valued parameter: "+n);}A.push(encodeURIComponent(n)+"="+encodeURIComponent(t.formatPropertyAsLiteral(P[n],e)));}}p+="("+A.join(",")+")";}else{for(n in P){if(!(n in N)){delete P[n];}}}return p;};R.prototype.getServiceUrl=function(){return this.sServiceUrl;};R.prototype.hasPendingChanges=function(){var G,p;for(G in this.mBatchQueue){p=this.mBatchQueue[G][0].some(function(r){return r.$cancel;});if(p){return true;}}return Object.keys(this.mRunningChangeRequests).length>0;};R.prototype.isActionBodyOptional=function(){return false;};R.prototype.isChangeSetOptional=function(){return true;};R.prototype.ready=function(){return S.resolve();};R.prototype.refreshSecurityToken=function(o){var t=this;if(!this.oSecurityTokenPromise){if(o!==this.mHeaders["X-CSRF-Token"]){return Promise.resolve();}this.oSecurityTokenPromise=new Promise(function(r,f){q.ajax(t.sServiceUrl+t.sQueryParams,{method:"HEAD",headers:{"X-CSRF-Token":"Fetch"}}).then(function(D,T,j){t.mHeaders["X-CSRF-Token"]=j.getResponseHeader("X-CSRF-Token");t.oSecurityTokenPromise=null;r();},function(j,T,e){t.oSecurityTokenPromise=null;f(a.createError(j));});});}return this.oSecurityTokenPromise;};R.prototype.removePatch=function(p){var C=this.cancelChangesByFilter(function(o){return o.$promise===p;});if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.removePost=function(G,o){var C=this.cancelChangesByFilter(function(e){return e.body===o;},G);if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.request=function(m,r,G,h,p,s,C,M,i){var o,I=r==="$batch",P,e,f,t=this;function j(){return new Promise(function(k,l){var n=t.mHeaders["X-CSRF-Token"];q.ajax(t.sServiceUrl+t.convertResourcePath(r)+(I?t.sQueryParams:""),{data:P,headers:q.extend({},t.mPredefinedRequestHeaders,t.mHeaders,h,I?o.headers:t.mFinalHeaders),method:m}).then(function(p,T,u){try{t.doCheckVersionHeader(u.getResponseHeader,r,!p);}catch(E){l(E);return;}t.mHeaders["X-CSRF-Token"]=u.getResponseHeader("X-CSRF-Token")||t.mHeaders["X-CSRF-Token"];if(I){k(_.deserializeBatchResponse(u.getResponseHeader("Content-Type"),p));}else{try{k(t.doConvertResponse(p,M));}catch(E){l(E);}}},function(u,T,E){var v=u.getResponseHeader("X-CSRF-Token");if(!i&&u.status===403&&v&&v.toLowerCase()==="required"){t.refreshSecurityToken(n).then(function(){k(t.request(m,r,G,h,p,undefined,undefined,M,true));},l);}else{l(a.createError(u));}});});}if(G==="$cached"){throw new Error("Unexpected request: "+m+" "+r);}G=G||"$direct";if(I){o=_.serializeBatchRequest(c.cleanBatch(p));P=o.body;}else{if(this.getGroupSubmitMode(G)!=="Direct"){e=new Promise(function(k,l){var n=t.mBatchQueue[G];if(!n){n=t.mBatchQueue[G]=[[]];if(t.oModelInterface.fnOnCreateGroup){t.oModelInterface.fnOnCreateGroup(G);}}f={method:m,url:t.convertResourcePath(r),headers:q.extend({},t.mPredefinedPartHeaders,t.mHeaders,h,t.mFinalHeaders),body:p,$cancel:C,$metaPath:M,$reject:l,$resolve:k,$submit:s};if(m==="GET"){n.push(f);}else{n[0].push(f);}});f.$promise=e;return e;}P=JSON.stringify(c.cleanPayload(p));if(s){s();}}if(this.oSecurityTokenPromise&&m!=="GET"){return this.oSecurityTokenPromise.then(j);}return j();};R.prototype.relocate=function(C,o,n){var r=this.mBatchQueue[C],t=this,f=r&&r[0].some(function(e,i){if(e.body===o){t.request(e.method,e.url,n,e.headers,o,e.$submit,e.$cancel).then(e.$resolve,e.$reject);r[0].splice(i,1);d(t,C);return true;}});if(!f){throw new Error("Request not found in group '"+C+"'");}};R.prototype.submitBatch=function(G){var C=[],h,p,r=this.mBatchQueue[G],t=this;function m(p,f){var i,P,s;if(p&&p.method==="PATCH"&&f.method==="PATCH"&&p.url===f.url&&q.sap.equal(p.headers,f.headers)){P=p.body;i=f.body;for(s in P){if(P[s]===null&&i[s]&&typeof i[s]==="object"){return undefined;}}return q.extend(true,P,i);}return undefined;}function v(r,f){var i;r.forEach(function(j,k){var E,l,n=f[k];if(Array.isArray(n)){v(j,n);}else if(!n){E=new Error("HTTP request was not processed because the previous request failed");E.cause=i;j.$reject(E);}else if(n.status>=400){n.getResponseHeader=g;i=a.createError(n);e(i,j);}else if(n.responseText){l=JSON.parse(n.responseText);try{t.doCheckVersionHeader(g.bind(n),j.url,true);j.$resolve(t.doConvertResponse(l,j.$metaPath));}catch(s){j.$reject(s);}}else{j.$resolve();}});}function o(f){if(Array.isArray(f)){f.forEach(o);}else if(f.$submit){f.$submit();}}function e(E,f){if(Array.isArray(f)){f.forEach(e.bind(null,E));}else{f.$reject(E);}}if(!r){return Promise.resolve();}delete this.mBatchQueue[G];o(r);r[0].forEach(function(f){var M=m(p,f);if(M){p.body=M;f.$resolve(p.$promise);}else{C.push(f);p=f;}});if(C.length===0){r.splice(0,1);}else if(C.length===1&&this.isChangeSetOptional()){r[0]=C[0];}else{r[0]=C;}h=C.length>0;this.batchRequestSent(G,h);return this.request("POST","$batch",undefined,B,r).then(function(f){t.batchResponseReceived(G,h);v(r,f);}).catch(function(E){var f=new Error("HTTP request was not processed because $batch failed");function i(r){r.forEach(function(j){if(Array.isArray(j)){i(j);}else{j.$reject(f);}});}t.batchResponseReceived(G,h);f.cause=E;i(r);throw E;});};c={cleanBatch:function(r){r.forEach(function(o){if(Array.isArray(o)){c.cleanBatch(o);}else{o.body=c.cleanPayload(o.body);}});return r;},cleanPayload:function(p){var r=p;if(r){Object.keys(r).forEach(function(k){if(k.indexOf("@$ui5.")===0){if(r===p){r=q.extend({},p);}delete r[k];}});}return r;},create:function(s,m,h,Q,o){var r=new R(s,h,Q,m);if(o==="2.0"){b(r);}return r;}};return c;},false);
