/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/unified/calendar/CalendarUtils','./calendar/Header','./calendar/Month','./calendar/MonthPicker','./calendar/YearPicker','./calendar/CalendarDate','./library','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/ResizeHandler','sap/ui/core/Locale',"./CalendarRenderer"],function(q,C,L,a,H,M,b,Y,c,l,D,d,R,e,f){"use strict";var g=C.extend("sap.ui.unified.Calendar",{metadata:{library:"sap.ui.unified",designtime:"sap/ui/unified/designtime/Calendar.designtime",properties:{intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},months:{type:"int",group:"Appearance",defaultValue:1},firstDayOfWeek:{type:"int",group:"Appearance",defaultValue:-1},nonWorkingDays:{type:"int[]",group:"Appearance",defaultValue:null},primaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},secondaryCalendarType:{type:"sap.ui.core.CalendarType",group:"Appearance",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},minDate:{type:"object",group:"Misc",defaultValue:null},maxDate:{type:"object",group:"Misc",defaultValue:null},showWeekNumbers:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},disabledDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"disabledDate"},header:{type:"sap.ui.unified.calendar.Header",multiple:false,visibility:"hidden"},month:{type:"sap.ui.unified.calendar.Month",multiple:true,visibility:"hidden"},monthPicker:{type:"sap.ui.unified.calendar.MonthPicker",multiple:false,visibility:"hidden"},yearPicker:{type:"sap.ui.unified.calendar.YearPicker",multiple:false,visibility:"hidden"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},cancel:{},startDateChange:{}}}});g.prototype.init=function(){this._iBreakPointTablet=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0];this._iBreakPointDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1];this._iBreakPointLargeDesktop=D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2];var i=sap.ui.getCore().getConfiguration().getCalendarType();this.setProperty("primaryCalendarType",i);this.setProperty("secondaryCalendarType",i);this._iMode=0;this._oYearFormat=d.getDateInstance({format:"y",calendarType:i});this.data("sap-ui-fastnavgroup","true",true);this._oMinDate=a._minDate(this.getPrimaryCalendarType());this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());this._initializeHeader();var t=this._createMonth(this.getId()+"--Month0");t.attachEvent("focus",this._handleFocus,this);t.attachEvent("select",n,this);t.attachEvent("_renderMonth",m,this);t.attachEvent("_bindMousemove",o,this);t.attachEvent("_unbindMousemove",p,this);t._bNoThemeChange=true;this.addAggregation("month",t);this._initilizeMonthPicker();this._initilizeYearPicker();this._resizeProxy=q.proxy(r,this);this._oSelectedMonth;};g.prototype.exit=function(){if(this._sInvalidateMonth){q.sap.clearDelayedCall(this._sInvalidateMonth);}if(this._sResizeListener){R.deregister(this._sResizeListener);this._sResizeListener=undefined;}this._oSelectedMonth=null;};g.prototype._initializeHeader=function(){var i=new H(this.getId()+"--Head");i.attachEvent("pressPrevious",this._handlePrevious,this);i.attachEvent("pressNext",this._handleNext,this);i.attachEvent("pressButton1",this._handleButton1,this);i.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",i);};g.prototype._initilizeMonthPicker=function(){var i=new b(this.getId()+"--MP");i.attachEvent("select",this._selectMonth,this);i._bNoThemeChange=true;this.setAggregation("monthPicker",i);};g.prototype._initilizeYearPicker=function(){var y=new Y(this.getId()+"--YP");y.attachEvent("select",this._selectYear,this);this.setAggregation("yearPicker",y);};g.prototype._createMonth=function(i){var t=new M(i,{width:"100%"});t.attachEvent("datehovered",this._handleDateHovered,this);return t;};g.prototype._handleDateHovered=function(E){var t=this.getAggregation("month"),u=E.getParameter("date1"),v=E.getParameter("date2"),i;for(i=0;i<t.length;i++){t[i]._markDatesBetweenStartAndHoveredDate(u,v);}};g.prototype.onBeforeRendering=function(){var t=this.getAggregation("month");var u;var v=t[0].getDate();var F=this._getFocusedDate();if(t.length>1&&v){u=c.fromLocalJSDate(v,this.getPrimaryCalendarType());}else if(t.length>1){u=s.call(this,this._getFocusedDate());}else{u=F;}for(var i=0;i<t.length;i++){v=new c(u);if(i>0){v.setDate(1);v.setMonth(v.getMonth()+i);}var w=v;if(F.getYear()===v.getYear()&&F.getMonth()===v.getMonth()){w=F;}t[i].displayDate(w.toLocalJSDate());t[i].setShowWeekNumbers(this.getShowWeekNumbers());}this._updateHeader(u);this._iSize=0;};g.prototype.onAfterRendering=function(E){if(!this._getSucessorsPickerPopup()){h.call(this);}if(k.call(this)>1||this._bInitMonth){E.size={width:this.getDomRef().offsetWidth};r.call(this,E,true);if(!this._sResizeListener){this._sResizeListener=R.register(this,this._resizeProxy);}this._bInitMonth=undefined;}};g.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&this._iMode==0&&!this._sInvalidateMonth){this._sInvalidateMonth=q.sap.delayedCall(0,this,this._invalidateMonth,[O]);}};g.prototype.removeSelectedDate=function(S){this._bDateRangeChanged=true;return this.removeAggregation("selectedDates",S);};g.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("selectedDates");return i;};g.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};g.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("specialDates");return i;};g.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};g.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};g.prototype.removeAllDisabledDates=function(){this._bDateRangeChanged=true;var i=this.removeAllAggregation("disabledDates");return i;};g.prototype.destroyDisabledDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("disabledDates");return i;};g.prototype.setLocale=function(i){if(this._sLocale!=i){this._sLocale=i;this._oLocaleData=undefined;this.invalidate();}return this;};g.prototype.getLocale=function(){if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};g.prototype._getFocusedDate=function(){if(!this._oFocusedDate){_.call(this);}return this._oFocusedDate;};g.prototype._setFocusedDate=function(i){a._checkCalendarDate(i);this._oFocusedDate=new c(i,this.getPrimaryCalendarType());};g.prototype.focusDate=function(i){j.call(this,i,false);return this;};g.prototype.displayDate=function(i){j.call(this,i,true);return this;};g.prototype.getStartDate=function(){var S;if(this.getDomRef()){var i=this.getAggregation("month");S=c.fromLocalJSDate(i[0].getDate(),this.getPrimaryCalendarType());}else{S=new c(this._getFocusedDate());}S.setDate(1);return S.toLocalJSDate();};g.prototype.setPopupMode=function(P){this._bPoupupMode=P;return this;};g.prototype.setMonths=function(t){this._bDateRangeChanged=undefined;this.setProperty("months",t,false);t=k.call(this);var u=this.getAggregation("month");var i=0;var v;if(u.length<t){for(i=u.length;i<t;i++){v=this._createMonth(this.getId()+"--Month"+i);v.attachEvent("focus",this._handleFocus,this);v.attachEvent("select",n,this);v.attachEvent("_renderMonth",m,this);v.attachEvent("_bindMousemove",o,this);v.attachEvent("_unbindMousemove",p,this);v._bNoThemeChange=true;this.addAggregation("month",v);}}else if(u.length>t){for(i=u.length;i>t;i--){v=this.removeAggregation("month",i-1);v.destroy();}if(t==1){this._bInitMonth=true;}}if(t>1&&u[0].getDate()){u[0].setProperty("date",null,true);}return this;};g.prototype.setPrimaryCalendarType=function(t){var u=this.getAggregation("month");var v=false;if(u.length>1){v=true;}this.setProperty("primaryCalendarType",t,!v);this._oYearFormat=d.getDateInstance({format:"y",calendarType:t});if(this._oFocusedDate){this._oFocusedDate=new c(this._oFocusedDate,t);}this._oMinDate=new c(this._oMinDate,t);this._oMaxDate=new c(this._oMaxDate,t);for(var i=0;i<u.length;i++){var w=u[i];w.setPrimaryCalendarType(t);}if(!this._getSucessorsPickerPopup()){var x=this.getAggregation("monthPicker");x.setPrimaryCalendarType(t);var y=this.getAggregation("yearPicker");y.setPrimaryCalendarType(t);}if(this.getDomRef()){this._updateHeader(this._oFocusedDate);if(!this._getSucessorsPickerPopup()){if(this.iMode!=1&&x.getDomRef()){x.$().remove();}if(this.iMode!=2&&y.getDomRef()){y.$().remove();}}}return this;};g.prototype.setSecondaryCalendarType=function(t){this._bSecondaryCalendarTypeSet=true;this.setProperty("secondaryCalendarType",t,true);this._oYearFormatSecondary=d.getDateInstance({format:"y",calendarType:t});var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];v.setSecondaryCalendarType(t);}if(this.getDomRef()){this._updateHeader(this._getFocusedDate());this.$().toggleClass("sapUiCalSecType",!!this._getSecondaryCalendarType());}return this;};g.prototype._getSecondaryCalendarType=function(){var S;if(this._bSecondaryCalendarTypeSet){S=this.getSecondaryCalendarType();var P=this.getPrimaryCalendarType();if(S==P){S=undefined;}}return S;};g.prototype.setMinDate=function(i){if(q.sap.equal(i,this.getMinDate())){return this;}if(!i){this._oMinDate=a._minDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMinDate.getYear();a._checkYearInValidRange(y);if(this._oMaxDate.isBefore(this._oMinDate)){q.sap.log.warning("minDate > maxDate -> maxDate set to end of the month",this);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMaxDate.setDate(a._daysInMonth(this._oMaxDate));this.setProperty("maxDate",this._oMaxDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("minDate",i,false);if(!this._getSucessorsPickerPopup()){var t=this.getAggregation("yearPicker");t._oMinDate.setYear(this._oMinDate.getYear());}return this;};g.prototype.setMaxDate=function(i){if(q.sap.equal(i,this.getMaxDate())){return this;}if(!i){this._oMaxDate=a._maxDate(this.getPrimaryCalendarType());}else{a._checkJSDateObject(i);this._oMaxDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=this._oMaxDate.getYear();a._checkYearInValidRange(y);if(this._oMinDate.isAfter(this._oMaxDate)){q.sap.log.warning("maxDate < minDate -> minDate set to begin of the month",this);this._oMinDate=c.fromLocalJSDate(i,this.getPrimaryCalendarType());this._oMinDate.setDate(1);this.setProperty("minDate",this._oMinDate.toLocalJSDate(),true);}this._setMinMaxDateExtend(c.fromLocalJSDate(i,this.getPrimaryCalendarType()));}this.setProperty("maxDate",i,false);if(!this._getSucessorsPickerPopup()){var t=this.getAggregation("yearPicker");t._oMaxDate.setYear(this._oMaxDate.getYear());}return this;};g.prototype._setMinMaxDateExtend=function(i){if(this._oFocusedDate){if(a._isOutside(this._oFocusedDate,this._oMinDate,this._oMaxDate)){q.sap.log.warning("focused date is not between [minDate - maxDate] -> refocus to the new max/min date: "+i.toString(),this);this.focusDate(i.toLocalJSDate());}}};g.prototype._getLocaleData=function(){if(!this._oLocaleData){var i=this.getLocale();var t=new e(i);this._oLocaleData=L.getInstance(t);}return this._oLocaleData;};g.prototype._getShowMonthHeader=function(){var i=k.call(this);if(i>2){return true;}else{return false;}};g.prototype.setWidth=function(w){this.setProperty("width",w,true);if(this.getDomRef()){w=this.getWidth();this.$().css("width",w);if(w){this.$().addClass("sapUiCalWidth");}else{this.$().removeClass("sapUiCalWidth");}}return this;};g.prototype.onclick=function(E){if(E.isMarked("delayedMouseEvent")){return;}if(E.target.id==this.getId()+"-cancel"){this.onsapescape(E);}};g.prototype.onmousedown=function(E){E.preventDefault();E.setMark("cancelAutoClose");};g.prototype.onsapescape=function(E){if(this._iMode==0){this.fireCancel();}this._closedPickers();};g.prototype.onsapshow=function(E){if(this._bPoupupMode){this._closedPickers();this.fireCancel();E.preventDefault();}};g.prototype.onsaphide=g.prototype.onsapshow;g.prototype.onsaptabnext=function(E){var t=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabNext(E)){q.sap.focus(t.getDomRef("B2"));}else{q.sap.focus(t.getDomRef("B1"));}if(!this._bPoupupMode){var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var w=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");if(w.getDomRef()){q(w._oItemNavigation.getItemDomRefs()[w._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(y.getDomRef()){q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}E.preventDefault();}else if(this._shouldFocusB2OnTabNext(E)){q.sap.focus(t.getDomRef("B2"));E.preventDefault();}};g.prototype._shouldFocusB2OnTabNext=function(E){var i=this.getAggregation("header");return(E.target.id==i.getId()+"-B1");};g.prototype._shouldFocusB2OnTabPrevious=function(E){return this._bPoupupMode;};g.prototype.onsaptabprevious=function(E){var t=this.getAggregation("header");if(q.sap.containsOrEquals(this.getDomRef("content"),E.target)){if(this._shouldFocusB2OnTabPrevious()){q.sap.focus(t.getDomRef("B2"));E.preventDefault();}}else if(E.target.id==t.getId()+"-B1"){var u=this.getAggregation("month");var F;switch(this._iMode){case 0:F=this._getFocusedDate();for(var i=0;i<u.length;i++){var v=u[i];var w=c.fromLocalJSDate(v.getDate(),this.getPrimaryCalendarType());if(F.isSame(w)){v._oItemNavigation.focusItem(v._oItemNavigation.getFocusedIndex());}else{q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}break;case 1:if(!this._getSucessorsPickerPopup()){var x=this.getAggregation("monthPicker");x._oItemNavigation.focusItem(x._oItemNavigation.getFocusedIndex());}break;case 2:if(!this._getSucessorsPickerPopup()){var y=this.getAggregation("yearPicker");y._oItemNavigation.focusItem(y._oItemNavigation.getFocusedIndex());}break;}E.preventDefault();}else if(E.target.id==t.getId()+"-B2"){q.sap.focus(t.getDomRef("B1"));E.preventDefault();}};g.prototype.onfocusin=function(E){if(E.target.id==this.getId()+"-end"){var t=this.getAggregation("month");this._focusOnShiftTab();if(!this._bPoupupMode){for(var i=0;i<t.length;i++){var u=t[i];q(u._oItemNavigation.getItemDomRefs()[u._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(!this._getSucessorsPickerPopup()){var v=this.getAggregation("monthPicker");var y=this.getAggregation("yearPicker");if(v.getDomRef()){q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}if(y.getDomRef()){q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}}this.$("end").attr("tabindex","-1");};g.prototype._focusOnShiftTab=function(){var i=this.getAggregation("header");q.sap.focus(i.getDomRef("B2"));};g.prototype.onsapfocusleave=function(E){var t,u,v,y;if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){this.$("end").attr("tabindex","0");if(!this._bPoupupMode){t=this.getAggregation("month");switch(this._iMode){case 0:for(var i=0;i<t.length;i++){u=t[i];q(u._oItemNavigation.getItemDomRefs()[u._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 1:if(!this._getSucessorsPickerPopup()){v=this.getAggregation("monthPicker");q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;case 2:if(!this._getSucessorsPickerPopup()){y=this.getAggregation("yearPicker");q(y._oItemNavigation.getItemDomRefs()[y._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}break;}}}};g.prototype.getFocusDomRef=function(){var i=this._oSelectedMonth?this._oSelectedMonth:this.getAggregation("month")[0];return i._oItemNavigation.getItemDomRefs()[i._oItemNavigation.getFocusedIndex()];};g.prototype.onThemeChanged=function(){var t;if(!this.getDomRef()){return;}this._bNamesLengthChecked=undefined;if(!this._getSucessorsPickerPopup()){t=this.getAggregation("monthPicker");this._showMonthPicker(true);t._bNoThemeChange=false;t.onThemeChanged(arguments);t._bNoThemeChange=true;this._bLongMonth=t._bLongMonth;this._hideMonthPicker(true);}var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];v._bNoThemeChange=false;v.onThemeChanged(arguments);v._bNoThemeChange=true;}var w;if(u.length>1){w=c.fromLocalJSDate(u[0].getDate(),this.getPrimaryCalendarType());}else{w=this._getFocusedDate();}this._setHeaderText(w);if(!this._getSucessorsPickerPopup()){h.call(this);}};g.prototype._updateHeader=function(i){this._setHeaderText(i);this._togglePrevNext(i,true);};g.prototype._togglePrevNext=function(i,t){var y=this._oMaxDate.getYear();var u=this._oMinDate.getYear();var v=this._oMaxDate.getMonth();var w=this._oMinDate.getMonth();var x=this.getAggregation("header");var z=k.call(this);var A=new c(i,this.getPrimaryCalendarType());if(this._iMode==0&&z>1){A=s.call(this,i);A.setMonth(A.getMonth()+z-1);A.setDate(a._daysInMonth(A));}else{A.setDate(a._daysInMonth(A));}var B=A.getYear();var E=A.getMonth();if(B>y||(B==y&&(!t||E>=v))||(this._iMode==1&&this._getSucessorsPickerPopup())){x.setEnabledNext(false);}else{x.setEnabledNext(true);}if(this._iMode==0&&z>1){A.setMonth(A.getMonth()-z+1);A.setDate(1);}else{A.setDate(1);}B=A.getYear();E=A.getMonth();if(B<u||(B==u&&(!t||E<=w))||(this._iMode==1&&this._getSucessorsPickerPopup())){x.setEnabledPrevious(false);}else{x.setEnabledPrevious(true);}};g.prototype._togglePrevNexYearPicker=function(){var y=this.getAggregation("yearPicker");var i=y.getYears();var t=c.fromLocalJSDate(y.getFirstRenderedDate());t.setYear(t.getYear()+Math.floor(i/2));var u=this.getAggregation("header");var v=new c(this._oMaxDate,this.getPrimaryCalendarType());v.setYear(v.getYear()-Math.ceil(i/2));v.setMonth(11);v.setDate(31);var w=new c(this._oMinDate,this.getPrimaryCalendarType());w.setYear(w.getYear()+Math.floor(i/2)+1);w.setMonth(0);w.setDate(1);u.setEnabledNext(t.isSameOrBefore(v));u.setEnabledPrevious(t.isSameOrAfter(w));};g.prototype._handlePrevious=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var y=this.getAggregation("yearPicker");var t=k.call(this);var u;var v;var S=false;switch(this._iMode){case 0:if(t>1){u=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());u.setDate(1);this._setFocusedDate(u);F=this._getFocusedDate();}else{F.setDate(1);}F.setDate(F.getDate()-1);this._renderMonth(S,true);break;case 1:F.setYear(F.getYear()-1);i.setTextButton2(this._oYearFormat.format(F.toUTCJSDate(),true));i.setAriaLabelButton1(this._oYearFormat.format(F.toUTCJSDate(),true));var w=this._getSecondaryCalendarType();if(w){v=new c(F,w);v.setMonth(0);v.setDate(1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(v.toUTCJSDate(),true));}else{i.setAdditionalTextButton2();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.previousPage();this._togglePrevNexYearPicker();break;}};g.prototype._handleNext=function(E){var F=this._getFocusedDate();var i=this.getAggregation("header");var y=this.getAggregation("yearPicker");var t=k.call(this);var u;var v;switch(this._iMode){case 0:if(t>1){u=c.fromLocalJSDate(this.getAggregation("month")[0].getDate(),this.getPrimaryCalendarType());this._setFocusedDate(u);F=this._getFocusedDate();}F.setDate(1);F.setMonth(F.getMonth()+t);this._renderMonth();break;case 1:F.setYear(F.getYear()+1);i.setTextButton2(this._oYearFormat.format(F.toUTCJSDate(),true));i.setAriaLabelButton1(this._oYearFormat.format(F.toUTCJSDate(),true));var S=this._getSecondaryCalendarType();if(S){v=new c(F,S);v.setMonth(0);v.setDate(1);i.setAdditionalTextButton2(this._oYearFormatSecondary.format(v.toUTCJSDate(),true));}else{i.setAdditionalTextButton2();}this._togglePrevNext(F);this._setDisabledMonths(F.getYear());break;case 2:y.nextPage();this._togglePrevNexYearPicker();break;}};g.prototype._getDisplayedMonths=function(t){var u=[];var v=t.getMonth();var w=k.call(this);if(w>1){for(var i=0;i<w;i++){u.push((v+i)%12);}}else{u.push(v);}return u;};g.prototype._getDisplayedSecondaryMonths=function(P,S){var i=this.getAggregation("month");var F=c.fromLocalJSDate(i[0].getDate(),P);F.setDate(1);F=new c(F,S);var t=F.getMonth();var u=c.fromLocalJSDate(i[i.length-1].getDate(),P);u.setDate(a._daysInMonth(u));u=new c(u,S);var E=u.getMonth();return{start:t,end:E};};g.prototype._closedPickers=function(){switch(this._iMode){case 0:break;case 1:this._hideMonthPicker();break;case 2:this._hideYearPicker();break;}};g.prototype._setDisabledMonths=function(y,i){var t=0;var u=11;if(y==this._oMinDate.getYear()){t=this._oMinDate.getMonth();}if(y==this._oMaxDate.getYear()){u=this._oMaxDate.getMonth();}if(!i){i=this.getAggregation("monthPicker");}i.setMinMax(t,u);};g.prototype._handleFocus=function(E){var i=c.fromLocalJSDate(E.getParameter("date"),this.getPrimaryCalendarType());var O=E.getParameter("otherMonth");var t=E.getParameter("restoreOldDate");if(t){if(!q.sap.equal(this._getFocusedDate(),i)){this._renderMonth(false,false,true);}}else{this._focusDate(i,O);}};g.prototype._getVisibleDays=function(){var i=this.getAggregation("month")[0];return i._getVisibleDays(i._getDate(),false);};g.prototype._renderMonth=function(S,I,N){var t=this._getFocusedDate();var u=this.getAggregation("month");var F=false;var v;var w;var x;var i=0;for(i=0;i<u.length;i++){v=u[i];if(v.checkDateFocusable(t.toLocalJSDate())){F=true;}if(F||u.length==1){if(!S){v.setDate(t.toLocalJSDate());}else{v.displayDate(t.toLocalJSDate());}break;}}if(!F){x=new c(t,this.getPrimaryCalendarType());if(u.length>1){x=s.call(this,x);for(i=0;i<u.length;i++){v=u[i];w=new c(x,this.getPrimaryCalendarType());w.setMonth(x.getMonth()+i);if(!S&&a._isSameMonthAndYear(w,t)){v.setDate(t.toLocalJSDate());}else{v.displayDate(w.toLocalJSDate());}}}this._updateHeader(x);if(!N){this.fireStartDateChange();}}};function _(){var S=this.getSelectedDates();var i=this.getPrimaryCalendarType();if(S&&S[0]&&S[0].getStartDate()){this._oFocusedDate=c.fromLocalJSDate(S[0].getStartDate(),i);}else{this._oFocusedDate=c.fromLocalJSDate(new Date(),i);}if(this._oFocusedDate.isBefore(this._oMinDate)){this._oFocusedDate=new c(this._oMinDate,i);}else if(this._oFocusedDate.isAfter(this._oMaxDate)){this._oFocusedDate=new c(this._oMaxDate,i);}}g.prototype._showMonthPicker=function(S){if(this._iMode==2){this._hideYearPicker(true);}var t=this._getFocusedDate();var u=this.getAggregation("monthPicker");if(u.getDomRef()){u.$().css("display","");}else{var v=sap.ui.getCore().createRenderManager();var $=this.$("content");v.renderControl(u);v.flush($[0],false,true);v.destroy();}this._showOverlay();if(!S){u.setMonth(t.getMonth());this._setDisabledMonths(t.getYear(),u);if(this._iMode==0){var w=this.getAggregation("month");for(var i=0;i<w.length;i++){var x=w[i];q(x._oItemNavigation.getItemDomRefs()[x._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}}this._iMode=1;this._togglePrevNext(t,false);};g.prototype._hideMonthPicker=function(S){this._iMode=0;var t=this.getAggregation("monthPicker");t.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(k.call(this)>1){var u=this.getAggregation("month");for(var i=0;i<u.length;i++){var v=u[i];q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};g.prototype._showYearPicker=function(){if(this._iMode==1){this._hideMonthPicker(true);}var t=this._getFocusedDate();var y=this.getAggregation("yearPicker");if(y.getDomRef()){y.$().css("display","");}else{var u=sap.ui.getCore().createRenderManager();var $=this.$("content");u.renderControl(y);u.flush($[0],false,true);u.destroy();}this._showOverlay();y.setDate(t.toLocalJSDate());var v;if(k.call(this)==1){v=this.getAggregation("month")[0];var w=v.$("days").find(".sapUiCalItem");if(w.length==28){y.$().addClass("sapUiCalYearNoTop");}else{y.$().removeClass("sapUiCalYearNoTop");}}if(this._iMode==0){var x=this.getAggregation("month");for(var i=0;i<x.length;i++){v=x[i];q(v._oItemNavigation.getItemDomRefs()[v._oItemNavigation.getFocusedIndex()]).attr("tabindex","-1");}}this._togglePrevNexYearPicker();this._iMode=2;};g.prototype._hideYearPicker=function(S){this._iMode=0;var y=this.getAggregation("yearPicker");y.$().css("display","none");this._hideOverlay();if(!S){this._renderMonth();if(k.call(this)>1){var t=this.getAggregation("month");for(var i=0;i<t.length;i++){var u=t[i];q(u._oItemNavigation.getItemDomRefs()[u._oItemNavigation.getFocusedIndex()]).attr("tabindex","0");}}}this._togglePrevNext(this._getFocusedDate(),true);};function h(){if(!this._bNamesLengthChecked){this._showMonthPicker(true);this._hideMonthPicker(true);var i=this.getAggregation("monthPicker");this._bLongMonth=i._bLongMonth;this._bNamesLengthChecked=true;if(!this._bLongMonth){var t=this.getAggregation("month");var u;if(t.length>1){u=c.fromLocalJSDate(t[0].getDate(),this.getPrimaryCalendarType());}else{u=this._getFocusedDate();}this._setHeaderText(u);}}else if(k.call(this)>1){this._focusDate(this._getFocusedDate(),true,true);}}g.prototype._focusDate=function(i,O,N){var F;var t=false;var u=false;if(i.isBefore(this._oMinDate)){F=this._oMinDate;t=true;}else if(i.isAfter(this._oMaxDate)){F=this._oMaxDate;t=true;}else{F=i;}if(this._focusDateExtend){u=this._focusDateExtend(i,O,N);}var I=F.isBefore(this._getFocusedDate());this._setFocusedDate(F);if(t||O){this._renderMonth(false,I,N);}if(u){this.fireStartDateChange();}};g.prototype._invalidateMonth=function(O){this._sInvalidateMonth=undefined;var t=this.getAggregation("month");if(t){for(var i=0;i<t.length;i++){var u=t[i];u._bDateRangeChanged=true;u._bInvalidateSync=true;u._bNoFocus=true;u.invalidate(O);u._bInvalidateSync=undefined;}}this._bDateRangeChanged=undefined;};g.prototype._setHeaderText=function(i){var t=this.getAggregation("header");var u=this._getLocaleData();var v=[];var w=[];var x=[];var A;var S=false;var T;var y;var P;var z=this.getPrimaryCalendarType();var B=this._getSecondaryCalendarType();if(this._bLongMonth||!this._bNamesLengthChecked){v=u.getMonthsStandAlone("wide",z);}else{S=true;v=u.getMonthsStandAlone("abbreviated",z);w=u.getMonthsStandAlone("wide",z);}if(B){x=u.getMonthsStandAlone("abbreviated",B);var E=this._getDisplayedSecondaryMonths(z,B);if(E.start==E.end){T=x[E.start];}else{P=u.getIntervalPattern();T=P.replace(/\{0\}/,x[E.start]).replace(/\{1\}/,x[E.end]);}}t.setAdditionalTextButton1(T);var F=this._getDisplayedMonths(i);if(F.length>1&&!this._bShowOneMonth){if(!P){P=u.getIntervalPattern();}T=P.replace(/\{0\}/,v[F[0]]).replace(/\{1\}/,v[F[F.length-1]]);A=w.length?P.replace(/\{0\}/,w[F[0]]).replace(/\{1\}/,w[F[F.length-1]]):T;}else{T=v[F[0]];A=w[F[0]]||T;}t.setTextButton1(T);t.setAriaLabelButton1(A);var G=new c(i,z);G.setDate(1);y=this._oYearFormat.format(G.toUTCJSDate(),true);t.setTextButton2(y);t.setAriaLabelButton2(y);if(B){G=new c(G,B);t.setAdditionalTextButton2(this._oYearFormatSecondary.format(G.toUTCJSDate(),true));}else{t.setAdditionalTextButton2();}return{sMonth:T,sYear:y,sAriaLabel:A,bShort:S};};function j(i,S){if(!i){return;}var t=c.fromLocalJSDate(i,this.getPrimaryCalendarType());var y=t.getYear();a._checkYearInValidRange(y);if(a._isOutside(t,this._oMinDate,this._oMaxDate)){throw new Error("Date must not be in valid range (minDate and maxDate); "+this);}this._setFocusedDate(t);if(this.getDomRef()&&this._iMode==0){this._renderMonth(S,false,true);}}function k(){if(D.system.phone){return 1;}else{return this.getMonths();}}g.prototype._handleButton1=function(E){if(this._iMode!=1){this._showMonthPicker();}else{this._hideMonthPicker();}};g.prototype._handleButton2=function(E){if(this._iMode!=2){this._showYearPicker();}else{this._hideYearPicker();}};function m(E){this.fireEvent("_renderMonth",{days:E.getParameter("days")});}function n(E){if(k.call(this)>1){var t=this.getAggregation("month");for(var i=0;i<t.length;i++){var u=t[i];if(u.getId()!=E.oSource.getId()){u._updateSelection();}}}this._oSelectedMonth=E.oSource;this.fireSelect();}function o(E){if(k.call(this)>1){var t=this.getAggregation("month");for(var i=0;i<t.length;i++){var u=t[i];if(u.getId()!=E.oSource.getId()){u._bindMousemove();}}}}function p(E){if(k.call(this)>1){var t=this.getAggregation("month");for(var i=0;i<t.length;i++){var u=t[i];if(u.getId()!=E.oSource.getId()){u._unbindMousemove();}}}}g.prototype._selectMonth=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType()),i=this.getAggregation("monthPicker"),t=i.getMonth();F.setMonth(t);if(t!=F.getMonth()){F.setDate(0);}this._focusDate(F,true);this._hideMonthPicker();};g.prototype._getSucessorsPickerPopup=function(){return this.getPickerPopup&&this.getPickerPopup();};g.prototype._selectYear=function(){var F=new c(this._getFocusedDate(),this.getPrimaryCalendarType());var y=this.getAggregation("yearPicker");var i=c.fromLocalJSDate(y.getDate(),this.getPrimaryCalendarType());i.setMonth(F.getMonth());i.setDate(F.getDate());F=i;this._focusDate(F,true);this._hideYearPicker();};g.prototype._showOverlay=function(){this.$("contentOver").css("display","");};g.prototype._hideOverlay=function(){this.$("contentOver").css("display","none");};function r(E){var w=E.size.width;if(w<=0){return;}var O=this._iSize;if(w<this._iBreakPointTablet){this._iSize=0;}else if(w<this._iBreakPointDesktop){this._iSize=1;}else if(w<this._iBreakPointLargeDesktop){this._iSize=2;}else{this._iSize=3;}var t=k.call(this);var u;if(O!=this._iSize||this._bInitMonth){switch(this._iSize){case 1:u=2;break;case 2:u=3;break;case 3:u=4;break;default:u=1;break;}if(t<u){u=t;}if(u>2&&t>u){var v=u;var U=0.0;var x=u;while(v>=2){var y=t%v;if(y==0){x=v;break;}else{var N=y/v;if(N>U){U=N;x=v;}}v--;}u=x;}var W;var z=this.getAggregation("month");if(u>1){W=100/u+"%";this.$("content").removeClass("sapUiCalContentSingle");}else{W="100%";this.$("content").addClass("sapUiCalContentSingle");}for(var i=0;i<z.length;i++){var A=z[i];A.setWidth(W);}}}function s(i){var F=new c(i,this.getPrimaryCalendarType());F.setDate(1);var t=k.call(this);if(t<=12){var u=i.getMonth();u=u-u%t;if(12%t>0&&u+t>11){u=12-t;}F.setMonth(u);}return F;}return g;});
