/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/unified/calendar/CalendarUtils','sap/ui/unified/calendar/CalendarDate','./library','sap/ui/unified/CalendarDateInterval','sap/ui/unified/CalendarDateIntervalRenderer','sap/ui/unified/calendar/OneMonthDatesRow','sap/ui/core/Renderer','sap/ui/unified/Calendar','sap/ui/unified/CalendarRenderer',"./CalendarOneMonthIntervalRenderer"],function(q,C,a,l,b,c,O,R,d,e,f){"use strict";var g=b.extend("sap.ui.unified.CalendarOneMonthInterval",{});g.prototype.init=function(){b.prototype.init.apply(this,arguments);this._bShowOneMonth=true;};g.prototype._getCalendarPicker=function(){var o=this.getAggregation("calendarPicker");if(!o){o=new h(this.getId()+"--Cal");o.setPopupMode(true);o.attachEvent("select",function(){var o=this._getCalendarPicker(),i=o._getFocusedDate(),n=C._getFirstDateOfMonth(i);this._setStartDate(n);this._adjustSelectedDate(n,false);this._oFocusDateOneMonth=n;this._closeCalendarPicker(true);this._focusDate(i,false,true);},this);o.attachEvent("cancel",function(E){var o=this._getCalendarPicker(),i=o._getFocusedDate();this._closeCalendarPicker(true);this._oFocusDateOneMonth=i;this._focusDate(i,true);},this);this.setAggregation("calendarPicker",o);}return o;};g.prototype._createMonth=function(i){return new O(i);};g.prototype._handleFocus=function(E){var o=!!E.getParameter("_outsideBorder"),D=E.getParameter("date"),i=a.fromLocalJSDate(D),j=a.fromLocalJSDate(this.getStartDate()),I=!C._isSameMonthAndYear(i,j),k,F,s;if(o||I){if(C._isLastDateInMonth(i)){this._oFocusDateOneMonth=i;}else{this._oFocusDateOneMonth=C._getFirstDateOfMonth(i);}k=i.isBefore(j)?-1:1;F=new a(this._getFocusedDate(),this.getPrimaryCalendarType());s=new a(this._getStartDate(),this.getPrimaryCalendarType());b.prototype._shiftStartFocusDates.call(this,F,s,k);}return b.prototype._handleFocus.apply(this,arguments);};g.prototype._focusDateExtend=function(D,o,n){var i,L;if(!this._oFocusDateOneMonth){return b.prototype._focusDateExtend.apply(this,arguments);}i=this.getAggregation("month")[0];L=this._oFocusDateOneMonth.toLocalJSDate();this._setFocusedDate(this._oFocusDateOneMonth);i._bNoRangeCheck=true;i.setDate(L);i._bNoRangeCheck=false;this._oFocusDateOneMonth=null;return!n;};g.prototype._setDisplayMode=function(m){this.getAggregation("month")[0].setMode(m);};g.prototype._shiftStartFocusDates=function(s,F,D){var S=D,o=this.getAggregation("month")[0];if(S!==0){S=S>0?1:-1;}s.setMonth(s.getMonth()+S);F.setYear(s.getYear());F.setMonth(s.getMonth());F.setDate(s.getDate());this._setFocusedDate(F);this._setStartDate(s,true);o.selectDate(s.toLocalJSDate());};g.prototype._adjustSelectedDate=function(D,u){var m=this.getAggregation("month")[0],s;s=u?C._getFirstDateOfMonth(D):D;if(m.getMode&&m.getMode()<2){this._selectDate(s);}};g.prototype._selectDate=function(D){var m=this.getAggregation("month")[0],L=D.toLocalJSDate();this.removeAllSelectedDates();this.addSelectedDate(new sap.ui.unified.DateRange({startDate:L}));m.selectDate(L);this._bDateRangeChanged=undefined;};g.prototype._dateMatchesVisibleRange=function(D){return C._isSameMonthAndYear(a.fromLocalJSDate(this.getStartDate()),a.fromLocalJSDate(D));};var h=d.extend("CustomMonthPicker",{renderer:R.extend(e)});h.prototype._initializeHeader=function(){var H=new sap.ui.unified.calendar.Header(this.getId()+"--Head",{visibleButton1:false});H.attachEvent("pressPrevious",this._handlePrevious,this);H.attachEvent("pressNext",this._handleNext,this);H.attachEvent("pressButton2",this._handleButton2,this);this.setAggregation("header",H);};h.prototype._shouldFocusB2OnTabNext=function(E){return q.sap.containsOrEquals(this.getDomRef("content"),E.target);};h.prototype.onAfterRendering=function(){this._showMonthPicker();};h.prototype._selectYear=function(){var y=this.getAggregation("yearPicker");var F=this._getFocusedDate();F.setYear(y.getYear());this._focusDate(F,true);this._showMonthPicker();};h.prototype._selectMonth=function(){var m=this.getAggregation("monthPicker");var s=this.getSelectedDates()[0];var F=this._getFocusedDate();F.setMonth(m.getMonth());if(!s){s=new sap.ui.unified.DateRange();}s.setStartDate(F.toLocalJSDate());this.addSelectedDate(s);this.fireSelect();};h.prototype.onsapescape=function(E){this.fireCancel();};return g;});
