/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/LocaleData','sap/ui/core/delegate/ItemNavigation','sap/ui/unified/calendar/CalendarUtils','sap/ui/core/date/UniversalDate','sap/ui/unified/library','sap/ui/core/format/DateFormat','sap/ui/core/library','sap/ui/core/Locale',"./TimesRowRenderer"],function(q,C,L,I,a,U,l,D,c,b,T){"use strict";var d=c.CalendarType;var e=C.extend("sap.ui.unified.calendar.TimesRow",{metadata:{library:"sap.ui.unified",properties:{date:{type:"object",group:"Data"},startDate:{type:"object",group:"Data"},items:{type:"int",group:"Appearance",defaultValue:12},intervalMinutes:{type:"int",group:"Appearance",defaultValue:60},intervalSelection:{type:"boolean",group:"Behavior",defaultValue:false},singleSelection:{type:"boolean",group:"Behavior",defaultValue:true},showHeader:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{selectedDates:{type:"sap.ui.unified.DateRange",multiple:true,singularName:"selectedDate"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"},legend:{type:"sap.ui.unified.CalendarLegend",multiple:false}},events:{select:{},focus:{parameters:{date:{type:"object"},notVisible:{type:"boolean"}}}}}});e.prototype.init=function(){this._oFormatYyyyMMddHHmm=D.getInstance({pattern:"yyyyMMddHHmm",calendarType:d.Gregorian});this._oFormatLong=D.getDateTimeInstance({style:"long/short"});this._oFormatDate=D.getDateInstance({style:"medium"});this._mouseMoveProxy=q.proxy(this._handleMouseMove,this);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.unified");};e.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._sInvalidateTimes){q.sap.clearDelayedCall(this._sInvalidateTimes);}};e.prototype.onAfterRendering=function(){_.call(this);};e.prototype.onsapfocusleave=function(E){if(!E.relatedControlId||!q.sap.containsOrEquals(this.getDomRef(),sap.ui.getCore().byId(E.relatedControlId).getFocusDomRef())){if(this._bMouseMove){w.call(this,true);p.call(this,this._getDate());this._bMoveChange=false;this._bMousedownChange=false;t.call(this);}if(this._bMousedownChange){this._bMousedownChange=false;t.call(this);}}};e.prototype.invalidate=function(O){if(!this._bDateRangeChanged&&(!O||!(O instanceof sap.ui.unified.DateRange))){C.prototype.invalidate.apply(this,arguments);}else if(this.getDomRef()&&!this._sInvalidateTimes){if(this._bInvalidateSync){u.call(this);}else{this._sInvalidateTimes=q.sap.delayedCall(0,this,u);}}};e.prototype.removeAllSelectedDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("selectedDates");return R;};e.prototype.destroySelectedDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("selectedDates");return i;};e.prototype.removeAllSpecialDates=function(){this._bDateRangeChanged=true;var R=this.removeAllAggregation("specialDates");return R;};e.prototype.destroySpecialDates=function(){this._bDateRangeChanged=true;var i=this.destroyAggregation("specialDates");return i;};e.prototype.setIntervalMinutes=function(M){if(M>=720){throw new Error("Only intervals < 720 minutes are allowed; "+this);}if(1440%M>0){throw new Error("A day must be divisible by the interval size; "+this);}this.setProperty("intervalMinutes",M,false);this._oFormatTime=undefined;return this;};e.prototype.setDate=function(i){k.call(this,i,false);return this;};e.prototype._setDate=function(i){var x=a._createLocalDate(i,true);this.setProperty("date",x,true);this._oUTCDate=i;};e.prototype._getDate=function(){if(!this._oUTCDate){this._oUTCDate=a._createUniversalUTCDate(new Date(),undefined,true);}return this._oUTCDate;};e.prototype.setStartDate=function(S){a._checkJSDateObject(S);var y=S.getFullYear();a._checkYearInValidRange(y);var i=a._createUniversalUTCDate(S,undefined,true);this.setProperty("startDate",S,true);this._oUTCStartDate=this._getIntervalStart(i);if(this.getDomRef()){var O=a._createLocalDate(this._getDate(),true);this._bNoRangeCheck=true;this.displayDate(S);this._bNoRangeCheck=false;if(O&&this.checkDateFocusable(O)){this.displayDate(O);}}return this;};e.prototype._getStartDate=function(){if(!this._oUTCStartDate){this._oUTCStartDate=a._createUniversalUTCDate(new Date(),undefined,true);this._oUTCStartDate=this._getIntervalStart(this._oUTCStartDate);}return this._oUTCStartDate;};e.prototype.displayDate=function(i){k.call(this,i,true);return this;};e.prototype._getLocale=function(){var P=this.getParent();if(P&&P.getLocale){return P.getLocale();}else if(!this._sLocale){this._sLocale=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();}return this._sLocale;};e.prototype._getLocaleData=function(){var P=this.getParent();if(P&&P._getLocaleData){return P._getLocaleData();}else if(!this._oLocaleData){var i=this._getLocale();var x=new b(i);this._oLocaleData=L.getInstance(x);}return this._oLocaleData;};e.prototype._getFormatLong=function(){var i=this._getLocale();if(this._oFormatLong.oLocale.toString()!=i){var x=new b(i);this._oFormatLong=D.getInstance({style:"long/short"},x);}return this._oFormatLong;};e.prototype._getFormatTime=function(){var i=this._getLocale();if(!this._oFormatTime||this._oFormatTime.oLocale.toString()!=i){var x=new b(i);var y=this.getIntervalMinutes();var z=this._getLocaleData();var P;this._oFormatTimeAmPm=undefined;if(y%60==0){P=z.getPreferredHourSymbol();if(z.getTimePattern("short").search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},x);}}else{P=z.getTimePattern("short");P=P.replace("HH","H");P=P.replace("hh","h");if(P.search("a")>=0){this._oFormatTimeAmPm=D.getTimeInstance({pattern:"a"},x);P=P.replace("a","").trim();}}this._oFormatTime=D.getTimeInstance({pattern:P},x);}return this._oFormatTime;};e.prototype._getFormatDate=function(){var i=this._getLocale();if(this._oFormatDate.oLocale.toString()!=i){var x=new b(i);this._oFormatDate=D.getDateInstance({style:"medium"},x);}return this._oFormatDate;};e.prototype.getIntervalSelection=function(){var P=this.getParent();if(P&&P.getIntervalSelection){return P.getIntervalSelection();}else{return this.getProperty("intervalSelection");}};e.prototype.getSingleSelection=function(){var P=this.getParent();if(P&&P.getSingleSelection){return P.getSingleSelection();}else{return this.getProperty("singleSelection");}};e.prototype.getSelectedDates=function(){var P=this.getParent();if(P&&P.getSelectedDates){return P.getSelectedDates();}else{return this.getAggregation("selectedDates",[]);}};e.prototype.getSpecialDates=function(){var P=this.getParent();if(P&&P.getSpecialDates){return P.getSpecialDates();}else{return this.getAggregation("specialDates",[]);}};e.prototype._getShowHeader=function(){var P=this.getParent();if(P&&P._getShowItemHeader){return P._getShowItemHeader();}else{return this.getProperty("showHeader");}};e.prototype.getIntervalMinutes=function(){var P=this.getParent();if(P&&P.getIntervalMinutes){return P.getIntervalMinutes();}else{return this.getProperty("intervalMinutes");}};e.prototype.getAriaLabelledBy=function(){var P=this.getParent();if(P&&P.getAriaLabelledBy){return P.getAriaLabelledBy();}else{return this.getAssociation("ariaLabelledBy",[]);}};e.prototype.getLegend=function(){var P=this.getParent();if(P&&P.getLegend){return P.getLegend();}else{return this.getAssociation("ariaLabelledBy",[]);}};e.prototype._checkDateSelected=function(x){if(!(x instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var S=0;var y=this.getSelectedDates();var M=new U(x.getTime());M=this._getIntervalStart(M);var z=M.getTime();for(var i=0;i<y.length;i++){var R=y[i];var A=R.getStartDate();var B=0;if(A){A=a._createUniversalUTCDate(A,undefined,true);A=this._getIntervalStart(A);B=A.getTime();}var E=R.getEndDate();var F=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);F=E.getTime();}if(z==B&&!E){S=1;break;}else if(z==B&&E){S=2;if(E&&z==F){S=5;}break;}else if(E&&z==F){S=3;break;}else if(E&&z>B&&z<F){S=4;break;}if(this.getSingleSelection()){break;}}return S;};e.prototype._getDateType=function(x){if(!(x instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var y;var S=this.getSpecialDates();var M=new U(x.getTime());M=this._getIntervalStart(M);var z=M.getTime();for(var i=0;i<S.length;i++){var R=S[i];var A=R.getStartDate();var B=0;if(A){A=a._createUniversalUTCDate(A,undefined,true);A=this._getIntervalStart(A);B=A.getTime();}var E=R.getEndDate();var F=0;if(E){E=a._createUniversalUTCDate(E,undefined,true);E=this._getIntervalStart(E);E.setUTCMinutes(E.getUTCMinutes()+this.getIntervalMinutes()-1);F=E.getTime();}else if(A.getUTCHours()==0&&A.getUTCMinutes()==0&&A.getUTCSeconds()==0&&A.getUTCMilliseconds()==0){E=new U(A.getTime());E.setUTCDate(E.getUTCDate()+1);F=E.getTime();}if((z==B&&!E)||(z>=B&&z<=F)){y={type:R.getType(),tooltip:R.getTooltip_AsString()};break;}}return y;};e.prototype._checkTimeEnabled=function(i){if(!(i instanceof U)){throw new Error("Date must be a UniversalDate object "+this);}var x=i.getTime();var P=this.getParent();if(P&&P._oMinDate&&P._oMaxDate){if(x<P._oMinDate.getTime()||x>P._oMaxDate.getTime()){return false;}}return true;};e.prototype._handleMouseMove=function(E){if(!this.$().is(":visible")){w.call(this,true);}var $=q(E.target);if($.hasClass("sapUiCalItemText")){$=$.parent();}if($.hasClass("sapUiCalItem")){var O=this._getDate();var F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(F.getTime()!=O.getTime()){this._setDate(F);p.call(this,F,true);this._bMoveChange=true;}}};e.prototype.onmouseup=function(E){if(this._bMouseMove){w.call(this,true);var F=this._getDate();var x=this._oItemNavigation.getItemDomRefs();for(var i=0;i<x.length;i++){var $=q(x[i]);if($.attr("data-sap-time")==this._oFormatYyyyMMddHHmm.format(F.getJSDate(),true)){$.focus();break;}}if(this._bMoveChange){var y=q(E.target);if(y.hasClass("sapUiCalItemText")){y=y.parent();}if(y.hasClass("sapUiCalItem")){F=new U(this._oFormatYyyyMMddHHmm.parse(y.attr("data-sap-time"),true).getTime());}p.call(this,F);this._bMoveChange=false;this._bMousedownChange=false;t.call(this);}}if(this._bMousedownChange){this._bMousedownChange=false;t.call(this);}};e.prototype.onsapselect=function(E){var S=p.call(this,this._getDate());if(S){t.call(this);}E.stopPropagation();E.preventDefault();};e.prototype.onsapselectmodifiers=function(E){this.onsapselect(E);};e.prototype.onsappageupmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i-7);}else{F.setUTCDate(i-1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};e.prototype.onsappagedownmodifiers=function(E){var F=new U(this._getDate().getTime());var i=F.getUTCDate();if(E.metaKey||E.ctrlKey){F.setUTCDate(i+7);}else{F.setUTCDate(i+1);}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});E.preventDefault();};e.prototype.checkDateFocusable=function(i){a._checkJSDateObject(i);if(this._bNoRangeCheck){return false;}var S=this._getStartDate();var E=new U(S.getTime());E.setUTCMinutes(E.getUTCMinutes()+this.getItems()*this.getIntervalMinutes());var x=a._createUniversalUTCDate(i,undefined,true);if(x.getTime()>=S.getTime()&&x.getTime()<E.getTime()){return true;}else{return false;}};e.prototype.applyFocusInfo=function(i){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());return this;};e.prototype._getIntervalStart=function(i){var x=i.getTime();var S=new U(i.getTime());S.setUTCHours(0);S.setUTCMinutes(0);S.setUTCSeconds(0);S.setUTCMilliseconds(0);var M=this.getIntervalMinutes();while(S.getTime()<=x){S.setUTCMinutes(S.getUTCMinutes()+M);}var y=new U(S.getTime());y.setUTCMinutes(y.getUTCMinutes()-M);return y;};function _(){var x=this._getDate();var y=this._oFormatYyyyMMddHHmm.format(x.getJSDate(),true);var z=0;var R=this.$("times").get(0);var A=this.$("times").children(".sapUiCalItem");for(var i=0;i<A.length;i++){var $=q(A[i]);if($.attr("data-sap-time")===y){z=i;break;}}if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.AfterFocus,f,this);this._oItemNavigation.attachEvent(I.Events.FocusAgain,g,this);this._oItemNavigation.attachEvent(I.Events.BorderReached,h,this);this.addDelegate(this._oItemNavigation);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"],saphome:["alt"],sapend:["alt"]});this._oItemNavigation.setCycling(false);this._oItemNavigation.setColumns(1,true);}this._oItemNavigation.setRootDomRef(R);this._oItemNavigation.setItemDomRefs(A);this._oItemNavigation.setFocusedIndex(z);this._oItemNavigation.setPageSize(A.length);}function f(i){var x=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}var O=this._getDate();var F=new U(O.getTime());var y=this._oItemNavigation.getItemDomRefs();var $=q(y[x]);F=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());this._setDate(F);this.fireFocus({date:a._createLocalDate(F,true),notVisible:false});if(E.type=="mousedown"){j.call(this,E,F,x);}}function g(i){var x=i.getParameter("index");var E=i.getParameter("event");if(!E){return;}if(E.type=="mousedown"){var F=this._getDate();j.call(this,E,F,x);}}function h(i){var E=i.getParameter("event");var x=this.getItems();var M=this.getIntervalMinutes();var O=this._getDate();var F=new U(O.getTime());if(E.type){switch(E.type){case"sapnext":case"sapnextmodifiers":F.setUTCMinutes(F.getUTCMinutes()+M);break;case"sapprevious":case"sappreviousmodifiers":F.setUTCMinutes(F.getUTCMinutes()-M);break;case"sappagedown":F.setUTCMinutes(F.getUTCMinutes()+M*x);break;case"sappageup":F.setUTCMinutes(F.getUTCMinutes()-M*x);break;default:break;}this.fireFocus({date:a._createLocalDate(F,true),notVisible:true});}}function j(E,F,i){if(E.button){return;}var S=p.call(this,F);if(S){this._bMousedownChange=true;}if(this._bMouseMove){w.call(this,true);this._bMoveChange=false;}else if(this.getIntervalSelection()&&this.$().is(":visible")){v.call(this,true);}E.preventDefault();E.setMark("cancelAutoClose");}function k(i,N){a._checkJSDateObject(i);var y=i.getFullYear();a._checkYearInValidRange(y);var F=true;if(!q.sap.equal(this.getDate(),i)){var x=a._createUniversalUTCDate(i,undefined,true);x=this._getIntervalStart(x);F=this.checkDateFocusable(i);if(!this._bNoRangeCheck&&!F){throw new Error("Date must be in visible date range; "+this);}this.setProperty("date",i,true);this._oUTCDate=x;}if(this.getDomRef()){if(F){m.call(this,this._oUTCDate,N);}else{n.call(this,N);}}}function m(x,N){var y=this._oFormatYyyyMMddHHmm.format(x.getJSDate(),true);var z=this._oItemNavigation.getItemDomRefs();var $;for(var i=0;i<z.length;i++){$=q(z[i]);if($.attr("data-sap-time")==y){if(document.activeElement!=z[i]){if(N){this._oItemNavigation.setFocusedIndex(i);}else{this._oItemNavigation.focusItem(i);}}break;}}}function n(N){var i=this._getStartDate();var $=this.$("times");if($.length>0){var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderTimes(R,this,i);R.flush($[0]);R.destroy();}o.call(this);_.call(this);if(!N){this._oItemNavigation.focusItem(this._oItemNavigation.getFocusedIndex());}}function o(){var S=this._getStartDate();if(this._getShowHeader()){var $=this.$("Head");if($.length>0){var i=this._getLocaleData();var R=sap.ui.getCore().createRenderManager();this.getRenderer().renderHeaderLine(R,this,i,S);R.flush($[0]);R.destroy();}}}function p(x,M){if(!this._checkTimeEnabled(x)){return false;}var S=this.getSelectedDates();var y;var z=this._oItemNavigation.getItemDomRefs();var $;var Y;var i=0;var P=this.getParent();var A=this;var B;if(P&&P.getSelectedDates){A=P;}if(this.getSingleSelection()){if(S.length>0){y=S[0];B=y.getStartDate();if(B){B=a._createUniversalUTCDate(B,undefined,true);B=this._getIntervalStart(B);}}else{y=new sap.ui.unified.DateRange();A.addAggregation("selectedDates",y,true);}if(this.getIntervalSelection()&&(!y.getEndDate()||M)&&B){var E;if(x.getTime()<B.getTime()){E=B;B=x;if(!M){y.setProperty("startDate",a._createLocalDate(new Date(B.getTime()),true),true);y.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true),true);}}else if(x.getTime()>=B.getTime()){E=x;if(!M){y.setProperty("endDate",a._createLocalDate(new Date(E.getTime()),true),true);}}r.call(this,B,E);}else{r.call(this,x);y.setProperty("startDate",a._createLocalDate(new Date(x.getTime()),true),true);y.setProperty("endDate",undefined,true);}}else{if(this.getIntervalSelection()){throw new Error("Calender don't support multiple interval selection");}else{var F=this._checkDateSelected(x);if(F>0){for(i=0;i<S.length;i++){B=S[i].getStartDate();if(B){B=a._createUniversalUTCDate(B,undefined,true);B=this._getIntervalStart(B);if(x.getTime()==B.getTime()){A.removeAggregation("selectedDates",i,true);break;}}}}else{y=new sap.ui.unified.DateRange({startDate:a._createLocalDate(new Date(x.getTime()),true)});A.addAggregation("selectedDates",y,true);}Y=this._oFormatYyyyMMddHHmm.format(x.getJSDate(),true);for(i=0;i<z.length;i++){$=q(z[i]);if($.attr("data-sap-time")==Y){if(F>0){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}else{$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");}}}}}return true;}function r(S,E){var x=this._oItemNavigation.getItemDomRefs();var $;var i=0;var y=false;var z=false;if(!E){var Y=this._oFormatYyyyMMddHHmm.format(S.getJSDate(),true);for(i=0;i<x.length;i++){$=q(x[i]);y=false;z=false;if($.attr("data-sap-time")==Y){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");y=true;}else if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}s.call(this,$,y,z);}}else{var A;for(i=0;i<x.length;i++){$=q(x[i]);y=false;z=false;A=new U(this._oFormatYyyyMMddHHmm.parse($.attr("data-sap-time"),true).getTime());if(A.getTime()==S.getTime()){$.addClass("sapUiCalItemSelStart");y=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");if(E&&A.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");z=true;}$.removeClass("sapUiCalItemSelBetween");}else if(E&&A.getTime()>S.getTime()&&A.getTime()<E.getTime()){$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.addClass("sapUiCalItemSelBetween");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelEnd");}else if(E&&A.getTime()==E.getTime()){$.addClass("sapUiCalItemSelEnd");z=true;$.addClass("sapUiCalItemSel");$.attr("aria-selected","true");$.removeClass("sapUiCalItemSelStart");$.removeClass("sapUiCalItemSelBetween");}else{if($.hasClass("sapUiCalItemSel")){$.removeClass("sapUiCalItemSel");$.attr("aria-selected","false");}if($.hasClass("sapUiCalItemSelStart")){$.removeClass("sapUiCalItemSelStart");}else if($.hasClass("sapUiCalItemSelBetween")){$.removeClass("sapUiCalItemSelBetween");}else if($.hasClass("sapUiCalItemSelEnd")){$.removeClass("sapUiCalItemSelEnd");}}s.call(this,$,y,z);}}}function s($,S,E){if(!this.getIntervalSelection()){return;}var x="";var y=[];var z=this.getId();var A=false;x=$.attr("aria-describedby");if(x){y=x.split(" ");}var B=-1;var F=-1;for(var i=0;i<y.length;i++){var G=y[i];if(G==(z+"-Start")){B=i;}if(G==(z+"-End")){F=i;}}if(B>=0&&!S){y.splice(B,1);A=true;if(F>B){F--;}}if(F>=0&&!E){y.splice(F,1);A=true;}if(B<0&&S){y.push(z+"-Start");A=true;}if(F<0&&E){y.push(z+"-End");A=true;}if(A){x=y.join(" ");$.attr("aria-describedby",x);}}function t(){if(this._bMouseMove){w.call(this,true);}this.fireSelect();}function u(){this._sInvalidateTimes=undefined;n.call(this,this._bNoFocus);this._bDateRangeChanged=undefined;this._bNoFocus=undefined;}function v(){q(window.document).bind('mousemove',this._mouseMoveProxy);this._bMouseMove=true;}function w(){q(window.document).unbind('mousemove',this._mouseMoveProxy);this._bMouseMove=undefined;}return e;});
