/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/ux3/ActionBar',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./library',"./ActionBarRenderer"],function(q,C,I,l,A){"use strict";
var a=C.extend("sap.ui.ux3.ActionBar",{metadata:{library:"sap.ui.ux3",properties:{followState:{type:"sap.ui.ux3.FollowActionState",group:"Misc",defaultValue:sap.ui.ux3.FollowActionState.Default},flagState:{type:"boolean",group:"Misc",defaultValue:null},favoriteState:{type:"boolean",group:"Misc",defaultValue:null},updateState:{type:"boolean",group:"Misc",defaultValue:null},thingIconURI:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},alwaysShowMoreMenu:{type:"boolean",group:"Misc",defaultValue:true},showUpdate:{type:"boolean",group:"Misc",defaultValue:true},showFollow:{type:"boolean",group:"Misc",defaultValue:true},showFlag:{type:"boolean",group:"Misc",defaultValue:true},showFavorite:{type:"boolean",group:"Misc",defaultValue:true},showOpen:{type:"boolean",group:"Misc",defaultValue:true},dividerWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null}},aggregations:{businessActions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"businessAction"},_businessActionButtons:{type:"sap.ui.commons.Button",multiple:true,singularName:"_businessActionButton",visibility:"hidden"},_socialActions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"_socialAction",visibility:"hidden"}},events:{actionSelected:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"},newState:{type:"string"}}},feedSubmit:{parameters:{text:{type:"string"}}}}}});
a.prototype.init=function(){this.mActionMap={};this.mActionKeys=sap.ui.ux3.ActionBarSocialActions;this.oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Update),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Follow),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Flag),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Favorite),true);this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Open),true);if(!this._oItemNavigation){this._oItemNavigation=new I();this.addDelegate(this._oItemNavigation);}};
a.prototype.exit=function(){this.closePopups();if(this._oUpdatePopup){this._oUpdatePopup.destroy();this._oUpdatePopup=null;}if(this._oMoreMenuButton){this._oMoreMenuButton.destroy();this._oMoreMenuButton=null;}if(this._oMoreMenu){this._oMoreMenu.destroy();this._oMoreMenu=null;}if(this._oHoldItem){this._oHoldItem.destroy();}if(this._oUnFollowItem){this._oUnFollowItem.destroy();}if(this._oUnHoldItem){this._oUnHoldItem.destroy();}if(this._sResizeListenerId){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}this.mActionKeys=null;this.mActionKeys=null;this.oRb=null;this.destroyAggregation("_socialActions");this.destroyAggregation("_businessActionButtons");if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
a.prototype.isActive=function(){var r=this.getDomRef()!=null;return r;};
a.prototype._getLocalizedText=function(k,b){var t;if(this.oRb){t=this.oRb.getText(k);}if(t&&b){for(var i=0;i<b.length;i++){t=t.replace("{"+i+"}",b[i]);}}return t?t:k;};
a.prototype._getSocialAction=function(s){var r=this.mActionMap[s];if(!r){r=new sap.ui.ux3.ThingAction({id:this.getId()+"-"+s});switch(s){case this.mActionKeys.Update:r.name=this.mActionKeys.Update;r.tooltipKey="ACTIONBAR_UPDATE_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarUpdateAction";r.fnInit=function(o){o._oUpdatePopup=new sap.ui.ux3.ToolPopup({id:o.getId()+"-UpdateActionPopup"}).addStyleClass("sapUiUx3ActionBarUpdatePopup");o._oUpdatePopup._ensurePopup().setAutoClose(true);o._feeder=new sap.ui.ux3.Feeder({id:o.getId()+"-Feeder",type:sap.ui.ux3.FeederType.Comment,thumbnailSrc:o.getThingIconURI(),text:"",submit:q.proxy(function(e){var d=e.getParameter("text");this.fireFeedSubmit({text:d});this._oUpdatePopup.close();},o)});o._feeder.addStyleClass("sapUiUx3ActionBarFeeder");o._oUpdatePopup.addContent(o._feeder);};r.fnActionSelected=function(e,o){o._setUpdateState(!o.getUpdateState());if(o._oUpdatePopup.isOpen()){o._oUpdatePopup.close();}else{var d,t,i;o._oUpdatePopup.setPosition(sap.ui.core.Popup.Dock.BeginBottom,sap.ui.core.Popup.Dock.BeginTop,e.getSource().getDomRef(),"-8 -13","none");o._oUpdatePopup.open();d=q(o._oUpdatePopup.getDomRef());t=q(window).height();i=q(o.getDomRef()).offset().top;d.css("top","auto").css("bottom",(t-i+7)+"px");q.sap.delayedCall(1000,this,function(){q.sap.focus(o._feeder.getFocusDomRef());});}o._updateSocialActionDomRef(r);};r.fnExit=function(o){if(o._oUpdatePopup){o._oUpdatePopup.destroy();o._oUpdatePopup=null;}};r.fnCalculateState=function(o){var d=null;if(o.getUpdateState()){d="Selected";}return d;};break;case this.mActionKeys.Follow:var f=r;r.name=this.mActionKeys.Follow;r.tooltipKey="ACTIONBAR_FOLLOW_ACTION_TOOLTIP_FOLLOW";r.cssClass="sapUiUx3ActionBarFollowAction";r.isMenu=function(o){return o.getFollowState()!=sap.ui.ux3.FollowActionState.Default;};r.fnActionSelected=function(e,o){if(o.getFollowState()==sap.ui.ux3.FollowActionState.Default){o._setFollowState(sap.ui.ux3.FollowActionState.Follow);o.fireActionSelected({id:f.name,state:"followState",action:f});this._fnPrepareFollowMenu(e,o);}else{var d=sap.ui.core.Popup.Dock;o._oMenu.open(false,f.getFocusDomRef(),d.BeginBottom,d.BeginTop,f.getDomRef());}};r.fnCalculateState=function(o){return o.getFollowState();};r._fnPrepareFollowMenu=function(e,o){var i=sap.ui.resource("sap.ui.ux3","themes/"+sap.ui.getCore().getConfiguration().getTheme());if(o.mActionMap[o.mActionKeys.Follow]){if(!o._oUnFollowItem){o._oUnFollowItem=new sap.ui.commons.MenuItem({id:o.getId()+"-unfollowState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_UNFOLLOW"),icon:i+"/img/menu_unlisten.png"});}if(!o._oHoldItem){o._oHoldItem=new sap.ui.commons.MenuItem({id:o.getId()+"-holdState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_HOLD"),icon:i+"/img/menu_hold.png"});}if(!o._oUnHoldItem){o._oUnHoldItem=new sap.ui.commons.MenuItem({id:o.getId()+"-unholdState",text:o._getLocalizedText("TI_FOLLOW_ACTION_MENU_TXT_UNHOLD"),icon:i+"/img/menu_follow.png"});}if(!o._oMenu){o._oMenu=new sap.ui.commons.Menu({id:o.getId()+"-followActionMenu"});o._oMenu.attachItemSelect(q.proxy(function(d){this._fnFollowMenuSelected(d,o);},this));o._oMenu.addItem(o._oHoldItem);o._oMenu.addItem(o._oUnHoldItem);o._oMenu.addItem(o._oUnFollowItem);}if(o.getFollowState()==sap.ui.ux3.FollowActionState.Default){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_FOLLOW"));o._oHoldItem.setVisible(false);o._oUnFollowItem.setVisible(false);o._oUnHoldItem.setVisible(false);}else if(o.getFollowState()==sap.ui.ux3.FollowActionState.Follow){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_STOPPAUSE_FOLLOW"));o._oHoldItem.setVisible(true);o._oUnFollowItem.setVisible(true);o._oUnHoldItem.setVisible(false);}else if(o.getFollowState()==sap.ui.ux3.FollowActionState.Hold){o.mActionMap[o.mActionKeys.Follow].setTooltip(o._getLocalizedText("TI_FOLLOW_ACTION_TOOLTIP_STOPCONTINUE_FOLLOW"));o._oHoldItem.setVisible(false);o._oUnFollowItem.setVisible(true);o._oUnHoldItem.setVisible(true);}o._updateSocialActionDomRef(r);}};r._fnFollowMenuSelected=function(e,o){if(o.mActionMap[o.mActionKeys.Follow]){var i=e.getParameters().item.getId();if(i==o.getId()+"-followState"){o._setFollowState(sap.ui.ux3.FollowActionState.Follow);}else if(i==o.getId()+"-unfollowState"){o._setFollowState(sap.ui.ux3.FollowActionState.Default);}else if(i==o.getId()+"-holdState"){o._setFollowState(sap.ui.ux3.FollowActionState.Hold);}else if(i+"-unholdState"){o._setFollowState(sap.ui.ux3.FollowActionState.Follow);}o.fireActionSelected({id:f.name,state:i,action:f});this._fnPrepareFollowMenu(e,o);}};break;case this.mActionKeys.Favorite:var b=r;r.name=this.mActionKeys.Favorite;r.tooltipKey="ACTIONBAR_FAVORITE_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarFavoriteAction";r.fnActionSelected=function(e,o){if(o.getFavoriteState()==true){o._setFavoriteState(false);}else{o._setFavoriteState(true);}o.fireActionSelected({id:b.name,state:o.getFavoriteState(),action:b});o._updateSocialActionDomRef(r);};r.fnCalculateState=function(o){var d=null;if(o.getFavoriteState()){d="Selected";}return d;};break;case this.mActionKeys.Flag:var c=r;r.name=this.mActionKeys.Flag;r.tooltipKey="ACTIONBAR_FLAG_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarFlagAction";r.fnActionSelected=function(e,o){o._setFlagState(!o.getFlagState());o.fireActionSelected({id:c.name,state:o.getFlagState(),action:c});o._updateSocialActionDomRef(r);};r.fnCalculateState=function(o){var d=null;if(o.getFlagState()){d="Selected";}return d;};break;case this.mActionKeys.Open:r.name=this.mActionKeys.Open;r.tooltipKey="ACTIONBAR_OPEN_THING_ACTION_TOOLTIP";r.cssClass="sapUiUx3ActionBarOpenThingAction";break;default:q.sap.log.warning("Function \"sap.ui.ux3.ActionBar.prototype._getSocialAction\" was called with unknown action key \""+s+"\".\n\tNo action will not be rendered.");return undefined;}}return r;};
a.prototype._updateSocialActionDomRef=function(s){var c=s.$();if(c){c.attr("class",s.cssClass);if(s.fnCalculateState){c.addClass("sapUiUx3ActionBarAction");c.addClass(s.fnCalculateState(this));}if(s.name==this.mActionKeys.Update||s.name==this.mActionKeys.Flag||s.name==this.mActionKeys.Favorite){c.attr("aria-pressed",s.fnCalculateState(this)=="Selected"?"true":"false");}if(s.isMenu){c.attr("aria-haspopup",s.isMenu(this)?"true":"false");}}};
a.prototype._rerenderSocialActions=function(){var c=this.$("socialActions");if(c.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ActionBarRenderer.renderSocialActions(r,this);r.flush(c[0]);r.destroy();}};
a.prototype._rerenderBusinessAction=function(b){var c=b.$();if(c.length>0){var r=sap.ui.getCore().createRenderManager();r.renderControl(b);r.flush(c[0].parentNode);r.destroy();}};
a.prototype._rerenderBusinessActions=function(){if(!this.getAlwaysShowMoreMenu()){var c=this.$("businessActions");if(c&&c.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ActionBarRenderer.renderBusinessActionButtons(r,this);r.flush(c[0]);r.destroy();}}this._onresize();};
a.prototype.setFollowState=function(f){this.setProperty("followState",f);if(!this._oMenu){var F=this._getSocialAction(this.mActionKeys.Follow);F._fnPrepareFollowMenu(null,this);}return this;};
a.prototype.setShowUpdate=function(f){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Update),f);this.setProperty("showUpdate",f,true);return this;};
a.prototype.setShowFollow=function(f){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Follow),f);this.setProperty("showFollow",f,true);return this;};
a.prototype.setShowFlag=function(f){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Flag),f);this.setProperty("showFlag",f,true);return this;};
a.prototype.setShowFavorite=function(f){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Favorite),f);this.setProperty("showFavorite",f,true);return this;};
a.prototype.setShowOpen=function(f){this._setShowSocialAction(this._getSocialAction(this.mActionKeys.Open),f);this.setProperty("showOpen",f,true);return this;};
a.prototype._setFollowState=function(f){this.setProperty("followState",f,true);return this;};
a.prototype._setFlagState=function(f){this.setProperty("flagState",f,true);return this;};
a.prototype._setUpdateState=function(u){this.setProperty("updateState",u,true);return this;};
a.prototype._setFavoriteState=function(f){this.setProperty("favoriteState",f,true);return this;};
a.prototype.setThingIconURI=function(i){this.setProperty("thingIconURI",i,true);var u=this.mActionMap[this.mActionKeys.Update];if(u&&this._feeder){this._feeder.setThumbnailSrc(i);}else{q.sap.log.warning("Function \"sap.ui.ux3.ActionBar.setThingIconURI\": failed to set new icon \""+i+"\".\n\tReason: either updateAction "+u+" or feeder "+this._feeder+" is not defined.");}return this;};
a.prototype.setDividerWidth=function(w){this._iSocActListWidth=null;this.setProperty("dividerWidth",w);return this;};
a.prototype.setAlwaysShowMoreMenu=function(f){var o=this.getProperty("alwaysShowMoreMenu");var b=this.getAggregation("businessActions",[]);this.setProperty("alwaysShowMoreMenu",f,true);if(o!=f&&b){if(!f){for(var i=0;i<b.length;i++){var B=b[i];this._createButtonForAction(B,this._oMoreMenu._getMenuItemForAction(B));}}else{var c=this._getBusinessActionButtons();for(var d=0;d<c.length;d++){if(c[d].oMenuItem){c[d].oMenuItem.setVisible(true);c[d].oMenuItem=null;}}this.destroyAggregation("_businessActionButtons");}this._styleMoreMenuButton();}this._bCallOnresize=true;this._rerenderBusinessActions();return this;};
a.prototype.closePopups=function(){if(this._oUpdatePopup){this._oUpdatePopup.close();}if(this._oMoreMenu){this._oMoreMenu.close();}if(this._oMenu){this._oMenu.close();}};
a.prototype._removeSocialAction=function(s){var r=null;if(s.name&&this.mActionMap[s.name]){if(this.mActionMap[s.name].fnExit){this.mActionMap[s.name].fnExit(this);}r=this.removeAggregation("_socialActions",this.mActionMap[s.name],true);this.mActionMap[s.name].destroy();delete this.mActionMap[s.name];this._rerenderSocialActions();this._iSocActListWidth=null;}return r;};
a.prototype._removeAllSocialActions=function(){for(var k in this.mActionMap){if(this.mActionMap[k]&&this.mActionMap[k].fnExit){this.mActionMap[k].fnExit(this);}}this.mActionMap={};var r=this.removeAllAggregation("_socialActions",true);this._iSocActListWidth=null;this._rerenderSocialActions();return r;};
a.prototype._addSocialAction=function(s,i){var r=null;if(!this.mActionMap[s.name]){r=this._prepareSocialAction(s,i);if(s.fnInit){s.fnInit(this);}this._iSocActListWidth=null;}if(r){this._rerenderSocialActions();}return r;};
a.prototype._prepareSocialAction=function(s,i){s.attachSelect(q.proxy(function(c){if(s.fnActionSelected){s.fnActionSelected(c,this);}else{this.fireActionSelected({id:s.name,action:s});}},this));s.setTooltip(this._getLocalizedText(s.tooltipKey));this.mActionMap[s.name]=s;if(i){this.insertAggregation("_socialActions",s,i,true);}else{this.addAggregation("_socialActions",s,true);}return s;};
a.prototype._setShowSocialAction=function(s,f){return f?this._addSocialAction(s):this._removeSocialAction(s);};
a.prototype.addBusinessAction=function(b){return this._addBusinessAction(b);};
a.prototype.insertBusinessAction=function(b,i){return this._addBusinessAction(b,i);};
a.prototype.removeBusinessAction=function(b){return this._removeBusinessAction(b,true);};
a.prototype._removeBusinessAction=function(b,r){if(typeof b==="string"){var c;var s=b;for(var i=0;i<this.getBusinessActions().length;i++){var o=this.getBusinessActions()[i];if(o.getId()===s){c=o;break;}}b=c;}if(this._oMoreMenu){var m=this._oMoreMenu._getMenuItemForAction(b);if(m){this._oMoreMenu.removeItem(m);m.destroy();}if(this._oMoreMenu.getItems().length==0){this._oMoreMenuButton.destroy();this._oMoreMenuButton=null;this._oMoreMenu.destroy();this._oMoreMenu=null;}}if(!this.getAlwaysShowMoreMenu()){var B=this._getButtonForAction(b);if(B){this.removeAggregation("_businessActionButtons",B,true);B.destroy();}}var d=this.removeAggregation("businessActions",b,true);if(r){this._rerenderBusinessActions();}return d;};
a.prototype.removeAllBusinessActions=function(){var b=this.getAggregation("businessActions",[]);if(b){for(var i=0;i<b.length;i++){this._removeBusinessAction(b[i],false);}}this._rerenderBusinessActions();var r=this.removeAllAggregation("businessActions",true);return r;};
a.prototype.destroyBusinessActions=function(){var b=this.getAggregation("businessActions",[]);if(b){for(var i=0;i<b.length;i++){var c=this._removeBusinessAction(b[i],false);if(c instanceof sap.ui.core.Element){c.destroy(true);}}}this._rerenderBusinessActions();var r=this.destroyAggregation("businessActions",true);return r;};
a.prototype._getBusinessActionButtons=function(){return this.getAggregation("_businessActionButtons",[]);};
a.prototype._addBusinessAction=function(b,c){var r;if(!c&&c!=0){r=this.addAggregation("businessActions",b,true);}else{r=this.insertAggregation("businessActions",b,c,true);}if(!this._oMoreMenuButton){this._oMoreMenuButton=new sap.ui.commons.MenuButton(this.getId()+"-MoreMenuButton");this._oMoreMenuButton.setText(this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TEXT"));this._oMoreMenuButton.setTooltip(this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TOOLTIP"));var e=sap.ui.core.Popup.Dock;this._oMoreMenuButton.setDockButton(e.EndTop);this._oMoreMenuButton.setDockMenu(e.EndBottom);this._styleMoreMenuButton();this._oMoreMenu=new sap.ui.commons.Menu(this.getId()+"-MoreMenu",{ariaDescription:this._getLocalizedText("ACTIONBAR_BUTTON_MORE_TOOLTIP")});this._oMoreMenu._getMenuItemForAction=function(o){for(var i=0;i<this.getItems().length;i++){var M=this.getItems()[i];if(M.action==o){return M;}}return null;};this._oMoreMenuButton.setMenu(this._oMoreMenu);}var m=this._oMoreMenu.getId()+"-MenuItem-"+b.getId();var M=new sap.ui.commons.MenuItem(m,{text:b.getText(),enabled:b.getEnabled()});M.action=b;M.attachSelect(q.proxy(function(o){this.fireActionSelected({id:b.getId(),action:b});},this));if(c){this._oMoreMenu.insertItem(M,c);}else{this._oMoreMenu.addItem(M);}this._createButtonForAction(b,M,c);this._rerenderBusinessActions();return r;};
a.prototype._getMoreMenuButton=function(){return this._oMoreMenuButton;};
a.prototype._onresize=function(e){var o=this.$();if(o){var s=this.getActionBarMinWidth()+"px";if(o.css('minWidth')!=s){o.css('minWidth',s);}}if(!this.getAlwaysShowMoreMenu()&&this._oMoreMenuButton){var S=false;if(this._getBusinessActionButtons().length>1){var m=this._oMoreMenuButton.$().outerWidth();var M=o.outerWidth()-this._getSocialActionListMinWidth()-m;var b=this._getBusinessActionButtons();var B=0;for(var i=0;i<b.length;i++){var c=b[i].$().parent();B+=c.outerWidth();if(i==b.length-1){B-=m;}if(B>=M){if(c.length>0){c.css('display','none');if(b[i].oMenuItem){b[i].oMenuItem.setVisible(true);}S=true;}}else{if(c.length>0){c.css('display','');if(!!sap.ui.Device.browser.internet_explorer){this._rerenderBusinessAction(b[i]);}if(b[i].oMenuItem){b[i].oMenuItem.setVisible(false);}}}}S|=this.getAggregation("businessActions").length>b.length;}var d=this._oMoreMenuButton.$().parent();if(d.length>0){S?d.css('display',''):d.css('display','none');}if(!S&&this._oMoreMenu){this._oMoreMenu.close();}}this._setItemNavigation();};
a.prototype.onBeforeRendering=function(){sap.ui.core.ResizeHandler.deregister(this._sResizeListenerId);this._sResizeListenerId=null;};
a.prototype.onAfterRendering=function(){this._sResizeListenerId=sap.ui.core.ResizeHandler.register(this.getDomRef(),q.proxy(this._onresize,this));if(this._bCallOnresize){this._onresize();}this._setItemNavigation();};
a.prototype._getSocialActionListMinWidth=function(){if(!this._iSocActListWidth){if(this.getDividerWidth()){this._iSocActListWidth=parseInt(this.getDividerWidth(),10);}else{var s=this.getAggregation("_socialActions",[]);var i=s.length;this._iSocActListWidth=24*i+12;}}return this._iSocActListWidth;};
a.prototype.getActionBarMinWidth=function(){var r=this._getSocialActionListMinWidth();var R=this._oMoreMenuButton;if(!this.getAlwaysShowMoreMenu()&&this._getBusinessActionButtons().length==1){R=this._getBusinessActionButtons()[0];}if(R){var p=R.$().parent();if(p){r+=p.outerWidth()-3;}}return r;};
a.prototype._getButtonForAction=function(o){for(var i=0;i<this._getBusinessActionButtons().length;i++){var b=this._getBusinessActionButtons()[i];if(b.action==o){return b;}}return null;};
a.prototype._createButtonForAction=function(b,m,i){if(!this.getAlwaysShowMoreMenu()&&!b.showInMoreMenu){var B=new sap.ui.commons.Button({id:this.getId()+"-"+b.getId()+"Button",text:b.getText(),tooltip:b.getTooltip(),enabled:b.getEnabled()});B.attachPress(q.proxy(function(c){this.fireActionSelected({id:b.getId(),action:b});},this));B.oMenuItem=m;B.action=b;if(i){this.insertAggregation("_businessActionButtons",B,i,true);}else{this.addAggregation("_businessActionButtons",B,true);}return B;}return null;};
a.prototype._styleMoreMenuButton=function(){if(this._oMoreMenuButton){if(this.getAlwaysShowMoreMenu()){this._oMoreMenuButton.setLite(true);this._oMoreMenuButton.addStyleClass("sapUiUx3ActionBarLiteMoreButton");}else{this._oMoreMenuButton.setLite(false);this._oMoreMenuButton.removeStyleClass("sapUiUx3ActionBarLiteMoreButton");}}};
a.prototype._setItemNavigation=function(){if(this.getDomRef()){this._oItemNavigation.setRootDomRef(q(this.getDomRef()).get(0));var b=[];var o=this.getAggregation("_socialActions",[]);for(var i=0;i<o.length;i++){b.push(o[i].getDomRef());}o=this.getAggregation("_businessActionButtons",[]);for(var i=0;i<o.length;i++){b.push(o[i].getDomRef());}if(this._oMoreMenuButton&&this._oMoreMenuButton.getDomRef()){b.push(this._oMoreMenuButton.getDomRef());}this._oItemNavigation.setItemDomRefs(b);}};
a.prototype.invalidate=function(c){if(c instanceof sap.ui.ux3.ThingAction){var b=sap.ui.getCore().byId(this.getId()+"-"+c.getId()+"Button");var B=this._oMoreMenu&&this._oMoreMenu._getMenuItemForAction(c);if(b){b.setTooltip(c.getTooltip());b.setText(c.getText());b.setEnabled(c.getEnabled());}if(B){B.setTooltip(c.getTooltip());B.setText(c.getText());B.setEnabled(c.getEnabled());}if(!b&&!B){C.prototype.invalidate.apply(this,arguments);}}C.prototype.invalidate.apply(this,arguments);};
return a;},true);
sap.ui.predefine('sap/ui/ux3/ActionBarRenderer',['jquery.sap.global'],function(q){"use strict";var A={};
A.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiUx3ActionBar");a.writeClasses();if(sap.ui.getCore().getConfiguration().getAccessibility()){a.writeAttribute('role','toolbar');}a.write(">");a.write("<ul");a.writeAttribute('id',c.getId()+"-socialActions");a.addClass("sapUiUx3ActionBarSocialActions");a.writeClasses();a.addStyle("min-width",c._getSocialActionListMinWidth()+"px");a.writeStyles();a.write(">");this.renderSocialActions(a,c);a.write("</ul>");a.write("<ul  id='"+c.getId()+"-businessActions' class='sapUiUx3ActionBarBusinessActions'>");this.renderBusinessActionButtons(a,c);a.write("</ul>");a.write("</div>");};
A.renderBusinessActionButtons=function(r,c){var a=c._getBusinessActionButtons();var m=c._getMoreMenuButton();if(a&&a.length>0){for(var i=0;i<a.length;i++){var b=a[i];r.write("<li");r.addClass("sapUiUx3ActionBarItemRight");r.writeClasses();r.write(">");r.renderControl(b);r.write("</li>");}this._renderMoreMenuButton(r,m);}else if(m){this._renderMoreMenuButton(r,m);}};
A._renderMoreMenuButton=function(r,m){if(m){r.write("<li");r.addClass("sapUiUx3ActionBarItemRight");r.addClass("sapUiUx3ActionBarMoreButton");r.writeClasses();r.write(">");r.renderControl(m);r.write("</li>");}};
A.renderSocialActions=function(r,c){var m=c.mActionMap;var k=c.mActionKeys;if(m[k.Update]){this._renderSocialActionListItem(r,c,m[k.Update]);}if(m[k.Follow]){this._renderSocialActionListItem(r,c,m[k.Follow]);}if(m[k.Flag]){this._renderSocialActionListItem(r,c,m[k.Flag]);}if(m[k.Favorite]){this._renderSocialActionListItem(r,c,m[k.Favorite]);}if(m[k.Open]){this._renderSocialActionListItem(r,c,m[k.Open]);}for(var K in m){if(!(K in sap.ui.ux3.ActionBarSocialActions)){this._renderSocialActionListItem(r,c,m[K]);}}};
A._renderSocialActionListItem=function(r,c,a){if(a&&!a.hide){r.write("<li");r.addClass("sapUiUx3ActionBarItem");r.writeClasses();r.write(">");this._renderSocialAction(r,c,a);r.write("</li>");}};
A._renderSocialAction=function(r,c,a){if(a.isMenu&&a.isMenu(c)){r.write("<a role=\"button\" aria-disabled=\"false\" aria-haspopup=\"true\"");}else{r.write("<a  role=\"button\" aria-disabled=\"false\" aria-haspopup=\"false\"");}if(a.name==c.mActionKeys.Flag||a.name==c.mActionKeys.Favorite){r.writeAttribute("aria-pressed",a.fnCalculateState(c)=="Selected"?"true":"false");}r.writeAttribute("tabindex","0");r.writeElementData(a);r.addClass(a.cssClass);if(a.fnCalculateState){r.addClass(a.fnCalculateState(c));}r.addClass("sapUiUx3ActionBarAction");r.writeClasses();if(a.getTooltip()){r.writeAttributeEscaped("title",a.getTooltip());}if(a.text){r.writeAttributeEscaped("text",c.getLocalizedText(a.getText()));}r.write("></a>");};
return A;},true);
sap.ui.predefine('sap/ui/ux3/Collection',['jquery.sap.global','sap/ui/core/Element','sap/ui/model/SelectionModel','./library'],function(q,E,S,l){"use strict";
var C=E.extend("sap.ui.ux3.Collection",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Appearance",defaultValue:null},editable:{type:"boolean",group:"Appearance",defaultValue:false},multiSelection:{type:"boolean",group:"Accessibility",defaultValue:false}},aggregations:{items:{type:"sap.ui.core.Item",multiple:true,singularName:"item"}},associations:{selectedItems:{type:"sap.ui.core.Item",multiple:true,singularName:"selectedItem"}},events:{selectionChanged:{},propertyChanged:{}}}});
C.prototype.init=function(){this.oCollectionSelection=new S(S.SINGLE_SELECTION);};
C.prototype.setMultiSelection=function(m){if(m){this.oCollectionSelection.setSelectionMode(S.MULTI_SELECTION);}else{this.oCollectionSelection.setSelectionMode(S.SINGLE_SELECTION);this.removeAllSelectedItems();}return this.setProperty("multiSelection",m);};
C.prototype.setEditable=function(e){this.setProperty("editable",e,true);this.firePropertyChanged();};
C.prototype.setTitle=function(t){this.setProperty("title",t);this.fireEvent('_titleChanged',{newTitle:this.getProperty("title")});};
C.prototype.addSelectedItem=function(s){var o;if(typeof s=="object"){o=s;}else{o=sap.ui.getCore().byId(s);}if(q.inArray(o.getId(),this.getSelectedItems())>=0){return this;}var i=this.indexOfItem(o);if(i>-1){if(this.oCollectionSelection.getSelectionMode()==S.SINGLE_SELECTION){this.removeAllAssociation("selectedItems",true);this.oCollectionSelection.clearSelection();}this.oCollectionSelection.addSelectionInterval(i,i);}this.addAssociation("selectedItems",s,true);this.fireSelectionChanged();return this;};
C.prototype.removeSelectedItem=function(s){if(this.getSelectedItems().length<=1){return;}var r=this.removeAssociation("selectedItems",s,true);var i;if(typeof s=="object"){i=this.indexOfItem(s);}else{i=this.indexOfItem(sap.ui.getCore().byId(s));}if(i>-1){this.oCollectionSelection.removeSelectionInterval(i,i);}this.fireSelectionChanged();return r;};
C.prototype.removeAllSelectedItems=function(){var r=this.removeAllAssociation("selectedItems",true);this.oCollectionSelection.clearSelection();if(this.getItems().length>0){this.addSelectedItem(this.getItems()[0]);}else{this.fireSelectionChanged();}return r;};
return C;},true);
sap.ui.predefine('sap/ui/ux3/CollectionInspector',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./library',"./CollectionInspectorRenderer"],function(q,C,I,l,a){"use strict";
var b=C.extend("sap.ui.ux3.CollectionInspector",{metadata:{library:"sap.ui.ux3",properties:{sidebarVisible:{type:"boolean",group:"Appearance",defaultValue:true},fitParent:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{collections:{type:"sap.ui.ux3.Collection",multiple:true,singularName:"collection"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{selectedCollection:{type:"sap.ui.ux3.Collection",multiple:false}},events:{collectionSelected:{},itemSelectionChanged:{},editCollection:{}}}});
b.prototype.init=function(){var t=this;if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.setCycling(false);this.addDelegate(this._oItemNavigation);}var T=new sap.ui.commons.ToggleButton(this.getId()+"-toggleButton");T.setParent(this);T.setTooltip("This button opens and closes the sidebar");T.attachPress(function(){if(T.getPressed()){t.openSidebar();}else{t.closeSidebar();}});this._oToggleButton=T;var c=new sap.ui.commons.SegmentedButton(this.getId()+"-selector");c.attachSelect(function(E){var i=this.indexOfButton(sap.ui.getCore().byId(this.getSelectedButton()));var o=t.getCollections()[i];t.setSelectedCollection(o);t.fireCollectionSelected({collection:o});t.openSidebar();});this._oCollectionSelector=c;var e=new sap.ui.commons.Button();e.addStyleClass("sapUiUx3EditCollectionButton");e.setText("Collection");e.setTooltip("This button opens an edit dialog for the current collection");e.attachPress(function(){t.fireEditCollection();});this._oEditButton=e;};
b.prototype.exit=function(){this._oToggleButton.destroy();this._oToggleButton=null;this._oEditButton.destroy();this._oEditButton=null;this._oCollectionSelector.destroy();this._oCollectionSelector=null;if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}};
b.prototype.onBeforeRendering=function(){this._oToggleButton.setPressed(this.getSidebarVisible());};
b.prototype.onAfterRendering=function(){if(!this.getSelectedCollection()){if(this.getCollections().length>0){this.setSelectedCollection(this.getCollections()[0]);}}else{var s=sap.ui.getCore().byId(this.getSelectedCollection());if(s.getSelectedItems().length==0&&s.getItems().length>0){s.addSelectedItem(s.getItems()[0]);}}this.setElementsHeight();this.updateItemNavigation();this.refreshSelectionHighlighting();};
b.prototype.onclick=function(e){var t=e.target;if(q(t).hasClass("sapUiUx3CICollectionListItem")){var s=sap.ui.getCore().byId(this.getSelectedCollection());if(q.inArray(t.id,s.getSelectedItems())>=0){s.removeSelectedItem(t.id);}else{s.addSelectedItem(t.id);}this.refreshSelectionHighlighting();this.fireItemSelectionChanged({selectedItems:s.getSelectedItems()});}};
b.prototype.getToggleButton=function(){return this._oToggleButton;};
b.prototype.getCollectionSelector=function(){return this._oCollectionSelector;};
b.prototype.rerenderSidebar=function(){var c=sap.ui.getCore().byId(this.getSelectedCollection());if(c&&c.getEditable()){this._oEditButton.setVisible(true);}else{this._oEditButton.setVisible(false);}var $=this.$("sidebar");if($.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderSidebar(r,this);r.flush($[0]);r.destroy();}if(c&&c.getEditable()){this.$("sidebar").addClass("sapUiUx3CIWithEditButton");}else{this.$("sidebar").removeClass("sapUiUx3CIWithEditButton");}this.updateItemNavigation();this.refreshSelectionHighlighting();};
b.prototype.updateItemNavigation=function(){var i=[];var $=this.$("sidebar").find('li');q.each($,function(c,d){i.push(d);});this._oItemNavigation.setItemDomRefs(i);this._oItemNavigation.setRootDomRef(this.$("sidebar ul")[0]);};
b.prototype.rerenderContent=function(){var c=this.$("content");if(c.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderContent(r,this);r.flush(c[0]);r.destroy();}this.setElementsHeight();};
b.prototype.setElementsHeight=function(){if(this.getFitParent()){return;}var s=this.$("sidebar");var c=this.$("content");var i=c.outerHeight(true);var d=c.outerHeight(true)-c.height();var S=s.outerHeight(true)-s.height();s.height(Math.max(200,i)-S);c.height(Math.max(200,i)-d);};
b.prototype.openSidebar=function(){var $=this.$();var s=this.$("sidebar");var c=this.$("content");s.stop(true,true).animate({width:150},300,function(){s.css('width','');});c.stop(true,true).animate({left:150},300,function(){c.css('left','');});$.removeClass("sapUiUx3CISidebarClosed");$.addClass("sapUiUx3CISidebarOpened");this._oToggleButton.setPressed(true);};
b.prototype.closeSidebar=function(){var $=this.$();var s=this.$("sidebar");var c=this.$("content");s.stop(true,true).animate({width:0},300,function(){s.css('width','');});c.stop(true,true).animate({left:0},300,function(){c.css('left','');});$.removeClass("sapUiUx3CISidebarOpened");$.addClass("sapUiUx3CISidebarClosed");this._oToggleButton.setPressed(false);};
b.prototype.insertCollection=function(c,i){var B=new sap.ui.commons.Button();B.setText(c.getTitle());c.attachEvent('_titleChanged',function(e){B.setText(e.getParameter("newTitle"));});var t=this;c.attachSelectionChanged(function(){t.refreshSelectionHighlighting();});c.attachPropertyChanged(function(){t.rerenderSidebar();});this._oCollectionSelector.insertButton(B,i);return this.insertAggregation("collections",c,i);};
b.prototype.addCollection=function(c){var B=new sap.ui.commons.Button();B.setText(c.getTitle());c.attachEvent('_titleChanged',function(e){B.setText(e.getParameter("newTitle"));});var t=this;c.attachSelectionChanged(function(){t.refreshSelectionHighlighting();});c.attachPropertyChanged(function(){t.rerenderSidebar();});this._oCollectionSelector.addButton(B);return this.addAggregation("collections",c);};
b.prototype.removeCollection=function(c){var i;if(typeof c=="object"){i=this.indexOfCollection(c);}else{i=this.indexOfCollection(sap.ui.getCore().byId(c));}var B=this._oCollectionSelector.getButtons()[i];this._oCollectionSelector.removeButton(B);var r=this.removeAggregation("collections",c);if(r&&this.getSelectedCollection()==r.getId()){this.setSelectedCollection(null);}return r;};
b.prototype.removeAllCollections=function(){this._oCollectionSelector.removeAllButtons();this.setSelectedCollection(null);return this.removeAllAggregation("collections");};
b.prototype.destroyCollections=function(){this._oCollectionSelector.destroyButtons();this.setSelectedCollection(null);return this.destroyAggregation("collections");};
b.prototype.setSelectedCollection=function(c){this.setAssociation("selectedCollection",c,true);if(!c){this._oEditButton.setVisible(false);}else{this._oCollectionSelector.setSelectedButton(this._oCollectionSelector.getButtons()[this.indexOfCollection(c)]);var s=sap.ui.getCore().byId(this.getSelectedCollection());if(s.getSelectedItems().length==0&&s.getItems().length>0){s.addSelectedItem(s.getItems()[0]);}}this.rerenderSidebar();this.refreshSelectionHighlighting();};
b.prototype.insertContent=function(c,i){this.insertAggregation("content",c,i,true);this.rerenderContent();};
b.prototype.addContent=function(c){this.addAggregation("content",c,true);this.rerenderContent();};
b.prototype.removeContent=function(c){this.removeAggregation("content",c,true);this.rerenderContent();};
b.prototype.removeAllContent=function(){this.removeAllAggregation("content",true);this.rerenderContent();};
b.prototype.destroyContent=function(){this.destroyAggregation("content",true);this.rerenderContent();};
b.prototype.onfocusout=function(e){var t=q(e.target);if(t.hasClass("sapUiUx3CICollectionListItem")){t.removeClass("sapUiUx3CISidebarFoc");}};
b.prototype.onfocusin=function(e){var t=q(e.target);if(t.hasClass("sapUiUx3CICollectionListItem")){t.addClass("sapUiUx3CISidebarFoc");}};
b.prototype.onsapenter=function(e){var t=q(e.target);if(t.hasClass("sapUiUx3CISidebarFoc")){this.onclick(e);}e.stopPropagation();};
b.prototype.onsapspace=function(e){var t=q(e.target);if(t.hasClass("sapUiUx3CISidebarFoc")){this.onclick(e);}e.stopPropagation();};
b.prototype.refreshSelectionHighlighting=function(){var i=this.$("sidebar").find('.sapUiUx3CICollectionListItem');var s;if(this.getSelectedCollection()){s=sap.ui.getCore().byId(this.getSelectedCollection()).getSelectedItems();}else{s=[];}q.each(i,function(c,o){if(q.inArray(o.id,s)>=0){q(o).addClass("sapUiUx3CICollectionListItemSelected");q(o).attr("aria-selected",true);}else{q(o).removeClass("sapUiUx3CICollectionListItemSelected");q(o).attr("aria-selected",false);}});};
b.prototype.getEditButton=function(){return this._oEditButton;};
return b;},true);
sap.ui.predefine('sap/ui/ux3/CollectionInspectorRenderer',['jquery.sap.global'],function(q){"use strict";var C={};
C.render=function(r,c){var a=r;a.write("<div");a.addClass("sapUiUx3CI");if(c.getSidebarVisible()){a.addClass("sapUiUx3CISidebarOpened");}else{a.addClass("sapUiUx3CISidebarClosed");}if(c.getFitParent()){a.addClass("sapUiUx3CIFitParent");}a.writeClasses();a.writeControlData(c);a.write(">");a.write("<div");a.addClass("sapUiUx3CIToolBar");a.writeClasses();a.write(">");this.renderToggleButton(a,c);this.renderCollectionSelector(a,c);a.write("</div>");a.write('<div');a.addClass("sapUiUx3CISidebar");a.writeClasses();a.writeAttribute("id",c.getId()+"-sidebar");a.write(">");this.renderSidebar(a,c);a.write("</div>");a.write("<div");a.addClass("sapUiUx3CIContent");a.writeAttribute("id",c.getId()+"-content");a.writeClasses();a.write(">");this.renderContent(a,c);a.write("</div>");a.write("<div");a.addClass("sapUiUx3CIClear");a.writeClasses();a.write(">");a.write("</div>");a.write("</div>");};
C.renderToggleButton=function(r,c){if(c.getToggleButton()){r.write("<div");r.writeAttribute("id",c.getId()+"-togglebutton");r.addClass("sapUiUx3CIToggleButton");r.writeClasses();r.write(">");r.renderControl(c.getToggleButton());r.write("</div>");}};
C.renderCollectionSelector=function(r,c){if(c.getCollectionSelector()){r.write("<div");r.addClass("sapUiUx3CICollectionSelector");r.writeClasses();r.write(">");r.renderControl(c.getCollectionSelector());r.write("</div>");}};
C.renderSidebar=function(r,c){r.write("<div");r.addClass("sapUiUx3CICollectionListContainer");r.writeClasses();r.write(">");r.write('<ul tabindex="-1"');r.addClass("sapUiUx3CICollectionList");r.writeClasses();var o=sap.ui.getCore().byId(c.getSelectedCollection());if(c.getSelectedCollection()){r.writeAccessibilityState(o,{role:"listbox",multiselectable:o.getMultiSelection()});}r.write(">");if(c.getSelectedCollection()){var i=o.getItems().length;q.each(o.getItems(),function(I,a){r.write('<li tabindex="-1"');r.writeElementData(a);r.writeAttributeEscaped("title",a.getText());r.addClass("sapUiUx3CICollectionListItem");r.writeClasses();r.writeAccessibilityState(a,{role:"option",selected:(q.inArray(a.getId(),o.getSelectedItems())>=0),setsize:i,posinset:I});r.write(">");r.writeEscaped(a.getText());r.write("</li>");});}r.write("</ul></div>");r.renderControl(c.getEditButton());};
C.renderContent=function(r,c){q.each(c.getContent(),function(i,o){r.renderControl(o);});};
return C;},true);
sap.ui.predefine('sap/ui/ux3/DataSet',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/ResizeHandler','./library',"./DataSetRenderer"],function(q,C,R,a,D){"use strict";
var b=C.extend("sap.ui.ux3.DataSet",{metadata:{library:"sap.ui.ux3",properties:{showToolbar:{type:"boolean",group:"Misc",defaultValue:true},showFilter:{type:"boolean",group:"Misc",defaultValue:true},showSearchField:{type:"boolean",group:"Misc",defaultValue:true},multiSelect:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{items:{type:"sap.ui.ux3.DataSetItem",multiple:true,singularName:"item",bindable:"bindable"},views:{type:"sap.ui.ux3.DataSetView",multiple:true,singularName:"view"},filter:{type:"sap.ui.core.Control",multiple:true,singularName:"filter"},_viewSwitches:{type:"sap.ui.core.Control",multiple:true,singularName:"_viewSwitch",visibility:"hidden"},_toolbar:{type:"sap.ui.commons.Toolbar",multiple:false,visibility:"hidden"}},associations:{selectedView:{type:"sap.ui.ux3.DataSetView",multiple:false}},events:{selectionChanged:{parameters:{oldLeadSelectedIndex:{type:"int"},newLeadSelectedIndex:{type:"int"}}},search:{parameters:{query:{type:"string"}}}}}});
b.prototype.init=function(){var t=this,T;q.sap.require("sap.ui.model.SelectionModel");this.selectionModel=new sap.ui.model.SelectionModel(sap.ui.model.SelectionModel.SINGLE_SELECTION);this._oSegBut=new sap.ui.commons.SegmentedButton();this._oSegBut.attachSelect(function(e){t.press(e);},t);this._oSegBut.show=false;this._oSearchField=new sap.ui.commons.SearchField(this.getId()+"-searchValue");this._oSearchField.setShowListExpander(false);this._oSearchField.setEnableListSuggest(false);this._oSearchField.setEnableFilterMode(true);this._oSearchField.setEnableClear(true);this._oSearchField.show=false;t=this;this._oSearchField.attachSearch(function(e){t.fireSearch(e.getParameters());});this.selectionModel.attachSelectionChanged(function(e){var o,n;var p=e.getParameters();if(p){n=p.leadIndex;o=p.oldIndex;}t.fireSelectionChanged({oldLeadSelectedIndex:o,newLeadSelectedIndex:n});q.sap.log.debug("Selection Change fired");});T=new sap.ui.commons.Toolbar();this._setToolbar(T);this._iShiftStart=null;};
b.prototype.exit=function(){this._oSegBut.destroy();this._oSearchField.destroy();this.destroyAggregation("_toolbar");};
b.prototype._prepareToolbar=function(){var v=this.getViews().length,t=this._getToolbar();if(v>1&&this._oSegBut.show==false){t.insertItem(this._oSegBut,0);this._oSegBut.show=true;}else if(v<=1&&this._oSegBut.show){t.removeItem(this._oSegBut);this._oSegBut.show=false;}if(this.getShowSearchField()&&this._oSearchField.show==false){t.insertRightItem(this._oSearchField,t.getRightItems().length);this._oSearchField.show=true;}else if(!this.getShowSearchField()&&this._oSearchField.show==true){t.removeRightItem(this._oSearchField);this._oSearchField.show=false;}};
b.prototype.press=function(e,s){var B=e.getParameters().selectedButtonId,v=B.substring(B.lastIndexOf('-')+1),o=sap.ui.getCore().byId(this.getSelectedView());o.exitView(this.getItems());this.setSelectedView(v);};
b.prototype.filter=function(){this.fireFilter({filterValue:this.getFilterValue()});};
b.prototype.sort=function(){this.fireSort();};
b.prototype.addSelectionInterval=function(i,I){this.selectionModel.addSelectionInterval(i,I);return this;};
b.prototype.setSelectionInterval=function(i,I){this.selectionModel.setSelectionInterval(i,I);return this;};
b.prototype.removeSelectionInterval=function(i,I){this.selectionModel.removeSelectionInterval(i,I);return this;};
b.prototype.getSelectedIndex=function(){return this.selectionModel.getLeadSelectedIndex();};
b.prototype.getSelectedIndices=function(){return this.selectionModel.getSelectedIndices()||[];};
b.prototype.clearSelection=function(){this.selectionModel.clearSelection();return this;};
b.prototype.selectItem=function(e){var p=e.getParameters(),i=e.getParameters().itemId,I=sap.ui.getCore().byId(i),c=this.getItems(),d=q.inArray(I,c),o=this.getLeadSelection();if(!this.getMultiSelect()){if(o==d&&!p.shift){this.setLeadSelection(-1);}else{this.setLeadSelection(d);}this._iShiftStart=null;}else{if(p.ctrl){if(!this.isSelectedIndex(d)){this.addSelectionInterval(d,d);}else{this.removeSelectionInterval(d,d);}if(this._iShiftStart>=0){this._iShiftStart=d;}}if(p.shift){if(!this._iShiftStart&&this._iShiftStart!==0){this._iShiftStart=o;}if(this._iShiftStart>=0&&p.ctrl){this.addSelectionInterval(this._iShiftStart,d);}else if(this._iShiftStart>=0&!p.ctrl){this.setSelectionInterval(this._iShiftStart,d);}else{this.setLeadSelection(d);this._iShiftStart=d;}}if(!p.shift&&!p.ctrl){if(o==d&&d!=this._iShiftStart){this.setLeadSelection(-1);}else{this.setLeadSelection(d);}this._iShiftStart=null;}}};
b.prototype.prepareRendering=function(){var v,V=this.getViews().length;if(V==0){return;}this._prepareToolbar();if(this._bDirty){v=sap.ui.getCore().byId(this.getSelectedView());if(v.exitView){v.exitView(this.getItems());}if(v.initView){v.initView(this.getItems());}this._bDirty=false;}};
b.prototype.getLeadSelection=function(){return this.selectionModel.getLeadSelectedIndex();};
b.prototype.setLeadSelection=function(i){this.selectionModel.setLeadSelectedIndex(i);};
b.prototype.isSelectedIndex=function(i){return(this.selectionModel.isSelectedIndex(i));};
b.prototype.getSelectedItemId=function(i){return this.getItems()[i].getId();};
b.prototype.createViewSwitch=function(v,i){var V;if(v.getIcon()){V=new sap.ui.commons.Button({id:this.getId()+"-view-"+v.getId(),lite:true,icon:v.getIcon(),iconHovered:v.getIconHovered(),iconSelected:v.getIconSelected()});}else if(v.getName()){V=new sap.ui.commons.Button({id:this.getId()+"-view-"+v.getId(),text:v.getName(),lite:true});}else{V=new sap.ui.commons.Button({id:this.getId()+"-view-"+v.getId(),text:v.getId(),lite:true});}V._viewIndex=i;return V;};
b.prototype._rerenderToolbar=function(){var $=this.$("toolbar");this._prepareToolbar();if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.DataSetRenderer.renderToolbar(r,this);r.flush($[0]);r.destroy();}};
b.prototype._rerenderFilter=function(){var $=this.$("filter");if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.DataSetRenderer.renderFilterArea(r,this);r.flush($[0]);if(this.getShowFilter()){$.removeClass("noPadding");}else{$.addClass("noPadding");}r.destroy();}};
b.prototype.setMultiSelect=function(m){this.clearSelection();if(!m){this.setProperty("multiSelect",false);if(!!this.selectionModel){this.selectionModel.setSelectionMode(sap.ui.model.SelectionModel.SINGLE_SELECTION);}}else{this.setProperty("multiSelect",true);if(!!this.selectionModel){this.selectionModel.setSelectionMode(sap.ui.model.SelectionModel.MULTI_SELECTION);}}return this;};
b.prototype.removeItem=function(i){var r=this.removeAggregation("items",i,true);if(r){r.detachSelected(this.selectItem,this);r.destroyAggregation("_template",true);this._bDirty=true;}return r;};
b.prototype.removeAllItems=function(){var I=this.getItems(),r;q.each(I,function(i,o){o.destroyAggregation("_template",true);o.detachSelected(this.selectItem,this);});r=this.removeAllAggregation("items");this._bDirty=true;return r;};
b.prototype.destroyItems=function(){var r=this.destroyAggregation("items");this._bDirty=true;return r;};
b.prototype.addItem=function(i){this.addAggregation("items",i,true);i.attachSelected(this.selectItem,this);this._bDirty=true;return this;};
b.prototype.insertItem=function(i,I){this.insertAggregation("items",i,I,true);i.attachSelected(this.selectItem,this);this._bDirty=true;return this;};
b.prototype.setFilterValue=function(f){this.setProperty("filterValue",f,true);return this;};
b.prototype.getFilterValue=function(){return this.getProperty("filterValue");};
b.prototype.insertView=function(v,i){var V=this.createViewSwitch(v,i,true);if(!this.getSelectedView()){this.setSelectedView(v);}this.insertAggregation("views",v,i);this._oSegBut.insertButton(V,i);this._rerenderToolbar();return this;};
b.prototype.addView=function(v){var i=this.getViews().length,V=this.createViewSwitch(v,i);if(!this.getSelectedView()){this.setSelectedView(v);}this.addAggregation("views",v,true);this._oSegBut.addButton(V);this._rerenderToolbar();return this;};
b.prototype.removeView=function(v){var r=this.removeAggregation("views",v,true);if(r){if(this.getSelectedView()==r.getId()){this.setSelectedView(this.getViews()[0]);this._bDirty=true;r.invalidate();}else{this._rerenderToolbar();}this._oSegBut.removeButton(this.getId()+"-view-"+r.getId()).destroy();}return r;};
b.prototype.destroyViews=function(){this._oSegBut.destroyButtons();this.destroyAggregation("views");return this;};
b.prototype.removeAllViews=function(){var r=this.removeAllAggregation("views");this._oSegBut.destroyButtons();return r;};
b.prototype.setEnableSorting=function(e){this.setProperty("enableSorting",e,true);this._rerenderToolbar();return this;};
b.prototype.setEnableFiltering=function(e){this.setProperty("enableFiltering",e,true);this._rerenderToolbar();return this;};
b.prototype.setSelectedView=function(v){var o=this.getSelectedView();this.setAssociation("selectedView",v);if(o!=this.getSelectedView()){this._bDirty=true;}if(this.getId()+"-view-"+this.getSelectedView()!==this._oSegBut.getSelectedButton()){this._oSegBut.setSelectedButton(this.getId()+"-view-"+this.getSelectedView());}return this;};
b.prototype.addToolbarItem=function(t){this._getToolbar().addItem(t);this._rerenderToolbar();};
b.prototype.removeToolbarItem=function(t){this._getToolbar().removeItem(t);this._rerenderToolbar();};
b.prototype.setShowToolbar=function(s){this.setProperty("showToolbar",s,true);this._rerenderToolbar();};
b.prototype.setShowFilter=function(s){this.setProperty("showFilter",s,true);this._rerenderFilter();};
b.prototype.setShowSearchField=function(s){this.setProperty("showSearchField",s,true);this._rerenderToolbar();};
b.prototype._setToolbar=function(t){this.setAggregation("_toolbar",t,true);this._rerenderToolbar();};
b.prototype._getToolbar=function(){return this.getAggregation("_toolbar");};
b.prototype.refreshItems=function(){var B=this.getBinding("items"),s=sap.ui.getCore().byId(this.getSelectedView());B.bUseExtendedChangeDetection=true;if(s&&s.getItemCount&&s.getItemCount()){var i=Math.max(s.getItemCount(),this.getItems().length);if(i){B.getContexts(0,i);}else{B.getContexts();}}else{B.getContexts();}};
b.prototype.updateItems=function(c){var B=this.mBindingInfos["items"],A=this.getMetadata().getAggregation("items"),s=sap.ui.getCore().byId(this.getSelectedView()),o=B.binding,f=B.factory,d,I,e,g,t=this,h=[];o.bUseExtendedChangeDetection=true;if(s&&s.getItemCount&&s.getItemCount()){var j=Math.max(s.getItemCount(),this.getItems().length);if(j){h=o.getContexts(0,j);}else{h=o.getContexts();}}else{h=o.getContexts();}if(h.diff&&c){var k=h.diff;for(var i=0;i<k.length;i++){I=this.getItems();g=k[i].index;if(k[i].type==="delete"){e=I[g];k[i].item=e;this.removeItem(e);}else if(h.diff[i].type==="insert"){e=f("",h[g]);e.setBindingContext(h[g],B.model);k[i].item=e;this.insertItem(e,g);}}if(s&&s.updateView){s.updateView(k);}}else{this[A._sDestructor]();q.each(h,function(g,m){var n=t.getId()+"-"+g;d=f(n,m);d.setBindingContext(m,B.model);t[A._sMutator](d);});}I=this.getItems();for(var i=0,l=h.length;i<l;i++){I[i].setBindingContext(h[i],B.model);}};
return b;},true);
sap.ui.predefine('sap/ui/ux3/DataSetItem',['jquery.sap.global','sap/ui/core/Element','./library'],function(q,E,l){"use strict";
var D=E.extend("sap.ui.ux3.DataSetItem",{metadata:{library:"sap.ui.ux3",properties:{iconSrc:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},title:{type:"string",group:"Misc",defaultValue:'Title'},checkable:{type:"boolean",group:"Misc",defaultValue:true},subtitle:{type:"string",group:"Misc",defaultValue:'Subtitle'}},aggregations:{_template:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}},events:{selected:{parameters:{itemId:{type:"string"}}}}}});
D.prototype.onclick=function(e){e.stopPropagation();var s=e.shiftKey;var c=!!(e.metaKey||e.ctrlKey);this.fireSelected({itemId:this.getId(),shift:s,ctrl:c});};
D.prototype.ondblclick=function(e){this.onclick(e);};
return D;},true);
sap.ui.predefine('sap/ui/ux3/DataSetRenderer',['jquery.sap.global'],function(q){"use strict";var D={};
D.render=function(r,c){var a=r,v=null;c.prepareRendering();a.write("<div");a.writeControlData(c);a.addClass("sapUiUx3DS");a.writeClasses();a.writeStyles();a.write(">");a.write("<div id='"+c.getId()+"-toolbar'");a.addClass('sapUiUx3DSToolbar');if(!c.getShowToolbar()){a.addClass('noPadding');}a.writeClasses();a.write(">");this.renderToolbar(a,c);a.write("</div>");a.write("<div id='"+c.getId()+"-filter'");a.addClass('sapUiUx3DSFilterArea');if(!c.getShowFilter()){a.addClass('noPadding');}a.writeClasses();a.write(">");this.renderFilterArea(a,c);a.write("</div>");a.write("<div");a.writeAttribute("id",c.getId()+"-items");a.addClass("sapUiUx3DSItems");a.writeClasses();a.write(">");v=sap.ui.getCore().byId(c.getSelectedView());a.renderControl(v);a.write("</div>");a.write("</div>");};
D.renderToolbar=function(r,c){var a=r;if(c.getShowToolbar()){a.renderControl(c._getToolbar());}};
D.renderFilterArea=function(r,c){var a=r,f=c.getFilter();if(c.getShowFilter()){q.each(f,function(i,F){a.renderControl(F);});}};
return D;},true);
sap.ui.predefine('sap/ui/ux3/DataSetSimpleView',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/ResizeHandler','./library',"./DataSetSimpleViewRenderer",'jquery.sap.script'],function(q,C,R,l,D){"use strict";
var a=C.extend("sap.ui.ux3.DataSetSimpleView",{metadata:{interfaces:["sap.ui.ux3.DataSetView"],library:"sap.ui.ux3",properties:{floating:{type:"boolean",group:"Misc",defaultValue:true},name:{type:"string",group:"Misc",defaultValue:"Name of this View"},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHovered:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},responsive:{type:"boolean",group:"Misc",defaultValue:false},itemMinWidth:{type:"int",group:"Misc",defaultValue:0},initialItemCount:{type:"int",group:"Appearance",defaultValue:0},reloadItemCount:{type:"int",group:"Appearance",defaultValue:0},scrollArea:{type:"any",group:"Appearance",defaultValue:null},height:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}},aggregations:{template:{type:"sap.ui.core.Control",multiple:false}}}});
a.prototype.init=function(){this._oDataSet=this.getParent();this.items=[];this._bRendered=false;if(this.getInitialItemCount()>0&&this.getReloadItemCount()<=0){this.setReloadItemCount(this.getInitialItemCount());}this._bUsePagination=false;};
a.prototype.exit=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
a.prototype.handleSelection=function(e){var d=this.getParent();var i=d.getItems(),s=d.getSelectedIndices();if(s.length>1){this._clearTextSelection();}q.each(i,function(b,c){if(d.isSelectedIndex(b)){c.$().addClass("sapUiUx3DSSVSelected");}else{c.$().removeClass("sapUiUx3DSSVSelected");}});};
a.prototype._clearTextSelection=function(){if(window.getSelection){if(window.getSelection().empty){window.getSelection().empty();}else if(window.getSelection().removeAllRanges){window.getSelection().removeAllRanges();}}else if(document.selection&&document.selection.empty){try{document.selection.empty();}catch(e){}}};
a.prototype.isItemSelected=function(i){var I=q.inArray(i,this.items);if(I==-1){return false;}return this.getParent().isSelectedIndex(I);};
a.prototype.initView=function(I){this.getParent().attachSelectionChanged(this.handleSelection,this);this.items=this.items.concat(I);for(var i=0;i<I.length;i++){var t=this.getTemplate().clone();I[i].setAggregation('_template',t,true);}};
a.prototype.updateView=function(d){var i;if(!this.getDomRef()){for(i=0;i<d.length;i++){if(d[i].type==="delete"){d[i].item.destroy();}}return;}var r=sap.ui.getCore().createRenderManager(),L=this.items.length;for(i=0;i<d.length;i++){var I=d[i].item;var b=d[i].index;if(d[i].type==="insert"){var t=this.getTemplate().clone();I.setAggregation('_template',t,true);if(i==d.length-1&&L==0){var o={onAfterRendering:function(){this.calculateItemCounts();this.getParent().updateItems(sap.ui.model.ChangeReason.Change);t.removeDelegate(o);}};t.addDelegate(o,false,this);}this.getRenderer().renderItem(r,this,I);r.flush(this.$()[0],false,b);this.items.splice(b,0,I);}else{this.items.splice(b,1);I.$().remove();I.destroy();}}if(d.length>0&&this.getFloating()&&this.getResponsive()){this._computeWidths(true);}r.destroy();};
a.prototype.exitView=function(I){this.getParent().detachSelectionChanged(this.handleSelection,this);for(var i=0;i<I.length;i++){I[i].destroyAggregation("_template",true);}this.items=[];};
a.prototype.initScrollArea=function(){var $=this.getScrollArea(),t=this;var s=function(e){t.getParent().updateItems(sap.ui.model.ChangeReason.Change);};if(typeof $==='string'){$=q.sap.byId($);}if(!$){$=this.$();}else if($.is('html')){$=q(document);}if(!this._bUsePagination){$.off('scroll',s);}else{$.on('scroll',s);}};
a.prototype.checkScrollItems=function(){if(!this._bRendered){return;}var b=this.getParent().mBindingInfos["items"],$=this.getScrollArea(),B=b.binding,p=this.getParent(),A=0,f,s,c,S;if(p.getItems().length===B.getLength()){return A;}if(typeof $==='string'){$=q.sap.byId($);}if(!$){$=this.$();}if(!$||$.length==0){return A;}s=$[0];c=s.clientHeight;S=s.scrollHeight;if($.is('html')){$=q(document);}if(c==S){f=c+this._iScrollTrigger;}else{f=c+this._iScrollTrigger+$.scrollTop();}if(f>0){var n=Math.floor(f/this._iRowHeight)*this._iItemsPerRow;var i=p.getItems().length;n=Math.ceil(n/this._iItemsPerRow)*this._iItemsPerRow;A=n-i;}return A;};
a.prototype.getItemCount=function(){if(this._bUsePagination){var L=this.getParent().getItems().length,A=this.checkScrollItems();if(L==0){L+=this.getInitialItemCount();}else{L+=A;}return L;}else{return null;}};
a.prototype.setInitialItemCount=function(v){this.setProperty("initialItemCount",v);this._bUsePagination=(v!=0);};
a.prototype.onBeforeRendering=function(){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}};
a.prototype.onAfterRendering=function(){this._bRendered=true;this.initScrollArea();if((this.getFloating()&&this.getResponsive())||this._bUsePagination){this._height=-1;this._itemsPerRow=-1;this.onresize();this.sResizeListenerId=R.register(this.getDomRef(),q.proxy(this.onresize,this));}};
a.prototype.onThemeChanged=function(){if(this._bRendered){this.calculateItemCounts();this.getParent().updateItems(sap.ui.model.ChangeReason.Change);}};
a.prototype.onresize=function(){if(!this.getDomRef()){if(this.sResizeListenerId){R.deregister(this.sResizeListenerId);this.sResizeListenerId=null;}return;}if(this.getFloating()&&this.getResponsive()){this._computeWidths();}if(this._bUsePagination&&this.items.length>0){this.calculateItemCounts();this.getParent().updateItems(sap.ui.model.ChangeReason.Change);}};
a.prototype.setTemplate=function(t){this.setAggregation("template",t,true);if(this.getParent()){this.getParent().updateItems();}};
a.prototype.calculateItemCounts=function(){if(this.getDomRef()&&sap.ui.getCore().isThemeApplied()){var $=this.$(),b=$.children().first();this._iItemsPerRow=Math.floor($.outerWidth(true)/b.outerWidth(true));this._iNewRows=Math.ceil(this.getReloadItemCount()/this._iItemsPerRow);this._iNewItems=this._iItemsPerRow*this._iNewRows;this._iRowHeight=b.outerHeight(true);this._iScrollTrigger=this._iNewRows*this._iRowHeight;}};
a.prototype._computeWidths=function(i){var t=this.$();var I=Math.floor(t.width()/this.getItemMinWidth());var b=Math.floor(100/I);if(t.width()*b/100<this.getItemMinWidth()){I--;b=Math.floor(100/I);}if(i||this._height!=t.height()||this._itemsPerRow!=I){var c=-1;var d=this.getParent().getItems();var e,w;for(var j=0;j<d.length;j++){if(c==-1||c+1>I){c=0;e=100-(I*b);}var w=b;if(e>0){w++;e--;}d[j].$().css("width",w+"%");c++;}this._height=t.height();this._itemsPerRow=I;}};
a.prototype.setScrollArea=function(s,S){if(typeof s!=='string'&&!(s instanceof q)){q.sap.log.error('You can only pass a string (ID of scroll area DOM) or a jQuery object as scrollarea');}this.setProperty('scrollArea',s,S);};
return a;},true);
sap.ui.predefine('sap/ui/ux3/DataSetSimpleViewRenderer',['jquery.sap.global'],function(q){"use strict";var D={};
D.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiUx3DSSV");if(c.getFloating()){if(c.getResponsive()){a.addClass("sapUiUx3DSSVResponsive");}else{a.addClass("sapUiUx3DSSVFloating");}}else{a.addClass("sapUiUx3DSSVSingleRow");}if(c.getHeight()){a.addStyle("height",c.getHeight());a.addClass("sapUiUx3DSSVSA");}a.writeClasses();a.writeStyles();a.write(">");if(c.items){for(var i=0;i<c.items.length;i++){this.renderItem(a,c,c.items[i]);}}a.write("</div>");};
D.renderItem=function(r,c,i){r.write("<div");r.addClass("sapUiUx3DSSVItem");if(c.getFloating()){r.addClass("sapUiUx3DSSVFlow");if(c.getItemMinWidth()>0){r.writeAttribute("style","min-width:"+c.getItemMinWidth()+"px");}}if(c.isItemSelected(i)){r.addClass("sapUiUx3DSSVSelected");}r.writeClasses();r.writeElementData(i);r.write(">");r.renderControl(i.getAggregation("_template"));r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/ui/ux3/Exact',['jquery.sap.global','sap/ui/commons/Button','sap/ui/commons/Menu','sap/ui/commons/SearchField','sap/ui/commons/TextView','sap/ui/core/Control','./ExactArea','./ExactAttribute','./ExactBrowser','./library',"./ExactRenderer"],function(q,B,M,S,T,C,E,a,b,l,c){"use strict";
var d=C.extend("sap.ui.ux3.Exact",{metadata:{library:"sap.ui.ux3",properties:{resultText:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"attributes",aggregations:{settingsMenu:{type:"sap.ui.commons.Menu",multiple:false,forwarding:{idSuffix:"-browser",aggregation:"optionsMenu"}},attributes:{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute",forwarding:{idSuffix:"-browser",aggregation:"attributes"}},controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"}},events:{search:{parameters:{query:{type:"string"}}},refineSearch:{parameters:{query:{type:"string"},changedAttribute:{type:"sap.ui.ux3.ExactAttribute"},allSelectedAttributes:{type:"object"}}}}}});
(function(){
d.prototype.init=function(){var t=this;this._searchArea=new E(this.getId()+"-searchArea",{toolbarVisible:false});this._searchArea.addStyleClass("sapUiUx3ExactSearchArea");this.addAggregation("controls",this._searchArea);this._search_input=new S(this.getId()+"-searchTF",{enableListSuggest:false});this._search_input.attachSearch(function(o){_(t,o);});this._search_input.addStyleClass("sapUiUx3ExactSearchText");this._searchArea.addContent(this._search_input);this._browser=new b(this.getId()+"-browser",{title:"Attributes"});this._browser.addStyleClass("sapUiUx3ExactBrowseArea");this.addAggregation("controls",this._browser);this._browser.attachAttributeSelected(function(o){e(t,o);});this._resultArea=new E(this.getId()+"-resultArea");this.addAggregation("controls",this._resultArea);this._resultText=new T(this.getId()+"-resultAreaTitle",{design:sap.ui.commons.TextViewDesign.Bold});this._resultText.addStyleClass("sapUiUx3ExactViewTitle");this.addAggregation("controls",this._resultText);this._bDetailsVisible=false;};
d.prototype.getResultText=function(){return this._resultText.getText();};
d.prototype.setResultText=function(r){this._resultText.setText(r);return this;};
d.prototype.getResultArea=function(){return this._resultArea;};
d.prototype.getSearchField=function(){return this._search_input;};
var _=function(t,o){t._sSearchQuery=o.getParameter("query");t.fireSearch({query:t._sSearchQuery});t._bDetailsVisible=true;t.invalidate();};var e=function(t,o){t.fireRefineSearch({query:t._sSearchQuery,changedAttribute:o.getParameter("attribute"),allSelectedAttributes:o.getParameter("allAttributes")});};}());return d;},true);
sap.ui.predefine('sap/ui/ux3/ExactArea',['jquery.sap.global','sap/ui/commons/Toolbar','sap/ui/core/Control','./library',"./ExactAreaRenderer"],function(q,T,C,l,E){"use strict";
var a=C.extend("sap.ui.ux3.ExactArea",{metadata:{library:"sap.ui.ux3",properties:{toolbarVisible:{type:"boolean",group:"Appearance",defaultValue:true}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},toolbarItems:{type:"sap.ui.commons.ToolbarItem",multiple:true,singularName:"toolbarItem"}}}});
(function(){
sap.ui.core.Element.extend("sap.ui.ux3.ExactAreaToolbarTitle",{metadata:{interfaces:["sap.ui.commons.ToolbarItem"],properties:{text:{name:"text",type:"string",group:"Appearance",defaultValue:''}}}});
}());return a;},true);
sap.ui.predefine('sap/ui/ux3/ExactAreaRenderer',['jquery.sap.global'],function(q){"use strict";var E={};
E.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiUx3ExactArea");a.writeClasses();a.write(">");if(c.getToolbarVisible()){a.write("<div id=\""+c.getId()+"-tb\" class=\"sapUiTb sapUiTbDesignFlat sapUiTbStandalone\" role=\"toolbar\">");a.write("<div class=\"sapUiTbCont\"><div class=\"sapUiTbInner\">");var t=c.getToolbarItems();for(var i=0;i<t.length;i++){var T=t[i];if(T instanceof sap.ui.commons.ToolbarSeparator){sap.ui.commons.ToolbarRenderer.renderSeparator(a,T);}else if(T instanceof sap.ui.ux3.ExactAreaToolbarTitle){a.write("<div class=\"sapUiUx3ExactAreaTbTitle\">"+q.sap.encodeHTML(T.getText())+"</div>");}else{a.renderControl(T);}}a.write("</div></div></div>");}a.write("<div id=\""+c.getId()+"-ct\" class=\"sapUiUx3ExactAreaCont\">");var C=c.getContent();for(var i=0;i<C.length;i++){a.renderControl(C[i]);}a.write("</div>");a.write("</div>");};
return E;},true);
sap.ui.predefine('sap/ui/ux3/ExactAttribute',['jquery.sap.global','sap/ui/core/Element','./library'],function(q,E,l){"use strict";
var a=E.extend("sap.ui.ux3.ExactAttribute",{metadata:{library:"sap.ui.ux3",properties:{text:{type:"string",group:"Misc",defaultValue:null},selected:{type:"boolean",group:"Misc",defaultValue:null},width:{type:"int",group:"Misc",defaultValue:168},listOrder:{type:"sap.ui.ux3.ExactOrder",defaultValue:sap.ui.ux3.ExactOrder.Select},showSubAttributesIndicator:{type:"boolean",group:"Misc",defaultValue:true},additionalData:{type:"object",group:"Misc",defaultValue:null},supplyActive:{type:"boolean",group:"Misc",defaultValue:true},autoActivateSupply:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute"}},events:{supplyAttributes:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"}}}}}});
(function(){a._MINWIDTH=70;a._MAXWIDTH=500;
a.prototype.init=function(){this._getAttributesCallCount=0;};
a.prototype.scrollTo=function(A){if(!(A instanceof a)){this._scrollToAttributeId=undefined;return;}var L=this.getChangeListener();if(L){L=sap.ui.getCore().byId(L.id);if(L&&L._lb){var i=this.indexOfAttribute(A);if(i>=0){L._lb.scrollToIndex(i,true);}this._scrollToAttributeId=undefined;return;}}this._scrollToAttributeId=A.getId();};
a.prototype.setText=function(t){this.setProperty("text",t,true);this._handleChange(this,"text");return this;};
a.prototype.setWidth=function(w){this._setWidth(w);this._handleChange(this,"width");return this;};
a.prototype.setTooltip=function(t){E.prototype.setTooltip.apply(this,arguments);this._handleChange(this,"tooltip",true);return this;};
a.prototype.setSelected=function(s){this.setProperty("selected",s,true);if(!this.getSelected()){this._clearSelection();}this._handleChange(this,"selected");return this;};
a.prototype.setSupplyActive=function(s){this.setProperty("supplyActive",s,true);return this;};
a.prototype.setAutoActivateSupply=function(A){this.setProperty("autoActivateSupply",A,true);return this;};
a.prototype.setAdditionalData=function(A){this.setProperty("additionalData",A,true);return this;};
a.prototype.setListOrder=function(L){this.setProperty("listOrder",L,true);this._handleChange(this,"order");return this;};
a.prototype.getAttributes=function(){this._getAttributesCallCount++;if(this._getAttributesCallCount>1){this.setSupplyActive(false);}if(this.hasListeners("supplyAttributes")&&this.getSupplyActive()){this._bSuppressChange=true;this._bChangedHappenedDuringSuppress=false;this.fireSupplyAttributes({attribute:this});this.setSupplyActive(false);this._bSuppressChange=undefined;if(this._bChangedHappenedDuringSuppress){this._handleChange(this,"attributes");}this._bChangedHappenedDuringSuppress=undefined;}this._getAttributesCallCount--;return this.getAttributesInternal();};
a.prototype.insertAttribute=function(A,i){this.insertAggregation("attributes",A,i,true);this._handleChange(this,"attributes");this.setSupplyActive(false);return this;};
a.prototype.addAttribute=function(A){this.addAggregation("attributes",A,true);this._handleChange(this,"attributes");this.setSupplyActive(false);return this;};
a.prototype.removeAttribute=function(e){var A=this.removeAggregation("attributes",e,true);if(A){A.setChangeListener(null);this._handleChange(this,"attributes");}return A;};
a.prototype.removeAllAttributes=function(){var A=this.getAttributesInternal();for(var i=0;i<A.length;i++){A[i].setChangeListener(null);}var r=this.removeAllAggregation("attributes",true);if(A.length>0){this._handleChange(this,"attributes");}return r;};
a.prototype.destroyAttributes=function(){var A=this.getAttributesInternal();for(var i=0;i<A.length;i++){A[i].setChangeListener(null);}this.destroyAggregation("attributes",true);if(A.length>0){this._handleChange(this,"attributes");}return this;};
a.prototype.getShowSubAttributesIndicator_Computed=function(){return this.hasListeners("supplyAttributes")&&this.getSupplyActive()?this.getShowSubAttributesIndicator():this.getAttributesInternal().length>0;};
a.prototype.attachSupplyAttributes=function(d,f,L){this.attachEvent("supplyAttributes",d,f,L);if(this.getSelected()){this.getAttributesInternal(true);}return this;};
a.prototype._setProperty_Orig=a.prototype.setProperty;
a.prototype.setProperty=function(p,v,s){this._setProperty_Orig(p,v,s);if(p=="selected"){if(v){this.getAttributesInternal(true);}else{if(this.getAutoActivateSupply()){this.setSupplyActive(true);}}}return this;};
a.prototype.setChangeListener=function(c){this._oChangeListener=c;};
a.prototype.getChangeListener=function(c){return this._oChangeListener;};
a.prototype.getAttributesInternal=function(f){return f?this.getAttributes():this.getAggregation("attributes",[]);};
a.prototype._handleChange=function(s,t){if(this._bSuppressChange){this._bChangedHappenedDuringSuppress=true;return;}if(this.getChangeListener()){this.getChangeListener()._notifyOnChange(t,s);}else if(this.getParent()&&this.getParent()._handleChange){this.getParent()._handleChange(s,t);}};
a.prototype._clearSelection=function(){this.setProperty("selected",false,true);var v=this.getAttributesInternal();for(var i=0;i<v.length;i++){v[i]._clearSelection();}};
a.prototype._setWidth=function(w){w=Math.round(a._checkWidth(w));this.setProperty("width",w,true);};
a._checkWidth=function(w){w=Math.max(w,a._MINWIDTH);w=Math.min(w,a._MAXWIDTH);return w;};
}());return a;},true);
sap.ui.predefine('sap/ui/ux3/ExactBrowser',['jquery.sap.global','sap/ui/commons/Button','sap/ui/commons/Menu','sap/ui/core/Control','./ExactAttribute','./ExactList','./library',"./ExactBrowserRenderer"],function(q,B,M,C,E,a,l,b){"use strict";
var c=C.extend("sap.ui.ux3.ExactBrowser",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},headerTitle:{type:"string",group:"Misc",defaultValue:null},topListOrder:{type:"sap.ui.ux3.ExactOrder",defaultValue:sap.ui.ux3.ExactOrder.Select},enableListClose:{type:"boolean",group:"Misc",defaultValue:false},listHeight:{type:"int",group:"Appearance",defaultValue:290},showHeader:{type:"boolean",group:"Misc",defaultValue:false},showTopList:{type:"boolean",group:"Misc",defaultValue:true},enableReset:{type:"boolean",group:"Misc",defaultValue:true},enableSave:{type:"boolean",group:"Misc",defaultValue:false},topListWidth:{type:"int",group:"Misc",defaultValue:168}},defaultAggregation:"attributes",aggregations:{attributes:{type:"sap.ui.ux3.ExactAttribute",multiple:true,singularName:"attribute",forwarding:{idSuffix:"-rootAttribute",aggregation:"attributes"}},optionsMenu:{type:"sap.ui.commons.Menu",multiple:false},controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"},rootAttribute:{type:"sap.ui.core.Element",multiple:false,visibility:"hidden"}},associations:{followUpControl:{type:"sap.ui.core.Control",multiple:false}},events:{attributeSelected:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"},allAttributes:{type:"object"}}},save:{}}}});
(function(){
c.prototype.init=function(){var t=this;this.data("sap-ui-fastnavgroup","true",true);this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._attributeRoot=new E(this.getId()+"-rootAttribute");this.setAggregation("rootAttribute",this._attributeRoot);this._rootList=new a(this.getId()+"-rootlist");this._rootList.setData(this._attributeRoot);this.addAggregation("controls",this._rootList);this._resetButton=new B(this.getId()+"-RstBtn",{text:this._rb.getText("EXACT_BRWSR_RESET"),lite:true});this._resetButton.addStyleClass("sapUiUx3ExactBrwsrReset");this.addAggregation("controls",this._resetButton);this._resetButton.attachPress(function(){t.reset();});this._saveButton=new B(this.getId()+"-SvBtn",{text:this._rb.getText("EXACT_BRWSR_SAVE"),lite:true});this._saveButton.addStyleClass("sapUiUx3ExactBrwsrSave");this.addAggregation("controls",this._saveButton);this._saveButton.attachPress(function(){t.fireSave();});this._rootList.attachAttributeSelected(function(e){t.fireAttributeSelected({attribute:e.getParameter("attribute"),allAttributes:e.getParameter("allAttributes")});});this._rootList.attachEvent("_headerPress",function(e){var m=t.getOptionsMenu();if(m){var d=e.getParameter("domRef");m.open(e.getParameter("keyboard"),d,sap.ui.core.Popup.Dock.BeginTop,sap.ui.core.Popup.Dock.BeginBottom,d);}});};
c.prototype.exit=function(){this._rootList.destroy();this._attributeRoot.destroy();this._rootList=null;this._attributeRoot=null;this._resetButton=null;this._saveButton=null;this._saveDialog=null;this._saveTextField=null;this._rb=null;};
c.prototype.onThemeChanged=function(e){if(this.getDomRef()){this.invalidate();}};
c.prototype.getTitle=function(){return this._rootList.getTopTitle();};
c.prototype.setTitle=function(t){this._rootList.setTopTitle(t);return this;};
c.prototype.setTopListOrder=function(L){this.setProperty("topListOrder",L,true);this._attributeRoot.setListOrder(L);return this;};
c.prototype.getTopListWidth=function(){return this._attributeRoot.getWidth();};
c.prototype.setTopListWidth=function(w){this._attributeRoot.setWidth(w);return this;};
c.prototype.getHeaderTitle=function(){var t=this.getProperty("headerTitle");return t?t:this._rb.getText("EXACT_BRWSR_TITLE");};
c.prototype.getEnableListClose=function(){return this._rootList.getShowClose();};
c.prototype.setEnableListClose=function(e){this._rootList.setShowClose(e);return this;};
c.prototype.getListHeight=function(){return this._rootList.getTopHeight();};
c.prototype.setListHeight=function(L){this._rootList.setTopHeight(L);return this;};
c.prototype.reset=function(){this._rootList._closeAll();};
c.prototype.hasOptionsMenu=function(){return!!this.getOptionsMenu();};
}());return c;},true);
sap.ui.predefine('sap/ui/ux3/ExactBrowserRenderer',['jquery.sap.global'],function(q){"use strict";var E={};
E.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiUx3ExactBrwsr");a.writeClasses();a.writeAttribute("role","region");if(c.getShowHeader()){a.writeAttribute("aria-labelledby",c.getId()+"-hdtitle");}if(c.getFollowUpControl()){a.writeAttribute("aria-controls",c.getFollowUpControl());}var t=c.getTooltip_AsString();if(t){a.writeAttributeEscaped("title",t);}a.write(">");if(c.getShowHeader()){a.write("<div class=\"sapUiUx3ExactBrwsrHd\"><h2 id=\""+c.getId()+"-hdtitle\">");a.write(q.sap.encodeHTML(c.getHeaderTitle()));a.write("</h2><div class=\"sapUiUx3ExactBrwsrHdTool\" role=\"toolbar\">");if(c.getEnableSave()){a.renderControl(c._saveButton);}if(c.getEnableReset()){a.renderControl(c._resetButton);}a.write("</div></div>");}a.renderControl(c._rootList);a.write("</div>");};
return E;},true);
sap.ui.predefine('sap/ui/ux3/ExactList',['jquery.sap.global','sap/ui/commons/ListBox','sap/ui/core/Control','sap/ui/core/Popup','sap/ui/core/theming/Parameters','./library',"./ExactListRenderer",'jquery.sap.dom'],function(q,L,C,P,a,l,E){"use strict";
var b=C.extend("sap.ui.ux3.ExactList",{metadata:{library:"sap.ui.ux3",properties:{showClose:{type:"boolean",group:"Misc",defaultValue:false},topTitle:{type:"string",group:"Misc",defaultValue:null},topHeight:{type:"int",group:"Appearance",defaultValue:290}},aggregations:{subLists:{type:"sap.ui.ux3.ExactList",multiple:true,singularName:"subList"},controls:{type:"sap.ui.commons.ListBox",multiple:true,singularName:"control",visibility:"hidden"}},associations:{data:{type:"sap.ui.ux3.ExactAttribute",multiple:false}},events:{attributeSelected:{parameters:{attribute:{type:"sap.ui.ux3.ExactAttribute"},allAttributes:{type:"object"}}}}}});
(function(){
L.extend("sap.ui.ux3.ExactList.LB",{
init:function(){L.prototype.init.apply(this,arguments);this.setAllowMultiSelect(true);this.setDisplayIcons(true);this.addStyleClass("sapUiUx3ExactLstLb");},
invalidate:function(){L.prototype.invalidate.apply(this,arguments);if(!this.bInvalidated&&this.getParent()){this.getParent().invalidate();}this.bInvalidated=true;},
_handleUserActivation:function(i){i.metaKey=true;L.prototype._handleUserActivation.apply(this,[i]);},
onclick:function(i){L.prototype.onclick.apply(this,arguments);this.getParent().onclick(i);},
onAfterRendering:function(){L.prototype.onAfterRendering.apply(this,arguments);this.bInvalidated=false;var s=this.getParent();var G=this.getItems();var I=s._isTop();var H=false;for(var i=0;i<G.length;i++){var J=G[i];var K=sap.ui.getCore().byId(J.getKey());var M=J.$();H=false;if(I||(!K||!K.getShowSubAttributesIndicator_Computed())){M.addClass("sapUiUx3ExactLstNoIco");H=I;}else{H=true;}if(H&&!I){M.attr("aria-label",s._rb.getText(M.hasClass("sapUiLbxISel")?"EXACT_LST_LIST_ITEM_SEL_ARIA_LABEL":"EXACT_LST_LIST_ITEM_ARIA_LABEL",[J.getText()]));}}var N=s._bRTL?"left":"right";q(".sapUiLbxITxt",this.getDomRef()).css("margin-"+N,20+q.sap.scrollbarSize().width+"px");q(".sapUiLbxIIco",this.getDomRef()).css(N,5+q.sap.scrollbarSize().width+"px");q(this.getDomRef()).attr("tabindex","-1");var O;if(I){O=s.getTopTitle();}else{O=s._rb.getText("EXACT_LST_LIST_ARIA_LABEL",[s._iLevel,s._getAtt().getText()]);}q(this.getFocusDomRef()).attr("aria-label",O).attr("aria-expanded","true");this.oItemNavigation.iActiveTabIndex=-1;this.oItemNavigation.setSelectedIndex(-1);this.oItemNavigation.onsapnext=function(Q){if(Q.keyCode!=q.sap.KeyCodes.ARROW_DOWN){return;}sap.ui.core.delegate.ItemNavigation.prototype.onsapnext.apply(this,arguments);};this.oItemNavigation.onsapprevious=function(Q){if(Q.keyCode!=q.sap.KeyCodes.ARROW_UP){return;}sap.ui.core.delegate.ItemNavigation.prototype.onsapprevious.apply(this,arguments);};},
renderer:"sap.ui.commons.ListBoxRenderer"
});
b.prototype.init=function(){var i=this;this._iLevel=0;this._bCollapsed=false;this._bIsFirstRendering=true;this._rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._lb=new b.LB(this.getId()+"-lb",{select:function(s){p(i);var K=s.getParameter("selectedItem").getKey();var G=sap.ui.getCore().byId(K);var S=s.getParameter("selectedIndex");if(i._lb.isIndexSelected(S)){G.setProperty("selected",true,true);var H=z(i,G);if(H){var I=h(i,G);if(I<0){i.addSubList(H);}else{i.insertSubList(H,I);}}}else{A(i,G,S);}D(i)._selectionChanged(G);}});this.addAggregation("controls",this._lb);this._closeHandle=q.proxy(this.onForceVerticalClose,this);};
b.prototype.exit=function(){if(this.bIsDestroyed){return;}B(this);this._lb.removeAllItems();this._lb=null;this._closeHandle=null;this._scrollCheckHandle=null;this._rb={getText:function(){return"";}};this._oTopList=null;if(this._dirtyListsCleanupTimer){q.sap.clearDelayedCall(this._dirtyListsCleanupTimer);this._dirtyListsCleanupTimer=null;this._dirtyLists=null;}};
b.prototype.getFocusDomRef=function(){if(this._isTop()&&this.$().hasClass("sapUiUx3ExactLstTopHidden")){return this.getDomRef("foc");}return this._bCollapsed?this.getDomRef("head"):this._lb.getFocusDomRef();};
b.prototype.onBeforeRendering=function(){this._oTopList=null;if(!this._bIsFirstRendering){return;}this._bRTL=sap.ui.getCore().getConfiguration().getRTL();if(!this._isTop()){this._bCollapsed=true;this._oCollapseStyles={"cntnt":"margin-"+(this._bRTL?"right":"left")+":"+a.get("sapUiUx3ExactLstCollapseWidth")+";border-top-width:0px;","lst":"width:0px;"};}else{this._bIsFirstRendering=false;}};
b.prototype.onAfterRendering=function(){var i=this;var I=this._isTop();if(!this._iCurrentWidth){this._iCurrentWidth=this._getAtt().getWidth();}if(I){this._iScrollWidthDiff=-1;this.onCheckScrollbar();this.$("lst").css("bottom",q.sap.scrollbarSize().height+"px");this.$("cntnt").bind("scroll",function(s){if(s.target.id===i.getId()+"-cntnt"&&s.target.scrollTop!=0){s.target.scrollTop=0;}});}if(!this._bCollapsed){n(this,this._iCurrentWidth);}p(this);if(this._bIsFirstRendering){this._bIsFirstRendering=false;v(this,false,null,true);}else{r(this);w(this);}if(this._bRefreshList){this._bRefreshList=false;setTimeout(function(){i._lb.invalidate();},0);}};
b.prototype.onfocusin=function(i){if(i.target===this.getDomRef()){this.getFocusDomRef().focus();}var $=this.$("head");if(this._isTop()){$.attr("tabindex","-1");this.$("foc").attr("tabindex","-1");if(!d(this)&&i.target===$[0]){this.getFocusDomRef().focus();}if(this.$().hasClass("sapUiUx3ExactLstTopHidden")&&i.target===this.getDomRef("foc")){var s=this.getSubLists();if(s.length>0){s[0].getFocusDomRef().focus();}}}if(!i.__exactHandled){$.addClass("sapUiUx3ExactLstHeadFocus");i.__exactHandled=true;}};
b.prototype.onfocusout=function(i){var $=this.$("head");if(this._isTop()){$.attr("tabindex","0");this.$("foc").attr("tabindex","0");}$.removeClass("sapUiUx3ExactLstHeadFocus");};
b.prototype.onclick=function(i){var s=this._lb.getScrollTop();if(q(i.target).attr("id")==this.getId()+"-exp"){x(this);this.focus();i.stopPropagation();}else if(q(i.target).attr("id")==this.getId()+"-close"){y(this);}else if(q(i.target).attr("id")==this.getId()+"-hide"){v(this,!this._bCollapsed,i);}else if(this._isTop()&&d(this)&&q.sap.containsOrEquals(this.$("head")[0],i.target)){f(this,i,false);return;}else if(!q.sap.containsOrEquals(this.$("cntnt")[0],i.target)){this.focus();}this._lb.setScrollTop(s);};
b.prototype.onkeydown=function(i){function _(i,T){if(q(T).hasClass("sapUiUx3ExactLstFoc")){return;}if(T){T.focus();}i.preventDefault();i.stopPropagation();}switch(i.keyCode){case q.sap.KeyCodes.ENTER:case q.sap.KeyCodes.SPACE:if(this._isTop()&&d(this)&&q.sap.containsOrEquals(this.$("head")[0],i.target)){f(this,i,true);}break;case q.sap.KeyCodes.DELETE:if(!this._isTop()&&this.getShowClose()){y(this);_(i,this.getParent().getFocusDomRef());}break;case q.sap.KeyCodes.NUMPAD_MINUS:if(i.shiftKey){if(!this._bCollapsed){n(this,this._iCurrentWidth-10);_(i);}}else if(!this._bCollapsed){v(this,true,i);}break;case q.sap.KeyCodes.NUMPAD_PLUS:if(i.shiftKey){if(!this._bCollapsed){n(this,this._iCurrentWidth+10);_(i);}}else if(this._bCollapsed){v(this,false,i);}break;case q.sap.KeyCodes.TAB:if(this._iLevel==0){var H=d(this);if(!i.shiftKey&&H&&q.sap.containsOrEquals(this.$("head")[0],i.target)){_(i,this.getFocusDomRef());}else if(q.sap.containsOrEquals(this.getFocusDomRef(),i.target)){if(i.shiftKey&&H){_(i,this.$("head")[0]);}else if(!i.shiftKey){var s=c(this);if(s){_(i,s.getFocusDomRef());}}}return;}if(this._iLevel==1){var s=null;if(i.shiftKey){if(q.sap.containsOrEquals(this.$("cntnt")[0],i.target)){s=this;}else{s=g(this);}}else{s=c(this);}if(s){_(i,s.getFocusDomRef());}i.stopPropagation();}break;case q.sap.KeyCodes.ARROW_LEFT:case q.sap.KeyCodes.ARROW_RIGHT:var s=null;if(this._iLevel>=1){if((this._bRTL&&i.keyCode===q.sap.KeyCodes.ARROW_LEFT)||(!this._bRTL&&i.keyCode===q.sap.KeyCodes.ARROW_RIGHT)){s=c(this,true);}else{s=g(this,true);}if(s){_(i,s.getFocusDomRef());}i.stopPropagation();}break;}};
b.prototype.onmousedown=function(i){if(i.target.id===this.getId()+"-rsz"){q(document.body).append("<div id=\""+this.getId()+"-ghost\" class=\"sapUiUx3ExactLstRSzGhost\" style =\" z-index:"+P.getNextZIndex()+"\" ></div>");q(document.body).bind("selectstart."+this.getId(),o);var H=!!sap.ui.Device.browser.internet_explorer?q(document.body):this.$("ghost");H.bind("mouseup."+this.getId(),q.proxy(m,this)).bind("mousemove."+this.getId(),q.proxy(k,this));this._iStartDragX=i.pageX;this._iStartWidth=this.$("lst").width();this.$("rsz").addClass("sapUiUx3ExactLstRSzDrag");}};
b.prototype.onForceVerticalClose=function(i){if(i.type=="mousedown"||i.type=="click"||i.type=="dblclick"||i.type=="focusin"||i.type=="focusout"||i.type=="keydown"||i.type=="keypress"||i.type=="keyup"||i.type=="mousedown"||i.type=="mouseup"){var R=this.$("lst");if(!q.sap.containsOrEquals(R[0],i.target)||i.target.tagName=="BODY"){if(R.hasClass("sapUiUx3ExactLstExpanded")){this._oPopup.close(true);}}}};
b.prototype.onCheckScrollbar=function(i){this._scrollCheckTimer=null;var s=this.$("cntnt");var G=s[0];if(G){var N=G.scrollWidth-G.clientWidth;if(this._iScrollWidthDiff!=N){this._iScrollWidthDiff=N;if(N<=0){s.css({"overflow-x":"hidden","bottom":q.sap.scrollbarSize().height+"px"});}else{s.css({"overflow-x":"scroll","bottom":"0px"});}}this._scrollCheckTimer=q.sap.delayedCall(300,this,this.onCheckScrollbar);}};
b.prototype.insertSubList=function(s,i){this.insertAggregation("subLists",s,i);if(s){t(s,this._iLevel+1);}return this;};
b.prototype.addSubList=function(s){this.addAggregation("subLists",s);if(s){t(s,this._iLevel+1);}return this;};
b.prototype.setData=function(s){if(s!=null&&typeof(s)!="string"){s=s.getId();}if(s){this.setAssociation("data",s);s=this._getAtt();this._lb.removeAllItems();if(!s){return this;}var G=s.getAttributesInternal(true);var S=[];var H=[];for(var i=0;i<G.length;i++){var I=F(G[i]);this._lb.addItem(I);if(G[i].getSelected()){var J=z(this,G[i]);if(J){H.push(J);}S.push(I.getKey());}}this._lb.setSelectedKeys(S);var O=this.getSubLists();for(var i=0;i<O.length;i++){var K=q.inArray(O[i],H);if(K>=0){if(s.getListOrder()!=sap.ui.ux3.ExactOrder.Fixed){H.splice(K,1);}}else{O[i]._lb.removeAllItems();O[i].destroy();}}if(s.getListOrder()===sap.ui.ux3.ExactOrder.Fixed){this.removeAllSubLists();}for(var i=0;i<H.length;i++){this.addSubList(H[i]);}var M=this;s.setChangeListener({id:M.getId(),_notifyOnChange:function(T,N){if(T==="width"){if(M._getAtt()===N&&M.getDomRef()){n(M,N.getWidth());}return;}var Q=D(M);if(!Q._dirtyLists){Q._dirtyLists={};}if(!Q._dirtyLists[M.getId()]){Q._dirtyLists[M.getId()]=M;}if(!Q._dirtyListsCleanupTimer){Q._dirtyListsCleanupTimer=q.sap.delayedCall(0,Q,function(){this._dirtyListsCleanupTimer=null;q.each(this._dirtyLists,function(i,J){if(J._lb&&J.getParent()){if(!J._isTop()){J.getParent().setData(J.getParent().getData());}else{J.setData(J.getData());}}});this._dirtyLists=null;},[]);}}});}return this;};
b.prototype.setShowClose=function(s){if(this._isTop()){this.setProperty("showClose",s);}return this;};
b.prototype.getShowClose=function(){return D(this).getProperty("showClose");};
b.prototype.getTopTitle=function(){var T=this.getProperty("topTitle");return T?T:this._rb.getText("EXACT_BRWSR_LST_TITLE");};
b.prototype._getAtt=function(){return sap.ui.getCore().byId(this.getData());};
b.prototype._isTop=function(){return!(this.getParent()instanceof b);};
b.prototype._selectionChanged=function(i){if(!this._isTop()){return;}i=sap.ui.getCore().byId(i.getId());var _=function(H,R){if(!H.getSelected()){return;}R.push(H);var V=H.getAttributesInternal();for(var G=0;G<V.length;G++){_(V[G],R);}};var s=[];var T=this._getAtt().getAttributesInternal();for(var G=0;G<T.length;G++){_(T[G],s);}this.fireAttributeSelected({attribute:i,allAttributes:s});};
b.prototype._closeAll=function(){if(!this._isTop()){return;}var s=this;var G=function(){s._getAtt()._clearSelection();s._lb.clearSelection();s.fireAttributeSelected({attribute:undefined,allAttributes:[]});};var H=this.getSubLists();if(H.length>0){for(var i=0;i<H.length;i++){y(H[i],true,i==H.length-1?G:null);}}else{G();}};
var g=function(i,s){function G(K){var M=K.getParent();var N=M.getSubLists();var O=M.indexOfSubList(K)-1;if(O>=0){return N[O];}return null;}function H(K){var S=K.getSubLists();if(S.length>0){return H(S[S.length-1]);}return K;}if(i._iLevel==0){return null;}else if(i._iLevel==1){if(s){return null;}var I=G(i);if(I){return I;}return i.getParent();}else if(i._iLevel>1){var I=G(i);if(I){return H(I);}var J=i.getParent();if(J._iLevel>=1){return J;}}return null;};var c=function(i,s){function G(J){var K=J.getParent();var M=K.getSubLists();var O=K.indexOfSubList(J)+1;if(O<M.length){return M[O];}return null;}function H(J){var S=J.getSubLists();if(S.length>0){return S[0];}return null;}function I(J){var K=G(J);if(K){return K;}var M=J.getParent();if(M._iLevel>(s?1:0)){return I(M);}else{return null;}}if(i._iLevel==0){return H(i);}else if(i._iLevel==1){return s?H(i):G(i);}else if(i._iLevel>1){var N=H(i);if(N){return N;}return I(i);}return null;};var f=function(i,s,K){i.fireEvent("_headerPress",{kexboard:K,domRef:i.$("head")});s.stopPropagation();};var d=function(i){return!e(i)&&i.$().hasClass("sapUiUx3ExactLstTopActive");};var e=function(i){return i.$().hasClass("sapUiUx3ExactLstTopHidden");};var h=function(s,G){if(s._getAtt().getListOrder()!=sap.ui.ux3.ExactOrder.Fixed){return-1;}var H=s._getAtt().getAttributes();var I=0;for(var i=0;i<H.length;i++){if(H[i]===G){break;}if(H[i].getChangeListener()){I++;}}return I;};var r=function(i){if(u(i)){i.$("lst").addClass("sapUiUx3ExactLstLstExp");if(!i._oPopup){var s=function(G){i._handleEvent(G);};i._oPopup=new P();if(!sap.ui.Device.browser.firefox){i._oPopup._fixPositioning=function(G,R){P.prototype._fixPositioning.apply(this,arguments);if(R){var $=this._$();var O=q(G.of);var H=0;if(G.offset){H=parseInt(G.offset.split(" ")[0],10);}$.css("right",(q(window).width()-O.outerWidth()-O.offset().left+H)+"px");}};}i._oPopup.open=function(){var G=i.$("lst");j(G,false,-1,function(R){G.addClass("sapUiUx3ExactLstExpanded");i.$("exp").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(true,false));i.__sOldHeight=G.css("height");G.css("height",i.__sOldHeight);var H=i.$("head");var I=q(i._lb.getDomRef());var J=I[0].scrollHeight+i.$("exp").height()+I.outerHeight()-I.height()+1;var M=q(window).height()-parseInt(I.offset().top,10)+q(window).scrollTop()-H.outerHeight();var T=Math.min(J,M);i._oPopup.setContent(G[0]);var O=a.get()["sapUiUx3ExactLst"+(i._isTop()?"Root":"")+"ExpandOffset"]||"0 0";P.prototype.open.apply(i._oPopup,[0,P.Dock.BeginTop,P.Dock.BeginBottom,H[0],O,"none none"]);i._bPopupOpened=true;return T;},function(R){G.addClass("sapUiUx3ExactLstExpandedBL");u(i);i.getFocusDomRef().focus();q.sap.bindAnyEvent(i._closeHandle);R.bind(q.sap.ControlEvents.join(" "),s);});};i._oPopup.close=function(S){var G=i.$("lst");G.removeClass("sapUiUx3ExactLstExpandedBL");j(G,false,i.__sOldHeight,function(R){q.sap.unbindAnyEvent(i._closeHandle);R.unbind(q.sap.ControlEvents.join(" "),s);G.removeClass("sapUiUx3ExactLstExpanded");i.$("exp").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(false,false));},function(R){R.detach();G.removeClass("sapUiShd");R.attr("style","width:"+i._iCurrentWidth+"px;");q(i.getDomRef()).prepend(R);i._oPopup.setContent(null);i._bPopupOpened=undefined;i.__sOldHeight=null;if(i._isTop()){R.css("bottom",q.sap.scrollbarSize().height+"px");}u(i);P.prototype.close.apply(i._oPopup,[0]);if(!S){i.getFocusDomRef().focus();}});};}}};var j=function(R,W,V,i,s){if(i){var G=i(R);if(G!=undefined){V=G;}}var _=s?function(){s(R);}:function(){};if(q.fx.off){if(W){R.width(V);}else{R.height(V);}_();}else{var H=W?{width:V}:{height:V};R.stop(true,true).animate(H,200,'linear',_);}};var o=function(i){i.preventDefault();i.stopPropagation();return false;};var k=function(i){var s=i.pageX;var G=this._bRTL?(this._iStartDragX-s):(s-this._iStartDragX);n(this,this._iStartWidth+G);};var m=function(i){q(document.body).unbind("selectstart."+this.getId()).unbind("mouseup."+this.getId()).unbind("mousemove."+this.getId());this.$("ghost").remove();this.$("rsz").removeClass("sapUiUx3ExactLstRSzDrag");this._iStartWidth=undefined;this._iStartDragX=undefined;this.focus();};var n=function(i,W){W=sap.ui.ux3.ExactAttribute._checkWidth(W);var s=i._bRTL?"right":"left";i._iCurrentWidth=W;i._getAtt()._setWidth(i._iCurrentWidth);i.$("lst").css("width",W+"px");i.$("rsz").css(s,(W-4)+"px");if(i._isTop()){if(!e(i)){i.$("head").css("width",W+"px");i.$("cntnt").css(s,(W+8)+"px");i.$("scroll").css(s,(W+8)+"px");}}else{if(!i.$().hasClass("sapUiUx3ExactLstCollapsed")){i.$("cntnt").css("margin-"+s,W+"px");}}};var p=function(i){var s=i._getAtt();if(s&&!i._isTop()){i.$("head-txt").html(q.sap.encodeHTML(s.getText())+"<span class=\"sapUiUx3ExactLstHeadInfo\">&nbsp;("+i._lb.getSelectedIndices().length+"/"+i._lb.getItems().length+")</span>");}};var t=function(s,G){s._iLevel=G;var H=s.getSubLists();for(var i=0;i<H.length;i++){t(H[i],G+1);}};var u=function(i){if(i._lb){var s=q(i._lb.getDomRef());i.$("lst").removeClass("sapUiUx3ExactLstScroll");if(s.length>0&&s.outerHeight()<s[0].scrollHeight){i.$("lst").addClass("sapUiUx3ExactLstScroll");return true;}}return false;};var v=function(i,s,G,S){if(G){G.preventDefault();G.stopPropagation();}if(i._isTop()){return;}if(i._bCollapsed!=s){var H=!!G;var I={};I["margin-"+(i._bRTL?"right":"left")]=(i._bCollapsed?(i._iCurrentWidth+"px"):a.get("sapUiUx3ExactLstCollapseWidth"));I["border-top-width"]=(i._bCollapsed?a.get("sapUiUx3ExactLstContentTop"):"0px");var $=i.$("cntnt");if(q.fx.off){for(var J in I){$.css(J,I[J]);}}else{$.stop(true,true).animate(I,200,'linear');}if(i._bCollapsed){j(i.$("lst"),true,i._iCurrentWidth+"px",function(){q(i.getDomRef()).removeClass("sapUiUx3ExactLstCollapsed");i.$("head").css("overflow","hidden");},function(R){i.$("hide").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(true,true)).attr("title",i._rb.getText("EXACT_LST_LIST_COLLAPSE"));if(H){i.focus();}var N=i.$("head");i.$("head-txt").removeAttr("style");N.removeAttr("style");R.removeAttr("style");r(i);n(i,i._iCurrentWidth);w(i);N.removeAttr("role");N.removeAttr("aria-label");N.removeAttr("aria-expanded");var O=i._getAtt();if(O&&O._scrollToAttributeId){O.scrollTo(sap.ui.getCore().byId(O._scrollToAttributeId));}});i._oCollapseStyles=undefined;}else{i._oCollapseStyles={};j(i.$("lst"),true,0,null,function(){q(i.getDomRef()).addClass("sapUiUx3ExactLstCollapsed");i.$("hide").html(sap.ui.ux3.ExactListRenderer.getExpanderSymbol(false,true)).attr("title",i._rb.getText("EXACT_LST_LIST_EXPAND"));if(H){i.focus();}w(i);var N=i.$("head");N.attr("role","region");N.attr("aria-label",i._rb.getText("EXACT_LST_LIST_COLL_ARIA_LABEL",[i._iLevel,i._getAtt().getText()]));N.attr("aria-expanded","false");});var K=[];for(var J in I){K.push(J,":",I[J],";");}i._oCollapseStyles["cntnt"]=K.join("");i._oCollapseStyles["lst"]="width:0px;";}i._bCollapsed=!i._bCollapsed;}if(S){return;}var M=i.getParent();if(!i._isTop()&&M&&M._isTop&&!M._isTop()){v(M,s);}};var w=function(s){if(s._bCollapsed){var W=s.$("cntnt").height()-50;var $=s.$("head-txt");$.css("width",W+"px");}var S=s.getSubLists();for(var i=0;i<S.length;i++){w(S[i]);}};var x=function(i){var s=i.$("lst");if(s.hasClass("sapUiUx3ExactLstExpanded")){i._oPopup.close();}else{i._oPopup.open();}};var y=function(i,s,G){var H=function(R){if(!s){var J=i._getAtt();var S=J.getParent().indexOfAttribute(J);A(i.getParent(),J,S,true);p(i.getParent());D(i)._selectionChanged(J);}i.destroy();if(G){G();}};var I=i.getDomRef();if(I){j(q(I),true,0,function(R){R.css("overflow","hidden");},H);}else{H();}};var z=function(i,s){if(s.getSelected()){var G=s.getAttributesInternal(true);if(G.length>0){var S;if(s.getChangeListener()){S=sap.ui.getCore().byId(s.getChangeListener().id);}else{S=new b();}S.setData(s);return S;}}return null;};var A=function(s,G,S,H){s._lb.removeSelectedIndex(S);G._clearSelection();if(!H){var I=s.getSubLists();for(var i=0;i<I.length;i++){if(I[i].getData()===G.getId()){y(I[i],true);}}}};var B=function(i){var s=i._getAtt();if(s&&s.getChangeListener()&&s.getChangeListener().id===i.getId()){s.setChangeListener(null);}};var D=function(i){if(i._isTop()){return i;}if(!i._oTopList){i._oTopList=D(i.getParent());}return i._oTopList;};var F=function(i){var I;if(i.__oItem){I=i.__oItem;if(I.getText()!=i.getText()){I.setText(i.getText());}if(I.getKey()!=i.getId()){I.setKey(i.getId());}}else{I=new sap.ui.core.ListItem({text:i.getText(),key:i.getId()});i.exit=function(){if(sap.ui.ux3.ExactAttribute.prototype.exit){sap.ui.ux3.ExactAttribute.prototype.exit.apply(i,[]);}this.__oItem.destroy();this.__oItem=null;};i.__oItem=I;}return I;};}());return b;},true);
sap.ui.predefine('sap/ui/ux3/ExactListRenderer',['jquery.sap.global'],function(q){"use strict";var E={};
E.render=function(r,c){var a=r;var s=c.getSubLists();var A=c._getAtt();if(!A){return;}var I=c._isTop();a.write("<div");a.writeControlData(c);a.addClass("sapUiUx3ExactLst");var b=false;var t=false;if(I){var B=c.getParent();if(B){if(B.hasOptionsMenu){b=B.hasOptionsMenu();if(b){a.addClass("sapUiUx3ExactLstTopActive");}}if(B.getShowTopList&&!B.getShowTopList()){a.addClass("sapUiUx3ExactLstTopHidden");t=true;}}a.addClass("sapUiUx3ExactLstTop");a.addStyle("height",c.getTopHeight()+"px");}if(c._bCollapsed){a.addClass("sapUiUx3ExactLstCollapsed");}a.addClass("sapUiUx3ExactLstLvl_"+c._iLevel);a.writeClasses();a.writeStyles();a.write(">");if(t){a.write("<div id=\""+c.getId()+"-foc\" class=\"sapUiUx3ExactLstFoc\" tabindex=\"0\"></div>");}if(!c._bPopupOpened){a.write("<div id=\""+c.getId()+"-lst\" class=\"sapUiUx3ExactLstLst\"");if(c._bCollapsed&&c._oCollapseStyles&&c._oCollapseStyles["lst"]){a.write(" style=\""+c._oCollapseStyles["lst"]+"\"");}a.write(">");a.renderControl(c._lb);a.write("<a id=\""+c.getId()+"-exp\" class=\"sapUiUx3ExactLstExp\">"+this.getExpanderSymbol(false,false)+"</a>");a.write("</div>");}else{c._bRefreshList=true;}a.write("<div id=\""+c.getId()+"-cntnt\" ");a.write("class=\"sapUiUx3ExactLstCntnt");if(s.length==0){a.write(" sapUiUx3ExactLstCntntEmpty");}a.write("\"");if(c._bCollapsed&&c._oCollapseStyles&&c._oCollapseStyles["cntnt"]){a.write(" style=\""+c._oCollapseStyles["cntnt"]+"\"");}a.write(">");for(var i=0;i<s.length;i++){a.renderControl(s[i]);}a.write("</div>");a.write("<header id=\""+c.getId()+"-head\" class=\"sapUiUx3ExactLstHead\"");if(I&&b){a.write(" role=\"button\" aria-haspopup=\"true\"");}if(!I&&c._bCollapsed&&A){a.writeAttribute("role","region");a.writeAttribute("aria-expanded","false");a.writeAttributeEscaped("aria-label",c._rb.getText("EXACT_LST_LIST_COLL_ARIA_LABEL",[c._iLevel,A.getText()]));}a.write(" tabindex=\""+(I?"0":"-1")+"\">");if(I){a.write("<h3 id=\""+c.getId()+"-head-txt\" class=\"sapUiUx3ExactLstHeadTopTxt\"><span class=\"sapUiUx3ExactLstHeadTopTxtTxt\">");if(c.getTopTitle()){a.writeEscaped(c.getTopTitle());}a.write("</span>");if(b){a.write("<span class=\"sapUiUx3ExactLstHeadTopIco\"></span>");}a.write("</h3>");}else{a.write("<h3 id=\""+c.getId()+"-head-txt\" class=\"sapUiUx3ExactLstHeadTxt\"");if(A&&A.getTooltip_AsString()){a.writeAttributeEscaped("title",A.getTooltip_AsString());}else if(A&&A.getText()){a.writeAttributeEscaped("title",A.getText());}if(c._bCollapsed&&c._oCollapseStyles&&c._oCollapseStyles["head-txt"]){a.write(" style=\""+c._oCollapseStyles["head-txt"]+"\"");}a.write(">");if(A){a.writeEscaped(A.getText());}a.write("</h3>");a.write("<div id=\""+c.getId()+"-head-action\" class=\"sapUiUx3ExactLstHeadAct"+(c.getShowClose()?"":" sapUiUx3ExactLstHeadActNoClose")+"\">");a.write("<a id=\""+c.getId()+"-hide\" class=\"sapUiUx3ExactLstHide\" role=\"presentation\"");a.writeAttributeEscaped("title",c._rb.getText(c._bCollapsed?"EXACT_LST_LIST_EXPAND":"EXACT_LST_LIST_COLLAPSE"));a.write(">",this.getExpanderSymbol(!c._bCollapsed,true),"</a>");a.write("<a id=\""+c.getId()+"-close\" role=\"presentation\" class=\"sapUiUx3ExactLstClose\"");a.writeAttributeEscaped("title",c._rb.getText("EXACT_LST_LIST_CLOSE"));a.write(">X</a>");a.write("</div>");}a.write("</header>");a.write("<div id=\""+c.getId()+"-rsz\" class=\"sapUiUx3ExactLstRSz\"></div>");a.write("</div>");};
E.getExpanderSymbol=function(e,h){if(h){if(sap.ui.getCore().getConfiguration().getRTL()){return e?"&#9654;":"&#9664;";}else{return e?"&#9664;":"&#9654;";}}else{return e?"&#9650;":"&#9660;";}};
return E;},true);
sap.ui.predefine('sap/ui/ux3/ExactRenderer',['jquery.sap.global'],function(q){"use strict";var E={};
E.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiUx3Exact");a.writeClasses();var t=c.getTooltip_AsString();if(t){a.writeAttributeEscaped("title",t);}a.write(">");a.renderControl(c._searchArea);if(c._bDetailsVisible){a.renderControl(c._browser);a.renderControl(c._resultText);a.renderControl(c._resultArea);}a.write("</div>");};
return E;},true);
sap.ui.predefine('sap/ui/ux3/FacetFilter',['jquery.sap.global','sap/ui/core/Control','./library',"./FacetFilterRenderer"],function(q,C,l,F){"use strict";
var a=C.extend("sap.ui.ux3.FacetFilter",{metadata:{library:"sap.ui.ux3",properties:{visibleItemCountMode:{type:"sap.ui.ux3.VisibleItemCountMode",group:"Appearance",defaultValue:sap.ui.ux3.VisibleItemCountMode.Fixed}},aggregations:{lists:{type:"sap.ui.ux3.FacetFilterList",multiple:true,singularName:"list"}}}});
a.prototype.init=function(){this.data("sap-ui-fastnavgroup","true",true);};
return a;},true);
sap.ui.predefine('sap/ui/ux3/FacetFilterList',['jquery.sap.global','sap/ui/commons/ListBox','sap/ui/core/Control','./library',"./FacetFilterListRenderer"],function(q,L,C,l,F){"use strict";
var a=C.extend("sap.ui.ux3.FacetFilterList",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},multiSelect:{type:"boolean",group:"Behavior",defaultValue:true},displaySecondaryValues:{type:"boolean",group:"Misc",defaultValue:false},selectedKeys:{type:"string[]",group:"Misc",defaultValue:null},showCounter:{type:"boolean",group:"Behavior",defaultValue:true}},aggregations:{items:{type:"sap.ui.core.ListItem",multiple:true,singularName:"item"},controls:{type:"sap.ui.commons.ListBox",multiple:true,singularName:"control",visibility:"hidden"}},events:{select:{parameters:{id:{type:"string"},selectedIndices:{type:"int[]"},selectedItems:{type:"sap.ui.core.ListItem[]"},all:{type:"boolean"}}}}}});
(function(){
a.prototype.init=function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oListBox=new L(this.getId()+"-lb");this._oListBox.setScrollTop(0);this._oListBox.setValueTextAlign("Begin");this._oListBox.setDisplaySecondaryValues(this.getDisplaySecondaryValues());this._oListBox.setDisplayIcons(false);this._oListBox.setEditable(true);this._oListBox.setEnabled(true);this._oListBox.setVisible(true);this._oListBox.setAllowMultiSelect(this.getMultiSelect());this._oListBox.addAriaLabelledBy(this.getId()+"-head-txt");var t=this;this._oListBox.attachSelect(function(e){t.onSelect(t,e);});this.addAggregation("controls",this._oListBox);this._oItemAll=new sap.ui.core.ListItem({text:this._oResBundle.getText("FACETFILTER_ALL",[0]),key:"sapUiFacetFilter_ALL"});this._oListBox.addItem(this._oItemAll);};
a.prototype.setMultiSelect=function(m){this._oListBox.setAllowMultiSelect(m);this.setProperty("multiSelect",m,true);};
a.prototype.setDisplaySecondaryValues=function(d){this._oListBox.setDisplaySecondaryValues(d);this.setProperty("displaySecondaryValues",d,true);};
a.prototype.addItem=function(i){this._oListBox.addItem(i);if(!i.getKey()||q.trim(i.getKey())==""){i.setKey("generatedkey"+this.indexOfItem(i));}this.updateText4All();};
a.prototype.insertItem=function(i,I){this._oListBox.insertItem(i,I+1);if(!i.getKey()||q.trim(i.getKey())==""){i.setKey("generatedkey"+this.indexOfItem(i));}this.updateText4All();};
a.prototype.removeItem=function(i){this._oListBox.removeItem(i);this.updateText4All();};
a.prototype.removeAllItems=function(){this._oListBox.removeAllItems();this._oListBox.addItem(this._oItemAll);this.updateText4All();};
a.prototype.destroyItems=function(){this._oListBox.removeItem(this._oItemAll);this._oListBox.destroyItems();this._oListBox.addItem(this._oItemAll);this.updateText4All();};
a.prototype.indexOfItem=function(i){var I=this._oListBox.indexOfItem(i);if(I>-1){I=I-1;}return I;};
a.prototype.getItems=function(){var b=this._oListBox.getItems();var I=[];for(var i=1;i<b.length;i++){I.push(b[i]);}return I;};
a.prototype.setSelectedKeys=function(s){this.setProperty("selectedKeys",s);this.invalidate();};
a.prototype.setShowCounter=function(s){this.setProperty("showCounter",s);this.updateText4All();};
a.prototype.updateText4All=function(){if(this.getShowCounter()){this._oItemAll.setText(this._oResBundle.getText("FACETFILTER_ALL",[this._oListBox.getItems().length-1]));}else{this._oItemAll.setText(this._oResBundle.getText("FACETFILTER_NO_COUNT"));}};
a.prototype.onBeforeRendering=function(){if(!this.bFullHeight){this._oListBox.setVisibleItems(5);}var k=this.getSelectedKeys();if(k&&k.length>0){this._oListBox.setSelectedKeys(k);this._bAllOnly=false;}else{this._oListBox.setSelectedKeys(["sapUiFacetFilter_ALL"]);this._bAllOnly=true;}};
a.prototype.updateItems=function(){this.updateAggregation("items");var s=this._oListBox.getSelectedKeys();if(s.length==0){s=["sapUiFacetFilter_ALL"];this._bAllOnly=true;this._oListBox.setSelectedKeys(s);}};
a.prototype.onSelect=function(f,e){var s=this._oListBox.getSelectedKeys();if(s.length==0){s=["sapUiFacetFilter_ALL"];this._bAllOnly=true;this._oListBox.setSelectedKeys(s);}var I=q.inArray("sapUiFacetFilter_ALL",s);if(I>-1){if(s.length==1){this._bAllOnly=true;}else{if(this._bAllOnly){s.splice(I,1);this._bAllOnly=false;}else{s=["sapUiFacetFilter_ALL"];this._bAllOnly=true;}this._oListBox.setSelectedKeys(s);}}else{this._bAllOnly=false;}this.setProperty("selectedKeys",s,true);var S=[];var b=[];var A=this._oListBox.getSelectedItems();if(!this._bAllOnly){for(var i=0;i<A.length;i++){if(A[i]!=this._oItemAll){S.push(this.indexOfItem(A[i]));b.push(A[i]);}}}this.fireSelect({id:f.getId(),all:this._bAllOnly,selectedIndices:S,selectedItems:b});};
}());return a;},true);
sap.ui.predefine('sap/ui/ux3/FacetFilterListRenderer',['jquery.sap.global'],function(q){"use strict";var F={};
F.render=function(r,c){var a=r;a.write("<div ");a.writeControlData(c);a.addClass("sapUiUx3FFLst");a.writeClasses();a.writeAttribute("style","width:"+c.sWidth);a.write(">");a.write("<header id=\""+c.getId()+"-head\"  class=\"sapUiUx3FFLstHead\"");if(c.getTooltip_AsString()){a.writeAttributeEscaped("title",c.getTooltip_AsString());}a.write(">");a.write("<h3 id=\""+c.getId()+"-head-txt\"  class=\"sapUiUx3FFLstHeadTxt\">");if(c.getTitle()){a.writeEscaped(c.getTitle());}a.write("</h3>");a.write("</header>");a.renderControl(c._oListBox);a.write("</div>");};
return F;},true);
sap.ui.predefine('sap/ui/ux3/FacetFilterRenderer',['jquery.sap.global'],function(q){"use strict";var F={};
F.render=function(r,c){var a=r;var f=(c.getVisibleItemCountMode()===sap.ui.ux3.VisibleItemCountMode.Auto);a.write("<div");a.writeControlData(c);a.addClass("sapUiUx3FacetFilter");a.writeClasses();if(f){a.writeAttribute("style","height:100%");}a.write(">");var l=c.getLists();if(l){for(var i=0;i<l.length;i++){l[i].sWidth=100/l.length+"%";l[i].bFullHeight=f;a.renderControl(l[i]);}}a.write("</div>");};
return F;},true);
sap.ui.predefine('sap/ui/ux3/Feed',['jquery.sap.global','sap/ui/commons/DropdownBox','sap/ui/commons/MenuButton','sap/ui/commons/SearchField','sap/ui/commons/ToggleButton','sap/ui/core/Control','./Feeder','./library',"./FeedRenderer"],function(q,D,M,S,T,C,F,l,a){"use strict";
var b=C.extend("sap.ui.ux3.Feed",{metadata:{library:"sap.ui.ux3",properties:{feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},live:{type:"boolean",group:"Behavior",defaultValue:true},title:{type:"string",group:"Data",defaultValue:null}},aggregations:{filterItems:{type:"sap.ui.core.ListItem",multiple:true,singularName:"filterItem",bindable:"bindable"},chunks:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"chunk",bindable:"bindable"},toolsMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"toolsMenuItem",bindable:"bindable"}},events:{filterChange:{parameters:{newValue:{type:"string"}}},search:{parameters:{query:{type:"string"}}},chunkAdded:{parameters:{chunk:{type:"sap.ui.ux3.FeedChunk"}}},toolsItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}},toggleLive:{parameters:{live:{type:"boolean"}}}}}});
b.prototype.init=function(){this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.data("sap-ui-fastnavgroup","true",true);this.oFeeder=new F(this.getId()+'-Feeder',{type:sap.ui.ux3.FeederType.Medium}).setParent(this);this.oFeeder.attachEvent('submit',this.handleFeederSubmit,this);this.oLiveButton=new T(this.getId()+'-liveButton',{text:this.rb.getText('FEED_LIVE'),pressed:this.getLive(),lite:true}).setParent(this);this.oLiveButton.attachEvent('press',this.handleLiveButtonPress,this);this.oFilter=new D(this.getId()+'-filter').setParent(this);this.oFilter.attachEvent('change',this.handleFilterChange,this);this.oSearchField=new S(this.getId()+'-search',{enableListSuggest:false}).setParent(this);this.oSearchField.attachEvent('search',this.handleSearchFieldSearch,this);};
b.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new M(this.getId()+'-toolsButton',{tooltip:this.rb.getText('FEED_TOOLS'),lite:true,menu:new sap.ui.commons.Menu(this.getId()+'-toolsMenu')}).setParent(this);this.oToolsButton.attachEvent('itemSelected',this.handleLtoolsButtonSelected,this);var i=sap.ui.core.theming.Parameters._getThemeImage('_sap_ui_ux3_Feed_ToolsIconUrl');var I=sap.ui.core.theming.Parameters._getThemeImage('_sap_ui_ux3_Feed_ToolsIconHoverUrl');if(i){this.oToolsButton.setProperty('icon',i,true);}if(I){this.oToolsButton.setProperty('iconHovered',I,true);}}};
b.prototype.exit=function(){if(this.oFeeder){this.oFeeder.destroy();delete this.oFeeder;}if(this.oLiveButton){this.oLiveButton.destroy();delete this.oLiveButton;}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton;}if(this.oFilter){this.oFilter.destroy();delete this.oFilter;}if(this.oSearchField){this.oSearchField.destroy();delete this.oSearchField;}this.rb=undefined;};
b.prototype.handleFeederSubmit=function(e){var d=new Date();var s=String(d);var n=new sap.ui.ux3.FeedChunk(this.getId()+'-new-'+this.getChunks().length,{text:e.getParameter('text'),commentChunk:false,deletionAllowed:true,timestamp:s,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.insertChunk(n,0);this.fireChunkAdded({chunk:n});};
b.prototype.handleLiveButtonPress=function(e){var p=e.getParameter("pressed");this.setProperty("live",p,true);this.fireToggleLive({live:p});};
b.prototype.handleLtoolsButtonSelected=function(e){this.fireToolsItemSelected(e.mParameters);};
b.prototype.handleFilterChange=function(e){this.fireFilterChange(e.mParameters);};
b.prototype.handleSearchFieldSearch=function(e){this.fireSearch(e.mParameters);};
b.prototype.setFeederThumbnailSrc=function(f){this.setProperty("feederThumbnailSrc",f,true);this.oFeeder.setThumbnailSrc(f);return this;};
b.prototype.setLive=function(L){this.setProperty("live",L,true);this.oLiveButton.setPressed(L);return this;};
b.prototype.getToolsMenuItems=function(){if(this.oToolsButton){return this.oToolsButton.getMenu().getItems();}};
b.prototype.insertToolsMenuItem=function(t,i){this.initToolsButton();this.oToolsButton.getMenu().insertItem(t,i);return this;};
b.prototype.addToolsMenuItem=function(t){this.initToolsButton();this.oToolsButton.getMenu().addItem(t);return this;};
b.prototype.removeToolsMenuItem=function(t){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(t);}};
b.prototype.removeAllToolsMenuItems=function(){if(this.oToolsButton){return this.oToolsButton.getMenu().removeAllItems();}};
b.prototype.indexOfToolsMenuItem=function(t){if(this.oToolsButton){return this.oToolsButton.getMenu().indexOfItem(t);}};
b.prototype.destroyToolsMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().destroyItems();}return this;};
b.prototype.bindToolsMenuItems=function(p,t,s,f){this.initToolsButton();this.oToolsButton.getMenu().bindItems(p,t,s,f);return this;};
b.prototype.unbindToolsMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems();}return this;};
b.prototype.getFilterItems=function(){return this.oFilter.getItems();};
b.prototype.insertFilterItem=function(f,i){this.oFilter.insertItem(f,i);return this;};
b.prototype.addFilterItem=function(f){this.oFilter.addItem(f);return this;};
b.prototype.removeFilterItem=function(f){return this.oFilter.removeItem(f);};
b.prototype.removeAllFilterItems=function(){return this.oFilter.removeAllItems();};
b.prototype.indexOfFilterItem=function(f){return this.oFilter.indexOfItem(f);};
b.prototype.destroyFilterItems=function(){this.oFilter.destroyItems();return this;};
b.prototype.bindFilterItems=function(p,t,s,f){this.oFilter.bindItems(p,t,s,f);return this;};
b.prototype.unbindFilterItems=function(){this.oFilter.unbindItems();return this;};
return b;},true);
sap.ui.predefine('sap/ui/ux3/FeedChunk',['jquery.sap.global','sap/ui/commons/MenuButton','sap/ui/core/Control','sap/ui/core/theming/Parameters','./Feeder','./library',"./FeedChunkRenderer"],function(q,M,C,P,F,l,a){"use strict";
var b=C.extend("sap.ui.ux3.FeedChunk",{metadata:{library:"sap.ui.ux3",properties:{thumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},sender:{type:"string",group:"Data",defaultValue:null},timestamp:{type:"string",group:"Data",defaultValue:null},deletionAllowed:{type:"boolean",group:"Behavior",defaultValue:false},commentChunk:{type:"boolean",group:"Appearance",defaultValue:false,deprecated:true},feederThumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},feederSender:{type:"string",group:"Data",defaultValue:null},flagged:{type:"boolean",group:"Data",defaultValue:false},favorite:{type:"boolean",group:"Data",defaultValue:null},shared:{type:"boolean",group:"Data",defaultValue:false},enableFlag:{type:"boolean",group:"Appearance",defaultValue:true},enableShare:{type:"boolean",group:"Appearance",defaultValue:true},enableComment:{type:"boolean",group:"Appearance",defaultValue:true},enableInspect:{type:"boolean",group:"Appearance",defaultValue:true},enableFavorite:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{comments:{type:"sap.ui.ux3.FeedChunk",multiple:true,singularName:"comment",bindable:"bindable"},actionMenuItems:{type:"sap.ui.commons.MenuItem",multiple:true,singularName:"actionMenuItem",bindable:"bindable"}},events:{deleted:{},commentAdded:{parameters:{comment:{type:"sap.ui.ux3.FeedChunk"}}},toggleFlagged:{parameters:{flagged:{type:"boolean"}}},senderClicked:{},referenceClicked:{parameters:{text:{type:"string"}}},toggleFavorite:{parameters:{favorite:{type:"boolean"}}},inspect:{},toggleShared:{parameters:{shareed:{type:"boolean"}}},actionItemSelected:{parameters:{itemId:{type:"string"},item:{type:"sap.ui.unified.MenuItemBase"}}}}}});
b.prototype.init=function(){this.maxComments=2;this.allComments=false;this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.expanded=false;};
b.prototype.initCommentFeeder=function(){if(!this.oCommentFeeder){this.oCommentFeeder=new F(this.getId()+'-CommentFeeder',{type:sap.ui.ux3.FeederType.Comment}).setParent(this);this.oCommentFeeder.attachEvent('submit',this.handleCommentFeederSubmit,this);this.showCommentFeeder=true;}};
b.prototype.initToolsButton=function(){if(!this.oToolsButton){this.oToolsButton=new M(this.getId()+'-toolsButton',{tooltip:this.rb.getText('FEED_TOOLS'),lite:true,menu:new sap.ui.commons.Menu(this.getId()+'-toolsMenu')}).setParent(this);this.oToolsButton.attachEvent('itemSelected',this.handleToolsButtonSelected,this);var i=P._getThemeImage('_sap_ui_ux3_Feed_ToolsIconUrl');var I=P._getThemeImage('_sap_ui_ux3_Feed_ToolsIconHoverUrl');if(i){this.oToolsButton.setProperty('icon',i,true);}if(I){this.oToolsButton.setProperty('iconHovered',I,true);}}};
b.prototype.exit=function(){if(this.oCommentFeeder){this.oCommentFeeder.destroy();delete this.oCommentFeeder;}if(this.oToolsButton){this.oToolsButton.destroy();delete this.oToolsButton;}this.rb=undefined;this.showCommentFeeder=undefined;this.expanded=undefined;this.oText=undefined;if(this.oHCMMenuButton){this.oHCMMenuButton.destroy();delete this.oHCMMenuButton;}};
b.prototype.onAfterRendering=function(){this.oText=this.$().children(".sapUiFeedChunkText").get(0);if(this.oText.clientHeight<this.oText.scrollHeight){var f=this.$().children(".sapUiFeedChunkByline").get(0);q(f).append(sap.ui.ux3.FeedChunkRenderer.renderExpander(this));if(this.expanded){q(this.oText).css('height','auto');}}};
b.prototype.onclick=function(e){var t=e.target.getAttribute('ID');if(t){switch(t){case(this.getId()+'-delete'):this.fireDeleted();break;case(this.getId()+'-sender'):this.fireSenderClicked();break;case(this.getId()+'-thumb'):this.fireSenderClicked();break;case(this.getId()+'-exp'):var n='';if(this.expanded){q(this.oText).css('height','');n=this.rb.getText("FEED_EXPAND");this.expanded=false;}else{q(this.oText).css('height','auto');n=this.rb.getText("FEED_COLLAPSE");this.expanded=true;}q.sap.byId(t).attr('title',n).toggleClass('sapUiFeedChunkExpand sapUiFeedChunkCollapse');break;case(this.getId()+'-all'):this.showAllComments();break;case(this.getId()+'-ActComment'):if(!this.showCommentFeeder){this.initCommentFeeder();this.rerender();}break;case(this.getId()+'-ActFlag'):this.setFlagged(!this.getFlagged());this.fireToggleFlagged({flagged:this.getFlagged()});break;case(this.getId()+'-ActFavorite'):this.setFavorite(!this.getFavorite());this.fireToggleFavorite({favorite:this.getFavorite()});break;case(this.getId()+'-ActInspect'):this.fireInspect();break;case(this.getId()+'-ActShare'):this.setShared(!this.getShared());this.fireToggleShared({shared:this.getShared()});break;default:if(t.search(this.getId()+'-Ref')!=-1){this.fireReferenceClicked({text:q(e.target).text()});}break;}}e.preventDefault();e.stopPropagation();};
b.prototype.showAllComments=function(){this.allComments=!this.allComments;var $=q.sap.byId(this.getId()+" > section");if($.length>0){var r=sap.ui.getCore().createRenderManager();this.getRenderer().renderComments(r,this);r.flush($[0]);r.destroy();}};
b.prototype.handleCommentFeederSubmit=function(e){var d=new Date();var D=String(d);var n=new b(this.getId()+'-new-'+this.getComments().length,{text:e.getParameter('text'),commentChunk:true,deletionAllowed:true,timestamp:D,sender:this.getFeederSender(),thumbnailSrc:this.getFeederThumbnailSrc()});this.addComment(n);this.fireCommentAdded({comment:n});};
b.prototype.handleToolsButtonSelected=function(e){if(e.getParameter('itemId')==this.getId()+'-actDelete'){this.fireDeleted();}else{this.fireActionItemSelected(e.mParameters);}};
b.prototype.insertComment=function(c,i){this.insertAggregation("comments",c,i);this.initCommentFeeder();return this;};
b.prototype.addComment=function(c){this.addAggregation("comments",c);this.initCommentFeeder();return this;};
b.prototype.setDeletionAllowed=function(d){if(d==this.getDeletionAllowed()){return this;}this.setProperty("deletionAllowed",d);if(d){this.initToolsButton();this.oToolsButton.getMenu().insertItem(new sap.ui.commons.MenuItem(this.getId()+'-actDelete',{text:this.rb.getText('FEED_DELETE')}),0);}else{if(this.oToolsButton){this.oToolsButton.getMenu().removeItem(this.getId()+'-actDelete');}}return this;};
b.prototype.getActionMenuItems=function(){if(this.oToolsButton){var i=this.oToolsButton.getMenu().getItems();if(i.length>0&&i[0].getId()==(this.getId()+'-actDelete')){i.shift();}return i;}};
b.prototype.insertActionMenuItem=function(A,i){this.initToolsButton();var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){i++;}this.oToolsButton.getMenu().insertItem(A,i);return this;};
b.prototype.addActionMenuItem=function(A){this.initToolsButton();this.oToolsButton.getMenu().addItem(A);return this;};
b.prototype.removeActionMenuItem=function(A){if(this.oToolsButton){return this.oToolsButton.getMenu().removeItem(A);}};
b.prototype.removeAllActionMenuItems=function(){if(this.oToolsButton){var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){I.shift();for(var i=0;i<I.length;i++){this.oToolsButton.getMenu().removeItem(I[i]);}return I;}else{return this.oToolsButton.getMenu().removeAllItems();}}};
b.prototype.indexOfActionMenuItem=function(A){if(this.oToolsButton){var i=this.oToolsButton.getMenu().indexOfItem(A);var I=this.oToolsButton.getMenu().getItems();if(I.length>0&&I[0].getId()==(this.getId()+'-actDelete')){i--;}return i;}};
b.prototype.destroyActionMenuItems=function(){if(this.oToolsButton){var i=this.oToolsButton.getMenu().getItems();if(i.length>0&&i[0].getId()==(this.getId()+'-actDelete')){this.removeAllActionMenuItems();}else{this.oToolsButton.getMenu().destroyItems();}}return this;};
b.prototype.bindActionMenuItems=function(p,t,s,f){this.initToolsButton();this.oToolsButton.getMenu().bindItems(p,t,s,f);return this;};
b.prototype.unbindActionMenuItems=function(){if(this.oToolsButton){this.oToolsButton.getMenu().unbindItems();}return this;};
b.prototype.getFeederThumbnailSrc=function(){var t=this.getProperty("feederThumbnailSrc");if(!t||t==""){var p=this.getParent();if(p&&(p instanceof sap.ui.ux3.Feed||p instanceof b)){t=p.getFeederThumbnailSrc();}}return t;};
b.prototype.getFeederSender=function(){var s=this.getProperty("feederSender");if(!s||s==""){var p=this.getParent();if(p&&(p instanceof sap.ui.ux3.Feed||p instanceof b)){s=p.getFeederSender();}}return s;};
b.prototype.initHCMMenuButton=function(){if(!this.oHCMMenuButton){this.oHCMMenuButton=new M(this.getId()+"-HCMMenu",{lite:true}).setParent(this);this.oHCMMenuButton.attachEvent('itemSelected',this.handleHCMMenuButtonSelected,this);}};
b.prototype.setHCMMenu=function(m){this.initHCMMenuButton();this.oHCMMenuButton.setMenu(m);return this;};
b.prototype.handleHCMMenuButtonSelected=function(e){this.fireEvent("HCMMenuItemSelected",e.mParameters);};
return b;},true);
sap.ui.predefine('sap/ui/ux3/FeedChunkRenderer',['jquery.sap.global'],function(q){"use strict";var F={};
F.render=function(r,c){var a=r;var C=c;if(C.getParent()instanceof sap.ui.ux3.FeedChunk){C.bComment=true;}else{C.bComment=false;}var m=C.getId();a.write('<ARTICLE');a.writeControlData(C);a.addClass('sapUiFeedChunk');if(C.bComment){a.addClass('sapUiFeedChunkComment');}a.writeClasses();a.write('>');a.write('<img id='+m+'-thumb');var t=C.getThumbnailSrc();if(!t){t=sap.ui.core.theming.Parameters._getThemeImage('_sap_ui_ux3_FeedChunk_PersonPlaceholder');}a.writeAttributeEscaped('src',t);a.writeAttributeEscaped('alt',C.getSender());a.writeClasses();a.write('>');a.write('<DIV class= "sapUiFeedChunkText" >');a.write('<a id='+m+'-sender ');a.writeAttribute('href','#');a.write('>');a.writeEscaped(C.getSender());a.write('</a> ');if(C.oHCMMenuButton){a.renderControl(C.oHCMMenuButton);}this.renderText(a,C);a.write('</DIV>');if(!C.bComment){a.write('<UL class= "sapUiFeedChunkStatusIcons" >');if(C.getFlagged()){a.write('<LI class= "sapUiFeedChunkFlagged" title="'+C.rb.getText('FEED_FLAGGED')+'" >&#9873</LI>');}if(C.getFavorite()){a.write('<LI class= "sapUiFeedChunkFavorite" title="'+C.rb.getText('FEED_FAVORITE')+'" >&#9733</LI>');}if(C.getShared()){a.write('<LI class= "sapUiFeedChunkShared" title="'+C.rb.getText('FEED_SHARED')+'" >&#8635</LI>');}a.write('</UL>');}a.write('<SPAN class= "sapUiFeedChunkByline" >');a.writeEscaped(C.getTimestamp());a.write('</SPAN>');if(!C.bComment){if(C.oToolsButton){a.renderControl(C.oToolsButton);}if(C.getEnableShare()){a.write('<BUTTON type = "button" id='+m+'-ActShare class= "sapUiFeedChunkAct sapUiFeedChunkActShare" title="'+C.rb.getText('FEED_ACT_SHARE')+'" >&#8635</BUTTON>');}if(C.getEnableInspect()){a.write('<BUTTON type = "button" id='+m+'-ActInspect class= "sapUiFeedChunkAct sapUiFeedChunkActInspect" title="'+C.rb.getText('FEED_ACT_INSPECT')+'" >i</BUTTON>');}if(C.getEnableFavorite()){a.write('<BUTTON type = "button" id='+m+'-ActFavorite class= "sapUiFeedChunkAct sapUiFeedChunkActFavorite" title="'+C.rb.getText('FEED_ACT_FAVORITE')+'" >&#9733</BUTTON>');}if(C.getEnableFlag()){a.write('<BUTTON type = "button" id='+m+'-ActFlag class= "sapUiFeedChunkAct sapUiFeedChunkActFlag" title="'+C.rb.getText('FEED_ACT_FLAG')+'" >&#9873</BUTTON>');}if(C.getEnableComment()){a.write('<BUTTON type = "button" id='+m+'-ActComment class= "sapUiFeedChunkAct sapUiFeedChunkActComment" title="'+C.rb.getText('FEED_ACT_COMMENT')+'" >C</BUTTON>');}}if(C.getDeletionAllowed()&&C.bComment){a.write('<BUTTON type = "button" id='+m+'-delete class= "sapUiFeedChunkDel" title="'+C.rb.getText('FEED_DELETE')+'" >X</BUTTON>');}if(C.getComments().length>0||C.showCommentFeeder){a.write("<SECTION>");this.renderComments(a,C);a.write("</SECTION>");}a.write('</ARTICLE>');};
F.renderText=function(r,c){var t=c.getText();var i=0;var p=0;do{p=t.search(/\s/);var s="",w="";if(p<0){w=t;}else{w=t.slice(0,p);s=t.slice(p,p+1);t=t.slice(p+1);}if(/^@/.test(w)){r.write('<a id='+c.getId()+'-Ref'+i);r.writeAttribute('href','#');r.write('>');r.writeEscaped(w,true);r.write('</a>',s);i++;}else if(/^(https?|ftp):\/\//i.test(w)&&q.sap.validateUrl(w)){r.write('<a');r.writeAttribute('href',q.sap.encodeHTML(w));r.write('>');r.writeEscaped(w,true);r.write('</a>',s);}else if(/^(www\.)/i.test(w)&&q.sap.validateUrl("http://"+w)){r.write('<a');r.writeAttribute('href',q.sap.encodeHTML("http://"+w));r.write('>');r.writeEscaped(w,true);r.write('</a>',s);}else if(/^[\w\.=-]+@[\w\.-]+\.[\w]{2,5}$/.test(w)){r.write('<a');r.writeAttribute('href',"mailto:"+q.sap.encodeHTML(w));r.write('>');r.writeEscaped(w,true);r.write('</a>',s);}else{r.writeEscaped(w+s,true);}}while(p>=0);};
F.renderComments=function(r,c){var C=c.getComments();var l=C.length;r.write('<HEADER class= "sapUiFeedChunkComments" >');if(c.rb){r.write(c.rb.getText('FEED_NO_COMMENTS',[l]));if(l>c.maxComments){r.write('<a id='+c.getId()+'-all ');r.writeAttribute('href','#');r.write('>');if(!c.allComments){r.write(c.rb.getText('FEED_ALL_COMMENTS'));}else{r.write(c.rb.getText('FEED_MAX_COMMENTS'));}r.write('</a>');}}r.write("</HEADER>");var n=l;if(!c.allComments&&c.maxComments<n){n=c.maxComments;}for(var i=0;i<n;i++){r.renderControl(C[l-n+i]);}if(c.oCommentFeeder){r.renderControl(c.oCommentFeeder);}};
F.renderExpander=function(c){if(c.expanded){return"<button id= '"+c.getId()+"-exp' class='sapUiFeedChunkCollapse' title='"+c.rb.getText("FEED_COLLAPS")+"'>&#9660</button>";}else{return"<button id= '"+c.getId()+"-exp' class='sapUiFeedChunkExpand' title='"+c.rb.getText("FEED_EXPAND")+"'>&#9660</button>";}};
return F;},true);
sap.ui.predefine('sap/ui/ux3/FeedRenderer',[],function(){"use strict";var F={};
F.render=function(r,c){var a=r;var f=c;a.write('<DIV');a.writeControlData(f);a.addClass('sapUiFeed');a.writeClasses();a.write('>');a.renderControl(f.oFeeder);a.write('<HEADER class=sapUiFeedTitle ><H4>');var t=f.getTitle();if(!t||t==""){t=f.rb.getText('FEED_TITLE');}a.writeEscaped(t);if(f.oToolsButton){a.renderControl(f.oToolsButton);}a.renderControl(f.oLiveButton);a.write('</H4>');a.write('<DIV class="sapUiFeedToolbar" >');a.renderControl(f.oFilter);a.renderControl(f.oSearchField);a.write('</DIV>');a.write('</HEADER>');a.write('<SECTION>');for(var i=0;i<f.getChunks().length;i++){var C=f.getChunks()[i];a.renderControl(C);}a.write('</SECTION>');a.write('</DIV>');};
return F;},true);
sap.ui.predefine('sap/ui/ux3/Feeder',['jquery.sap.global','sap/ui/commons/Button','sap/ui/core/Control','sap/ui/core/theming/Parameters','./library',"./FeederRenderer"],function(q,B,C,P,l,F){"use strict";
var a=C.extend("sap.ui.ux3.Feeder",{metadata:{library:"sap.ui.ux3",properties:{thumbnailSrc:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},text:{type:"string",group:"Data",defaultValue:null},type:{type:"sap.ui.ux3.FeederType",group:"Appearance",defaultValue:sap.ui.ux3.FeederType.Large},placeholderText:{type:"string",group:"Appearance",defaultValue:null}},events:{submit:{parameters:{text:{type:"string"}}}}}});
a.prototype.init=function(){this.rb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this.oSendButton=new B(this.getId()+"-send",{style:sap.ui.commons.ButtonStyle.Emph,icon:"sap-icon://feeder-arrow"}).setParent(this);this.oSendButton.attachEvent('press',this.handleSendButtonPress,this);};
a.prototype.initSendButton=function(){if(this.getText()==""){this.oSendButton.setProperty('enabled',false,true);}};
a.prototype.exit=function(){this.rb=undefined;this.oInput=undefined;if(this.oSendButton){this.oSendButton.destroy();delete this.oSendButton;}};
a.prototype.onAfterRendering=function(){this.oInput=this.$("input");};
a.prototype.onclick=function(e){var t=e.target.getAttribute('ID');switch(t){case(this.getId()+'-send'):break;case(this.getId()+'-input'):break;default:break;}};
a.prototype.onfocusin=function(e){this.oInput.find(".sapUiFeederEmptyText").remove();};
a.prototype.onfocusout=function(e){var t=this.oInput.text();if(t==""){this.oInput.empty();this.oInput.append(sap.ui.ux3.FeederRenderer.getEmptyTextInfo(this));}this.setProperty("text",t,true);};
a.prototype.getFocusDomRef=function(){return this.getDomRef("input");};
a.prototype.onkeyup=function(e){if(this.oInput.text()==""){this.oSendButton.setEnabled(false);}else{this.oSendButton.setEnabled(true);}};
a.prototype.handleSendButtonPress=function(e){var t=this.getMultilineText(this.oInput);this.setProperty("text",t,true);this.fireSubmit({text:t});this.setText('');};
a.prototype.getMultilineText=function(I){function p(n){var b;var t='';for(var i=0;i<n.length;i++){b=n[i];if(b.nodeType===3||b.nodeType===4){if(!((!!sap.ui.Device.browser.internet_explorer||!!sap.ui.Device.browser.edge)&&b.nodeValue==='\xA0')){t+=b.nodeValue.replace(/\n/g,'');}}if(b.nodeName==='DIV'||b.nodeName==='P'||(b.nodeName==='BR'&&!sap.ui.Device.browser.webkit)){if(b.nodeName==='BR'&&!!sap.ui.Device.browser.firefox&&i===n.length-1&&q(b).attr("type")==="_moz"){continue;}if(!((!!sap.ui.Device.browser.internet_explorer||!!sap.ui.Device.browser.edge)&&t==='')&&!((!!sap.ui.Device.browser.firefox||!!sap.ui.Device.browser.webkit)&&t===''&&b.nodeName==='P')&&!(!!sap.ui.Device.browser.webkit&&b.nodeName==='P'&&b.textContent.match(/^(\n)*$/))){t+='\n';}}if(b.nodeType!==8){t+=p(b.childNodes);}}return t;}return p(I.get(0).childNodes);};
a.prototype.getThumbnailSrc=function(){var t=this.getProperty("thumbnailSrc");if(!t||t==""){var p=this.getParent();if(p&&(p instanceof sap.ui.ux3.Feed||p instanceof sap.ui.ux3.FeedChunk)){t=p.getFeederThumbnailSrc();}}return t;};
a.prototype.onpaste=function(e){if(!!sap.ui.Device.browser.firefox){q.sap.delayedCall(10,this,"onAfterPaste");}};
a.prototype.onAfterPaste=function(){var c=this.oInput.get(0).childNodes;for(var i=0;i<c.length;i++){var o=c[i];if(o.nodeName=="PRE"){q(o).css("overflow","hidden");}}};
return a;},true);
sap.ui.predefine('sap/ui/ux3/FeederRenderer',['jquery.sap.global'],function(q){"use strict";var F={};
F.render=function(r,c){var a=r;var f=c;a.write('<DIV');a.writeControlData(f);a.addClass('sapUiFeeder');switch(f.getType()){case sap.ui.ux3.FeederType.Medium:a.addClass('sapUiFeederMedium');break;case sap.ui.ux3.FeederType.Comment:a.addClass('sapUiFeederComment');break;default:a.addClass('sapUiFeederLarge');break;}a.writeClasses();a.write('>');a.write('<img id='+f.getId()+'-thumb');var t=f.getThumbnailSrc();if(!t){t=sap.ui.core.theming.Parameters._getThemeImage("_sap_ui_ux3_Feeder_PersonPlaceholder");}a.writeAttributeEscaped('src',t);a.writeClasses();a.write('>');a.write('<DIV id='+f.getId()+'-input contenteditable="true" class="sapUiFeederInput" >');if(f.getText()==''){a.write(this.getEmptyTextInfo(f));}else{a.writeEscaped(f.getText(),true);}a.write('</DIV>');f.initSendButton();a.renderControl(f.oSendButton);a.write('</DIV>');};
F.getEmptyTextInfo=function(f){return"<span class='sapUiFeederEmptyText'>"+q.sap.encodeHTML(f.getPlaceholderText()||f.rb.getText("FEED_EMPTY_FEEDER"))+"</span>";};
return F;},true);
sap.ui.predefine('sap/ui/ux3/NavigationBar',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./library',"./NavigationBarRenderer",'jquery.sap.dom'],function(q,C,I,l,N){"use strict";
var b=C.extend("sap.ui.ux3.NavigationBar",{metadata:{library:"sap.ui.ux3",properties:{toplevelVariant:{type:"boolean",group:"Misc",defaultValue:false},overflowItemsToUpperCase:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"items",aggregations:{items:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"item"},overflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedItem:{type:"sap.ui.ux3.NavigationItem",multiple:false},associatedItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"associatedItem"}},events:{select:{allowPreventDefault:true,parameters:{itemId:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"}}}}}});
b.SCROLL_STEP=250;
b.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iLastArrowPos=-100;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this.allowTextSelection(false);this.startScrollX=0;this.startTouchX=0;var t=this;this._oItemNavigation=new I().setCycling(false);this.addDelegate(this._oItemNavigation);this.data("sap-ui-fastnavgroup","true",true);if(q.sap.touchEventMode==="ON"){var T=function(e){e.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("list").scrollLeft;t.startTouchX=e.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var f=function(e){var d=e.touches[0].pageX-t.startTouchX;var L=t.getDomRef("list");var o=L.scrollLeft;var n=t.startScrollX-d;L.scrollLeft=n;t._bTouchNotMoved=false;var c=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(c>0){t._velocity=(n-o)/c;}e.preventDefault();};var a=function(e){if(t._bTouchNotMoved===false){e.preventDefault();var L=t.getDomRef("list");var d=50;var c=Math.abs(t._velocity/10);t._iInertiaIntervalId=window.setInterval(function(){t._velocity=t._velocity*0.80;var g=t._velocity*d;L.scrollLeft=L.scrollLeft+g;if(Math.abs(t._velocity)<c){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},d);}else if(t._bTouchNotMoved===true){t.onclick(e);e.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.ontouchstart=T;this.ontouchend=a;this.ontouchmove=f;}};
b.prototype.exit=function(){if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._checkOverflowIntervalId){q.sap.clearIntervalCall(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null;}};
b.prototype.onBeforeRendering=function(){if(this._checkOverflowIntervalId){q.sap.clearIntervalCall(this._checkOverflowIntervalId);this._checkOverflowIntervalId=null;}this._iSoredScrollPosition=this.$("list").scrollLeft();if(!!sap.ui.Device.browser.firefox){this.$().unbind("DOMMouseScroll",this._handleScroll);}else{this.$().unbind("mousewheel",this._handleScroll);}var a=this.getDomRef("arrow");this._iLastArrowPos=a?parseInt(this._bRtl?a.style.right:a.style.left,10):-100;};
b.prototype.invalidate=function(s){if(s instanceof sap.ui.ux3.NavigationItem){this._menuInvalid=true;}C.prototype.invalidate.apply(this,arguments);};
b.prototype._calculatePositions=function(){var d=this.getDomRef();this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._checkOverflow(d.firstChild,this.getDomRef("ofb"),this.getDomRef("off"));};
b.prototype.onThemeChanged=function(){if(this.getDomRef()){this._calculatePositions();}};
b.prototype.onAfterRendering=function(){var d=this.getDomRef();var L=d.firstChild;var o=this.getDomRef("ofb");var a=this.getDomRef("off");this._checkOverflowIntervalId=q.sap.intervalCall(350,this,"_checkOverflow",[L,o,a]);if(!!sap.ui.Device.browser.firefox){q(d).bind("DOMMouseScroll",q.proxy(this._handleScroll,this));}else{q(d).bind("mousewheel",q.proxy(this._handleScroll,this));}this._calculatePositions();this._updateItemNavigation();var n=this.$();n.on("scroll",function(){n.children().scrollTop(0);n.scrollTop(0);});if(this._iSoredScrollPosition){this.$("list").scrollLeft(this._iSoredScrollPosition);}};
b.prototype._updateItemNavigation=function(){var d=this.getDomRef();if(d){var s=-1;var S=this.getSelectedItem();var i=q(d).children().children("li").children().not(".sapUiUx3NavBarDummyItem");i.each(function(a,e){if(e.id==S){s=a;}});this._oItemNavigation.setRootDomRef(d);this._oItemNavigation.setItemDomRefs(i.toArray());this._oItemNavigation.setSelectedIndex(s);}};
b.prototype.onsapspace=function(e){this._handleActivation(e);};
b.prototype.onclick=function(e){this._handleActivation(e);};
b.prototype.setOverflowItemsToUpperCase=function(v){this._getOverflowMenu().toggleStyleClass("sapUiUx3NavBarUpperCaseText",v);return this.setProperty("overflowItemsToUpperCase",v);};
b.prototype._handleActivation=function(e){var t=e.target.id;if(t){var i=this.getId();e.preventDefault();if(t==i+"-ofb"){this._scroll(-b.SCROLL_STEP,500);}else if(t==i+"-off"){this._scroll(b.SCROLL_STEP,500);}else if(t==i+"-oflt"||t==i+"-ofl"){this._showOverflowMenu();}else{var a=sap.ui.getCore().byId(t);if(a&&(t!=this.getSelectedItem())&&(sap.ui.getCore().byId(t)instanceof sap.ui.ux3.NavigationItem)){if(this.fireSelect({item:a,itemId:t})){this.setAssociation("selectedItem",a,true);this._updateSelection(t);}}}}};
b.prototype._getOverflowMenu=function(){var m=this.getAggregation("overflowMenu");if(!m||this._menuInvalid){if(m){m.destroyAggregation("items",true);}else{m=new sap.ui.commons.Menu();}var a=this._getCurrentItems();var t=this;var s=this.getSelectedItem();for(var i=0;i<a.length;++i){var n=a[i];var M=new sap.ui.commons.MenuItem(n.getId()+"-overflowItem",{text:n.getText(),visible:n.getVisible(),icon:s==n.getId()?"sap-icon://accept":null,select:(function(n){return function(e){t._handleActivation({target:{id:n.getId()},preventDefault:function(){}});};})(n)});m.addAggregation("items",M,true);}this.setAggregation("overflowMenu",m,true);this._menuInvalid=false;}return m;};
b.prototype._getCurrentItems=function(){var a=this.getItems();if(a.length<1){a=this.getAssociatedItems();var c=sap.ui.getCore();for(var i=0;i<a.length;++i){a[i]=c.byId(a[i]);}}return a;};
b.prototype._showOverflowMenu=function(){var m=this._getOverflowMenu();var t=this.$("ofl").get(0);m.open(true,t,sap.ui.core.Popup.Dock.EndTop,sap.ui.core.Popup.Dock.CenterCenter,t);};
b.prototype._updateSelection=function(i){this._menuInvalid=true;var $=q.sap.byId(i);$.attr("tabindex","0").attr("aria-checked","true");$.parent().addClass("sapUiUx3NavBarItemSel");$.parent().parent().children().each(function(){var a=this.firstChild;if(a&&(a.id!=i)&&(a.className.indexOf("Dummy")==-1)){q(a).attr("tabindex","-1");q(a).parent().removeClass("sapUiUx3NavBarItemSel");q(a).attr("aria-checked","false");}});var s=$.parent().index();if(s>0){s--;}this._oItemNavigation.setSelectedIndex(s);var A=this.$("arrow");var c=A.outerWidth();var t=b._getArrowTargetPos(i,c,this._bRtl);A.stop();var d=this._bRtl?{right:t+"px"}:{left:t+"px"};A.animate(d,500,"linear");var e=this;window.setTimeout(function(){t=b._getArrowTargetPos(i,c,e._bRtl);A.stop();var a=e._bRtl?{right:t+"px"}:{left:t+"px"};A.animate(a,200,"linear",function(){var f=q.sap.domById(i);e._scrollItemIntoView(f);});},300);};
b.prototype._scrollItemIntoView=function(i){if(!i){return;}var a=q(i.parentNode);var u=a.parent();var t;var r=sap.ui.getCore().getConfiguration().getRTL();var c=a.index()-1;if(c==0){t=r?(u[0].scrollWidth-u.innerWidth()+20):0;}else if(c==a.siblings().length-2){t=r?0:(u[0].scrollWidth-u.innerWidth()+20);}else{var d=a.position().left;var e=r?u.scrollLeftRTL():u.scrollLeft();if(d<0){t=e+d;}else{var f=u.innerWidth()-(d+a.outerWidth(true));if(f<0){t=e-f;t=Math.min(t,e+d);}}}if(t!==undefined){if(r){t=q.sap.denormalizeScrollLeftRTL(t,u.get(0));}u.stop(true,true).animate({scrollLeft:t});}};
b._getArrowTargetPos=function(t,a,r){var i=q.sap.byId(t);if(i.length>0){var w=i.outerWidth();var c=Math.round(i[0].offsetLeft+(w/2)-(a/2));if(!r){return c;}else{return i.parent().parent().innerWidth()-c-a;}}else{return-100;}};
b.prototype._handleScroll=function(e){if(e.type=="DOMMouseScroll"){var s=e.originalEvent.detail*40;this._scroll(s,50);}else{var s=-e.originalEvent.wheelDelta;this._scroll(s,50);}e.preventDefault();};
b.prototype._scroll=function(d,D){var o=this.$()[0].firstChild;var s=o.scrollLeft;if(!sap.ui.Device.browser.internet_explorer&&this._bRtl){d=-d;}var S=s+d;q(o).stop(true,true).animate({scrollLeft:S},D);};
b.prototype._checkOverflow=function(L,o,a){function i(){return sap.ui.Device.os.macintosh&&sap.ui.Device.browser.chrome;}if(L&&this.getDomRef()&&q.sap.act.isActive()){var s=L.scrollLeft;var S=false;var c=false;var r=L.scrollWidth;var d=L.clientWidth;var e=i()?5:0;if(Math.abs(r-d)==1){r=d;}if(!this._bRtl){if(s>e){S=true;}if((r>d)&&(r-(s+d)>e)){c=true;}}else{var $=q(L);if($.scrollLeftRTL()>e){c=true;}if($.scrollRightRTL()>e){S=true;}}if((c!=this._bPreviousScrollForward)||(S!=this._bPreviousScrollBack)){this._bPreviousScrollForward=c;this._bPreviousScrollBack=S;this.$().toggleClass("sapUiUx3NavBarScrollBack",S).toggleClass("sapUiUx3NavBarScrollForward",c);if(!b._bMenuLoaded&&(S||c)){b._bMenuLoaded=true;q.sap.require("sap.ui.commons.Menu");}}var f=sap.ui.getCore().byId(this.getSelectedItem());if(f){var A=this.$("arrow");var g=A.outerWidth();var t=b._getArrowTargetPos(f.getId(),g,this._bRtl)+"px";if(!this._bRtl){if(A[0].style.left!=t){A[0].style.left=t;}}else{if(A[0].style.right!=t){A[0].style.right=t;}}}}};
b.prototype.setSelectedItem=function(i){this.setAssociation("selectedItem",i,true);if(this.getDomRef()){var s=(!i||(typeof(i)=="string"))?i:i.getId();this._updateSelection(s);}};
b.prototype.addItem=function(i){this._menuInvalid=true;return this.addAggregation("items",i);};
b.prototype.destroyItems=function(){this._menuInvalid=true;return this.destroyAggregation("items");};
b.prototype.insertItem=function(i,a){this._menuInvalid=true;return this.insertAggregation("items",i,a);};
b.prototype.removeItem=function(i){this._menuInvalid=true;return this.removeAggregation("items",i);};
b.prototype.removeAllItems=function(){this._menuInvalid=true;return this.removeAllAggregation("items");};
b.prototype.addAssociatedItem=function(i){this._menuInvalid=true;return this.addAssociation("associatedItems",i);};
b.prototype.removeAssociatedItem=function(i){this._menuInvalid=true;return this.removeAssociation("associatedItems",i);};
b.prototype.removeAllAssociatedItems=function(){this._menuInvalid=true;return this.removeAllAssociation("associatedItems");};
b.prototype.setAssociatedItems=function(a){var L=this.getDomRef("list");this.removeAllAssociation("associatedItems",true);for(var i=0;i<a.length;i++){this.addAssociation("associatedItems",a[i],true);}if(L){var f=q(L).find(":focus");var c=(f.length>0)?f.attr("id"):null;if(arguments.length>1&&typeof arguments[1]==="boolean"){this._iLastArrowPos=-100;}else{var d=this.getDomRef("arrow");this._iLastArrowPos=parseInt(this._bRtl?d.style.right:d.style.left,10);}L.innerHTML="";var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.NavigationBarRenderer.renderItems(r,this);r.flush(L,true);r.destroy();var n;if(c&&(n=q.sap.domById(c))){q.sap.focus(n);}this._updateSelection(this.getSelectedItem());this._updateItemNavigation();}return this;};
b.prototype.isSelectedItemValid=function(){var s=this.getSelectedItem();if(!s){return false;}var a=this.getItems();if(!a||a.length==0){a=this.getAssociatedItems();for(var i=0;i<a.length;i++){if(a[i]==s){return true;}}}else{for(var i=0;i<a.length;i++){if(a[i].getId()==s){return true;}}}return false;};
return b;},true);
sap.ui.predefine('sap/ui/ux3/NavigationBarRenderer',['jquery.sap.global'],function(q){"use strict";var N={};
N.render=function(r,c){var a=r;var i=c.getId();a.addClass("sapUiUx3NavBar").addClass("sapUiUx3NavBarUpperCaseText");if(c.getToplevelVariant()){a.addClass("sapUiUx3NavBarToplevel");}a.write("<nav");a.writeControlData(c);a.writeClasses();a.write("role='navigation'>");a.write("<ul id='"+i+"-list' role='menubar' class='sapUiUx3NavBarList'");a.addStyle("white-space","nowrap");a.writeStyles();a.write(">");N.renderItems(a,c);a.write("</ul>");a.write("<a id='"+i+"-ofb' role='presentation' class='sapUiUx3NavBarBack' href='#'></a>");a.write("<a id='"+i+"-off' role='presentation' class='sapUiUx3NavBarForward' href='#'></a>");a.write("<a id='"+i+"-ofl' role='presentation' class='sapUiUx3NavBarOverflowBtn' href='#'>");a.writeIcon("sap-icon://overflow",[],{id:i+"-oflt"});a.write("</a>");a.write("</nav>");};
N.renderItems=function(r,c){var I=c.getItems();var n=false;if(!I||I.length==0){I=c.getAssociatedItems();n=true;}var a=I.length;r.write("<li");r.addStyle("display","inline-block");r.writeStyles();r.write(">");r.write("<a id='"+c.getId()+"-dummyItem' class='sapUiUx3NavBarDummyItem sapUiUx3NavBarItem'>&nbsp;</a></li>");var s=c.getSelectedItem();for(var i=0;i<a;i++){var b=n?sap.ui.getCore().byId(I[i]):I[i];if(b.getVisible()){var d=b.getId();var e=d==s;r.write("<li");r.addStyle("display","inline-block");r.writeStyles();if(e){r.write(" class='sapUiUx3NavBarItemSel'");}r.write("><a ");r.writeElementData(b);r.writeAttributeEscaped("href",b.getHref()||'#');r.write(" aria-setsize='"+a+"' aria-posinset='"+(i+1)+"' role='menuitemradio' class='sapUiUx3NavBarItem'");if(e){r.write(" tabindex='0'");}r.write(" aria-checked='"+(e?"true":"false")+"'");var t=b.getTooltip_AsString();if(t){r.write(" title='"+q.sap.encodeHTML(t)+"'");}r.write(">");r.write(q.sap.encodeHTML(b.getText()));r.write("</a></li>");}}var f;if(c._bRtl){f="right:"+c._iLastArrowPos;}else{f="left:"+c._iLastArrowPos;}r.write("<span id='"+c.getId()+"-arrow' style='"+f+"px;");r.write("' class='sapUiUx3NavBarArrow'></span>");};
return N;},true);
sap.ui.predefine('sap/ui/ux3/NavigationItem',['jquery.sap.global','sap/ui/core/Item','./library'],function(q,I,l){"use strict";
var N=I.extend("sap.ui.ux3.NavigationItem",{metadata:{library:"sap.ui.ux3",properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true},href:{type:"sap.ui.core.URI",group:"Behavior",defaultValue:null}},defaultAggregation:"subItems",aggregations:{subItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"subItem"}}}});
return N;},true);
sap.ui.predefine('sap/ui/ux3/NotificationBar',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','sap/ui/core/theming/Parameters','./library',"./NotificationBarRenderer"],function(q,C,I,P,l,N){"use strict";
var a=C.extend("sap.ui.ux3.NotificationBar",{metadata:{library:"sap.ui.ux3",properties:{visibleStatus:{type:"sap.ui.ux3.NotificationBarStatus",group:"Misc",defaultValue:sap.ui.ux3.NotificationBarStatus.Default},resizeEnabled:{type:"boolean",group:"Misc",defaultValue:true},alwaysShowToggler:{type:"boolean",defaultValue:false,since:"1.24.5"}},aggregations:{messageNotifier:{type:"sap.ui.core.Element",multiple:false},notifiers:{type:"sap.ui.core.Element",multiple:true,singularName:"notifier"}},events:{display:{parameters:{show:{type:"boolean"}}},resize:{parameters:{status:{type:"sap.ui.ux3.NotificationBarStatus"}}}}}});
C.extend("sap.ui.ux3.NotificationBar.NotifierView",{
renderMessages:function(r){r.write("<div");r.writeAttribute("id",this.getId()+"-content");r.addClass("sapUiNotifierContent");r.writeClasses();r.write(">");var m=this.getMessages();var i=m.length-1;var f=true;for(;i>=0;i--){if(!f||(i==0&&m.length>1)){r.write("<div");r.addClass("sapUiNotificationBarCltSep");r.writeClasses();r.write(">");r.write("</div>");}else{f=false;}var M=m[i];if(M._message&&M._message.getReadOnly()){M.addStyleClass("sapUiNotifierMessageReadOnly");}r.renderControl(M);}r.write("</div>");},
metadata:{properties:{"title":"string","visibleItems":"int","renderMode":{type:"string",defaultValue:"callout"}},aggregations:{"messages":"sap.ui.ux3.NotificationBar.MessageView"}},
init:function(){this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");},
exit:function(){if(this._renderedControl){delete this._renderedControl;}delete this._oResBundle;},
getTitle:function(){var t=this.getProperty("title");var c=this.getMessages().length;if(c>0){var k="NOTIBAR_NOTIFIER_VIEW_TITLE";t=this._oResBundle.getText(k,[t,c]);}return t;},
renderer:function(r,c){r.write("<div");r.addClass("sapUiNotifierContainer");r.writeControlData(c);r.writeClasses();r.write(">");r.write("<div");r.writeAttribute("id",c.getId()+"-title");r.addClass("sapUiNotifierTitle");r.writeClasses();r.write(">");r.writeEscaped(c.getTitle());r.write("</div>");if(c.getMessages().length>0){c.renderMessages(r);}r.write("</div>");},
onAfterRendering:function(){var $=this.$("content"),b=$.children(".sapUiNotifierMessage"),c=b.length,v=this.getVisibleItems();if(c>v){q.sap.delayedCall(0,this,this._fnAfterRenderingCallback,[b,$,v]);}},
_fnAfterRenderingCallback:function($,b,v){var t=v-1,c=0;$.each(function(){if(c===v){b.css("max-height",t);return;}t+=q(this).outerHeight();c++;});}
});
C.extend("sap.ui.ux3.NotificationBar.MessageView",{
metadata:{properties:{"text":"string","timestamp":"string","icon":"sap.ui.core.URI"}},
renderer:function(r,c){var i=c.getId();r.write("<div");r.writeControlData(c);r.addClass("sapUiNotifierMessage");r.writeClasses();r.writeAttribute("tabindex","0");r.write(">");if(c.getIcon()){r.write("<div");r.writeAttribute("id",i+"-icon");r.addClass("sapUiNotifierMessageIcon");r.writeClasses();r.write(">");r.write("<img");r.writeAttributeEscaped("src",c.getIcon());r.write("/>");r.write("</div>");}r.write("<div");r.writeAttribute("id",i+"-text");r.addClass("sapUiNotifierMessageText");r.writeClasses();r.write(">");r.writeEscaped(c.getText());r.write("</div>");r.write("<div");r.writeAttribute("id",i+"-timestamp");r.addClass("sapUiNotifierMessageTimestamp");r.writeClasses();r.write(">");r.writeEscaped(c.getTimestamp());r.write("</div>");r.write("</div>");},
onclick:function(e){if(!this._message.getReadOnly()){var n=this._message.getParent();n.fireMessageSelected({message:this._message,notifier:n});}},
onsapselect:function(e){this.onclick(e);},
exit:function(e){if(this._message){delete this._message;}}
});
(function(){var c=function(t){var i=t.hasItems();var j=t.getVisibleStatus();if(i&&j==="None"){return true;}else if(!i&&j!=="None"){return true;}else if(!i&&j!=="Min"){return true;}else{return false;}};var s=function(t,i){var j=i.getMessages().concat([]);if(j.length>0){j.sort(sap.ui.core.Message.compareByType);var u=j.length-1;t._sSeverestMessageLevel=j[u].getLevel();}};var f=function(E){var j=E.getParameter("callout");switch(E.getParameter("type")){case"added":case"removed":var t=E.getParameter("notifier");if(this.getMessageNotifier()&&this.getMessageNotifier().getId()===t.getId()){s(this,this.getMessageNotifier());}if(c(this)){var u=this.hasItems();this.fireDisplay({show:u});}else{this.invalidate();if(E.getParameter("type")==="removed"){if(j.getContent().length>0){var v=j.getContent()[0];var M=E.getParameter("message");var x=v.getMessages();var y;for(var i=0;i<x.length;i++){y=x[i];if(M.getId()===y._message.getId()){y.destroy();j.rerender();j.adjustPosition();break;}}}}}break;case"openCallout":j.destroyContent();var t=E.getParameter("notifier");t.destroyAggregation("views",true);var z=t.getId();var A=this.getMessageNotifier();if(A&&z===A.getId()){z+="-messageNotifierView";}else{z+="-messageView";}var B=new a.NotifierView(z,{title:t.getTitle(),visibleItems:this._visibleItems});if(t._bEnableMessageSelect){B.addStyleClass("sapUiNotifierSelectable");}var D=t.getMessages();for(var i=0;i<D.length;i++){var V=b(D[i],t,this);B.addMessage(V);}t.addAggregation("views",B,true);j.addContent(B);break;}};a.HOVER_ITEM_HEIGHT=16;
a.prototype.init=function(){this._oItemNavigation=new I();this._oItemNavigation.setCycling(true);this.addDelegate(this._oItemNavigation);this._iCalloutWidth=parseInt(250,10);this._iCalloutHeight=parseInt(200,10);this._visibleItems=5;this._eventListener=q.proxy(f,this);this._oResBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._togglerPosition="50%";this._gapMessageArea="5";this._sSeverestMessageLevel=sap.ui.core.MessageType.None;q(window).bind("resize",q.proxy(o,this));this._proxyEnableMessageSelect=q.proxy(e,this);this.data("sap-ui-fastnavgroup","true",true);this.setAlwaysShowToggler(false);};
a.prototype.exit=function(){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;delete this._iCalloutWidth;delete this._iCalloutHeight;delete this._visibleItems;delete this._eventListener;if(this.getMessageNotifier()){var M=this.getMessageNotifier();M._oMessageArea.destroy();delete M._oMessageArea;}delete this._resizeFrom;delete this._resizeTo;delete this._oResBundle;delete this._formerVisibleStatus;delete this._togglerPosition;delete this._gapMessageArea;delete this._isHovered;delete this._togglerClicked;delete this._sSeverestMessageLevel;q(window).unbind("resize",o);delete this._proxyEnableMessageSelect;};
var b=function(M,i,j){var t=new a.MessageView(i.getId()+"-messageView-"+M.getId(),{text:M.getText(),timestamp:M.getTimestamp()});t._message=M;if(i.sParentAggregationName=="messageNotifier"){if(j.getVisibleStatus()==sap.ui.ux3.NotificationBarStatus.Max){t.setIcon(M.getIcon()||M.getDefaultIcon("32x32"));}else{t.setIcon(M.getIcon()||M.getDefaultIcon());}}else{t.setIcon(M.getIcon());}return t;};var r=function(t,i){i.attachEvent("_childControlCalling",t._eventListener,t);};var d=function(t,i){i.detachEvent("_childControlCalling",t._eventListener,t);};
a.prototype.addNotifier=function(i){if(i){var j=(this.getVisibleStatus()==sap.ui.ux3.NotificationBarStatus.None)?true:false;this.addAggregation("notifiers",i,j);r(this,i);}return this;};
a.prototype.insertNotifier=function(i,j){if(i){this.insertAggregation("notifiers",i,j);r(this,i);}return this;};
a.prototype.removeNotifier=function(i){var j=this.removeAggregation("notifiers",i);d(this,j);return j;};
a.prototype.removeAllNotifiers=function(){var j=this.removeAllAggregation("notifiers");for(var i=0;i<j.length;i++){var t=j[i];d(this,t);}return j;};
a.prototype.destroyNotifiers=function(){var j=this.getNotifiers();for(var i=0;i<j.length;i++){var t=j[i];d(this,t);}this.destroyAggregation("notifiers");return this;};
var e=function(E){var M=this.getMessageNotifier();if(M&&M.getId()===E.getParameter("notifier").getId()){M.invalidate();}};
a.prototype.setMessageNotifier=function(M){var i=this.getMessageNotifier();if(i){i._oMessageArea.destroy();delete i._oMessageArea;i.detachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);d(this,i);}this.setAggregation("messageNotifier",M);if(M){M._oMessageArea=new a.MessageView(this.getId()+"-inplaceMessage");M._oMessageArea.setParent(M);M.attachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);r(this,M);}return this;};
a.prototype.destroyMessageNotifier=function(M){var i=this.getMessageNotifier();if(i){i._oMessageArea.destroy();delete i._oMessageArea;i.detachEvent("_enableMessageSelect",this._proxyEnableMessageSelect);d(this,i);}this.destroyAggregation("messageNotifier");return this;};
var S=function(t,i){var T=t.$();switch(i){case sap.ui.ux3.NotificationBarStatus.Min:T.addClass("sapUiNotificationBarMinimized");break;case sap.ui.ux3.NotificationBarStatus.Max:var H=t.getHeightOfStatus(t.getVisibleStatus());T.addClass("sapUiNotificationBarMaximized");T.css("height",H);var $=t.$("containers");$.css("max-height",H);break;case sap.ui.ux3.NotificationBarStatus.None:if(!t._resizeTo){T.css("display","none");}break;case sap.ui.ux3.NotificationBarStatus.Default:default:T.removeClass("sapUiNotificationBarMaximized");T.removeClass("sapUiNotificationBarMinimized");break;}};var R=function(t){if(w(t)){var F=t.getHeightOfStatus(t._resizeFrom);var T=t.$();T.css("height",F);var j=t.getHeightOfStatus(t._resizeTo);T.stop(true,true).animate({height:j},"fast",function(){var u=t.getVisibleStatus();if(u==="None"){T.css("display","none");if(t.hasItems()){if(t.getMessageNotifier()){var M=t.getMessageNotifier();M.$().css("display","none");}if(t.getNotifiers().length>0){var v=t.getNotifiers();for(var i=0;i<v.length;i++){v[i].$().css("display","none");}}}}S(t,u);n(t,u);});}else{var u=t.getVisibleStatus();S(t,u);}delete t._resizeFrom;delete t._resizeTo;};var g=function(t){if(t.getMessageNotifier()&&t.getMessageNotifier().hasItems()){var $;var j=t.getId()+"-notifiers";var u=q.sap.byId(j);if(u.length>0){var T=parseInt(u.width(),10);var v=u.children();for(var i=0;i<v.length;i++){var x=q(v[i]);if(x.hasClass("sapUiNotifier")){T-=x.width();}else if(x.hasClass("sapUiNotifierSeparator")){T-=x.width();}else if(x.hasClass("sapUiInPlaceMessage")){$=x;}}if($){T-=t._gapMessageArea+2;$.css("width",T+"px");}}}};
a.prototype.onAfterRendering=function(){this._oItemNavigation.setRootDomRef(this.getDomRef());var t=[];var u=this.getVisibleStatus()===sap.ui.ux3.NotificationBarStatus.Max;if(u){var M=this.getMessageNotifier();if(M!=null){var v=M.getMessages();var x=M.getId()+"-messageNotifierView-messageView-";for(var i=v.length-1;i>=0;i--){var D=q.sap.domById(x+v[i].getId());if(D){t.push(D);}}}var y=this.getNotifiers();for(var i=0;i<y.length;i++){var v=y[i].getMessages();var x=y[i].getId()+"-notifierView-messageView-";for(var j=v.length-1;j>=0;j--){var D=q.sap.domById(x+v[j].getId());if(D){t.push(D);}}}}else{var y=this.getNotifiers();for(var i=0;i<y.length;i++){var D=y[i].getDomRef();if(D){t.push(D);}}var M=this.getMessageNotifier();if(M!=null){var D=M.getDomRef();if(D){t.push(D);}D=this.getDomRef("inplaceMessage");if(D&&q(D).hasClass("sapUiInPlaceMessageSelectable")){t.push(D);}}}this._oItemNavigation.setItemDomRefs(t);R(this);g(this);h(this,this.getMessageNotifier());k(this);if(sap.ui.Device.browser.mobile){var $=this.$("toggler");if(this.getVisibleStatus()!==sap.ui.ux3.NotificationBarStatus.None){$.css("display","block");}else{$.css("display","none");}}};
var h=function(t,M){if(M&&M.hasItems()){var $=M.$("counter");$.removeClass("sapUiMessageInformation");$.removeClass("sapUiMessageSuccess");$.removeClass("sapUiMessageWarning");$.removeClass("sapUiMessageError");s(t,M);var L=t._sSeverestMessageLevel;$.addClass("sapUiMessage"+L);var i=M.getMessages().length;var K="NOTIBAR_MESSAGE_NOTIFIER_DESC_LEVEL_"+L.toUpperCase()+(i===1?"_SING":"_PL");m(t,M,K,i);}};var k=function(t){var j=t.getNotifiers();for(var i=0;i<j.length;i++){var u=j[i].getMessages().length;var K="NOTIBAR_NOTIFIER_COUNT_TEXT_"+(u===1?"SING":"PL");m(t,j[i],K,u);}};var m=function(t,i,K,j){var $=i.$("description");var M=t._oResBundle.getText(K,[j]);$.html(M);};var o=function(E){g(this);};var w=function(t){if(t._resizeFrom&&t._resizeTo){if(t._resizeFrom!=t._resizeTo){return true;}}return false;};
a.prototype.hasItems=function(){var j=this.getNotifiers();if(j.length>0){for(var i=0;i<j.length;i++){var t=j[i];if(t.hasItems()){return true;}}}if(this.getMessageNotifier()){if(this.getMessageNotifier().hasItems()){return true;}}return false;};
var n=function(i,t){var j="none";var $=i.$();switch(t){case sap.ui.ux3.NotificationBarStatus.Max:case sap.ui.ux3.NotificationBarStatus.None:break;case sap.ui.ux3.NotificationBarStatus.Min:$.stop().animate({height:i.getHeightOfStatus(t)},{duration:"fast",queue:true});$.addClass("sapUiNotificationBarMinimized");i.$("notifiers").css("display","none");j="block";break;default:case sap.ui.ux3.NotificationBarStatus.Default:$.stop().animate({height:i.getHeightOfStatus(t)},{duration:"fast",queue:true});$.removeClass("sapUiNotificationBarMaximized");$.removeClass("sapUiNotificationBarMinimized");break;}var u=i.$("hoverItem");u.css("display",j);};
a.prototype.onfocusin=function(E){if(this._togglerClicked){delete this._togglerClicked;E.stopImmediatePropagation(true);}};
a.prototype.onclick=function(E){this._togglerClicked=true;this.$().blur();var $=q(document.activeElement);p(this);var i=E.target.id;var j=i.split("-");if(j){var v=this.getVisibleStatus();var t=j.length-1;switch(j[t]){case"ArrowUp":if(v==="Min"){this.setVisibleStatus("Default");}else{this.setVisibleStatus("Max");}break;case"ArrowDown":if(v==="Max"){this.setVisibleStatus("Default");}else{this.setVisibleStatus("Min");}E.preventDefault();break;case"BarUp":if(this._formerVisibleStatus){this.setVisibleStatus(this._formerVisibleStatus);}else{this.setVisibleStatus("Default");}break;case"BarDown":this._formerVisibleStatus=v;this.setVisibleStatus("Min");$.blur();break;default:if($.hasClass("sapUiNotifier")){$.focus();}else{if(this.hasItems()){var u=this.getNotifiers();if(u.length>0){var x=q(u[0]);x.focus();}else{var y=this.getMessageNotifier();if(y){q(y).focus();}}}}break;}}};
a.prototype.onThemeChanged=function(E){if(this.getDomRef()){this.invalidate();}};
var p=function(t){var j=t.getNotifiers();for(var i=0;i<j.length;i++){var u=j[i];u._oCallout.close();}if(t.getMessageNotifier()){t.getMessageNotifier()._oCallout.close();}};
a.prototype.getHeightOfStatus=function(i){var j="";if(i==sap.ui.ux3.NotificationBarStatus.Min){j="sapUiNotificationBarHeightMinimized";}else if(i==sap.ui.ux3.NotificationBarStatus.Default){j="sapUiNotificationBarHeight";}else if(i==sap.ui.ux3.NotificationBarStatus.Max){j="sapUiNotificationBarHeightMaximized";j=P.get(j);var t=j.indexOf("%");if(t!=-1){var u=j.substring(0,t);var H=q(window).height();H=parseInt(H/100*u,10);var _=parseInt(this.getHeightOfStatus(sap.ui.ux3.NotificationBarStatus.Default),10);if(H<_){H=_+1;}}else{var M="No valid percantage value given for maximized size. 400px is used";q.sap.log.warning(M);H=400;}return H+"px";}else{return"0px";}j=P.get(j);return j;};
a.prototype.setVisibleStatus=function(t){this._resizeFrom=this.getVisibleStatus();this._resizeTo=t;if(this._resizeFrom!==this._resizeTo){if(t===sap.ui.ux3.NotificationBarStatus.None){p(this);if(this.getDomRef()){n(this,t);}else{this.$().css({"height":"0px","display":"none"});}}this.setProperty("visibleStatus",t);this.fireResize({status:t});}};
a.prototype.setAlwaysShowToggler=function(A){if(sap.ui.Device.browser.mobile){A=true;}this.setProperty("alwaysShowToggler",A,true);var $=this.$("toggler");if(A){$.css("display","block");}else{$.css("display","none");}};
}());return a;},true);
sap.ui.predefine('sap/ui/ux3/NotificationBarRenderer',['jquery.sap.global','sap/ui/core/Icon'],function(q,I){"use strict";var N={};(function(){
N.render=function(o,i){w(o,i);W(o,i);c(o,i);};
var w=function(o,i){o.write("<div");o.writeControlData(i);if(i.getVisibleStatus()===sap.ui.ux3.NotificationBarStatus.None){if(i.$().length>0){if(i._resizeFrom){i.$().stop().animate({height:0},"fast",function(){i.$().css("display","none");o.addStyle("display","none");o.writeAttribute("aria-hidden","true");});}else{o.addStyle("display","none");o.writeAttribute("aria-hidden","true");}}else{o.addStyle("display","none");o.writeAttribute("aria-hidden","true");}}else{o.writeAttribute("aria-hidden","false");o.addStyle("display","block");}o.writeStyles();o.addClass("sapUiNotificationBar");if(i._resizeTo){if(i._resizeFrom==sap.ui.ux3.NotificationBarStatus.Max){if(i._resizeTo==sap.ui.ux3.NotificationBarStatus.Default){o.addClass("sapUiNotificationBarMaximized");}}}o.writeClasses();o.write(">");f(o,i);};var r=function(o,i){var s=i.getVisibleStatus();if(s!=="None"){var k=i.getId()+"-toggler";o.write("<div");o.writeAttribute("id",k);o.addClass("sapUiBarToggle");if(s!=="Min"){o.addClass("sapUiBarToggleWide");}o.writeClasses();if(i.getAlwaysShowToggler()){o.addStyle("display","block");o.writeStyles();}o.write(">");R(o,i,"ArrowUp");R(o,i,"ArrowDown");R(o,i,"BarUp");R(o,i,"BarDown");o.write("</div>");}else{o.addStyle("display","none");o.writeStyles();}};var R=function(o,i,s){o.write("<div");var k=i.getId()+"-"+s;o.writeAttribute("id",k);var S=i.getVisibleStatus();var H=true;var t="";switch(s){case"ArrowUp":if(S==="Default"){H=false;}t=i._oResBundle.getText("NOTIBAR_TITLE_ENLARGE");break;case"ArrowDown":if(S==="Max"){H=false;}t=i._oResBundle.getText("NOTIBAR_TITLE_MINIMIZE");break;case"BarUp":if(S==="Min"){H=false;}t=i._oResBundle.getText("NOTIBAR_TITLE_BAR_UP");break;case"BarDown":if(S==="Max"||S==="Default"){H=false;}t=i._oResBundle.getText("NOTIBAR_TITLE_BAR_DOWN");break;}o.writeAttributeEscaped("title",t);if(H){o.addClass("sapUiBarToggleHide");}o.addClass("sapUiBarToggle"+s);o.addClass("sapUiBarToggleItem");o.writeClasses();o.write(">");o.write("</div>");};var f=function(o,i){o.write("<div");var s=i.getId()+"-hoverItem";o.writeAttribute("id",""+s);var S=i.getVisibleStatus();if(S==="Min"){o.addStyle("top","-"+sap.ui.ux3.NotificationBar.HOVER_ITEM_HEIGHT+"px");o.addStyle("display","block");}else{o.addStyle("display","none");}if(i.getDomRef()){var $=q(i.getDomRef());var k=$.width()+"px";o.addStyle("width",k);}o.writeStyles();o.addClass("sapUiNotiHover");o.writeClasses();o.write(">");o.write("</div>");};var W=function(o,i){if(i.getResizeEnabled()){r(o,i);}if(i.hasItems()){if(i.getVisibleStatus()==sap.ui.ux3.NotificationBarStatus.Max){a(o,i);}else{b(o,i);}}};var a=function(o,k){var n=k.getNotifiers();var m=k.getMessageNotifier();var s="";o.write("<div");o.writeAttribute("id",k.getId()+"-containers");o.addClass("sapUiNotifierContainers");o.writeClasses();o.write(">");if(m&&m.hasItems()){m.destroyAggregation("views",true);s=m.getId()+"-messageNotifierView";var M=C(s,m);m.addAggregation("views",M,true);o.renderControl(M);}if(n.length>0){for(var i=0;i<n.length;i++){if(n[i].hasItems()){n[i].destroyAggregation("views",true);s=n[i].getId()+"-notifierView";var v=C(s,n[i]);n[i].addAggregation("views",v,true);o.renderControl(v);}}}o.write("</div");};var b=function(o,k){var n=k.getNotifiers();var m=k.getMessageNotifier();o.write("<ul");o.writeAttribute("id",k.getId()+"-notifiers");o.addClass("sapUiNotifiers");o.writeClasses();o.write(">");var M=false;for(var i=0;i<n.length;i++){if(n[i].hasItems()){M=true;break;}}var l=(m&&m.hasItems())?true:false;if(M){e(o,n);}if(M&&l){o.write("<li");o.addClass("sapUiNotifierSeparator");o.writeClasses();o.write(">");o.write("&nbsp;");o.write("</li>");}if(l){h(o,m,k);}o.write("</ul>");};var c=function(o,i){o.write("</div>");};var d=function(o,n,m){var i=n.getId();o.write("<li");o.writeElementData(n);o.addClass("sapUiNotifier");o.writeClasses();o.writeAttribute("tabindex","-1");o.writeAttribute("aria-describedby",i+'-description>');o.write(">");g(o,n.getIcon(),m);o.write('<div id="'+i+'-description"');o.addStyle("display","none");o.writeStyles();o.write(">");o.write("</div>");var k=n.getMessages().length;if(k>0){o.write('<div id="'+i+'-counter" role="tooltip"');o.addClass("sapUiNotifierMessageCount");if(m){o.addClass("sapUiMessage");}o.writeClasses();o.write(">");if(k>99){k=">99";}o.write(k);o.write("</div>");}o.write("</li>");};var C=function(s,n){var o=new sap.ui.ux3.NotificationBar.NotifierView(s,{title:n.getTitle(),renderMode:"maximized"});if(n._bEnableMessageSelect){o.addStyleClass("sapUiNotifierSelectable");}var m=n.getMessages();for(var i=0;i<m.length;i++){var M=m[i];var k=new sap.ui.ux3.NotificationBar.MessageView(s+"-messageView-"+M.getId(),{text:M.getText(),timestamp:M.getTimestamp()});k._message=M;k.setIcon(M.getIcon()||M.getDefaultIcon("32x32"));o.addMessage(k);}return o;};var e=function(o,n){for(var i=0;i<n.length;i++){d(o,n[i],false);}};var g=function(o,u,m){if(u==null||u==""){var i=new I({useIconTooltip:false});i.addStyleClass("sapUiNotifierIcon");if(m){i.setSrc("sap-icon://alert");}else{i.setSrc("sap-icon://notification-2");}o.renderControl(i);return;}o.write("<img alt=\"\"");o.addClass("sapUiNotifierIcon");o.writeClasses();o.writeAttributeEscaped("src",u);o.write("/>");};var h=function(o,n,i){d(o,n,true);j(o,n,i);};var j=function(o,m,n){if(m.hasItems()){var M=m.getMessages();var l=M[M.length-1];var i=m._oMessageArea;i._message=l;var s=n.getId()+"-inplaceMessage-"+i._message.getId();o.write("<li");o.writeAttribute("id",s);o.addClass("sapUiInPlaceMessage");o.writeClasses();if(n._gapMessageArea){var k=n._gapMessageArea+"px";o.addStyle("margin-left",k);o.writeStyles();}o.write(">");if(l.getText()!=""){o.write("<div");o.writeControlData(i);o.writeAttribute("tabindex","-1");o.addClass("sapUiNotifierMessageText");o.addClass("sapUiInPlaceMessage");if(m._bEnableMessageSelect&&!i._message.getReadOnly()){o.addClass("sapUiInPlaceMessageSelectable");}o.writeClasses();o.write(">");o.writeEscaped(l.getText());o.write("</div>");}if(l.getTimestamp()!=""){o.write("<div");o.addClass("sapUiNotifierMessageTimestamp");o.addClass("sapUiInPlaceMessage");o.writeClasses();o.write(">");o.writeEscaped(l.getTimestamp());o.write("</div>");}o.write("</li>");}};}());return N;},true);
sap.ui.predefine('sap/ui/ux3/Notifier',['jquery.sap.global','sap/ui/commons/Callout','sap/ui/core/Element','./library'],function(q,C,E,l){"use strict";
var N=E.extend("sap.ui.ux3.Notifier",{metadata:{library:"sap.ui.ux3",properties:{icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},title:{type:"string",group:"Misc",defaultValue:null}},aggregations:{messages:{type:"sap.ui.core.Message",multiple:true,singularName:"message"},views:{type:"sap.ui.core.Control",multiple:true,singularName:"view",visibility:"hidden"}},events:{messageSelected:{parameters:{message:{type:"sap.ui.core.Message"},notifier:{type:"sap.ui.ux3.Notifier"}}}}}});
(function(){var b=function(){this.fireEvent("_childControlCalling",{type:"openCallout",callout:this._oCallout,notifier:this});};var c=function(o){if(o.getSource()){o.getSource().destroyContent();}if(this._oCallout){this._oCallout.$().css("display","none");}};
N.prototype.hasItems=function(){if(this.getMessages().length>0){return true;}return false;};
N.prototype.init=function(){this._oCallout=new C(this.getId()+"-callout",{beforeOpen:q.proxy(b,this),open:function(o){this.$().css({position:"fixed",display:"block"});},close:q.proxy(c,this),collision:"none"});this._oCallout.addStyleClass("sapUiNotifierCallout");if(sap.ui.Device.browser.mobile){this._oCallout.setOpenDelay(0);}this._oCallout.setMyPosition("begin bottom");this._oCallout.setAtPosition("begin top");this._oCallout.setTip=function(){C.prototype.setTip.apply(this,arguments);var $=this.$("arrow");$.css("bottom","-24px");var r=sap.ui.getCore().getConfiguration().getRTL();if(!r){$.css("left","6px");}};this.setTooltip(this._oCallout);this.setTooltip=function(){q.sap.log.warning("Setting toolstips for notifiers deactivated");};this._proxyEnableMessageSelect=q.proxy(e,this);this.attachEvent(sap.ui.base.EventProvider.M_EVENTS.EventHandlerChange,this._proxyEnableMessageSelect);};
var e=function(o){var s=o.getParameter("EventId");if(s==="messageSelected"){if(o.getParameter("type")==="listenerAttached"){this._bEnableMessageSelect=true;}else if(o.getParameter("type")==="listenerDetached"){this._bEnableMessageSelect=false;}this.fireEvent("_enableMessageSelect",{enabled:this._bEnableMessageSelect,notifier:this});}};
N.prototype.exit=function(o){this._oCallout=undefined;if(this._oMessageView){this._oMessageView.destroy();delete this._oMessageView;}this.detachEvent(sap.ui.base.EventProvider.M_EVENTS.EventHandlerChange,this._proxyEnableMessageSelect);delete this._proxyEnableMessageSelect;};
N.prototype.onclick=function(o){o.preventDefault();this.$().trigger("mouseover");};
var f=function(t,m,T){var L=m?m.getLevel():sap.ui.core.MessageType.None;T.fireEvent("_childControlCalling",{type:t,notifier:T,level:L,message:m,callout:T._oCallout});};
N.prototype.addMessage=function(m){this.addAggregation("messages",m);f("added",m,this);return this;};
N.prototype.insertMessage=function(m,i){this.insertAggregation("messages",m,i);f("added",m,this);return this;};
N.prototype.removeMessage=function(m){var r=this.removeAggregation("messages",m);if(r){f("removed",r,this);}return r;};
N.prototype.removeAllMessages=function(){var r=this.removeAllAggregation("messages");if(r.length>0){f("removed",null,this);}return r;};
N.prototype.destroyMessages=function(){var L=this.getMessages().length;this.destroyAggregation("messages");if(L>0){f("removed",null,this);}return this;};
}());return N;},true);
sap.ui.predefine('sap/ui/ux3/Overlay',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/Popup','./library',"./OverlayRenderer"],function(q,C,P,l,O){"use strict";
var a=C.extend("sap.ui.ux3.Overlay",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{openButtonVisible:{type:"boolean",group:"Misc",defaultValue:true},closeButtonVisible:{type:"boolean",group:"Misc",defaultValue:true}},events:{close:{allowPreventDefault:true,parameters:{id:{type:"string"}}},closed:{allowPreventDefault:true,parameters:{id:{type:"string"}}},openNew:{parameters:{id:{type:"string"}}},open:{parameters:{id:{type:"string"}}}}}});
a.prototype.init=function(){var t=this;this._oPopup=new P(this,false,true);this._oPopup.attachOpened(function(e){var d=q.sap.byId(t._initialFocusId)[0];if(!d&&t._getShell()&&t.getOpenButtonVisible()){d=q.sap.domById(t._getOpenButtonId());}else if(!d&&t._getShell()&&t.getCloseButtonVisible()){d=q.sap.domById(t._getCloseButtonId());}else if(!d){d=t.$("content").firstFocusableDomRef();}if(!d){d=t.$().firstFocusableDomRef();}if(d){q.sap.focus(d);}});this._oPopup.attachClosed(function(e){t.fireClosed({id:t.getId()});});this._overridePopupEventing();};
a.prototype._overridePopupEventing=function(){this._oPopup.onmousedown=function(e){return;};};
a.prototype._getShell=function(){var s=q(".sapUiUx3Shell").control();if(s.length>0&&!this._oShell){this._oShell=s.length?s[0]:null;}return this._oShell;};
a.prototype._getCloseButtonId=function(){return this.getId()+"-close";};
a.prototype._getOpenButtonId=function(){return this.getId()+"-openNew";};
a.prototype._initDom=function(f,F,A){var s=q(".sapUiUx3Shell").control();this._oShell=s.length?s[0]:null;s=this._oShell;this.$().css("position","fixed");if(s){this._bFocusEventsRegistered=true;s.syncWithCanvasSize(this.getId(),true,f,F,A);this.$("firstFocusDummyPaneFw").attr("tabindex","0").focusin(q.proxy(s.focusFirstHdr,s));this.$("firstFocusDummyPaneBw").attr("tabindex","0").focusin(q.proxy(s.focusLastTool,s));this.$("LastFocusDummyPane").attr("tabindex","0").focusin(q.proxy(s.focusPaneStart,s));}else{this.$().css("bottom","0").css("top","0").css("left","0").css("right","0");}};
a.prototype._cleanupDom=function(){if(this._oShell){this._oShell.syncWithCanvasSize(this.getId(),false);}if(this._bFocusEventsRegistered){this._bFocusEventsRegistered=false;this.$("firstFocusDummyPaneFw").removeAttr("tabindex").unbind("focusin");this.$("firstFocusDummyPaneBw").removeAttr("tabindex").unbind("focusin");this.$("LastFocusDummyPane").removeAttr("tabindex").unbind("focusin");}};
a.prototype.onAfterRendering=function(){var p=this._oPopup.getOpenState();if(p===sap.ui.core.OpenState.OPEN||p===sap.ui.core.OpenState.OPENING){this._initDom(q.proxy(this._setFocusFirst,this),q.proxy(this._setFocusLast,this),q.proxy(this._applyChanges,this));}};
a.prototype.onBeforeRendering=function(){};
a.prototype.exit=function(){this.close();this._oPopup.destroy();this._oPopup=null;this._oShell=null;};
a.prototype.open=function(i){this._initialFocusId=i;if(this._oPopup.isOpen()){return;}if(i){this._oPopup.setInitialFocusId(i);}this._oPreviousFocus=P.getCurrentFocusInfo();this._oPopup.open(400);this._initDom(q.proxy(this._setFocusFirst,this),q.proxy(this._setFocusLast,this),q.proxy(this._applyChanges,this));this.fireOpen({id:this.getId()});};
a.prototype.close=function(){if(!this._oPopup.isOpen()){return;}this._oPopup.close(400);q.sap.delayedCall(400,this,'restorePreviousFocus');this._cleanupDom();};
a.prototype.onclick=function(e){this._handleButtonEvent(e);};
a.prototype.onsapselect=function(e){this._handleButtonEvent(e);};
a.prototype._handleButtonEvent=function(e){var b=e.target.id;if(b===this._getCloseButtonId()){if(this.fireClose({id:this.getId()})){this.close();}}else if(b===this._getOpenButtonId()){this.fireOpenNew({id:this.getId()});}};
a.prototype._getText=function(k,A){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var t;if(r){t=r.getText(k);}if(t&&A){for(var i=0;i<A.length;i++){t=t.replace("{"+i+"}",A[i]);}}return t?t:k;};
a.prototype._setFocusFirst=function(){q.sap.focus(q.sap.domById(this._getOpenButtonId()));};
a.prototype._setFocusLast=function(){q.sap.focus(q.sap.domById(this._getCloseButtonId()));};
a.prototype._applyChanges=function(c){return this;};
a.prototype.isOpen=function(){return this._oPopup.isOpen();};
a.prototype.restorePreviousFocus=function(){P.applyFocusInfo(this._oPreviousFocus);};
return a;},true);
sap.ui.predefine('sap/ui/ux3/OverlayContainer',['jquery.sap.global','./Overlay','./library',"./OverlayContainerRenderer"],function(q,O,l,a){"use strict";
var b=O.extend("sap.ui.ux3.OverlayContainer",{metadata:{library:"sap.ui.ux3",defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
b.prototype._setFocusLast=function(){var f=this.$("content").lastFocusableDomRef();if(!f&&this.getCloseButtonVisible()){f=this.getDomRef("close");}else if(!f&&this.getOpenButtonVisible()){f=this.getDomRef("openNew");}q.sap.focus(f);};
b.prototype._setFocusFirst=function(){if(this.getOpenButtonVisible()){q.sap.focus(this.getDomRef("openNew"));}else if(this.getCloseButtonVisible()){q.sap.focus(this.getDomRef("close"));}else{q.sap.focus(this.$("content").firstFocusableDomRef());}};
return b;},true);
sap.ui.predefine('sap/ui/ux3/OverlayContainerRenderer',['jquery.sap.global','sap/ui/core/Renderer','./OverlayRenderer'],function(q,R,O){"use strict";var a=R.extend(O);
a.renderContent=function(r,c){var b=r;b.write("<div role='Main' class='sapUiUx3OCContent' id='"+c.getId()+"-content'>");var d=c.getContent();for(var i=0;i<d.length;i++){var e=d[i];b.renderControl(e);}b.write("</div>");};
a.addRootClasses=function(r,c){var b=r;b.addClass("sapUiUx3OC");};
a.addOverlayClasses=function(r,c){var b=r;b.addClass("sapUiUx3OCOverlay");};
return a;},true);
sap.ui.predefine('sap/ui/ux3/OverlayDialog',['jquery.sap.global','sap/ui/core/IntervalTrigger','./Overlay','./library',"./OverlayDialogRenderer"],function(q,I,O,l,a){"use strict";
var b=O.extend("sap.ui.ux3.OverlayDialog",{metadata:{library:"sap.ui.ux3",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'auto'}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}}}});
b.prototype.init=function(){O.prototype.init.apply(this);this.setProperty("openButtonVisible",false);b.Trigger=new I(300);};
b.prototype._setFocusLast=function(){var f=this.$("content").lastFocusableDomRef();if(!f&&this.getCloseButtonVisible()){f=this.getDomRef("close");}q.sap.focus(f);};
b.prototype._setFocusFirst=function(){if(this.getCloseButtonVisible()){q.sap.focus(this.getDomRef("close"));}else{q.sap.focus(this.$("content").firstFocusableDomRef());}};
b.prototype.setOpenButtonVisible=function(v){q.sap.log.warning("OverlayDialog does not support an openButton.");return undefined;};
b.prototype.setWidth=function(w){if(w=="auto"||w=="inherit"){w="auto";}return this.setProperty("width",w);};
b.prototype.setHeight=function(h){if(h=="auto"||h=="inherit"){h="auto";}return this.setProperty("height",h);};
b.prototype.onBeforeRendering=function(){O.prototype.onBeforeRendering.apply(this,arguments);this._cleanup();};
b.prototype.onAfterRendering=function(){O.prototype.onAfterRendering.apply(this,arguments);b.Trigger.addListener(this._checkChange,this);};
b.prototype._cleanup=function(){b.Trigger.removeListener(this._checkChange,this);this.contentWidth=null;this.contentHeight=null;this.overlayWidth=null;this.overlayHeight=null;};
b.prototype.exit=function(){this._cleanup();O.prototype.exit.apply(this,arguments);};
b.prototype._checkChange=function(){if(!this.getDomRef()){return;}var $=this.$("content"),c=this.$(),A=this.getWidth()==="auto",d=this.getHeight()==="auto";var e=A?Math.round(c.width()/2):$.width(),f=d?Math.round(c.height()/2):$.height(),o=c.width(),g=c.height();if(e!=this.contentWidth||f!=this.contentHeight||o!=this.overlayWidth||g!=this.overlayHeight){$.css("left","0").css("right","auto").css("top","0").css("bottom","auto").css("width",this.getWidth()).css("height",this.getHeight());this.contentWidth=e;this.contentHeight=f;this.overlayWidth=o;this.overlayHeight=g;var h=this.$("close");if(this.contentWidth<this.overlayWidth){$.css("left","50%");$.css("right","auto");$.css("margin-left",Math.round((-1)*this.contentWidth/2)+"px");$.css("width",d?this.contentWidth:this.getWidth());h.css("right","50%");h.css("margin-right",Math.round((-1)*this.contentWidth/2-10)+"px");}else{$.css("left","0");$.css("right","10px");$.css("margin-left","0");$.css("width","auto");h.css("right","0");h.css("margin-right","0");}if(this.contentHeight<this.overlayHeight-30){$.css("top","50%");$.css("bottom","auto");$.css("margin-top",Math.round((-1)*this.contentHeight/2)+"px");$.css("height",d?this.contentHeight:this.getHeight());h.css("top","50%");h.css("margin-top",Math.round((-1)*this.contentHeight/2-10)+"px");}else{$.css("top","10px");$.css("bottom","30px");$.css("margin-top","0");$.css("height","auto");h.css("top","0");h.css("margin-top","0");}}};
return b;},true);
sap.ui.predefine('sap/ui/ux3/OverlayDialogRenderer',['jquery.sap.global','sap/ui/core/Renderer','./OverlayRenderer'],function(q,R,O){"use strict";var a=R.extend(O);
a.renderContent=function(r,c){var b=r;b.write("<div role='Main' class='sapUiUx3ODContent' id='"+c.getId()+"-content'>");var d=c.getContent();for(var i=0;i<d.length;i++){var e=d[i];b.renderControl(e);}b.write("</div>");};
a.addRootClasses=function(r,c){var b=r;b.addClass("sapUiUx3OD");};
a.addOverlayClasses=function(r,c){var b=r;b.addClass("sapUiUx3ODOverlay");};
return a;},true);
sap.ui.predefine('sap/ui/ux3/OverlayRenderer',['jquery.sap.global'],function(q){"use strict";var O={};
O.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.addClass("sapUiUx3Overlay");if(this.addRootClasses){this.addRootClasses(a,c);}a.writeClasses();a.write(">");a.write("<div role='presentation'");a.addClass("sapUiUx3OverlayOverlay");if(this.addOverlayClasses){this.addOverlayClasses(a,c);}a.writeClasses();a.write(">");a.write("</div>");a.write("<span class='sapUiUx3OverlayFocusDummyPane' id='"+c.getId()+"-firstFocusDummyPaneFw'></span>");a.write("<span class='sapUiUx3OverlayFocusDummyPane' id='"+c.getId()+"-firstFocusDummyPaneBw'></span>");if(c.getOpenButtonVisible()){a.write("<a role=\"button\" aria-disabled=\"false\" class='sapUiUx3OverlayOpenButton' id='"+c.getId()+"-openNew' tabindex=\"0\" title=\""+c._getText("OVERLAY_OPEN_BUTTON_TOOLTIP")+"\">"+c._getText("OVERLAY_OPEN_BUTTON_TEXT")+"</a>");}if(c.getCloseButtonVisible()){a.write("<a role=\"button\" aria-disabled=\"false\" class='sapUiUx3OverlayCloseButton' id='"+c.getId()+"-close' tabindex=\"0\" aria-label='"+c._getText("OVERLAY_CLOSE_BUTTON_TOOLTIP")+"'></a>");}if(this.renderContent){this.renderContent(a,c);}a.write("<span class='sapUiUx3OverlayFocusDummyPane' id='"+c.getId()+"-LastFocusDummyPane'></span>");a.write("</div>");};
return O;},true);
sap.ui.predefine('sap/ui/ux3/QuickView',['jquery.sap.global','sap/ui/commons/CalloutBase','sap/ui/core/delegate/ItemNavigation','./ActionBar','./library',"./QuickViewRenderer"],function(q,C,I,A,l,Q){"use strict";
var a=C.extend("sap.ui.ux3.QuickView",{metadata:{library:"sap.ui.ux3",properties:{type:{type:"string",group:"Misc",defaultValue:null},firstTitle:{type:"string",group:"Misc",defaultValue:null},firstTitleHref:{type:"string",group:"Misc",defaultValue:null},secondTitle:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},showActionBar:{type:"boolean",group:"Misc",defaultValue:true},followState:{type:"sap.ui.ux3.FollowActionState",group:"Misc",defaultValue:sap.ui.ux3.FollowActionState.Default},flagState:{type:"boolean",group:"Misc",defaultValue:false},favoriteState:{type:"boolean",group:"Misc",defaultValue:false},favoriteActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},updateActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},followActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},flagActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},openActionEnabled:{type:"boolean",group:"Misc",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Element",multiple:true,singularName:"content"},actions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"action"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false}},events:{actionSelected:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"},newState:{type:"string"}}},feedSubmit:{parameters:{text:{type:"string"}}},navigate:{allowPreventDefault:true,parameters:{href:{type:"string"}}}}}});
a.prototype.init=function(){var o;function b(d){var p=d.getParameters();this.fireActionSelected(p);}function c(d){var p=d.getParameters();this.fireFeedSubmit(p);}C.prototype.init.call(this);if(!this.getActionBar()){o=new A();o.attachActionSelected(q.proxy(b,this));o.attachFeedSubmit(q.proxy(c,this));this.setAggregation("actionBar",o,true);}};
a.prototype.onmouseover=function(e){var p=this._getPopup();if(p.isOpen()&&p.getContent()==this){if(this.sCloseNowTimeout){q.sap.clearDelayedCall(this.sCloseNowTimeout);this.sCloseNowTimeout=null;}return;}sap.ui.core.TooltipBase.prototype.onmouseover.call(this,e);};
a.prototype.onAfterRendering=function(){var f=this.getDomRef(),d=[];var r=this.$("title");d.push(r);r=this.$("link");if(!r.length){r=this.$("name");}if(!r.length){return;}d.push(r);r=this.$("descr");if(r.length){d.push(r);}if(!this.oItemNavigation){this.oItemNavigation=new I(null,null,false);this.addDelegate(this.oItemNavigation);}this.oItemNavigation.setRootDomRef(f);this.oItemNavigation.setItemDomRefs(d);this.oItemNavigation.setCycling(false);this.oItemNavigation.setSelectedIndex(1);this.oItemNavigation.setPageSize(d.length);};
a.prototype.onclick=function(e){var t=e.target;if(!t||!t.hasAttribute("href")){return;}if(!this.fireEvent("navigate",{href:t.href},true,false)){e.preventDefault();}};
a.prototype.exit=function(){if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();delete this.oItemNavigation;}};
a.prototype.insertAction=function(o,i){if(this.getActionBar()){this.getActionBar().insertBusinessAction(o,i);}return this;};
a.prototype.addAction=function(o){if(this.getActionBar()){this.getActionBar().addBusinessAction(o);}return this;};
a.prototype.removeAction=function(o){if(this.getActionBar()){this.getActionBar().removeBusinessAction(o);}return this;};
a.prototype.removeAllActions=function(){if(this.getActionBar()){this.getActionBar().removeAllBusinessActions();}return this;};
a.prototype.getActions=function(){if(this.getActionBar()){this.getActionBar().getBusinessActions();}return this;};
a.prototype.destroyActions=function(){if(this.getActionBar()){this.getActionBar().destroyBusinessActions();}return this;};
a.prototype.setFollowState=function(f){if(this.getActionBar()){this.getActionBar().setFollowState(f);}return this;};
a.prototype.getFollowState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFollowState();}return r;};
a.prototype.setFlagState=function(f){if(this.getActionBar()){this.getActionBar().setFlagState(f);}return this;};
a.prototype.getFlagState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFlagState();}return r;};
a.prototype.setFavoriteState=function(f){if(this.getActionBar()){this.getActionBar().setFavoriteState(f);}return this;};
a.prototype.getFavoriteState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFavoriteState();}return r;};
a.prototype.setFavoriteActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowFavorite(e);}return this;};
a.prototype.getFavoriteActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFavorite();}return r;};
a.prototype.setFlagActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowFlag(e);}return this;};
a.prototype.getFlagActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFlag();}return r;};
a.prototype.setUpdateActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowUpdate(e);}return this;};
a.prototype.getUpdateActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowUpdate();}return r;};
a.prototype.setFollowActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowFollow(e);}return this;};
a.prototype.getFollowActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFollow();}return r;};
a.prototype.setOpenActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowOpen(e);}return this;};
a.prototype.getOpenActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowOpen();}return r;};
a.prototype.setIcon=function(i){this.setProperty("icon",i);if(this.getActionBar()){this.getActionBar().setThingIconURI(i);}return this;};
a.prototype.setActionBar=function(o){this.setAggregation("actionBar",o,true);if(this.getIcon()&&this.getActionBar()){this.getActionBar().setThingIconURI(this.getIcon());}return this;};
return a;},true);
sap.ui.predefine('sap/ui/ux3/QuickViewRenderer',['jquery.sap.global','sap/ui/commons/CalloutBaseRenderer','sap/ui/core/Renderer','sap/ui/core/IconPool'],function(q,C,R,I){"use strict";var Q=R.extend(C);
Q.renderContent=function(r,c){var a=r;var A=sap.ui.getCore().getConfiguration().getAccessibility();var t=c.getType(),n=c.getFirstTitle(),h=c.getFirstTitleHref(),i=c.getIcon(),d=c.getSecondTitle(),w=c.getWidth(),s=c.getId(),b=c.getTooltip_AsString(),o;a.write("<div");if(b){a.writeAttributeEscaped("title",b);}if(A){a.writeAttribute("role","dialog");a.writeAttribute("aria-labelledby",s+"-title");}a.addClass("sapUiUx3QV");a.writeClasses();if(w){a.addStyle("width",w);a.writeStyles();}a.write(">");a.write("<div");a.writeAttribute("id",s+"-title");a.writeAttribute("tabindex","-1");a.addClass("sapUiUx3QVHeader");a.writeClasses();a.write(">");a.writeEscaped(t);a.write("</div>");if(i||n||d){a.write("<div");if(A){a.writeAttribute("role","heading");}a.addClass("sapUiUx3QVHeading");a.writeClasses();a.write(">");if(i){if(I.isIconURI(i)){o={title:n,tabindex:"-1"};}a.writeIcon(i,"sapUiUx3QVIcon",o);}a.write("<span");a.writeAttribute("id",s+"-name");if(A&&d){a.writeAttribute("aria-describedby",s+"-descr");}a.addClass("sapUiUx3QVTitle1");a.writeClasses();a.write(">");if(h){a.write("<a");a.writeAttribute("id",s+"-link");a.writeAttributeEscaped("href",h);a.writeAttribute("tabindex","-1");a.write(">");}a.writeEscaped(n||"");if(h){a.write("</a>");}a.write("</span>");if(d){a.write("<br><span");a.writeAttribute("id",s+"-descr");a.writeAttribute("tabindex","-1");a.addClass("sapUiUx3QVTitle2");a.writeClasses();a.write(">");a.writeEscaped(d);a.write("</span>");}a.write("</div>");}a.write("<div id=\""+s+"-content\">");this.renderBody(a,c);a.write("</div>");a.write("</div>");if(c.getShowActionBar()&&c.getActionBar()){a.renderControl(c.getActionBar());}};
Q.renderBody=function(r,c){var a=c.getContent();for(var i=0;i<a.length;i++){r.write("<div class=\"sapUiUx3QVBody\">");if(a[i]instanceof sap.ui.core.Control){r.renderControl(a[i]);}else if(a[i].getContent&&typeof a[i].getContent=="function"){var b=a[i].getContent();for(var j=0;j<b.length;j++){if(b[j]instanceof sap.ui.core.Control){r.renderControl(b[j]);}}}r.write("</div>");}};
return Q;},true);
sap.ui.predefine('sap/ui/ux3/Shell',['jquery.sap.global','sap/ui/commons/Menu','sap/ui/core/Control','sap/ui/core/theming/Parameters','./library',"./ShellRenderer"],function(q,M,C,P,l,S){"use strict";
var a=C.extend("sap.ui.ux3.Shell",{metadata:{library:"sap.ui.ux3",properties:{appTitle:{type:"string",group:"Misc",defaultValue:null},appIcon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},appIconTooltip:{type:"string",group:"Misc",defaultValue:null},showLogoutButton:{type:"boolean",group:"Misc",defaultValue:true},logoutButtonTooltip:{type:"string",group:"Accessibility",defaultValue:null},showSearchTool:{type:"boolean",group:"Misc",defaultValue:true},showInspectorTool:{type:"boolean",group:"Misc",defaultValue:false,deprecated:true},showFeederTool:{type:"boolean",group:"Misc",defaultValue:true},showTools:{type:"boolean",group:"Misc",defaultValue:true},showPane:{type:"boolean",group:"Misc",defaultValue:true},headerType:{type:"sap.ui.ux3.ShellHeaderType",group:"Misc",defaultValue:sap.ui.ux3.ShellHeaderType.Standard},designType:{type:"sap.ui.ux3.ShellDesignType",group:"Misc",defaultValue:sap.ui.ux3.ShellDesignType.Standard},paneWidth:{type:"int",group:"Misc",defaultValue:250},applyContentPadding:{type:"boolean",group:"Appearance",defaultValue:true},fullHeightContent:{type:"boolean",group:"Appearance",defaultValue:false},allowOverlayHeaderAccess:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"content",aggregations:{worksetItems:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"worksetItem"},paneBarItems:{type:"sap.ui.core.Item",multiple:true,singularName:"paneBarItem"},paneContent:{type:"sap.ui.core.Control",multiple:true,singularName:"paneContent"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},toolPopups:{type:"sap.ui.ux3.ToolPopup",multiple:true,singularName:"toolPopup"},headerItems:{type:"sap.ui.core.Control",multiple:true,singularName:"headerItem"},notificationBar:{type:"sap.ui.ux3.NotificationBar",multiple:false},_paneOverflowMenu:{type:"sap.ui.commons.Menu",multiple:false,visibility:"hidden"}},associations:{selectedWorksetItem:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{worksetItemSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}},paneBarItemSelected:{parameters:{id:{type:"string"},item:{type:"sap.ui.core.Item"},key:{type:"string"}}},logout:{},search:{},feedSubmit:{},paneClosed:{parameters:{id:{type:"string"}}}}}});
a.WSI_MENU_DELAY=200;a.WSI_OVERFLOW_SCROLL_STEP=250;a.TOOL_PREFIX="-tool-";a.FIRST_RENDERING=true;a.SIDE_BAR_BASE_WIDTH=null;a.PANE_OVERFLOW_BUTTON_HEIGHT=null;
a.prototype.init=function(){this._iOpenPaneIndex=-1;this._sOpenWsiId=null;this._bPreviousScrollRight=false;this._bPreviousScrollLeft=false;this._sSelectedWorksetId=null;this._sSelectedFacetId=null;this._aSyncRefStack=[];this._mSyncRefs={};this._oWorksetBar=new sap.ui.ux3.NavigationBar(this.getId()+"-wsBar",{toplevelVariant:true,select:[this._handleWorksetBarSelect,this]}).setParent(this);this._oFacetBar=new sap.ui.ux3.NavigationBar(this.getId()+"-facetBar",{select:[this._handleFacetBarSelect,this]}).setParent(this);this.setAggregation("_paneOverflowMenu",new M());var t=this;this._checkResizeClosure=function(){t._checkResize();};this.currentToolPaletteWidth=0;this._updateThemeVariables();};
a.prototype.exit=function(){if(this._oWorksetBar){this._oWorksetBar.destroy();delete this._oWorksetBar;}if(this._oFacetBar){this._oFacetBar.destroy();delete this._oFacetBar;}this._oSearchField=null;q(window).unbind("resize",this._checkResizeClosure);};
a.prototype.onBeforeRendering=function(){this._beforeRenderingToolPalette();this.$("focusDummyPane").unbind("focusin");if(window.FileReader){var $=this.$("hdr");$.unbind('dragover',this._handleDragover).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);var b=this.$("bgImg");b.unbind('dragover',q.proxy(this._handleDragover)).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);}};
a.prototype.onAfterRendering=function(){this._afterRenderingToolPalette();if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusLast){this.$("focusDummyPane").focusin(this._mSyncRefs[this._topSyncRefId].focusLast);}if(window.FileReader){var $=this.$("hdr");$.bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));var b=this.$("bgImg");b.bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));}var s=(this._oFacetBar.getAssociatedItems().length>0);var f=this.$("facetBar");f.css("display",(s?"block":"none"));this._adaptContentHeight();this._bRtl=sap.ui.getCore().getConfiguration().getRTL();if(this._getPersonalization().hasChanges()){this._getPersonalization().applySettings(this._getPersonalization().oSettings);}if(!this._oPaneItemNavigation){this._oPaneItemNavigation=new sap.ui.core.delegate.ItemNavigation().setCycling(false);this.addDelegate(this._oPaneItemNavigation);}var p=this.$("paneBarEntries");this._updatePaneBarItemNavigation(p);this._setNotifyVisibility();if(a.FIRST_RENDERING){q(window).bind("resize",this._checkResizeClosure);}this._checkResize();a.FIRST_RENDERING=false;if(!!sap.ui.Device.browser.firefox&&sap.ui.Device.browser.version==17){q.sap.delayedCall(500,this,this._checkResize);}};
a.prototype._updateThemeVariables=function(){a.SIDE_BAR_BASE_WIDTH=parseInt(P.get("sapUiUx3ShellSideBarBaseWidth"),10);a.PANE_OVERFLOW_BUTTON_HEIGHT=parseInt(P.get("sapUiUx3ShellPaneOverflowButtonHeight"),10);a.PANE_OVERFLOW_BUTTON_MAX_HEIGHT=a.PANE_OVERFLOW_BUTTON_HEIGHT;};
a.prototype._checkResize=function(){if(!this.getDomRef()){return;}q.sap.clearDelayedCall(this._checkResizeDelayId);this._checkResizeDelayId=q.sap.delayedCall(100,this,function(){this._rerenderPaneBarItems();this._checkToolPaletteSize();});};
a.prototype._checkToolPaletteSize=function(h){if(!this.getDomRef()){return;}if(h===undefined){h=!this.getShowTools();}var t=this.$("tp");var c=1;var L=9999999;var i=0;var k=true;if(h){c=0;k=false;}do{var b=c*a.SIDE_BAR_BASE_WIDTH;var s=Math.floor(b/2);var d=Math.floor(b/4);var e=this._bRtl?"right":"left";this.$("canvas").css(e,b+"px");this.$("canvasBackground").css(e,b+"px");this.$("wBar").css("margin-"+e,b+"px");var p={};p[e]=b+"px";this.$("notify").css(p);t.css("width",b+"px");var p={};p["width"]=s+"px";p["margin-"+e]=d+"px";this.$("tp-separator").css(p);if(!k){break;}sap.ui.core.RenderManager.forceRepaint(t[0]);i=t.children().last()[0].offsetTop;if(i>=L){c--;k=false;continue;}L=i;c++;if(c>10){q.sap.log.error("The ToolPalette is growing too much, this must be a bug.");break;}}while(i>t.height());this.currentToolPaletteWidth=this.getShowTools()?b:0;this._updateOverlaysOnToolPaletteChange();};
a.prototype._updateOverlaysOnToolPaletteChange=function(){var o=this._getSyncRefs();if(this._bRtl){o.css("right",this.currentToolPaletteWidth+"px");}else{o.css("left",this.currentToolPaletteWidth+"px");}};
a.prototype._updatePaneBarItemNavigation=function(p){this._oPaneItemNavigation.setRootDomRef(p[0]);var b=p.children().toArray();this._oPaneItemNavigation.setItemDomRefs(b);if(this._oPaneItemNavigation.getFocusedIndex()>b.length){this._oPaneItemNavigation.setFocusedIndex(-1);}this._checkPaneBarOverflow(p);};
a.prototype._checkPaneBarOverflow=function(p){q.sap.clearDelayedCall(this._checkPaneBarOverflowDelayId);this._checkPaneBarOverflowDelayId=q.sap.delayedCall(200,this,function(){this._delayedCheckPaneBarOverflow(p);});};
a.prototype._delayedCheckPaneBarOverflow=function(p){if(!p){p=this.$("paneBarEntries");}if(p.length==0){this._checkPaneBarOverflow();return;}var L=p.parent().height()-(this._bRtl?p.innerHeight():0);var I=0;var e=p.children();e.css("display","inline-block");var b=false;var c=e.length;for(var i=c-1;i>=0;--i){var d=e[i];if(this._bRtl){I=(0-d.offsetLeft);}else{I=d.offsetLeft+d.offsetWidth;}var f=I<L;q(d).css("display",f?"inline-block":"none");sap.ui.getCore().byId(d.id+"-overflow").setVisible(!f);if(f){continue;}else{b=true;}}var o=this.$("paneBarOverflowButton");if(b){o.css("display","block");}else{o.css("display","none");if(!!sap.ui.Device.browser.firefox&&sap.ui.Device.browser.version==17){sap.ui.core.RenderManager.forceRepaint(document.getElementsByTagName("body")[0]);}}var O=this._changeOverflowButton();if(O){this._checkPaneBarOverflow();}};
a.prototype._adaptOverflowButtonHeight=function(){var b=this.$("paneBarOverflowButton");var B=this.$("paneBarOverflowWrapper");var $=this.$("paneBarOverflowText");var p=this.$("paneBarRight");$.css("width","");var o=a.PANE_OVERFLOW_BUTTON_HEIGHT;var s=$[0].scrollWidth+5;if(s>a.PANE_OVERFLOW_BUTTON_MAX_HEIGHT){a.PANE_OVERFLOW_BUTTON_HEIGHT=a.PANE_OVERFLOW_BUTTON_MAX_HEIGHT;}else{a.PANE_OVERFLOW_BUTTON_HEIGHT=s;}b.css("height",a.PANE_OVERFLOW_BUTTON_HEIGHT);B.css("width",a.PANE_OVERFLOW_BUTTON_HEIGHT);$.css("width","100%");p.css("padding-bottom",a.PANE_OVERFLOW_BUTTON_HEIGHT+"px");return(o!=a.PANE_OVERFLOW_BUTTON_HEIGHT);};
a.prototype._changeOverflowButton=function(){var o=null;if(this._sOpenPaneId){o=sap.ui.getCore().byId(this._sOpenPaneId+"-overflow");}var t=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON");var s=false;if(o&&o.getVisible()){t=o.getText();s=true;}t=t.toUpperCase();var b=this.$("paneBarOverflowText");b.text(t);b.attr("title",t);b.toggleClass("sapUiUx3ShellPaneEntrySelected",s);return this._adaptOverflowButtonHeight();};
a.prototype._getPaneOverflowMenu=function(){return this.getAggregation("_paneOverflowMenu");};
a.prototype.getFocusInfo=function(){try{var e=document.activeElement;return e?{'sFocusId':e.id,'oFocusedElement':e}:{};}catch(b){return{};}};
a.prototype.applyFocusInfo=function(f){var e=q.sap.domById(f.sFocusId)||f.oFocusedElement;q.sap.focus(e);};
a._updateToolIcon=function(d){if(d&&d.firstChild){var $=q(d);var t=d.id.substr(d.id.indexOf(a.TOOL_PREFIX)+6);var b=sap.ui.getCore().byId(t);var i;if($.is(".sapUiUx3ShellToolSelected")){i=b.getIconSelected();}else if($.is(".sapUiUx3ShellToolHover")){i=b.getIconHover();}else{i=b.getIcon();}d.firstChild.src=i;}};
a.prototype.onclick=function(e){this.onUserActivation(e);};
a.prototype.onsapspace=function(e){this.onUserActivation(e);};
a.prototype.onsapenter=function(e){this.onUserActivation(e);};
a.prototype.onUserActivation=function(e){var t=e.target.id;var p=e.target.parentNode;var i=this.getId();if(e.target.className&&e.target.className.indexOf&&e.target.className.indexOf("sapUiUx3ShellHeader-logout")>-1){this.fireLogout();}else if(p&&p.parentNode&&p.parentNode.className&&p.parentNode.className.indexOf&&p.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(t);}else if(p&&p.parentNode&&p.parentNode.parentNode&&p.parentNode.parentNode.className&&p.parentNode.parentNode.className.indexOf&&p.parentNode.parentNode.className.indexOf("sapUiUx3ShellToolPaletteArea")>-1){this._handleToolItemClick(p.id);}else if(t===i+"-paneBarOverflowText"){var T=this.$("paneBarOverflowButton")[0];this._getPaneOverflowMenu().open(true,T,(this._bRtl?"left":"right")+" bottom","center center",T);}else if(t){if(p&&p.className&&p.className.indexOf&&p.className.indexOf("sapUiUx3ShellPaneEntries")>-1){this._handlePaneBarItemClick(t);}}};
a.prototype._handleWorksetBarSelect=function(e){var p=this._handleWorksetItemClick(e.getParameter("item"));if(!p){e.preventDefault();}};
a.prototype._handleFacetBarSelect=function(e){var p=this._handleWorksetItemClick(e.getParameter("item"));if(!p){e.preventDefault();}};
a.prototype._handleWorksetItemClick=function(e){var p=e.getParent(),i=e.getId(),f=i,b=true;if(p instanceof a){if(i!=this._sSelectedWorksetId){var s=e.getSubItems();if(s.length>0){f=s[0].getId();}b=this._fireWorksetItemSelected(f);if(b){this._sSelectedWorksetId=i;if(s.length>0){this._sSelectedFacetId=s[0].getId();i=this._sSelectedFacetId;}else{this._sSelectedFacetId=null;}var s=e.getSubItems();this._oFacetBar.setAssociatedItems(s,true);var F=this.$("facetBar");var c=this._calcFacetBarHeight(F);if(s.length>0){if(!this._oFacetBar.isSelectedItemValid()){this._oFacetBar.setSelectedItem(s[0]);this._sSelectedFacetId=s[0].getId();}F.slideDown();this._adaptContentHeight(null,true,c);}else{this._oFacetBar.setSelectedItem(null);F.slideUp();this._adaptContentHeight(null,true,c);}}}}else{if(i!=this._sSelectedFacetId){b=this._fireWorksetItemSelected(f);if(b){this._sSelectedFacetId=i;}}}return b;};
a.prototype._fireWorksetItemSelected=function(i){var b=sap.ui.getCore().byId(i);var k=(b?b.getKey():null);var p=this.fireWorksetItemSelected({id:i,item:b,key:k});if(p){this.setAssociation("selectedWorksetItem",i,true);}return p;};
a.prototype._closeCurrentToolPopup=function(){var o;if(this._oOpenToolPopup){o=this._oOpenToolPopup.getId();q.sap.byId(this.getId()+a.TOOL_PREFIX+this._oOpenToolPopup.getId()).removeClass("sapUiUx3ShellToolSelected").attr("aria-pressed","false");if(o===this.getId()+"-feederTool"){var f=sap.ui.getCore().byId(this.getId()+"-feeder");f.setText("");f.rerender();}this._oOpenToolPopup.close();this._oOpenToolPopup=null;}return o;};
a.prototype._handleToolItemClick=function(i){var A=this._closeCurrentToolPopup();var t;var b=i.substr(i.indexOf(a.TOOL_PREFIX)+6);if(b==(this.getId()+"-searchTool")){t=this._getSearchTool();}else if(b==(this.getId()+"-feederTool")){t=this._getFeederTool();}else{t=sap.ui.getCore().byId(b);}if(t&&(t.getId()!=A)){this._oOpenToolPopup=t;t.setPosition(sap.ui.core.Popup.Dock.BeginTop,sap.ui.core.Popup.Dock.EndTop,q.sap.domById(i),"13 -6","fit");t.open();q.sap.byId(i).addClass("sapUiUx3ShellToolSelected").attr("aria-pressed","true");a._updateToolIcon(q.sap.domById(i));var c=this;var o=function(e){t.detachClosed(o);if(c._oOpenToolPopup&&c._oOpenToolPopup.getId()===e.getParameter("id")){c._closeCurrentToolPopup();}q.sap.byId(i).removeClass("sapUiUx3ShellToolSelected");a._updateToolIcon(q.sap.domById(i));};t.attachClosed(o);}else if(t.getId()==A){a._updateToolIcon(q.sap.domById(i));}};
a.prototype._hasDarkDesign=function(){return(this.getDesignType()!==sap.ui.ux3.ShellDesignType.Light&&this.getDesignType()!==sap.ui.ux3.ShellDesignType.Crystal);};
a.prototype._getSearchTool=function(){if(!this._oSearchPopup){var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oSearchPopup=new sap.ui.ux3.ToolPopup(this.getId()+"-searchTool",{tooltip:r.getText("SHELL_SEARCH")}).addStyleClass("sapUiUx3TP-search");var i=this._hasDarkDesign();this._oSearchPopup.setInverted(i);var t=this;var s=new sap.ui.commons.SearchField(this.getId()+"-searchField",{enableListSuggest:false,search:function(e){t.fireSearch({text:e.getParameter("query")});}});var b=new sap.ui.commons.Label({text:r.getText("SHELL_SEARCH_LABEL")+":"}).setLabelFor(s);this._oSearchPopup.addContent(b).addContent(s);this._oSearchPopup.attachOpen(function(){window.setTimeout(function(){s.focus();},100);});this._oSearchField=s;}return this._oSearchPopup;};
a.prototype.getSearchField=function(){if(!this._oSearchField){this._getSearchTool();}return this._oSearchField;};
a.prototype._getFeederTool=function(){if(!this._oFeederPopup){var t=this;var r=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");this._oFeederPopup=new sap.ui.ux3.ToolPopup(this.getId()+"-feederTool",{tooltip:r.getText("SHELL_FEEDER")}).addStyleClass("sapUiUx3TP-feeder");var i=this._hasDarkDesign();this._oFeederPopup.setInverted(i);var f=new sap.ui.ux3.Feeder(this.getId()+"-feeder",{type:sap.ui.ux3.FeederType.Medium,submit:function(e){t.fireFeedSubmit({text:e.getParameter("text")});f.setText("");f.rerender();t._oFeederPopup.close();}});this._oFeederPopup.setInitialFocus(this.getId()+"-feeder");this._oFeederPopup.attachClose(function(){f.setText("");});this._oFeederPopup.addContent(f);}return this._oFeederPopup;};
a.prototype.openPane=function(p){var t=this;var i=sap.ui.getCore().byId(p);if(i&&(p!=this._sOpenPaneId)&&this.getShowPane()){var k;if(i){if(i.getKey()==""){k=null;}else{k=i.getKey();}}else{k=null;}this.firePaneBarItemSelected({"id":p,"item":i,"key":k});var o=q.sap.byId(p);o.siblings().removeClass("sapUiUx3ShellPaneEntrySelected");o.addClass("sapUiUx3ShellPaneEntrySelected");if(!this._sOpenPaneId){this._openPane(function(){t.focusPaneStart();});}else{q.sap.byId(this.getId()+"-pb_"+this._sOpenPaneId).removeClass("sapUiUx3ShellPaneEntrySelected");}this._sOpenPaneId=p;}return this;};
a.prototype.closePane=function(){this._closePane();return this;};
a.prototype.isPaneOpen=function(){return(this._sOpenPaneId!=null);};
a.prototype._handlePaneBarItemClick=function(p){if(p===this._sOpenPaneId){this.closePane();}else{this.openPane(p);}this._checkPaneBarOverflow();};
(function(){a._SHELL_OFFSET_RIGHT=0;
a.prototype._closePane=function(c){if(!this._sOpenPaneId){if(c){c();}return;}var o=this._sOpenPaneId;var t=this;var i=this.getId();var d=this.getShowPane()?(q.sap.byId(i+"-paneBarRight").outerWidth()+a._SHELL_OFFSET_RIGHT):a._SHELL_OFFSET_RIGHT;var p={};p[this._bRtl?"left":"right"]=d+"px";var b={};b[this._bRtl?"marginLeft":"marginRight"]=(d-a._SHELL_OFFSET_RIGHT)+"px";q.sap.byId(i+"-content").css("overflow-x","hidden");q.sap.byId(i+"-canvas").stop().animate(p);q.sap.byId(i+"-notify").stop().animate(p);this._getSyncRefs().stop(false,true).animate(p);q.sap.byId(i+"-wBar").stop().animate(b);q.sap.byId(i+"-paneBar").removeClass("sapUiUx3ShellPaneBarOpened").addClass("sapUiUx3ShellPaneBarClose");q.sap.byId(i+"-canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundOpen").addClass("sapUiUx3ShellCanvasBackgroundClosed").stop().animate(p,function(){q.sap.byId(i+"-paneBar").removeClass("sapUiUx3ShellPaneBarOpen");q.sap.byId(i+"-content").css("overflow-x","");if(c){c();}t.firePaneClosed({"id":o});});q.sap.byId(this._sOpenPaneId).removeClass("sapUiUx3ShellPaneEntrySelected");this._sOpenPaneId=null;};
a.prototype._openPane=function(o){var i=this.getId();var b=this.getPaneWidth();var p=q.sap.byId(i+"-paneBarRight").outerWidth();q.sap.byId(i+"-content").css("overflow-x","hidden");if(this._bRtl){q.sap.byId(i+"-paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");q.sap.byId(i+"-wBar").stop().animate({marginLeft:(b+p)+"px"});q.sap.byId(i+"-canvas").stop().animate({left:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});q.sap.byId(i+"-notify").stop().animate({left:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});this._getSyncRefs().stop(false,true).animate({left:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});q.sap.byId(i+"-canvasBackground").stop().animate({left:(b+p+a._SHELL_OFFSET_RIGHT)+"px"},function(){q.sap.byId(i+"-content").css("overflow-x","");q.sap.byId(i+"-canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");q.sap.byId(i+"-paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(o){o();}});}else{q.sap.byId(i+"-paneBar").removeClass("sapUiUx3ShellPaneBarClose").addClass("sapUiUx3ShellPaneBarOpen");q.sap.byId(i+"-wBar").stop().animate({marginRight:(b+p)+"px"});q.sap.byId(i+"-canvas").stop().animate({right:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});q.sap.byId(i+"-notify").stop().animate({right:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});this._getSyncRefs().stop(false,true).animate({right:(b+p+a._SHELL_OFFSET_RIGHT)+"px"});q.sap.byId(i+"-canvasBackground").stop().animate({right:(b+p+a._SHELL_OFFSET_RIGHT)+"px"},function(){q.sap.byId(i+"-content").css("overflow-x","");q.sap.byId(i+"-canvasBackground").removeClass("sapUiUx3ShellCanvasBackgroundClosed").addClass("sapUiUx3ShellCanvasBackgroundOpen");q.sap.byId(i+"-paneBar").addClass("sapUiUx3ShellPaneBarOpened");if(o){o();}});}};
a.prototype.setPaneWidth=function(w){if(typeof w=="number"&&(w>0)){w=Math.max(w,50);if(this.getDomRef()){var i=this.getId();q.sap.byId(i+"-paneContent").css("width",w+"px");q.sap.byId(i+"-paneBar").css("width",(w+a.SIDE_BAR_BASE_WIDTH)+"px");if(!!this._sOpenPaneId){if(this._bRtl){q.sap.byId(i+"-wBar").css("marginLeft",(w+a.SIDE_BAR_BASE_WIDTH)+"px");q.sap.byId(i+"-canvas").css("left",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");q.sap.byId(i+"-notify").css("left",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");this._getSyncRefs().css("left",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");q.sap.byId(i+"-canvasBackground").css("left",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");}else{q.sap.byId(i+"-wBar").css("marginRight",(w+a.SIDE_BAR_BASE_WIDTH)+"px");q.sap.byId(i+"-canvas").css("right",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");q.sap.byId(i+"-notify").css("right",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");this._getSyncRefs().css("right",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");q.sap.byId(i+"-canvasBackground").css("right",(w+a.SIDE_BAR_BASE_WIDTH+a._SHELL_OFFSET_RIGHT)+"px");}}}this.setProperty("paneWidth",w,true);}return this;};
a.prototype.setOffsetRight=function(p,c,o){if(p<0){p=0;}if(p>600){p=600;}a._SHELL_OFFSET_RIGHT=p;var b=p+"px";var i=this.getId();var d=this._bRtl?{"left":b}:{"right":b};q.sap.byId(i+"-hdr").stop().animate(d);q.sap.byId(i+"-hdrImg").stop().animate(d);q.sap.byId(i+"-bg").stop().animate(d,function(){if(c){c();}});q.sap.byId(i+"-bgImg").stop().animate(d);q.sap.byId(i+"-wBar").stop().animate(d);q.sap.byId(i+"-paneBar").stop().animate(d);q.sap.byId(o).stop().animate({"width":b});if(!this.$().hasClass("sapUiUx3ShellNoPane")){b=(p+(this._sOpenPaneId?this.getPaneWidth():0)+a.SIDE_BAR_BASE_WIDTH)+"px";}d=this._bRtl?{"left":b}:{"right":b};q.sap.byId(i+"-notify").stop().animate(d);this._getSyncRefs().stop(false,true).animate(d);q.sap.byId(i+"-canvas").stop().animate(d);q.sap.byId(i+"-canvasBackground").stop().animate(d);};
a.prototype._refreshCanvasOffsetRight=function(p){var i=this.getId();var r=this._bRtl?"left":"right";var b=a._SHELL_OFFSET_RIGHT;if(p){var c=q.sap.byId(i+"-paneBarRight").outerWidth();b=b+(this._sOpenPaneId?this.getPaneWidth():0)+c;}b=b+"px";q.sap.byId(i+"-notify").css(r,b);q.sap.byId(i+"-canvas").css(r,b);q.sap.byId(i+"-canvasBackground").css(r,b);this._getSyncRefs().css(r,b);};
a.prototype._setNotifyVisibility=function(v){var n=this.getNotificationBar();if(!n){return;}if(!v){v=n.getVisibleStatus();}var $=this.$("notify");var b=this._topSyncRefId?q.sap.byId(this._topSyncRefId):q(null);var i=b.hasClass("sapUiUx3TI");var h=0;var B=0;if(v===sap.ui.ux3.NotificationBarStatus.Min){h=10;}else if(v===sap.ui.ux3.NotificationBarStatus.Max||v===sap.ui.ux3.NotificationBarStatus.Default){if(this.getHeaderType()===sap.ui.ux3.ShellHeaderType.BrandOnly&&i){h=parseInt(n.getHeightOfStatus(sap.ui.ux3.NotificationBarStatus.Default),10);}else{h=10;}B=h;}$.removeClass("sapUiUx3ShellNotifyTI").removeClass("sapUiUx3ShellNotifyOverlay");if(this._topSyncRefId){this._getSyncRefs().animate({"bottom":B+"px"},"fast");if(B>0){$.addClass(i?"sapUiUx3ShellNotifyTI":"sapUiUx3ShellNotifyOverlay");}}if(v===sap.ui.ux3.NotificationBarStatus.Min){$.css("height",h+"px").css("z-index",1);}else{$.css("height",h+"px").css("z-index",100000);}if(h>0&&!this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().addClass("sapUiUx3ShellNotifyVisible");}else if(h==0&&this.$().hasClass("sapUiUx3ShellNotifyVisible")){this.$().removeClass("sapUiUx3ShellNotifyVisible");}this._adaptContentHeight(v);};
a.prototype.syncWithCanvasSize=function(i,I,f,F,A){var b=q.inArray(i,this._aSyncRefStack);if(I){var r={id:i,focusFirst:f,focusLast:F,applyChanges:A};if(b<0){this._aSyncRefStack.push(i);}this._mSyncRefs[i]=r;r.applyChanges({showOverlay:this.getHeaderType()!==sap.ui.ux3.ShellHeaderType.BrandOnly});}else{if(b>=0){delete this._mSyncRefs[i];this._aSyncRefStack.splice(b,1);}}this.$("canvas").removeAttr("aria-hidden");this.$("focusDummyTPStart").removeAttr("tabindex").unbind("focusin");this.$("focusDummyTPEnd").removeAttr("tabindex").unbind("focusin");this.$("focusDummyHdrStart").removeAttr("tabindex").unbind("focusin");this.$("focusDummyHdrEnd").removeAttr("tabindex").unbind("focusin");this.$("focusDummyPane").removeAttr("tabindex").unbind("focusin");this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",false);delete this._topSyncRefId;if(this._aSyncRefStack.length>0){var r=this._mSyncRefs[this._aSyncRefStack[this._aSyncRefStack.length-1]];var d=this._getSyncRefs();var c=this.getDomRef("canvas");d.css(this._bRtl?"right":"left",(this.getShowTools()?this.currentToolPaletteWidth:0)+"px");var R=a._SHELL_OFFSET_RIGHT;if(this.getShowPane()){R+=a.SIDE_BAR_BASE_WIDTH;if(this._sOpenPaneId){R+=this.getPaneWidth();}}d.css(this._bRtl?"left":"right",R+"px");d.css("top",q.sap.domById(this.getId()+(this.getAllowOverlayHeaderAccess()?"-hdr":"-hdrLine")).offsetHeight+"px");d.css("bottom","0");q(c).attr("aria-hidden","true");this.$("focusDummyTPEnd").attr("tabindex","0").focusin(r.focusFirst);this.$("focusDummyHdrStart").attr("tabindex","0").focusin(q.proxy(this.focusPaneEnd,this));this.$("focusDummyHdrEnd").attr("tabindex","0").focusin(q.proxy(this.focusFirstTool,this));this.$("focusDummyTPStart").attr("tabindex","0").focusin(q.proxy(this.focusLastHdr,this));this.$("focusDummyPane").attr("tabindex","0").focusin(r.focusLast);this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());this._topSyncRefId=r.id;}q.sap.require("jquery.sap.script");if(this._sUpdateNotificationZIndex){q.sap.clearDelayedCall(this._sUpdateNotificationZIndex);delete this._sUpdateNotificationZIndex;}this._sUpdateNotificationZIndex=q.sap.delayedCall(0,this,function(){delete this._sUpdateNotificationZIndex;this._setNotifyVisibility();if(this._oOpenToolPopup&&this._topSyncRefId){var $=q.sap.byId(this._topSyncRefId);this._oOpenToolPopup.$().css("z-index",parseInt($.css("z-index"),10)+1);}});};
}());
a.prototype._getSyncRefs=function(){var r=[];var R;for(var i=0;i<this._aSyncRefStack.length;i++){R=q.sap.domById(this._aSyncRefStack[i]);if(R){r.push(R);}}return q(r);};
a.prototype.focusFirstHdr=function(){var t=this.$("hdr-items").firstFocusableDomRef();if(t&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=sap.ui.ux3.ShellHeaderType.BrandOnly){q.sap.focus(t);}else{this.focusFirstTool();}};
a.prototype.focusLastHdr=function(){var t=this.$("hdr-items").lastFocusableDomRef();if(t&&this.getAllowOverlayHeaderAccess()&&this.getHeaderType()!=sap.ui.ux3.ShellHeaderType.BrandOnly){q.sap.focus(t);}else{this.focusPaneEnd();}};
a.prototype.focusFirstTool=function(){var $=this.$("tp").find(".sapUiUx3ShellTool").first();if($.length&&this.getShowTools()){q.sap.focus($[0]);}else{this._mSyncRefs[this._topSyncRefId].focusFirst();}};
a.prototype.focusLastTool=function(){var $=this.$("tp").find(".sapUiUx3ShellTool").last();if($.length&&this.getShowTools()){q.sap.focus($[0]);}else{this.focusPaneEnd();}};
a.prototype.focusPaneStart=function(){var t=this.$("paneBar").firstFocusableDomRef();if(t){q.sap.focus(t);}else{this.focusFirstTool();}};
a.prototype.focusPaneEnd=function(){var t=this.$("paneBar").lastFocusableDomRef();if(t){q.sap.focus(t);}else{this._mSyncRefs[this._topSyncRefId].focusLast();}};
a.prototype.setAppTitle=function(A){this.setProperty("appTitle",A,true);this._rerenderHeader();return this;};
a.prototype.setAppIcon=function(A){this.setProperty("appIcon",A,true);this._rerenderHeader();return this;};
a.prototype.setShowLogoutButton=function(s){this.setProperty("showLogoutButton",s,true);this._rerenderHeader();return this;};
a.prototype.setLogoutButtonTooltip=function(t){this.setProperty("logoutButtonTooltip",t,true);this._rerenderHeader();return this;};
a.prototype.insertHeaderItem=function(h,i){if(sap.ui.commons&&sap.ui.commons.Button&&(h instanceof sap.ui.commons.Button)){h.setStyled(false);}this.insertAggregation("headerItems",h,i,true);this._rerenderHeader();return this;};
a.prototype.addHeaderItem=function(h){if(sap.ui.commons&&sap.ui.commons.Button&&(h instanceof sap.ui.commons.Button)){h.setStyled(false);}this.addAggregation("headerItems",h,true);this._rerenderHeader();return this;};
a.prototype.removeHeaderItem=function(i){var r=this.removeAggregation("headerItems",i,true);this._rerenderHeader();return r;};
a.prototype.removeAllHeaderItems=function(){var r=this.removeAllAggregation("headerItems",true);this._rerenderHeader();return r;};
a.prototype.destroyHeaderItems=function(){this.destroyAggregation("headerItems",true);this._rerenderHeader();return this;};
a.prototype.setShowSearchTool=function(s){this.setProperty("showSearchTool",s,true);this._rerenderToolPalette();return this;};
a.prototype.setShowFeederTool=function(s){this.setProperty("showFeederTool",s,true);this._rerenderToolPalette();return this;};
a.prototype.setHeaderType=function(h){var c=this.getHeaderType();this.setProperty("headerType",h,true);this.$().removeClass("sapUiUx3ShellHead"+c).addClass("sapUiUx3ShellHead"+this.getHeaderType());var s=this._getSyncRefs();if(s.length){s.css("top",q.sap.domById(this.getId()+(this.getAllowOverlayHeaderAccess()?"-hdr":"-hdrLine")).offsetHeight+"px");}var o={showOverlay:h!==sap.ui.ux3.ShellHeaderType.BrandOnly};q.each(this._mSyncRefs,function(i,r){r.applyChanges(o);});return this;};
a.prototype.setAllowOverlayHeaderAccess=function(A){this.setProperty("allowOverlayHeaderAccess",A,true);var s=this._getSyncRefs();if(s.length){this.$().toggleClass("sapUiUx3ShellBlockHeaderAccess",!this.getAllowOverlayHeaderAccess());s.css("top",q.sap.domById(this.getId()+(this.getAllowOverlayHeaderAccess()?"-hdr":"-hdrLine")).offsetHeight+"px");}return this;};
a.prototype.setDesignType=function(d){var c=this.getDesignType();this.setProperty("designType",d,true);var I=this._hasDarkDesign();if(this._oSearchPopup){this._oSearchPopup.setInverted(I);}if(this._oFeederPopup){this._oFeederPopup.setInverted(I);}var t=this.getToolPopups();for(var i=0;i<t.length;++i){t[i].setInverted(I);}this.$().removeClass("sapUiUx3ShellDesign"+c).addClass("sapUiUx3ShellDesign"+d).toggleClass("sapUiUx3ShellDesignLight",!I);return this;};
a.prototype.setShowTools=function(s){this.setProperty("showTools",s,true);if(s){this.$().removeClass("sapUiUx3ShellNoTools");this._checkResize();}else{this.$().addClass("sapUiUx3ShellNoTools");this._closeCurrentToolPopup();this.$("tp").attr("style","");}this._checkToolPaletteSize(true);return this;};
a.prototype.setShowPane=function(s){this.setProperty("showPane",s,true);if(s){this.$().removeClass("sapUiUx3ShellNoPane");this._refreshCanvasOffsetRight(true);this._checkPaneBarOverflow();}else{var t=this;this._closePane(function(){t._refreshCanvasOffsetRight(false);t.$().addClass("sapUiUx3ShellNoPane");});}return this;};
a.prototype.insertToolPopup=function(t,i){this.insertAggregation("toolPopups",t,i,true);t.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this;};
a.prototype.addToolPopup=function(t){var i=this._hasDarkDesign();t.setInverted(i);this.addAggregation("toolPopups",t,true);t.attachIconChanged(this._rerenderToolPalette,this);this._rerenderToolPalette();return this;};
a.prototype.removeToolPopup=function(i){var r=this.removeAggregation("toolPopups",i,true);if(r===this._oOpenToolPopup){this._closeCurrentToolPopup();}this._rerenderToolPalette();return r;};
a.prototype.removeAllToolPopups=function(){var r=this.removeAllAggregation("toolPopups",true);this._rerenderToolPalette();return r;};
a.prototype.destroyToolPopups=function(){this.destroyAggregation("toolPopups",true);this._rerenderToolPalette();return this;};
a.prototype.insertContent=function(c,i){this.insertAggregation("content",c,i,true);this._rerenderContent();return this;};
a.prototype.addContent=function(c){this.addAggregation("content",c,true);this._rerenderContent();return this;};
a.prototype.removeContent=function(i){var r=this.removeAggregation("content",i,true);this._rerenderContent();return r;};
a.prototype.removeAllContent=function(){var r=this.removeAllAggregation("content",true);this._rerenderContent();return r;};
a.prototype.destroyContent=function(){this.destroyAggregation("content",true);this._rerenderContent();return this;};
a.prototype.addPaneBarItem=function(p){this.addAggregation("paneBarItems",p,true);this._rerenderPaneBarItems();return this;};
a.prototype.insertPaneBarItem=function(p,i){this.insertAggregation("paneBarItems",p,i,true);this._rerenderPaneBarItems();return this;};
a.prototype.removePaneBarItem=function(p){var r=this.removeAggregation("paneBarItems",p,true);if(r){var i=sap.ui.getCore().byId(r.getId()+"-overflow");if(i){i.destroy();}}this._rerenderPaneBarItems();return r;};
a.prototype.removeAllPaneBarItems=function(){var r=this.removeAllAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return r;};
a.prototype.destroyPaneBarItems=function(){this.destroyAggregation("paneBarItems",true);this._getPaneOverflowMenu().destroyItems();this._rerenderPaneBarItems();return this;};
a.prototype.addWorksetItem=function(w){this.addAggregation("worksetItems",w,true);this._rerenderWorksetItems();return this;};
a.prototype.insertWorksetItem=function(w,i){this.insertAggregation("worksetItems",w,i,true);this._rerenderWorksetItems();return this;};
a.prototype.removeWorksetItem=function(w){var r=this.removeAggregation("worksetItems",w,true);this._rerenderWorksetItems();return r;};
a.prototype.removeAllWorksetItems=function(){var r=this.removeAllAggregation("worksetItems",true);this._rerenderWorksetItems();return r;};
a.prototype.destroyWorksetItems=function(){this.destroyAggregation("worksetItems",true);this._rerenderWorksetItems();return this;};
(function(){
function c(s){var o=s.getNotificationBar();if(o){s._setNotifyVisibility(sap.ui.ux3.NotificationBarStatus.None);o.setVisibleStatus=o.__orig_setVisibleStatus;o.detachDisplay(o.__fHandleNotifyDisplay);delete o.__orig_setVisibleStatus;delete o.__fHandleNotifyDisplay;}}
a.prototype.setNotificationBar=function(n){c(this);if(n){var t=this;n.__orig_setVisibleStatus=n.setVisibleStatus;n.setVisibleStatus=function(v){this.__orig_setVisibleStatus.apply(this,arguments);t._setNotifyVisibility();};}this.setAggregation("notificationBar",n,true);this._rerenderNotificationArea();if(n){n.__fHandleNotifyDisplay=function(e){var s=e?e.getParameter("show"):n.hasItems();n.setVisibleStatus(s?sap.ui.ux3.NotificationBarStatus.Default:sap.ui.ux3.NotificationBarStatus.None);};n.attachDisplay(n.__fHandleNotifyDisplay);n.__fHandleNotifyDisplay();}return this;};
a.prototype.destroyNotificationBar=function(){c(this);this.destroyAggregation("notificationBar",true);this._rerenderNotificationArea();return this;};
}());
a.prototype._rerenderNotificationArea=function(){var $=this.$("notify");if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ShellRenderer.renderNotificationArea(r,this);r.flush($[0],true);r.destroy();}};
a.prototype._rerenderHeader=function(){var $=this.$("hdr");if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ShellRenderer.renderHeader(r,this);r.flush($[0],true);r.destroy();}};
a.prototype._rerenderToolPalette=function(){var $=this.$("tp");if($.length>0){var r=sap.ui.getCore().createRenderManager();this._beforeRenderingToolPalette();sap.ui.ux3.ShellRenderer.renderToolPalette(r,this);r.flush($[0],true);this._afterRenderingToolPalette();r.destroy();this._checkResize();}};
a.prototype._beforeRenderingToolPalette=function(){this.$("tp").find(".sapUiUx3ShellTool").unbind("mouseenter mouseleave");this.$("focusDummyTPEnd").unbind("focusin");this.$("focusDummyTPStart").unbind("focusin");};
a.prototype._afterRenderingToolPalette=function(){var I=this.getId()+a.TOOL_PREFIX;var t=this.getToolPopups();var v=false;if(this._oOpenToolPopup&&this._oOpenToolPopup.isOpen()&&(this.indexOfToolPopup(this._oOpenToolPopup)>=0||this._oOpenToolPopup===this._oSearchPopup||this._oOpenToolPopup===this._oFeederPopup)){this._oOpenToolPopup.setPosition(sap.ui.core.Popup.Dock.BeginTop,sap.ui.core.Popup.Dock.EndTop,q.sap.domById(I+this._oOpenToolPopup.getId()),"13 -6","fit");var p=q.sap.domById(I+this._oOpenToolPopup.getId());q(p).toggleClass("sapUiUx3ShellToolSelected",true);a._updateToolIcon(p);v=true;}if(!v&&this._oOpenToolPopup){this._closeCurrentToolPopup();}for(var i=0;i<t.length;i++){var T=t[i];if(T instanceof sap.ui.ux3.ToolPopup){q.sap.byId(I+T.getId()).hover(function(e){q(this).toggleClass("sapUiUx3ShellToolHover",(e.type==="mouseenter"));a._updateToolIcon(this);});}}if(this._topSyncRefId&&this._mSyncRefs[this._topSyncRefId].focusFirst){this.$("focusDummyTPEnd").attr("tabindex","0").focusin(this._mSyncRefs[this._topSyncRefId].focusFirst);}if(this._aSyncRefStack.length>0){this.$("focusDummyTPStart").attr("tabindex","0").focusin(q.proxy(this.focusLastHdr,this));}};
a.prototype._rerenderContent=function(p){var $=this.$("content");if($.length>0){var c=this.getContent(),r=sap.ui.getCore().createRenderManager();for(var i=0;i<c.length;i++){r.renderControl(c[i]);}r.flush($[0],p);r.destroy();}};
a.prototype._rerenderPane=function(p){var $=this.$("paneContent");if($.length>0){var b=this.getPaneContent(),r=sap.ui.getCore().createRenderManager();for(var i=0;i<b.length;i++){r.renderControl(b[i]);}r.flush($[0],p);r.destroy();}};
a.prototype._rerenderPaneBarItems=function(){var p=this.$("paneBar").find(".sapUiUx3ShellPaneEntries");if(p.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ShellRenderer.renderPaneBarItems(r,this);r.flush(p[0]);r.destroy();this._updatePaneBarItemNavigation(p);}var t=this;var m=this._getPaneOverflowMenu();var b=this.getPaneBarItems();var o=function(e){var d={overflowItem:e.getParameter("item"),target:{id:e.getParameter("id").replace(/-overflow$/,""),parentNode:{className:"sapUiUx3ShellPaneEntries"}}};t.onUserActivation(d);};for(var i=0;i<b.length;++i){var I=b[i].getId()+"-overflow";var c=sap.ui.getCore().byId(I);if(!c){var O=new sap.ui.commons.MenuItem(I,{text:b[i].getText(),visible:false,select:o});m.addItem(O);}}this._checkPaneBarOverflow(p);};
a.prototype._rerenderWorksetItems=function(){if(this.$("wBar").length>0){sap.ui.ux3.ShellRenderer.renderWorksetItems(null,this);sap.ui.ux3.ShellRenderer.renderFacetBar(null,this);var i=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",(i&&i.length>0?"block":"none"));this._adaptContentHeight();}};
a.prototype.forceInvalidation=C.prototype.invalidate;
a.prototype.invalidate=function(s){if(!s){this.forceInvalidation();}else if(s instanceof sap.ui.ux3.NavigationItem){if(this._oWorksetBar&&this._oFacetBar){this._oWorksetBar.setAssociatedItems(this.getWorksetItems());var w=this.getSelectedWorksetItem();if(w){var i;var b=sap.ui.getCore().byId(w);if(b&&b.getParent()instanceof sap.ui.ux3.NavigationItem){this._oFacetBar.setAssociatedItems(b.getParent().getSubItems());}else if(b&&(i=b.getSubItems())){if(i&&(i.length>0)){this._oFacetBar.setAssociatedItems(i);}}i=this._oFacetBar.getAssociatedItems();this._oFacetBar.$().css("display",(i&&i.length>0?"block":"none"));this._adaptContentHeight();}}}else if((s instanceof sap.ui.core.Item)&&(s.getParent()==this)){this.forceInvalidation();}else if(s instanceof sap.ui.ux3.ToolPopup){this._rerenderToolPalette();}else if(this.indexOfHeaderItem(s)>=0){this._rerenderHeader();}};
a.prototype._setParent=C.prototype.setParent;
a.prototype.setParent=function(p,A,s){this._setParent(p,A,s);this.forceInvalidation();};
a.prototype.setContent=function(c,d){var o=[];var $=this.$("content");var p=false;if(!d){o=this.removeAllAggregation("content",true);if($.length>0){sap.ui.core.RenderManager.preserveContent($[0]);p=true;$.empty();}}else{this.destroyAggregation("content",true);}if(c instanceof C){this.addAggregation("content",c,true);}else if(c&&typeof(c)=="object"&&c.length){for(var i=0;i<c.length;i++){this.addAggregation("content",c[i],true);}}this._rerenderContent(p);return o;};
a.prototype.setPaneContent=function(c,d){var o=[];var $=this.$("paneContent");var p=false;if(!d){o=this.removeAllAggregation("paneContent",true);if($.length>0){sap.ui.core.RenderManager.preserveContent($[0]);p=true;$.empty();}}else{this.destroyAggregation("paneContent",true);}if(c instanceof C){this.addAggregation("paneContent",c,true);}else if(c&&typeof(c)=="object"&&c.length){for(var i=0;i<c.length;i++){this.addAggregation("paneContent",c[i],true);}}this._rerenderPane(p);return o;};
a.prototype.getSelectedWorksetItem=function(){return this.getAssociation("selectedWorksetItem");};
a.prototype.setSelectedWorksetItem=function(s){var o=this.getSelectedWorksetItem();this.setAssociation("selectedWorksetItem",s,true);var n=this.getSelectedWorksetItem();if(o!=n){var b=sap.ui.getCore().byId(n);if(b){this._sSelectedWorksetId=n;this._sSelectedFacetId=null;var c=b.getSubItems();if(c.length>0){b=c[0];}if(b&&(b.getParent()instanceof sap.ui.ux3.NavigationItem)){var d=b.getParent();this._sSelectedWorksetId=d.getId();this._sSelectedFacetId=b.getId();this._oWorksetBar.setSelectedItem(d);this._oFacetBar.setAssociatedItems(d.getSubItems());this._oFacetBar.setSelectedItem(b);if(this.getDomRef()){var f=this.$("facetBar");var F=this._calcFacetBarHeight(f);f.slideDown();this._adaptContentHeight(null,true,F);}}else if(b){this._oWorksetBar.setSelectedItem(b);this._oFacetBar.setAssociatedItems([]);this._oFacetBar.setSelectedItem(null);if(this.getDomRef()){var f=this.$("facetBar");var F=this._calcFacetBarHeight(f);f.slideUp();this._adaptContentHeight(null,true,F);}}}else{throw new Error("WorksetItem with ID "+n+" cannot be found.");}}return this;};
a.prototype.setApplyContentPadding=function(A){this.setProperty("applyContentPadding",A,true);this.$().toggleClass("sapUiUx3ShellNoContentPadding",!A);this._adaptContentHeight();};
a.prototype.setFullHeightContent=function(f){this.setProperty("fullHeightContent",f,true);this.$().toggleClass("sapUiUx3ShellFullHeightContent",f);this._adaptContentHeight();};
a.prototype._calcFacetBarHeight=function(f){if(this._iFacetBarHeight===undefined){this._iFacetBarHeight=0;}if(!f){f=this.$("facetBar");}if(f.length>0){var h=this.$("facetBar").outerHeight(true);this._iFacetBarHeight=Math.max(this._iFacetBarHeight,h);}return this._iFacetBarHeight;};
a.prototype._adaptContentHeight=function(n,A,f){if(!this.getDomRef()){return;}var $=this.$("content");var b=this.$("canvas");if(this.getFullHeightContent()){var p=this.getApplyContentPadding();var t=!p?0:parseInt(b.css("paddingTop"),10);var L=!p?0:parseInt(b.css("paddingLeft"),10);var r=!p?0:parseInt(b.css("paddingRight"),10);var _=f?f:this._calcFacetBarHeight();var T=(t+(this._oFacetBar.getAssociatedItems().length>0?_:0))+"px";if(A){$.stop().animate({top:T});}else{$.stop().css("top",T);}var N=this.getNotificationBar();if(N&&!n){n=N.getVisibleStatus();}if(n===sap.ui.ux3.NotificationBarStatus.Default||n===sap.ui.ux3.NotificationBarStatus.Max){$.css("bottom",N.getHeightOfStatus(sap.ui.ux3.NotificationBarStatus.Default));}else{var B=!p?0:parseInt(b.css("paddingBottom"),10);if(N&&n===sap.ui.ux3.NotificationBarStatus.Min){B+=sap.ui.ux3.NotificationBar.HOVER_ITEM_HEIGHT;}$.css("bottom",B+"px");}$.css(this._bRtl?"right":"left",L+"px");$.css(this._bRtl?"left":"right",r+"px");}else{$.removeAttr("style");}if(!!sap.ui.Device.browser.webkit){sap.ui.core.RenderManager.forceRepaint(this.getId()+"-canvas");}};
a.prototype._handleDragover=function(e){var i=e.target.id;if(!this._dragOverBlinking){var $=q.sap.byId(i);$.css("opacity","0.5");this._dragOverBlinking=true;var t=this;window.setTimeout(function(){$.css("opacity","1");window.setTimeout(function(){t._dragOverBlinking=null;},300);},300);}return false;};
a.prototype._handleDragend=function(e){return false;};
a.prototype._handleDrop=function(b){var i=b.target.id;b.preventDefault();var e=b.originalEvent;var f=e.dataTransfer.files[0];if(f){var r=new window.FileReader();r.onload=q.proxy(function(c){var d=c.target.result;if(i==this.getId()+"-bgImg"){this._getPersonalization()._handleBackgroundImageChange(d,true);}else if(i==this.getId()+"-hdr"){this._getPersonalization()._handleHeaderImageChange(d,true);}else if(i==this.getId()+"-logoImg"){this._getPersonalization()._handleLogoImageChange(d,true);}r=null;},this);r.readAsDataURL(f);}};
a.prototype._getPersonalization=function(){if(!this.oPersonalization){q.sap.require("sap.ui.ux3.ShellPersonalization");this.oPersonalization=new sap.ui.ux3.ShellPersonalization(this);}return this.oPersonalization;};
a.prototype.openPersonalizationDialog=function(){this._getPersonalization().openDialog();};
a.prototype.initializePersonalization=function(s){this._getPersonalization().initializeSettings(s);};
a.prototype.onThemeChanged=function(e){this._iFacetBarHeight=undefined;if(!this.getDomRef()){return;}var i="";if(!this.getAppIcon()){i=P._getThemeImage('sapUiUx3ShellApplicationImageURL',true);this.$("logoImg").attr('src',i);}i=P._getThemeImage('sapUiUx3ShellHeaderImageURL',true);this.$("hdrImg").attr('src',i);i=P._getThemeImage('sapUiUx3ShellBackgroundImageURL',true);this.$("bgImg").attr('src',i);this.$("facetBar").stop(true,true);this._adaptContentHeight();this._updateThemeVariables();this._checkResize();};
return a;},true);
sap.ui.predefine('sap/ui/ux3/ShellColorPicker',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/commons/Button','sap/ui/core/Popup'],function(Q,E,B,P){"use strict";
var S=E.extend("sap.ui.ux3.ShellColorPicker",{constructor:function(i){E.apply(this);this.id=i;}});
S.M_EVENTS={liveChange:"liveChange"};
S.prototype.attachLiveChange=function(f,l){this.attachEvent(S.M_EVENTS.liveChange,f,l);};
S.prototype.detachLiveChange=function(f,l){this.detachEvent(S.M_EVENTS.liveChange,f,l);};
S.prototype.fireLiveChange=function(c){var p={cssColor:S.hslToCss(c)};this.fireEvent(S.M_EVENTS.liveChange,p);};
S.prototype.isOpen=function(){return(this.oPopup&&this.oPopup.isOpen());};
S.prototype.open=function(c,d,m,a,o,b,e){if(this.oPopup&&this.oPopup.isOpen()){return;}this.oSlider=new sap.ui.commons.Slider({width:"225px",liveChange:[this.handleSlider,this]});this.oOkBtn=new B({text:"OK",press:[this.handleOk,this]});this.oCancelBtn=new B({text:"Cancel",press:[this.handleCancel,this]});this.oInitialColor=c;this.oCurrentColor=Q.extend({},this.oInitialColor);this.oSlider.setValue(this.oCurrentColor.l);var r=sap.ui.getCore().createRenderManager();var f=document.createElement("div");var s=sap.ui.getCore().getStaticAreaRef();s.appendChild(f);this.renderHtml(r);r.flush(f);r.destroy;this.oPopup=new P(f.firstChild,false,true,true).attachClosed(this.handleClose,this);this.oPopup.setAutoCloseAreas([f.firstChild]);this.oPopup.open(d,m,a,o,b,e);s.removeChild(f);f=null;Q.sap.byId(this.id).bind("mousedown",Q.proxy(this.handleGeneralMouseDown,this));Q.sap.byId(this.id+"-img").bind("mousedown",Q.proxy(this.handleMouseDown,this));Q.sap.byId(this.id+"-marker").bind("mousedown",Q.proxy(this.handleMouseDown,this));this._imgOffset=Q.sap.byId(this.id+"-img").offset();this.adaptSliderBar(this.oCurrentColor);this.markColorOnImage(this.oCurrentColor);this.adaptPreview(this.oCurrentColor);};
S.parseCssRgbString=function(r){r=Q.trim(r.replace(/rgb\(/,"").replace(/\)/,""));var R=r.split(",");var o={r:parseInt(R[0],10),g:parseInt(R[1],10),b:parseInt(R[2],10)};return S.rgbToHsl(o);};
S.prototype.renderHtml=function(r){r.write("<div id='"+this.id+"' class='sapUiUx3ShellColorPicker'>");r.write("<img id='"+this.id+"-img' src='"+sap.ui.resource('sap.ui.ux3','img/colors-h.png')+"' />");r.renderControl(this.oSlider);r.write("<div id='"+this.id+"-grad' class='sapUiUx3ShellColorPickerGradient'></div>");r.write("<div id='"+this.id+"-marker' class='sapUiUx3ShellColorPickerMarker'></div>");r.write("<div id='"+this.id+"-preview' class='sapUiUx3ShellColorPickerPreview'></div>");r.renderControl(this.oOkBtn);r.renderControl(this.oCancelBtn);r.write("</div>");};
S.prototype.markColorOnImage=function(c){var x=c.h*225;var y=(1-c.s)*75;Q.sap.byId(this.id+"-marker").css("left",x+10).css("top",y+10);};
S.prototype.markColorOnSlider=function(c){this.oSlider.setValue(c.l);};
S.prototype.adaptSliderBar=function(c){var g="";var m=Q.extend({},c);m.l=50;var a=S.hslToCss(m);if(!!sap.ui.Device.browser.firefox){g="-moz-linear-gradient(left, black, "+a+", white)";}else if(!!sap.ui.Device.browser.webkit){g="-webkit-gradient(linear, left center, right center, from(#000), color-stop(0.5, "+a+"), to(#FFF))";}Q.sap.byId(this.id+"-grad").css("background-image",g);};
S.prototype.adaptPreview=function(c){Q.sap.byId(this.id+"-preview").css("background-color",S.hslToCss(c));};
S.prototype.handleSlider=function(e){var l=e.getParameter("value");this.oCurrentColor.l=l;this.adaptPreview(this.oCurrentColor);this.fireLiveChange(this.oCurrentColor);};
S.prototype.handleGeneralMouseDown=function(e){e.preventDefault();};
S.prototype.handleMouseDown=function(e){this.handleMousePos(e);e.preventDefault();Q(document).bind("mousemove",Q.proxy(this.handleMousePos,this)).bind("mouseup",Q.proxy(this.handleMouseUp,this));};
S.prototype.handleMouseUp=function(e){this.handleMousePos(e);Q(document).unbind("mousemove",this.handleMousePos).unbind("mouseup",this.handleMouseUp);};
S.prototype.handleMousePos=function(e){var x=e.pageX-this._imgOffset.left;var y=e.pageY-this._imgOffset.top;x=Math.min(Math.max(x,0),225);y=Math.min(Math.max(y,0),75);var h=x/225;var s=1-y/75;this.oCurrentColor.h=h;this.oCurrentColor.s=s;this.adaptSliderBar(this.oCurrentColor);this.markColorOnImage(this.oCurrentColor);this.adaptPreview(this.oCurrentColor);this.fireLiveChange(this.oCurrentColor);};
S.prototype.handleOk=function(){this.fireLiveChange(this.oCurrentColor);this.oPopup.close();};
S.prototype.handleCancel=function(){this.fireLiveChange(this.oInitialColor);this.oPopup.close();};
S.prototype.handleClose=function(){Q.sap.byId(this.id+"-img").unbind("mousedown",this.handleMouseDown);Q.sap.byId(this.id+"-marker").unbind("mousedown",this.handleMouseDown);Q(document).unbind("mousemove",this.handleMousePos).unbind("mouseup",this.handleMouseUp);Q.sap.byId(this.id).unbind("mousedown",this.handleGeneralMouseDown);this.oSlider.destroy();this.oSlider=null;this.oOkBtn.destroy();this.oOkBtn=null;this.oCancelBtn.destroy();this.oCancelBtn=null;var d=Q.sap.domById(this.id);d.parentNode.removeChild(d);this.oPopup.destroy();this.oPopup=null;};
S.rgbToHsl=function(c){var r=c.r/255,g=c.g/255,b=c.b/255;var m=Math.max(r,g,b);var a=Math.min(r,g,b);var h,s,l=(m+a)/2;if(m==a){h=s=0;}else{var d=m-a;s=l>0.5?d/(2-m-a):d/(m+a);switch(m){case r:h=(g-b)/d+(g<b?6:0);break;case g:h=(b-r)/d+2;break;case b:h=(r-g)/d+4;break;}h/=6;}return{h:h,s:s,l:l*100};};
S.hslToRgb=function(c){var r,g,b;var l=c.l/100;if(c.s==0){r=g=b=l;}else{var q=l<0.5?l*(1+c.s):l+c.s-l*c.s;var p=2*l-q;r=S.hueToRgb(p,q,c.h+1/3);g=S.hueToRgb(p,q,c.h);b=S.hueToRgb(p,q,c.h-1/3);}return[r*255,g*255,b*255];};
S.hueToRgb=function(p,q,t){if(t<0){t+=1;}if(t>1){t-=1;}if(t<1/6){return p+(q-p)*6*t;}if(t<1/2){return q;}if(t<2/3){return p+(q-p)*(2/3-t)*6;}return p;};
S.hslToCss=function(c){var r=S.hslToRgb(c);return"rgb("+Math.round(r[0])+","+Math.round(r[1])+","+Math.round(r[2])+")";};
return S;},true);
sap.ui.predefine('sap/ui/ux3/ShellPersonalization',['jquery.sap.global','sap/ui/base/EventProvider','sap/ui/commons/Button','sap/ui/commons/Dialog'],function(q,E,B,D){"use strict";
var S=E.extend("sap.ui.ux3.ShellPersonalization",{constructor:function(s){E.apply(this);this.shell=s;this.oSettings={};}});
S.prototype.initializeSettings=function(s){this.oSettings=q.extend({},s);if(this.shell.getDomRef()){this.applySettings(s);}};
S.M_EVENTS={personalizationChange:"personalizationChange"};
S.prototype.attachPersonalizationChange=function(f,l){this.attachEvent(S.M_EVENTS.personalizationChange,f,l);};
S.prototype.detachPersonalizationChange=function(f,l){this.detachEvent(S.M_EVENTS.personalizationChange,f,l);};
S.prototype.firePersonalizationChange=function(p){this.fireEvent(S.M_EVENTS.personalizationChange,p);};
S.ORIGINAL_SETTINGS={bByDStyle:false,sBgColor:"rgb(17,17,17)",sBgCssImg:null,sBgImgSrc:null,sBgImgPos:"tile",fBgImgOpacity:1,fSidebarOpacity:1,sLineColor:"rgb(239,170,0)",sLogoImageSrc:null,sLogoAlign:"left",bUseLogoSize:false};S.TRANSPARENT_1x1=sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif');S.IMAGE_FOLDER_PATH=q.sap.getModulePath("sap.ui.ux3.themes."+sap.ui.getCore().getConfiguration().getTheme(),"/img/shell/");
S.getOriginalSettings=function(){if(!S._bOriginalSettingsInitialized){S._bOriginalSettingsInitialized=true;q.sap.require("sap.ui.core.theming.Parameters");var a=sap.ui.core.theming.Parameters.get();var g=a["sap.ui.ux3.Shell:sapUiUx3ShellGradientTop"];var b=a["sap.ui.ux3.Shell:sapUiUx3ShellGradientBottom"];if(!!sap.ui.Device.browser.firefox){S.ORIGINAL_SETTINGS.sBgCssImg="-moz-linear-gradient(top, "+g+" 0, "+b+" 108px, "+b+")";}else if(!!sap.ui.Device.browser.internet_explorer){if(sap.ui.Device.browser.version==9){S.ORIGINAL_SETTINGS.sBgCssImg="url("+S.IMAGE_FOLDER_PATH+"Workset_bg.png)";}else{S.ORIGINAL_SETTINGS.sBgCssImg="-ms-linear-gradient(top, "+g+" 0, "+b+" 108px, "+b+")";}}else if(!!sap.ui.Device.browser.webkit){S.ORIGINAL_SETTINGS.sBgCssImg="-webkit-linear-gradient(top, "+g+" 0, "+b+" 108px, "+b+")";}}return S.ORIGINAL_SETTINGS;};
S.prototype.hasChanges=function(){var s=0;for(var k in this.oSettings){s++;}return(s>0);};
S.prototype.applySettings=function(s){var a=q.extend({},S.getOriginalSettings());a=q.extend(a,s);this.applyByDStyle(a.bByDStyle);this.applyBgColor(a.sBgColor);this.applyBgImage(a.sBgCssImg,a.sBgImgSrc);this.applyBgImageOpacity(a.fBgImgOpacity);if(a.sHeaderImageSrc){this.applyHeaderImage(a.sHeaderImageSrc);}else{this.shell.getDomRef("hdr").style.backgroundImage="";}this.applySidebarOpacity(a.fSidebarOpacity);this.applyBgColor(a.sBgColor);this.applyLineColor(a.sLineColor);this.applyLogoImage(a.sLogoImageSrc);this.applyLogoAlign(a.sLogoAlign);this.applyUseLogoSize(a.bUseLogoSize);};
S.prototype.openDialog=function(){if(this.oDialog&&this._getDialog().isOpen()){return;}this.oTransientSettings=q.extend({},this.oSettings);this._getDialog().open();this._bindDragAndDrop("bg");this._bindDragAndDrop("hdr");this._bindDragAndDrop("logo");};
S.prototype.getTransientSettingsWithDefaults=function(){return q.extend(q.extend({},S.getOriginalSettings()),this.oTransientSettings);};
S.prototype._bindDragAndDrop=function(p){if(window.FileReader){var i=this.shell.getId()+"-p13n_";q.sap.byId(i+p+"ImageImg").bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));q.sap.byId(i+p+"ImageHolder").bind('dragover',q.proxy(this._handleDragover,this)).bind('dragend',q.proxy(this._handleDragend,this)).bind('drop',q.proxy(this._handleDrop,this));}};
S.prototype._unbindDragAndDrop=function(p){if(window.FileReader){var i=this.shell.getId()+"-p13n_";q.sap.byId(i+"hdrImageImg").unbind('dragover',this._handleDragover).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);q.sap.byId(i+"hdrImageHolder").unbind('dragover',this._handleDragover).unbind('dragend',this._handleDragend).unbind('drop',this._handleDrop);}};
S.prototype._getDialog=function(){if(!this.oDialog){q.sap.require("sap.ui.ux3.ShellColorPicker");var i=this.shell.getId()+"-p13n_";var s=q.extend(q.extend({},S.getOriginalSettings()),this.oSettings);var c=sap.ui.commons;var t=this;var d=new c.Dialog({title:"Shell Personalization",width:"544px",height:"560px",showCloseButton:false,resizable:false,closed:[function(){this._unbindDragAndDrop("bg");this._unbindDragAndDrop("hdr");this._unbindDragAndDrop("logo");this.oTransientSettings=null;},this]}).addStyleClass("sapUiUx3ShellP13n");var a=new c.TabStrip({width:"100%",height:"100%",select:q.proxy(function(p){var C=sap.ui.getCore().byId(p.getParameter("id"));if(C){var e=p.getParameter("index");C.setSelectedIndex(e);var t=this;if(e==0){window.setTimeout(function(){t.shell.$("bgColor").css("background-color",t.getTransientSettingsWithDefaults().sBgColor);},1);window.setTimeout(q.proxy(function(){this._bindDragAndDrop("bg");},this),0);}else if(e==1){window.setTimeout(function(){t.shell.$("lineColor").css("background-color",t.getTransientSettingsWithDefaults().sLineColor);},1);window.setTimeout(q.proxy(function(){this._bindDragAndDrop("hdr");},this),0);}else if(e==2){window.setTimeout(q.proxy(function(){this._bindDragAndDrop("logo");},this),0);}}},this)});this.oBgImgHtml=new sap.ui.core.HTML(i+"bgImageHolder",{preferDOM:true,content:"<div id='"+i+"bgImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+i+"bgImageImg' src='"+(this.oTransientSettings.sBackgroundImageSrc?q.sap.encodeHTML(this.oTransientSettings.sBackgroundImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'/></div>"});this.oBgImgOpacitySlider=new c.Slider({value:(this.oTransientSettings.fBgImgOpacity!==undefined?100-this.oTransientSettings.fBgImgOpacity*100:100-S.getOriginalSettings().fBgImgOpacity*100),liveChange:q.proxy(this._handleBgImageOpacitySliderChange,this)});this.oSidebarOpacitySlider=new c.Slider({value:(this.oTransientSettings.fSidebarOpacity!==undefined?100-this.oTransientSettings.fSidebarOpacity*100:100-S.getOriginalSettings().fSidebarOpacity*100),liveChange:q.proxy(this._handleSidebarOpacitySliderChange,this)});this.oBgColorPicker=new sap.ui.ux3.ShellColorPicker(i+"bgColorPicker");this.oBgColorPicker.attachLiveChange(function(e){t._handleBgColorChange(e);});var b=new c.Button({text:"Change..."});var t=this;b.attachPress(function(){if(!t.oBgColorPicker.isOpen()){t.oBgColorPicker.open(sap.ui.ux3.ShellColorPicker.parseCssRgbString(t.getTransientSettingsWithDefaults().sBgColor),sap.ui.core.Popup.Dock.BeginTop,sap.ui.core.Popup.Dock.BeginBottom,t.shell.getDomRef("bgColor"));}});this.oBgPreviewHtml=new sap.ui.core.HTML({preferDom:true,content:"<div id='"+this.shell.getId()+"-bgColor' style='background-color:"+q.sap.encodeHTML(s.sBgColor)+"' class='sapUiUx3ShellColorPickerPreview'></div>"});var o=new sap.ui.commons.Tab().setText("Background").addContent(new c.layout.MatrixLayout({layoutFixed:false}).createRow(new c.Label({text:"Background Image:"}),this.oBgImgHtml).createRow(new c.Label({text:"Image Transparency:"}),this.oBgImgOpacitySlider).createRow(new c.Label({text:"Background Color:"}),new c.layout.MatrixLayoutCell().addContent(this.oBgPreviewHtml).addContent(b)).createRow(null).createRow(new c.Label({text:"Sidebar Transparency:"}),this.oSidebarOpacitySlider));a.addTab(o);this.oByDStyleCb=new c.CheckBox({text:"ByDesign-style Header Bar",checked:this.oTransientSettings.bByDStyle,change:q.proxy(this._handleByDStyleChange,this)});this.oHdrImgHtml=new sap.ui.core.HTML(i+"hdrImageHolder",{preferDOM:true,content:"<div id='"+i+"hdrImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+i+"hdrImageImg' src='"+(this.oTransientSettings.sHeaderImageSrc?q.sap.encodeHTML(this.oTransientSettings.sHeaderImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'/></div>"});this.oLineColorPicker=new sap.ui.ux3.ShellColorPicker(i+"lineColorPicker");this.oLineColorPicker.attachLiveChange(function(e){t._handleLineColorChange(e);});var l=new c.Button({text:"Change..."});var t=this;l.attachPress(function(){if(!t.oLineColorPicker.isOpen()){t.oLineColorPicker.open(sap.ui.ux3.ShellColorPicker.parseCssRgbString(t.getTransientSettingsWithDefaults().sLineColor),sap.ui.core.Popup.Dock.BeginTop,sap.ui.core.Popup.Dock.BeginBottom,t.shell.getDomRef("lineColor"));}});this.oLinePreviewHtml=new sap.ui.core.HTML({preferDom:true,content:"<div id='"+this.shell.getId()+"-lineColor' style='background-color:"+q.sap.encodeHTML(s.sLineColor)+"' class='sapUiUx3ShellColorPickerPreview'></div>"});var h=new sap.ui.commons.Tab().setText("Header Bar").addContent(new c.layout.MatrixLayout({layoutFixed:false}).createRow(new c.Label({text:"Line Color (ByD-style only):"}),new c.layout.MatrixLayoutCell().addContent(this.oLinePreviewHtml).addContent(l)).createRow(null).createRow(new c.Label({text:"Header Image:"}),this.oHdrImgHtml));a.addTab(h);this.oLogoImgHtml=new sap.ui.core.HTML(i+"logoImageHolder",{preferDOM:true,content:"<div id='"+i+"logoImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+i+"logoImageImg' src='"+(this.oTransientSettings.sLogoImageSrc?q.sap.encodeHTML(this.oTransientSettings.sLogoImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'/></div>"});this.oLogoRbg=new c.RadioButtonGroup().addItem(new sap.ui.core.Item({text:"Left",key:"left"})).addItem(new sap.ui.core.Item({text:"Center",key:"center"})).attachSelect(this._handleLogoAlignChange,this);this.oUseLogoSizeCb=new c.CheckBox({text:"Use original image size",checked:this.oTransientSettings.bUseLogoSize,change:q.proxy(this._handleUseLogoSizeChange,this)});var L=new sap.ui.commons.Tab().setText("Logo").addContent(new c.layout.MatrixLayout({layoutFixed:false}).createRow(new c.Label({text:"Logo Image:"}),this.oLogoImgHtml).createRow(new c.Label({text:"Position:"}),this.oLogoRbg).createRow(this.oUseLogoSizeCb));a.addTab(L);d.addContent(a);var t=this;d.addButton(new c.Button({text:"Reset All",press:function(){t.applySettings(q.extend({},S.getOriginalSettings()));t.oSettings={};t.oTransientSettings={};t.updateDialog();t._bindDragAndDrop("bg");t._bindDragAndDrop("hdr");t._bindDragAndDrop("logo");t.firePersonalizationChange({settings:{}});}}));d.addButton(new c.Button({text:"OK",press:function(){t.oSettings=q.extend({},t.oTransientSettings);t.firePersonalizationChange({settings:t.oSettings});d.close();}}));d.addButton(new c.Button({text:"Cancel",press:function(){d.close();}}));this.oDialog=d;}return this.oDialog;};
S.prototype.updateDialog=function(){var a=q.extend({},S.getOriginalSettings());a=q.extend(a,this.oSettings);var i=this.shell.getId()+"-p13n_";this.oBgImgHtml.setContent("<div id='"+i+"bgImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+i+"bgImageImg' src='"+(a.sBackgroundImageSrc?q.sap.encodeHTML(a.sBackgroundImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'/></div>");this.oBgImgOpacitySlider.setValue(100-a.fBgImgOpacity*100);this.oSidebarOpacitySlider.setValue(100-a.fSidebarOpacity*100);this.oByDStyleCb.setChecked(a.bByDStyle);this.oHdrImgHtml.setContent("<div id='"+i+"hdrImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+i+"hdrImageImg' src='"+(a.sHeaderImageSrc?q.sap.encodeHTML(a.sHeaderImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'/></div>");this.oLogoRbg.setSelectedIndex((a.sLogoAlign=="center")?1:0);this.oUseLogoSizeCb.setChecked(a.bUseLogoSize);this.oLogoImgHtml.setContent("<div id='"+i+"logoImageHolder' class='sapUiUx3ShellP13nImgHolder'><img id='"+i+"logoImageImg' src='"+(a.sLogoImageSrc?q.sap.encodeHTML(a.sLogoImageSrc):sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif'))+"'/></div>");};
S.prototype._handleByDStyleChange=function(e){var c=e.getParameter("checked");this.oTransientSettings.bByDStyle=c;this.applyByDStyle(c);};
S.prototype.applyByDStyle=function(b){this.shell.$().toggleClass("sapUiUx3ShellByD",b);};
S.prototype._handleBgColorChange=function(e){var c=e.getParameter("cssColor");this.oTransientSettings.sBgColor=c;this.applyBgColor(c);};
S.prototype.applyBgColor=function(c){this.shell.$("bg").css("background-color",c);this.shell.$("bgColor").css("background-color",c);};
S.prototype._handleBackgroundImageChange=function(u,p){var t=true;if(p){if(t){this.oSettings.sBgCssImg="url("+u+")";this.oSettings.sBgImgSrc=null;}else{this.oSettings.sBgCssImg=null;this.oSettings.sBgImgSrc=u;}this.applyBgImage(this.oSettings.sBgCssImg,this.oSettings.sBgImgSrc);this.firePersonalizationChange({settings:this.oSettings});}else{if(t){this.oTransientSettings.sBgCssImg="url("+u+")";this.oTransientSettings.sBgImgSrc=null;}else{this.oTransientSettings.sBgCssImg=null;this.oTransientSettings.sBgImgSrc=u;}this.applyBgImage(this.oTransientSettings.sBgCssImg,this.oTransientSettings.sBgImgSrc);}};
S.prototype.applyBgImage=function(b,s){b=b?b:"";s=s?s:S.TRANSPARENT_1x1;var o=this.shell.getDomRef("bgImg");o.style.backgroundImage=b;o.src=s;};
S.prototype._handleHeaderImageChange=function(d,p){if(p){this.oSettings.sHeaderImageSrc=d;this.firePersonalizationChange({settings:this.oSettings});}else{this.oTransientSettings.sHeaderImageSrc=d;}this.applyHeaderImage(d);};
S.prototype.applyHeaderImage=function(d){this.shell.$("hdr").css("background-image","url("+d+")");if(this.oDialog&&this.oDialog.isOpen()){this.shell.$("p13n_hdrImageImg").attr("src",d);}};
S.prototype._handleLineColorChange=function(e){var c=e.getParameter("cssColor");this.oTransientSettings.sLineColor=c;this.applyLineColor(c);};
S.prototype.applyLineColor=function(c){this.shell.$("hdr").find("hr").css("background-color",c);this.shell.$("lineColor").css("background-color",c);};
S.prototype._handleBgImageOpacitySliderChange=function(e){var v=(100-e.getParameter("value"))/100;this.oTransientSettings.fBgImgOpacity=v;this.applyBgImageOpacity(v);};
S.prototype.applyBgImageOpacity=function(v){this.shell.$("bgImg").css("opacity",v);};
S.prototype._handleSidebarOpacitySliderChange=function(e){var v=(100-e.getParameter("value"))/100;this.oTransientSettings.fSidebarOpacity=v;this.applySidebarOpacity(v);};
S.prototype.applySidebarOpacity=function(v){this.shell.$("tp").css("opacity",v);this.shell.$("paneBar").children(":nth-child(2)").css("opacity",v);};
S.prototype._handleLogoImageChange=function(u,p){if(p){this.oSettings.sLogoImageSrc=u;this.firePersonalizationChange({settings:this.oSettings});}else{this.oTransientSettings.sLogoImageSrc=u;}this.applyLogoImage(u);};
S.prototype.applyLogoImage=function(u){if(!u){u=this.shell.getAppIcon();if(!u){u=S.TRANSPARENT_1x1;}}this.shell.$("logoImg").attr("src",u);this.shell.$("p13n_logoImageImg").attr("src",u);};
S.prototype._handleLogoAlignChange=function(e){var i=e.getParameter("selectedIndex");var a=["left","center"][i];this.oTransientSettings.sLogoAlign=a;this.applyLogoAlign(a);};
S.prototype.applyLogoAlign=function(l){var r=l;if(sap.ui.getCore().getConfiguration().getRTL()&&(r=="right")){r="left";}this.shell.$("hdr").css("text-align",r);};
S.prototype._handleUseLogoSizeChange=function(e){var u=e.getParameter("checked");this.oTransientSettings.bUseLogoSize=u;this.applyUseLogoSize(u);};
S.prototype.applyUseLogoSize=function(u){this.shell.$("hdr").toggleClass("sapUiUx3ShellHeaderFlex",u);this.shell.$("hdrImg").toggleClass("sapUiUx3ShellHeaderImgFlex",u);};
S.prototype._handleDragover=function(e){var i=e.target.id;if(!this._dragOverBlinking){var $=q.sap.byId(i);$.css("opacity","0.5");this._dragOverBlinking=true;var t=this;window.setTimeout(function(){$.css("opacity","1");window.setTimeout(function(){t._dragOverBlinking=null;},250);},250);}return false;};
S.prototype._handleDragend=function(e){return false;};
S.prototype._handleDrop=function(a){var i=a.target.id;a.preventDefault();var e=a.originalEvent;var f=e.dataTransfer.files[0];if(f){var r=new window.FileReader();r.onload=q.proxy(function(b){var d=b.target.result;if((i==this.shell.getId()+"-p13n_bgImageImg")||(i==this.shell.getId()+"-p13n_bgImageHolder")){this._handleBackgroundImageChange(d);}else if((i==this.shell.getId()+"-p13n_hdrImageImg")||(i==this.shell.getId()+"-p13n_hdrImageHolder")){this._handleHeaderImageChange(d);}else if((i==this.shell.getId()+"-p13n_logoImageImg")||(i==this.shell.getId()+"-p13n_logoImageHolder")){this._handleLogoImageChange(d);}r=null;},this);r.readAsDataURL(f);}};
return S;},true);
sap.ui.predefine('sap/ui/ux3/ShellRenderer',['jquery.sap.global','sap/ui/core/IconPool'],function(q,I){"use strict";var S={};
S.render=function(r,c){var a=r;var p=c.isPaneOpen();var P=c.getPaneWidth()+sap.ui.ux3.Shell.SIDE_BAR_BASE_WIDTH;var R=sap.ui.getCore().getConfiguration().getRTL();var s=c.getId();if(sap.ui.ux3.Shell.FIRST_RENDERING){document.body.style.margin="0";}a.write("<div");a.writeControlData(c);a.addClass("sapUiUx3Shell");a.addClass("sapUiUx3ShellHead"+c.getHeaderType());a.addClass("sapUiUx3ShellDesign"+c.getDesignType());if(!c._hasDarkDesign()){a.addClass("sapUiUx3ShellDesignLight");}if(c.getFullHeightContent()){a.addClass("sapUiUx3ShellFullHeightContent");}if(!c.getApplyContentPadding()){a.addClass("sapUiUx3ShellNoContentPadding");}if(!c.getShowTools()){a.addClass("sapUiUx3ShellNoTools");}if(!c.getShowPane()){a.addClass("sapUiUx3ShellNoPane");}if(c._topSyncRefId&&!c.getAllowOverlayHeaderAccess()){a.addClass("sapUiUx3ShellBlockHeaderAccess");}a.writeClasses();a.write(">");a.write("<img id='"+s+"-hdrImg' class='sapUiUx3ShellHeaderImg' src='");var b=sap.ui.core.theming.Parameters._getThemeImage('sapUiUx3ShellHeaderImageURL',true);a.writeEscaped(b);a.write("' />");a.write("<header id='"+s+"-hdr' class='sapUiUx3ShellHeader' role='banner'>");var t=c._topSyncRefId?" tabindex='0'":"";a.write("<span class='sapUiUx3ShellFocusDummy' id='"+s+"-focusDummyHdrStart'"+t+"></span>");S.renderHeader(a,c);a.write("<span class='sapUiUx3ShellFocusDummy' id='"+s+"-focusDummyHdrEnd'"+t+"></span>");a.write("</header>");a.write("<div id='",s,"-bg' class='sapUiUx3ShellBg'></div>");a.write("<img id='",s,"-bgImg' class='sapUiUx3ShellBgImg' src='");b=sap.ui.core.theming.Parameters._getThemeImage('sapUiUx3ShellBackgroundImageURL',true);a.writeEscaped(b);a.write("'/>");var w=p?" style='margin-"+(R?"left":"right")+":"+(P+22)+"px'":"";a.write("<div id='",s,"-wBar'"+w+" class='sapUiUx3ShellWorksetBar'>");S.renderWorksetItems(a,c);a.write("</div>");a.write("<section id='"+s+"-tp' class='sapUiUx3ShellToolPaletteArea' role='complementary' data-sap-ui-fastnavgroup='true'>");S.renderToolPalette(a,c);a.write("</section>");var d=p?" style='"+(R?"left":"right")+":"+P+"px'":"";a.write("<div class='sapUiUx3ShellCanvas'"+d+" id='"+s+"-canvas'>");S.renderFacetBar(a,c);a.write("<article class='sapUiUx3ShellContent' id='"+s+"-content' role='main' data-sap-ui-fastnavgroup='true'>");var C=c.getContent();for(var i=0;i<C.length;i++){a.renderControl(C[i]);}a.write("</article><div class='sapUiUx3ShellNotifySpace'></div></div>");var t=c._topSyncRefId?" tabindex='0'":"";a.write("<span class='sapUiUx3ShellFocusDummy' id='"+s+"-focusDummyPane'"+t+"></span>");a.write("<aside id='"+s+"-paneBar' class='sapUiUx3ShellPaneBar "+(p?" sapUiUx3ShellPaneBarOpen sapUiUx3ShellPaneBarOpened":" sapUiUx3ShellPaneBarClose")+"' role='complementary' style='width:"+P+"px;'>");a.write("<section id='"+s+"-paneContent' style='width:"+c.getPaneWidth()+"px;' class='sapUiUx3ShellPaneBarContent' role='tabpanel'>");var e=c.getPaneContent();for(var i=0;i<e.length;i++){a.renderControl(e[i]);}a.write("</section>");a.write("<div id='"+s+"-paneBarRight' class='sapUiUx3ShellPaneBarRight' data-sap-ui-fastnavgroup='true'>");a.write("<ul id='"+s+"-paneBarEntries' class='sapUiUx3ShellPaneEntries' role='tablist'>");S.renderPaneBarItems(a,c);a.write("</ul>");a.write("<div id='"+s+"-paneBarOverflowButton' class='sapUiUx3ShellPaneOverflowButton'");a.addStyle("display","none;");a.writeStyles();a.write(">");a.write("<div id='"+s+"-paneBarOverflowWrapper' class='sapUiUx3ShellPaneOverflowWrapper'>");a.write("<span id='"+s+"-paneBarOverflowText' class='sapUiUx3ShellPaneOverflowText sapUiUx3ShellPaneEntry'>");a.write(sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3").getText("SHELL_MORE_BUTTON"));a.write("</span>");a.write("</div>");a.write("</div>");a.write("</div>");a.write("</aside>");a.write("<div class='sapUiUx3ShellCanvasBackground "+(p?"sapUiUx3ShellCanvasBackgroundOpen":"sapUiUx3ShellCanvasBackgroundClosed")+"' id='"+s+"-canvasBackground'"+d+">");a.write("<div class='sapUiUx3ShellCanvasBackgroundRight'></div>");a.write("</div>");a.write("<div id='"+s+"-notify' class='sapUiUx3ShellNotify'>");S.renderNotificationArea(a,c);a.write("</div>");a.write("</div>");};
S.renderHeader=function(r,c){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var b=c.getAppIcon();r.write("<hr id='"+c.getId()+"-hdrLine'/>");r.write("<span id='"+c.getId()+"-hdr-items' class='sapUiUx3ShellHeaderTitleRight'>");var h=c.getHeaderItems();for(var i=0;i<h.length;i++){if(h[i]instanceof sap.ui.commons.MenuButton){if(h[i].getMenu()){h[i].getMenu().addStyleClass("sapUiMnuTop",true);}}r.renderControl(h[i]);if((i<(h.length-1))||(c.getShowLogoutButton())){r.write("<span class='sapUiUx3ShellHeaderSep'></span>");}}if(c.getShowLogoutButton()){r.write("<a id='"+c.getId()+"-logout' title='");r.write(c.getLogoutButtonTooltip()?q.sap.encodeHTML(c.getLogoutButtonTooltip()):a.getText("SHELL_LOGOUT"));r.write("' tabindex='0' role='button' class='sapUiUx3ShellHeaderButton sapUiUx3ShellHeader-logout'></a>");}r.write("</span>");r.write("<span class='sapUiUx3ShellHeaderTitleLeft' ");r.writeAttributeEscaped("title",c.getAppTitle());r.write(">");r.write("<img id='"+c.getId()+"-logoImg' src='");if(b){r.writeEscaped(c.getAppIcon());}else{var s=sap.ui.core.theming.Parameters._getThemeImage('sapUiUx3ShellApplicationImageURL',true);r.writeEscaped(s);}r.write("'");var d=c.getAppIconTooltip()||a.getText("SHELL_LOGO");r.writeAttributeEscaped("alt",d);r.writeAttributeEscaped("title",d);r.write(">");r.write("<span>");r.writeEscaped(c.getAppTitle());r.write("</span>");r.write("</span>");};
S.renderToolPalette=function(r,c){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var s=c.getId();var t=c._topSyncRefId?" tabindex='0'":"";r.write("<span class='sapUiUx3ShellFocusDummy' id='"+c.getId()+"-focusDummyTPStart'"+t+"></span>");var A=a.getText("SHELL_TOOLPANE_GENERIC"),b=false,f=true,d="";if(c.getShowSearchTool()){b=true;d+="<a id='"+s+sap.ui.ux3.Shell.TOOL_PREFIX+s+"-searchTool' title='"+a.getText("SHELL_SEARCH")+"' class='sapUiUx3ShellTool sapUiUx3ShellTool-search' tabindex='0' role='button' aria-pressed='false'></a>";if(f){f=false;}else{A+=",";}A+=" "+a.getText("SHELL_SEARCH");}if(c.getShowFeederTool()){b=true;d+="<a id='"+s+sap.ui.ux3.Shell.TOOL_PREFIX+s+"-feederTool' title='"+a.getText("SHELL_FEEDER")+"' class='sapUiUx3ShellTool sapUiUx3ShellTool-feeder' tabindex='0' role='button' aria-pressed='false'></a>";if(f){f=false;}else{A+=",";}A+=" "+a.getText("SHELL_FEEDER");}if(b){r.write("<div role='toolbar'aria-describedby='"+s+"-genericToolsDescr'>");r.write("<span id='"+s+"-genericToolsDescr' style='display:none;'>"+A+"</span>");r.write(d+"</div>");}var T=c.getToolPopups();if(b&&(T.length>0)){r.write("<hr id='"+s+"-tp-separator' class='sapUiUx3ShellToolSep'/>");}if(T.length>0){r.write("<div role='toolbar' aria-describedby='"+s+"-appToolsDescr'>");r.write("<span id='"+s+"-appToolsDescr' style='display:none;'>"+a.getText("SHELL_TOOLPANE_APP")+"</span>");for(var i=0;i<T.length;i++){var o=T[i];if(o instanceof sap.ui.core.SeparatorItem){r.write("<hr class='sapUiUx3ShellToolSep'/>");}else{r.write("<a id='"+s+"-tool-"+o.getId()+"' class='sapUiUx3ShellTool'");var e=o.getTooltip_AsString();if(!e){e=o.getTitle();}if(e){r.write(" title='");r.writeEscaped(e);r.write("' ");}r.write(" tabindex='0' role='button' aria-pressed='false'>");var g=o.getIcon();if(I.isIconURI(g)){r.writeIcon(g,["sapUiUx3ShellToolFontIcon"],{"title":null,"aria-label":null});}else{r.write("<img src='");r.writeEscaped(g);r.write("' alt='' role='presentation'/>");}r.write("</a>");}}r.write("</div>");}r.write("<span class='sapUiUx3ShellFocusDummy' id='"+c.getId()+"-focusDummyTPEnd'"+t+"></span>");};
S.renderPaneBarItems=function(r,c){var s=c.getId();var p=c.getPaneBarItems();var n=p.length;for(var i=0;i<n;i++){var a=p[i];var b=a.getId();r.write("<li");r.writeElementData(a);r.write(" role='tab' aria-controls='"+s+"-paneContent' aria-setsize='"+n+"' aria-posinset='"+(i+1)+"' tabindex='-1' class='sapUiUx3ShellPaneEntry");if(c._sOpenPaneId===b){r.write(" sapUiUx3ShellPaneEntrySelected");}r.write("'");if(a.getTooltip_AsString()){r.writeAttributeEscaped("title",a.getTooltip_AsString());}r.write(">");r.writeEscaped(a.getText().toUpperCase());r.write("</li>");}};
S.renderNotificationArea=function(r,c){r.write("<div class='sapUiUx3ShellNotifyBG'></div>");if(c.getNotificationBar()){r.renderControl(c.getNotificationBar());}};
S.renderWorksetItems=function(r,c){var i=c.getWorksetItems();c._oWorksetBar.setAssociatedItems(i);if(!c._oWorksetBar.isSelectedItemValid()&&(i.length>0)){c.setAssociation("selectedWorksetItem",i[0],true);c._oWorksetBar.setSelectedItem(i[0]);}if(r){r.renderControl(c._oWorksetBar);}};
S.renderFacetBar=function(r,c){var s=sap.ui.getCore().byId(c.getSelectedWorksetItem());if(s){var p=s.getParent();if(p&&p instanceof sap.ui.ux3.NavigationItem){s=p;}var a=s.getSubItems();c._oFacetBar.setAssociatedItems(a);if(!c._oFacetBar.isSelectedItemValid()&&(a.length>0)){c._oFacetBar.setSelectedItem(a[0]);}}if(r){r.renderControl(c._oFacetBar);}};
return S;},true);
sap.ui.predefine('sap/ui/ux3/ThingAction',['jquery.sap.global','sap/ui/core/Element','./library'],function(q,E){"use strict";
var T=E.extend("sap.ui.ux3.ThingAction",{metadata:{library:"sap.ui.ux3",properties:{text:{type:"string",group:"Misc",defaultValue:null},enabled:{type:"boolean",group:"Misc",defaultValue:true}},events:{select:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"}}}}}});
T.prototype.onclick=function(e){this.fireSelect({id:this.getId(),action:this});};
T.prototype.onsapselect=function(e){this.fireSelect({id:this.getId(),action:this});};
return T;},true);
sap.ui.predefine('sap/ui/ux3/ThingGroup',['jquery.sap.global','sap/ui/core/Element','./library'],function(q,E){"use strict";
var T=E.extend("sap.ui.ux3.ThingGroup",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},colspan:{type:"boolean",group:"Misc",defaultValue:false}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"},actions:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"action"}}}});
return T;},true);
sap.ui.predefine('sap/ui/ux3/ThingInspector',['jquery.sap.global','./ActionBar','./Overlay','./ThingViewer',"./ThingInspectorRenderer",'./library'],function(q,A,O,T,a){"use strict";
var b=O.extend("sap.ui.ux3.ThingInspector",{metadata:{library:"sap.ui.ux3",properties:{firstTitle:{type:"string",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},secondTitle:{type:"string",group:"Misc",defaultValue:null},followState:{type:"sap.ui.ux3.FollowActionState",group:"Misc",defaultValue:sap.ui.ux3.FollowActionState.Default},flagState:{type:"boolean",group:"Misc",defaultValue:false},favoriteState:{type:"boolean",group:"Misc",defaultValue:false},favoriteActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},updateActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},followActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},flagActionEnabled:{type:"boolean",group:"Misc",defaultValue:true},headerType:{type:"sap.ui.ux3.ThingViewerHeaderType",group:"Misc",defaultValue:sap.ui.ux3.ThingViewerHeaderType.Standard}},aggregations:{actions:{type:"sap.ui.ux3.ThingAction",multiple:true,singularName:"action"},headerContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"headerContent"},facets:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"facet"},facetContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"facetContent"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false},thingViewer:{type:"sap.ui.ux3.ThingViewer",multiple:false,visibility:"hidden"}},associations:{selectedFacet:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{actionSelected:{parameters:{id:{type:"string"},action:{type:"sap.ui.ux3.ThingAction"}}},facetSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}},feedSubmit:{parameters:{text:{type:"string"}}}}}});
(function(){
b.prototype.init=function(){var o,t=this;O.prototype.init.apply(this);this._oThingViewer=new T(this.getId()+"-thingViewer");this.setAggregation("thingViewer",this._oThingViewer);this._oThingViewer.attachFacetSelected(function(e){var i=e.getParameters().item;if(t.fireFacetSelected({id:i.getId(),key:i.getKey(),item:i})){t.setSelectedFacet(i);}else{e.preventDefault();}});this._oSocialActions={};if(this.getActionBar()==null){o=new A(this.getId()+"-actionBar");o.setShowOpen(false);o.setAlwaysShowMoreMenu(false);o.setDividerWidth("252px");o.attachActionSelected(function(e){var s=e.getParameters().id,B=e.getParameters().action,c;if(s.indexOf(sap.ui.ux3.ActionBarSocialActions.Favorite)!==-1||s.indexOf(sap.ui.ux3.ActionBarSocialActions.Follow)!==-1||s.indexOf(sap.ui.ux3.ActionBarSocialActions.Flag)!==-1){if(t._oSocialActions[s]){c=t._oSocialActions[s];}else{c=new sap.ui.ux3.ThingAction({id:t.getId()+"-"+s.toLowerCase(),text:B.text,enabled:B.enabled});t._oSocialActions[s]=c;}t.fireActionSelected({id:s.toLowerCase(),action:c});}else{t.fireActionSelected({id:e.getParameters().id,action:e.getParameters().action});}});o.attachFeedSubmit(function(e){t.fireFeedSubmit({text:e.getParameters().text});});this.setActionBar(o);}};
b.prototype.onAfterRendering=function(){O.prototype.onAfterRendering.apply(this,arguments);var s=this._getShell();this._bShell=!!s;if(!s){this._applyChanges({showOverlay:false});}};
b.prototype.onBeforeRendering=function(){O.prototype.onBeforeRendering.apply(this,arguments);};
b.prototype.exit=function(){this._oThingViewer.exit(arguments);this._oThingViewer.destroy();this._oThingViewer=null;O.prototype.exit.apply(this,arguments);};
b.prototype.open=function(i){if(this.getDomRef()){this.rerender();}O.prototype.open.apply(this,arguments);this._selectDefault();};
b.prototype._getNavBar=function(){return this._oThingViewer._oNavBar;};
b.prototype._selectDefault=function(){this._oThingViewer._selectDefault();};
b.prototype._equalColumns=function(){this._oThingViewer._equalColumns();};
b.prototype._setTriggerValue=function(){this._oThingViewer._setTriggerValue();};
b.prototype._setFocusLast=function(){var f=this.$("thingViewer-toolbar").lastFocusableDomRef();if(!f&&this.getCloseButtonVisible()&&this.$("close").is(":sapFocusable")){f=this.getDomRef("close");}else if(!f&&this.getOpenButtonVisible()&&this.$("openNew").is(":sapFocusable")){f=this.getDomRef("openNew");}q.sap.focus(f);};
b.prototype._setFocusFirst=function(){if(this.getOpenButtonVisible()&&this.$("openNew").is(":sapFocusable")){q.sap.focus(this.getDomRef("openNew"));}else if(this.getCloseButtonVisible()&&this.$("close").is(":sapFocusable")){q.sap.focus(this.getDomRef("close"));}else{q.sap.focus(this.$("thingViewer-content").firstFocusableDomRef());}};
b.prototype.insertAction=function(o,i){if(this.getActionBar()){this.getActionBar().insertBusinessAction(o,i);}return this;};
b.prototype.addAction=function(o){if(this.getActionBar()){this.getActionBar().addBusinessAction(o);}return this;};
b.prototype.removeAction=function(o){var r;if(this.getActionBar()){r=this.getActionBar().removeBusinessAction(o);}return r;};
b.prototype.removeAllActions=function(){var r;if(this.getActionBar()){r=this.getActionBar().removeAllBusinessActions();}return r;};
b.prototype.getActions=function(){var r;if(this.getActionBar()){r=this.getActionBar().getBusinessActions();}return r;};
b.prototype.destroyActions=function(){if(this.getActionBar()){this.getActionBar().destroyBusinessActions();}return this;};
b.prototype.indexOfAction=function(o){var r=-1;if(this.getActionBar()){r=this.getActionBar().indexOfBusinessAction(o);}return r;};
b.prototype.getFacets=function(){return this._oThingViewer.getFacets();};
b.prototype.insertFacet=function(f,i){this._oThingViewer.insertFacet(f,i);return this;};
b.prototype.addFacet=function(f){this._oThingViewer.addFacet(f);return this;};
b.prototype.removeFacet=function(e){return this._oThingViewer.removeFacet(e);};
b.prototype.removeAllFacets=function(){return this._oThingViewer.removeAllFacets();};
b.prototype.destroyFacets=function(){this._oThingViewer.destroyFacets();return this;};
b.prototype.indexOfFacet=function(f){return this._oThingViewer.indexOfFacet(f);};
b.prototype.setFollowState=function(f){if(this.getActionBar()){this.getActionBar().setFollowState(f);}return this;};
b.prototype.getFollowState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFollowState();}return r;};
b.prototype.setFlagState=function(f){if(this.getActionBar()){this.getActionBar().setFlagState(f);}return this;};
b.prototype.getFlagState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFlagState();}return r;};
b.prototype.setFavoriteState=function(f){if(this.getActionBar()){this.getActionBar().setFavoriteState(f);}return this;};
b.prototype.getFavoriteState=function(){var r=null;if(this.getActionBar()){r=this.getActionBar().getFavoriteState();}return r;};
b.prototype.setIcon=function(i){this._oThingViewer.setIcon(i);if(this.getActionBar()){this.getActionBar().setThingIconURI(i);}return this;};
b.prototype.getIcon=function(){return this._oThingViewer.getIcon();};
b.prototype.setType=function(t){this._oThingViewer.setType(t);return this;};
b.prototype.getType=function(){return this._oThingViewer.getType();};
b.prototype.insertFacetContent=function(f,i){this._oThingViewer.insertFacetContent(f,i);return this;};
b.prototype.addFacetContent=function(f){this._oThingViewer.addFacetContent(f);return this;};
b.prototype.removeFacetContent=function(f){var r=this._oThingViewer.removeFacetContent(f);return r;};
b.prototype.removeAllFacetContent=function(){var r=this._oThingViewer.removeAllFacetContent();return r;};
b.prototype.destroyFacetContent=function(){this._oThingViewer.destroyFacetContent();return this;};
b.prototype.getFacetContent=function(){return this._oThingViewer.getFacetContent();};
b.prototype.indexOfFacetContent=function(f){return this._oThingViewer.indexOfFacetContent(f);};
b.prototype.setActionBar=function(o){this._oThingViewer.setActionBar(o);return this;};
b.prototype.getActionBar=function(){return this._oThingViewer.getActionBar();};
b.prototype.destroyActionBar=function(){this._oThingViewer.destroyActionBar();};
b.prototype.insertHeaderContent=function(h,i){this._oThingViewer.insertHeaderContent(h,i);return this;};
b.prototype.addHeaderContent=function(h){this._oThingViewer.addHeaderContent(h);return this;};
b.prototype.getHeaderContent=function(){return this._oThingViewer.getHeaderContent();};
b.prototype.removeHeaderContent=function(h){var r=this._oThingViewer.removeHeaderContent(h);return r;};
b.prototype.removeAllHeaderContent=function(){var r=this._oThingViewer.removeAllHeaderContent();return r;};
b.prototype.destroyHeaderContent=function(){this._oThingViewer.destroyHeaderContent();return this;};
b.prototype.indexOfHeaderContent=function(h){return this._oThingViewer.indexOfHeaderContent(h);};
b.prototype.setSelectedFacet=function(s){this._oThingViewer.setSelectedFacet(s);};
b.prototype.getSelectedFacet=function(s){return this._oThingViewer.getSelectedFacet();};
b.prototype.setFavoriteActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowFavorite(e);}return this;};
b.prototype.getFavoriteActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFavorite();}return r;};
b.prototype.setFlagActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowFlag(e);}return this;};
b.prototype.getFlagActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFlag();}return r;};
b.prototype.setUpdateActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowUpdate(e);}return this;};
b.prototype.getUpdateActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowUpdate();}return r;};
b.prototype.setFollowActionEnabled=function(e){if(this.getActionBar()){this.getActionBar().setShowFollow(e);}return this;};
b.prototype.getFollowActionEnabled=function(){var r;if(this.getActionBar()){r=this.getActionBar().getShowFollow();}return r;};
b.prototype.setFirstTitle=function(t){this._oThingViewer.setTitle(t);};
b.prototype.getFirstTitle=function(){return this._oThingViewer.getTitle();};
b.prototype.setSecondTitle=function(t){this._oThingViewer.setSubtitle(t);};
b.prototype.getSecondTitle=function(){return this._oThingViewer.getSubtitle();};
b.prototype.setHeaderType=function(h){this._oThingViewer.setHeaderType(h);return this;};
b.prototype.getHeaderType=function(){var r=this._oThingViewer.getHeaderType();return r;};
b.prototype._applyChanges=function(c){this.oChanges=c;if(c.showOverlay){this.$().removeClass("sapUiUx3TINoFrame");}else{this.$().addClass("sapUiUx3TINoFrame");}return this;};
}());return b;},true);
sap.ui.predefine('sap/ui/ux3/ThingInspectorRenderer',['jquery.sap.global','sap/ui/core/Renderer','./OverlayRenderer'],function(q,R,O){"use strict";var T=R.extend(O);
T.renderContent=function(r,c){var a=r;a.write("<div role='Main' class='sapUiUx3TIContent' id='"+c.getId()+"-content'>");a.renderControl(c._oThingViewer);a.write("</div>");};
T.addRootClasses=function(r,c){var a=r;a.addClass("sapUiUx3TI");};
T.addOverlayClasses=function(r,c){var a=r;a.addClass("sapUiUx3TIOverlay");};
return T;},true);
sap.ui.predefine('sap/ui/ux3/ThingViewer',['jquery.sap.global','sap/ui/core/Control',"./ThingViewerRenderer",'./library'],function(q,C,T){"use strict";
var a=C.extend("sap.ui.ux3.ThingViewer",{metadata:{library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},type:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},subtitle:{type:"string",group:"Misc",defaultValue:null},width:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:'100%'},headerType:{type:"sap.ui.ux3.ThingViewerHeaderType",group:"Misc",defaultValue:sap.ui.ux3.ThingViewerHeaderType.Standard}},aggregations:{headerContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"headerContent"},facets:{type:"sap.ui.ux3.NavigationItem",multiple:true,singularName:"facet"},facetContent:{type:"sap.ui.ux3.ThingGroup",multiple:true,singularName:"facetContent"},actionBar:{type:"sap.ui.ux3.ActionBar",multiple:false},navBar:{type:"sap.ui.ux3.NavigationBar",multiple:false,visibility:"hidden"}},associations:{selectedFacet:{type:"sap.ui.ux3.NavigationItem",multiple:false}},events:{facetSelected:{allowPreventDefault:true,parameters:{id:{type:"string"},item:{type:"sap.ui.ux3.NavigationItem"},key:{type:"string"}}}}}});
(function(){
a.prototype.init=function(){var t=this;this._oNavBar=new sap.ui.ux3.NavigationBar();this.setAggregation("navBar",this._oNavBar);this._oNavBar.attachSelect(function(c){var i=c.getParameters().item;if(t.fireFacetSelected({id:i.getId(),key:i.getKey(),item:i})){t.setSelectedFacet(i);}else{c.preventDefault();}});};
a.prototype.onAfterRendering=function(){this._resize=false;if(this.getActionBar()){this._adjustStyles();}if(this.$().find(".sapUiUx3TVFacetContent").length<=0){return;}this._resizeListenerId=sap.ui.core.ResizeHandler.register(this.$().find(".sapUiUx3TVFacetContent")[0],q.proxy(this._onresize,this));this._setTriggerValue();this._setHeaderPosition();this._onresize();};
a.prototype.onBeforeRendering=function(){if(this._resizeListenerId){sap.ui.core.ResizeHandler.deregister(this._resizeListenerId);this._resizeListenerId=null;}};
a.prototype._setHeaderPosition=function(){if(this.getHeaderType()===sap.ui.ux3.ThingViewerHeaderType.Standard){var $=this.$().find(".sapUiUx3TVHeaderContainerIdentifier"),b=this.$().find(".sapUiUx3TVHeaderGroupScrollContainer");b.css("top",$.outerHeight());}};
a.prototype._onresize=function(e){var w;if(e){w=q(e.target).width();}if(!w){w=q(this.$().find(".sapUiUx3TVFacetContent")[0]).width();}if(w<this._triggerValue&&this._resize==false){var f=this.$().find(".sapUiUx3TVFacetThingGroup");for(var i=0;i<f.length;i++){q(f[i]).animate({width:"100%"},"fast");}this._resize=true;}else if(w>this._triggerValue&&this._resize==true){var f=this.$().find(".sapUiUx3TVFacetThingGroup");for(var i=0;i<f.length;i++){q(f[i]).animate({width:"50%"},"fast");}this._resize=false;}if(this.getActionBar()){var m=this.getActionBar().getActionBarMinWidth(),b=m;if(this._bShell){m+=36;b=m+60;}this.$().find(".sapUiUx3TV").css("min-width",b+"px");this.$().find(".sapUiUx3TVContent").css("min-width",m+"px");}};
a.prototype.exit=function(){this._oNavBar.destroy();if(this._resizeListenerId){sap.ui.core.ResizeHandler.deregister(this._resizeListenerId);this._resizeListenerId=null;}};
a.prototype._getNavBar=function(){return this._oNavBar;};
a.prototype._selectDefault=function(){var n=this._oNavBar.getItems();if(n.length&&!this._oNavBar.getSelectedItem()){if(!this.getSelectedFacet()){this.setSelectedFacet(n[0]);}var i=this._oNavBar.getSelectedItem(),b=sap.ui.getCore().byId(i);this.fireFacetSelected({id:b.getId(),key:b.getKey(),item:b});}};
a.prototype._equalColumns=function(){var h=this.$().find(".sapUiUx3TVHeader"),f=this.$().find(".sapUiUx3TVFacets"),s=this.$().find(".sapUiUx3TVContentScrollContainer"),b=s.get(0).scrollHeight;f.height(b);h.height(b);};
a.prototype._rerenderHeader=function(){var $=this.$("header");if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ThingViewerRenderer.renderHeader(r,this);r.flush($[0]);r.destroy();}};
a.prototype._rerenderHeaderContent=function(){var $=this.$("headerContent");if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ThingViewerRenderer.renderHeaderContent(r,this);r.flush($[0]);r.destroy();}};
a.prototype._rerenderToolbar=function(){var $=this.$("toolbar");if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ThingViewerRenderer.renderToolbar(r,this);r.flush($[0]);r.destroy();}};
a.prototype._rerenderFacetContent=function(){var $=this.$("facetContent");if($.length>0){var r=sap.ui.getCore().createRenderManager();sap.ui.ux3.ThingViewerRenderer.renderFacetContent(r,this);r.flush($[0]);r.destroy();this._resize=false;this._setTriggerValue();this._onresize();}};
a.prototype._setTriggerValue=function(){var f,m,$=this.$("facetContent");if($.length>0){f=this.$().find(".sapUiUx3TVFacetThingGroup");m=q(f[0]).css("min-width");if(m){this._triggerValue=parseInt(m,10)*2;}}};
a.prototype.getFacets=function(){return this._oNavBar.getItems();};
a.prototype.insertFacet=function(f,i){this._oNavBar.insertItem(f,i);return this;};
a.prototype.addFacet=function(f){this._oNavBar.addItem(f);return this;};
a.prototype.removeFacet=function(e){return this._oNavBar.removeItem(e);};
a.prototype.removeAllFacets=function(){return this._oNavBar.removeAllItems();};
a.prototype.destroyFacets=function(){this._oNavBar.destroyItems();return this;};
a.prototype.setIcon=function(i){this.setProperty("icon",i);if(this.getActionBar()){this.getActionBar().setThingIconURI(i);}this._rerenderHeader();return this;};
a.prototype.insertFacetContent=function(f,i){this.insertAggregation("facetContent",f,i,true);this._rerenderFacetContent();return this;};
a.prototype.addFacetContent=function(f){this.addAggregation("facetContent",f,true);this._rerenderFacetContent();return this;};
a.prototype.removeFacetContent=function(f){var r=this.removeAggregation("facetContent",f,true);this._rerenderFacetContent();return r;};
a.prototype.removeAllFacetContent=function(){var r=this.removeAllAggregation("facetContent",true);this._rerenderFacetContent();return r;};
a.prototype.destroyFacetContent=function(){this.destroyAggregation("facetContent",true);this._rerenderFacetContent();return this;};
a.prototype.insertHeaderContent=function(h,i){this.insertAggregation("headerContent",h,i,true);this._rerenderHeaderContent();return this;};
a.prototype.addHeaderContent=function(h){this.addAggregation("headerContent",h,true);this._rerenderHeaderContent();return this;};
a.prototype.removeHeaderContent=function(h){var r=this.removeAggregation("headerContent",h,true);this._rerenderHeaderContent();return r;};
a.prototype.removeAllHeaderContent=function(){var r=this.removeAllAggregation("headerContent",true);this._rerenderHeaderContent();return r;};
a.prototype.destroyHeaderContent=function(){this.destroyAggregation("headerContent",true);this._rerenderHeaderContent();return this;};
a.prototype.setSelectedFacet=function(s){var o=this.getSelectedFacet();this.setAssociation("selectedFacet",s,true);var n=this.getSelectedFacet();if(o!=n){this._oNavBar.setSelectedItem(n);}};
a.prototype.setTitle=function(t){this.setProperty("title",t,true);this._rerenderHeader();};
a.prototype.setSubtitle=function(t){this.setProperty("subtitle",t,true);this._rerenderHeader();};
a.prototype.setActionBar=function(A){this.setAggregation("actionBar",A,true);if(this.getIcon()&&this.getActionBar()){this.getActionBar().setThingIconURI(this.getIcon());}this._rerenderToolbar();this._adjustStyles();return this;};
a.prototype._adjustStyles=function(){var $=this.$().find(".sapUiUx3TVHeader"),b=this.$().find(".sapUiUx3TVFacets");if($.length>0){$.addClass("sapUiUx3TVActionBar");$.removeClass("sapUiUx3TVNoActionBar");}if(b.length>0){b.addClass("sapUiUx3TVActionBar");b.removeClass("sapUiUx3TVNoActionBar");}};
}());return a;},true);
sap.ui.predefine('sap/ui/ux3/ThingViewerRenderer',['jquery.sap.global'],function(q){"use strict";var T={};
T.render=function(r,c){var a=r;a.write("<div");a.writeControlData(c);a.writeAttributeEscaped("style","width:"+c.getWidth()+"; height:"+c.getHeight());a.addClass('sapUiUx3TV');a.writeClasses();a.write(">");this.renderContent(a,c);a.write("</div>");};
T.renderContent=function(r,c){var a=r,h=c.getHeaderType();a.write("<div role='Main' class='sapUiUx3TVContent' id='"+c.getId()+"-content'>");a.write("<div class='sapUiUx3TVHeader sapUiUx3TVNoActionBar");if(c.getHeaderType()===sap.ui.ux3.ThingViewerHeaderType.Standard){a.write("'>");}else{a.write(" sapUiUx3TVhorizontal'>");}a.write("<div class='sapUiUx3TVHeaderContainerIdentifier'>");a.write("<span role='heading' aria-level='1' class='sapUiUx3TVIdentifier'");a.writeAttributeEscaped("title",c.getType());a.write(">");a.writeEscaped(c.getType());a.write("</span>");a.write("</div>");if(h===sap.ui.ux3.ThingViewerHeaderType.Standard){a.write("<div class='sapUiUx3TVHeaderGroupScrollContainer'>");a.write("<div id='"+c.getId()+"-header' class='sapUiUx3TVHeaderContainer'>");this.renderHeader(a,c);a.write("</div>");}else{a.write("<div id='"+c.getId()+"-header' class='sapUiUx3TVHeaderContainer'>");this.renderHeader(a,c);a.write("</div>");a.write("<div class='sapUiUx3TVHeaderGroupScrollContainer sapUiUx3TVhorizontal'>");}a.write("<div id='"+c.getId()+"-headerContent'");if(h===sap.ui.ux3.ThingViewerHeaderType.Standard){a.write(">");}else{a.write("style='height:100%; white-space:nowrap'>");}this.renderHeaderContent(a,c);a.write("</div>");a.write("</div>");a.write("</div>");a.write("<div class='sapUiUx3TVFacets sapUiUx3TVNoActionBar");if(h===sap.ui.ux3.ThingViewerHeaderType.Standard){a.write("'>");}else{a.write(" sapUiUx3TVhorizontal'>");}a.write("<div role='Navigation' class='sapUiUx3TVFacetBar'>");a.renderControl(c._getNavBar());a.write("</div>");a.write("<div id='"+c.getId()+"-facetContent' class='sapUiUx3TVFacetContent sapUiBodyBackground'>");this.renderFacetContent(a,c);a.write("</div>");a.write("</div>");this.renderToolbar(a,c);a.write("</div>");};
T.addRootClasses=function(r,c){var a=r;a.addClass("sapUiUx3TV");};
T.addOverlayClasses=function(r,c){var a=r;a.addClass("sapUiUx3TVOverlay");};
T.renderHeader=function(r,c){var a=r;a.write("<div class='sapUiUx3TVIconBar'>");a.writeIcon(c.getIcon(),["sapUiUx3TVIcon"],{role:'presentation',id:c.getId()+'-swatch',title:null});a.write("<div class='sapUiUx3TVTitle'>");a.write("<span role='heading' aria-level='2' class='sapUiUx3TVTitleFirst'");a.writeAttributeEscaped("title",c.getTitle());a.write(">");a.writeEscaped(c.getTitle());a.write("</span><br/>");a.write("</div><div class='sapUiUx3TVTitle'>");a.write("<span role='heading' aria-level='3' class='sapUiUx3TVTitleSecond'");a.writeAttributeEscaped("title",c.getSubtitle());a.write(">");a.writeEscaped(c.getSubtitle());a.write("</span>");a.write("</div>");a.write("</div>");};
T.renderToolbar=function(r,c){if(c.getActionBar()){r.write("<div id='"+c.getId()+"-toolbar' class='sapUiUx3TVToolbar'>");r.renderControl(c.getActionBar());r.write("</div>");}};
T.renderHeaderContent=function(r,c){var h=c.getHeaderContent(),a=c.getHeaderType();for(var i=0;i<h.length;i++){var b=h[i];if(a===sap.ui.ux3.ThingViewerHeaderType.Standard){r.write("<hr class='sapUiUx3TVHRWhite'>");}r.write("<div class='sapUiUx3TVHeaderContainer");if(a===sap.ui.ux3.ThingViewerHeaderType.Standard){r.write("' role='form'>");}else{r.write(" sapUiUx3TVhorizontal' role='form'>");}if(b.getTitle()){r.write("<div class='sapUiUx3TVHeaderGroupTitle'");r.writeAttributeEscaped("title",b.getTooltip_AsString()?b.getTooltip_AsString():b.getTitle());r.write("><span role='heading' aria-level='4'>");r.writeEscaped(b.getTitle());r.write("</span>");r.write("</div>");}r.write("<div class='sapUiUx3TVHeaderGroupContent'>");var d=b.getContent();for(var j=0;j<d.length;j++){var e=d[j];r.renderControl(e);}r.write("</div>");r.write("</div>");}};
T.renderFacetContent=function(r,c){var f=c.getFacetContent();var t=true;if(f.length==1){t=false;}for(var i=0;i<f.length;i++){var g=f[i];if(g.getColspan()){r.write("<div class='sapUiUx3TVFacetThingGroupSpan' role='form'>");}else{r.write("<div class='sapUiUx3TVFacetThingGroup' role='form'>");}if(t){r.write("<div class='sapUiUx3TVFacetThingGroupContentTitle'");r.writeAttributeEscaped("title",g.getTooltip_AsString()?g.getTooltip_AsString():g.getTitle());r.write("><span role='heading'>");r.writeEscaped(g.getTitle());r.write("</span></div>");}r.write("<div class='sapUiUx3TVFacetThingGroupContent'>");var a=g.getContent();for(var j=0;j<a.length;j++){r.renderControl(a[j]);}r.write("</div></div>");}};
return T;},true);
sap.ui.predefine('sap/ui/ux3/ToolPopup',['jquery.sap.global','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/Popup','sap/ui/core/theming/Parameters','sap/ui/core/RenderManager','./library',"./ToolPopupRenderer"],function(q,C,I,P,a,R,l,T){"use strict";
var b=C.extend("sap.ui.ux3.ToolPopup",{metadata:{interfaces:["sap.ui.core.PopupInterface"],library:"sap.ui.ux3",properties:{title:{type:"string",group:"Misc",defaultValue:null},icon:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconHover:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},iconSelected:{type:"sap.ui.core.URI",group:"Misc",defaultValue:null},modal:{type:"boolean",group:"Behavior",defaultValue:false},inverted:{type:"boolean",group:"Misc",defaultValue:true},autoClose:{type:"boolean",group:"Misc",defaultValue:false},maxHeight:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},maxWidth:{type:"sap.ui.core.CSSSize",group:"Misc",defaultValue:null},openDuration:{type:"int",group:"Misc",defaultValue:400},closeDuration:{type:"int",group:"Misc",defaultValue:400}},defaultAggregation:"content",aggregations:{buttons:{type:"sap.ui.core.Control",multiple:true,singularName:"button"},content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},associations:{initialFocus:{type:"sap.ui.core.Control",multiple:false},opener:{type:"sap.ui.core.Control",multiple:false},defaultButton:{type:"sap.ui.core.Control",multiple:false}},events:{open:{},close:{allowPreventDefault:true},enter:{parameters:{originalEvent:{type:"object"},originalSrcControl:{type:"sap.ui.core.Control"}}},iconChanged:{},closed:{},opened:{}}}});
b.ARROW_LEFT=new RegExp(/my:(left|begin)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(right|end)\|[a-z]+/);b.ARROW_RIGHT=new RegExp(/my:(right|end)([-+]\d*\%?)?\|[a-z]+([-+]\d*\%?)? at:(left|begin)\|[a-z]+/);b.ARROW_UP=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|top([-+]\d*\%?)? at:[a-z]+\|bottom/);b.ARROW_DOWN=new RegExp(/my:[a-z]+([-+]\d*\%?)?\|bottom([-+]\d*\%?)? at:[a-z]+\|top/);(function(){
b.prototype.init=function(){this.oPopup=null;this._bPositionSet=false;this._mParameters={};this._mParameters.that=this;this._mParameters.firstFocusable=this.getId()+"-firstFocusable";this._mParameters.lastFocusable=this.getId()+"-lastFocusable";this._bFocusSet=false;this._proxyOpened=q.proxy(p,this);this._proxyClosed=q.proxy(o,this);this._proxyFixSize=q.proxy(f,this);this._proxyOnResize=q.proxy(O,this);s(this);};
b.prototype.exit=function(){if(this.oPopup){this.oPopup.detachOpened(this._proxyOpened);this.oPopup.detachClosed(this._proxyClosed);this.oPopup.destroy();delete this.oPopup;}delete this._bPositionSet;delete this._mParameters;delete this._bFocusSet;delete this._bPreventRestoreFocus;delete this._proxyOpened;delete this._proxyClosed;delete this._bRTL;delete this._sArrowDir;delete this._oArrowIcon;delete this._bThemeInverted;delete this._sInitialFocusId;};
var _=function(i){var t=i;if(!t._bFocusSet){c(t);}else{t._sInitialFocusId=t.oPopup._sInitialFocusId;}return t._sInitialFocusId;};var c=function(k){var E;var F;var t=k;var m=[t._mParameters.firstFocusable,t._mParameters.lastFocusable];var n=q(":sapTabbable",t.$()).get();for(var i=0;i<n.length;i++){if(m.indexOf(n[i].id)===-1){E=n[i];break;}}F=q(E).control();if(F[0]){var v=F[0].getFocusDomRef();E=v||E;}else{E=q.sap.domById(m[0]);}if(E){q.sap.focus(E);t._sInitialFocusId=E.id;}};
function d(t,i){var k,m;if(!i){return null;}k=sap.ui.getCore().byId(i);while(!k&&k!==t){if(!i||!document.getElementById(i)){return null;}m=document.getElementById(i).parentNode;i=m.id;k=sap.ui.getCore().byId(i);}return k;}
b.prototype.getFocusDomRef=function(){var i;var k=d(this,this._sInitialFocusId);if(!k){this._bFocusSet=false;i=_(this);k=d(this,i);}return k?k.getDomRef():this.getDomRef();};
b.prototype.onfocusin=function(E){this._mParameters.event=E;this._mParameters.$FocusablesContent=q(":sapTabbable",this.$("content"));this._mParameters.$FocusablesFooter=q(":sapTabbable",this.$("buttons"));this.oPopup.focusTabChain(this._mParameters);};
var f=function(){var t=this.$();var v=0;var m=this.getMaxHeight();var M=m?parseInt(m,10):0;var i=this.getMaxWidth();if(i){var k=parseInt(i,10);var B=t.css("border-left-width");var n=parseInt(B,10);var w=t.css("border-right-width");var x=parseInt(w,10);var y=t.css("padding-left");var z=parseInt(y,10);var A=t.css("padding-right");var D=parseInt(A,10);k-=n+z+D+x;t.css("max-width",k+"px");}else{t.css("max-width","");}var E=t.css("padding-top");var F=parseInt(E,10);var G=t.css("padding-bottom");var H=parseInt(G,10);var J=t.css("border-top-width");var K=parseInt(J,10);var L=t.css("border-bottom-width");var N=parseInt(L,10);var Q=F+H+K+N;var U=q(document).scrollTop();var V=t.rect();var W=V.top-U+t.outerHeight(true);var X=q(window).height();var Y=(W>X)&&(M===0);var Z=0;if(Y){var $=q.sap.byId(this.getOpener());var a1=$.rect();var b1=a1.top-U+$.outerHeight(true);var c1=this.oPopup._getPositionOffset();if(W>b1&&c1.length>0){Z=Math.abs(parseInt(c1[1],10));if((W-Z)<X){Y=false;var d1="Offset of "+Z+" pushes ToolPopup out of the window";q.sap.log.warning(d1,"","sap.ui.ux3.ToolPopup");}}M=M?M:X-V.top;}t.toggleClass("sapUiUx3TPLargeContent",Y);if(M||Y){t.css("max-height",M+"px");var e1=this.$("title");var f1=this.$("title-separator");var g1=this.$("buttons");var h1=this.$("buttons-separator");v=M>0?M:X-V.top-H-Z;v-=Q;v-=e1.outerHeight(true);v-=f1.outerHeight(true);v-=h1.outerHeight(true);v-=g1.length>0?g1.outerHeight(true):0;v=parseInt(v,10);var i1=this.$("content");i1.css("max-height",v+"px");i1.toggleClass("sapUiUx3TPLargeContent",true);}S(this);};var p=function(){this._proxyFixSize();if(!this._sInitialFocusId){var i=_(this);if(i!==sap.ui.getCore().getCurrentFocusedControlId()){var k=q.sap.byId(i);k.focus();}}if(!this._sResizeID){this._sResizeID=sap.ui.core.ResizeHandler.register(this.$('content')[0],this._proxyOnResize);}this.fireOpened();};
b.prototype.isOpen=function(){return this.oPopup&&(this.oPopup.getOpenState()=="OPENING"||this.oPopup.getOpenState()=="OPEN");};
b.prototype.willBeClosed=function(){var i=this.oPopup&&this.oPopup.getOpenState();return i!==sap.ui.core.OpenState.OPENING&&i!==sap.ui.core.OpenState.OPEN;};
b.prototype.open=function(m,i){this._my=m;this._at=i;this._sArrowDir=g(this);var $=null;this.sOffset="";u(this);if(!this._bPositionSet){var k=0;var n=0;if(!this._my){this._my=P.Dock.BeginTop;}if(!this._at){this._at=P.Dock.EndTop;}$=q.sap.domById(this.getOpener());if($){switch(this._sArrowDir){case"Up":k=0;n=this.iArrowWidth;break;case"Down":k=0;n=-this.iArrowWidth;break;case"Right":k=-this.iArrowWidth;break;default:case"Left":k=this.iArrowWidth;break;}k=parseInt(k,10);n=parseInt(n,10);this.sOffset=""+k+" "+n;this.setPosition(this._my,this._at,$,this.sOffset,"none");}else{this.setPosition(P.Dock.BeginTop,P.Dock.BeginTop,window,"0 0","fit");q.sap.log.warning("No opener set. Using a default position for Popup","","sap.ui.ux3.ToolPopup");}this._bPositionSet=false;}this._ensurePopup();var A=this.getAutoClose();var M=this.getModal();if(A&&M){q.sap.log.warning("A modal & autoclose ToolPopup will not work properly. Therefore 'autoclose' will be deactived!");A=false;}this.oPopup.setAutoClose(A);this.oPopup.setModal(M);this._oPreviousFocus=P.getCurrentFocusInfo();this.fireOpen();e(this);this.oPopup.open(this.getOpenDuration(),this._my,this._at,$,this.sOffset,"",true);S(this);return this;};
var e=function(t){if(!t.getOpener()){var i="";if(t.oPopup){if(t.oPopup._oPosition.of instanceof sap.ui.core.Element){i=t.oPopup._oPosition.of.getId();}else{if(t.oPopup._oPosition.of.length>0){i=t.oPopup._oPosition.of[0].id;}else{i=t.oPopup._oPosition.of.id;}}}if(i!==""){t.setAssociation("opener",i,true);}else{q.sap.log.error("Neither an opener was set properly nor a corresponding one can be distinguished","","sap.ui.ux3.ToolPopup");}}};var s=function(t){var i="sapUiUx3ToolPopupArrowWidth";t.sArrowWidth=a.get(i);t.iArrowWidth=parseInt(t.sArrowWidth,10);i="sapUiUx3ToolPopupArrowHeight";t.sArrowHeight=a.get(i);t.iArrowHeight=parseInt(t.sArrowHeight,10);i="sapUiUx3ToolPopupArrowRightMarginCorrection";t.sArrowPadding=a.get(i);t.iArrowPadding=parseInt(t.sArrowPadding,10);i="sapUiUx3ToolPopupArrowRightMarginCorrectionInverted";t.sArrowPaddingInverted=a.get(i);t.iArrowPaddingInverted=parseInt(t.sArrowPaddingInverted,10);};var g=function(t){var D="Left";var m=t._my;var i=t._at;if(!m&&t.oPopup){m=t.oPopup._oPosition.my;}if(!i&&t.oPopup){i=t.oPopup._oPosition.at;}t._bHorizontalArrow=false;if(m&&i){var M=m.split(" ");var A=i.split(" ");var k="my:"+M[0]+"|"+M[1];k+=" at:"+A[0]+"|"+A[1];if(b.ARROW_LEFT.exec(k)){t._bHorizontalArrow=true;D="Left";}else if(b.ARROW_RIGHT.exec(k)){t._bHorizontalArrow=true;D="Right";}else if(b.ARROW_UP.exec(k)){D="Up";}else if(b.ARROW_DOWN.exec(k)){D="Down";}if(t.getDomRef()&&t.isOpen()){var $=t.$();var n=$.rect();var v=q.sap.byId(t.getOpener());var w=v.rect();if(w){if(t._bHorizontalArrow){var x=n.left+$.outerWidth(true)+t.iArrowWidth;var y=w.left+v.outerWidth(true);if(x<=y){D="Right";}else{D="Left";}}else{var z=n.top+$.outerHeight(true)+t.iArrowWidth;var B=w.top+v.outerHeight(true);if(z<=B){D="Down";}else{D="Up";}}}}}return D;};var S=function(t){var k="",v=0,z=0,H=t.iArrowHeight/2,i=sap.ui.getCore().getConfiguration().getRTL(),A,m=t.$().rect(),n=q.sap.byId(t.getOpener()),w=n.rect(),x=0,$=t.$("arrow");if(!t.getDomRef()){return;}t._sArrowDir=g(t);A=t._sArrowDir;if(i){if(t._sArrowDir==="Right"){A="Left";}else if(t._sArrowDir==="Left"){A="Right";}}if(!w){q.sap.log.warning("Opener wasn't set properly. Therefore arrow will be at a default position","","sap.ui.ux3.ToolPopup");}if(!t._my&&t.oPopup){t._my=t.oPopup._oPosition.my;}if(t._bHorizontalArrow){k="top";if(w){x=parseInt(t.$().css('border-top-width'),10)||0;z=parseInt(w.top-x-m.top,10);v=Math.round(z+w.height/2-H);v=v+H>m.height?v-t.iArrowHeight:v;}}else{k="left";if(w){if(i){k="right";x=parseInt(t.$().css('border-right-width'),10)||0;z=parseInt(m.left+m.width-w.left-w.width-x,10);}else{x=parseInt(t.$().css('border-left-width'),10)||0;z=parseInt(w.left-m.left-x,10);}v=Math.round(z+w.width/2-H);v=v+H>m.width?v-t.iArrowHeight:v;}}if(!w){v=t.iArrowHeight;}var y="";if($.hasClass("sapUiUx3TPNewArrow")){y="sapUiUx3TPNewArrow sapUiUx3TPNewArrow";}else{y=t.isInverted()?"sapUiUx3TPArrow sapUiTPInverted sapUiUx3TPArrow":"sapUiUx3TPArrow sapUiUx3TPArrow";}$.attr("class",y+A);if(A==="Right"){var W=m.width;if(t.isInverted()){W+=t.iArrowPaddingInverted;}else{W+=t.iArrowPadding;}if(i){$.css("right",W+"px");}else{$.css("left",W+"px");}}else{$.css({"left":"","right":""});}v=parseInt(v,10);v=v<-x?-x:v;$.css(k,v+"px");};
b.prototype.onsapescape=function(){if(this.fireClose()){this.close();}};
var o=function(E){if(!this._bPreventRestoreFocus){P.applyFocusInfo(this._oPreviousFocus);}if(this.getDomRef()){R.preserveContent(this.getDomRef());this.$().remove();}this.fireClosed();};
b.prototype.close=function(i){if(this.oPopup&&this.oPopup.isOpen()){if(this._sResizeID){sap.ui.core.ResizeHandler.deregister(this._sResizeID);delete this._sResizeID;}this.oPopup.close(this.getCloseDuration());this._bPreventRestoreFocus=i;}return this;};
b.prototype.getEnabled=function(){var i=this.oPopup?this.oPopup.getOpenState():sap.ui.core.OpenState.CLOSED;return i===sap.ui.core.OpenState.OPENING||i===sap.ui.core.OpenState.OPEN;};
b.prototype.onsapenter=function(E){var i=this.getDefaultButton();var F=sap.ui.getCore().byId(i);if(i&&F&&q.contains(this.getDomRef(),F.getDomRef())){if(F instanceof sap.ui.commons.Button){var $=F.$();$.click();$.focus();}}E.preventDefault();E.stopPropagation();};
b.prototype.onBeforeRendering=function(){var i=this.getInitialFocus()||this._sInitialFocusId;var D=this.getDefaultButton();this._bFocusSet=true;if(i){this.oPopup.setInitialFocusId(i);}else if(D){this.oPopup.setInitialFocusId(D);}else{this._bFocusSet=false;}this._bRTL=sap.ui.getCore().getConfiguration().getRTL();};
b.prototype._ensurePopup=function(){if(!this.oPopup){this.oPopup=new P(this,false,true,false);this.oPopup.attachOpened(this._proxyOpened);this.oPopup.attachClosed(this._proxyClosed);var t=this;this.oPopup._applyPosition=function(){P.prototype._applyPosition.apply(t.oPopup,arguments);var i=t.oPopup._oLastPosition.of;if(!i){t.oPopup.close();}else{var $=q.sap.byId(i.id);if(t._bPositionSet){if(!$.hasClass("sapUiUx3ShellTool")){t._my=t.oPopup._oLastPosition.my;t._at=t.oPopup._oLastPosition.at;}}S(t);}};}return this.oPopup;};
var O=function(){if(this.getContent().length){this._proxyFixSize();this.oPopup._applyPosition(this.oPopup._oLastPosition);}};
b.prototype.setPosition=function(){this._ensurePopup();this.oPopup.setPosition.apply(this.oPopup,arguments);this._bPositionSet=true;e(this);return this;};
var h=function(i,t){var k=i;if(t==="content"){r(k);}else if(t==="buttons"){j(k);}k._proxyFixSize();k.oPopup._applyPosition(k.oPopup._oLastPosition);};var r=function(t){var k=t.getDomRef("content");k.innerHTML="";var m=t.getContent();var n=sap.ui.getCore().createRenderManager();for(var i=0;i<m.length;i++){n.renderControl(m[i]);}n.flush(k,true);n.destroy();};var j=function(t){var B=t.getDomRef("buttons");var k=t.getDomRef("buttons-separator");var m=t.getButtons();if(m.length===0){q(B).addClass("sapUiUx3TPButtonRowHidden");q(k).addClass("sapUiUx3TPButtonRowHidden");}else{q(B).removeClass("sapUiUx3TPButtonRowHidden");q(k).removeClass("sapUiUx3TPButtonRowHidden");B.innerHTML="";var n=sap.ui.getCore().createRenderManager();for(var i=0;i<m.length;i++){n.renderControl(m[i]);}n.flush(B,true);n.destroy();}};
b.prototype.addContent=function(i){this.addAggregation("content",i,true);if(this.isOpen()){h(this,"content");}return this;};
b.prototype.insertContent=function(i,k){this.insertAggregation("content",i,k,true);if(this.isOpen()){h(this,"content");}return this;};
b.prototype.removeContent=function(i){this.removeAggregation("content",i,true);if(this.isOpen()){h(this,"content");}return this;};
b.prototype.addButton=function(B){this.addAggregation("buttons",B,true);if(this.isOpen()){h(this,"buttons");}return this;};
b.prototype.insertButton=function(B,i){this.insertAggregation("buttons",B,i,true);if(this.isOpen()){h(this,"buttons");}return this;};
b.prototype.removeButton=function(B){this.removeAggregation("button",B,true);if(this.isOpen()){h(this,"buttons");}return this;};
var u=function(t){var i="sapUiUx3ToolPopupInverted";i=a.get(i);t._bThemeInverted=i==="true";};
b.prototype.onThemeChanged=function(){u(this);};
b.prototype.isInverted=function(){u(this);return this.getInverted()&&this._bThemeInverted;};
b.prototype.setAutoCloseAreas=function(A){this._ensurePopup();return this.oPopup.setAutoCloseAreas(A);};
b.prototype.addFocusableArea=function(i){this._ensurePopup();if(typeof(i)==="string"){this.oPopup._addFocusableArea("channelId","eventId",{id:i});return this;}else{q.sap.log.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup");}};
b.prototype.removeFocusableArea=function(i){this._ensurePopup();if(typeof(i)==="string"){this.oPopup._removeFocusableArea("channelId","eventId",{id:i});return this;}else{q.sap.log.error("Wrong type of focusable area ID - string expected","","sap.ui.ux3.ToolPopup");}};
}());
b.prototype.setIcon=function(i){this.setProperty("icon",i,true);this.fireIconChanged();return this;};
b.prototype.setIconHover=function(i){this.setProperty("iconHover",i,true);this.fireIconChanged();return this;};
b.prototype.setIconSelected=function(i){this.setProperty("iconSelected",i,true);this.fireIconChanged();return this;};
b.prototype.getIconSelected=function(){return this.getProperty("iconSelected")||this.getProperty("iconHover");};
b.prototype.setMaxWidth=function(m){var p=/[0-9]+px/;if(p.test(m)){this.setProperty("maxWidth",m);}else{q.sap.log.error("Only values in pixels are possible","","sap.ui.ux3.ToolPopup");}};
return b;},true);
sap.ui.predefine('sap/ui/ux3/ToolPopupRenderer',['jquery.sap.global'],function(q){"use strict";var T={};
T.render=function(r,c){var a=sap.ui.getCore().getLibraryResourceBundle("sap.ui.ux3");var I=c.getId();var C=c.getContent();var b=c.getButtons();var t=c.getTitle();var s=sap.ui.resource('sap.ui.core','themes/base/img/1x1.gif');r.write("<div");r.writeControlData(c);r.addClass("sapUiUx3TP");if(t===""){r.addClass("sapUiUx3TPNoTitle");}if(b.length===0){r.addClass("sapUiUx3TPNoButtons");}if(c.isInverted()){r.addClass("sapUiTPInverted");r.addClass("sapUiInverted-CTX");}r.writeClasses();r.write(" aria-labelledby='",I,"-title ",I,"-acc' role='dialog'");r.writeAttribute("tabindex","-1");r.write(">");r.write("<div id='"+I+"-arrow' class='sapUiUx3TPArrow sapUiUx3TPArrowLeft'><div class='sapUiUx3TPArrowBorder'></div></div>");r.write("<span style='display:none;' id='",I,"-acc'>");r.writeEscaped(a.getText("DIALOG_CLOSE_HELP"));r.write("</span>");r.write('<span id="'+I+'-firstFocusable'+'" tabindex="0" class="sapUiUxTPFocus">');r.write('<img src="'+s+'">');r.write('</span>');if(t&&(t.length!=="")){r.write('<div class="sapUiUx3TPTitle" id="'+I+'-title">');r.write('<span class="sapUiUx3TPTitleText">');r.writeEscaped(t);r.write('</span>');r.write('</div>');r.write('<div class="sapUiUx3TPTitleSep" id="'+I+'-title-separator"></div>');}else{var d=c.getTooltip_AsString();if(d){r.write("<h1 id='"+I+"-title' style='display:none;'>");r.writeEscaped(d);r.write("</h1>");}}r.write('<div id="'+I+'-content"');r.addClass("sapUiUx3TPContent");r.writeClasses();r.write(">");for(var i=0;i<C.length;i++){r.renderControl(C[i]);}r.write('</div>');if(b.length>0){r.write('<div class="sapUiUx3TPButtonsSep" id="'+I+'-buttons-separator"></div>');r.write('<div class="sapUiUx3TPBtnRow" id="'+I+'-buttons">');for(var i=0;i<b.length;i++){r.renderControl(b[i].addStyleClass("sapUiUx3TPBtn"));}}else{r.write('<div class="sapUiUx3TPButtonsSep sapUiUx3TPButtonRowHidden" id="'+I+'-buttons-separator"></div>');r.write('<div class="sapUiUx3TPBtnRow sapUiUx3TPButtonRowHidden" id="'+I+'-buttons">');}r.write("</div>");r.write('<span id="'+I+'-lastFocusable'+'" tabindex="0" class="sapUiUxTPFocus">');r.write('<img src="'+s+'">');r.write('</span>');r.write("</div>");};
return T;},true);
sap.ui.predefine('sap/ui/ux3/library',['jquery.sap.global','sap/ui/core/library','sap/ui/commons/library'],function(q){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.ux3",version:"1.54.7",dependencies:["sap.ui.core","sap.ui.commons"],types:["sap.ui.ux3.ActionBarSocialActions","sap.ui.ux3.ExactOrder","sap.ui.ux3.FeederType","sap.ui.ux3.FollowActionState","sap.ui.ux3.NotificationBarStatus","sap.ui.ux3.ShellDesignType","sap.ui.ux3.ShellHeaderType","sap.ui.ux3.ThingViewerHeaderType","sap.ui.ux3.VisibleItemCountMode"],interfaces:["sap.ui.ux3.DataSetView"],controls:["sap.ui.ux3.ActionBar","sap.ui.ux3.CollectionInspector","sap.ui.ux3.DataSet","sap.ui.ux3.DataSetSimpleView","sap.ui.ux3.Exact","sap.ui.ux3.ExactArea","sap.ui.ux3.ExactBrowser","sap.ui.ux3.ExactList","sap.ui.ux3.FacetFilter","sap.ui.ux3.FacetFilterList","sap.ui.ux3.Feed","sap.ui.ux3.FeedChunk","sap.ui.ux3.Feeder","sap.ui.ux3.NavigationBar","sap.ui.ux3.NotificationBar","sap.ui.ux3.Overlay","sap.ui.ux3.OverlayContainer","sap.ui.ux3.OverlayDialog","sap.ui.ux3.QuickView","sap.ui.ux3.Shell","sap.ui.ux3.ThingInspector","sap.ui.ux3.ThingViewer","sap.ui.ux3.ToolPopup"],elements:["sap.ui.ux3.Collection","sap.ui.ux3.DataSetItem","sap.ui.ux3.ExactAttribute","sap.ui.ux3.NavigationItem","sap.ui.ux3.Notifier","sap.ui.ux3.ThingAction","sap.ui.ux3.ThingGroup"]});sap.ui.ux3.ActionBarSocialActions={Update:"Update",Follow:"Follow",Flag:"Flag",Favorite:"Favorite",Open:"Open"};sap.ui.ux3.ExactOrder={Select:"Select",Fixed:"Fixed"};sap.ui.ux3.FeederType={Large:"Large",Medium:"Medium",Comment:"Comment"};sap.ui.ux3.FollowActionState={Follow:"Follow",Hold:"Hold",Default:"Default"};sap.ui.ux3.NotificationBarStatus={Default:"Default",Min:"Min",Max:"Max",None:"None"};sap.ui.ux3.ShellDesignType={Standard:"Standard",Light:"Light",Crystal:"Crystal"};sap.ui.ux3.ShellHeaderType={Standard:"Standard",BrandOnly:"BrandOnly",NoNavigation:"NoNavigation",SlimNavigation:"SlimNavigation"};sap.ui.ux3.ThingViewerHeaderType={Standard:"Standard",Horizontal:"Horizontal"};sap.ui.ux3.VisibleItemCountMode={Fixed:"Fixed",Auto:"Auto"};return sap.ui.ux3;});
jQuery.sap.registerPreloadedModules({
"name":"sap/ui/ux3/library-preload",
"version":"2.0",
"modules":{
	"sap/ui/ux3/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.ux3","type":"library","embeds":[],"applicationVersion":{"version":"1.54.7"},"title":"Controls that implement the SAP User Experience (UX) Guidelines 3.0","description":"Controls that implement the SAP User Experience (UX) Guidelines 3.0","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.54","libs":{"sap.ui.core":{"minVersion":"1.54.7"},"sap.ui.commons":{"minVersion":"1.54.7"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.ux3.ActionBar","sap.ui.ux3.CollectionInspector","sap.ui.ux3.DataSet","sap.ui.ux3.DataSetSimpleView","sap.ui.ux3.Exact","sap.ui.ux3.ExactArea","sap.ui.ux3.ExactBrowser","sap.ui.ux3.ExactList","sap.ui.ux3.FacetFilter","sap.ui.ux3.FacetFilterList","sap.ui.ux3.Feed","sap.ui.ux3.FeedChunk","sap.ui.ux3.Feeder","sap.ui.ux3.NavigationBar","sap.ui.ux3.NotificationBar","sap.ui.ux3.Overlay","sap.ui.ux3.OverlayContainer","sap.ui.ux3.OverlayDialog","sap.ui.ux3.QuickView","sap.ui.ux3.Shell","sap.ui.ux3.ThingInspector","sap.ui.ux3.ThingViewer","sap.ui.ux3.ToolPopup"],"elements":["sap.ui.ux3.Collection","sap.ui.ux3.DataSetItem","sap.ui.ux3.ExactAttribute","sap.ui.ux3.NavigationItem","sap.ui.ux3.Notifier","sap.ui.ux3.ThingAction","sap.ui.ux3.ThingGroup"],"types":["sap.ui.ux3.ActionBarSocialActions","sap.ui.ux3.ExactOrder","sap.ui.ux3.FeederType","sap.ui.ux3.FollowActionState","sap.ui.ux3.NotificationBarStatus","sap.ui.ux3.ShellDesignType","sap.ui.ux3.ShellHeaderType","sap.ui.ux3.ThingViewerHeaderType","sap.ui.ux3.VisibleItemCountMode"],"interfaces":["sap.ui.ux3.DataSetView"]}}}}'
}});
//# sourceMappingURL=library-preload.js.map