/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/m/Button","sap/m/library","sap/m/Popover","sap/m/Toolbar","sap/ui/core/IconPool","sap/ui/core/Item","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/layout/HorizontalLayout","sap/ui/Device","sap/ui/core/CustomData","./HierarchicalSelect","./library","sap/uxap/AnchorBarRenderer","jquery.sap.keycodes"],function(q,B,m,P,T,I,a,R,S,H,D,C,b,l,A){"use strict";var c=m.SelectType;var d=m.PlacementType;var e=T.extend("sap.uxap.AnchorBar",{metadata:{library:"sap.uxap",properties:{showPopover:{type:"boolean",defaultValue:true},upperCase:{type:"boolean",defaultValue:false}},associations:{selectedButton:{type:"sap.m.Button",multiple:false}},aggregations:{_select:{type:"sap.uxap.HierarchicalSelect",multiple:false,visibility:"hidden"},_popovers:{type:"sap.m.Popover",multiple:true,visibility:"hidden"},_scrollArrowLeft:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},_scrollArrowRight:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});e.prototype.init=function(){if(T.prototype.init){T.prototype.init.call(this);}this.addStyleClass("sapUxAPAnchorBar");this._oPressHandlers={};this._oSectionInfo={};this._oScroller=null;this._sSelectedKey=null;this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._bRtlScenario=this._bRtl&&!D.browser.msie;this._bHasButtonsBar=D.system.tablet||D.system.desktop;this._oSelect=this._getHierarchicalSelect();if(this._bHasButtonsBar){this._oScroller=new S(this,this.getId()+"-scroll",{horizontal:true,vertical:false,nonTouchScrolling:true});this._iREMSize=parseInt(q("body").css("font-size"),10);this._iTolerance=this._iREMSize*1;this._iOffset=this._iREMSize*3;this._sResizeListenerId=undefined;}this.oLibraryResourceBundleOP=l.i18nModel.getResourceBundle();this.setDesign("Transparent");};e.SCROLL_STEP=250;e.SCROLL_DURATION=500;e.DOM_CALC_DELAY=200;e.prototype.setSelectedButton=function(o){var p=this.getSelectedButton(),f,s=this._oSelect.getItems(),h=s.length>0;if(typeof o==="string"){o=sap.ui.getCore().byId(o);}if(o){if(o.getId()===p){return this;}var g=o.data("sectionId");this._sSelectedKey=g;if(g&&h){this._oSelect.setSelectedKey(g);}if(this._bHasButtonsBar){f=sap.ui.getCore().byId(p);this._toggleSelectionStyleClass(f,false);this._toggleSelectionStyleClass(o,true);if(g){this.scrollToSection(g,e.SCROLL_DURATION);}this._setAnchorButtonsTabFocusValues(o);}}return this.setAssociation("selectedButton",o,true);};e.prototype.setShowPopover=function(v,s){if(this.getShowPopover()===v){return this;}var f,n=!q.isEmptyObject(this._oPressHandlers);if(n){var g=this.getContent()||[];f=this.getSelectedButton();g.forEach(this._detachPopoverHandler,this);}this.setProperty("showPopover",v,true);if(n){this.rerender();if(f){this.setSelectedButton(f);}}return this;};e.prototype.getSelectedSection=function(){var s=this.getSelectedButton();if(s&&(typeof(s)==="string")){s=sap.ui.getCore().byId(s);}if(s&&(s instanceof B)&&s.data("sectionId")){return sap.ui.getCore().byId(s.data("sectionId"));}return null;};e.prototype.onBeforeRendering=function(){if(T.prototype.onBeforeRendering){T.prototype.onBeforeRendering.call(this);}var f=this.getContent()||[],u=this.getUpperCase(),p={oLastFirstLevelButton:null,oCurrentPopover:null};this._oSelect.removeAllItems();this._oSelect.setUpperCase(u);this.toggleStyleClass("sapUxAPAnchorBarUpperCase",u);f.forEach(function(o){this._createSelectItem(o);if(this._bHasButtonsBar){this._createPopoverSubMenu(o,p);}},this);if(f.length>0&&this._sSelectedKey){this._oSelect.setSelectedKey(this._sSelectedKey);}};e.prototype.addContent=function(o,i){o.addStyleClass("sapUxAPAnchorBarButton");o.removeAllAriaDescribedBy();if(this._bHasButtonsBar&&(o.data("secondLevel")===true||o.data("secondLevel")==="true")){o.attachPress(this._handleDirectScroll,this);}return this.addAggregation("content",o,i);};e.prototype._createSelectItem=function(o){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true";if(o.getText().trim()!=""&&(!i||o.data("bTitleVisible")===true)){var p=new a({key:o.data("sectionId"),text:o.getText(),customData:[new C({key:"secondLevel",value:o.data("secondLevel")})]});this._oSelect.addItem(p);}};e.prototype._createPopoverSubMenu=function(o,p){var i=o.data("secondLevel")===true||o.data("secondLevel")==="true",f=null;if(i){if(p.oLastFirstLevelButton&&p.oCurrentPopover){if(!this._oPressHandlers[p.oLastFirstLevelButton.getId()]){f=q.proxy(this._handlePopover,{oCurrentPopover:p.oCurrentPopover,oLastFirstLevelButton:p.oLastFirstLevelButton});p.oLastFirstLevelButton.attachPress(f);this._oPressHandlers[p.oLastFirstLevelButton.getId()]=f;}p.oCurrentPopover.addContent(o);}else if(this.getShowPopover()){q.sap.log.error("sapUxApAnchorBar :: missing parent first level for item "+o.getText());}else{this.removeContent(o);o.destroy();}}else{p.oLastFirstLevelButton=o;if(this.getShowPopover()){p.oCurrentPopover=new P({placement:d.Bottom,showHeader:false,verticalScrolling:true,horizontalScrolling:false,contentWidth:"auto",showArrow:false,afterOpen:this._decorateSubMenuButtons});p.oCurrentPopover.addStyleClass("sapUxAPAnchorBarPopover");this._addKeyboardHandling(p.oCurrentPopover);this.addAggregation('_popovers',p.oCurrentPopover);}else if(!this._oPressHandlers[p.oLastFirstLevelButton.getId()]){f=q.proxy(this._handleDirectScroll,this);p.oLastFirstLevelButton.attachPress(f);this._oPressHandlers[p.oLastFirstLevelButton.getId()]=f;}}};e.prototype._decorateSubMenuButtons=function(E){var f=E.getSource().getContent();f.forEach(function(o){o.$().attr("aria-controls",o.data("sectionId"));});};e.prototype._toggleSelectionStyleClass=function(o,f){if(o){o.toggleStyleClass("sapUxAPAnchorBarButtonSelected",f);o.$().attr("aria-checked",f);}};e.prototype._addKeyboardHandling=function(o){o.onsapdown=function(E){if(E.target.nextSibling){E.target.nextSibling.focus();}};o.onsapright=function(E){o.onsapdown(E);};o.onsapup=function(E){if(E.target.previousSibling){E.target.previousSibling.focus();}};o.onsapleft=function(E){o.onsapup(E);};o.onsaphome=function(E){if(E.target.parentElement.firstChild){E.target.parentElement.firstChild.focus();}};o.onsapend=function(E){if(E.target.parentElement.lastChild){E.target.parentElement.lastChild.focus();}};o.onsappageup=this._handlePageUp.bind(o);o.onsappagedown=this._handlePageDown.bind(o);};e.prototype._detachPopoverHandler=function(o){if(this._oPressHandlers[o.getId()]){o.detachPress(this._oPressHandlers[o.getId()]);this._oPressHandlers[o.getId()]=null;}};e.prototype._handlePopover=function(E){var p=this.oCurrentPopover.getContent()||[];if(this.oLastFirstLevelButton.$().is(":visible")){if(p.length==1){p[0].firePress({});}else{this.oCurrentPopover.openBy(this.oLastFirstLevelButton);}}};e.prototype._handleDirectScroll=function(E){if(E.getSource().getParent()instanceof P){E.getSource().getParent().close();}this._requestScrollToSection(E.getSource().data("sectionId"));};e.prototype._requestScrollToSection=function(r){var o=sap.ui.getCore().byId(r),f=o.getParent();if(this.getParent()instanceof l.ObjectPageLayout){var n=r;if(o instanceof l.ObjectPageSubSection&&f instanceof l.ObjectPageSection){n=f.getId();}this.getParent().setDirectScrollingToSection(n);this.getParent().scrollToSection(o.getId(),null,0,true);}if(o instanceof l.ObjectPageSubSection&&f instanceof l.ObjectPageSection){f.setAssociation("selectedSubSection",o,true);}};e.prototype._onSelectChange=function(E){var s=E.getParameter("selectedItem"),o;o=sap.ui.getCore().byId(s.getKey());if(o){this._requestScrollToSection(o.getId());}else{q.sap.log.error("AnchorBar :: cannot find corresponding section",s.getKey());}};e.prototype._getHierarchicalSelect=function(){if(!this.getAggregation('_select')){this.setAggregation('_select',new b({width:"100%",icon:"sap-icon://slim-arrow-down",change:q.proxy(this._onSelectChange,this)}));}return this.getAggregation('_select');};e.prototype._createScrollArrow=function(L){var s,i,f,g,o,t=this,h=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_LEFT_ARROW"),j=this.oLibraryResourceBundleOP.getText("TOOLTIP_OP_SCROLL_RIGHT_ARROW");if(L){s=this.getId()+"-arrowScrollLeft";i="slim-arrow-left";f="anchorBarArrowLeft";g=this._bRtl?j:h;}else{s=this.getId()+"-arrowScrollRight";i="slim-arrow-right";f="anchorBarArrowRight";g=this._bRtl?h:j;}o=new B(s,{icon:I.getIconURI(i),type:"Transparent",press:function(E){E.preventDefault();t._handleScrollButtonTap(L);},tooltip:g});o.addEventDelegate({onAfterRendering:function(){if(sap.ui.getCore().getConfiguration().getTheme()!="sap_hcb"){this.$().attr("tabindex",-1);}},onThemeChanged:function(){if(sap.ui.getCore().getConfiguration().getTheme()=="sap_hcb"){this.$().removeAttr("tabindex");}else{this.$().attr("tabindex",-1);}}},o);return new H({content:[o]}).addStyleClass("anchorBarArrow").addStyleClass(f);};e.prototype._getScrollArrowLeft=function(){var s=this.getAggregation("_scrollArrowLeft");if(s){return s;}else{s=this._createScrollArrow(true);this.setAggregation("_scrollArrowLeft",s);return s;}};e.prototype._getScrollArrowRight=function(){var s=this.getAggregation("_scrollArrowRight");if(s){return s;}else{s=this._createScrollArrow(false);this.setAggregation("_scrollArrowRight",s);return s;}};e.prototype._applyHierarchicalSelectMode=function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this.$().find(".sapUxAPAnchorBarScrollContainer").show();this._oSelect.setWidth("auto");this._oSelect.setAutoAdjustWidth(true);this._oSelect.setType(c.IconOnly);this._computeBarSectionsInfo();}else{this.$().find(".sapUxAPAnchorBarScrollContainer").hide();this._oSelect.setWidth("100%");this._oSelect.setAutoAdjustWidth(false);this._oSelect.setType(c.Default);}this.$().toggleClass("sapUxAPAnchorBarOverflow",this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon);};e.prototype._adjustSize=function(){var n=l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())?A._AnchorBarHierarchicalSelectMode.Text:A._AnchorBarHierarchicalSelectMode.Icon;if(n!==this._sHierarchicalSelectMode){this._sHierarchicalSelectMode=n;this._applyHierarchicalSelectMode();}if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){if(this._iMaxPosition<0){return;}var $=this.$(),f=$.find(".sapUxAPAnchorBarScrollContainer"),N,g,i;i=f.width();if(this._bRtlScenario){if(D.browser.firefox){g=Math.abs(f.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);N=Math.abs(f.scrollLeft())>=this._iTolerance;}else{g=Math.abs(f.scrollLeft())>=this._iTolerance;N=Math.abs(f.scrollLeft())+i<(this._iMaxPosition-this._iTolerance);}}else{g=f.scrollLeft()+i<(this._iMaxPosition-this._iTolerance);N=f.scrollLeft()>=this._iTolerance;}q.sap.log.debug("AnchorBar :: scrolled at "+f.scrollLeft(),"scrollBegin ["+(N?"true":"false")+"] scrollEnd ["+(g?"true":"false")+"]");$.toggleClass("sapUxAPAnchorBarScrollLeft",N);$.toggleClass("sapUxAPAnchorBarScrollRight",g);}};e.prototype._handleScrollButtonTap=function(s){var i=((!this._bRtlScenario&&s)||(this._bRtlScenario&&!s))?-1:1;this._oScroller.scrollTo(this._iMaxPosition*i,0,e.SCROLL_DURATION*3);};e.prototype.scrollToSection=function(i,f){if(this._bHasButtonsBar){var f=f||e.SCROLL_DURATION,s;if(!l.Utilities.isPhoneScenario(this._getCurrentMediaContainerRange())&&this._oSectionInfo[i]){if(this._bRtlScenario&&D.browser.firefox){s=this._oSectionInfo[i].scrollLeft+this._iOffset;}else{s=this._oSectionInfo[i].scrollLeft-this._iOffset;if(s<0){s=0;}}q.sap.log.debug("AnchorBar :: scrolling to section "+i+" of "+s);if(this._sCurrentScrollId!=i){this._sCurrentScrollId=i;if(this._iCurrentScrollTimeout){q.sap.clearDelayedCall(this._iCurrentScrollTimeout);q.sap.byId(this.getId()+"-scroll").parent().stop(true,false);}this._iCurrentScrollTimeout=q.sap.delayedCall(f,this,function(){this._sCurrentScrollId=undefined;this._iCurrentScrollTimeout=undefined;});this._oScroller.scrollTo(s,0,f);}}else{q.sap.log.debug("AnchorBar :: no need to scroll to "+i);}}};e.prototype.getScrollDelegate=function(){return this._oScroller;};e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE=5;e.prototype.onsapdown=function(E){E.preventDefault();if(E.target.nextSibling){E.target.nextSibling.focus();}};e.prototype.onsapright=function(E){var M=this._bRtl?"onsapup":"onsapdown";this[M](E);};e.prototype.onsapup=function(E){E.preventDefault();if(E.target.previousSibling){E.target.previousSibling.focus();}};e.prototype.onsapleft=function(E){var M=this._bRtl?"onsapdown":"onsapup";this[M](E);};e.prototype.onsaphome=function(E){E.preventDefault();if(E.target.parentElement.firstChild){E.target.parentElement.firstChild.focus();}};e.prototype.onsapend=function(E){E.preventDefault();if(E.target.parentElement.lastChild){E.target.parentElement.lastChild.focus();}};e.prototype.onsappageup=function(E){this._handlePageUp(E);};e.prototype.onsappagedown=function(E){this._handlePageDown(E);};e.prototype._handlePageUp=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(o.getId()===E.target.id){n=i-(e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1);return;}});if(n&&f[n]){f[n].focus();}else if(f[0]){f[0].focus();}};e.prototype._handlePageDown=function(E){E.preventDefault();var n;var f=this.getContent();f.forEach(function(o,i){if(o.getId()===E.target.id){n=i+e.PAGEUP_AND_PAGEDOWN_JUMP_SIZE+1;return;}});if(n&&f[n]){f[n].focus();}else if(f[f.length-1]){f[f.length-1].focus();}};e.prototype._setAnchorButtonsTabFocusValues=function(s){var f=this.getContent()||[],$,F='0',n='-1',t="tabIndex";f.forEach(function(o){$=o.$();if(o.sId===s.sId){$.attr(t,F);}else{$.attr(t,n);}});};e.prototype.onsapskipforward=function(E){this._handleGroupNavigation(E,false);};e.prototype._handleGroupNavigation=function(E,s){var o=q.Event("keydown"),f={},O=this.getParent(),u=O.getUseIconTabBar(),g=O.getSelectedSection(),h=O.getSections(),i=[this.getDomRef()],j=[];if(u){j=sap.ui.getCore().byId(g).getSubSections().map(function(k){return k.$().attr("tabindex",-1)[0];});i=i.concat(j);}else{h.forEach(function(k){j=k.getSubSections().map(function(n){return n.$().attr("tabindex",-1)[0];});i=i.concat(j);});}f.scope=i;E.preventDefault();this.$().focus();o.target=E.target;o.keyCode=q.sap.KeyCodes.F6;o.shiftKey=s;q.sap.handleF6GroupNavigation(o,f);};e.prototype.onAfterRendering=function(){var s;if(T.prototype.onAfterRendering){T.prototype.onAfterRendering.call(this);}s=sap.ui.getCore().byId(this.getSelectedButton());this._iMaxPosition=-1;this._sResizeListenerId=R.register(this,q.proxy(this._adjustSize,this));this.$().find(".sapUxAPAnchorBarScrollContainer").scroll(q.proxy(this._onScroll,this));if(s){this.setSelectedButton(s);this._setAnchorButtonsTabFocusValues(s);}if(this._bHasButtonsBar){q.sap.delayedCall(e.DOM_CALC_DELAY,this,function(){if(this._sHierarchicalSelectMode===A._AnchorBarHierarchicalSelectMode.Icon){this._computeBarSectionsInfo();}this._adjustSize();});}};e.prototype._onScroll=function(){if(!this._iCurrentSizeCheckTimeout){this._iCurrentSizeCheckTimeout=q.sap.delayedCall(e.SCROLL_DURATION,this,function(){this._iCurrentSizeCheckTimeout=undefined;this._adjustSize();});}};e.prototype._computeBarSectionsInfo=function(){this._iMaxPosition=0;var f=this.getContent()||[];f.forEach(this._computeNextSectionInfo,this);if(this._bRtlScenario&&(D.browser.webkit||D.browser.firefox)){f.forEach(this._adjustNextSectionInfo,this);this._oScroller.scrollTo(this._iMaxPosition,0,0);}};e.prototype._computeNextSectionInfo=function(o){if(o.data("bHasSubMenu")){o.$().attr("aria-haspopup","true");}o.$().attr("aria-controls",o.data("sectionId")).attr("aria-checked",false);var w=o.$().outerWidth(true);this._oSectionInfo[o.data("sectionId")]={scrollLeft:this._iMaxPosition,width:w};this._iMaxPosition+=w;};e.prototype._adjustNextSectionInfo=function(o){var s=this._oSectionInfo[o.data("sectionId")];if(D.browser.firefox){s.scrollLeft=-s.scrollLeft;}else{s.scrollLeft=this._iMaxPosition-s.scrollLeft-s.width;}};e.prototype._destroyPopoverContent=function(){var p=this.getAggregation("_popovers");if(Array.isArray(p)){p.forEach(function(f){f.destroyContent();});}};e.prototype._resetControl=function(){this._destroyPopoverContent();this.getContent().forEach(this._detachPopoverHandler,this);this.destroyAggregation('content',true);return this;};e.prototype.enhanceAccessibilityState=function(E,f){var o=this.getContent(),i=o.indexOf(E);if(i!==-1){f.role="menuitemradio";f.type="button";f.setsize=o.length;f.posinset=i+1;}};e.prototype.exit=function(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this.oLibraryResourceBundleOP){this.oLibraryResourceBundleOP=null;}};return e;});
