/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
(function(__global){"use strict";(function(u){var m=/(edge)[ \/]([\w.]+)/.exec(u)||/(webkit)[ \/]([\w.]+)/||[];if(m[1]==='edge'||m[1]==='webkit'&&(/(Version|PhantomJS)\/(\d+\.\d+).*Safari/.test(u)||/iPhone|iPad|iPod/.test(u))){__global.Promise=undefined;}if(!__global.Promise){ES6Promise.polyfill();}}(navigator.userAgent.toLowerCase()));function docBase(){var h=document.baseURI,p=h.search(/[?#]/);return p<0?h:h.slice(0,p);}var resolveURL=(function(_){try{if(!/localhost/.test(new _('index.html','http://localhost:8080/'))){_=null;}}catch(e){_=null;}if(_){return function(u,B){return new _(u,B?new _(B,docBase()):docBase()).toString();};}var d=document.implementation.createHTMLDocument("Dummy doc for resolveURI");var b=d.createElement('base');b.href=docBase();d.head.appendChild(b);var a=d.createElement("A");d.body.appendChild(a);return function(u,B){b.href=docBase();if(B!=null){a.href=B;b.href=a.href;}a.href=u;return a.href;};}(__global.URL||__global.webkitURL));function noop(){}function forEach(o,c){Object.keys(o).forEach(function(k){c(k,o[k]);});}var log={debug:noop,info:noop,warning:noop,error:noop,isLoggable:noop};var assert=noop;var measure;var translate;var bGlobalAsyncMode=false;var syncCallBehavior=0;var DEFAULT_BASE_URL='resources/';var vOriginalDefine;var vOriginalRequire;var mUrlPrefixes=Object.create(null);mUrlPrefixes['']={url:DEFAULT_BASE_URL,absoluteUrl:resolveURL(DEFAULT_BASE_URL)};var mMaps=Object.create(null),mShims=Object.create(null),mDepCache=Object.create(null),bDebugSources=false,fnIgnorePreload;var mModules=Object.create(null),bForceSyncDefines=null,_execStack=[],sLogPrefix="",iAnonymousModuleCount=0,MAX_EXEC_SCRIPT_LENGTH=512*1024;function urnToUI5(n){if(!/\.js$/.test(n)){return undefined;}n=n.slice(0,-3);if(/^jquery\.sap\./.test(n)){return n;}return n.replace(/\//g,".");}function urnToIDAndType(r){var b=r.lastIndexOf('/'),d=r.lastIndexOf('.');if(d>b){return{id:r.slice(0,d),type:r.slice(d)};}return{id:r,type:''};}var rJSSubTypes=/(\.controller|\.fragment|\.view|\.designtime|\.support)?.js$/;function urnToBaseIDAndSubType(r){var m=rJSSubTypes.exec(r);if(m){return{baseID:r.slice(0,m.index),subType:m[0]};}}var rDotSegmentAnywhere=/(?:^|\/)\.+(?=\/|$)/;var rDotSegment=/^\.*$/;function normalize(r,b){var p=r.search(rDotSegmentAnywhere),s,S,i,j,l;if(p<0){return r;}if(p===0){if(b==null){throw new Error("relative name not supported ('"+r+"'");}r=b.slice(0,b.lastIndexOf('/')+1)+r;}s=r.split('/');for(i=0,j=0,l=s.length;i<l;i++){S=s[i];if(rDotSegment.test(S)){if(S==='.'||S===''){continue;}else if(S==='..'){if(j===0){throw new Error("Can't navigate to parent of root ('"+r+"')");}j--;}else{throw new Error("Illegal path segment '"+S+"' ('"+r+"')");}}else{s[j++]=S;}}s.length=j;return s.join('/');}function registerResourcePath(r,u){r=String(r||"");if(u==null){if(r){if(mUrlPrefixes[r]){delete mUrlPrefixes[r];log.info("registerResourcePath ('"+r+"') (registration removed)");}return;}u=DEFAULT_BASE_URL;log.info("registerResourcePath ('"+r+"') (default registration restored)");}u=String(u);var q=u.search(/[?#]/);if(q!==-1){u=u.slice(0,q);}if(u.slice(-1)!=='/'){u+='/';}mUrlPrefixes[r]={url:u,absoluteUrl:resolveURL(u)};}function getResourcePath(r,s){var n=r,p=r.length,P;while(p>0&&!mUrlPrefixes[n]){p=n.lastIndexOf('/');n=p>0?n.slice(0,p):'';}assert((p>0||n==='')&&mUrlPrefixes[n],"there always must be a mapping");P=mUrlPrefixes[n].url+r.slice(p+1);if(P.slice(-1)==='/'){P=P.slice(0,-1);}return P+(s||'');}function guessResourceName(u){var n,U,r;u=resolveURL(u);for(n in mUrlPrefixes){U=mUrlPrefixes[n].absoluteUrl.slice(0,-1);if(u.indexOf(U)===0){r=n+u.slice(U.length);if(r.charAt(0)==='/'){r=r.slice(1);}if(mModules[r]&&mModules[r].data){return r;}}}}function findMapForContext(c){var p,m;if(c!=null){c=urnToIDAndType(c).id;p=c.length;m=mMaps[c];while(p>0&&m==null){p=c.lastIndexOf('/');if(p>0){c=c.slice(0,p);m=mMaps[c];}}}return m||mMaps['*'];}function getMappedName(r,R){var m=findMapForContext(R),P,p;r=normalize(r,R);if(m!=null){P=urnToIDAndType(r).id;p=P.length;while(p>0&&m[P]==null){p=P.lastIndexOf('/');P=p>0?P.slice(0,p):'';}if(p>0){if(log.isLoggable()){log.debug('module ID '+r+" mapped to "+m[P]+r.slice(p));}return m[P]+r.slice(p);}}return r;}function getGlobalObject(o,n,l,c){for(var i=0;o&&i<l;i++){if(!o[n[i]]&&c){o[n[i]]={};}o=o[n[i]];}return o;}function getGlobalProperty(n){var N=n?n.split("."):[];if(syncCallBehavior&&N.length>1){log.error("[nosync] getGlobalProperty called to retrieve global name '"+n+"'");}return getGlobalObject(__global,N,N.length);}function setGlobalProperty(n,v){var N=n?n.split("."):[],o;if(N.length>0){o=getGlobalObject(__global,N,N.length-1,true);o[N[N.length-1]]=v;}}var INITIAL=0,PRELOADED=-1,LOADING=1,LOADED=2,EXECUTING=3,READY=4,FAILED=5,NOT_YET_DETERMINED={};function Module(n){this.name=n;this.state=INITIAL;this.url=this._deferred=this.data=this.group=this.error=this.pending=null;this.content=NOT_YET_DETERMINED;}Module.prototype.deferred=function(){if(this._deferred==null){var d=this._deferred={};d.promise=new Promise(function(r,a){d.resolve=r;d.reject=a;});d.promise.catch(noop);}return this._deferred;};Module.prototype.api=function(){if(this._api==null){this._exports={};this._api={id:this.name.slice(0,-3),exports:this._exports,url:this.url,config:noop};}return this._api;};Module.prototype.ready=function(v){this.state=READY;if(arguments.length>0){this.content=v;}this.deferred().resolve(this.value());if(this.aliases){v=this.value();this.aliases.forEach(function(a){Module.get(a).ready(v);});}};Module.prototype.fail=function(e){if(this.state!==FAILED){this.state=FAILED;this.error=e;this.deferred().reject(e);if(this.aliases){this.aliases.forEach(function(a){Module.get(a).fail(e);});}}};Module.prototype.addAlias=function(a){(this.aliases||(this.aliases=[])).push(a);};Module.prototype.preload=function(u,d,b){if(this.state===INITIAL&&!(fnIgnorePreload&&fnIgnorePreload(this.name))){this.state=PRELOADED;this.url=u;this.data=d;this.group=b;}return this;};Module.prototype.value=function(){if(this.state===READY){if(this.content===NOT_YET_DETERMINED){var s=mShims[this.name],e=s&&(Array.isArray(s.exports)?s.exports[0]:s.exports);this.content=getGlobalProperty(e||urnToUI5(this.name));}return this.content;}return undefined;};Module.prototype.dependsOn=function(d){var v=Object.create(null);function a(m){if(!v[m.name]){v[m.name]=true;if(Array.isArray(m.pending)){if(m.pending.indexOf(d.name)>=0){return true;}for(var i=0;i<m.pending.length;i++){if(mModules[m.pending[i]]&&a(mModules[m.pending[i]])){return true;}}}}return false;}return this.name===d.name||a(this);};Module.get=function(m){return mModules[m]||(mModules[m]=new Module(m));};function ensureStacktrace(e){if(!e.stack){try{throw e;}catch(a){return a;}}return e;}function makeNestedError(m,c){var e=new Error(m+": "+c.message);e.cause=c;e.loadError=c.loadError;ensureStacktrace(e);ensureStacktrace(c);if(e.stack&&c.stack){try{e.stack=e.stack+"\nCaused by: "+c.stack;}catch(a){}}return e;}function declareModule(m){var M;assert(/\.js$/.test(m),"must be a Javascript module");M=Module.get(m);if(M.state>INITIAL){return M;}if(log.isLoggable()){log.debug(sLogPrefix+"declare module '"+m+"'");}M.state=READY;return M;}var queue=new function ModuleDefinitionQueue(){var q=[],r=0,t;this.push=function(n,d,f,_){log.debug("pushing define from "+(document.currentScript&&document.currentScript.src));q.push({name:n,deps:d,factory:f,_export:_,guess:document.currentScript&&document.currentScript.getAttribute('data-sap-ui-module')});if(!t){t=setTimeout(this.process.bind(this,null));}};this.clear=function(){q=[];if(t){clearTimeout(t);t=null;}};this.process=function(m){var M,e;if(m&&m.execError){if(log.isLoggable()){log.debug("module execution error detected, ignoring queued define calls");}m.fail(m.execError);this.clear();return;}if(q.length===0){log.debug("define queue empty");if(m){m.data=undefined;m.ready();}return;}r++;log.debug("processing define queue "+r);M=m&&m.name;while(q.length>0){e=q.shift();if(e.name==null){if(M!=null){e.name=M;M=null;}else{throw new Error("module id missing in define call: "+e.guess);}}else if(M&&e.name!==M){if(log.isLoggable()){log.debug("module names don't match: requested: "+M+", defined: "+e.name);}Module.get(e.name).addAlias(M);}defineModule(e.name,e.deps,e.factory,e._export,true);log.debug("define called for "+e.name);}if(t){clearTimeout(t);t=null;}log.debug("processing define queue done "+r);};}();function loadSyncXHR(m){var x=new XMLHttpRequest();function a(b){b=b||ensureStacktrace(new Error(x.status+" - "+x.statusText));b.status=x.status;b.statusText=x.statusText;b.loadError=true;return b;}x.addEventListener('load',function(e){if(x.status===200||x.status===0){m.state=LOADED;m.data=x.responseText;}else{m.error=a();}});x.addEventListener('error',function(e){m.error=a();});x.open('GET',m.url,false);try{x.send();}catch(b){m.error=a(b);}}if('currentScript'in document){window.addEventListener('error',function onUncaughtError(e){var m=document.currentScript&&document.currentScript.getAttribute('data-sap-ui-module');var M=m&&Module.get(m);if(M&&M.execError==null){if(log.isLoggable()){log.debug("unhandled exception occurred while executing "+m+": "+e.message);}M.execError=e.error||{name:'Error',message:e.message};return false;}});}function loadScript(m,r){var s;function o(e){if(log.isLoggable()){log.debug("Javascript resource loaded: "+m.name);}s.removeEventListener('load',o);s.removeEventListener('error',a);queue.process(m);}function a(e){s.removeEventListener('load',o);s.removeEventListener('error',a);if(r){log.warning("retry loading Javascript resource: "+m.name);if(s&&s.parentNode){s.parentNode.removeChild(s);}loadScript(m,false);return;}log.error("failed to load Javascript resource: "+m.name);m.fail(ensureStacktrace(new Error("script load error")));}s=document.createElement('SCRIPT');s.src=m.url;s.setAttribute("data-sap-ui-module",m.name);if(r!==undefined){s.addEventListener('load',o);s.addEventListener('error',a);}document.head.appendChild(s);}function preloadDependencies(m){var k=mDepCache[m];if(Array.isArray(k)){log.debug("preload dependencies for "+m+": "+k);k.forEach(function(d){d=getMappedName(d,m);if(/\.js$/.test(d)){requireModule(null,d,true);}});}}function requireModule(r,m,a,s){var l=log.isLoggable(),S=urnToBaseIDAndSubType(m),o=mShims[m],M,e,i,b,E;if(!S){throw new Error("can only require Javascript module, not "+m);}M=Module.get(m);if(o&&o.deps&&!s){if(l){log.debug("require dependencies of raw module "+m);}return requireAll(M,o.deps,function(){return requireModule(r,m,a,true);},function(c){M.fail(c);if(a){return;}throw c;},a);}if(l){log.debug(sLogPrefix+"require '"+m+"' of type '"+S.subType+"'");}if(M.state!==INITIAL){if(M.state===PRELOADED){M.state=LOADED;E=true;measure&&measure.start(m,"Require module "+m+" (preloaded)",["require"]);execModule(m,a);measure&&measure.end(m);}if(M.state===READY){if(l){log.debug(sLogPrefix+"module '"+m+"' has already been loaded (skipped).");}return a?Promise.resolve(M.value()):M.value();}else if(M.state===FAILED){if(a){return M.deferred().promise;}else{throw(E?M.error:makeNestedError("found in negative cache: '"+m+"' from "+M.url,M.error));}}else{if(a){if(r&&M.dependsOn(r)){if(log.isLoggable()){log.debug("cycle detected between '"+r.name+"' and '"+m+"', returning undefined for '"+m+"'");}return Promise.resolve(undefined);}return M.deferred().promise;}if(!a&&!M.async){if(log.isLoggable()){log.debug("cycle detected, returning undefined for '"+m+"'");}return undefined;}}}measure&&measure.start(m,"Require module "+m,["require"]);M.state=LOADING;M.async=a;e=bDebugSources?["-dbg",""]:[""];if(!a){for(i=0;i<e.length&&M.state!==LOADED;i++){M.url=getResourcePath(S.baseID,e[i]+S.subType);if(l){log.debug(sLogPrefix+"loading "+(e[i]?e[i]+" version of ":"")+"'"+m+"' from '"+M.url+"'");}if(syncCallBehavior){b="[nosync] loading module '"+M.url+"'";if(syncCallBehavior===1){log.error(b);}else{throw new Error(b);}}require.load({completeLoad:noop,async:false},M.url,S.baseID);loadSyncXHR(M);}if(M.state===LOADING){if(fnIgnorePreload){loadScript(M);}M.fail(makeNestedError("failed to load '"+m+"' from "+M.url,M.error));}else if(M.state===LOADED){execModule(m,a);}measure&&measure.end(m);if(M.state!==READY){throw M.error;}return M.value();}else{M.url=getResourcePath(S.baseID,S.subType);require.load({completeLoad:noop,async:true},M.url,S.baseID);loadScript(M,true);preloadDependencies(m);return M.deferred().promise;}}function execModule(sModuleName,bAsync){var oModule=mModules[sModuleName],oShim=mShims[sModuleName],bLoggable=log.isLoggable(),sOldPrefix,sScript,vAMD,oMatch,bOldForceSyncDefines;if(oModule&&oModule.state===LOADED&&typeof oModule.data!=="undefined"){vAMD=(oShim===true||(oShim&&oShim.amd))&&typeof __global.define==="function"&&__global.define.amd;bOldForceSyncDefines=bForceSyncDefines;try{if(vAMD){delete __global.define.amd;}bForceSyncDefines=!bAsync;if(bLoggable){log.debug(sLogPrefix+"executing '"+sModuleName+"'");sOldPrefix=sLogPrefix;sLogPrefix=sLogPrefix+": ";}oModule.state=EXECUTING;_execStack.push({name:sModuleName,used:false});if(typeof oModule.data==="function"){oModule.data.call(__global);}else if(Array.isArray(oModule.data)){define.apply(null,oModule.data);}else{sScript=oModule.data;if(sScript){oMatch=/\/\/[#@] source(Mapping)?URL=(.*)$/.exec(sScript);if(oMatch&&oMatch[1]&&/^[^/]+\.js\.map$/.test(oMatch[2])){sScript=sScript.slice(0,oMatch.index)+oMatch[0].slice(0,-oMatch[2].length)+resolveURL(oMatch[2],oModule.url);}if(!oMatch||oMatch[1]){sScript+="\n//# sourceURL="+resolveURL(oModule.url)+"?eval";}}if(typeof translate==="function"){sScript=translate(sScript,sModuleName);}if(__global.execScript&&(!oModule.data||oModule.data.length<MAX_EXEC_SCRIPT_LENGTH)){try{oModule.data&&__global.execScript(sScript);}catch(e){_execStack.pop();eval(oModule.data);throw e;}}else{__global.eval(sScript);}}_execStack.pop();queue.process(oModule);if(bLoggable){sLogPrefix=sOldPrefix;log.debug(sLogPrefix+"finished executing '"+sModuleName+"'");}}catch(err){if(bLoggable){sLogPrefix=sOldPrefix;}oModule.data=undefined;oModule.fail(err);}finally{if(vAMD){__global.define.amd=vAMD;}bForceSyncDefines=bOldForceSyncDefines;}}}function requireAll(r,d,c,e,a){var b,m=[],l=log.isLoggable(),i,D,E,p;try{if(r instanceof Module){b=r.name;}else{b=r;r=null;}d=d.slice();for(i=0;i<d.length;i++){d[i]=getMappedName(d[i]+'.js',b);}if(r){r.pending=d.filter(function(g){return!/^(require|exports|module)\.js$/.test(g);});}for(i=0;i<d.length;i++){D=d[i];if(l){log.debug(sLogPrefix+"require '"+D+"'");}if(r){switch(D){case'require.js':m[i]=createContextualRequire(b);break;case'module.js':m[i]=r.api();break;case'exports.js':r.api();m[i]=r._exports;break;default:break;}}if(!m[i]){m[i]=requireModule(r,D,a);}if(l){log.debug(sLogPrefix+"require '"+D+"': done.");}}}catch(f){E=f;}if(a){p=E?Promise.reject(E):Promise.all(m);return p.then(c,e);}else{if(E){e(E);}else{return c(m);}}}function define(m,d,f,e){var r,c;if(typeof m==='string'){r=m+'.js';}else{e=f;f=d;d=m;r=null;}if(!Array.isArray(d)){e=f;f=d;if(typeof f==='function'&&f.length>0){d=['require','exports','module'].slice(0,f.length);}else{d=[];}}if(bForceSyncDefines===false||(bForceSyncDefines==null&&bGlobalAsyncMode)){queue.push(r,d,f,e);return;}c=_execStack.length>0?_execStack[_execStack.length-1]:null;if(!r){if(c&&!c.used){r=c.name;c.used=true;}else{r='~anonymous~'+(++iAnonymousModuleCount)+'.js';if(c){r=c.name.slice(0,c.name.lastIndexOf('/')+1)+r;}log.error("Modules that use an anonymous define() call must be loaded with a require() call; "+"they must not be executed via script tag or nested into other modules. "+"All other usages will fail in future releases or when standard AMD loaders are used "+"or when ui5loader runs in async mode. Now using substitute name "+r);}}else if(c&&!c.used&&r!==c.name){log.debug("module names don't match: requested: "+m+", defined: ",c.name);Module.get(c.name).addAlias(m);}defineModule(r,d,f,e,false);}function defineModule(r,d,f,e,a){var l=log.isLoggable();r=normalize(r);if(l){log.debug("define("+r+", "+"['"+d.join("','")+"']"+")");}var m=declareModule(r);m.content=undefined;requireAll(m,d,function(M){if(l){log.debug("define("+r+"): calling factory "+typeof f);}if(e&&syncCallBehavior!==2){var p=r.split('/');if(p.length>1){getGlobalObject(__global,p,p.length-1,true);}}if(typeof f==='function'){try{var b=f.apply(__global,M);if(m._api&&m._api.exports!==undefined&&m._api.exports!==m._exports){b=m._api.exports;}else if(b===undefined&&m._exports){b=m._exports;}m.content=b;}catch(c){m.fail(c);if(a){return;}throw c;}}else{m.content=f;}if(e&&syncCallBehavior!==2){if(m.content==null){log.error("module '"+r+"' returned no content, but should be exported");}else{if(l){log.debug("exporting content of '"+r+"': as global object");}var s=urnToUI5(r);setGlobalProperty(s,m.content);}}m.ready();},function(E){m.fail(E);if(!a){throw E;}},a);}function createContextualRequire(c){var r=function(d,C,e){var m;assert(typeof d==='string'||Array.isArray(d),"dependency param either must be a single string or an array of strings");assert(C==null||typeof C==='function',"callback must be a function or null/undefined");assert(e==null||typeof e==='function',"error callback must be a function or null/undefined");if(typeof d==='string'){m=getMappedName(d+'.js',c);return Module.get(m).value();}requireAll(c,d,function(M){if(typeof C==='function'){if(bGlobalAsyncMode){C.apply(__global,M);}else{setTimeout(function(){C.apply(__global,M);},0);}}},function(E){if(typeof e==='function'){if(bGlobalAsyncMode){e.call(__global,E);}else{setTimeout(function(){e.call(__global,E);},0);}}else{throw E;}},bGlobalAsyncMode);};r.toUrl=function(n){n=getMappedName(n,c);var N=urnToIDAndType(n);return getResourcePath(N.id,N.type);};return r;}var require=createContextualRequire(null);function requireSync(m){m=getMappedName(m+'.js');return requireModule(null,m,false);}function dumpInternals(t){var s=[PRELOADED,INITIAL,LOADED,READY,FAILED,EXECUTING,LOADING];var a={};a[PRELOADED]='PRELOADED';a[INITIAL]='INITIAL';a[LOADING]='LOADING';a[LOADED]='LOADED';a[EXECUTING]='EXECUTING';a[READY]='READY';a[FAILED]='FAILED';if(t==null){t=PRELOADED;}var i=log.isLoggable('INFO')?log.info.bind(log):console.info.bind(console);var m=Object.keys(mModules).sort();s.forEach(function(b){if(b<t){return;}var c=0;i(a[b]+":");m.forEach(function(M,d){var o=mModules[M];if(o.state===b){var e;if(o.state===LOADING){var p=o.pending&&o.pending.reduce(function(f,g){var D=Module.get(g);if(D.state!==READY){f.push(g+"("+a[D.state]+")");}return f;},[]);if(p&&p.length>0){e="waiting for "+p.join(", ");}}else if(o.state===FAILED){e=(o.error.name||"Error")+": "+o.error.message;}i("  "+(d+1)+" "+M+(e?" ("+e+")":""));c++;}});if(c===0){i("  none");}});}function getUrlPrefixes(){var u=Object.create(null);forEach(mUrlPrefixes,function(n,U){u[n]=U.url;});return u;}function unloadResources(n,p,u,d){var m=[],U,M;if(p==null){p=true;}if(p){for(U in mModules){M=mModules[U];if(M&&M.group===n){m.push(U);}}}else{if(mModules[n]){m.push(n);}}m.forEach(function(U){var M=mModules[U];if(M&&d&&U.match(/\.js$/)){setGlobalProperty(urnToUI5(U),undefined);}if(M&&(u||M.state===PRELOADED)){delete mModules[U];}});}function getModuleContent(n,u){if(n){n=getMappedName(n);}else{n=guessResourceName(u);}var m=n&&mModules[n];if(m){m.state=LOADED;return m.data;}else{return undefined;}}function getAllModules(){var s=Object.create(null);forEach(mModules,function(u,m){s[u]={state:m.state,ui5:urnToUI5(u)};});return s;}function loadJSResourceAsync(r,i){r=getMappedName(r);var p=requireModule(null,r,true);return i?p.catch(noop):p;}var mConfigHandlers={baseUrl:function(u){registerResourcePath("",u);},paths:registerResourcePath,shim:function(m,s){if(Array.isArray(s)){s={deps:s};}mShims[m+'.js']=s;},async:function(a){bGlobalAsyncMode=!!a;},debugSources:function(d){bDebugSources=!!d;},depCache:function(m,d){mDepCache[m+'.js']=d.map(function(a){return a+'.js';});},depCacheUI5:function(m,d){mDepCache[m]=d;},ignoreBundledResources:function(f){if(f==null||typeof f==='function'){fnIgnorePreload=f;}},map:function(c,m){if(m==null){delete mMaps[c];}else if(typeof m==='string'){mMaps['*'][c]=m;}else{mMaps[c]=mMaps[c]||Object.create(null);forEach(m,function(a,n){mMaps[c][a]=n;});}},reportSyncCalls:function(r){if(r===0||r===1||r===2){syncCallBehavior=r;}},noConflict:function(v){if(v){__global.define=vOriginalDefine;__global.require=vOriginalRequire;}else{__global.define=define;__global.require=require;}}};function config(c){forEach(c,function(k,v){var h=mConfigHandlers[k];if(typeof h==='function'){if(h.length===1){h(v);}else if(v!=null){forEach(v,h);}}else{log.warning("configuration option "+k+" not supported (ignored)");}});}require.load=function(c,u,i){};var ui5loader={amdDefine:define,amdRequire:require,config:config,declareModule:function(r){declareModule(normalize(r));},dump:dumpInternals,getAllModules:getAllModules,getModuleContent:getModuleContent,getModuleState:function(r){return mModules[r]?mModules[r].state:INITIAL;},getResourcePath:getResourcePath,getUrlPrefixes:getUrlPrefixes,loadJSResourceAsync:loadJSResourceAsync,resolveURL:resolveURL,toUrl:getResourcePath,unloadResources:unloadResources};Object.defineProperties(ui5loader,{logger:{get:function(){return log;},set:function(v){log=v;}},measure:{get:function(){return measure;},set:function(v){measure=v;}},assert:{get:function(){return assert;},set:function(v){assert=v;}},translate:{get:function(){return translate;},set:function(v){translate=v;}}});require.sync=requireSync;require.predefine=function(m,d,f,e){if(typeof m!=='string'){throw new Error("predefine requires a module name");}m=normalize(m);Module.get(m+'.js').preload("<unknown>/"+m,[m,d,f,e],null);};require.preload=function(m,g,u){g=g||null;u=u||"<unknown>";for(var n in m){n=normalize(n);Module.get(n).preload(u+"/"+n,m[n],g);}};if(typeof ES6Promise!=='undefined'){Module.get('sap/ui/thirdparty/es6-promise.js').ready(ES6Promise);}Module.get('sap/ui/thirdparty/es6-string-methods.js').ready(null);vOriginalDefine=__global.define;vOriginalRequire=__global.require;__global.define=define;__global.require=require;__global.sap=__global.sap||{};sap.ui=sap.ui||{};sap.ui._ui5loader=ui5loader;sap.ui.define=define;sap.ui.predefine=require.predefine;sap.ui.require=require;sap.ui.requireSync=require.sync;}(window));
