/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/base/util/now","sap/base/util/getObject","sap/base/util/getter","sap/base/Version","sap/base/util/extend","sap/base/assert","sap/base/Log","sap/ui/Configuration","sap/ui/dom/appendHead","sap/ui/dom/computedStylePolyfill","sap/ui/dom/activeElementFix","sap/ui/dom/includeScript","sap/ui/dom/includeStylesheet","sap/ui/initjQuerySupport","sap/ui/initSupportHooks","sap/ui/initjQueryBrowser","sap/ui/security/FrameOptions","sap/ui/performance/Measurement","sap/ui/performance/Interaction","sap/ui/performance/ResourceTimings","sap/ui/bootstrap/StoredConfig","sap/ui/SyncPoint","sap/ui/XHRProxy","sap/ui/Device","sap/ui/thirdparty/URI","sap/ui/thirdparty/jquery","sap/ui/thirdparty/jqueryui/jquery-ui-position","ui5loader-autoconfig","jquery.sap.stubs"],function(now,getObject,getter,Version,extend,assert,Log,Configuration,appendHead,computedStylePolyfill,activeElementFix,includeScript,includeStylesheet,initjQuerySupport,initSupportHooks,initjQueryBrowser,FrameOptions,Measurement,Interaction,ResourceTimings,StoredConfig,SyncPoint,XHRProxy,Device,URI,jQuery){"use strict";if(!jQuery){throw new Error("Loading of jQuery failed");}var ui5loader=sap.ui.loader;if(!ui5loader||!ui5loader._){throw new Error("The UI5 compatilbility module requires a UI5 specific AMD implementation");}var _ui5loader=ui5loader._;var _earlyLogs=[];function _earlyLog(l,m){_earlyLogs.push({level:l,message:m});}var oJQVersion=Version(jQuery.fn.jquery);if(Device.browser.msie){jQuery.support=jQuery.support||{};jQuery.support.cors=true;if(window.ActiveXObject!==undefined&&oJQVersion.inRange("1.11","2")){var fnCreateStandardXHR=function(){try{return new XMLHttpRequest();}catch(e){}};var fnCreateActiveXHR=function(){try{return new ActiveXObject("Microsoft.XMLHTTP");}catch(e){}};jQuery.ajaxSettings=jQuery.ajaxSettings||{};jQuery.ajaxSettings.xhr=function(){return!this.isLocal?fnCreateStandardXHR():fnCreateActiveXHR();};}}if(Device.browser.firefox){computedStylePolyfill();}if(Device.browser.msie||Device.browser.edge){activeElementFix();}if(Device.browser.firefox&&window.Proxy){XHRProxy();}var oCfgData=window["sap-ui-config"]=Configuration;var syncCallBehavior=0;if(oCfgData['xx-nosync']==='warn'||/(?:\?|&)sap-ui-xx-nosync=(?:warn)/.exec(window.location.search)){syncCallBehavior=1;}if(oCfgData['xx-nosync']===true||oCfgData['xx-nosync']==='true'||/(?:\?|&)sap-ui-xx-nosync=(?:x|X|true)/.exec(window.location.search)){syncCallBehavior=2;}ui5loader.config({reportSyncCalls:syncCallBehavior});if(syncCallBehavior&&oCfgData.__loaded){_earlyLog(syncCallBehavior===1?"warning":"error","[nosync]: configuration loaded via sync XHR");}if(oCfgData.noconflict===true||oCfgData.noconflict==="true"||oCfgData.noconflict==="x"){jQuery.noConflict();}jQuery.sap=jQuery.sap||{};jQuery.sap.Version=Version;jQuery.sap.now=now;jQuery.sap.debug=StoredConfig.debug;jQuery.sap.setReboot=StoredConfig.setReboot;jQuery.sap.statistics=StoredConfig.statistics;jQuery.sap.log=extend(Log.getLogger(),{Level:Log.Level,getLogger:Log.getLogger,getLogEntries:Log.getLog,addLogListener:Log.addLogListener,removeLogListener:Log.removeLogListener,logSupportInfo:Log.logSupportInfo,LogLevel:Log.Level,getLog:Log.getLog});var sWindowName=(typeof window==="undefined"||window.top==window)?"":"["+window.location.pathname.split('/').slice(-1)[0]+"] ";jQuery.sap.assert=function(r,m){if(!r){var M=typeof m==="function"?m():m;assert(r,sWindowName+M);}};oCfgData.loglevel=(function(){var m=/(?:\?|&)sap-ui-log(?:L|-l)evel=([^&]*)/.exec(window.location.search);return m&&m[1];}())||oCfgData.loglevel;if(oCfgData.loglevel){Log.setLevel(Log.Level[oCfgData.loglevel.toUpperCase()]||parseInt(oCfgData.loglevel,10));}Log.info("SAP Logger started.");jQuery.each(_earlyLogs,function(i,e){Log[e.level](e.message);});_earlyLogs=null;jQuery.sap.factory=function factory(p){function F(){}F.prototype=p;return F;};jQuery.sap.newObject=function newObject(p){return Object.create(p||null);};jQuery.sap.getter=getter;jQuery.sap.getObject=function(n,N,c){var o=c||window,a=(n||"").split("."),l=a.length,e=isNaN(N)?0:l-N,i;if(syncCallBehavior&&c===window){Log.error("[nosync] getObject called to retrieve global name '"+n+"'");}for(i=0;o&&i<l;i++){if(!o[a[i]]&&i<e){o[a[i]]={};}o=o[a[i]];}return o;};jQuery.sap.setObject=function(n,v,c){if(n!=undefined){var N=n.split(".");c=c||window;if(N.length>1){var o=N.pop();getObject(c,N.join("."),true)[o]=v;}else if(N.length==1){c[n]=v;}}};_ui5loader.measure=Measurement;jQuery.sap.measure=extend({},_ui5loader.measure);jQuery.sap.measure.clearInteractionMeasurements=Interaction.clear;jQuery.sap.measure.startInteraction=Interaction.start;jQuery.sap.measure.endInteraction=Interaction.end;jQuery.sap.measure.getPendingInteractionMeasurement=Interaction.getPending;jQuery.sap.measure.filterInteractionMeasurements=Interaction.filter;jQuery.sap.measure.getAllInteractionMeasurements=Interaction.getAll;jQuery.sap.measure.getRequestTimings=ResourceTimings.getRequestTimings;jQuery.sap.measure.clearRequestTimings=ResourceTimings.clearRequestTimings;jQuery.sap.measure.setRequestBufferSize=ResourceTimings.setRequestBufferSize;jQuery.sap.syncPoint=function(n,c,t){return new SyncPoint(n,c,t);};var getModuleSystemInfo=(function(){var l=_ui5loader.logger=Log.getLogger("sap.ui.ModuleSystem",(/sap-ui-xx-debug(M|-m)odule(L|-l)oading=(true|x|X)/.test(location.search)||oCfgData["xx-debugModuleLoading"])?Log.Level.DEBUG:Log.Level.INFO),F="fragment",V="view",k={js:[V,F,"controller","designtime"],xml:[V,F],json:[V,F],html:[V,F]},r,a;(function(){var s="",S="";for(var t in k){s=(s?s+"|":"")+t;S=(S?S+"|":"")+"(?:(?:"+k[t].join("\\.|")+"\\.)?"+t+")";}s="\\.("+s+")$";S="\\.(?:"+S+"|[^./]+)$";l.debug("constructed regexp for file types :"+s);l.debug("constructed regexp for file sub-types :"+S);r=new RegExp(s);a=new RegExp(S);}());function u(N){if(/^jquery\.sap\./.test(N)){return N;}return N.replace(/\./g,"/");}jQuery.sap.getModulePath=function(m,s){return jQuery.sap.getResourcePath(u(m),s);};jQuery.sap.getResourcePath=function(R,s){if(arguments.length===1&&R!=''){var S=R.split(/\//);var m=a.exec(S[S.length-1]);if(m){s=m[0];S[S.length-1]=S[S.length-1].slice(0,m.index);R=S.join('/');}else{s="";}}return _ui5loader.getResourcePath(R,s);};jQuery.sap.registerModulePath=function registerModulePath(m,v){m=m.replace(/\./g,"/");v=v||'.';jQuery.sap.registerResourcePath(m,v);};jQuery.sap.registerResourcePath=function(R,v){if(!v){v={url:null};}if(!f[R]){var s;if(typeof v==="string"||v instanceof String){s=v;}else{s=v.url;if(v.final){f[R]=v.final;}}var o=_ui5loader.toUrl(R);var c;if(s!==o||v.final){c={paths:{}};c.paths[R]=s;ui5loader.config(c);l.info("jQuery.sap.registerResourcePath ('"+R+"', '"+s+"')"+(v['final']?" (final)":""));}}else{l.warning("jQuery.sap.registerResourcePath with prefix "+R+" already set as final. This call is ignored.");}};var f=Object.create(null);jQuery.sap.registerModuleShims=function(s){ui5loader.config({shim:s});};jQuery.sap.isDeclared=function isDeclared(m,i){var s=_ui5loader.getModuleState(u(m)+".js");return s&&(i||s>0);};jQuery.sap.isResourceLoaded=function isResourceLoaded(R){return!!_ui5loader.getModuleState(R);};jQuery.sap.getAllDeclaredModules=function(){var m=[],M=_ui5loader.getAllModules(true),o;for(var s in M){o=M[s];if(o.ui5&&o.state!==-1){m.push(o.ui5);}}return m;};if(oCfgData.resourceroots){for(var n in oCfgData.resourceroots){jQuery.sap.registerModulePath(n,oCfgData.resourceroots[n]);}}var U=_ui5loader.getUrlPrefixes();l.info("URL prefixes set to:");for(var n in U){l.info("  "+(n?"'"+n+"'":"(default)")+" : "+U[n]+(f[n]?" (final)":""));}jQuery.sap.declare=function(m,c){var N=m;if(typeof(m)==="object"){N=m.modName;m=u(m.modName)+(m.type?"."+m.type:"")+".js";}else{m=u(m)+".js";}_ui5loader.declareModule(m);if(c!==false){jQuery.sap.getObject(N,1);}};jQuery.sap.require=function(m){if(arguments.length>1){for(var i=0;i<arguments.length;i++){jQuery.sap.require(arguments[i]);}return this;}if(typeof(m)==="object"){m=u(m.modName)+(m.type?"."+m.type:"");}else{m=u(m);}sap.ui.requireSync(m);};Object.defineProperty(jQuery.sap.require,"_hook",{get:function(){return _ui5loader.translate;},set:function(h){_ui5loader.translate=h;}});jQuery.sap.preloadModules=function(p,A,s){Log.error("jQuery.sap.preloadModules was never a public API and has been removed. Migrate to Core.loadLibrary()!");};jQuery.sap.registerPreloadedModules=function(d){var m=d.modules;if(Version(d.version||"1.0").compareTo("2.0")<0){m={};for(var N in d.modules){m[u(N)+".js"]=d.modules[N];}}sap.ui.require.preload(m,d.name,d.url);};jQuery.sap.unloadResources=_ui5loader.unloadResources;jQuery.sap.getResourceName=function(m,s){return u(m)+(s==null?".js":s);};jQuery.sap.loadResource=function(R,o){var t,D,s,E,b;if(typeof R==="string"){o=o||{};}else{o=R||{};R=o.name;}o=jQuery.extend({failOnError:true,async:false},o);t=o.dataType;if(t==null&&R){t=(t=r.exec(R||o.url))&&t[1];}b=o.async?new jQuery.Deferred():null;function h(d,e){if(d==null&&o.failOnError){E=e||new Error("no data returned for "+R);if(o.async){b.reject(E);l.error(E);}return null;}if(o.async){b.resolve(d);}return d;}function c(d){var C=jQuery.ajaxSettings.converters["text "+t];if(typeof C==="function"){d=C(d);}return h(d);}D=_ui5loader.getModuleContent(R,o.url);if(D!=undefined){if(o.async){setTimeout(function(){c(D);},0);}else{D=c(D);}}else{if(!o.async&&syncCallBehavior){if(syncCallBehavior>=1){l.error("[nosync] loading resource '"+(R||o.url)+"' with sync XHR");}else{throw new Error("[nosync] loading resource '"+(R||o.url)+"' with sync XHR");}}jQuery.ajax({url:s=o.url||_ui5loader.getResourcePath(R),async:o.async,dataType:t,headers:o.headers,success:function(d,e,x){D=h(d);},error:function(x,d,e){E=new Error("resource "+R+" could not be loaded from "+s+". Check for 'file not found' or parse errors. Reason: "+e);E.status=d;E.error=e;E.statusCode=x.status;D=h(null,E);}});}if(o.async){return Promise.resolve(b);}if(E!=null&&o.failOnError){throw E;}return D;};jQuery.sap._loadJSResourceAsync=_ui5loader.loadJSResourceAsync;return function(){return{modules:_ui5loader.getAllModules(),prefixes:_ui5loader.getUrlPrefixes()};};}());jQuery.sap.includeScript=includeScript;jQuery.sap.includeStyleSheet=includeStylesheet;if(!(oCfgData.productive===true||oCfgData.productive==="true"||oCfgData.productive==="x")){initSupportHooks(getModuleSystemInfo,oCfgData);}if(oJQVersion.compareTo("2.2.3")!=0){Log.warning("SAPUI5's default jQuery version is 2.2.3; current version is "+jQuery.fn.jquery+". Please note that we only support version 2.2.3.");}initjQueryBrowser();initjQuerySupport();jQuery.sap.FrameOptions=FrameOptions;jQuery.sap.globalEval=function(){eval(arguments[0]);};return jQuery;});
