/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/f/Avatar',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/IconPool","./AvatarRenderer","jquery.sap.keycodes"],function(q,l,C,I,A){"use strict";var a=l.AvatarType;var b=l.AvatarImageFitType;var c=l.AvatarSize;var d=l.AvatarShape;
var e=C.extend("sap.f.Avatar",{metadata:{library:"sap.f",properties:{src:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},initials:{type:"string",group:"Data",defaultValue:null},displayShape:{type:"sap.f.AvatarShape",group:"Appearance",defaultValue:d.Circle},displaySize:{type:"sap.f.AvatarSize",group:"Appearance",defaultValue:c.S},customDisplaySize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"3rem"},customFontSize:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:"1.125rem"},imageFitType:{type:"sap.f.AvatarImageFitType",group:"Appearance",defaultValue:b.Cover}},aggregations:{detailBox:{type:'sap.m.LightBox',multiple:false,bindable:"bindable"}},events:{press:{}},designtime:"sap/f/designtime/Avatar.designtime"}});
e.DEFAULT_CIRCLE_PLACEHOLDER="sap-icon://person-placeholder";e.DEFAULT_SQUARE_PLACEHOLDER="sap-icon://product";
e.prototype.init=function(){this._sActualType=null;this._bIsDefaultIcon=true;};
e.prototype.exit=function(){if(this._icon){this._icon.destroy();}if(this._fnLightBoxOpen){this._fnLightBoxOpen=null;}};
e.prototype.setDetailBox=function(L){var o=this.getDetailBox();if(L){if(L===o){return this;}if(o){this.detachPress(this._fnLightBoxOpen,o);}this._fnLightBoxOpen=L.open;this.attachPress(this._fnLightBoxOpen,L);}else if(this._fnLightBoxOpen){this.detachPress(this._fnLightBoxOpen,o);this._fnLightBoxOpen=null;}return this.setAggregation("detailBox",L);};
e.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments),f=o.getDetailBox();if(f){o.detachPress(this._fnLightBoxOpen,this.getDetailBox());o._fnLightBoxOpen=f.open;o.attachPress(o._fnLightBoxOpen,f);}return o;};
e.prototype.attachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.attachEvent.apply(this,arguments);if(this.hasListeners("press")){this.$().attr("tabindex","0");this.$().attr("role","button");}return this;};
e.prototype.detachPress=function(){Array.prototype.unshift.apply(arguments,["press"]);C.prototype.detachEvent.apply(this,arguments);if(!this.hasListeners("press")){this.$().removeAttr("tabindex");this.$().removeAttr("role");}return this;};
e.prototype.ontap=function(){this.firePress({});};
e.prototype.onkeyup=function(E){if(E.which===q.sap.KeyCodes.SPACE||E.which===q.sap.KeyCodes.ENTER){this.firePress({});E.stopPropagation();}};
e.prototype._areInitialsValid=function(i){var v=/^[a-zA-Z]{1,2}$/;if(!v.test(i)){q.sap.log.warning("Initials should consist of only 1 or 2 latin letters",this);this._sActualType=a.Icon;this._bIsDefaultIcon=true;return false;}return true;};
e.prototype._validateSrc=function(s){if(I.isIconURI(s)){this._sActualType=a.Icon;this._bIsDefaultIcon=false;}else{this._sActualType=a.Image;}return this;};
e.prototype._getActualDisplayType=function(){var s=this.getSrc(),i=this.getInitials();if(s){this._validateSrc(s);}else if(i&&this._areInitialsValid(i)){this._sActualType=a.Initials;}else{q.sap.log.warning("No src and initials were provided",this);this._sActualType=a.Icon;this._bIsDefaultIcon=true;}return this._sActualType;};
e.prototype._getDefaultIconPath=function(D){var s=null;if(D===d.Circle){s=e.DEFAULT_CIRCLE_PLACEHOLDER;}else if(D===d.Square){s=e.DEFAULT_SQUARE_PLACEHOLDER;}return s;};
e.prototype._getIcon=function(){var s=this.getSrc(),D=this.getDisplayShape();if(this._bIsDefaultIcon){s=this._getDefaultIconPath(D);}if(!this._icon){this._icon=I.createControlByURI({alt:"Image placeholder",src:s});}else if(this._icon.getSrc()!==s){this._icon.setSrc(s);}return this._icon;};
e.prototype._getEscapedSrc=function(){var s=this.getSrc();if(!s){return'';}return s.replace(/'/g,"\\'");};
e.prototype.getAccessibilityInfo=function(){var h=this.hasListeners("press");if(!h){return null;}return{role:h?"button":"img",type:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText(h?"ACC_CTR_TYPE_BUTTON":"ACC_CTR_TYPE_IMAGE"),focusable:h};};
return e;});
sap.ui.predefine('sap/f/AvatarRenderer',["sap/f/library","jquery.sap.global"],function(l,q){"use strict";var A=l.AvatarSize;var a=l.AvatarType;var b={};
b.render=function(r,o){var i=o.getInitials(),s=o._getActualDisplayType(),d=o.getDisplaySize(),D=o.getDisplayShape(),I=o.getImageFitType(),c=o.getCustomDisplaySize(),C=o.getCustomFontSize(),S=o._getEscapedSrc(),e="sapFAvatar",t=o.getTooltip_AsString();r.write("<span");r.writeControlData(o);r.addClass(e);r.addClass(e+d);r.addClass(e+s);r.addClass(e+D);if(o.hasListeners("press")){r.addClass("sapMPointer");r.addClass("sapFAvatarFocusable");r.writeAccessibilityState(o,{"role":"button"});r.writeAttribute("tabIndex",0);}if(s===a.Image){r.addClass(e+s+I);r.addStyle("background-image","url('"+q.sap.encodeHTML(S)+"')");}if(d===A.Custom){r.addStyle("width",c);r.addStyle("height",c);r.addStyle("font-size",C);}if(t){r.writeAttributeEscaped("title",t);}r.writeClasses();r.writeStyles();r.write(">");if(s===a.Icon){r.renderControl(o._getIcon());}else if(s===a.Initials){r.write("<span");r.addClass(e+"InitialsHolder");r.writeClasses();r.write(">");r.writeEscaped(i);r.write("</span>");}if(o._fnLightBoxOpen){r.write("<span class=\"sapFAvatarMagnifyingGlass\"></span>");}r.write("</span>");};
return b;},true);
sap.ui.predefine('sap/f/DynamicPage',["jquery.sap.global","./library","sap/ui/core/Control","sap/ui/core/ScrollBar","sap/ui/core/ResizeHandler","sap/ui/core/delegate/ScrollEnablement","sap/ui/Device","sap/f/DynamicPageTitle","./DynamicPageRenderer"],function(q,l,C,S,R,a,D,b,c){"use strict";
var d=C.extend("sap.f.DynamicPage",{metadata:{library:"sap.f",properties:{preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},fitContent:{type:"boolean",group:"Behavior",defaultValue:false}},aggregations:{title:{type:"sap.f.DynamicPageTitle",multiple:false},header:{type:"sap.f.DynamicPageHeader",multiple:false},content:{type:"sap.ui.core.Control",multiple:false},footer:{type:"sap.m.IBar",multiple:false},_scrollBar:{type:"sap.ui.core.ScrollBar",multiple:false,visibility:"hidden"}},designtime:"sap/f/designtime/DynamicPage.designtime"}});
function e(o){if(arguments.length===1){return o&&("length"in o)?o.length>0:!!o;}return Array.prototype.slice.call(arguments).every(function(O){return e(O);});}
function h(E){var o;if(!E){return false;}o=E.getBoundingClientRect();return!!(o.width&&o.height);}
var u=sap.ui.getCore().getConfiguration().getAnimation();d.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE=0.6;d.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE=0.6;d.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE=0.3;d.FOOTER_ANIMATION_DURATION=350;d.BREAK_POINTS={TABLET:1024,PHONE:600};d.EVENTS={TITLE_PRESS:"_titlePress",TITLE_MOUSE_OVER:"_titleMouseOver",TITLE_MOUSE_OUT:"_titleMouseOut",PIN_UNPIN_PRESS:"_pinUnpinPress",VISUAL_INDICATOR_MOUSE_OVER:"_visualIndicatorMouseOver",VISUAL_INDICATOR_MOUSE_OUT:"_visualIndicatorMouseOut",HEADER_VISUAL_INDICATOR_PRESS:"_headerVisualIndicatorPress",TITLE_VISUAL_INDICATOR_PRESS:"_titleVisualIndicatorPress"};d.MEDIA={INVISIBLE:"sapUiHidden",PHONE:"sapFDynamicPage-Std-Phone",TABLET:"sapFDynamicPage-Std-Tablet",DESKTOP:"sapFDynamicPage-Std-Desktop"};d.RESIZE_HANDLER_ID={PAGE:"_sResizeHandlerId",TITLE:"_sTitleResizeHandlerId",CONTENT:"_sContentResizeHandlerId"};
d.prototype.init=function(){this._bPinned=false;this._bHeaderInTitleArea=false;this._bExpandingWithAClick=false;this._bSuppressToggleHeaderOnce=false;this._headerBiggerThanAllowedHeight=false;this._bMSBrowser=D.browser.internet_explorer||D.browser.edge||false;this._oScrollHelper=new a(this,this.getId()+"-content",{horizontal:false,vertical:true});};
d.prototype.onBeforeRendering=function(){var o=this.getTitle();if(!this._preserveHeaderStateOnScroll()){this._attachPinPressHandler();}if(e(o)){o._toggleFocusableState(this.getToggleHeaderOnTitleClick());}this._attachTitlePressHandler();this._attachVisualIndicatorsPressHandlers();this._attachVisualIndicatorMouseOverHandlers();this._attachTitleMouseOverHandlers();this._detachScrollHandler();};
d.prototype.onAfterRendering=function(){var s;if(this._preserveHeaderStateOnScroll()){q.sap.delayedCall(0,this,this._overridePreserveHeaderStateOnScroll);}this._bPinned=false;this._cacheDomElements();this._detachResizeHandlers();this._attachResizeHandlers();this._updateMedia(this._getWidth(this));this._attachScrollHandler();this._updateScrollBar();this._attachPageChildrenAfterRenderingDelegates();this._resetPinButtonState();if(!this.getHeaderExpanded()){this._snapHeader(false);s=this.getHeader()&&!this.getPreserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();if(s){this._setScrollPosition(this._getSnappingHeight());}else{this._toggleHeaderVisibility(false);this._moveHeaderToTitleArea();}}this._updateToggleHeaderVisualIndicators();};
d.prototype.exit=function(){this._detachResizeHandlers();if(this._oScrollHelper){this._oScrollHelper.destroy();}};
d.prototype.setShowFooter=function(s){var r=this.setProperty("showFooter",s,true);this._toggleFooter(s);return r;};
d.prototype.setHeaderExpanded=function(H){if(this._bPinned){return this;}if(this.getHeaderExpanded()===H){return this;}if(this.getDomRef()){this._titleExpandCollapseWhenAllowed();}this.setProperty("headerExpanded",H,true);return this;};
d.prototype.setToggleHeaderOnTitleClick=function(t){var o=this.getTitle(),H=this.getHeaderExpanded(),r=this.setProperty("toggleHeaderOnTitleClick",t,true);t=this.getProperty("toggleHeaderOnTitleClick");this.$().toggleClass("sapFDynamicPageTitleClickEnabled",t);this._updateToggleHeaderVisualIndicators();this._updateARIAStates(H);if(e(o)){o._toggleFocusableState(t);}return r;};
d.prototype.setFitContent=function(f){var r=this.setProperty("fitContent",f,true);if(e(this.$())){this._updateFitContainer();}return r;};
d.prototype.getScrollDelegate=function(){return this._oScrollHelper;};
d.prototype._overridePreserveHeaderStateOnScroll=function(){if(!this._shouldOverridePreserveHeaderStateOnScroll()){this._headerBiggerThanAllowedHeight=false;return;}this._headerBiggerThanAllowedHeight=true;if(this.getHeaderExpanded()){this._moveHeaderToContentArea(true);}else{this._adjustSnap();}this._updateScrollBar();};
d.prototype._shouldOverridePreserveHeaderStateOnScroll=function(){return!D.system.desktop&&this._headerBiggerThanAllowedToBeFixed()&&this._preserveHeaderStateOnScroll();};
d.prototype._toggleFooter=function(s){var f=this.getFooter();if(!e(this.$())){return;}if(!e(f)){return;}f.toggleStyleClass("sapFDynamicPageActualFooterControlShow",s);f.toggleStyleClass("sapFDynamicPageActualFooterControlHide",!s);this._toggleFooterSpacer(s);if(u){if(!s){this._iFooterAnimationTimeout=q.sap.delayedCall(d.FOOTER_ANIMATION_DURATION,this,function(){this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());});}else{if(this._iFooterAnimationTimeout){q.sap.clearDelayedCall(this._iFooterAnimationTimeout);this._iFooterAnimationTimeout=null;}this.$footerWrapper.toggleClass("sapUiHidden",!this.getShowFooter());}q.sap.delayedCall(d.FOOTER_ANIMATION_DURATION,this,function(){f.removeStyleClass("sapFDynamicPageActualFooterControlShow");});}this._updateScrollBar();};
d.prototype._toggleFooterSpacer=function(t){var $=this.$("spacer");if(e($)){$.toggleClass("sapFDynamicPageContentWrapperSpacer",t);}if(e(this.$contentFitContainer)){this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainerFooterVisible",t);}};
d.prototype._toggleHeaderInTabChain=function(t){var o=this.getTitle(),f=this.getHeader();if(!e(o)||!e(f)){return;}f.$().css("visibility",t?"visible":"hidden");};
d.prototype._snapHeader=function(A,U){var o=this.getTitle();if(this._bPinned&&!U){q.sap.log.debug("DynamicPage :: aborted snapping, header is pinned",this);return;}q.sap.log.debug("DynamicPage :: snapped header",this);if(this._bPinned&&U){this._unPin();this._togglePinButtonPressedState(false);}if(e(o)){o._toggleState(false,U);if(A&&this._bHeaderInTitleArea){this._moveHeaderToContentArea(true);}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't snap header. There's no title.",this);return;}this.setProperty("headerExpanded",false,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.addClass("sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();this._togglePinButtonVisibility(false);}this._toggleHeaderInTabChain(false);this._updateARIAStates(false);};
d.prototype._expandHeader=function(A,U){var o=this.getTitle();q.sap.log.debug("DynamicPage :: expand header",this);if(e(o)){o._toggleState(true,U);if(A){this._moveHeaderToTitleArea(true);}}if(!e(this.$titleArea)){q.sap.log.warning("DynamicPage :: couldn't expand header. There's no title.",this);return;}this.setProperty("headerExpanded",true,true);if(this._hasVisibleTitleAndHeader()){this.$titleArea.removeClass("sapFDynamicPageTitleSnapped");this._updateToggleHeaderVisualIndicators();if(!this.getPreserveHeaderStateOnScroll()){this._togglePinButtonVisibility(true);}}this._toggleHeaderInTabChain(true);this._updateARIAStates(true);};
d.prototype._toggleHeaderVisibility=function(s,U){var E=this.getHeaderExpanded(),o=this.getTitle(),f=this.getHeader();if(this._bPinned&&!U){q.sap.log.debug("DynamicPage :: header toggle aborted, header is pinned",this);return;}if(e(o)){o._toggleState(E);}if(e(f)){f.$().toggleClass("sapFDynamicPageHeaderHidden",!s);this._updateScrollBar();}this._toggleHeaderInTabChain(s);};
d.prototype._moveHeaderToContentArea=function(o){var f=this.getHeader();if(e(f)){f.$().prependTo(this.$wrapper);this._bHeaderInTitleArea=false;if(o){this._offsetContentOnMoveHeader();}}};
d.prototype._moveHeaderToTitleArea=function(o){var f=this.getHeader();if(e(f)){f.$().appendTo(this.$titleArea);this._bHeaderInTitleArea=true;if(o){this._offsetContentOnMoveHeader();}}};
d.prototype._offsetContentOnMoveHeader=function(){var o=Math.ceil(this._getHeaderHeight()),i=this._getScrollPosition(),n;if(!o){return;}n=this._bHeaderInTitleArea?i-o:i+o;n=Math.max(n,0);this._setScrollPosition(n,true);};
d.prototype._pin=function(){var $=this.$();if(this._bPinned){return;}this._bPinned=true;if(!this._bHeaderInTitleArea){this._moveHeaderToTitleArea(true);this._updateScrollBar();}this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(e($)){$.addClass("sapFDynamicPageHeaderPinned");}};
d.prototype._unPin=function(){var $=this.$();if(!this._bPinned){return;}this._bPinned=false;this._updateToggleHeaderVisualIndicators();this._togglePinButtonARIAState(this._bPinned);if(e($)){$.removeClass("sapFDynamicPageHeaderPinned");}};
d.prototype._togglePinButtonVisibility=function(t){var o=this.getHeader();if(e(o)){o._setShowPinBtn(t);}};
d.prototype._togglePinButtonPressedState=function(p){var o=this.getHeader();if(e(o)){o._togglePinButton(p);}};
d.prototype._togglePinButtonARIAState=function(p){var o=this.getHeader();if(e(o)){o._updateARIAPinButtonState(p);}};
d.prototype._resetPinButtonState=function(){if(this._preserveHeaderStateOnScroll()){this._togglePinButtonVisibility(false);}else{this._togglePinButtonPressedState(false);this._togglePinButtonARIAState(false);}};
d.prototype._restorePinButtonFocus=function(){this.getHeader()._focusPinButton();};
d.prototype._getScrollPosition=function(){return e(this.$wrapper)?Math.ceil(this.$wrapper.scrollTop()):0;};
d.prototype._setScrollPosition=function(n,s){if(!e(this.$wrapper)){return;}if(this._getScrollPosition()===n){return;}if(s){this._bSuppressToggleHeaderOnce=true;}if(!this.getScrollDelegate()._$Container){this.getScrollDelegate()._$Container=this.$wrapper;}this.getScrollDelegate().scrollTo(0,n);};
d.prototype._shouldSnap=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()>=this._getSnappingHeight()&&this.getHeaderExpanded()&&!this._bPinned;};
d.prototype._shouldExpand=function(){return!this._preserveHeaderStateOnScroll()&&this._getScrollPosition()<this._getSnappingHeight()&&!this.getHeaderExpanded()&&!this._bPinned;};
d.prototype._headerScrolledOut=function(){return this._getScrollPosition()>=this._getSnappingHeight();};
d.prototype._headerSnapAllowed=function(){return!this._preserveHeaderStateOnScroll()&&this.getHeaderExpanded()&&!this._bPinned;};
d.prototype._canSnapHeaderOnScroll=function(){var m=this._getMaxScrollPosition(),t=this._bMSBrowser?1:0;if(this._bHeaderInTitleArea){m+=this._getHeaderHeight();m-=t;}return m>this._getSnappingHeight();};
d.prototype._getSnappingHeight=function(){return Math.ceil(this._getHeaderHeight()||this._getTitleHeight());};
d.prototype._getMaxScrollPosition=function(){var $;if(e(this.$wrapper)){$=this.$wrapper[0];return $.scrollHeight-$.clientHeight;}return 0;};
d.prototype._needsVerticalScrollBar=function(){var t=this._bMSBrowser?1:0;return this._getMaxScrollPosition()>t;};
d.prototype._getOwnHeight=function(){return this._getHeight(this);};
d.prototype._getEntireHeaderHeight=function(){var t=0,H=0,o=this.getTitle(),f=this.getHeader();if(e(o)){t=o.$().outerHeight();}if(e(f)){H=f.$().outerHeight();}return t+H;};
d.prototype._headerBiggerThanAllowedToPin=function(i){if(!(typeof i==="number"&&!isNaN(parseInt(i,10)))){i=this._getOwnHeight();}return this._getEntireHeaderHeight()>d.HEADER_MAX_ALLOWED_PINNED_PERCENTAGE*i;};
d.prototype._headerBiggerThanAllowedToBeFixed=function(){var i=this._getOwnHeight();return this._getEntireHeaderHeight()>d.HEADER_MAX_ALLOWED_NON_SROLLABLE_PERCENTAGE*i;};
d.prototype._headerBiggerThanAllowedToBeExpandedInTitleArea=function(){var E=this._getEntireHeaderHeight(),i=this._getOwnHeight();if(i===0){return false;}return D.system.phone?E>=d.HEADER_MAX_ALLOWED_NON_SROLLABLE_ON_MOBILE*i:E>=i;};
d.prototype._measureScrollBarOffsetHeight=function(){var H=0,s=!this.getHeaderExpanded(),f=this._bHeaderInTitleArea;if(this._preserveHeaderStateOnScroll()||this._bPinned||(!s&&this._bHeaderInTitleArea)){H=this._getTitleAreaHeight();q.sap.log.debug("DynamicPage :: preserveHeaderState is enabled or header pinned :: title area height"+H,this);return H;}if(s||!e(this.getTitle())||!this._canSnapHeaderOnScroll()){H=this._getTitleHeight();q.sap.log.debug("DynamicPage :: header snapped :: title height "+H,this);return H;}this._snapHeader(true);H=this._getTitleHeight();if(!s){this._expandHeader(f);}q.sap.log.debug("DynamicPage :: snapped mode :: title height "+H,this);return H;};
d.prototype._updateScrollBar=function(){var s,f,n;if(!D.system.desktop||!e(this.$wrapper)){return;}s=this._getScrollBar();s.setContentSize(this._measureScrollBarOffsetHeight()+this.$wrapper[0].scrollHeight+"px");f=this._needsVerticalScrollBar();n=this.bHasScrollbar!==f;if(n){s.toggleStyleClass("sapUiHidden",!f);this.toggleStyleClass("sapFDynamicPageWithScroll",f);this.bHasScrollbar=f;}q.sap.delayedCall(0,this,this._updateFitContainer);q.sap.delayedCall(0,this,this._updateScrollBarOffset);};
d.prototype._updateFitContainer=function(n){var N=typeof n!=='undefined'?!n:!this._needsVerticalScrollBar(),f=this.getFitContent(),t=f||N;this.$contentFitContainer.toggleClass("sapFDynamicPageContentFitContainer",t);};
d.prototype._updateScrollBarOffset=function(){var s=sap.ui.getCore().getConfiguration().getRTL()?"left":"right",o=this._needsVerticalScrollBar()?q.sap.scrollbarSize().width+"px":0,f=this.getFooter();this.$titleArea.css("padding-"+s,o);if(e(f)){f.$().css(s,o);}};
d.prototype._updateHeaderARIAState=function(E){var o=this.getHeader();if(e(o)){o._updateARIAState(E);}};
d.prototype._updateTitleARIAState=function(E){var o=this.getTitle(),t=this.getToggleHeaderOnTitleClick();if(e(o)){o._updateARIAState(E,t);}};
d.prototype._updateARIAStates=function(E){this._updateHeaderARIAState(E);this._updateTitleARIAState(E);};
d.prototype._updateMedia=function(w){if(w===0){this._updateMediaStyle(d.MEDIA.INVISIBLE);}else if(w<=d.BREAK_POINTS.PHONE){this._updateMediaStyle(d.MEDIA.PHONE);}else if(w<=d.BREAK_POINTS.TABLET){this._updateMediaStyle(d.MEDIA.TABLET);}else{this._updateMediaStyle(d.MEDIA.DESKTOP);}};
d.prototype._updateMediaStyle=function(s){Object.keys(d.MEDIA).forEach(function(m){var E=s===d.MEDIA[m];this.toggleStyleClass(d.MEDIA[m],E);},this);};
d.prototype._toggleExpandVisualIndicator=function(t){var o=this.getTitle();if(e(o)){o._toggleExpandButton(t);}};
d.prototype._focusExpandVisualIndicator=function(){var o=this.getTitle();if(e(o)){o._focusExpandButton();}};
d.prototype._toggleCollapseVisualIndicator=function(t){var o=this.getHeader();if(e(o)){o._toggleCollapseButton(t);}};
d.prototype._focusCollapseVisualIndicator=function(){var o=this.getHeader();if(e(o)){o._focusCollapseButton();}};
d.prototype._updateToggleHeaderVisualIndicators=function(){var H,f,E,g=this._hasVisibleTitleAndHeader();if(!this.getToggleHeaderOnTitleClick()||!g){f=false;E=false;}else{H=this.getHeaderExpanded();f=H;E=!H;}this._toggleCollapseVisualIndicator(f);this._toggleExpandVisualIndicator(E);};
d.prototype._scrollBellowCollapseVisualIndicator=function(){var H=this.getHeader(),$,i,v,o;if(e(H)){$=this.getHeader()._getCollapseButton().getDomRef();i=$.getBoundingClientRect().height;v=this.$wrapper[0].getBoundingClientRect().height;o=$.offsetTop+i-v;this._setScrollPosition(o);}};
d.prototype._hasVisibleTitleAndHeader=function(){var t=this.getTitle(),H=this.getHeader();return e(t)&&t.getVisible()&&e(H)&&H.getVisible()&&e(H.getContent());};
d.prototype._getHeight=function(o){var $;if(!(o instanceof C)){return 0;}$=o.getDomRef();return $?$.getBoundingClientRect().height:0;};
d.prototype._getWidth=function(o){return!(o instanceof C)?0:o.$().outerWidth()||0;};
d.prototype._getTitleAreaHeight=function(){return e(this.$titleArea)?this.$titleArea.outerHeight()||0:0;};
d.prototype._getTitleHeight=function(){return this._getHeight(this.getTitle());};
d.prototype._getHeaderHeight=function(){return this._getHeight(this.getHeader());};
d.prototype._preserveHeaderStateOnScroll=function(){return this.getPreserveHeaderStateOnScroll()&&!this._headerBiggerThanAllowedHeight;};
d.prototype._getScrollBar=function(){if(!e(this.getAggregation("_scrollBar"))){var v=new S(this.getId()+"-vertSB",{vertical:true,size:"100%",scrollPosition:0,scroll:this._onScrollBarScroll.bind(this)});this.setAggregation("_scrollBar",v,true);}return this.getAggregation("_scrollBar");};
d.prototype._cacheDomElements=function(){var f=this.getFooter();if(e(f)){this.$footer=f.$();this.$footerWrapper=this.$("footerWrapper");}this.$wrapper=this.$("contentWrapper");this.$contentFitContainer=this.$("contentFitContainer");this.$titleArea=this.$("header");this._cacheTitleDom();};
d.prototype._cacheTitleDom=function(){var t=this.getTitle();if(e(t)){this.$title=t.$();}};
d.prototype._adjustSnap=function(){var o,i,f,I,$=this.$();if(!e($)){return;}if(!h($[0])){return;}o=this.getHeader();i=!this.getHeaderExpanded();if(!o||!i){return;}f=!this._preserveHeaderStateOnScroll()&&this._canSnapHeaderOnScroll();I=i&&o.$().hasClass("sapFDynamicPageHeaderHidden");if(f&&I){this._toggleHeaderVisibility(true);this._moveHeaderToContentArea(true);}else if(!f&&!I){this._moveHeaderToTitleArea(true);this._toggleHeaderVisibility(false);}};
d.prototype.ontouchmove=function(E){E.setMarked();};
d.prototype._onChildControlAfterRendering=function(E){if(E.srcControl instanceof b){this._cacheTitleDom();this._deRegisterResizeHandler(d.RESIZE_HANDLER_ID.TITLE);this._registerResizeHandler(d.RESIZE_HANDLER_ID.TITLE,this.$title[0],this._onChildControlsHeightChange.bind(this));}q.sap.delayedCall(0,this,this._updateScrollBar);};
d.prototype._onChildControlsHeightChange=function(){var n=this._needsVerticalScrollBar();if(n){this._updateFitContainer(n);}this._adjustSnap();if(!this._bExpandingWithAClick){this._updateScrollBar();}this._bExpandingWithAClick=false;};
d.prototype._onResize=function(E){var o=this.getTitle(),f=this.getHeader(),i=E.size.width;if(!this._preserveHeaderStateOnScroll()&&f){if(this._headerBiggerThanAllowedToPin(E.size.height)||D.system.phone){this._unPin();this._togglePinButtonVisibility(false);this._togglePinButtonPressedState(false);}else{this._togglePinButtonVisibility(true);}if(this._bHeaderInTitleArea&&this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._expandHeader(false);this._setScrollPosition(0);}}if(e(o)){o._onResize(i);}this._adjustSnap();this._updateScrollBar();this._updateMedia(i);};
d.prototype._onWrapperScroll=function(E){var s=Math.max(E.target.scrollTop,0);if(D.system.desktop){if(this.allowCustomScroll===true){this.allowCustomScroll=false;return;}this.allowInnerDiv=true;this._getScrollBar().setScrollPosition(s);this.toggleStyleClass("sapFDynamicPageWithScroll",this._needsVerticalScrollBar());}};
d.prototype._toggleHeaderOnScroll=function(){if(this._bSuppressToggleHeaderOnce){this._bSuppressToggleHeaderOnce=false;return;}if(D.system.desktop&&this._bExpandingWithAClick){return;}if(this._preserveHeaderStateOnScroll()){return;}if(this._shouldSnap()){this._snapHeader(true,true);}else if(this._shouldExpand()){this._expandHeader(false,true);this._toggleHeaderVisibility(true);}else if(!this._bPinned&&this._bHeaderInTitleArea){var f=(this._getScrollPosition()>=this._getSnappingHeight());this._moveHeaderToContentArea(f);}};
d.prototype._onScrollBarScroll=function(){if(this.allowInnerDiv===true){this.allowInnerDiv=false;return;}this.allowCustomScroll=true;this._setScrollPosition(this._getScrollBar().getScrollPosition());};
d.prototype._onTitlePress=function(){if(this.getToggleHeaderOnTitleClick()){this._titleExpandCollapseWhenAllowed(true);}};
d.prototype._onExpandHeaderVisualIndicatorPress=function(){this._onTitlePress();if(this._headerBiggerThanAllowedToBeExpandedInTitleArea()){this._scrollBellowCollapseVisualIndicator();}this._focusCollapseVisualIndicator();};
d.prototype._onCollapseHeaderVisualIndicatorPress=function(){this._onTitlePress();this._focusExpandVisualIndicator();};
d.prototype._onVisualIndicatorMouseOver=function(){var $=this.$();if(e($)){$.addClass("sapFDynamicPageTitleForceHovered");}};
d.prototype._onVisualIndicatorMouseOut=function(){var $=this.$();if(e($)){$.removeClass("sapFDynamicPageTitleForceHovered");}};
d.prototype._onTitleMouseOver=d.prototype._onVisualIndicatorMouseOver;d.prototype._onTitleMouseOut=d.prototype._onVisualIndicatorMouseOut;
d.prototype._titleExpandCollapseWhenAllowed=function(U){var A;if(this._bPinned&&!U){return this;}this._bSuppressToggleHeaderOnce=true;if(this._preserveHeaderStateOnScroll()||!this._canSnapHeaderOnScroll()||!this.getHeader()){if(!this.getHeaderExpanded()){this._expandHeader(false,U);this._toggleHeaderVisibility(true,U);}else{this._snapHeader(false,U);this._toggleHeaderVisibility(false,U);}}else if(!this.getHeaderExpanded()){A=!this._headerBiggerThanAllowedToBeExpandedInTitleArea();this._bExpandingWithAClick=true;this._expandHeader(A,U);this.getHeader().$().removeClass("sapFDynamicPageHeaderHidden");if(!A){this._setScrollPosition(0);}this._bExpandingWithAClick=false;}else{var m=this._bHeaderInTitleArea;this._snapHeader(m,U);if(!m){this._setScrollPosition(this._getSnappingHeight());}}q.sap.delayedCall(0,this,function(){this._bSuppressToggleHeaderOnce=false;}.bind(this));};
d.prototype._onPinUnpinButtonPress=function(){if(this._bPinned){this._unPin();}else{this._pin();this._restorePinButtonFocus();}};
d.prototype._attachResizeHandlers=function(){var f=this._onChildControlsHeightChange.bind(this);this._registerResizeHandler(d.RESIZE_HANDLER_ID.PAGE,this,this._onResize.bind(this));if(e(this.$title)){this._registerResizeHandler(d.RESIZE_HANDLER_ID.TITLE,this.$title[0],f);}if(e(this.$contentFitContainer)){this._registerResizeHandler(d.RESIZE_HANDLER_ID.CONTENT,this.$contentFitContainer[0],f);}};
d.prototype._registerResizeHandler=function(H,o,f){if(!this[H]){this[H]=R.register(o,f);}};
d.prototype._detachResizeHandlers=function(){this._deRegisterResizeHandler(d.RESIZE_HANDLER_ID.PAGE);this._deRegisterResizeHandler(d.RESIZE_HANDLER_ID.TITLE);this._deRegisterResizeHandler(d.RESIZE_HANDLER_ID.CONTENT);};
d.prototype._deRegisterResizeHandler=function(H){if(this[H]){R.deregister(this[H]);this[H]=null;}};
d.prototype._attachPageChildrenAfterRenderingDelegates=function(){var t=this.getTitle(),H=this.getHeader(),o=this.getContent(),p={onAfterRendering:this._onChildControlAfterRendering.bind(this)};if(e(t)){t.addEventDelegate(p);}if(e(o)){o.addEventDelegate(p);}if(e(H)){H.addEventDelegate(p);}};
d.prototype._attachTitlePressHandler=function(){var t=this.getTitle();if(e(t)&&!this._bAlreadyAttachedTitlePressHandler){t.attachEvent(d.EVENTS.TITLE_PRESS,this._onTitlePress,this);this._bAlreadyAttachedTitlePressHandler=true;}};
d.prototype._attachPinPressHandler=function(){var H=this.getHeader();if(e(H)&&!this._bAlreadyAttachedPinPressHandler){H.attachEvent(d.EVENTS.PIN_UNPIN_PRESS,this._onPinUnpinButtonPress,this);this._bAlreadyAttachedPinPressHandler=true;}};
d.prototype._attachVisualIndicatorsPressHandlers=function(){var t=this.getTitle(),H=this.getHeader();if(e(t)&&!this._bAlreadyAttachedTitleIndicatorPressHandler){t.attachEvent(d.EVENTS.TITLE_VISUAL_INDICATOR_PRESS,this._onExpandHeaderVisualIndicatorPress,this);this._bAlreadyAttachedTitleIndicatorPressHandler=true;}if(e(H)&&!this._bAlreadyAttachedHeaderIndicatorPressHandler){H.attachEvent(d.EVENTS.HEADER_VISUAL_INDICATOR_PRESS,this._onCollapseHeaderVisualIndicatorPress,this);this._bAlreadyAttachedHeaderIndicatorPressHandler=true;}};
d.prototype._attachVisualIndicatorMouseOverHandlers=function(){var H=this.getHeader();if(e(H)&&!this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler){H.attachEvent(d.EVENTS.VISUAL_INDICATOR_MOUSE_OVER,this._onVisualIndicatorMouseOver,this);H.attachEvent(d.EVENTS.VISUAL_INDICATOR_MOUSE_OUT,this._onVisualIndicatorMouseOut,this);this._bAlreadyAttachedVisualIndicatorMouseOverOutHandler=true;}};
d.prototype._attachTitleMouseOverHandlers=function(){var t=this.getTitle();if(e(t)&&!this._bAlreadyAttachedTitleMouseOverOutHandler){t.attachEvent(d.EVENTS.TITLE_MOUSE_OVER,this._onTitleMouseOver,this);t.attachEvent(d.EVENTS.TITLE_MOUSE_OUT,this._onTitleMouseOut,this);this._bAlreadyAttachedTitleMouseOverOutHandler=true;}};
d.prototype._attachScrollHandler=function(){this._onWrapperScrollReference=this._onWrapperScroll.bind(this);this._toggleHeaderOnScrollReference=this._toggleHeaderOnScroll.bind(this);this.$wrapper.on("scroll",this._onWrapperScrollReference);this.$wrapper.on("scroll",this._toggleHeaderOnScrollReference);};
d.prototype._detachScrollHandler=function(){if(this.$wrapper){this.$wrapper.off("scroll",this._onWrapperScrollReference);this.$wrapper.off("scroll",this._toggleHeaderOnScrollReference);}};
return d;});
sap.ui.predefine('sap/f/DynamicPageHeader',["./library","sap/ui/Device","sap/ui/core/Control","sap/m/ToggleButton","sap/m/Button","./DynamicPageHeaderRenderer"],function(l,D,C,T,B,a){"use strict";
var b=C.extend("sap.f.DynamicPageHeader",{metadata:{library:"sap.f",properties:{pinnable:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true},_pinButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_collapseButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},designtime:"sap/f/designtime/DynamicPageHeader.designtime"}});
b._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};
b.ARIA={ARIA_CONTROLS:"aria-controls",ARIA_EXPANDED:"aria-expanded",ARIA_LABEL:"aria-label",LABEL_EXPANDED:b._getResourceBundle().getText("EXPANDED_HEADER"),LABEL_COLLAPSED:b._getResourceBundle().getText("SNAPPED_HEADER"),LABEL_PINNED:b._getResourceBundle().getText("PIN_HEADER"),LABEL_UNPINNED:b._getResourceBundle().getText("UNPIN_HEADER"),TOOLTIP_COLLAPSE_BUTTON:b._getResourceBundle().getText("COLLAPSE_HEADER_BUTTON_TOOLTIP"),STATE_TRUE:"true",STATE_FALSE:"false"};
b.prototype.init=function(){this._bShowCollapseButton=true;};
b.prototype.onAfterRendering=function(){this._initARIAState();this._initPinButtonARIAState();};
b.prototype._togglePinButton=function(v){this._getPinButton().setPressed(v);};
b.prototype._setShowPinBtn=function(v){this._getPinButton().$().toggleClass("sapUiHidden",!v);};
b.prototype._pinUnpinFireEvent=function(){this.fireEvent("_pinUnpinPress");};
b.prototype._onCollapseButtonPress=function(){this.fireEvent("_headerVisualIndicatorPress");};
b.prototype._onCollapseButtonMouseOver=function(){this.fireEvent("_visualIndicatorMouseOver");};
b.prototype._onCollapseButtonMouseOut=function(){this.fireEvent("_visualIndicatorMouseOut");};
b.prototype._initARIAState=function(){var $=this.$();$.attr(b.ARIA.ARIA_EXPANDED,b.ARIA.STATE_TRUE);$.attr(b.ARIA.ARIA_LABEL,b.ARIA.LABEL_EXPANDED);};
b.prototype._initPinButtonARIAState=function(){var $;if(this.getPinnable()){$=this._getPinButtonJQueryRef();$.attr(b.ARIA.ARIA_CONTROLS,this.getId());}};
b.prototype._updateARIAState=function(e){var $=this.$();if(e){$.attr(b.ARIA.ARIA_EXPANDED,b.ARIA.STATE_TRUE);$.attr(b.ARIA.ARIA_LABEL,b.ARIA.LABEL_EXPANDED);}else{$.attr(b.ARIA.ARIA_EXPANDED,b.ARIA.STATE_FALSE);$.attr(b.ARIA.ARIA_LABEL,b.ARIA.LABEL_COLLAPSED);}};
b.prototype._updateARIAPinButtonState=function(p){var P=this._getPinButton();if(p){P.setTooltip(b.ARIA.LABEL_UNPINNED);}else{P.setTooltip(b.ARIA.LABEL_PINNED);}};
b.prototype._getPinButton=function(){if(!this.getAggregation("_pinButton")){var p=new T({id:this.getId()+"-pinBtn",icon:"sap-icon://pushpin-off",tooltip:b.ARIA.LABEL_PINNED,press:this._pinUnpinFireEvent.bind(this)}).addStyleClass("sapFDynamicPageHeaderPinButton");this.setAggregation("_pinButton",p,true);}return this.getAggregation("_pinButton");};
b.prototype._getCollapseButton=function(){if(!this.getAggregation("_collapseButton")){var c=new B({id:this.getId()+"-collapseBtn",icon:"sap-icon://slim-arrow-up",press:this._onCollapseButtonPress.bind(this),tooltip:b.ARIA.TOOLTIP_COLLAPSE_BUTTON}).addStyleClass("sapFDynamicPageToggleHeaderIndicator");c.onmouseover=this._onCollapseButtonMouseOver.bind(this);c.onmouseout=this._onCollapseButtonMouseOut.bind(this);this.setAggregation("_collapseButton",c,true);}return this.getAggregation("_collapseButton");};
b.prototype._toggleCollapseButton=function(t){this._setShowCollapseButton(t);this._getCollapseButton().$().toggleClass("sapUiHidden",!t);};
b.prototype._getShowCollapseButton=function(){return this._bShowCollapseButton;};
b.prototype._setShowCollapseButton=function(v){this._bShowCollapseButton=!!v;};
b.prototype._focusCollapseButton=function(){this._getCollapseButton().$().focus();};
b.prototype._focusPinButton=function(){this._getPinButtonJQueryRef().focus();};
b.prototype._getPinButtonJQueryRef=function(){return this._getPinButton().$();};
b.prototype._getState=function(){var c=this.getContent(),h=c.length>0,H=this.getPinnable()&&h&&!D.system.phone,p=this._getPinButton(),o=this._getCollapseButton();o.toggleStyleClass("sapUiHidden",!this._getShowCollapseButton());return{content:c,headerHasContent:h,headerPinnable:H,hasContent:c.length>0,pinButton:p,collapseButton:o};};
return b;});
sap.ui.predefine('sap/f/DynamicPageHeaderRenderer',[],function(){"use strict";var D={};
D.render=function(r,d){var o=d._getState();r.write("<header");r.writeControlData(d);r.writeAccessibilityState({role:"region"});r.addClass("sapContrastPlus");r.addClass("sapFDynamicPageHeader");if(o.headerHasContent){r.addClass("sapFDynamicPageHeaderWithContent");}if(o.headerPinnable){r.addClass("sapFDynamicPageHeaderPinnable");}r.writeClasses();r.write(">");this._renderHeaderContent(r,o);r.renderControl(o.collapseButton);if(o.headerPinnable){r.renderControl(o.pinButton);}r.write("</header>");};
D._renderHeaderContent=function(r,d){if(d.headerHasContent){r.write("<div");r.addClass("sapFDynamicPageHeaderContent");r.writeClasses();r.write(">");d.content.forEach(r.renderControl);r.write("</div>");}};
return D;},true);
sap.ui.predefine('sap/f/DynamicPageRenderer',["sap/ui/Device"],function(D){"use strict";var a={};
a.render=function(r,d){var o=d.getTitle(),b=d.getHeader(),c=d.getFooter(),e=d.getContent(),h=d.getHeaderExpanded(),H=b?b.getContent():[],f=H.length>0,s=d.getShowFooter(),p=d._preserveHeaderStateOnScroll();r.write("<article");r.writeControlData(d);r.addClass("sapFDynamicPage");if(d.getToggleHeaderOnTitleClick()){r.addClass("sapFDynamicPageTitleClickEnabled");}r.writeClasses();r.write(">");if(D.system.desktop){r.renderControl(d._getScrollBar().addStyleClass("sapFDynamicPageScrollBar"));}r.write("<header");r.writeAttributeEscaped("id",d.getId()+"-header");r.addClass("sapContrastPlus");r.addClass("sapFDynamicPageTitleWrapper");if(!h){r.addClass("sapFDynamicPageTitleSnapped");}if(!f){r.addClass("sapFDynamicPageTitleOnly");}r.writeClasses();r.write(">");r.renderControl(o);if(p){r.renderControl(b);}r.write("</header>");r.write("<div");r.writeAttributeEscaped("id",d.getId()+"-contentWrapper");r.addClass("sapFDynamicPageContentWrapper");r.writeClasses();r.write(">");if(!p){r.renderControl(b);}r.write("<div");r.writeAttributeEscaped("id",d.getId()+"-content");r.addClass("sapFDynamicPageContent");r.writeClasses();r.write(">");r.write("<div");r.writeAttributeEscaped("id",d.getId()+"-contentFitContainer");if(d.getFitContent()){r.addClass("sapFDynamicPageContentFitContainer");}if(c&&s){r.addClass("sapFDynamicPageContentFitContainerFooterVisible");}r.writeClasses();r.write(">");r.renderControl(e);a.renderFooterSpacer(r,d,c,s);r.write("</div>");r.write("</div>");r.write("</div>");a.renderFooter(r,d,c,s);r.write("</article>");};
a.renderFooter=function(r,d,o,s){if(o){r.write("<footer");r.writeAttributeEscaped("id",d.getId()+"-footerWrapper");r.addClass("sapContrast sapContrastPlus sapFDynamicPageFooter sapFFooter-CTX");if(!s){r.addClass("sapUiHidden");}r.writeClasses();r.write(">");o.addStyleClass("sapFDynamicPageActualFooterControl");r.renderControl(o);r.write("</footer>");}};
a.renderFooterSpacer=function(r,d,o,s){if(o){r.write("<div");r.writeAttributeEscaped("id",d.getId()+"-spacer");if(s){r.addClass("sapFDynamicPageContentWrapperSpacer");}r.writeClasses();r.write(">");r.write("</div>");}};
return a;},true);
sap.ui.predefine('sap/f/DynamicPageTitle',["./library","sap/ui/core/Control","sap/ui/base/ManagedObjectObserver","sap/m/library","sap/m/Toolbar","sap/m/ToolbarSeparator","sap/m/OverflowToolbar","sap/m/Button","sap/ui/core/InvisibleText","./DynamicPageTitleRenderer"],function(l,C,M,m,T,a,O,B,I,D){"use strict";var b=l.DynamicPageTitleArea,c=m.ToolbarStyle;var o=sap.ui.getCore();
var d=C.extend("sap.f.DynamicPageTitle",{metadata:{library:"sap.f",properties:{primaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:b.Begin},areaShrinkRatio:{type:"sap.f.DynamicPageTitleShrinkRatio",group:"Appearance",defaultValue:"1:1.6:1.6"}},aggregations:{heading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},snappedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},expandedHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null},actions:{type:"sap.ui.core.Control",multiple:true,singularName:"action"},navigationActions:{type:"sap.m.Button",multiple:true,singularName:"navigationAction"},content:{type:"sap.ui.core.Control",multiple:true},snappedContent:{type:"sap.ui.core.Control",multiple:true},expandedContent:{type:"sap.ui.core.Control",multiple:true},breadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false},_actionsToolbar:{type:"sap.m.OverflowToolbar",multiple:false,visibility:"hidden"},_navActionsToolbar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},_navActionsToolbarSeparator:{type:"sap.m.ToolbarSeparator",multiple:false,visibility:"hidden"},_expandButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},events:{stateChange:{parameters:{isExpanded:{type:"boolean"}}}},designtime:"sap/f/designtime/DynamicPageTitle.designtime"}});
function e(v){if(arguments.length===1){return v&&("length"in v)?v.length>0:!!v;}return Array.prototype.slice.call(arguments).every(function(f){return e(f);});}
d.NAV_ACTIONS_PLACEMENT_BREAK_POINT=1280;d.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS={headingAreaShrinkFactor:1.6,contentAreaShrinkFactor:1,actionsAreaShrinkFactor:1.6};d.TOGGLE_HEADER_TEXT_ID=I.getStaticId("sap.f","TOGGLE_HEADER");d.EXPANDED_HEADER_TEXT_ID=I.getStaticId("sap.f","EXPANDED_HEADER");d.COLLAPSED_HEADER_TEXT_ID=I.getStaticId("sap.f","SNAPPED_HEADER");
d._renderControl=function(f,g){var r;if(!g||!f){return;}r=o.createRenderManager();r.renderControl(g);r.flush(f);r.destroy();};
function i(f){return typeof f==="function";}
d.prototype.init=function(){this._bExpandedState=true;this._bShowExpandButton=false;this._bIsFocusable=true;this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);this._bNavigationActionsInTopArea=false;this._oRB=o.getLibraryResourceBundle("sap.f");this._oObserver=new M(d.prototype._observeChanges.bind(this));this._oObserver.observe(this,{aggregations:["content","_actionsToolbar"]});this._oRB=sap.ui.getCore().getLibraryResourceBundle("sap.f");};
d.prototype.onBeforeRendering=function(){this._getActionsToolbar();this._observeControl(this.getBreadcrumbs());};
d.prototype.onAfterRendering=function(){this._cacheDomElements();this._toggleState(this._bExpandedState);this._doNavigationActionsLayout();};
d.prototype.exit=function(){if(this._oObserver){this._oObserver.disconnect();this._oObserver=null;}};
d.prototype.setPrimaryArea=function(A){var s=this.getAreaShrinkRatio(),S=this._getShrinkFactorsObject(),f=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue();if(!this.getDomRef()){return this.setProperty("primaryArea",A,true);}if(s!==f){return this.setProperty("primaryArea",A,true);}if(A===b.Begin){this._setShrinkFactors(S.headingAreaShrinkFactor,S.contentAreaShrinkFactor,S.actionsAreaShrinkFactor);}else{this._setShrinkFactors(d.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor,d.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor,d.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor);}return this.setProperty("primaryArea",A,true);};
d.prototype.setAreaShrinkRatio=function(A){A=this.validateProperty("areaShrinkRatio",A);this.setProperty("areaShrinkRatio",A,true);var s=this._getShrinkFactorsObject();if(this.getPrimaryArea()===b.Middle){jQuery.sap.log.warning("DynamicPageTitle :: Property primaryArea is disregarded when areaShrinkRatio is set.",this);}if(s.headingAreaShrinkFactor>1&&s.contentAreaShrinkFactor>1&&s.actionsAreaShrinkFactor>1){jQuery.sap.log.warning("DynamicPageTitle :: One of the shrink factors should be set to 1.",this);}this._setShrinkFactors(s.headingAreaShrinkFactor,s.contentAreaShrinkFactor,s.actionsAreaShrinkFactor);return this;};
d.prototype.ontap=function(E){var s=E.srcControl;if(s===this||s===this.getAggregation("_actionsToolbar")||s===this.getAggregation("breadcrumbs")){this.fireEvent("_titlePress");}};
d.prototype.onmouseover=function(){this.fireEvent("_titleMouseOver");};
d.prototype.onmouseout=function(){this.fireEvent("_titleMouseOut");};
d.prototype.onsapspace=function(E){this.onsapenter(E);};
d.prototype.onsapenter=function(E){if(E.srcControl===this){this.fireEvent("_titlePress");}};
["addAction","insertAction","removeAction","indexOfAction","removeAllActions","destroyActions","getActions"].forEach(function(s){d.prototype[s]=function(f){var t=this._getActionsToolbar(),g=s.replace(/Actions?/,"Content"),S=true,r;if(s==="addAction"||s==="insertAction"){t[g].apply(t,arguments);this._preProcessAction(f,"actions");r=this;}else if(s==="removeAction"){this._postProcessAction(f);}else if(s==="removeAllActions"){this.getActions().forEach(this._postProcessAction,this);}else if(s==="destroyActions"){this.getActions().forEach(this._postProcessAction,this);t[g].apply(t,arguments);r=this;}else if(s==="getActions"){S=false;}r=r||t[g].apply(t,arguments);S&&this._updateSeparatorVisibility();return r;};});["addNavigationAction","insertNavigationAction","removeNavigationAction","indexOfNavigationAction","removeAllNavigationActions","destroyNavigationActions","getNavigationActions"].forEach(function(s){d.prototype[s]=function(f){var t=this._getNavigationActionsToolbar(),g=s.replace(/NavigationActions?/,"Content"),h=true,r;if(s==="addNavigationAction"||s==="insertNavigationAction"){t[g].apply(t,arguments);this._preProcessAction(f,"navigationActions");r=this;}else if(s==="removeNavigationAction"){this._postProcessAction(f);}else if(s==="removeAllNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);}else if(s==="destroyNavigationActions"){this.getNavigationActions().forEach(this._postProcessAction,this);t[g].apply(t,arguments);r=this;}else if(s==="getNavigationActions"){h=false;}r=r||t[g].apply(t,arguments);h&&this._updateTopAreaVisibility();return r;};});
d.prototype.clone=function(s,L,f){var t=C.prototype.clone.apply(this,arguments),g=true;if(f){g=!!f.cloneChildren;}if(!g){return t;}var h=function(A){if(!this.isBound(A)){var j=this.getMetadata().getAggregation(A);j.get(this).forEach(function(k){j.add(t,k.clone());},this);}}.bind(this);h("actions");h("navigationActions");return t;};
d.prototype._cacheDomElements=function(){this.$topNavigationActionsArea=this.$("topNavigationArea");this.$mainNavigationActionsArea=this.$("mainNavigationArea");this.$beginArea=this.$("left-inner");this.$middleArea=this.$("content");this.$snappedHeadingWrapper=this.$("snapped-heading-wrapper");this.$expandHeadingWrapper=this.$("expand-heading-wrapper");this.$snappedWrapper=this.$("snapped-wrapper");this.$expandWrapper=this.$("expand-wrapper");};
d.prototype._getActionsToolbar=function(){if(!this.getAggregation("_actionsToolbar")){this.setAggregation("_actionsToolbar",new O({id:this.getId()+"-_actionsToolbar",style:c.Clear}).addStyleClass("sapFDynamicPageTitleActionsBar"),true);}return this.getAggregation("_actionsToolbar");};
d.prototype._getNavigationActionsToolbar=function(){if(!this.getAggregation("_navActionsToolbar")){this.setAggregation("_navActionsToolbar",new T({id:this.getId()+"-navActionsToolbar",style:c.Clear}).addStyleClass("sapFDynamicPageTitleActionsBar"),true);}return this.getAggregation("_navActionsToolbar");};
d.prototype._getToolbarSeparator=function(){if(!this.getAggregation("_navActionsToolbarSeparator")){this.setAggregation("_navActionsToolbarSeparator",new a({id:this.getId()+"-separator"}),true);}return this.getAggregation("_navActionsToolbarSeparator");};
d.prototype._toggleFocusableState=function(f){var $=this.$();this._bIsFocusable=f;f?$.attr("tabindex",0):$.removeAttr("tabindex");};
d.prototype._preProcessAction=function(A,p){if(i(A._fnOriginalGetParent)){return;}this._observeControl(A);A._fnOriginalGetParent=A.getParent;A.getParent=this._fnActionSubstituteParentFunction;A._sOriginalParentAggregationName=A.sParentAggregationName;A.sParentAggregationName=p;};
d.prototype._postProcessAction=function(A){if(!i(A._fnOriginalGetParent)){return;}this._unobserveControl(A);A.getParent=A._fnOriginalGetParent;A._fnOriginalGetParent=null;A.sParentAggregationName=A._sOriginalParentAggregationName;A._sOriginalParentAggregationName=null;};
d.prototype._observeControl=function(f){this._oObserver.observe(f,{properties:["visible"]});};
d.prototype._unobserveControl=function(f){this._oObserver.unobserve(f,{properties:["visible"]});};
d.prototype._doNavigationActionsLayout=function(){var r,n,N;if(this.getNavigationActions().length===0){return;}N=this._getNavigationActionsToolbar();r=this._shouldRenderNavigationActionsInTopArea();if(r){n=this.$topNavigationActionsArea[0];}else{n=this.$mainNavigationActionsArea[0];}this._bNavigationActionsInTopArea=r;d._renderControl(n,N);this._updateSeparatorVisibility();};
d.prototype._updateTopAreaVisibility=function(f){var n=this._areNavigationActionsInTopArea(),N=this._shouldRenderNavigationActionsInTopArea(f),h=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible(),s=h||N,S=this.getNavigationActions().length>0&&(N^n);this._toggleTopAreaVisibility(s);if(S){this._toggleNavigationActionsPlacement(N);}else{this._updateSeparatorVisibility();}};
d.prototype._onResize=function(f){this._updateTopAreaVisibility(f);};
d.prototype._toggleNavigationActionsPlacement=function(s){this["_showNavigationActionsIn"+(s?"Top":"Main")+"Area"]();this._updateSeparatorVisibility();};
d.prototype._showNavigationActionsInTopArea=function(){var n=this._getNavigationActionsToolbar();if(this.$topNavigationActionsArea&&this.$topNavigationActionsArea.length>0){this.$topNavigationActionsArea.html(n.$());}this._bNavigationActionsInTopArea=true;};
d.prototype._showNavigationActionsInMainArea=function(){var n=this._getNavigationActionsToolbar();if(this.$mainNavigationActionsArea&&this.$mainNavigationActionsArea.length>0){this.$mainNavigationActionsArea.html(n.$());}this._bNavigationActionsInTopArea=false;};
d.prototype._areNavigationActionsInTopArea=function(){return this._bNavigationActionsInTopArea;};
d.prototype._updateSeparatorVisibility=function(){if(this.getDomRef()){this._getToolbarSeparator().toggleStyleClass("sapUiHidden",!this._shouldShowSeparator());}};
d.prototype._toggleTopAreaVisibility=function(s){if(this.getDomRef()){this.$("top").toggleClass("sapUiHidden",!s);}};
d.prototype._shouldShowSeparator=function(){var h,H;if(this._bNavigationActionsInTopArea){return false;}h=this._getVisibleActions().length>0;H=this._getVisibleNavigationActions().length>0;return h&&H;};
d.prototype._getVisibleActions=function(){return this.getActions().filter(function(A){return A.getVisible();});};
d.prototype._getVisibleNavigationActions=function(){return this.getNavigationActions().filter(function(A){return A.getVisible();});};
d.prototype._setShrinkFactors=function(h,f,A){this.$("left-inner").css("flex-shrink",h);this.$("content").css("flex-shrink",f);this.$("mainActions").css("flex-shrink",A);};
d.prototype._shouldRenderNavigationActionsInTopArea=function(f){var w,h,H;if(this.getNavigationActions().length===0){return false;}w=f?f:this._getWidth();h=this._getVisibleActions().length>0;H=this.getBreadcrumbs()&&this.getBreadcrumbs().getVisible();return w<d.NAV_ACTIONS_PLACEMENT_BREAK_POINT&&(H||h);};
d.prototype._toggleState=function(E,u){var f=this._bExpandedState;this._bExpandedState=E;if(e(this.getSnappedContent())){this.$snappedWrapper.toggleClass("sapUiHidden",E);this.$snappedWrapper.parent().toggleClass("sapFDynamicPageTitleMainSnapContentVisible",!E);}if(e(this.getSnappedHeading())){this.$snappedHeadingWrapper.toggleClass("sapUiHidden",E);}if(e(this.getExpandedContent())){this.$expandWrapper.toggleClass("sapUiHidden",!E);this.$expandWrapper.parent().toggleClass("sapFDynamicPageTitleMainExpandContentVisible",E);}if(e(this.getExpandedHeading())){this.$expandHeadingWrapper.toggleClass("sapUiHidden",!E);}if(u&&f!==E){this.fireEvent("stateChange",{isExpanded:E});}};
d.prototype._getExpandButton=function(){if(!this.getAggregation("_expandButton")){var E=new B({id:this.getId()+"-expandBtn",icon:"sap-icon://slim-arrow-down",press:this._onExpandButtonPress.bind(this),tooltip:this._oRB.getText("EXPAND_HEADER_BUTTON_TOOLTIP")}).addStyleClass("sapFDynamicPageToggleHeaderIndicator sapUiHidden");this.setAggregation("_expandButton",E,true);}return this.getAggregation("_expandButton");};
d.prototype._onExpandButtonPress=function(){this.fireEvent("_titleVisualIndicatorPress");};
d.prototype._toggleExpandButton=function(t){this._setShowExpandButton(t);this._getExpandButton().$().toggleClass("sapUiHidden",!t);};
d.prototype._getShowExpandButton=function(){return this._bShowExpandButton;};
d.prototype._setShowExpandButton=function(v){this._bShowExpandButton=!!v;};
d.prototype._focusExpandButton=function(){this._getExpandButton().$().focus();};
d.prototype._getWidth=function(){return this.$().outerWidth();};
d.prototype._getState=function(){var h=this.getActions().length>0,H=this.getNavigationActions().length>0,f=this.getContent(),s=this.getSnappedContent(),E=this.getExpandedContent(),g=E.length>0,j=s.length>0,S=this._getShrinkFactorsObject(),k=this._getExpandButton(),n=this.getBreadcrumbs(),p=n||H,q=!!(n&&!H),r=H&&!n,A=this.getMetadata().getProperty("areaShrinkRatio").getDefaultValue(),P=this.getParent(),t=i(P.getToggleHeaderOnTitleClick)?P.getToggleHeaderOnTitleClick():false;if(this.getAreaShrinkRatio()===A&&this.getPrimaryArea()===b.Middle){S.headingAreaShrinkFactor=d.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.headingAreaShrinkFactor;S.contentAreaShrinkFactor=d.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.contentAreaShrinkFactor;S.actionsAreaShrinkFactor=d.PRIMARY_AREA_MIDDLE_SHRINK_FACTORS.actionsAreaShrinkFactor;}k.toggleStyleClass("sapUiHidden",!this._getShowExpandButton());return{id:this.getId(),actionBar:this._getActionsToolbar(),navigationBar:this._getNavigationActionsToolbar(),hasActions:h,hasNavigationActions:H,content:f,hasContent:f.length>0,heading:this.getHeading(),snappedHeading:this.getSnappedHeading(),expandedHeading:this.getExpandedHeading(),expandButton:k,snappedContent:s,expandedContent:E,hasSnappedContent:j,hasExpandedContent:g,hasAdditionalContent:g||j,isSnapped:!this._bExpandedState,headingAreaShrinkFactor:S.headingAreaShrinkFactor,contentAreaShrinkFactor:S.contentAreaShrinkFactor,actionsAreaShrinkFactor:S.actionsAreaShrinkFactor,ariaLabelledByIDs:t?this._getARIALabelReferences(this._bExpandedState):"",breadcrumbs:this.getBreadcrumbs(),separator:this._getToolbarSeparator(),hasTopContent:p,hasOnlyBreadcrumbs:q,hasOnlyNavigationActions:r,contentAreaFlexBasis:this._sContentAreaFlexBasis,actionsAreaFlexBasis:this._sActionsAreaFlexBasis,isFocusable:this._bIsFocusable};};
d.prototype._getShrinkFactorsObject=function(){var r={},A=this.getAreaShrinkRatio().split(":");r.headingAreaShrinkFactor=parseFloat(A[0]);r.contentAreaShrinkFactor=parseFloat(A[1]);r.actionsAreaShrinkFactor=parseFloat(A[2]);return r;};
d.prototype._observeChanges=function(f){var g=f.object,s=f.name;if(g===this){if(s==="content"||s==="_actionsToolbar"){this._observeContentChanges(f);}}else if(s==="visible"){this._updateTopAreaVisibility();}};
d.prototype._observeContentChanges=function(f){var g=f.child,s=f.mutation;if(!(g instanceof O)){return;}if(s==="insert"){g.attachEvent("_contentSizeChange",this._onContentSizeChange,this);}else if(s==="remove"){g.detachEvent("_contentSizeChange",this._onContentSizeChange,this);this._setContentAreaFlexBasis(0,g.$().parent());}};
d.prototype._onContentSizeChange=function(E){var f=E.getParameter("contentSize");this._setContentAreaFlexBasis(f,E.getSource().$().parent());};
d.prototype._setContentAreaFlexBasis=function(f,$){var F,s;f=parseInt(f,10);F=f?f+"px":"auto";s=F!=="auto"?F:undefined;$.css({"flex-basis":F});if($.hasClass("sapFDynamicPageTitleMainContent")){this._sContentAreaFlexBasis=s;}else if($.hasClass("sapFDynamicPageTitleMainActions")){this._sActionsAreaFlexBasis=s;}};
d.prototype._updateARIAState=function(h,t){var A=t?this._getARIALabelReferences(h):"";this.$().attr("aria-labelledby",A);return this;};
d.prototype._getARIALabelReferences=function(h){var r="";r+=h?d.EXPANDED_HEADER_TEXT_ID:d.COLLAPSED_HEADER_TEXT_ID;r+=" "+d.TOGGLE_HEADER_TEXT_ID;return r;};
return d;});
sap.ui.predefine('sap/f/DynamicPageTitleRenderer',["./library"],function(l){"use strict";var D={};
D.render=function(r,d){var o=d._getState();r.write("<div");if(o.isFocusable){r.writeAttribute("tabindex",0);}r.writeControlData(d);r.writeAccessibilityState({role:"heading",level:2,labelledBy:o.ariaLabelledByIDs});r.addClass("sapFDynamicPageTitle");r.writeClasses();r.write(">");this._renderTopArea(r,o);this._renderMainArea(r,o);r.renderControl(o.expandButton);r.write("</div>");};
D._renderTopArea=function(r,d){if(d.hasTopContent){r.write("<div id="+d.id+"-top");r.addClass("sapFDynamicPageTitleTop");if(d.hasOnlyBreadcrumbs){r.addClass("sapFDynamicPageTitleTopBreadCrumbsOnly");}if(d.hasOnlyNavigationActions){r.addClass("sapFDynamicPageTitleTopNavActionsOnly");}r.writeClasses();r.write(">");this._renderTopBreadcrumbsArea(r,d);this._renderTopNavigationArea(r,d);r.write("</div>");}};
D._renderTopBreadcrumbsArea=function(r,d){if(d.breadcrumbs){r.write("<div");r.writeAttribute("id",d.id+"-breadcrumbs");r.addClass("sapFDynamicPageTitleTopLeft");r.writeClasses();r.write(">");r.renderControl(d.breadcrumbs);r.write("</div>");}};
D._renderTopNavigationArea=function(r,d){if(d.hasNavigationActions){r.write("<div");r.writeAttribute("id",d.id+"-topNavigationArea");r.addClass("sapFDynamicPageTitleTopRight");r.writeClasses();r.write(">");r.write("</div>");}};
D._renderMainArea=function(r,d){r.write("<div id="+d.id+"-main");r.addClass("sapFDynamicPageTitleMain");if(!d.hasContent){r.addClass("sapFDynamicPageTitleMainNoContent");}r.writeClasses();r.write(">");r.write("<div");r.addClass("sapFDynamicPageTitleMainInner");r.writeClasses();r.write(">");this._renderMainHeadingArea(r,d);this._renderMainContentArea(r,d);this._renderMainActionsArea(r,d);r.write("</div>");this._renderMainNavigationArea(r,d);r.write("</div>");};
D._renderMainHeadingArea=function(r,d){r.write("<div");r.writeAttribute("id",d.id+"-left-inner");r.addClass("sapFDynamicPageTitleMainHeading");r.writeClasses();r.addStyle("flex-shrink",d.headingAreaShrinkFactor);r.writeStyles();r.write(">");r.write("<div");r.addClass("sapFDynamicPageTitleHeading-CTX");r.addClass("sapFDynamicPageTitleMainHeadingInner");r.writeClasses();r.write(">");if(d.heading){r.renderControl(d.heading);}else{if(d.snappedHeading){D._renderSnappedHeading(r,d);}if(d.expandedHeading){D._renderExpandHeading(r,d);}}r.write("</div>");if(d.hasAdditionalContent){r.write("<div");r.addClass("sapFDynamicPageTitleMainHeadingSnappedExpandContent");r.writeClasses();r.write(">");if(d.hasSnappedContent){D._renderSnappedContent(r,d);}if(d.hasExpandedContent){D._renderExpandContent(r,d);}r.write("</div>");}r.write("</div>");};
D._renderMainContentArea=function(r,d){r.write("<div");r.writeAttributeEscaped("id",d.id+"-content");r.addClass("sapFDynamicPageTitleMainContent");r.addClass("sapFDynamicPageTitleContent-CTX");r.writeClasses();r.addStyle("flex-shrink",d.contentAreaShrinkFactor);if(d.contentAreaFlexBasis){r.addStyle("flex-basis",d.contentAreaFlexBasis);}r.writeStyles();r.write(">");d.content.forEach(r.renderControl);r.write("</div>");};
D._renderMainActionsArea=function(r,d){r.write("<div");r.writeAttribute("id",d.id+"-mainActions");r.addClass("sapFDynamicPageTitleMainActions");r.writeClasses();r.addStyle("flex-shrink",d.actionsAreaShrinkFactor);if(d.actionsAreaFlexBasis){r.addStyle("flex-basis",d.actionsAreaFlexBasis);}r.writeStyles();r.write(">");if(d.hasActions){r.renderControl(d.actionBar);}r.write("</div>");};
D._renderMainNavigationArea=function(r,d){if(d.hasNavigationActions){r.write("<div");r.writeAttribute("id",d.id+"-mainNavigationAreaWrapper");r.addClass("sapFDynamicPageTitleMainNavigationArea");r.writeClasses();r.write(">");r.renderControl(d.separator);r.write("<div");r.writeAttribute("id",d.id+"-mainNavigationArea");r.addClass("sapFDynamicPageTitleMainNavigationAreaInner");r.writeClasses();r.write(">");r.write("</div>");r.write("</div>");}};
D._renderExpandHeading=function(r,d){r.write("<div");r.writeAttribute("id",d.id+"-expand-heading-wrapper");r.writeClasses();r.write(">");r.renderControl(d.expandedHeading);r.write("</div>");};
D._renderSnappedHeading=function(r,d){r.write("<div");r.writeAttribute("id",d.id+"-snapped-heading-wrapper");if(!d.isSnapped){r.addClass("sapUiHidden");}r.writeClasses();r.write(">");r.renderControl(d.snappedHeading);r.write("</div>");};
D._renderExpandContent=function(r,d){r.write("<div");r.writeAttributeEscaped("id",d.id+"-expand-wrapper");r.writeClasses();r.write(">");d.expandedContent.forEach(r.renderControl);r.write("</div>");};
D._renderSnappedContent=function(r,d){r.write("<div");r.writeAttributeEscaped("id",d.id+"-snapped-wrapper");if(!d.isSnapped){r.addClass("sapUiHidden");}r.addClass("sapFDynamicPageTitleSnapped");r.writeClasses();r.write(">");d.snappedContent.forEach(r.renderControl);r.write("</div>");};
return D;},true);
sap.ui.predefine('sap/f/FlexibleColumnLayout',["jquery.sap.global","./library","sap/ui/Device","sap/ui/core/ResizeHandler","sap/ui/core/Control","sap/m/library","sap/m/Button","sap/m/NavContainer","sap/ui/core/Configuration","./FlexibleColumnLayoutRenderer","jquery.sap.events"],function(q,l,D,R,C,m,B,N,a,F){"use strict";var L=l.LayoutType;
var b=C.extend("sap.f.FlexibleColumnLayout",{metadata:{properties:{layout:{type:"sap.f.LayoutType",defaultValue:L.OneColumn},defaultTransitionNameBeginColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameMidColumn:{type:"string",group:"Appearance",defaultValue:"slide"},defaultTransitionNameEndColumn:{type:"string",group:"Appearance",defaultValue:"slide"},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:m.BackgroundDesign.Transparent}},aggregations:{beginColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getBeginColumn",aggregation:"pages"}},midColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getMidColumn",aggregation:"pages"}},endColumnPages:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getEndColumn",aggregation:"pages"}},_beginColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_midColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_endColumnNav:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"},_beginColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_midColumnBackArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"},_endColumnForwardArrow:{type:"sap.m.Button",multiple:false,visibility:"hidden"}},associations:{initialBeginColumnPage:{type:"sap.ui.core.Control",multiple:false},initialMidColumnPage:{type:"sap.ui.core.Control",multiple:false},initialEndColumnPage:{type:"sap.ui.core.Control",multiple:false}},events:{stateChange:{parameters:{layout:{type:"sap.f.LayoutType"},maxColumnsCount:{type:"int"},isNavigationArrow:{type:"boolean"},isResize:{type:"boolean"}}},beginColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterBeginColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},midColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterMidColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},endColumnNavigate:{allowPreventDefault:true,parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}},afterEndColumnNavigate:{parameters:{from:{type:"sap.ui.core.Control"},fromId:{type:"string"},to:{type:"sap.ui.core.Control"},toId:{type:"string"},firstTime:{type:"boolean"},isTo:{type:"boolean"},isBack:{type:"boolean"},isBackToTop:{type:"boolean"},isBackToPage:{type:"boolean"},direction:{type:"string"}}}}}});
b.COLUMN_RESIZING_ANIMATION_DURATION=560;
b.prototype.init=function(){this._initNavContainers();this._initButtons();this._oLayoutHistory=new c();};
b.prototype._createNavContainer=function(s){var d=s.charAt(0).toUpperCase()+s.slice(1);return new N(this.getId()+"-"+s+"ColumnNav",{navigate:function(e){this._handleNavigationEvent(e,false,s);}.bind(this),afterNavigate:function(e){this._handleNavigationEvent(e,true,s);}.bind(this),defaultTransitionName:this["getDefaultTransitionName"+d+"Column"]()});};
b.prototype._handleNavigationEvent=function(e,A,s){var E,d;if(A){E="after"+(s.charAt(0).toUpperCase()+s.slice(1))+"ColumnNavigate";}else{E=s+"ColumnNavigate";}d=this.fireEvent(E,e.mParameters,true);if(!d){e.preventDefault();}};
b.prototype._getBeginColumn=function(){return this.getAggregation("_beginColumnNav");};
b.prototype._getMidColumn=function(){return this.getAggregation("_midColumnNav");};
b.prototype._getEndColumn=function(){return this.getAggregation("_endColumnNav");};
b.prototype._flushColumnContent=function(s){var o=this.getAggregation("_"+s+"ColumnNav"),r=sap.ui.getCore().createRenderManager();r.renderControl(o);r.flush(this._$columns[s].find(".sapFFCLColumnContent")[0],undefined,true);r.destroy();};
b.prototype.setLayout=function(n){n=this.validateProperty("layout",n);var s=this.getLayout();if(s===n){return this;}var r=this.setProperty("layout",n,true);this._oLayoutHistory.addEntry(n);this._resizeColumns();this._hideShowArrows();return r;};
b.prototype.setBackgroundDesign=function(n){n=this.validateProperty("backgroundDesign",n);var s=this.getBackgroundDesign();if(s===n){return this;}var r=this.setProperty("backgroundDesign",n,true);if(s!==m.BackgroundDesign.Transparent){this.$().removeClass("sapFFCLBackgroundDesign"+s);}if(n!==m.BackgroundDesign.Transparent){this.$().addClass("sapFFCLBackgroundDesign"+n);}return r;};
b.prototype.onBeforeRendering=function(){this._deregisterResizeHandler();};
b.prototype.onAfterRendering=function(){this._registerResizeHandler();this._cacheDOMElements();this._hideShowArrows();this._resizeColumns();this._flushColumnContent("begin");this._flushColumnContent("mid");this._flushColumnContent("end");this._fireStateChange(false,false);};
b.prototype._getControlWidth=function(){return this.$().width();};
b.prototype.exit=function(){this._deregisterResizeHandler();this._handleEvent(q.Event("Destroy"));};
b.prototype._registerResizeHandler=function(){this._iResizeHandlerId=R.register(this,this._onResize.bind(this));};
b.prototype._deregisterResizeHandler=function(){if(this._iResizeHandlerId){R.deregister(this._iResizeHandlerId);this._iResizeHandlerId=null;}};
b.prototype._initNavContainers=function(){this.setAggregation("_beginColumnNav",this._createNavContainer("begin"),true);this.setAggregation("_midColumnNav",this._createNavContainer("mid"),true);this.setAggregation("_endColumnNav",this._createNavContainer("end"),true);};
b.prototype._initButtons=function(){var o=new B(this.getId()+"-beginBack",{icon:"sap-icon://slim-arrow-left",tooltip:b._getResourceBundle().getText("FCL_BEGIN_COLUMN_BACK_ARROW"),press:this._onArrowClick.bind(this,"left")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_beginColumnBackArrow",o,true);var M=new B(this.getId()+"-midForward",{icon:"sap-icon://slim-arrow-right",tooltip:b._getResourceBundle().getText("FCL_MID_COLUMN_FORWARD_ARROW"),press:this._onArrowClick.bind(this,"right")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_midColumnForwardArrow",M,true);var d=new B(this.getId()+"-midBack",{icon:"sap-icon://slim-arrow-left",tooltip:b._getResourceBundle().getText("FCL_MID_COLUMN_BACK_ARROW"),press:this._onArrowClick.bind(this,"left")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonRight");this.setAggregation("_midColumnBackArrow",d,true);var e=new B(this.getId()+"-endForward",{icon:"sap-icon://slim-arrow-right",tooltip:b._getResourceBundle().getText("FCL_END_COLUMN_FORWARD_ARROW"),press:this._onArrowClick.bind(this,"right")}).addStyleClass("sapFFCLNavigationButton").addStyleClass("sapFFCLNavigationButtonLeft");this.setAggregation("_endColumnForwardArrow",e,true);};
b.prototype._cacheDOMElements=function(){this._cacheColumns();if(!D.system.phone){this._cacheArrows();}};
b.prototype._cacheColumns=function(){this._$columns={begin:this.$("beginColumn"),mid:this.$("midColumn"),end:this.$("endColumn")};};
b.prototype._cacheArrows=function(){this._$columnButtons={beginBack:this.$("beginBack"),midForward:this.$("midForward"),midBack:this.$("midBack"),endForward:this.$("endForward")};};
b.prototype._getVisibleColumnsCount=function(){return["begin","mid","end"].filter(function(s){return this._getColumnSize(s)>0;},this).length;};
b.prototype._resizeColumns=function(){var p,n,s,t,A,d=false,e=["begin","mid","end"],r=sap.ui.getCore().getConfiguration().getRTL(),f,v;if(!this.isActive()){return;}v=this._getVisibleColumnsCount();if(v===0){return;}t=(v-1)*b.COLUMN_MARGIN;A=this._getControlWidth()-t;e.forEach(function(g){var o=this._$columns[g];p=this._getColumnSize(g);o.toggleClass("sapFFCLColumnMargin",d&&p>0);o.toggleClass("sapFFCLColumnActive",p>0);o.removeClass("sapFFCLColumnOnlyActive");o.removeClass("sapFFCLColumnLastActive");o.removeClass("sapFFCLColumnFirstActive");n=Math.round(A*(p/100));if([100,0].indexOf(p)!==-1){s=p+"%";}else{s=n+"px";}if(sap.ui.getCore().getConfiguration().getAnimationMode()!==a.AnimationMode.none){var h=o.get(0);R.suspend(h);if(o._iResumeResizeHandlerTimeout){clearTimeout(o._iResumeResizeHandlerTimeout);}o._iResumeResizeHandlerTimeout=setTimeout(function(){R.resume(h);o._iResumeResizeHandlerTimeout=null;},b.COLUMN_RESIZING_ANIMATION_DURATION);}o.width(s);if(!D.system.phone){this._updateColumnContextualSettings(g,n);this._updateColumnCSSClasses(g,n);}if(p>0){d=true;}},this);f=e.filter(function(g){return this._getColumnSize(g)>0;},this);if(r){e.reverse();}if(f.length===1){this._$columns[f[0]].addClass("sapFFCLColumnOnlyActive");}if(f.length>1){this._$columns[f[0]].addClass("sapFFCLColumnFirstActive");this._$columns[f[f.length-1]].addClass("sapFFCLColumnLastActive");}};
b.prototype._propagateContextualSettings=function(){};
b.prototype._updateColumnContextualSettings=function(s,w){var o,d;o=this.getAggregation("_"+s+"ColumnNav");if(!o){return;}d=o._getContextualSettings();if(!d||d.contextualWidth!==w){o._applyContextualSettings({contextualWidth:w});}};
b.prototype._updateColumnCSSClasses=function(s,w){var n="";this._$columns[s].removeClass("sapUiContainer-Narrow sapUiContainer-Medium sapUiContainer-Wide sapUiContainer-ExtraWide");if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[0]){n="Narrow";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[1]){n="Medium";}else if(w<D.media._predefinedRangeSets[D.media.RANGESETS.SAP_STANDARD_EXTENDED].points[2]){n="Wide";}else{n="ExtraWide";}this._$columns[s].addClass("sapUiContainer-"+n);};
b.prototype._getColumnSize=function(s){var d=this.getLayout(),e=this._getColumnWidthDistributionForLayout(d),S=e.split("/"),M={begin:0,mid:1,end:2},f=S[M[s]];return parseInt(f,10);};
b.prototype.getMaxColumnsCount=function(){return this._getMaxColumnsCountForWidth(this._getControlWidth());};
b.prototype._getMaxColumnsCountForWidth=function(w){if(w>=b.DESKTOP_BREAKPOINT){return 3;}if(w>=b.TABLET_BREAKPOINT&&w<b.DESKTOP_BREAKPOINT){return 2;}if(w>0){return 1;}return 0;};
b.prototype._onResize=function(e){var o=e.oldSize.width,n=e.size.width,O,M;if(n===0){return;}O=this._getMaxColumnsCountForWidth(o);M=this._getMaxColumnsCountForWidth(n);this._resizeColumns();if(M!==O){this._hideShowArrows();this._fireStateChange(false,true);}};
b.prototype._onArrowClick=function(s){var d=this.getLayout(),i=typeof b.SHIFT_TARGETS[d]!=="undefined"&&typeof b.SHIFT_TARGETS[d][s]!=="undefined",n;n=i?b.SHIFT_TARGETS[d][s]:L.OneColumn;this.setLayout(n);if(b.ARROWS_NAMES[n][s]!==b.ARROWS_NAMES[d][s]&&i){var o=s==='right'?'left':'right';this._$columnButtons[b.ARROWS_NAMES[n][o]].focus();}this._fireStateChange(true,false);};
b.prototype._hideShowArrows=function(){var s=this.getLayout(),M={},n=[],i;if(!this.isActive()||D.system.phone){return;}i=this.getMaxColumnsCount();if(i>1){M[L.TwoColumnsBeginExpanded]=["beginBack"];M[L.TwoColumnsMidExpanded]=["midForward"];M[L.ThreeColumnsMidExpanded]=["midForward","midBack"];M[L.ThreeColumnsEndExpanded]=["endForward"];M[L.ThreeColumnsMidExpandedEndHidden]=["midForward","midBack"];M[L.ThreeColumnsBeginExpandedEndHidden]=["beginBack"];if(typeof M[s]==="object"){n=M[s];}}this._toggleButton("beginBack",n.indexOf("beginBack")!==-1);this._toggleButton("midForward",n.indexOf("midForward")!==-1);this._toggleButton("midBack",n.indexOf("midBack")!==-1);this._toggleButton("endForward",n.indexOf("endForward")!==-1);};
b.prototype._toggleButton=function(s,S){this._$columnButtons[s].toggle(S);};
b.prototype._fireStateChange=function(i,I){if(this._getControlWidth()===0){return;}this.fireStateChange({isNavigationArrow:i,isResize:I,layout:this.getLayout(),maxColumnsCount:this.getMaxColumnsCount()});};
b.prototype.setInitialBeginColumnPage=function(p){this._getBeginColumn().setInitialPage(p);this.setAssociation('initialBeginColumnPage',p,true);return this;};
b.prototype.setInitialMidColumnPage=function(p){this._getMidColumn().setInitialPage(p);this.setAssociation('initialMidColumnPage',p,true);return this;};
b.prototype.setInitialEndColumnPage=function(p){this._getEndColumn().setInitialPage(p);this.setAssociation('initialEndColumnPage',p,true);return this;};
b.prototype.to=function(p,t,d,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().to(p,t,d,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().to(p,t,d,T);}else{this._getEndColumn().to(p,t,d,T);}return this;};
b.prototype.backToPage=function(p,o,t){if(this._getBeginColumn().getPage(p)){this._getBeginColumn().backToPage(p,o,t);}else if(this._getMidColumn().getPage(p)){this._getMidColumn().backToPage(p,o,t);}else{this._getEndColumn().backToPage(p,o,t);}return this;};
b.prototype._safeBackToPage=function(p,t,d,T){if(this._getBeginColumn().getPage(p)){this._getBeginColumn()._safeBackToPage(p,t,d,T);}else if(this._getMidColumn().getPage(p)){this._getMidColumn()._safeBackToPage(p,t,d,T);}else{this._getEndColumn()._safeBackToPage(p,t,d,T);}};
b.prototype.toBeginColumnPage=function(p,t,d,T){this._getBeginColumn().to(p,t,d,T);return this;};
b.prototype.toMidColumnPage=function(p,t,d,T){this._getMidColumn().to(p,t,d,T);return this;};
b.prototype.toEndColumnPage=function(p,t,d,T){this._getEndColumn().to(p,t,d,T);return this;};
b.prototype.backBeginColumn=function(d,t){return this._getBeginColumn().back(d,t);};
b.prototype.backMidColumn=function(d,t){return this._getMidColumn().back(d,t);};
b.prototype.backEndColumn=function(d,t){return this._getEndColumn().back(d,t);};
b.prototype.backBeginColumnToPage=function(p,d,t){return this._getBeginColumn().backToPage(p,d,t);};
b.prototype.backMidColumnToPage=function(p,d,t){return this._getMidColumn().backToPage(p,d,t);};
b.prototype.backEndColumnToPage=function(p,d,t){return this._getEndColumn().backToPage(p,d,t);};
b.prototype.backToTopBeginColumn=function(o,t){this._getBeginColumn().backToTop(o,t);return this;};
b.prototype.backToTopMidColumn=function(o,t){this._getMidColumn().backToTop(o,t);return this;};
b.prototype.backToTopEndColumn=function(o,t){this._getEndColumn().backToTop(o,t);return this;};
b.prototype.getCurrentBeginColumnPage=function(){return this._getBeginColumn().getCurrentPage();};
b.prototype.getCurrentMidColumnPage=function(){return this._getMidColumn().getCurrentPage();};
b.prototype.getCurrentEndColumnPage=function(){return this._getEndColumn().getCurrentPage();};
b.prototype.setDefaultTransitionNameBeginColumn=function(t){this.setProperty("defaultTransitionNameBeginColumn",t,true);this._getBeginColumn().setDefaultTransitionName(t);return this;};
b.prototype.setDefaultTransitionNameMidColumn=function(t){this.setProperty("defaultTransitionNameMidColumn",t,true);this._getMidColumn().setDefaultTransitionName(t);return this;};
b.prototype.setDefaultTransitionNameEndColumn=function(t){this.setProperty("defaultTransitionNameEndColumn",t,true);this._getEndColumn().setDefaultTransitionName(t);return this;};
b.prototype._getLayoutHistory=function(){return this._oLayoutHistory;};
b.prototype._getColumnWidthDistributionForLayout=function(s,A){var M=this.getMaxColumnsCount(),o={},r;if(M===0){r="0/0/0";}else{o[L.OneColumn]="100/0/0";o[L.MidColumnFullScreen]="0/100/0";o[L.EndColumnFullScreen]="0/0/100";if(M===1){o[L.TwoColumnsBeginExpanded]="0/100/0";o[L.TwoColumnsMidExpanded]="0/100/0";o[L.ThreeColumnsMidExpanded]="0/0/100";o[L.ThreeColumnsEndExpanded]="0/0/100";o[L.ThreeColumnsMidExpandedEndHidden]="0/0/100";o[L.ThreeColumnsBeginExpandedEndHidden]="0/0/100";}else{o[L.TwoColumnsBeginExpanded]="67/33/0";o[L.TwoColumnsMidExpanded]="33/67/0";o[L.ThreeColumnsMidExpanded]=M===2?"0/67/33":"25/50/25";o[L.ThreeColumnsEndExpanded]=M===2?"0/33/67":"25/25/50";o[L.ThreeColumnsMidExpandedEndHidden]="33/67/0";o[L.ThreeColumnsBeginExpandedEndHidden]="67/33/0";}r=o[s];}if(A){r=r.split("/").map(function(d){return parseInt(d,10);});}return r;};
b.COLUMN_MARGIN=8;b.DESKTOP_BREAKPOINT=1280;b.TABLET_BREAKPOINT=960;b.ARROWS_NAMES={TwoColumnsBeginExpanded:{"left":"beginBack"},TwoColumnsMidExpanded:{"right":"midForward"},ThreeColumnsMidExpanded:{"left":"midBack","right":"midForward"},ThreeColumnsEndExpanded:{"right":"endForward"},ThreeColumnsMidExpandedEndHidden:{"left":"midBack","right":"midForward"},ThreeColumnsBeginExpandedEndHidden:{"left":"beginBack"}};
b._getResourceBundle=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.f");};
b.SHIFT_TARGETS={TwoColumnsBeginExpanded:{"left":L.TwoColumnsMidExpanded},TwoColumnsMidExpanded:{"right":L.TwoColumnsBeginExpanded},ThreeColumnsMidExpanded:{"left":L.ThreeColumnsEndExpanded,"right":L.ThreeColumnsMidExpandedEndHidden},ThreeColumnsEndExpanded:{"right":L.ThreeColumnsMidExpanded},ThreeColumnsMidExpandedEndHidden:{"left":L.ThreeColumnsMidExpanded,"right":L.ThreeColumnsBeginExpandedEndHidden},ThreeColumnsBeginExpandedEndHidden:{"left":L.ThreeColumnsMidExpandedEndHidden}};
function c(){this._aLayoutHistory=[];}
c.prototype.addEntry=function(s){if(typeof s!=="undefined"){this._aLayoutHistory.push(s);}};
c.prototype.getClosestEntryThatMatches=function(d){var i;for(i=this._aLayoutHistory.length-1;i>=0;i--){if(d.indexOf(this._aLayoutHistory[i])!==-1){return this._aLayoutHistory[i];}}};
return b;});
sap.ui.predefine('sap/f/FlexibleColumnLayoutRenderer',["sap/ui/core/InvisibleText","sap/ui/Device","sap/m/library"],function(I,D,m){"use strict";var F={};
F.render=function(r,c){var b=c.getBackgroundDesign();r.write("<div");r.writeControlData(c);r.addClass("sapFFCL");if(b!==m.BackgroundDesign.Transparent){r.addClass("sapFFCLBackgroundDesign"+b);}r.writeClasses();r.write(">");F.renderBeginColumn(r,c);F.renderMidColumn(r,c);F.renderEndColumn(r,c);r.write("</div>");};
F.renderBeginColumn=function(r,c){var b=c.getAggregation("_beginColumnBackArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-beginColumn");r.writeAccessibilityState(c,{role:"region",labelledBy:I.getStaticId("sap.f","FCL_BEGIN_COLUMN_REGION_TEXT")});r.addClass("sapFFCLColumn").addClass("sapFFCLColumnBegin").addClass("sapFFCLColumnActive");r.writeClasses();r.writeStyles();r.write(">");F.renderColumnContentWrapper(r);F.renderArrow(r,b);r.write("</div>");};
F.renderMidColumn=function(r,c){var M=c.getAggregation("_midColumnForwardArrow"),o=c.getAggregation("_midColumnBackArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-midColumn");r.writeAccessibilityState(c,{role:"region",labelledBy:I.getStaticId("sap.f","FCL_MID_COLUMN_REGION_TEXT")});r.addClass("sapFFCLColumn").addClass("sapFFCLColumnMid");r.writeClasses();r.writeStyles();r.write(">");F.renderArrow(r,M);F.renderColumnContentWrapper(r);F.renderArrow(r,o);r.write("</div>");};
F.renderEndColumn=function(r,c){var e=c.getAggregation("_endColumnForwardArrow");r.write("<div");r.writeAttribute("id",c.getId()+"-endColumn");r.writeAccessibilityState(c,{role:"region",labelledBy:I.getStaticId("sap.f","FCL_END_COLUMN_REGION_TEXT")});r.addClass("sapFFCLColumn").addClass("sapFFCLColumnEnd");r.writeClasses();r.writeStyles();r.write(">");F.renderArrow(r,e);F.renderColumnContentWrapper(r);r.write("</div>");};
F.renderArrow=function(r,a){if(!D.system.phone){a.addStyleClass("sapContrastPlus");r.renderControl(a);}};
F.renderColumnContentWrapper=function(r){r.write("<div");r.addClass("sapFFCLColumnContent");r.writeClasses();r.write("></div>");};
return F;},true);
sap.ui.predefine('sap/f/FlexibleColumnLayoutSemanticHelper',["jquery.sap.global","./library","./FlexibleColumnLayout"],function(q,l,F){"use strict";var L=l.LayoutType;var a=function(f,s){var m={Normal:3,MasterDetail:2,SingleColumn:1},i,M;s||(s={});this._oFCL=f;this._defaultLayoutType=L.OneColumn;this._defaultTwoColumnLayoutType=[L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded].indexOf(s.defaultTwoColumnLayoutType)!==-1?s.defaultTwoColumnLayoutType:L.TwoColumnsBeginExpanded;this._defaultThreeColumnLayoutType=[L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded].indexOf(s.defaultThreeColumnLayoutType)!==-1?s.defaultThreeColumnLayoutType:L.ThreeColumnsMidExpanded;if(["Normal","MasterDetail","SingleColumn"].indexOf(s.mode)!==-1&&!s.maxColumnsCount){M=m[s.mode];}else{M=s.maxColumnsCount?parseInt(s.maxColumnsCount,10):3;if(M<1||M>3){M=3;}}this._maxColumnsCount=M;i=s.initialColumnsCount?parseInt(s.initialColumnsCount,10):1;if(i<1||i>2||this._maxColumnsCount===1){i=1;}this._initialColumnsCount=i;};a._oInstances={};
a.getInstanceFor=function(f,s){var i=f.getId();if(typeof a._oInstances[i]==="undefined"){a._oInstances[i]=new a(f,s);var d={onDestroy:function(){delete a._oInstances[i];}};f.addEventDelegate(d);}return a._oInstances[i];};
a.prototype.getCurrentUIState=function(){var c=this._oFCL.getLayout();return this._getUIStateForLayout(c);};
a.prototype.getNextUIState=function(n){var c=this._oFCL.getLayout(),i=this._initialColumnsCount,N;if(n===0){if(i===2&&this._canShowTwoColumns()){N=this._defaultTwoColumnLayoutType;}else{N=L.OneColumn;}}if(n===1){if(this._maxColumnsCount===1){N=L.MidColumnFullScreen;}else{if([L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded].indexOf(c)!==-1){N=c;}else if([L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(c)!==-1){N=L.MidColumnFullScreen;}else{N=this._defaultTwoColumnLayoutType;}}}if(n===2){if(this._maxColumnsCount<3){N=L.EndColumnFullScreen;}else{if([L.ThreeColumnsMidExpandedEndHidden,L.ThreeColumnsBeginExpandedEndHidden].indexOf(c)!==-1){N=this._defaultThreeColumnLayoutType;}else if([L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded].indexOf(c)!==-1){N=c;}else if([L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(c)!==-1){N=L.EndColumnFullScreen;}else{N=this._defaultThreeColumnLayoutType;}}}if(n>2){N=L.EndColumnFullScreen;}return this._getUIStateForLayout(N);};
a.prototype._getUIStateForLayout=function(s){var S=this._oFCL._getColumnWidthDistributionForLayout(s,true),c=S.join("/"),m=this._oFCL.getMaxColumnsCount();return{layout:s,maxColumnsCount:m,columnsSizes:this._getColumnsSizes(S),columnsVisibility:this._getColumnsVisibility(S),isFullScreen:this._getIsFullScreen(S),isLogicallyFullScreen:this._getIsLogicallyFullScreen(s),actionButtonsInfo:this._getActionButtonsInfo(c,m)};};
a.prototype._getColumnsSizes=function(s){return{beginColumn:s[0],midColumn:s[1],endColumn:s[2]};};
a.prototype._getColumnsVisibility=function(s){return{beginColumn:s[0]!==0,midColumn:s[1]!==0,endColumn:s[2]!==0};};
a.prototype._getIsFullScreen=function(s){return s.indexOf(100)!==-1;};
a.prototype._getIsLogicallyFullScreen=function(s){return[L.OneColumn,L.MidColumnFullScreen,L.EndColumnFullScreen].indexOf(s)!==-1;};
a.prototype._getActionButtonsInfo=function(c,m){var M={fullScreen:null,exitFullScreen:null,closeColumn:null},e={fullScreen:null,exitFullScreen:null,closeColumn:null},E,s;if(this._maxColumnsCount===1){return{midColumn:M,endColumn:e};}if(m===1){M.closeColumn=this._defaultLayoutType;e.closeColumn=this._defaultTwoColumnLayoutType;}else{if(c==="67/33/0"||c==="33/67/0"){M.fullScreen=L.MidColumnFullScreen;M.closeColumn=this._defaultLayoutType;}if(c==="25/50/25"||c==="25/25/50"||c==="0/67/33"){e.fullScreen=L.EndColumnFullScreen;e.closeColumn=this._defaultTwoColumnLayoutType;}if(c==="0/100/0"){E=[L.TwoColumnsBeginExpanded,L.TwoColumnsMidExpanded,L.ThreeColumnsBeginExpandedEndHidden,L.ThreeColumnsMidExpandedEndHidden];s=this._oFCL._getLayoutHistory().getClosestEntryThatMatches(E)||this._defaultTwoColumnLayoutType;M.exitFullScreen=s;M.closeColumn=this._defaultLayoutType;}if(c==="0/0/100"){if(this._maxColumnsCount!==2){E=[L.ThreeColumnsMidExpanded,L.ThreeColumnsEndExpanded];s=this._oFCL._getLayoutHistory().getClosestEntryThatMatches(E)||this._defaultThreeColumnLayoutType;e.exitFullScreen=s;e.closeColumn=this._defaultTwoColumnLayoutType;}}}return{midColumn:M,endColumn:e};};
a.prototype.getDefaultLayouts=function(){return{defaultLayoutType:this._defaultLayoutType,defaultTwoColumnLayoutType:this._defaultTwoColumnLayoutType,defaultThreeColumnLayoutType:this._defaultThreeColumnLayoutType};};
a.prototype._canShowTwoColumns=function(){var c=this._oFCL._getControlWidth(),m=this._oFCL._getMaxColumnsCountForWidth(c||window.innerWidth);return m>1;};
return a;},true);
sap.ui.predefine('sap/f/changeHandler/MoveDynamicPageTitleActions',["sap/ui/fl/Utils"],function(F){"use strict";var M={};var A="actions";
M.applyChange=function(c,C,p){var m=p.modifier,v=p.view,a=p.appComponent,o=c.getDefinition().content.movedElements[0];var b=m.bySelector(o.selector,a,v),t=o.targetIndex;m.getAggregation(C,A).forEach(function(B){if(m.getId(B)===m.getId(b)){m.removeAggregation(C,A,B);m.insertAggregation(C,"dependents",B,undefined,v);}});m.insertAggregation(C,A,b,t,v);return true;};
M.revertChange=function(c,C,p){var m=p.modifier,v=p.view,a=p.appComponent,o=c.getDefinition().content.movedElements[0];var b=m.bySelector(o.selector,a,v),t=o.targetIndex,s=o.sourceIndex;m.removeAggregation(C,A,b,t,v);m.insertAggregation(C,A,b,s,v);return true;};
M.completeChangeContent=function(c,s,p){var m=p.modifier,a=p.appComponent,C=c.getDefinition();C.content={movedElements:[]};s.movedElements.forEach(function(e){var E=e.element||m.bySelector(e.id,a);C.content.movedElements.push({selector:m.getSelector(E,a),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex});});};
return M;},true);
sap.ui.predefine('sap/f/flexibility/DynamicPageTitle.flexibility',["sap/m/changeHandler/CombineButtons","sap/m/changeHandler/SplitMenuButton","sap/f/changeHandler/MoveDynamicPageTitleActions"],function(C,S,M){"use strict";return{"hideControl":"default","unhideControl":"default","combineButtons":{"changeHandler":C,"layers":{"CUSTOMER":false}},"splitMenuButton":{"changeHandler":S,"layers":{"CUSTOMER":false}},"moveActions":{"changeHandler":M},"moveControls":"default"};},true);
sap.ui.predefine('sap/f/library',["sap/ui/base/DataType","sap/ui/Global","sap/ui/core/library","sap/m/library"],function(D){"use strict";sap.ui.getCore().initLibrary({name:"sap.f",version:"1.56.5",dependencies:["sap.ui.core","sap.m"],designtime:"sap/f/designtime/library.designtime",types:["sap.f.LayoutType","sap.f.DynamicPageTitleArea","sap.f.DynamicPageTitleShrinkRatio"],controls:["sap.f.Avatar","sap.f.DynamicPage","sap.f.DynamicPageHeader","sap.f.DynamicPageTitle","sap.f.FlexibleColumnLayout","sap.f.semantic.SemanticPage"],elements:["sap.f.semantic.AddAction","sap.f.semantic.CloseAction","sap.f.semantic.CopyAction","sap.f.semantic.DeleteAction","sap.f.semantic.DiscussInJamAction","sap.f.semantic.EditAction","sap.f.semantic.ExitFullScreenAction","sap.f.semantic.FavoriteAction","sap.f.semantic.FlagAction","sap.f.semantic.FooterMainAction","sap.f.semantic.FullScreenAction","sap.f.semantic.MessagesIndicator","sap.f.semantic.NegativeAction","sap.f.semantic.PositiveAction","sap.f.semantic.PrintAction","sap.f.semantic.SemanticButton","sap.f.semantic.SemanticControl","sap.f.semantic.SemanticToggleButton","sap.f.semantic.SendEmailAction","sap.f.semantic.SendMessageAction","sap.f.semantic.ShareInJamAction","sap.f.semantic.TitleMainAction"],extensions:{flChangeHandlers:{"sap.f.DynamicPageHeader":{"hideControl":"default","unhideControl":"default","moveControls":"default"},"sap.f.DynamicPageTitle":"sap/f/flexibility/DynamicPageTitle","sap.f.semantic.SemanticPage":{"moveControls":"default"}},"sap.ui.support":{internalRules:true}}});var t=sap.f;t.DynamicPageTitleArea={Begin:"Begin",Middle:"Middle"};t.DynamicPageTitleShrinkRatio=D.createType('sap.f.DynamicPageTitleShrinkRatio',{isValid:function(v){return/^(([0-9]\d*)(\.\d)?:([0-9]\d*)(\.\d)?:([0-9]\d*)(\.\d)?)$/.test(v);}},D.getType('string'));t.LayoutType={OneColumn:"OneColumn",TwoColumnsBeginExpanded:"TwoColumnsBeginExpanded",TwoColumnsMidExpanded:"TwoColumnsMidExpanded",MidColumnFullScreen:"MidColumnFullScreen",ThreeColumnsMidExpanded:"ThreeColumnsMidExpanded",ThreeColumnsEndExpanded:"ThreeColumnsEndExpanded",ThreeColumnsMidExpandedEndHidden:"ThreeColumnsMidExpandedEndHidden",ThreeColumnsBeginExpandedEndHidden:"ThreeColumnsBeginExpandedEndHidden",EndColumnFullScreen:"EndColumnFullScreen"};sap.ui.lazyRequire("sap.f.routing.Router");sap.ui.lazyRequire("sap.f.routing.Target");sap.ui.lazyRequire("sap.f.routing.TargetHandler");sap.ui.lazyRequire("sap.f.routing.Targets");t.AvatarShape={Circle:"Circle",Square:"Square"};t.AvatarSize={XS:"XS",S:"S",M:"M",L:"L",XL:"XL",Custom:"Custom"};t.AvatarType={Icon:"Icon",Image:"Image",Initials:"Initials"};t.AvatarImageFitType={Cover:"Cover",Contain:"Contain"};return t;});
sap.ui.predefine('sap/f/routing/Router',['sap/ui/core/routing/Router','./TargetHandler','./Targets'],function(R,T,a){"use strict";
var M=R.extend("sap.f.routing.Router",{
constructor:function(){this._oTargetHandler=new T();R.prototype.constructor.apply(this,arguments);},
destroy:function(){R.prototype.destroy.apply(this,arguments);this._oTargetHandler.destroy();this._oTargetHandler=null;},
getTargetHandler:function(){return this._oTargetHandler;},
_createTargets:function(c,t){return new a({views:this._oViews,config:c,targets:t,targetHandler:this._oTargetHandler});},
fireRouteMatched:function(A){var r=this.getRoute(A.name),t;if(r._oTarget){t=r._oTarget._oOptions;this._oTargetHandler.addNavigation({navigationIdentifier:A.name,transition:t.transition,transitionParameters:t.transitionParameters,eventData:A.arguments,targetControl:A.targetControl,view:A.view,layout:r._oConfig.layout});}return R.prototype.fireRouteMatched.apply(this,arguments);},
fireRoutePatternMatched:function(A){var r=A.name,v;if(this._oTargets&&this._oTargets._oLastDisplayedTarget){v=this._oTargets._getViewLevel(this._oTargets._oLastDisplayedTarget);}this._oTargetHandler.navigate({navigationIdentifier:r,viewLevel:v,askHistory:true});return R.prototype.fireRoutePatternMatched.apply(this,arguments);}
});
return M;});
sap.ui.predefine('sap/f/routing/Target',['sap/ui/core/routing/Target','sap/f/FlexibleColumnLayout','./async/Target'],function(T,F,a){"use strict";
var M=T.extend("sap.f.routing.Target",{
constructor:function(o,v,p,t){this._oTargetHandler=t;T.prototype.constructor.apply(this,arguments);var b=a;this._super={};for(var f in b){this._super[f]=this[f];this[f]=b[f];}},
_beforePlacingViewIntoContainer:function(A){var c=A.container;var r=A.data&&A.data.routeConfig;if(c instanceof F&&r&&r.layout){c.setLayout(r.layout);}T.prototype._beforePlacingViewIntoContainer.apply(this,arguments);}
});
return M;});
sap.ui.predefine('sap/f/routing/TargetHandler',['jquery.sap.global','sap/m/InstanceManager','sap/f/FlexibleColumnLayout','sap/ui/base/Object','sap/ui/core/routing/History'],function($,I,F,B,H){"use strict";
var T=B.extend("sap.f.routing.TargetHandler",{constructor:function(c){this._aQueue=[];this._oNavigationOrderPromise=Promise.resolve();if(c===undefined){this._bCloseDialogs=true;}else{this._bCloseDialogs=!!c;}}});
T.prototype.setCloseDialogs=function(c){this._bCloseDialogs=!!c;return this;};
T.prototype.getCloseDialogs=function(){return this._bCloseDialogs;};
T.prototype.addNavigation=function(p){this._aQueue.push(p);};
T.prototype.navigate=function(d){var r=this._createResultingNavigations(d.navigationIdentifier),c=false,b=this._getDirection(d),n;while(r.length){n=this._applyNavigationResult(r.shift().oParams,b);c=c||n;}if(c){this._closeDialogs();}};
T.prototype._chainNavigation=function(n){this._oNavigationOrderPromise=this._oNavigationOrderPromise.then(n);return this._oNavigationOrderPromise;};
T.prototype._getDirection=function(d){var t=d.viewLevel,h=H.getInstance(),b=false;if(d.direction==="Backwards"){b=true;}else if(isNaN(t)||isNaN(this._iCurrentViewLevel)||t===this._iCurrentViewLevel){if(d.askHistory){b=h.getDirection()==="Backwards";}}else{b=t<this._iCurrentViewLevel;}this._iCurrentViewLevel=t;return b;};
T.prototype._createResultingNavigations=function(n){var i,c,C,o,r=[],R;while(this._aQueue.length){c=this._aQueue.shift();C=c.targetControl;o={oContainer:C,oParams:c};for(i=0;i<r.length;i++){R=r[i];if(R.oContainer!==C){continue;}}r.push(o);}return r;};
T.prototype._applyNavigationResult=function(p,b){var t=p.targetControl,a=p.eventData,s=p.transition||"",o=p.transitionParameters,v=p.view.getId(),c,i=t instanceof F,S=false;if(i){c=[t.getCurrentBeginColumnPage(),t.getCurrentMidColumnPage(),t.getCurrentEndColumnPage()];S=c.some(function(C){return C&&C.getId()===v;});}if(S){$.sap.log.info("navigation to view with id: "+v+" is skipped since it already is displayed by its targetControl","sap.f.routing.TargetHandler");return false;}$.sap.log.info("navigation to view with id: "+v+" the targetControl is "+t.getId()+" backwards is "+b);if(b){t._safeBackToPage(v,s,a,o);}else{t.to(v,s,a,o);}return true;};
T.prototype._closeDialogs=function(){if(!this._bCloseDialogs){return;}if(I.hasOpenPopover()){I.closeAllPopovers();}if(I.hasOpenDialog()){I.closeAllDialogs();}if(I.hasOpenLightBox()){I.closeAllLightBoxes();}};
return T;});
sap.ui.predefine('sap/f/routing/Targets',['sap/ui/core/routing/Targets','./TargetHandler','./Target','./async/Targets'],function(T,a,b,c){"use strict";
var M=T.extend("sap.f.routing.Targets",{
constructor:function(o){o.config._async=true;if(o.targetHandler){this._oTargetHandler=o.targetHandler;}else{this._oTargetHandler=new a();this._bHasOwnTargetHandler=true;}T.prototype.constructor.apply(this,arguments);var d=c;this._super={};for(var f in d){this._super[f]=this[f];this[f]=d[f];}},
destroy:function(){T.prototype.destroy.apply(this,arguments);if(this._bHasOwnTargetHandler){this._oTargetHandler.destroy();}this._oTargetHandler=null;},
getTargetHandler:function(){return this._oTargetHandler;},
_constructTarget:function(o,p){return new b(o,this._oViews,p,this._oTargetHandler);},
_getViewLevel:function(t){var v;do{v=t._oOptions.viewLevel;if(v!==undefined){return v;}t=t._oParent;}while(t);return v;}
});
return M;});
sap.ui.predefine('sap/f/routing/async/Target',[],function(){"use strict";return{_place:function(d){var p=this._super._place.apply(this,arguments),r=d&&d.routeConfig||{},t=this;return this._oTargetHandler._chainNavigation(function(){return p.then(function(v){t._oTargetHandler.addNavigation({navigationIdentifier:t._oOptions.name,transition:t._oOptions.transition,transitionParameters:t._oOptions.transitionParameters,eventData:d,targetControl:v.control,view:v.view,layout:r.layout});return v;});});}};},true);
sap.ui.predefine('sap/f/routing/async/Targets',[],function(){"use strict";return{display:function(){var v,n;this._oLastDisplayedTarget=null;var p=this._super.display.apply(this,arguments);return p.then(function(V){if(this._oLastDisplayedTarget){v=this._getViewLevel(this._oLastDisplayedTarget);n=this._oLastDisplayedTarget._oOptions.name;}this._oTargetHandler.navigate({viewLevel:v,navigationIdentifier:n});return V;}.bind(this));},_displaySingleTarget:function(n){var t=this.getTarget(n);return this._super._displaySingleTarget.apply(this,arguments).then(function(v){if(t){this._oLastDisplayedTarget=t;}return v;}.bind(this));}};},true);
sap.ui.predefine('sap/f/semantic/AddAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var A=S.extend("sap.f.semantic.AddAction",{metadata:{library:"sap.f"}});
return A;});
sap.ui.predefine('sap/f/semantic/CloseAction',['./SemanticButton'],function(S){"use strict";
var C=S.extend("sap.f.semantic.CloseAction",{metadata:{library:"sap.f"}});
return C;});
sap.ui.predefine('sap/f/semantic/CopyAction',['./SemanticButton'],function(S){"use strict";
var C=S.extend("sap.f.semantic.CopyAction",{metadata:{library:"sap.f"}});
return C;});
sap.ui.predefine('sap/f/semantic/DeleteAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var D=S.extend("sap.f.semantic.DeleteAction",{metadata:{library:"sap.f"}});
return D;});
sap.ui.predefine('sap/f/semantic/DiscussInJamAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var D=S.extend("sap.f.semantic.DiscussInJamAction",{metadata:{library:"sap.f"}});
return D;});
sap.ui.predefine('sap/f/semantic/EditAction',['./SemanticButton'],function(S){"use strict";
var E=S.extend("sap.f.semantic.EditAction",{metadata:{library:"sap.f"}});
return E;});
sap.ui.predefine('sap/f/semantic/ExitFullScreenAction',['./SemanticButton'],function(S){"use strict";
var E=S.extend("sap.f.semantic.ExitFullScreenAction",{metadata:{library:"sap.f"}});
return E;});
sap.ui.predefine('sap/f/semantic/FavoriteAction',['./SemanticToggleButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FavoriteAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/FlagAction',['./SemanticToggleButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FlagAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/FooterMainAction',["./MainAction"],function(M){"use strict";
var F=M.extend("sap.f.semantic.FooterMainAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/FullScreenAction',['./SemanticButton'],function(S){"use strict";
var F=S.extend("sap.f.semantic.FullScreenAction",{metadata:{library:"sap.f"}});
return F;});
sap.ui.predefine('sap/f/semantic/MainAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var M=S.extend("sap.f.semantic.MainAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return M;});
sap.ui.predefine('sap/f/semantic/MessagesIndicator',['./SemanticButton'],function(S){"use strict";
var M=S.extend("sap.f.semantic.MessagesIndicator",{metadata:{library:"sap.f"}});
return M;});
sap.ui.predefine('sap/f/semantic/NegativeAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var N=S.extend("sap.f.semantic.NegativeAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return N;});
sap.ui.predefine('sap/f/semantic/PositiveAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var P=S.extend("sap.f.semantic.PositiveAction",{metadata:{library:"sap.f",properties:{text:{type:"string",group:"Misc",defaultValue:null}}}});
return P;});
sap.ui.predefine('sap/f/semantic/PrintAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var P=S.extend("sap.f.semantic.PrintAction",{metadata:{library:"sap.f"}});
return P;});
sap.ui.predefine('sap/f/semantic/SemanticButton',["./SemanticControl","sap/m/Button","sap/m/OverflowToolbarButton"],function(S,B,O){"use strict";
var a=S.extend("sap.f.semantic.SemanticButton",{metadata:{library:"sap.f","abstract":true,properties:{enabled:{type:"boolean",group:"Behavior",defaultValue:true}},events:{press:{}}}});
a.prototype._getControl=function(){var c=this.getAggregation('_control'),C=this._getConfiguration(),o,n;if(!C){return null;}if(!c){o=C&&C.constraints==="IconOnly"?O:B;n=this._createInstance(o);n.applySettings(C.getSettings());if(typeof C.getEventDelegates==="function"){n.addEventDelegate(C.getEventDelegates(n));}this.setAggregation('_control',n,true);c=this.getAggregation('_control');}return c;};
a.prototype._createInstance=function(c){return new c({id:this.getId()+"-button",press:jQuery.proxy(this.firePress,this)});};
return a;});
sap.ui.predefine('sap/f/semantic/SemanticConfiguration',["sap/ui/base/Metadata","sap/ui/core/IconPool","sap/m/library","sap/m/OverflowToolbarLayoutData"],function(M,I,m,O){"use strict";var a=m.OverflowToolbarPriority;var B=m.ButtonType;var S=M.createClass("sap.f.semantic.SemanticConfiguration",{});S._Placement={titleText:"titleText",titleIcon:"titleIcon",footerLeft:"footerLeft",footerRight:"footerRight",shareMenu:"shareMenu"};
S.isKnownSemanticType=function(t){return S.getConfiguration(t)!==null;};
S.getConfiguration=function(t){return S._oTypeConfigs[t]||null;};
S.getSettings=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].getSettings();}return null;};
S.getConstraints=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].constraints||null;}return null;};
S.getPlacement=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].placement;}return null;};
S.getOrder=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].order;}return null;};
S.shouldBePreprocessed=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].needPreprocesing||false;}return false;};
S.isMainAction=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].mainAction||false;}return false;};
S.isNavigationAction=function(t){if(S.isKnownSemanticType(t)){return S._oTypeConfigs[t].navigation||false;}return false;};
S._oTypeConfigs=(function(){var t={},b=sap.ui.getCore().getLibraryResourceBundle("sap.f");t["sap.f.semantic.TitleMainAction"]={placement:S._Placement.titleText,order:0,mainAction:true,getSettings:function(){return{type:B.Emphasized,layoutData:new O({priority:a.NeverOverflow})};}};t["sap.f.semantic.EditAction"]={placement:S._Placement.titleText,order:1,getSettings:function(){return{text:b.getText("SEMANTIC_CONTROL_EDIT"),tooltip:b.getText("SEMANTIC_CONTROL_EDIT"),type:B.Transparent};}};t["sap.f.semantic.DeleteAction"]={placement:S._Placement.titleText,order:2,getSettings:function(){return{text:b.getText("SEMANTIC_CONTROL_DELETE"),type:B.Transparent};}};t["sap.f.semantic.CopyAction"]={placement:S._Placement.titleText,order:3,getSettings:function(){return{text:b.getText("SEMANTIC_CONTROL_COPY"),type:B.Transparent};}};t["sap.f.semantic.AddAction"]={placement:S._Placement.titleText,order:4,getSettings:function(){return{text:b.getText("SEMANTIC_CONTROL_ADD"),tooltip:b.getText("SEMANTIC_CONTROL_ADD"),type:B.Transparent};}};t["sap.f.semantic.FavoriteAction"]={placement:S._Placement.titleIcon,order:0,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("favorite"),text:b.getText("SEMANTIC_CONTROL_FAVORITE"),type:B.Transparent};}};t["sap.f.semantic.FlagAction"]={placement:S._Placement.titleIcon,order:1,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("flag"),text:b.getText("SEMANTIC_CONTROL_FLAG"),type:B.Transparent};}};t["sap.f.semantic.FullScreenAction"]={placement:S._Placement.titleIcon,order:0,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("full-screen"),tooltip:b.getText("SEMANTIC_CONTROL_FULL_SCREEN"),layoutData:new O({priority:a.NeverOverflow}),type:B.Transparent};}};t["sap.f.semantic.ExitFullScreenAction"]={placement:S._Placement.titleIcon,order:1,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("exit-full-screen"),tooltip:b.getText("SEMANTIC_CONTROL_EXIT_FULL_SCREEN"),layoutData:new O({priority:a.NeverOverflow}),type:B.Transparent};}};t["sap.f.semantic.CloseAction"]={placement:S._Placement.titleIcon,order:2,constraints:"IconOnly",navigation:true,getSettings:function(){return{icon:I.getIconURI("decline"),tooltip:b.getText("SEMANTIC_CONTROL_CLOSE"),layoutData:new O({priority:a.NeverOverflow}),type:B.Transparent};}};t["sap.f.semantic.MessagesIndicator"]={placement:S._Placement.footerLeft,order:0,mainAction:false,getSettings:function(){return{icon:I.getIconURI("message-popup"),text:{path:"message>/",formatter:function(c){return c.length||0;}},tooltip:b.getText("SEMANTIC_CONTROL_MESSAGES_INDICATOR"),type:B.Emphasized,visible:{path:"message>/",formatter:function(c){return c&&c.length>0;}},models:{message:sap.ui.getCore().getMessageManager().getMessageModel()},layoutData:new O({priority:a.NeverOverflow})};}};t["sap.m.DraftIndicator"]={placement:S._Placement.footerRight,order:0,needPreprocesing:true,mainAction:false,getSettings:function(){return{layoutData:new O({shrinkable:false})};}};t["sap.f.semantic.FooterMainAction"]={placement:S._Placement.footerRight,order:1,mainAction:true,getSettings:function(){return{type:B.Emphasized,text:b.getText("SEMANTIC_CONTROL_SAVE"),layoutData:new O({priority:a.NeverOverflow})};}};t["sap.f.semantic.PositiveAction"]={placement:S._Placement.footerRight,order:2,mainAction:false,getSettings:function(){return{type:B.Accept,text:b.getText("SEMANTIC_CONTROL_ACCEPT"),layoutData:new O({priority:a.NeverOverflow})};}};t["sap.f.semantic.NegativeAction"]={placement:S._Placement.footerRight,order:3,mainAction:false,getSettings:function(){return{type:B.Reject,text:b.getText("SEMANTIC_CONTROL_REJECT"),layoutData:new O({priority:a.NeverOverflow})};}};t["sap.f.semantic.SendEmailAction"]={placement:S._Placement.shareMenu,order:0,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("email"),text:b.getText("SEMANTIC_CONTROL_SEND_EMAIL"),type:B.Transparent};}};t["sap.f.semantic.DiscussInJamAction"]={placement:S._Placement.shareMenu,order:1,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("discussion-2"),text:b.getText("SEMANTIC_CONTROL_DISCUSS_IN_JAM"),type:B.Transparent};}};t["sap.f.semantic.ShareInJamAction"]={placement:S._Placement.shareMenu,order:2,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("share-2"),text:b.getText("SEMANTIC_CONTROL_SHARE_IN_JAM"),type:B.Transparent};}};t["sap.f.semantic.SendMessageAction"]={placement:S._Placement.shareMenu,order:3,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("discussion"),text:b.getText("SEMANTIC_CONTROL_SEND_MESSAGE"),type:B.Transparent};}};t["saveAsTileAction"]={placement:S._Placement.shareMenu,order:4,constraints:"IconOnly"};t["sap.f.semantic.PrintAction"]={placement:S._Placement.shareMenu,order:5,constraints:"IconOnly",getSettings:function(){return{icon:I.getIconURI("print"),text:b.getText("SEMANTIC_CONTROL_PRINT"),type:B.Transparent};}};return t;})();return S;},false);
sap.ui.predefine('sap/f/semantic/SemanticContainer',["jquery.sap.global","sap/ui/base/Metadata","./SemanticConfiguration"],function(q,M,S){"use strict";var a=M.createClass("sap.f.semantic.SemanticContainer",{constructor:function(c,p){if(!c){q.sap.log.error("SemanticContainer :: missing argument - container reference",this);return;}this._oContainer=c;this._oParent=p;}});
a.prototype._getContainer=function(){return this._oContainer;};
a.prototype._getParent=function(){return this._oParent;};
a.prototype._shouldBePreprocessed=function(c){var t=(c._getType&&c._getType())||c.getMetadata().getName();return S.shouldBePreprocessed(t);};
a.prototype._getControlOrder=function(c){var t=(c._getType&&c._getType())||c.getMetadata().getName();return S.getOrder(t);};
a.prototype._getConstraints=function(c){return S.getConstraints(c.getMetadata().getName());};
a.prototype._getControl=function(c){return c._getControl?c._getControl():c;};
a.prototype._isMainAction=function(c){return S.isMainAction(c.getMetadata().getName());};
a.prototype._isNavigationAction=function(c){return S.isNavigationAction(c.getMetadata().getName());};
a.prototype._callContainerAggregationMethod=function(m){return this._getContainer()[m].apply(this._getContainer(),Array.prototype.slice.call(arguments).slice(1));};
a.prototype._sortControlByOrder=function(c,C){return this._getControlOrder(c)-this._getControlOrder(C);};
a.prototype.destroy=function(){this._oParent=null;this._oContainer=null;};
return a;},false);
sap.ui.predefine('sap/f/semantic/SemanticControl',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/core/Element","./SemanticConfiguration"],function(q,M,E,S){"use strict";
var a=E.extend("sap.f.semantic.SemanticControl",{metadata:{library:"sap.f","abstract":true,properties:{visible:{type:"boolean",group:"Appearance",defaultValue:true}},aggregations:{_control:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"}}}});
a.prototype.setProperty=function(k,v,s){M.prototype.setProperty.call(this,k,v,true);this._applyProperty(k,v,s);return this;};
a.prototype.updateAggregation=function(n){this._getControl().updateAggregation(n);};
a.prototype.refreshAggregation=function(n){this._getControl().refreshAggregation(n);};
a.prototype.setAggregation=function(A,o,s){if(A==='_control'){return M.prototype.setAggregation.call(this,A,o,s);}return this._getControl().setAggregation(A,o,s);};
a.prototype.getAggregation=function(A,d){if(A==='_control'){return M.prototype.getAggregation.call(this,A,d);}return this._getControl().getAggregation(A,d);};
a.prototype.indexOfAggregation=function(A,o){return this._getControl().indexOfAggregation(A,o);};
a.prototype.insertAggregation=function(A,o,i,s){return this._getControl().insertAggregation(A,o,i,s);};
a.prototype.addAggregation=function(A,o,s){return this._getControl().addAggregation(A,o,s);};
a.prototype.removeAggregation=function(A,o,s){return this._getControl().removeAggregation(A,o,s);};
a.prototype.removeAllAggregation=function(A,s){return this._getControl().removeAllAggregation(A,s);};
a.prototype.destroyAggregation=function(A,s){return this._getControl().destroyAggregation(A,s);};
a.prototype.bindAggregation=function(n,b){return this._getControl().bindAggregation(n,b);};
a.prototype.unbindAggregation=function(n,s){return this._getControl().unbindAggregation(n,s);};
a.prototype.clone=function(i,l){var C=E.prototype.clone.apply(this,arguments);var p=this._getControl().clone(i,l);C.setAggregation('_control',p);return C;};
a.prototype.destroy=function(){var r=E.prototype.destroy.apply(this,arguments);if(this.getAggregation("_control")){this.getAggregation("_control").destroy();}return r;};
a.prototype.getDomRef=function(s){return this._getControl().getDomRef(s);};
a.prototype.addEventDelegate=function(d,t){q.each(d,function(e,C){if(typeof C==='function'){d[e]=function(o){o.srcControl=this;C.call(t,o);}.bind(this);}}.bind(this));this._getControl().addEventDelegate(d,t);return this;};
a.prototype.removeEventDelegate=function(d){this._getControl().removeEventDelegate(d);return this;};
a.prototype._getConfiguration=function(){return S.getConfiguration(this.getMetadata().getName());};
a.prototype._applyProperty=function(k,v,s){var C=this._getControl(),b;if(C){b="set"+c(k);this._getControl()[b](v,s);}};
function c(n){return n.charAt(0).toUpperCase()+n.slice(1);}
return a;});
sap.ui.predefine('sap/f/semantic/SemanticFooter',["sap/m/ToolbarSpacer","sap/m/library","./SemanticContainer"],function(T,m,S){"use strict";var B=m.ButtonType;
var a=S.extend("sap.f.semantic.SemanticFooter",{constructor:function(c,p){S.call(this,c,p);this._aCustomContent=[];this._aSemanticLeftContent=[];this._aSemanticRightContent=[];this._iSemanticLeftContentCount=1;this._fnParentSubstitute=function(){return this._oParent;}.bind(this);this._insertSpacer();}});
a.mPlacementMethodMap={footerLeft:"LeftContent",footerRight:"RightContent"};
a.prototype.addCustomAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("addContent",c);this._aCustomContent.push(c);return this;};
a.prototype.insertCustomAction=function(c,i){var C=this._getCustomContentInsertIndex(i);c.setType(B.Transparent);this._callContainerAggregationMethod("insertContent",c,C);this._aCustomContent.splice(i,0,c);return this;};
a.prototype.getCustomActions=function(){return this._aCustomContent;};
a.prototype.indexOfCustomAction=function(c){return this._aCustomContent.indexOf(c);};
a.prototype.removeCustomAction=function(c){var r=this._callContainerAggregationMethod("removeContent",c);this._aCustomContent.splice(this._aCustomContent.indexOf(c),1);return r;};
a.prototype.removeAllCustomActions=function(){var r=[];this._aCustomContent.forEach(function(c){var R=this._callContainerAggregationMethod("removeContent",c);if(R){r.push(c);}},this);this._aCustomContent=[];return r;};
a.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(c){c.destroy();});return this;};
a.prototype.addContent=function(s,p){this["_insertSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.removeContent=function(s,p){this["_removeSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.destroy=function(){this._aCustomContent=null;this._aSemanticLeftContent=null;this._aSemanticRightContent=null;this._oSpacer=null;return S.prototype.destroy.call(this);};
a.prototype._insertSemanticLeftContent=function(s){var c=this._getControl(s),C=this._getControlOrder(s),i=this._getSemanticLeftContentInsertIndex(C);this._callContainerAggregationMethod("insertContent",c,i);this._iSemanticLeftContentCount++;this._aSemanticLeftContent.push(s);return this;};
a.prototype._insertSemanticRightContent=function(s){var c=this._getControl(s);this._aSemanticRightContent.push(s);this._callContainerAggregationMethod("insertContent",c,this._getSemanticRightContentInsertIndex(s));if(this._shouldBePreprocessed(s)){this._preProcessControl(c);}return this;};
a.prototype._removeSemanticLeftContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeContent",c);this._iSemanticLeftContentCount--;this._aSemanticLeftContent.splice(this._aSemanticLeftContent.indexOf(c),1);return s;};
a.prototype._removeSemanticRightContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeContent",c);this._aSemanticRightContent.splice(this._aSemanticRightContent.indexOf(s),1);this._postProcessControl(c);return s;};
a.prototype._getSemanticLeftContentInsertIndex=function(c){return this._iSemanticLeftContentCount>1?c:0;};
a.prototype._getSemanticRightContentInsertIndex=function(s){this._aSemanticRightContent.sort(this._sortControlByOrder.bind(this));return this._iSemanticLeftContentCount+this._aSemanticRightContent.indexOf(s);};
a.prototype._getCustomContentInsertIndex=function(i){return i+this._iSemanticLeftContentCount+this._aSemanticRightContent.length;};
a.prototype._insertSpacer=function(){this._callContainerAggregationMethod("addContent",this._getSpacer());return this;};
a.prototype._getSpacer=function(){if(!this._oSpacer){this._oSpacer=new T();}return this._oSpacer;};
a.prototype._preProcessControl=function(c){if(!(typeof c._fnOriginalGetParent==="function")){c._fnOriginalGetParent=c.getParent;c.getParent=this._fnParentSubstitute;}};
a.prototype._postProcessControl=function(c){if(c._fnOriginalGetParent){c.getParent=c._fnOriginalGetParent;delete c._fnOriginalGetParent;}};
return a;});
sap.ui.predefine('sap/f/semantic/SemanticPage',["sap/ui/core/Control","sap/ui/base/ManagedObject","sap/f/library","sap/f/DynamicPage","sap/f/DynamicPageTitle","sap/f/DynamicPageHeader","sap/m/OverflowToolbar","sap/m/ActionSheet","./SemanticTitle","./SemanticFooter","./SemanticShareMenu","./SemanticConfiguration","./SemanticPageRenderer"],function(C,M,l,D,a,b,O,A,S,c,d,e,f){"use strict";var g=l.DynamicPageTitleArea;
var h=C.extend("sap.f.semantic.SemanticPage",{metadata:{library:"sap.f",properties:{headerExpanded:{type:"boolean",group:"Behavior",defaultValue:true},headerPinnable:{type:"boolean",group:"Behavior",defaultValue:true},preserveHeaderStateOnScroll:{type:"boolean",group:"Behavior",defaultValue:false},toggleHeaderOnTitleClick:{type:"boolean",group:"Behavior",defaultValue:true},showFooter:{type:"boolean",group:"Behavior",defaultValue:false},titlePrimaryArea:{type:"sap.f.DynamicPageTitleArea",group:"Appearance",defaultValue:g.Begin}},defaultAggregation:"content",aggregations:{titleHeading:{type:"sap.ui.core.Control",multiple:false,defaultValue:null,forwarding:{getter:"_getTitle",aggregation:"heading"}},titleBreadcrumbs:{type:"sap.m.IBreadcrumbs",multiple:false,defaultValue:null,forwarding:{getter:"_getTitle",aggregation:"breadcrumbs"}},titleSnappedContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"snappedContent"}},titleExpandedContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"expandedContent"}},titleContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getTitle",aggregation:"content"}},titleMainAction:{type:"sap.f.semantic.TitleMainAction",multiple:false},editAction:{type:"sap.f.semantic.EditAction",multiple:false},deleteAction:{type:"sap.f.semantic.DeleteAction",multiple:false},copyAction:{type:"sap.f.semantic.CopyAction",multiple:false},addAction:{type:"sap.f.semantic.AddAction",multiple:false},flagAction:{type:"sap.f.semantic.FlagAction",multiple:false},favoriteAction:{type:"sap.f.semantic.FavoriteAction",multiple:false},fullScreenAction:{type:"sap.f.semantic.FullScreenAction",multiple:false},exitFullScreenAction:{type:"sap.f.semantic.ExitFullScreenAction",multiple:false},closeAction:{type:"sap.f.semantic.CloseAction",multiple:false},titleCustomTextActions:{type:"sap.m.Button",multiple:true},titleCustomIconActions:{type:"sap.m.OverflowToolbarButton",multiple:true},headerContent:{type:"sap.ui.core.Control",multiple:true,forwarding:{getter:"_getHeader",aggregation:"content"}},content:{type:"sap.ui.core.Control",multiple:false},footerMainAction:{type:"sap.f.semantic.FooterMainAction",multiple:false},messagesIndicator:{type:"sap.f.semantic.MessagesIndicator",multiple:false},draftIndicator:{type:"sap.m.DraftIndicator",multiple:false},positiveAction:{type:"sap.f.semantic.PositiveAction",multiple:false},negativeAction:{type:"sap.f.semantic.NegativeAction",multiple:false},footerCustomActions:{type:"sap.m.Button",multiple:true},discussInJamAction:{type:"sap.f.semantic.DiscussInJamAction",multiple:false},saveAsTileAction:{type:"sap.m.Button",multiple:false},shareInJamAction:{type:"sap.f.semantic.ShareInJamAction",multiple:false},sendMessageAction:{type:"sap.f.semantic.SendMessageAction",multiple:false},sendEmailAction:{type:"sap.f.semantic.SendEmailAction",multiple:false},printAction:{type:"sap.f.semantic.PrintAction",multiple:false},customShareActions:{type:"sap.m.Button",multiple:true},_dynamicPage:{type:"sap.f.DynamicPage",multiple:false,visibility:"hidden"}},designtime:"sap/f/designtime/SemanticPage.designtime"}});
h._EVENTS={SHARE_MENU_CONTENT_CHANGED:"_shareMenuContentChanged"};h._SAVE_AS_TILE_ACTION="saveAsTileAction";
h.prototype.init=function(){this._bSPBeingDestroyed=false;this._initDynamicPage();this._attachShareMenuButtonChange();this._fnActionSubstituteParentFunction=function(){return this;}.bind(this);};
h.prototype.exit=function(){this._bSPBeingDestroyed=true;this._cleanMemory();};
h.prototype.setHeaderExpanded=function(H){this._getPage().setHeaderExpanded(H);return this;};
h.prototype.getHeaderExpanded=function(){return this._getPage().getHeaderExpanded();};
h.prototype.setHeaderPinnable=function(H){var o=this._getPage(),i=o.getHeader();i.setPinnable(H);return this.setProperty("headerPinnable",i.getPinnable(),true);};
h.prototype.setPreserveHeaderStateOnScroll=function(p){var o=this._getPage();o.setPreserveHeaderStateOnScroll(p);return this.setProperty("preserveHeaderStateOnScroll",o.getPreserveHeaderStateOnScroll(),true);};
h.prototype.setToggleHeaderOnTitleClick=function(t){this._getPage().setToggleHeaderOnTitleClick(t);return this.setProperty("toggleHeaderOnTitleClick",t,true);};
h.prototype.setShowFooter=function(s){this._getPage().setShowFooter(s);return this.setProperty("showFooter",s,true);};
h.prototype.setTitlePrimaryArea=function(p){var o=this._getTitle();o.setPrimaryArea(p);return this.setProperty("titlePrimaryArea",o.getPrimaryArea(),true);};
h.prototype.setAggregation=function(s,o,i){var j=this.mAggregations[s],t,p;if(j===o){return this;}o=this.validateAggregation(s,o,false);if(s===h._SAVE_AS_TILE_ACTION){t=h._SAVE_AS_TILE_ACTION;}else{t=this.getMetadata().getManagedAggregation(s).type;}if(e.isKnownSemanticType(t)){p=e.getPlacement(t);if(j){this._onRemoveAggregation(j,t);this._getSemanticContainer(p).removeContent(j,p);}if(o){o._getType=function(){return t;};this._getSemanticContainer(p).addContent(o,p);this._onAddAggregation(o,t);}return M.prototype.setAggregation.call(this,s,o,true);}return M.prototype.setAggregation.call(this,s,o,i);};
h.prototype.destroyAggregation=function(s,i){var o=this.getMetadata().getAggregations()[s],j,p,t;if(s===h._SAVE_AS_TILE_ACTION){t=h._SAVE_AS_TILE_ACTION;}else{t=o&&o.type;}if(t&&e.isKnownSemanticType(t)){j=M.prototype.getAggregation.call(this,s);if(j){p=e.getPlacement(t);this._onRemoveAggregation(j,t);!this._bSPBeingDestroyed&&this._getSemanticContainer(p).removeContent(j,p);}}return M.prototype.destroyAggregation.call(this,s,i);};
["getContent","setContent","destroyContent"].forEach(function(m){h.prototype[m]=function(o){var i=this._getPage();return i[m].apply(i,arguments);};},this);["addTitleCustomTextAction","insertTitleCustomTextAction","indexOfTitleCustomTextAction","removeTitleCustomTextAction","removeAllTitleCustomTextActions","destroyTitleCustomTextActions","getTitleCustomTextActions"].forEach(function(m){h.prototype[m]=function(){var s=this._getSemanticTitle(),i=m.replace(/TitleCustomTextAction?/,"CustomTextAction");return s[i].apply(s,arguments);};},this);["addTitleCustomIconAction","insertTitleCustomIconAction","indexOfTitleCustomIconAction","removeTitleCustomIconAction","removeAllTitleCustomIconActions","destroyTitleCustomIconActions","getTitleCustomIconActions"].forEach(function(m){h.prototype[m]=function(){var s=this._getSemanticTitle(),i=m.replace(/TitleCustomIconAction?/,"CustomIconAction");return s[i].apply(s,arguments);};},this);["addFooterCustomAction","insertFooterCustomAction","indexOfFooterCustomAction","removeFooterCustomAction","removeAllFooterCustomActions","destroyFooterCustomActions","getFooterCustomActions"].forEach(function(m){h.prototype[m]=function(){var s=this._getSemanticFooter(),i=m.replace(/FooterCustomAction?/,"CustomAction");return s[i].apply(s,arguments);};},this);["addCustomShareAction","insertCustomShareAction","indexOfCustomShareAction","removeCustomShareAction","removeAllCustomShareActions","destroyCustomShareActions","getCustomShareActions"].forEach(function(m){h.prototype[m]=function(){var s=this._getShareMenu(),i=m.replace(/CustomShareAction?/,"CustomAction");return s[i].apply(s,arguments);};},this);
h.prototype._onAddAggregation=function(o,t){if(t===h._SAVE_AS_TILE_ACTION){this._replaceParent(o);}};
h.prototype._onRemoveAggregation=function(o,t){if(t===h._SAVE_AS_TILE_ACTION){this._restoreParent(o);}if(o._getType){delete o._getType;}};
h.prototype._replaceParent=function(o){if(o._fnOriginalGetParent){return;}o._fnOriginalGetParent=o.getParent;o.getParent=this._fnActionSubstituteParentFunction;};
h.prototype._restoreParent=function(o){if(o&&o._fnOriginalGetParent){o.getParent=o._fnOriginalGetParent;}};
h.prototype._attachShareMenuButtonChange=function(){this.attachEvent(h._EVENTS.SHARE_MENU_CONTENT_CHANGED,this._onShareMenuContentChanged,this);};
h.prototype._onShareMenuContentChanged=function(E){var s=E.getParameter("bEmpty"),o=this._getSemanticTitle(),i=this._getShareMenu(),j=i._getShareMenuButton();if(!j.getParent()){o.addContent(j,"shareIcon");return;}j.setVisible(!s);};
h.prototype._getPage=function(){if(!this.getAggregation("_dynamicPage")){this._initDynamicPage();}return this.getAggregation("_dynamicPage");};
h.prototype._initDynamicPage=function(){this.setAggregation("_dynamicPage",new D(this.getId()+"-page",{title:this._getTitle(),header:this._getHeader(),footer:this._getFooter()}),true);};
h.prototype._getTitle=function(){if(!this._oDynamicPageTitle){this._oDynamicPageTitle=this._getSemanticTitle()._getContainer();}return this._oDynamicPageTitle;};
h.prototype._getHeader=function(){if(!this._oDynamicPageHeader){this._oDynamicPageHeader=new b(this.getId()+"-pageHeader");}return this._oDynamicPageHeader;};
h.prototype._getFooter=function(){if(!this._oDynamicPageFooter){this._oDynamicPageFooter=this._getSemanticFooter()._getContainer();}return this._oDynamicPageFooter;};
h.prototype._getSemanticTitle=function(){if(!this._oSemanticTitle){this._oSemanticTitle=new S(new a(this.getId()+"-pageTitle"),this);}return this._oSemanticTitle;};
h.prototype._getShareMenu=function(){if(!this._oShareMenu){this._oShareMenu=new d(this._getActionSheet(),this);}return this._oShareMenu;};
h.prototype._getActionSheet=function(){if(!this._oActionSheet){this._oActionSheet=new A(this.getId()+"-shareMenu");}return this._oActionSheet;};
h.prototype._getSemanticFooter=function(){if(!this._oSemanticFooter){this._oSemanticFooter=new c(this._getOverflowToolbar(),this);}return this._oSemanticFooter;};
h.prototype._getOverflowToolbar=function(){if(!this._oOverflowToolbar){this._oOverflowToolbar=new O(this.getId()+"-pageFooter");}return this._oOverflowToolbar;};
h.prototype._getSemanticContainer=function(p){var P=e._Placement;if(p===P.titleText||p===P.titleIcon){return this._getSemanticTitle();}else if(p===P.footerLeft||p===P.footerRight){return this._getSemanticFooter();}else if(p===P.shareMenu){return this._getShareMenu();}return null;};
h.prototype._cleanMemory=function(){if(this._oShareMenu){this._oShareMenu.destroy();this._oShareMenu=null;}if(this._oActionSheet){this._oActionSheet.destroy();this._oActionSheet=null;}if(this._oSemanticTitle){this._oSemanticTitle.destroy();this._oSemanticTitle=null;}if(this._oDynamicPageTitle){this._oDynamicPageTitle.destroy();this._oDynamicPageTitle=null;}if(this._oDynamicPageHeader){this._oDynamicPageHeader.destroy();this._oDynamicPageHeader=null;}if(this._oSemanticFooter){this._oSemanticFooter.destroy();this._oSemanticFooter=null;}if(this._oDynamicPageFooter){this._oDynamicPageFooter.destroy();this._oDynamicPageFooter=null;}if(this._oOverflowToolbar){this._oOverflowToolbar.destroy();this._oOverflowToolbar=null;}};
return h;});
sap.ui.predefine('sap/f/semantic/SemanticPageRenderer',[],function(){"use strict";var S={};
S.render=function(r,s){r.write("<div");r.writeControlData(s);r.addClass("sapFSemanticPage");r.writeClasses();r.write(">");r.renderControl(s._getPage());r.write("</div>");};
return S;},true);
sap.ui.predefine('sap/f/semantic/SemanticShareMenu',["sap/ui/core/IconPool","sap/ui/base/EventProvider","sap/m/library","sap/m/OverflowToolbarButton","sap/m/OverflowToolbarLayoutData","./SemanticContainer"],function(I,E,m,O,a,S){"use strict";var B=m.ButtonType;
var b=S.extend("sap.f.semantic.SemanticShareMenu",{constructor:function(c,p){S.call(this,c,p);this._aShareMenuActions=[];this._aCustomShareActions=[];this._setMode(b._Mode.initial);}});
b._Mode={initial:"initial",menu:"menu"};
b.prototype.addCustomAction=function(c){this._onControlAdded(c);this._callContainerAggregationMethod("insertButton",c,this._getCustomActionInsertIndex());this._aCustomShareActions.push(c);return this;};
b.prototype.insertCustomAction=function(c,i){this._onControlAdded(c);this._callContainerAggregationMethod("insertButton",c,this._getCustomActionInsertIndex(i));this._aCustomShareActions.splice(i,0,c);return this;};
b.prototype.getCustomActions=function(){return this._aCustomShareActions;};
b.prototype.indexOfCustomAction=function(c){return this._aCustomShareActions.indexOf(c);};
b.prototype.removeCustomAction=function(c){var r=this._callContainerAggregationMethod("removeButton",c);this._aCustomShareActions.splice(this._aCustomShareActions.indexOf(c),1);this._onControlRemoved();return r;};
b.prototype.removeAllCustomActions=function(){var r=[];this._aCustomShareActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeButton",c);if(R){r.push(c);}},this);this._aCustomShareActions=[];this._onControlRemoved();return r;};
b.prototype.destroyCustomActions=function(){this.removeAllCustomActions(true).forEach(function(c){c.destroy();});return this;};
b.prototype.addContent=function(s){var c=this._getControl(s);this._onControlAdded(c);this._aShareMenuActions.push(s);this._preProcessOverflowToolbarButton(c);this._callContainerAggregationMethod("insertButton",c,this._getSemanticActionInsertIndex(s));return this;};
b.prototype.removeContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeButton",c);this._aShareMenuActions.splice(this._aShareMenuActions.indexOf(s),1);this._postProcessOverflowToolbarButton(s);this._onControlRemoved();return this;};
b.prototype.destroy=function(){this._oShareMenuBtn=null;this._aShareMenuActions=null;this._aCustomShareActions=null;return S.prototype.destroy.call(this);};
b.prototype._getMode=function(){return this._mode;};
b.prototype._setMode=function(M){if(this._getMode()===M){return this;}if(M===b._Mode.initial){if(this._getMode()){this._fireContentChanged(true);}this._mode=b._Mode.initial;return this;}if(M===b._Mode.menu){this._mode=b._Mode.menu;this._fireContentChanged(false);}return this;};
b.prototype._fireContentChanged=function(e){E.prototype.fireEvent.call(this._getParent(),"_shareMenuContentChanged",{"bEmpty":e});};
b.prototype._getShareMenuButton=function(){var c=this._getContainer();if(!this._oShareMenuBtn){this._oShareMenuBtn=new O(c.getId()+"-shareButton",{icon:I.getIconURI("action"),tooltip:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("SEMANTIC_CONTROL_ACTION_SHARE"),layoutData:new a({closeOverflowOnInteraction:false}),text:sap.ui.getCore().getLibraryResourceBundle("sap.f").getText("SEMANTIC_CONTROL_ACTION_SHARE"),type:B.Transparent,press:function(){c.openBy(this._oShareMenuBtn);}.bind(this)});this._oShareMenuBtn.addEventDelegate({onAfterRendering:function(){this._oShareMenuBtn.$().attr("aria-haspopup",true);}.bind(this)},this);}return this._oShareMenuBtn;};
b.prototype._getCustomActionInsertIndex=function(i){var c=this._aCustomShareActions.length;if(i===undefined){return this._aShareMenuActions.length+c;}i=i>=c?c:i;i+=this._aShareMenuActions.length;return i;};
b.prototype._getSemanticActionInsertIndex=function(s){this._aShareMenuActions.sort(this._sortControlByOrder.bind(this));return this._aShareMenuActions.indexOf(s);};
b.prototype._onControlAdded=function(c){if(this._isInitialMode()){this._setMode(b._Mode.menu,c);}};
b.prototype._onControlRemoved=function(){var A=this._aShareMenuActions.length,c=this._aCustomShareActions.length,e=(A+c)===0;if(this._isMenuMode()&&e){this._setMode(b._Mode.initial);}};
b.prototype._preProcessOverflowToolbarButton=function(o){if(o instanceof O){o._bInOverflow=true;}};
b.prototype._postProcessOverflowToolbarButton=function(o){if(o instanceof O){delete o._bInOverflow;}};
b.prototype._isInitialMode=function(){return this._getMode()===b._Mode.initial;};
b.prototype._isMenuMode=function(){return this._getMode()===b._Mode.menu;};
return b;});
sap.ui.predefine('sap/f/semantic/SemanticTitle',["jquery.sap.global","sap/m/library","./SemanticContainer"],function(q,m,S){"use strict";var B=m.ButtonType;
var a=S.extend("sap.f.semantic.SemanticTitle",{constructor:function(c,p){S.call(this,c,p);this._iMainActionCount=0;this._aSemanticTextActions=[];this._aSemanticSimpleIconActions=[];this._aSemanticNavIconActions=[];this._aCustomTextActions=[];this._aCustomIconActions=[];}});
a.mPlacementMethodMap={titleText:"TextContent",titleIcon:"IconContent",shareIcon:"ShareContent"};
a.prototype.addContent=function(s,p){this["_insertSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.removeContent=function(s,p){this["_removeSemantic"+a.mPlacementMethodMap[p]].call(this,s);return this;};
a.prototype.destroy=function(){this._aSemanticSimpleIconActions=null;this._aSemanticTextActions=null;this._aCustomTextActions=null;this._aCustomIconActions=null;this._aSemanticNavIconActions=null;return S.prototype.destroy.call(this);};
a.prototype.addCustomTextAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomTextActionInsertIndex());this._aCustomTextActions.push(c);return this;};
a.prototype.insertCustomTextAction=function(c,i){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomTextActionInsertIndex(i));this._aCustomTextActions.splice(i,0,c);return this;};
a.prototype.indexOfCustomTextAction=function(c){return this._aCustomTextActions.indexOf(c);};
a.prototype.removeCustomTextAction=function(c){var i=this._aCustomTextActions.indexOf(c),r=this._callContainerAggregationMethod("removeAction",c);this._aCustomTextActions.splice(i,1);return r;};
a.prototype.removeAllCustomTextActions=function(){var r=[];this._aCustomTextActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeAction",c);if(R){r.push(c);}},this);this._aCustomTextActions=[];return r;};
a.prototype.destroyCustomTextActions=function(){this.removeAllCustomTextActions().forEach(function(c){c.destroy();});return this;};
a.prototype.getCustomTextActions=function(){return this._aCustomTextActions;};
a.prototype.addCustomIconAction=function(c){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomIconActionInsertIndex());this._aCustomIconActions.push(c);return this;};
a.prototype.insertCustomIconAction=function(c,i){c.setType(B.Transparent);this._callContainerAggregationMethod("insertAction",c,this._getCustomIconActionInsertIndex(i));this._aCustomIconActions.splice(i,0,c);return this;};
a.prototype.indexOfCustomIconAction=function(c){return this._aCustomIconActions.indexOf(c);};
a.prototype.removeCustomIconAction=function(c){var i=this._aCustomIconActions.indexOf(c),r=this._callContainerAggregationMethod("removeAction",c);this._aCustomIconActions.splice(i,1);return r;};
a.prototype.removeAllCustomIconActions=function(){var r=[];this._aCustomIconActions.forEach(function(c){var R=this._callContainerAggregationMethod("removeAction",c);if(R){r.push(c);}},this);this._aCustomIconActions=[];return r;};
a.prototype.destroyCustomIconActions=function(){this.removeAllCustomIconActions().forEach(function(c){c.destroy();});return this;};
a.prototype.getCustomIconActions=function(){return this._aCustomIconActions;};
a.prototype._insertSemanticTextContent=function(s){var c=this._getControl(s),i=this._isMainAction(s),I;this._aSemanticTextActions.push(s);if(i){this._iMainActionCount++;I=this._getSemanticTextMainActionInsertIndex();}else{I=this._getSemanticTextActionInsertIndex(s);}this._callContainerAggregationMethod("insertAction",c,I);return this;};
a.prototype._removeSemanticTextContent=function(s){var c=this._getControl(s),C=this._aSemanticTextActions.indexOf(s),i=this._isMainAction(s);if(i){this._iMainActionCount--;}this._aSemanticTextActions.splice(C,1);this._callContainerAggregationMethod("removeAction",c);return this;};
a.prototype._insertSemanticIconContent=function(s){var c=this._getControl(s),C,i;if(this._isNavigationAction(s)){this._aSemanticNavIconActions.push(s);i=this._getSemanticNavIconActionInsertIndex(s);C="insertNavigationAction";}else{this._aSemanticSimpleIconActions.push(s);i=this._getSemanticSimpleIconActionInsertIndex(s);C="insertAction";}this._callContainerAggregationMethod(C,c,i);return this;};
a.prototype._removeSemanticIconContent=function(s){var c=this._getControl(s),C,i;if(this._isNavigationAction(s)){i=this._aSemanticNavIconActions.indexOf(s);this._aSemanticNavIconActions.splice(i,1);C="removeNavigationAction";}else{i=this._aSemanticTextActions.indexOf(s);this._aSemanticSimpleIconActions.splice(i,1);C="removeAction";}this._callContainerAggregationMethod(C,c);return this;};
a.prototype._insertSemanticShareContent=function(s){var c=this._getControl(s),i=this._getSemanticShareMenuInsertIndex();this._callContainerAggregationMethod("insertAction",c,i);return this;};
a.prototype._removeSemanticShareContent=function(s){var c=this._getControl(s);this._callContainerAggregationMethod("removeAction",c);return this;};
a.prototype._getSemanticTextMainActionInsertIndex=function(){return 0;};
a.prototype._getCustomTextActionInsertIndex=function(i){var c=this._aCustomTextActions.length;if(i===undefined){return this._iMainActionCount+c;}i=i>=c?c:i;i+=this._iMainActionCount;return i;};
a.prototype._getSemanticTextActionInsertIndex=function(s){this._aSemanticTextActions.sort(this._sortControlByOrder.bind(this));return this._getCustomTextActionInsertIndex()+this._aSemanticTextActions.indexOf(s)-this._iMainActionCount;};
a.prototype._getCustomIconActionInsertIndex=function(i){var c=this._aCustomIconActions.length,p=this._aCustomTextActions.length+this._aSemanticTextActions.length;if(i===undefined){return p+c;}i=i>=c?c:i;i+=p;return i;};
a.prototype._getSemanticSimpleIconActionInsertIndex=function(s){this._aSemanticSimpleIconActions.sort(this._sortControlByOrder.bind(this));return this._getCustomIconActionInsertIndex()+this._aSemanticSimpleIconActions.indexOf(s);};
a.prototype._getSemanticNavIconActionInsertIndex=function(s){this._aSemanticNavIconActions.sort(this._sortControlByOrder.bind(this));return this._aSemanticNavIconActions.indexOf(s);};
a.prototype._getSemanticShareMenuInsertIndex=function(){return this._callContainerAggregationMethod("getActions").length;};
a.prototype._getContainerBar=function(){var c=this._getContainer();if(c){return c.getAggregation("_overflowToolbar");}return null;};
return a;});
sap.ui.predefine('sap/f/semantic/SemanticToggleButton',['./SemanticButton','sap/m/library','jquery.sap.keycodes'],function(S,m,q){"use strict";var B=m.ButtonType;
var a=S.extend("sap.f.semantic.SemanticToggleButton",{metadata:{library:"sap.f","abstract":true,properties:{pressed:{type:"boolean",group:"Data",defaultValue:false}}}});
a.prototype._onTap=function(e){e.setMarked();if(this.getEnabled()){this.setPressed(!this.getPressed());this.firePress({pressed:this.getPressed()});}};
a.prototype._onKeydown=function(e){if(e.which===q.sap.KeyCodes.SPACE||e.which===q.sap.KeyCodes.ENTER){this._onTap(e);}};
a.prototype._applyProperty=function(p,v,s){if(p==='pressed'){this._setPressed(v,s);}else{S.prototype._applyProperty.apply(this,arguments);}};
a.prototype._setPressed=function(p,s){var b=p?B.Emphasized:B.Transparent;this._getControl().setType(b,s);};
a.prototype._createInstance=function(c){var i=new c({id:this.getId()+"-toggleButton"});i.addEventDelegate({ontap:this._onTap,onkeydown:this._onKeydown},this);return i;};
return a;});
sap.ui.predefine('sap/f/semantic/SendEmailAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.SendEmailAction",{metadata:{library:"sap.f"}});
return a;});
sap.ui.predefine('sap/f/semantic/SendMessageAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.SendMessageAction",{metadata:{library:"sap.f"}});
return a;});
sap.ui.predefine('sap/f/semantic/ShareInJamAction',['sap/f/semantic/SemanticButton'],function(S){"use strict";
var a=S.extend("sap.f.semantic.ShareInJamAction",{metadata:{library:"sap.f"}});
return a;});
sap.ui.predefine('sap/f/semantic/TitleMainAction',["./MainAction"],function(M){"use strict";
var T=M.extend("sap.f.semantic.TitleMainAction",{metadata:{library:"sap.f"}});
return T;});
sap.ui.require.preload({
	"sap/f/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.f","type":"library","embeds":[],"applicationVersion":{"version":"1.56.5"},"title":"SAPUI5 library with Fiori controls.","description":"SAPUI5 library with Fiori controls.","ach":"CA-UI5-CTR","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base","sap_hcb"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.56","libs":{"sap.ui.core":{"minVersion":"1.56.5"},"sap.m":{"minVersion":"1.56.5"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.f.Avatar","sap.f.DynamicPage","sap.f.DynamicPageHeader","sap.f.DynamicPageTitle","sap.f.FlexibleColumnLayout","sap.f.semantic.SemanticPage"],"elements":["sap.f.semantic.AddAction","sap.f.semantic.CloseAction","sap.f.semantic.CopyAction","sap.f.semantic.DeleteAction","sap.f.semantic.DiscussInJamAction","sap.f.semantic.EditAction","sap.f.semantic.ExitFullScreenAction","sap.f.semantic.FavoriteAction","sap.f.semantic.FlagAction","sap.f.semantic.FooterMainAction","sap.f.semantic.FullScreenAction","sap.f.semantic.MessagesIndicator","sap.f.semantic.NegativeAction","sap.f.semantic.PositiveAction","sap.f.semantic.PrintAction","sap.f.semantic.SemanticButton","sap.f.semantic.SemanticControl","sap.f.semantic.SemanticToggleButton","sap.f.semantic.SendEmailAction","sap.f.semantic.SendMessageAction","sap.f.semantic.ShareInJamAction","sap.f.semantic.TitleMainAction"],"types":["sap.f.LayoutType","sap.f.DynamicPageTitleArea","sap.f.DynamicPageTitleShrinkRatio"]}}}}'
},"sap/f/library-preload"
);
//# sourceMappingURL=library-preload.js.map