/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./DatePicker','sap/ui/model/type/Date','sap/ui/unified/DateRange','./library','sap/ui/core/Control','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/LocaleData','./DateTimePickerRenderer','jquery.sap.keycodes'],function(q,D,a,b,l,C,c,d,L,e){"use strict";var P=l.PlacementType;var f=D.extend("sap.m.DateTimePicker",{metadata:{library:"sap.m",properties:{minutesStep:{type:"int",group:"Misc",defaultValue:1},secondsStep:{type:"int",group:"Misc",defaultValue:1}},aggregations:{_popup:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/DateTimePicker.designtime"}});var g=C.extend("DateTimePickerPopup",{metadata:{aggregations:{_switcher:{type:"sap.ui.core.Control",multiple:false,visibility:"hidden"},calendar:{type:"sap.ui.core.Control",multiple:false},timeSliders:{type:"sap.ui.core.Control",multiple:false}}},renderer:function(r,p){r.write("<div");r.writeControlData(p);r.addClass("sapMDateTimePopupCont");r.addClass("sapMTimePickerDropDown");r.writeClasses();r.write(">");var s=p.getAggregation("_switcher");if(s&&s.getVisible()){r.write("<div");r.addClass("sapMTimePickerSwitch");r.writeClasses();r.write(">");r.renderControl(s);r.write("</div>");}var i=p.getCalendar();if(i){r.renderControl(i);}r.write("<div");r.addClass("sapMTimePickerSep");r.writeClasses();r.write(">");r.write("</div>");var S=p.getTimeSliders();if(S){r.renderControl(S);}r.write("</div>");},init:function(){},onBeforeRendering:function(){var s=this.getAggregation("_switcher");if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){if(!s){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var i=r.getText("DATETIMEPICKER_DATE");var t=r.getText("DATETIMEPICKER_TIME");s=new sap.m.SegmentedButton(this.getId()+"-Switch",{selectedKey:"Cal",items:[new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Cal",{key:"Cal",text:i}),new sap.m.SegmentedButtonItem(this.getId()+"-Switch-Sli",{key:"Sli",text:t})]});s.attachSelect(this._handleSelect,this);this.setAggregation("_switcher",s,true);}else{s.setVisible(true);s.setSelectedKey("Cal");}}else if(s){s.setVisible(false);}},onAfterRendering:function(){if(c.system.phone||q('html').hasClass("sapUiMedia-Std-Phone")){var s=this.getAggregation("_switcher");var K=s.getSelectedKey();this._switchVisibility(K);}},_handleSelect:function(E){this._switchVisibility(E.getParameter("key"));},_switchVisibility:function(K){var i=this.getCalendar();var s=this.getTimeSliders();if(!i||!s){return;}if(K=="Cal"){i.$().css("display","");s.$().css("display","none");}else{i.$().css("display","none");s.$().css("display","");s._updateSlidersValues();s._onOrientationChanged();s.openFirstSlider();}},switchToTime:function(){var s=this.getAggregation("_switcher");if(s&&s.getVisible()){s.setSelectedKey("Sli");this._switchVisibility("Sli");}},getSpecialDates:function(){return this._oDateTimePicker.getSpecialDates();}});f.prototype.init=function(){D.prototype.init.apply(this,arguments);this._bOnlyCalendar=false;};f.prototype.exit=function(){D.prototype.exit.apply(this,arguments);if(this._oSliders){this._oSliders.destroy();delete this._oSliders;}this._oPopupContent=undefined;};f.prototype.setDisplayFormat=function(s){D.prototype.setDisplayFormat.apply(this,arguments);if(this._oSliders){this._oSliders.setDisplayFormat(n.call(this));}return this;};f.prototype.setMinutesStep=function(M){this.setProperty('minutesStep',M,true);if(this._oSliders){this._oSliders.setMinutesStep(M);}return this;};f.prototype.setMinDate=function(i){D.prototype.setMinDate.call(this,i);if(i){this._oMinDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};f.prototype.setMaxDate=function(i){D.prototype.setMaxDate.call(this,i);if(i){this._oMaxDate.setHours(i.getHours(),i.getMinutes(),i.getSeconds());}return this;};f.prototype.setSecondsStep=function(s){this.setProperty('secondsStep',s,true);if(this._oSliders){this._oSliders.setSecondsStep(s);}return this;};f.prototype._getFormatInstance=function(A,i){var M=q.extend({},A);var s=-1;if(M.style){s=M.style.indexOf("/");}if(i){var j=q.extend({},M);if(s>0){j.style=j.style.substr(0,s);}this._oDisplayFormatDate=d.getInstance(j);}return d.getDateTimeInstance(M);};f.prototype._checkStyle=function(p){if(D.prototype._checkStyle.apply(this,arguments)){return true;}else if(p.indexOf("/")>0){var s=["short","medium","long","full"];var S=false;for(var i=0;i<s.length;i++){var r=s[i];for(var j=0;j<s.length;j++){var t=s[j];if(p==r+"/"+t){S=true;break;}}if(S){break;}}return S;}return false;};f.prototype._parseValue=function(v,i){var j=D.prototype._parseValue.apply(this,arguments);if(i&&!j){j=this._oDisplayFormatDate.parse(v);if(j){var O=this.getDateValue();if(!O){O=new Date();}j.setHours(O.getHours());j.setMinutes(O.getMinutes());j.setSeconds(O.getSeconds());j.setMilliseconds(O.getMilliseconds());}}return j;};f.prototype._getLocaleBasedPattern=function(p){var i=L.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()),s=p.indexOf("/");if(s>0){return i.getCombinedDateTimePattern(p.substr(0,s),p.substr(s+1));}else{return i.getCombinedDateTimePattern(p,p);}};f.prototype._createPopup=function(){if(!this._oPopup){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");var O=r.getText("TIMEPICKER_SET");var s=r.getText("TIMEPICKER_CANCEL");this._oPopupContent=new g(this.getId()+"-PC");this._oPopupContent._oDateTimePicker=this;this._oPopup=new sap.m.ResponsivePopover(this.getId()+"-RP",{showCloseButton:false,showHeader:false,placement:P.VerticalPreferedBottom,beginButton:new sap.m.Button(this.getId()+"-OK",{text:O,press:q.proxy(_,this)}),endButton:new sap.m.Button(this.getId()+"-Cancel",{text:s,press:q.proxy(h,this)}),content:this._oPopupContent});this._oPopup.addStyleClass("sapMDateTimePopup");var p=this._oPopup.getAggregation("_popup");if(p.setShowArrow){p.setShowArrow(false);}this._oPopup.attachAfterOpen(k,this);this._oPopup.attachAfterClose(m,this);if(c.system.desktop){this._oPopoverKeydownEventDelegate={onkeydown:function(E){var K=q.sap.KeyCodes,i=E.which||E.keyCode,A=E.altKey;if((A&&(i===K.ARROW_UP||i===K.ARROW_DOWN))||i===K.F4){_.call(this,E);this.focus();E.preventDefault();}}};this._oPopup.addEventDelegate(this._oPopoverKeydownEventDelegate,this);}this.setAggregation("_popup",this._oPopup,true);}};f.prototype._openPopup=function(){if(!this._oPopup){return;}this._storeInputSelection(this._$input.get(0));var p=this._oPopup.getAggregation("_popup");p.oPopup.setAutoCloseAreas([this.getDomRef()]);this._oPopup.openBy(this);var s=this._oPopup.getContent()[0]&&this._oPopup.getContent()[0].getTimeSliders();if(s){q.sap.delayedCall(0,s,s._updateSlidersValues);}};f.prototype._createPopupContent=function(){var N=!this._oCalendar;D.prototype._createPopupContent.apply(this,arguments);if(N){this._oPopupContent.setCalendar(this._oCalendar);this._oCalendar.attachSelect(o,this);var t=this,H=this._oCalendar._hideMonthPicker,i=this._oCalendar._hideYearPicker;this._oCalendar._hideMonthPicker=function(s){H.apply(this,arguments);if(!s){t._selectFocusedDateValue(new b().setStartDate(this._getFocusedDate().toLocalJSDate()));}};this._oCalendar._hideYearPicker=function(s){i.apply(this,arguments);if(!s){t._selectFocusedDateValue(new b().setStartDate(this._getFocusedDate().toLocalJSDate()));}};}if(!this._oSliders){q.sap.require("sap.m.TimePickerSliders");this._oSliders=new sap.m.TimePickerSliders(this.getId()+"-Sliders",{minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep(),displayFormat:n.call(this),localeId:this.getLocaleId()})._setShouldOpenSliderAfterRendering(true);this._oPopupContent.setTimeSliders(this._oSliders);}};f.prototype._selectFocusedDateValue=function(i){var j=this._oCalendar;j.removeAllSelectedDates();j.addSelectedDate(i);return this;};f.prototype._fillDateRange=function(){var i=this.getDateValue();if(i){i=new Date(i.getTime());}else{i=this._getInitialFocusedDateValue();var M=this._oMaxDate.getTime()+86400000;if(i.getTime()<this._oMinDate.getTime()||i.getTime()>M){i=this._oMinDate;}}this._oCalendar.focusDate(i);if(!this._oDateRange.getStartDate()||this._oDateRange.getStartDate().getTime()!=i.getTime()){this._oDateRange.setStartDate(i);}this._oSliders._setTimeValues(i);};f.prototype._getSelectedDate=function(){var i=D.prototype._getSelectedDate.apply(this,arguments);if(i){var j=this._oSliders.getTimeValues();var p=this._oSliders._getDisplayFormatPattern();if(p.search("h")>=0||p.search("H")>=0){i.setHours(j.getHours());}if(p.search("m")>=0){i.setMinutes(j.getMinutes());}if(p.search("s")>=0){i.setSeconds(j.getSeconds());}if(i.getTime()<this._oMinDate.getTime()){i=new Date(this._oMinDate.getTime());}else if(i.getTime()>this._oMaxDate.getTime()){i=new Date(this._oMaxDate.getTime());}}return i;};f.prototype._getInitialFocusedDateValue=function(){return this.getInitialFocusedDateValue()||new Date();};f.prototype.getLocaleId=function(){return sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale().toString();};f.prototype.getAccessibilityInfo=function(){var i=D.prototype.getAccessibilityInfo.apply(this,arguments);i.type=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_DATETIMEINPUT");return i;};function _(E){this._selectDate();}function h(E){this.onsaphide(E);this._oCalendar.removeAllSelectedDates();this._oCalendar.addSelectedDate(new b().setStartDate(this._getInitialFocusedDateValue()));}function k(E){this.$("inner").attr("aria-expanded",true);this._oCalendar.focus();this._oSliders._onOrientationChanged();}function m(){this.$("inner").attr("aria-expanded",false);this._restoreInputSelection(this._$input.get(0));}function n(){var s=this.getDisplayFormat();var t;var B=this.getBinding("value");if(B&&B.oType&&(B.oType instanceof a)){s=B.oType.getOutputPattern();}else if(B&&B.oType&&B.oType.oFormat){s=B.oType.oFormat.oFormatOptions.pattern;}else{s=this.getDisplayFormat();}if(!s){s="medium";}var S=s.indexOf("/");if(S>0&&this._checkStyle(s)){s=s.substr(S+1);}if(s=="short"||s=="medium"||s=="long"||s=="full"){var i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale();var j=L.getInstance(i);t=j.getTimePattern(s);}else{t=s;}return t;}function o(E){this._oPopupContent.switchToTime();}return f;});
