/*!
* UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
*/
sap.ui.define(['jquery.sap.global','./NavContainer','./library','sap/ui/core/Control','sap/ui/core/IconPool','sap/ui/core/delegate/ItemNavigation','sap/ui/core/InvisibleText','sap/ui/Device','sap/ui/base/ManagedObject','sap/ui/core/Icon','sap/ui/model/Filter','./FacetFilterRenderer','jquery.sap.keycodes'],function(q,N,l,C,I,a,b,D,M,c,F,d){"use strict";var T=l.ToolbarDesign;var L=l.ListType;var e=l.ListMode;var f=l.FacetFilterListDataType;var B=l.ButtonType;var P=l.PlacementType;var g=l.FacetFilterType;var h=C.extend("sap.m.FacetFilter",{metadata:{interfaces:["sap.ui.core.IShrinkable"],library:"sap.m",properties:{showPersonalization:{type:"boolean",group:"Appearance",defaultValue:false},type:{type:"sap.m.FacetFilterType",group:"Appearance",defaultValue:g.Simple},liveSearch:{type:"boolean",group:"Behavior",defaultValue:true},showSummaryBar:{type:"boolean",group:"Behavior",defaultValue:false},showReset:{type:"boolean",group:"Behavior",defaultValue:true},showPopoverOKButton:{type:"boolean",group:"Appearance",defaultValue:false}},defaultAggregation:"lists",aggregations:{lists:{type:"sap.m.FacetFilterList",multiple:true,singularName:"list"},buttons:{type:"sap.m.Button",multiple:true,singularName:"button",visibility:"hidden"},removeFacetIcons:{type:"sap.ui.core.Icon",multiple:true,singularName:"removeFacetIcon",visibility:"hidden"},popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"},addFacetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},summaryBar:{type:"sap.m.Toolbar",multiple:false,visibility:"hidden"},resetButton:{type:"sap.m.Button",multiple:false,visibility:"hidden"},arrowLeft:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"},arrowRight:{type:"sap.ui.core.Icon",multiple:false,visibility:"hidden"}},events:{reset:{},confirm:{}}}});h.SCROLL_STEP=264;h.prototype.setType=function(t){var s=this.getAggregation("summaryBar");if(D.system.phone){this.setProperty("type",g.Light);s.setActive(true);}else{this.setProperty("type",t);s.setActive(t===g.Light);}if(t===g.Light){if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}}return this;};h.prototype.setShowReset=function(v){this.setProperty("showReset",v);var s=this.getAggregation("summaryBar");if(v){if(this.getShowSummaryBar()||this.getType()===g.Light){this._addResetToSummary(s);}}else{if(this.getShowSummaryBar()||this.getType()===g.Light){this._removeResetFromSummary(s);}}return this;};h.prototype.setShowSummaryBar=function(v){this.setProperty("showSummaryBar",v);if(v){var s=this.getAggregation("summaryBar");if(this.getShowReset()){this._addResetToSummary(s);}else{this._removeResetFromSummary(s);}s.setActive(this.getType()===g.Light);}return this;};h.prototype.setLiveSearch=function(v){this.setProperty("liveSearch",v);if(this._displayedList){var o=this._displayedList;var s=sap.ui.getCore().byId(o.getAssociation("search"));s.detachLiveChange(o._handleSearchEvent,o);if(v){s.attachLiveChange(o._handleSearchEvent,o);}}return this;};h.prototype.getLists=function(){var i=this.getAggregation("lists");if(!i){i=[];}if(this._displayedList){i.splice(this._listAggrIndex,0,this._displayedList);}return i;};h.prototype.removeList=function(o){var i=M.prototype.removeAggregation.call(this,"lists",o);this._removeList(i);return i;};h.prototype.removeAggregation=function(){var o=M.prototype.removeAggregation.apply(this,arguments);if(arguments[0]==="lists"){this._removeList(o);}return o;};h.prototype.openFilterDialog=function(){var o=this._getFacetDialog();var n=this._getFacetDialogNavContainer();o.addContent(n);this.getLists().forEach(function(i){if(i.getMode()===e.MultiSelect){i._preserveOriginalActiveState();}});o.setInitialFocus(n.getPages()[0].getContent()[0].getItems()[0]);o.open();return this;};h.prototype.init=function(){this._pageSize=5;this._addDelegateFlag=false;this._invalidateFlag=false;this._lastCategoryFocusIndex=0;this._aDomRefs=null;this._previousTarget=null;this._addTarget=null;this._aRows=null;this._bundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this.data("sap-ui-fastnavgroup","true",true);this._buttons={};this._aOwnedLabels=[];this._removeFacetIcons={};this._listAggrIndex=-1;this._displayedList=null;this._lastScrolling=false;this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._getAddFacetButton();this._getSummaryBar();this.setAggregation("resetButton",this._createResetButton());if(q.sap.touchEventMode==="ON"&&!D.system.phone){this._enableTouchSupport();}if(D.system.phone){this.setType(g.Light);}};h.prototype.exit=function(){var o;sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);if(this.oItemNavigation){this.removeDelegate(this.oItemNavigation);this.oItemNavigation.destroy();}if(this._aOwnedLabels){this._aOwnedLabels.forEach(function(i){o=sap.ui.getCore().byId(i);if(o){o.destroy();}});this._aOwnedLabels=null;}};h.prototype.onBeforeRendering=function(){if(this.getShowSummaryBar()||this.getType()===g.Light){var s=this.getAggregation("summaryBar");var t=s.getContent()[0];t.setText(this._getSummaryText());t.setTooltip(this._getSummaryText());}sap.ui.getCore().detachIntervalTimer(this._checkOverflow,this);};h.prototype.onAfterRendering=function(){if(this.getType()!==g.Light&&!D.system.phone){sap.ui.getCore().attachIntervalTimer(this._checkOverflow,this);}if(this.getType()!==g.Light){this._startItemNavigation();}};h.prototype._startItemNavigation=function(){var o=this.getDomRef(),r=o.getElementsByClassName("sapMFFHead"),j=[];if(r.length>0){for(var i=0;i<r[0].childNodes.length;i++){if(r[0].childNodes[i].id.indexOf("ff")<0&&r[0].childNodes[i].id.indexOf("icon")<0&&r[0].childNodes[i].id.indexOf("add")<0){j.push(r[0].childNodes[i]);}if(r[0].childNodes[i].id.indexOf("add")>=0){j.push(r[0].childNodes[i]);}}}if(j!=""){this._aDomRefs=j;}if((!this.oItemNavigation)||this._addDelegateFlag==true){this.oItemNavigation=new a();this.addDelegate(this.oItemNavigation);this._addDelegateFlag=false;}this._aRows=r;for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].id.indexOf("add")>=0){this._addTarget=this.$().find(":sapTabbable")[i];break;}}this.oItemNavigation.setRootDomRef(o);this.oItemNavigation.setItemDomRefs(j);this.oItemNavigation.setCycling(false);this.oItemNavigation.setPageSize(this._pageSize);};h.prototype.onsapdelete=function(E){var o,i;if(this.getType()===g.Light){return;}if(!this.getShowPersonalization()){return;}o=sap.ui.getCore().byId(E.target.id);if(!o){return;}i=sap.ui.getCore().byId(o.getAssociation("list"));if(!i){return;}if(!i.getShowRemoveFacetIcon()){return;}i.removeSelections(true);i.setSelectedKeys();i.setProperty("active",false,true);this.invalidate();var t=this.$().find(":sapTabbable");q(t[t.length-1]).focus();var n=this.oItemNavigation.getFocusedIndex();q(E.target).blur();this.oItemNavigation.setFocusedIndex(n+1);this.focus();if(this.oItemNavigation.getFocusedIndex()==0){for(var k=0;k<this.$().find(":sapTabbable").length-1;k++){if(t[k].id.indexOf("add")>=0){q(t[k]).focus();}}}};h.prototype.onsaptabnext=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;if(E.target.parentNode.className=="sapMFFHead"){for(var i=0;i<this.$().find(":sapTabbable").length;i++){if(this.$().find(":sapTabbable")[i].parentNode.className=="sapMFFResetDiv"){q(this.$().find(":sapTabbable")[i]).focus();E.preventDefault();E.setMarked();return;}}}this._lastCategoryFocusIndex=this.oItemNavigation.getFocusedIndex();if(this._invalidateFlag==true){this.oItemNavigation.setFocusedIndex(-1);this.focus();this._invalidateFlag=false;}};h.prototype.onsaptabprevious=function(E){if(this.getType()===g.Light){return;}if(E.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget==null){q(this.$().find(":sapTabbable")[0]).focus();E.preventDefault();E.setMarked();return;}if(E.target.parentNode.className=="sapMFFResetDiv"&&this._previousTarget!=null&&this._previousTarget.id!=E.target.id){q(this._previousTarget).focus();E.preventDefault();E.setMarked();return;}if(E.target.id.indexOf("add")>=0||E.target.parentNode.className=="sapMFFHead"){this._previousTarget=E.target;q(this.$().find(":sapTabbable")[0]).focus();}};h.prototype.onsapend=function(E){if(this.getType()===g.Light){return;}if(this._addTarget!=null){q(this._addTarget).focus();E.preventDefault();E.setMarked();}else{q(this._aRows[this._aRows.length-1]).focus();E.preventDefault();E.setMarked();}this._previousTarget=E.target;};h.prototype.onsaphome=function(E){if(this.getType()===g.Light){return;}q(this._aRows[0]).focus();E.preventDefault();E.setMarked();this._previousTarget=E.target;};h.prototype.onsappageup=function(E){this._previousTarget=E.target;};h.prototype.onsappagedown=function(E){this._previousTarget=E.target;};h.prototype.onsapincreasemodifiers=function(E){if(this.getType()===g.Light){return;}if(E.which==q.sap.KeyCodes.ARROW_RIGHT){this._previousTarget=E.target;var i=this.oItemNavigation.getFocusedIndex()-1;var n=i+this._pageSize;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();}};h.prototype.onsapdecreasemodifiers=function(E){if(this.getType()===g.Light){return;}var i=0;if(E.which==q.sap.KeyCodes.ARROW_LEFT){this._previousTarget=E.target;i=this.oItemNavigation.getFocusedIndex()+1;var n=i-this._pageSize;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();}};h.prototype.onsapdownmodifiers=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;var i=0;i=this.oItemNavigation.getFocusedIndex()-1;var n=i+this._pageSize;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};h.prototype.onsapupmodifiers=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;var i=0;i=this.oItemNavigation.getFocusedIndex();if(i!=0){i=i+1;}var n=i-this._pageSize;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};h.prototype.onsapexpand=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;var n=this.oItemNavigation.getFocusedIndex()+1;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};h.prototype.onsapcollapse=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;var n=this.oItemNavigation.getFocusedIndex()-1;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};h.prototype.onsapdown=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;if(E.target.parentNode.className=="sapMFFResetDiv"){q(E.target).focus();E.preventDefault();E.setMarked();return;}};h.prototype.onsapup=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;if(E.target.parentNode.className=="sapMFFResetDiv"){q(E.target).focus();E.preventDefault();E.setMarked();}};h.prototype.onsapleft=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;if(E.target.parentNode.className=="sapMFFResetDiv"){q(E.target).focus();E.preventDefault();E.setMarked();}};h.prototype.onsapright=function(E){if(this.getType()===g.Light){return;}this._previousTarget=E.target;if(E.target.parentNode.className=="sapMFFResetDiv"){q(E.target).focus();E.preventDefault();E.setMarked();}};h.prototype.onsapescape=function(E){if(this.getType()===g.Light){return;}if(E.target.parentNode.className=="sapMFFResetDiv"){return;}var n=this._lastCategoryFocusIndex;q(E.target).blur();this.oItemNavigation.setFocusedIndex(n);this.focus();};h.prototype._getPopover=function(){var p=this.getAggregation("popover");if(!p){var t=this;p=new sap.m.Popover({placement:P.Bottom,beforeOpen:function(E){if(t._displayedList){t._displayedList._setSearchValue("");}this.setCustomHeader(t._createFilterItemsSearchFieldBar(t._displayedList));var s=this.getSubHeader();if(!s){this.setSubHeader(t._createSelectAllCheckboxBar(t._displayedList));}i(t._displayedList);},afterClose:function(E){t._addDelegateFlag=true;if(D.browser.internet_explorer&&D.browser.version<10){q.sap.delayedCall(100,t,t._handlePopoverAfterClose);}else{t._handlePopoverAfterClose();}},horizontalScrolling:false});this.setAggregation("popover",p,true);p.setContentWidth("30%");if(D.browser.internet_explorer&&D.browser.version<10){p.setContentWidth("30%");}p.addStyleClass("sapMFFPop");var i=function(o){if(!o){return;}var j=t._getFacetRemoveIcon(o);if(j){j._bTouchStarted=false;}};}if(this.getShowPopoverOKButton()){this._addOKButtonToPopover(p);}else{p.destroyAggregation("footer");}return p;};h.prototype._handlePopoverAfterClose=function(){var p=this.getAggregation("popover"),o=this._displayedList;if(!p){return;}var i=this._getFacetRemoveIcon(o);if(i&&i._bTouchStarted){return;}this._restoreListFromDisplayContainer(p);this._displayRemoveIcon(false,o);o._fireListCloseEvent();this._fireConfirmEvent();this.destroyAggregation("popover");if(this._oOpenPopoverDeferred){q.sap.delayedCall(0,this,function(){this._oOpenPopoverDeferred.resolve();this._oOpenPopoverDeferred=undefined;});}};h.prototype._fireConfirmEvent=function(){this.fireEvent('confirm');};h.prototype._openPopover=function(p,o){if(!p.isOpen()){var i=sap.ui.getCore().byId(o.getAssociation("list"));i.fireListOpen({});this._moveListToDisplayContainer(i,p);p.openBy(o);if(i.getShowRemoveFacetIcon()){this._displayRemoveIcon(true,i);}if(i.getWordWrap()){p.setContentWidth("30%");}i._applySearch();}return this;};h.prototype._getAddFacetButton=function(){var o=this.getAggregation("addFacetButton");if(!o){var t=this;var o=new sap.m.Button(this.getId()+"-add",{icon:I.getIconURI("add-filter"),type:B.Transparent,tooltip:this._bundle.getText("FACETFILTER_ADDFACET"),press:function(E){t.openFilterDialog();}});this.setAggregation("addFacetButton",o,true);}return o;};h.prototype._getButtonForList=function(o){if(this._buttons[o.getId()]){this._setButtonText(o);return this._buttons[o.getId()];}var t=this;var i=new sap.m.Button({type:B.Transparent,press:function(E){var j=this;var O=function(){var p=t._getPopover();t._openPopover(p,j);};if(o.getMode()===e.MultiSelect){o._preserveOriginalActiveState();}if(D.browser.internet_explorer&&D.browser.version<10){q.sap.delayedCall(100,this,O);}else{var p=t._getPopover();if(p.isOpen()){q.sap.delayedCall(100,this,function(){if(p.isOpen()){return;}t._oOpenPopoverDeferred=q.Deferred();t._oOpenPopoverDeferred.promise().done(O);});}else{q.sap.delayedCall(100,this,O);}}}});this._buttons[o.getId()]=i;this.addAggregation("buttons",i);i.setAssociation("list",o.getId(),true);this._setButtonText(o);return i;};h.prototype._setButtonText=function(o){var i=this._buttons[o.getId()];if(o._iAllItemsCount===undefined&&o.getMaxItemsCount()){o._iAllItemsCount=o.getMaxItemsCount();}if(i){var t="";var s=Object.getOwnPropertyNames(o._oSelectedKeys);var j=s.length;if(j===1){var S=o._oSelectedKeys[s[0]];t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[o.getTitle(),S]);}else if(j>0&&j===(o._iAllItemsCount?o._iAllItemsCount:0)){t=this._bundle.getText("FACETFILTER_ALL_SELECTED",[o.getTitle()]);}else if(j>0){t=this._bundle.getText("FACETFILTER_ITEM_SELECTION",[o.getTitle(),j]);}else{t=o.getTitle();}i.setText(t);}};h.prototype._getFacetRemoveIcon=function(o){var t=this,i=this._removeFacetIcons[o.getId()];if(!i){i=new c({src:I.getIconURI("sys-cancel"),tooltip:this._bundle.getText("FACETFILTER_REMOVE"),press:function(){i._bPressed=true;}});i.addDelegate({ontouchstart:function(){i._bTouchStarted=true;i._bPressed=false;},ontouchend:function(){t._displayRemoveIcon(false,o);i._bTouchStarted=false;q.sap.delayedCall(100,this,p);}},true);var p=function(){if(i._bPressed){o.removeSelections(true);o.setSelectedKeys();o.setProperty("active",false,true);}t._handlePopoverAfterClose();};i.setAssociation("list",o.getId(),true);i.addStyleClass("sapMFFLRemoveIcon");this._removeFacetIcons[o.getId()]=i;this.addAggregation("removeFacetIcons",i);this._displayRemoveIcon(false,o);}return i;};h.prototype._displayRemoveIcon=function(i,o){if(this.getShowPersonalization()){var j=this._removeFacetIcons[o.getId()];if(i){j.removeStyleClass("sapMFFLHiddenRemoveIcon");j.addStyleClass("sapMFFLVisibleRemoveIcon");}else{j.removeStyleClass("sapMFFLVisibleRemoveIcon");j.addStyleClass("sapMFFLHiddenRemoveIcon");}}};h.prototype._getFacetDialogNavContainer=function(){var n=new N({autoFocus:false});var o=this._createFacetPage();n.addPage(o);n.setInitialPage(o);var t=this;n.attachAfterNavigate(function(E){var i=E.getParameters()["to"];var j=E.getParameters()['from'];if(j===o){var k=(t._displayedList.getMode()===e.MultiSelect)?i.getContent(0)[1].getItems()[0]:i.getContent(0)[0].getItems()[0];if(k){k.focus();}}if(i===o){j.destroySubHeader();j.destroyContent();t._selectedFacetItem.invalidate();i.invalidate();q.sap.focus(t._selectedFacetItem);t._selectedFacetItem=null;}});return n;};h.prototype._createFacetPage=function(){var o=this._createFacetList();var i=new sap.m.SearchField({width:"100%",tooltip:this._bundle.getText("FACETFILTER_SEARCH"),liveChange:function(E){var j=o.getBinding("items");if(j){var k=new F("text",sap.ui.model.FilterOperator.Contains,E.getParameters()["newValue"]);j.filter([k]);}}});var p=new sap.m.Page({enableScrolling:true,title:this._bundle.getText("FACETFILTER_TITLE"),subHeader:new sap.m.Bar({contentMiddle:i}),content:[o]});return p;};h.prototype._createFilterItemsPage=function(){var t=this;var p=new sap.m.Page({showNavButton:true,enableScrolling:true,navButtonPress:function(E){var n=E.getSource().getParent();t._navFromFilterItemsPage(n);}});return p;};h.prototype._getFilterItemsPage=function(n){var o=n.getPages()[1];if(o){n.removePage(o);o.destroy();}var p=this._createFilterItemsPage();n.addPage(p);return p;};h.prototype._createFilterItemsSearchFieldBar=function(o){var t=this;var s=true;if(o.getDataType()!=f.String){s=false;}var S=new sap.m.SearchField({value:o._getSearchValue(),width:"100%",enabled:s,tooltip:this._bundle.getText("FACETFILTER_SEARCH"),search:function(E){t._displayedList._handleSearchEvent(E);}});if(this.getLiveSearch()){S.attachLiveChange(o._handleSearchEvent,o);}var i=new sap.m.Bar({contentMiddle:S});o.setAssociation("search",S);return i;};h.prototype._getFacetDialog=function(){var o=this.getAggregation("dialog");if(!o){var t=this;o=new sap.m.Dialog({showHeader:false,stretch:D.system.phone?true:false,afterClose:function(){t._addDelegateFlag=true;t._invalidateFlag=true;var n=this.getContent()[0];var i=n.getPages()[1];if(n.getCurrentPage()===i){var j=t._restoreListFromDisplayContainer(i);if(j.getMode()===e.MultiSelect){j._updateActiveState();}j._fireListCloseEvent();j._search("");}this.destroyAggregation("content",true);t.invalidate();},beginButton:new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),press:function(){t._closeDialog();}}),contentHeight:"500px"});o.addStyleClass("sapMFFDialog");o.onsapentermodifiers=function(E){if(E.shiftKey&&!E.ctrlKey&&!E.altKey){var n=this.getContent()[0];t._navFromFilterItemsPage(n);}};this.setAggregation("dialog",o,true);}return o;};h.prototype._closeDialog=function(){var o=this.getAggregation("dialog");if(o&&o.isOpen()){o.close();this._fireConfirmEvent();}};h.prototype._closePopover=function(){var p=this.getAggregation("popover");if(p&&p.isOpen()){p.close();}};h.prototype._createFacetList=function(){var o=new sap.m.List({mode:e.None,items:{path:"/items",template:new sap.m.StandardListItem({title:"{text}",counter:"{count}",type:L.Navigation,customData:[new sap.ui.core.CustomData({key:"index",value:"{index}"})]})}});var j=[];for(var i=0;i<this.getLists().length;i++){var k=this.getLists()[i];j.push({text:k.getTitle(),count:k.getAllCount(),index:i});}var m=new sap.ui.model.json.JSONModel({items:j});if(j.length>100){m.setSizeLimit(j.length);}var t=this;o.attachUpdateFinished(function(){for(var i=0;i<o.getItems().length;i++){var n=this.getItems()[i];n.detachPress(t._handleFacetListItemPress,t);n.attachPress(t._handleFacetListItemPress,t);}});o.setModel(m);return o;};h.prototype._createSelectAllCheckboxBar=function(o){if(!o.getMultiSelect()){return null;}var s=o.getActive()&&o.getItems().length>0&&Object.getOwnPropertyNames(o._oSelectedKeys).length===o.getItems().length;var i=new sap.m.CheckBox(o.getId()+"-selectAll",{text:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),tooltip:this._bundle.getText("FACETFILTER_CHECKBOX_ALL"),selected:s,select:function(E){i.setSelected(E.getParameter("selected"));o._handleSelectAllClick(E.getParameter("selected"));}});o.setAssociation("allcheckbox",i);var j=new sap.m.Bar();j.addEventDelegate({ontap:function(E){if(E.srcControl===this){o._handleSelectAllClick(i.getSelected());}}},j);j.addContentLeft(i);j.addStyleClass("sapMFFCheckbar");return j;};h.prototype._handleFacetListItemPress=function(E){this._navToFilterItemsPage(E.getSource());};h.prototype._navToFilterItemsPage=function(o){this._selectedFacetItem=o;var n=this.getAggregation("dialog").getContent()[0];var i=o.getCustomData();var j=i[0].getValue();var k=this.getLists()[j];this._listIndexAgg=this.indexOfAggregation("lists",k);if(this._listIndexAgg==j){var m=this._getFilterItemsPage(n);k.fireListOpen({});this._moveListToDisplayContainer(k,m);m.setSubHeader(this._createFilterItemsSearchFieldBar(k));var p=this._createSelectAllCheckboxBar(k);if(p){m.insertContent(p,0);}m.setTitle(k.getTitle());n.to(m);}};h.prototype._navFromFilterItemsPage=function(n){var o=n.getPages()[1];var i=this._restoreListFromDisplayContainer(o);if(i.getMode()===e.MultiSelect){i._updateActiveState();}i._fireListCloseEvent();i._search("");this._selectedFacetItem.setCounter(i.getAllCount());n.backToTop();};h.prototype._moveListToDisplayContainer=function(o,i){this._listAggrIndex=this.indexOfAggregation("lists",o);M.prototype.removeAggregation.call(this,"lists",o,true);i.addAggregation("content",o,false);o.setAssociation("facetFilter",this,true);this._displayedList=o;};h.prototype._restoreListFromDisplayContainer=function(o){var i=o.removeAggregation("content",this._displayedList,true);this.insertAggregation("lists",i,this._listAggrIndex,i.getActive());this._listAggrIndex=-1;this._displayedList=null;return i;};h.prototype._getSequencedLists=function(){var m=-1;var s=[];var k=this.getLists();if(k.length>0){for(var i=0;i<k.length;i++){if(k[i].getActive()){if(k[i].getSequence()<-1){k[i].setSequence(-1);}else if(k[i].getSequence()>m){m=k[i].getSequence();}s.push(k[i]);}else if(!k[i].getRetainListSequence()){k[i].setSequence(-1);}}for(var j=0;j<s.length;j++){if(s[j].getSequence()<=-1){m+=1;s[j].setSequence(m);}}if(s.length>1){s.sort(function(n,o){return n.getSequence()-o.getSequence();});}}return s;};h.prototype._getSummaryBar=function(){var s=this.getAggregation("summaryBar");if(!s){var t=new sap.m.Text({maxLines:1});var i=this;s=new sap.m.Toolbar({content:[t],active:this.getType()===g.Light?true:false,design:T.Info,press:function(E){i.openFilterDialog();}});s._setRootAccessibilityRole("button");this.setAggregation("summaryBar",s);}return s;};h.prototype._createResetButton=function(){var t=this;var o=new sap.m.Button({type:B.Transparent,icon:I.getIconURI("undo"),tooltip:this._bundle.getText("FACETFILTER_RESET"),press:function(E){t._addDelegateFlag=true;t._invalidateFlag=true;t.fireReset();var j=t.getLists();for(var i=0;i<j.length;i++){j[i]._searchValue="";j[i]._applySearch();q.sap.focus(j[i].getItems()[0]);}t.invalidate();}});return o;};h.prototype._addOKButtonToPopover=function(p){var o=p.getFooter();if(!o){var t=this;var o=new sap.m.Button({text:this._bundle.getText("FACETFILTER_ACCEPT"),tooltip:this._bundle.getText("FACETFILTER_ACCEPT"),width:"100%",press:function(){t._closePopover();}});p.setFooter(o);}return o;};h.prototype._getSummaryText=function(){var k=", ";var S=" ";var s="";var m=true;var n=this.getLists();if(n.length>0){for(var i=0;i<n.length;i++){var o=n[i];if(o.getActive()){var p=this._getSelectedItemsText(o);var t="";for(var j=0;j<p.length;j++){t=t+p[j]+k;}if(t){t=t.substring(0,t.lastIndexOf(k)).trim();if(m){s=this._bundle.getText("FACETFILTER_INFOBAR_FILTERED_BY",[o.getTitle(),t]);m=false;}else{s=s+S+this._bundle.getText("FACETFILTER_INFOBAR_AND")+S+this._bundle.getText("FACETFILTER_INFOBAR_AFTER_AND",[o.getTitle(),t]);}}}}}if(!s){s=this._bundle.getText("FACETFILTER_INFOBAR_NO_FILTERS");}return s;};h.prototype._getSelectedItemsText=function(o){var t=o.getSelectedItems().map(function(v){return v.getText();});o._oSelectedKeys&&Object.getOwnPropertyNames(o._oSelectedKeys).forEach(function(v){t.indexOf(o._oSelectedKeys[v])===-1&&t.push(o._oSelectedKeys[v]);});return t;};h.prototype._addResetToSummary=function(s){if(s.getContent().length===1){s.addContent(new sap.m.ToolbarSpacer({width:""}));var o=this._createResetButton();s.addContent(o);o.addStyleClass("sapUiSizeCompact");o.addStyleClass("sapMFFRefresh");o.addStyleClass("sapMFFBtnHoverable");}};h.prototype._removeResetFromSummary=function(s){if(s.getContent().length===3){var S=s.removeAggregation("content",1);S.destroy();var o=s.removeAggregation("content",1);o.destroy();}};h.prototype._removeList=function(o){if(o){var i=this._buttons[o.getId()];if(i){this.removeAggregation("buttons",i);i.destroy();}var r=this._removeFacetIcons[o.getId()];if(r){this.removeAggregation("removeIcons",r);r.destroy();}delete this._buttons[o.getId()];delete this._removeFacetIcons[o.getId()];}};h.prototype._getScrollingArrow=function(n){var A=null;var p={src:"sap-icon://navigation-"+n+"-arrow"};if(n==="left"){A=this.getAggregation("arrowLeft");if(!A){p.id=this.getId()+"-arrowScrollLeft";A=I.createControlByURI(p);var j=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollLeft"];for(var i=0;i<j.length;i++){A.addStyleClass(j[i]);A.setTooltip(this._bundle.getText("FACETFILTER_PREVIOUS"));}this.setAggregation("arrowLeft",A);}}else if(n==="right"){A=this.getAggregation("arrowRight");if(!A){p.id=this.getId()+"-arrowScrollRight";A=I.createControlByURI(p);var k=["sapMPointer","sapMFFArrowScroll","sapMFFArrowScrollRight"];for(var i=0;i<k.length;i++){A.addStyleClass(k[i]);A.setTooltip(this._bundle.getText("FACETFILTER_NEXT"));}this.setAggregation("arrowRight",A);}}else{q.sap.log.error("Scrolling arrow name "+n+" is not valid");}return A;};h.prototype._checkOverflow=function(){var o=this.getDomRef("head"),$=q(o),i=this.$(),s=false,S=false,j=false,k=null,m=null,n=null;if(o){k=o.scrollLeft;m=o.scrollWidth;n=o.clientWidth;if(m>n){if(m-n==1){m=n;}else{j=true;}}i.toggleClass("sapMFFScrolling",j);i.toggleClass("sapMFFNoScrolling",!j);this._lastScrolling=j;if(!this._bRtl){s=k>0;S=(m>n)&&(m>k+n);}else{S=$.scrollLeftRTL()>0;s=$.scrollRightRTL()>0;}if((S!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){i.toggleClass("sapMFFNoScrollBack",!s);i.toggleClass("sapMFFNoScrollForward",!S);}}};h.prototype.onclick=function(E){var t=E.target.id;if(t){var i=this.getId(),o=E.target;E.preventDefault();if(t==i+"-arrowScrollLeft"){o.tabIndex=-1;o.focus();this._scroll(-h.SCROLL_STEP,500);}else if(t==i+"-arrowScrollRight"){o.tabIndex=-1;o.focus();this._scroll(h.SCROLL_STEP,500);}}};h.prototype._scroll=function(i,j){var o=this.getDomRef("head");var s=o.scrollLeft;if(!D.browser.internet_explorer&&this._bRtl){i=-i;}var S=s+i;q(o).stop(true,true).animate({scrollLeft:S},j);};h.prototype._enableTouchSupport=function(){var t=this;var i=function(m){var s=t.getType();if(s===g.Light){return;}m.preventDefault();if(t._iInertiaIntervalId){window.clearInterval(t._iInertiaIntervalId);}t.startScrollX=t.getDomRef("head").scrollLeft;t.startTouchX=m.touches[0].pageX;t._bTouchNotMoved=true;t._lastMoveTime=new Date().getTime();};var j=function(m){var s=t.getType();if(s===g.Light){return;}var n=m.touches[0].pageX-t.startTouchX;var o=t.getDomRef("head");var p=o.scrollLeft;var r=t.startScrollX-n;o.scrollLeft=r;t._bTouchNotMoved=false;var u=new Date().getTime()-t._lastMoveTime;t._lastMoveTime=new Date().getTime();if(u>0){t._velocity=(r-p)/u;}m.preventDefault();};var k=function(m){var s=t.getType();if(s===g.Light){return;}if(t._bTouchNotMoved===false){m.preventDefault();var o=t.getDomRef("head");var n=50;var p=Math.abs(t._velocity/10);t._iInertiaIntervalId=window.setInterval(function(){t._velocity=t._velocity*0.80;var r=t._velocity*n;o.scrollLeft=o.scrollLeft+r;if(Math.abs(t._velocity)<p){window.clearInterval(t._iInertiaIntervalId);t._iInertiaIntervalId=undefined;}},n);}else if(t._bTouchNotMoved===true){t.onclick(m);m.preventDefault();}t._bTouchNotMoved=undefined;t._lastMoveTime=undefined;};this.addEventDelegate({ontouchstart:i},this);this.addEventDelegate({ontouchend:k},this);this.addEventDelegate({ontouchmove:j},this);};return h;});
