/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/delegate/ItemNavigation','./IconTabBarDragAndDropUtil','./IconTabBarSelectListRenderer','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo'],function(q,l,C,I,a,b,D,c){"use strict";var d=C.extend("sap.m.IconTabBarSelectList",{metadata:{library:"sap.m",aggregations:{items:{type:"sap.m.IconTabFilter",multiple:true,singularName:"item",dnd:true}},events:{selectionChange:{parameters:{selectedItem:{type:"sap.m.IconTabFilter"}}}}}});d.prototype.init=function(){this._itemNavigation=new I();this._itemNavigation.setCycling(false);this.addEventDelegate(this._itemNavigation);this._itemNavigation.setPageSize(10);};d.prototype.exit=function(){if(this._itemNavigation){this._itemNavigation.destroy();this._itemNavigation=null;}};d.prototype.onAfterRendering=function(){this._initItemNavigation();};d.prototype._setsDragAndConfiguration=function(){if(!this._iconTabHeader.getEnableTabReordering()&&this.getDragDropConfig().length){this.destroyDragDropConfig();}else if(this._iconTabHeader.getEnableTabReordering()&&!this.getDragDropConfig().length){a.setDragDropAggregations(this,D,c,"Vertical");}};d.prototype.onBeforeRendering=function(){if(!this._iconTabHeader){return;}this._setsDragAndConfiguration();};d.prototype._initItemNavigation=function(){var e,f=this.getItems(),g=[];for(var i=0;i<f.length;i++){e=f[i];g.push(e.getDomRef());}this._itemNavigation.setRootDomRef(this.getDomRef());this._itemNavigation.setItemDomRefs(g);};d.prototype.getVisibleItems=function(){var e=this.getItems(),v=[],f;for(var i=0;i<e.length;i++){f=e[i];if(f.getVisible()){v.push(f);}}return v;};d.prototype.setSelectedItem=function(i){if(this._selectedItem){this._deselectItem(this._selectedItem);}if(i){this._selectItem(i);}this._selectedItem=i;};d.prototype.getSelectedItem=function(){return this._selectedItem;};d.prototype._deselectItem=function(i){var $=i.$();if($){$.removeClass('sapMITBSelectItemSelected');$.removeAttr('aria-selected');}};d.prototype._selectItem=function(i){var $=i.$();if($){$.addClass('sapMITBSelectItemSelected');$.attr('aria-selected',true);}};d.prototype.ontap=function(e){var $=q(e.target);if(!$.hasClass('sapMITBSelectItem')){$=$.parent(".sapMITBSelectItem");}var s=sap.ui.getCore().byId($[0].id);if(s&&s.getEnabled()){e.preventDefault();if(s!=this.getSelectedItem()){this._selectItem(s);this.fireSelectionChange({selectedItem:s});}}if(this._iconTabHeader){this._iconTabHeader._closeOverflow();}};d.prototype.onsapenter=d.prototype.ontap;d.prototype.onsapspace=d.prototype.ontap;d.prototype.checkIconOnly=function(e){var f,g=e.length;for(var i=0;i<g;i++){f=e[i];if(f.getText()||f.getCount()){return false;}}return true;};d.prototype._handleDragAndDrop=function(e){var o=e.getParameter("dropPosition"),f=e.getParameter("draggedControl"),g=e.getParameter("droppedControl"),h=f.getParent().getMetadata().getName()==="sap.m.IconTabHeader",i;if(h){i=a.getDraggedDroppedItemsFromList(this.getAggregation("items"),f,g);this._handleDropOfListAndHeaderItems(o,i.oDraggedControlFromList,i.oDroppedControlFromList,f,g._tabFilter);}else{this._handleDropOfListAndHeaderItems(o,f,g,f._tabFilter,g._tabFilter);}this._initItemNavigation();f.$().focus();};d.prototype._handleDropOfListAndHeaderItems=function(o,e,f,g,h,i){a.handleDrop(this,o,e,f,true);a.handleDrop(this._iconTabHeader,o,g,h,true);this._iconTabHeader._initItemNavigation();};d.prototype.ondragrearranging=function(e){if(!this._iconTabHeader.getEnableTabReordering()){return;}var t=e.srcControl,k=e.keyCode;a.moveItem.call(this,t,k);this._initItemNavigation();t.$().focus();this._iconTabHeader._moveTab(t._tabFilter,k);};d.prototype.onsaphomemodifiers=d.prototype.ondragrearranging;d.prototype.onsapendmodifiers=d.prototype.ondragrearranging;d.prototype.onsapincreasemodifiers=d.prototype.ondragrearranging;d.prototype.onsapdecreasemodifiers=d.prototype.ondragrearranging;return d;});
