/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/EnabledPropagator','sap/ui/core/delegate/ItemNavigation','sap/ui/core/IconPool','sap/ui/core/delegate/ScrollEnablement','./IconTabBarSelectList','./Button','./ResponsivePopover','./IconTabFilter','sap/ui/Device','sap/ui/core/ResizeHandler','sap/ui/core/Icon','./IconTabBarDragAndDropUtil','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','./IconTabHeaderRenderer'],function(q,l,C,E,I,a,S,b,B,R,c,D,d,e,f,g,h,j){"use strict";var t=l.touch;var k=l.ImageHelper;var P=l.PlacementType;var m=l.ButtonType;var n=l.BackgroundDesign;var o=l.IconTabHeaderMode;var p=l.IconTabDensityMode;var r=C.extend("sap.m.IconTabHeader",{metadata:{library:"sap.m",properties:{showSelection:{type:"boolean",group:"Misc",defaultValue:true,deprecated:true},selectedKey:{type:"string",group:"Data",defaultValue:null},visible:{type:"boolean",group:"Behavior",defaultValue:true},mode:{type:"sap.m.IconTabHeaderMode",group:"Appearance",defaultValue:o.Standard},showOverflowSelectList:{type:"boolean",group:"Appearance",defaultValue:false},backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:n.Solid},enableTabReordering:{type:"boolean",group:"Behavior",defaultValue:false},tabDensityMode:{type:"sap.m.IconTabDensityMode",group:"Appearance",defaultValue:p.Cozy}},aggregations:{items:{type:"sap.m.IconTab",multiple:true,singularName:"item",dnd:{draggable:true,droppable:true,layout:"Horizontal"}}},events:{select:{parameters:{item:{type:"sap.m.IconTabFilter"},key:{type:"string"}}}}}});E.apply(r.prototype,[true]);r.SCROLL_STEP=264;r.prototype.init=function(){this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;this._iCurrentScrollLeft=0;this.startScrollX=0;this.startTouchX=0;this._scrollable=null;this._aTabKeys=[];this._oItemNavigation=new I().setCycling(false);this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this._oItemNavigation.setDisabledModifiers({sapnext:["alt","meta"],sapprevious:["alt","meta"]});this.addDelegate(this._oItemNavigation);this._oScroller=new S(this,this.getId()+"-head",{horizontal:true,vertical:false,nonTouchScrolling:true});};r.prototype.isTouchScrollingDisabled=function(){return this.getShowOverflowSelectList()&&this.getParent().getMetadata().getName()=='sap.tnt.ToolHeader';};r.prototype._getSelectList=function(){var i=this;if(!this._oSelectList){this._oSelectList=new b({selectionChange:function(s){var T=s.getParameter('selectedItem');i.setSelectedItem(T._tabFilter);}});this._oSelectList._iconTabHeader=this;}return this._oSelectList;};r.prototype._getOverflowButton=function(){if(!this._oOverflowButton){this._oOverflowButton=new B({id:this.getId()+'-overflow',icon:"sap-icon://slim-arrow-down",type:m.Transparent,press:this._overflowButtonPress.bind(this)});}return this._oOverflowButton;};r.prototype._overflowButtonPress=function(i){if(!this._oPopover){this._oPopover=new R({showArrow:false,showHeader:false,placement:P.Vertical,offsetX:0,offsetY:0}).addStyleClass('sapMITBPopover');if(D.system.phone){this._oPopover._oControl.addButton(this._createPopoverCloseButton());}this.addDependent(this._oPopover);}var s=this._getSelectList();this._setSelectListItems();this._oPopover.removeAllContent();this._oPopover.addContent(s);this._oPopover.setInitialFocus(s.getSelectedItem());this._oPopover.openBy(this._getOverflowButton());};r.prototype._createPopoverCloseButton=function(){var i=this;var s=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:s.getText("SELECT_CANCEL_BUTTON"),press:function(){i._closeOverflow();}});};r.prototype._closeOverflow=function(){if(!D.system.desktop){this._oPopover.close();}if(this.oSelectedItem){this.oSelectedItem.$().focus();}};r.prototype._setSelectListItems=function(){if(!this.getShowOverflowSelectList()){return;}var s,T,u=this._getSelectList(),v=this.getTabFilters();u.destroyItems();for(var i=0;i<v.length;i++){T=v[i];s=T.clone();s._tabFilter=T;u.addItem(s);if(T==this.oSelectedItem){u.setSelectedItem(s);}}};r.prototype._findSelectItem=function(T){var s=this._getSelectList(),u=s.getItems(),v;for(var i=0;i<u.length;i++){v=u[i];if(v._tabFilter==T){return v;}}};r.prototype._onItemNavigationFocusLeave=function(){if(!this.oSelectedItem){return;}var s=this.getItems();var u=-1;var v;for(var i=0;i<s.length;i++){v=s[i];if(v instanceof c==false){continue;}u++;if(this.oSelectedItem==v){break;}}this._oItemNavigation.setFocusedIndex(u);};r.prototype._onItemNavigationAfterFocus=function(i){var H=this.getDomRef("head"),s=i.getParameter("index"),$=i.getParameter('event');if($.keyCode===undefined){return;}this._iCurrentScrollLeft=H.scrollLeft;this._checkOverflow();if(s!==null&&s!==undefined){this._scrollIntoView(this.getTabFilters()[s],0);}};r.prototype.getTabFilters=function(){var i=this.getItems();var T=[];i.forEach(function(s){if(s instanceof c){T.push(s);}});return T;};r.prototype.exit=function(){if(this._oArrowLeft){this._oArrowLeft.destroy();}if(this._oArrowRight){this._oArrowRight.destroy();}if(this._oItemNavigation){this.removeDelegate(this._oItemNavigation);this._oItemNavigation.destroy();delete this._oItemNavigation;}if(this._oScroller){this._oScroller.destroy();this._oScroller=null;}if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(this._aTabKeys){this._aTabKeys=null;}if(this._oPopover){this._oPopover.destroy();this._oPopover=null;}if(this._oOverflowButton){this._oOverflowButton.removeEventDelegate(this._onDragOverEventDelegate);this._oOverflowButton.destroy();this._oOverflowButton=null;}};r.prototype._handlesOnDragOver=function(){if(!this._oPopover||!this._oPopover.isOpen()){this._overflowButtonPress();}};r.prototype._setsDragAndDropConfigurations=function(){var O=this._getOverflowButton();if(!this.getEnableTabReordering()&&this.getDragDropConfig().length){this.destroyDragDropConfig();}else if(this.getEnableTabReordering()&&!this.getDragDropConfig().length){O.addEventDelegate(this._onDragOverEventDelegate);f.setDragDropAggregations(this,g,h,"Horizontal");}};r.prototype.onBeforeRendering=function(){var s=this.getItems(),u=this.getSelectedKey(),i=0,v=this.getParent(),w=v instanceof sap.m.IconTabBar,x=v&&v.getMetadata().getName()=='sap.tnt.ToolHeader';this._bRtl=sap.ui.getCore().getConfiguration().getRTL();this._onDragOverEventDelegate={ondragover:this._handlesOnDragOver.bind(this)};if(this._sResizeListenerId){d.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}if(s.length>0){if(!this.oSelectedItem||u&&u!==this.oSelectedItem._getNonEmptyKey()){if(u){for(;i<s.length;i++){if(!(s[i]instanceof sap.m.IconTabSeparator)&&s[i]._getNonEmptyKey()===u){this.oSelectedItem=s[i];break;}}}if(!this.oSelectedItem&&(w||!u)){for(i=0;i<s.length;i++){if(!(s[i]instanceof sap.m.IconTabSeparator)&&s[i].getVisible()){this.oSelectedItem=s[i];break;}}}}if(!x&&this.oSelectedItem&&!this.oSelectedItem.getVisible()){for(i=0;i<s.length;i++){if(!(s[i]instanceof sap.m.IconTabSeparator)&&s[i].getVisible()){this.oSelectedItem=s[i];break;}}}if(this.oSelectedItem){this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);}}this._isTouchScrollingDisabled=this.isTouchScrollingDisabled();this._oScroller.setHorizontal(!this._isTouchScrollingDisabled&&(!this.getEnableTabReordering()||!D.system.desktop));this._setsDragAndDropConfigurations();if(this._sResizeListenerNoFlexboxSupportId){d.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};r.prototype.setSelectedKey=function(K){var s=this.getTabFilters(),i=0,u=this.getParent(),v=u instanceof sap.m.IconTabBar,w;if(s.length>0){K=K||s[0]._getNonEmptyKey();}if(this.$().length){for(;i<s.length;i++){if(s[i]._getNonEmptyKey()===K){this.setSelectedItem(s[i],true);w=true;break;}}if(!w&&!v&&K){this.setSelectedItem(null);}}this.setProperty("selectedKey",K,true);return this;};r.prototype.setSelectedItem=function(i,A){if(!i){if(this.oSelectedItem){this.oSelectedItem.$().removeClass("sapMITBSelected");this.oSelectedItem=null;}return this;}if(!i.getEnabled()){return this;}if(this.getShowOverflowSelectList()){var s=this._findSelectItem(i);if(s){this._getSelectList().setSelectedItem(s);}}var u=this.getParent();var v=u instanceof sap.m.IconTabBar;var w=false;if(i.getContent().length===0&&this.oSelectedItem&&this.oSelectedItem.getContent().length===0){w=true;}if(this.oSelectedItem&&this.oSelectedItem.getVisible()&&(!A&&v&&u.getExpandable()||this.oSelectedItem!==i)){this.oSelectedItem.$().removeClass("sapMITBSelected").attr('aria-selected',false).removeAttr('aria-expanded');}if(i.getVisible()){if(this.oSelectedItem===i){if(!A&&v&&u.getExpandable()){u._toggleExpandCollapse();}}else{if(v){u.$("content").attr('aria-labelledby',i.sId);}this.oSelectedItem=i;this.setProperty("selectedKey",this.oSelectedItem._getNonEmptyKey(),true);if(!v){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}if(v&&(u.getExpandable()||u.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});var x=this.oSelectedItem.getContent();if(x.length>0){u._rerenderContent(x);}else{if(!w){u._rerenderContent(u.getContent());}}if(!A&&u.getExpandable()&&!u.getExpanded()){u._toggleExpandCollapse(true);}}}if(this.oSelectedItem.$().length>0){this._scrollIntoView(i,500);}else{this._scrollAfterRendering=true;}}this.oSelectedItem=i;var y=this.oSelectedItem._getNonEmptyKey();this.setProperty("selectedKey",y,true);if(v){u.setProperty("selectedKey",y,true);}if(!A){if(v){u.fireSelect({selectedItem:this.oSelectedItem,selectedKey:y,item:this.oSelectedItem,key:y});}else{this.fireSelect({selectedItem:this.oSelectedItem,selectedKey:y,item:this.oSelectedItem,key:y});}}return this;};r.prototype.getVisibleTabFilters=function(){var s=this.getTabFilters(),v=[],u;for(var i=0;i<s.length;i++){u=s[i];if(u.getVisible()){v.push(u);}}return v;};r.prototype._getFirstVisibleItem=function(s){for(var i=0;i<s.length;i++){if(s[i].getVisible()){return s[i];}}return null;};r.prototype._initItemNavigation=function(){var i=this,H=this.getDomRef("head"),s=this.getItems(),T=[],u=-1;s.forEach(function(v){if(v instanceof c){var w=i.getFocusDomRef(v);q(w).attr("tabindex","-1");T.push(w);if(v===i.oSelectedItem){u=T.indexOf(w);}}});if(!this._oItemNavigation){this._oItemNavigation=new I();this._oItemNavigation.attachEvent(I.Events.FocusLeave,this._onItemNavigationFocusLeave,this);this._oItemNavigation.attachEvent(I.Events.AfterFocus,this._onItemNavigationAfterFocus,this);this.addDelegate(this._oItemNavigation);}this._oItemNavigation.setRootDomRef(H);this._oItemNavigation.setItemDomRefs(T);this._oItemNavigation.setSelectedIndex(u);};r.prototype.onThemeChanged=function(){this._applyTabDensityMode();};r.prototype._applyTabDensityMode=function(){var T=this.getTabDensityMode();this.$().removeClass("sapUiSizeCompact");switch(T){case p.Compact:this.$().addClass("sapUiSizeCompact");break;case p.Inherit:if(this.$().closest(".sapUiSizeCompact").length){this.$().addClass("sapUiSizeCompact");}break;}};r.prototype.onAfterRendering=function(){this._applyTabDensityMode();if(this._oScroller){this._oScroller.setIconTabBar(this,q.proxy(this._afterIscroll,this),q.proxy(this._scrollPreparation,this));}var i=this.getParent();var s=i instanceof sap.m.IconTabBar;if(this.oSelectedItem&&(!s||s&&i.getExpanded())){this.oSelectedItem.$().addClass("sapMITBSelected").attr({'aria-selected':true});}q.sap.delayedCall(350,this,"_checkOverflow");if(this.oSelectedItem){this._scrollIntoView(this.oSelectedItem,500);}this._initItemNavigation();if(this.getShowOverflowSelectList()){this.$('overflow').attr('tabindex',-1);}this._sResizeListenerId=d.register(this.getDomRef(),q.proxy(this._fnResize,this));if(!q.support.newFlexBoxLayout&&s&&i.getStretchContentHeight()){this._sResizeListenerNoFlexboxSupportId=d.register(i.getDomRef(),q.proxy(this._fnResizeNoFlexboxSupport,this));this._fnResizeNoFlexboxSupport();}this._bCheckIfIntoView=true;};r.prototype.destroyItems=function(){this.oSelectedItem=null;this._aTabKeys=[];this.destroyAggregation("items");};r.prototype.addItem=function(i){if(!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();if(this._aTabKeys.indexOf(K)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+K+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(K);}this.addAggregation("items",i);};r.prototype.insertItem=function(i,s){if(!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();if(this._aTabKeys.indexOf(K)!==-1){q.sap.log.warning("sap.m.IconTabHeader: duplicate key '"+K+"' inside the IconTabFilter. Please use unique keys.");}this._aTabKeys.push(K);}this.insertAggregation("items",i,s);};r.prototype.removeAllItems=function(){this._aTabKeys=[];return this.removeAllAggregation("items");};r.prototype.removeItem=function(i){i=this.removeAggregation("items",i);if(i&&!(i instanceof sap.m.IconTabSeparator)){var K=i.getKey();this._aTabKeys.splice(this._aTabKeys.indexOf(K),1);}return i;};r.prototype.updateAggregation=function(){this.oSelectedItem=null;return C.prototype.updateAggregation.apply(this,arguments);};r.prototype.removeAggregation=function(A,O,s){var i=this.getTabFilters();var u=C.prototype.removeAggregation.apply(this,arguments);if(s){return u;}if(u&&u==this.oSelectedItem&&A=='items'){var v=q.inArray(u,i);i=this.getTabFilters();v=Math.max(0,Math.min(v,i.length-1));var w=i[v];if(w){this.setSelectedItem(w,true);}else{var x=this.getParent();if(x instanceof sap.m.IconTabBar&&x.getExpanded()){x.$("content").children().remove();}}}return u;};r.prototype.removeAllAggregation=function(A,s){if(A=='items'){var i=this.getParent();if(i instanceof sap.m.IconTabBar&&i.getExpanded()){i.$("content").children().remove();}}return C.prototype.removeAllAggregation.apply(this,arguments);};r.prototype._getDisplayText=function(i){var T=i.getText();if(this.isInlineMode()){var s=i.getCount();if(s){if(this._bRtl){T='('+s+') '+T;}else{T+=' ('+s+')';}}}return T;};r.prototype.isInlineMode=function(){return this._bTextOnly&&this.getMode()==o.Inline;};r.prototype._checkTextOnly=function(s){if(s.length>0){for(var i=0;i<s.length;i++){if(!(s[i]instanceof sap.m.IconTabSeparator)){if(s[i].getIcon()){this._bTextOnly=false;return false;}}}}this._bTextOnly=true;return true;};r.prototype._checkNoText=function(s){if(s.length>0){for(var i=0;i<s.length;i++){if(!(s[i]instanceof sap.m.IconTabSeparator)){if(s[i].getText().length>0){return false;}}}}return true;};r.prototype._checkInLine=function(s){var u;if(s.length>0){for(var i=0;i<s.length;i++){u=s[i];if(!(u instanceof sap.m.IconTabSeparator)){if(u.getIcon()||u.getCount()){this._bInLine=false;return false;}}}}this._bInLine=true;return true;};r.prototype._checkScrolling=function(H){var $=this.$();var s=false;var i=this.getDomRef("scrollContainer");var u=this.getDomRef("head");if(u&&i){if(u.offsetWidth>i.offsetWidth){s=true;}}if(this._scrollable!==s){$.toggleClass("sapMITBScrollable",s);$.toggleClass("sapMITBNotScrollable",!s);this._scrollable=s;}this._setTabsVisibility();return s;};r.prototype._getScrollingArrow=function(N){var s=a.getIconURI("slim-arrow-"+N);var i={src:s,useIconTooltip:false};var u=this._bTextOnly?"TextOnly":"";var L="sapMITBArrowScrollLeft"+u;var v="sapMITBArrowScrollRight"+u;var w=["sapMITBArrowScroll",L];var x=["sapMITBArrowScroll",v];if(this._bInLine){w.push('sapMITBArrowScrollLeftInLine');x.push('sapMITBArrowScrollRightInLine');}if(N==="left"){if(!this._oArrowLeft){this._oArrowLeft=k.getImageControl(this.getId()+"-arrowScrollLeft",this._oArrowLeft,this,i,w);}return this._oArrowLeft;}if(N==="right"){if(!this._oArrowRight){this._oArrowRight=k.getImageControl(this.getId()+"-arrowScrollRight",this._oArrowRight,this,i,x);}return this._oArrowRight;}};r.prototype._checkOverflow=function(){var i=this.getDomRef("head");var $=this.$();if(this._checkScrolling(i)&&i){var s=false;var u=false;var v=this.getDomRef("scrollContainer");var w=this.getDomRef("head");if(this._oScroller.getScrollLeft()>0){s=true;}if((this._oScroller.getScrollLeft()+v.offsetWidth)<w.offsetWidth){u=true;}if((u!=this._bPreviousScrollForward)||(s!=this._bPreviousScrollBack)){this._bPreviousScrollForward=u;this._bPreviousScrollBack=s;$.toggleClass("sapMITBScrollBack",s);$.toggleClass("sapMITBNoScrollBack",!s);$.toggleClass("sapMITBScrollForward",u);$.toggleClass("sapMITBNoScrollForward",!u);}}else{this._bPreviousScrollForward=false;this._bPreviousScrollBack=false;}};r.prototype._handleActivation=function(i){var T=i.target.id,s=i.srcControl,u,$=q(i.target);if(s instanceof B){return;}var v=q.sap.byId(T);if(q.inArray(this.$("content")[0],v.parents())>-1){}else{if(T){var w=this.getId();i.preventDefault();if(T==w+"-arrowScrollLeft"&&D.system.desktop){var x=this._oScroller.getScrollLeft()-r.SCROLL_STEP;if(x<0){x=0;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[x,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else if(T==w+"-arrowScrollRight"&&D.system.desktop){var x=this._oScroller.getScrollLeft()+r.SCROLL_STEP;var y=this.$("scrollContainer").width();var H=this.$("head").width();if(x>(H-y)){x=H-y;}this._scrollPreparation();q.sap.delayedCall(0,this._oScroller,"scrollTo",[x,0,500]);q.sap.delayedCall(500,this,"_afterIscroll");}else{if($.hasClass('sapMITBFilterIcon')||$.hasClass('sapMITBCount')||$.hasClass('sapMITBText')||$.hasClass('sapMITBTab')||$.hasClass('sapMITBContentArrow')||$.hasClass('sapMITBSep')||$.hasClass('sapMITBSepIcon')){u=i.srcControl.getId().replace(/-icon$/,"");s=sap.ui.getCore().byId(u);if(s.getMetadata().isInstanceOf("sap.m.IconTab")&&!(s instanceof sap.m.IconTabSeparator)){this.setSelectedItem(s);}}else if(s.getMetadata().isInstanceOf("sap.m.IconTab")&&!(s instanceof sap.m.IconTabSeparator)){this.setSelectedItem(s);}}}else{if(s.getMetadata().isInstanceOf("sap.m.IconTab")&&!(s instanceof sap.m.IconTabSeparator)){this.setSelectedItem(s);}}}};r.prototype._scrollIntoView=function(i,s){var $=i.$(),u,N,v;if($.length>0){var w=this.$('head');var H=w.innerWidth()-w.width();var x=$.outerWidth(true);var y=$.position().left-H/2;u=this._oScroller.getScrollLeft();v=this.$("scrollContainer").width();N=0;if(y-u<0||y-u>v-x){if(y-u<0){N+=y;}else{N+=Math.min(y,y+x-v);N=Math.round(N);}this._scrollPreparation();this._iCurrentScrollLeft=N;q.sap.delayedCall(0,this._oScroller,"scrollTo",[N,0,s]);q.sap.delayedCall(s,this,"_afterIscroll");}}return this;};r.prototype._scroll=function(i,s){this._scrollPreparation();var u=this.getDomRef("head");var v=u.scrollLeft;var w=D.browser.msie||D.browser.edge;if(!w&&this._bRtl){i=-i;}var x=v+i;q(u).stop(true,true).animate({scrollLeft:x},s,q.proxy(this._adjustAndShowArrow,this));this._iCurrentScrollLeft=x;};r.prototype._adjustAndShowArrow=function(){this._$bar&&this._$bar.toggleClass("sapMITBScrolling",false);this._$bar=null;if(D.system.desktop){this._checkOverflow();}};r.prototype._scrollPreparation=function(){if(!this._$bar){this._$bar=this.$().toggleClass("sapMITBScrolling",true);}};r.prototype._afterIscroll=function(){this._checkOverflow();this._adjustAndShowArrow();this._setTabsVisibility();};r.prototype._fnResize=function(){this._checkOverflow();if(this.oSelectedItem&&this._bCheckIfIntoView){this._scrollIntoView(this.oSelectedItem,0);if(!this._isTouchScrollingDisabled){this._bCheckIfIntoView=false;}}this._setTabsVisibility();};r.prototype._fnResizeNoFlexboxSupport=function(){var $=this.getParent().$("containerContent"),i=$.outerHeight(true)-$.height();$.height(this.getParent().$().height()-$.position().top-i);};r.prototype._setTabsVisibility=function(){if(!this._isTouchScrollingDisabled){return;}var T=this.getItems(),s,$,H,i;for(i=0;i<T.length;i++){s=T[i];$=s.$();if(!$.hasClass('sapMITBSelected')&&!this._isTabIntoView($)){$.addClass('sapMITBFilterHidden');}else{H=true;$.removeClass('sapMITBFilterHidden');}}if(!H){for(i=0;i<T.length;i++){s=T[i];$=s.$();if(this._isTabIntoView($,true)){$.removeClass('sapMITBFilterHidden');break;}}}this._moveVisibleTabs();};r.prototype._isTabIntoView=function($,s){if(!$.length){return false;}var i=this._oScroller.getScrollLeft(),u=this.$("scrollContainer").width(),v=this.$('head'),H=v.innerWidth()-v.width(),w=$.css('padding-left'),x=$.width()+parseFloat(w),y=Math.ceil($.position().left-H/2);if(y-i<0||(!s&&(y+x-i>u))){return false;}return true;};r.prototype._moveVisibleTabs=function(){if(!this._oScroller){return;}var s=this._oScroller.getScrollLeft(),$=this.$('head'),H=$.innerWidth()-$.width(),i=this.$().find('.sapMITBFilter:not(.sapMITBFilterHidden)').first(),u,v;if(!i.length){return;}v=i.position().left-H/2;if(!this._bRtl&&v-s>2){u=s-v;$.css('transform','translate('+u+'px)');}else{$.css('transform','');}return true;};r.prototype.onExit=function(){if(this._sResizeListenerNoFlexboxSupportId){d.deregister(this._sResizeListenerNoFlexboxSupportId);this._sResizeListenerNoFlexboxSupportId=null;}};r.prototype.getFocusDomRef=function(F){var T=F||this.oSelectedItem;if(!T){return null;}return T.getDomRef();};r.prototype.applyFocusInfo=function(F){if(F.focusDomRef){q(F.focusDomRef).focus();}};r.prototype.ontouchstart=function(i){var T=i.targetTouches[0];this._iActiveTouch=T.identifier;this._iTouchStartPageX=T.pageX;this._iTouchStartPageY=T.pageY;this._iTouchDragX=0;this._iTouchDragY=0;var $=q(i.target);if($.hasClass('sapMITBArrowScroll')){i.preventDefault();}};r.prototype.ontouchmove=function(i){if(this._iActiveTouch===undefined){return;}var T=t.find(i.changedTouches,this._iActiveTouch);if(!T||T.pageX===this._iTouchStartPageX){return;}this._iTouchDragX+=Math.abs(this._iTouchStartPageX-T.pageX);this._iTouchDragY+=Math.abs(this._iTouchStartPageY-T.pageY);this._iTouchStartPageX=T.pageX;this._iTouchStartPageY=T.pageY;};r.prototype.ontouchend=function(i){if(this._iActiveTouch===undefined){return;}var M=D.system.desktop?5:15;if((this._scrollable&&this._iTouchDragX>M)||this._iTouchDragY>M){return;}var s=0;var L=1;var u;if(i.which===u||i.which===s||i.which===L){this._handleActivation(i);}this._iActiveTouch=undefined;};r.prototype.ontouchcancel=r.prototype.ontouchend;r.prototype.onsapselect=function(i){this._handleActivation(i);};r.prototype._handleDragAndDrop=function(i){var s=i.getParameter("dropPosition"),u=i.getParameter("draggedControl"),v=i.getParameter("droppedControl"),w=u.getParent().getMetadata().getName()==="sap.m.IconTabBarSelectList";if(w){this._handleDragAndDropBetweenHeaderAndList(s,v,u);}else{f.handleDrop(this,s,u,v,false);}this._initItemNavigation();u.$().focus();};r.prototype._handleDragAndDropBetweenHeaderAndList=function(s,i,u){var v=this._getSelectList(),w=f.getDraggedDroppedItemsFromList(v.getAggregation("items"),u,i);if(!w){return;}f.handleDrop(this,s,u._tabFilter,i,false);f.handleDrop(v,s,u,w.oDroppedControlFromList,false);v._initItemNavigation();};r.prototype._moveTab=function(T,K){var i=f.moveItem.call(this,T,K);this._initItemNavigation();if(i){this._scrollIntoView(T,0);}};r.prototype.ondragrearranging=function(i){if(!this.getEnableTabReordering()){return;}var T=i.srcControl;this._moveTab(T,i.keyCode);T.$().focus();};r.prototype.onsaphomemodifiers=r.prototype.ondragrearranging;r.prototype.onsapendmodifiers=r.prototype.ondragrearranging;r.prototype.onsapincreasemodifiers=r.prototype.ondragrearranging;r.prototype.onsapdecreasemodifiers=r.prototype.ondragrearranging;return r;});
