/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/base/events/KeyCodes","sap/ui/Device","sap/ui/core/Control","sap/ui/core/InvisibleText","sap/ui/core/LabelEnablement","sap/ui/core/delegate/ItemNavigation","./library","./InstanceManager","./GrowingEnablement","./GroupHeaderListItem","./ListItemBase","./ListBaseRenderer"],function(q,K,D,C,I,L,a,l,b,G,c,d,f){"use strict";var g=l.ListType;var h=l.ListKeyboardMode;var j=l.ListGrowingDirection;var S=l.SwipeDirection;var k=l.ListSeparators;var m=l.ListMode;var n=l.ListHeaderDesign;var o=C.extend("sap.m.ListBase",{metadata:{library:"sap.m",properties:{inset:{type:"boolean",group:"Appearance",defaultValue:false},headerText:{type:"string",group:"Misc",defaultValue:null},headerDesign:{type:"sap.m.ListHeaderDesign",group:"Appearance",defaultValue:n.Standard,deprecated:true},footerText:{type:"string",group:"Misc",defaultValue:null},mode:{type:"sap.m.ListMode",group:"Behavior",defaultValue:m.None},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:"100%"},includeItemInSelection:{type:"boolean",group:"Behavior",defaultValue:false},showUnread:{type:"boolean",group:"Misc",defaultValue:false},noDataText:{type:"string",group:"Misc",defaultValue:null},showNoData:{type:"boolean",group:"Misc",defaultValue:true},enableBusyIndicator:{type:"boolean",group:"Behavior",defaultValue:true},modeAnimationOn:{type:"boolean",group:"Misc",defaultValue:true},showSeparators:{type:"sap.m.ListSeparators",group:"Appearance",defaultValue:k.All},swipeDirection:{type:"sap.m.SwipeDirection",group:"Misc",defaultValue:S.Both},growing:{type:"boolean",group:"Behavior",defaultValue:false},growingThreshold:{type:"int",group:"Misc",defaultValue:20},growingTriggerText:{type:"string",group:"Appearance",defaultValue:null},growingScrollToLoad:{type:"boolean",group:"Behavior",defaultValue:false},growingDirection:{type:"sap.m.ListGrowingDirection",group:"Behavior",defaultValue:j.Downwards},rememberSelections:{type:"boolean",group:"Behavior",defaultValue:true},keyboardMode:{type:"sap.m.ListKeyboardMode",group:"Behavior",defaultValue:h.Navigation}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.ListItemBase",multiple:true,singularName:"item",bindable:"bindable",selector:"#{id} .sapMListItems",dnd:true},swipeContent:{type:"sap.ui.core.Control",multiple:false},headerToolbar:{type:"sap.m.Toolbar",multiple:false},infoToolbar:{type:"sap.m.Toolbar",multiple:false},contextMenu:{type:"sap.ui.core.IContextMenu",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},events:{select:{deprecated:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}},selectionChange:{parameters:{listItem:{type:"sap.m.ListItemBase"},listItems:{type:"sap.m.ListItemBase[]"},selected:{type:"boolean"},selectAll:{type:"boolean"}}},"delete":{parameters:{listItem:{type:"sap.m.ListItemBase"}}},swipe:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"},swipeContent:{type:"sap.ui.core.Control"},srcControl:{type:"sap.ui.core.Control"}}},growingStarted:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},growingFinished:{deprecated:true,parameters:{actual:{type:"int"},total:{type:"int"}}},updateStarted:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},updateFinished:{parameters:{reason:{type:"string"},actual:{type:"int"},total:{type:"int"}}},itemPress:{parameters:{listItem:{type:"sap.m.ListItemBase"},srcControl:{type:"sap.ui.core.Control"}}},beforeOpenContextMenu:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ListItemBase"}}}},designtime:"sap/m/designtime/ListBase.designtime"}});o.prototype.bAnnounceDetails=true;o.getInvisibleText=function(){return this.oInvisibleText||(this.oInvisibleText=new I().toStatic());};o.prototype.sNavItemClass="sapMLIB";o.prototype.init=function(){this._aNavSections=[];this._aSelectedPaths=[];this._iItemNeedsHighlight=0;this.data("sap-ui-fastnavgroup","true",true);};o.prototype.onBeforeRendering=function(){this._bRendering=true;this._bActiveItem=false;this._aNavSections=[];this._removeSwipeContent();};o.prototype.onAfterRendering=function(){this._bRendering=false;this._sLastMode=this.getMode();if(D.system.desktop){this._bItemNavigationInvalidated=true;}};o.prototype.exit=function(){this._oSelectedItem=null;this._aNavSections=[];this._aSelectedPaths=[];this._destroyGrowingDelegate();this._destroyItemNavigation();};o.prototype.refreshItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.refreshItems(r);}else{if(!this._bReceivingData){this._updateStarted(r);this._bReceivingData=true;}this.refreshAggregation("items");}};o.prototype.updateItems=function(r){if(this._oGrowingDelegate){this._oGrowingDelegate.updateItems(r);}else{if(this._bReceivingData){this._bReceivingData=false;}else{this._updateStarted(r);}this.updateAggregation("items");this._updateFinished();}};o.prototype.setBindingContext=function(){this._resetItemsBinding();return C.prototype.setBindingContext.apply(this,arguments);};o.prototype._bindAggregation=function(N,B){function e(B,E,H){B.events=B.events||{};if(!B.events[E]){B.events[E]=H;}else{var O=B.events[E];B.events[E]=function(){H.apply(this,arguments);O.apply(this,arguments);};}}if(N==="items"){this._resetItemsBinding();e(B,"dataRequested",this._onBindingDataRequestedListener.bind(this));e(B,"dataReceived",this._onBindingDataReceivedListener.bind(this));}C.prototype._bindAggregation.call(this,N,B);};o.prototype._onBindingDataRequestedListener=function(e){this._showBusyIndicator();if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}};o.prototype._onBindingDataReceivedListener=function(e){if(this._dataReceivedHandlerId!=null){q.sap.clearDelayedCall(this._dataReceivedHandlerId);delete this._dataReceivedHandlerId;}this._dataReceivedHandlerId=q.sap.delayedCall(0,this,function(){this._hideBusyIndicator();delete this._dataReceivedHandlerId;});};o.prototype.destroyItems=function(s){if(!this.getItems(true).length){return this;}this._oSelectedItem=null;this.destroyAggregation("items","KeepDom");if(!s){this.invalidate();}return this;};o.prototype.removeAllItems=function(A){this._oSelectedItem=null;return this.removeAllAggregation("items");};o.prototype.removeItem=function(i){var e=this.removeAggregation("items",i);if(e&&e===this._oSelectedItem){this._oSelectedItem=null;}return e;};o.prototype.getItems=function(r){if(r){return this.mAggregations["items"]||[];}return this.getAggregation("items",[]);};o.prototype.getId=function(s){var i=this.sId;return s?i+"-"+s:i;};o.prototype.setGrowing=function(e){e=!!e;if(this.getGrowing()!=e){this.setProperty("growing",e,!e);if(e){this._oGrowingDelegate=new G(this);}else if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}}return this;};o.prototype.setGrowingThreshold=function(t){return this.setProperty("growingThreshold",t,true);};o.prototype.setEnableBusyIndicator=function(e){this.setProperty("enableBusyIndicator",e,true);if(!this.getEnableBusyIndicator()){this._hideBusyIndicator();}return this;};o.prototype.setNoDataText=function(N){this.setProperty("noDataText",N,true);this.$("nodata-text").text(this.getNoDataText());return this;};o.prototype.getNoDataText=function(e){if(e&&this._bBusy){return"";}var N=this.getProperty("noDataText");N=N||sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("LIST_NO_DATA");return N;};o.prototype.getSelectedItem=function(){var e=this.getItems(true);for(var i=0;i<e.length;i++){if(e[i].getSelected()){return e[i];}}return null;};o.prototype.setSelectedItem=function(e,s,F){if(this.indexOfItem(e)<0){q.sap.log.warning("setSelectedItem is called without valid ListItem parameter on "+this);return;}if(this._bSelectionMode){e.setSelected((s===undefined)?true:!!s);F&&this._fireSelectionChangeEvent([e]);}};o.prototype.getSelectedItems=function(){return this.getItems(true).filter(function(i){return i.getSelected();});};o.prototype.setSelectedItemById=function(i,s){var e=sap.ui.getCore().byId(i);return this.setSelectedItem(e,s);};o.prototype.getSelectedContexts=function(A){var B=this.getBindingInfo("items"),M=(B||{}).model,e=this.getModel(M);if(!B||!e){return[];}if(A&&this.getRememberSelections()){return this._aSelectedPaths.map(function(p){return e.getContext(p);});}return this.getSelectedItems().map(function(i){return i.getBindingContext(M);});};o.prototype.removeSelections=function(A,F,e){var i=[];this._oSelectedItem=null;A&&(this._aSelectedPaths=[]);this.getItems(true).forEach(function(p){if(!p.getSelected()){return;}if(e&&p.isSelectedBoundTwoWay()){return;}p.setSelected(false,true);i.push(p);!A&&this._updateSelectedPaths(p);},this);if(F&&i.length){this._fireSelectionChangeEvent(i);}return this;};o.prototype.selectAll=function(F){if(this.getMode()!="MultiSelect"){return this;}var e=[];this.getItems(true).forEach(function(i){if(!i.getSelected()){i.setSelected(true,true);e.push(i);this._updateSelectedPaths(i);}},this);if(F&&e.length){this._fireSelectionChangeEvent(e,F);}return this;};o.prototype.getLastMode=function(M){return this._sLastMode;};o.prototype.setMode=function(M){M=this.validateProperty("mode",M);var O=this.getMode();if(O==M){return this;}this._bSelectionMode=M.indexOf("Select")>-1;if(!this._bSelectionMode){this.removeSelections(true);}else{var s=this.getSelectedItems();if(s.length>1){this.removeSelections(true);}else if(O===m.MultiSelect){this._oSelectedItem=s[0];}}return this.setProperty("mode",M);};o.prototype.getGrowingInfo=function(){return this._oGrowingDelegate?this._oGrowingDelegate.getInfo():null;};o.prototype.setRememberSelections=function(r){this.setProperty("rememberSelections",r,true);!this.getRememberSelections()&&(this._aSelectedPaths=[]);return this;};o.prototype.setSelectedContextPaths=function(s){this._aSelectedPaths=s||[];};o.prototype.getSelectedContextPaths=function(A){if(!A||(A&&this.getRememberSelections())){return this._aSelectedPaths.slice(0);}return this.getSelectedItems().map(function(i){return i.getBindingContextPath();});};o.prototype.isAllSelectableSelected=function(){if(this.getMode()!=m.MultiSelect){return false;}var i=this.getItems(true),s=this.getSelectedItems().length,e=i.filter(function(p){return p.isSelectable();}).length;return(i.length>0)&&(s==e);};o.prototype.getVisibleItems=function(){return this.getItems(true).filter(function(i){return i.getVisible();});};o.prototype.getActiveItem=function(){return this._bActiveItem;};o.prototype.onItemDOMUpdate=function(e){if(!this._bRendering&&this.bOutput){this._startItemNavigation(true);}};o.prototype.onItemActiveChange=function(e,A){this._bActiveItem=A;};o.prototype.onItemHighlightChange=function(i,N){this._iItemNeedsHighlight+=(N?1:-1);if(this._iItemNeedsHighlight==1&&N){this.$("listUl").addClass("sapMListHighlight");}else if(this._iItemNeedsHighlight==0){this.$("listUl").removeClass("sapMListHighlight");}};o.prototype.onItemSelectedChange=function(e,s){if(this.getMode()==m.MultiSelect){this._updateSelectedPaths(e,s);return;}if(s){this._aSelectedPaths=[];this._oSelectedItem&&this._oSelectedItem.setSelected(false,true);this._oSelectedItem=e;}else if(this._oSelectedItem===e){this._oSelectedItem=null;}this._updateSelectedPaths(e,s);};o.prototype.getItemsContainerDomRef=function(){return this.getDomRef("listUl");};o.prototype.checkGrowingFromScratch=function(){};o.prototype.onBeforePageLoaded=function(e,s){this._fireUpdateStarted(s,e);this.fireGrowingStarted(e);};o.prototype.onAfterPageLoaded=function(e,s){this._fireUpdateFinished(e);this.fireGrowingFinished(e);};o.prototype.addNavSection=function(i){this._aNavSections.push(i);return i;};o.prototype.getMaxItemsCount=function(){var B=this.getBinding("items");if(B&&B.getLength){return B.getLength()||0;}return this.getItems(true).length;};o.prototype.shouldRenderItems=function(){return true;};o.prototype._resetItemsBinding=function(){if(this.isBound("items")){this._bUpdating=false;this._bReceivingData=false;this.removeSelections(true,false,true);this._oGrowingDelegate&&this._oGrowingDelegate.reset();this._hideBusyIndicator();if(this._oItemNavigation){this._oItemNavigation.iFocusedIndex=-1;}}};o.prototype._updateStarted=function(r){if(!this._bReceivingData&&!this._bUpdating){this._bUpdating=true;this._fireUpdateStarted(r);}};o.prototype._fireUpdateStarted=function(r,i){this._sUpdateReason=q.sap.charToUpperCase(r||"Refresh");this.fireUpdateStarted({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});};o.prototype.onThemeChanged=function(){if(this._oGrowingDelegate){this._oGrowingDelegate._updateTrigger();}};o.prototype._updateFinished=function(){if(!this._bReceivingData&&this._bUpdating){this._fireUpdateFinished();this._bUpdating=false;}};o.prototype._fireUpdateFinished=function(i){this._hideBusyIndicator();q.sap.delayedCall(0,this,function(){this._bItemNavigationInvalidated=true;this.fireUpdateFinished({reason:this._sUpdateReason,actual:i?i.actual:this.getItems(true).length,total:i?i.total:this.getMaxItemsCount()});});};o.prototype._showBusyIndicator=function(){if(this.getEnableBusyIndicator()&&!this.getBusy()&&!this._bBusy){this._bBusy=true;this._sBusyTimer=q.sap.delayedCall(this.getBusyIndicatorDelay(),this,function(){this.$("nodata-text").text("");});this.setBusy(true,"listUl");}};o.prototype._hideBusyIndicator=function(){if(this._bBusy){this._bBusy=false;this.setBusy(false,"listUl");q.sap.clearDelayedCall(this._sBusyTimer);if(!this.getItems(true).length){this.$("nodata-text").text(this.getNoDataText());}}};o.prototype.onItemBindingContextSet=function(i){if(!this._bSelectionMode||!this.getRememberSelections()||!this.isBound("items")){return;}if(i.isSelectedBoundTwoWay()){return;}var p=i.getBindingContextPath();if(p){var s=(this._aSelectedPaths.indexOf(p)>-1);i.setSelected(s);}};o.prototype.onItemInserted=function(i,s){if(s){this.onItemSelectedChange(i,true);}if(!this._bSelectionMode||!this._aSelectedPaths.length||!this.getRememberSelections()||!this.isBound("items")||i.isSelectedBoundTwoWay()||i.getSelected()){return;}var p=i.getBindingContextPath();if(p&&this._aSelectedPaths.indexOf(p)>-1){i.setSelected(true);}};o.prototype.onItemSelect=function(e,s){if(this.getMode()==m.MultiSelect){this._fireSelectionChangeEvent([e]);}else if(this._bSelectionMode&&s){this._fireSelectionChangeEvent([e]);}};o.prototype._fireSelectionChangeEvent=function(e,s){var i=e&&e[0];if(!i){return;}this.fireSelectionChange({listItem:i,listItems:e,selected:i.getSelected(),selectAll:!!s});this.fireSelect({listItem:i});};o.prototype.onItemDelete=function(e){this.fireDelete({listItem:e});};o.prototype.onItemPress=function(e,s){if(e.getType()==g.Inactive){return;}q.sap.delayedCall(0,this,function(){this.fireItemPress({listItem:e,srcControl:s});});};o.prototype._updateSelectedPaths=function(i,s){if(!this.getRememberSelections()||!this.isBound("items")){return;}var p=i.getBindingContextPath();if(!p){return;}s=(s===undefined)?i.getSelected():s;var e=this._aSelectedPaths.indexOf(p);if(s){e<0&&this._aSelectedPaths.push(p);}else{e>-1&&this._aSelectedPaths.splice(e,1);}};o.prototype._destroyGrowingDelegate=function(){if(this._oGrowingDelegate){this._oGrowingDelegate.destroy();this._oGrowingDelegate=null;}};o.prototype._destroyItemNavigation=function(){if(this._oItemNavigation){this.removeEventDelegate(this._oItemNavigation);this._oItemNavigation.destroy();this._oItemNavigation=null;}};o.prototype._getTouchBlocker=function(){return this.$().children();};o.prototype._getSwipeContainer=function(){return this._$swipeContainer||(this._$swipeContainer=q("<div>",{"id":this.getId("swp"),"class":"sapMListSwp"}));};o.prototype._setSwipePosition=function(){if(this._isSwipeActive){return this._getSwipeContainer().css("top",this._swipedItem.$().position().top);}};o.prototype._renderSwipeContent=function(){var $=this._swipedItem.$(),e=this._getSwipeContainer();this.$().prepend(e.css({top:$.position().top,height:$.outerHeight(true)}));if(this._bRerenderSwipeContent){this._bRerenderSwipeContent=false;var r=sap.ui.getCore().createRenderManager();r.render(this.getSwipeContent(),e.empty()[0]);r.destroy();}return this;};o.prototype._swipeIn=function(){var t=this,$=t._getTouchBlocker(),i=t._getSwipeContainer();t._isSwipeActive=true;t._renderSwipeContent();b.addDialogInstance(t);window.document.activeElement.blur();q(window).on("resize.swp",function(){t._setSwipePosition();});$.css("pointer-events","none").on("touchstart.swp mousedown.swp",function(e){if(!i[0].firstChild.contains(e.target)){e.preventDefault();e.stopPropagation();}});i.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");i.css("opacity",1).focus();$.parent().on("touchend.swp touchcancel.swp mouseup.swp",function(e){if(!i[0].firstChild.contains(e.target)){t.swipeOut();}});}).removeClass("sapMListSwpOutAnim").addClass("sapMListSwpInAnim");};o.prototype._onSwipeOut=function(e){this._getSwipeContainer().css("opacity",0).remove();q(window).off("resize.swp");this._getTouchBlocker().css("pointer-events","auto").off("touchstart.swp mousedown.swp");if(typeof e=="function"){e.call(this,this._swipedItem,this.getSwipeContent());}this._isSwipeActive=false;b.removeDialogInstance(this);};o.prototype.swipeOut=function(e){if(!this._isSwipeActive){return this;}var t=this,$=this._getSwipeContainer();this._getTouchBlocker().parent().off("touchend.swp touchend.swp touchcancel.swp mouseup.swp");$.bind("webkitAnimationEnd animationend",function(){q(this).unbind("webkitAnimationEnd animationend");t._onSwipeOut(e);}).removeClass("sapMListSwpInAnim").addClass("sapMListSwpOutAnim");return this;};o.prototype._removeSwipeContent=function(){if(this._isSwipeActive){this.swipeOut()._onSwipeOut();}};o.prototype.close=o.prototype._removeSwipeContent;o.prototype._onSwipe=function(e){var i=this.getSwipeContent(),s=e.srcControl;if(i&&s&&!this._isSwipeActive&&this!==s&&!this._eventHandledByControl&&D.support.touch){for(var p=s;p&&!(p instanceof d);p=p.oParent);if(p instanceof d){this._swipedItem=p;this.fireSwipe({listItem:this._swipedItem,swipeContent:i,srcControl:s},true)&&this._swipeIn();}}};o.prototype.ontouchstart=function(e){this._eventHandledByControl=e.isMarked();};o.prototype.onswipeleft=function(e){var i=sap.ui.getCore().getConfiguration().getRTL()?"RightToLeft":"LeftToRight";if(this.getSwipeDirection()!=i){this._onSwipe(e);}};o.prototype.onswiperight=function(e){var i=sap.ui.getCore().getConfiguration().getRTL()?"LeftToRight":"RightToLeft";if(this.getSwipeDirection()!=i){this._onSwipe(e);}};o.prototype.setSwipeDirection=function(s){return this.setProperty("swipeDirection",s,true);};o.prototype.getSwipedItem=function(){return(this._isSwipeActive?this._swipedItem:null);};o.prototype.setSwipeContent=function(e){this._bRerenderSwipeContent=true;this.toggleStyleClass("sapMListSwipable",!!e);return this.setAggregation("swipeContent",e,!this._isSwipeActive);};o.prototype.invalidate=function(O){if(O&&O===this.getSwipeContent()){this._bRerenderSwipeContent=true;this._isSwipeActive&&this._renderSwipeContent();return this;}return C.prototype.invalidate.apply(this,arguments);};o.prototype.addItemGroup=function(e,H,s){H=H||new c({title:e.text||e.key});H._bGroupHeader=true;this.addAggregation("items",H,s);return H;};o.prototype.removeGroupHeaders=function(s){this.getItems(true).forEach(function(i){if(i.isGroupHeader()){i.destroy(s);}});};o.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_LIST");};o.prototype.getAccessibilityStates=function(){if(!this.getItems(true).length){return"";}var s="",M=m,e=this.getMode(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m");if(L.isRequired(this)){s+=B.getText("LIST_REQUIRED")+" ";}if(e==M.MultiSelect){s+=B.getText("LIST_MULTISELECTABLE")+" ";}else if(e==M.Delete){s+=B.getText("LIST_DELETABLE")+" ";}else if(e!=M.None){s+=B.getText("LIST_SELECTABLE")+" ";}if(this.isGrouped()){s+=B.getText("LIST_GROUPED")+" ";}return s;};o.prototype.getAccessibilityDescription=function(){var s=this.getAriaLabelledBy().map(function(A){var e=sap.ui.getCore().byId(A);return d.getAccessibilityText(e);}).join(" ");var H=this.getHeaderToolbar();if(H){var t=H.getTitleControl();if(t){s+=t.getText()+" ";}}else{s+=this.getHeaderText()+" ";}s+=this.getAccessibilityStates()+" ";return s;};o.prototype.getAccessibilityInfo=function(){return{description:this.getAccessibilityDescription().trim(),focusable:true};};o.prototype.getAccessbilityPosition=function(i){var s=0,e=this.getVisibleItems(),p=e.indexOf(i)+1,B=this.getBinding("items");if(this.getGrowing()&&this.getGrowingScrollToLoad()&&B&&B.isLengthFinal()){s=B.getLength();if(B.isGrouped()){s+=e.filter(function(i){return i.isGroupHeader()&&i.getVisible();}).length;}}else{s=e.length;}return{setSize:s,posInset:p};};o.prototype.onItemFocusIn=function(i,F){if(i!==F){return;}if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}var e=i.getDomRef(),p=this.getAccessbilityPosition(i);if(!i.getContentAnnouncement){this.getNavigationRoot().setAttribute("aria-activedescendant",e.id);e.setAttribute("aria-posinset",p.posInset);e.setAttribute("aria-setsize",p.setSize);}else{var A=i.getAccessibilityInfo(),B=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s=A.type+" ";s+=B.getText("LIST_ITEM_POSITION",[p.posInset,p.setSize])+" ";s+=A.description;this.updateInvisibleText(s,e);return s;}};o.prototype.updateInvisibleText=function(t,i,p){var e=o.getInvisibleText(),F=q(i||document.activeElement);if(this.bAnnounceDetails){this.bAnnounceDetails=false;t=this.getAccessibilityInfo().description+" "+t;}e.setText(t.trim());F.addAriaLabelledBy(e.getId(),p);window.setTimeout(function(){F.removeAriaLabelledBy(e.getId());},0);};o.prototype.getNavigationRoot=function(){return this.getDomRef("listUl");};o.prototype.getFocusDomRef=function(){return this.getNavigationRoot();};o.prototype._startItemNavigation=function(i){if(!D.system.desktop){return;}var s=this.getKeyboardMode(),e=h;if(s==e.Edit&&!this.getItems(true).length){return;}var N=this.getNavigationRoot();var t=(s==e.Edit)?-1:0;if(i&&!N.contains(document.activeElement)){this._bItemNavigationInvalidated=true;if(!N.getAttribute("tabindex")){N.tabIndex=t;}return;}if(!this._oItemNavigation){this._oItemNavigation=new a();this._oItemNavigation.setCycling(false);this.addEventDelegate(this._oItemNavigation);this._setItemNavigationTabIndex(t);this._oItemNavigation.setTableMode(true,true).setColumns(1);this._oItemNavigation.setDisabledModifiers({sapnext:["alt"],sapprevious:["alt"]});}this._oItemNavigation.setPageSize(this.getGrowingThreshold());this._oItemNavigation.setRootDomRef(N);this.setNavigationItems(this._oItemNavigation,N);this._bItemNavigationInvalidated=false;};o.prototype.setNavigationItems=function(i,N){var e=q(N).children(".sapMLIB").get();i.setItemDomRefs(e);if(i.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==j.Upwards){i.setFocusedIndex(e.length-1);}else{i.setFocusedIndex(0);}}};o.prototype.getItemNavigation=function(){return this._oItemNavigation;};o.prototype._setItemNavigationTabIndex=function(t){if(this._oItemNavigation){this._oItemNavigation.iActiveTabIndex=t;this._oItemNavigation.iTabIndex=t;}};o.prototype.setKeyboardMode=function(s){this.setProperty("keyboardMode",s,true);if(this.isActive()){var t=(s==h.Edit)?-1:0;this.$("nodata").prop("tabIndex",~t);this.$("listUl").prop("tabIndex",t);this.$("after").prop("tabIndex",t);this._setItemNavigationTabIndex(t);}return this;};o.prototype.setItemFocusable=function(e){if(!this._oItemNavigation){return;}var i=this._oItemNavigation.getItemDomRefs();var p=i.indexOf(e.getDomRef());if(p>=0){this._oItemNavigation.setFocusedIndex(p);}};o.prototype.forwardTab=function(F){this._bIgnoreFocusIn=true;this.$(F?"after":"before").focus();};o.prototype.onsaptabnext=function(e){if(e.isMarked()||this.getKeyboardMode()==h.Edit){return;}if(e.target.id==this.getId("nodata")){this.forwardTab(true);e.setMarked();}};o.prototype.onsaptabprevious=function(e){if(e.isMarked()||this.getKeyboardMode()==h.Edit){return;}var t=e.target.id;if(t==this.getId("nodata")){this.forwardTab(false);}else if(t==this.getId("trigger")){this.focusPrevious();e.preventDefault();}};o.prototype._navToSection=function(F){var t;var i=0;var s=F?1:-1;var e=this._aNavSections.length;this._aNavSections.some(function(r,u){var v=q.sap.domById(r);if(v&&v.contains(document.activeElement)){i=u;return true;}});var p=this.getItemsContainerDomRef();var $=q.sap.byId(this._aNavSections[i]);if($[0]===p&&this._oItemNavigation){$.data("redirect",this._oItemNavigation.getFocusedIndex());}this._aNavSections.some(function(){i=(i+s+e)%e;t=q.sap.byId(this._aNavSections[i]);if(t[0]===p&&this._oItemNavigation){var r=t.data("redirect");var u=this._oItemNavigation.getItemDomRefs();var T=u[r]||p.children[0];t=q(T);}if(t.is(":focusable")){t.focus();return true;}},this);return t;};o.prototype.onsapshow=function(e){if(e.isMarked()||e.which==K.F4||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(true)){e.preventDefault();e.setMarked();}};o.prototype.onsaphide=function(e){if(e.isMarked()||e.target.id!=this.getId("trigger")&&!q(e.target).hasClass(this.sNavItemClass)){return;}if(this._navToSection(false)){e.preventDefault();e.setMarked();}};o.prototype.onkeydown=function(e){var i=(e.which==K.A)&&(e.metaKey||e.ctrlKey);if(e.isMarked()||!i||!q(e.target).hasClass(this.sNavItemClass)){return;}e.preventDefault();if(this.getMode()!==m.MultiSelect){return;}if(this.isAllSelectableSelected()){this.removeSelections(false,true);}else{this.selectAll(true);}e.setMarked();};o.prototype.onmousedown=function(e){if(this._bItemNavigationInvalidated){this._startItemNavigation();}};o.prototype.focusPrevious=function(){if(!this._oItemNavigation){return;}var N=this._oItemNavigation.getItemDomRefs();var i=this._oItemNavigation.getFocusedIndex();var $=q(N[i]);var r=$.control(0)||{};var t=r.getTabbables?r.getTabbables():$.find(":sapTabbable");var F=t.eq(-1).add($).eq(-1);this.bAnnounceDetails=true;F.focus();};o.prototype.onfocusin=function(e){if(this._bIgnoreFocusIn){this._bIgnoreFocusIn=false;e.stopImmediatePropagation(true);return;}if(this._bItemNavigationInvalidated){this._startItemNavigation();}var t=e.target;if(t.id==this.getId("nodata")){this.updateInvisibleText(this.getNoDataText(),t);}if(e.isMarked()||!this._oItemNavigation||this.getKeyboardMode()==h.Edit||t.id!=this.getId("after")){return;}this.focusPrevious();e.setMarked();};o.prototype.onsapfocusleave=function(e){if(this._oItemNavigation&&!this.bAnnounceDetails&&!this.getNavigationRoot().contains(document.activeElement)){this.bAnnounceDetails=true;}};o.prototype.onItemArrowUpDown=function(e,E){var i=this.getItems(true),p=i.indexOf(e)+(E.type=="sapup"?-1:1),r=i[p];if(r&&r.isGroupHeader()){r=i[p+(E.type=="sapup"?-1:1)];}if(!r){return;}var t=r.getTabbables(),F=e.getTabbables().index(E.target),$=t.eq(t[F]?F:-1);$[0]?$.focus():r.focus();E.preventDefault();E.setMarked();};o.prototype.onItemContextMenu=function(e,E){var i=this.getContextMenu();if(!i){return;}var p=this.fireBeforeOpenContextMenu({listItem:e,column:sap.ui.getCore().byId(q(E.target).closest(".sapMListTblCell",this.getNavigationRoot()).attr("data-sap-ui-column"))});if(p){E.setMarked();E.preventDefault();var B,r=this.getBindingInfo("items");if(r){B=e.getBindingContext(r.model);i.setBindingContext(B);}i.openAsContextMenu(E,e);}};o.prototype.isGrouped=function(){var B=this.getBinding("items");return B&&B.isGrouped();};o.prototype.setContextMenu=function(e){this.setAggregation("contextMenu",e,true);};o.prototype.destroyContextMenu=function(){this.destroyAggregation("contextMenu",true);};return o;});
