/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','./Button','./Dialog','./NavContainer','./List','./Page','./MenuListItem','sap/ui/unified/Menu','sap/ui/unified/MenuItem','sap/ui/Device','sap/ui/core/EnabledPropagator'],function(q,l,C,B,D,N,L,P,M,U,a,b,E){"use strict";var c=l.ListType;var d=l.ListMode;var e=C.extend("sap.m.Menu",{metadata:{interfaces:["sap.ui.core.IContextMenu"],library:"sap.m",properties:{title:{type:"string",group:"Misc",defaultValue:null}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MenuItem",multiple:true,singularName:"item",bindable:"bindable"},_dialog:{type:"sap.m.Dialog",multiple:false,visibility:"hidden"},_menu:{type:"sap.ui.unified.Menu",multiple:false,visibility:"hidden"}},events:{itemSelected:{parameters:{item:{type:"sap.m.MenuItem"}}},closed:{}}}});E.call(e.prototype);e.UNIFIED_MENU_ITEMS_ID_SUFFIX='-unifiedmenu';e.UNFIFIED_MENU_ITEMS_PROPS=a.getMetadata().getAllProperties();e.LIST_ITEMS_ID_SUFFIX='-menuinnerlist';e.MENU_LIST_ITEMS_PROPS=M.getMetadata().getAllProperties();e.prototype.init=function(){if(b.system.phone){this._initDialog();}this._bIsInitialized=false;};e.prototype.exit=function(){if(this._navContainerId){this._navContainerId=null;}if(this._bIsInitialized){this._bIsInitialized=null;}if(this._getMenu()&&this._getMenu().getPopup()){this._getMenu().getPopup().detachClosed(this._menuClosed,this);}};e.prototype.invalidate=function(){};e.prototype.setTitle=function(t){var n=this._getNavContainer();this.setProperty("title",t,true);if(n&&n.getPages().length){n.getPages()[0].setTitle(t);}return this;};e.prototype.openBy=function(o,w,s,h,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}var i=sap.ui.core.Popup.Dock;if(!s){s=i.BeginTop;}if(!h){h=i.BeginBottom;}if(!O){O="0 -2";}this._getMenu().open(w,o,s,h,o,O);}};e.prototype.close=function(){if(b.system.phone){this._getDialog().close();}else{this._getVisualParent().close();}};e.prototype._initDialog=function(){var o=new D({showHeader:false,stretch:true,content:this._initNavContainer(),buttons:[this._initCloseButton()]});o.addStyleClass("sapMRespMenuDialog");o.removeStyleClass("sapUiPopupWithPadding");this.setAggregation("_dialog",o,true);};e.prototype._getDialog=function(){return this.getAggregation("_dialog");};e.prototype._openDialog=function(){if(!this._bIsInitialized){this._initAllPages();this._bIsInitialized=true;}this._getNavContainer().to(this._getNavContainer().getPages()[0]);this._getDialog().open();};e.prototype._initAllMenuItems=function(){this._initMenuForItems(this.getItems());};e.prototype._initMenuForItems=function(i,p){var m=new U();m.isCozy=this._isMenuCozy.bind(this,m);this.addStyleClass('sapMMenu');m.aCustomStyleClasses=this.aCustomStyleClasses;m.mCustomStyleClassMap=this.mCustomStyleClassMap;i.forEach(function(I){this._addVisualMenuItemFromItem(I,m);}.bind(this));if(p){p.setSubmenu(m);}else{m.getPopup().attachClosed(this._menuClosed,this);this.setAggregation('_menu',m,true);}m.attachItemSelect(this._handleMenuItemSelect,this);};e.prototype._menuClosed=function(){this.fireClosed();};e.prototype._getMenu=function(){return this.getAggregation("_menu");};e.prototype._initCloseButton=function(){var r=sap.ui.getCore().getLibraryResourceBundle("sap.m");return new B({text:r.getText("MENU_CLOSE"),press:f.bind(this)});};function f(){this._getDialog().close();}e.prototype._initNavContainer=function(){var n=new N();this._navContainerId=n.getId();return n;};e.prototype._getNavContainer=function(){return sap.ui.getCore().byId(this._navContainerId);};e.prototype._initAllPages=function(){this._initPageForParent(this);};e.prototype._initPageForParent=function(p){var i=p.getItems(),h=p instanceof e,s=h?p.getTitle():p.getText(),o=new L({mode:d.None}),j=new P({title:s,showNavButton:!h,content:o});if(!h){this._setBackButtonTooltipForPageWithParent(p,j);}j.attachNavButtonPress(function(){this._getNavContainer().back();},this);this._getNavContainer().addPage(j);i.forEach(function(I){this._addListItemFromItem(I,j);},this);this._updateListInset(o);o.attachEvent("itemPress",this._handleListItemPress,this);return j;};e.prototype._handleListItemPress=function(o){var h=o.getParameter("listItem"),m=sap.ui.getCore().byId(h.getMenuItem()),p=m._getVisualChild();if(p){this._getNavContainer().to(p);}else{this._getDialog().close();this.fireItemSelected({item:m});}m.firePress();};e.prototype._setBackButtonTooltipForPageWithParent=function(p,o){var h=p.getParent(),r=sap.ui.getCore().getLibraryResourceBundle("sap.m"),s;s=h instanceof e?h.getTitle():h.getText();s=r.getText("MENU_PAGE_BACK_BUTTON")+" "+s;o.setNavButtonTooltip(s);};e.prototype._createMenuListItemFromItem=function(i){return new M({id:this._generateListItemId(i.getId()),type:c.Active,icon:i.getIcon(),title:i.getText(),startsSection:i.getStartsSection(),menuItem:i,tooltip:i.getTooltip(),visible:i.getVisible()});};e.prototype._createVisualMenuItemFromItem=function(i){return new a({id:this._generateUnifiedMenuItemId(i.getId()),icon:i.getIcon(),text:i.getText(),startsSection:i.getStartsSection(),tooltip:i.getTooltip(),visible:i.getVisible(),enabled:i.getEnabled()});};e.prototype._addVisualMenuItemFromItem=function(i,m,I){var o=this._createVisualMenuItemFromItem(i);i._setVisualParent(m);i._setVisualControl(o);var h=['aggregationChanged','propertyChanged'];h.forEach(function(s){var j='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[j],this);},this);if(i.getItems().length!==0){this._initMenuForItems(i.getItems(),o);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){m.addItem(o);}else{m.insertItem(o,I);}};e.prototype._addListItemFromItem=function(i,p,I){var m=this._createMenuListItemFromItem(i),o=p.getContent()[0];i._setVisualParent(p);i._setVisualControl(m);var h=['aggregationChanged','propertyChanged'];h.forEach(function(s){var j='_on'+s.slice(0,1).toUpperCase()+s.slice(1);i.attachEvent(s,this[j],this);},this);if(i.getItems().length!==0){this._initPageForParent(i);i._setVisualChild(i.getItems()[0]._getVisualParent());}if(I===undefined){o.addItem(m);}else{o.insertItem(m,I);}o.rerender();};e.prototype._connectVisualItem=function(i,o,I){if(!o||sap.ui.getCore().byId(i._getVisualControl())){return;}if(b.system.phone){this._addListItemFromItem(i,o,I);var h=o.getContent()[0];this._updateListInset(h);}else{this._addVisualMenuItemFromItem(i,o,I);}};e.prototype._updateListInset=function(o){var h=false,I="sapMListIcons",j=o.getItems();for(var i=0;i<j.length;i++){if(j[i].getIcon()){h=true;break;}}if(h){o.addStyleClass(I);}else{o.removeStyleClass(I);}};e.prototype._handleMenuItemSelect=function(o){var u=o.getParameter("item"),m;if(!u){return;}m=this._findMenuItemByUnfdMenuItem(u);if(m&&!m.getItems().length){this.fireItemSelected({item:m});}if(m){m.firePress();}};e.prototype._generateListItemId=function(m){return m+e.LIST_ITEMS_ID_SUFFIX;};e.prototype._generateUnifiedMenuItemId=function(m){return m+e.UNIFIED_MENU_ITEMS_ID_SUFFIX;};e.prototype._findMenuItemByUnfdMenuItem=function(u){var h=[],o=u,I,j,i;do{h.push(o.getId());o=o.getParent().getParent();}while(o instanceof a);I=this.getItems();do{j=h.pop();for(i=0;i<I.length;i++){if(I[i]._getVisualControl()===j){if(h.length===0){return I[i];}else{I=I[i].getItems();break;}}}}while(h.length);return null;};e.prototype._isMenuCozy=function(m){if(!m.bCozySupported){return false;}if(m.hasStyleClass("sapUiSizeCozy")){return true;}if(g(m.oOpenerRef)){return true;}return false;};function g(r){if(!r){return false;}r=r.$?r.$():q(r);var $=r.closest(".sapUiSizeCompact,.sapUiSizeCondensed,.sapUiSizeCozy");return(!$.hasClass("sapUiSizeCompact")&&!$.hasClass("sapUiSizeCondensed"))||$.hasClass("sapUiSizeCozy");}e.prototype.addAggregation=function(A,o,s){C.prototype.addAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent());}return this;};e.prototype.insertAggregation=function(A,o,i,s){C.prototype.insertAggregation.apply(this,arguments);if(A==="items"){this._connectVisualItem(o,this._getVisualParent(),i);}return this;};e.prototype.removeAggregation=function(A,o,s){var i=C.prototype.removeAggregation.apply(this,arguments);if(A==="items"){this._removeVisualItem(i);}return i;};e.prototype.removeAllAggregation=function(A,s){var I=C.prototype.removeAllAggregation.apply(this,arguments);if(A==="items"){for(var i=0;i<I.length;i++){this._removeVisualItem(I[i]);}}return I;};e.prototype._removeVisualItem=function(i,p){var v=sap.ui.getCore().byId(i._getVisualControl()),m;if(v){m=v.getParent();m.removeItem(v);if(b.system.phone){this._removeSubPageForItem(i);if(m.getItems().length===0){if(p){p._setVisualChild(null);sap.ui.getCore().byId(p._getVisualControl()).rerender();}}if(m){m.rerender();}}}};e.prototype.destroyAggregation=function(A,s){if(A==="items"){for(var i=0;i<this.getItems().length;i++){this._removeVisualItem(this.getItems()[i]);}}return C.prototype.destroyAggregation.apply(this,arguments);};e.prototype._removeSubPageForItem=function(I,s){var S;if(!s){for(var i=0;i<I.getItems().length;i++){this._removeSubPageForItem(I.getItems()[i]);}}if(I._getVisualChild()){S=sap.ui.getCore().byId(I._getVisualChild());if(this._getNavContainer()&&S){this._getNavContainer().removePage(S);}!!S&&S.destroy();}};e.prototype._getVisualParent=function(){var n=this._getNavContainer(),m=this._getMenu();if(n&&n.getPages().length){return n.getPages()[0];}else{return m;}};e.prototype._onPropertyChanged=function(o){var p=o.getParameter("propertyKey"),h=o.getParameter("propertyValue"),t=b.system.phone?e.MENU_LIST_ITEMS_PROPS:e.UNFIFIED_MENU_ITEMS_PROPS,G=b.system.phone?this._generateListItemId:this._generateUnifiedMenuItemId,T;if(b.system.phone&&p==='text'){p='title';}if(!t[p]){return;}T=G(o.getSource().getId());if(T){sap.ui.getCore().byId(T).setProperty(p,h);if(b.system.phone&&this._getDialog().isOpen()){this._getDialog().close();}}};e.prototype._onAggregationChanged=function(o){var A=o.getParameter("aggregationName");switch(A){case'items':this._onItemsAggregationChanged(o);break;}};e.prototype._onItemsAggregationChanged=function(o){var I=o.getSource(),m=o.getParameter("methodName"),h=o.getParameter("methodParams"),j;if(m==="add"||m==="insert"){if(m==="insert"){j=h.index;}this._addOrInsertItem(I,h.item,j);}if(m==="remove"){this._removeVisualItem(h.item,I);}if(m==="removeall"){for(var i=0;i<h.items.length;i++){this._removeVisualItem(h.items[i],I);}}if(m==="destroy"){this._destroyItem(I);}};e.prototype._addOrInsertItem=function(p,n,i){var o;if(p._getVisualChild()){this._connectVisualItem(n,sap.ui.getCore().byId(p._getVisualChild()),i);}else{if(b.system.phone){this._initPageForParent(p);p._setVisualChild(p.getItems()[0]._getVisualParent());o=sap.ui.getCore().byId(p._getVisualControl());o.rerender();}else{this._initMenuForItems(p.getItems(),sap.ui.getCore().byId(p._getVisualControl()));p._setVisualChild(p.getItems()[0]._getVisualParent());}}};e.prototype._destroyItem=function(i){var v=sap.ui.getCore().byId(i._getVisualControl());if(v&&v.setMenuItem){v.setMenuItem(null);}this._removeSubPageForItem(i,true);i._setVisualChild(null);if(v&&v.setMenuItem){v.rerender();v.setMenuItem(i);}};e.prototype.getDomRefId=function(){if(b.system.phone){return this._getDialog().getId();}else{return this._getMenu().getId();}};e.prototype.openAsContextMenu=function(o,O){if(b.system.phone){this._openDialog();}else{if(!this._bIsInitialized){this._initAllMenuItems();this._bIsInitialized=true;}this._getMenu().openAsContextMenu(o,O);}};["addStyleClass","removeStyleClass","toggleStyleClass"].forEach(function(m){e.prototype[m]=function(s,S){var o=this._getDialog();C.prototype[m].apply(this,arguments);if(o){o[m].apply(o,arguments);}return this;};});return e;});
