/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/core/Control","sap/ui/core/CustomData","sap/ui/core/IconPool","sap/ui/core/HTML","sap/ui/core/Icon","./Button","./Toolbar","./ToolbarSpacer","./List","./StandardListItem","./library","./Text","./SegmentedButton","./Page","./NavContainer","./Link","./MessageItem","./GroupHeaderListItem","sap/ui/core/library","sap/ui/base/ManagedObject","./MessageViewRenderer","jquery.sap.keycodes"],function(q,C,a,I,H,b,B,T,c,L,S,l,d,e,P,N,f,M,G,g,h,j){"use strict";var V=g.ValueState;var k=g.MessageType;var m=l.ListType;var n=C.extend("sap.m.MessageView",{metadata:{library:"sap.m",properties:{asyncDescriptionHandler:{type:"any",group:"Behavior",defaultValue:null},asyncURLHandler:{type:"any",group:"Behavior",defaultValue:null},groupItems:{type:"boolean",group:"Behavior",defaultValue:false},showDetailsPageHeader:{type:"boolean",group:"Behavior",defaultValue:true}},defaultAggregation:"items",aggregations:{items:{type:"sap.m.MessageItem",multiple:true,singularName:"item"},headerButton:{type:"sap.m.Button",multiple:false},_navContainer:{type:"sap.m.NavContainer",multiple:false,visibility:"hidden"}},events:{afterOpen:{parameters:{openBy:{type:"sap.ui.core.Control"}}},itemSelect:{parameters:{item:{type:"sap.m.MessageItem"},messageTypeFilter:{type:"sap.ui.core.MessageType"}}},listSelect:{parameters:{messageTypeFilter:{type:"sap.ui.core.MessageType"}}},longtextLoaded:{},urlValidated:{}}}});var o="sapMMsgView";var p={back:I.getIconURI("nav-back"),close:I.getIconURI("decline"),information:I.getIconURI("message-information"),warning:I.getIconURI("message-warning"),error:I.getIconURI("message-error"),success:I.getIconURI("message-success")};var r=["all","error","warning","success","information"];var A=["asyncDescriptionHandler","asyncURLHandler"];var D={asyncDescriptionHandler:function(i){var s=i.item.getLongtextUrl();if(s){q.ajax({type:"GET",url:s,success:function(t){i.item.setDescription(t);i.promise.resolve();},error:function(){var E="A request has failed for long text data. URL: "+s;q.sap.log.error(E);i.promise.reject(E);}});}}};n.setDefaultHandlers=function(i){A.forEach(function(F){if(i.hasOwnProperty(F)){D[F]=i[F];}});};n.prototype.init=function(){var t=this;this._bHasHeaderButton=false;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._createNavigationPages();this._createLists();A.forEach(function(F){if(D.hasOwnProperty(F)){t.setProperty(F,D[F]);}});};n.prototype.onBeforeRendering=function(){var i,s=this.getItems();this._clearLists();this._detailsPage.setShowHeader(this.getShowDetailsPageHeader());if(this.getGroupItems()){i=this._groupItems(s);this._fillGroupedLists(i);}else{this._fillLists(s);}var t=this.getHeaderButton();if(t){this._bHasHeaderButton=true;this._oListHeader.insertContent(t,2);}this._clearSegmentedButton();this._fillSegmentedButton();this._fnFilterList(this._getCurrentMessageTypeFilter()||"all");if(s.length===1&&this._oLists.all.getItems()[0].getType()===m.Navigation){this._fnHandleForwardNavigation(this._oLists.all.getItems()[0],"show");this._navContainer._pageStack[this._navContainer._pageStack.length-1].transition="slide";}if(!this.getBindingInfo("items")&&!s.length){this._makeAutomaticBinding();}};n.prototype._fillGroupedLists=function(i){var s=Object.keys(i),u=s.indexOf(""),U,t;if(u!==-1){U=i[""];t=Object.keys(U);t.forEach(function(v){var w=U[v];this._fillLists(w);delete i[""];s.splice(u,1);},this);}s.forEach(function(v){this._fillListsWithGroups(v,i[v]);},this);};n.prototype._fillListsWithGroups=function(s,i){var t=Object.keys(i),u=new G({title:s}),v;this._oLists["all"].addAggregation("items",u,true);t.forEach(function(w){this._oLists[w.toLowerCase()].addAggregation("items",u.clone(),true);v=i[w];this._fillLists(v);},this);};n.prototype.exit=function(){if(this._oLists){this._destroyLists();}if(this._oMessageItemTemplate){this._oMessageItemTemplate.destroy();}this._oResourceBundle=null;this._oListHeader=null;this._oDetailsHeader=null;this._oSegmentedButton=null;this._oBackButton=null;this._navContainer=null;this._listPage=null;this._detailsPage=null;this._sCurrentList=null;};n.prototype._makeAutomaticBinding=function(){var t=this;this.setModel(sap.ui.getCore().getMessageManager().getMessageModel(),"message");this._oMessageItemTemplate=new M({type:"{message>type}",title:"{message>message}",description:"{message>description}",longtextUrl:"{message>longtextUrl}"});this.bindAggregation("items",{path:"message>/",template:t._oMessageItemTemplate});};n.prototype._groupItems=function(i){var s={},t,u;i.forEach(function(v){t=v.getGroupName();u=v.getType();s[t]=s[t]||{};var w=s[t];if(w[u]){w[u].push(v);}else{w[u]=[v];}});return s;};n.prototype._onkeypress=function(E){if(E.shiftKey&&E.keyCode==q.sap.KeyCodes.ENTER){this.navigateBack();}};n.prototype._getListHeader=function(){return this._oListHeader||this._createListHeader();};n.prototype._getDetailsHeader=function(){return this._oDetailsHeader||this._createDetailsHeader();};n.prototype._createListHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDescr";var t=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var u=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_HEADING");var v=this.getId()+"-HeadingDescr";var w=new H(v,{content:"<span id=\""+v+"\" style=\"display: none;\" role=\"heading\">"+u+"</span>"});this._oSegmentedButton=new e(this.getId()+"-segmented",{}).addStyleClass("sapMSegmentedButtonNoAutoWidth");this._oListHeader=new T({content:[this._oSegmentedButton,new c(),t,w]});return this._oListHeader;};n.prototype._createDetailsHeader=function(){var s=this._oResourceBundle.getText("MESSAGEPOPOVER_CLOSE");var i=this.getId()+"-CloseBtnDetDescr";var t=new H(i,{content:"<span id=\""+i+"\" style=\"display: none;\">"+s+"</span>"});var u=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON_TOOLTIP");var v=this._oResourceBundle.getText("MESSAGEPOPOVER_ARIA_BACK_BUTTON");var w=this.getId()+"-BackBtnDetDescr";var x=new H(w,{content:"<span id=\""+w+"\" style=\"display: none;\">"+v+"</span>"});this._oBackButton=new B({icon:p["back"],press:this.navigateBack.bind(this),ariaLabelledBy:x,tooltip:u}).addStyleClass(o+"BackBtn");this._oDetailsHeader=new T({content:[this._oBackButton,new c(),t,x]});return this._oDetailsHeader;};n.prototype._createNavigationPages=function(){this._listPage=new P(this.getId()+"listPage",{customHeader:this._getListHeader()});this._detailsPage=new P(this.getId()+"-detailsPage",{customHeader:this._getDetailsHeader()});this._detailsPage.addEventDelegate({onclick:function(E){var t=E.target;if(t.nodeName.toUpperCase()==="A"&&(t.className.indexOf("sapMMsgPopoverItemDisabledLink")!==-1||t.className.indexOf("sapMMsgPopoverItemPendingLink")!==-1)){E.preventDefault();}}});this._navContainer=new N(this.getId()+"-navContainer",{initialPage:this.getId()+"listPage",pages:[this._listPage,this._detailsPage]});this.setAggregation("_navContainer",this._navContainer);return this;};n.prototype._createLists=function(){this._oLists={};r.forEach(function(s){this._oLists[s]=new L({itemPress:this._fnHandleItemPress.bind(this),visible:false});this._listPage.addAggregation("content",this._oLists[s],true);},this);return this;};n.prototype._clearLists=function(){r.forEach(function(s){if(this._oLists[s]){this._oLists[s].destroyAggregation("items",true);}},this);return this;};n.prototype._destroyLists=function(){r.forEach(function(s){this._oLists[s]=null;},this);this._oLists=null;};n.prototype._fillLists=function(i){i.forEach(function(s){var t=this._mapItemToListItem(s),u=this._mapItemToListItem(s);this._oLists["all"].addAggregation("items",t,true);this._oLists[s.getType().toLowerCase()].addAggregation("items",u,true);},this);};n.prototype._mapItemToListItem=function(i){if(!i){return null;}var t=i.getType(),s=this._getItemType(i),u=new S({title:h.escapeSettingsValue(i.getTitle()),description:h.escapeSettingsValue(i.getSubtitle()),counter:i.getCounter(),icon:this._mapIcon(t),infoState:this._mapInfoState(t),info:"\r",type:s}).addStyleClass(o+"Item").addStyleClass(o+"Item"+t);if(s!==m.Navigation){u.addEventDelegate({onAfterRendering:function(){var v=this.getDomRef().querySelector(".sapMSLITitleDiv > div");if(v.offsetWidth<v.scrollWidth){this.setType(m.Navigation);}}},u);}u._oMessageItem=i;return u;};n.prototype._mapInfoState=function(t){if(!t){return null;}switch(t){case k.Warning:return V.Warning;case k.Error:return V.Error;case k.Success:return V.Success;case k.Information:case k.None:return V.None;default:q.sap.log.warning("The provided MessageType is not mapped to a specific ValueState",t);return null;}};n.prototype._mapIcon=function(i){if(!i){return null;}return p[i.toLowerCase()];};n.prototype._getItemType=function(i){return(i.getDescription()||i.getMarkupDescription()||i.getLongtextUrl())?m.Navigation:m.Inactive;};n.prototype._clearSegmentedButton=function(){if(this._oSegmentedButton){this._oSegmentedButton.destroyAggregation("buttons",true);}return this;};n.prototype._fillSegmentedButton=function(){var t=this;var i=function(v){return function(){t._fnFilterList(v);};};r.forEach(function(v){var w=this._oLists[v],x=v=="all"?"MESSAGEPOPOVER_ALL":"MESSAGEVIEW_BUTTON_TOOLTIP_"+v.toUpperCase(),y=w.getItems().filter(function(E){return(E instanceof S);}).length,z;if(y>0){z=new B(this.getId()+"-"+v,{text:v=="all"?this._oResourceBundle.getText(x):y,tooltip:this._oResourceBundle.getText(x),icon:p[v],press:i(v)}).addStyleClass(o+"Btn"+v.charAt(0).toUpperCase()+v.slice(1));this._oSegmentedButton.addButton(z,true);}},this);var s=this._oSegmentedButton.getButtons().length>2;this._oSegmentedButton.setVisible(s);var u=s||this._bHasHeaderButton;this._listPage.setShowHeader(u);return this;};n.prototype._setIcon=function(i,s){this._previousIconTypeClass=o+"DescIcon"+i.getType();this._oMessageIcon=new b({src:s.getIcon()}).addStyleClass(o+"DescIcon").addStyleClass(this._previousIconTypeClass);this._detailsPage.addContent(this._oMessageIcon);};n.prototype._setTitle=function(i){this._oMessageTitleText=new d(this.getId()+"MessageTitleText",{text:h.escapeSettingsValue(i.getTitle())}).addStyleClass("sapMMsgViewTitleText");this._detailsPage.addAggregation("content",this._oMessageTitleText);};n.prototype._setDescription=function(i){var s=i.getLink();this._oLastSelectedItem=i;if(i.getMarkupDescription()){this._oMessageDescriptionText=new H(this.getId()+"MarkupDescription",{content:"<div class='sapMMsgViewDescriptionText'>"+i.getDescription()+"</div>"});}else{this._oMessageDescriptionText=new d(this.getId()+"MessageDescriptionText",{text:h.escapeSettingsValue(i.getDescription())}).addStyleClass("sapMMsgViewDescriptionText");}this._detailsPage.addContent(this._oMessageDescriptionText);if(s){var t=this._createLinkCopy(s);this._detailsPage.addContent(t);t.addStyleClass("sapMMsgViewDescriptionLink");}};n.prototype._createLinkCopy=function(i){var s,t=i.clone("","",{cloneChildren:false,cloneBindings:false}),u=i.getCustomData()||[];s=Object.keys(i.getMetadata().getProperties());s.forEach(function(v){t.setProperty(v,i.getProperty(v));});t.destroyCustomData();u.forEach(function(v){var w=new a({key:v.getKey(),value:v.getValue()});t.addCustomData(w);});return t;};n.prototype._iNextValidationTaskId=0;n.prototype._validateURL=function(u){if(q.sap.validateUrl(u)){return u;}q.sap.log.warning("You have entered invalid URL");return"";};n.prototype._queueValidation=function(i){var s=this.getAsyncURLHandler();var v=++this._iNextValidationTaskId;var t={};var u=new window.Promise(function(w,x){t.resolve=w;t.reject=x;var y={url:i,id:v,promise:t};s(y);});u.id=v;return u;};n.prototype._getTagPolicy=function(){var t=this,i;var s=html.makeTagPolicy(this._validateURL());return function customTagPolicy(u,v){var w,x=false;if(u.toUpperCase()==="A"){for(i=0;i<v.length;){if(v[i]==="href"){x=true;w=v[i+1];v.splice(0,2);continue;}i+=2;}}v=s(u,v);if(x&&typeof t.getAsyncURLHandler()==="function"){v=v||[];var y="sapMMsgViewItemDisabledLink sapMMsgViewItemPendingLink";var z=v.indexOf("class");if(z>-1){v[z+1]+=y;}else{v.unshift(y);v.unshift("class");}var E=v.indexOf("id");if(E>-1){v.splice(E+1,1);v.splice(E,1);}var F=t._queueValidation(w);v.push("href");v.push(w);v.push("target");v.push("_blank");v.push("id");v.push("sap-ui-"+t.getId()+"-link-under-validation-"+F.id);F.then(function(J){var $=q.sap.byId("sap-ui-"+t.getId()+"-link-under-validation-"+J.id);if(J.allowed){q.sap.log.info("Allow link "+w);}else{q.sap.log.info("Disallow link "+w);}$.removeClass("sapMMsgViewItemPendingLink");$.toggleClass("sapMMsgViewItemDisabledLink",!J.allowed);t.fireUrlValidated();}).catch(function(){q.sap.log.warning("Async URL validation could not be performed.");});}return v;};};n.prototype._sanitizeDescription=function(i){q.sap.require("jquery.sap.encoder");q.sap.require("sap.ui.thirdparty.caja-html-sanitizer");var s=i.getDescription();if(i.getMarkupDescription()){var t=this._getTagPolicy();s=html.sanitizeWithPolicy(s,t);}i.setDescription(s);this._setDescription(i);};n.prototype._fnHandleForwardNavigation=function(i,t){var s=i._oMessageItem,u=this._detailsPage.getContent()||[],v=this.getAsyncDescriptionHandler();this._previousIconTypeClass=this._previousIconTypeClass||"";this.fireItemSelect({item:s,messageTypeFilter:this._getCurrentMessageTypeFilter()});this._clearDetailsPage.call(this,u);if(typeof v==="function"&&!!s.getLongtextUrl()){s.setMarkupDescription(true);var w={};var x=new window.Promise(function(z,E){w.resolve=z;w.reject=E;});var y=function(){this._detailsPage.setBusy(false);this._navigateToDetails.call(this,s,i,t,true);}.bind(this);x.then(y).catch(function(){q.sap.log.warning("Async description loading could not be performed.");y();});this._navContainer.to(this._detailsPage);this._detailsPage.setBusy(true);v({promise:w,item:s});}else{this._navigateToDetails.call(this,s,i,t,false);}this._listPage.$().attr("aria-hidden","true");};n.prototype._fnHandleItemPress=function(E){this._fnHandleForwardNavigation(E.getParameter("listItem"),"slide");};n.prototype._navigateToDetails=function(i,s,t,u){this._setTitle(i);this._sanitizeDescription(i);this._setIcon(i,s);this._detailsPage.rerender();this.fireLongtextLoaded();if(!u){this._navContainer.to(this._detailsPage,t);}};n.prototype._clearDetailsPage=function(i){i.forEach(function(s){s.destroy();},this);};n.prototype.navigateBack=function(){this._listPage.$().removeAttr("aria-hidden");this._navContainer.back();};n.prototype._fnFilterList=function(s){r.forEach(function(i){if(i!=s&&this._oLists[i].getVisible()){this._oLists[i].setVisible(false);}},this);this._sCurrentList=s;this._oLists[s].setVisible(true);this._listPage.rerender();this.fireListSelect({messageTypeFilter:this._getCurrentMessageTypeFilter()});};n.prototype._getCurrentMessageTypeFilter=function(){return this._sCurrentList=="all"?"":this._sCurrentList;};n.prototype._isListPage=function(){return this._navContainer.getCurrentPage()==this._listPage;};return n;});
