/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","./library","sap/m/ToggleButton","sap/ui/core/InvisibleText","sap/m/Toolbar","sap/m/ToolbarSpacer","sap/m/OverflowToolbarLayoutData","sap/m/OverflowToolbarAssociativePopover","sap/m/OverflowToolbarAssociativePopoverControls","sap/ui/core/IconPool","sap/ui/Device","./OverflowToolbarRenderer"],function(q,l,T,I,a,b,O,c,d,e,D,f){"use strict";var P=l.PlacementType;var B=l.ButtonType;var g=l.OverflowToolbarPriority;var h=a.extend("sap.m.OverflowToolbar",{metadata:{aggregations:{_overflowButton:{type:"sap.m.ToggleButton",multiple:false,visibility:"hidden"},_popover:{type:"sap.m.Popover",multiple:false,visibility:"hidden"}},designtime:"sap/m/designtime/OverflowToolbar.designtime"}});h.prototype._callToolbarMethod=function(F,A){return a.prototype[F].apply(this,A);};h.prototype.init=function(){this._callToolbarMethod("init",arguments);this._iPreviousToolbarWidth=null;this._bOverflowButtonNeeded=false;this._bNestedInAPopover=null;this._bListenForControlPropertyChanges=false;this._bControlsInfoCached=false;this._bSkipOptimization=false;this._aControlSizes={};};h.prototype.exit=function(){var p=this.getAggregation("_popover");if(p){p.destroy();}};h.prototype.onAfterRendering=function(){this._getOverflowButton().$().attr("aria-haspopup","true");this._doLayout();this._applyFocus();};h.prototype._doLayout=function(){var C=sap.ui.getCore();if(!C.isThemeApplied()){q.sap.log.debug("OverflowToolbar: theme not applied yet, skipping calculations",this);return;}var w=this.$().width();this._bListenForControlPropertyChanges=false;this._deregisterToolbarResize();this._polyfillFlexboxSupport();if(w>0){if(!this._isControlsInfoCached()){this._cacheControlsInfo();}if(this._iPreviousToolbarWidth!==w){this._iPreviousToolbarWidth=w;this._setControlsOverflowAndShrinking(w);this.fireEvent("_controlWidthChanged");}}this._registerToolbarResize();this._bListenForControlPropertyChanges=true;};h.prototype._applyFocus=function(){var F=sap.ui.getCore().byId(this.sFocusedChildControlId),$,L=this.$().lastFocusableDomRef();if(F){$=F.$();}if($&&$.length){$.focus();}else if(this._bControlWasFocused){this._getOverflowButton().focus();this._bControlWasFocused=false;this._bOverflowButtonWasFocused=true;}else if(this._bOverflowButtonWasFocused&&!this._getOverflowButtonNeeded()){L&&L.focus();this._bOverflowButtonWasFocused=false;}};h.prototype._preserveChildControlFocusInfo=function(){var A=sap.ui.getCore().getCurrentFocusedControlId();if(this._getControlsIds().indexOf(A)!==-1){this._bControlWasFocused=true;this.sFocusedChildControlId=A;}else if(A===this._getOverflowButton().getId()){this._bOverflowButtonWasFocused=true;this.sFocusedChildControlId=null;}};h.prototype._polyfillFlexboxSupport=function(){if(f.hasNewFlexBoxSupport){return;}var t=this.$();var o=t[0]||{};t.removeClass("sapMTBOverflow");var i=o.scrollWidth>o.clientWidth;i&&t.addClass("sapMTBOverflow");};h.prototype._cacheControlsInfo=function(){var p,C,A;this._aMovableControls=[];this._aToolbarOnlyControls=[];this._aActionSheetOnlyControls=[];this._iOldContentSize=this._iContentSize;this._iContentSize=0;this.getContent().forEach(function(o){p=h._getControlPriority(o);C=p!==g.NeverOverflow;A=p===g.AlwaysOverflow;var i=h._getOptimalControlWidth(o,this._aControlSizes[o.getId()]);this._aControlSizes[o.getId()]=i;if(d.supportsControl(o)&&A){this._aActionSheetOnlyControls.push(o);}else{this._iContentSize+=i;if(d.supportsControl(o)&&C&&o.getVisible()){this._aMovableControls.push(o);}else{this._aToolbarOnlyControls.push(o);}}},this);if(D.system.phone){this._iContentSize-=1;}if(this._aActionSheetOnlyControls.length){var v=this._aActionSheetOnlyControls.filter(function(o){return o.getVisible();}),H=(v.length>0);if(H){this._iContentSize+=this._getOverflowButtonSize();}}this._bControlsInfoCached=true;if(this._iOldContentSize!==this._iContentSize){this.fireEvent("_contentSizeChange",{contentSize:this._iContentSize});}};h.prototype._isControlsInfoCached=function(){return this._bControlsInfoCached;};h.prototype._setControlsOverflowAndShrinking=function(t){var C=this._iContentSize,j=[],s,i,A,F=function(p){p.forEach(function(r){this._moveButtonToActionSheet(r);},this);},k=function(H){if(typeof H==="undefined"||this._getPopover()._getContentIdsHash()!==H){this._preserveChildControlFocusInfo();this.invalidate();}},m=function(C){if(!this._getOverflowButtonNeeded()){C+=this._getOverflowButtonSize();this._setOverflowButtonNeeded(true);}return C;},n=function(M){var G={},p=[];M.forEach(function(r){var u=h._getControlGroup(r),v=h._oPriorityOrder,w,x,y;if(u){w=h._getControlPriority(r);x=this._getControlIndex(r);G[u]=G[u]||[];y=G[u];y.unshift(r);if(!y._priority||v[y._priority]<v[w]){y._priority=w;}if(!y._index||y._index<x){y._index=x;}}else{p.push(r);}},this);Object.keys(G).forEach(function(r){p.push(G[r]);});return p;},E=function(M){if(M.length){M.forEach(o,this);}else{o.call(this,M);}if(C<=t){return true;}},S=function(v,p){var r=h._oPriorityOrder,u=h._getControlPriority(v),w=h._getControlPriority(p),x=r[u]-r[w];if(x!==0){return x;}else{return this._getControlIndex(p)-this._getControlIndex(v);}},o=function(p){j.unshift(p);C-=this._aControlSizes[p.getId()];};if(this._bSkipOptimization){this._bSkipOptimization=false;}else{s=this._getPopover()._getContentIdsHash();}this._resetToolbar();if(this._aActionSheetOnlyControls.length){for(i=this._aActionSheetOnlyControls.length-1;i>=0;i--){if(this._aActionSheetOnlyControls[i].getVisible()){j.unshift(this._aActionSheetOnlyControls[i]);}}if(j.length>0){this._setOverflowButtonNeeded(true);}}if(C<=t){F.call(this,j);k.call(this,s);return;}if(this._aMovableControls.length){C=m.call(this,C);A=n.call(this,this._aMovableControls);A.sort(S.bind(this));A.some(E,this);}F.call(this,j);if(C>t){this._checkContents();}k.call(this,s);};h.prototype._resetToolbar=function(){this._getPopover().close();this._getPopover()._getAllContent().forEach(function(o){this._restoreButtonInToolbar(o);},this);this._setOverflowButtonNeeded(false);this.getContent().forEach(function(C){C.removeStyleClass(a.shrinkClass);});};h.prototype._moveButtonToActionSheet=function(o){this._getPopover().addAssociatedContent(o);};h.prototype._restoreButtonInToolbar=function(v){if(typeof v==="object"){v=v.getId();}this._getPopover().removeAssociatedContent(v);};h.prototype._resetAndInvalidateToolbar=function(H){if(this._bIsBeingDestroyed){return;}this._resetToolbar();for(var C in this._aControlSizes){if(this._aControlSizes.hasOwnProperty(C)){this._aControlSizes[C]=0;}}this._bControlsInfoCached=false;this._bNestedInAPopover=null;this._iPreviousToolbarWidth=null;if(H){this._bSkipOptimization=true;}if(this.$().length){this._preserveChildControlFocusInfo();this.invalidate();}};h.prototype._getVisibleContent=function(){var t=this.getContent(),A=this._getPopover()._getAllContent();return t.filter(function(C){return A.indexOf(C)===-1;});};h.prototype._getVisibleAndNonOverflowContent=function(){return this._getVisibleContent().filter(function(C){return C.getVisible();});};h.prototype._getOverflowButton=function(){var o;if(!this.getAggregation("_overflowButton")){o=new T({id:this.getId()+"-overflowButton",icon:e.getIconURI("overflow"),press:this._overflowButtonPressed.bind(this),ariaLabelledBy:I.getStaticId("sap.ui.core","Icon.overflow"),type:B.Transparent});this.setAggregation("_overflowButton",o,true);}return this.getAggregation("_overflowButton");};h.prototype._overflowButtonPressed=function(E){var p=this._getPopover(),s=this._getBestActionSheetPlacement();if(p.getPlacement()!==s){p.setPlacement(s);}if(p.isOpen()){p.close();}else{p.openBy(E.getSource());}};h.prototype._getPopover=function(){var p;if(!this.getAggregation("_popover")){p=new c(this.getId()+"-popover",{showHeader:false,showArrow:false,modal:false,horizontalScrolling:D.system.phone?false:true,contentWidth:D.system.phone?"100%":"auto",offsetY:this._detireminePopoverVerticalOffset(),ariaLabelledBy:I.getStaticId("sap.m","INPUT_AVALIABLE_VALUES")});p._adaptPositionParams=function(){c.prototype._adaptPositionParams.call(this);this._myPositions=["end top","begin center","end bottom","end center"];this._atPositions=["end bottom","end center","end top","begin center"];};if(D.system.phone){p.attachBeforeOpen(this._shiftPopupShadow,this);}p.attachAfterClose(this._popOverClosedHandler,this);this.setAggregation("_popover",p,true);}return this.getAggregation("_popover");};h.prototype._shiftPopupShadow=function(){var p=this._getPopover(),s=p.getCurrentPosition();if(s===P.Bottom){p.addStyleClass("sapMOTAPopoverNoShadowTop");p.removeStyleClass("sapMOTAPopoverNoShadowBottom");}else if(s===P.Top){p.addStyleClass("sapMOTAPopoverNoShadowBottom");p.removeStyleClass("sapMOTAPopoverNoShadowTop");}};h.prototype._popOverClosedHandler=function(){var w=D.os.windows_phone||D.browser.edge&&D.browser.mobile;this._getOverflowButton().setPressed(false);this._getOverflowButton().$().focus();if(this._isNestedInsideAPopup()||w){return;}this._getOverflowButton().setEnabled(false);q.sap.delayedCall(0,this,function(){this._getOverflowButton().setEnabled(true);q.sap.delayedCall(0,this,function(){this._getOverflowButton().$().focus();});});};h.prototype._isNestedInsideAPopup=function(){var s;if(this._bNestedInAPopover!==null){return this._bNestedInAPopover;}s=function(C){if(!C){return false;}if(C.getMetadata().isInstanceOf("sap.ui.core.PopupInterface")){return true;}return s(C.getParent());};this._bNestedInAPopover=s(this);return this._bNestedInAPopover;};h.prototype._getOverflowButtonNeeded=function(){return this._bOverflowButtonNeeded;};h.prototype._setOverflowButtonNeeded=function(v){if(this._bOverflowButtonNeeded!==v){this._bOverflowButtonNeeded=v;}return this;};h.prototype.onLayoutDataChange=function(){this._resetAndInvalidateToolbar(true);};h.prototype.addContent=function(C){this._registerControlListener(C);this._resetAndInvalidateToolbar(false);return this._callToolbarMethod("addContent",arguments);};h.prototype.insertContent=function(C,i){this._registerControlListener(C);this._resetAndInvalidateToolbar(false);return this._callToolbarMethod("insertContent",arguments);};h.prototype.removeContent=function(C){var v=this._callToolbarMethod("removeContent",arguments);if(v){this._getPopover().removeAssociatedContent(v.getId());}this._resetAndInvalidateToolbar(false);this._deregisterControlListener(v);return v;};h.prototype.removeAllContent=function(){var C=this._callToolbarMethod("removeAllContent",arguments);C.forEach(function(o){this._deregisterControlListener(o);},this);this._resetAndInvalidateToolbar(false);return C;};h.prototype.destroyContent=function(){this._resetAndInvalidateToolbar(false);q.sap.delayedCall(0,this,function(){this._resetAndInvalidateToolbar(false);});return this._callToolbarMethod("destroyContent",arguments);};h.prototype._registerControlListener=function(C){if(C){C.attachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);}};h.prototype._deregisterControlListener=function(C){if(C){C.detachEvent("_change",this._onContentPropertyChangedOverflowToolbar,this);}};h.prototype._onContentPropertyChangedOverflowToolbar=function(E){if(!this._bListenForControlPropertyChanges){return;}var s=E.getSource();var C=d.getControlConfig(s);var p=E.getParameter("name");if(typeof C!=="undefined"&&C.noInvalidationProps.indexOf(p)!==-1){return;}this._resetAndInvalidateToolbar(true);};h.prototype._getOverflowButtonSize=function(){var i=parseInt(l.BaseFontSize,10),C=this.$().parents().hasClass('sapUiSizeCompact')?2.5:3;return parseInt(i*C,10);};h.prototype._getBestActionSheetPlacement=function(){var H=this.getHTMLTag();if(H==="Footer"){return P.Top;}else if(H==="Header"){return P.Bottom;}return P.Vertical;};h.prototype._getControlsIds=function(){return this.getContent().map(function(i){return i.getId();});};h.prototype._getControlIndex=function(C){return C.length?C._index:this.indexOfContent(C);};h._getOptimalControlWidth=function(C,o){var i;if(C instanceof b){i=parseInt(C.$().css('min-width'),10)||0+C.$().outerWidth(true)-C.$().outerWidth();}else{i=C.getVisible()?C.$().outerWidth(true):0;}if(i===null){i=typeof o!=="undefined"?o:0;}return i;};h._getControlPriority=function(C){if(C.length){return C._priority;}var i=C.getMetadata().getInterfaces().indexOf("sap.m.IOverflowToolbarContent")>-1,G=i&&C.getOverflowToolbarConfig().getCustomImportance;if(i&&typeof G==="function"){return G();}var L=C.getLayoutData&&C.getLayoutData();if(L&&L instanceof O){if(L.getMoveToOverflow()===false){return g.NeverOverflow;}if(L.getStayInOverflow()===true){return g.AlwaysOverflow;}var p=L.getPriority();if(p===g.Never){return g.NeverOverflow;}if(p===g.Always){return g.AlwaysOverflow;}return p;}return g.High;};h._getControlGroup=function(C){var L=C.getLayoutData();if(L instanceof O){return L.getGroup();}};h._oPriorityOrder=(function(){var p={};p[g.Disappear]=1;p[g.Low]=2;p["Medium"]=3;p[g.High]=4;return p;})();h.prototype._detireminePopoverVerticalOffset=function(){return this.$().parents().hasClass('sapUiSizeCompact')?2:3;};h.prototype.onThemeChanged=function(){this._resetAndInvalidateToolbar();};h.prototype.closeOverflow=function(){this._getPopover().close();};return h;});
