/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./library','sap/ui/core/Control','sap/ui/core/format/DateFormat','sap/ui/core/format/NumberFormat','sap/ui/core/IconPool','sap/ui/Device','sap/ui/core/InvisibleText','sap/ui/core/library','sap/ui/core/ResizeHandler','sap/ui/core/Item'],function(q,a,C,D,N,I,b,c,d,R,e){"use strict";var V=d.ValueState;var B=a.ButtonType;var T=a.ToolbarDesign;var f=d.TextAlign;var O=a.OverflowToolbarPriority;var G;var P=C.extend("sap.m.P13nConditionPanel",{metadata:{library:"sap.m",properties:{maxConditions:{type:"string",group:"Misc",defaultValue:'-1'},exclude:{type:"boolean",group:"Misc",defaultValue:false},containerQuery:{type:"boolean",group:"Misc",defaultValue:false},autoAddNewRow:{type:"boolean",group:"Misc",defaultValue:false},disableFirstRemoveIcon:{type:"boolean",group:"Misc",defaultValue:false},alwaysShowAddIcon:{type:"boolean",group:"Misc",defaultValue:true},usePrevConditionSetting:{type:"boolean",group:"Misc",defaultValue:true},autoReduceKeyFieldItems:{type:"boolean",group:"Misc",defaultValue:false},layoutMode:{type:"string",group:"Misc",defaultValue:null},showLabel:{type:"boolean",group:"Misc",defaultValue:false},displayFormat:{type:"string",group:"Misc",defaultValue:null},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content",visibility:"hidden"}},events:{dataChange:{}}},renderer:function(r,o){r.write("<section");r.writeControlData(o);r.addClass("sapMConditionPanel");r.writeClasses();r.writeStyles();r.write(">");r.write("<div");r.addClass("sapMConditionPanelContent");r.addClass("sapMConditionPanelBG");r.writeClasses();r.write(">");var g=o.getAggregation("content");var l=g.length;for(var i=0;i<l;i++){r.renderControl(g[i]);}r.write("</div>");r.write("</section>");}});P.prototype.setConditions=function(g){if(!g){q.sap.log.error("sap.m.P13nConditionPanel : aCondition is not defined");}if(this._bIgnoreSetConditions){return;}this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;for(var i=0;i<g.length;i++){this._addCondition2Map(g[i]);}this._clearConditions();this._fillConditions();};P.prototype.removeAllConditions=function(){this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._clearConditions();this._fillConditions();};P.prototype.addCondition=function(o){if(this._bIgnoreSetConditions){return;}o.index=this._iConditions;this._addCondition2Map(o);this._addCondition(o);};P.prototype.insertCondition=function(o,i){if(this._bIgnoreSetConditions){return;}if(i!==undefined){o.index=i;}this._addCondition2Map(o);this._addCondition(o);};P.prototype.removeCondition=function(v){this._clearConditions();if(typeof v=="string"){this._removeConditionFromMap(v);}if(typeof v=="object"){this._removeConditionFromMap(v.key);}this._fillConditions();};P.prototype._addCondition2Map=function(o){if(!o.key){o.key="condition_"+this._iConditions;if(this.getExclude()){o.key="x"+o.key;}}this._iConditions++;this._oConditionsMap[o.key]=o;this._aConditionKeys.push(o.key);};P.prototype._removeConditionFromMap=function(k){this._iConditions--;delete this._oConditionsMap[k];var i=this._aConditionKeys.indexOf(k);if(i>=0){this._aConditionKeys.splice(i,1);}};P.prototype.getConditions=function(){var o;var g=[];if(this._oConditionsMap){for(var h in this._oConditionsMap){o=this._oConditionsMap[h];var v=o.value;if(!v){v=this._getFormatedConditionText(o.operation,o.value1,o.value2,o.exclude,o.keyField,o.showIfGrouped);}if(!o._oGrid||o._oGrid.select.getSelected()){g.push({"key":h,"text":v,"exclude":o.exclude,"operation":o.operation,"keyField":o.keyField,"value1":o.value1,"value2":o.operation===sap.m.P13nConditionOperation.BT?o.value2:null,"showIfGrouped":o.showIfGrouped});}}}return g;};P.prototype.setOperations=function(o,t){t=t||"default";this._oTypeOperations[t]=o;this._updateAllOperations();};P.prototype.setValues=function(v,t){t=t||"default";this._oTypeValues[t]=v;};P.prototype.addOperation=function(o,t){t=t||"default";this._oTypeOperations[t].push(o);this._updateAllOperations();};P.prototype.removeAllOperations=function(t){t=t||"default";this._oTypeOperations[t]=[];this._updateAllOperations();};P.prototype.getOperations=function(t){t=t||"default";return this._oTypeOperations[t];};P.prototype.setKeyFields=function(k){this._aKeyFields=k;this._updateKeyFieldItems(this._oConditionsGrid,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};P.prototype.addKeyField=function(k){this._aKeyFields.push(k);this._updateKeyFieldItems(this._oConditionsGrid,true,true);this._updateAllConditionsEnableStates();this._createAndUpdateAllKeyFields();this._updateAllOperations();};P.prototype.removeAllKeyFields=function(){this._aKeyFields=[];this._updateKeyFieldItems(this._oConditionsGrid,true);};P.prototype.getKeyFields=function(){return this._aKeyFields;};P.prototype.setAlwaysShowAddIcon=function(E){this.setProperty("alwaysShowAddIcon",E);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");}return this;};P.prototype.setLayoutMode=function(l){this.setProperty("layoutMode",l);if(this._oConditionsGrid){this._oConditionsGrid.toggleStyleClass("conditionRootGrid",l!=="Desktop");}this._updateConditionFieldSpans(l);this._clearConditions();this._fillConditions();return this;};P.prototype.setContainerQuery=function(E){this._unregisterResizeHandler();this.setProperty("containerQuery",E);this._registerResizeHandler();this._clearConditions();this._fillConditions();return this;};P.prototype._updateConditionFieldSpans=function(m){if(this._aConditionsFields){var g=m==="Desktop";if(g){this._aConditionsFields[2].SpanFilter="L3 M3 S3";this._aConditionsFields[4].SpanFilter="L2 M2 S2";this._aConditionsFields[5].SpanFilter="L3 M3 S3";this._aConditionsFields[6].SpanFilter="L2 M2 S2";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}var t=m==="Tablet";if(t){this._aConditionsFields[2].SpanFilter="L5 M5 S5";this._aConditionsFields[4].SpanFilter="L5 M5 S5";this._aConditionsFields[5].SpanFilter="L10 M10 S10";this._aConditionsFields[6].SpanFilter="L10 M10 S10";this._aConditionsFields[7].SpanFilter="L1 M1 S1";}}};P.prototype.init=function(){sap.ui.getCore().loadLibrary("sap.ui.layout");G=G||sap.ui.requireSync("sap/ui/layout/Grid");this.addStyleClass("sapMConditionPanel");this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._sFromLabelText=this._oRb.getText("CONDITIONPANEL_LABELFROM");this._sToLabelText=this._oRb.getText("CONDITIONPANEL_LABELTO");this._sValueLabelText=this._oRb.getText("CONDITIONPANEL_LABELVALUE");this._sShowIfGroupedLabelText=this._oRb.getText("CONDITIONPANEL_LABELGROUPING");this._sValidationDialogFieldMessage=this._oRb.getText("CONDITIONPANEL_FIELDMESSAGE");this._oTypeOperations={"default":[]};this._oTypeValues={"default":[]};this._aKeyFields=[];this._oConditionsMap={};this._aConditionKeys=[];this._iConditions=0;this._sLayoutMode="Desktop";this._sConditionType="Filter";this._sAddRemoveIconTooltip="FILTER";this._iBreakPointTablet=b.media._predefinedRangeSets[b.media.RANGESETS.SAP_STANDARD].points[0];this._iBreakPointDesktop=b.media._predefinedRangeSets[b.media.RANGESETS.SAP_STANDARD].points[1];this._oConditionsGrid=new G({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:0,vSpacing:0}).toggleStyleClass("conditionRootGrid",this.getLayoutMode()!=="Desktop");this._iFirstConditionIndex=0;this._iConditionPageSize=10;this._oInvisibleTextField=new c({text:this._oRb.getText("CONDITIONPANEL_FIELD_LABEL")});this._oInvisibleTextOperator=new c({text:this._oRb.getText("CONDITIONPANEL_OPERATOR_LABEL")});this.addAggregation("content",this._oInvisibleTextField);this.addAggregation("content",this._oInvisibleTextOperator);this.addAggregation("content",this._oConditionsGrid);this._registerResizeHandler();this._aConditionsFields=[{"ID":"select","Label":"","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"CheckBox","Value":""},{"ID":"keyFieldLabel","Text":"Sort By","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"keyField","Label":"","SpanFilter":"L3 M5 S10","SpanSort":"L5 M5 S12","SpanGroup":"L4 M4 S12","Control":"ComboBox"},{"ID":"operationLabel","Text":"Sort Order","SpanFilter":"L1 M1 S1","SpanSort":"L1 M1 S1","SpanGroup":"L1 M1 S1","Control":"Label"},{"ID":"operation","Label":"","SpanFilter":"L2 M5 S10","SpanSort":b.system.phone?"L5 M5 S8":"L5 M5 S9","SpanGroup":"L2 M5 S10","Control":"ComboBox"},{"ID":"value1","Label":this._sFromLabelText,"SpanFilter":"L3 M10 S10","SpanSort":"L3 M10 S10","SpanGroup":"L3 M10 S10","Control":"TextField","Value":""},{"ID":"value2","Label":this._sToLabelText,"SpanFilter":"L2 M10 S10","SpanSort":"L2 M10 S10","SpanGroup":"L2 M10 S10","Control":"TextField","Value":""},{"ID":"showIfGrouped","Label":this._sShowIfGroupedLabelText,"SpanFilter":"L1 M10 S10","SpanSort":"L1 M10 S10","SpanGroup":"L3 M4 S9","Control":"CheckBox","Value":"false"}];this._oButtonGroupSpan={"SpanFilter":"L2 M2 S2","SpanSort":b.system.phone?"L2 M2 S4":"L2 M2 S3","SpanGroup":"L2 M2 S3"};this._updateConditionFieldSpans(this.getLayoutMode());this._fillConditions();};P.prototype._createPaginatorToolbar=function(){this._bPaginatorButtonsVisible=false;var t=this;this._oPrevButton=new sap.m.Button({icon:I.getIconURI("navigation-left-arrow"),tooltip:this._oRb.getText("WIZARD_FINISH"),visible:true,press:function(E){t._iFirstConditionIndex=Math.max(0,t._iFirstConditionIndex-t._iConditionPageSize);t._clearConditions();t._fillConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow})});this._oNextButton=new sap.m.Button({icon:I.getIconURI("navigation-right-arrow"),tooltip:this._oRb.getText("WIZARD_NEXT"),visible:true,press:function(E){t._iFirstConditionIndex+=t._iConditionPageSize;t._clearConditions();t._fillConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow})});this._oRemoveAllButton=new sap.m.Button({text:this._oRb.getText("CONDITIONPANEL_REMOVE_ALL"),visible:true,press:function(E){t._aConditionKeys.forEach(function(k,i){if(i>=0){this.fireDataChange({key:k,index:i,operation:"remove",newData:null});}},t);this._iFirstConditionIndex=0;t.removeAllConditions();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.Low})});this._oAddButton=new sap.m.Button({icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),visible:true,press:function(E){var o=t._createConditionRow(t._oConditionsGrid,undefined,null,0);t._changeField(o);setTimeout(function(){o.keyField.focus();});t._updatePaginatorToolbar();},layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.Low})});this._oHeaderText=new sap.m.Text({wrapping:false,layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow})});this._oPageText=new sap.m.Text({wrapping:false,textAlign:f.Center,layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.NeverOverflow})});this._oFilterField=new sap.m.SearchField({width:"12rem",layoutData:new sap.m.OverflowToolbarLayoutData({priority:O.High})});this._oPaginatorToolbar=new sap.m.OverflowToolbar({height:"3rem",design:T.Transparent,content:[this._oHeaderText,new sap.m.ToolbarSpacer(),this._oFilterField,this._oPrevButton,this._oPageText,this._oNextButton,this._oRemoveAllButton,this._oAddButton]});};P.prototype._updatePaginatorToolbar=function(){if(this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"){return;}var i=this._aConditionKeys.length;var p=1+Math.floor(Math.max(0,i-1)/this._iConditionPageSize);var g=1+Math.floor(this._iFirstConditionIndex/this._iConditionPageSize);var o=this.getParent();if(!this._oPaginatorToolbar){if(i>this._iConditionPageSize){this._createPaginatorToolbar();this.insertAggregation("content",this._oPaginatorToolbar,0);this._onGridResize();}else{if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText();}o.setHeaderText(this._sOrgHeaderText+(i>0?" ("+i+")":""));}return;}}this._oPrevButton.setEnabled(this._iFirstConditionIndex>0);this._oNextButton.setEnabled(this._iFirstConditionIndex+this._iConditionPageSize<i);if(o&&o.setHeaderToolbar){if(!o.getHeaderToolbar()){this.removeAggregation("content",this._oPaginatorToolbar);o.setHeaderToolbar(this._oPaginatorToolbar);o.attachExpand(function(E){this._setToolbarElementVisibility(E.getSource().getExpanded()&&this._bPaginatorButtonsVisible);}.bind(this));}}if(o&&o.setHeaderText){if(this._sOrgHeaderText==undefined){this._sOrgHeaderText=o.getHeaderText();}var h=this._sOrgHeaderText+(i>0?" ("+i+")":"");o.setHeaderText(h);this._oHeaderText.setText(h);}else{this._oHeaderText.setText(i+" Conditions");}this._oPageText.setText(g+"/"+p);this._bPaginatorButtonsVisible=this._bPaginatorButtonsVisible||p>1;this._setToolbarElementVisibility(this._bPaginatorButtonsVisible);if(g>p){this._iFirstConditionIndex-=Math.max(0,this._iConditionPageSize);this._clearConditions();this._fillConditions();}var n=0;this._oConditionsGrid.getContent().forEach(function(j){if(j.select.getSelected()){n++;}},this);if(p==g&&(i-this._iFirstConditionIndex)>n){this._clearConditions();this._fillConditions();}};P.prototype._setToolbarElementVisibility=function(v){this._oPrevButton.setVisible(v);this._oNextButton.setVisible(v);this._oPageText.setVisible(v);this._oFilterField.setVisible(false);this._oAddButton.setVisible(v);this._oRemoveAllButton.setVisible(v);};P.prototype.exit=function(){this._clearConditions();this._unregisterResizeHandler();this._aConditionsFields=null;this._aKeys=null;this._aKeyFields=null;this._oTypeOperations=null;this._oRb=null;this._sFromLabelText=null;this._sToLabelText=null;this._sValueLabelText=null;this._sValidationDialogFieldMessage=null;this._oConditionsMap=null;this._aConditionKeys=[];};P.prototype._clearConditions=function(){var g=this._oConditionsGrid.getContent();g.forEach(function(o){for(var F in this._aConditionsFields){var h=this._aConditionsFields[F];if(o[h["ID"]]&&o.getContent().indexOf(o[h["ID"]])===-1){o[h["ID"]].destroy();}}},this);this._oConditionsGrid.destroyContent();};P.prototype._fillConditions=function(){var o,s;var i=0,m=this._getMaxConditionsAsNumber(),n=this._aConditionKeys.length;if(this._oConditionsMap){var p=this._sConditionType!=="Filter"||this.getMaxConditions()!=="-1"?9999:this._iConditionPageSize;n=Math.min(n,Math.min(m,this._iFirstConditionIndex+p));for(i=this._iFirstConditionIndex;i<n;i++){s=this._aConditionKeys[i];o=this._oConditionsMap[s];this._createConditionRow(this._oConditionsGrid,o,s);}}this._updatePaginatorToolbar();if((this.getAutoAddNewRow()||this._oConditionsGrid.getContent().length===0)&&this._oConditionsGrid.getContent().length<m){this._createConditionRow(this._oConditionsGrid);}};P.prototype._addCondition=function(o){var i=0;var m=this._getMaxConditionsAsNumber();if(this._oConditionsMap){for(var g in this._oConditionsMap){if(i<m&&o===this._oConditionsMap[g]){this._createConditionRow(this._oConditionsGrid,o,g,i);}i++;}}this._updatePaginatorToolbar();};P.prototype._getMaxConditionsAsNumber=function(){return this.getMaxConditions()==="-1"?9999:parseInt(this.getMaxConditions(),10);};P.prototype.onAfterRendering=function(){if(this.getLayoutMode()){this._sLayoutMode=this.getLayoutMode();return;}};P.prototype._handleMediaChange=function(p){this._sLayoutMode=p.name;this._updateLayout(p);};P.prototype._unregisterResizeHandler=function(){if(this._sContainerResizeListener){R.deregister(this._sContainerResizeListener);this._sContainerResizeListener=null;}b.media.detachHandler(this._handleMediaChange,this,b.media.RANGESETS.SAP_STANDARD);};P.prototype._registerResizeHandler=function(){if(this.getContainerQuery()){this._sContainerResizeListener=R.register(this._oConditionsGrid,q.proxy(this._onGridResize,this));this._onGridResize();}else{b.media.attachHandler(this._handleMediaChange,this,b.media.RANGESETS.SAP_STANDARD);}};P.prototype._getKeyFromConditionGrid=function(o){var k=o.data("_key");if(!k){k=this._createConditionKey();}return k;};P.prototype._createConditionKey=function(){var i=0;var k;do{k="condition_"+i;if(this.getExclude()){k="x"+k;}i++;}while(this._oConditionsMap[k]);return k;};P.prototype._createConditionRow=function(t,o,k,p){var g=null;var h;var i=this;if(p===undefined){p=t.getContent().length;}var j=new G({width:"100%",defaultSpan:"L12 M12 S12",hSpacing:1,vSpacing:0,containerQuery:this.getContainerQuery()}).data("_key",k);for(var F in this._aConditionsFields){var l;var m=this._aConditionsFields[F];switch(m["Control"]){case"CheckBox":l=new sap.m.CheckBox({enabled:false,visible:false,layoutData:new sap.ui.layout.GridData({span:m["Span"+this._sConditionType]})});if(m["ID"]==="showIfGrouped"){l.setEnabled(true);l.setText(m["Label"]);l.attachSelect(function(){i._changeField(j);});l.setSelected(o?o.showIfGrouped:true);}else{if(o){l.setSelected(true);l.setEnabled(true);}}break;case"ComboBox":if(m["ID"]==="keyField"){l=new sap.m.ComboBox({width:"100%",ariaLabelledBy:this._oInvisibleTextField});var n=q.proxy(l.setSelectedKey,l);l.setSelectedKey=function(k){n(k);var z=i.getValidationExecutor();if(z){z();}};var r=q.proxy(l.setSelectedItem,l);l.setSelectedItem=function(z){r(z);var E=i.getValidationExecutor();if(E){E();}};l.setLayoutData(new sap.ui.layout.GridData({span:m["Span"+this._sConditionType]}));this._fillKeyFieldListItems(l,this._aKeyFields);if(l.attachSelectionChange){l.attachSelectionChange(function(E){var z=i.getValidationExecutor();if(z){z();}i._handleSelectionChangeOnKeyField(t,j);});}if(l.attachChange){l.attachChange(function(E){j.keyField.close();i._handleChangeOnKeyField(t,j);});}if(l.setSelectedItem){if(o){l.setSelectedKey(o.keyField);this._aKeyFields.forEach(function(K,z){var E=K.key;if(E===undefined){E=K;}if(o.keyField===E){l.setSelectedItem(l.getItems()[z]);}},this);}else{if(this.getUsePrevConditionSetting()&&!this.getAutoReduceKeyFieldItems()){if(p>0&&!k){h=t.getContent()[p-1];if(h.keyField.getSelectedKey()){l.setSelectedKey(h.keyField.getSelectedKey());}else{if(!l.getSelectedItem()&&l.getItems().length>0){l.setSelectedItem(l.getItems()[0]);}}}else{this._aKeyFields.some(function(K,z){if(K.isDefault){l.setSelectedItem(l.getItems()[z]);return true;}if(!l.getSelectedItem()&&K.type!=="boolean"){l.setSelectedItem(l.getItems()[z]);}},this);if(!l.getSelectedItem()&&l.getItems().length>0){l.setSelectedItem(l.getItems()[0]);}}}else{this._aKeyFields.forEach(function(K,z){if(K.isDefault){l.setSelectedItem(l.getItems()[z]);}},this);}}}}if(m["ID"]==="operation"){l=new sap.m.Select({width:"100%",ariaLabelledBy:this._oInvisibleTextOperator,layoutData:new sap.ui.layout.GridData({span:m["Span"+this._sConditionType]})});l.attachChange(function(){i._handleChangeOnOperationField(t,j);});j[m["ID"]]=l;this._updateOperationItems(t,j);if(o){var K=this._getCurrentKeyFieldItem(j.keyField);var s=this._oTypeOperations["default"];if(K){if(K.type&&this._oTypeOperations[K.type]){s=this._oTypeOperations[K.type];}if(K.operations){s=K.operations;}}s.some(function(z,E){if(o.operation===z){l.setSelectedKey(z);return true;}},this);}else{if(this.getUsePrevConditionSetting()){if(p>0&&k===null){var h=t.getContent()[p-1];l.setSelectedKey(h.operation.getSelectedKey());}}}}if(l.getSelectedItem&&l.getSelectedItem()){l.setTooltip(l.getSelectedItem().getTooltip()||l.getSelectedItem().getText());}break;case"TextField":var u=this._getCurrentKeyFieldItem(j.keyField);l=this._createValueField(u,m,j);l.oTargetGrid=t;if(o&&o[m["ID"]]!==undefined){var v=o[m["ID"]];var w;if(l instanceof sap.m.Select){if(typeof v==="string"&&u.type==="boolean"){v=v==="true";}if(typeof v==="boolean"){l.setSelectedIndex(v?2:1);}else{l.setSelectedItem(l.getItemByKey(v.toString()));}}else{if(typeof v==="string"&&j.oFormatter instanceof N){w=parseFloat(v);v=j.oFormatter.format(w);if(isNaN(w)){break;}}if(typeof v==="string"&&j.oFormatter){w=j.oFormatter.parse(v);}else{w=v;}if(!isNaN(w)&&w!==null&&j.oFormatter){v=j.oFormatter.format(w);l.setValue(v);}else{if(!w&&v&&j.oFormatter instanceof D){w=new Date(v);v=j.oFormatter.format(w);l.setValue(v);}else{l.setValue(w);}}}}break;case"Label":l=new sap.m.Label({text:m["Text"]+":",visible:this.getShowLabel(),layoutData:new sap.ui.layout.GridData({span:m["Span"+this._sConditionType]})}).addStyleClass("conditionLabel");l.oTargetGrid=t;break;}j[m["ID"]]=l;j.addContent(l);}g=new sap.ui.layout.HorizontalLayout({layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L2 M2 S2":this._oButtonGroupSpan["Span"+this._sConditionType]})}).addStyleClass("floatRight");j.addContent(g);j["ButtonContainer"]=g;var x=new sap.m.Button({type:B.Transparent,icon:I.getIconURI("sys-cancel"),tooltip:this._oRb.getText("CONDITIONPANEL_REMOVE"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){i._handleRemoveCondition(this.oTargetGrid,j);},layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M2 S2"})});x.oTargetGrid=t;g.addContent(x);j["remove"]=x;var A=new sap.m.Button({type:B.Transparent,icon:I.getIconURI("add"),tooltip:this._oRb.getText("CONDITIONPANEL_ADD"+(this._sAddRemoveIconTooltipKey?"_"+this._sAddRemoveIconTooltipKey:"")+"_TOOLTIP"),press:function(){i._handleAddCondition(this.oTargetGrid,j);},layoutData:new sap.ui.layout.GridData({span:this.getLayoutMode()==="Desktop"?"L1 M1 S1":"L1 M10 S10"})});A.oTargetGrid=t;A.addStyleClass("conditionAddBtnFloatRight");g.addContent(A);j["add"]=A;t.insertContent(j,p);this._updateOperationItems(t,j);this._changeOperationValueFields(t,j);this._updateAllConditionsEnableStates();this._updateConditionButtons(t);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false);}if(this._sLayoutMode){this._updateLayout({name:this._sLayoutMode});}if(o){var y=this._getFormatedConditionText(o.operation,o.value1,o.value2,o.exclude,o.keyField,o.showIfGrouped);o._oGrid=j;o.value=y;this._oConditionsMap[k]=o;}return j;};P.prototype._handleRemoveCondition=function(t,o){var i=t.getContent().indexOf(o);this._removeCondition(t,o);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false);}if(i>=0){i=Math.min(i,t.getContent().length-1);var o=t.getContent()[i];setTimeout(function(){o.remove.focus();});}this._updatePaginatorToolbar();};P.prototype._handleAddCondition=function(t,s){var p=t.getContent().indexOf(s);var o=this._createConditionRow(t,undefined,null,p+1);this._changeField(o);setTimeout(function(){o.keyField.focus();});this._updatePaginatorToolbar();};P.prototype._getCurrentKeyFieldItem=function(k){if(k.getSelectedKey&&k.getSelectedKey()){var K=k.getSelectedKey();var i=this._aKeyFields;for(var g in i){var o=i[g];if(o.key===K){return o;}}}return null;};P.prototype._createValueField=function(o,F,g){var h;var s=o?o.type:"";var t=this;var p={value:F["Value"],width:"100%",placeholder:F["Label"],change:function(E){t._validateFormatFieldValue(E);t._changeField(g);},layoutData:new sap.ui.layout.GridData({span:F["Span"+this._sConditionType]})};switch(s){case"boolean":case"enum":var j=[];var v=o.values||this._oTypeValues[s]||["",false,true];v.forEach(function(i,m){j.push(new e({key:s==="boolean"?(m===v.length-1).toString():i.toString(),text:i.toString()}));});p={width:"100%",items:j,change:function(){t._changeField(g);},layoutData:new sap.ui.layout.GridData({span:F["Span"+this._sConditionType]})};g.oFormatter=null;h=new sap.m.Select(p);break;case"numeric":var k;if(o.precision||o.scale){k={};if(o.precision){k["maxIntegerDigits"]=parseInt(o.precision,10);}if(o.scale){k["maxFractionDigits"]=parseInt(o.scale,10);}}g.oFormatter=N.getFloatInstance(k);h=new sap.m.Input(p);break;case"date":g.oFormatter=D.getDateInstance(q.extend({},o.formatSettings,{strictParsing:true}));if(o.formatSettings&&o.formatSettings.style){p.displayFormat=o.formatSettings.style;}h=new sap.m.DatePicker(p);break;case"time":g.oFormatter=D.getTimeInstance(q.extend({},o.formatSettings,{strictParsing:true}));h=new sap.m.TimePicker(p);break;case"datetime":g.oFormatter=D.getDateTimeInstance(q.extend({},o.formatSettings,{strictParsing:true}));if(o.formatSettings&&o.formatSettings.style){p.displayFormat=o.formatSettings.style;}h=new sap.m.DateTimePicker(p);break;case"stringdate":g.oFormatter=new sap.m.P13nConditionStringDateFormatter(q.extend({},o.formatSettings,{strictParsing:true}));if(o.formatSettings&&o.formatSettings.style){p.displayFormat=o.formatSettings.style;}h=new sap.m.DatePicker(p);break;default:if(s=="numc"){g.oFormatter={format:function(i){return this.oType.formatValue(i,"string");},parse:function(i){try{if(i===""){return"";}this.oType.validateValue(i,"string");}catch(m){return NaN;}return this.oType.parseValue(i,"string");},oType:new sap.ui.model.odata.type.String({},o.formatSettings)};}else{g.oFormatter=null;}h=new sap.m.Input(p);if(this._fSuggestCallback){var o=this._getCurrentKeyFieldItem(g.keyField);if(o&&o.key){var S=this._fSuggestCallback(h,o.key);if(S){h._oSuggestProvider=S;}}}}if(s!=="boolean"&&s!=="enum"){h.onpaste=function(E){var m;if(window.clipboardData){m=window.clipboardData.getData("Text");}else{m=E.originalEvent.clipboardData.getData('text/plain');}var g=E.srcControl.getParent();var n=m.split(/\r\n|\r|\n/g);var r=g.operation;var u=r.getSelectedKey();if(n&&n.length>1&&u!=="BT"){setTimeout(function(){var L=n?n.length:0;var K=t._getCurrentKeyFieldItem(g.keyField);var r=g.operation;for(var i=0;i<L;i++){if(t._aConditionKeys.length>=t._getMaxConditionsAsNumber()){break;}if(n[i]){var w={"key":t._createConditionKey(),"exclude":t.getExclude(),"operation":r.getSelectedKey(),"keyField":K.key,"value1":n[i],"value2":null};t._addCondition2Map(w);t.fireDataChange({key:w.key,index:w.index,operation:"add",newData:w});}}t._clearConditions();t._fillConditions();},0);}};}if(o&&o.maxLength&&h.setMaxLength){var l=-1;if(typeof o.maxLength==="string"){l=parseInt(o.maxLength,10);}if(typeof o.maxLength==="number"){l=o.maxLength;}if(l>0&&(!h.getShowSuggestion||!h.getShowSuggestion())){h.setMaxLength(l);}}return h;};P.prototype._fillOperationListItems=function(o,g,t){if(t==="_STRING_"){t="";}if(t==="_TIME_"||t==="_DATETIME_"){t="_DATE_";}if(t==="_BOOLEAN_"||t==="_NUMC_"){t="";}o.destroyItems();for(var i in g){var s=this._oRb.getText("CONDITIONPANEL_OPTION"+t+g[i]);if(q.sap.startsWith(s,"CONDITIONPANEL_OPTION")){s=this._oRb.getText("CONDITIONPANEL_OPTION"+g[i]);}o.addItem(new sap.ui.core.ListItem({key:g[i],text:s,tooltip:s}));}};P.prototype._fillKeyFieldListItems=function(o,i){o.destroyItems();for(var g in i){var h=i[g];o.addItem(new sap.ui.core.ListItem({key:h.key,text:h.text,tooltip:h.tooltip?h.tooltip:h.text}));}o.setEditable(o.getItems().length>1);};P.prototype._handleChangeOnOperationField=function(t,o){this._changeOperationValueFields(t,o);this._changeField(o);};P.prototype._handleSelectionChangeOnKeyField=function(t,o){if(this._sConditionType==="Filter"){this._updateOperationItems(t,o);this._createAndUpdateValueFields(t,o);this._changeOperationValueFields(t,o);}this._changeField(o);};P.prototype._handleChangeOnKeyField=function(t,o){if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(t,false,false,o.keyField);}};P.prototype._createAndUpdateAllKeyFields=function(){var g=this._oConditionsGrid.getContent();g.forEach(function(o){this._createAndUpdateValueFields(this._oConditionsGrid,o);this._changeOperationValueFields(this._oConditionsGrid,o);},this);};P.prototype._createAndUpdateValueFields=function(t,o){var g=this._getCurrentKeyFieldItem(o.keyField);var h=function(o,i,j){var s=i.getValue?i.getValue():"";var k=o.indexOfContent(i);o.removeContent(i);if(i._oSuggestProvider){i._oSuggestProvider.destroy();i._oSuggestProvider=null;}i.destroy();var l=this._aConditionsFields[j];i=this._createValueField(g,l,o);o[l["ID"]]=i;o.insertContent(i,k===-1?0:k);var v,m;if(o.oFormatter&&s){v=o.oFormatter.parse(s);if(!isNaN(v)&&v!==null){m=o.oFormatter.format(v);i.setValue(m);}}if(!m&&!o.oFormatter&&s){i.setValue(s);}};q.proxy(h,this)(o,o.value1,5);q.proxy(h,this)(o,o.value2,6);};P.prototype._updateAllOperations=function(){var g=this._oConditionsGrid.getContent();g.forEach(function(o){this._updateOperationItems(this._oConditionsGrid,o);this._changeOperationValueFields(this._oConditionsGrid,o);},this);};P.prototype._updateOperationItems=function(t,o){var s="";var k=this._getCurrentKeyFieldItem(o.keyField);var g=o.operation;var h=this._oTypeOperations["default"];var i=g.getSelectedItem();if(k&&!this.getExclude()){if(k.type&&k.type!==""&&this._oTypeOperations[k.type]){s=k.type;h=this._oTypeOperations[s];}if(k.operations){h=k.operations;}}this._fillOperationListItems(g,h,s?"_"+s.toUpperCase()+"_":"");if(i&&g.getItemByKey(i.getKey())){g.setSelectedKey(i.getKey());}else{g.setSelectedItem(g.getItems()[0]);}this._sConditionType="Filter";if(h[0]===sap.m.P13nConditionOperation.Ascending||h[0]===sap.m.P13nConditionOperation.Descending){this._sConditionType="Sort";}if(h[0]===sap.m.P13nConditionOperation.GroupAscending||h[0]===sap.m.P13nConditionOperation.GroupDescending){this._sConditionType="Group";}this._adjustValue1Span(o);};P.prototype._updateKeyFieldItems=function(t,F,A,o){var n=t.getContent().length;var i;var u={};if(!F){for(i=0;i<n;i++){var k=t.getContent()[i].keyField;var K=k.getSelectedKey();if(K!=null&&K!==""){u[K]=true;}}}for(i=0;i<n;i++){var k=t.getContent()[i].keyField;var s=t.getContent()[i].select;var g=k.getSelectedKey();var j=0;var h=this._aKeyFields;if(k!==o){if(A){j=h.length-1;}else{k.destroyItems();}for(j;j<h.length;j++){var l=h[j];if(l.key==null||l.key===""||!u[l.key]||l.key===g){k.addItem(new sap.ui.core.ListItem({key:l.key,text:l.text,tooltip:l.tooltip?l.tooltip:l.text}));}}k.setEditable(k.getItems().length>1);}if(g){k.setSelectedKey(g);}else if(k.getItems().length>0){k.setSelectedItem(k.getItems()[0]);}if(!s.getSelected()){this._aKeyFields.some(function(m,p){if(m.isDefault){k.setSelectedItem(k.getItems()[p]);return true;}if(!k.getSelectedItem()){if(m.type!=="boolean"){k.setSelectedItem(k.getItems()[p]);}}},this);}if(k.getSelectedItem()){k.setTooltip(k.getSelectedItem().getTooltip()||k.getSelectedItem().getText());}}};P.prototype._changeOperationValueFields=function(t,o){var g=o.operation;var s=g.getSelectedKey();var v=o.value1;var h=o.value2;var S=o.showIfGrouped;if(!s){return;}if(s===sap.m.P13nConditionOperation.BT){if(v.setPlaceholder&&v.getPlaceholder()!==this._sFromLabelText){v.setPlaceholder(this._sFromLabelText);}if(!v.getVisible()){v.setVisible(true);o.insertContent(v,o.getContent().length-1);}if(h.setPlaceholder&&h.getPlaceholder()!==this._sToLabelText){h.setPlaceholder(this._sToLabelText);}if(!h.getVisible()){h.setVisible(true);o.insertContent(h,o.getContent().length-1);}}else{if(s===sap.m.P13nConditionOperation.GroupAscending||s===sap.m.P13nConditionOperation.GroupDescending){if(v.getVisible()){v.setVisible(false);o.removeContent(v);}if(h.getVisible()){h.setVisible(false);o.removeContent(h);}if(g.getVisible()){g.setVisible(false);o.removeContent(g);}S.setVisible(this._getMaxConditionsAsNumber()!=1);}else{if(s===sap.m.P13nConditionOperation.NotEmpty||s===sap.m.P13nConditionOperation.Empty||s===sap.m.P13nConditionOperation.Initial||s===sap.m.P13nConditionOperation.Ascending||s===sap.m.P13nConditionOperation.Descending||s===sap.m.P13nConditionOperation.Total||s===sap.m.P13nConditionOperation.Average||s===sap.m.P13nConditionOperation.Minimum||s===sap.m.P13nConditionOperation.Maximum){if(v.getVisible()){v.setVisible(false);o.removeContent(v);}if(h.getVisible()){h.setVisible(false);o.removeContent(h);}o.removeContent(S);}else{if(v.setPlaceholder&&v.getPlaceholder()!==this._sValueLabelText){v.setPlaceholder(this._sValueLabelText);}if(!v.getVisible()){v.setVisible(true);o.insertContent(v,o.getContent().length-1);}if(h.getVisible()){h.setVisible(false);o.removeContent(h);}}}}this._adjustValue1Span(o);};P.prototype._adjustValue1Span=function(o){if(this._sConditionType==="Filter"&&o.value1&&o.operation){var g=o.operation;var n=this._aConditionsFields[5]["Span"+this._sConditionType];if(g.getSelectedKey()!=="BT"){n="L5 M10 S10";}var l=o.value1.getLayoutData();if(l.getSpan()!==n){l.setSpan(n);}}};P.prototype._getIndexOfCondition=function(o){var i=-1;o.getParent().getContent().some(function(g){if(g.select.getSelected()){i++;}return(g===o);},this);return i+this._iFirstConditionIndex;};P.prototype._makeFieldValid=function(o,v){if(v){o.setValueState(V.None);o.setValueStateText("");}else{o.setValueState(V.Warning);o.setValueStateText(this._sValidationDialogFieldMessage);}};P.prototype._validateFormatFieldValue=function(E){var o=E.oSource;var g=o.getParent();var v;if(o.getDateValue&&E){v=E.getParameter("value");var h=E.getParameter("valid");this._makeFieldValid(o,h);return;}else{v=o.getValue&&o.getValue();}if(!g){return;}if(this.getDisplayFormat()==="UpperCase"&&v){v=v.toUpperCase();o.setValue(v);}if(g.oFormatter&&v){var i=g.oFormatter.parse(v);var h=!isNaN(i)&&i!==null;this._makeFieldValid(o,h);if(h){v=g.oFormatter.format(i);o.setValue(v);}}else{this._makeFieldValid(o,true);}};P.prototype._changeField=function(o,E){var k=o.keyField.getSelectedKey();if(o.keyField.getSelectedItem()){o.keyField.setTooltip(o.keyField.getSelectedItem().getTooltip()||o.keyField.getSelectedItem().getText());}else{o.keyField.setTooltip(null);}var s=o.operation.getSelectedKey();if(o.operation.getSelectedItem()){o.operation.setTooltip(o.operation.getSelectedItem().getTooltip()||o.operation.getSelectedItem().getText());}else{o.operation.setTooltip(null);}var v=this._getValueTextFromField(o.value1,o.oFormatter);var g=v;if(o.oFormatter&&v){g=o.oFormatter.parse(v);if(isNaN(g)||g===null){v="";}}if(s==="BT"&&o.value1.setMinDate){if(o.value2&&o.value2.setMinDate){o.value2.setMinDate(g instanceof Date?g:null);}}var h=this._getValueTextFromField(o.value2,o.oFormatter);var i=h;if(o.oFormatter&&h){i=o.oFormatter.parse(h);if(isNaN(i)||i===null){h="";}}var j=this._getCurrentKeyFieldItem(o.keyField);var l=j?j.type:"";if(l==="boolean"){var m=j.values||this._oTypeValues[l]||["",false,true];var t=m[m.length-1].toString();g=v===t;i=null;}if(j&&j.type==="numc"){if([sap.m.P13nConditionOperation.Contains,sap.m.P13nConditionOperation.EndsWith].indexOf(s)!=-1){g=o.oFormatter.format(g);}}var S=o.showIfGrouped.getSelected();var n=this.getExclude();var p=o.select;var r="";var K;if(k===""||k==null){k=null;K=this._getKeyFromConditionGrid(o);this._removeConditionFromMap(K);this._enableCondition(o,false);var u=this._getIndexOfCondition(o);if(p.getSelected()){p.setSelected(false);p.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:K,index:u,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}return;}this._enableCondition(o,true);r=this._getFormatedConditionText(s,v,h,n,k,S);var w={"value":r,"exclude":n,"operation":s,"keyField":k,"value1":g,"value2":s===sap.m.P13nConditionOperation.BT?i:null,"showIfGrouped":S};K=this._getKeyFromConditionGrid(o);if(r!==""){p.setSelected(true);p.setEnabled(true);var s="update";if(!this._oConditionsMap[K]){s="add";}this._oConditionsMap[K]=w;if(s==="add"){this._aConditionKeys.splice(this._getIndexOfCondition(o),0,K);}o.data("_key",K);this.fireDataChange({key:K,index:this._getIndexOfCondition(o),operation:s,newData:w});}else if(this._oConditionsMap[K]!==undefined){this._removeConditionFromMap(K);o.data("_key",null);var u=this._getIndexOfCondition(o);if(p.getSelected()){p.setSelected(false);p.setEnabled(false);this._bIgnoreSetConditions=true;this.fireDataChange({key:K,index:u,operation:"remove",newData:null});this._bIgnoreSetConditions=false;}}this._updatePaginatorToolbar();};P.prototype._getValueTextFromField=function(o,F){if(o.getDateValue&&o.getDateValue()){return F.format(o.getDateValue());}if(o instanceof sap.m.Select){return o.getSelectedItem()?o.getSelectedItem().getText():"";}return o.getValue();};P.prototype._updateAllConditionsEnableStates=function(){var g=this._oConditionsGrid.getContent();g.forEach(function(o){var k=this._getCurrentKeyFieldItem(o.keyField);var K=k&&k.key!==undefined?k.key:k;var E=K!==""&&K!==null;this._enableCondition(o,E);},this);};P.prototype._enableCondition=function(o,E){o.operation.setEnabled(E);o.value1.setEnabled(E);o.value2.setEnabled(E);o.showIfGrouped.setEnabled(E);};P.prototype._removeCondition=function(t,o){var k=this._getKeyFromConditionGrid(o);var i=-1;if(o.select.getSelected()){i=this._getIndexOfCondition(o);}this._removeConditionFromMap(k);o.destroy();if(t.getContent().length<1){this._createConditionRow(t);}else{this._updateConditionButtons(t);}if(i>=0){this.fireDataChange({key:k,index:i,operation:"remove",newData:null});}};P.prototype._updateConditionButtons=function(t){var m=this._getMaxConditionsAsNumber();var n=t.getContent().length;for(var i=0;i<n;i++){var A=t.getContent()[i].add;if((this.getAlwaysShowAddIcon()&&(n<m))||(i===n-1&&i<m-1)){A.removeStyleClass("displayNone");}else{A.addStyleClass("displayNone");}var r=t.getContent()[i].remove;if(m===1||(i===0&&n===1&&this.getDisableFirstRemoveIcon())){r.addStyleClass("displayNone");}else{r.removeStyleClass("displayNone");}}};P.prototype.validateConditions=function(){var t=this;var g=function(h){var v=true;for(var i=0;i<h.length;i++){var o=h[i];var j=t._checkCondition(o,i===h.length-1);v=v&&j;}return v;};return g(this._oConditionsGrid.getContent());};P.prototype.removeValidationErrors=function(){this._oConditionsGrid.getContent().forEach(function(o){var v=o.value1;var g=o.value2;v.setValueState(V.None);v.setValueStateText("");g.setValueState(V.None);g.setValueStateText("");},this);};P.prototype.removeInvalidConditions=function(){var i=[];this._oConditionsGrid.getContent().forEach(function(o){if(o.value1.getValueState()!==V.None||o.value2.getValueState()!==V.None){i.push(o);}},this);i.forEach(function(o){this._removeCondition(this._oConditionsGrid,o);if(this.getAutoReduceKeyFieldItems()){this._updateKeyFieldItems(this._oConditionsGrid,false);}},this);};P.prototype._checkCondition=function(o,i){var v=true;var g=o.value1;var h=o.value2;var j=g&&(g.getVisible()&&!this._getValueTextFromField(g,o.oFormatter));var k=g&&g.getVisible()&&g.getValueState?g.getValueState():V.None;var l=h&&(h.getVisible()&&!this._getValueTextFromField(h,o.oFormatter));var m=h&&h.getVisible()&&h.getValueState?h.getValueState():V.None;var s=o.operation.getSelectedKey();if(s===sap.m.P13nConditionOperation.BT){if(!j?l:!l){if(j){g.setValueState(V.Warning);g.setValueStateText(this._sValidationDialogFieldMessage);}if(l){h.setValueState(V.Warning);h.setValueStateText(this._sValidationDialogFieldMessage);}v=false;}else if(k!==V.None||m!==V.None){v=false;}else{g.setValueState(V.None);g.setValueStateText("");h.setValueState(V.None);h.setValueStateText("");}}if((g.getVisible()&&g.getValueState&&g.getValueState()!==V.None)||(h.getVisible()&&h.getValueState&&h.getValueState()!==V.None)){v=false;}return v;};P.prototype._getFormatedConditionText=function(o,v,s,E,k,S){var g="";var K=null;if(this._aKeyFields&&this._aKeyFields.length>1){for(var i=0;i<this._aKeyFields.length;i++){var h=this._aKeyFields[i];if(typeof h!=="string"){if(h.key===k&&h.text){K=h.text;}}}}switch(o){case sap.m.P13nConditionOperation.EQ:if(v!==""&&v!==undefined){g="="+v;}break;case sap.m.P13nConditionOperation.GT:if(v!==""&&v!==undefined){g=">"+v;}break;case sap.m.P13nConditionOperation.GE:if(v!==""&&v!==undefined){g=">="+v;}break;case sap.m.P13nConditionOperation.LT:if(v!==""&&v!==undefined){g="<"+v;}break;case sap.m.P13nConditionOperation.LE:if(v!==""&&v!==undefined){g="<="+v;}break;case sap.m.P13nConditionOperation.Contains:if(v!==""&&v!==undefined){g="*"+v+"*";}break;case sap.m.P13nConditionOperation.StartsWith:if(v!==""&&v!==undefined){g=v+"*";}break;case sap.m.P13nConditionOperation.EndsWith:if(v!==""&&v!==undefined){g="*"+v;}break;case sap.m.P13nConditionOperation.BT:if(v!==""&&v!==undefined){if(s!==""){g=v+"..."+s;}}break;case sap.m.P13nConditionOperation.Initial:g="=''";break;case sap.m.P13nConditionOperation.Empty:g="''";break;case sap.m.P13nConditionOperation.NotEmpty:g="!''";break;case sap.m.P13nConditionOperation.Ascending:g="ascending";break;case sap.m.P13nConditionOperation.GroupAscending:g="ascending";g+=" showIfGrouped:"+S;break;case sap.m.P13nConditionOperation.Descending:g="descending";break;case sap.m.P13nConditionOperation.GroupDescending:g="descending";g+=" showIfGrouped:"+S;break;case sap.m.P13nConditionOperation.Total:g="total";break;case sap.m.P13nConditionOperation.Average:g="average";break;case sap.m.P13nConditionOperation.Minimum:g="minimum";break;case sap.m.P13nConditionOperation.Maximum:g="maximum";break;}if(E&&g!==""){g="!("+g+")";}if(K&&g!==""){g=K+": "+g;}return g;};P.prototype._updateLayout=function(r){if(!this._oConditionsGrid){return;}var g=this._oConditionsGrid.getContent();var n=this._aConditionsFields.length;var h=n;if(r.name==="Tablet"){h=5;}if(r.name==="Phone"){h=3;}if(this._sConditionType==="Filter"){for(var i=0;i<g.length;i++){var j=g[i];j.ButtonContainer.removeStyleClass("floatRight");j.removeContent(j.ButtonContainer);j.insertContent(j.ButtonContainer,h);if(!this.getAlwaysShowAddIcon()){if(h!==n){j.ButtonContainer.removeContent(j.add);j.addContent(j.add);}else{j.removeContent(j.add);j.ButtonContainer.addContent(j.add);}}}}};P.prototype._onGridResize=function(){if(this._oPaginatorToolbar&&this._oConditionsGrid&&this._oConditionsGrid.getContent().length>0){var g=this._oConditionsGrid.getContent()[0];if(g.remove&&g.remove.$().position()){var w=0;if(this._oPaginatorToolbar.getParent()&&this._oPaginatorToolbar.getParent().getExpandable&&this._oPaginatorToolbar.getParent().getExpandable()){w=48-4;}var t=g.remove.$().position().left-w+g.remove.$().width();this._oPaginatorToolbar.setWidth(t+"px");}}var h=this._oConditionsGrid.getDomRef();if(!h){return;}if(!q(h).is(":visible")){return;}var w=h.clientWidth;var r={};if(w<=this._iBreakPointTablet){r.name="Phone";}else if((w>this._iBreakPointTablet)&&(w<=this._iBreakPointDesktop)){r.name="Tablet";}else{r.name="Desktop";}if(r.name==="Phone"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}if(r.name==="Tablet"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}if(r.name==="Desktop"&&this._sLayoutMode!==r.name){this._updateLayout(r);this._sLayoutMode=r.name;}};sap.m.P13nConditionOperation={BT:"BT",EQ:"EQ",Contains:"Contains",StartsWith:"StartsWith",EndsWith:"EndsWith",LT:"LT",LE:"LE",GT:"GT",GE:"GE",Initial:"Initial",Empty:"Empty",NotEmpty:"NotEmpty",Ascending:"Ascending",Descending:"Descending",GroupAscending:"GroupAscending",GroupDescending:"GroupDescending",Total:"Total",Average:"Average",Minimum:"Minimum",Maximum:"Maximum"};sap.m.P13nConditionStringDateFormatter=function(F){F=q.extend({},F,{UTC:false});this.parseFormatter=D.getDateInstance({UTC:false,pattern:"yyyyMMdd"});this.displayFormatter=D.getDateInstance(F);this.format=function(v){if(v===null||v===undefined||v==""){return null;}if(!(v instanceof Date)){v=this.parseFormatter.parse(v);}return this.displayFormatter.format(v);};this.parse=function(v){if(v!=null&&v!=""){var o=this.parseFormatter.parse(v,true);if(o){v=this.parseFormatter.format(o);return v;}}return null;};};return P;});
