/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./Dialog','./library','sap/ui/core/EnabledPropagator','./DialogRenderer','sap/ui/core/library','sap/ui/Device','./Bar','./Button','./Title','sap/m/OverflowToolbarLayoutData','sap/ui/base/ManagedObjectObserver'],function(q,D,l,E,a,c,b,B,d,T,O,M){"use strict";var e=l.OverflowToolbarPriority;var L=l.ListType;var P=l.P13nPanelType;var f=l.ListMode;var g=c.MessageType;var h=l.ButtonType;var N;var j;var k=D.extend("sap.m.P13nDialog",{metadata:{library:"sap.m",properties:{initialVisiblePanelType:{type:"string",group:"Misc",defaultValue:null},showReset:{type:"boolean",group:"Appearance",defaultValue:false},showResetEnabled:{type:"boolean",group:"Appearance",defaultValue:false},validationExecutor:{type:"object",group:"Misc",defaultValue:null}},aggregations:{panels:{type:"sap.m.P13nPanel",multiple:true,singularName:"panel",bindable:"bindable"}},events:{ok:{},cancel:{},reset:{}}},renderer:function(r,C){a.render.apply(this,arguments);var i=C._getVisiblePanelID();var p=C.getVisiblePanel();if(i&&p){r.write("<div");r.writeAttribute("id",i);r.write(">");r.renderControl(p);r.write("</div>");}}});E.apply(k.prototype,[true]);k.prototype.init=function(o){this.addStyleClass("sapMP13nDialog");D.prototype.init.apply(this,arguments);this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._mValidationListener={};this._createDialog();this._mVisibleNavigationItems={};this._bNavigationControlsPromiseResolved=false;this._oNavigationControlsPromise=this._requestRequiredNavigationControls();this._oObserver=new M(_.bind(this));this._oObserver.observe(this,{properties:["showReset","showResetEnabled"],aggregations:["panels"]});};k.prototype.setShowResetEnabled=function(i){return this.setProperty("showResetEnabled",i,true);};k.prototype._createDialog=function(){if(b.system.phone){var t=this;this.setStretch(true);this.setVerticalScrolling(false);this.setHorizontalScrolling(false);this.setCustomHeader(new B(this.getId()+"-phoneHeader",{contentLeft:new d(this.getId()+"-backToList",{visible:false,type:h.Back,press:function(){t._backToList();}}),contentMiddle:new T(this.getId()+"-phoneTitle",{text:this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"),level:"H2"})}));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}else{this.setHorizontalScrolling(false);this.setContentWidth("65rem");this.setContentHeight("40rem");this.setDraggable(true);this.setResizable(true);this.setTitle(this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS"));this.addButton(this._createOKButton());this.addButton(this._createCancelButton());this.addButton(this._createResetButton());}};k.prototype._showValidationDialog=function(C,F,v){var w=[];var i=[];this._prepareMessages(F,v,w,i);var t=this;return new Promise(function(r){sap.ui.require(["sap/m/MessageBox"],function(m){var s="";if(i.length){i.forEach(function(o,I,n){s=(n.length>1?"• ":"")+o.messageText+"\n"+s;});m.show(s,{icon:m.Icon.ERROR,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE_ERROR"),actions:[m.Action.CLOSE],styleClass:t.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}else if(w.length){w.forEach(function(o,I,n){s=(n.length>1?"• ":"")+o.messageText+"\n"+s;});s=s+sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE_QUESTION");m.show(s,{icon:m.Icon.WARNING,title:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_TITLE"),actions:[sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_FIX"),sap.m.MessageBox.Action.IGNORE],onClose:function(A){if(A===m.Action.IGNORE){C();}},styleClass:t.$().closest(".sapUiSizeCompact").length?"sapUiSizeCompact":""});}r();});});};k.prototype._prepareMessages=function(F,v,w,m){if(!F.length&&!v.length){return;}F.forEach(function(p){switch(p){case P.filter:v.push({messageType:g.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VALIDATION_MESSAGE")});break;case P.columns:v.push({messageType:g.Warning,messageText:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("P13NDIALOG_VISIBLE_ITEMS_THRESHOLD_MESSAGE")});break;default:q.sap.log.error("Panel type '"+p+"' is not supported jet.");}});var u=v.filter(function(o,I,n){for(var i=++I;i<n.length;i++){if(o.messageText===n[i].messageText){return false;}}return true;});u.forEach(function(o){if(o.messageType===g.Warning){w.push(o);}else if(o.messageType===g.Error){m.push(o);}});};k.prototype._mapPanelToNavigationItem=function(p){if(!p){return null;}return b.system.phone?new j(p.getId()+"-navItem",{type:L.Navigation,title:p.getTitle()}):new j(p.getId()+"-navItem",{text:p.getTitle()});};k.prototype._switchPanel=function(n){var p=this._getPanelByNavigationItem(n);this.setVerticalScrolling(p.getVerticalScrolling());if(b.system.phone){var o=this._getNavigationControl();if(o){o.setVisible(false);p.beforeNavigationTo();p.setVisible(true);this.getCustomHeader().getContentMiddle()[0].setText(p.getTitle());this.getCustomHeader().getContentLeft()[0].setVisible(true);}}else{this.getPanels().forEach(function(i){if(i===p){i.beforeNavigationTo();i.setVisible(true);}else{i.setVisible(false);}},this);}this.invalidate();this.rerender();};k.prototype._backToList=function(){var n=this._getNavigationControl();if(n){n.setVisible(true);var p=this.getVisiblePanel();p.setVisible(false);this._updateDialogTitle();this.getCustomHeader().getContentLeft()[0].setVisible(false);}};k.prototype.getVisiblePanel=function(){var p=null;this.getPanels().some(function(o){if(o.getVisible()){p=o;return true;}});return p;};k.prototype._getVisiblePanelID=function(){var p=this.getVisiblePanel();if(p){return this.getId()+"-panel_"+p.getId();}return null;};k.prototype._getPanelByNavigationItem=function(n){for(var i=0,p=this.getPanels(),m=p.length;i<m;i++){if(this._getNavigationItemByPanel(p[i])===n){return p[i];}}return null;};k.prototype._getNavigationItemByPanel=function(p){return p?p.data("sapMP13nDialogNavigationItem"):null;};k.prototype.onAfterRendering=function(){D.prototype.onAfterRendering.apply(this,arguments);var C=q(this.getFocusDomRef()).find(".sapMDialogScrollCont");var i=this._getVisiblePanelID();if(i&&C){var p=q.sap.byId(i);p.appendTo(q(C));}};k.prototype._updateDialogTitle=function(){var p=this.getVisiblePanel();var t=this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");if(!this._isNavigationControlExpected()&&p){switch(p.getType()){case P.filter:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_FILTER");break;case P.sort:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_SORT");break;case P.group:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_GROUP");break;case P.columns:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_COLUMNS");break;case P.dimeasure:t=this._oResourceBundle.getText("P13NDIALOG_TITLE_DIMEASURE");break;default:t=p.getTitleLarge()||this._oResourceBundle.getText("P13NDIALOG_VIEW_SETTINGS");}}if(b.system.phone){this.getCustomHeader().getContentMiddle()[0].setText(t);}else{this.setTitle(t);}};k.prototype._registerValidationListener=function(p,C){if(this.getPanels().indexOf(p)&&C&&this._mValidationListener[p.getType()]===undefined){this._mValidationListener[p.getType()]=C;}};k.prototype._callValidationExecutor=function(){var v=this.getValidationExecutor();if(v&&!q.isEmptyObject(this._mValidationListener)){var t=this;v(this._getPayloadOfPanels()).then(function(V){var r=t._distributeValidationResult(V);for(var s in t._mValidationListener){var C=t._mValidationListener[s];C(r[s]||[]);}});}};k.prototype._callChangeNotifier=function(p){if(this.getShowReset()){this.setShowResetEnabled(true);}};k.prototype._distributeValidationResult=function(r){var o={};r.forEach(function(R){R.panelTypes.forEach(function(t){if(o[t]===undefined){o[t]=[];}o[t].push({columnKey:R.columnKey,messageType:R.messageType,messageText:R.messageText});});});return o;};k.prototype._createOKButton=function(){var t=this;return new d(this.getId()+"-ok",{text:this._oResourceBundle.getText("P13NDIALOG_OK"),layoutData:new O({priority:e.NeverOverflow}),press:function(){t.setBusy(true);var p=t._getPayloadOfPanels();var F=function(){t.setBusy(false);t.fireOk({payload:p});};var i=[];var C=function(){t.getPanels().forEach(function(o){if(i.indexOf(o.getType())>-1){o.onAfterNavigationFrom();}});F();};t.getPanels().forEach(function(o){if(!o.onBeforeNavigationFrom()){i.push(o.getType());}});var v=[];var V=t.getValidationExecutor();if(V){V(p).then(function(v){if(i.length||v.length){t.setBusy(false);t._showValidationDialog(C,i,v);}else{F();}});}else{if(i.length||v.length){t.setBusy(false);t._showValidationDialog(C,i,v);}else{F();}}}});};k.prototype._createCancelButton=function(){var t=this;return new d(this.getId()+"-cancel",{text:this._oResourceBundle.getText("P13NDIALOG_CANCEL"),layoutData:new O({priority:e.NeverOverflow}),press:function(){t.fireCancel();}});};k.prototype._createResetButton=function(){var t=this;return new d(this.getId()+"-reset",{text:this._oResourceBundle.getText("P13NDIALOG_RESET"),layoutData:new O({priority:e.NeverOverflow}),visible:this.getShowReset(),enabled:this.getShowResetEnabled(),press:function(){t.setShowResetEnabled(false);var p={};t.getPanels().forEach(function(o){p[o.getType()]=o.getResetPayload();});t.fireReset({payload:p});}});};k.prototype._getPayloadOfPanels=function(){var p={};this.getPanels().forEach(function(o){p[o.getType()]=o.getOkPayload();});return p;};k.prototype.exit=function(){D.prototype.exit.apply(this,arguments);this._oObserver.disconnect();this._oObserver=undefined;this._mValidationListener={};this._mVisibleNavigationItems={};this._oNavigationControlsPromise=null;};k.prototype._isInstanceOf=function(o,m){var C=sap.ui.require(m);return o&&typeof C==='function'&&(o instanceof C);};function _(C){if(this._isInstanceOf(C.object,"sap/m/P13nDialog")){var i;switch(C.name){case"panels":var p=C.child?[C.child]:C.children;p.forEach(function(o){switch(C.mutation){case"insert":this._mVisibleNavigationItems[o.getType()]=o.getVisible();o.setVisible(false);o.beforeNavigationTo();this._oObserver.observe(o,{properties:["title"]});o.setValidationExecutor(q.proxy(this._callValidationExecutor,this));o.setValidationListener(q.proxy(this._registerValidationListener,this));o.setChangeNotifier(q.proxy(this._callChangeNotifier,this));break;case"remove":delete this._mVisibleNavigationItems[o.getType()];this._oObserver.unobserve(o);o.setValidationExecutor();o.setValidationListener();o.setChangeNotifier();break;default:q.sap.log.error("Mutation '"+C.mutation+"' is not supported jet.");}},this);if(this._bNavigationControlsPromiseResolved){this._updateDialog();}else{this._oNavigationControlsPromise.then(function(){this._updateDialog();}.bind(this));}break;case"showReset":i=this.getButtons();if(i.length>1){i[2].setVisible(C.current);}break;case"showResetEnabled":i=this.getButtons();if(i.length>1){i[2].setEnabled(C.current);i[2].invalidate();}break;default:q.sap.log.error("The property or aggregation '"+C.name+"' has not been registered.");}}else if(this._isInstanceOf(C.object,"sap/m/P13nPanel")){if(C.name==="title"){var I=this._getNavigationItemByPanel(C.object);if(I){if(b.system.phone){I.setTitle(C.current);}else{I.setText(C.current);}}}}}k.prototype._isNavigationControlExpected=function(){return this._getCountOfVisibleNavigationItems()>1;};k.prototype._getCountOfVisibleNavigationItems=function(){var C=0;for(var t in this._mVisibleNavigationItems){C=this._mVisibleNavigationItems[t]?C+1:C;}return C;};k.prototype._isNavigationControlExists=function(){return b.system.phone?this.getContent().length>0:(!!this.getSubHeader()&&this.getSubHeader().getContentLeft().length>0);};k.prototype._getNavigationControl=function(){if(!this._isNavigationControlExists()){this._createNavigationControl();}return b.system.phone?this.getContent()[0]:this.getSubHeader().getContentLeft()[0];};k.prototype._setVisibleOfNavigationControl=function(v){if(!this._isNavigationControlExists()){return;}return b.system.phone?this.getContent()[0].setVisible(v):this.getSubHeader().setVisible(v);};k.prototype._createNavigationControl=function(){if(b.system.phone){this.addContent(new N(this.getId()+"-navigationItems",{mode:f.None,itemPress:function(o){this._switchPanel(o.getParameter("listItem"));}.bind(this)}));}else{this.setSubHeader(new B(this.getId()+"-navigationBar",{contentLeft:new N(this.getId()+"-navigationItems",{width:'100%',selectionChange:function(o){this._switchPanel(o.getParameter("item"));}.bind(this)})}));}return this._getNavigationControl();};k.prototype._updateDialog=function(){var n=this._getNavigationControl();n.destroyItems();var i=this._determineInitialVisiblePanelType();this.getPanels().forEach(function(p){var o=this._mapPanelToNavigationItem(p);p.data("sapMP13nDialogNavigationItem",o);n.addItem(o);var v=b.system.phone?this._mVisibleNavigationItems[p.getType()]&&this._getCountOfVisibleNavigationItems()===1:this._mVisibleNavigationItems[p.getType()]&&i===p.getType();p.setVisible(v);if(v){if(!b.system.phone){this.setVerticalScrolling(p.getVerticalScrolling());}}o.setVisible(this._mVisibleNavigationItems[p.getType()]);if(v&&n.setSelectedItem){n.setSelectedItem(o);}}.bind(this));this._updateDialogTitle();this._setVisibleOfNavigationControl(this._isNavigationControlExpected());};k.prototype._determineInitialVisiblePanelType=function(){if(this.getInitialVisiblePanelType()&&this._mVisibleNavigationItems[this.getInitialVisiblePanelType()]){return this.getInitialVisiblePanelType();}var t;this.getPanels().some(function(p){if(this._mVisibleNavigationItems[p.getType()]){t=p.getType();return true;}}.bind(this));return t;};k.prototype._requestRequiredNavigationControls=function(){var n=b.system.phone?"sap/m/List":"sap/m/SegmentedButton";var s=b.system.phone?"sap/m/StandardListItem":"sap/m/SegmentedButtonItem";N=sap.ui.require(n);j=sap.ui.require(s);if(N&&j){this._bNavigationControlsPromiseResolved=true;return Promise.resolve();}if(!this._oNavigationControlsPromise){this._oNavigationControlsPromise=new Promise(function(r){sap.ui.require([n,s],function(i,m){N=i;j=m;this._bNavigationControlsPromiseResolved=true;return r();}.bind(this));}.bind(this));}return this._oNavigationControlsPromise;};return k;});
