/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/Device','sap/ui/core/Element','sap/ui/core/Control','./StandardListItem','./StandardListItemRenderer','sap/ui/core/Renderer','./library','sap/ui/unified/library','sap/ui/unified/DateRange','sap/ui/unified/CalendarRow','sap/ui/unified/CalendarRowRenderer','sap/m/ColumnListItem','sap/m/ColumnListItemRenderer','sap/ui/core/dnd/DragInfo','sap/ui/core/dnd/DropInfo','sap/ui/core/dnd/DragDropInfo'],function(q,D,E,C,S,a,R,l,u,b,c,d,e,f,g,h,j){"use strict";var k=u.CalendarIntervalType;var m="DragDropConfig";var n="ResizeConfig";var o="CreateConfig";var P=E.extend("sap.m.PlanningCalendarRow",{metadata:{library:"sap.m",properties:{title:{type:"string",group:"Data"},text:{type:"string",group:"Data"},icon:{type:"sap.ui.core.URI",group:"Data",defaultValue:null},nonWorkingDays:{type:"int[]",group:"Misc",defaultValue:null},nonWorkingHours:{type:"int[]",group:"Misc",defaultValue:null},selected:{type:"boolean",group:"Data",defaultValue:false},key:{type:"string",group:"Data",defaultValue:null},enableAppointmentsDragAndDrop:{type:"boolean",group:"Misc",defaultValue:false},enableAppointmentsResize:{type:"boolean",group:"Misc",defaultValue:false},enableAppointmentsCreate:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{appointments:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"appointment",dnd:{draggable:true}},intervalHeaders:{type:"sap.ui.unified.CalendarAppointment",multiple:true,singularName:"intervalHeader"},specialDates:{type:"sap.ui.unified.DateTypeRange",multiple:true,singularName:"specialDate"},_nonWorkingDates:{type:"sap.ui.unified.DateRange",multiple:true,visibility:"hidden"}},events:{appointmentDrop:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"},calendarRow:{type:"sap.m.PlanningCalendarRow"},copy:{type:"boolean"}}},appointmentDragEnter:{allowPreventDefault:true,parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"},calendarRow:{type:"sap.m.PlanningCalendarRow"}}},appointmentResize:{parameters:{appointment:{type:"sap.ui.unified.CalendarAppointment"},startDate:{type:"object"},endDate:{type:"object"}}},appointmentCreate:{parameters:{startDate:{type:"object"},endDate:{type:"object"},calendarRow:{type:"sap.m.PlanningCalendarRow"}}}}}});P.PC_FOREIGN_KEY_NAME="relatedToPCDateRange";P.AGGR_NONWORKING_DATES_NAME="_nonWorkingDates";var p=S.extend("CalenderRowHeader",{metadata:{associations:{parentRow:{type:"sap.m.PlanningCalendarRow",multiple:false}}},setParentRow:function(i){this.setAssociation("parentRow",i,true);if(!i){this._oRow=undefined;}else if(typeof i=="string"){this._oRow=sap.ui.getCore().byId(i);}else{this._oRow=i;}return this;},renderer:R.extend(a)});CalenderRowHeaderRenderer.openItemTag=function(i,L){i.write("<div");};CalenderRowHeaderRenderer.closeItemTag=function(i,L){i.write("</div>");};CalenderRowHeaderRenderer.renderTabIndex=function(i,L){};var r=R.extend(d);r.getLegendItems=function(i){var T=[],L,w=i.getLegend();if(w){L=sap.ui.getCore().byId(w);if(L){T=L.getAppointmentItems?L.getAppointmentItems():L.getItems();}else{q.sap.log.error("PlanningCalendarLegend with id '"+w+"' does not exist!",i);}}return T;};r.renderBeforeAppointments=function(w,x){var y;if(!x._oPlanningCalendarRow.getEnableAppointmentsDragAndDrop()&&!x._oPlanningCalendarRow.getEnableAppointmentsResize()&&!x._oPlanningCalendarRow.getEnableAppointmentsCreate()||x._isOneMonthIntervalOnSmallSizes()){return;}y=x.getAggregation("_intervalPlaceholders");w.write("<div class=\"sapUiCalendarRowAppsOverlay\">");if(y){for(var i=0;i<y.length;i++){var z=y[i];z.setWidth(100/y.length+"%");w.renderControl(z);}}w.write("</div>");};r.renderResizeHandle=function(i,w,A){if(!w._oPlanningCalendarRow.getEnableAppointmentsResize()||w._isOneMonthIntervalOnSmallSizes()||(A._aAppointments&&A._aAppointments.length>0)){return;}i.write("<span");i.addClass("sapUiCalendarAppResizeHandle");i.writeClasses();i.write(">");i.write("</span>");};r.writeCustomAttributes=function(i,w){if(w._oPlanningCalendarRow.getEnableAppointmentsCreate()){i.writeAttribute("draggable","true");}};r.renderInterval=function(w,x,y,W,z,N,A,B,F,G,H,J,L){var K=x.getIntervalType();if(K===k.Day||K===k.Week||K===k.OneMonth){var M=x._oPlanningCalendarRow.getSpecialDates(),O=x.getAggregation("_nonWorkingDates"),Q=x.getStartDate(),T,U,V;if(M){M.filter(function(x){return x.getType()===sap.ui.unified.CalendarDayType.NonWorking;});}if(O&&M){O=O.concat(M);}else if(M){O=M;}if(O&&O.length){var X=function(Z){return Z===T.getDay();};T=new Date(Q.getTime());T.setHours(0,0,0);T.setDate(Q.getDate()+y);for(var i=0;i<O.length;i++){if(O[i].getStartDate()){U=new Date(O[i].getStartDate().getTime());}if(O[i].getEndDate()){V=new Date(O[i].getEndDate().getTime());}else{V=new Date(O[i].getStartDate().getTime());V.setHours(23,59,59);}if(T.getTime()>=U.getTime()&&T.getTime()<=V.getTime()){var Y=N.some(X);if(!Y){w.addClass("sapUiCalendarRowAppsNoWork");}}}}}d.renderInterval(w,x,y,W,z,N,A,B,F,G,H,J,L);};var s=c.extend("CalendarRowInPlanningCalendar",{metadata:{aggregations:{_intervalPlaceholders:{type:"IntervalPlaceholder",multiple:true,visibility:"hidden",dnd:{droppable:true}},_nonWorkingDates:{type:"sap.ui.unified.DateRange",multiple:true,visibility:"hidden"}}},constructor:function(){c.apply(this,arguments);},renderer:r});s.PCROW_FOREIGN_KEY_NAME="relatedToPCRowDateRange";s.AGGR_NONWORKING_DATES_NAME="_nonWorkingDates";s.prototype._updatePlaceholders=function(){var w=this.getProperty("intervals");if(this.getIntervalType()===k.Hour){w*=2;}this.removeAllAggregation("_intervalPlaceholders");for(var i=0;i<w;i++){this.addAggregation("_intervalPlaceholders",new I());}};s.prototype.onBeforeRendering=function(){c.prototype.onBeforeRendering.call(this);this._updatePlaceholders();};s.prototype.onmousedown=function(i){var w=i.target.classList;this._isResizeHandleMouseDownTarget=w.contains("sapUiCalendarAppResizeHandle");this._isRowAppsIntervalMouseDownTarget=w.contains("sapUiCalendarRowAppsInt");};s.prototype._isResizingPerformed=function(){return this._isResizeHandleMouseDownTarget;};s.prototype._isDraggingPerformed=function(){return!this._isResizeHandleMouseDownTarget&&!this._isRowAppsIntervalMouseDownTarget;};s.prototype._isCreatingPerformed=function(){return this._isRowAppsIntervalMouseDownTarget;};var I=C.extend("IntervalPlaceholder",{metadata:{properties:{width:{type:"sap.ui.core.CSSSize",group:"Appearance",defaultValue:null}}},renderer:function(i,w){i.write("<div");i.writeControlData(w);i.addStyle("width",w.getWidth());i.writeStyles();i.addClass("sapUiCalendarRowAppsPlaceholder");i.writeClasses();i.write("></div>");}});var t=e.extend("ColumnListItemInPlanningCalendar",{metadata:{associations:{planningCalendarRow:{type:"sap.m.PlanningCalendarRow",multiple:false,visibility:"hidden"}}},renderer:f});t.prototype.getCustomData=function(){return sap.ui.getCore().byId(this.getAssociation("planningCalendarRow")).getCustomData();};P.prototype._addDragDropInfo=function(i){this.addDragDropConfig(new g({groupName:m,sourceAggregation:"appointments",dragStart:function(w){var H=function(){var $=q(".sapUiCalendarRowAppsOverlay");setTimeout(function(){$.addClass("sapUiCalendarRowAppsOverlayDragging");});q(document).one("dragend",function(){$.removeClass("sapUiCalendarRowAppsOverlayDragging");});};if(i._isOneMonthIntervalOnSmallSizes()||!i._isDraggingPerformed()){w.preventDefault();return;}H();}}));i.addDragDropConfig(new h({groupName:m,targetAggregation:"_intervalPlaceholders",dragEnter:function(w){var x=w.getParameter("dragSession"),A=x.getDragControl(),y=i.getIntervalType(),z=i.getStartDate(),B=i.indexOfAggregation("_intervalPlaceholders",x.getDropControl()),T=i.getId(),F,G=function(){var $=q(x.getIndicator()),J=x.getDropControl().getDomRef().getBoundingClientRect(),K=sap.ui.getCore().byId(T).getDomRef().getBoundingClientRect(),L=x.getDragControl().$().outerWidth(),M=sap.ui.getCore().getConfiguration().getRTL(),N=M?Math.ceil(J.right)-K.left:K.right-Math.ceil(J.left);$.css("min-width",(L<N)?L:N).css(M?"border-left-width":"border-right-width",(L>N)?"0":"").css("margin-left",M?-($.outerWidth()-parseFloat($.context.style.width)):"");};if(this.hasListeners("appointmentDragEnter")){if(y===k.Hour){F=this._calcNewHoursAppPos(z,A.getStartDate(),A.getEndDate(),B);}else if(y===k.Day||y===k.Week||(y===k.OneMonth&&!i._isOneMonthIntervalOnSmallSizes())){F=this._calcNewDaysAppPos(z,A.getStartDate(),A.getEndDate(),B);}else if(y===k.Month){F=this._calcNewMonthsAppPos(z,A.getStartDate(),A.getEndDate(),B);}var H=this.fireAppointmentDragEnter({appointment:A,startDate:F.startDate,endDate:F.endDate,calendarRow:i._oPlanningCalendarRow});if(!H){w.preventDefault();return;}}else if(A.getParent().getCalendarRow()!==i){w.preventDefault();return;}if(i.getIntervalType()!==k.Hour){return;}if(!x.getIndicator()){setTimeout(function(){G();},0);}else{G();}}.bind(this),drop:function(w){var x=w.getParameter("dragSession"),A=x.getDragControl(),y=i.getIntervalType(),z=i.getStartDate(),B=i.indexOfAggregation("_intervalPlaceholders",x.getDropControl()),F,G=w.getParameter("browserEvent"),H=(G.metaKey||G.ctrlKey);if(y===k.Hour){F=this._calcNewHoursAppPos(z,A.getStartDate(),A.getEndDate(),B);}else if(y===k.Day||y===k.Week||(y===k.OneMonth&&!i._isOneMonthIntervalOnSmallSizes())){F=this._calcNewDaysAppPos(z,A.getStartDate(),A.getEndDate(),B);}else if(y===k.Month){F=this._calcNewMonthsAppPos(z,A.getStartDate(),A.getEndDate(),B);}i.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");if(A.getStartDate().getTime()===F.startDate.getTime()&&A.getParent()===i._oPlanningCalendarRow){return;}this.fireAppointmentDrop({appointment:A,startDate:F.startDate,endDate:F.endDate,calendarRow:i._oPlanningCalendarRow,copy:H});}.bind(this)}));};P.prototype._calcNewHoursAppPos=function(i,A,w,x){var y=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours());y=new Date(y.getTime()+(x*30*60*1000));return{startDate:y,endDate:new Date(y.getTime()+w.getTime()-A.getTime())};};P.prototype._calcNewDaysAppPos=function(i,A,w,x){var y=new Date(i);y.setDate(y.getDate()+x);y=new Date(y.getFullYear(),y.getMonth(),y.getDate(),A.getHours(),A.getMinutes(),A.getSeconds());return{startDate:y,endDate:new Date(y.getTime()+w.getTime()-A.getTime())};};P.prototype._calcNewMonthsAppPos=function(i,A,w,x){var y=new Date(i);y.setMonth(y.getMonth()+x);y=new Date(y.getFullYear(),y.getMonth(),A.getDate(),A.getHours(),A.getMinutes(),A.getSeconds());return{startDate:y,endDate:new Date(y.getTime()+w.getTime()-A.getTime())};};P.prototype._calcResizeNewHoursAppPos=function(i,A,w,x){var y=new Date(i.getFullYear(),i.getMonth(),i.getDate(),i.getHours()),M=30*60*1000;y=new Date(y.getTime()+((x+1)*M));if(y.getTime()<=A.getTime()){y=new Date(A.getTime()+M);}return{startDate:A,endDate:y};};P.prototype._calcResizeNewDaysAppPos=function(i,A,w,x){var y=new Date(i),N=y.getDate()+x+1;if(N<=A.getDate()){N=A.getDate()+1;}y.setDate(N);y=new Date(y.getFullYear(),y.getMonth(),y.getDate());return{startDate:A,endDate:y};};P.prototype._calcResizeNewMonthsAppPos=function(i,A,w,x){var y=new Date(i),N=y.getMonth()+x+1;if(N<=A.getMonth()){N=A.getMonth()+1;}y.setMonth(N);y=new Date(y.getFullYear(),y.getMonth(),1);return{startDate:A,endDate:y};};P.prototype._calcCreateNewAppHours=function(i,w,x){var M=30*60*1000,A,y;if(w<=x){A=new Date(i.getTime()+(w*M));y=new Date(i.getTime()+((x+1)*M));}else{A=new Date(i.getTime()+(x*M));y=new Date(i.getTime()+(w*M));}return{startDate:A,endDate:y};};P.prototype._calcCreateNewAppDays=function(i,w,x){var A=new Date(i),y=new Date(i);if(w<=x){A=new Date(i.getFullYear(),i.getMonth(),i.getDate()+w);y=new Date(i.getFullYear(),i.getMonth(),i.getDate()+x+1);}else{A=new Date(i.getFullYear(),i.getMonth(),i.getDate()+x);y=new Date(i.getFullYear(),i.getMonth(),i.getDate()+w);}return{startDate:A,endDate:y};};P.prototype._calcCreateNewAppMonths=function(i,w,x){var A=new Date(i),y=new Date(i);if(w<=x){A=new Date(i.getFullYear(),i.getMonth()+w,1);y=new Date(i.getFullYear(),i.getMonth()+x+1,1);}else{A=new Date(i.getFullYear(),i.getMonth()+x,1);y=new Date(i.getFullYear(),i.getMonth()+w,1);}return{startDate:A,endDate:y};};P.prototype.init=function(){var i=this.getId();var w=new p(i+"-Head",{parentRow:this,iconDensityAware:false});var x=new s(i+"-CalRow",{checkResize:false,updateCurrentTime:false,ariaLabelledBy:i+"-Head"});x._oPlanningCalendarRow=this;x.getAppointments=function(){if(this._oPlanningCalendarRow){return this._oPlanningCalendarRow.getAppointments();}else{return[];}};x.getIntervalHeaders=function(){if(this._oPlanningCalendarRow){return this._oPlanningCalendarRow.getIntervalHeaders();}else{return[];}};this._oColumnListItem=new t(this.getId()+"-CLI",{cells:[w,x],planningCalendarRow:this});};P.prototype.exit=function(){if(this._oColumnListItem.getCells()[1]){this._oColumnListItem.getCells()[1].destroy();}this._oColumnListItem.destroy();this._oColumnListItem=undefined;};P.prototype.setEnableAppointmentsDragAndDrop=function(i){this.setProperty("enableAppointmentsDragAndDrop",i,true);if(i){var w=this.getDragDropConfig().some(function(x){return x.getGroupName()===m;});if(!w){this._addDragDropInfo(this.getCalendarRow());}}else{this.getDragDropConfig().forEach(function(x){if(x.getGroupName()===m){this.removeDragDropConfig(x);}},this);this.getCalendarRow().getDragDropConfig().forEach(function(x){if(x.getGroupName()===m){this.getCalendarRow().removeDragDropConfig(x);}},this);}return this;};P.prototype.setTooltip=function(T){this.setAggregation("tooltip",T,true);this._oColumnListItem.getCells()[0].setTooltip(T);return this;};P.prototype.setTitle=function(T){this.setProperty("title",T,true);this._oColumnListItem.getCells()[0].setTitle(T);return this;};P.prototype.setText=function(T){this.setProperty("text",T,true);this._oColumnListItem.getCells()[0].setDescription(T);if(T){this._oColumnListItem.getCells()[1].addStyleClass("sapMPlanCalRowLarge");}else{this._oColumnListItem.getCells()[1].removeStyleClass("sapMPlanCalRowLarge");}return this;};P.prototype.setIcon=function(i){this.setProperty("icon",i,true);this._oColumnListItem.getCells()[0].setIcon(i);return this;};P.prototype.setNonWorkingDays=function(N){this.setProperty("nonWorkingDays",N,true);this.getCalendarRow().setNonWorkingDays(N);return this;};P.prototype.setNonWorkingHours=function(N){this.setProperty("nonWorkingHours",N,true);this.getCalendarRow().setNonWorkingHours(N);return this;};P.prototype.setEnableAppointmentsResize=function(i){var O=this._getConfigFromDragDropConfigAggregation(this.getAggregation("dragDropConfig"),n),N=this._getResizeConfig();this.setProperty("enableAppointmentsResize",i,true);if(i&&!O){this.addAggregation("dragDropConfig",N,true);}if(!i){this.removeAggregation("dragDropConfig",O,true);}return this;};P.prototype.setEnableAppointmentsCreate=function(i){var w=this.getCalendarRow(),O=this._getConfigFromDragDropConfigAggregation(w.getAggregation("dragDropConfig"),o),N=this._getAppointmentsCreateConfig();this.setProperty("enableAppointmentsCreate",i,true);if(i&&!O){w.addAggregation("dragDropConfig",N,true);}if(!i){w.removeAggregation("dragDropConfig",O,true);}return this;};P.prototype.invalidate=function(O){if(!O||!(O instanceof sap.ui.unified.CalendarAppointment)){E.prototype.invalidate.apply(this,arguments);}else if(this._oColumnListItem){this.getCalendarRow().invalidate(O);}};P.prototype.removeAppointment=function(O){var i=this.removeAggregation("appointments",O,true);this.getCalendarRow().invalidate();return i;};P.prototype.removeAllAppointments=function(){var i=this.removeAllAggregation("appointments",true);this.getCalendarRow().invalidate();return i;};P.prototype.destroyAppointments=function(){var i=this.destroyAggregation("appointments",true);this.getCalendarRow().invalidate();return i;};P.prototype.removeIntervalHeader=function(O){var i=this.removeAggregation("intervalHeaders",O,true);this.getCalendarRow().invalidate();return i;};P.prototype.removeAllIntervalHeaders=function(){var i=this.removeAllAggregation("intervalHeaders",true);this.getCalendarRow().invalidate();return i;};P.prototype.destroyIntervalHeaders=function(){var i=this.destroyAggregation("intervalHeaders",true);this.getCalendarRow().invalidate();return i;};P.prototype.setSelected=function(i){this.setProperty("selected",i,true);this._oColumnListItem.setSelected(i);return this;};P.prototype.getColumnListItem=function(){return this._oColumnListItem;};P.prototype.getCalendarRow=function(){if(!this._oColumnListItem){return null;}return this._oColumnListItem.getCells()[1];};P.prototype.applyFocusInfo=function(F){this.getCalendarRow().applyFocusInfo(F);return this;};P.prototype.addAggregation=function(A,O,i){if(P.AGGR_NONWORKING_DATES_NAME===A){this.getCalendarRow().addAggregation(s.AGGR_NONWORKING_DATES_NAME,this._buildCalendarRowDateRange(O),i);}return E.prototype.addAggregation.apply(this,arguments);};P.prototype.insertAggregation=function(A,O,i,w){if(P.AGGR_NONWORKING_DATES_NAME===A){this.getCalendarRow().insertAggregation(s.AGGR_NONWORKING_DATES_NAME,this._buildCalendarRowDateRange(O),i,w);}return E.prototype.insertAggregation.apply(this,arguments);};P.prototype.removeAggregation=function(A,O,i){var w;if(P.AGGR_NONWORKING_DATES_NAME===A&&this.getAggregation(P.AGGR_NONWORKING_DATES_NAME)){w=this.getCalendarRow().getAggregation(s.AGGR_NONWORKING_DATES_NAME).filter(function(N){return N.data(s.PCROW_FOREIGN_KEY_NAME)===O.getId();});if(w.length){this.getCalendarRow().removeAggregation("_nonWorkingDates",w[0]);}}return E.prototype.removeAggregation.apply(this,arguments);};P.prototype.removeAllAggregation=function(A,i){if(P.AGGR_NONWORKING_DATES_NAME===A){this.getCalendarRow().removeAllAggregation(s.AGGR_NONWORKING_DATES_NAME,i);}return E.prototype.removeAllAggregation.apply(this,arguments);};P.prototype.destroyAggregation=function(A,i){if(P.AGGR_NONWORKING_DATES_NAME===A){if(this.getCalendarRow()){this.getCalendarRow().destroyAggregation(s.AGGR_NONWORKING_DATES_NAME,i);}}return E.prototype.destroyAggregation.apply(this,arguments);};P.prototype._buildCalendarRowDateRange=function(i){var w=new b();if(i.getStartDate()){w.setStartDate(new Date(i.getStartDate().getTime()));}if(i.getEndDate()){w.setEndDate(new Date(i.getEndDate().getTime()));}w.data(s.PCROW_FOREIGN_KEY_NAME,i.getId());return w;};P.prototype._getResizeConfig=function(){var i=this,w=this.getCalendarRow(),x=new j({sourceAggregation:"appointments",targetAggregation:"_intervalPlaceholders",targetElement:this.getCalendarRow(),dragStart:function(y){if(!i.getEnableAppointmentsResize()||w._isOneMonthIntervalOnSmallSizes()||!w._isResizingPerformed()){y.preventDefault();return;}var z=y.getParameter("dragSession"),$=w.$().find(".sapUiCalendarRowAppsOverlay"),A=q(z.getIndicator()),B=z.getDragControl().$();A.addClass("sapUiDnDIndicatorHide");setTimeout(function(){$.addClass("sapUiCalendarRowAppsOverlayDragging");});q(document).one("dragend",function(){$.removeClass("sapUiCalendarRowAppsOverlayDragging");A.removeClass("sapUiDnDIndicatorHide");B.css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});});if(!D.browser.msie&&!D.browser.edge){y.getParameter("browserEvent").dataTransfer.setDragImage(v(),0,0);}},dragEnter:function(y){var z=y.getParameter("dragSession"),T=this.getTargetElement(),H=function(){var $=q(z.getIndicator());$.addClass("sapUiDnDIndicatorHide");},A=z.getDropControl().getDomRef().getBoundingClientRect(),B=sap.ui.getCore().byId(T).getDomRef().getBoundingClientRect(),F={width:A.left+A.width-(z.getDragControl().$().position().left+B.left),"min-width":Math.min(z.getDragControl().$().outerWidth(),z.getDropControl().$().outerWidth()),"z-index":1,opacity:0.8};z.getDragControl().$().css(F);if(!z.getIndicator()){q.sap.delayedCall(0,null,H);}else{H();}},drop:function(y){var w=i.getCalendarRow();var z=y.getParameter("dragSession"),A=z.getDragControl(),B=w.getIntervalType(),F=w.getStartDate(),G=w.indexOfAggregation("_intervalPlaceholders",z.getDropControl()),H;if(B===k.Hour){H=this._calcResizeNewHoursAppPos(F,A.getStartDate(),A.getEndDate(),G);}else if(B===k.Day||B===k.Week||(B===k.OneMonth&&!w._isOneMonthIntervalOnSmallSizes())){H=this._calcResizeNewDaysAppPos(F,A.getStartDate(),A.getEndDate(),G);}else if(B===k.Month){H=this._calcResizeNewMonthsAppPos(F,A.getStartDate(),A.getEndDate(),G);}w.$().find(".sapUiCalendarRowAppsOverlay").removeClass("sapUiCalendarRowAppsOverlayDragging");q(z.getIndicator()).removeClass("sapUiDnDIndicatorHide");A.$().css({width:"auto","min-width":"auto","z-index":"auto",opacity:1});if(A.getEndDate().getTime()===H.endDate.getTime()){return;}this.fireAppointmentResize({appointment:A,startDate:H.startDate,endDate:H.endDate,calendarRow:w._oPlanningCalendarRow});}.bind(this)});x.setProperty("groupName",n);return x;};P.prototype._getConfigFromDragDropConfigAggregation=function(A,w){var x=A,y=x&&x.length;for(var i=0;i<y;i++){if(x[i].getGroupName()===w){return x[i];}}return null;};P.prototype._getAppointmentsCreateConfig=function(){var i=this,w=this.getCalendarRow(),x=new j({targetAggregation:"_intervalPlaceholders",dragStart:function(y){if(!i.getEnableAppointmentsCreate()||w._isOneMonthIntervalOnSmallSizes()||!w._isCreatingPerformed()){y.preventDefault();return;}var z=y.getParameter("dragSession"),$=w.$().find(".sapUiCalendarRowAppsOverlay"),A=q(z.getIndicator());setTimeout(function(){$.addClass("sapUiCalendarRowAppsOverlayDragging");});q(document).one("dragend",function(){$.removeClass("sapUiCalendarRowAppsOverlayDragging");A.html("");A.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");});if(!D.browser.msie&&!D.browser.edge){y.getParameter("browserEvent").dataTransfer.setDragImage(v(),0,0);}},dragEnter:function(y){var z=y.getParameter("dragSession"),A=z.getDropControl().getDomRef().getBoundingClientRect(),B=function(){var $=q(z.getIndicator());$.addClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");};var F=z.getData("text")?parseFloat(z.getData("text").split("|")[0]):0;if(F){if(F<=A.left){z.setIndicatorConfig({left:F,width:Math.max((A.left+A.width-F),A.width)});}else{z.setIndicatorConfig({left:A.left,width:F-A.left});}}else{z.setData("text",A.left+"|"+w.indexOfAggregation("_intervalPlaceholders",z.getDropControl()));}if(!z.getIndicator()){q.sap.delayedCall(0,null,B);}else{B();}},drop:function(y){var z=y.getParameter("dragSession"),$=q(z.getIndicator()),A=w.getIntervalType(),B=i.getCalendarRow().getStartDate(),F=parseInt(z.getData("text").split("|")[1],10),G=w.indexOfAggregation("_intervalPlaceholders",z.getDropControl()),N;if(A===k.Hour){N=this._calcCreateNewAppHours(B,F,G);}else if(A===k.Day||A===k.Week||(A===k.OneMonth&&!w._isOneMonthIntervalOnSmallSizes())){N=this._calcCreateNewAppDays(B,F,G);}else if(A===k.Month){N=this._calcCreateNewAppMonths(B,F,G);}this.fireAppointmentCreate({startDate:N.startDate,endDate:N.endDate,calendarRow:w._oPlanningCalendarRow});$.html("");$.removeClass("sapUiCalendarApp sapUiCalendarAppType01 sapUiAppCreate");}.bind(this)});x.setProperty("groupName",o);return x;};function v(){var $=q("<span></span>").addClass("sapUiCalAppResizeGhost");$.appendTo(document.body);q.sap.delayedCall(0,null,function(){$.remove();});return $.get(0);}return P;});
