/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/Device","./library","./ListBase","./ListItemBase","./CheckBox","./TableRenderer"],function(q,D,l,L,a,C,T){"use strict";var b=l.ListKeyboardMode;var c=l.ListGrowingDirection;var B=l.BackgroundDesign;var P=l.PopinLayout;var S=l.Sticky;var d=L.extend("sap.m.Table",{metadata:{library:"sap.m",properties:{backgroundDesign:{type:"sap.m.BackgroundDesign",group:"Appearance",defaultValue:B.Translucent},fixedLayout:{type:"boolean",group:"Behavior",defaultValue:true},showOverlay:{type:"boolean",group:"Appearance",defaultValue:false},alternateRowColors:{type:"boolean",group:"Appearance",defaultValue:false},popinLayout:{type:"sap.m.PopinLayout",group:"Appearance",defaultValue:P.Block},sticky:{type:"sap.m.Sticky[]",group:"Appearance"}},aggregations:{columns:{type:"sap.m.Column",multiple:true,singularName:"column",dnd:{draggable:true,droppable:true,layout:"Horizontal"}}},events:{beforeOpenContextMenu:{allowPreventDefault:true,parameters:{listItem:{type:"sap.m.ColumnListItem"},column:{type:"sap.m.Column"}}}},designtime:"sap/m/designtime/Table.designtime"}});d.prototype.sNavItemClass="sapMListTblRow";d.prototype.init=function(){this._iItemNeedsColumn=0;L.prototype.init.call(this);};d.prototype.onBeforeRendering=function(){L.prototype.onBeforeRendering.call(this);this._ensureColumnsMedia();this._notifyColumns("ItemsRemoved");};d.prototype._ensureColumnsMedia=function(){this.getColumns().forEach(function(o){if(o._bShouldAddMedia){o._addMedia();}});};d.prototype.onAfterRendering=function(){L.prototype.onAfterRendering.call(this);this.updateSelectAllCheckbox();this._renderOverlay();};d.prototype._renderOverlay=function(){var $=this.$(),e=$.find(".sapMTableOverlay"),s=this.getShowOverlay();if(s&&e.length===0){e=q("<div>").addClass("sapUiOverlay sapMTableOverlay").css("z-index","1");$.append(e);}else if(!s){e.remove();}};d.prototype.setShowOverlay=function(s){this.setProperty("showOverlay",s,true);this._renderOverlay();return this;};d.prototype.exit=function(){L.prototype.exit.call(this);if(this._selectAllCheckBox){this._selectAllCheckBox.destroy();this._selectAllCheckBox=null;}};d.prototype.destroyItems=function(){this._notifyColumns("ItemsRemoved");return L.prototype.destroyItems.apply(this,arguments);};d.prototype.removeAllItems=function(){this._notifyColumns("ItemsRemoved");return L.prototype.removeAllItems.apply(this,arguments);};d.prototype.removeSelections=function(){L.prototype.removeSelections.apply(this,arguments);this.updateSelectAllCheckbox();return this;};d.prototype.selectAll=function(){L.prototype.selectAll.apply(this,arguments);this.updateSelectAllCheckbox();return this;};d.prototype.getColumns=function(s){var e=this.getAggregation("columns",[]);if(s){e.sort(function(f,g){return f.getOrder()-g.getOrder();});}return e;};d.prototype.onAfterPageLoaded=function(){this.updateSelectAllCheckbox();if(this.getAlternateRowColors()){var $=this.$("tblBody").removeClass();$.addClass(this._getAlternateRowColorsClass());}L.prototype.onAfterPageLoaded.apply(this,arguments);};d.prototype.shouldRenderItems=function(){var h=this.getColumns().some(function(o){return o.getVisible();});if(!h){q.sap.log.warning("No visible columns found in "+this);}return h;};d.prototype.onItemTypeColumnChange=function(i,n){this._iItemNeedsColumn+=(n?1:-1);if(this._iItemNeedsColumn==1&&n){this._setTypeColumnVisibility(true);}else if(this._iItemNeedsColumn==0){this._setTypeColumnVisibility(false);}};d.prototype.onItemSelectedChange=function(i,s){L.prototype.onItemSelectedChange.apply(this,arguments);q.sap.delayedCall(0,this,function(){this.updateSelectAllCheckbox();});};d.prototype.getTableDomRef=function(){return this.getDomRef("listUl");};d.prototype.getItemsContainerDomRef=function(){return this.getDomRef("tblBody");};d.prototype.setNavigationItems=function(i){var h=this.$("tblHeader");var f=this.$("tblFooter");var r=this.$("tblBody").children(".sapMLIB");var I=h.add(r).add(f).get();i.setItemDomRefs(I);if(i.getFocusedIndex()==-1){if(this.getGrowing()&&this.getGrowingDirection()==c.Upwards){i.setFocusedIndex(I.length-1);}else{i.setFocusedIndex(h[0]?1:0);}}};d.prototype.checkGrowingFromScratch=function(){if(this.hasPopin()){return false;}return this.getColumns().some(function(o){return o.getVisible()&&o.getMergeDuplicates();});};d.prototype.onColumnResize=function(o){if(!this.hasPopin()&&!this._mutex){var h=this.getColumns().some(function(f){return f.isPopin();});if(!h){o.setDisplayViaMedia(this.getTableDomRef());return;}}this._dirty=this._getMediaContainerWidth()||window.innerWidth;if(!this._mutex){var e=this._getMediaContainerWidth()||window.innerWidth;this._mutex=true;this.rerender();q.sap.delayedCall(200,this,function(){if(this._dirty!=e){this._dirty=0;this.rerender();}this._mutex=false;});}};d.prototype.setTableHeaderVisibility=function(e){if(!this.getDomRef()){return;}var $=this.$("tblHeader"),h=!$.hasClass("sapMListTblHeaderNone"),v=$.find(".sapMListTblCell:visible"),f=v.eq(0);if(v.length==1){f.width("");}else{v.each(function(){this.style.width=this.getAttribute("data-sap-width")||"";});}this._colCount=v.length+2+!!sap.m.ListBaseRenderer.ModeOrder[this.getMode()];this.$("tblBody").find(".sapMGHLICell").attr("colspan",this.getColSpan());this.$("nodata-text").attr("colspan",this.getColCount());if(this.getFixedLayout()){this._forceStyleChange();}if(!e&&h){$[0].className="sapMListTblRow sapMListTblHeader";this._headerHidden=false;}else if(e&&!h&&!v.length){$[0].className="sapMListTblHeaderNone";this._headerHidden=true;}};d.prototype._forceStyleChange=function(){if(D.browser.msie){var t=this.getTableDomRef().style;t.listStyleType="circle";window.setTimeout(function(){t.listStyleType="none";},0);}};d.prototype._setTypeColumnVisibility=function(v){q(this.getTableDomRef()).toggleClass("sapMListTblHasNav",v);};d.prototype._notifyColumns=function(A,p,v){this.getColumns().forEach(function(o){o["on"+A](p,v);});};d.prototype._getSelectAllCheckbox=function(){return this._selectAllCheckBox||(this._selectAllCheckBox=new C({id:this.getId("sa"),activeHandling:false}).addStyleClass("sapMLIBSelectM").setParent(this,null,true).attachSelect(function(){if(this._selectAllCheckBox.getSelected()){this.selectAll(true);}else{this.removeSelections(false,true);}},this).setTabIndex(-1));};d.prototype.updateSelectAllCheckbox=function(){if(this._selectAllCheckBox&&this.getMode()==="MultiSelect"){var i=this.getItems(),s=this.getSelectedItems().length,e=i.filter(function(I){return I.isSelectable();}).length;this._selectAllCheckBox.setSelected(i.length>0&&s==e);}};d.prototype.enhanceAccessibilityState=function(e,A){if(e==this._selectAllCheckBox){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m");A.label=o.getText("TABLE_CHECKBOX_SELECT_ALL");}};d.prototype.getColSpan=function(){return(this._colCount||1)-1;};d.prototype.getColCount=function(){return(this._colCount||0);};d.prototype.hasPopin=function(){return!!this._hasPopin;};d.prototype.isHeaderRowEvent=function(e){var h=this.$("tblHeader");return!!q(e.target).closest(h,this.getTableDomRef()).length;};d.prototype.isFooterRowEvent=function(e){var f=this.$("tblFooter");return!!q(e.target).closest(f,this.getTableDomRef()).length;};d.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TABLE");};d.prototype.getAccessibilityDescription=function(){return L.prototype.getAccessibilityDescription.call(this)+" "+this.getFooterText();};d.prototype._setHeaderAnnouncement=function(){var o=sap.ui.getCore().getLibraryResourceBundle("sap.m"),A=o.getText("ACC_CTR_TYPE_HEADER_ROW")+" ";if(this.isAllSelectableSelected()){A+=o.getText("LIST_ALL_SELECTED");}this.getColumns(true).forEach(function(e,i){if(!e.getVisible()){return;}var h=e.getHeader();if(h&&h.getVisible()){A+=a.getAccessibilityText(h)+" ";}});this.updateInvisibleText(A);};d.prototype._setFooterAnnouncement=function(){var A=sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_FOOTER_ROW")+" ";this.getColumns(true).forEach(function(o,i){if(!o.getVisible()){return;}var f=o.getFooter();if(f&&f.getVisible()){var h=o.getHeader();if(h&&h.getVisible()){A+=a.getAccessibilityText(h)+" ";}A+=a.getAccessibilityText(f)+" ";}});this.updateInvisibleText(A);};d.prototype.onsapspace=function(e){if(e.isMarked()){return;}if(this._selectAllCheckBox&&e.target===this.getDomRef("tblHeader")){this._selectAllCheckBox.setSelected(!this._selectAllCheckBox.getSelected()).fireSelect();e.preventDefault();e.setMarked();}};d.prototype.onsaptabnext=function(e){if(e.isMarked()||this.getKeyboardMode()==b.Edit){return;}var r=q();if(e.target.id==this.getId("nodata")){r=this.$("nodata");}else if(this.isHeaderRowEvent(e)){r=this.$("tblHeader");}else if(this.isFooterRowEvent(e)){r=this.$("tblFooter");}var o=r.find(":sapTabbable").get(-1)||r[0];if(e.target===o){this.forwardTab(true);e.setMarked();}};d.prototype.onsaptabprevious=function(e){if(e.isMarked()||this.getKeyboardMode()==b.Edit){return;}var t=e.target.id;if(t==this.getId("nodata")||t==this.getId("tblHeader")||t==this.getId("tblFooter")){this.forwardTab(false);}else if(t==this.getId("trigger")){this.focusPrevious();e.preventDefault();}};d.getStickyBrowserSupport=function(){var o=D.browser;return(o.safari||o.chrome||(o.firefox&&o.version>=59)||(o.edge&&o.version>=16));};d.prototype.getStickyStyleValue=function(){var s=this.getSticky();if(!s||!s.length||!d.getStickyBrowserSupport()){return(this._iStickyValue=0);}var i=0,h=this.getHeaderText(),H=this.getHeaderToolbar(),e=h||(H&&H.getVisible()),I=this.getInfoToolbar(),f=I&&I.getVisible(),g=this.getColumns().some(function(o){return o.getVisible()&&o.getHeader();});s.forEach(function(j){if(j===S.HeaderToolbar&&e){i+=1;}else if(j===S.InfoToolbar&&f){i+=2;}else if(j===S.ColumnHeaders&&g){i+=4;}});return(this._iStickyValue=i);};d.prototype.setHeaderToolbar=function(h){return this._setToolbar("headerToolbar",h);};d.prototype.setInfoToolbar=function(i){return this._setToolbar("infoToolbar",i);};d.prototype._setToolbar=function(A,t){var o=this.getAggregation(A);if(o){o.detachEvent("_change",this._onToolbarPropertyChanged,this);}this.setAggregation(A,t);if(t){t.attachEvent("_change",this._onToolbarPropertyChanged,this);}return this;};d.prototype._onToolbarPropertyChanged=function(e){if(e.getParameter("name")!=="visible"){return;}var o=this._iStickyValue,n=this.getStickyStyleValue();if(o!==n){var t=this.getDomRef();if(t){var f=t.classList;f.toggle("sapMSticky",!!n);f.remove("sapMSticky"+o);f.toggle("sapMSticky"+n,!!n);}}};d.prototype.onfocusin=function(e){var t=e.target;if(t.id===this.getId("tblHeader")){this._setHeaderAnnouncement();}else if(t.id===this.getId("tblFooter")){this._setFooterAnnouncement();}if(this._bThemeChanged){this._bThemeChanged=false;this._forceStyleChange();}L.prototype.onfocusin.call(this,e);};d.prototype._handleStickyItemFocus=function(i){if(!this._iStickyValue||this._sLastFocusedStickyItemId===i.id){return;}var s=l.getScrollDelegate(this,true);if(!s){return;}var t=0,e=0,I=0,f=0,h=0,H=0;if(this._iStickyValue&4){var o=this.getDomRef("tblHeader").firstChild;var g=o.getBoundingClientRect();e=parseInt(g.bottom,10);t=parseInt(g.height,10);}if(this._iStickyValue&2){var j=this.getInfoToolbar().$().parent()[0];var k=j.getBoundingClientRect();f=parseInt(k.bottom,10);I=parseInt(k.height,10);}if(this._iStickyValue&1){var m=this.getDomRef().querySelector(".sapMListHdr");var n=m.getBoundingClientRect();H=parseInt(n.bottom,10);h=parseInt(n.height,10);}var p=Math.round(i.getBoundingClientRect().top);if(e>p||f>p||H>p){window.requestAnimationFrame(function(){s.scrollToElement(i,0,[0,-t-I-h]);});}this._sLastFocusedStickyItemId=i.id;};d.prototype.onItemFocusIn=function(i){this._handleStickyItemFocus(i.getDomRef());L.prototype.onItemFocusIn.apply(this,arguments);};d.prototype.onThemeChanged=function(){L.prototype.onThemeChanged.call(this);this._bThemeChanged=true;};d.prototype._getAlternateRowColorsClass=function(){if(this.isGrouped()){return"sapMListTblAlternateRowColorsGrouped";}if(this.hasPopin()){return"sapMListTblAlternateRowColorsPopin";}return"sapMListTblAlternateRowColors";};return d;});
