/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./InputBase','./DateTimeField','./MaskInputRule','./ResponsivePopover','sap/ui/core/EnabledPropagator','sap/ui/core/IconPool','./TimePickerSliders','./MaskEnabler','sap/ui/Device','sap/ui/core/format/DateFormat','sap/ui/core/Locale','sap/m/library','sap/ui/core/LocaleData','./TimePickerRenderer','jquery.sap.keycodes'],function(q,I,D,M,R,E,a,T,b,c,d,L,l,e,f){"use strict";var P=l.PlacementType,g=l.TimePickerMaskMode,h=1;var j=D.extend("sap.m.TimePicker",{metadata:{library:"sap.m",designtime:"sap/m/designtime/TimePicker.designtime",properties:{localeId:{type:"string",group:"Data"},title:{type:"string",group:"Misc",defaultValue:null},minutesStep:{type:"int",group:"Misc",defaultValue:h},secondsStep:{type:"int",group:"Misc",defaultValue:h},placeholderSymbol:{type:"string",group:"Misc",defaultValue:"_"},mask:{type:"string",group:"Misc",defaultValue:null},maskMode:{type:"sap.m.TimePickerMaskMode",group:"Misc",defaultValue:g.On},support2400:{type:"boolean",group:"Misc",defaultValue:false}},aggregations:{rules:{type:"sap.m.MaskInputRule",multiple:true,singularName:"rule"},_picker:{type:"sap.m.ResponsivePopover",multiple:false,visibility:"hidden"}}}});a.insertFontFaceStyle();E.call(j.prototype,true);b.call(j.prototype);var k={Short:"short",Medium:"medium",Long:"long"},m={Hour:"hour",Minute:"minute",Second:"second"},n='-';j.prototype.init=function(){b.init.apply(this,arguments);this.setDisplayFormat(p());this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.m");this._bValid=false;this._sUsedDisplayPattern=null;this._sUsedValuePattern=null;this._oDisplayFormat=null;this._sValueFormat=null;this._oPopoverKeydownEventDelegate=null;this._rPlaceholderRegEx=new RegExp(n,'g');this._sLastChangeValue=null;};j.prototype.exit=function(){if(this._oTimeSemanticMaskHelper){this._oTimeSemanticMaskHelper.destroy();}b.exit.apply(this,arguments);this._removePickerEvents();this._oResourceBundle=null;this._bValid=false;this._sUsedDisplayPattern=null;this._oDisplayFormat=null;this._oPopoverKeydownEventDelegate=null;this._sUsedValuePattern=null;this._sValueFormat=null;this._sLastChangeValue=null;};j.prototype.ontap=function(i){var r,s;if(!(this.getEditable()&&this.getEnabled())){return;}r=q(i.target).hasClass("sapUiIcon");s=this._getPicker()&&this._getPicker().isOpen();if(!s&&r){this._openPicker();}else if(r&&!c.system.phone){this._closePicker();}};j.prototype.onfocusin=function(i){var r=this._getPicker();var s=q(i.target).hasClass("sapUiIcon");b.onfocusin.apply(this,arguments);if(r&&r.isOpen()&&!s){this._closePicker();}};j.prototype.onBeforeOpen=function(){var s=this._getSliders(),i=this.getDateValue(),r=this._$input.val(),F=this.getValueFormat(),t=F.indexOf("HH"),u=F.indexOf("H");s.setValue(r);if(this._shouldSetInitialFocusedDateValue()){i=this.getInitialFocusedDateValue();}s._setTimeValues(i,T._isHoursValue24(r,t,u));s.collapseAll();this.$().addClass("sapMTPInputActive");};j.prototype.onAfterOpen=function(){var s=this._getSliders();if(s){s.openFirstSlider();this._handleAriaOnExpandCollapse();}};j.prototype.onAfterClose=function(){this.$().removeClass("sapMTPInputActive");this._handleAriaOnExpandCollapse();};j.prototype._handleInputChange=function(v){var i,t,r,F=this.getValueFormat(),s=F.indexOf("HH"),u=F.indexOf("H");v=v||this._$input.val();t=v;r=T._isHoursValue24(t,s,u);this._bValid=true;if(v!==""){i=this._parseValue(T._isHoursValue24(v,s,u)?T._replace24HoursWithZero(v,s,u):v,true);if(!i){this._bValid=false;}else{v=this._formatValue(i);}}t=this.getSupport2400()&&r?"24:"+v.replace(/[0-9]/g,"0").slice(0,-3):v;this.updateDomValue(t);if(i){t=v=this._formatValue(i,true);}this.setProperty("value",t,true);this._lastValue=v;if(this._bValid){this.setProperty("dateValue",i,true);}this.fireChangeEvent(t,{valid:this._bValid});return true;};j.prototype.onChange=function(i){var v=i?i.value:null;if(this.getEditable()&&this.getEnabled()){return this._handleInputChange(v);}return false;};j.prototype.setMinutesStep=function(s){var S=this._getSliders();s=Math.max(h,s||h);if(S){S.setMinutesStep(s);}return this.setProperty("minutesStep",s,true);};j.prototype.setSecondsStep=function(s){var S=this._getSliders();s=Math.max(h,s||h);if(S){S.setSecondsStep(s);}return this.setProperty("secondsStep",s,true);};j.prototype.setTitle=function(t){var s=this._getSliders();if(s){s.setLabelText(t);}this.setProperty("title",t,true);return this;};j.prototype._handleDateValidation=function(i){if(!i){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);}else{this._bValid=true;this.setProperty("dateValue",i,true);var v=this._formatValue(i);if(this.isActive()){this.updateDomValue(v);}else{this.setProperty("value",v,true);this._lastValue=v;this._sLastChangeValue=v;}}};j.prototype.setSupport2400=function(s){var S=this._getSliders();this.setProperty("support2400",s,true);if(S){S.setSupport2400(s);}this._initMask();return this;};j.prototype.setDisplayFormat=function(s){var S=this._getSliders();this.setProperty("displayFormat",s,true);this._initMask();if(S){S.setDisplayFormat(s);}var i=this.getDateValue();if(!i){return this;}var O=this._formatValue(i);this.updateDomValue(O);this._lastValue=O;return this;};j.prototype.setValue=function(v){var i,O,F=this.getValueFormat(),r=F.indexOf("HH"),s=F.indexOf("H"),S=this._getSliders();v=this.validateProperty("value",v);this._initMask();b.setValue.call(this,v);this._sLastChangeValue=v;this._bValid=true;if(v){i=this._parseValue(T._isHoursValue24(v,r,s)?T._replace24HoursWithZero(v,r,s):v);if(!i){this._bValid=false;q.sap.log.warning("Value can not be converted to a valid date",this);}}if(this._bValid){this.setProperty("dateValue",i,true);}if(i&&!this.getSupport2400()){O=this._formatValue(i);}else{O=v;}if(S){S.setValue(v);}this.updateDomValue(O);this._lastValue=O;return this;};j.prototype.setTooltip=function(t){var i=this.getDomRef(),s;this._refreshTooltipBaseDelegate(t);this.setAggregation("tooltip",t,true);if(!i){return this;}s=this.getTooltip_AsString();if(s){i.setAttribute("title",s);}else{i.removeAttribute("title");}this._handleTooltipHiddenTextLifecycle();return this;};j.prototype._handleTooltipHiddenTextLifecycle=function(){var r,s,A,H,C,i;if(!sap.ui.getCore().getConfiguration().getAccessibility()){return;}r=this.getRenderer();s=r.getAriaDescribedBy(this);A=r.getDescribedByAnnouncement(this);H=this.getId()+"-describedby";C=s.indexOf(H)>-1;i=this.getDomRef("describedby");if(C){i=document.createElement("span");i.id=H;i.setAttribute("aria-hidden","true");i.className="sapUiInvisibleText";i.textContent=A;this.getDomRef().appendChild(i);}else{this.getDomRef().removeChild(i);}this._$input.attr("aria-describedby",s);};j.prototype.setLocaleId=function(s){var C=this.getValue(),S=this._getSliders();this.setProperty("localeId",s,true);this._initMask();this._oDisplayFormat=null;this._sValueFormat=null;if(C){this.setValue(C);}if(S){S.setLocaleId(s);}return this;};j.prototype._getDefaultDisplayStyle=function(){return k.Medium;};j.prototype._getDefaultValueStyle=function(){return k.Medium;};j.prototype._getFormatterInstance=function(F,s,r,C,i){if(s===k.Short||s===k.Medium||s===k.Long){F=d.getTimeInstance({style:s,strictParsing:true,relative:r},new L(this.getLocaleId()));}else{F=d.getTimeInstance({pattern:s,strictParsing:true,relative:r},new L(this.getLocaleId()));}if(i){this._sUsedDisplayPattern=s;this._oDisplayFormat=F;}else{this._sUsedValuePattern=s;this._sValueFormat=F;}return F;};j.prototype._getFormat=function(){var F=this._getDisplayFormatPattern();if(!F){F=k.Medium;}if(Object.keys(k).indexOf(F)!==-1){F=p();}return F;};j.prototype.onsappageup=function(i){this._increaseTime(1,m.Hour);i.preventDefault();};j.prototype.onsappageupmodifiers=function(i){if(!(i.ctrlKey||i.metaKey||i.altKey)&&i.shiftKey){this._increaseTime(1,m.Minute);}if(!i.altKey&&i.shiftKey&&(i.ctrlKey||i.metaKey)){this._increaseTime(1,m.Second);}i.preventDefault();};j.prototype.onsappagedown=function(i){this._increaseTime(-1,m.Hour);i.preventDefault();};j.prototype.onsappagedownmodifiers=function(i){if(!(i.ctrlKey||i.metaKey||i.altKey)&&i.shiftKey){this._increaseTime(-1,m.Minute);}if(!i.altKey&&i.shiftKey&&(i.ctrlKey||i.metaKey)){this._increaseTime(-1,m.Second);}i.preventDefault();};j.prototype.onkeydown=function(i){var K=q.sap.KeyCodes,r=i.which||i.keyCode,A=i.altKey,s;if(r===K.F4||(A&&(r===K.ARROW_UP||r===K.ARROW_DOWN))){s=this._getPicker()&&this._getPicker().isOpen();if(!s){this._openPicker();}else{this._closePicker();}i.preventDefault();}else{b.onkeydown.call(this,i);}};j.prototype._getPicker=function(){return this.getAggregation("_picker");};j.prototype._removePickerEvents=function(){var i,r=this._getPicker();if(r){i=r.getAggregation("_popup");if(typeof this._oPopoverKeydownEventDelegate==='function'){i.removeEventDelegate(this._oPopoverKeydownEventDelegate);}}};j.prototype._openPicker=function(){var i=this._getPicker(),s;if(!i){i=this._createPicker(this._getDisplayFormatPattern());}i.open();s=this._getSliders();q.sap.delayedCall(0,s,s._updateSlidersValues);return i;};j.prototype._closePicker=function(){var i=this._getPicker();if(i){i.close();}else{q.sap.log.warning("There is no picker to close.");}return i;};j.prototype._createPicker=function(F){var t=this,i,r,s,O,C,u,v=this.getLocaleId();s=sap.ui.getCore().getLibraryResourceBundle("sap.m");O=s.getText("TIMEPICKER_SET");C=s.getText("TIMEPICKER_CANCEL");u=this.getTitle();r=new R(t.getId()+"-RP",{showCloseButton:false,showHeader:false,horizontalScrolling:false,verticalScrolling:false,placement:P.VerticalPreferedBottom,beginButton:new sap.m.Button({text:O,press:q.proxy(this._handleOkPress,this)}),endButton:new sap.m.Button({text:C,press:q.proxy(this._handleCancelPress,this)}),content:[new T(this.getId()+"-sliders",{support2400:this.getSupport2400(),displayFormat:F,valueFormat:this.getValueFormat(),labelText:u?u:"",localeId:v,minutesStep:this.getMinutesStep(),secondsStep:this.getSecondsStep()})._setShouldOpenSliderAfterRendering(true)],contentHeight:j._PICKER_CONTENT_HEIGHT});i=r.getAggregation("_popup");if(i.setShowArrow){i.setShowArrow(false);}i.oPopup.setAutoCloseAreas([this.getDomRef("icon")]);r.addStyleClass(this.getRenderer().CSS_CLASS+"DropDown").attachBeforeOpen(this.onBeforeOpen,this).attachAfterOpen(this.onAfterOpen,this).attachAfterClose(this.onAfterClose,this);r.open=function(){return this.openBy(t);};if(c.system.desktop){this._oPopoverKeydownEventDelegate={onkeydown:function(w){var K=q.sap.KeyCodes,x=w.which||w.keyCode,A=w.altKey;if((A&&(x===K.ARROW_UP||x===K.ARROW_DOWN))||x===K.F4){this._handleOkPress(w);this.focus();w.preventDefault();}}};i.addEventDelegate(this._oPopoverKeydownEventDelegate,this);i._afterAdjustPositionAndArrowHook=function(){t._getSliders()._onOrientationChanged();};}this.setAggregation("_picker",r,true);return r;};j.prototype._getSliders=function(){var i=this._getPicker();if(!i){return null;}return i.getContent()[0];};j.prototype._handleOkPress=function(i){var r=this._getSliders().getTimeValues(),v=this._formatValue(r);if(this.getSupport2400()){v=this._getSliders().getValue();}this.updateDomValue(v);this._handleInputChange();this._closePicker();};j.prototype._handleCancelPress=function(i){this._closePicker();};j.prototype._getLocaleBasedPattern=function(s){return e.getInstance(sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale()).getTimePattern(s);};j.prototype._parseValue=function(v,i){if(i){v=this._oTimeSemanticMaskHelper.stripValueOfLeadingSpaces(v);v=v.replace(this._rPlaceholderRegEx,'');}return D.prototype._parseValue.call(this,v,i);};j.prototype._formatValue=function(i,v){var V=D.prototype._formatValue.apply(this,arguments),F=this.getValueFormat(),r=F.indexOf("HH"),s=F.indexOf("H");if(i){if(!v&&this._oTimeSemanticMaskHelper){V=this._oTimeSemanticMaskHelper.formatValueWithLeadingTrailingSpaces(V);}}if(this.getSupport2400()&&T._isHoursValue24(this.getValue(),r,s)&&T._replaceZeroHoursWith24(V,r,s)===this.getValue()){V=this.getValue();}return V;};j.prototype._handleAriaOnExpandCollapse=function(){this.getFocusDomRef().setAttribute("aria-expanded",this._getPicker().isOpen());};j.prototype._increaseTime=function(N,u){var O=this.getDateValue(),i,r;if(O&&this.getEditable()&&this.getEnabled()){i=new Date(O.getTime());switch(u){case m.Hour:i.setHours(i.getHours()+N);r=60*60*1000;break;case m.Minute:i.setMinutes(i.getMinutes()+N);r=60*1000;break;case m.Second:r=1000;i.setSeconds(i.getSeconds()+N);}if(N<0&&i.getTime()-O.getTime()!==N*r){i=new Date(O.getTime()+N*r);}this.setDateValue(i);this.fireChangeEvent(this.getValue(),{valid:true});}};j.prototype._initMask=function(){if(this._oTimeSemanticMaskHelper){this._oTimeSemanticMaskHelper.destroy();}this._oTimeSemanticMaskHelper=new o(this);};j.prototype._isMaskEnabled=function(){return this.getMaskMode()===g.On;};j.prototype._shouldSetInitialFocusedDateValue=function(){if(!this._isValidValue()){return true;}return!this.getValue()&&!!this.getInitialFocusedDateValue();};j.prototype._isValidValue=function(){return this._bValid;};j.prototype.fireChangeEvent=function(v,i){if(v){v=v.trim();}if(v!==this._sLastChangeValue){this._sLastChangeValue=v;I.prototype.fireChangeEvent.call(this,v,i);}};var o=function(t){var s=t._getDisplayFormatPattern(),r,A,u=t.getLocaleId()||sap.ui.getCore().getConfiguration().getFormatLocale(),v=new L(u),i;if(t._checkStyle(s)){r=e.getInstance(v).getTimePattern(s);}else{r=s;}t.setProperty("localeId",u,true);this._oTimePicker=t;this.aOriginalAmPmValues=e.getInstance(v).getDayPeriods("abbreviated");this.aAmPmValues=this.aOriginalAmPmValues.slice(0);this.iAmPmValueMaxLength=Math.max(this.aAmPmValues[0].length,this.aAmPmValues[1].length);for(i=0;i<this.aAmPmValues.length;i++){while(this.aAmPmValues[i].length<this.iAmPmValueMaxLength){this.aAmPmValues[i]+=" ";}}this.b24H=s.indexOf("H")!==-1;this.bLeadingZero=s.indexOf("HH")!==-1||s.indexOf("hh")!==-1;this.sLeadingChar=this.bLeadingZero?"0":" ";this.sAlternativeLeadingChar=this.bLeadingZero?" ":"0";this.sLeadingRegexChar=this.bLeadingZero?"0":"\\s";t.setPlaceholderSymbol(n);r=r.replace(/hh/ig,"h").replace(/h/ig,"h9");if(this.b24H){A="["+this.sLeadingRegexChar+"012]";}else{A="["+this.sLeadingRegexChar+"1]";}this._maskRuleHours=new M({maskFormatSymbol:"h",regex:A});t.addRule(this._maskRuleHours);this.iHourNumber1Index=r.indexOf("h9");this.iHourNumber2Index=this.iHourNumber1Index!==-1?this.iHourNumber1Index+1:-1;this.iMinuteNumber1Index=r.indexOf("mm");r=r.replace(/mm/g,"59");this.iSecondNumber1Index=r.indexOf("ss");r=r.replace(/ss/g,"59");this._maskRuleMinSec=new M({maskFormatSymbol:"5",regex:"[0-5]"});t.addRule(this._maskRuleMinSec);this.aAllowedHours=F.call(this,this.b24H,this.sLeadingChar);this.aAllowedMinutesAndSeconds=G.call(this);this.iAmPmChar1Index=r.indexOf("a");this.iAfterAmPmValueIndex=-1;if(this.iAmPmChar1Index!==-1){this.iAfterAmPmValueIndex=this.iAmPmChar1Index+this.iAmPmValueMaxLength;var C=this.iAmPmValueMaxLength-"a".length;this.shiftIndexes(C);var w=65;var x="";var y="";var z="";for(i=0;i<this.iAmPmValueMaxLength;i++){y="[";if(this.aAmPmValues[0][i]){y+=this.aAmPmValues[0][i];}else{y+="\\s";}if(this.aAmPmValues[1][i]!==this.aAmPmValues[0][i]){if(this.aAmPmValues[1][i]){y+=this.aAmPmValues[1][i];}else{y+="\\s";}}y+="]";z=String.fromCharCode(w++);x+=z;this._maskRuleChars=new M({maskFormatSymbol:z,regex:y});t.addRule(this._maskRuleChars);}r=r.replace(/a/g,x);}t.setMask(r);function B(S,H,J){var K=[],N,i;for(i=S;i<=H;i++){N=i.toString();if(i<10){N=J+N;}K.push(N);}return K;}function F(H,J){var S=H?0:1,K=this._oTimePicker.getSupport2400()?24:23,N=H?K:12;return B(S,N,J);}function G(){return B(0,59,"0");}};o.prototype.replaceChar=function(C,r,s){var A=r-this.iAmPmChar1Index,t,u,v,S,w,x,i;if(r===this.iHourNumber1Index&&this.sAlternativeLeadingChar===C){if(this.aAllowedHours.indexOf(this.sLeadingChar+C)!==-1){return this.sLeadingChar+C;}else{return this.sLeadingChar;}}else if(r===this.iHourNumber1Index&&!this._oTimePicker._isCharAllowed(C,r)&&this.aAllowedHours.indexOf(this.sLeadingChar+C)!==-1){return this.sLeadingChar+C;}else if(r===this.iHourNumber2Index&&this.aAllowedHours.indexOf(s[this.iHourNumber1Index]+C)===-1){return"";}else if((r===this.iMinuteNumber1Index||r===this.iSecondNumber1Index)&&!this._oTimePicker._isCharAllowed(C,r)&&this.aAllowedMinutesAndSeconds.indexOf("0"+C)!==-1){return"0"+C;}else if(A>=0&&r<this.iAfterAmPmValueIndex){t=s.slice(this.iAmPmChar1Index,r);u=this.aAmPmValues[0].slice(0,A);v=this.aAmPmValues[1].slice(0,A);w=this.aAmPmValues[0].slice(A,this.iAfterAmPmValueIndex);x=this.aAmPmValues[1].slice(A,this.iAfterAmPmValueIndex);S=(u===v);var y="";for(i=A;i<this.iAmPmValueMaxLength;i++){if(this.aAmPmValues[0][i]===this.aAmPmValues[1][i]){y+=this.aAmPmValues[0][i];}else{break;}}if(i===this.iAmPmValueMaxLength||i!==A){return y;}else{if(!S){if(t===u){return w;}else if(t===v){return x;}else{return C;}}else{if(this.aAmPmValues[0][A].toLowerCase()===C.toLowerCase()&&this.aAmPmValues[0]===t+w){return w;}else if(this.aAmPmValues[1][A].toLowerCase()===C.toLowerCase()&&this.aAmPmValues[1]===t+x){return x;}else{return C;}}}}else{return C;}};o.prototype.formatValueWithLeadingTrailingSpaces=function(v){var i=this._oTimePicker.getMask().length;if(this.aOriginalAmPmValues[0]!==this.aAmPmValues[0]){v=v.replace(this.aOriginalAmPmValues[0],this.aAmPmValues[0]);}if(this.aOriginalAmPmValues[1]!==this.aAmPmValues[1]){v=v.replace(this.aOriginalAmPmValues[1],this.aAmPmValues[1]);}while(i>v.length){v=[v.slice(0,this.iHourNumber1Index)," ",v.slice(this.iHourNumber1Index)].join('');}return v;};o.prototype.stripValueOfLeadingSpaces=function(v){if(v[this.iHourNumber1Index]===" "){v=[v.slice(0,this.iHourNumber1Index),v.slice(this.iHourNumber1Index+1)].join('');}return v;};o.prototype.shiftIndexes=function(s){if(this.iAmPmChar1Index<this.iHourNumber1Index){this.iHourNumber1Index+=s;this.iHourNumber2Index+=s;}if(this.iAmPmChar1Index<this.iMinuteNumber1Index){this.iMinuteNumber1Index+=s;}if(this.iAmPmChar1Index<this.iSecondNumber1Index){this.iSecondNumber1Index+=s;}};o.prototype.destroy=function(){if(this._maskRuleHours){this._maskRuleHours.destroy();this._maskRuleHours=null;}if(this._maskRuleMinSec){this._maskRuleMinSec.destroy();this._maskRuleMinSec=null;}if(this._maskRuleChars){this._maskRuleChars.destroy();this._maskRuleChars=null;}};j.prototype._feedReplaceChar=function(C,i,s){return this._oTimeSemanticMaskHelper.replaceChar(C,i,s);};j.prototype.getAccessibilityInfo=function(){var r=this.getRenderer();var i=I.prototype.getAccessibilityInfo.apply(this,arguments);var v=this.getValue()||"";if(this._bValid){var s=this.getDateValue();if(s){v=this._formatValue(s);}}q.extend(true,i,{role:r.getAriaRole(this),type:sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TIMEINPUT"),description:[v,r.getLabelledByAnnouncement(this),r.getDescribedByAnnouncement(this)].join(" ").trim(),multiline:false,autocomplete:"none",expanded:false,haspopup:true,owns:this.getId()+"-sliders"});return i;};function p(){var i=sap.ui.getCore().getConfiguration().getFormatSettings().getFormatLocale(),r=e.getInstance(i);return r.getTimePattern(k.Medium);}j._PICKER_CONTENT_HEIGHT="25rem";return j;});
