/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./ListBase','./library','sap/ui/model/ClientTreeBindingAdapter','sap/ui/model/TreeBindingCompatibilityAdapter','./TreeRenderer'],function(q,L,l,C,T,a){"use strict";var b=L.extend("sap.m.Tree",{metadata:{library:"sap.m",events:{toggleOpenState:{parameters:{itemIndex:{type:"int"},itemContext:{type:"object"},expanded:{type:"boolean"}}}}}});b.prototype.isTreeBinding=function(n){return(n=="items");};b.prototype.getBinding=function(n){n=n||"items";var B=L.prototype.getBinding.call(this,n);if(B&&n==="items"&&!B.getLength){if(B.isA("sap.ui.model.odata.v2.ODataTreeBinding")){B.applyAdapterInterface();}else if(B.isA("sap.ui.model.ClientTreeBinding")){C.apply(B);}else if(B.isA("sap.ui.model.odata.ODataTreeBinding")){T(B,this);}else{q.sap.log.error("TreeBinding is not supported for the "+this);}}return B;};b.prototype.updateAggregation=function(n){if(n!="items"){return L.prototype.updateAggregation.apply(this,arguments);}var B=this.getBindingInfo("items"),o=this.getBinding("items"),f=B.factory,c;function u(d,c){var e=d.getItems()||[],g,h;if(e.length>c.length){for(var i=c.length;i<e.length;i++){d.removeItem(e[i]);e[i].destroy("KeepDom");}}for(var i=0;i<c.length;i++){g=c[i];h=e[i];if(h){h.setBindingContext(g,B.model);}else{h=f(d.getId()+"-"+i,g);h.setBindingContext(g,B.model);d.addItem(h);}}}c=o.getContexts(0);if(!B.template){this.destroyItems();}u(this,c);};b.prototype.validateAggregation=function(A,o,m){var r=L.prototype.validateAggregation.apply(this,arguments);if(A==="items"&&!o.isA("sap.m.TreeItemBase")){throw new Error(o+" is not a valid items aggregation of "+this+". Items aggregation in Tree control only supports TreeItemBase-based objects, e.g. StandardTreeItem.");}return r;};b.prototype.onItemExpanderPressed=function(i,e){var I=this.indexOfItem(i);var B=this.getBindingInfo("items");var o=i&&i.getBindingContext(B.model);if(B&&o){var E=i.getExpanded();var c;if(e==undefined){this.getBinding("items").toggleIndex(I);}else if(e){this.getBinding("items").expand(I);}else{this.getBinding("items").collapse(I);}c=i.getExpanded();if(c&&(i.getLevel()+1>this.getDeepestLevel())){this._iDeepestLevel=i.getLevel()+1;}if(E!==c&&!i.isLeaf()){this.fireToggleOpenState({itemIndex:I,itemContext:o,expanded:c});}}};b.prototype.setGrowing=function(){q.sap.log.error("Growing feature of "+this+" is not supported!");return this;};b.prototype.setGrowingThreshold=function(){q.sap.log.error("GrowingThreshold of "+this+" is not supported!");return this;};b.prototype.setGrowingTriggerText=function(){q.sap.log.error("GrowingTriggerText of "+this+" is not supported!");return this;};b.prototype.setGrowingScrollToLoad=function(){q.sap.log.error("GrowingScrollToLoad of "+this+" is not supported!");return this;};b.prototype.setGrowingDirection=function(){q.sap.log.error("GrowingDirection of "+this+" is not supported!");return this;};b.prototype.expandToLevel=function(i){var B=this.getBinding("items");if(B&&B.expandToLevel&&B.getNumberOfExpandedLevels){if(B.getNumberOfExpandedLevels()>i){B.collapseToLevel(0);}B.expandToLevel(i);}return this;};b.prototype.getNumberOfExpandedLevel=function(){return this.getBinding("items").getNumberOfExpandedLevels();};b.prototype.getDeepestLevel=function(){if(this._iDeepestLevel===undefined){this._iDeepestLevel=this.getNumberOfExpandedLevel();}return this._iDeepestLevel;};b.prototype.collapseAll=function(){var B=this.getBinding("items");if(B){B.collapseToLevel(0);}return this;};b.prototype._sortHelper=function(p){var i=[];if(typeof p==="number"){i.push(p);}else if(Array.isArray(p)){i=p.sort().reverse();}return i;};b.prototype._removeLeaf=function(s){var I=null,c,d=[];for(var i=0;i<s.length;i++){c=s[i];I=this.getItems()[c];if(I&&!I.isLeaf()){d.push(c);}}return d;};b.prototype._preExpand=function(p){var i=this._sortHelper(p);i=this._removeLeaf(i);return i;};b.prototype.expand=function(p){var B=this.getBinding("items");if(B&&B.expand){var I=this._preExpand(p);for(var i=0;i<I.length-1;i++){B.expand(I[i],true);}B.expand(I[I.length-1],false);}return this;};b.prototype.collapse=function(p){var B=this.getBinding("items");if(B&&B.collapse){var I=this._preExpand(p);for(var i=0;i<I.length-1;i++){B.collapse(I[i],true);}B.collapse(I[I.length-1],false);}return this;};b.prototype.getAccessibilityType=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.m").getText("ACC_CTR_TYPE_TREE");};b.prototype.getAccessbilityPosition=function(i){var s,p,n=i.getItemNodeContext();if(n.parent){s=n.parent.children.length;}if(n.positionInParent){p=n.positionInParent+1;}return{setSize:s,posInset:p};};b.prototype.onItemLongDragOver=function(i){var I=this.indexOfItem(i);this.getBinding("items").expand(I);};b.prototype.isGrouped=function(){return false;};return b;});
