/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./BindingParser','./DataType','./EventProvider','./ManagedObjectMetadata','./Object','../model/BindingMode','../model/CompositeBinding','../model/Context','../model/FormatException','../model/ParseException','../model/Type','../model/ValidateException','jquery.sap.act','jquery.sap.script','jquery.sap.strings'],function(q,B,D,E,M,d,e,C,f,F,P,T,V){"use strict";var I;var g=E.extend("sap.ui.base.ManagedObject",{metadata:{"abstract":true,publicMethods:["getId","getMetadata","getModel","setModel","hasModel","bindProperty","unbindProperty","bindAggregation","unbindAggregation","bindObject","unbindObject","getObjectBinding"],library:"sap.ui.core",properties:{},aggregations:{},associations:{},events:{"validationSuccess":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"validationError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"parseError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'},message:{type:'string'}}},"formatError":{enableEventBubbling:true,parameters:{element:{type:'sap.ui.base.ManagedObject'},property:{type:'string'},type:{type:'sap.ui.model.Type'},newValue:{type:'any'},oldValue:{type:'any'}}},"modelContextChange":{}},specialSettings:{id:'sap.ui.core.ID',models:'object',bindingContexts:'object',objectBindings:'object',metadataContexts:'object',Type:{type:'string',visibility:'hidden'}}},constructor:function(i,s,o){var t=this;E.call(this);if(typeof i!=='string'&&i!==undefined){o=s;s=i;i=s&&s.id;}if(!i){i=this.getMetadata().uid();}else{var p=g._fnIdPreprocessor;i=(p?p.call(this,i):i);var a=I||(I=D.getType("sap.ui.core.ID"));if(!a.isValid(i)){throw new Error("\""+i+"\" is not a valid ID.");}}this.sId=i;this.mProperties=this.getMetadata().createPropertyBag();this.mAggregations={};this.mAssociations={};this.oParent=null;this.aDelegates=[];this.aBeforeDelegates=[];this.iSuppressInvalidate=0;this.oPropagatedProperties=g._oEmptyPropagatedProperties;this.mSkipPropagation={};this.oModels={};this.aPropagationListeners=[];this.oBindingContexts={};this.mElementBindingContexts={};this.mBindingInfos={};this.mObjectBindingInfos={};this._oContextualSettings=g._defaultContextualSettings;this._sOwnerId=g._sOwnerId;(function(){var c=false;if(t.register){t.register();}try{if(t._initCompositeSupport){t._initCompositeSupport(s);}if(t.init){t.init();}t.applySettings(s,o);c=true;}finally{if(!c&&t.deregister){t.deregister();}}}());}},M);g.create=function(v,K,s){if(!v||v instanceof g||typeof v!=="object"||v instanceof String){return v;}function a(t){if(typeof t==="function"){return t;}if(typeof t==="string"){return q.sap.getObject(t);}}var c=a(v.Type)||a(K&&K.type);if(typeof c==="function"){return new c(v,s);}var m="Don't know how to create a ManagedObject from "+v+" ("+(typeof v)+")";q.sap.log.fatal(m);throw new Error(m);};var S;function h(i){if(!S){S=sap.ui.require("sap/ui/core/StashedControlSupport");}if(S){return S.getStashedControls(i);}return[];}g._fnIdPreprocessor=null;g._fnSettingsPreprocessor=null;g.runWithPreprocessors=function(a,p,t){var o={id:this._fnIdPreprocessor,settings:this._fnSettingsPreprocessor};p=p||{};this._fnIdPreprocessor=p.id;this._fnSettingsPreprocessor=p.settings;try{return a.call(t);}finally{this._fnIdPreprocessor=o.id;this._fnSettingsPreprocessor=o.settings;}};g.prototype.applySettings=function(s,o){if(!s||q.isEmptyObject(s)){return this;}var t=this,m=this.getMetadata(),v=m.getJSONKeys(),a=g.create,p=g._fnSettingsPreprocessor,K,b,c;function n(O){for(var i=0,u=O.length;i<u;i++){var w=O[i];if(Array.isArray(w)){n(w);}else{t[c._sMutator](a(w,c,o));}}}p&&p.call(this,s);if(s.metadataContexts&&this._processMetadataContexts){this._processMetadataContexts(s.metadataContexts,s);}if(s.models){if(typeof s.models!=="object"){throw new Error("models must be a simple object");}if(d.isA(s.models,"sap.ui.model.Model")){this.setModel(s.models);}else{for(K in s.models){this.setModel(s.models[K],K==="undefined"?undefined:K);}}}if(s.bindingContexts){if(typeof s.bindingContexts!=="object"){throw new Error("bindingContexts must be a simple object");}if(s.bindingContexts instanceof f){this.setBindingContext(s.bindingContexts);}else{for(K in s.bindingContexts){this.setBindingContext(s.bindingContexts[K],K==="undefined"?undefined:K);}}}if(s.objectBindings){if(typeof s.objectBindings!=="string"&&typeof s.objectBindings!=="object"){throw new Error("binding must be a string or simple object");}if(typeof s.objectBindings==="string"||s.objectBindings.path){this.bindObject(s.objectBindings);}else{for(var K in s.objectBindings){s.objectBindings.model=K;this.bindObject(s.objectBindings[K]);}}}for(K in s){b=s[K];if((c=v[K])!==undefined){var r;switch(c._iKind){case 0:r=this.extractBindingInfo(b,o);if(r&&typeof r==="object"){this.bindProperty(K,r);}else{this[c._sMutator](r||b);}break;case 1:r=c.altTypes&&this.extractBindingInfo(b,o);if(r&&typeof r==="object"){this.bindProperty(K,r);}else{if(Array.isArray(b)){if(b.length>1){q.sap.log.error("Tried to add an array of controls to a single aggregation");}b=b[0];}this[c._sMutator](a(r||b,c,o));}break;case 2:r=this.extractBindingInfo(b,o);if(r&&typeof r==="object"){this.bindAggregation(K,r);}else{b=r||b;if(b){if(Array.isArray(b)){n(b);}else{t[c._sMutator](a(b,c,o));}}}break;case 3:this[c._sMutator](b);break;case 4:if(b){if(Array.isArray(b)){for(var i=0,l=b.length;i<l;i++){this[c._sMutator](b[i]);}}else{this[c._sMutator](b);}}break;case 5:if(typeof b=="function"){this[c._sMutator](b);}else{this[c._sMutator](b[0],b[1],b[2]);}break;case-1:default:break;}}else{}}return this;};g.escapeSettingsValue=function(v){return(typeof v==="string")?g.bindingParser.escape(v):v;};g.prototype.toString=function(){return"ManagedObject "+this.getMetadata().getName()+"#"+this.getId();};g.prototype.getId=function(){return this.sId;};g.prototype.setProperty=function(p,v,s){var o=this.mProperties[p];v=this.validateProperty(p,v);if(q.sap.equal(o,v)){this.mProperties[p]=v;return this;}if(s){q.sap.act.refresh();this.iSuppressInvalidate++;}this.mProperties[p]=v;if(!this.isInvalidateSuppressed()){this.invalidate();}this.updateModelProperty(p,v,o);if(this.mEventRegistry["_change"]){E.prototype.fireEvent.call(this,"_change",{"id":this.getId(),"name":p,"oldValue":o,"newValue":v});}if(this._observer){this._observer.propertyChange(this,p,o,v);}if(s){this.iSuppressInvalidate--;}return this;};g.prototype.getProperty=function(p){var v=this.mProperties[p],o=this.getMetadata().getProperty(p),t;if(!o){throw new Error("Property \""+p+"\" does not exist in "+this);}t=D.getType(o.type);if(t instanceof D&&t.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v instanceof String){v=v.valueOf();}return v;};g.prototype.validateProperty=function(p,v){var o=this.getMetadata().getProperty(p),t;if(!o){throw new Error("Property \""+p+"\" does not exist in "+this);}t=D.getType(o.type);if(t instanceof D&&t.isArrayType()&&Array.isArray(v)){v=v.slice(0);}if(v==null){v=o.getDefaultValue();}else if(t instanceof D){if(t.getName()=="string"){if(!(typeof v=="string"||v instanceof String)){v=""+v;}}else if(t.getName()=="string[]"){if(typeof v=="string"){v=[v];}if(!Array.isArray(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected string[]"+" for property \""+p+"\" of "+this);}for(var i=0;i<v.length;i++){if(typeof v[i]!=="string"){v[i]=""+v[i];}}}else if(!t.isValid(v)){throw new Error("\""+v+"\" is of type "+typeof v+", expected "+t.getName()+" for property \""+p+"\" of "+this);}}if(t&&t.normalize&&typeof t.normalize==="function"){v=t.normalize(v);}return v;};g.prototype.isPropertyInitial=function(p){return!Object.prototype.hasOwnProperty.call(this.mProperties,p)&&!this.isBound(p);};g.prototype.resetProperty=function(p){if(this.mProperties.hasOwnProperty(p)){var o=this.getMetadata().getProperty(p);this[o._sMutator](null);if(this.mProperties[p]===o.getDefaultValue()){delete this.mProperties[p];}}return this;};g.prototype.getOriginInfo=function(p){var v=this.mProperties[p];if(!(v instanceof String&&v.originInfo)){return null;}return v.originInfo;};g.prototype.setAssociation=function(a,i,s){if(i instanceof g){i=i.getId();}else if(i!=null&&typeof i!=="string"){return this;}if(this.mAssociations[a]===i){return this;}if(s){this.iSuppressInvalidate++;}if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"remove",this.mAssociations[a]);}this.mAssociations[a]=i;if(this._observer&&this.mAssociations[a]!=null){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};g.prototype.getAssociation=function(a,o){var r=this.mAssociations[a];if(!r){r=this.mAssociations[a]=o||null;}else{if(typeof r.length==='number'&&!(r.propertyIsEnumerable('length'))){return r.slice();}return r;}return r;};g.prototype.addAssociation=function(a,i,s){if(i instanceof g){i=i.getId();}else if(typeof i!=="string"){return this;}if(s){this.iSuppressInvalidate++;}var b=this.mAssociations[a];if(!b){b=this.mAssociations[a]=[i];}else{b.push(i);}if(this._observer){this._observer.associationChange(this,a,"insert",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};g.prototype.removeAssociation=function(a,o,s){var b=this.mAssociations[a];var c=null;if(!b){return null;}if(s){this.iSuppressInvalidate++;}if(typeof(o)=="object"&&o.getId){o=o.getId();}if(typeof(o)=="string"){for(var i=0;i<b.length;i++){if(b[i]==o){o=i;break;}}}if(typeof(o)=="number"){if(o<0||o>=b.length){q.sap.log.warning("ManagedObject.removeAssociation called with invalid index: "+a+", "+o);}else{c=b[o];b.splice(o,1);if(this._observer){this._observer.associationChange(this,a,"remove",c);}if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(s){this.iSuppressInvalidate--;}return c;};g.prototype.removeAllAssociation=function(a,s){var i=this.mAssociations[a];if(!i){return[];}if(s){this.iSuppressInvalidate++;}delete this.mAssociations[a];if(this._observer){this._observer.associationChange(this,a,"remove",i);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return i;};g.prototype.validateAggregation=function(a,o,m,O){var b=this.getMetadata(),A=b.getManagedAggregation(a),c,t,i,l;if(!A){throw new Error("Aggregation \""+a+"\" does not exist in "+this);}if(A.multiple!==m){throw new Error("Aggregation '"+a+"' of "+this+" used with wrong cardinality (declared as "+(A.multiple?"0..n":"0..1")+")");}var n=b.getAggregationForwarder(a);if(n&&!O){n.getTarget(this).validateAggregation(n.targetAggregationName,o,m);}if(!A.multiple&&!o){return o;}if(o instanceof d&&o.isA(A.type)){return o;}c=A.altTypes;if(c&&c.length){if(o==null){return o;}for(i=0;i<c.length;i++){t=D.getType(c[i]);if(t instanceof D){if(t.isValid(o)){return o;}}}}t=q.sap.getObject(A.type);if(typeof t==="function"&&o instanceof t){return o;}l="\""+o+"\" is not valid for aggregation \""+a+"\" of "+this;if(D.isInterfaceType(A.type)){return o;}else{throw new Error(l);}};g.prototype.setAggregation=function(a,o,s){var b=this.getMetadata().getAggregationForwarder(a);if(b){o=this.validateAggregation(a,o,false,true);return b.set(this,o);}var O=this.mAggregations[a];if(O===o){return this;}o=this.validateAggregation(a,o,false);if(s){this.iSuppressInvalidate++;}this.mAggregations[a]=null;if(O instanceof g){O.setParent(null);}else{if(this._observer!=null&&O!=null){this._observer.aggregationChange(this,a,"remove",O);}}this.mAggregations[a]=o;if(o instanceof g){o.setParent(this,a,s);}else{if(!this.isInvalidateSuppressed()){this.invalidate();}if(this._observer!=null&&o!=null){this._observer.aggregationChange(this,a,"insert",o);}}if(s){this.iSuppressInvalidate--;}return this;};g.prototype.getAggregation=function(a,o){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.get(this);}var c=this.mAggregations[a];if(!c){c=this.mAggregations[a]=o||null;}if(c){if(typeof c.length==='number'&&!(c.propertyIsEnumerable('length'))){return c.slice();}return c;}else{return null;}};g.prototype.indexOfAggregation=function(a,o){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.indexOf(this,o);}var c=this.mAggregations[a];if(c){if(c.length==undefined){return-2;}for(var i=0;i<c.length;i++){if(c[i]==o){return i;}}}return-1;};g.prototype.insertAggregation=function(a,o,b,s){if(!o){return this;}o=this.validateAggregation(a,o,true,true);var c=this.getMetadata().getAggregationForwarder(a);if(c){return c.insert(this,o,b);}var l=this.mAggregations[a]||(this.mAggregations[a]=[]);var i;if(b<0){i=0;}else if(b>l.length){i=l.length;}else{i=b;}if(i!==b){q.sap.log.warning("ManagedObject.insertAggregation: index '"+b+"' out of range [0,"+l.length+"], forced to "+i);}l.splice(i,0,o);o.setParent(this,a,s);return this;};g.prototype.addAggregation=function(a,o,s){if(!o){return this;}o=this.validateAggregation(a,o,true,true);var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.add(this,o);}var c=this.mAggregations[a];if(!c){c=this.mAggregations[a]=[o];}else{c.push(o);}o.setParent(this,a,s);return this;};g.prototype.removeAggregation=function(a,o,s){var b=this.getMetadata().getAggregationForwarder(a);if(b){return b.remove(this,o);}var c=this.mAggregations[a],l=null,i;if(!c){return null;}if(s){this.iSuppressInvalidate++;}if(typeof(o)=="string"){for(i=0;i<c.length;i++){if(c[i]&&c[i].getId()===o){o=i;break;}}}if(typeof(o)=="object"){for(i=0;i<c.length;i++){if(c[i]==o){o=i;break;}}}if(typeof(o)=="number"){if(o<0||o>=c.length){q.sap.log.warning("ManagedObject.removeAggregation called with invalid index: "+a+", "+o);}else{l=c[o];c.splice(o,1);l.setParent(null);if(!this.isInvalidateSuppressed()){this.invalidate();}}}if(s){this.iSuppressInvalidate--;}return l;};g.prototype.removeAllAggregation=function(a,s){var o=this.getMetadata().getAggregationForwarder(a);if(o){return o.removeAll(this);}var c=this.mAggregations[a];if(!c){return[];}if(s){this.iSuppressInvalidate++;}delete this.mAggregations[a];for(var i=0;i<c.length;i++){c[i].setParent(null);}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return c;};g.prototype.destroyAggregation=function(a,s){var o=this.getMetadata().getAggregationForwarder(a);if(o){return o.destroy(this);}var b=this.mAggregations[a],i,l;h(this.getId()).forEach(function(c){if(c.sParentAggregationName===a){c.destroy();}});if(!b){return this;}if(s){this.iSuppressInvalidate++;}delete this.mAggregations[a];if(b instanceof g){b.destroy(s);if(this._observer){this._observer.aggregationChange(this,a,"remove",b);}}else if(Array.isArray(b)){for(i=b.length-1;i>=0;i--){l=b[i];if(l){l.destroy(s);if(this._observer){this._observer.aggregationChange(this,a,"remove",l);}}}}if(!this.isInvalidateSuppressed()){this.invalidate();}if(s){this.iSuppressInvalidate--;}return this;};g.prototype.invalidate=function(){if(this.oParent){this.oParent.invalidate(this);}};g.prototype.isInvalidateSuppressed=function(){var i=this.iSuppressInvalidate>0;if(this.oParent&&this.oParent instanceof g){i=i||this.oParent.isInvalidateSuppressed();}return i;};g.prototype._removeChild=function(c,a,s){if(!a){q.sap.log.error("Cannot remove aggregated child without aggregation name.",null,this);}else{if(s){this.iSuppressInvalidate++;}var i=this.indexOfAggregation(a,c);var A=this.getMetadata().getAggregation(a);if(i==-2){if(A&&this[A._sMutator]){this[A._sMutator](null);}else{this.setAggregation(a,null,s);}}else if(i>-1){if(A&&this[A._sRemoveMutator]){this[A._sRemoveMutator](i);}else{this.removeAggregation(a,i,s);}}if(s){this.iSuppressInvalidate--;}}};function j(a,b){while(a&&a!==b){a=a.oParent;}return!!a;}g.prototype.setParent=function(p,a,s){if(!p){if(this.oParent){if(this.oParent._observer){this.oParent._observer.aggregationChange(this.oParent,this.sParentAggregationName,"remove",this);}}this.oParent=null;this.sParentAggregationName=null;var o=g._oEmptyPropagatedProperties;if(o!==this.oPropagatedProperties){this.oPropagatedProperties=o;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oParent){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);this.fireModelContextChange();}}.bind(this),0);}}this._oContextualSettings=g._defaultContextualSettings;if(!this._bIsBeingDestroyed){setTimeout(function(){if(!this.oParent){this._propagateContextualSettings();}}.bind(this),0);}q.sap.act.refresh();return;}if(j(p,this)){throw new Error("Cycle detected: new parent '"+p+"' is already a descendant of (or equal to) '"+this+"'");}if(s){q.sap.act.refresh();this.iSuppressInvalidate++;}var O=this.getParent();if(O){O._removeChild(this,this.sParentAggregationName);if(this.aAPIParentInfos&&this.aAPIParentInfos.length){var b=this.aAPIParentInfos[this.aAPIParentInfos.length-1];if(b&&!j(p,b.parent)){delete this.aAPIParentInfos;}}}this.oParent=p;this.sParentAggregationName=a;var o=p._getPropertiesToPropagate();if(o!==this.oPropagatedProperties){this.oPropagatedProperties=o;if(this.hasModel()){this.updateBindings(true,null);this.updateBindingContext(false,undefined,true);this.propagateProperties(true);}this._callPropagationListener();this.fireModelContextChange();}this._applyContextualSettings(p._oContextualSettings);if(p&&!this.isInvalidateSuppressed()){p.invalidate(this);}if(s){this.iSuppressInvalidate--;}if(p._observer){p._observer.aggregationChange(p,a,"insert",this);}return this;};g.prototype._applyContextualSettings=function(c){if(this._oContextualSettings!==c){this._oContextualSettings=c;this._propagateContextualSettings();this._onContextualSettingsChanged();}};g.prototype._onContextualSettingsChanged=function(){};g.prototype._propagateContextualSettings=function(){var s=this._oContextualSettings,a,A,i;for(a in this.mAggregations){A=this.mAggregations[a];if(A instanceof g){A._applyContextualSettings(s);}else if(A instanceof Array){for(i=0;i<A.length;i++){if(A[i]instanceof g){A[i]._applyContextualSettings(s);}}}}};g.prototype._getContextualSettings=function(){return this._oContextualSettings;};g.prototype.getParent=function(){return this.oParent;};g.prototype.destroy=function(s){if(this.bIsDestroyed){return;}var t=this;this._bIsBeingDestroyed=true;if(s){this.iSuppressInvalidate++;}if(this.exit){this.exit();}if(this._exitCompositeSupport){this._exitCompositeSupport();}for(var a in this.mAggregations){this.destroyAggregation(a,s);}h(this.getId()).forEach(function(c){c.destroy();});if(this.deregister){this.deregister();}if(this.oParent&&this.sParentAggregationName){this.oParent._removeChild(this,this.sParentAggregationName,s);}delete this.oParent;q.each(this.mBindingInfos,function(n,b){if(b.factory){t.unbindAggregation(n,true);}else{t.unbindProperty(n,true);}});q.each(this.mObjectBindingInfos,function(n,b){t.unbindObject(n,true);});if(s){this.iSuppressInvalidate--;}if(this._observer){this._observer.objectDestroyed(this);}if(this.aAPIParentInfos){this.aAPIParentInfos=null;}E.prototype.destroy.apply(this,arguments);this.setParent=function(){throw Error("The object with ID "+t.getId()+" was destroyed and cannot be used anymore.");};this.bIsDestroyed=true;};g.bindingParser=B.simpleParser;g.prototype.isBinding=function(v,K){return typeof this.extractBindingInfo(v)==="object";};g.prototype.extractBindingInfo=function(v,s){if(v&&typeof v==="object"){if(v.ui5object){delete v.ui5object;}else if(v.path!=undefined||v.parts){if(v.template){v.template=g.create(v.template);}return v;}}if(typeof v==="string"){return g.bindingParser(v,s,true);}};g.prototype.getBindingInfo=function(n){var o=this.getMetadata().getAggregationForwarder(n);if(o&&o.forwardBinding){return o.getTarget(this).getBindingInfo(o.targetAggregationName);}return this.mBindingInfos[n];};g.prototype.bindObject=function(b){var m,p,s;if(typeof b=="string"){p=b;b={path:p,parameters:arguments[1]};}else{p=b.path;}s=p.indexOf(">");if(s>0){b.model=p.substr(0,s);b.path=p.substr(s+1);}m=b.model;if(this.mObjectBindingInfos[m]){this.unbindObject(m,true);}this.mObjectBindingInfos[m]=b;if(this.getModel(m)){this._bindObject(b);}return this;};g.prototype._bindObject=function(b){var o,c,m,a,t=this;var i=function(n){t.setElementBindingContext(o.getBoundContext(),m);};var l=function(n){var p=o.getDataState();if(!p){return;}if(t.refreshDataState){t.refreshDataState('',p);}};m=b.model;a=this.getModel(m);c=this.getBindingContext(m);o=a.bindContext(b.path,c,b.parameters);if(b.suspended){o.suspend(true);}o.attachChange(i);b.binding=o;b.modelChangeHandler=i;b.dataStateChangeHandler=l;o.attachEvents(b.events);if(this.refreshDataState){o.attachAggregatedDataStateChange(l);}o.initialize();};g.prototype.bindContext=function(p){return this.bindObject(p);};g.prototype.unbindContext=function(m){return this.unbindObject(m);};g.prototype.unbindObject=function(m,_){var b=this.mObjectBindingInfos[m];if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);b.binding.detachEvents(b.events);if(this.refreshDataState){b.binding.detachAggregatedDataStateChange(b.dataStateChangeHandler);}b.binding.destroy();}delete this.mObjectBindingInfos[m];delete this.mElementBindingContexts[m];if(!_){this.updateBindingContext(false,m);this.propagateProperties(m);this.fireModelContextChange();}}return this;};g.prototype.bindProperty=function(n,b,_,a){var s,A=true,p=this.getMetadata().getPropertyLikeSetting(n);if(!p){throw new Error("Property \""+n+"\" does not exist in "+this);}if(typeof b=="string"){b={parts:[{path:b,type:_ instanceof T?_:undefined,mode:a}],formatter:typeof _==='function'?_:undefined};}if(!b.parts){b.parts=[];b.parts[0]={path:b.path,targetType:b.targetType,type:b.type,suspended:b.suspended,formatOptions:b.formatOptions,constraints:b.constraints,model:b.model,mode:b.mode};delete b.path;delete b.targetType;delete b.mode;delete b.model;}for(var i=0;i<b.parts.length;i++){var o=b.parts[i];if(typeof o=="string"){o={path:o};b.parts[i]=o;}s=o.path.indexOf(">");if(s>0){o.model=o.path.substr(0,s);o.path=o.path.substr(s+1);}if(b.formatter&&o.mode!=e.OneWay&&o.mode!=e.OneTime){o.mode=e.OneWay;}if(!this.getModel(o.model)){A=false;}}if(this.isBound(n)){this.unbindProperty(n,true);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"property");}if(A){this._bindProperty(n,b);}return this;};g.prototype._bindProperty=function(n,b){var m,c,o,s,a=e.TwoWay,t,i,p=this.getMetadata().getPropertyLikeSetting(n),l=p._iKind===0?p.type:p.altTypes[0],r=this,u=[],v=function(x){r.updateProperty(n);var y=o.getDataState();if(y){var z=y.getControlMessages();if(z&&z.length>0){var A=sap.ui.getCore().getMessageManager();y.setControlMessages([]);if(z){A.removeMessages(z);}}y.setInvalidValue(undefined);}if(o.getBindingMode()===e.OneTime&&o.isResolved()){o.detachChange(v);o.detachEvents(b.events);if(this.refreshDataState){o.detachAggregatedDataStateChange(w);}o.destroy();}},w=function(){var x=o.getDataState();if(!x){return;}if(r.refreshDataState){r.refreshDataState(n,x);}};b.parts.forEach(function(x){c=r.getBindingContext(x.model);m=r.getModel(x.model);t=x.type;if(typeof t=="string"){i=q.sap.getObject(t);if(typeof i!=="function"){throw new Error("Cannot find type \""+t+"\" used in control \""+r.getId()+"\"!");}t=new i(x.formatOptions,x.constraints);}o=m.bindProperty(x.path,c,b.parameters);o.setType(t,x.targetType||l);o.setFormatter(x.formatter);if(x.suspended){o.suspend(true);}s=x.mode||m.getDefaultBindingMode();o.setBindingMode(s);if(s!=e.TwoWay){a=e.OneWay;}u.push(o);});if(u.length>1||(b.formatter&&b.formatter.textFragments)){t=b.type;if(typeof t=="string"){i=q.sap.getObject(t);t=new i(b.formatOptions,b.constraints);}o=new C(u,b.useRawValues,b.useInternalValues);o.setType(t,b.targetType||l);o.setBindingMode(b.mode||a);}else{o=u[0];}o.attachChange(v);if(this.refreshDataState){o.attachAggregatedDataStateChange(w);}o.setFormatter(q.proxy(b.formatter,this));b.binding=o;b.modelChangeHandler=v;b.dataStateChangeHandler=w;o.attachEvents(b.events);o.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"property");}};g.prototype.unbindProperty=function(n,s){var b=this.mBindingInfos[n];if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);if(this.refreshDataState){b.binding.detachAggregatedDataStateChange(b.dataStateChangeHandler);}b.binding.detachEvents(b.events);b.binding.destroy();}if(this._observer){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"property");}delete this.mBindingInfos[n];if(!s){this.resetProperty(n);}}return this;};g.prototype.updateProperty=function(n){var b=this.mBindingInfos[n],o=b.binding,p=this.getMetadata().getPropertyLikeSetting(n);if(b.skipPropertyUpdate){return;}try{var v=o.getExternalValue();b.skipModelUpdate=true;this[p._sMutator](v);b.skipModelUpdate=false;}catch(a){b.skipModelUpdate=false;if(a instanceof F){this.fireFormatError({element:this,property:n,type:o.getType(),newValue:o.getValue(),oldValue:this[p._sGetter](),exception:a,message:a.message},false,true);b.skipModelUpdate=true;this.resetProperty(n);b.skipModelUpdate=false;}else{throw a;}}};g.prototype.updateModelProperty=function(n,v,o){if(this.isBound(n)){var b=this.mBindingInfos[n],a=b.binding;if(b.skipModelUpdate||(a&&a.isSuspended())){return;}if(a&&a.getBindingMode()==e.TwoWay){try{b.skipPropertyUpdate=true;a.setExternalValue(v);b.skipPropertyUpdate=false;var c=a.getExternalValue();if(v!=c){this.updateProperty(n);}if(a.hasValidation()){this.fireValidationSuccess({element:this,property:n,type:a.getType(),newValue:v,oldValue:o},false,true);}}catch(i){b.skipPropertyUpdate=false;if(i instanceof P){this.fireParseError({element:this,property:n,type:a.getType(),newValue:v,oldValue:o,exception:i,message:i.message},false,true);}else if(i instanceof V){this.fireValidationError({element:this,property:n,type:a.getType(),newValue:v,oldValue:o,exception:i,message:i.message},false,true);}else{throw i;}}}}};var k=1;g.prototype.bindAggregation=function(n,b){var p,t,s,a,m=this.getMetadata(),A=m.getAggregation(n);if(!A){throw new Error("Aggregation \""+n+"\" does not exist in "+this);}if(!A.multiple){q.sap.log.error("Binding of single aggregation \""+n+"\" of "+this+" is not supported!");}if(typeof b=="string"){p=arguments[1];t=arguments[2];s=arguments[3];a=arguments[4];b={path:p,sorter:s,filters:a};if(t instanceof g){b.template=t;}else if(typeof t==="function"){b.factory=t;}}var o=m.getAggregationForwarder(n);if(o&&o.forwardBinding){return o.getTarget(this).bindAggregation(o.targetAggregationName,b);}if(this.isBound(n)){this.unbindAggregation(n);}if(!(b.template||b.factory)){if(A._doesNotRequireFactory){b.factory=function(){throw new Error("dummy factory called unexpectedly ");};}else{throw new Error("Missing template or factory function for aggregation "+n+" of "+this+" !");}}if(b.template){if(b.template._sapui_candidateForDestroy){q.sap.log.warning("A binding template that is marked as 'candidate for destroy' is reused in a binding. "+"You can use 'templateShareable:true' to fix this issue for all bindings that are affected "+"(The template is used in aggregation '"+n+"' of object '"+this.getId()+"'). "+"For more information, see documentation under 'Aggregation Binding'.");delete b.template._sapui_candidateForDestroy;}if(b.templateShareable===undefined){b.templateShareable=k;}b.factory=function(c){return b.template.clone(c);};}var i=b.path.indexOf(">");if(i>0){b.model=b.path.substr(0,i);b.path=b.path.substr(i+1);}this.mBindingInfos[n]=b;if(this._observer){this._observer.bindingChange(this,n,"prepare",b,"aggregation");}if(this.getModel(b.model)){this._bindAggregation(n,b);}return this;};g.prototype._bindAggregation=function(n,b){var t=this,o,m=function(l){var u="update"+n.substr(0,1).toUpperCase()+n.substr(1);if(t[u]){var s=l&&l.getParameter("reason");if(s){t[u](s);}else{t[u]();}}else{t.updateAggregation(n);}},a=function(l){var r="refresh"+n.substr(0,1).toUpperCase()+n.substr(1);if(t[r]){t[r](l.getParameter("reason"));}else{m(l);}},c=function(l){var p=o.getDataState();if(!p){return;}if(t.refreshDataState){t.refreshDataState(n,p);}};var i=this.getModel(b.model);if(this.isTreeBinding(n)){o=i.bindTree(b.path,this.getBindingContext(b.model),b.filters,b.parameters,b.sorter);}else{o=i.bindList(b.path,this.getBindingContext(b.model),b.sorter,b.filters,b.parameters);if(this.bUseExtendedChangeDetection){o.enableExtendedChangeDetection(!b.template,b.key);}}if(b.suspended){o.suspend(true);}b.binding=o;b.modelChangeHandler=m;b.modelRefreshHandler=a;b.dataStateChangeHandler=c;o.attachChange(m);o.attachRefresh(a);o.attachEvents(b.events);if(this.refreshDataState){o.attachAggregatedDataStateChange(c);}o.initialize();if(this._observer){this._observer.bindingChange(this,n,"ready",b,"aggregation");}};g.prototype.unbindAggregation=function(n,s){var o=this.getMetadata().getAggregationForwarder(n);if(o&&o.forwardBinding){return o.getTarget(this).unbindAggregation(o.targetAggregationName,s);}var b=this.mBindingInfos[n],a=this.getMetadata().getAggregation(n);if(b){if(b.binding){b.binding.detachChange(b.modelChangeHandler);b.binding.detachRefresh(b.modelRefreshHandler);b.binding.detachEvents(b.events);if(this.refreshDataState){b.binding.detachAggregatedDataStateChange(b.dataStateChangeHandler);}b.binding.destroy();}if(b.template){if(!b.templateShareable&&b.template.destroy){b.template.destroy();}if(b.templateShareable===k){b.template._sapui_candidateForDestroy=true;}}if(this._observer){this._observer.bindingChange(this,n,"remove",this.mBindingInfos[n],"aggregation");}delete this.mBindingInfos[n];if(!s){this[a._sDestructor]();}}return this;};g.prototype.updateAggregation=function(n){var b=this.mBindingInfos[n],o=b.binding,a=b.factory,A=this.getMetadata().getAggregation(n),G,c,l,s=A._sMutator+"Group",t=this;function m(i,w){if(t.bUseExtendedChangeDetection){return M.uid('clone');}else{return i.getId()+"-"+w;}}function u(w,l,x,y){var z=w[A._sGetter]()||[],H,J;if(z.length>l.length){for(var i=l.length;i<z.length;i++){J=z[i];w[A._sRemoveMutator](J);J.destroy("KeepDom");}}for(var i=0;i<l.length;i++){H=l[i];J=z[i];if(x){x(H);}if(J){J.setBindingContext(H,b.model);}else{J=a(m(w,i),H);J.setBindingContext(H,b.model);w[A._sMutator](J);}if(y){y(H,J);}}}function p(w,l){var x=l.diff,y=w[A._sGetter]()||[],z,H,J,i;if(!x||y.length===0){u(w,l);return;}for(i=0;i<x.length;i++){z=x[i];switch(z.type){case"insert":J=l[z.index];H=a(m(w,z.index),J);H.setBindingContext(J,b.model);w[A._sInsertMutator](H,z.index);break;case"delete":H=w[A._sRemoveMutator](z.index);H.destroy("KeepDom");break;default:q.sap.log.error("Unknown diff type \""+z.type+"\"");}}y=w[A._sGetter]()||[];for(i=0;i<y.length;i++){y[i].setBindingContext(l[i]);}}function r(i){var N=o.getGroup(i);if(N.key!==G){var w;if(b.groupHeaderFactory){w=b.groupHeaderFactory(N);}t[s](N,w);G=N.key;}}function v(i,w){u(i,w,null,function(x,y){v(y,o.getNodeContexts(x));});}if(d.isA(o,"sap.ui.model.ListBinding")){l=o.getContexts(b.startIndex,b.length);c=o.isGrouped()&&t[s];if(c||o.bWasGrouped){this[A._sDestructor]();u(this,l,c?r:undefined);}else if(this.bUseExtendedChangeDetection){p(this,l);}else{if(!b.template){this[A._sDestructor]();}u(this,l);}o.bWasGrouped=c;}else if(d.isA(o,"sap.ui.model.TreeBinding")){if(!b.template){this[A._sDestructor]();}v(this,o.getRootContexts());}};g.prototype.refreshAggregation=function(n){var b=this.mBindingInfos[n],o=b.binding;o.getContexts(b.startIndex,b.length);};g.prototype.propagateMessages=function(n,m){q.sap.log.warning("Message for "+this+", Property "+n);};g.prototype.isTreeBinding=function(n){return false;};g.prototype.updateBindings=function(u,m){var t=this,n,b;function a(b){var p=b.parts,i;if(p){if(p.length==1){return(u||p[0].model==m)&&!b.binding.updateRequired(t.getModel(p[0].model));}else{for(i=0;i<p.length;i++){if((u||p[i].model==m)&&!b.binding.aBindings[i].updateRequired(t.getModel(p[i].model))){return true;}}}}else{return(u||b.model==m)&&!b.binding.updateRequired(t.getModel(b.model));}}function c(b){var p=b.parts,i;if(p){for(i=0;i<p.length;i++){if(!t.getModel(p[i].model)){return false;}}return true;}else{return!!t.getModel(b.model);}}function r(b){if(t.refreshDataState){t.refreshDataState(n,b.binding.getDataState());}b.binding.detachChange(b.modelChangeHandler);if(b.modelRefreshHandler){b.binding.detachRefresh(b.modelRefreshHandler);}b.binding.detachEvents(b.events);b.binding.destroy();delete b.binding;delete b.modelChangeHandler;delete b.dataStateChangeHandler;delete b.modelRefreshHandler;}for(n in this.mObjectBindingInfos){b=this.mObjectBindingInfos[n];if(b.binding&&a(b)){r(b);}if(!b.binding&&c(b)){this._bindObject(b);}}for(n in this.mBindingInfos){b=this.mBindingInfos[n];if(b.binding&&a(b)){if(this._observer){var s=b.factory?"aggregation":"property";this._observer.bindingChange(this,n,"remove",b,s);}r(b);}if(!b.binding&&c(b)){if(b.factory){this._bindAggregation(n,b);}else{this._bindProperty(n,b);}}}};g.prototype.isBound=function(n){return!!this.getBindingInfo(n);};g.prototype.getObjectBinding=function(m){return this.mObjectBindingInfos[m]&&this.mObjectBindingInfos[m].binding;};g.prototype.getEventingParent=function(){return this.oParent;};g.prototype.getBinding=function(n){var i=this.getBindingInfo(n);return i&&i.binding;};g.prototype.getBindingPath=function(n){var i=this.getBindingInfo(n);return i&&(i.path||(i.parts&&i.parts[0]&&i.parts[0].path));};g.prototype.setBindingContext=function(c,m){var o=this.oBindingContexts[m];if(f.hasChanged(o,c)){if(c===undefined){delete this.oBindingContexts[m];}else{this.oBindingContexts[m]=c;}this.updateBindingContext(false,m);this.propagateProperties(m);this.fireModelContextChange();}return this;};g.prototype.setElementBindingContext=function(c,m){var o=this.mElementBindingContexts[m];if(f.hasChanged(o,c)){if(c===undefined){delete this.mElementBindingContexts[m];}else{this.mElementBindingContexts[m]=c;}this.updateBindingContext(true,m);this.propagateProperties(m);this.fireModelContextChange();}return this;};g.prototype.updateBindingContext=function(s,a,u){var m,o={},b,c,n,l,i;if(u){for(b in this.oModels){if(this.oModels.hasOwnProperty(b)){o[b]=b;}}for(b in this.oPropagatedProperties.oModels){if(this.oPropagatedProperties.oModels.hasOwnProperty(b)){o[b]=b;}}}else{o[a]=a;}for(b in o){if(o.hasOwnProperty(b)){b=b==="undefined"?undefined:b;m=this.getModel(b);l=this.mObjectBindingInfos[b];if(m&&l&&!s){if(!l.binding){this._bindObject(l);}else{c=this._getBindingContext(b);if(f.hasChanged(l.binding.getContext(),c)){l.binding.setContext(c);}}continue;}c=this.getBindingContext(b);for(n in this.mBindingInfos){var l=this.mBindingInfos[n],p=l.binding,r=l.parts;if(!p){continue;}if(r&&r.length>1){for(i=0;i<r.length;i++){if(r[i].model==b){p.aBindings[i].setContext(c);}}}else if(l.factory){if(l.model==b){p.setContext(c);}}else{if(r[0].model==b){p.setContext(c);}}}}}};g.prototype.getBindingContext=function(m){var o=this.getModel(m),a=this.mElementBindingContexts[m];if(a&&!o){return a;}else if(a&&o&&a.getModel()===o){return a;}else if(a===null){return a;}else{return this._getBindingContext(m);}};g.prototype._getBindingContext=function(m){var o=this.getModel(m),c=this.oBindingContexts[m],p=this.oPropagatedProperties.oBindingContexts[m];if(c&&!o){return this.oBindingContexts[m];}else if(c&&o&&c.getModel()===o){return this.oBindingContexts[m];}else if(c===null){return c;}else if(p&&o&&p.getModel()!==o){return undefined;}else{return p;}};g.prototype.setModel=function(m,n){if(!m&&this.oModels[n]){delete this.oModels[n];this.propagateProperties(n);this.updateBindings(false,n);this.fireModelContextChange();}else if(m&&m!==this.oModels[n]){this.oModels[n]=m;this.propagateProperties(n);this.updateBindingContext(false,n);this.updateBindings(false,n);this.fireModelContextChange();}return this;};g.prototype.addPropagationListener=function(l){this.aPropagationListeners.push(l);this.propagateProperties(false);this._callPropagationListener(l);return this;};g.prototype.removePropagationListener=function(l){var L=this.aPropagationListeners;var i=L.indexOf(l);if(i>=0){L.splice(i,1);this.propagateProperties(false);}return this;};g.prototype.getPropagationListeners=function(){return this.oPropagatedProperties.aPropagationListeners.concat(this.aPropagationListeners);};g.prototype._callPropagationListener=function(l){var L;if(l){l(this);}else{L=this.getPropagationListeners();for(var i=0;i<L.length;i++){l=L[i];l(this);}}return this;};g._oEmptyPropagatedProperties={oModels:{},oBindingContexts:{},aPropagationListeners:[]};g.prototype.propagateProperties=function(n){var p=this._getPropertiesToPropagate(),u=n===true,U=n===false,N=u?undefined:n,a,A,i;for(a in this.mAggregations){if(this.mSkipPropagation[a]){continue;}A=this.mAggregations[a];if(A instanceof g){this._propagateProperties(n,A,p,u,N,U);}else if(A instanceof Array){for(i=0;i<A.length;i++){if(A[i]instanceof g){this._propagateProperties(n,A[i],p,u,N,U);}}}}};g.prototype._propagateProperties=function(n,o,p,u,N,U){if(!p){p=this._getPropertiesToPropagate();u=n===true;U=n===false;N=u?undefined:n;}if(o.oPropagatedProperties!==p){o.oPropagatedProperties=p;if(U!==true){o.updateBindings(u,N);o.updateBindingContext(false,N,u);}o.propagateProperties(n);if(U||u){o._callPropagationListener();}o.fireModelContextChange();}};g.prototype._getPropertiesToPropagate=function(){var n=q.isEmptyObject(this.oModels),N=q.isEmptyObject(this.oBindingContexts),b=this.aPropagationListeners.length===0,a=q.isEmptyObject(this.mElementBindingContexts);function m(i,o,l,p){return i?o:q.extend({},o,l,p);}function c(i,l,o){return i?l:l.concat(o);}if(N&&n&&a&&b){return this.oPropagatedProperties;}else{return{oModels:m(n,this.oPropagatedProperties.oModels,this.oModels),oBindingContexts:m((N&&a),this.oPropagatedProperties.oBindingContexts,this.oBindingContexts,this.mElementBindingContexts),aPropagationListeners:c(b,this.oPropagatedProperties.aPropagationListeners,this.aPropagationListeners)};}};g.prototype.getModel=function(m){return this.oModels[m]||this.oPropagatedProperties.oModels[m];};g.prototype.hasModel=function(){return!(q.isEmptyObject(this.oModels)&&q.isEmptyObject(this.oPropagatedProperties.oModels));};g.prototype.clone=function(s,L,o){var c=true,b=true;if(o){c=!!o.cloneChildren;b=!!o.cloneBindings;}if(!s){s=M.uid("clone")||q.sap.uid();}if(!L&&c){L=this.findAggregatedObjects(true).map(function(O){return O.getId();});}var m=this.getMetadata(),a=m._oClass,n=this.getId()+"-"+s,p={},r=this.mProperties,K,N,t,u=g.bindingParser.escape,i;var v=Object.keys(r);i=v.length;while(i>0){K=v[--i];if(!(this.isBound(K)&&b)){if(typeof r[K]==="string"){p[K]=u(r[K]);}else{p[K]=r[K];}}}p["models"]=this.oModels;p["bindingContexts"]=this.oBindingContexts;if(c){for(N in this.mAggregations){var A=this.mAggregations[N];if(m.hasAggregation(N)&&!(this.isBound(N)&&b)){if(A instanceof g){p[N]=A.clone(s,L);}else if(Array.isArray(A)){p[N]=[];for(var i=0;i<A.length;i++){p[N].push(A[i].clone(s,L));}}else{p[N]=A;}}}var w=h(this.getId());for(var i=0,l=w.length;i<l;i++){var x=w[i].clone(s);x.sParentId=n;x.sParentAggregationName=w[i].sParentAggregationName;}for(N in this.mAssociations){var y=this.mAssociations[N];if(Array.isArray(y)){y=y.slice(0);for(var i=0;i<y.length;i++){if(L.indexOf(y[i])>=0){y[i]+="-"+s;}}}else if(L.indexOf(y)>=0){y+="-"+s;}p[N]=y;}}t=new a(n,p);for(N in this.mObjectBindingInfos){t.mObjectBindingInfos[N]=q.extend({},this.mObjectBindingInfos[N]);}for(N in this.mEventRegistry){t.mEventRegistry[N]=this.mEventRegistry[N].slice();}if(b){for(N in this.mBindingInfos){var z=this.mBindingInfos[N];var G=q.extend({},z);if(!z.templateShareable&&z.template&&z.template.clone){G.template=z.template.clone(s,L);delete G.factory;}else if(z.templateShareable===k){z.templateShareable=G.templateShareable=true;q.sap.log.error("During a clone operation, a template was found that neither was marked with 'templateShareable:true' nor 'templateShareable:false'. "+"The framework won't destroy the template. This could cause errors (e.g. duplicate IDs) or memory leaks "+"(The template is used in aggregation '"+N+"' of object '"+this.getId()+"')."+"For more information, see documentation under 'Aggregation Binding'.");}delete G.binding;delete G.modelChangeHandler;delete G.dataStateChangeHandler;delete G.modelRefreshHandler;if(z.factory||z.template){t.bindAggregation(N,G);}else{t.bindProperty(N,G);}}}if(g._supportInfo){g._supportInfo.addSupportInfo(t.getId(),g._supportInfo.byId(this.getId()));}if(this._cloneMetadataContexts){this._cloneMetadataContexts(t);}return t;};g._handleLocalizationChange=function(p){var i;if(p===1){q.each(this.oModels,function(n,m){if(m&&m._handleLocalizationChange){m._handleLocalizationChange();}});}else if(p===2){q.each(this.mBindingInfos,function(n,b){var a=b.parts;if(a){for(i=0;i<a.length;i++){if(b.type&&b.type._handleLocalizationChange){b.type._handleLocalizationChange();}}if(b.modelChangeHandler){b.modelChangeHandler();}}});}};g.prototype.findAggregatedObjects=function(r,c){var A=[];if(c&&typeof c!=="function"){c=null;}function b(o){var a,i,n;for(n in o.mAggregations){a=o.mAggregations[n];if(Array.isArray(a)){for(i=0;i<a.length;i++){if(!c||c(a[i])){A.push(a[i]);}if(r){b(a[i]);}}}else if(a instanceof g){if(!c||c(a)){A.push(a);}if(r){b(a);}}}}b(this);return A;};g._defaultContextualSettings={};return g;});
