/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./DataType','./Metadata'],function(q,D,M){"use strict";var c=function(s,o){M.apply(this,arguments);};c.prototype=Object.create(M.prototype);var h=Object.prototype.hasOwnProperty;function e(n){return n.charAt(0).toUpperCase()+n.slice(1);}var r=/(children|ies|ves|oes|ses|ches|shes|xes|s)$/i;var S={'children':-3,'ies':'y','ves':'f','oes':-2,'ses':-2,'ches':-2,'shes':-2,'xes':-2,'s':-1};function g(n){return n.replace(r,function($,p){var R=S[p.toLowerCase()];return typeof R==="string"?R:p.slice(0,R);});}function j(f,n){return function(){q.sap.log.warning("Usage of deprecated feature: "+n);return f.apply(this,arguments);};}function k(o,i){var a=null;for(var n in i){if(h.call(i,n)&&typeof o[n]==='undefined'){a=a||{};a[n]=i[n];}}return a;}var K={SPECIAL_SETTING:-1,PROPERTY:0,SINGLE_AGGREGATION:1,MULTIPLE_AGGREGATION:2,SINGLE_ASSOCIATION:3,MULTIPLE_ASSOCIATION:4,EVENT:5};c._guessSingularName=g;function l(o,n,i){i=typeof i!=='object'?{type:i}:i;this.name=n;this.type=i.type||'any';this.visibility=i.visibility||'public';this.defaultValue=i.defaultValue;this.appData=k(this,i);this._oParent=o;this._sUID="special:"+n;this._iKind=K.SPECIAL_SETTING;}function P(o,n,i){i=typeof i!=='object'?{type:i}:i;this.name=n;this.type=i.type||'string';this.group=i.group||'Misc';this.defaultValue=i.defaultValue!==null?i.defaultValue:null;this.bindable=!!i.bindable;this.deprecated=!!i.deprecated||false;this.visibility='public';this.selector=typeof i.selector==="string"?i.selector:null;this.appData=k(this,i);this._oParent=o;this._sUID=n;this._iKind=K.PROPERTY;var N=e(n);this._sMutator='set'+N;this._sGetter='get'+N;if(this.bindable){this._sBind='bind'+N;this._sUnbind='unbind'+N;}else{this._sBind=this._sUnbind=undefined;}this._oType=null;}P.prototype.generate=function(a){var t=this,n=t.name;a(t._sGetter,function(){return this.getProperty(n);});a(t._sMutator,function(v){this.setProperty(n,v);return this;},t);if(t.bindable){a(t._sBind,function(p,f,m){this.bindProperty(n,p,f,m);return this;},t);a(t._sUnbind,function(p){this.unbindProperty(n,p);return this;});}};P.prototype.getType=function(){return this._oType||(this._oType=D.getType(this.type));};P.prototype.getDefaultValue=function(){var d=this.defaultValue,t;if(d===null){t=this.getType();if(t instanceof D){d=t.getDefaultValue();}}return d;};P.prototype.get=function(i){return i[this._sGetter]();};P.prototype.set=function(i,v){return i[this._sMutator](v);};function A(o,n,i){i=typeof i!=='object'?{type:i}:i;this.name=n;this.type=i.type||'sap.ui.core.Control';this.altTypes=i.altTypes||undefined;this.multiple=typeof i.multiple==='boolean'?i.multiple:true;this.singularName=this.multiple?i.singularName||g(n):undefined;this.bindable=!!i.bindable;this.deprecated=i.deprecated||false;this.visibility=i.visibility||'public';this.selector=i.selector||null;this.forwarding=i.forwarding;this._doesNotRequireFactory=!!i._doesNotRequireFactory;this.appData=k(this,i);this._oParent=o;this._sUID='aggregation:'+n;this._iKind=this.multiple?K.MULTIPLE_AGGREGATION:K.SINGLE_AGGREGATION;this._oForwarder=this.forwarding?new u(this):undefined;var N=e(n);this._sGetter='get'+N;if(this.multiple){var a=e(this.singularName);this._sMutator='add'+a;this._sInsertMutator='insert'+a;this._sRemoveMutator='remove'+a;this._sRemoveAllMutator='removeAll'+N;this._sIndexGetter='indexOf'+a;this._sUpdater='update'+N;this._sRefresher='refresh'+N;}else{this._sMutator='set'+N;this._sInsertMutator=this._sRemoveMutator=this._sRemoveAllMutator=this._sIndexGetter=this._sUpdater=this._sRefresher=undefined;}this._sDestructor='destroy'+N;if(this.bindable){this._sBind='bind'+N;this._sUnbind='unbind'+N;}else{this._sBind=this._sUnbind=undefined;}}A.prototype.generate=function(b){var d=this,n=d.name;if(!d.multiple){b(d._sGetter,function(){return this.getAggregation(n);});b(d._sMutator,function(v){this.setAggregation(n,v);return this;},d);}else{b(d._sGetter,function(){return this.getAggregation(n,[]);});b(d._sMutator,function(a){this.addAggregation(n,a);return this;},d);b(d._sInsertMutator,function(i,a){this.insertAggregation(n,i,a);return this;},d);b(d._sRemoveMutator,function(a){return this.removeAggregation(n,a);});b(d._sRemoveAllMutator,function(){return this.removeAllAggregation(n);});b(d._sIndexGetter,function(a){return this.indexOfAggregation(n,a);});}b(d._sDestructor,function(){this.destroyAggregation(n);return this;});if(d.bindable){b(d._sBind,function(p,t,s,f){this.bindAggregation(n,p,t,s,f);return this;},d);b(d._sUnbind,function(p){this.unbindAggregation(n,p);return this;});}};A.prototype.getType=function(){return this._oType||(this._oType=D.getType(this.type));};A.prototype.get=function(i){return i[this._sGetter]();};A.prototype.set=function(i,v){return i[this._sMutator](v);};A.prototype.add=function(i,v){return i[this._sMutator](v);};A.prototype.insert=function(i,v,p){return i[this._sInsertMutator](v,p);};A.prototype.remove=function(i,v){return i[this._sRemoveMutator](v);};A.prototype.removeAll=function(i){return i[this._sRemoveAllMutator]();};A.prototype.indexOf=function(i,v){return i[this._sIndexGetter](v);};A.prototype.destroy=function(i){return i[this._sDestructor]();};function u(a){var f=a.forwarding;this.aggregation=a;this.targetAggregationName=f.aggregation;this.forwardBinding=f.forwardBinding;this.targetAggregationInfo=null;if(f.getter){if(typeof f.getter==="function"){this._getTarget=f.getter;}else{this._getTarget=(function(s){return function(){return this[s]();};})(f.getter);}}else if(f.idSuffix){this._getTarget=(function(i){return function(){return sap.ui.getCore().byId(this.getId()+i);};})(f.idSuffix);}else{throw new Error("Either getter or idSuffix must be given for forwarding the aggregation "+a.name+" to the aggregation "+f.aggregation+" in "+a._oParent.getName());}}u.prototype._getTargetAggregationInfo=function(t){var T=this.targetAggregationInfo;if(!T){T=this.targetAggregationInfo=t.getMetadata().getAggregation(this.targetAggregationName);if(!T){throw new Error("Target aggregation "+this.targetAggregationName+" not found on "+t);}if(this.aggregation.multiple!==T.multiple){throw new Error("Aggregation "+this.aggregation+" (multiple: "+this.aggregation.multiple+") cannot be forwarded to aggregation "+this.targetAggregationName+" (multiple: "+T.multiple+")");}}return T;};u.prototype.getTarget=function(i){var t=this._getTarget.call(i);this._getTargetAggregationInfo(t);return t;};u.prototype.get=function(i){var t=this.getTarget(i);if(t){return this.targetAggregationInfo.get(t);}else{return this.targetAggregationInfo.multiple?[]:null;}};u.prototype.indexOf=function(i,a){var t=this.getTarget(i);return this.targetAggregationInfo.multiple?this.targetAggregationInfo.indexOf(t,a):t.indexOfAggregation(this.targetAggregationName,a);};u.prototype.set=function(i,a){var t=this.getTarget(i);c.addAPIParentInfo(a,i,this.aggregation.name);this.targetAggregationInfo.set(t,a);return i;};u.prototype.add=function(i,a){var t=this.getTarget(i);c.addAPIParentInfo(a,i,this.aggregation.name);this.targetAggregationInfo.add(t,a);return i;};u.prototype.insert=function(i,a,I){var t=this.getTarget(i);c.addAPIParentInfo(a,i,this.aggregation.name);this.targetAggregationInfo.insert(t,a,I);return i;};function w(a,b){while(a&&a!==b){a=a.oParent;}return!!a;}c.addAPIParentInfo=function(a,p,s){if(!a){return;}var n={parent:p,aggregationName:s};if(!a.aAPIParentInfos){a.aAPIParentInfos=[n];}else{var o=a.aAPIParentInfos[a.aAPIParentInfos.length-1];if(o&&!w(p,o.parent)){a.aAPIParentInfos=[];}a.aAPIParentInfos.push(n);}};u.prototype.remove=function(i,a){var t=this.getTarget(i);var b=this.targetAggregationInfo.remove(t,a);if(b){b.aAPIParentInfos.pop();}return b;};u.prototype.removeAll=function(I){var t=this.getTarget(I);var R=this.targetAggregationInfo.removeAll(t);for(var i=0;i<R.length;i++){if(R[i].aAPIParentInfos){R[i].aAPIParentInfos.pop();}}return R;};u.prototype.destroy=function(i){var t=this.getTarget(i);this.targetAggregationInfo.destroy(t);return i;};function x(o,n,i){i=typeof i!=='object'?{type:i}:i;this.name=n;this.type=i.type||'sap.ui.core.Control';this.multiple=i.multiple||false;this.singularName=this.multiple?i.singularName||g(n):undefined;this.deprecated=i.deprecated||false;this.visibility='public';this.appData=k(this,i);this._oParent=o;this._sUID='association:'+n;this._iKind=this.multiple?K.MULTIPLE_ASSOCIATION:K.SINGLE_ASSOCIATION;var N=e(n);this._sGetter='get'+N;if(this.multiple){var a=e(this.singularName);this._sMutator='add'+a;this._sRemoveMutator='remove'+a;this._sRemoveAllMutator='removeAll'+N;}else{this._sMutator='set'+N;this._sRemoveMutator=this._sRemoveAllMutator=undefined;}}x.prototype.generate=function(b){var t=this,n=t.name;if(!t.multiple){b(t._sGetter,function(){return this.getAssociation(n);});b(t._sMutator,function(v){this.setAssociation(n,v);return this;},t);}else{b(t._sGetter,function(){return this.getAssociation(n,[]);});b(t._sMutator,function(a){this.addAssociation(n,a);return this;},t);b(t._sRemoveMutator,function(a){return this.removeAssociation(n,a);});b(t._sRemoveAllMutator,function(){return this.removeAllAssociation(n);});if(n!==t.singularName){b('removeAll'+e(t.singularName),function(){q.sap.log.warning("Usage of deprecated method "+t._oParent.getName()+".prototype."+'removeAll'+e(t.singularName)+","+" use method "+t._sRemoveAllMutator+" (plural) instead.");return this[t._sRemoveAllMutator]();});}}};x.prototype.getType=function(){return this._oType||(this._oType=D.getType(this.type));};x.prototype.get=function(i){return i[this._sGetter]();};x.prototype.set=function(i,v){return i[this._sMutator](v);};x.prototype.remove=function(i,v){return i[this._sRemoveMutator](v);};x.prototype.removeAll=function(i){return i[this._sRemoveAllMutator]();};function E(o,n,i){this.name=n;this.allowPreventDefault=i.allowPreventDefault||false;this.deprecated=i.deprecated||false;this.visibility='public';this.allowPreventDefault=!!i.allowPreventDefault;this.enableEventBubbling=!!i.enableEventBubbling;this.appData=k(this,i);this._oParent=o;this._sUID='event:'+n;this._iKind=K.EVENT;var N=e(n);this._sMutator='attach'+N;this._sDetachMutator='detach'+N;this._sTrigger='fire'+N;}E.prototype.generate=function(a){var t=this,n=t.name,b=t.allowPreventDefault,i=t.enableEventBubbling;a(t._sMutator,function(d,f,o){this.attachEvent(n,d,f,o);return this;},t);a(t._sDetachMutator,function(f,o){this.detachEvent(n,f,o);return this;});a(t._sTrigger,function(p){return this.fireEvent(n,p,b,i);});};E.prototype.attach=function(i,d,f,a){return i[this._sMutator](d,f,a);};E.prototype.detach=function(i,f,a){return i[this._sDetachMutator](f,a);};E.prototype.fire=function(i,p,a,b){return i[this._sTrigger](p,a,b);};c.prototype.metaFactorySpecialSetting=l;c.prototype.metaFactoryProperty=P;c.prototype.metaFactoryAggregation=A;c.prototype.metaFactoryAssociation=x;c.prototype.metaFactoryEvent=E;c.prototype.applySettings=function(o){var t=this,s=o.metadata;M.prototype.applySettings.call(this,o);function n(i,m){var R={},N;if(i){for(N in i){if(h.call(i,N)){R[N]=new m(t,N,i[N]);}}}return R;}function f(i,p){var R={},N;for(N in i){if(p===(i[N].visibility==='public')){R[N]=i[N];}}return R;}var a=/([a-z][^.]*(?:\.[a-z][^.]*)*)\./;function d(N){var m=a.exec(N);return(m&&m[1])||"";}this._sLibraryName=s.library||d(this.getName());this._mSpecialSettings=n(s.specialSettings,this.metaFactorySpecialSetting);this._mProperties=n(s.properties,this.metaFactoryProperty);var b=n(s.aggregations,this.metaFactoryAggregation);this._mAggregations=f(b,true);this._mPrivateAggregations=f(b,false);this._sDefaultAggregation=s.defaultAggregation||null;this._sDefaultProperty=s.defaultProperty||null;this._mAssociations=n(s.associations,this.metaFactoryAssociation);this._mEvents=n(s.events,this.metaFactoryEvent);this._oDesignTime=o.metadata["designtime"]||o.metadata["designTime"];if(o.metadata.__version>1.0){this.generateAccessors();}};c.prototype.afterApplySettings=function(){M.prototype.afterApplySettings.call(this);var p=this.getParent();if(p instanceof c){this._mAllEvents=q.extend({},p._mAllEvents,this._mEvents);this._mAllProperties=q.extend({},p._mAllProperties,this._mProperties);this._mAllPrivateAggregations=q.extend({},p._mAllPrivateAggregations,this._mPrivateAggregations);this._mAllAggregations=q.extend({},p._mAllAggregations,this._mAggregations);this._mAllAssociations=q.extend({},p._mAllAssociations,this._mAssociations);this._sDefaultAggregation=this._sDefaultAggregation||p._sDefaultAggregation;this._sDefaultProperty=this._sDefaultProperty||p._sDefaultProperty;this._mAllSpecialSettings=q.extend({},p._mAllSpecialSettings,this._mSpecialSettings);}else{this._mAllEvents=this._mEvents;this._mAllProperties=this._mProperties;this._mAllPrivateAggregations=this._mPrivateAggregations;this._mAllAggregations=this._mAggregations;this._mAllAssociations=this._mAssociations;this._mAllSpecialSettings=this._mSpecialSettings;}};c.Kind=K;c.prototype.getLibraryName=function(){return this._sLibraryName;};c.prototype.addProperty=function(n,i){var p=this._mProperties[n]=new P(this,n,i);if(!this._mAllProperties[n]){this._mAllProperties[n]=p;}};c.prototype.hasProperty=function(n){return!!this._mAllProperties[n];};c.prototype.getProperty=function(n){var p=this._mAllProperties[n];return typeof p==='object'?p:undefined;};c.prototype.getProperties=function(){return this._mProperties;};c.prototype.getAllProperties=function(){return this._mAllProperties;};c.prototype.hasAggregation=function(n){return!!this._mAllAggregations[n];};c.prototype.getAggregation=function(n){n=n||this._sDefaultAggregation;var a=n?this._mAllAggregations[n]:undefined;return typeof a==='object'?a:undefined;};c.prototype.getAggregations=function(){return this._mAggregations;};c.prototype.getAllAggregations=function(){return this._mAllAggregations;};c.prototype.getAllPrivateAggregations=function(){return this._mAllPrivateAggregations;};c.prototype.getManagedAggregation=function(a){a=a||this._sDefaultAggregation;var o=a?this._mAllAggregations[a]||this._mAllPrivateAggregations[a]:undefined;return typeof o==='object'?o:undefined;};c.prototype.getDefaultAggregationName=function(){return this._sDefaultAggregation;};c.prototype.getDefaultAggregation=function(){return this.getAggregation();};c.prototype.forwardAggregation=function(f,o){var a=this.getAggregation(f);if(!a){throw new Error("aggregation "+f+" does not exist");}if(!o||!o.aggregation||!(o.idSuffix||o.getter)||(o.idSuffix&&o.getter)){throw new Error("an 'mOptions' object with 'aggregation' property and either 'idSuffix' or 'getter' property (but not both) must be given"+" but does not exist");}if(a._oParent===this){a.forwarding=o;a._oForwarder=new u(a);}else{a=new this.metaFactoryAggregation(this,f,{type:a.type,altTypes:a.altTypes,multiple:a.multiple,singularName:a.singularName,bindable:a.bindable,deprecated:a.deprecated,visibility:a.visibility,selector:a.selector,forwarding:o});this._mAggregations[f]=this._mAllAggregations[f]=a;}};c.prototype.getAggregationForwarder=function(a){var o=this._mAllAggregations[a];return o?o._oForwarder:undefined;};c.prototype.getDefaultPropertyName=function(){return this._sDefaultProperty;};c.prototype.getDefaultProperty=function(){return this.getProperty(this.getDefaultPropertyName());};c.prototype.getPropertyLikeSetting=function(n){var p=this._mAllProperties[n];if(typeof p==='object'){return p;}p=this._mAllAggregations[n];return(typeof p==='object'&&p.altTypes&&p.altTypes.length>0)?p:undefined;};c.prototype.hasAssociation=function(n){return!!this._mAllAssociations[n];};c.prototype.getAssociation=function(n){var a=this._mAllAssociations[n];return typeof a==='object'?a:undefined;};c.prototype.getAssociations=function(){return this._mAssociations;};c.prototype.getAllAssociations=function(){return this._mAllAssociations;};c.prototype.hasEvent=function(n){return!!this._mAllEvents[n];};c.prototype.getEvent=function(n){var o=this._mAllEvents[n];return typeof o==='object'?o:undefined;};c.prototype.getEvents=function(){return this._mEvents;};c.prototype.getAllEvents=function(){return this._mAllEvents;};c.prototype.addSpecialSetting=function(n,i){var s=new l(this,n,i);this._mSpecialSettings[n]=s;if(!this._mAllSpecialSettings[n]){this._mAllSpecialSettings[n]=s;}};c.prototype.hasSpecialSetting=function(n){return!!this._mAllSpecialSettings[n];};c.prototype.getPropertyDefaults=function(){var d=this._mDefaults;if(d){return d;}if(this.getParent()instanceof c){d=q.extend({},this.getParent().getPropertyDefaults());}else{d={};}for(var s in this._mProperties){d[s]=this._mProperties[s].getDefaultValue();}this._mDefaults=d;return d;};c.prototype.createPropertyBag=function(){if(!this._fnPropertyBagFactory){this._fnPropertyBagFactory=function PropertyBag(){};this._fnPropertyBagFactory.prototype=this.getPropertyDefaults();}return new(this._fnPropertyBagFactory)();};c.prototype._enrichChildInfos=function(){q.sap.log.error("obsolete call to ManagedObjectMetadata._enrichChildInfos. This private method will be deleted soon");};c.prototype.getJSONKeys=function(){if(this._mJSONKeys){return this._mJSONKeys;}var a={},J={};function b(m){var n,i,p;for(n in m){i=m[n];p=a[n];if(!p||i._iKind<p._iKind){a[n]=J[n]=i;}J[i._sUID]=i;}}b(this._mAllSpecialSettings);b(this.getAllProperties());b(this.getAllAggregations());b(this.getAllAssociations());b(this.getAllEvents());this._mJSONKeys=J;this._mAllSettings=a;return this._mJSONKeys;};c.prototype.getAllSettings=function(){if(!this._mAllSettings){this.getJSONKeys();}return this._mAllSettings;};c.prototype.removeUnknownSettings=function(s){if(s==null){return s;}var v=this.getJSONKeys(),R={},n;for(n in s){if(h.call(v,n)){R[n]=s[n];}}return R;};c.prototype.generateAccessors=function(){var p=this.getClass().prototype,a=this.getName()+".",m=this._aPublicMethods,n;function b(d,f,i){if(!p[d]){p[d]=(i&&i.deprecated)?j(f,a+i.name):f;}m.push(d);}for(n in this._mProperties){this._mProperties[n].generate(b);}for(n in this._mAggregations){this._mAggregations[n].generate(b);}for(n in this._mAssociations){this._mAssociations[n].generate(b);}for(n in this._mEvents){this._mEvents[n].generate(b);}};function y(m){var L=m.getLibraryName(),p=sap.ui.getCore().getConfiguration().getPreload(),o=sap.ui.getCore().getLoadedLibraries()[L];if(o&&o.designtime){var a;if(p==="async"||p==="sync"){a=q.sap._loadJSResourceAsync(o.designtime.replace(/\.designtime$/,"-preload.designtime.js"),true);}else{a=Promise.resolve();}return new Promise(function(R){a.then(function(){sap.ui.require([o.designtime],function(b){R(b);});});});}return Promise.resolve(null);}function z(m){if(q.isPlainObject(m._oDesignTime)||!m._oDesignTime){return Promise.resolve(m._oDesignTime||{});}return new Promise(function(R){var s;if(typeof m._oDesignTime==="string"){s=m._oDesignTime;}else{s=q.sap.getResourceName(m.getName(),".designtime");}y(m).then(function(L){sap.ui.require([s],function(d){d.designtimeModule=s;m._oDesignTime=d;d._oLib=L;R(d);});});});}function B(i){var I=i instanceof q.sap.getObject('sap.ui.base.ManagedObject')&&typeof i.data==="function"&&i.data("sap-ui-custom-settings")&&i.data("sap-ui-custom-settings")["sap.ui.dt"]&&i.data("sap-ui-custom-settings")["sap.ui.dt"].designtime;if(typeof I==="string"){return new Promise(function(R){sap.ui.require([I],function(d){R(d);});});}else{return Promise.resolve({});}}function C(m,s){var R=m;if("default"in m){R=q.sap.extend(true,{},m.default,s!=="default"&&m[s]||null);}return R;}c.prototype.loadDesignTime=function(m,s){s=typeof s==="string"&&s||"default";var i=B(m);if(!this._oDesignTimePromise){var W;var p=this.getParent();if(p instanceof c){W=p.loadDesignTime(null,s);}else{W=Promise.resolve({});}this._oDesignTimePromise=z(this).then(function(o){return W.then(function(a){return q.sap.extend(true,{},C(a,s),C(o,s),{designtimeModule:o.designtimeModule||undefined,_oLib:o._oLib});});});}return Promise.all([i,this._oDesignTimePromise]).then(function(d){var I=d[0],o=d[1];return q.sap.extend(true,{},o,C(I||{},s));});};var U={},F;function G(i){i=(F||(F=sap.ui.getCore().getConfiguration().getUIDPrefix()))+i;var a=U[i]||0;U[i]=a+1;return i+a;}c.uid=G;c.prototype.uid=function(){var i=this._sUIDToken;if(typeof i!=="string"){i=this.getName();i=i.slice(i.lastIndexOf('.')+1);i=i.replace(/([a-z])([A-Z])/g,"$1 $2").split(" ").slice(-1)[0];i=this._sUIDToken=i.replace(/([^A-Za-z0-9-_.:])|([0-9]+$)/g,"").toLowerCase();}return G(i);};var H;c.isGeneratedId=function(i){F=F||sap.ui.getCore().getConfiguration().getUIDPrefix();H=H||new RegExp("(^|-{1,3})"+q.sap.escapeRegExp(F));return H.test(i);};return c;},true);
