/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./LabelEnablement','sap/ui/base/Object','jquery.sap.act','jquery.sap.encoder','jquery.sap.dom','jquery.sap.trace'],function(q,L,B){"use strict";var c=["renderControl","write","writeEscaped","translate","writeAcceleratorKey","writeControlData","writeInvisiblePlaceholderData","writeElementData","writeAttribute","writeAttributeEscaped","addClass","writeClasses","addStyle","writeStyles","writeAccessibilityState","writeIcon","getConfiguration","getHTML","cleanupControlWithoutRendering"];var N=["render","flush","destroy"];function R(){var t=this,F,l,r,s,o,p;this._setFocusHandler=function(n){F=n;};function u(){l=t.aBuffer=[];r=t.aRenderedControls=[];s=t.aStyleStack=[{}];}this.write=function(T){l.push.apply(l,arguments);return this;};this.writeEscaped=function(T,e){if(T!=null){T=q.sap.encodeHTML(String(T));if(e){T=T.replace(/&#xa;/g,"<br>");}l.push(T);}return this;};this.writeAttribute=function(n,V){l.push(" ",n,"=\"",V,"\"");return this;};this.writeAttributeEscaped=function(n,V){l.push(" ",n,"=\"",q.sap.encodeHTML(String(V)),"\"");return this;};this.addStyle=function(n,e){if(e!=null){var S=s[s.length-1];if(!S.aStyle){S.aStyle=[];}S.aStyle.push(n+":"+e);}return this;};this.writeStyles=function(){var S=s[s.length-1];if(S.aStyle){this.write(" style=\""+S.aStyle.join(";")+"\" ");}S.aStyle=null;return this;};this.addClass=function(n){if(n){var S=s[s.length-1];if(!S.aClasses){S.aClasses=[];}S.aClasses.push(n);}return this;};this.writeClasses=function(e){var S=s[s.length-1];var C;if(e){C=e.aCustomStyleClasses;}else if(e===false){C=[];}else{C=S.aCustomStyleClasses;}if(S.aClasses||C){var j=[].concat(S.aClasses||[],C||[]);j.sort();j=j.filter(function(n,i){return i==0||n!==j[i-1];});this.write(" class=\"",j.join(" "),"\" ");}if(!e){S.aCustomStyleClasses=null;}S.aClasses=null;return this;};function v(C){p=true;try{var e=q.Event("BeforeRendering");e.srcControl=C;C._handleEvent(e);}finally{p=false;}}this.cleanupControlWithoutRendering=function(C){if(!C||!C.getDomRef()){return;}v(C);C.bOutput=false;};this.renderControl=function(C){if(!C){return this;}if(!o){o=[];}if(o&&o.length>0){q.sap.measure.pause(o[0]+"---renderControl");}else if(C.getParent()&&C.getParent().getMetadata().getName()=="sap.ui.core.UIArea"){q.sap.measure.pause(C.getParent().getId()+"---rerender");}o.unshift(C.getId());q.sap.measure.start(C.getId()+"---renderControl","Rendering of "+C.getMetadata().getName(),["rendering","control"]);var e=l.length;var j={};if(C.aCustomStyleClasses&&C.aCustomStyleClasses.length>0){j.aCustomStyleClasses=C.aCustomStyleClasses;}s.push(j);q.sap.measure.pause(C.getId()+"---renderControl");var n;var M=C.getMetadata();var V=C.getVisible();if(V){n=M.getRenderer();}else{var E=M.getProperty("visible");var U=E&&E._oParent&&E._oParent.getName()=="sap.ui.core.Control";n=U?k:M.getRenderer();}q.sap.measure.resume(C.getId()+"---renderControl");v(C);var G=C.aBindParameters;if(G&&G.length>0){var H=q(C.getDomRef());if(H&&H[0]){for(var i=0;i<G.length;i++){var J=G[i];H.unbind(J.sEventType,J.fnProxy);}}}if(n&&typeof n.render==="function"){n.render(y,C);}else{q.sap.log.error("The renderer for class "+M.getName()+" is not defined or does not define a render function! Rendering of "+C.getId()+" will be skipped!");}s.pop();r.push(C);if(C.getUIArea&&C.getUIArea()){C.getUIArea()._onControlRendered(C);}C.bOutput=l.length!=e;if(n===k){C.bOutput="invisible";}q.sap.measure.end(C.getId()+"---renderControl");o.shift();if(o&&o.length>0){q.sap.measure.resume(o[0]+"---renderControl");}else if(C.getParent()&&C.getParent().getMetadata().getName()=="sap.ui.core.UIArea"){q.sap.measure.resume(C.getParent().getId()+"---rerender");}return this;};this.getHTML=function(C){var e=l;var i=l=this.aBuffer=[];this.renderControl(C);l=this.aBuffer=e;return i.join("");};function w(S){var i,n=r.length;for(i=0;i<n;i++){r[i]._sapui_bInAfterRenderingPhase=true;}p=true;try{for(i=0;i<n;i++){var C=r[i];if(C.bOutput&&C.bOutput!=="invisible"){var E=q.Event("AfterRendering");E.srcControl=C;q.sap.measure.start(C.getId()+"---AfterRendering","AfterRendering of "+C.getMetadata().getName(),["rendering","after"]);C._handleEvent(E);q.sap.measure.end(C.getId()+"---AfterRendering");}}}finally{for(i=0;i<n;i++){delete r[i]._sapui_bInAfterRenderingPhase;}p=false;}try{F.restoreFocus(S);}catch(e){q.sap.log.warning("Problems while restoring the focus after rendering: "+e,null);}for(i=0;i<n;i++){var C=r[i],G=C.aBindParameters;if(G&&G.length>0){var H=q(C.getDomRef());if(H&&H[0]){for(var j=0;j<G.length;j++){var J=G[j];H.bind(J.sEventType,J.fnProxy);}}}}}function x(e){var S=F?F.getControlFocusInfo():null;var H=l.join("");e(H);w(S);u();q.sap.act.refresh();q.sap.interaction.notifyStepEnd();}this.flush=function(T,e,j){if(!e&&(typeof j!=="number")&&!j){R.preserveContent(T);}x(function(H){for(var i=0;i<r.length;i++){var n=r[i].getDomRef();if(n&&!R.isPreservedContent(n)){if(R.isInlineTemplate(n)){q(n).empty();}else{q(n).remove();}}}if(typeof j==="number"){if(j<=0){q(T).prepend(H);}else{var $=q(T).children().eq(j-1);if($.length===1){$.after(H);}else{q(T).append(H);}}}else if(!j){q(T).html(H);}else{q(T).append(H);}});};this.render=function(C,T){if(p){q.sap.log.error("Render must not be called within Before or After Rendering Phase. Call ignored.",null,this);return;}u();this.renderControl(C);x(function(H){if(C&&T){var e=C.getDomRef();if(!e||R.isPreservedContent(e)){e=q.sap.domById(a.Invisible+C.getId())||q.sap.domById(a.Dummy+C.getId());}var n=e&&e.parentNode!=T;var i=function(){var j=q(T);if(T.innerHTML==""){j.html(H);}else{j.append(H);}};if(n){if(!R.isPreservedContent(e)){if(R.isInlineTemplate(e)){q(e).empty();}else{q(e).remove();}}if(H){i();}}else{if(H){if(e){if(R.isInlineTemplate(e)){q(e).html(H);}else if(h()){q.sap.replaceDOM(e,H,true);}else{q(e).replaceWith(H);}}else{i();}}else{if(R.isInlineTemplate(e)){q(e).empty();}else{if(!C.getParent()||!C.getParent()._onChildRerenderedEmpty||!C.getParent()._onChildRerenderedEmpty(C,e)){q(e).remove();}}}}}});};this.destroy=function(){u();};var y={};var z={};c.forEach(function(M){y[M]=z[M]=t[M];});N.forEach(function(M){z[M]=t[M];});this.getRendererInterface=function(){return y;};this.getInterface=function(){return z;};u();}R.prototype.getConfiguration=function(){return sap.ui.getCore().getConfiguration();};R.prototype.translate=function(K){};R.prototype.writeAcceleratorKey=function(){return this;};R.prototype.writeControlData=function(C){this.writeElementData(C);return this;};R.prototype.writeInvisiblePlaceholderData=function(e){var p=R.createInvisiblePlaceholderId(e),s=' '+'id="'+p+'" '+'class="sapUiHiddenPlaceholder" '+'data-sap-ui="'+p+'" '+'style="display: none;"'+'aria-hidden="true" ';this.write(s);return this;};R.prototype.writeElementData=function(e){var s=e.getId();if(s){this.writeAttribute("id",s).writeAttribute("data-sap-ui",s);}var j=e.getCustomData();var l=j.length;for(var i=0;i<l;i++){var C=j[i]._checkWriteToDom(e);if(C){this.writeAttributeEscaped(C.key,C.value);}}var n=e.getDragDropConfig().some(function(v){return v.isDraggable(e);});if(!n){var p=e.getParent();if(p&&p.getDragDropConfig){n=p.getDragDropConfig().some(function(v){return v.isDraggable(e);});}}if(n){this.writeAttribute("draggable","true");this.writeAttribute("data-sap-ui-draggable","true");}return this;};R.prototype.writeAccessibilityState=function(e,j){if(!sap.ui.getCore().getConfiguration().getAccessibility()){return this;}if(arguments.length==1&&!(B.isA(e,'sap.ui.core.Element'))){j=e;e=null;}var l={};if(e!=null){var M=e.getMetadata();var n=function(E,i,v){var w=M.getProperty(E);if(w&&e[w._sGetter]()===v){l[i]="true";}};var o=function(E,v){var w=M.getAssociation(E);if(w&&w.multiple){var y=e[w._sGetter]();if(E=="ariaLabelledBy"){var z=L.getReferencingLabels(e);var C=z.length;if(C){var F=[];for(var i=0;i<C;i++){if(y.indexOf(z[i])<0){F.push(z[i]);}}y=F.concat(y);}}if(y.length>0){l[v]=y.join(" ");}}};n("editable","readonly",false);n("enabled","disabled",false);n("visible","hidden",false);if(L.isRequired(e)){l["required"]="true";}n("selected","selected",true);n("checked","checked",true);o("ariaDescribedBy","describedby");o("ariaLabelledBy","labelledby");}if(j){var r=function(v){var i=typeof(v);return v===null||v===""||i==="number"||i==="string"||i==="boolean";};var s={};var x,t,u;for(x in j){t=j[x];if(r(t)){s[x]=t;}else if(typeof(t)==="object"&&r(t.value)){u="";if(t.append&&(x==="describedby"||x==="labelledby")){u=l[x]?l[x]+" ":"";}s[x]=u+t.value;}}q.extend(l,s);}if(B.isA(e,'sap.ui.core.Element')&&e.getParent()&&e.getParent().enhanceAccessibilityState){e.getParent().enhanceAccessibilityState(e,l);}for(var p in l){if(l[p]!=null&&l[p]!==""){this.writeAttributeEscaped(p==="role"?p:"aria-"+p,l[p]);}}return this;};R.prototype.writeIcon=function(u,C,e){var i=sap.ui.requireSync("sap/ui/core/IconPool"),j=i.isIconURI(u),s=j?"<span ":"<img ",l=false,n,p,o,r,t,v;if(typeof C==="string"){C=[C];}if(j){o=i.getIconInfo(u);if(!o){q.sap.log.error("An unregistered icon: "+u+" is used in sap.ui.core.RenderManager's writeIcon method.");return this;}if(!C){C=[];}C.push("sapUiIcon");if(!o.suppressMirroring){C.push("sapUiIconMirrorInRTL");}}this.write(s);if(Array.isArray(C)&&C.length){n=C.join(" ");this.write("class=\""+n+"\" ");}if(j){r={"data-sap-ui-icon-content":o.content,"role":"presentation","title":o.text||null};this.write("style=\"font-family: "+o.fontFamily+";\" ");}else{r={role:"presentation",alt:"",src:u};}e=q.extend(r,e);if(!e.id){e.id=q.sap.uid();}if(j){t=e.alt||e.title||o.text||o.name;v=e.id+"-label";if(e["aria-labelledby"]){l=true;e["aria-labelledby"]+=(" "+v);}else if(!e.hasOwnProperty("aria-label")){e["aria-label"]=t;}}if(typeof e==="object"){for(p in e){if(e.hasOwnProperty(p)&&e[p]!==null){this.writeAttributeEscaped(p,e[p]);}}}if(j){this.write(">");if(l){this.write("<span style=\"display:none;\" id=\""+v+"\">"+t+"</span>");}this.write("</span>");}else{this.write("/>");}return this;};R.prototype.getRenderer=function(C){return R.getRenderer(C);};var a=R.RenderPrefixes={Invisible:"sap-ui-invisible-",Dummy:"sap-ui-dummy-"};R.getRenderer=function(C){return C.getMetadata().getRenderer();};R.forceRepaint=function(v){var o=typeof v=="string"?q.sap.domById(v):v;if(o){q.sap.log.debug("forcing a repaint for "+(o.id||String(o)));var O=o.style.display;var e=document.activeElement;o.style.display="none";o.offsetHeight;o.style.display=O;if(document.activeElement!==e){q.sap.focus(e);}}};R.createInvisiblePlaceholderId=function(e){return a.Invisible+e.getId();};var I="sap-ui-preserve",b="sap-ui-static",A="data-sap-ui-preserve",d="data-sap-ui-area";function g(){var $=q.sap.byId(I);if($.length===0){$=q("<DIV/>",{"aria-hidden":"true",id:I}).addClass("sapUiHidden").addClass("sapUiForcedHidden").css("width","0").css("height","0").css("overflow","hidden").appendTo(document.body);}return $;}function m(n){q("<DIV/>",{id:a.Dummy+n.id}).addClass("sapUiHidden").insertBefore(n);}var P=[];R.attachPreserveContent=function(l,C){R.detachPreserveContent(l);P.push({fn:l,context:C});};R.detachPreserveContent=function(l){P=P.filter(function(o){return o.fn!==l;});};R.preserveContent=function(r,p,e){P.forEach(function(l){l.fn.call(l.context||R,{domNode:r});});var $=g();function j(i){if(i.id===I||i.id===b){return;}if(i.hasAttribute(A)){if(i===r){m(i);}$.append(i);}else if(e&&i.id){R.markPreservableContent(q(i),i.id);$.append(i);return;}if(!i.hasAttribute(d)){var n=i.firstChild;while(n){i=n;n=n.nextSibling;if(i.nodeType===1){j(i);}}}}q.sap.measure.start(r.id+"---preserveContent","preserveContent for "+r.id,["rendering","preserve"]);if(p){j(r);}else{q(r).children().each(function(i,n){j(n);});}q.sap.measure.end(r.id+"---preserveContent");};R.findPreservedContent=function(i){var $=g(),e=$.children("["+A+"='"+i.replace(/(:|\.)/g,'\\$1')+"']");return e;};R.markPreservableContent=function($,i){$.attr(A,i);};R.isPreservedContent=function(o){return(o&&o.getAttribute(A)&&o.parentNode&&o.parentNode.id==I);};R.getPreserveAreaRef=function(){return g()[0];};var f="data-sap-ui-template";R.markInlineTemplate=function($){$.attr(f,"");};R.isInlineTemplate=function(o){return(o&&o.hasAttribute(f));};var D;function h(){if(D===undefined){D=sap.ui.getCore().getConfiguration().getDomPatching();if(D){q.sap.log.warning("DOM Patching is enabled: This feature should be used only for testing purposes!");}}return D;}var k={render:function(r,C){r.write("<span");r.writeInvisiblePlaceholderData(C);r.write("></span>");}};return R;},true);
