/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/base/util/extend','sap/ui/base/EventProvider','sap/ui/base/ManagedObject','sap/ui/core/mvc/ControllerMetadata','sap/ui/core/mvc/ControllerExtension','sap/ui/core/mvc/OverrideExecution'],function(q,e,E,M,C,a,O){"use strict";var r={};var m={};var b=E.extend("sap.ui.core.mvc.Controller",{metadata:{stereotype:"controller",methods:{"byId":{"public":true,"final":true},"getView":{"public":true,"final":true},"getInterface":{"public":false,"final":true},"onInit":{"public":false,"final":false,"overrideExecution":O.After},"onExit":{"public":false,"final":false,"overrideExecution":O.Before},"onBeforeRendering":{"public":false,"final":false,"overrideExecution":O.Before},"onAfterRendering":{"public":false,"final":false,"overrideExecution":O.After}}},constructor:function(n){var t=null;if(typeof(n)=="string"){if(!r[n]){q.sap.log.warning("Do not call sap.ui.core.mvc.Controller constructor for non typed scenario!");}t=r[n];}E.apply(this,arguments);if(t){q.extend(this,r[n]);}if(this.extension){throw new Error("The keyword 'extension' cannot be used as a member of a controller");}this["_sapui_Extensions"]={};b.extendByMember(this,false);this._sapui_isExtended=false;},_isExtended:function(){return this._sapui_isExtended;},getInterface:function(){var i={};var o=this.getMetadata();var p=o.getAllPublicMethods();p.forEach(function(s){var F=this[s];if(typeof F==='function'){i[s]=function(){var t=F.apply(this,arguments);return(t instanceof b)?t.getInterface():t;}.bind(this);}}.bind(this));this.getInterface=q.sap.getter(i);return i;}},C);function c(o,i,l){var n=i.getMetadata().getName();var k=o.getMetadata();var p=o["_sapui_Extensions"];var I=o.getInterface();var L=a.getMetadata().getLifecycleConfiguration();var s={namespace:n,extension:i,reloadNeeded:false};i._setController(I);if(i.getMetadata().hasOverrides()){var t,u,v,w,x=i.getMetadata().getOverrides(),S=i.getMetadata().getStaticOverrides();for(w in S){v=i.getMetadata();if(!v.isMethodFinal(w)){a.overrideMethod(w,i,S,i,v.getOverrideExecution(w));}else{q.sap.log.error("Method '"+w+"' of extension '"+n+"' is flagged final and cannot be overridden by calling 'override'");}}for(w in x){if(w!=='extension'){if(w in i.base){q.sap.log.debug("Overriding  member '"+w+"' of original controller.");var y=x[w];var z=o[w];if(typeof z=="object"&&typeof y=="object"){u=p[w];v=u.extension.getMetadata();for(t in y){if(!v.isMethodFinal(t)){a.overrideMethod(t,z,y,i,v.getOverrideExecution(t));}else{q.sap.log.error("Method '"+t+"' of extension '"+u.namespace+"' is flagged final and cannot be overridden by extension '"+n+"'");}}}else if(!k.isMethodFinal(w)){a.overrideMethod(w,o,x,i,k.getOverrideExecution(w));}else{q.sap.log.error("Method '"+w+"' of controller '"+o.getMetadata().getName()+"' is flagged final and cannot be overridden by extension '"+n+"'");}}else if(w in L){a.overrideMethod(w,o,x,i,k.getOverrideExecution(w));}else{q.sap.log.error("Method '"+t+"' of extension '"+u.namespace+" does not exist in controller "+o.getMetadata().getName()+" and cannot be overridden");}}if(x.extension){for(var A in x.extension){v=p[A].extension.getMetadata();var B=q.sap.getObject(A,null,o.extension);var D=p[A].extension;var F=x.extension[A];for(t in F){if(!v.isMethodFinal(t)){a.overrideMethod(t,B,F,i,v.getOverrideExecution(t));a.overrideMethod(t,D,F,i,v.getOverrideExecution(t));}else{q.sap.log.error("Method '"+t+"' of extension '"+A+"' is flagged final and cannot be overridden by extension '"+n+"'");}}}}s.reloadNeeded=true;}}var G=i.getInterface();if(l){p[l]=s;s.location=l;o[l]=G;I[l]=G;}else{p[n]=s;s.location="extension."+n;q.sap.setObject("extension."+n,G,o);q.sap.setObject("extension."+n,G,I);}}function d(o,i,l){if(i instanceof a){c(o,i,l);}else if(i.getMetadata&&i.getMetadata().getStereotype()=="controllerextension"){var k=new i();c(o,k,l);}else{var L=a.getMetadata().getLifecycleConfiguration();for(var s in i){if(s in L){a.overrideMethod(s,o,i,o,L[s].overrideExecution);}else{a.overrideMethod(s,o,i);}}}}function f(n,A){if(!n){throw new Error("Controller name ('sName' parameter) is required");}var s=n.replace(/\./g,"/"),i=k(sap.ui.require(s));function k(i){if(i){return i;}else if(r[n]){return b;}else{return q.sap.getObject(n);}}s=s+".controller";if(A){return new Promise(function(l,o){if(!i){sap.ui.require([s],function(i){l(k(i));});}else{l(i);}});}else if(!i){i=sap.ui.requireSync(s);return k(i);}else{return i;}}function g(o,A){var p=b._sExtensionProvider.replace(/\./g,"/"),P=m[p];if(A){return new Promise(function(k,l){if(p){if(P){k(P);}else{sap.ui.require([p],function(i){P=new i();m[p]=P;k(P);});}}else{k();}});}else if(p){if(P){return P;}else{var i=sap.ui.requireSync(p);P=new i();m[p]=P;return P;}}}function h(i,n){var o;if(r[n]){o=new i(n);}else{o=new i();}if(!o){throw new Error("Controller "+n+" couldn't be instantiated");}return o;}b.extendByMember=function(o,A){var s;for(s in o){if(o[s]&&o[s].getMetadata&&o[s].getMetadata().getStereotype()=="controllerextension"){o[s]=new o[s]();}}for(s in o){if(o[s]&&o[s].getMetadata&&o[s].getMetadata().getStereotype()=="controllerextension"){d(o,o[s],s);}}if(A){return Promise.resolve(o);}else{return o;}};b.extendByCustomizing=function(o,n,A){var k=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(!k){return A?Promise.resolve(o):o;}function p(y,o){return f(y,A).then(function(s){if((s=r[y])!==undefined){d(o,s);return o;}},function(z){q.sap.log.error("Attempt to load Extension Controller "+y+" was not successful - is the Controller correctly defined in its file?");});}var s,t=[],u,v=A?Promise.resolve(o):o,w=k.getControllerExtension(n,M._sOwnerId);if(w){u=typeof w==="string"?w:w.controllerName;t=w.controllerNames||[];if(u){t.unshift(u);}}for(var i=0,l=t.length;i<l;i++){var x=t[i];if(typeof x==="string"){q.sap.log.info("Customizing: Controller '"+n+"' is now extended by '"+x+"'");if(A){v=v.then(p.bind(null,x,o));}else{if(!r[x]&&!sap.ui.require(x)){f(x);}if((s=r[x])!==undefined){d(o,s);}else{q.sap.log.error("Attempt to load Extension Controller "+x+" was not successful - is the Controller correctly defined in its file?");}}}}return v;};b.extendByProvider=function(o,n,s,A){if(!b._sExtensionProvider){return A?Promise.resolve(o):o;}q.sap.log.info("Customizing: Controller '"+n+"' is now extended by Controller Extension Provider '"+b._sExtensionProvider+"'");var k,p;if(A){return g(o,A).then(function(p){return p.getControllerExtensions(n,s,A);}).then(function(t){if(t&&t.length){for(var i=0,l=t.length;i<l;i++){d(o,t[i]);}}return o;},function(t){q.sap.log.error("Controller Extension Provider: Error '"+t+"' thrown in "+b._sExtensionProvider+"extension provider ignored.");return o;});}else{p=g(o,A);k=p.getControllerExtensions(n,s,A);if(k&&Array.isArray(k)){for(var i=0,l=k.length;i<l;i++){d(o,k[i]);}}else{q.sap.log.error("Controller Extension Provider: Error in ExtensionProvider.getControllerExtensions: "+b._sExtensionProvider+" - no valid extensions returned");}}return o;};b.create=function(o){return j(o.name,undefined,true);};sap.ui.controller=function(n,o,A){if(A){q.sap.log.info("Do not use deprecated factory function 'sap.ui.controller("+n+")'. Use 'sap.ui.core.mvc.Controller.create(...)' instead.");}else{q.sap.log.warning("Do not use synchronous controller creation for controller '"+n+"'! Use the new asynchronous factory 'sap.ui.core.mvc.Controller.create(...)' instead.");}return j.apply(this,arguments);};function j(n,o,A){var i,k,s=M._sOwnerId;if(typeof o==="boolean"){o=undefined;}if(!o){if(A){return f(n,A).then(function(k){return h(k,n);}).then(function(i){return b.extendByCustomizing(i,n,A);}).then(function(i){return b.extendByProvider(i,n,s,A);}).then(function(i){i._sapui_isExtended=true;return i;});}else{k=f(n,A);i=h(k,n);i=b.extendByCustomizing(i,n,A);i=b.extendByProvider(i,n,s,A);i._sapui_isExtended=true;}return i;}else{r[n]=o;q.sap.log.info("For defining controllers use Controller.extend instead");}}b.prototype.getPublicMethods=function(){var p={},o=this.getMetadata(),i=o.getAllMethods(),l=o.getLifecycleConfiguration();Object.keys(i).forEach(function(s){if(o.isMethodPublic(s)){p[s]=i[s];p[s].reloadNeeded=!!(s in l);}});delete p.extension;var k=this["_sapui_Extensions"];Object.keys(k).forEach(function(n){var s=k[n];var t=s.extension.getInterface();var A=s.extension.getMetadata().getAllMethods();Object.keys(t).forEach(function(u){delete p[s.location];var v=q.extend({},A[u],{reloadNeeded:s.reloadNeeded});p[s.location+"."+u]=v;});});return p;};b.prototype.destroy=function(){Object.keys(this["_sapui_Extensions"]).forEach(function(o){q.sap.setObject(o.location,null,this);}.bind(this));delete this["_sapui_Extensions"];delete this["_sapui_Interface"];E.prototype.destroy.apply(this,arguments);};b.prototype.getView=function(){return this.oView;};b.prototype.byId=function(i){return this.oView?this.oView.byId(i):undefined;};b.prototype.createId=function(i){return this.oView?this.oView.createId(i):undefined;};b.prototype.getOwnerComponent=function(){var i=sap.ui.requireSync("sap/ui/core/Component");return i.getOwnerComponentFor(this.getView());};b.prototype.connectToView=function(v){this.oView=v;if(this.onInit){v.attachAfterInit(this.onInit,this);}if(this.onExit){v.attachBeforeExit(this.onExit,this);}if(this.onAfterRendering){v.attachAfterRendering(this.onAfterRendering,this);}if(this.onBeforeRendering){v.attachBeforeRendering(this.onBeforeRendering,this);}};b._sExtensionProvider=null;b.registerExtensionProvider=function(s){b._sExtensionProvider=s;};return b;});
