/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/ManagedObject','sap/ui/core/Control','sap/ui/core/mvc/Controller','sap/base/util/extend','sap/ui/core/library',"./ViewRenderer"],function(q,M,C,a,e,b,V){"use strict";var c=b.mvc.ViewType;var d=C.extend("sap.ui.core.mvc.View",{metadata:{interfaces:["sap.ui.core.IDScope"],library:"sap.ui.core",properties:{width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:'100%'},height:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},viewName:{type:"string",group:"Misc",defaultValue:null},displayBlock:{type:"boolean",group:"Appearance",defaultValue:false}},aggregations:{content:{type:"sap.ui.core.Control",multiple:true,singularName:"content"}},events:{afterInit:{},beforeExit:{},afterRendering:{},beforeRendering:{}},specialSettings:{controller:'sap.ui.core.mvc.Controller',controllerName:'string',preprocessors:'Object',resourceBundleName:'string',resourceBundleUrl:'sap.ui.core.URI',resourceBundleLocale:'string',resourceBundleAlias:'string',type:'string',definition:'any',viewContent:{type:'any',deprecated:true},viewData:'any',async:{type:"boolean",defaultValue:false}}}});d._mPreprocessors={};function f(P){P._settings={};for(var i in P){if(i.indexOf("_")!==0){P._settings[i]=P[i];}}}function g(P,A){var i;if(typeof P.preprocessor==="string"){var j=P.preprocessor.replace(/\./g,"/");if(A){return new Promise(function(l,u){sap.ui.require([j],function(i){l(i);});});}else{return sap.ui.requireSync(j);}}else if(typeof P.preprocessor==="function"&&!P.preprocessor.process){i={process:P.preprocessor};}else{i=P.preprocessor;}if(A){return Promise.resolve(i);}else{return i;}}function h(j,T){var L=this.mPreprocessors[T]||[],G=[],i,l,O,P=[];if(d._mPreprocessors[j]&&d._mPreprocessors[j][T]){G=d._mPreprocessors[j][T].map(function(u){return q.extend({},u);});}for(i=0,l=G.length;i<l;i++){if(G[i]._onDemand){O=G[i];}else{P.push(G[i]);}}for(i=0,l=L.length;i<l;i++){var I=!L[i].preprocessor;if(I&&O){P.unshift(q.extend(L[i],O));}else if(!I){P.push(L[i]);}}return P;}function k(i,S){var j=i.getMetadata().getClass();function l(P){P.preprocessor=g(P,S.async);}i.mPreprocessors=q.extend({},S.preprocessors);for(var _ in j.PreprocessorType){var T=j.PreprocessorType[_];if(i.mPreprocessors[T]&&!Array.isArray(i.mPreprocessors[T])){i.mPreprocessors[T]=[i.mPreprocessors[T]];}else if(!i.mPreprocessors[T]){i.mPreprocessors[T]=[];}i.mPreprocessors[T].forEach(f);i.mPreprocessors[T]=h.call(i,j._sType,T);i.mPreprocessors[T].forEach(l);}}function m(i){i.oAsyncState={};i.oAsyncState.promise=null;}var n=function(T,S){if(!sap.ui.getCore().getConfiguration().getControllerCodeDeactivated()){var i=S.controller,N=i&&typeof i.getMetadata==="function"&&i.getMetadata().getName(),A=S.async;if(!i&&T.getControllerName){var j=T.getControllerName();if(j){var l=sap.ui.require('sap/ui/core/CustomizingConfiguration');var u=l&&l.getControllerReplacement(j,M._sOwnerId);if(u){j=typeof u==="string"?u:u.controllerName;}i=sap.ui.controller(j,true,A);}}else if(i){var O=M._sOwnerId;if(!i._isExtended()){if(A){i=a.extendByCustomizing(i,N,A).then(function(i){return a.extendByProvider(i,N,O,A);});}else{i=a.extendByCustomizing(i,N,A);i=a.extendByProvider(i,N,O,A);}}else if(A){i=Promise.resolve(i);}}if(i){var w=function(i){T.oController=i;i.oView=T;};if(A){if(!T.oAsyncState){throw new Error("The view "+T.sViewName+" runs in sync mode and therefore cannot use async controller extensions!");}return i.then(w);}else{w(i);}}}else{sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl",{"_sap.ui.core.mvc.EmptyControllerImpl":true});T.oController=sap.ui.controller("sap.ui.core.mvc.EmptyControllerImpl");}};d.prototype._initCompositeSupport=function(S){this.oViewData=S.viewData;this.sViewName=S.viewName;var i=this;k(this,S);if(S.async){m(this);}var j=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(j&&j.hasCustomProperties(this.sViewName,this)){this._fnSettingsPreprocessor=function(S){var I=this.getId();if(j&&I){if(i.isPrefixedId(I)){I=I.substring((i.getId()+"--").length);}var l=j.getCustomProperties(i.sViewName,I,i);if(l){S=q.extend(S,l);}}};}var P=function(l,u){var w=sap.ui.require("sap/ui/core/Component");var O=w&&w.getOwnerComponentFor(i);if(O){if(u){i.fnScopedRunWithOwner=i.fnScopedRunWithOwner||function(x){return O.runAsOwner(x);};}return O.runAsOwner(l);}return l();};var A=function(l){if(l.oController&&l.oController.connectToView){return l.oController.connectToView(l);}};var F=function(){if(i.onControllerConnected){return i.onControllerConnected(i.oController);}};if(this.initViewSettings){if(S.async){this.oAsyncState.promise=this.initViewSettings(S).then(function(){return P(n.bind(null,i,S),true);}).then(function(){return P(F,true);}).then(function(){return A(i);}).then(function(){return i.runPreprocessor("controls",i,false);}).then(function(){return P(i.fireAfterInit.bind(i),true);}).then(function(){return i;});}else{this.initViewSettings(S);n(this,S);F();A(this);this.runPreprocessor("controls",this,true);this.fireAfterInit();}}};d.prototype.getController=function(){return this.oController;};d.prototype.byId=function(i){return sap.ui.getCore().byId(this.createId(i));};d.prototype.createId=function(i){if(!this.isPrefixedId(i)){i=this.getId()+"--"+i;}return i;};d.prototype.getLocalId=function(i){var P=this.getId()+"--";return(i&&i.indexOf(P)===0)?i.slice(P.length):null;};d.prototype.isPrefixedId=function(i){return!!(i&&i.indexOf(this.getId()+"--")===0);};d.prototype.getViewData=function(){return this.oViewData;};function o(){this.oAsyncState=null;}d.prototype.exit=function(){this.fireBeforeExit();delete this.oController;delete this.oPreprocessorInfo;if(this.oAsyncState){var D=o.bind(this);this.oAsyncState.promise.then(D,D);}};d.prototype.onAfterRendering=function(){this.fireAfterRendering();};d.prototype.onBeforeRendering=function(){this.fireBeforeRendering();};d.prototype.clone=function(i,l){var S={},K,u;for(K in this.mProperties&&!(this.isBound&&this.isBound(K))){if(this.mProperties.hasOwnProperty(K)){S[K]=this.mProperties[K];}}u=C.prototype.clone.call(this,i,l,{cloneChildren:false,cloneBindings:true});var E,w,j;for(E in u.mEventRegistry){w=u.mEventRegistry[E];for(j=w.length-1;j>=0;j--){if(w[j].oListener===this.getController()){w[j]={oListener:u.getController(),fFunction:w[j].fFunction,oData:w[j].oData};}}}u.applySettings(S);return u;};d.prototype.getPreprocessors=function(){return this.mPreprocessors;};d.prototype.getPreprocessorInfo=function(S){if(!this.oPreprocessorInfo){this.oPreprocessorInfo={name:this.sViewName,componentId:this._sOwnerId,id:this.getId(),caller:this+" ("+this.sViewName+")",sync:!!S};}if(d._supportInfo){this.oPreprocessorInfo._supportInfo=d._supportInfo;}return this.oPreprocessorInfo;};d.prototype.runPreprocessor=function(T,S,j){var u=this.getPreprocessorInfo(j),P=this.mPreprocessors&&this.mPreprocessors[T]||[],w,A,x;if(!j){A=function(u,y){return function(S){return y.preprocessor.then(function(z){return z.process(S,u,y._settings);});};};x=Promise.resolve(S);}for(var i=0,l=P.length;i<l;i++){if(j&&P[i]._syncSupport===true){w=P[i].preprocessor.process;S=w(S,u,P[i]._settings);}else if(!j){x=x.then(A(u,P[i]));}else{q.sap.log.debug("Async \""+T+"\"-preprocessor was skipped in sync view execution for "+this.getMetadata().getClass()._sType+"View",this.getId());}}return j?S:x;};function p(T,i){if(!d._mPreprocessors[i]){d._mPreprocessors[i]={};}if(!d._mPreprocessors[i][T]){d._mPreprocessors[i][T]=[];}}function r(i,j,T){d._mPreprocessors[j][T].forEach(function(P){if(P._onDemand){q.sap.log.error("Registration for \""+T+"\" failed, only one on-demand-preprocessor allowed",i.getMetadata().getName());return false;}});return true;}d.registerPreprocessor=function(T,P,i,S,O,j){if(typeof O!=="boolean"){j=O;O=false;}if(P){p(T,i);if(O&&!r(this,i,T)){return;}d._mPreprocessors[i][T].push({preprocessor:P,_onDemand:O,_syncSupport:S,_settings:j});q.sap.log.debug("Registered "+(O?"on-demand-":"")+"preprocessor for \""+T+"\""+(S?" with syncSupport":""),this.getMetadata().getName());}else{q.sap.log.error("Registration for \""+T+"\" failed, no preprocessor specified",this.getMetadata().getName());}};d.prototype.hasPreprocessor=function(T){return!!this.mPreprocessors[T].length;};d.create=function(O){var P=e(true,{},O);P.async=true;P.viewContent=P.definition;var i=sap.ui.require("sap/ui/core/Component");var j;if(i&&M._sOwnerId){j=i.get(M._sOwnerId);}function t(){return v(P.id,P,P.type).loaded();}return new Promise(function(l,u){var w=s(P);sap.ui.require([w],function(x){l(x);},function(E){u(E);});}).then(function(l){if(j){return j.runAsOwner(t);}else{return t();}});};sap.ui.view=function(i,j,T){if(j&&j.async){q.sap.log.info("Do not use deprecated factory function 'sap.ui.view'. Use 'sap.ui.mvc.View.create' instead");}else{q.sap.log.warning("Do not use synchronous view creation! Use the new asynchronous factory 'sap.ui.mvc.View.create' instead");}return v(i,j,T);};function v(i,j,T){var l=null,u={};if(typeof i==="object"||typeof i==="string"&&j===undefined){j=i;i=undefined;}if(j){if(typeof j==="string"){u.viewName=j;}else{u=j;}}if(i){u.id=i;}if(T){u.type=T;}var w=sap.ui.require('sap/ui/core/CustomizingConfiguration');if(w){var x=w.getViewReplacement(u.viewName,M._sOwnerId);if(x){q.sap.log.info("Customizing: View replacement for view '"+u.viewName+"' found and applied: "+x.viewName+" (type: "+x.type+")");q.extend(u,x);}else{q.sap.log.debug("Customizing: no View replacement found for view '"+u.viewName+"'.");}}var y=s(u);l=t(y,u);return l;}function s(i){var j;if(!i.type){throw new Error("No view type specified.");}else if(i.type===c.JS){j='sap/ui/core/mvc/JSView';}else if(i.type===c.JSON){j='sap/ui/core/mvc/JSONView';}else if(i.type===c.XML){j='sap/ui/core/mvc/XMLView';}else if(i.type===c.HTML){j='sap/ui/core/mvc/HTMLView';}else if(i.type===c.Template){j='sap/ui/core/mvc/TemplateView';}else{throw new Error("Unknown view type "+i.type+" specified.");}return j;}function t(i,j){var l=sap.ui.require(i);if(!l){l=sap.ui.requireSync(i);if(j.async){q.sap.log.warning("sap.ui.view was called without requiring the according view class.");}}return new l(j);}d.prototype.loaded=function(){if(this.oAsyncState&&this.oAsyncState.promise){return this.oAsyncState.promise;}else{return Promise.resolve(this);}};return d;});
