/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','./View',"./XMLViewRenderer","sap/base/util/extend",'sap/ui/base/ManagedObject','sap/ui/core/XMLTemplateProcessor','sap/ui/core/library','sap/ui/core/Control','sap/ui/core/RenderManager','sap/ui/core/cache/CacheManager','sap/ui/model/resource/ResourceModel','jquery.sap.xml','jquery.sap.script'],function(q,V,X,a,M,b,l,C,R,c,d){"use strict";var f=R.RenderPrefixes,g=l.mvc.ViewType,x="XMLViewCacheError",n={};var h=V.extend("sap.ui.core.mvc.XMLView",{metadata:{library:"sap.ui.core",specialSettings:{containingView:{type:'sap.ui.core.mvc.XMLView',visibility:'hidden'},xmlNode:{type:'Element',visibility:'hidden'},cache:'Object',processingMode:{type:"string",defaultValue:"",visibility:"hidden"}},designtime:"sap/ui/core/designtime/mvc/XMLView.designtime"}});sap.ui.xmlview=function(i,e){return sap.ui.view(i,e,g.XML);};h.create=function(o){var P=a(true,{},o);P.viewContent=P.definition;P.async=true;P.type=g.XML;P.processingMode=P.processingMode||"sequential";return V.create(P);};h._sType=g.XML;h.asyncSupport=true;h._bUseCache=sap.ui.getCore().getConfiguration().getViewCache()&&c._isSupportedEnvironment();function v(e){if(e.parseError.errorCode!==0){var P=e.parseError;throw new Error("The following problem occurred: XML parse Error for "+P.url+" code: "+P.errorCode+" reason: "+P.reason+" src: "+P.srcText+" line: "+P.line+" linepos: "+P.linepos+" filepos: "+P.filepos);}}function j(o,S){if(!S){throw new Error("mSettings must be given");}else if(S.viewName&&S.viewContent){throw new Error("View name and view content are given. There is no point in doing this, so please decide.");}else if((S.viewName||S.viewContent)&&S.xmlNode){throw new Error("View name/content AND an XML node are given. There is no point in doing this, so please decide.");}else if(!(S.viewName||S.viewContent)&&!S.xmlNode){throw new Error("Neither view name/content nor an XML node is given. One of them is required.");}else if(S.cache&&!(S.cache.keys&&S.cache.keys.length)){throw new Error("No cache keys provided. At least one is required.");}}function k(o,S){o.mProperties["viewContent"]=S.viewContent;var e=q.sap.parseXML(S.viewContent);v(e);return e.documentElement;}function s(o,S){if((o._resourceBundleName||o._resourceBundleUrl)&&(!S.models||!S.models[o._resourceBundleAlias])){var e=new d({bundleName:o._resourceBundleName,bundleUrl:o._resourceBundleUrl,bundleLocale:o._resourceBundleLocale});o.setModel(e,o._resourceBundleAlias);}}function m(o){o.oAfterRenderingNotifier=new D();o.oAfterRenderingNotifier.addDelegate({onAfterRendering:function(){o.onAfterRenderingBeforeChildren();}});}function p(S){var e=sap.ui.require("sap/ui/core/Component"),o;while(S&&e){var i=e.getOwnerComponentFor(S);if(i){S=o=i;}else{if(S instanceof e){o=S;}S=S.getParent&&S.getParent();}}return o;}function r(o,e){var i=p(o),E=i?JSON.stringify(i.getManifest()):null,F=[];F=F.concat(w(o,i),z(),y(o),e.keys);return u(o,F).then(function(K){return{key:K+"("+q.sap.hashCode(E||"")+")",componentManifest:E,additionalData:e.additionalData};});}function t(K){return K;}function u(o,F){return Promise.all(F).then(function(K){K=K.filter(function(E){return E!==n;});if(K.every(t)){return K.join('_');}else{var e=new Error("Provided cache keys may not be empty or undefined.");e.name=x;return Promise.reject(e);}});}function w(o,e){var i=e&&e.getMetadata().getName();return[i||window.location.host+window.location.pathname,o.getId(),sap.ui.getCore().getConfiguration().getLanguageTag()];}function y(e){var P=e.getPreprocessors(),i=e.getPreprocessorInfo(false),F=[];function E(o){F.push(o.preprocessor.then(function(G){if(G.getCacheKey){return G.getCacheKey(i);}else{return n;}}));}for(var T in P){P[T].forEach(E);}return F;}function z(){return sap.ui.getVersionInfo({async:true}).then(function(i){var T="";if(!i.libraries){T=sap.ui.buildinfo.buildtime;}else{i.libraries.forEach(function(L){T+=L.buildTimestamp;});}return T;}).catch(function(e){q.sap.log.warning("sap.ui.getVersionInfo could not be retrieved","sap.ui.core.mvc.XMLView");q.sap.log.debug(e);return"";});}function A(e,i){var K=e.key;delete e.key;e.xml=q.sap.serializeXML(i);return c.set(K,e);}function B(e){return c.get(e.key).then(function(i){if(i&&i.componentManifest==e.componentManifest){i.xml=q.sap.parseXML(i.xml,"application/xml").documentElement;if(i.additionalData){q.extend(true,e.additionalData,i.additionalData);}return i;}});}h.prototype.initViewSettings=function(S){var e=this,_;function i(J){e._xContent=J;if(V._supportInfo){V._supportInfo({context:e._xContent,env:{caller:"view",viewinfo:q.extend(true,{},e),settings:q.extend(true,{},S||{}),type:"xmlview"}});}if(!e.isSubView()){var K={};b.parseViewAttributes(J,e,K);if(!S.async){q.sap.extend(S,K);}else{e.applySettings(K);}}else{delete S.controller;}s(e,S);m(e);}function o(J,K){if(e.hasPreprocessor("viewxml")){return b.enrichTemplateIdsPromise(J,e,K).then(function(){return e.runPreprocessor("viewxml",J,!K);});}return J;}function E(J){return e.runPreprocessor("xml",J).then(function(J){return o(J,true);});}function F(I){return q.sap.loadResource(I,{async:true}).then(function(J){return J.documentElement;});}function G(I,J){return F(I).then(E).then(function(K){if(J){A(J,K);}return K;});}function H(I,J){return r(e,J).then(function(K){return B(K).then(function(L){if(!L){return G(I,K);}else{return L.xml;}});}).catch(function(K){if(K.name===x){q.sap.log.debug(K.message,K.name,"sap.ui.core.mvc.XMLView");q.sap.log.debug("Processing the View without caching.","sap.ui.core.mvc.XMLView");return G(I);}else{return Promise.reject(K);}});}this._oContainingView=S.containingView||this;this._sProcessingMode=S.processingMode;if(this.oAsyncState){this.oAsyncState.suppressPreserve=true;}j(this,S);if(S.viewName){var I=q.sap.getResourceName(S.viewName,".view.xml");if(S.async){if(S.cache&&h._bUseCache){return H(I,S.cache).then(i);}else{return F(I).then(E).then(i);}}else{_=q.sap.loadResource(I).documentElement;}}else if(S.viewContent){if(S.viewContent.nodeType===window.Node.DOCUMENT_NODE){_=S.viewContent.documentElement;}else{_=k(this,S);}}else if(S.xmlNode){_=S.xmlNode;}if(S.async){return E(_).then(i);}else{_=this.runPreprocessor("xml",_,true);_=o(_,false);if(_&&typeof _.then==='function'){if(_.isRejected()){throw _.getResult();}_=_.getResult();}i(_);}};h.prototype.exit=function(){if(this.oAfterRenderingNotifier){this.oAfterRenderingNotifier.destroy();}V.prototype.exit.apply(this,arguments);};h.prototype.onControllerConnected=function(o){var e=this;function i(E){return M.runWithPreprocessors(E,{settings:e._fnSettingsPreprocessor});}if(!this.oAsyncState){this._aParsedContent=i(b.parseTemplate.bind(null,this._xContent,this));}else{return b.parseTemplatePromise(this._xContent,this,true,{fnRunWithPreprocessor:i}).then(function(P){e._aParsedContent=P;delete e.oAsyncState.suppressPreserve;});}};h.prototype.getControllerName=function(){return this._controllerName;};h.prototype.isSubView=function(){return this._oContainingView!=this;};h.prototype.onAfterRenderingBeforeChildren=function(){if(this._$oldContent.length!==0){var e=this.getAggregation("content");if(e){for(var i=0;i<e.length;i++){var o=e[i].getDomRef()||q.sap.domById(f.Invisible+e[i].getId());if(o){q.sap.byId(f.Dummy+e[i].getId(),this._$oldContent).replaceWith(o);}}}q.sap.byId(f.Dummy+this.getId()).replaceWith(this._$oldContent);}this._$oldContent=undefined;};h.prototype._onChildRerenderedEmpty=function(o,e){q(e).replaceWith('<div id="'+f.Dummy+o.getId()+'" class="sapUiHidden"/>');return true;};h.prototype.destroy=function(S){var $=R.findPreservedContent(this.getId());if($){$.remove();}if(S=="KeepDom"&&this.getDomRef()){this.getDomRef().removeAttribute("data-sap-ui-preserve");}V.prototype.destroy.call(this,S);};h.registerPreprocessor=function(T,P,S,o,e){T=T.toUpperCase();if(h.PreprocessorType[T]){V.registerPreprocessor(h.PreprocessorType[T],P,this.getMetadata().getClass()._sType,S,o,e);}else{q.sap.log.error("Preprocessor could not be registered due to unknown sType \""+T+"\"",this.getMetadata().getName());}};h.PreprocessorType={XML:"xml",VIEWXML:"viewxml",CONTROLS:"controls"};var D=C.extend("sap.ui.core.mvc.XMLAfterRenderingNotifier",{metadata:{library:"sap.ui.core"},renderer:function(o,e){o.write("");}});h.registerPreprocessor("xml","sap.ui.core.util.XMLPreprocessor",true,true);return h;});
