/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["sap/ui/core/EventBus","sap/base/util/equal","sap/base/util/includes","sap/base/util/isPlainObject","sap/base/util/isWindow","sap/base/Log"],function(E,e,i,a,b,L){"use strict";var I;var s='______UI5______';var P=E.extend("sap.ui.core.postmessage.Bus",{constructor:function(){if(I){return I;}I=this;E.apply(this,arguments);this._aAcceptedOrigins=[window.location.origin];this._aDeclinedOrigins=[];this._oPendingProcess=null;this._aEventQueue=[];this._receiver=this._receiver.bind(this);window.addEventListener('message',this._receiver);}});P.event={CONNECT:'______CONNECT______',READY:'______READY______',ACCEPTED:'______ACCEPTED______',DECLINED:'______DECLINED______'};P.prototype.destroy=function(){window.removeEventListener('message',this._receiver);this._aEventQueue=[];E.prototype.destroy.apply(this,arguments);I=undefined;this.bIsDestroyed=true;};P.getInstance=function(){if(!I){I=new P();}return I;};P.prototype.publish=function(p){var t=p.target;var o=p.origin;var c=p.channelId;var d=p.eventId;var D=p.data;if(d===P.event.READY){if(!t){if(window.opener&&window.opener!==window){t=window.opener;}else if(window.parent!==window){t=window.parent;}else{return;}}if(!o){o='*';}}if(!b(t)||t===window){throw TypeError("Target must be a window object and has to differ from current window");}if(typeof o!=="string"){throw TypeError("Origin must be a string");}if(typeof c!=="string"){throw TypeError("ChannelId must be a string");}if(typeof d!=="string"){throw TypeError("EventId must be a string");}if(!i([P.event.READY,P.event.ACCEPTED,P.event.DECLINED],d)&&o!=='*'&&!i(this._aAcceptedOrigins,o)){this._aAcceptedOrigins.push(o);}var m={origin:o,channelId:c,eventId:d,data:D};m[s]=true;t.postMessage(m,o);};P.prototype._callListener=function(c,l,C,d,D){c.call(l,D);};P.prototype._getText=function(k,p){return sap.ui.getCore().getLibraryResourceBundle().getText(k,p);};P.prototype._receiver=function(o){var d=o.data;if(!a(d)||!d.hasOwnProperty(s)){return;}if(this._oPendingProcess){this._aEventQueue.push(o);}else{this._oPendingProcess=this._processEvent(o);}};P.prototype._processEvent=function(o){return new Promise(function(r){var d=o.data;var O=o.origin;if(i(this._aDeclinedOrigins,O)){r();return;}switch(d.eventId){case P.event.CONNECT:{if(typeof d.data!=="string"){this.publish({target:o.source,origin:o.origin,channelId:d.channelId,eventId:P.event.DECLINED});r();}else if(i(this._aAcceptedOrigins,O)){this.publish({target:o.source,origin:o.origin,channelId:d.channelId,eventId:P.event.ACCEPTED});r();}else{sap.ui.require(["sap/ui/core/postmessage/confirmationDialog"],function(c){c(this._getText('PostMessage.Message',[d.data,O])).then(function(){this.addAcceptedOrigin(O);this.publish({target:o.source,origin:o.origin,channelId:d.channelId,eventId:P.event.ACCEPTED});}.bind(this),function(){this.addDeclinedOrigin(O);this.publish({target:o.source,origin:o.origin,channelId:d.channelId,eventId:P.event.DECLINED});}.bind(this)).then(r);}.bind(this));}break;}case P.event.ACCEPTED:case P.event.DECLINED:case P.event.READY:{o.data.data=undefined;this._emitMessage(o);r();break;}default:{if(i(this._aAcceptedOrigins,O)){this._emitMessage(o);}r();}}}.bind(this)).catch(function(v){var m;var d;if(typeof v==='string'){m=v;}else if(v instanceof Error){m=v.message;d=v.stack;}else{m='Some unexpected error happened during post message processing';}L.error(m,d,'sap.ui.core.postmessage.Bus');}).then(function(){this._oPendingProcess=(this._aEventQueue.length>0?this._processEvent(this._aEventQueue.shift()):null);}.bind(this));};P.prototype._emitMessage=function(o){var c=o.data.channelId;var d=o.data.eventId;E.prototype.publish.call(this,c,d,{originalEvent:o,channelId:c,eventId:d,source:o.source,origin:o.origin,data:o.data.data});};P.prototype.getAcceptedOrigins=function(){return this._aAcceptedOrigins.slice();};P.prototype.setAcceptedOrigins=function(o){if(!Array.isArray(o)){throw new TypeError('Expected an array, but got '+typeof o);}this._aAcceptedOrigins=o.slice();};P.prototype.addAcceptedOrigin=function(o){if(typeof o!=='string'){throw new TypeError('Expected a string, but got '+typeof o);}if(!i(this._aAcceptedOrigins,o)){this._aAcceptedOrigins.push(o);}};P.prototype.resetAcceptedOrigins=function(){this.setAcceptedOrigins([]);};P.prototype.getDeclinedOrigins=function(){return this._aDeclinedOrigins.slice();};P.prototype.setDeclinedOrigins=function(o){if(!Array.isArray(o)){throw new TypeError('Expected an array, but got '+typeof o);}this._aDeclinedOrigins=o.slice();};P.prototype.addDeclinedOrigin=function(o){if(typeof o!=='string'){throw new TypeError('Expected a string, but got '+typeof o);}if(!i(this._aDeclinedOrigins,o)){this._aDeclinedOrigins.push(o);}};P.prototype.resetDeclinedOrigins=function(){this.setDeclinedOrigins([]);};return P;});
