/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','sap/ui/core/DeclarativeSupport','sap/ui/core/library','sap/ui/core/UIArea','./DOMElement','./Template',"./TemplateControlRenderer"],function(q,C,D,l,U,a,T,b){"use strict";var c=C.extend("sap.ui.core.tmpl.TemplateControl",{metadata:{library:"sap.ui.core",properties:{context:{type:"object",group:"Data",defaultValue:null}},aggregations:{controls:{type:"sap.ui.core.Control",multiple:true,singularName:"control",visibility:"hidden"}},associations:{template:{type:"sap.ui.core.tmpl.Template",multiple:false}},events:{afterRendering:{},beforeRendering:{}}}});c.prototype.init=function(){this._aBindingInfos=[];};c.prototype.isInline=function(){var i=false,p=this.getParent();if(p instanceof U&&q(p.getRootNode()).attr("id")===this.getId()){i=true;}return i;};c.prototype.placeAt=function(r,p){var i=this.isInline();var $=this.$(),u=this.getUIArea();C.prototype.placeAt.apply(this,arguments);if(i&&$.length===1){$.remove();u.destroyContent();}};c.prototype.getTemplateRenderer=function(){return this.fnRenderer;};c.prototype.setTemplateRenderer=function(r){this.fnRenderer=r;return this;};c.prototype._cleanup=function(){this.destroyAggregation("controls");this._aBindingInfos.forEach(function(B){var o=B.binding;if(o){o.detachChange(B.changeHandler);o.destroy();}});this._aBindingInfos=[];};c.prototype._compile=function(){var t=sap.ui.getCore().byId(this.getTemplate()),d=t&&t.getDeclarativeSupport();if(d){var e=this;setTimeout(function(){D.compile(e.getDomRef());});}};c.prototype.exit=function(){this._cleanup();};c.prototype.onBeforeRendering=function(){this.fireBeforeRendering();this._cleanup();};c.prototype.onAfterRendering=function(){this.fireAfterRendering();};c.prototype.clone=function(){var o=C.prototype.clone.apply(this,arguments);o.fnRenderer=this.fnRenderer;return o;};c.prototype.updateBindings=function(u,m){C.prototype.updateBindings.apply(this,arguments);if(this.getDomRef()){this.invalidate();}};c.prototype.bind=function(p,t){var P=T.parsePath(p),m=this.getModel(P.model),p=P.path,M=t?"bind"+q.sap.charToUpperCase(t):"bindProperty",B=m&&m[M](p),o={binding:B,path:P.path,model:P.model};if(B){o.changeHandler=function(){q.sap.log.debug("TemplateControl#"+this.getId()+": "+t+" binding changed for path \""+p+"\"");this.invalidate();}.bind(this);B.attachChange(o.changeHandler);}this._aBindingInfos.push(o);return B;};c.prototype.calculatePath=function(p,t){var B=this.getBindingContext(),s=B&&B.getPath();if(p&&s&&!q.sap.startsWith(p,"/")){if(!q.sap.endsWith(s,"/")){s+="/";}p=s+p;}return p;};c.prototype.bindProp=function(p){var B=this.bind(this.calculatePath(p),"property");return B&&B.getExternalValue();};c.prototype.bindList=function(p){var B=this.bind(this.calculatePath(p),"list"),m=B&&B.getModel(),p=B&&B.getPath();return B&&m.getProperty(p);};c.prototype.createDOMElement=function(s,p,d){var e=new a(s);if(p){e.bindObject(p);}if(!d){this.addAggregation("controls",e);}return e;};c.prototype.createControl=function(s,p,d,v){var h={};q.each(s,function(k,V){h["data-"+q.sap.hyphen(k)]=V;});var $=q("<div/>",h);var o=D._createControl($.get(0),v);if(p){o.bindObject(p);}if(!d){this.addAggregation("controls",o);}return o;};return c;});
