/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/base/ManagedObject','sap/ui/dt/ElementOverlay','sap/ui/dt/AggregationOverlay','sap/ui/dt/OverlayRegistry','sap/ui/dt/SelectionManager','sap/ui/dt/ElementDesignTimeMetadata','sap/ui/dt/AggregationDesignTimeMetadata','sap/ui/dt/ElementUtil','sap/ui/dt/Overlay','sap/ui/dt/OverlayUtil','sap/ui/dt/MetadataPropagationUtil','sap/ui/dt/Util','sap/ui/dt/TaskManager','./library'],function(M,E,A,O,S,a,b,c,d,e,f,U,T){"use strict";var D=M.extend("sap.ui.dt.DesignTime",{metadata:{library:"sap.ui.dt",properties:{selectionMode:{type:"sap.ui.dt.SelectionMode",defaultValue:sap.ui.dt.SelectionMode.Single},designTimeMetadata:{type:"object"},enabled:{type:"boolean",defaultValue:true},scope:{type:"string",defaultValue:"default"}},associations:{rootElements:{type:"sap.ui.core.Element",multiple:true}},aggregations:{plugins:{type:"sap.ui.dt.Plugin",multiple:true}},events:{addRootElement:{parameters:{element:{type:"sap.ui.core.Element"}}},enabledChanged:{parameters:{value:{type:"boolean"}}},elementOverlayCreated:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},elementOverlayDestroyed:{parameters:{elementOverlay:{type:"sap.ui.dt.ElementOverlay"}}},selectionChange:{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},syncing:{},synced:{},syncFailed:{}}},constructor:function(){this._mPendingOverlays={};this._oTaskManager=new T({complete:function(o){if(o.getSource().isEmpty()){this._registerElementOverlaysInPlugins();this.fireSynced();}}.bind(this),add:function(o){if(o.getSource().count()===1){this.fireSyncing();}}.bind(this)});this._onElementOverlayDestroyed=this._onElementOverlayDestroyed.bind(this);M.apply(this,arguments);this.getRootElements().forEach(this._createOverlaysForRootElement,this);this.attachEvent("addRootElement",function(o){this._createOverlaysForRootElement(o.getParameter('element'));},this);this.attachEvent("enabledChanged",function(o){var v=o.getParameter('value');var $=d.getOverlayContainer();$[v?'show':'hide']();this.getRootElements().forEach(function(r){var R=O.getOverlay(r);R.setVisible(v);if(v){R.applyStyles();}});},this);}});D.prototype.init=function(){this._oSelectionManager=this._createSelectionManager();this._oSelectionManager.attachEvent("change",function(o){this.fireSelectionChange({selection:o.getParameter("selection")});},this);this._collectOverlaysDuringSyncing();};D.prototype._collectOverlaysDuringSyncing=function(){this._aOverlaysCreatedInLastBatch=[];this.attachElementOverlayCreated(function(o){var n=o.getParameter("elementOverlay");this._aOverlaysCreatedInLastBatch.push(n);}.bind(this));this.attachElementOverlayDestroyed(this._onOverlayDestroyedDuringSyncing,this);};D.prototype._onOverlayDestroyedDuringSyncing=function(o){var g=o.getParameter("elementOverlay");var i=this._aOverlaysCreatedInLastBatch.indexOf(g);if(i!==-1){this._aOverlaysCreatedInLastBatch.splice(i,1);}};D.prototype._registerElementOverlaysInPlugins=function(){var p=this.getPlugins();this._aOverlaysCreatedInLastBatch.forEach(function(o){p.forEach(function(P){P.callElementOverlayRegistrationMethods(o);});});this._aOverlaysCreatedInLastBatch=[];};D.prototype.exit=function(){this.detachElementOverlayDestroyed(this._onOverlayDestroyedDuringSyncing,this);this._oTaskManager.destroy();this.getPlugins().forEach(function(p){p.destroy();});this._destroyAllOverlays();this._oSelectionManager.destroy();delete this._aOverlaysCreatedInLastBatch;};D.prototype._createSelectionManager=function(){return new S();};D.prototype.getSelection=function(){return this.getSelectionManager().get();};D.prototype.getSelectionManager=function(){return this._oSelectionManager;};D.prototype.setSelectionMode=function(m){this.setProperty("selectionMode",m);return this;};D.prototype.getPlugins=function(){return this.getAggregation("plugins")||[];};D.prototype.addPlugin=function(p){p.setDesignTime(this);this.addAggregation("plugins",p);return this;};D.prototype.insertPlugin=function(p,i){p.setDesignTime(this);this.insertAggregation("plugins",p,i);return this;};D.prototype.removePlugin=function(p){this.getPlugins().forEach(function(C){if(C===p){p.setDesignTime(null);return;}});this.removeAggregation("plugins",p);return this;};D.prototype.removeAllPlugins=function(){this.getPlugins().forEach(function(p){p.setDesignTime(null);});this.removeAllAggregation("plugins");return this;};D.prototype.getRootElements=function(){return(this.getAssociation("rootElements")||[]).map(function(s){return c.getElementInstance(s);});};D.prototype.getDesignTimeMetadataFor=function(o){var C;if(typeof o==='string'){C=o;jQuery.sap.log.error('sap.ui.dt.DesignTime#getDesignTimeMetadataFor / Function getDesignTimeMetadataFor() should be called with element instance');}else{C=o.getMetadata().getName();}return(this.getDesignTimeMetadata()||{})[C];};D.prototype.addRootElement=function(r){this.addAssociation("rootElements",r);this.fireAddRootElement({element:r});};D.prototype._createOverlaysForRootElement=function(r){var t=this._oTaskManager.add({type:'createOverlay',element:r,root:true});this.createOverlay({element:c.getElementInstance(r),root:true,visible:this.getEnabled()}).then(function(o){d.getOverlayContainer().append(o.render());o.applyStyles();this._oTaskManager.complete(t);return o;}.bind(this),function(){jQuery.sap.log.error('sap.ui.dt: root element with id = "'+r.getId()+'" initialization is failed');this._oTaskManager.cancel(t);}.bind(this));};D.prototype.removeRootElement=function(r){this.removeAssociation("rootElements",r);this._destroyOverlaysForElement(c.getElementInstance(r));return this;};D.prototype.removeAllRootElement=function(){this.removeAssociation("rootElements");this._destroyAllOverlays();return this;};D.prototype.getElementOverlays=function(){var g=[];this._iterateRootElements(function(r){g=g.concat(this._getAllElementOverlaysIn(r));},this);return g;};D.prototype.createOverlay=function(v){var p=jQuery.extend({},jQuery.isPlainObject(v)?v:{element:v});var t=this._oTaskManager.add({type:'createOverlay'});if(!p.element||p.element.bIsDestroyed||!c.isElementValid(p.element)){this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","can't create overlay without element"));}else{var s=p.element.getId();var o=O.getOverlay(s);if(o){this._oTaskManager.complete(t);return Promise.resolve(o);}else if(s in this._mPendingOverlays){this._oTaskManager.complete(t);return this._mPendingOverlays[s];}else{if(typeof p.root==="undefined"&&!c.getParent(p.element)){p.root=true;}this._mPendingOverlays[s]=this._createElementOverlay(p).then(function(o){return this._createChildren(o,p.parentMetadata).then(function(){delete this._mPendingOverlays[s];if(this.bIsDestroyed){o.detachEvent('destroyed',this._onElementOverlayDestroyed);o.destroy();this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating overlay, DesignTime instance has been destroyed"));}else if(o.bIsDestroyed){this._oTaskManager.cancel(t);return Promise.reject(U.createError("DesignTime#createOverlay","while creating children overlays, its parent overlay has been destroyed"));}else{O.register(o);o.attachBeforeDestroy(function(g){O.deregister(g.getSource());});this.fireElementOverlayCreated({elementOverlay:o});this._oTaskManager.complete(t);return o;}}.bind(this));}.bind(this),function(g){throw g;}).catch(function(g){var h=U.propagateError(g,'DesignTime#createOverlay',U.printf("Failed attempt to create overlay for '{0}'",s));delete this._mPendingOverlays[s];this.fireSyncFailed({error:h});this._oTaskManager.cancel(t);return Promise.reject(h);}.bind(this));return this._mPendingOverlays[s];}}};D.prototype._createElementOverlay=function(p){var o=p.element;return new Promise(function(r,R){new E({element:o,isRoot:p.root,visible:typeof p.visible!=="boolean"||p.visible,metadataScope:this.getScope(),designTimeMetadata:(this.getDesignTimeMetadataFor(o)instanceof a?this.getDesignTimeMetadataFor(o):U.curry(function(m,P,o,g){g=jQuery.sap.extend(true,{},g,m);this._mMetadataOriginal=g;if(P){g=f.propagateMetadataToElementOverlay(g,P,o);}return g;})(this.getDesignTimeMetadataFor(o),p.parentMetadata,o)),init:function(g){r(g.getSource());},initFailed:function(s,g){var h=g.getSource();var i=U.propagateError(g.getParameter('error'),'DesignTime#_createElementOverlay',U.printf("Can't create overlay properly (id='{0}') for '{1}'",h.getId(),s));h.detachEvent('destroyed',this._onElementOverlayDestroyed);h.detachEvent('elementDestroyed',this._onElementDestroyed);h.destroy();R(i);}.bind(this,o.getId()),destroyed:this._onElementOverlayDestroyed,elementDestroyed:this._onElementDestroyed.bind(this),selectionChange:this._onElementOverlaySelectionChange.bind(this),elementModified:this._onElementModified.bind(this)});}.bind(this));};D.prototype._createChildren=function(o,p){return Promise.all(o.getAggregationNames().map(function(s){var g=o.getElement();var m=f.propagateMetadataToAggregationOverlay(o.getDesignTimeMetadata().getAggregation(s),g,p);var h=new A({aggregationName:s,element:g,designTimeMetadata:new b({data:m}),beforeDestroy:function(i){O.deregister(i.getSource());},destroyed:this._onAggregationOverlayDestroyed});O.register(h);return Promise.all(c[h.isAssociation()?'getAssociationInstances':'getAggregation'](g,s).map(function(g){return this.createOverlay({element:g,root:false,parentMetadata:m}).catch(function(i){return i;});},this)).then(function(C){C.map(function(i){if(i instanceof E&&!i.bIsDestroyed){h.addChild(i,true);}},this);return h;}.bind(this));},this)).then(function(g){g.forEach(function(h){if(o.bIsDestroyed){h.destroy();}else{o.addChild(h,true);}});});};D.prototype._destroyOverlaysForElement=function(o){var g=O.getOverlay(o);if(g){g.destroy();}};D.prototype._destroyAllOverlays=function(){this._iterateRootElements(function(r){this._destroyOverlaysForElement(r);},this);};D.prototype._onElementOverlayDestroyed=function(o){var g=o.getSource();var s=g.getAssociation('element');if(s in this._mPendingOverlays){return;}if(!O.hasOverlays()){d.destroyMutationObserver();d.removeOverlayContainer();}if(g.getSelected()){this.getSelectionManager().remove(g);}this.fireElementOverlayDestroyed({elementOverlay:g});};D.prototype._onElementDestroyed=function(o){var s=o.getParameter("targetId");this.removeRootElement(s);};D.prototype._onAggregationOverlayDestroyed=function(o){if(!O.hasOverlays()){d.removeOverlayContainer();}};D.prototype._onElementOverlaySelectionChange=function(o){var g=o.getSource();var s=o.getParameter("selected");if(s){if(this.getSelectionMode()===sap.ui.dt.SelectionMode.Multi){this.getSelectionManager().add(g);}else{this.getSelectionManager().set(g);}}else{this.getSelectionManager().remove(g);}};D.prototype._onElementModified=function(o){var p=o.getParameters();if(p.type==="addOrSetAggregation"||p.type==="insertAggregation"){this._onAddAggregation(p.value,p.target,p.name);}else if(p.type==="setParent"){setTimeout(function(){if(!this.bIsDestroyed){this._checkIfOverlayShouldBeDestroyed(p.target);}}.bind(this),0);}};D.prototype._onAddAggregation=function(o,p,s){if(c.isElementValid(o)){var P=O.getOverlay(p);var g=P.getAggregationOverlay(s);var h=O.getOverlay(o);if(!h){var t=this._oTaskManager.add({type:'createChildOverlay',element:o});h=this.createOverlay({element:o,parentMetadata:g.getDesignTimeMetadata().getData()}).then(function(h){g.insertChild(null,h);h.applyStyles();this._oTaskManager.complete(t);}.bind(this),function(v){throw v;}).catch(function(i,j,v){this._oTaskManager.cancel(t);var k=U.propagateError(v,"DesignTime#_onAddAggregation",U.printf("Failed to add new element overlay (elementId='{0}') into aggregation overlay (id='{1}')",i,j));if(!o.bIsDestroyed){jQuery.sap.log.error(U.errorToString(k));}}.bind(this,o.getId(),g.getId()));}else{if(h&&!this._isElementInRootElements(h)&&h.isRoot()){h.setIsRoot(false);}g.insertChild(null,h);h.setDesignTimeMetadata(f.propagateMetadataToElementOverlay(h._mMetadataOriginal,g.getDesignTimeMetadata().getData(),o));}}};D.prototype._checkIfOverlayShouldBeDestroyed=function(o){var g=O.getOverlay(o);if(!o.bIsDestroyed&&g&&(!this._isElementInRootElements(o)||o.sParentAggregationName==="dependents")){g.destroy();}};D.prototype._isElementInRootElements=function(o){var F=false;this._iterateRootElements(function(r){if(c.hasAncestor(o,r)){F=true;return false;}});return F;};D.prototype._iterateRootElements=function(s,o){var r=this.getRootElements();r.forEach(function(R){var g=c.getElementInstance(R);s.call(o||this,g);},this);};D.prototype._getAllElementOverlaysIn=function(o){var g=[];var h=O.getOverlay(o);if(h){e.iterateOverlayElementTree(h,function(C){if(C.getDesignTimeMetadata()){g.push(C);}});}return g;};D.prototype.setEnabled=function(v){v=!!v;if(this.getEnabled()!==v){this.setProperty('enabled',v);this.fireEnabledChanged({value:v});}};return D;},true);
