/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/ui/dt/Overlay','sap/ui/dt/ControlObserver','sap/ui/dt/ManagedObjectObserver','sap/ui/dt/ElementDesignTimeMetadata','sap/ui/dt/OverlayRegistry','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/DOMUtil','sap/ui/dt/Util','sap/ui/core/Control'],function(O,C,M,E,a,b,c,D,U,d){"use strict";var S='sapUiDtOverlayScrollContainer';var e=O.extend("sap.ui.dt.ElementOverlay",{metadata:{library:"sap.ui.dt",associations:{editableByPlugins:{type:"any[]",multiple:true,singularName:"editableByPlugin"}},properties:{selected:{type:"boolean",defaultValue:false},selectable:{type:"boolean",defaultValue:false},movable:{type:"boolean",defaultValue:false},editable:{type:"boolean",defaultValue:false},relevantOverlays:{type:"any[]",defaultValue:[]},metadataScope:{type:"string"}},events:{selectionChange:{parameters:{selected:{type:"boolean"}}},movableChange:{parameters:{movable:{type:"boolean"}}},selectableChange:{parameters:{selectable:{type:"boolean"}}},editableChange:{parameters:{editable:{type:"boolean"}}},elementModified:{parameters:{type:"string",name:"string",value:"any",oldValue:"any",target:"sap.ui.core.Element"}},elementDestroyed:{parameters:{targetId:"string"}}}},constructor:function(){this._aMetadataEnhancers=[];O.apply(this,arguments);}});e.prototype.asyncInit=function(){return(this.getDesignTimeMetadata()?Promise.resolve():this._loadDesignTimeMetadata()).then(function(){this._initMutationObserver();this._initControlObserver();}.bind(this));};e.prototype._initMutationObserver=function(){if(this.isRoot()){this._subscribeToMutationObserver();}this.attachEvent('isRootChanged',function(o){if(o.getParameter('value')){this._subscribeToMutationObserver();}else{this._unsubscribeFromMutationObserver();}},this);};e.prototype._subscribeToMutationObserver=function(){var m=O.getMutationObserver();m.addToWhiteList(this.getElement().getId());m.attachDomChanged(this._onDomChanged,this);};e.prototype._unsubscribeFromMutationObserver=function(){var m=O.getMutationObserver();m.removeFromWhiteList(this.getAssociation('element'));m.detachDomChanged(this._onDomChanged,this);};e.prototype._initControlObserver=function(){if(this.getElement()instanceof d){this._oObserver=new C({target:this.getElement()});}else{this._oObserver=new M({target:this.getElement()});}this._oObserver.attachModified(this._onElementModified,this);this._oObserver.attachDestroyed(this._onElementDestroyed,this);};e.prototype._destroyControlObserver=function(){if(this._oObserver){this._oObserver.destroy();}};e.prototype._getAttributes=function(){return jQuery.extend(true,{},O.prototype._getAttributes.apply(this,arguments),{"data-sap-ui-dt-for":this.getElement().getId(),"draggable":this.getMovable()});};e.prototype.render=function(){this.addStyleClass('sapUiDtElementOverlay');return O.prototype.render.apply(this,arguments);};e.prototype.onAfterRendering=function(){var o=!this._oDomRef;O.prototype.onAfterRendering.apply(this,arguments);if(o&&this._oDomRef){var p={id:this.getId(),type:"overlayRendered"};this.fireElementModified(p);}};e.prototype.exit=function(){this._unsubscribeFromMutationObserver();this._destroyControlObserver();if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}O.prototype.exit.apply(this,arguments);};e.prototype._loadDesignTimeMetadata=function(){return this.getElement().getMetadata().loadDesignTime(this.getElement(),this.getMetadataScope()).then(function(m){var o=this.getElement();if(!o||o.bIsDestroyed){new Error("sap.ui.dt.ElementOverlay#loadDesignTimeMetadata / Can't set metadata to overlay which element has been destroyed already");}this.setDesignTimeMetadata(m);}.bind(this)).catch(function(v){var o=U.wrapError(v);if(U.isForeignError(o)){var l='sap.ui.dt.ElementOverlay#loadDesignTimeMetadata';o.name='Error in '+l;o.message=U.printf("{0} / Can't load designtime metadata data for overlay with id='{1}', element id='{2}' ({3}): {4}",l,this.getId(),this.getElement().getId(),this.getElement().getMetadata().getName(),o.message);}throw o;}.bind(this));};e.prototype._setPosition=function(){O.prototype._setPosition.apply(this,arguments);this.getScrollContainers().forEach(function(s,i){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||jQuery();var f=this.getScrollContainerById(i);if($.length){var o=$.get(0);this._setSize(f,D.getGeometry(o));O.prototype._setPosition.call(this,f,D.getGeometry(o),this.$());this._handleOverflowScroll(D.getGeometry(o),f,this);}else{this._deleteDummyContainer(f);f.css("display","none");}},this);};e.prototype._applySizes=function(){var p=this.getChildren().filter(function(o){return o.isRendered();}).map(function(o){return new Promise(function(r){o.attachEventOnce('geometryChanged',r);});});O.prototype._applySizes.apply(this,arguments);Promise.all(p).then(function(){this._sortChildren(this.getChildrenDomRef());this.getScrollContainers().forEach(function(s,i){var $=this.getDesignTimeMetadata().getAssociatedDomRef(this.getElement(),s.domRef)||jQuery();var f=this.getScrollContainerById(i);if($.length){this._sortChildren(f.get(0));}},this);}.bind(this));};e.prototype._sortChildren=function(o){var f=function(i,j){var G=D.getGeometry(i);var k=D.getGeometry(j);var p=G&&G.position;var P=k&&k.position;if(p&&P){var B=p.top+G.size.height;var l=P.top+k.size.height;if(p.top<P.top){if(B>=l&&P.left<p.left){return 1;}else{return-1;}}else if(p.top===P.top){if(p.left===P.left){if(G.size.height<k.size.height||G.size.width<k.size.width){return-1;}else if(G.size.height>k.size.height||G.size.width>k.size.width){return 1;}else{return 0;}}else if(p.left<P.left){return-1;}else{return 1;}}else if(B<=l&&P.left>p.left){return-1;}else{return 1;}}return 0;};var g=jQuery(o).find('>:not(.sapUiDtDummyScrollContainer)').toArray();var s=g.slice().sort(f);var h=g.some(function(i,I){return i!==s[I];});if(h){s.forEach(function(i){D.appendChild(o,i);});}};e.prototype.placeInOverlayContainer=function(){if(this._bInit){if(this.isRoot()){if(!this.isRendered()){O.getOverlayContainer().append(this.render());this.applyStyles();}else{jQuery.sap.log.error('sap.ui.dt.ElementOverlay: overlay is already rendered and can\'t be placed in overlay container. Isn\'t it already there?');}}else{jQuery.sap.log.error('sap.ui.dt.ElementOverlay: it\'s not possible to place overlay inside overlay container while it\'s part of some hierarchy');}}else{jQuery.sap.log.error('sap.ui.dt.ElementOverlay: overlay is not ready yet. Please wait until "init" event happens');}};e.prototype.setDesignTimeMetadata=function(v){var o=this.getDesignTimeMetadata();var m;if(jQuery.isFunction(v)){if(!o){this._aMetadataEnhancers=this._aMetadataEnhancers.concat(v);}else{o.setData(v(jQuery.sap.extend(true,{},o.getData())));return;}}else if(v instanceof E){o=v;}else if(jQuery.isPlainObject(v)){m=v;var f;while(f=this._aMetadataEnhancers.shift()){m=f.call(this,m);}o=new E({data:m});}if(o){O.prototype.setDesignTimeMetadata.call(this,o);}};e.prototype.getScrollContainers=function(){return this.getDesignTimeMetadata().getScrollContainers();};e.prototype._renderChildren=function(){var f=O.prototype._renderChildren.apply(this,arguments);this.getScrollContainers().forEach(function(s,i){var $=jQuery("<div/>",{"class":S,"data-sap-ui-dt-scrollContainerIndex":i});if(s.aggregations){U.intersection(s.aggregations,this.getAggregationNames()).forEach(function(A){var o=this.getAggregationOverlay(A);var g=f.indexOf(o.$());o.setScrollContainerId(i);$.append(f[g]);f.splice(g,1);},this);}f.push($);},this);return f;};e.prototype.getScrollContainerById=function(i){return jQuery(this.getChildrenDomRef()).find('>.'+S+'[data-sap-ui-dt-scrollcontainerindex="'+i+'"]');};e.prototype.getAssociatedDomRef=function(){var o=b.getDomRef(this.getElement());if(!o){var f=this.getDesignTimeMetadata();if(!f){return undefined;}var g=f.getDomRef();if(typeof g==="function"){o=g(this.getElement());}}if(o){return jQuery(o);}return undefined;};e.prototype.setSelectable=function(s){s=!!s;if(s!==this.isSelectable()){if(!s){this.setSelected(false);}this.toggleStyleClass("sapUiDtOverlaySelectable",s);this.setProperty("selectable",s);this.fireSelectableChange({selectable:s});}this.setFocusable(s);return this;};e.prototype.setSelected=function(s,f){s=!!s;if(this.isSelectable()&&s!==this.isSelected()){this.setProperty("selected",s);this.toggleStyleClass("sapUiDtOverlaySelected",s);if(!f){this.fireSelectionChange({selected:s});}}return this;};e.prototype.setMovable=function(m){m=!!m;if(this.getMovable()!==m){this.toggleStyleClass("sapUiDtOverlayMovable",m);this.setProperty("movable",m);this.fireMovableChange({movable:m});this.$()[m?'attr':'removeAttr']('draggable',m);}return this;};e.prototype.setEditable=function(f){f=!!f;if(this.getEditable()!==f){this.toggleStyleClass("sapUiDtOverlayEditable",f);this.setProperty("editable",f);this.fireEditableChange({editable:f});}return this;};e.prototype.getAggregationNames=function(){var o=this.getElement();var f=this.getDesignTimeMetadata();var A=o.getMetadata().getAllAggregations();return[].concat(Object.keys(A),Object.keys(f.getAggregations())).filter(function(s,i,g){return(i===g.indexOf(s)&&!f.isAggregationIgnored(o,s));});};e.prototype._onChildAdded=function(o){var A=o.getSource();if(this.isRendered()&&!A.isRendered()){var t=(U.isInteger(A.getScrollContainerId())?this.getScrollContainerById(A.getScrollContainerId()):jQuery(this.getChildrenDomRef()));t.append(A.render());}};e.prototype.addChild=function(A){A.detachChildAdded(this._onChildAdded,this);A.attachChildAdded(this._onChildAdded,this);O.prototype.addChild.apply(this,arguments);};e.prototype._onElementModified=function(o){var p=o.getParameters();var n=p.name;if(p.type==="propertyChanged"&&n==="visible"){this.setRelevantOverlays([]);this.fireElementModified(p);}else if(n){var A=this.getAggregationOverlay(n);if(A){this.setRelevantOverlays([]);this.fireElementModified(p);}}else if(o.getParameters().type==="setParent"){this.fireElementModified(p);}};e.prototype._onDomChanged=function(o){if(this.isReady()&&this.isRoot()){if(this._iApplyStylesRequest){window.cancelAnimationFrame(this._iApplyStylesRequest);}this._iApplyStylesRequest=window.requestAnimationFrame(function(){this.applyStyles();delete this._iApplyStylesRequest;}.bind(this));}};e.prototype._onElementDestroyed=function(o){var s=o.getSource().getTarget();this.fireElementDestroyed({targetId:s});if(this._bInit){this.destroy();}else{this._bShouldBeDestroyed=true;}};e.prototype.getAggregationOverlays=function(){return this.getAggregation("children")||[];};e.prototype.getAggregationOverlay=function(A){return this.getChildren().filter(function(o){return o.getAggregationName()===A;}).pop();};e.prototype.getParentElementOverlay=function(){var p=this.getParentAggregationOverlay();if(p){return p.getParent();}};e.prototype.getParentAggregationOverlay=function(){var p=this.getParent();return p instanceof sap.ui.dt.AggregationOverlay?p:null;};e.prototype.isSelected=function(){return this.getSelected();};e.prototype.isSelectable=function(){return this.getSelectable();};e.prototype.isMovable=function(){return this.getMovable();};e.prototype.isEditable=function(){return this.getEditable();};e.prototype._getElementInstanceVisible=function(){var o=this.getElement();if(o){var g=this.getGeometry();return g&&g.visible;}else{return false;}};e.prototype.getElementVisibility=function(){var o=this.getElement();if(o instanceof sap.ui.core.Control){return o.getVisible();}var f=this.getDesignTimeMetadata();var g=f&&f.getData().isVisible;if(!g){return undefined;}return g(this.getElement());};e.prototype.isElementVisible=function(){var o=this.getElement();var v=false;if(this.getDesignTimeMetadata().isIgnored(o)){v=false;}else{var g=this.getGeometry(true);if(g){v=g.visible;}else if(jQuery.isFunction(this.getDesignTimeMetadata().getData().isVisible)){v=this.getDesignTimeMetadata().getData().isVisible(o);}else if(o instanceof d){v=!!o.getDomRef()&&o.getVisible();}}return v;};e.prototype.isVisible=function(){return(O.prototype.isVisible.apply(this,arguments)&&this.isElementVisible());};e.prototype.getRelevantContainer=function(f){var o=this.getDesignTimeMetadata();if(o&&o.getData().relevantContainer){return o.getData().relevantContainer;}else if(f){return this.getElement();}var p=this.getParentElementOverlay();return p?p.getElement():undefined;};return e;},true);
