/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/base/Object','sap/ui/base/ManagedObject','sap/ui/core/Element','sap/ui/dt/Util'],function(q,B,M,E,U){"use strict";var c={};c.iterateOverAllPublicAggregations=function(e,C){var a=e.getMetadata().getAllAggregations();var A=Object.keys(a);A.forEach(function(s){var o=a[s];var v=this.getAggregation(e,s);C(o,v);},this);};c.getElementInstance=function(e){if(typeof e==="string"){var o=sap.ui.getCore().byId(e);return o||sap.ui.getCore().getComponent(e);}else{return e;}};c.hasAncestor=function(e,a){a=this.fixComponentContainerElement(a);var p=this.fixComponentParent(e);while(p&&p!==a){p=p.getParent();p=this.fixComponentParent(p);}return!!p;};c.getClosestElementForNode=function(n){var C=q(n).closest("[data-sap-ui]");return C.length?sap.ui.getCore().byId(C.data("sap-ui")):undefined;};c.fixComponentParent=function(e){if(B.isA(e,"sap.ui.core.UIComponent")){var C=e.oContainer;if(C){return C.getParent();}}else{return e;}};c.fixComponentContainerElement=function(e){if(B.isA(e,"sap.ui.core.ComponentContainer")){if(!e.getComponentInstance()){return;}return e.getComponentInstance().getRootControl();}else{return e;}};c.getDomRef=function(e){if(e){var d;if(e.getDomRef){d=e.getDomRef();}if(!d&&e.getRenderedDomRef){d=e.getRenderedDomRef();}return d;}};c.findAllSiblingsInContainer=function(e,C){var p=e.getParent();if(!p){return[];}if(p!==C){var P=c.findAllSiblingsInContainer(p,C);return P.map(function(p){return c.getAggregation(p,e.sParentAggregationName);}).reduce(function(a,b){return a.concat(b);},[]);}return c.getAggregation(p,e.sParentAggregationName);};c.getAggregationAccessors=function(e,a){var m=e.getMetadata();m.getJSONKeys();var A=m.getAggregation(a);if(A){var g=A._sGetter;if(A.altTypes&&A.altTypes.length&&e[A._sGetter+"Control"]){g=A._sGetter+"Control";}return{get:g,add:A._sMutator,remove:A._sRemoveMutator,insert:A._sInsertMutator,removeAll:A._sRemoveAllMutator};}else{return{};}};c.getAggregation=function(e,a){var v;var g=this.getAggregationAccessors(e,a).get;if(g){v=e[g]();}else{v=e.getAggregation(a);}v=v&&v.splice?v:(v?[v]:[]);return v;};c.getIndexInAggregation=function(e,p,a){return this.getAggregation(p,a).indexOf(e);};c.addAggregation=function(p,a,e){if(this.hasAncestor(p,e)){throw new Error("Trying to add an element to itself or its successors");}var A=this.getAggregationAccessors(p,a).add;if(A){p[A](e);}else{p.addAggregation(a,e);}};c.removeAggregation=function(p,a,e,s){var A=this.getAggregationAccessors(p,a).remove;if(A){p[A](e,s);}else{p.removeAggregation(a,e,s);}};c.insertAggregation=function(p,a,e,i){if(this.hasAncestor(p,e)){throw new Error("Trying to add an element to itself or its successors");}if(this.getIndexInAggregation(e,p,a)!==-1){e.__bSapUiDtSupressParentChangeEvent=true;try{this.removeAggregation(p,a,e,true);}finally{delete e.__bSapUiDtSupressParentChangeEvent;}}var A=this.getAggregationAccessors(p,a).insert;if(A){p[A](e,i);}else{p.insertAggregation(a,e,i);}};c.isValidForAggregation=function(p,a,e){var A=p.getMetadata().getAggregation(a);if(this.hasAncestor(p,e)){return false;}if(A){var t=A.type;if(A.multiple===false&&this.getAggregation(p,a)&&this.getAggregation(p,a).length>0){return false;}return B.isA(e,t)||this.hasInterface(e,t);}};c.getAssociationAccessors=function(e,a){var m=e.getMetadata();m.getJSONKeys();var A=m.getAssociation(a);if(A){return{get:A._sGetter,add:A._sMutator,remove:A._sRemoveMutator,insert:A._sInsertMutator,removeAll:A._sRemoveAllMutator};}else{return{};}};c.getAssociation=function(e,a){var v;var g=this.getAssociationAccessors(e,a).get;if(g){v=e[g]();}return v;};c.getIndexInAssociation=function(e,p,a){return this.getAssociationInstances(p,a).indexOf(e);};c.getAssociationInstances=function(e,a){var v=U.castArray(this.getAssociation(e,a));return v.map(function(i){return this.getElementInstance(i);},this);};c.hasInterface=function(e,i){var I=e.getMetadata().getInterfaces();return I.indexOf(i)!==-1;};c.isElementValid=function(e,s,a){var i=e instanceof M&&!e.bIsDestroyed;if(!i&&s&&a){q.sap.log.error(["sap.ui.dt.DesignTime: child element in aggregation "+a+" of '"+s,"' should be a descendant of 'sap.ui.base.ManagedObject' and it is a '"+typeof e+"'. ","Please ignore the aggregation '"+a+"' in the .designtime configuration"].join(''));}return i;};c.getParent=function(e){return B.isA(e,'sap.ui.core.Component')?e.oContainer:e.getParent();};c.getLabelForElement=function(e,f){if(!c.isElementValid(e)){throw U.createError("ElementUtil#getLabelForElement","A valid managed object instance should be passed as parameter","sap.ui.dt");}if(typeof f==="function"){return f(e);}else{var C=function(e){var F=(typeof e.getText==="function"&&e.getText()||typeof e.getLabelText==="function"&&e.getLabelText()||typeof e.getLabel==="function"&&e.getLabel()||typeof e.getTitle==="function"&&e.getTitle()||typeof e.getHeading==="function"&&e.getHeading());if(c.isElementValid(F)){return C(F);}else{return F;}};var v=C(e);return typeof v!=="string"?e.getId():v;}};return c;},true);
