/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Element','sap/ui/dt/MutationObserver','sap/ui/dt/ElementUtil','sap/ui/dt/OverlayUtil','sap/ui/dt/DOMUtil','sap/ui/dt/ScrollbarSynchronizer','sap/ui/dt/Util','sap/ui/dt/Map','sap/ui/Device'],function(q,E,M,a,O,D,S,U,b,c){"use strict";var d="overlay-container";var o;var m;var e=E.extend("sap.ui.dt.Overlay",{metadata:{library:"sap.ui.dt",properties:{visible:{type:"boolean",defaultValue:true},focusable:{type:"boolean",defaultValue:false},isRoot:{type:"boolean",defaultValue:false}},associations:{element:{type:"sap.ui.core.Element"}},aggregations:{children:{type:"sap.ui.dt.Overlay",multiple:true},designTimeMetadata:{type:"sap.ui.dt.DesignTimeMetadata",altTypes:["function","object"],multiple:false}},events:{init:{},initFailed:{},afterRendering:{},beforeDestroy:{},destroyed:{parameters:{}},visibleChanged:{parameters:{visible:"boolean"}},geometryChanged:{},childAdded:{},scrollSynced:{},isRootChanged:{parameters:{value:{type:"boolean"}}}}},constructor:function(){this._aStyleClasses=this._aStyleClasses.slice(0);this._oScrollbarSynchronizers=new b();this._aBindParameters=[];E.apply(this,arguments);if(!this.getElement()){throw new Error("sap.ui.dt: can't create overlay without element");}this.asyncInit().then(function(){if(this._bShouldBeDestroyed){this.fireInitFailed({error:U.createError("Overlay#asyncInit","ElementOverlay is destroyed during initialization ('"+this.getId()+"')")});}else{this._bInit=true;this.fireInit();}}.bind(this)).catch(function(v){var f=U.wrapError(v);if(U.isForeignError(f)){var l='sap.ui.dt.Overlay#asyncInit';f.name='Error in '+l;f.message=U.printf("{0} / Can't initialize overlay (id='{1}') properly: {2}",l,this.getId(),f.message);}this.fireInitFailed({error:f});}.bind(this));},_bInit:false,_bRendered:false,_$DomRef:null,_aStyleClasses:['sapUiDtOverlay'],_bShouldBeDestroyed:false,_aBindParameters:null});e.getOverlayContainer=function(){if(!o){o=q("<div/>").attr('id',d).appendTo("body");}return o;};e.removeOverlayContainer=function(){if(o){o.remove();}o=undefined;};e.getMutationObserver=function(){if(!m){m=new M();}return m;};e.destroyMutationObserver=function(){if(m){m.destroy();m=null;}};e.prototype.asyncInit=function(){return Promise.resolve();};e.prototype._getAttributes=function(){return{"id":this.getId(),"data-sap-ui":this.getId(),"class":this._aStyleClasses.join(" "),"tabindex":this.isFocusable()?0:null};};e.prototype._renderChildren=function(){return this.getChildren().map(function(C){return C.isRendered()?C.$():C.render();});};e.prototype.render=function(s){if(this.isRendered()){return this.getDomRef();}this._$DomRef=q('<div/>').attr(this._getAttributes());this._$Children=q('<div/>').attr({"class":"sapUiDtOverlayChildren"}).appendTo(this._$DomRef);this._$Children.append(this._renderChildren());this._bRendered=true;if(!s){this.fireAfterRendering({domRef:this._$DomRef.get(0)});}return this._$DomRef;};e.prototype.isInit=function(){return this._bInit;};e.prototype.isRendered=function(){return this._bRendered;};e.prototype.isReady=function(){return this.isInit()&&this.isRendered();};e.prototype.addStyleClass=function(C){if(!this.hasStyleClass(C)){this._aStyleClasses.push(C);if(this.isReady()){this.$().addClass(C);}}};e.prototype.hasStyleClass=function(C){return this._aStyleClasses.indexOf(C)!==-1;};e.prototype.removeStyleClass=function(C){if(this.hasStyleClass(C)){this._aStyleClasses=this._aStyleClasses.filter(function(i){return i!==C;});if(this.isReady()){this.$().removeClass(C);}}};e.prototype.toggleStyleClass=function(C){this[(this.hasStyleClass(C)?'remove':'add')+'StyleClass'](C);};e.prototype.setElement=function(v){if(!this.getElement()){this.setAssociation("element",v);if(this._designTimeMetadataCache){this.setDesignTimeMetadata(this._designTimeMetadataCache);delete this._designTimeMetadataCache;}}};e.prototype.destroy=function(){if(this.bIsDestroyed){q.sap.log.error('FIXME: Do not destroy overlay twice (overlayId = '+this.getId()+')!');return;}this.fireBeforeDestroy();E.prototype.destroy.apply(this,arguments);};e.prototype.exit=function(){this._oScrollbarSynchronizers.forEach(function(s){s.destroy();});this._oScrollbarSynchronizers.clear();this.$().remove();delete this._bInit;delete this._bShouldBeDestroyed;delete this._$DomRef;delete this._oScrollbarSynchronizers;this.fireDestroyed();};e.prototype.setDesignTimeMetadata=function(v){if(!this.getElement()){this._designTimeMetadataCache=v;}else{this.setAggregation('designTimeMetadata',v);}};e.prototype.getDomRef=function(){return this.$().get(0);};e.prototype.getChildrenDomRef=function(){return this._$Children.get(0);};e.prototype.$=function(){return this._$DomRef||q();};e.prototype.getAssociatedDomRef=function(){throw new Error("This method is abstract and needs to be implemented");};e.prototype.getElementInstance=function(){return this.getElement();};e.prototype.getElement=function(){return a.getElementInstance(this.getAssociation('element'));};e.prototype.hasFocus=function(){return document.activeElement===this.getDomRef();};e.prototype.focus=function(){this.$().focus();};e.prototype.setFocusable=function(f){f=!!f;if(this.getFocusable()!==f){this.setProperty("focusable",f);this.toggleStyleClass("sapUiDtOverlayFocusable");this.$().attr("tabindex",f?0:null);}};e.prototype.isFocusable=function(){return this.getFocusable();};e.prototype._getRenderingParent=function(){return this.isRoot()?null:this.getParent().$();};e.prototype.applyStyles=function(){if(!this.isRendered()){return;}if(this.isVisible()){var g=this.getGeometry(true);if(g&&g.visible){this._setSize(this.$(),g);var r=this._getRenderingParent();if(!this.isRoot()){var p=[];this.getParent()._oScrollbarSynchronizers.forEach(function(s){if(s._bSyncing){p.push(new Promise(function(R){s.attachEventOnce('synced',R);}));}});if(p.length){Promise.all(p).then(function(){this._applySizes(g,r);this.fireGeometryChanged();}.bind(this));}else{this._applySizes(g,r);}}else{this._applySizes(g,r);}}else{this.$().css("display","none");}}else{this.$().css("display","none");}if(!p||!p.length){this.fireGeometryChanged();}};e.prototype._applySizes=function(g,r){this._setPosition(this.$(),g,r);if(g.domRef){this._handleOverflowScroll(g,this.$(),this.getParent());}this.getChildren().forEach(function(C){C.applyStyles();});};e.prototype._setSize=function(t,g){t.css("display","block");var s=g.size;t.css("width",s.width+"px");t.css("height",s.height+"px");};e.prototype._setPosition=function(t,g,p){var P=D.getOffsetFromParent(g,p?p.get(0):null);t.css("transform","translate("+P.left+"px, "+P.top+"px)");};e.prototype.attachBrowserEvent=function(s,h,l){if(s&&(typeof(s)==="string")){if(typeof h==="function"){if(!this._aBindParameters){this._aBindParameters=[];}l=l||this;var p=h.bind(l);this._aBindParameters.push({sEventType:s,fnHandler:h,oListener:l,fnProxy:p});this.$().bind(s,p);}}return this;};e.prototype.detachBrowserEvent=function(s,h,l){if(s&&(typeof(s)==="string")){if(typeof(h)==="function"){var $=this.$(),i,p;l=l||this;if(this._aBindParameters){for(i=this._aBindParameters.length-1;i>=0;i--){p=this._aBindParameters[i];if(p.sEventType===s&&p.fnHandler===h&&p.oListener===l){this._aBindParameters.splice(i,1);$.unbind(s,p.fnProxy);}}}}}return this;};e.prototype._deleteDummyContainer=function($){var f=$.find(">.sapUiDtDummyScrollContainer");if(f.length){f.remove();this._oScrollbarSynchronizers.get($.get(0)).destroy();this._oScrollbarSynchronizers.delete($.get(0));if(!this.isRoot()&&this.getParent()._oScrollbarSynchronizers.size===0&&!this.getParent().getChildren().some(function(A){return A._oScrollbarSynchronizers.size>0;})){var p=this.getParent();p.removeStyleClass("sapUiDtOverlayWithScrollBar");p.removeStyleClass("sapUiDtOverlayWithScrollBarVertical");p.removeStyleClass("sapUiDtOverlayWithScrollBarHorizontal");}}};e.prototype._handleOverflowScroll=function(g,$,f){var h=g.domRef;var s=g.size;var z=D.getZIndex(h);if(z){$.css("z-index",z);}var i=D.getOverflows(h);$.css("overflow-x",i.overflowX);$.css("overflow-y",i.overflowY);var j=h.scrollHeight;var k=h.scrollWidth;if(j>Math.ceil(s.height)||k>Math.ceil(s.width)){var l=$.find("> .sapUiDtDummyScrollContainer");if(!l.length){l=q("<div/>",{css:{height:j+"px",width:k+"px"}});l=q("<div class='sapUiDtDummyScrollContainer' style='height: "+j+"px; width: "+k+"px;'></div>");if(f&&D.hasVerticalScrollBar(h)){f.addStyleClass("sapUiDtOverlayWithScrollBar");f.addStyleClass("sapUiDtOverlayWithScrollBarVertical");}if(f&&D.hasHorizontalScrollBar(h)){f.addStyleClass("sapUiDtOverlayWithScrollBar");f.addStyleClass("sapUiDtOverlayWithScrollBarHorizontal");}$.append(l);var n=new S({synced:this.fireScrollSynced.bind(this)});n.addTarget(h,$.get(0));this._oScrollbarSynchronizers.set($.get(0),n);}else{l.css({"height":j,"width":k});var n=this._oScrollbarSynchronizers.get($.get(0));if(!n.hasTarget(h)){n.addTarget(h);}}}else{this._deleteDummyContainer($);}};e.prototype.getGeometry=function(f){if(f||!this._mGeometry){var $=this.getAssociatedDomRef();var C;if($){var i=this.isRoot();C=q.makeArray($).map(function(g){return D.getGeometry(g,i);});}else{C=this.getChildren().map(function(g){return g.getGeometry(true);});}if(C.length){this._mGeometry=C.length>1?O.getGeometry(C):C[0];}else{delete this._mGeometry;}}return this._mGeometry;};e.prototype.setVisible=function(v){v=!!v;if(this.getVisible()!==v){this.setProperty("visible",v);this.fireVisibleChanged({visible:v});}};e.prototype.isVisible=function(){return(this.getVisible()&&(this.isRoot()?true:this.getParent().isVisible()));};e.prototype.setIsRoot=function(v){v=!!v;if(this.getIsRoot()!==v){this.setProperty('isRoot',v);this.fireIsRootChanged({value:v});}};e.prototype.isRoot=function(){return this.getIsRoot();};return e;},true);
