/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/dt/Plugin','sap/ui/dt/ContextMenuControl','sap/ui/dt/Util','sap/ui/Device'],function(q,P,C,U,D){"use strict";var a=P.extend("sap.ui.dt.plugin.ContextMenu",{metadata:{properties:{contextElement:{type:"object"},styleClass:{type:"string"},openOnHover:{type:"boolean",defaultValue:true}},events:{openedContextMenu:{},closedContextMenu:{}}}});a.prototype.init=function(){this.iMenuTouchOpeningDelay=150;this.iMenuLeftclickOpeningDelay=0;this.iMenuHoverOpeningDelay=500;this.iMenuHoverClosingDelay=250;this.oContextMenuControl=new sap.ui.dt.ContextMenuControl({maxButtonsDisplayed:4});this.oContextMenuControl.attachClosed(this._contextMenuClosed,this);this.oContextMenuControl.attachOverflowButtonPressed(this._pressedOverflowButton,this);this._aMenuItems=[];this._aGroupedItems=[];this._aSubMenus=[];this._aPluginsWithBusyFunction=[];};a.prototype.exit=function(){this._clearHoverTimeout();delete this._aMenuItems;if(this.oContextMenuControl){this.oContextMenuControl.detachClosed(this._contextMenuClosed,this);this.oContextMenuControl.detachOverflowButtonPressed(this._pressedOverflowButton,this);this.oContextMenuControl.destroy(true);delete this.oContextMenuControl;}};a.prototype.addMenuItem=function(m,r,p){var M={menuItem:m,fromPlugin:!!r,bPersistOneTime:p};this._aMenuItems.push(M);};a.prototype.registerElementOverlay=function(o){o.attachBrowserEvent("click",this._onClick,this);o.attachBrowserEvent("touchstart",this._onTouch,this);o.attachBrowserEvent("contextmenu",this._onContextMenu,this);o.attachBrowserEvent("keydown",this._onKeyDown,this);};a.prototype.deregisterElementOverlay=function(o){o.detachBrowserEvent("click",this._onClick,this);o.detachBrowserEvent("touchstart",this._onTouch,this);o.detachBrowserEvent("contextmenu",this._onContextMenu,this);o.detachBrowserEvent("keydown",this._onKeyDown,this);};a.prototype.open=function(e,o,c,i){this._bContextMenu=!!c;this._aPluginsWithBusyFunction=[];this.setContextElement(o.getElement());var p=this.getDesignTime().getPlugins();p.forEach(function(b){if(b.isBusy){this._aPluginsWithBusyFunction.push(b);}}.bind(this));this._aMenuItems=this._aMenuItems.filter(function(M){if(M.bPersistOneTime){M.bPersistOneTime=false;return true;}return!M.fromPlugin;});if(!i){this._aGroupedItems=[];this._aSubMenus=[];p.forEach(function(b){var d=b.getMenuItems(o)||[];d.forEach(function(M){if(M.group!=undefined&&!c){this._addMenuItemToGroup(M);}else if(M.submenu!=undefined){this._addSubMenu(M,e,o);}else{this.addMenuItem(M,true);}}.bind(this));}.bind(this));this._addItemGroupsToMenu(e,o);}var m=this._aMenuItems.map(function(M){return M.menuItem;});if(m.length>0){this.oContextMenuControl._bUseExpPop=!!c;m=this._sortMenuItems(m);this.oContextMenuControl.setButtons(m,this._onItemSelected.bind(this),o);this.oContextMenuControl.setStyleClass(this.getStyleClass());if(i){this.oContextMenuControl.setOpenNew(true);}this.oContextMenuControl.show(o,c,{x:e.clientX,y:e.clientY});}this.fireOpenedContextMenu();};a.prototype._sortMenuItems=function(m){return m.sort(function(f,s){if(!f.rank&&!s.rank){return 0;}if(!f.rank&&s.rank){return-1;}if(f.rank&&!s.rank){return 1;}return f.rank-s.rank;});};a.prototype._onContextMenu=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);if(o&&o.isSelectable()){e.preventDefault();if(!this._bTouched){this._oCurrentOverlay=sap.ui.getCore().byId(e.currentTarget.id);this.oContextMenuControl.close();this._bOpenedByHover=false;if(document.activeElement){document.activeElement.blur();}clearTimeout(this.hoverTimeout);this._bTouched=false;this._ensureSelection(o);clearTimeout(this.clickTimeout);this.lockMenuOpening();this.oContextMenuControl.setOpenNew(true);this.open(e,o,true);e.stopPropagation();}}};a.prototype._onItemSelected=function(e){this.oContextMenuControl.close(true);this._ensureSelection(this._oCurrentOverlay);this.setFocusLock(true);var s=[],c=this.getContextElement(),S=e.data("id");this._aMenuItems.some(function(m){if(S===m.menuItem.id){var i=m.menuItem;s=this.getSelectedOverlays();var p={};p.eventItem=e;p.contextElement=c;i.handler(s,p);i=null;return true;}},this);};a.prototype._onTouch=function(e){this._bTouched=true;var o=sap.ui.getCore().byId(e.currentTarget.id);if(o&&o.isSelectable()){e.stopPropagation();if(this.touchTimeout){clearTimeout(this.touchTimeout);}this.touchTimeout=setTimeout(function(){this._bTouched=true;this._startOpening(e);}.bind(this),this.iMenuTouchOpeningDelay);}};a.prototype._onClick=function(e){if(!D.os.ios){var o=sap.ui.getCore().byId(e.currentTarget.id);if(o&&o.isSelectable()&&o.getSelected()){if(this.isMenuOpeningLocked()&&!this._bTouched){this.unlockMenuOpening();this._bTouched=false;this.oContextMenuControl.close();}this._startOpeningWithDelay(e);}}};a.prototype._startOpeningWithDelay=function(e){this._bTouched=false;var c=q.extend({},e);this.clickTimeout=setTimeout(function(){this._startOpening(c,true);}.bind(this),this.iMenuLeftclickOpeningDelay);};a.prototype._startOpening=function(e,l){clearTimeout(this.hoverTimeout);this._bOpenedByHover=false;if(this._oTempTarget!=e.currentTarget.id){clearTimeout(this.clickTimeout);}this._oTempTarget=e.currentTarget.id;var o=sap.ui.getCore().byId(e.currentTarget.id);var t=e.target.className;if(o&&o.isSelectable()&&t.indexOf("sapUiDtOverlay")>-1&&(!this.isMenuOpeningLocked()||this._bTouched)){e.stopPropagation();if(this._shouldContextMenuOpen(e)){this._ensureSelection(o);if(this._oCurrentOverlay.isSelected()||D.os.android){if(l){this.lockMenuOpening();}this.oContextMenuControl.setOpenNew(true);this.open(e,o);return true;}}}};a.prototype._onHover=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);if(o&&o.isSelectable()&&!e.ctrlKey&&this.getOpenOnHover()){e.stopPropagation();if(this._shouldContextMenuOpen(e,true)){if(this.iMenuHoverClosingDelay>=this.iMenuHoverOpeningDelay){q.error("sap.ui.dt ContextMenu iMenuHoverClosingDelay is bigger or equal to iMenuHoverOpeningDelay!");}if(this.oContextMenuControl.getPopover().isOpen()){this._closingTimeout=setTimeout(function(){if(!this._bTouched&&this.oContextMenuControl.getPopover().isOpen()){this.oContextMenuControl.close();}}.bind(this),this.iMenuHoverClosingDelay);}this.hoverTimeout=setTimeout(function(){if(!this._bTouched){sap.ui.getCore().byId(e.currentTarget.id).focus();this._startOpening(e);this._bOpenedByHover=true;}}.bind(this),this.iMenuHoverOpeningDelay);}}};a.prototype._clearHoverTimeout=function(){if(this.hoverTimeout){clearTimeout(this.hoverTimeout);this.hoverTimeout=null;}if(this._closingTimeout){clearTimeout(this._closingTimeout);this._closingTimeout=null;}};a.prototype._onKeyDown=function(e){var o=sap.ui.getCore().byId(e.currentTarget.id);if((e.keyCode===q.sap.KeyCodes.SPACE||e.keyCode===q.sap.KeyCodes.ENTER)&&(e.shiftKey===false)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()){this._startOpening(e,true);e.stopPropagation();}}if((e.keyCode===q.sap.KeyCodes.F10)&&(e.shiftKey===true)&&(e.altKey===false)&&(e.ctrlKey===false)){if(o&&o.isSelectable()){e.preventDefault();e.clientX=o.$().offset().left+o.$().width()/2;e.clientY=o.$().offset().top+o.$().height()/2;this._onContextMenu(e);}}};a.prototype._shouldContextMenuOpen=function(e,o){if((!this._checkForPluginLock()&&!this.isMenuOpeningLocked()||this._bTouched)){if(!o){this._oCurrentOverlay=sap.ui.getCore().byId(e.currentTarget.id);}return true;}else{return false;}};a.prototype._pressedOverflowButton=function(){if(!this._bTouched){this.lockMenuOpening();}this.setFocusLock(true);};a.prototype._contextMenuClosed=function(){this._bTouched=false;this.unlockMenuOpening();this.setFocusLock(false);};a.prototype.lockMenuOpening=function(o){if((this.oContextMenuControl.getPopover(true).isOpen()||this.oContextMenuControl.getPopover(false).isOpen())&&o!==true){this._bAsyncLock=true;}else{this._bOpeningLocked=true;}};a.prototype.unlockMenuOpening=function(){this._bOpeningLocked=false;if(this._bAsyncLock){this.lockMenuOpening(true);}this._bAsyncLock=false;this.resetFocus();};a.prototype.isMenuOpeningLocked=function(){return this._bOpeningLocked;};a.prototype.setFocusLock=function(i){this._bFocusLocked=i;};a.prototype.resetFocus=function(){if(!this._bFocusLocked&&this._oCurrentOverlay&&document.activeElement){if(!D.os.ios){this._oCurrentOverlay.focus();}}};a.prototype._ensureSelection=function(o){if((!this._bTouched||D.os.ios)&&o&&!o.isSelected()){o.setSelected(true);}};a.prototype._checkForPluginLock=function(){if(D.os.ios){return false;}if(this._aPluginsWithBusyFunction.some(function(p){return(typeof p.isBusy==="function"&&p.isBusy());})){return true;}this.setFocusLock(false);return false;};a.prototype._addMenuItemToGroup=function(m){var g=this._aGroupedItems.some(function(_){if(_.sGroupName===m.group){_.aGroupedItems.push(m);return true;}});if(!g){this._aGroupedItems.push({sGroupName:m.group,aGroupedItems:[m]});}};a.prototype._addSubMenu=function(m,e,o){m.submenu.forEach(function(s){s.handler=m.handler;});m.handler=function(M,e,o,O,p){this._aSubMenus.some(function(_){if(_.sSubMenuId===M){_.aSubMenuItems.forEach(function(s){this.addMenuItem(s,true,true);}.bind(this));return true;}}.bind(this));if(!this._bContextMenu){e.clientX=null;e.clientY=null;}this.oContextMenuControl.close();setTimeout(function(){this.open(e,o,true,true);}.bind(this),0);this.lockMenuOpening();}.bind(this,m.id,e,o);this._aSubMenus.push({sSubMenuId:m.id,aSubMenuItems:m.submenu});this.addMenuItem(m,true);};a.prototype._addItemGroupsToMenu=function(e,o){this._aGroupedItems.forEach(function(g,i){if(g.aGroupedItems.length===1){this.addMenuItem(g.aGroupedItems[0],true,false);}else{var h=function(i,e,o){this._aGroupedItems[i].aGroupedItems.forEach(function(m){this.addMenuItem(m,true,true);}.bind(this));e.clientX=null;e.clientY=null;this.oContextMenuControl.close();setTimeout(function(){this.open(e,o,true,true);}.bind(this),0);this.lockMenuOpening();};this.addMenuItem({id:g.sGroupName+"-groupButton",enabled:true,text:g.sGroupName,icon:g.aGroupedItems[0].icon,rank:g.aGroupedItems[0].rank,handler:h.bind(this,i,e,o)},true);}}.bind(this));};return a;},true);
