/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['sap/base/Version','sap/base/events/PseudoEvents','sap/base/events/checkMouseEnterOrLeave','sap/ui/events/ControlEvents','sap/ui/Device','sap/ui/events/MapTouchToMouse','sap/ui/thirdparty/jquery','sap/ui/thirdparty/jquery-mobile-custom','sap/ui/dom/jquery/control','sap/ui/events/jqueryEvent'],function(V,P,c,C,D,M,q){"use strict";var e={};e.aAdditionalControlEvents=[];e.aAdditionalPseudoEvents=[];e._createSimulatedEvent=function(s,o,h){var H="__"+s+"Handler";var S="sap"+s;this.aAdditionalControlEvents.push(S);this.aAdditionalPseudoEvents.push({sName:s,aTypes:[S],fnCheck:function(E){return true;}});q.event.special[S]={add:function(a){var t=this,$=q(this),A={domRef:t,eventName:s,sapEventName:S,eventHandle:a};var f=function(E){h(E,A);};a.__sapSimulatedEventHandler=f;for(var i=0;i<o.length;i++){$.on(o[i],f);}},remove:function(a){var $=q(this);var h=a.__sapSimulatedEventHandler;$.removeData(H+a.guid);for(var i=0;i<o.length;i++){q.event.remove(this,o[i],h);}}};};e._fnMouseToTouchHandler=function(E,o){var d=q(o.domRef);if(E.isMarked("delayedMouseEvent")){return;}if(!(E.type!="mouseout"||(E.type==="mouseout"&&c(E,o.domRef)))){var s=true;var a=d.data("__touchstart_control");if(a){var b=window.document.getElementById(a);if(b&&c(E,b)){s=false;}}if(s){return;}}var n=q.event.fix(E.originalEvent||E);n.type=o.sapEventName;if(n.isMarked("firstUIArea")){n.setMark("handledByUIArea",false);}var t=[{identifier:1,pageX:n.pageX,pageY:n.pageY,clientX:n.clientX,clientY:n.clientY,screenX:n.screenX,screenY:n.screenY,target:n.target,radiusX:1,radiusY:1,rotationAngle:0}];switch(o.eventName){case"touchstart":case"touchmove":n.touches=n.changedTouches=n.targetTouches=t;break;case"touchend":n.changedTouches=t;n.touches=n.targetTouches=[];break;}if(o.eventName==="touchstart"||d.data("__touch_in_progress")){d.data("__touch_in_progress","X");var f=q.fn.control?q(E.target).control(0):null;if(f){d.data("__touchstart_control",f.getId());}if(E.type==="mouseout"){n.setMarked("fromMouseout");}if(E.type!=="dragstart"){o.eventHandle.handler.call(o.domRef,n);}if((o.eventName==="touchend"||E.type==="dragstart")&&!n.isMarked("fromMouseout")){d.removeData("__touch_in_progress");d.removeData("__touchstart_control");}}};e._initTouchEventSimulation=function(){this._createSimulatedEvent("touchstart",["mousedown"],this._fnMouseToTouchHandler);this._createSimulatedEvent("touchend",["mouseup","mouseout"],this._fnMouseToTouchHandler);this._createSimulatedEvent("touchmove",["mousemove","dragstart"],this._fnMouseToTouchHandler);};e._initContextMenuSimulation=function(){var s=function(E,o){var n=q.event.fix(E.originalEvent||E);n.type=o.sapEventName;if(!window.getSelection||!window.getSelection()||window.getSelection().toString()===""){o.eventHandle.handler.call(o.domRef,n);}};this._createSimulatedEvent("contextmenu",["taphold"],s);};e._initMouseEventSimulation=function(b){var f=false,m=q.vmouse.moveDistanceThreshold,s,S,o,O,l;var a=function(E,d,g){var n=q.event.fix(E.originalEvent||E);n.type=d.sapEventName;delete n.touches;delete n.changedTouches;delete n.targetTouches;n.screenX=g.screenX;n.screenY=g.screenY;n.clientX=g.clientX;n.clientY=g.clientY;n.ctrlKey=g.ctrlKey;n.altKey=g.altKey;n.shiftKey=g.shiftKey;n.button=0;return n;};var t=function(E,d){if(E.isMarked("handledByTouchToMouse")){return;}E.setMarked("handledByTouchToMouse");if(!f){var g=E.originalEvent.touches[0];f=(Math.abs(g.pageX-s)>m||Math.abs(g.pageY-S)>m);}if(b){if(l&&E.timeStamp-l<50){return;}l=E.timeStamp;}var n=a(E,d,E.touches[0]);setTimeout(function(){n.setMark("handledByUIArea",false);d.eventHandle.handler.call(d.domRef,n);},0);};var T=function(E,d){if(E.isMarked("handledByTouchToMouse")){return;}E.setMarked("handledByTouchToMouse");var n,N,g;function h(){return a(E,d,d.eventName==="mouseup"?E.changedTouches[0]:E.touches[0]);}if(E.type==="touchstart"){var i=E.originalEvent.touches[0];f=false;l=0;s=i.pageX;S=i.pageY;o=Math.round(i.pageX-q(E.target).offset().left);O=Math.round(i.pageY-q(E.target).offset().top);n=h();setTimeout(function(){n.setMark("handledByUIArea",false);d.eventHandle.handler.call(d.domRef,n);},0);}else if(E.type==="touchend"){N=h();g=!f;setTimeout(function(){N.setMark("handledByUIArea",false);d.eventHandle.handler.call(d.domRef,N);if(g){N.type="click";N.getPseudoTypes=q.Event.prototype.getPseudoTypes;N.setMark("handledByUIArea",false);N.offsetX=o;N.offsetY=O;d.eventHandle.handler.call(d.domRef,N);}},0);}};this._createSimulatedEvent("mousedown",["touchstart"],T);this._createSimulatedEvent("mousemove",["touchmove"],t);this._createSimulatedEvent("mouseup",["touchend","touchcancel"],T);};e._init=function(E){this.aAdditionalControlEvents.push("swipe","tap","swipeleft","swiperight","scrollstart","scrollstop");this.aAdditionalPseudoEvents.push({sName:"swipebegin",aTypes:["swipeleft","swiperight"],fnCheck:function(o){var r=sap.ui.getCore().getConfiguration().getRTL();return(r&&o.type==="swiperight")||(!r&&o.type==="swipeleft");}});this.aAdditionalPseudoEvents.push({sName:"swipeend",aTypes:["swipeleft","swiperight"],fnCheck:function(o){var r=sap.ui.getCore().getConfiguration().getRTL();return(!r&&o.type==="swiperight")||(r&&o.type==="swipeleft");}});if(V(q.fn.jquery).compareTo("1.9.1")<0){E=E.concat(this.aAdditionalControlEvents);}else{E=this.aAdditionalControlEvents.concat(E);}for(var i=0;i<this.aAdditionalPseudoEvents.length;i++){P.addEvent(this.aAdditionalPseudoEvents[i]);}return E;};if(D.browser.webkit&&/Mobile/.test(navigator.userAgent)&&D.support.touch){M.init(window.document);e.disableTouchToMouseHandling=M.disableTouchToMouseHandling;}if(!e.disableTouchToMouseHandling){e.disableTouchToMouseHandling=q.noop;}if(D.support.touch){C.events.push("touchstart","touchend","touchmove","touchcancel");}(function initTouchEventSupport(){e.touchEventMode="SIM";if(D.support.touch){e.touchEventMode="ON";q.event.props.push("touches","targetTouches","changedTouches");}var E=!(D.os.windows_phone&&D.os.version<10);if(E){e._initTouchEventSimulation();}if(D.os.ios){e._initContextMenuSimulation();}if(D.support.touch&&E){e.disableTouchToMouseHandling();e._initMouseEventSimulation(D.os.blackberry);}C.events=e._init(C.events);}());return e;});
