/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/fl/Persistence","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Cache","sap/ui/fl/registry/Settings","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/View","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/fl/context/ContextManager","sap/ui/core/Element"],function(q,P,C,U,L,a,V,b,F,c,d,J,X,e,E){"use strict";var f=function(s,A){this._oChangePersistence=undefined;this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;if(this._sComponentName&&this._sAppVersion){this._createChangePersistence();}};f.appliedChangesCustomDataKey="sap.ui.fl.appliedChanges";f.failedChangesCustomDataKeyJs="sap.ui.fl.failedChanges.js";f.failedChangesCustomDataKeyXml="sap.ui.fl.failedChanges.xml";f.PENDING="sap.ui.fl:PendingChange";f.PROCESSING="sap.ui.fl:ProcessingChange";f.variantTechnicalParameterName="sap-ui-fl-control-variant-id";f.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};f.prototype.getComponentName=function(){return this._sComponentName;};f.prototype.getAppVersion=function(){return this._sAppVersion;};f.prototype.getVariantModelData=function(){var D;if(this._oChangePersistence&&this._oChangePersistence._oVariantController._mVariantManagement&&Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length>0){D=this._oChangePersistence._oVariantController._fillVariantModel();}return D;};f.prototype.createBaseChange=function(o,A){var g,h;var i=e._getContextIdsFromUrl();if(i.length>1){throw new Error("More than one DesignTime Context is currently active.");}if(!A){throw new Error("No Application Component found - to offer flexibility. Valid relation to its owning application component must be present.");}o.reference=this.getComponentName();o.packageName="$TMP";o.context=i.length===1?i[0]:"";o.validAppVersions=this._getValidAppVersions(o);g=a.createInitialFileContent(o);h=new a(g);if(o.variantReference){h.setVariantReference(o.variantReference);}return h;};f.prototype.createChange=function(o,g){var h,i;if(!g){throw new Error("A flexibility change cannot be created without a targeted control.");}var s=g.id||g.getId();if(!o.selector){o.selector={};}var A=g.appComponent||U.getAppComponentForControl(g);if(!A){throw new Error("No Application Component found - to offer flexibility the control with the id '"+s+"' has to have a valid relation to its owning application component.");}if(U.hasLocalIdSuffix(s,A)){var l=A.getLocalId(s);if(!l){throw new Error("Generated ID attribute found ('"+s+"'); provide a stable ID for the control as required by flexibility for assigning the changes.");}o.selector.id=l;o.selector.idIsLocal=true;}else{o.selector.id=s;o.selector.idIsLocal=false;}h=this.createBaseChange(o,A);var j=g.controlType||U.getControlType(g);if(!j){throw new Error("No control type found - the change handler can not be retrieved.");}i=this._getChangeHandler(h,j,g,J);if(i){i.completeChangeContent(h,o,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return h;};f.prototype.createVariant=function(v,A){var o,g;if(!A){throw new Error("No Application Component found - to offer flexibility the variant has to have a valid relation to its owning application component.");}v.content.reference=this.getComponentName();v.content.packageName="$TMP";v.content.validAppVersions=this._getValidAppVersions(v);g=V.createInitialFileContent(v);o=new V(g);return o;};f.prototype._getValidAppVersions=function(o){var A=this.getAppVersion();var v={creation:A,from:A};if(A&&o.developerMode&&o.scenario!==sap.ui.fl.Scenario.AdaptationProject&&o.scenario!==sap.ui.fl.Scenario.AppVariant){v.to=A;}return v;};f.prototype.addChange=function(o,g){var h=this.createChange(o,g);var i=U.getAppComponentForControl(g);this.addPreparedChange(h,i);return h;};f.prototype.addPreparedChange=function(o,A){if(o.getVariantReference()){var m=A.getModel("$FlexVariants");m._addChange(o);}this._oChangePersistence.addChange(o,A);return o;};f.prototype.deleteChange=function(o,A){this._oChangePersistence.deleteChange(o);if(o.getVariantReference()){A.getModel("$FlexVariants")._removeChange(o);}};f.prototype.createAndApplyChange=function(o,g){var h=this.addChange(o,g);var p={modifier:J,appComponent:U.getAppComponentForControl(g),view:U.getViewForControl(g)};return this.checkTargetAndApplyChange(h,g,p).then(function(r){if(!r.success){var i=r.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(h);throw i;}}.bind(this));};f.prototype._checkDependencies=function(o,D,m,A,r){var R=this._checkChange(o,A);if(!R){return[];}r.push(o);var s=o.getId();var g=D[s]&&D[s].dependencies||[];for(var i=0,n=g.length;i<n;i++){var h=U.getChangeFromChangesMap(m,g[i]);R=this._checkDependencies(h,D,m,A,r);if(R.length===0){r=[];break;}delete D[s];}return r;};f.prototype._checkChange=function(o,A){var s;var S=o.getSelector();if(S.idIsLocal){s=A.createId(S.id);}else{s=S.id;}var g=sap.ui.getCore().byId(s);if(!g){return false;}var h=this._getFailedCustomDataJs(o,g,J).customDataEntries;if(h.indexOf(o.getId())>-1){return false;}return true;};f.prototype.waitForChangesToBeApplied=function(o){var m=this._oChangePersistence.getChangesMapForComponent();var p=[];var D=q.extend({},m.mDependencies);var g=m.mChanges;var h=g[o.getId()]||[];var A=this._getAppliedCustomData(undefined,o,J).customDataEntries;var i=U.getAppComponentForControl(o);var n=h.filter(function(j){return A.indexOf(j.getId())===-1;});var r=[];n.forEach(function(j){var k=this._checkDependencies(j,D,m.mChanges,i,[]);r=r.concat(k);},this);r=r.filter(function(j,k,l){return l.indexOf(j)===k;});r.forEach(function(w){if(!w.aPromiseFn){w.aPromiseFn=[];}p.push(new Promise(function(j,k){w.aPromiseFn.push({resolve:j,reject:k});}).catch(function(j){var k=j.getId&&m.mDependentChangesOnMe[j.getId()]||[];k.forEach(function(s){var l=U.getChangeFromChangesMap(g,s);if(l.aPromiseFn){l.aPromiseFn.forEach(function(t){t.reject(l);});}});Promise.resolve();}));},this);return Promise.all(p);};f.prototype.saveAll=function(s){return this._oChangePersistence.saveDirtyChanges(s);};f.prototype.processXmlView=function(v,p){var o=sap.ui.getCore().getComponent(p.componentId);var A=U.getAppComponentForControl(o);var m=o.getManifest();p.appComponent=A;p.appDescriptor=m;p.modifier=X;p.view=v;return this.processViewByModifier(p);};f.prototype.processViewByModifier=function(p){p.siteId=U.getSiteId(p.appComponent);return this._oChangePersistence.getChangesForView(p.viewId,p).then(this._resolveGetChangesForView.bind(this,p),this._handlePromiseChainError.bind(this,p.view));};f.prototype._resolveGetChangesForView=function(p,g){var h=[];if(!Array.isArray(g)){var s="No list of changes was passed for processing the flexibility on view: "+p.view+".";U.log.error(s,undefined,"sap.ui.fl.FlexController");return[];}g.forEach(function(o){try{var S=this._getSelectorOfChange(o);if(!S||!S.id){throw new Error("No selector in change found or no selector ID.");}var i=p.modifier.bySelector(S,p.appComponent,p.view);if(!i){throw new Error("A flexibility change tries to change a nonexistent control.");}h.push(function(){return this.checkTargetAndApplyChange(o,i,p).then(function(r){if(!r.success){this._logApplyChangeError(r.error||{},o);}}.bind(this));}.bind(this));}catch(j){this._logApplyChangeError(j,o);}}.bind(this));return U.execPromiseQueueSequentially(h).then(function(){return p.view;});};f.prototype._logApplyChangeError=function(o,g){var D=g.getDefinition();var s=D.changeType;var t=D.selector.id;var h=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(o.message){w+="\n   occurred error message: '"+o.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+h;w+="\n   id of targeted control: '"+t+"'.";U.log.warning(w,undefined,"sap.ui.fl.FlexController");};f.prototype.checkTargetAndApplyChange=function(o,g,p){var x=p.modifier.targets==="xmlTree";var m=p.modifier;var s=m.getControlType(g);var h=this._getChangeHandler(o,s,g,m);var S;var r;if(!h){var i="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";U.log.warning(i);return new U.FakePromise({success:false,error:new Error(i)});}if(x&&o.getDefinition().jsOnly){return new U.FakePromise({success:false,error:new Error("Change can not be applied in XML. Retrying in JS.")});}var A=this._getAppliedCustomData(o,g,m);var j=A.customDataValue;var k=A.customData;if(!this._isChangeCurrentlyApplied(g,o,m,A)){var R=this.isChangeHandlerRevertible(o,g,h);return new U.FakePromise().then(function(){S=F.getInstanceOrUndef();if(!R&&S&&S._oSettings.recordUndo){if(x){throw new Error();}return new Promise(function(l){sap.ui.require(["sap/ui/rta/ControlTreeModifier"],function(n){if(!n){U.log.error("Please load 'sap/ui/rta' library if you want to record undo");}else{p.modifier=n;n.startRecordingUndo();r=n;}l();});});}}).then(function(){o.PROCESSING=o.PROCESSING?o.PROCESSING:true;return h.applyChange(o,g,p);}).then(function(I){if(I instanceof E){g=I;}if(!R&&S&&S._oSettings.recordUndo&&r){o.setUndoOperations(r.stopRecordingUndo());}var l=o.getId();var v=j?j+","+l:l;this._writeAppliedChangesCustomData(k,v,p,g);if(o.aPromiseFn){o.aPromiseFn.forEach(function(n){n.resolve(o);});}delete o.PROCESSING;o.APPLIED=true;return{success:true};}.bind(this)).catch(function(l){var n;this._setMergeError(true);var t="Change ''{0}'' could not be applied. Merge error detected while "+"processing the {1}.";if(x){n=this._getFailedCustomDataXml(o,g,m);t=q.sap.formatMessage(t,[o.getId(),"XML tree"]);q.sap.log.warning(t,l.stack||"");}else{n=this._getFailedCustomDataJs(o,g,m);t=q.sap.formatMessage(t,[o.getId(),"JS control tree"]);q.sap.log.error(t,l.stack||"");}var u=n.customData;n.customDataEntries.push(o.getId());var v=n.customDataEntries.join(",");if(x){this._writeFailedChangesCustomDataXml(u,v,p,g);}else{this._writeFailedChangesCustomDataJs(u,v,p,g);}if(o.aPromiseFn){o.aPromiseFn.forEach(function(w){w.reject(o);});}delete o.PROCESSING;return{success:false,error:l};}.bind(this));}return new U.FakePromise({success:true});};f.prototype._removeFromAppliedChangesAndMaybeRevert=function(o,g,p,r){var A,h,i;var m=p.modifier;var s=m.getControlType(g);var j=this._getChangeHandler(o,s,g,m);var R;if(r&&!j){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");return new U.FakePromise();}var k=o.getId();var l=this._getAppliedCustomData(o,g,m);A=l.customDataEntries;h=l.customData;i=A.indexOf(k);if(i===-1&&(o.PROCESSING||o.QUEUED)){R=new Promise(function(n,t){o.aPromiseFn=o.aPromiseFn||[];o.aPromiseFn.push({resolve:n,reject:t});}).then(function(v){return true;});}else{R=new U.FakePromise(false);}return R.then(function(n){if(r&&(n||(!n&&i>-1))){return j.revertChange(o,g,p);}}).then(function(){l=this._getAppliedCustomData(o,g,m);A=l.customDataEntries;h=l.customData;i=A.indexOf(k);if(i>-1&&h){A.splice(i,1);this._writeAppliedChangesCustomData(h,A.join(),p,g);}}.bind(this)).catch(function(n){U.log.error("Change could not be reverted:",n);});};f.prototype._writeAppliedChangesCustomData=function(o,v,p,g){this._writeCustomData(o,v,p,g,f.appliedChangesCustomDataKey);};f.prototype._writeFailedChangesCustomDataXml=function(o,v,p,g){this._writeCustomData(o,v,p,g,f.failedChangesCustomDataKeyXml);};f.prototype._writeFailedChangesCustomDataJs=function(o,v,p,g){this._writeCustomData(o,v,p,g,f.failedChangesCustomDataKeyJs);};f.prototype._writeCustomData=function(o,v,p,g,s){var m=p.modifier;if(o){m.setProperty(o,"value",v);}else{var A=p.appComponent;var h=p.view;o=m.createControl("sap.ui.core.CustomData",A,h);m.setProperty(o,"key",s);m.setProperty(o,"value",v);m.insertAggregation(g,"customData",o,0,h);}};f.prototype._getAppliedCustomData=function(o,g,m){return this._getCustomData(o,g,m,f.appliedChangesCustomDataKey);};f.prototype._getFailedCustomDataXml=function(o,g,m){return this._getCustomData(o,g,m,f.failedChangesCustomDataKeyXml);};f.prototype._getFailedCustomDataJs=function(o,g,m){return this._getCustomData(o,g,m,f.failedChangesCustomDataKeyJs);};f.prototype._getCustomData=function(o,g,m,s){var h=m.getAggregation(g,"customData")||[];var r={customDataEntries:[]};h.some(function(i){var k=m.getProperty(i,"key");if(k===s){r.customData=i;r.customDataValue=m.getProperty(i,"value");r.customDataEntries=r.customDataValue.split(",");return true;}});return r;};f.prototype._handlePromiseChainError=function(v,o){U.log.error("Error processing view "+o+".");return v;};f.prototype._getSelectorOfChange=function(o){if(!o||!o.getSelector){return undefined;}return o.getSelector();};f.prototype._getChangeHandler=function(o,s,g,m){var h=o.getChangeType();var l=o.getLayer();return this._getChangeRegistry().getChangeHandler(h,s,g,m,l);};f.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};f.prototype.getComponentChanges=function(p){return this._oChangePersistence.getChangesForComponent(p);};f.prototype.isPersonalized=function(p){p=p||{};p.includeVariants=true;return this.getComponentChanges(p).then(function(g){var i=g.some(function(o){return o.isUserDependent();});return!!i;});};f.prototype._createChangePersistence=function(){this._oChangePersistence=c.getChangePersistenceForComponent(this.getComponentName(),this.getAppVersion());return this._oChangePersistence;};f.prototype.resetChanges=function(l,g,o){return this._oChangePersistence.resetChanges(l,g).then(function(r){if(o){var m=o.getModel("$FlexVariants");if(m){m.updateHasherEntry({parameters:[],updateURL:true,component:o});}}return r;});};f.prototype.discardChanges=function(g,D){var A=U.getCurrentLayer(!!D);var i=0;var l;var o;l=g.length;while(i<g.length){o=g[i];if(o&&o.getLayer&&o.getLayer()===A){this._oChangePersistence.deleteChange(o);}if(l===g.length){i++;}else{l=g.length;}}return this._oChangePersistence.saveDirtyChanges();};f.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var o=this._oChangePersistence.getChangesMapForComponent();var g=o.mChanges[i]||[];return this.discardChanges(g,D);};f.prototype._setMergeError=function(){return F.getInstance().then(function(s){s.setMergeErrorOccured(true);});};f.prototype._isChangeCurrentlyApplied=function(o,g,m,h){if(!h){h=this._getAppliedCustomData(g,o,J);}var A=h.customDataEntries;var s=g.getId();return A.indexOf(s)>-1;};f.prototype._checkIfDependencyIsStillValid=function(A,m,s){var o=U.getChangeFromChangesMap(this._oChangePersistence._mChanges.mChanges,s);if(!o.APPLIED){return true;}var g=m.bySelector(o.getSelector(),A);if(!this._isChangeCurrentlyApplied(g,o,m)){return true;}return false;};f.prototype._applyChangesOnControl=function(g,A,o){var p=[];var m=g();var h=m.mChanges;var D=m.mDependencies;var i=m.mDependentChangesOnMe;var j=h[o.getId()]||[];var k={modifier:J,appComponent:A,view:U.getViewForControl(o)};j.forEach(function(l){if(l.APPLIED&&!this._isChangeCurrentlyApplied(o,l,k.modifier)){m=this._oChangePersistence.copyDependenciesFromInitialChangesMap(l,this._checkIfDependencyIsStillValid.bind(this,A,k.modifier));D=m.mDependencies;i=m.mDependentChangesOnMe;delete l.APPLIED;}if(!D[l.getId()]){l.QUEUED=true;p.push(function(){return this.checkTargetAndApplyChange(l,o,k).then(function(r){if(r.success){this._updateDependencies(D,i,l.getId());}delete l.QUEUED;}.bind(this));}.bind(this));}else{D[l.getId()][f.PENDING]=this.checkTargetAndApplyChange.bind(this,l,o,k);}}.bind(this));return U.execPromiseQueueSequentially(p).then(function(){return this._processDependentQueue(D,i);}.bind(this));};f.prototype.getBoundApplyChangesOnControl=function(g,o){var B=this._applyChangesOnControl.bind(this,g,o);B._bIsSapUiFlFlexControllerApplyChangesOnControl=true;return B;};f.prototype.revertChangesOnControl=function(g,A){var p=[];g.forEach(function(o){p.push(function(){var s=this._getSelectorOfChange(o);var h=J.bySelector(s,A);var m={modifier:J,appComponent:A,view:U.getViewForControl(h)};return this._removeFromAppliedChangesAndMaybeRevert(o,h,m,true).then(function(){this._oChangePersistence._deleteChangeInMap(o);}.bind(this));}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};f.prototype.isChangeHandlerRevertible=function(o,g,h){if(!h){var s=J.getControlType(g);h=this._getChangeHandler(o,s,g,J);}return!!(h&&typeof h.revertChange==="function");};f.prototype.applyVariantChanges=function(g,o){var A=U.getAppComponentForControl(o);var p=[];g.forEach(function(h){var m=this._oChangePersistence.getChangesMapForComponent().mChanges;var i=Object.keys(m).reduce(function(g,s){return g.concat(m[s]);},[]);this._oChangePersistence._addChangeAndUpdateDependencies(o,h,i.length,i);p.push(function(){var M=J;var s=this._getSelectorOfChange(h);var j=M.bySelector(s,A);if(!j){U.log.error("A flexibility change tries to change a nonexistent control.");return new U.FakePromise();}return this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence),A,j);}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};f.prototype.removeFromAppliedChangesOnControl=function(o,A,g){var p={modifier:J,appComponent:A,view:U.getViewForControl(g)};return this._removeFromAppliedChangesAndMaybeRevert(o,g,p,false);};f.prototype._updateControlsDependencies=function(D){var o;Object.keys(D).forEach(function(s){var g=D[s];if(g.controlsDependencies&&g.controlsDependencies.length>0){var l=g.controlsDependencies.length;while(l--){var i=g.controlsDependencies[l];o=sap.ui.getCore().byId(i);if(o){g.controlsDependencies.splice(l,1);}}}});};f.prototype._updateDependencies=function(D,m,s){if(m[s]){m[s].forEach(function(k){var o=D[k];var i=o.dependencies.indexOf(s);if(i>-1){o.dependencies.splice(i,1);}});delete m[s];}};f.prototype._iterateDependentQueue=function(D,m){var A=[],g=[],p=[];this._updateControlsDependencies(D);Object.keys(D).forEach(function(s){var o=D[s];if(o[f.PENDING]&&o.dependencies.length===0&&!(o.controlsDependencies&&o.controlsDependencies.length>0)&&!o[f.PROCESSING]){o[f.PROCESSING]=true;p.push(function(){return o[f.PENDING]().then(function(r){if(r.success){g.push(s);A.push(o.changeObject.getId());}});});}});return U.execPromiseQueueSequentially(p).then(function(){for(var j=0;j<g.length;j++){delete D[g[j]];}for(var k=0;k<A.length;k++){this._updateDependencies(D,m,A[k]);}return A;}.bind(this));};f.prototype._processDependentQueue=function(D,m){return this._iterateDependentQueue(D,m).then(function(A){if(A.length>0){return this._processDependentQueue(D,m);}}.bind(this));};return f;},true);
