/*
 * ! UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/ControlPersonalizationAPI',["sap/ui/fl/Utils","sap/ui/fl/registry/ChangeRegistry","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/Element","sap/ui/fl/variants/VariantManagement","sap/ui/core/Component"],function(U,C,J,E,V,a){"use strict";var b="sap-ui-fl-control-variant-id";var c={_determineParameters:function(o){var A=U.getAppComponentForControl(o);var r=A.getRootControl();var v=U.getViewForControl(o);var d=A.getModel("$FlexVariants");var p={appComponent:A,rootControl:r,view:v,variantModel:d,variantManagement:{}};var e;var f;jQuery.makeArray(p.rootControl.$().find(".sapUiFlVarMngmt")).map(function(g){e=sap.ui.getCore().byId(g.id);if(e.getMetadata().getName()==="sap.ui.fl.variants.VariantManagement"){f=e.getFor();f.forEach(function(s){p.variantManagement[s]=p.variantModel._getLocalId(g.id,p.appComponent);});}});return p;},_getVariantManagement:function(o){var p=this._determineParameters(o);var f=function(o){if(!p.variantManagement[o.getId()]&&o.getParent()&&o.getId()!==p.rootControl.getId()){return f(o.getParent());}else if(!o.getParent()||o.getId()===p.rootControl.getId()){return p.variantManagement[o.getId()]||"";}else{return p.variantManagement[o.getId()];}};return f(o);},clearVariantParameterInURL:function(o){var u=[];var A=U.getAppComponentForControl(o);var v=A instanceof a?A.getModel("$FlexVariants"):undefined;if(!v){U.setTechnicalURLParameterValues(undefined,b,u);return U.log.error("Variant model could not be found on the provided control");}if(o instanceof V){var s=v._getLocalId(o.getId(),A);var m=v.getVariantIndexInURL(s);if(m.index>-1){m.parameters[b].splice(m.index,1);u=m.parameters[b].slice(0);}}v.updateHasherEntry({parameters:u,updateURL:true,component:A});},activateVariant:function(e,v){var o;return Promise.resolve().then(function(){if(typeof e==='string'||e instanceof String){o=sap.ui.getCore().getComponent(e);if(!(o instanceof a)){o=sap.ui.getCore().byId(e);if(!(o instanceof E)){throw new Error("A valid component or control cannot be found for the provided Id");}}}else if(e instanceof a||e instanceof E){o=e;}var A=U.getAppComponentForControl(o);if(!A){throw new Error("A valid variant management control or component (instance or id) should be passed as parameter");}var d=A.getModel("$FlexVariants");if(!d){throw new Error("No variant management model found for the passed control or component");}var s=d.getVariantManagementReference(v).variantManagementReference;if(!s){throw new Error("A valid control or component, and variant id combination is required");}return d.updateCurrentVariant(s,v);})["catch"](function(d){U.log.error(d);return Promise.reject(d);});},addPersonalizationChanges:function(d){var o;var v;var s;var S;var m;var e;var f;var p;var P;var g;var h;var j=[];var l=U.getCurrentLayer(true);var G=function(q,r){var t=r.getMetadata().getName();return C.getInstance().getChangeHandler(q,t,r,J,l);};var k=function(m){var g;if(!m.selectorControl||!m.selectorControl.getMetadata){g={change:m,message:"No valid selectorControl"};}else{if(!m.changeSpecificData){g={change:m,message:"No changeSpecificData available"};}else if(!m.changeSpecificData.changeType){g={change:m,message:"No valid changeType"};}else{o=G(m.changeSpecificData.changeType,m.selectorControl);if(!o){g={change:m,message:"No valid ChangeHandler"};}else if(!o.revertChange){g={change:m,message:"ChangeHandler has no revertChange function"};}}}return g;};var A=function(h,S,p){P.variantModel.oFlexController.addPreparedChange(h,P.appComponent);return P.variantModel.oFlexController.checkTargetAndApplyChange(h,S,p);};var n=function(g){return Promise.reject(g);};for(var i=0;i<d.length;i++){m=d[i];e={};jQuery.extend(e,{developerMode:false,layer:l});g=k(m);if(g){j.push(n.bind(this,g));}else{f=m.changeSpecificData;S=m.selectorControl;if(!P){P=this._determineParameters(S);}v=this._getVariantManagement(S);s=undefined;if(!v){g={change:m,message:"No Variant Management Control available for change"};j.push(n.bind(this,g));}else{s=P.variantModel.oData[v].currentVariant;h=P.variantModel.oFlexController.createChange(jQuery.extend(e,f),S,P.appComponent);h.setVariantReference(s);p={appComponent:P.appComponent,view:P.view,modifier:J};j.push(A.bind(this,h,S,p));}}}return U.execPromiseQueueSequentially(j);},hasVariantManagement:function(o){return!!this._getVariantManagement(o);}};return c;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnectorLocalStorage',["sap/ui/fl/FakeLrepLocalStorage","sap/ui/fl/FakeLrepConnector","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/Utils"],function(F,a,L,C,b,U){"use strict";c._oBackendInstances={};
function c(s){this.mSettings=jQuery.extend({"isKeyUser":true,"isAtoAvailable":false,"isProductiveSystem":false},s);}
jQuery.extend(c.prototype,a.prototype);
c.prototype.create=function(v){var r;if(Array.isArray(v)){r=v.map(function(m){return this._saveChange(m);}.bind(this));}else{r=this._saveChange(v);}return Promise.resolve({response:r,status:'success'});};
c.prototype._saveChange=function(m){if(!m.creation){m.creation=new Date().toISOString();}F.saveChange(m.fileName,m);return m;};
c.prototype.update=function(m,s,d,i){return Promise.resolve({response:this._saveChange(m),status:'success'});};
c.prototype.send=function(u,m,d,o){if(m==="DELETE"){return a.prototype.send.apply(this,arguments).then(function(r){F.getChanges().forEach(function(e){if(e.reference===r.response.parameters[1]){F.deleteChange(e.fileName);}});return Promise.resolve({response:undefined,status:"nocontent"});});}else{return a.prototype.send.apply(this,arguments);}};
c.prototype.deleteChange=function(o){F.deleteChange(o.sChangeName);return Promise.resolve({response:undefined,status:"nocontent"});};
c.prototype.deleteChanges=function(){F.deleteChanges();return Promise.resolve({response:undefined,status:"nocontent"});};
c.prototype.loadChanges=function(s){var d=F.getChanges();return new Promise(function(r,e){var R={};if(this.mSettings.sInitialComponentJsonPath){jQuery.getJSON(this.mSettings.sInitialComponentJsonPath).done(function(o){R={changes:o,componentClassName:s};r(R);}).fail(function(f){e(f);});}else{r(R);}}.bind(this)).then(function(r){var v=[];var e=[];var f=[];var g=[];d.forEach(function(o){if(o.fileType==="ctrl_variant"&&o.variantManagementReference){v.push(o);}else if(o.fileType==="ctrl_variant_change"){e.push(o);}else if(o.fileType==="ctrl_variant_management_change"){f.push(o);}else{g.push(o);}});r=this._createChangesMap(r,v);r=this._sortChanges(r,g,e,f);r=this._assignVariantReferenceChanges(r);r.changes.contexts=[];r.changes.settings=this.mSettings;r.componentClassName=s;return r;}.bind(this));};
c.prototype._createChangesMap=function(r,v){if(!r||!r.changes){r={changes:{}};}if(!r.changes.changes){r.changes.changes=[];}if(!r.changes.variantSection){r.changes.variantSection={};}var f=function(e,n){return e.some(function(o){return o.content.fileName===n.fileName;});};var V={};v.forEach(function(o){V=r.changes.variantSection[o.variantManagementReference];if(!V){var s=this._fakeStandardVariant(o.variantManagementReference);V=this._getVariantManagementStructure([this._getVariantStructure(s,[],{}),this._getVariantStructure(o,[],{})],{});r.changes.variantSection[o.variantManagementReference]=V;}else{if(!f(V.variants,o)){V.variants.push(this._getVariantStructure(o,[],{}));}}}.bind(this));return r;};
c.prototype._getVariantStructure=function(v,d,V){return{content:v,controlChanges:d,variantChanges:V};};
c.prototype._getVariantManagementStructure=function(v,V){return{variants:v,variantManagementChanges:V};};
c.prototype._assignVariantReferenceChanges=function(r){Object.keys(r.changes.variantSection).forEach(function(v){var V=r.changes.variantSection[v].variants;V.forEach(function(o){var s=o.content.variantReference;var e=o.controlChanges;if(s){e=this._getReferencedChanges(r,o).concat(e);}o.controlChanges=e;}.bind(this));}.bind(this));return r;};
c.prototype._getReferencedChanges=function(r,o){var R=[];r.changes.variantSection[o.content.variantManagementReference].variants.some(function(v){if(o.content.variantReference===v.content.fileName){R=v.controlChanges.filter(function(d){return U.isLayerAboveCurrentLayer(d.layer)===-1;});if(v.content.variantReference){R=R.concat(this._getReferencedChanges(r,v));}return true;}}.bind(this));return R;};
c.prototype._sortChanges=function(r,d,e,f){var A=function(r,V,o){r.changes.variantSection[V].variants.some(function(h){if(h.content.fileName===o.variantReference){h.controlChanges.push(o);return true;}});};var g=function(r,V,o){r.changes.variantSection[V].variants.some(function(h){if(h.content.fileName===o.selector.id){if(!h.variantChanges[o.changeType]){h.variantChanges[o.changeType]=[];}h.variantChanges[o.changeType].push(o);return true;}});};var v={};f.forEach(function(V){var s=V.selector.id;if(Object.keys(r.changes.variantSection).length===0){r.changes.variantSection[s]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(s),[],{})],{});}v=r.changes.variantSection[s].variantManagementChanges;if(!v[V.changeType]){v[V.changeType]=[];}v[V.changeType].push(V);}.bind(this));d.forEach(function(o){if(!o.variantReference){r.changes.changes.push(o);}else if(Object.keys(r.changes.variantSection).length===0){r.changes.variantSection[o.variantReference]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(o.variantReference),[o],{})],{});}else{Object.keys(r.changes.variantSection).forEach(function(V){A(r,V,o);});}}.bind(this));e.forEach(function(V){if(Object.keys(r.changes.variantSection).length===0){var m={};m[V.changeType]=[V];r.changes.variantSection[V.selector.id]=this._getVariantManagementStructure([this._getVariantStructure(this._fakeStandardVariant(V.selector.id),[],m)],{});}else{Object.keys(r.changes.variantSection).forEach(function(s){g(r,s,V);});}}.bind(this));return r;};
c.prototype._fakeStandardVariant=function(v){return{fileName:v,fileType:"ctrl_variant",variantManagementReference:v,variantReference:"",content:{title:sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl").getText("STANDARD_VARIANT_TITLE")}};};
c.prototype.loadSettings=function(){return new Promise(function(r,d){var s={};r(s);});};
c.enableFakeConnector=function(s,A,d){s=s||{};function r(){c.enableFakeConnector.original=L.createConnector;L.createConnector=function(){if(!c._oFakeInstance){c._oFakeInstance=new c(s);}return c._oFakeInstance;};}if(A&&d){var o=b.getChangePersistenceForComponent(A,d);if(!(o._oConnector instanceof c)){C.clearEntry(A,d);if(!c._oBackendInstances[A]){c._oBackendInstances[A]={};}c._oBackendInstances[A][d]=o._oConnector;o._oConnector=new c(s);}r();return;}C.clearEntries();if(c.enableFakeConnector.original){return;}r();};
c.disableFakeConnector=function(A,s){function r(){if(c.enableFakeConnector.original){L.createConnector=c.enableFakeConnector.original;c.enableFakeConnector.original=undefined;c._oFakeInstance=undefined;}}if(A&&s){var o=b.getChangePersistenceForComponent(A,s);if(!(o._oConnector instanceof L)){C.clearEntry(A,s);if(c._oBackendInstances[A]&&c._oBackendInstances[A][s]){o._oConnector=c._oBackendInstances[A][s];c._oBackendInstances[A][s]=undefined;}}r();return;}C.clearEntries();r();};
return c;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepLocalStorage',[],function(){"use strict";var F="sap.ui.fl.change";var a="sap.ui.fl.variant";var b={};
b.createChangeKey=function(i){if(i){return F+"."+i;}};
b.createVariantKey=function(i){if(i){return a+"."+i;}};
b.forEachLrepChangeInLocalStorage=function(p){for(var k in window.localStorage){if(k.indexOf(F)>-1||k.indexOf(a)>-1){p(k);}}};
b.getChange=function(i){if(i){var c=window.localStorage.getItem(this.createChangeKey(i));if(!c){c=window.localStorage.getItem(this.createVariantKey(i));}return JSON.parse(c);}};
b.getChanges=function(){var c=[],C;this.forEachLrepChangeInLocalStorage(function(k){C=JSON.parse(window.localStorage[k]);c.push(C);});return c;};
b.getNumChanges=function(){var c=0;this.forEachLrepChangeInLocalStorage(function(k){c++;});return c;};
b._aModifyCallbacks=[];
b.attachModifyCallback=function(c){this._aModifyCallbacks.push(c);};
b.detachModifyCallback=function(c){var i=this._aModifyCallbacks.indexOf(c);if(i!==-1){this._aModifyCallbacks.splice(i,1);}};
b._callModifyCallbacks=function(m){this._aModifyCallbacks.forEach(function(c){c(m);});};
b.deleteChange=function(i){if(i){window.localStorage.removeItem(this.createChangeKey(i));window.localStorage.removeItem(this.createVariantKey(i));}this._callModifyCallbacks("delete");};
b.deleteChanges=function(){this.forEachLrepChangeInLocalStorage(function(k){window.localStorage.removeItem(k);});this._callModifyCallbacks("delete");};
b.saveChange=function(i,c){var C,s;if(i&&c){if(c.fileType==="ctrl_variant"&&c.variantManagementReference){C=this.createVariantKey(i);}else{C=this.createChangeKey(i);}s=JSON.stringify(c);window.localStorage.setItem(C,s);}this._callModifyCallbacks("save");};
return b;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantManagement',['jquery.sap.global','sap/ui/model/Context','sap/ui/model/PropertyBinding','sap/ui/model/json/JSONModel','sap/ui/model/Filter','sap/ui/Device','sap/ui/core/TextAlign','sap/ui/core/InvisibleText','sap/ui/core/Control','sap/ui/core/Icon','sap/ui/core/ValueState','sap/ui/layout/HorizontalLayout','sap/ui/layout/Grid','sap/m/SearchField','sap/m/RadioButton','sap/m/ScreenSize','sap/m/PopinDisplay','sap/m/ColumnListItem','sap/m/Column','sap/m/Text','sap/m/Bar','sap/m/Table','sap/m/Page','sap/m/PlacementType','sap/m/ButtonType','sap/m/Toolbar','sap/m/ToolbarSpacer','sap/m/Button','sap/m/CheckBox','sap/m/Dialog','sap/m/Input','sap/m/Label','sap/m/Title','sap/m/ResponsivePopover','sap/m/SelectList','sap/m/ObjectIdentifier','sap/m/OverflowToolbar','sap/m/OverflowToolbarPriority','sap/m/OverflowToolbarLayoutData','sap/m/VBox','sap/ui/fl/Utils','../changeHandler/BaseTreeModifier'],function(q,C,P,J,F,D,T,I,a,b,V,H,G,S,R,c,d,f,g,h,B,i,j,k,l,m,n,o,p,r,s,L,t,u,v,O,w,x,y,z,A,E){"use strict";
var K=a.extend("sap.ui.fl.variants.VariantManagement",{
metadata:{library:"sap.ui.fl",designtime:"sap/ui/fl/designtime/variants/VariantManagement.designtime",properties:{showExecuteOnSelection:{type:"boolean",group:"Misc",defaultValue:false},showSetAsDefault:{type:"boolean",group:"Misc",defaultValue:true},manualVariantKey:{type:"boolean",group:"Misc",defaultValue:false},inErrorState:{type:"boolean",group:"Misc",defaultValue:false},editable:{type:"boolean",group:"Misc",defaultValue:true},modelName:{type:"string",group:"Misc",defaultValue:null},updateVariantInURL:{type:"boolean",group:"Misc",defaultValue:false}},associations:{"for":{type:"sap.ui.core.Control",multiple:true}},events:{save:{parameters:{name:{type:"string"},overwrite:{type:"boolean"},key:{type:"string"},execute:{type:"boolean"},def:{type:"boolean"}}},manage:{},initialized:{},select:{parameters:{key:{type:"string"}}}}},
renderer:function(e,M){e.write("<div ");e.writeControlData(M);e.addClass("sapUiFlVarMngmt");e.writeClasses();e.write(">");e.renderControl(M.oVariantLayout);e.write("</div>");}
});
K.MODEL_NAME="$FlexVariants";K.INNER_MODEL_NAME="$sapUiFlVariants";K.MAX_NAME_LEN=100;K.COLUMN_FAV_IDX=0;K.COLUMN_NAME_IDX=1;
K.prototype.init=function(){this._sModelName=K.MODEL_NAME;this.attachModelContextChange(this._setModel,this);this._oRb=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this._createInnerModel();this.oVariantInvisibleText=new I({text:{parts:[{path:'currentVariant',model:this._sModelName},{path:"modified",model:this._sModelName}],formatter:function(M,N){if(N){M=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT_MOD",[M]);}else{M=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT",[M]);}}.bind(this)}});this.oVariantText=new t(this.getId()+"-text",{text:{path:'currentVariant',model:this._sModelName,formatter:function(M){var N=this.getSelectedVariantText(M);return N;}.bind(this)}});this.oVariantText.addStyleClass("sapUiFlVarMngmtClickable");this.oVariantText.addStyleClass("sapUiFlVarMngmtTitle");if(D.system.phone){this.oVariantText.addStyleClass("sapUiFlVarMngmtTextPhoneMaxWidth");}else{this.oVariantText.addStyleClass("sapUiFlVarMngmtTextMaxWidth");}var e=new L(this.getId()+"-modified",{text:"*",visible:{path:"modified",model:this._sModelName,formatter:function(M){return(M===null||M===undefined)?false:M;}}});e.setVisible(false);e.addStyleClass("sapUiFlVarMngmtModified");e.addStyleClass("sapUiFlVarMngmtClickable");e.addStyleClass("sapMTitleStyleH4");this.oVariantPopoverTrigger=new o(this.getId()+"-trigger",{icon:"sap-icon://slim-arrow-down",type:l.Transparent});this.oVariantPopoverTrigger.addAriaLabelledBy(this.oVariantInvisibleText);this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtn");this.oVariantPopoverTrigger.addStyleClass("sapMTitleStyleH4");this.oVariantLayout=new H({content:[this.oVariantText,e,this.oVariantPopoverTrigger,this.oVariantInvisibleText]});this.oVariantLayout.addStyleClass("sapUiFlVarMngmtLayout");this.addDependent(this.oVariantLayout);};
K.prototype.getTitle=function(){return this.oVariantText;};
K.prototype._createInnerModel=function(){var M=new J({showExecuteOnSelection:false,showSetAsDefault:true,editable:true,popoverTitle:this._oRb.getText("VARIANT_MANAGEMENT_VARIANTS")});this.setModel(M,K.INNER_MODEL_NAME);this._bindProperties();};
K.prototype._bindProperties=function(){this.bindProperty("showExecuteOnSelection",{path:"/showExecuteOnSelection",model:K.INNER_MODEL_NAME});this.bindProperty("showSetAsDefault",{path:"/showSetAsDefault",model:K.INNER_MODEL_NAME});this.bindProperty("editable",{path:"/editable",model:K.INNER_MODEL_NAME});};
K.prototype.getOriginalDefaultVariantKey=function(){var M=this.getModel(this._sModelName);if(M&&this.oContext){return M.getProperty(this.oContext+"/originalDefaultVariant");}return null;};
K.prototype.setDefaultVariantKey=function(e){var M=this.getModel(this._sModelName);if(M&&this.oContext){M.setProperty(this.oContext+"/defaultVariant",e);}};
K.prototype.getDefaultVariantKey=function(){var M=this.getModel(this._sModelName);if(M&&this.oContext){return M.getProperty(this.oContext+"/defaultVariant");}return null;};
K.prototype.setCurrentVariantKey=function(e){var M=this.getModel(this._sModelName);if(M&&this.oContext){M.setProperty(this.oContext+"/currentVariant",e);}return this;};
K.prototype.getCurrentVariantKey=function(){var M=this.getModel(this._sModelName);if(M&&this.oContext){return M.getProperty(this.oContext+"/currentVariant");}return null;};
K.prototype._assignPopoverTitle=function(){var e,M,N=this.getModel(this._sModelName);if(N&&this.oContext){e=N.getProperty(this.oContext+"/popoverTitle");}if(e!==undefined){M=this.getModel(K.INNER_MODEL_NAME);if(M){M.setProperty("/popoverTitle",e);}}};
K.prototype.getVariants=function(){return this._getItems();};
K.prototype.setModified=function(e){var M=this.getModel(this._sModelName);if(M&&this.oContext){M.setProperty(this.oContext+"/modified",e);}};
K.prototype.getModified=function(){var M=this.getModel(this._sModelName);if(M&&this.oContext){return M.getProperty(this.oContext+"/modified");}return false;};
K.prototype.getSelectedVariantText=function(e){var M=this._getItemByKey(e);if(M){return M.title;}return"";};
K.prototype.getStandardVariantKey=function(){var e=this._getItems();if(e&&e[0]){return e[0].key;}return null;};
K.prototype.getShowFavorites=function(){var M=this.getModel(this._sModelName);if(M&&this.oContext){return M.getProperty(this.oContext+"/showFavorites");}return false;};
K.prototype._clearDeletedItems=function(){this._aDeletedItems=[];};
K.prototype._addDeletedItem=function(e){this._aDeletedItems.push(e);};
K.prototype._getDeletedItems=function(e){return this._aDeletedItems;};
K.prototype._getItems=function(){var e=[];if(this.oContext&&this.oContext.getObject()){e=this.oContext.getObject().variants.filter(function(M){if(!M.hasOwnProperty("visible")){return true;}return M.visible;});}return e;};
K.prototype._getItemByKey=function(e){var M=null,N=this._getItems();N.some(function(Q){if(Q.key===e){M=Q;}return(M!=null);});return M;};
K.prototype._rebindControl=function(e){this.oVariantInvisibleText.unbindProperty("text");this.oVariantInvisibleText.bindProperty("text",{parts:[{path:'currentVariant',model:this._sModelName},{path:"modified",model:this._sModelName}],formatter:function(M,N){if(N){M=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT_MOD",[M]);}else{M=this._oRb.getText("VARIANT_MANAGEMENT_SEL_VARIANT",[M]);}}.bind(this)});this.oVariantText.unbindProperty("text");this.oVariantText.bindProperty("text",{path:'currentVariant',model:this._sModelName,formatter:function(M){var N=this.getSelectedVariantText(M);return N;}.bind(this)});this.oVariantText.unbindProperty("visible",{path:"modified",model:this._sModelName,formatter:function(M){return(M===null||M===undefined)?false:M;}});};
K.prototype.setModelName=function(e){if(this.getModelName()){this.oContext=null;}this.setProperty("modelName",e);this._sModelName=e;this._rebindControl();};
K.prototype._setBindingContext=function(){var M,e;if(!this.oContext){M=this.getModel(this._sModelName);if(M){e=this._getLocalId();if(e){this.oContext=new C(M,"/"+e);this.setBindingContext(this.oContext,this._sModelName);if(!this.getModelName()&&M.registerToModel){M.registerToModel(this);}this._assignPopoverTitle();this._registerPropertyChanges(M);this.fireInitialized();}}}};
K.prototype._getLocalId=function(){if(this.getModelName()&&(this._sModelName!==K.MODEL_NAME)){return this.getId();}return E.getSelector(this,A.getComponentForControl(this)).id;};
K.prototype._setModel=function(){this._setBindingContext();};
K.prototype._registerPropertyChanges=function(M){var e=new P(M,this.oContext+"/variantsEditable");e.attachChange(function(N){if(N&&N.oSource&&N.oSource.oModel&&N.oSource.sPath){var Q,U=N.oSource.oModel.getProperty(N.oSource.sPath);Q=this.getModel(K.INNER_MODEL_NAME);if(Q){Q.setProperty("/editable",U);}}}.bind(this));};
K.prototype.handleOpenCloseVariantPopover=function(){if(!this.bPopoverOpen){this._openVariantList();}else if(this.oVariantPopOver&&this.oVariantPopOver.isOpen()){this.oVariantPopOver.close();}else if(this.getInErrorState()&&this.oErrorVariantPopOver&&this.oErrorVariantPopOver.isOpen()){this.oErrorVariantPopOver.close();}};
K.prototype.getFocusDomRef=function(){if(this.oVariantPopoverTrigger){return this.oVariantPopoverTrigger.getFocusDomRef();}};
K.prototype.onclick=function(e){if(this.oVariantPopoverTrigger&&!this.bPopoverOpen){this.oVariantPopoverTrigger.focus();}this.handleOpenCloseVariantPopover();};
K.prototype.onkeydown=function(e){if(e.which===q.sap.KeyCodes.F4||e.which===q.sap.KeyCodes.SPACE||e.altKey===true&&e.which===q.sap.KeyCodes.ARROW_UP||e.altKey===true&&e.which===q.sap.KeyCodes.ARROW_DOWN){this._openVariantList();}};
K.prototype.onAfterRendering=function(){this.oVariantText.$().off("mouseover").on("mouseover",function(){this.oVariantPopoverTrigger.addStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));this.oVariantText.$().off("mouseout").on("mouseout",function(){this.oVariantPopoverTrigger.removeStyleClass("sapUiFlVarMngmtTriggerBtnHover");}.bind(this));};
K.prototype._openInErrorState=function(){var M;if(!this.oErrorVariantPopOver){M=new z({fitContainer:true,alignItems:sap.m.FlexAlignItems.Center,items:[new b({size:"4rem",color:"lightgray",src:"sap-icon://message-error"}),new t({titleStyle:sap.ui.core.TitleLevel.H2,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT1")}),new h({textAlign:sap.ui.core.TextAlign.Center,text:this._oRb.getText("VARIANT_MANAGEMENT_ERROR_TEXT2")})]});M.addStyleClass("sapUiFlVarMngmtErrorPopover");this.oErrorVariantPopOver=new u(this.getId()+"-errorpopover",{title:{path:"/popoverTitle",model:K.INNER_MODEL_NAME},contentWidth:"400px",placement:k.Bottom,content:[new j(this.getId()+"-errorselpage",{showSubHeader:false,showNavButton:false,showHeader:false,content:[M]})],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oErrorVariantPopOver.attachBrowserEvent("keyup",function(e){if(e.which===32){this.oErrorVariantPopOver.close();}}.bind(this));}if(this.bPopoverOpen){return;}this.oErrorVariantPopOver.openBy(this.oVariantLayout);};
K.prototype._createVariantList=function(){if(this.oVariantPopOver){return;}this.oVariantManageBtn=new o(this.getId()+"-manage",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGE"),enabled:true,press:function(){this._openManagementDialog();}.bind(this),layoutData:new y({priority:x.Low})});this.oVariantSaveBtn=new o(this.getId()+"-mainsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVE"),press:function(){this._handleVariantSave();}.bind(this),enabled:{path:"modified",model:this._sModelName,formatter:function(M){return M;}},layoutData:new y({priority:x.Low})});this.oVariantSaveAsBtn=new o(this.getId()+"-saveas",{text:this._oRb.getText("VARIANT_MANAGEMENT_SAVEAS"),press:function(){this._openSaveAsDialog();}.bind(this),layoutData:new y({priority:x.Low})});this._oVariantList=new v(this.getId()+"-list",{selectedKey:{path:"currentVariant",model:this._sModelName},itemPress:function(M){var N=null;if(M&&M.getParameters()){var Q=M.getParameters().item;if(Q){N=Q.getKey();}}if(N){this.setCurrentVariantKey(N);this.fireEvent("select",{key:N});this.oVariantPopOver.close();}}.bind(this)});this._oVariantList.setNoDataText(this._oRb.getText("VARIANT_MANAGEMENT_NODATA"));var e=new sap.ui.core.Item({key:'{'+this._sModelName+">key}",text:'{'+this._sModelName+">title}"});this._oVariantList.bindAggregation("items",{path:"variants",model:this._sModelName,template:e});this._oSearchField=new S(this.getId()+"-search");this._oSearchField.attachLiveChange(function(M){this._triggerSearch(M,this._oVariantList);}.bind(this));this.oVariantSelectionPage=new j(this.getId()+"-selpage",{subHeader:new m({content:[this._oSearchField]}),content:[this._oVariantList],footer:new w({content:[new n(this.getId()+"-spacer"),this.oVariantSaveBtn,this.oVariantSaveAsBtn,this.oVariantManageBtn]}),showNavButton:false,showHeader:false,showFooter:{path:"/editable",model:K.INNER_MODEL_NAME}});this.oVariantPopOver=new u(this.getId()+"-popover",{title:{path:"/popoverTitle",model:K.INNER_MODEL_NAME},contentWidth:"400px",placement:k.Bottom,content:[this.oVariantSelectionPage],afterOpen:function(){this.bPopoverOpen=true;}.bind(this),afterClose:function(){if(this.bPopoverOpen){setTimeout(function(){this.bPopoverOpen=false;}.bind(this),200);}}.bind(this),contentHeight:"300px"});this.oVariantPopOver.addStyleClass("sapUiFlVarMngmtPopover");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oVariantPopOver.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oVariantPopOver);};
K.prototype._openVariantList=function(){var e;if(this.getInErrorState()){this._openInErrorState();return;}if(this.bPopoverOpen){return;}if(!this.oContext){return;}this._createVariantList();this._oSearchField.setValue("");this._oVariantList.getBinding("items").filter(this._getFilters());this.oVariantSelectionPage.setShowSubHeader(this._oVariantList.getItems().length>9?true:false);this.oVariantSaveBtn.setEnabled(false);this.oVariantSaveAsBtn.setEnabled(true);if(this.getModified()){e=this._getItemByKey(this.getCurrentVariantKey());if(e&&e.change){this.oVariantSaveBtn.setEnabled(true);}}this.oVariantPopOver.openBy(this.oVariantLayout);};
K.prototype._triggerSearch=function(e,M){if(!e){return;}var N=e.getParameters();if(!N){return;}var Q=N.newValue?N.newValue:"";var U=new F({path:"title",operator:sap.ui.model.FilterOperator.Contains,value1:Q});M.getBinding("items").filter(this._getFilters(U));};
K.prototype._createSaveAsDialog=function(){if(!this.oSaveAsDialog){this.oInputName=new s(this.getId()+"-name",{liveChange:function(N){this._checkVariantNameConstraints(this.oInputName,this.oSaveSave);}.bind(this)});var e=new L(this.getId()+"-namelabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_NAME"),required:true});e.setLabelFor(this.oInputName);this.oDefault=new p(this.getId()+"-default",{text:this._oRb.getText("VARIANT_MANAGEMENT_SETASDEFAULT"),visible:{path:"/showSetAsDefault",model:K.INNER_MODEL_NAME},width:"100%"});this.oExecuteOnSelect=new p(this.getId()+"-execute",{text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT"),visible:{path:"/showExecuteOnSelection",model:K.INNER_MODEL_NAME},width:"100%"});this.oInputManualKey=new s(this.getId()+"-key",{liveChange:function(N){this._checkVariantNameConstraints(this.oInputManualKey);}.bind(this)});this.oLabelKey=new L(this.getId()+"-keylabel",{text:this._oRb.getText("VARIANT_MANAGEMENT_KEY"),required:true});this.oLabelKey.setLabelFor(this.oInputManualKey);this.oSaveSave=new o(this.getId()+"-variantsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),press:function(){this._bSaveCanceled=false;this._handleVariantSaveAs(this.oInputName.getValue());}.bind(this),enabled:true});var M=new G({defaultSpan:"L12 M12 S12"});if(this.getShowSetAsDefault()){M.addContent(this.oDefault);}if(this.getShowExecuteOnSelection()){M.addContent(this.oExecuteOnSelect);}this.oSaveAsDialog=new r(this.getId()+"-savedialog",{title:this._oRb.getText("VARIANT_MANAGEMENT_SAVEDIALOG"),beginButton:this.oSaveSave,endButton:new o(this.getId()+"-variantcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this._bSaveCanceled=true;this.oSaveAsDialog.close();}.bind(this)}),content:[e,this.oInputName,this.oLabelKey,this.oInputManualKey,M],stretch:D.system.phone});this.oSaveAsDialog.addStyleClass("sapUiPopupWithPadding");this.oSaveAsDialog.addStyleClass("sapUiFlVarMngmtSaveDialog");if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oSaveAsDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oSaveAsDialog);}};
K.prototype._openSaveAsDialog=function(){this._createSaveAsDialog();this.oInputName.setValue(this.getSelectedVariantText(this.getCurrentVariantKey()));this.oSaveSave.setEnabled(false);this.oInputName.setEnabled(true);this.oInputName.setValueState(V.None);this.oInputName.setValueStateText(null);this.oDefault.setSelected(false);this.oExecuteOnSelect.setSelected(false);if(this.oVariantPopOver){this.oVariantPopOver.close();}if(this.getManualVariantKey()){this.oInputManualKey.setVisible(true);this.oInputManualKey.setEnabled(true);this.oInputManualKey.setValueState(V.None);this.oInputManualKey.setValueStateText(null);this.oLabelKey.setVisible(true);}else{this.oInputManualKey.setVisible(false);this.oLabelKey.setVisible(false);}this.oSaveAsDialog.open();};
K.prototype._handleVariantSaveAs=function(N){var e=null,M=N.trim(),Q=this.oInputManualKey.getValue().trim();if(M==""){this.oInputName.setValueState(V.Error);this.oInputName.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}if(this.getManualVariantKey()){if(Q==""){this.oInputManualKey.setValueState(V.Error);this.oInputManualKey.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));return;}e=Q;}if(this.oSaveAsDialog){this.oSaveAsDialog.close();}if(this.oDefault.getSelected()){this.setDefaultVariantKey(e);}this.setModified(false);this.fireSave({key:e,name:M,overwrite:false,def:this.oDefault.getSelected(),execute:this.oExecuteOnSelect.getSelected()});};
K.prototype._handleVariantSave=function(){var e=this._getItemByKey(this.getCurrentVariantKey());var M=false;if(this.getDefaultVariantKey()===e.key){M=true;}if(this.oVariantPopOver){this.oVariantPopOver.close();}this.fireSave({name:e.title,overwrite:true,key:e.key,def:M});this.setModified(false);};
K.prototype.openManagementDialog=function(e){if(e&&this.oManagementDialog){this.oManagementDialog.destroy();this.oManagementDialog=undefined;}this._openManagementDialog();};
K.prototype._triggerSearchInManageDialog=function(e,M){if(!e){return;}var N=e.getParameters();if(!N){return;}var Q=N.newValue?N.newValue:"";var U=[this._getVisibleFilter(),new F({filters:[new F({path:"title",operator:sap.ui.model.FilterOperator.Contains,value1:Q}),new F({path:"author",operator:sap.ui.model.FilterOperator.Contains,value1:Q})],and:false})];M.getBinding("items").filter(U);this._bDeleteOccured=true;};
K.prototype._createManagementDialog=function(){if(!this.oManagementDialog){this.oManagementTable=new i(this.getId()+"-managementTable",{growing:true,columns:[new g({width:"3rem",visible:{path:"showFavorites",model:this._sModelName}}),new g({header:new h({text:this._oRb.getText("VARIANT_MANAGEMENT_NAME")}),width:"14rem"}),new g({header:new h({text:this._oRb.getText("VARIANT_MANAGEMENT_DEFAULT")}),width:"4rem",demandPopin:true,popinDisplay:d.Inline,minScreenWidth:c.Tablet,visible:{path:"/showSetAsDefault",model:K.INNER_MODEL_NAME}}),new g({header:new h({text:this._oRb.getText("VARIANT_MANAGEMENT_EXECUTEONSELECT")}),width:"6rem",hAlign:T.Center,demandPopin:true,popinDisplay:d.Inline,minScreenWidth:"800px",visible:{path:"/showExecuteOnSelection",model:K.INNER_MODEL_NAME}}),new g({header:new h({text:this._oRb.getText("VARIANT_MANAGEMENT_AUTHOR")}),width:"8rem",demandPopin:true,popinDisplay:d.Inline,minScreenWidth:"900px"}),new g({width:"2rem",hAlign:T.Center}),new g({visible:false})]});this.oManagementSave=new o(this.getId()+"-managementsave",{text:this._oRb.getText("VARIANT_MANAGEMENT_OK"),enabled:true,press:function(){this._handleManageSavePressed();}.bind(this)});this.oManagementCancel=new o(this.getId()+"-managementcancel",{text:this._oRb.getText("VARIANT_MANAGEMENT_CANCEL"),press:function(){this.oManagementDialog.close();this._handleManageCancelPressed();}.bind(this)});this.oManagementDialog=new r(this.getId()+"-managementdialog",{resizable:true,draggable:true,customHeader:new B(this.getId()+"-managementHeader",{contentMiddle:[new h(this.getId()+"-managementHeaderText",{text:this._oRb.getText("VARIANT_MANAGEMENT_MANAGEDIALOG")})]}),beginButton:this.oManagementSave,endButton:this.oManagementCancel,content:[this.oManagementTable],stretch:D.system.phone});this.oManagementDialog.isPopupAdaptationAllowed=function(){return false;};this._oSearchFieldOnMgmtDialog=new S();this._oSearchFieldOnMgmtDialog.attachLiveChange(function(M){this._triggerSearchInManageDialog(M,this.oManagementTable);}.bind(this));var e=new B(this.getId()+"-mgmHeaderSearch",{contentRight:[this._oSearchFieldOnMgmtDialog]});this.oManagementDialog.setSubHeader(e);if(this.oVariantLayout.$().closest(".sapUiSizeCompact").length>0){this.oManagementDialog.addStyleClass("sapUiSizeCompact");}this.addDependent(this.oManagementDialog);this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});this._bDeleteOccured=false;}};
K.prototype._setFavoriteIcon=function(e,M){if(e){e.setSrc(M?"sap-icon://favorite":"sap-icon://unfavorite");e.setTooltip(this._oRb.getText(M?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP"));}};
K.prototype._templateFactoryManagementDialog=function(e,M){var N=null,Q,U,W,X=M.getObject();if(!X){return undefined;}var Y=function(e1){this._checkVariantNameConstraints(e1.oSource,this.oManagementSave,e1.oSource.getBindingContext(this._sModelName).getObject().key);}.bind(this);var Z=function(e1){this._handleManageTitleChanged(e1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var $=function(e1){if(e1.getParameters().selected===true){this._handleManageDefaultVariantChange(e1.oSource,e1.oSource.getBindingContext(this._sModelName).getObject());}}.bind(this);var _=function(e1){this._handleManageExecuteOnSelectionChanged(e1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var a1=function(e1){this._handleManageDeletePressed(e1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);var b1=function(e1){this._handleManageFavoriteChanged(e1.oSource,e1.oSource.getBindingContext(this._sModelName).getObject());}.bind(this);if(X.rename){W=new s({liveChange:Y,change:Z,value:'{'+this._sModelName+">title}"});}else{W=new O({title:'{'+this._sModelName+">title}"});if(N){W.setTooltip(N);}}Q=new o({icon:"sap-icon://sys-cancel",enabled:true,type:l.Transparent,press:a1,tooltip:this._oRb.getText("VARIANT_MANAGEMENT_DELETE"),visible:X.remove});this._assignColumnInfoForDeleteButton(Q);U=this.oContext.getPath();var c1=new b({src:{path:"favorite",model:this._sModelName,formatter:function(e1){return e1?"sap-icon://favorite":"sap-icon://unfavorite";}},tooltip:{path:'favorite',model:this._sModelName,formatter:function(e1){return this._oRb.getText(e1?"VARIANT_MANAGEMENT_FAV_DEL_TOOLTIP":"VARIANT_MANAGEMENT_FAV_ADD_TOOLTIP");}.bind(this)},press:b1});c1.addStyleClass("sapUiFlVarMngmtFavColor");var d1=new f({cells:[c1,W,new R({groupName:this.getId(),select:$,selected:{path:U+"/defaultVariant",model:this._sModelName,formatter:function(e1){return(X.key===e1)?true:false;}}}),new p({select:_,selected:'{'+this._sModelName+">executeOnSelect}"}),new h({text:'{'+this._sModelName+">author}",textAlign:"Begin"}),Q,new h({text:'{'+this._sModelName+">key}"})]});return d1;};
K.prototype._openManagementDialog=function(){this._createManagementDialog();if(this.oVariantPopOver){this.oVariantPopOver.close();}this._clearDeletedItems();this.oManagementSave.setEnabled(false);this._oSearchFieldOnMgmtDialog.setValue("");if(this._bDeleteOccured){this._bDeleteOccured=false;this.oManagementTable.bindAggregation("items",{path:"variants",model:this._sModelName,factory:this._templateFactoryManagementDialog.bind(this),filters:this._getVisibleFilter()});}this.oManagementDialog.open();};
K.prototype._assignColumnInfoForDeleteButton=function(e){if(!this._oInvisibleDeleteColumnName){this._oInvisibleDeleteColumnName=new I({text:this._oRb.getText("VARIANT_MANAGEMENT_ACTION_COLUMN")});this.oManagementDialog.addContent(this._oInvisibleDeleteColumnName);}if(this._oInvisibleDeleteColumnName){e.addAriaLabelledBy(this._oInvisibleDeleteColumnName);}};
K.prototype._handleManageDefaultVariantChange=function(e,M){var N=M.key;if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if(this.getShowFavorites()&&!M.favorite&&e){M.favorite=!M.favorite;this._setFavoriteIcon(e.getParent().getCells()[K.COLUMN_FAV_IDX],M.favorite);}this.setDefaultVariantKey(N);};
K.prototype._handleManageCancelPressed=function(){var e,M;this._getDeletedItems().forEach(function(N){N.visible=true;});this._getItems().forEach(function(N){N.title=N.originalTitle;N.favorite=N.originalFavorite;N.executeOnSelection=N.originalExecuteOnSelection;});e=this.getOriginalDefaultVariantKey();if(e!==this.getDefaultVariantKey()){this.setDefaultVariantKey(e);}M=this.getModel(this._sModelName);if(M){M.checkUpdate();}};
K.prototype._handleManageFavoriteChanged=function(e,M){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}if((this.getDefaultVariantKey()===M.key)&&M.favorite){return;}M.favorite=!M.favorite;this._setFavoriteIcon(e,M.favorite);};
K.prototype._handleManageDeletePressed=function(e){var M,N=e.key;if(this.oManagementTable.getItems().length===1){return;}if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}e.visible=false;this._addDeletedItem(e);if((N===this.getDefaultVariantKey())){this.setDefaultVariantKey(this.getStandardVariantKey());}M=this.getModel(this._sModelName);if(M){M.checkUpdate();}};
K.prototype._handleManageExecuteOnSelectionChanged=function(e){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}};
K.prototype._handleManageTitleChanged=function(e){if(!this._anyInErrorState(this.oManagementTable)){this.oManagementSave.setEnabled(true);}};
K.prototype._handleManageSavePressed=function(){this._getDeletedItems().some(function(e){if(e.key===this.getCurrentVariantKey()){var M=this.getStandardVariantKey();this.setModified(false);this.setCurrentVariantKey(M);this.fireEvent("select",{key:M});return true;}return false;}.bind(this));this.fireManage();this.oManagementDialog.close();};
K.prototype._anyInErrorState=function(M){var e,N,Q=false;if(M){e=M.getItems();e.some(function(U){N=U.getCells()[K.COLUMN_NAME_IDX];if(N&&N.getValueState&&(N.getValueState()===V.Error)){Q=true;}return Q;});}return Q;};
K.prototype._getFilters=function(e){var M=[];if(e){M.push(e);}M.push(this._getVisibleFilter());if(this.getShowFavorites()){M.push(this._getFilterFavorites());}return M;};
K.prototype._getVisibleFilter=function(){return new F({path:"visible",operator:sap.ui.model.FilterOperator.EQ,value1:true});};
K.prototype._getFilterFavorites=function(){return new F({path:"favorite",operator:sap.ui.model.FilterOperator.EQ,value1:true});};
K.prototype._checkVariantNameConstraints=function(e,M,N){if(!e){return;}var Q=e.getValue();Q=Q.trim();if(!this._checkIsDuplicate(Q,N)){if(Q===""){e.setValueState(V.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_EMPTY"));}else if(Q.indexOf('{')>-1){e.setValueState(V.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_NOT_ALLOWED_CHAR",["{"]));}else if(Q.length>K.MAX_NAME_LEN){e.setValueState(V.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_MAX_LEN",[K.MAX_NAME_LEN]));}else{e.setValueState(V.None);e.setValueStateText(null);}}else{e.setValueState(V.Error);e.setValueStateText(this._oRb.getText("VARIANT_MANAGEMENT_ERROR_DUPLICATE"));}if(M){if(e.getValueState()===V.Error){M.setEnabled(false);}else{M.setEnabled(true);}}};
K.prototype._checkIsDuplicate=function(e,M){var N=false,Q=this._getItems(),U=e.toLowerCase();Q.some(function(W){if(W.title.toLowerCase()===U){if(M&&(M===W.key)){return false;}N=true;}return N;});return N;};
K.prototype.exit=function(){var M;if(this.oDefault&&!this.oDefault._bIsBeingDestroyed){this.oDefault.destroy();}this.oDefault=undefined;if(this.oExecuteOnSelect&&!this.oExecuteOnSelect._bIsBeingDestroyed){this.oExecuteOnSelect.destroy();}this.oExecuteOnSelect=undefined;this._oRb=undefined;this.oContext=undefined;this._oVariantList=undefined;this.oVariantSelectionPage=undefined;this.oVariantLayout=undefined;this.oVariantText=undefined;this.oVariantPopoverTrigger=undefined;this.oVariantInvisibleText=undefined;this._oSearchField=undefined;this._oSearchFieldOnMgmtDialog=undefined;M=this.getModel(K.INNER_MODEL_NAME);if(M){M.destroy();}};
return K;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantModel',["jquery.sap.global","sap/ui/model/json/JSONModel","sap/ui/fl/Utils","sap/ui/core/util/reflection/BaseTreeModifier","sap/ui/fl/Change","sap/ui/fl/changeHandler/Base","sap/ui/core/BusyIndicator","sap/ui/fl/variants/util/VariantUtil"],function(q,J,U,B,C,a,b,V){"use strict";
var c=J.extend("sap.ui.fl.variants.VariantModel",{constructor:function(d,f,o,O){this.pSequentialImportCompleted=Promise.resolve();J.apply(this,arguments);this.bObserve=O;this.oFlexController=f;this.oComponent=o;this.oVariantController=undefined;this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");if(f&&f._oChangePersistence){this.oVariantController=f._oChangePersistence._oVariantController;this.sVariantTechnicalParameterName=this.oVariantController.sVariantTechnicalParameterName;}V.initializeHashRegister.call(this);if(d&&typeof d=="object"){Object.keys(d).forEach(function(k){d[k].variants.forEach(function(v){if(!d[k].currentVariant&&(v.key===d[k].defaultVariant)){d[k].currentVariant=v.key;}v.originalTitle=v.title;v.originalFavorite=v.favorite;});d[k].originalCurrentVariant=d[k].currentVariant;d[k].originalDefaultVariant=d[k].defaultVariant;});this.setData(d);}}});
c.prototype.updateCurrentVariant=function(v,n){var s,m;var d;s=this.oData[v].originalCurrentVariant;if(this.oData[v].modified){d=this.oVariantController.getVariantChanges(v,s);this._removeDirtyChanges(d,v,s);this.oData[v].modified=false;}m=this.oFlexController._oChangePersistence.loadSwitchChangesMapForComponent(v,s,n);var A=U.getAppComponentForControl(this.oComponent);return Promise.resolve().then(this.oFlexController.revertChangesOnControl.bind(this.oFlexController,m.aRevert,A)).then(this.oFlexController.applyVariantChanges.bind(this.oFlexController,m.aNew,this.oComponent)).then(function(){this.oData[v].originalCurrentVariant=n;this.oData[v].currentVariant=n;if(this.oData[v].updateVariantInURL){this._updateVariantInURL(v,n);this.oVariantController.updateCurrentVariantInMap(v,n);}this.checkUpdate();}.bind(this));};
c.prototype._updateVariantInURL=function(v,n){var t=this.getVariantIndexInURL(v);if(!t.parameters){return;}var p=Array.isArray(t.parameters[this.sVariantTechnicalParameterName])?t.parameters[this.sVariantTechnicalParameterName].slice(0):[];var i=t.index;if(n===this.oData[v].defaultVariant){if(i===-1){return;}p.splice(i,1);}else{i===-1?p.push(n):(p[i]=n);}this.updateHasherEntry({parameters:p,updateURL:!this._bAdaptationMode});};
c.prototype.updateHasherEntry=function(){V.updateHasherEntry.apply(this,arguments);};
c.prototype.getVariantIndexInURL=function(v){var h=U.getParsedURLHash().params;var p=-1;if(h){if(this._bAdaptationMode){h={};h[this.sVariantTechnicalParameterName]=V.getCurrentHashParamsFromRegister.call(this);}if(!q.isEmptyObject(h)&&Array.isArray(h[this.sVariantTechnicalParameterName])){h[this.sVariantTechnicalParameterName].some(function(P,i){if(!!this.oVariantController.getVariant(v,P)){p=i;return true;}}.bind(this));}}return{parameters:h,index:p};};
c.prototype.getCurrentVariantReference=function(v){return this.oData[v].currentVariant;};
c.prototype.getVariantManagementReference=function(v){var s="";var i=-1;Object.keys(this.oData).some(function(k){return this.oData[k].variants.some(function(o,d){if(o.key===v){s=k;i=d;return true;}});}.bind(this));return{variantManagementReference:s,variantIndex:i};};
c.prototype.getVariant=function(v,s){return this.oVariantController.getVariant(s?s:this.getVariantManagementReference(v).variantManagementReference,v);};
c.prototype.getVariantProperty=function(v,p){return this.getVariant(v).content.content[p];};
c.prototype._addChange=function(o){var v=o.getVariantReference();var s=this.getVariantManagementReference(v).variantManagementReference;this.oData[s].modified=!!this.oData[s].variantsEditable;this.checkUpdate(true);return this.oVariantController.addChangeToVariant(o,s,v);};
c.prototype._removeChange=function(o){var v=o.getVariantReference();var s=this.getVariantManagementReference(v).variantManagementReference;return this.oVariantController.removeChangeFromVariant(o,s,v);};
c.prototype._removeDirtyChanges=function(v,s,d){var A=U.getAppComponentForControl(this.oComponent);var e=v.map(function(o){return o.fileName;});var f;var D=this.oFlexController._oChangePersistence.getDirtyChanges().filter(function(o){f=e.indexOf(o.getDefinition().fileName)>-1;if(f){this.oVariantController.removeChangeFromVariant(o,s,d);}return f;}.bind(this));D.forEach(function(o){this.oFlexController.deleteChange(o,A);}.bind(this));return this.oFlexController.revertChangesOnControl(D.reverse(),A);};
c.prototype._getVariantTitleCount=function(n,v){var d=this.getData();return d[v].variants.reduce(function(i,o){if(n===o.title&&o.visible){i++;}return i;},0);};
c.prototype._duplicateVariant=function(p){var n=p.newVariantReference,s=p.sourceVariantReference,S=this.getVariant(s);var d={content:{},controlChanges:JSON.parse(JSON.stringify(S.controlChanges)),variantChanges:{}};var i=U.isLayerAboveCurrentLayer(S.content.layer);Object.keys(S.content).forEach(function(k){if(k==="fileName"){d.content[k]=n;}else if(k==="variantReference"){if(i===0){d.content[k]=S.content["variantReference"];}else if(i===-1){d.content[k]=s;}}else if(k==="content"){d.content[k]=JSON.parse(JSON.stringify(S.content[k]));d.content.content.title=p.title;}else{d.content[k]=S.content[k];}});d.content["layer"]=p.layer;var v=d.controlChanges.slice();var D={};d.controlChanges=v.reduce(function(e,o){if(U.isLayerAboveCurrentLayer(o.layer)===0){D=q.extend(true,{},o);D.fileName=U.createDefaultFileName(o.changeType);D.variantReference=d.content.fileName;if(!D.support){D.support={};}D.support.sourceChangeFileName=o.fileName;e.push(D);}return e;},[]);return d;};
c.prototype._copyVariant=function(p){var d=this._duplicateVariant(p);var v={key:d.content.fileName,layer:p.layer,title:d.content.content.title,originalTitle:d.content.content.title,favorite:true,originalFavorite:true,rename:true,change:true,remove:true,visible:true};var o=this.oFlexController.createVariant(d,this.oComponent);var e=[];[o].concat(o.getControlChanges()).forEach(function(f){e.push(this.oFlexController._oChangePersistence.addDirtyChange(f));}.bind(this));var i=this.oVariantController.addVariantToVariantManagement(o.getDefinitionWithChanges(),p.variantManagementReference);this.oData[p.variantManagementReference].variants.splice(i,0,v);return this.updateCurrentVariant(p.variantManagementReference,o.getId()).then(function(){return e;});};
c.prototype.removeVariant=function(v,s,d){var e=this.oFlexController._oChangePersistence.getDirtyChanges().filter(function(o){return(o.getVariantReference&&o.getVariantReference()===v.getId())||o.getId()===v.getId();});e.forEach(function(o){this.oFlexController._oChangePersistence.deleteChange(o);}.bind(this));return this.updateCurrentVariant(d,s).then(function(){var i=this.oVariantController.removeVariantFromVariantManagement(v,d);this.oData[d].variants.splice(i,1);this.checkUpdate();}.bind(this));};
c.prototype.collectModelChanges=function(v,l){var d=this.getData()[v];var m=d.variants;var e=[];var p={};m.forEach(function(o){if(o.originalTitle!==o.title){p={variantReference:o.key,changeType:"setTitle",title:o.title,originalTitle:o.originalTitle,layer:l};e.push(p);}if(o.originalFavorite!==o.favorite){p={variantReference:o.key,changeType:"setFavorite",favorite:o.favorite,originalFavorite:o.originalFavorite,layer:l};e.push(p);}if(!o.visible){p={variantReference:o.key,changeType:"setVisible",visible:false,layer:l};e.push(p);}});if(d.originalDefaultVariant!==d.defaultVariant){p={variantManagementReference:v,changeType:"setDefault",defaultVariant:d.defaultVariant,originalDefaultVariant:d.originalDefaultVariant,layer:l};e.push(p);}return e;};
c.prototype.manageVariants=function(v,s,l){return new Promise(function(r){v.attachManage({resolve:r,variantManagementReference:s,layer:l},this.fnManageClickRta,this);v.openManagementDialog(true);}.bind(this));};
c.prototype._setVariantProperties=function(v,p,A){var i=-1;var o;var d=null;var D=this.getData();if(p.variantReference){i=this.getVariantManagementReference(p.variantReference).variantIndex;o=D[v].variants[i];}var n={};var m={};switch(p.changeType){case"setTitle":m.title=p.title;o.title=p.title;o.originalTitle=o.title;break;case"setFavorite":m.favorite=p.favorite;o.favorite=p.favorite;o.originalFavorite=o.favorite;break;case"setVisible":m.visible=p.visible;m.createdByReset=false;o.visible=p.visible;break;case"setDefault":m.defaultVariant=p.defaultVariant;D[v].defaultVariant=p.defaultVariant;D[v].originalDefaultVariant=D[v].defaultVariant;break;default:break;}if(i>-1){var s=this.oVariantController._setVariantData(m,v,i);D[v].variants.splice(i,1);D[v].variants.splice(s,0,o);}else if(this.oVariantController._mVariantManagement[v]){this.oVariantController._mVariantManagement[v].defaultVariant=p.defaultVariant;}if(A){n.changeType=p.changeType;n.layer=p.layer;if(p.changeType==="setDefault"){n.fileType="ctrl_variant_management_change";n.selector={id:v};}else{if(p.changeType==="setTitle"){a.setTextInChange(n,"title",p.title,"XFLD");}n.fileType="ctrl_variant_change";n.selector={id:p.variantReference};}d=this.oFlexController.createBaseChange(n,p.appComponent);d.setContent(m);this.oVariantController._updateChangesForVariantManagementInMap(d.getDefinition(),v,true);this.oFlexController._oChangePersistence.addDirtyChange(d);}else{if(p.change){this.oVariantController._updateChangesForVariantManagementInMap(p.change.getDefinition(),v,false);this.oFlexController._oChangePersistence.deleteChange(p.change);}}this.setData(D);this.checkUpdate(true);return d;};
c.prototype._ensureStandardVariantExists=function(v){var d=this.getData();if(!d[v]){d[v]={currentVariant:v,originalCurrentVariant:v,defaultVariant:v,originalDefaultVariant:v,variants:[{key:v,title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE"),originalTitle:this._oResourceBundle.getText("STANDARD_VARIANT_ORIGINAL_TITLE"),favorite:true,originalFavorite:true,visible:true}]};this.setData(d);if(this.oVariantController){var o={changes:{variantSection:{}}};var D={defaultVariant:v,variantManagementChanges:{},variants:[{content:{fileName:v,fileType:"ctrl_variant",variantManagementReference:v,variantReference:"",content:{title:this._oResourceBundle.getText("STANDARD_VARIANT_TITLE")}},controlChanges:[],variantChanges:{}}]};o.changes.variantSection[v]=D;this.oVariantController._setChangeFileContent(o,{});}}};
c.prototype._setModelPropertiesForControl=function(v,A,o){var r=function(d,v,A){if((d.layer===U.getCurrentLayer(!A))&&(d.key!==v)){return true;}else{return false;}};this.oData[v].modified=false;this.oData[v].showFavorites=true;if(this._bAdaptationMode!==A){var p={};if(A){p={parameters:[],updateURL:true,ignoreRegisterUpdate:true};}else if(this._bAdaptationMode){p={parameters:V.getCurrentHashParamsFromRegister.call(this),updateURL:true,ignoreRegisterUpdate:true};}this.updateHasherEntry(p);this._bAdaptationMode=A;}if(!(typeof this.fnManageClick==="function"&&typeof this.fnManageClickRta==="function")){this._initializeManageVariantsEvents();}o.detachManage(this.fnManageClick,this);o.detachManage(this.fnManageClickRta,this);if(A){this.oData[v].variantsEditable=false;this.oData[v].variants.forEach(function(d){d.rename=true;d.change=true;d.remove=r(d,v,A);});}else{if(this.oData[v]._isEditable){o.attachManage({variantManagementReference:v},this.fnManageClick,this);this.oData[v].variantsEditable=true;this.oData[v].variants.forEach(function(d){d.remove=r(d,v,A);if(d.layer===U.getCurrentLayer(true)){d.rename=true;d.change=true;}else{d.rename=false;d.change=false;}});}else{this.oData[v].variantsEditable=false;this.oData[v].variants.forEach(function(d){d.remove=false;d.rename=false;d.change=false;});}}};
c.prototype._initializeManageVariantsEvents=function(){this.fnManageClickRta=function(e,d){var f=this.collectModelChanges(d.variantManagementReference,d.layer);d.resolve(f);};this.fnManageClick=function(e,d){if(!this.oFlexController||!this.oVariantController){return;}var f=this.collectModelChanges(d.variantManagementReference,U.getCurrentLayer(true));f.forEach(function(o){o.appComponent=this.oComponent;this._setVariantProperties(d.variantManagementReference,o,true);}.bind(this));this.oFlexController._oChangePersistence.saveDirtyChanges();};};
c.prototype._handleCurrentVariantChange=function(e){var p=e.getSource();var v=p.getContext().getPath().replace(/^\//,'');if(this.oData[v].currentVariant!==this.oData[v].originalCurrentVariant){this.updateCurrentVariant(v,p.getValue());}};
c.prototype._handleSave=function(e){var v=e.getSource();var s=e.getParameter("def");var A=U.getAppComponentForControl(this.oComponent)||U.getAppComponentForControl(v);var d=this._getLocalId(v.getId(),A);var S=this.getCurrentVariantReference(d);var f=this.oVariantController.getVariantChanges(d,S);if(e.getParameter("overwrite")){var g=this.oFlexController._oChangePersistence.getDirtyChanges();var h=f.map(function(o){return o.fileName;});var D=g.reduce(function(r,o){if(h.indexOf(o.getId())>-1){return r.concat(o);}else{return r;}},[]);this.oFlexController._oChangePersistence.saveSequenceOfDirtyChanges(D);this.oData[d].modified=false;this.checkUpdate(true);return Promise.resolve();}else{var n=U.createDefaultFileName("Copy");var p={variantManagementReference:d,appComponent:A,layer:U.getCurrentLayer(true),title:e.getParameter("name"),sourceVariantReference:S,newVariantReference:n};return this._copyVariant(p).then(function(D){return this._removeDirtyChanges(f,d,S).then(function(){if(s){var P={changeType:"setDefault",defaultVariant:n,originalDefaultVariant:this.oData[d].defaultVariant,appComponent:A,layer:U.getCurrentLayer(true),variantManagementReference:d};var o=this._setVariantProperties(d,P,true);D.push(o);}this.oFlexController._oChangePersistence.saveSequenceOfDirtyChanges(D);this.oData[d].modified=false;this.checkUpdate(true);return Promise.resolve();}.bind(this));}.bind(this));}};
c.prototype._getLocalId=function(i,A){return B.getSelector(i,A).id;};
c.prototype.switchToDefaultVariant=function(v){Object.keys(this.oData).forEach(function(s){if(!v||this.oData[s].currentVariant===v){b.show(200);this.updateCurrentVariant(s,this.oData[s].defaultVariant).then(function(){b.hide();});}}.bind(this));};
c.prototype.registerToModel=function(v){var s=this._getLocalId(v,U.getAppComponentForControl(v)||this.oComponent);this._ensureStandardVariantExists(s);if(v){this.oData[s]._isEditable=v.getEditable();v.getTitle().getBinding("text").attachChange(this._handleCurrentVariantChange,this);this._setModelPropertiesForControl(s,false,v);v.attachSave(this._handleSave,this);if(v.getUpdateVariantInURL()){this.oData[s].updateVariantInURL=true;V.attachHashHandlers.call(this);}}};
return c;},true);
/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.predefine('sap/ui/fl/Cache',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils"],function(L,U){"use strict";var C=function(){};C._isOn=true;C._entries={};C._switches={};C._oFlexDataPromise=undefined;
C.getSwitches=function(){return C._switches;};
C.isActive=function(){return C._isOn;};
C.setActive=function(a){C._isOn=a;};
C.getFlexDataPromise=function(){return C._oFlexDataPromise;};
C.getEntries=function(){return C._entries;};
C.clearEntries=function(){C._entries={};};
C.getEntry=function(c,a){if(!C._entries[c]){C._entries[c]={};}if(!C._entries[c][a]){C._entries[c][a]={file:{changes:{changes:[],contexts:[],variantSection:{},ui2personalization:{}}}};}return C._entries[c][a];};
C.clearEntry=function(c,a){C.getEntry(c,a);C._entries[c][a]={};};
C._deleteEntry=function(c,a){if(C._entries[c]&&C._entries[c][a]){delete C._entries[c][a];}if(jQuery.isEmptyObject(C._entries[c])){delete C._entries[c];}};
C.getChangesFillingCache=function(l,c,p){if(!this.isActive()){return l.loadChanges(c,p);}var s=c.name;var a=c.appVersion||U.DEFAULT_APP_VERSION;var o=C.getEntry(s,a);if(o.promise){return o.promise;}var b=C._getChangesFromBundle(p);if(p&&p.cacheKey==="<NO CHANGES>"){var d=b.then(function(g){o.file={changes:{changes:g,contexts:[],variantSection:{},ui2personalization:{}},componentClassName:s};return o.file;});o.promise=d;return d;}var f=l.loadChanges(c,p);var e=f.then(function(r){return r;},function(E){var g=jQuery.sap.formatMessage("flexibility service is not available:\nError message: {0}",E.status);jQuery.sap.log.error(g);return Promise.resolve({changes:{changes:[],contexts:[],variantSection:{},ui2personalization:{}}});});var d=Promise.all([b,e]).then(function(v){var g=v[0];var m=v[1];if(m&&m.changes){if(m.changes.settings&&m.changes.settings.switchedOnBusinessFunctions){m.changes.settings.switchedOnBusinessFunctions.forEach(function(V){C._switches[V]=true;});}m.changes.changes=g.concat(m.changes.changes);}o.file=m;return o.file;},function(g){C._deleteEntry(s,a);throw g;});o.promise=d;C._oFlexDataPromise=f;return d;};
C._getChangesFromBundle=function(p){var c=p&&p.appName;if(!c){return Promise.resolve([]);}var r=jQuery.sap.getResourceName(p.appName,"/changes/changes-bundle.json");var b=jQuery.sap.isResourceLoaded(r);if(b){return Promise.resolve(jQuery.sap.loadResource(r));}else{if(!sap.ui.getCore().getConfiguration().getDebug()){return Promise.resolve([]);}try{return Promise.resolve(jQuery.sap.loadResource(r));}catch(e){jQuery.sap.log.warning("flexibility did not find a changesBundle.json  for the application");return Promise.resolve([]);}}};
C.NOTAG="<NoTag>";
C.getCacheKey=function(c){if(!c||!c.name||!c.appVersion){jQuery.sap.log.warning("Not all parameters were passed to determine a flexibility cache key.");return Promise.resolve(C.NOTAG);}return this.getChangesFillingCache(L.createConnector(),c).then(function(w){if(w&&w.etag){return w.etag;}else{return C.NOTAG;}});};
C._getChangeArray=function(c){var s=c.name;var a=c.appVersion||U.DEFAULT_APP_VERSION;var e=C.getEntry(s,a);return e.file.changes.changes;};
C.addChange=function(c,o){var a=C._getChangeArray(c);if(!a){return;}a.push(o);};
C.updateChange=function(c,o){var a=C._getChangeArray(c);if(!a){return;}for(var i=0;i<a.length;i++){if(a[i].fileName===o.fileName){a.splice(i,1,o);break;}}};
C.deleteChange=function(c,o){var a=C._getChangeArray(c);if(!a){return;}for(var i=0;i<a.length;i++){if(a[i].fileName===o.fileName){a.splice(i,1);break;}}};
C.getPersonalization=function(r,a,c,i){var m={name:r,appVersion:a};return this.getChangesFillingCache(L.createConnector(),m).then(function(R){if(!R||!R.changes||!R.changes.ui2personalization||!R.changes.ui2personalization[c]){return i?undefined:[];}if(!i){return R.changes.ui2personalization[c]||[];}return R.changes.ui2personalization[c].filter(function(e){return e.itemName===i;})[0];});};
C.setPersonalization=function(p){if(!p||!p.reference||!p.containerKey||!p.itemName||!p.content){return Promise.reject("not all mandatory properties were provided for the storage of the personalization");}return L.createConnector().send("/sap/bc/lrep/ui2personalization/","PUT",p,{}).then(this._addPersonalizationToEntries.bind(this,p));};
C._addPersonalizationToEntries=function(p){Object.keys(this._entries[p.reference]).forEach(function(v){var e=this._entries[p.reference][v];var P=e.file.changes.ui2personalization;if(!P[p.containerKey]){P[p.containerKey]=[];}P[p.containerKey].push(p);}.bind(this));};
C.deletePersonalization=function(r,c,i){if(!r||!c||!i){return Promise.reject("not all mandatory properties were provided for the storage of the personalization");}var u="/sap/bc/lrep/ui2personalization/?reference=";u+=r+"&containerkey="+c+"&itemname="+i;return L.createConnector().send(u,"DELETE",{}).then(this._removePersonalizationFromEntries.bind(this,r,c,i));};
C._removePersonalizationFromEntries=function(r,c,i){var d=[];Object.keys(this._entries[r]).forEach(function(a){var g=this.getPersonalization(r,a,c);var G=this.getPersonalization(r,a,c,i);var D=Promise.all([g,G]).then(function(p){var I=p[0];var t=p[1];var n=I.indexOf(t);I.splice(n,1);});d.push(D);}.bind(this));return Promise.all(d);};
return C;},true);
sap.ui.predefine('sap/ui/fl/Change',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/fl/registry/Settings"],function(q,M,U,S){"use strict";
var C=M.extend("sap.ui.fl.Change",{
constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){U.log.error("Constructor : sap.ui.fl.Change : oFile is not defined");}this._oDefinition=f;this._sRequest='';this._bUserDependent=(f.layer==="USER");this._vRevertData=null;this._aUndoOperations=null;this.setState(C.states.NEW);},
metadata:{properties:{state:{type:"string"}}}
});
C.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};
C.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};
C.prototype._isValidState=function(s){var b=false;Object.keys(C.states).some(function(k){if(C.states[k]===s){b=true;}return b;});if(!b){return false;}if((this.getState()===C.states.NEW)&&(s===C.states.DIRTY)){return false;}return true;};
C.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.fileType){i=false;}if(!this._oDefinition.fileName){i=false;}if(!this._oDefinition.changeType){i=false;}if(!this._oDefinition.layer){i=false;}if(!this._oDefinition.originalLanguage){i=false;}return i;};
C.prototype.isVariant=function(){return this._oDefinition.fileType==="variant";};
C.prototype.getChangeType=function(){if(this._oDefinition){return this._oDefinition.changeType;}};
C.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.fileType;}};
C.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.originalLanguage){return this._oDefinition.originalLanguage;}return"";};
C.prototype.getContext=function(){if(this._oDefinition&&this._oDefinition.context){return this._oDefinition.context;}return"";};
C.prototype.getPackage=function(){return this._oDefinition.packageName;};
C.prototype.getNamespace=function(){return this._oDefinition.namespace;};
C.prototype.setNamespace=function(n){this._oDefinition.namespace=n;};
C.prototype.getProjectId=function(){return this._oDefinition.projectId;};
C.prototype.setProjectId=function(p){this._oDefinition.projectId=p;};
C.prototype.getId=function(){return this._oDefinition.fileName;};
C.prototype.getContent=function(){return this._oDefinition.content;};
C.prototype.setContent=function(c){this._oDefinition.content=c;this.setState(C.states.DIRTY);};
C.prototype.getVariantReference=function(){return this._oDefinition.variantReference||"";};
C.prototype.setVariantReference=function(v){this._oDefinition.variantReference=v;this.setState(C.states.DIRTY);};
C.prototype.getSelector=function(){return this._oDefinition.selector;};
C.prototype.getOwnerId=function(){return this._oDefinition.support?this._oDefinition.support.user:"";};
C.prototype.getText=function(t){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.getTexts : sTextId is not defined");}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){return this._oDefinition.texts[t].value;}}return"";};
C.prototype.setText=function(t,n){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Change.setTexts : sTextId is not defined");return;}if(this._oDefinition.texts){if(this._oDefinition.texts[t]){this._oDefinition.texts[t].value=n;this.setState(C.states.DIRTY);}}};
C.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser();};
C.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};
C.prototype.isLabelReadOnly=function(){if(this._isReadOnlyDueToLayer()){return true;}return this._isReadOnlyDueToOriginalLanguage();};
C.prototype._isReadOnlyDueToLayer=function(){var c;c=U.getCurrentLayer(this._bUserDependent);return(this._oDefinition.layer!==c);};
C.prototype._isReadOnlyDueToOriginalLanguage=function(){var c,o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
C.prototype.markForDeletion=function(){this.setState(C.states.DELETED);};
C.prototype.setRequest=function(r){if(typeof(r)!=="string"){U.log.error("sap.ui.fl.Change.setRequest : sRequest is not defined");}this._sRequest=r;};
C.prototype.getRequest=function(){return this._sRequest;};
C.prototype.getLayer=function(){return this._oDefinition.layer;};
C.prototype.getComponent=function(){return this._oDefinition.reference;};
C.prototype.setComponent=function(c){this._oDefinition.reference=c;};
C.prototype.getCreation=function(){return this._oDefinition.creation;};
C.prototype.isUserDependent=function(){return(this._bUserDependent);};
C.prototype.getPendingAction=function(){return this.getState();};
C.prototype.getDefinition=function(){return this._oDefinition;};
C.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this.setState(C.states.PERSISTED);}};
C.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().fileName;var F=this.getDefinition().fileType;return l+"/"+n+"/"+f+"."+F;};
C.prototype.addDependentControl=function(c,a,p,A){if(!c){throw new Error("Parameter vControl is mandatory");}if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}if(!this._oDefinition.dependentSelector){this._oDefinition.dependentSelector={};}if(this._oDefinition.dependentSelector[a]){throw new Error("Alias '"+a+"' already exists in the change.");}var m=p.modifier;var o=p.appComponent;if(Array.isArray(c)){var s=[];c.forEach(function(b){s.push(m.getSelector(b,o,A));});this._oDefinition.dependentSelector[a]=s;}else{this._oDefinition.dependentSelector[a]=m.getSelector(c,o,A);}delete this._aDependentIdList;};
C.prototype.getDependentControl=function(a,p){var d=[];var D;if(!a){throw new Error("Parameter sAlias is mandatory");}if(!p){throw new Error("Parameter mPropertyBag is mandatory");}var m=p.modifier;var A=p.appComponent;if(!this._oDefinition.dependentSelector){return undefined;}D=this._oDefinition.dependentSelector[a];if(Array.isArray(D)){D.forEach(function(s){d.push(m.bySelector(s,A,p.view));});return d;}else{return m.bySelector(D,A,p.view);}};
C.prototype.getDependentIdList=function(a){var t=this;var i;var d=[this.getSelector()];var D=[];if(!this._aDependentIdList){if(this._oDefinition.dependentSelector){d=Object.keys(this._oDefinition.dependentSelector).reduce(function(d,A){return d.concat(t._oDefinition.dependentSelector[A]);},d);}d.forEach(function(o){i=o.id;if(o.idIsLocal){i=a.createId(o.id);}if(i&&D.indexOf(i)===-1){D.push(i);}});this._aDependentIdList=D;}return this._aDependentIdList;};
C.prototype.getDependentControlIdList=function(a){var i;var d=this.getDependentIdList().concat();if(d.length>0){var s=this.getSelector();i=s.id;if(s.idIsLocal){i=a.createId(s.id);}var I=d.indexOf(i);if(I>-1){d.splice(I,1);}}return d;};
C.prototype.getRevertData=function(){return this._vRevertData;};
C.prototype.setRevertData=function(d){this._vRevertData=d;};
C.prototype.resetRevertData=function(){this.setRevertData(null);};
C.prototype.getUndoOperations=function(){return this._aUndoOperations;};
C.prototype.setUndoOperations=function(d){this._aUndoOperations=d;};
C.prototype.resetUndoOperations=function(){this.setUndoOperations(null);};
C.createInitialFileContent=function(p){if(!p){p={};}var f;if(p.fileType){f=p.fileType;}else{f=p.isVariant?"variant":"change";}var b=p.reference&&p.reference.replace(".Component","")||"";var n={fileName:p.id||U.createDefaultFileName(p.changeType),fileType:f,changeType:p.changeType||"",reference:p.reference||"",packageName:p.packageName||"",content:p.content||{},selector:p.selector||{},layer:p.layer||U.getCurrentLayer(p.isUserDependent),texts:p.texts||{},namespace:p.namespace||U.createNamespace(p,"changes"),projectId:p.projectId||b,creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},context:p.context||"",support:{generator:p.generator||"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version,compositeCommand:""},dependentSelector:p.dependentSelector||{},validAppVersions:p.validAppVersions||{},jsOnly:p.jsOnly||false};return n;};
return C;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistence',["sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/context/ContextManager","sap/ui/fl/registry/Settings","sap/ui/fl/transport/TransportSelection","sap/ui/fl/variants/VariantController","sap/ui/core/BusyIndicator","sap/m/MessageBox","sap/ui/model/json/JSONModel"],function(C,V,U,L,a,b,S,T,c,B,M,J){"use strict";var d=function(m){this._mComponent=m;this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};this._mChangesInitial={};this._mVariantsChanges={};if(!this._mComponent||!this._mComponent.name){U.log.error("The Control does not belong to an SAPUI5 component. Personalization and changes for this control might not work as expected.");throw new Error("Missing component name.");}this._oVariantController=new c(this._mComponent.name,this._mComponent.appVersion,{});this._oTransportSelection=new T();this._oConnector=this._createLrepConnector();this._aDirtyChanges=[];this._oMessagebundle=undefined;this._mChangesEntries={};};
d.prototype.getComponentName=function(){return this._mComponent.name;};
d.prototype._createLrepConnector=function(){return L.createConnector();};
d.prototype.getCacheKey=function(){return a.getCacheKey(this._mComponent);};
d.prototype._preconditionsFulfilled=function(A,i,o){if(!o.fileName){U.log.warning("A change without fileName is detected and excluded from component: "+this._mComponent.name);return false;}function _(){if(i){return(o.fileType==="change")||(o.fileType==="variant");}return(o.fileType==="change")&&(o.changeType!=="defaultVariant");}function e(){if(i){if((o.fileType==="variant")||(o.changeType==="defaultVariant")){return o.selector&&o.selector.persistencyKey;}}return true;}function f(){return b.doesContextMatch(o,A);}function g(){if((o.fileType==="ctrl_variant")||(o.fileType==="ctrl_variant_change")||(o.fileType==="ctrl_variant_management_change")){return o.variantManagementReference||o.variantReference||(o.selector&&o.selector.id);}}if((_()&&e()&&f())||g()){return true;}return false;};
d.prototype.getChangesForComponent=function(p){return a.getChangesFillingCache(this._oConnector,this._mComponent,p).then(function(w){var o=p&&p.oComponent;if(w.changes&&w.changes.settings){S._storeInstance(w.changes.settings);}var f=w.changes&&Array.isArray(w.changes.changes)&&w.changes.changes.length!==0;var v=w.changes&&w.changes.variantSection&&!jQuery.isEmptyObject(w.changes.variantSection);if(!f&&!v){return[];}var e=w.changes.changes;if(!this._oMessagebundle&&w.messagebundle&&o){if(!o.getModel("i18nFlexVendor")){if(e.some(function(l){return l.layer==="VENDOR";})){this._oMessagebundle=w.messagebundle;var m=new J(this._oMessagebundle);o.setModel(m,"i18nFlexVendor");}}}var i=p&&p.includeCtrlVariants&&v;var s=p&&p.currentLayer;if(s){e=e.filter(this._filterChangeForCurrentLayer.bind(null,s));if(!i&&v){this._getAllCtrlVariantChanges(w.changes.variantSection,false,s);}}else if(U.isLayerFilteringRequired()&&!(p&&p.ignoreMaxLayerParameter)){e=e.filter(this._filterChangeForMaxLayer);if(!i&&v){this._getAllCtrlVariantChanges(w.changes.variantSection,true);}}if(i){e=e.concat(this._getAllCtrlVariantChanges(w.changes.variantSection));}var h=o?o.getComponentData():(p&&p.componentData||{});if(w.changes.variantSection&&Object.keys(w.changes.variantSection).length!==0&&Object.keys(this._oVariantController._getChangeFileContent()).length===0){this._oVariantController._setChangeFileContent(w,h&&h.technicalParameters);}if(Object.keys(this._oVariantController._getChangeFileContent()).length>0){var j=this._oVariantController.loadInitialChanges();e=i?e:e.concat(j);}var I=p&&p.includeVariants;var k=w.changes.contexts||[];return new Promise(function(r){b.getActiveContexts(k).then(function(A){r(e.filter(this._preconditionsFulfilled.bind(this,A,I)).map(g.bind(this)));}.bind(this));}.bind(this));}.bind(this));function g(o){var e;if(!this._mChangesEntries[o.fileName]){this._mChangesEntries[o.fileName]=new C(o);}e=this._mChangesEntries[o.fileName];e.setState(C.states.PERSISTED);return e;}};
d.prototype._filterChangeForMaxLayer=function(o){return!U.isOverMaxLayer(o.layer);};
d.prototype._filterChangeForCurrentLayer=function(l,o){return l===o.layer;};
d.prototype._getAllCtrlVariantChanges=function(v,f,s){var e=[];var F=function(){return true;};if(f){F=this._filterChangeForMaxLayer;}else if(typeof s==="string"&&s!==""){F=this._filterChangeForCurrentLayer.bind(this,s);}Object.keys(v).forEach(function(g){var o=v[g];o.variants=o.variants.filter(function(h){return!h.content.layer||F(h.content);});o.variants.forEach(function(h){if(Array.isArray(h.variantChanges.setVisible)){h.variantChanges.setVisible=h.variantChanges.setVisible.filter(F);var A=h.variantChanges.setVisible.slice(-1)[0];if(A&&!A.content.visible&&A.content.createdByReset){return;}else{e=e.concat(h.variantChanges.setVisible);}}Object.keys(h.variantChanges).forEach(function(i){if(i!=="setVisible"){h.variantChanges[i]=h.variantChanges[i].filter(F);e=h.variantChanges[i].length>0?e.concat(h.variantChanges[i].slice(-1)[0]):e;}});e=(h.content.fileName!==g)?e.concat([h.content]):e;h.controlChanges=h.controlChanges.filter(F);e=e.concat(h.controlChanges);});Object.keys(o.variantManagementChanges).forEach(function(h){o.variantManagementChanges[h]=o.variantManagementChanges[h].filter(F);e=o.variantManagementChanges[h].length>0?e.concat(o.variantManagementChanges[h].slice(-1)[0]):e;});});return e;};
d.prototype.getChangesForVariant=function(s,e,p){if(this._mVariantsChanges[e]){return Promise.resolve(this._mVariantsChanges[e]);}var i=function(o){var f=false;var g=o._oDefinition.selector;jQuery.each(g,function(h,v){if(h===s&&v===e){f=true;}});return f;};var l=function(k,t){U.log.error("key : "+k+" and text : "+t.value);};return this.getChangesForComponent(p).then(function(f){return f.filter(i);}).then(function(f){this._mVariantsChanges[e]={};if(f&&f.length===0){return L.isFlexServiceAvailable().then(function(g){if(g===false){return Promise.reject();}return Promise.resolve(this._mVariantsChanges[e]);}.bind(this));}var I;f.forEach(function(o){I=o.getId();if(o.isValid()){if(this._mVariantsChanges[e][I]&&o.isVariant()){U.log.error("Id collision - two or more variant files having the same id detected: "+I);jQuery.each(o.getDefinition().texts,l);U.log.error("already exists in variant : ");jQuery.each(this._mVariantsChanges[e][I].getDefinition().texts,l);}this._mVariantsChanges[e][I]=o;}}.bind(this));return this._mVariantsChanges[e];}.bind(this));};
d.prototype.addChangeForVariant=function(s,e,p){var f,i,I,o,g;if(!p){return undefined;}if(!p.type){U.log.error("sap.ui.fl.Persistence.addChange : type is not defined");}var h=jQuery.type(p.content);if(h!=='object'&&h!=='array'){U.log.error("mParameters.content is not of expected type object or array, but is: "+h,"sap.ui.fl.Persistence#addChange");}I={};if(typeof(p.texts)==="object"){jQuery.each(p.texts,function(j,t){I[j]={value:t,type:"XFLD"};});}var v={creation:this._mComponent.appVersion,from:this._mComponent.appVersion};if(this._mComponent.appVersion&&p.developerMode){v.to=this._mComponent.appVersion;}i={changeType:p.type,service:p.ODataService,texts:I,content:p.content,reference:this._mComponent.name,isVariant:p.isVariant,packageName:p.packageName,isUserDependent:p.isUserDependent,validAppVersions:v};i.selector={};i.selector[s]=e;f=C.createInitialFileContent(i);if(p.id){f.fileName=p.id;}o=new C(f);g=o.getId();if(!this._mVariantsChanges[e]){this._mVariantsChanges[e]={};}this._mVariantsChanges[e][g]=o;return o.getId();};
d.prototype.saveAllChangesForVariant=function(s){var p=[];var t=this;jQuery.each(this._mVariantsChanges[s],function(i,o){var e=o.getId();switch(o.getPendingAction()){case"NEW":p.push(t._oConnector.create(o.getDefinition(),o.getRequest(),o.isVariant()).then(function(r){o.setResponse(r.response);if(a.isActive()){a.addChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},r.response);}return r;}));break;case"UPDATE":p.push(t._oConnector.update(o.getDefinition(),o.getId(),o.getRequest(),o.isVariant()).then(function(r){o.setResponse(r.response);if(a.isActive()){a.updateChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},r.response);}return r;}));break;case"DELETE":p.push(t._oConnector.deleteChange({sChangeName:o.getId(),sLayer:o.getLayer(),sNamespace:o.getNamespace(),sChangelist:o.getRequest()},o.isVariant()).then(function(r){var o=t._mVariantsChanges[s][e];if(o.getPendingAction()==="DELETE"){delete t._mVariantsChanges[s][e];}if(a.isActive()){a.deleteChange({name:t._mComponent.name,appVersion:t._mComponent.appVersion},o.getDefinition());}return r;}));break;default:break;}});return Promise.all(p);};
d.prototype._addChangeIntoMap=function(o,e){var s=e.getSelector();if(s&&s.id){var f=s.id;if(s.idIsLocal){f=o.createId(f);}this._addMapEntry(f,e);if(s.idIsLocal===undefined&&f.indexOf("---")!=-1){var g=f.split("---")[0];if(g!==o.getId()){f=f.split("---")[1];f=o.createId(f);this._addMapEntry(f,e);}}}return this._mChanges;};
d.prototype._addMapEntry=function(s,o){if(!this._mChanges.mChanges[s]){this._mChanges.mChanges[s]=[];}if(this._mChanges.mChanges[s].indexOf(o)===-1){this._mChanges.mChanges[s].push(o);}};
d.prototype._addDependency=function(D,o){if(!this._mChanges.mDependencies[D.getId()]){this._mChanges.mDependencies[D.getId()]={changeObject:D,dependencies:[]};}this._mChanges.mDependencies[D.getId()].dependencies.push(o.getId());if(!this._mChanges.mDependentChangesOnMe[o.getId()]){this._mChanges.mDependentChangesOnMe[o.getId()]=[];}this._mChanges.mDependentChangesOnMe[o.getId()].push(D.getId());};
d.prototype._addControlsDependencies=function(D,e){if(e.length>0){if(!this._mChanges.mDependencies[D.getId()]){this._mChanges.mDependencies[D.getId()]={changeObject:D,dependencies:[],controlsDependencies:[]};}this._mChanges.mDependencies[D.getId()].controlsDependencies=e;}};
d.prototype.loadChangesMapForComponent=function(o,p){p.oComponent=!jQuery.isEmptyObject(o)&&o;return this.getChangesForComponent(p).then(e.bind(this));function e(f){this._mChanges={mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};f.forEach(this._addChangeAndUpdateDependencies.bind(this,o));this._mChangesInitial=jQuery.extend(true,{},this._mChanges);return this.getChangesMapForComponent.bind(this);}};
d.prototype.copyDependenciesFromInitialChangesMap=function(o,D){var i=jQuery.extend(true,{},this._mChangesInitial.mDependencies);var I=i[o.getId()];if(I){var n=[];I.dependencies.forEach(function(s){if(D(s)){if(!this._mChanges.mDependentChangesOnMe[s]){this._mChanges.mDependentChangesOnMe[s]=[];}this._mChanges.mDependentChangesOnMe[s].push(o.getId());n.push(s);}}.bind(this));I.dependencies=n;this._mChanges.mDependencies[o.getId()]=I;}return this._mChanges;};
d.prototype._addChangeAndUpdateDependencies=function(o,e,I,f){this._addChangeIntoMap(o,e);var A=U.getAppComponentForControl(o);var D=e.getDependentIdList(A);var g=e.getDependentControlIdList(A);this._addControlsDependencies(e,g);var p;var P;var h;var F;for(var i=I-1;i>=0;i--){p=f[i];P=f[i].getDependentIdList(A);F=false;for(var j=0;j<D.length&&!F;j++){h=P.indexOf(D[j]);if(h>-1){this._addDependency(e,p);F=true;}}}};
d.prototype.getChangesMapForComponent=function(){return this._mChanges;};
d.prototype.getChangesForView=function(v,p){var t=this;return this.getChangesForComponent(p).then(function(f){return f.filter(e.bind(t));});function e(o){var s=o.getSelector();if(!s){return false;}var f=s.id;if(!f||!p){return false;}var g=f.slice(0,f.lastIndexOf("--"));var v;if(o.getSelector().idIsLocal){var A=p.appComponent;if(A){v=A.getLocalId(p.viewId);}}else{v=p.viewId;}return g===v;}};
d.prototype.addChange=function(v,o){var e=this.addDirtyChange(v);this._addChangeIntoMap(o,e);this._addPropagationListener(o);return e;};
d.prototype.addDirtyChange=function(v){var n;if(v instanceof C||v instanceof V){n=v;}else{n=new C(v);}if(this._aDirtyChanges.indexOf(n)===-1){this._aDirtyChanges.push(n);}return n;};
d.prototype._addPropagationListener=function(o){if(o){var f=function(p){return!p._bIsSapUiFlFlexControllerApplyChangesOnControl;};var n=o.getPropagationListeners().every(f);if(n){var m=o.getManifest();var v=U.getAppVersionFromManifest(m);var F=sap.ui.fl.FlexControllerFactory.create(this.getComponentName(),v);var p=F.getBoundApplyChangesOnControl(this.getChangesMapForComponent.bind(this),o);o.addPropagationListener(p);}}};
d.prototype.saveDirtyChanges=function(s){var D=this._aDirtyChanges.slice(0);var e=this._aDirtyChanges;var r=this._getRequests(D);var p=this._getPendingActions(D);if(p.length===1&&r.length===1&&p[0]==="NEW"){var R=r[0];var P=this._prepareDirtyChanges(e);return this._oConnector.create(P,R).then(function(o){this._massUpdateCacheAndDirtyState(e,D,s);return o;}.bind(this));}else{return D.reduce(function(f,o){var g=f.then(this._performSingleSaveAction(o));g.then(this._updateCacheAndDirtyState.bind(this,e,o,s));return g;}.bind(this),Promise.resolve());}};
d.prototype.saveSequenceOfDirtyChanges=function(D,s){var A=this.getDirtyChanges();return D.reduce(function(e,o){var f=e.then(this._performSingleSaveAction(o));f.then(this._updateCacheAndDirtyState.bind(this,A,o,s));return f;}.bind(this),Promise.resolve());};
d.prototype._performSingleSaveAction=function(D){return function(){if(D.getPendingAction()==="NEW"){return this._oConnector.create(D.getDefinition(),D.getRequest());}if(D.getPendingAction()==="DELETE"){return this._oConnector.deleteChange({sChangeName:D.getId(),sLayer:D.getLayer(),sNamespace:D.getNamespace(),sChangelist:D.getRequest()});}}.bind(this);};
d.prototype._updateCacheAndDirtyState=function(D,o,s){if(!s){if(o.getPendingAction()==="NEW"&&o.getFileType()!=="ctrl_variant_change"&&o.getFileType()!=="ctrl_variant_management_change"&&o.getFileType()!=="ctrl_variant"&&!o.getVariantReference()){a.addChange(this._mComponent,o.getDefinition());}else if(o.getPendingAction()==="DELETE"){a.deleteChange(this._mComponent,o.getDefinition());}}var i=D.indexOf(o);if(i>-1){D.splice(i,1);}};
d.prototype._massUpdateCacheAndDirtyState=function(D,e,s){e.forEach(function(o){this._updateCacheAndDirtyState(D,o,s);},this);};
d.prototype._getRequests=function(D){var r=[];D.forEach(function(o){var R=o.getRequest();if(r.indexOf(R)===-1){r.push(R);}});return r;};
d.prototype._getPendingActions=function(D){var p=[];D.forEach(function(o){var P=o.getPendingAction();if(p.indexOf(P)===-1){p.push(P);}});return p;};
d.prototype._prepareDirtyChanges=function(D){var e=[];D.forEach(function(o){e.push(o.getDefinition());});return e;};
d.prototype.getDirtyChanges=function(){return this._aDirtyChanges;};
d.prototype.deleteChange=function(o){var n=this._aDirtyChanges.indexOf(o);if(n>-1){if(o.getPendingAction()==="DELETE"){return;}this._aDirtyChanges.splice(n,1);this._deleteChangeInMap(o);return;}o.markForDeletion();this.addDirtyChange(o);this._deleteChangeInMap(o);};
d.prototype._deleteChangeInMap=function(o){var s=o.getId();var m=this._mChanges.mChanges;var D=this._mChanges.mDependencies;var e=this._mChanges.mDependentChangesOnMe;Object.keys(m).some(function(k){var f=m[k];var n=f.map(function(E){return E.getId();}).indexOf(o.getId());if(n!==-1){f.splice(n,1);return true;}});Object.keys(D).forEach(function(k){if(k===s){delete D[k];}else if(D[k].dependencies&&jQuery.isArray(D[k].dependencies)&&D[k].dependencies.indexOf(s)!==-1){D[k].dependencies.splice(D[k].dependencies.indexOf(s),1);if(D[k].dependencies.length===0){delete D[k];}}});Object.keys(e).forEach(function(k){if(k===s){delete e[k];}else if(jQuery.isArray(e[k])&&e[k].indexOf(s)!==-1){e[k].splice(e[k].indexOf(s),1);if(e[k].length===0){delete e[k];}}});};
d.prototype.loadSwitchChangesMapForComponent=function(v,s,n){return this._oVariantController.getChangesForVariantSwitch(v,s,n,this._mChanges.mChanges);};
d.prototype.transportAllUIChanges=function(r,s,l){var h=function(e){B.hide();var R=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");var m=R.getText("MSG_TRANSPORT_ERROR",e?[e.message||e]:undefined);var t=R.getText("HEADER_TRANSPORT_ERROR");U.log.error("transport error"+e);M.show(m,{icon:M.Icon.ERROR,title:t,styleClass:s});return"Error";};return this._oTransportSelection.openTransportSelection(null,r,s).then(function(t){if(this._oTransportSelection.checkTransportInfo(t)){B.show(0);return this.getChangesForComponent({currentLayer:l,includeCtrlVariants:true}).then(function(A){return this._oTransportSelection._prepareChangesForTransport(t,A).then(function(){B.hide();});}.bind(this));}else{return"Cancel";}}.bind(this))['catch'](h);};
d.prototype.resetChanges=function(l,g){return this.getChangesForComponent({currentLayer:l,includeCtrlVariants:true}).then(function(e){return S.getInstance(this.getComponentName()).then(function(s){if(!s.isProductiveSystem()&&!s.hasMergeErrorOccured()){return this._oTransportSelection.setTransports(e,sap.ui.getCore().getComponent(this.getComponentName()));}}.bind(this)).then(function(){var u="?reference="+this.getComponentName()+"&appVersion="+this._mComponent.appVersion+"&layer="+l+"&generator="+g;if(e.length>0){u=u+"&changelist="+e[0].getRequest();}return this._oConnector.send("/sap/bc/lrep/changes/"+u,"DELETE");}.bind(this));}.bind(this));};
return d;},true);
sap.ui.predefine('sap/ui/fl/ChangePersistenceFactory',["jquery.sap.global","sap/ui/core/Component","sap/ui/fl/ChangePersistence","sap/ui/fl/Utils"],function(q,C,a,U){"use strict";var b={};b._instanceCache={};
b.getChangePersistenceForComponent=function(c,A){var o;A=A||U.DEFAULT_APP_VERSION;if(!b._instanceCache[c]){b._instanceCache[c]={};}o=b._instanceCache[c][A];if(!o){var d={name:c,appVersion:A};o=new a(d);b._instanceCache[c][A]=o;}return o;};
b.getChangePersistenceForControl=function(c){var s;s=this._getComponentClassNameForControl(c);var A=U.getAppVersionFromManifest(U.getAppComponentForControl(c).getManifest());return b.getChangePersistenceForComponent(s,A);};
b._getComponentClassNameForControl=function(c){return U.getComponentClassName(c);};
b.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=this._onLoadComponent.bind(this);};
b._doLoadComponent=function(c,m){var o={oChangePersistence:{},oRequestOptions:{appName:c.name}};var s=U.getFlexReference(m);var A=U.getAppVersionFromManifest(m);var M,S,t;S=c&&c.componentData&&c.componentData.startupParameters||{};t=c&&c.componentData&&c.componentData.technicalParameters;if(S["sap-app-id"]&&S["sap-app-id"].length===1){s=S["sap-app-id"][0];}else{if(c){var d=c.asyncHints;if(d&&d.requests&&Array.isArray(d.requests)){var f=this._findFlAsyncHint(d.requests,s);if(f){o.oRequestOptions.cacheKey=f.cachebusterToken||"<NO CHANGES>";o.oRequestOptions.url=f.url;}}}}var e=t||S;if(e&&e["sap-ui-fl-max-layer"]&&e["sap-ui-fl-max-layer"].length===1){M=e["sap-ui-fl-max-layer"][0];}U.setMaxLayerParameter(M);o.oRequestOptions.siteId=U.getSiteIdByComponentData(c.componentData);o.oChangePersistence=this.getChangePersistenceForComponent(s,A);return o;};
b._onLoadComponent=function(c,m){if(!U.isApplication(m)){return;}var o=this._doLoadComponent(c,m);o.oRequestOptions.componentData={};q.extend(o.oRequestOptions.componentData,c.componentData);o.oChangePersistence.getChangesForComponent(o.oRequestOptions);};
b._getChangesForComponentAfterInstantiation=function(c,m,o){if(!U.isApplication(m)){return Promise.resolve(function(){return{mChanges:{},mDependencies:{},mDependentChangesOnMe:{}};});}var d=this._doLoadComponent(c,m);return d.oChangePersistence.loadChangesMapForComponent(o,d.oRequestOptions);};
b._findFlAsyncHint=function(A,r){var t=this;var f;q.each(A,function(n,o){if(t._flAsyncHintMatches(o,r)){f=o;return false;}});return f;};
b._flAsyncHintMatches=function(A,r){return A.name==="sap.ui.fl.changes"&&A.reference===r;};
return b;},true);
sap.ui.predefine('sap/ui/fl/DefaultVariant',["jquery.sap.global","sap/ui/fl/Change"],function($,C){"use strict";var D=function(){};
D.prototype.getDefaultVariantId=function(c){var d=this.getNewestDefaultVariantChangeDeleteTheRest(c);if(d){return d.getContent().defaultVariantName;}return"";};
D.prototype.getNewestDefaultVariantChangeDeleteTheRest=function(c){var d=this.getDefaultVariantChanges(c).sort(function(a,b){var e=new Date(a.getCreation());var f=new Date(b.getCreation());if(isNaN(e.getDate())){return-1;}if(isNaN(f.getDate())){return 1;}return f-e;});var n=d.shift();d.forEach(function(o){o.markForDeletion();});return n;};
D.prototype.getDefaultVariantChanges=function(c){if(!c||typeof c!=='object'){return[];}return Object.keys(c).map(a).filter(d);function a(s){return c[s];}function d(o){return o.getChangeType()==='defaultVariant';}};
D.prototype.updateDefaultVariantId=function(c,n){var N=this.getNewestDefaultVariantChangeDeleteTheRest(c);if(N){var o=N.getContent();o.defaultVariantName=n;N.setContent(o);}return N;};
D.prototype._createChangeFile=function(p){var f;p.namespace=p.component+'/changes/default';p.componentName=p.component;p.changeType='defaultVariant';f=C.createInitialFileContent(p);f.content.defaultVariantName=p.defaultVariantId;f.layer='USER';return f;};
D.prototype.createChangeObject=function(p){var f,c;f=this._createChangeFile(p);c=new C(f);return c;};
return new D();},true);
sap.ui.predefine('sap/ui/fl/EventHistory',function(){"use strict";var E=function(){};E._aEventIds=["ControlForPersonalizationRendered"];E._aUnsubscribedEventIds=[];E._oHistory={};
E.start=function(){E._aEventIds.forEach(function(e){if(E._aUnsubscribedEventIds.indexOf(e)===-1){sap.ui.getCore().getEventBus().subscribe("sap.ui",e,E.saveEvent);E._oHistory[e]=[];}});};
E.saveEvent=function(c,e,p){var o={"channelId":c,"eventId":e,"parameters":p};if(E._oHistory[e]){E._oHistory[e].push(o);}};
E.getHistoryAndStop=function(e){sap.ui.getCore().getEventBus().unsubscribe("sap.ui",e,E.saveEvent);E._addUnsubscribedEvent(e);return E._oHistory[e]||[];};
E._addUnsubscribedEvent=function(e){if(E._aUnsubscribedEventIds.indexOf(e)===-1){E._aUnsubscribedEventIds.push(e);}};
return E;},true);
sap.ui.predefine('sap/ui/fl/FakeLrepConnector',["jquery.sap.global","sap/ui/thirdparty/URI","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/ChangePersistenceFactory"],function(q,u,F,L,C,a){"use strict";var l=Object.create(L.prototype);b._oBackendInstances={};
function b(i){this.sInitialComponentJsonPath=i;}
for(var p in l){if(typeof l[p]==='function'){b.prototype[p]=(function(p){return function(){throw new Error('Method '+p+'() is not implemented in FakeLrepConnector.');};}(p));}}
b.prototype.loadChanges=function(s){var i=this.sInitialComponentJsonPath;return new Promise(function(r,f){q.getJSON(i).done(function(R){var g={changes:R,componentClassName:s};r(g);}).fail(function(g){f(g);});});};
b.prototype.create=function(f,g,i){if(!i){return Promise.resolve();}if(!f.creation){f.creation=new Date().toISOString();}return Promise.resolve({response:f,status:'success'});};
b.prototype.update=function(f,g,i,j){if(!j){return Promise.resolve();}return Promise.resolve({response:f,status:'success'});};
b.prototype.deleteChange=function(f,i){if(!i){return Promise.resolve();}return Promise.resolve({response:undefined,status:'nocontent'});};
b.prototype.send=function(U,m,D,o){return new Promise(function(r,f){e(U,m,D,o,r,f);d(U,m,D,o,r,f);c(U,m,D,o,r,f);h(U,m,D,o,r,f);});};
function h(U,m,D,o,r){if(U.match(/^\/sap\/bc\/lrep\/changes\//)&&m==='DELETE'){var f=[];var g=/\?reference=([\w.]+)\&.+\&layer=(\w+)\&generator=([\w.]+)/;f=U.match(g);r({response:{"parameters":f},status:"success"});}}
function c(U,m,D,o,r){if(U.match(/^\/sap\/bc\/ui2\/app_index\/ui5_app_mani_first_supported\//)&&m==='GET'){r({response:false,status:"success"});}}
function d(U,m,D,o,r){if(U.match(/^\/sap\/bc\/lrep\/actions\/make_changes_transportable\//)&&m==='POST'){r();}}
function e(U,m,D,o,r,f){if(U.match(/^\/sap\/bc\/lrep\/actions\/gettransports\//)){r({response:{"transports":[{"transportId":"U31K008488","description":"The Ultimate Transport","owner":"Fantasy Owner","locked":false}],"localonly":false,"errorCode":""}});}}
b.enableFakeConnector=function(i,A,s){function r(){b.enableFakeConnector.original=L.createConnector;L.createConnector=function(){if(!b._oFakeInstance){b._oFakeInstance=new b(i);}return b._oFakeInstance;};}if(A&&s){var o=a.getChangePersistenceForComponent(A,s);if(!(o._oConnector instanceof b)){C.clearEntry(A,s);if(!b._oBackendInstances[A]){b._oBackendInstances[A]={};}b._oBackendInstances[A][s]=o._oConnector;o._oConnector=new b(i);}r();return;}C.clearEntries();if(b.enableFakeConnector.original){return;}r();};
b.disableFakeConnector=function(A,s){function r(){if(b.enableFakeConnector.original){L.createConnector=b.enableFakeConnector.original;b.enableFakeConnector.original=undefined;b._oFakeInstance=undefined;}}if(A&&s){var o=a.getChangePersistenceForComponent(A,s);if(!(o._oConnector instanceof L)){C.clearEntry(A,s);if(b._oBackendInstances[A]&&b._oBackendInstances[A][s]){o._oConnector=b._oBackendInstances[A][s];b._oBackendInstances[A][s]=undefined;}}r();return;}C.clearEntries();r();};
return b;},true);
sap.ui.predefine('sap/ui/fl/FlexController',["jquery.sap.global","sap/ui/fl/Persistence","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Cache","sap/ui/fl/registry/Settings","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/View","sap/ui/core/util/reflection/JsControlTreeModifier","sap/ui/core/util/reflection/XmlTreeModifier","sap/ui/fl/context/ContextManager","sap/ui/core/Element"],function(q,P,C,U,L,a,V,b,F,c,d,J,X,e,E){"use strict";var f=function(s,A){this._oChangePersistence=undefined;this._sComponentName=s||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;if(this._sComponentName&&this._sAppVersion){this._createChangePersistence();}};f.appliedChangesCustomDataKey="sap.ui.fl.appliedChanges";f.failedChangesCustomDataKeyJs="sap.ui.fl.failedChanges.js";f.failedChangesCustomDataKeyXml="sap.ui.fl.failedChanges.xml";f.PENDING="sap.ui.fl:PendingChange";f.PROCESSING="sap.ui.fl:ProcessingChange";f.variantTechnicalParameterName="sap-ui-fl-control-variant-id";
f.prototype.setComponentName=function(s){this._sComponentName=s;this._createChangePersistence();};
f.prototype.getComponentName=function(){return this._sComponentName;};
f.prototype.getAppVersion=function(){return this._sAppVersion;};
f.prototype.getVariantModelData=function(){var D;if(this._oChangePersistence&&this._oChangePersistence._oVariantController._mVariantManagement&&Object.keys(this._oChangePersistence._oVariantController._mVariantManagement).length>0){D=this._oChangePersistence._oVariantController._fillVariantModel();}return D;};
f.prototype.createBaseChange=function(o,A){var g,h;var i=e._getContextIdsFromUrl();if(i.length>1){throw new Error("More than one DesignTime Context is currently active.");}if(!A){throw new Error("No Application Component found - to offer flexibility. Valid relation to its owning application component must be present.");}o.reference=this.getComponentName();o.packageName="$TMP";o.context=i.length===1?i[0]:"";o.validAppVersions=this._getValidAppVersions(o);g=a.createInitialFileContent(o);h=new a(g);if(o.variantReference){h.setVariantReference(o.variantReference);}return h;};
f.prototype.createChange=function(o,g){var h,i;if(!g){throw new Error("A flexibility change cannot be created without a targeted control.");}var s=g.id||g.getId();if(!o.selector){o.selector={};}var A=g.appComponent||U.getAppComponentForControl(g);if(!A){throw new Error("No Application Component found - to offer flexibility the control with the id '"+s+"' has to have a valid relation to its owning application component.");}if(U.hasLocalIdSuffix(s,A)){var l=A.getLocalId(s);if(!l){throw new Error("Generated ID attribute found ('"+s+"'); provide a stable ID for the control as required by flexibility for assigning the changes.");}o.selector.id=l;o.selector.idIsLocal=true;}else{o.selector.id=s;o.selector.idIsLocal=false;}h=this.createBaseChange(o,A);var j=g.controlType||U.getControlType(g);if(!j){throw new Error("No control type found - the change handler can not be retrieved.");}i=this._getChangeHandler(h,j,g,J);if(i){i.completeChangeContent(h,o,{modifier:J,appComponent:A});}else{throw new Error("Change handler could not be retrieved for change "+JSON.stringify(o)+".");}return h;};
f.prototype.createVariant=function(v,A){var o,g;if(!A){throw new Error("No Application Component found - to offer flexibility the variant has to have a valid relation to its owning application component.");}v.content.reference=this.getComponentName();v.content.packageName="$TMP";v.content.validAppVersions=this._getValidAppVersions(v);g=V.createInitialFileContent(v);o=new V(g);return o;};
f.prototype._getValidAppVersions=function(o){var A=this.getAppVersion();var v={creation:A,from:A};if(A&&o.developerMode&&o.scenario!==sap.ui.fl.Scenario.AdaptationProject&&o.scenario!==sap.ui.fl.Scenario.AppVariant){v.to=A;}return v;};
f.prototype.addChange=function(o,g){var h=this.createChange(o,g);var i=U.getAppComponentForControl(g);this.addPreparedChange(h,i);return h;};
f.prototype.addPreparedChange=function(o,A){if(o.getVariantReference()){var m=A.getModel("$FlexVariants");m._addChange(o);}this._oChangePersistence.addChange(o,A);return o;};
f.prototype.deleteChange=function(o,A){this._oChangePersistence.deleteChange(o);if(o.getVariantReference()){A.getModel("$FlexVariants")._removeChange(o);}};
f.prototype.createAndApplyChange=function(o,g){var h=this.addChange(o,g);var p={modifier:J,appComponent:U.getAppComponentForControl(g),view:U.getViewForControl(g)};return this.checkTargetAndApplyChange(h,g,p).then(function(r){if(!r.success){var i=r.error||new Error("The change could not be applied.");this._oChangePersistence.deleteChange(h);throw i;}}.bind(this));};
f.prototype._checkDependencies=function(o,D,m,A,r){var R=this._checkChange(o,A);if(!R){return[];}r.push(o);var s=o.getId();var g=D[s]&&D[s].dependencies||[];for(var i=0,n=g.length;i<n;i++){var h=U.getChangeFromChangesMap(m,g[i]);R=this._checkDependencies(h,D,m,A,r);if(R.length===0){r=[];break;}delete D[s];}return r;};
f.prototype._checkChange=function(o,A){var s;var S=o.getSelector();if(S.idIsLocal){s=A.createId(S.id);}else{s=S.id;}var g=sap.ui.getCore().byId(s);if(!g){return false;}var h=this._getFailedCustomDataJs(o,g,J).customDataEntries;if(h.indexOf(o.getId())>-1){return false;}return true;};
f.prototype.waitForChangesToBeApplied=function(o){var m=this._oChangePersistence.getChangesMapForComponent();var p=[];var D=q.extend({},m.mDependencies);var g=m.mChanges;var h=g[o.getId()]||[];var A=this._getAppliedCustomData(undefined,o,J).customDataEntries;var i=U.getAppComponentForControl(o);var n=h.filter(function(j){return A.indexOf(j.getId())===-1;});var r=[];n.forEach(function(j){var k=this._checkDependencies(j,D,m.mChanges,i,[]);r=r.concat(k);},this);r=r.filter(function(j,k,l){return l.indexOf(j)===k;});r.forEach(function(w){if(!w.aPromiseFn){w.aPromiseFn=[];}p.push(new Promise(function(j,k){w.aPromiseFn.push({resolve:j,reject:k});}).catch(function(j){var k=j.getId&&m.mDependentChangesOnMe[j.getId()]||[];k.forEach(function(s){var l=U.getChangeFromChangesMap(g,s);if(l.aPromiseFn){l.aPromiseFn.forEach(function(t){t.reject(l);});}});Promise.resolve();}));},this);return Promise.all(p);};
f.prototype.saveAll=function(s){return this._oChangePersistence.saveDirtyChanges(s);};
f.prototype.processXmlView=function(v,p){var o=sap.ui.getCore().getComponent(p.componentId);var A=U.getAppComponentForControl(o);var m=o.getManifest();p.appComponent=A;p.appDescriptor=m;p.modifier=X;p.view=v;return this.processViewByModifier(p);};
f.prototype.processViewByModifier=function(p){p.siteId=U.getSiteId(p.appComponent);return this._oChangePersistence.getChangesForView(p.viewId,p).then(this._resolveGetChangesForView.bind(this,p),this._handlePromiseChainError.bind(this,p.view));};
f.prototype._resolveGetChangesForView=function(p,g){var h=[];if(!Array.isArray(g)){var s="No list of changes was passed for processing the flexibility on view: "+p.view+".";U.log.error(s,undefined,"sap.ui.fl.FlexController");return[];}g.forEach(function(o){try{var S=this._getSelectorOfChange(o);if(!S||!S.id){throw new Error("No selector in change found or no selector ID.");}var i=p.modifier.bySelector(S,p.appComponent,p.view);if(!i){throw new Error("A flexibility change tries to change a nonexistent control.");}h.push(function(){return this.checkTargetAndApplyChange(o,i,p).then(function(r){if(!r.success){this._logApplyChangeError(r.error||{},o);}}.bind(this));}.bind(this));}catch(j){this._logApplyChangeError(j,o);}}.bind(this));return U.execPromiseQueueSequentially(h).then(function(){return p.view;});};
f.prototype._logApplyChangeError=function(o,g){var D=g.getDefinition();var s=D.changeType;var t=D.selector.id;var h=D.namespace+D.fileName+"."+D.fileType;var w="A flexibility change could not be applied.";w+="\nThe displayed UI might not be displayed as intedend.";if(o.message){w+="\n   occurred error message: '"+o.message+"'";}w+="\n   type of change: '"+s+"'";w+="\n   LRep location of the change: "+h;w+="\n   id of targeted control: '"+t+"'.";U.log.warning(w,undefined,"sap.ui.fl.FlexController");};
f.prototype.checkTargetAndApplyChange=function(o,g,p){var x=p.modifier.targets==="xmlTree";var m=p.modifier;var s=m.getControlType(g);var h=this._getChangeHandler(o,s,g,m);var S;var r;if(!h){var i="Change handler implementation for change not found or change type not enabled for current layer - Change ignored";U.log.warning(i);return new U.FakePromise({success:false,error:new Error(i)});}if(x&&o.getDefinition().jsOnly){return new U.FakePromise({success:false,error:new Error("Change can not be applied in XML. Retrying in JS.")});}var A=this._getAppliedCustomData(o,g,m);var j=A.customDataValue;var k=A.customData;if(!this._isChangeCurrentlyApplied(g,o,m,A)){var R=this.isChangeHandlerRevertible(o,g,h);return new U.FakePromise().then(function(){S=F.getInstanceOrUndef();if(!R&&S&&S._oSettings.recordUndo){if(x){throw new Error();}return new Promise(function(l){sap.ui.require(["sap/ui/rta/ControlTreeModifier"],function(n){if(!n){U.log.error("Please load 'sap/ui/rta' library if you want to record undo");}else{p.modifier=n;n.startRecordingUndo();r=n;}l();});});}}).then(function(){o.PROCESSING=o.PROCESSING?o.PROCESSING:true;return h.applyChange(o,g,p);}).then(function(I){if(I instanceof E){g=I;}if(!R&&S&&S._oSettings.recordUndo&&r){o.setUndoOperations(r.stopRecordingUndo());}var l=o.getId();var v=j?j+","+l:l;this._writeAppliedChangesCustomData(k,v,p,g);if(o.aPromiseFn){o.aPromiseFn.forEach(function(n){n.resolve(o);});}delete o.PROCESSING;o.APPLIED=true;return{success:true};}.bind(this)).catch(function(l){var n;this._setMergeError(true);var t="Change ''{0}'' could not be applied. Merge error detected while "+"processing the {1}.";if(x){n=this._getFailedCustomDataXml(o,g,m);t=q.sap.formatMessage(t,[o.getId(),"XML tree"]);q.sap.log.warning(t,l.stack||"");}else{n=this._getFailedCustomDataJs(o,g,m);t=q.sap.formatMessage(t,[o.getId(),"JS control tree"]);q.sap.log.error(t,l.stack||"");}var u=n.customData;n.customDataEntries.push(o.getId());var v=n.customDataEntries.join(",");if(x){this._writeFailedChangesCustomDataXml(u,v,p,g);}else{this._writeFailedChangesCustomDataJs(u,v,p,g);}if(o.aPromiseFn){o.aPromiseFn.forEach(function(w){w.reject(o);});}delete o.PROCESSING;return{success:false,error:l};}.bind(this));}return new U.FakePromise({success:true});};
f.prototype._removeFromAppliedChangesAndMaybeRevert=function(o,g,p,r){var A,h,i;var m=p.modifier;var s=m.getControlType(g);var j=this._getChangeHandler(o,s,g,m);var R;if(r&&!j){U.log.warning("Change handler implementation for change not found or change type not enabled for current layer - Change ignored");return new U.FakePromise();}var k=o.getId();var l=this._getAppliedCustomData(o,g,m);A=l.customDataEntries;h=l.customData;i=A.indexOf(k);if(i===-1&&(o.PROCESSING||o.QUEUED)){R=new Promise(function(n,t){o.aPromiseFn=o.aPromiseFn||[];o.aPromiseFn.push({resolve:n,reject:t});}).then(function(v){return true;});}else{R=new U.FakePromise(false);}return R.then(function(n){if(r&&(n||(!n&&i>-1))){return j.revertChange(o,g,p);}}).then(function(){l=this._getAppliedCustomData(o,g,m);A=l.customDataEntries;h=l.customData;i=A.indexOf(k);if(i>-1&&h){A.splice(i,1);this._writeAppliedChangesCustomData(h,A.join(),p,g);}}.bind(this)).catch(function(n){U.log.error("Change could not be reverted:",n);});};
f.prototype._writeAppliedChangesCustomData=function(o,v,p,g){this._writeCustomData(o,v,p,g,f.appliedChangesCustomDataKey);};
f.prototype._writeFailedChangesCustomDataXml=function(o,v,p,g){this._writeCustomData(o,v,p,g,f.failedChangesCustomDataKeyXml);};
f.prototype._writeFailedChangesCustomDataJs=function(o,v,p,g){this._writeCustomData(o,v,p,g,f.failedChangesCustomDataKeyJs);};
f.prototype._writeCustomData=function(o,v,p,g,s){var m=p.modifier;if(o){m.setProperty(o,"value",v);}else{var A=p.appComponent;var h=p.view;o=m.createControl("sap.ui.core.CustomData",A,h);m.setProperty(o,"key",s);m.setProperty(o,"value",v);m.insertAggregation(g,"customData",o,0,h);}};
f.prototype._getAppliedCustomData=function(o,g,m){return this._getCustomData(o,g,m,f.appliedChangesCustomDataKey);};
f.prototype._getFailedCustomDataXml=function(o,g,m){return this._getCustomData(o,g,m,f.failedChangesCustomDataKeyXml);};
f.prototype._getFailedCustomDataJs=function(o,g,m){return this._getCustomData(o,g,m,f.failedChangesCustomDataKeyJs);};
f.prototype._getCustomData=function(o,g,m,s){var h=m.getAggregation(g,"customData")||[];var r={customDataEntries:[]};h.some(function(i){var k=m.getProperty(i,"key");if(k===s){r.customData=i;r.customDataValue=m.getProperty(i,"value");r.customDataEntries=r.customDataValue.split(",");return true;}});return r;};
f.prototype._handlePromiseChainError=function(v,o){U.log.error("Error processing view "+o+".");return v;};
f.prototype._getSelectorOfChange=function(o){if(!o||!o.getSelector){return undefined;}return o.getSelector();};
f.prototype._getChangeHandler=function(o,s,g,m){var h=o.getChangeType();var l=o.getLayer();return this._getChangeRegistry().getChangeHandler(h,s,g,m,l);};
f.prototype._getChangeRegistry=function(){var i=C.getInstance();i.initSettings();return i;};
f.prototype.getComponentChanges=function(p){return this._oChangePersistence.getChangesForComponent(p);};
f.prototype.isPersonalized=function(p){p=p||{};p.includeVariants=true;return this.getComponentChanges(p).then(function(g){var i=g.some(function(o){return o.isUserDependent();});return!!i;});};
f.prototype._createChangePersistence=function(){this._oChangePersistence=c.getChangePersistenceForComponent(this.getComponentName(),this.getAppVersion());return this._oChangePersistence;};
f.prototype.resetChanges=function(l,g,o){return this._oChangePersistence.resetChanges(l,g).then(function(r){if(o){var m=o.getModel("$FlexVariants");if(m){m.updateHasherEntry({parameters:[],updateURL:true,component:o});}}return r;});};
f.prototype.discardChanges=function(g,D){var A=U.getCurrentLayer(!!D);var i=0;var l;var o;l=g.length;while(i<g.length){o=g[i];if(o&&o.getLayer&&o.getLayer()===A){this._oChangePersistence.deleteChange(o);}if(l===g.length){i++;}else{l=g.length;}}return this._oChangePersistence.saveDirtyChanges();};
f.prototype.discardChangesForId=function(i,D){if(!i){return Promise.resolve();}var o=this._oChangePersistence.getChangesMapForComponent();var g=o.mChanges[i]||[];return this.discardChanges(g,D);};
f.prototype._setMergeError=function(){return F.getInstance().then(function(s){s.setMergeErrorOccured(true);});};
f.prototype._isChangeCurrentlyApplied=function(o,g,m,h){if(!h){h=this._getAppliedCustomData(g,o,J);}var A=h.customDataEntries;var s=g.getId();return A.indexOf(s)>-1;};
f.prototype._checkIfDependencyIsStillValid=function(A,m,s){var o=U.getChangeFromChangesMap(this._oChangePersistence._mChanges.mChanges,s);if(!o.APPLIED){return true;}var g=m.bySelector(o.getSelector(),A);if(!this._isChangeCurrentlyApplied(g,o,m)){return true;}return false;};
f.prototype._applyChangesOnControl=function(g,A,o){var p=[];var m=g();var h=m.mChanges;var D=m.mDependencies;var i=m.mDependentChangesOnMe;var j=h[o.getId()]||[];var k={modifier:J,appComponent:A,view:U.getViewForControl(o)};j.forEach(function(l){if(l.APPLIED&&!this._isChangeCurrentlyApplied(o,l,k.modifier)){m=this._oChangePersistence.copyDependenciesFromInitialChangesMap(l,this._checkIfDependencyIsStillValid.bind(this,A,k.modifier));D=m.mDependencies;i=m.mDependentChangesOnMe;delete l.APPLIED;}if(!D[l.getId()]){l.QUEUED=true;p.push(function(){return this.checkTargetAndApplyChange(l,o,k).then(function(r){if(r.success){this._updateDependencies(D,i,l.getId());}delete l.QUEUED;}.bind(this));}.bind(this));}else{D[l.getId()][f.PENDING]=this.checkTargetAndApplyChange.bind(this,l,o,k);}}.bind(this));return U.execPromiseQueueSequentially(p).then(function(){return this._processDependentQueue(D,i);}.bind(this));};
f.prototype.getBoundApplyChangesOnControl=function(g,o){var B=this._applyChangesOnControl.bind(this,g,o);B._bIsSapUiFlFlexControllerApplyChangesOnControl=true;return B;};
f.prototype.revertChangesOnControl=function(g,A){var p=[];g.forEach(function(o){p.push(function(){var s=this._getSelectorOfChange(o);var h=J.bySelector(s,A);var m={modifier:J,appComponent:A,view:U.getViewForControl(h)};return this._removeFromAppliedChangesAndMaybeRevert(o,h,m,true).then(function(){this._oChangePersistence._deleteChangeInMap(o);}.bind(this));}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};
f.prototype.isChangeHandlerRevertible=function(o,g,h){if(!h){var s=J.getControlType(g);h=this._getChangeHandler(o,s,g,J);}return!!(h&&typeof h.revertChange==="function");};
f.prototype.applyVariantChanges=function(g,o){var A=U.getAppComponentForControl(o);var p=[];g.forEach(function(h){var m=this._oChangePersistence.getChangesMapForComponent().mChanges;var i=Object.keys(m).reduce(function(g,s){return g.concat(m[s]);},[]);this._oChangePersistence._addChangeAndUpdateDependencies(o,h,i.length,i);p.push(function(){var M=J;var s=this._getSelectorOfChange(h);var j=M.bySelector(s,A);if(!j){U.log.error("A flexibility change tries to change a nonexistent control.");return new U.FakePromise();}return this._applyChangesOnControl(this._oChangePersistence.getChangesMapForComponent.bind(this._oChangePersistence),A,j);}.bind(this));}.bind(this));return U.execPromiseQueueSequentially(p);};
f.prototype.removeFromAppliedChangesOnControl=function(o,A,g){var p={modifier:J,appComponent:A,view:U.getViewForControl(g)};return this._removeFromAppliedChangesAndMaybeRevert(o,g,p,false);};
f.prototype._updateControlsDependencies=function(D){var o;Object.keys(D).forEach(function(s){var g=D[s];if(g.controlsDependencies&&g.controlsDependencies.length>0){var l=g.controlsDependencies.length;while(l--){var i=g.controlsDependencies[l];o=sap.ui.getCore().byId(i);if(o){g.controlsDependencies.splice(l,1);}}}});};
f.prototype._updateDependencies=function(D,m,s){if(m[s]){m[s].forEach(function(k){var o=D[k];var i=o.dependencies.indexOf(s);if(i>-1){o.dependencies.splice(i,1);}});delete m[s];}};
f.prototype._iterateDependentQueue=function(D,m){var A=[],g=[],p=[];this._updateControlsDependencies(D);Object.keys(D).forEach(function(s){var o=D[s];if(o[f.PENDING]&&o.dependencies.length===0&&!(o.controlsDependencies&&o.controlsDependencies.length>0)&&!o[f.PROCESSING]){o[f.PROCESSING]=true;p.push(function(){return o[f.PENDING]().then(function(r){if(r.success){g.push(s);A.push(o.changeObject.getId());}});});}});return U.execPromiseQueueSequentially(p).then(function(){for(var j=0;j<g.length;j++){delete D[g[j]];}for(var k=0;k<A.length;k++){this._updateDependencies(D,m,A[k]);}return A;}.bind(this));};
f.prototype._processDependentQueue=function(D,m){return this._iterateDependentQueue(D,m).then(function(A){if(A.length>0){return this._processDependentQueue(D,m);}}.bind(this));};
return f;},true);
sap.ui.predefine('sap/ui/fl/FlexControllerFactory',["jquery.sap.global","sap/ui/fl/FlexController","sap/ui/fl/Utils","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/variants/VariantModel"],function(q,F,U,C,V){"use strict";var a={};a._instanceCache={};
a.create=function(c,A){var A=A||U.DEFAULT_APP_VERSION;if(!a._instanceCache[c]){a._instanceCache[c]={};}var f=a._instanceCache[c][A];if(!f){f=new F(c,A);a._instanceCache[c][A]=f;}return f;};
a.createForControl=function(c,m){var s=U.getComponentClassName(c);var l=m||U.getAppComponentForControl(c).getManifest();var A=U.getAppVersionFromManifest(l);return a.create(s,A);};
a.getChangesAndPropagate=function(c,v){var m=c.getManifestObject();if(U.isApplication(m)){var f=a.createForControl(c,m);C._getChangesForComponentAfterInstantiation(v,m,c).then(function(g){c.addPropagationListener(f.getBoundApplyChangesOnControl(g,c));var d=f.getVariantModelData()||{};c.setModel(new V(d,f,c),"$FlexVariants");});}};
return a;},true);
sap.ui.predefine('sap/ui/fl/LrepConnector',["jquery.sap.global","sap/ui/thirdparty/URI","sap/ui/fl/Utils"],function(q,u,F){"use strict";var C=function(p){this._initClientParam();this._initLanguageParam();if(p){this._sXsrfToken=p.XsrfToken;}};
C.createConnector=function(p){return new C(p);};
C._bServiceAvailability=undefined;C.prototype.DEFAULT_CONTENT_TYPE="application/json; charset=utf-8";C.prototype._sClient=undefined;C.prototype._sLanguage=undefined;C.prototype._aSentRequestListeners=[];C.prototype._sRequestUrlPrefix="";
C.isFlexServiceAvailable=function(){if(C._bServiceAvailability!==undefined){return Promise.resolve(C._bServiceAvailability);}return C.createConnector().loadSettings().then(function(){return Promise.resolve(C._bServiceAvailability);});};
C.attachSentRequest=function(c){if(typeof c==="function"&&C.prototype._aSentRequestListeners.indexOf(c)===-1){C.prototype._aSentRequestListeners.push(c);}};
C.detachSentRequest=function(c){var i=C.prototype._aSentRequestListeners.indexOf(c);if(i!==-1){C.prototype._aSentRequestListeners.splice(i,1);}};
C.prototype._initClientParam=function(){var c=F.getClient();if(c){this._sClient=c;}};
C.prototype._initLanguageParam=function(){var l;l=F.getUrlParameter("sap-language")||F.getUrlParameter("sap-ui-language");if(l){this._sLanguage=l;}};
C.prototype.setRequestUrlPrefix=function(r){this._sRequestUrlPrefix=r;};
C.prototype._resolveUrl=function(r){if(!q.sap.startsWith(r,"/")){r="/"+r;}r=this._sRequestUrlPrefix+r;var U=u(r).absoluteTo("");return U.toString();};
C.prototype._getDefaultHeader=function(){var h={headers:{"X-CSRF-Token":this._sXsrfToken||"fetch"}};return h;};
C.prototype._getDefaultOptions=function(m,c,d){var o;if(!c){c=this.DEFAULT_CONTENT_TYPE;}else if(c.indexOf("charset")===-1){c+="; charset=utf-8";}o=q.extend(true,this._getDefaultHeader(),{type:m,async:true,contentType:c,processData:false,headers:{"Content-Type":c}});if(d&&o.contentType.indexOf("application/json")===0){o.dataType="json";if(typeof d==="object"){o.data=JSON.stringify(d);}else{o.data=d;}}else if(d){o.data=d;}if(m==="DELETE"){delete o.data;delete o.contentType;}return o;};
C.prototype.send=function(U,m,d,o){m=m||"GET";m=m.toUpperCase();o=o||{};U=this._resolveUrl(U);if(o.success||o.error){var e="Success and error handler are not allowed in mOptions";throw new Error(e);}var c=o.contentType||this.DEFAULT_CONTENT_TYPE;o=q.extend(true,this._getDefaultOptions(m,c,d),o);return this._sendAjaxRequest(U,o);};
C.prototype._getMessagesFromXHR=function(x){var a,m,l,i;m=[];try{a=JSON.parse(x.responseText);if(a&&a.messages&&a.messages.length>0){l=a.messages.length;for(i=0;i<l;i++){m.push({severity:a.messages[i].severity,text:a.messages[i].text});}}}catch(e){}return m;};
C.prototype._sendAjaxRequest=function(U,o){var t=this;var f="/sap/bc/lrep/actions/getcsrftoken/";var m={headers:{"X-CSRF-Token":"fetch"},type:"HEAD"};if(this._sClient){m.headers["sap-client"]=this._sClient;}return new Promise(function(r,a){function h(d,s,x){var n=x.getResponseHeader("X-CSRF-Token");t._sXsrfToken=n||t._sXsrfToken;var e=x.getResponseHeader("etag");var g={status:s,etag:e,response:d};r(g);q.each(t._aSentRequestListeners,function(i,j){j(g);});}function b(d,s,x){t._sXsrfToken=x.getResponseHeader("X-CSRF-Token");o.headers=o.headers||{};o.headers["X-CSRF-Token"]=t._sXsrfToken;q.ajax(U,o).done(h).fail(function(x,s,e){var E=new Error(e);E.status="error";E.code=x.statusCode().status;E.messages=t._getMessagesFromXHR(x);a(E);});}function c(x,s,e){if(x.status===403){q.ajax(f,m).done(b).fail(function(x,s,e){a({status:"error"});});}else{if(o&&o.type==="DELETE"&&x.status===404){r();}else{var d;d={status:"error",code:x.statusCode().status,messages:t._getMessagesFromXHR(x)};a(d);}}}var R=true;if(o&&o.type){if(o.type==="GET"||o.type==="HEAD"){R=false;}else if(t._sXsrfToken&&t._sXsrfToken!=="fetch"){R=false;}}if(R){q.ajax(f,m).done(b).fail(function(x,s,e){a({status:"error",code:x.statusCode().status,messages:t._getMessagesFromXHR(x)});});}else{q.ajax(U,o).done(h).fail(c);}});};
C.prototype.loadChanges=function(c,p){var o={};var s=c.name;var U="/sap/bc/lrep/flex/data/";p=p||{};if(!s||s.match(new RegExp(/^\$*\{[a-zA-Z0-9\.]*\}/g))){return Promise.reject(new Error("Component name not specified"));}if(p.url){U=p.url;}else{if(p.cacheKey){o.cache=true;U+="~"+p.cacheKey+"~/";}U+=s;}if(p.siteId){if(!o.headers){o.headers={};}o.headers={"X-LRep-Site-Id":p.siteId};}if(p.layer){U+="&upToLayerType="+p.layer;}if(p.appDescriptor){if(p.appDescriptor["sap.app"]){if(!o.headers){o.headers={};}o.headers={"X-LRep-AppDescriptor-Id":p.appDescriptor["sap.app"].id};}}if(this._sClient){U+="&sap-client="+this._sClient;}if(c.appVersion&&(c.appVersion!==F.DEFAULT_APP_VERSION)){if(c.appVersion.match(new RegExp(/^\$*\{[a-zA-Z0-9\.]*\}/g))){return Promise.reject(new Error("Component appVersion is invalid"));}U+="&appVersion="+c.appVersion;}U=U.replace("&","?");return this.send(U,undefined,undefined,o).then(function(r){C._bServiceAvailability=true;return{changes:r.response,messagebundle:r.response.messagebundle,componentClassName:s,etag:r.etag};},function(e){if(e.code===404){C._bServiceAvailability=false;}throw(e);});};
C.prototype.loadSettings=function(){var U="/sap/bc/lrep/flex/settings";if(this._sClient){U+="?sap-client="+this._sClient;}return this.send(U,undefined,undefined,{}).then(function(r){C._bServiceAvailability=true;return r.response;},function(e){if(e.code===404){C._bServiceAvailability=false;}return Promise.resolve();});};
C.prototype._buildParams=function(p){if(!p){p=[];}if(this._sClient){p.push({name:"sap-client",value:this._sClient});}if(this._sLanguage){p.push({name:"sap-language",value:this._sLanguage});}var r="";var l=p.length;for(var i=0;i<l;i++){if(i===0){r+="?";}else if(i>0&&i<l){r+="&";}r+=p[i].name+"="+p[i].value;}return r;};
C.prototype._getUrlPrefix=function(i){if(i){return"/sap/bc/lrep/variants/";}return"/sap/bc/lrep/changes/";};
C.prototype.create=function(p,c,i){var r=this._getUrlPrefix(i);var P=[];if(c){P.push({name:"changelist",value:c});}r+=this._buildParams(P);return this.send(r,"POST",p,null);};
C.prototype.update=function(p,c,s,i){var r=this._getUrlPrefix(i);r+=c;var P=[];if(s){P.push({name:"changelist",value:s});}r+=this._buildParams(P);return this.send(r,"PUT",p,null);};
C.prototype.deleteChange=function(p,i){var r=this._getUrlPrefix(i);r+=p.sChangeName;var P=[];if(p.sLayer){P.push({name:"layer",value:p.sLayer});}if(p.sNamespace){P.push({name:"namespace",value:p.sNamespace});}if(p.sChangelist){P.push({name:"changelist",value:p.sChangelist});}r+=this._buildParams(P);return this.send(r,"DELETE",{},null);};
C.prototype.getStaticResource=function(n,N,t,i){var a="/sap/bc/lrep/content/";var r=a;r+=n+"/"+N+"."+t;var p=[];if(!i){p.push({name:"dt",value:"true"});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
C.prototype.getFileAttributes=function(n,N,t,l){var a="/sap/bc/lrep/content/";var r=a;r+=n+"/"+N+"."+t;var p=[];p.push({name:"metadata",value:"true"});if(l){p.push({name:"layer",value:l});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
C.prototype.upsert=function(n,N,t,l,c,s,a){var b=this;return Promise.resolve(b._fileAction("PUT",n,N,t,l,c,s,a));};
C.prototype.deleteFile=function(n,N,t,l,c){return this._fileAction("DELETE",n,N,t,l,null,null,c);};
C.prototype._fileAction=function(m,n,N,t,l,c,s,a){var A="/sap/bc/lrep/content/";var r=A;r+=n+"/"+N+"."+t;var p=[];p.push({name:"layer",value:l});if(a){p.push({name:"changelist",value:a});}r+=this._buildParams(p);var o={contentType:s||this.DEFAULT_CONTENT_TYPE};return this.send(r,m.toUpperCase(),c,o);};
C.prototype.publish=function(o,n,t,O,T,s,c){var a="/sap/bc/lrep/actions/publish/";var r=a;r+=o+"/"+n+"."+t;var p=[];if(O){p.push({name:"layer",value:O});}if(T){p.push({name:"target-layer",value:T});}if(s){p.push({name:"target-namespace",value:s});}if(c){p.push({name:"changelist",value:c});}r+=this._buildParams(p);return this.send(r,"POST",{},null);};
C.prototype.listContent=function(n,l){var r="/sap/bc/lrep/content/";r+=n;var p=[];if(l){p.push({name:"layer",value:l});}r+=this._buildParams(p);return this.send(r,"GET",null,null);};
return C;},true);
sap.ui.predefine('sap/ui/fl/Persistence',["sap/ui/fl/Change","sap/ui/fl/DefaultVariant","sap/ui/fl/StandardVariant","sap/ui/fl/Utils","jquery.sap.global","sap/ui/fl/ChangePersistenceFactory"],function(C,d,s,U,$,a){"use strict";var P=function(c,S){this._oControl=c;this._sStableIdPropertyName=S||'id';this._sStableId=this._getStableId();this._sComponentName=U.getComponentClassName(c);if(!this._sComponentName){U.log.error("The Control does not belong to an SAPUI5 component. Variants and Changes for this control might not work as expected.");}this._oAppDescriptor=U.getAppDescriptor(c);this._sSiteId=U.getSiteId(c);this._oChangePersistence=a.getChangePersistenceForControl(this._oControl);this._oChanges={};};
P.prototype._getStableId=function(){if(!this._oControl){return undefined;}if((this._sStableIdPropertyName)&&(this._sStableIdPropertyName!=='id')){var S;try{S=this._oControl.getProperty(this._sStableIdPropertyName);}catch(e){S="";}return S;}if(typeof this._oControl.getId!=='function'){return undefined;}return this._oControl.getId();};
P.prototype.getChanges=function(){var p={appDescriptor:this._oAppDescriptor,siteId:this._sSiteId,includeVariants:true};if(!jQuery.isEmptyObject(this._oChanges)){return Promise.resolve(this._oChanges);}return this._oChangePersistence.getChangesForVariant(this._sStableIdPropertyName,this._sStableId,p).then(function(c){this._oChanges=c;return this._oChanges;}.bind(this));};
P.prototype.getChange=function(c){if(!c){U.log.error("sap.ui.fl.Persistence.getChange : sChangeId is not defined");return undefined;}return this._oChanges[c];};
P.prototype.addChange=function(p){return this._oChangePersistence.addChangeForVariant(this._sStableIdPropertyName,this._sStableId,p);};
P.prototype.getExecuteOnSelect=function(){return this.getChanges().then(function(c){return s.getExecuteOnSelect(c);});};
P.prototype.getExecuteOnSelectSync=function(){return s.getExecuteOnSelect(this._oChanges);};
P.prototype.setExecuteOnSelectSync=function(e){var p,c;var b={};b[this._sStableIdPropertyName]=this._sStableId;p={executeOnSelect:e,reference:this._sComponentName,selector:b};c=s.updateExecuteOnSelect(this._oChanges,e);if(c){return c;}c=s.createChangeObject(p);var f=c.getId();this._oChanges[f]=c;return c;};
P.prototype.getDefaultVariantId=function(){return this.getChanges().then(function(c){return d.getDefaultVariantId(c);});};
P.prototype.getDefaultVariantIdSync=function(){return d.getDefaultVariantId(this._oChanges);};
P.prototype.setDefaultVariantIdSync=function(D){var p,c;var b={};b[this._sStableIdPropertyName]=this._sStableId;p={defaultVariantId:D,reference:this._sComponentName,selector:b};c=d.updateDefaultVariantId(this._oChanges,D);if(c){return c;}c=d.createChangeObject(p);var e=c.getId();this._oChanges[e]=c;return c;};
P.prototype.saveAll=function(){return this._oChangePersistence.saveAllChangesForVariant(this._sStableId);};
P.prototype.isVariantDownport=function(){var l,i;l=U.getCurrentLayer();i=U.isHotfixMode();return((l==='VENDOR')&&(i));};
return P;},true);
sap.ui.predefine('sap/ui/fl/Preprocessor',['jquery.sap.global','sap/ui/base/Object'],function(q,B){'use strict';return B.extend("sap.ui.fl.Preprocessor",{});},true);
sap.ui.predefine('sap/ui/fl/PreprocessorImpl',['jquery.sap.global','sap/ui/core/Component','sap/ui/fl/Utils','sap/ui/fl/ChangePersistenceFactory'],function(jQuery,Component,Utils,ChangePersistenceFactory){'use strict';var PreprocessorImpl=function(){};
PreprocessorImpl.prototype.getControllerExtensions=function(c,C,a){if(a){if(!C){jQuery.sap.log.warning("No component ID for determining the anchor of the code extensions was passed.");return Promise.resolve([]);}var o=Component.get(C);var A=Utils.getAppComponentForControl(o);var f=Utils.getComponentClassName(A);var s=Utils.getAppVersionFromManifest(A.getManifest());var b=ChangePersistenceFactory.getChangePersistenceForComponent(f,s);return b.getChangesForComponent().then(function(d){if(!this._mPreloaded){this._mPreloaded={};}if(!this._mPreloaded[C]){this.aCodeExtChanges=[];this._preloadExtensions(d);this._mPreloaded[C]=true;}var e=[];this.aCodeExtChanges.forEach(function(g){var h=g.getDefinition();if(h.content&&c===h.selector.controllerName){e.push(PreprocessorImpl.getExtensionProvider(h));}});return Promise.all(e);}.bind(this));}else{jQuery.sap.log.warning("Synchronous extensions are not supported by sap.ui.fl.PreprocessorImpl");return[];}};
PreprocessorImpl.prototype._preloadExtensions=function(aChanges){var oCodeExtensions={};var oExtensionProvider;aChanges.forEach(function(oChange){var sChangeType=oChange.getChangeType();var oContent=oChange.getContent();if(sChangeType==="codeExt"&&oContent.code){var sConvertedCodeContent=Utils.asciiToString(oContent.code);eval("oExtensionProvider = function() {"+sConvertedCodeContent+"}");oCodeExtensions[oContent.codeRef]=oExtensionProvider;this.aCodeExtChanges.push(oChange);}}.bind(this));if(Object.keys(oCodeExtensions).length>0){sap.ui.require.preload(oCodeExtensions);}};
PreprocessorImpl.getExtensionProvider=function(c){return new Promise(function(r){var C=c.content.codeRef;var f=C.substr(0,C.lastIndexOf("."));sap.ui.require([f],function(e){r(e);},function(e){Utils.log.error("Code Extension not found",e.message);r({});});});};
return PreprocessorImpl;},true);
sap.ui.predefine('sap/ui/fl/RegistrationDelegator',["sap/ui/fl/FlexControllerFactory","sap/ui/core/Component","sap/ui/fl/registry/ChangeHandlerRegistration","sap/ui/fl/ChangePersistenceFactory","sap/ui/core/mvc/Controller","sap/ui/core/mvc/XMLView","sap/ui/fl/EventHistory"],function(F,C,a,b,M,X,E){"use strict";var R={};
R.registerChangesInComponent=function(){C._fnOnInstanceCreated=F.getChangesAndPropagate;};
R.registerChangeHandlers=function(){a.getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs();};
R.registerLoadComponentEventHandler=function(){C._fnLoadComponentCallback=b._onLoadComponent.bind(b);};
R.registerExtensionProvider=function(){M.registerExtensionProvider("sap.ui.fl.PreprocessorImpl");};
R.registerXMLPreprocessor=function(){if(X.registerPreprocessor){X.registerPreprocessor("viewxml","sap.ui.fl.XmlPreprocessorImpl",true);}};
R.registerEventListener=function(){E.start();};
R.registerAll=function(){R.registerEventListener();R.registerChangeHandlers();R.registerLoadComponentEventHandler();R.registerExtensionProvider();R.registerChangesInComponent();R.registerXMLPreprocessor();};
return R;},true);
sap.ui.predefine('sap/ui/fl/StandardVariant',["jquery.sap.global","sap/ui/fl/Change"],function($,C){"use strict";var S=function(){};
S.prototype.getExecuteOnSelect=function(c){var a=this.getNewestStandardVariantChangeDeleteTheRest(c);if(a){return a.getContent().executeOnSelect;}return null;};
S.prototype.getNewestStandardVariantChangeDeleteTheRest=function(c){var d=this.getStandardVariantChanges(c).sort(function(a,b){var D=new Date(a.getCreation());var e=new Date(b.getCreation());if(isNaN(D.getDate())){return-1;}if(isNaN(e.getDate())){return 1;}return e-D;});var n=d.shift();d.forEach(function(o){o.markForDeletion();});return n;};
S.prototype.getStandardVariantChanges=function(c){if(!c||typeof c!=='object'){return[];}return Object.keys(c).map(a).filter(b);function a(s){return c[s];}function b(o){return o.getChangeType()==='standardVariant';}};
S.prototype.updateExecuteOnSelect=function(c,n){var N=this.getNewestStandardVariantChangeDeleteTheRest(c);if(N){var o=N.getContent();o.executeOnSelect=n;N.setContent(o);}return N;};
S.prototype._createChangeFile=function(p){var f;p.namespace=p.component+'/changes/standard';p.componentName=p.component;p.changeType='standardVariant';f=C.createInitialFileContent(p);f.content.executeOnSelect=p.executeOnSelect;f.layer='USER';return f;};
S.prototype.createChangeObject=function(p){var f,c;f=this._createChangeFile(p);c=new C(f);return c;};
return new S();},true);
sap.ui.predefine('sap/ui/fl/Utils',["jquery.sap.global","sap/ui/core/Component","sap/ui/core/util/reflection/BaseTreeModifier","sap/ui/thirdparty/hasher"],function(q,C,B,h){"use strict";var l=["VENDOR","PARTNER","CUSTOMER_BASE","CUSTOMER","USER"];var L={};l.forEach(function(s,i){L[s]=i;});var U={_aLayers:l,_mLayersIndex:L,_sTopLayer:l[l.length-1],_sMaxLayer:l[l.length-1],DEFAULT_APP_VERSION:"DEFAULT_APP_VERSION",APP_ID_AT_DESIGN_TIME:"${pro"+"ject.art"+"ifactId}",log:{error:function(m,d,c){q.sap.log.error(m,d,c);},warning:function(m,d,c){q.sap.log.warning(m,d,c);},debug:function(m,d,c){q.sap.log.debug(m,d,c);}},getXSRFTokenFromControl:function(c){var m;if(!c){return"";}if(c&&typeof c.getModel==="function"){m=c.getModel();return U._getXSRFTokenFromModel(m);}return"";},_getXSRFTokenFromModel:function(m){var H;if(!m){return"";}if(typeof m.getHeaders==="function"){H=m.getHeaders();if(H){return H["x-csrf-token"];}}return"";},getComponentClassName:function(c){var a;if(c){a=this.getAppComponentForControl(c);if(a){var v=this._getComponentStartUpParameter(a,"sap-app-id");if(v){return v;}if(a.getManifestEntry("sap.ui5")&&a.getManifestEntry("sap.ui5").appVariantId){return a.getManifestEntry("sap.ui5").appVariantId;}}}return U.getComponentName(a);},isVariantByStartupParameter:function(c){if(c){var a=this.getAppComponentForControl(c);if(a){return!!this._getComponentStartUpParameter(a,"sap-app-id");}}return false;},getAppComponentClassNameForComponent:function(c){return U.getComponentClassName(c);},getAppDescriptor:function(c){var m=null,o=null,a=null;if(c){o=this.getAppComponentForControl(c);if(o&&o.getMetadata){a=o.getMetadata();if(a&&a.getManifest){m=a.getManifest();}}}return m;},getSiteId:function(c){var s=null,o=null;if(c){o=this.getAppComponentForControl(c);if(o){s=this._getComponentStartUpParameter(o,"hcpApplicationId");}}return s;},getSiteIdByComponentData:function(c){var s=null;s=this._getStartUpParameter(c,"hcpApplicationId");return s;},isAppVariantMode:function(c){return(U.isVendorLayer()&&U.isApplicationVariant(c));},isBinding:function(p){var i=false;if(p&&typeof p==="string"&&p.substring(0,1)==="{"&&p.slice(-1)==="}"){i=true;}return i;},isVendorLayer:function(){if(U.getCurrentLayer(false)==="VENDOR"){return true;}return false;},isApplicationVariant:function(c){var f=U.getComponentClassName(c);var a=U.getAppComponentForControl(c);var s=U.getComponentName(a);return f!==s;},setMaxLayerParameter:function(m){this._sMaxLayer=m||this._sTopLayer;},getLayerIndex:function(s){return this._mLayersIndex[s];},isOverMaxLayer:function(s){return(this.getLayerIndex(s)>this.getLayerIndex(this._sMaxLayer));},isLayerAboveCurrentLayer:function(s){var c=U.getCurrentLayer(false);if((this.getLayerIndex(c)>this.getLayerIndex(s))||!s){return-1;}else if(this.getLayerIndex(c)===this.getLayerIndex(s)){return 0;}else{return 1;}},isLayerFilteringRequired:function(){return!(this._sTopLayer===this._sMaxLayer);},_getComponentStartUpParameter:function(c,p){var s=null;if(p){if(c&&c.getComponentData){s=this._getStartUpParameter(c.getComponentData(),p);}}return s;},_getStartUpParameter:function(c,p){if(c&&c.startupParameters&&p){if(q.isArray(c.startupParameters[p])){return c.startupParameters[p][0];}}},getComponentName:function(c){var s="";if(c){s=c.getMetadata().getName();}if(s.length>0&&s.indexOf(".Component")<0){s+=".Component";}return s;},_getComponent:function(c){var o;if(c){o=sap.ui.getCore().getComponent(c);}return o;},_getComponentIdForControl:function(c){var s="",i=0;do{i++;s=U._getOwnerIdForControl(c);if(s){return s;}if(c&&typeof c.getParent==="function"){c=c.getParent();}else{return"";}}while(c&&i<100);return"";},getComponentForControl:function(c){return U._getComponentForControl(c);},getAppComponentForControl:function(c){var o;if(c instanceof sap.ui.core.Component){o=c;}else{o=this._getComponentForControl(c);}return this._getAppComponentForComponent(o);},_getComponentForControl:function(c){var o=null;var s=null;if(c){s=U._getComponentIdForControl(c);if(s){o=U._getComponent(s);}}return o;},_getAppComponentForComponent:function(c){var s=null;if(c&&c.getAppComponent){return c.getAppComponent();}if(c&&c.oComponentData&&c.oComponentData.appComponent){return c.oComponentData.appComponent;}if(c&&c.getManifestEntry){s=c.getManifestEntry("sap.app");}else{return c;}if(s&&s.type&&s.type!=="application"){if(c instanceof sap.ui.core.Component){c=this._getComponentForControl(c);}return this.getAppComponentForControl(c);}return c;},getViewForControl:function(c){return U.getFirstAncestorOfControlWithControlType(c,sap.ui.core.mvc.View);},getFirstAncestorOfControlWithControlType:function(c,a){if(c instanceof a){return c;}if(c&&typeof c.getParent==="function"){c=c.getParent();return U.getFirstAncestorOfControlWithControlType(c,a);}},hasControlAncestorWithId:function(c,a){var o;if(c===a){return true;}o=sap.ui.getCore().byId(c);while(o){if(o.getId()===a){return true;}if(typeof o.getParent==="function"){o=o.getParent();}else{return false;}}return false;},_isView:function(c){return c instanceof sap.ui.core.mvc.View;},_getOwnerIdForControl:function(c){return C.getOwnerIdFor(c);},getCurrentLayer:function(i){var u,a;if(i){return"USER";}u=this._getUriParameters();a=u.mParams["sap-ui-layer"];if(a&&a.length>0){return a[0];}return"CUSTOMER";},doesSharedVariantRequirePackage:function(){var c;c=U.getCurrentLayer(false);if((c==="VENDOR")||(c==="PARTNER")||(c==="CUSTOMER_BASE")){return true;}return false;},getClient:function(){var u,c;u=this._getUriParameters();c=u.mParams["sap-client"];if(c&&c.length>0){return c[0];}return undefined;},_getUriParameters:function(){return q.sap.getUriParameters();},isHotfixMode:function(){var u,i,I;u=this._getUriParameters();i=u.mParams["hotfix"];if(i&&i.length>0){I=i[0];}return(I==="true");},convertBrowserLanguageToISO639_1:function(b){if(!b||typeof b!=="string"){return"";}var n=b.indexOf("-");if((n<0)&&(b.length<=2)){return b.toUpperCase();}if(n>0&&n<=2){return b.substring(0,n).toUpperCase();}return"";},getCurrentLanguage:function(){var s=sap.ui.getCore().getConfiguration().getLanguage();return U.convertBrowserLanguageToISO639_1(s);},getControlType:function(c){var m;if(c&&typeof c.getMetadata==="function"){m=c.getMetadata();if(m&&typeof m.getElementName==="function"){return m.getElementName();}}},asciiToString:function(a){var b=a.split(",");var p="";q.each(b,function(i,c){p+=String.fromCharCode(c);});return p;},stringToAscii:function(s){var a="";for(var i=0;i<s.length;i++){a+=s.charCodeAt(i)+",";}a=a.substring(0,a.length-1);return a;},checkControlId:function(c,a,s){if(!a){c=c instanceof sap.ui.base.ManagedObject?c:sap.ui.getCore().byId(c);a=U.getAppComponentForControl(c);}return B.checkControlId(c,a,s);},hasLocalIdSuffix:B.hasLocalIdSuffix,_getAllUrlParameters:function(){return window.location.search.substring(1);},getTechnicalParametersForComponent:function(c){return c&&c.getComponentData&&c.getComponentData()&&c.getComponentData().technicalParameters;},getParsedURLHash:function(){var u=U.getUshellContainer();if(u){var o=u.getService("URLParsing");var p=o.parseShellHash(o.getHash(window.location.href));return p?p:{};}return{};},setTechnicalURLParameterValues:function(c,p,v){var P=U.getParsedURLHash(p);if(P.params){h.changed.active=false;var t=U.getTechnicalParametersForComponent(c);if(!t){this.log.error("Component instance not provided, so technical parameters in component data and browser history remain unchanged");}if(v.length===0){delete P.params[p];t&&delete t[p];}else{P.params[p]=v;t&&(t[p]=v);}h.replaceHash(U.getUshellContainer().getService("URLParsing").constructShellHash(P));h.changed.active=true;}},isDebugEnabled:function(){if(sap.ui.getCore().getConfiguration().getDebug()){return true;}var d=window["sap-ui-debug"]||"";var D=d.split(",");return D.indexOf("sap.ui.fl")!==-1;},getUrlParameter:function(p){return q.sap.getUriParameters().get(p);},getUshellContainer:function(){return sap.ushell&&sap.ushell.Container;},createDefaultFileName:function(n){var f=q.sap.uid().replace(/-/g,"_");if(n){f+='_'+n;}return f;},createNamespace:function(p,s){var r=p.reference.replace('.Component','');var n='apps/'+r+"/"+s+"/";return n;},buildLrepRootNamespace:function(b,s,p){var r="apps/";var e=new Error("Error in sap.ui.fl.Utils#buildLrepRootNamespace: ");if(!b){e.message+="for every scenario you need a base ID";throw e;}switch(s){case sap.ui.fl.Scenario.AppVariant:if(!p){e.message+="in an app variant scenario you additionaly need a project ID";throw e;}r+=b+"/appVariants/"+p+"/";break;case sap.ui.fl.Scenario.AdaptationProject:if(!p){e.message+="in a adaptation project scenario you additionaly need a project ID";throw e;}r+=b+"/adapt/"+p+"/";break;case sap.ui.fl.Scenario.FioriElementsFromScratch:case sap.ui.fl.Scenario.UiAdaptation:default:r+=b+"/";}return r;},isApplication:function(m){return(m&&m.getEntry("sap.app")&&m.getEntry("sap.app").type==="application");},getFlexReference:function(m){if(m){if(m.getEntry("sap.ui5")){if(m.getEntry("sap.ui5").appVariantId){return m.getEntry("sap.ui5").appVariantId;}if(m.getEntry("sap.ui5").componentName){return m.getEntry("sap.ui5").componentName+".Component";}}if(m.getEntry("sap.app")&&m.getEntry("sap.app").id){var a=m.getEntry("sap.app").id;if(a===U.APP_ID_AT_DESIGN_TIME&&m.getComponentName){a=m.getComponentName();}return a+".Component";}}this.log.warning("No Manifest received.");return"";},getAppVersionFromManifest:function(m){var v="";if(m){var s=(m.getEntry)?m.getEntry("sap.app"):m["sap.app"];if(s&&s.applicationVersion&&s.applicationVersion.version){v=s.applicationVersion.version;}}else{this.log.warning("No Manifest received.");}return v;},isCustomerDependentLayer:function(s){return(["CUSTOMER","CUSTOMER_BASE"].indexOf(s)>-1);},execPromiseQueueSequentially:function(p,t,a){if(p.length===0){if(a){return Promise.resolve();}return new U.FakePromise();}var P=p.shift();if(typeof P==="function"){var r=P();return r.then(function(){if(!a&&r instanceof Promise){a=true;}}).catch(function(e){var E="Error during execPromiseQueueSequentially processing occured";E+=e?": "+e.message:"";this.log.error(E);if(t){throw new Error(E);}}.bind(this)).then(function(){return this.execPromiseQueueSequentially(p,t,a);}.bind(this));}else{this.log.error("Changes could not be applied, promise not wrapped inside function.");return this.execPromiseQueueSequentially(p,t,a);}},FakePromise:function(i,e){this.vValue=i;this.vError=e;U.FakePromise.prototype.then=function(f){if(!this.vError){try{this.vValue=f(this.vValue,true);}catch(E){this.vError=E;this.vValue=null;return this;}if(this.vValue instanceof Promise){return this.vValue;}}return this;};U.FakePromise.prototype.catch=function(f){if(this.vError){this.vValue=f(this.vError,true);this.vError=null;if(this.vValue instanceof Promise){return this.vValue;}}return this;};if(this.vValue instanceof Promise){return this.vValue;}},getChangeFromChangesMap:function(c,s){var r;Object.keys(c).forEach(function(a){c[a].some(function(o){if(o.getId()===s){r=o;return true;}});});return r;}};return U;},true);
sap.ui.predefine('sap/ui/fl/Variant',["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/fl/Utils","sap/ui/fl/registry/Settings"],function(q,M,U,S){"use strict";
var V=M.extend("sap.ui.fl.Variant",{
constructor:function(f){M.apply(this);if(!q.isPlainObject(f)){U.log.error("Constructor : sap.ui.fl.Variant : oFile is not defined");}this._oDefinition=f;this._oOriginDefinition=q.extend(true,{},f);this._sRequest='';this._bUserDependent=(f.content.layer==="USER");this._vRevertData=null;this.setState(V.states.NEW);},
metadata:{properties:{state:{type:"string"}}}
});
V.states={NEW:"NEW",PERSISTED:"NONE",DELETED:"DELETE",DIRTY:"UPDATE"};V.events={markForDeletion:"markForDeletion"};
V.prototype.setState=function(s){if(this._isValidState(s)){this.setProperty("state",s);}return this;};
V.prototype._isValidState=function(s){var b=false;Object.keys(V.states).some(function(k){if(V.states[k]===s){b=true;}return b;});if(!b){return false;}if((this.getState()===V.states.NEW)&&(s===V.states.DIRTY)){return false;}return true;};
V.prototype.isValid=function(){var i=true;if(typeof(this._oDefinition)!=="object"){i=false;}if(!this._oDefinition.content.fileType||this._oDefinition.content.fileType!=="ctrl_variant"){i=false;}if(!this._oDefinition.content.fileName){i=false;}if(!this._oDefinition.content.content.title){i=false;}if(!this._oDefinition.content.variantManagementReference){i=false;}if(!this._oDefinition.content.layer){i=false;}if(!this._oDefinition.content.originalLanguage){i=false;}return i;};
V.prototype.isVariant=function(){return true;};
V.prototype.getDefinitionWithChanges=function(){return this._oDefinition;};
V.prototype.getTitle=function(){if(this._oDefinition){return this._oDefinition.content.content.title;}};
V.prototype.getFileType=function(){if(this._oDefinition){return this._oDefinition.content.fileType;}};
V.prototype.getControlChanges=function(){return this._oDefinition.controlChanges;};
V.prototype.getOriginalLanguage=function(){if(this._oDefinition&&this._oDefinition.content.originalLanguage){return this._oDefinition.content.originalLanguage;}return"";};
V.prototype.getPackage=function(){return this._oDefinition.content.packageName;};
V.prototype.getNamespace=function(){return this._oDefinition.content.namespace;};
V.prototype.setNamespace=function(n){this._oDefinition.content.namespace=n;};
V.prototype.getId=function(){return this._oDefinition.content.fileName;};
V.prototype.getContent=function(){return this._oDefinition.content.content;};
V.prototype.setContent=function(c){this._oDefinition.content.content=c;this.setState(V.states.DIRTY);};
V.prototype.getVariantManagementReference=function(){return this._oDefinition.content.variantManagementReference;};
V.prototype.getVariantReference=function(){return this._oDefinition.content.variantReference;};
V.prototype.getOwnerId=function(){return this._oDefinition.content.support?this._oDefinition.content.support.user:"";};
V.prototype.getText=function(t){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Variant.getTexts : sTextId is not defined");}if(this._oDefinition.content.texts){if(this._oDefinition.content.texts[t]){return this._oDefinition.content.texts[t].value;}}return"";};
V.prototype.setText=function(t,n){if(typeof(t)!=="string"){U.log.error("sap.ui.fl.Variant.setTexts : sTextId is not defined");return;}if(this._oDefinition.content.texts){if(this._oDefinition.content.texts[t]){this._oDefinition.content.texts[t].value=n;this.setState(V.states.DIRTY);}}};
V.prototype.isReadOnly=function(){return this._isReadOnlyDueToLayer()||this._isReadOnlyWhenNotKeyUser();};
V.prototype._isReadOnlyWhenNotKeyUser=function(){if(this.isUserDependent()){return false;}var r=this.getDefinition().reference;if(!r){return true;}var s=S.getInstanceOrUndef();if(!s){return true;}return!s.isKeyUser();};
V.prototype._isReadOnlyDueToLayer=function(){var c;c=U.getCurrentLayer(this._bUserDependent);return(this._oDefinition.content.layer!==c);};
V.prototype._isReadOnlyDueToOriginalLanguage=function(){var c,o;o=this.getOriginalLanguage();if(!o){return false;}c=U.getCurrentLanguage();return(c!==o);};
V.prototype.markForDeletion=function(){this.setState(V.states.DELETED);};
V.prototype.setRequest=function(r){if(typeof(r)!=="string"){U.log.error("sap.ui.fl.Variant.setRequest : sRequest is not defined");}this._sRequest=r;};
V.prototype.getRequest=function(){return this._sRequest;};
V.prototype.getLayer=function(){return this._oDefinition.content.layer;};
V.prototype.getComponent=function(){return this._oDefinition.content.reference;};
V.prototype.setComponent=function(c){this._oDefinition.content.reference=c;};
V.prototype.getCreation=function(){return this._oDefinition.content.creation;};
V.prototype.isUserDependent=function(){return(this._bUserDependent);};
V.prototype.getPendingAction=function(){return this.getState();};
V.prototype.getDefinition=function(){return this._oDefinition.content;};
V.prototype.setResponse=function(r){var R=JSON.stringify(r);if(R){this._oDefinition=JSON.parse(R);this._oOriginDefinition=JSON.parse(R);this.setState(V.states.PERSISTED);}};
V.prototype.getFullFileIdentifier=function(){var l=this.getLayer();var n=this.getNamespace();var f=this.getDefinition().content.fileName;var F=this.getDefinition().content.fileType;return l+"/"+n+"/"+f+"."+F;};
V.prototype.getRevertData=function(){return this._vRevertData;};
V.prototype.setRevertData=function(d){this._vRevertData=d;};
V.prototype.resetRevertData=function(){this.setRevertData(null);};
V.createInitialFileContent=function(p){if(!p){p={};}var f=p.content.fileName||U.createDefaultFileName();var n=p.content.namespace||U.createNamespace(p.content,"variants");var N={content:{fileName:f,fileType:"ctrl_variant",variantManagementReference:p.content.variantManagementReference,variantReference:p.content.variantReference||"",reference:p.content.reference||"",packageName:p.content.packageName||"",content:{title:p.content.content.title||""},self:n+f+"."+"ctrl_variant",layer:p.content.layer||U.getCurrentLayer(p.isUserDependent),texts:p.content.texts||{},namespace:n,creation:"",originalLanguage:U.getCurrentLanguage(),conditions:{},support:{generator:p.generator||"Change.createInitialFileContent",service:p.service||"",user:"",sapui5Version:sap.ui.version},validAppVersions:p.content.validAppVersions||{}},controlChanges:p.controlChanges||[],variantChanges:{}};return N;};
return V;},true);
sap.ui.predefine('sap/ui/fl/XmlPreprocessorImpl',["jquery.sap.global","sap/ui/core/Component","sap/ui/fl/FlexControllerFactory","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/ChangePersistence"],function(q,C,F,U,L,a,b){"use strict";var X=function(){};
X.process=function(v,p){try{if(!p||p.sync){q.sap.log.warning("Flexibility feature for applying changes on an XML view is only available for "+"asynchronous views; merge is be done later on the JS controls.");return(v);}p.viewId=p.id;var c=sap.ui.getCore().getComponent(p.componentId);if(!c){U.log.warning("View is generated without a component. Flexibility features are not possible.");return Promise.resolve(v);}var A=U.getAppComponentForControl(c);var f=U.getComponentClassName(A);var s=U.getAppVersionFromManifest(A.getManifest());var o=a.getChangePersistenceForComponent(f,s);return o.getCacheKey().then(function(d){if(!d||d===b.NOTAG){U.log.warning("No cache key could be determined for the view; flexibility XML view preprocessing is skipped. "+"The processing will be done later on the JS controls.");return Promise.resolve(v);}var g=F.create(f,s);return g.processXmlView(v,p).then(function(){U.log.debug("flex processing view "+p.id+" finished");return v;});},function(){U.log.warning("Error happens when getting flex cache key! flexibility XML view preprocessing is skipped. "+"The processing will be done later on the JS controls.");return Promise.resolve(v);});}catch(e){var E="view "+p.id+": "+e;q.sap.log.info(E);return Promise.resolve(v);}};
X.getCacheKey=function(p){var c=sap.ui.getCore().getComponent(p.componentId);var A=U.getAppComponentForControl(c);if(U.isVariantByStartupParameter(A)){return Promise.resolve();}var f=U.getComponentClassName(A);var s=U.getAppVersionFromManifest(A.getManifest());var o=a.getChangePersistenceForComponent(f,s);return o.getCacheKey();};
return X;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/AddXML',["jquery.sap.global","sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(q,B,U){"use strict";var A={};var d=function(c){c.forEach(function(C){if(C.destroy){C.destroy();}});};
A.applyChange=function(c,C,p){var m=p.modifier;var o=c.getDefinition();var a=o.content.targetAggregation;if(!o.content.fragment){throw new Error("The content of the fragment is not set. This should happen in the backend");}var f=U.asciiToString(o.content.fragment);var i=o.content.index;var v=p.view;var n=c.getProjectId();var N;try{N=m.instantiateFragment(f,n,v);}catch(e){throw new Error("The following XML Fragment could not be instantiated: "+f+" Reason: "+e.message);}var b=m.findAggregation(C,a);if(!b){d(N);throw new Error("The given Aggregation is not available in the given control: "+m.getId(C));}N.forEach(function(g,I){if(!m.validateType(g,b,C,f,I)){d(N);throw new Error("The content of the xml fragment does not match the type of the targetAggregation: "+b.type);}});N.forEach(function(g,I){m.insertAggregation(C,a,g,i+I,v);});c.setRevertData(N.map(function(g){return m.getId(g);}));return true;};
A.revertChange=function(c,C,p){var m=p.modifier;var o=c.getDefinition();var a=o.content.targetAggregation;var v=p.view||U.getViewForControl(C);var b=p.appComponent;var r=c.getRevertData()||[];var e=r.map(function(i){return m.bySelector(i,b,v)||v&&v.createId&&m.bySelector(v.createId(i));});e.forEach(function(f){m.removeAggregation(C,a,f);});d(e);c.resetRevertData();return true;};
A.completeChangeContent=function(c,s){var C=c.getDefinition();var _=function(a){throw new Error("Attribute missing from the change specific content'"+a+"'");};if(!C.content){C.content={};}if(s.fragmentPath){C.content.fragmentPath=s.fragmentPath;}else{_("fragmentPath");}if(s.targetAggregation){C.content.targetAggregation=s.targetAggregation;}else{_("targetAggregation");}if(s.index!==undefined){C.content.index=s.index;}else{_("index");}};
return A;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/Base',function(){"use strict";var B={};
B.setTextInChange=function(c,k,t,T){if(!c.texts){c.texts={};}if(!c.texts[k]){c.texts[k]={};}c.texts[k].value=t;c.texts[k].type=T;};
return B;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseRename',["sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(B,U){"use strict";var a={createRenameChangeHandler:function(r){r.changePropertyName=r.changePropertyName||"newText";return{applyChange:function(c,C,p){var m=p.modifier;var P=r.propertyName;var o=c.getDefinition();var t=o.texts[r.changePropertyName];var v=t.value;if(o.texts&&t&&typeof(v)==="string"){c.setRevertData(m.getProperty(C,P));if(U.isBinding(v)){m.setPropertyBinding(C,P,v);}else{m.setProperty(C,P,v);}return true;}else{U.log.error("Change does not contain sufficient information to be applied: ["+o.layer+"]"+o.namespace+"/"+o.fileName+"."+o.fileType);}},revertChange:function(c,C,p){var o=c.getRevertData();if(o||o===""){var m=p.modifier;var P=r.propertyName;m.setProperty(C,P,o);c.resetRevertData();return true;}else{U.log.error("Change doesn't contain sufficient information to be reverted. Most Likely the Change didn't go through applyChange.");}},completeChangeContent:function(c,s,p){var C=c.getDefinition();var b=r.changePropertyName;var t=r.translationTextType;var o=p.modifier.bySelector(c.getSelector(),p.appComponent);C.content.originalControlType=p.modifier.getControlType(o);if(typeof(s.value)==="string"){B.setTextInChange(C,b,s.value,t);}else{throw new Error("oSpecificChangeInfo.value attribute required");}}};}};return a;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/BaseTreeModifier',["sap/ui/core/util/reflection/BaseTreeModifier"],function(B){"use strict";return B;});
sap.ui.predefine('sap/ui/fl/changeHandler/ChangeHandlerMediator',["jquery.sap.global"],function(q){"use strict";var C={};C._aChangeHandlerSettings=[];["addODataField","addODataFieldWithLabel"].forEach(function(s){["2.0","1.0"].forEach(function(v){C._aChangeHandlerSettings.push({key:{"scenario":s,"oDataServiceVersion":v},content:{"requiredLibraries":{"sap.ui.comp":{"minVersion":"1.48","lazy":false}}},scenarioInitialized:false});});});
C.addChangeHandlerSettings=function(k,s){var n;if(!(k&&s)){throw new Error('New entry in ChangeHandlerMediator requires a key and settings');}n={key:k,content:s,scenarioInitialized:false};var e=this.getChangeHandlerSettings(k,true);var i=this._aChangeHandlerSettings.indexOf(e);if(i>-1){q.extend(this._aChangeHandlerSettings[i].content,n.content);this._aChangeHandlerSettings[i].scenarioInitialized=false;}else{this._aChangeHandlerSettings.push(n);this._createChangeHandlerSettingsGetter(n);}};
C.getChangeHandlerSettings=function(k,s){var K=Object.keys(k);var f;if(K.length>0){f=this._aChangeHandlerSettings.filter(function(e,i){var E=Object.keys(e.key);if(E.length===K.length){var m=K.filter(function(a){if(e.key[a]===k[a]){return true;}});if(m.length===K.length){return true;}}})[0];if(!s&&f&&!f.scenarioInitialized){f.scenarioInitialized=this._initializeScenario(f);}}if(s||(f&&f.scenarioInitialized)){return f;}};
C._initializeScenario=function(f){var l;if(f.content.requiredLibraries){try{var L=Object.keys(f.content.requiredLibraries);L.forEach(function(s){l=s;sap.ui.getCore().loadLibrary(s);});var i=this._aChangeHandlerSettings.indexOf(f);this._aChangeHandlerSettings[i].scenarioInitialized=true;return true;}catch(e){q.sap.log.warning("Required library not available: "+l+" - "+f.key.scenario+" could not be initialized");return false;}}};
C._createChangeHandlerSettingsGetter=function(c){var g='get'+q.sap.charToUpperCase(c.key.scenario)+'Settings';if(!C[g]){C[g]=function(o){var O;var f;try{O=o.getModel().getMetaModel().getProperty("/dataServices/dataServiceVersion");}catch(e){q.sap.log.warning("Data service version could not be retrieved");}f=this.getChangeHandlerSettings({"scenario":c.key.scenario,"oDataServiceVersion":O});if(f&&f.content&&f.content.createFunction){return f;}};}};
C._aChangeHandlerSettings.forEach(function(c){C._createChangeHandlerSettingsGetter(c);});return C;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/HideControl',["jquery.sap.global"],function(q){"use strict";var H={};
H.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getVisible(C)});p.modifier.setVisible(C,false);return true;};
H.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setVisible(C,r.originalValue);c.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
H.completeChangeContent=function(c,s){};
return H;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/JsControlTreeModifier',["sap/ui/core/util/reflection/JsControlTreeModifier"],function(J){"use strict";return J;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveControls',["jquery.sap.global","./Base","sap/ui/fl/Utils"],function(q,B,F){"use strict";var M={};M.SOURCE_ALIAS="source";M.TARGET_ALIAS="target";M.MOVED_ELEMENTS_ALIAS="movedElements";
M._checkConditions=function(c,m,v,a){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!C.source||!C.source.selector){throw new Error("No source supplied for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.source.selector,a,v)){throw new Error("Move source parent not found");}if(!m.bySelector(C.target.selector,a,v)){throw new Error("Move target parent not found");}if(!C.source.selector.aggregation){throw new Error("No source aggregation supplied for move");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}};
M._getElementControlOrThrowError=function(m,o,a,v){if(!m.selector&&!m.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof m.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+m.selector.id+"' in movedElements supplied");}var c=o.bySelector(m.selector||m.id,a,v);if(!c){throw new Error("Control to move was not found. Id: '"+m.selector.id+"'");}return c;};
M._checkCompleteChangeContentConditions=function(s){if(!s.movedElements){throw new Error("mSpecificChangeInfo.movedElements attribute required");}if(s.movedElements.length===0){throw new Error("MovedElements array is empty");}s.movedElements.forEach(function(e){if(!e.id){throw new Error("MovedControls element has no id attribute");}if(typeof(e.sourceIndex)!=="number"){throw new Error("SourceIndex attribute at MovedElements element is no number");}if(typeof(e.targetIndex)!=="number"){throw new Error("TargetIndex attribute at MovedElements element is no number");}});};
M._getSpecificChangeInfo=function(m,s,a){delete s.source.publicAggregation;delete s.target.publicAggregation;var S=s.source.parent||m.bySelector(s.source.id,a);var t=s.target.parent||m.bySelector(s.target.id,a);var b=s.source.aggregation;var T=s.target.aggregation;var A={aggregation:s.source.aggregation,type:m.getControlType(S)};var c={aggregation:s.target.aggregation,type:m.getControlType(t)};var d={source:{id:S.getId(),aggregation:b,type:A.type,selector:m.getSelector(s.source.id,a,A)},target:{id:t.getId(),aggregation:T,type:c.type,selector:m.getSelector(s.target.id,a,c)},movedElements:s.movedElements};return d;};
M.applyChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=p.sourceAggregation||C.source.selector.aggregation;var t=m.bySelector(C.target.selector,a,v);var T=p.targetAggregation||C.target.selector.aggregation;var R=[];C.movedElements.forEach(function(b,e){var o=this._getElementControlOrThrowError(b,m,a,v);var S=m.getParent(o);var i=b.targetIndex;var I=m.findIndexInParentAggregation(o);if(I>-1){s=p.sourceAggregation||m.getParentAggregationName(o,S);if(I===i){I=b.sourceIndex;}R.unshift({index:I,aggregation:s,sourceParent:S});}m.removeAggregation(S,s,o);m.insertAggregation(t,T,o,i,v);},this);c.setRevertData(R);return true;};
M.revertChange=function(c,r,p){var m=p.modifier;var v=p.view;var a=p.appComponent;this._checkConditions(c,m,v,a);var C=c.getContent();var s=m.bySelector(C.source.selector,a,v);var S=C.source.selector.aggregation;var t=m.bySelector(C.target.selector,a,v);var T=C.target.selector.aggregation;var R=c.getRevertData();c.getContent().movedElements.reverse();C.movedElements.forEach(function(b,e){var o=this._getElementControlOrThrowError(b,m,a,v);if(!o){F.log.warning("Element to move not found");return;}var i=b.sourceIndex;if(R){s=R[e].sourceParent;S=R[e].aggregation;i=R[e].index;}m.removeAggregation(t,T,o);m.insertAggregation(s,S,o,i,v);},this);c.resetRevertData();return true;};
M.completeChangeContent=function(c,s,p){this._checkCompleteChangeContentConditions(s);var m=p.modifier;var a=p.appComponent;var C=c.getDefinition();s=this._getSpecificChangeInfo(m,s,a);C.content={movedElements:[],source:{selector:s.source.selector},target:{selector:s.target.selector}};s.movedElements.forEach(function(e){var E=e.element||m.bySelector(e.id,a);C.content.movedElements.push({selector:m.getSelector(E,a),sourceIndex:e.sourceIndex,targetIndex:e.targetIndex});});c.addDependentControl(s.source.id,M.SOURCE_ALIAS,p);c.addDependentControl(s.target.id,M.TARGET_ALIAS,p);c.addDependentControl(s.movedElements.map(function(e){return e.id;}),M.MOVED_ELEMENTS_ALIAS,p);};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/MoveElements',["jquery.sap.global","sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(q,B,F){"use strict";var M={};M.CHANGE_TYPE="moveElements";
M.applyChange=function(c,s,p){function a(c,m,v,A){if(!c){throw new Error("No change instance");}var C=c.getContent();if(!C||!C.movedElements||C.movedElements.length===0){throw new Error("Change format invalid");}if(!c.getSelector().aggregation){throw new Error("No source aggregation supplied via selector for move");}if(!C.target||!C.target.selector){throw new Error("No target supplied for move");}if(!m.bySelector(C.target.selector,A,v)){throw new Error("Move target parent not found");}if(!C.target.selector.aggregation){throw new Error("No target aggregation supplied for move");}}function g(b,m,A,v){if(!b.selector&&!b.id){throw new Error("Change format invalid - moveElements element has no id attribute");}if(typeof b.targetIndex!=="number"){throw new Error("Missing targetIndex for element with id '"+b.selector.id+"' in movedElements supplied");}return m.bySelector(b.selector||b.id,A,v);}var m=p.modifier;var v=p.view;var A=p.appComponent;a(c,m,v,A);var C=c.getContent();var t=m.bySelector(C.target.selector,A,v);var S=c.getSelector().aggregation;var T=C.target.selector.aggregation;C.movedElements.forEach(function(b){var o=g(b,m,A,v);if(!o){F.log.warning("Element to move not found");return;}m.removeAggregation(s,S,o);m.insertAggregation(t,T,o,b.targetIndex,v);});return true;};
M.completeChangeContent=function(){throw new Error('Using deprecated change handler. Please consider of using \'MoveControls\' instead');};
M.getSpecificChangeInfo=function(m,s){var S=s.source.parent||m.bySelector(s.source.id);var t=s.target.parent||m.bySelector(s.target.id);var a=s.source.aggregation;var T=s.target.aggregation;var b={source:{id:S.getId(),aggregation:a,type:m.getControlType(S)},target:{id:t.getId(),aggregation:T,type:m.getControlType(t)},movedElements:s.movedElements};return b;};
return M;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyBindingChange',["jquery.sap.global"],function(q){"use strict";var P={};
P.applyChange=function(c,C,p){var d=c.getDefinition();var s=d.content.property;var v=d.content.newBinding;var m=p.modifier;c.setRevertData({originalValue:m.getPropertyBinding(C,s)});m.setPropertyBinding(C,s,v);};
P.revertChange=function(c,C,p){var r=c.getRevertData();if(r){var d=c.getDefinition();var s=d.content.property;var v=r.originalValue;var m=p.modifier;m.setPropertyBinding(C,s,v);c.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
P.completeChangeContent=function(c,s){var C=c.getDefinition();if(s.content){C.content=s.content;}else{throw new Error("oSpecificChangeInfo attribute required");}};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/PropertyChange',["jquery.sap.global","sap/ui/fl/changeHandler/Base","sap/ui/fl/Utils"],function(q,B,F){"use strict";var P={};
function c(C,p,v,m){try{if(F.isBinding(v)||q.isPlainObject(v)){m.setPropertyBinding(C,p,v);}else{m.setProperty(C,p,v);}}catch(e){throw new Error("Applying property changes failed: "+e);}}
P.applyChange=function(C,o,p){var d=C.getDefinition();var s=d.content.property;var v=d.content.newValue;var m=p.modifier;C.setRevertData({originalValue:m.getPropertyBinding(o,s)||m.getProperty(o,s)});c(o,s,v,m);};
P.revertChange=function(C,o,p){var r=C.getRevertData();if(r){var d=C.getDefinition();var s=d.content.property;var v=r.originalValue;var m=p.modifier;c(o,s,v,m);C.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
P.completeChangeContent=function(C,s){var o=C.getDefinition();if(s.content){o.content=s.content;}else{throw new Error("oSpecificChangeInfo attribute required");}};
return P;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/StashControl',["jquery.sap.global"],function(q){"use strict";var S={};
S.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getStashed(C)});p.modifier.setStashed(C,true);return true;};
S.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setStashed(C,r.originalValue);c.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
S.completeChangeContent=function(c,s){};
return S;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnhideControl',["jquery.sap.global"],function(q){"use strict";var U={};
U.applyChange=function(c,C,p){c.setRevertData({originalValue:p.modifier.getProperty(C,'visible')});p.modifier.setVisible(C,true);return true;};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setVisible(C,r.originalValue);c.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
U.completeChangeContent=function(c,s){};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/UnstashControl',["jquery.sap.global"],function(q){"use strict";var U={};
U.applyChange=function(c,C,p){var m=c.getContent();var M=p.modifier;c.setRevertData({originalValue:p.modifier.getStashed(C)});M.setStashed(C,false);if(p.modifier.targets==="jsControlTree"){C=p.modifier.bySelector(p.modifier.getSelector(C,p.appComponent),p.appComponent);}if(m.parentAggregationName){var t=m.parentAggregationName;var T=M.getParent(C);M.removeAggregation(T,t,C);M.insertAggregation(T,t,C,m.index,p.view);}return C;};
U.revertChange=function(c,C,p){var r=c.getRevertData();if(r){p.modifier.setStashed(C,r.originalValue);c.resetRevertData();}else{q.sap.log.error("Attempt to revert an unapplied change.");return false;}return true;};
U.completeChangeContent=function(c,s){var C=c.getDefinition();if(s.content){C.content=s.content;}};
return U;},true);
sap.ui.predefine('sap/ui/fl/changeHandler/XmlTreeModifier',["sap/ui/core/util/reflection/XmlTreeModifier"],function(X){"use strict";return X;},true);
sap.ui.predefine('sap/ui/fl/codeExt/CodeExtManager',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/Change"],function(L,U,C){"use strict";var a;a={_oLrepConnector:L.createConnector(),createOrUpdateCodeExtChange:function(p,o){if(!p.content||!p.content.codeRef){throw new Error("no code reference passed for the code extension change");}if(!p.selector||!p.selector.id){throw new Error("no controller name passed for the code extension change");}if(!p.reference){throw new Error("no reference passed for the code extension change");}p.changeType=p.changeType||"codeExt";var c=C.createInitialFileContent(p);var u="/sap/bc/lrep/content/"+c.namespace+c.fileName+".change";u+="?layer="+c.layer;if(o){if(o.transportId){u+="&changelist="+o.transportId;}if(o.packageName){u+="&package="+o.packageName;}}var m="PUT";return this._oLrepConnector.send(u,m,c,{});},createCodeExtChanges:function(c,o){c=c||[];if(c.length===0){return Promise.resolve();}var p=[];c.forEach(function(b){b.changeType=b.changeType||"codeExt";b.packageName=o.packageName;b.content={codeRef:o.codeRef};p.push(C.createInitialFileContent(b));});return this._oLrepConnector.create(p,o.transportId);},deleteCodeExtChange:function(c,o){if(c.changeType!=="codeExt"||c.fileType!=="change"){throw new Error("the change is not of type 'code extension'");}if(!c.fileName){throw new Error("the extension does not contains a file name");}if(c.namespace===undefined){throw new Error("the extension does not contains a namespace");}var u="/sap/bc/lrep/content/"+c.namespace+c.fileName+".change";if(c.layer){u+="&layer="+c.layer;}if(o){if(o.transportId){u+="&changelist="+o.transportId;}if(o.packageName){u+="&package="+o.packageName;}}u=u.replace("&","?");var m="DELETE";return this._oLrepConnector.send(u,m,c,{});}};return a;},true);
sap.ui.predefine('sap/ui/fl/context/BaseContextProvider',['sap/ui/base/ManagedObject'],function(M){"use strict";
var B=M.extend("sap.ui.fl.context.BaseContextProvider",{metadata:{properties:{text:{type:"String"},description:{type:"String"}}}});
B.prototype.loadData=function(){return Promise.resolve({});};
B.prototype.getValue=function(r){return this.loadData().then(function(d){var R=r&&r.split(".")||[];var m=R.reduce(function(c,C){if(c&&c.hasOwnProperty(C)){return c[C];}return undefined;},d);return m;});};
B.prototype.getValueHelp=function(r){return Promise.resolve({});};
B.prototype.validate=function(k,v){return Promise.resolve(true);};
return B;},true);
sap.ui.predefine('sap/ui/fl/context/Context',['sap/ui/base/ManagedObject'],function(M){"use strict";
var C=M.extend("sap.ui.fl.context.Context",{metadata:{library:"sap.ui.fl",properties:{configuration:{type:"object"},content:{type:"object"}},aggregations:{contextProviders:{type:"object",multiple:true}},events:{}}});
C.prototype.getValue=function(R){return this._getProviderContent(R,"getValue");};
C.prototype.getValueHelp=function(R){return this._getProviderContent(R,"getValueHelp");};
var r=function(d,R){if(d.indexOf(R)!==-1){return undefined;}if(R.indexOf(d+".")!==-1){return R.substring(d.length+1);}throw new Error("Invalid request for sap.ui.fl.context - domain:"+d+"request:"+R);};
C.prototype._getProviderContent=function(R,p){var t=this;var P=[];var a=[];var h=function(s){var A=t._assureDomain(s);if(A){var o=t._loadProvider(A);P.push(o);a.push({domain:A,request:r(A,s)});}else{a.push({domain:undefined,request:s});}};var m=function(D){var c=t.getConfiguration();var b=false;for(var i=0;i<D.length;i++){var o=D[i];if(o){c[o.domain]=o.provider;b=true;}}if(b){t.setConfiguration(c);}};if(R instanceof Array){R.forEach(function(s){h(s);});}else if(R===undefined){for(var d in this.getConfiguration()){P.push(this._loadProvider(d));}a=Object.keys(this.getConfiguration()).map(function(d){return{domain:d,request:undefined};});}return Promise.all(P).then(m).then(function(){return t._mergeProviderContent(a,p,R);});};
C.prototype._assureDomain=function(d){var c=this.getConfiguration();if(c.hasOwnProperty(d)){return d;}else{var k=Object.keys(c);for(var i=0;i<k.length;i++){var K=k[i];if(d.indexOf(K)===0||K.indexOf(d)===0){return K;}}}return null;};
C.prototype._loadProvider=function(d,c){var a=this.getConfiguration()[d];if(typeof(a)==="string"){return new Promise(function(b,e){try{sap.ui.require([a],function(P){var p=new P();b({"domain":d,"provider":p});});}catch(E){jQuery.sap.log.error(E);b();return;}});}else{return Promise.resolve();}};
C.prototype._mergeProviderContent=function(R,p,a){var P=[];var c=this.getConfiguration();R.forEach(function(o){if(c.hasOwnProperty(o.domain)){var A=c[o.domain];if(A instanceof sap.ui.fl.context.BaseContextProvider){P.push(A[p].call(A,o.request).then(function(v){var s={};var b=o.domain;if(o.request){b=b+"."+o.request;}s[b]=v;return s;}));}}else{var s={};s[o.request]=undefined;P.push(Promise.resolve(s));}});return Promise.all(P).then(function(b){return b.reduce(function(m,d){var k=Object.keys(d)[0];m[k]=d[k];return m;},{});});};
return C;},true);
sap.ui.predefine('sap/ui/fl/context/ContextManager',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils","sap/ui/fl/context/Context"],function(L,U,C){"use strict";var a;a={_oContext:new C({configuration:{"device":"sap/ui/fl/context/DeviceContextProvider","switches":"sap/ui/fl/context/SwitchContextProvider"}}),_oLrepConnector:L.createConnector(),doesContextMatch:function(c,A){var s=c.context||"";if(!s){return true;}return jQuery.inArray(s,A)!==-1;},getActiveContexts:function(c){var d=this._getContextIdsFromUrl();if(d.length===0){return this._getContextParametersFromAPI(c).then(this._getActiveContextsByAPIParameters.bind(this,c));}else{return Promise.resolve(this._getActiveContextsByUrlParameters(c,d));}},_getContextParametersFromAPI:function(c){var r=[];c.forEach(function(o){o.parameters.forEach(function(b){var s=b.selector;if(r.indexOf(s)===-1){r.push(s);}});});return this._oContext.getValue(r);},_getActiveContextsByAPIParameters:function(c,r){var t=this;var A=[];c.forEach(function(o){if(t._isContextObjectActive(o,r)){A.push(o.id);}});return A;},_getActiveContextsByUrlParameters:function(c,d){var A=[];c.forEach(function(o){var b=jQuery.inArray(o.id,d)!==-1;if(b){A.push(o.id);}});return A;},_isContextObjectActive:function(c,r){var t=this;var b=true;var p=c.parameters;p.every(function(P){b=b&&t._checkContextParameter(P,r);return b;});return b;},_getContextIdsFromUrl:function(){var c=U.getUrlParameter("sap-ui-flexDesignTimeContext");if(!c){return[];}return c.split(",");},_checkContextParameter:function(p,r){var s=p.selector;var o=p.operator;var v=p.value;switch(o){case"EQ":return this._checkEquals(s,v,r);case"NE":return!this._checkEquals(s,v,r);default:jQuery.sap.log.info("A context within a flexibility change with the operator '"+o+"' could not be verified");return false;}},_checkEquals:function(s,v,r){return r[s]===v;},createOrUpdateContextObject:function(p){if(!p.reference){throw new Error("no reference passed for the context object");}if(!p.namespace){throw new Error("no namespace passed for the context object");}var i=p.id||U.createDefaultFileName();p={id:i,fileName:i,title:p.title||"",description:p.description||"",parameters:p.parameters||[],fileType:"context",reference:p.reference||"",packageName:p.packageName||"",layer:p.layer||U.getCurrentLayer(false),namespace:p.namespace,creation:p.creation||"",originalLanguage:p.originalLanguage||U.getCurrentLanguage(),support:p.support||{generator:p.generator||"",service:"",user:""},validAppVersions:p.validAppVersions||{}};var u="/sap/bc/lrep/content/"+p.namespace+p.fileName+".context";u+="?layer="+p.layer;var m="PUT";return this._oLrepConnector.send(u,m,p,{});}};return a;},true);
sap.ui.predefine('sap/ui/fl/context/DeviceContextProvider',["sap/ui/fl/context/BaseContextProvider","sap/ui/Device"],function(B,D){"use strict";
var a=B.extend("sap.ui.fl.context.DeviceContextProvider",{metadata:{properties:{text:{type:"String",defaultValue:"Device"},description:{type:"String",defaultValue:"Returns the values of sap.ui.Device"}}}});
a.prototype.loadData=function(){return Promise.resolve(D);};
a.prototype.getValueHelp=function(){return Promise.resolve({});};
a.prototype.validate=function(k,v){return Promise.resolve(true);};
return a;},true);
sap.ui.predefine('sap/ui/fl/context/SwitchContextProvider',["sap/ui/fl/context/BaseContextProvider","sap/ui/fl/Cache"],function(B,C){"use strict";
var S=B.extend("sap.ui.fl.context.SwitchContextProvider",{metadata:{properties:{text:{type:"String",defaultValue:"Switch"},description:{type:"String",defaultValue:"Returns the values of switches recieved in the flexibility response from the back end"}}}});
S.prototype.loadData=function(){return Promise.resolve(C.getSwitches());};
S.prototype.getValueHelp=function(){return Promise.resolve({});};
S.prototype.validate=function(k,v){return Promise.resolve(true);};
return S;},true);
sap.ui.predefine('sap/ui/fl/core/EventDelegate',["jquery.sap.global","sap/ui/fl/Utils","sap/ui/base/EventProvider","sap/ui/fl/registry/ChangeRegistry","sap/ui/fl/core/FlexVisualizer"],function(q,U,E,C,F){"use strict";var a=function(c,s){if(!c){U.log.error("sap.ui.fl.core.EventDelegate: Control required");}if(!s){U.log.error("sap.ui.fl.core.EventDelegate: Supported registry items required");}E.apply(this);this._oControl=c;this._oSupportedRegistryItems=s;};a.prototype=q.sap.newObject(E.prototype);
a.registerControl=function(c){if(c){var i=0;if(c.aDelegates){for(i=0;i<c.aDelegates.length;i++){var t="";if(c.aDelegates[i].oDelegate&&c.aDelegates[i].oDelegate.getType){t=(c.aDelegates[i].oDelegate.getType());}if(t==="Flexibility"){return;}}}a.registerExplicitChanges(c);}};
a.registerExplicitChanges=function(c){var r=C.getInstance();var p={controlType:U.getControlType(c)};var s=r.getRegistryItems(p);if(Object.keys(s).length>0){c.addEventDelegate(new a(c,s));}};
a.unregisterControl=function(){};
a.prototype.onmouseover=function(e){e.stopPropagation();if(e.handled){return;}else{e.handled=true;}if(F.isPersonalizationMode()){if(this._oControl&&!q(this._oControl.getDomRef()).hasClass("sapuiflex-highlight")){F.showDialog(this._oControl);}}};
a.prototype.onmouseout=function(e){if(F.isPersonalizationMode()){if(this._oControl){F.closeDialog();}}};
return a;},true);
sap.ui.predefine('sap/ui/fl/core/FlexVisualizer',["jquery.sap.global"],function(q){"use strict";var F=function(){};
F.showDialog=function(a,i){};
F.closeDialog=function(){};
return F;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorChangeFactory',["sap/ui/fl/ChangePersistenceFactory","sap/ui/fl/ChangePersistence","sap/ui/fl/Change","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/registry/Settings","sap/ui/fl/Utils"],function(C,a,b,U,S,F){"use strict";var D=function(m,i,s){this._mChangeFile=m;this._mChangeFile.packageName='$TMP';this._oInlineChange=i;this._sTransportRequest=null;this._oSettings=s;};
D.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._sTransportRequest=t;return Promise.resolve();};
D.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._mChangeFile.packageName=p;return Promise.resolve();};
D.prototype.submit=function(){this.store();var o=this._getChangePersistence(this._mChangeFile.reference);return o.saveDirtyChanges();};
D.prototype.store=function(){var s=this._mChangeFile.reference;var A=this._mChangeFile.validAppVersions.creation;var o=this._getChangePersistence(s,A);var d=this._getChangeToSubmit();o.addChange(d);return d;};
D.prototype._getChangePersistence=function(s,A){return C.getChangePersistenceForComponent(s,A);};
D.prototype._getChangeToSubmit=function(){var o=new b(this._getMap());if(this._sTransportRequest){o.setRequest(this._sTransportRequest);}else if(this._oSettings.isAtoEnabled()&&F.isCustomerDependentLayer(this._mChangeFile.layer)){o.setRequest('ATO_NOTIFICATION');}return o;};
D.prototype._getMap=function(){var i=this._oInlineChange.getMap();this._mChangeFile.content=i.content;this._mChangeFile.texts=i.texts;return this._mChangeFile;};
D.prototype.getJson=function(){return jQuery.extend(true,{},this._getMap());};
var c=function(){};
c.prototype.createNew=function(r,i,l,A,t){var s=function(_,I){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(I);}};s(i,r);var d;if(A){var m=A.getManifest();d=F.getAppVersionFromManifest(m);}var p={};p.changeType=i._getChangeType();p.componentName=r;p.reference=r;p.validAppVersions=d?{"creation":d,"from":d}:{};p.generator=t;if(!l){p.layer='CUSTOMER';}else{if(l!='VENDOR'&&l!='PARTNER'&&!F.isCustomerDependentLayer(l)){throw new Error("Parameter \"layer\" needs to be 'VENDOR', 'PARTNER' or customer dependent");}p.layer=l;}var e=b.createInitialFileContent(p);return S.getInstance().then(function(o){return Promise.resolve(new D(e,i,o));});};
return c;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory',["sap/ui/fl/descriptorRelated/internal/Utils"],function(U){"use strict";var D=function(c,p,t){U.checkTexts(t);this._mParameters={};this._mParameters.changeType=c;this._mParameters.content=p;this._mParameters.texts=t;};
D.prototype._getChangeType=function(){return this._mParameters.changeType;};
D.prototype.getMap=function(){return this._mParameters;};
var a={};
a.getDescriptorChangeTypes=function(){return["appdescr_ovp_addNewCard","appdescr_ovp_removeCard","appdescr_ovp_changeCard","appdescr_app_addNewInbound","appdescr_app_changeInbound","appdescr_app_removeInbound","appdescr_app_removeAllInboundsExceptOne","appdescr_app_addNewOutbound","appdescr_app_changeOutbound","appdescr_app_removeOutbound","appdescr_app_addNewDataSource","appdescr_app_changeDataSource","appdescr_app_removeDataSource","appdescr_app_addAnnotationsToOData","appdescr_app_addTechnicalAttributes","appdescr_app_removeTechnicalAttributes","appdescr_app_setTitle","appdescr_app_setSubTitle","appdescr_app_setShortTitle","appdescr_app_setDescription","appdescr_app_setInfo","appdescr_app_setDestination","appdescr_app_setKeywords","appdescr_app_setAch","appdescr_flp_setConfig","appdescr_ui5_addNewModel","appdescr_ui5_addNewModelEnhanceWith","appdescr_ui5_replaceComponentUsage","appdescr_smb_addNamespace","appdescr_smb_changeNamespace","appdescr_ui_generic_app_setMainPage","appdescr_ui_setIcon","appdescr_ui_setDeviceTypes","appdescr_ui5_addLibraries","appdescr_url_setUri"];};
a.createNew=function(c,p,t){var d=new D(c,p,t);return new Promise(function(r,b){if(d){r(d);}else{var e={};b(e);}});};
a._createDescriptorInlineChange=function(d,p,t){var o=new D(d,p,t);return new Promise(function(r,b){if(o){r(o);}else{var e={};b(e);}});};
a.createDescriptorInlineChange=function(d,p,t){return this._createDescriptorInlineChange(d,p,t);};
a.create_ovp_addNewCard=function(p,t){U.checkParameterAndType(p,"card","object");return this._createDescriptorInlineChange('appdescr_ovp_addNewCard',p,t);};
a.create_ovp_removeCard=function(p){U.checkParameterAndType(p,"cardId","string");return this._createDescriptorInlineChange('appdescr_ovp_removeCard',p);};
a.create_ovp_changeCard=function(p,t){U.checkParameterAndType(p,"cardId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_ovp_changeCard',p,t);};
a.create_app_addNewInbound=function(p,t){U.checkParameterAndType(p,"inbound","object");return this._createDescriptorInlineChange('appdescr_app_addNewInbound',p,t);};
a.create_app_removeInbound=function(p){U.checkParameterAndType(p,"inboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeInbound',p);};
a.create_app_removeAllInboundsExceptOne=function(p){U.checkParameterAndType(p,"inboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeAllInboundsExceptOne',p);};
a.create_app_changeInbound=function(p,t){U.checkParameterAndType(p,"inboundId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeInbound',p,t);};
a.create_app_addNewOutbound=function(p){U.checkParameterAndType(p,"outbound","object");return this._createDescriptorInlineChange('appdescr_app_addNewOutbound',p);};
a.create_app_removeOutbound=function(p){U.checkParameterAndType(p,"outboundId","string");return this._createDescriptorInlineChange('appdescr_app_removeOutbound',p);};
a.create_app_changeOutbound=function(p){U.checkParameterAndType(p,"outboundId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeOutbound',p);};
a.create_app_addNewDataSource=function(p){U.checkParameterAndType(p,"dataSource","object");return this._createDescriptorInlineChange('appdescr_app_addNewDataSource',p);};
a.create_app_removeDataSource=function(p){U.checkParameterAndType(p,"dataSourceId","string");return this._createDescriptorInlineChange('appdescr_app_removeDataSource',p);};
a.create_app_changeDataSource=function(p){U.checkParameterAndType(p,"dataSourceId","string");U.checkEntityPropertyChange(p);return this._createDescriptorInlineChange('appdescr_app_changeDataSource',p);};
a.create_app_addAnnotationsToOData=function(p){U.checkParameterAndType(p,"dataSourceId","string");U.checkParameterAndType(p,"annotations","array");U.checkParameterAndType(p,"dataSource","object");return this._createDescriptorInlineChange('appdescr_app_addAnnotationsToOData',p);};
a.create_app_setTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.title";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setSubTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setSubTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.subTitle";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setShortTitle=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setShortTitle',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.shortTitle";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setDescription=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setDescription',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.description";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setInfo=function(p){var t={"":p};return this._createDescriptorInlineChange('appdescr_app_setInfo',{},t).then(function(d){return new Promise(function(r){d["setHostingIdForTextKey"]=function(h){var b=d;var T=h+"_sap.app.info";b._mParameters.texts[T]=b._mParameters.texts[""];delete b._mParameters.texts[""];};r(d);});});};
a.create_app_setAch=function(p){U.checkParameterAndType(p,"ach","string");return this._createDescriptorInlineChange('appdescr_app_setAch',p);};
a.create_app_setDestination=function(p){U.checkParameterAndType(p,"destination","object");return this._createDescriptorInlineChange('appdescr_app_setDestination',p);};
a.create_app_setKeywords=function(p,t){U.checkParameterAndType(p,"keywords","array");return this._createDescriptorInlineChange('appdescr_app_setKeywords',p,t);};
a.create_app_addTechnicalAttributes=function(p){U.checkParameterAndType(p,"technicalAttributes","array");return this._createDescriptorInlineChange('appdescr_app_addTechnicalAttributes',p);};
a.create_app_removeTechnicalAttributes=function(p){U.checkParameterAndType(p,"technicalAttributes","array");return this._createDescriptorInlineChange('appdescr_app_removeTechnicalAttributes',p);};
a.create_flp_setConfig=function(p){U.checkParameterAndType(p,"config","object");return this._createDescriptorInlineChange('appdescr_flp_setConfig',p);};
a.create_ui5_addNewModel=function(p){U.checkParameterAndType(p,"model","object");return this._createDescriptorInlineChange('appdescr_ui5_addNewModel',p);};
a.create_ui5_addNewModelEnhanceWith=function(p,t){U.checkParameterAndType(p,"modelId","string");return this._createDescriptorInlineChange('appdescr_ui5_addNewModelEnhanceWith',p,t);};
a.create_ui5_replaceComponentUsage=function(p){U.checkParameterAndType(p,"componentUsageId","string");U.checkParameterAndType(p,"componentUsage","object");return this._createDescriptorInlineChange('appdescr_ui5_replaceComponentUsage',p);};
a.create_ui5_addLibraries=function(p){U.checkParameterAndType(p,"libraries","object");return this._createDescriptorInlineChange('appdescr_ui5_addLibraries',p);};
a.create_smb_addNamespace=function(p){U.checkParameterAndType(p,"smartBusinessApp","object");return this._createDescriptorInlineChange('appdescr_smb_addNamespace',p);};
a.create_smb_changeNamespace=function(p){U.checkParameterAndType(p,"smartBusinessApp","object");return this._createDescriptorInlineChange('appdescr_smb_changeNamespace',p);};
a.create_ui_generic_app_setMainPage=function(p,t){U.checkParameterAndType(p,"page","object");return this._createDescriptorInlineChange('appdescr_ui_generic_app_setMainPage',p,t);};
a.create_ui_setIcon=function(p){U.checkParameterAndType(p,"icon","string");return this._createDescriptorInlineChange('appdescr_ui_setIcon',p);};
a.create_ui_setDeviceTypes=function(p){U.checkParameterAndType(p,"deviceTypes","object");return this._createDescriptorInlineChange('appdescr_ui_setDeviceTypes',p);};
a.create_url_setUri=function(p){U.checkParameterAndType(p,"uri","string");return this._createDescriptorInlineChange('appdescr_url_setUri',p);};
return a;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/api/DescriptorVariantFactory',["sap/ui/fl/descriptorRelated/api/DescriptorInlineChangeFactory","sap/ui/fl/Utils","sap/ui/fl/LrepConnector","sap/ui/fl/descriptorRelated/internal/Utils","sap/ui/fl/registry/Settings"],function(D,F,L,U,S){"use strict";var a=function(p,f,d,s){if(p&&d){this._id=p.id;this._mode='DELETION';this._mMap=f;}else if(p){this._id=p.id;this._reference=p.reference;this._layer=p.layer;if(typeof p.isAppVariantRoot!=undefined){this._isAppVariantRoot=p.isAppVariantRoot;}if(typeof p.referenceVersion!=undefined){this._referenceVersion=p.referenceVersion;}this._mode='NEW';}else if(f){this._mMap=f;this._mode='FROM_EXISTING';}this._oSettings=s;this._sTransportRequest=null;this._content=[];};
a.prototype.addDescriptorInlineChange=function(d){var t=this;return new Promise(function(r){var s=function(_,i){if(_["setHostingIdForTextKey"]){_.setHostingIdForTextKey(i);}};switch(t._mode){case'NEW':s(d,t._id);t._content.push(d.getMap());break;case'FROM_EXISTING':s(d,t._mMap.id);t._mMap.content.push(d.getMap());break;default:}r(null);});};
a.prototype.setTransportRequest=function(t){try{U.checkTransportRequest(t);}catch(e){return Promise.reject(e);}this._sTransportRequest=t;return Promise.resolve();};
a.prototype.setPackage=function(p){try{U.checkPackage(p);}catch(e){return Promise.reject(e);}this._package=p;return Promise.resolve();};
a.prototype.submit=function(){var r='/sap/bc/lrep/appdescr_variants/';var m;switch(this._mode){case'NEW':m='POST';break;case'FROM_EXISTING':m='PUT';r=r+this._getMap().id;break;case'DELETION':m='DELETE';r=r+this._id;break;default:}var M=this._getMap();if(this._sTransportRequest){r+='?changelist='+this._sTransportRequest;}else if(this._oSettings.isAtoEnabled()&&F.isCustomerDependentLayer(M.layer)){r+='?changelist=ATO_NOTIFICATION';}var l=L.createConnector();return l.send(r,m,M);};
a.prototype.getId=function(){return this._id;};
a.prototype.setReference=function(r){if(r===undefined||typeof r!=="string"){throw new Error("No parameter sReference of type string provided");}this._reference=r;};
a.prototype.getReference=function(){return this._reference;};
a.prototype.getNamespace=function(){return this._getMap().namespace;};
a.prototype.getSettings=function(){return this._oSettings;};
a.prototype.getJson=function(){return jQuery.extend(true,{},this._getMap());};
a.prototype._getMap=function(){switch(this._mode){case'NEW':var r={"fileName":this._getNameAndNameSpace().fileName,"fileType":"appdescr_variant","namespace":this._getNameAndNameSpace().namespace,"layer":this._layer,"packageName":this._package?this._package:"$TMP","reference":this._reference,"id":this._id,"content":this._content};if(typeof this._isAppVariantRoot!=undefined){r.isAppVariantRoot=this._isAppVariantRoot;}if(r.isAppVariantRoot!=undefined&&!r.isAppVariantRoot){r.fileType="cdmapp_config";}if(typeof this._referenceVersion!=undefined){r.referenceVersion=this._referenceVersion;}return r;case'FROM_EXISTING':case'DELETION':{return this._mMap;}default:}};
a.prototype._getNameAndNameSpace=function(){return U.getNameAndNameSpace(this._id,this._reference);};
var b={};
b._getDescriptorVariant=function(i){var r='/sap/bc/lrep/appdescr_variants/'+i;var l=L.createConnector();return l.send(r,'GET');};
b.createNew=function(p){U.checkParameterAndType(p,"reference","string");U.checkParameterAndType(p,"id","string");if(!p.layer){p.layer='CUSTOMER';}else{U.checkParameterAndType(p,"layer","string");if(p.layer!='VENDOR'&&p.layer!='PARTNER'&&!F.isCustomerDependentLayer(p.layer)){throw new Error("Parameter \"layer\" needs to be 'VENDOR', 'PARTNER' or customer dependent");}}if(p.isAppVariantRoot){U.checkParameterAndType(p,"isAppVariantRoot","boolean");}return S.getInstance().then(function(s){return Promise.resolve(new a(p,null,false,s));});};
b.createForExisting=function(i){if(i===undefined||typeof i!=="string"){throw new Error("Parameter \"sId\" must be provided of type string");}var _;return b._getDescriptorVariant(i).then(function(r){_=r;return S.getInstance();}).then(function(s){var d=_.response;if(!jQuery.isPlainObject(d)){d=JSON.parse(d);}return Promise.resolve(new a(null,d,false,s));});};
b.createFromJson=function(p){if(!jQuery.isPlainObject(p)){throw new Error("Parameter \"mParameters\" must be provided of type object");}return S.getInstance().then(function(s){return Promise.resolve(new a(null,p,false,s));});};
b.createDeletion=function(i){if(i===undefined||typeof i!=="string"){throw new Error("Parameter \"sId\" must be provided of type string");}var p={};p.id=i;var _;return b._getDescriptorVariant(i).then(function(r){_=r;return S.getInstance();}).then(function(s){var d=JSON.parse(_.response);return Promise.resolve(new a(p,d,true,s));});};
return b;},true);
sap.ui.predefine('sap/ui/fl/descriptorRelated/internal/Utils',function(){"use strict";var U=function(){};
U.prototype.getNameAndNameSpace=function(i,r){return{"fileName":"manifest","namespace":"apps/"+r+"/appVariants/"+i+"/"};};
U.prototype.checkEntityPropertyChange=function(p){this.checkParameterAndType(p,"entityPropertyChange","object");if(p.entityPropertyChange instanceof Array){for(var i=0;i<p.entityPropertyChange.length;i++){var c=p.entityPropertyChange[i];this.checkEntityPropertyChangeContent(c);}}else if(p.entityPropertyChange instanceof Object){this.checkEntityPropertyChangeContent(p.entityPropertyChange);}};
U.prototype.checkEntityPropertyChangeContent=function(c){this.checkParameterAndType(c,"propertyPath","string");this.checkParameterAndType(c,"operation","string");if(jQuery.inArray(c.operation,['INSERT','UPDATE','UPSERT','DELETE'])<0){throw new Error("Parameter \"entityPropertyChange.operation\" needs to be one of 'INSERT', 'UPDATE', 'UPSERT', 'DELETE'");}if(c.propertyValue===undefined&&c.operation!=='DELETE'){throw new Error("No parameter \"entityPropertyChange.propertyValue\" provided");}};
U.prototype.checkParameterAndType=function(p,P,t){if(t==="array"){if(p===undefined||p[P]===undefined||!Array.isArray(p[P])){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}}else{if(p===undefined||p[P]===undefined||typeof p[P]!==t){throw new Error("No parameter \""+P+"\" of type "+t+" provided");}}};
U.prototype.checkTexts=function(t){if(t!==undefined&&typeof t!=="object"){throw new Error("Wrong format for provided \"texts\" parameter");}};
U.prototype.checkTransportRequest=function(t){if(!/^[A-Z0-9]{1,20}$/.test(t)&&t!=='ATO_NOTIFICATION'){throw new Error("Wrong format for provided \"sTransportRequest\" parameter");}};
U.prototype.checkPackage=function(p){if(!/^[A-Z0-9/_]{1,30}$/.test(p)){throw new Error("Wrong format for provided \"sPackage\" parameter");}};
return new U();},true);
sap.ui.predefine('sap/ui/fl/fieldExt/Access',["jquery.sap.storage"],function(S){"use strict";var A={};A._mServiceType={v2:"v2",v4:"v4"};A._sODataV4ResourcePathPrefix="sap/opu/odata4/";A._sStorageKey="sap.ui.fl.fieldExt.Access";A._iValidityPeriod=1*7*24*60*60*1000;
A.getBusinessContexts=function(s,e,E){var m=this._getEntityInfo(e,E);var a=this._parseServiceUri(s);var b=this._buildBusinessContextRetrievalUri(a,m);var p=this._executeAjaxCall(b,a,m);return p;};
A.isServiceOutdated=function(s){if(!this._isSystemInfoAvailable()){return false;}var m=this._getServiceItem(this._createServiceItem(s));if(m){if(this._isServiceExpired(m)){this.setServiceValid(s);return false;}else{return true;}}else{return false;}};
A.setServiceValid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();delete d[this._createServiceItem(s).serviceKey];this._setDataToLocalStorage(d);}};
A.setServiceInvalid=function(s){if(this._isSystemInfoAvailable()){var d=this._getDataFromLocalStorage();var i=this._createServiceItem(s);d[i.serviceKey]=i;this._setDataToLocalStorage(d);}};
A._getEntityInfo=function(e,E){var o={entityTypeName:e||"",entitySetName:E||""};if(((o.entitySetName.length===0)&&(o.entityTypeName.length===0))||(!(o.entitySetName.length===0)&&!(o.entityTypeName.length===0))){throw new Error("sap.ui.fl.fieldExt.Access._getEntityInfo()"+"Inconsistent input parameters EntityType: "+o.entityTypeName+" EntitySet: "+o.entitySetName);}return o;};
A._parseServiceUri=function(s){if(s.toLowerCase().indexOf(this._sODataV4ResourcePathPrefix)!==-1){return this._parseV4ServiceUri(s);}else{return this._parseV2ServiceUri(s);}};
A._parseV2ServiceUri=function(s){var r=/.*sap\/opu\/odata\/([^\/]+)\/([^\/]+)/i;var R=/([^;]+);v=(\d{1,4})/i;var o="sap/opu/odata";var a;if(s.toLowerCase().indexOf(o)!==-1){var b=s.match(r);if(!b||b.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseV2ServiceUri: Malformed service URI (Invalid service name)");}if(b[1].toLowerCase()!=="sap"){a="/"+b[1]+"/"+b[2];}else{a=b[2];}}else{if(s.length>0&&s.lastIndexOf("/")+1===s.length){s=s.substring(0,s.length-1);}a=s.substring(s.lastIndexOf("/")+1);}if(a.indexOf(";v=")!==-1){var v=a.match(R);if(!v||v.length!==3){throw new Error("sap.ui.fl.fieldExt.Access._parseV2ServiceUri: Malformed service URI (Invalid version)");}return{serviceName:v[1],serviceVersion:v[2],serviceType:this._mServiceType.v2};}else{return{serviceName:a,serviceVersion:"0001",serviceType:this._mServiceType.v2};}};
A._parseV4ServiceUri=function(s){var r=/^\/?sap\/opu\/odata4((?:\/[^/]+){5})(\/[^/]+){1}(\/.*)?/i;var a=s.match(r);if(!a||a.length!==4){throw new Error("sap.ui.fl.fieldExt.Access._parseV4ServiceUri: Malformed service URI");}var n=a[1].split("/");n.splice(0,3);var R=/(\d{1,4})/i;var v=a[2].match(R);return{serviceName:n.join("/"),serviceVersion:v[1],serviceType:this._mServiceType.v4};};
A._buildBusinessContextRetrievalUri=function(s,e){var b="/sap/opu/odata/SAP/APS_CUSTOM_FIELD_MAINTENANCE_SRV/";if(s.serviceType===this._mServiceType.v4){var r=this._sODataV4ResourcePathPrefix+s.serviceName+"/"+s.serviceVersion;b+="GetBusinessContextsByResourcePath?"+jQuery.sap.encodeURLParameters({"ResourcePath":"'"+r+"'"});}else{b+="GetBusinessContextsByEntityType?"+"ServiceName=\'"+s.serviceName+"\'"+"&ServiceVersion=\'"+s.serviceVersion+"\'";}b+="&EntitySetName=\'"+e.entitySetName+"\'"+"&EntityTypeName=\'"+e.entityTypeName+"\'"+"&$format=json";return b;};
A._executeAjaxCall=function(b,s,e){var t=this;var a=this._getAjaxSettings();var d=jQuery.Deferred();var r={BusinessContexts:[],ServiceName:s.serviceName,ServiceVersion:s.serviceVersion};jQuery.ajax(b,a).done(function(c,f,j){r.BusinessContexts=t._extractBusinessContexts(c);d.resolve(r);}).fail(function(j,c,f){if(j.status===404&&s.serviceType===t._mServiceType.v4){d.resolve(r);}else{var E=t._getMessagesFromXHR(j);var o={errorOccured:true,errorMessages:E,serviceName:s.serviceName,serviceVersion:s.serviceVersion,entityType:e.entityTypeName,entitySet:e.entitySetName};d.reject(o);}});return d.promise();};
A._getAjaxSettings=function(){var s={type:"GET",async:true,dataType:"json"};return s;};
A._extractBusinessContexts=function(d){var r=null;var b=[];if(d&&d.d){r=d.d.results;}if(r!==null&&r.length>0){for(var i=0;i<r.length;i++){if(r[i].BusinessContext!==null){b.push(r[i].BusinessContext);}}}return b;};
A._getMessagesFromXHR=function(x){var m=[];try{var E=JSON.parse(x.responseText);if(E&&E.error&&E.error.message&&E.error.message.value&&E.error.message.value!==''){m.push({severity:"error",text:E.error.message.value});}else{m.push({severity:"error",text:x.responseText});}}catch(e){}return m;};
A._getCurrentTime=function(){return Date.now();};
A._isServiceExpired=function(s){return s.expirationDate<=this._getCurrentTime();};
A._getLocalStorage=function(){return jQuery.sap.storage(jQuery.sap.storage.Type.local);};
A.isLocalStorageAvailable=function(){return this._getLocalStorage()&&this._getLocalStorage().isSupported();};
A._getServiceItem=function(s){return this._getDataFromLocalStorage()[s.serviceKey]||null;};
A._createServiceItem=function(s){var e=this._getCurrentTime()+this._iValidityPeriod;var m=this._getSystemInfo();var p=this._extractServiceInfo(s);return{"serviceKey":m.getName()+m.getClient()+p.serviceName+p.serviceVersion,"expirationDate":e};};
A._extractServiceInfo=function(s){if(typeof s==="string"){return this._parseServiceUri(s);}else{return s;}};
A._isSystemInfoAvailable=function(){return sap&&sap.ushell&&sap.ushell.Container&&sap.ushell.Container.getLogonSystem;};
A._getSystemInfo=function(){return sap.ushell.Container.getLogonSystem();};
A._setDataToLocalStorage=function(d){if(this.isLocalStorageAvailable()){this._getLocalStorage().put(A._sStorageKey,JSON.stringify(d));}};
A._getDataFromLocalStorage=function(){if(!this.isLocalStorageAvailable()){return{};}var s=this._getLocalStorage().get(A._sStorageKey);if(!s){return{};}else{return JSON.parse(s);}};
return A;},true);
sap.ui.predefine('sap/ui/fl/library',["sap/ui/fl/RegistrationDelegator"],function(R){"use strict";sap.ui.getCore().initLibrary({name:"sap.ui.fl",version:"1.56.5",controls:["sap.ui.fl.variants.VariantManagement"],dependencies:["sap.ui.core","sap.m"],designtime:"sap/ui/fl/designtime/library.designtime",extensions:{"sap.ui.support":{diagnosticPlugins:["sap/ui/fl/support/Flexibility"],publicRules:true}}});sap.ui.fl.Scenario={AppVariant:"APP_VARIANT",AdaptationProject:"ADAPTATION_PROJECT",FioriElementsFromScratch:"FE_FROM_SCRATCH",UiAdaptation:"UI_ADAPTATION"};R.registerAll();return sap.ui.fl;});
sap.ui.predefine('sap/ui/fl/registry/ChangeHandlerRegistration',["sap/ui/fl/registry/ChangeRegistry"],function(C){"use strict";var a={getChangeHandlersOfLoadedLibsAndRegisterOnNewLoadedLibs:function(){var t=this;var c=sap.ui.getCore();var A=c.getLoadedLibraries();jQuery.each(A,function(l,L){if(L.extensions&&L.extensions.flChangeHandlers){t.registerFlexChangeHandlers(L.extensions.flChangeHandlers);}});c.attachLibraryChanged(this.handleLibraryRegistrationAfterFlexLibraryIsLoaded.bind(this));},registerFlexChangeHandlers:function(f){if(f){var c=C.getInstance();c.registerControlsForChanges(f);}},handleLibraryRegistrationAfterFlexLibraryIsLoaded:function(l){if(l.getParameter("operation")==="add"){var L=l.getParameter("metadata");if(L&&L.extensions&&L.extensions.flChangeHandlers){var f=L.extensions.flChangeHandlers;this.registerFlexChangeHandlers(f);}}}};return a;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistry',["sap/ui/fl/Utils","jquery.sap.global","sap/ui/fl/registry/ChangeRegistryItem","sap/ui/fl/registry/ChangeTypeMetadata","sap/ui/fl/registry/Settings","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/AddXML"],function(U,q,C,a,S,H,M,b,P,c,d,e,f,A){"use strict";var g=function(){this._registeredItems={};this.initSettings();this.initDeveloperModeChangeHandlers();};g._instance=undefined;g.prototype._oDefaultActiveChangeHandlers={};g.prototype._oDefaultChangeHandlers={"hideControl":H,"moveElements":M,"moveControls":b,"unhideControl":d,"stashControl":e,"unstashControl":f};g.prototype._mDeveloperModeChangeHandlers={"propertyChange":{changeHandler:P},"propertyBindingChange":{changeHandler:c},"addXML":{changeHandler:A}};
g.prototype.initDeveloperModeChangeHandlers=function(){Object.keys(this._mDeveloperModeChangeHandlers).forEach(function(s){var o=this._mDeveloperModeChangeHandlers[s].changeHandler;var l=this._oSettings.getDeveloperModeLayerPermissions();var h={changeType:s,changeHandler:o,layers:l};var i=this._createChangeRegistryItemForSimpleChange("defaultActiveForAllControls",h);this._oDefaultActiveChangeHandlers[s]=i;}.bind(this));};
g.getInstance=function(){if(!g._instance){g._instance=new g();}return g._instance;};
g.prototype.hasRegisteredChangeHandlersForControl=function(s){var h=Object.keys(this._registeredItems);return h.indexOf(s)!==-1;};
g.prototype.hasChangeHandlerForControlAndChange=function(s,h){if(!this.hasRegisteredChangeHandlersForControl(s)){return false;}var r=this._registeredItems[s];var i=Object.keys(r);return i.indexOf(h)!==-1;};
g.prototype.registerControlsForChanges=function(m){var t=this;q.each(m,function(s,h){if(Array.isArray(h)){var o={};h.forEach(function(i){o[i.changeType]=i.changeHandler;});t._registerChangeHandlersForControl(s,o);}else{t._registerChangeHandlersForControl(s,h);}});};
g.prototype._registerChangeHandlersForControl=function(s,o){var t=this;if(typeof o==="string"){try{o=sap.ui.requireSync(o+".flexibility");}catch(h){U.log.error("Flexibility change handler registration failed.\nControlType: "+s+"\n"+h.message);return;}}q.each(o,function(i,j){var k=t._getChangeHandlerEntry(i,j);var l={"changeType":i,"changeHandler":k.changeHandler,"layers":k.layers};t.registerControlForSimpleChange(s,l);});};
g.prototype._getInstanceSpecificChangeRegistryItem=function(s,o,m){var h=m.getChangeHandlerModulePath(o);var i={},v,j,k,l,n;if(typeof h!=="string"){return undefined;}try{i=sap.ui.requireSync(h);}catch(p){U.log.error("Flexibility registration for control "+m.getId(o)+" failed to load module "+h+"\n"+p.message);return undefined;}v=i[s];if(!v){return undefined;}j=this._getChangeHandlerEntry(s,v);k={"changeType":s,"changeHandler":j.changeHandler,"layers":j.layers};l=m.getControlType(o);n=this._createChangeRegistryItemForSimpleChange(l,k);return n;};
g.prototype._getChangeHandlerEntry=function(s,v){var r={};var D=Object.keys(this._mDeveloperModeChangeHandlers);if(!v||!v.changeHandler){r.changeHandler=v;}else{r=v;}if(r.changeHandler==="default"){r.changeHandler=this._oDefaultChangeHandlers[s];}else if(D.indexOf(s)>-1){throw new Error("You can't use a custom change handler for the following Developer Mode change types: "+D.toString()+". Please use 'default' instead.");}return r;};
g.prototype._getChangeRegistryItem=function(s,h,l){var m;if(!s||!h){return undefined;}m=this.getRegistryItems({"changeTypeName":s,"controlType":h,"layer":l});if(m&&m[h]&&m[h][s]){return m[h][s];}else if(m&&m[h]){return m[h];}else{return m;}};
g.prototype.getChangeHandler=function(s,h,o,m,l){var i,j;i=this._getInstanceSpecificChangeRegistryItem(s,o,m);if(i&&i.getChangeTypeMetadata){var k=i.getChangeTypeMetadata().getChangeHandler();if(k){return k;}}j=this._getChangeRegistryItem(s,h,l);if(j&&j.getChangeTypeMetadata){var O=j.getChangeTypeMetadata().getChangeHandler();if(O){return O;}}return undefined;};
g.prototype.registerControlForSimpleChange=function(s,o){var h;if(!s){return;}if(!o||!o.changeType||!o.changeHandler){return;}h=this._createChangeRegistryItemForSimpleChange(s,o);if(h){this.addRegistryItem(h);}};
g.prototype._createChangeRegistryItemForSimpleChange=function(s,o){var p,h,i,l;l=q.extend({},this._oSettings.getDefaultLayerPermissions());var L=o.layers;if(L){Object.keys(L).forEach(function(j){if(l[j]===undefined){throw new Error("The Layer '"+j+"' is not supported. Please only use supported layers");}l[j]=L[j];});}p={name:o.changeType,changeHandler:o.changeHandler,layers:l};h=new a(p);p={changeTypeMetadata:h,controlType:s};i=new C(p);return i;};
g.prototype.addRegistryItem=function(r){var s,h;if(!r){return;}s=r.getChangeTypeName();h=r.getControlType();this._registeredItems[h]=this._registeredItems[h]||{};this._registeredItems[h][s]=r;};
g.prototype.removeRegistryItem=function(p){if(!p.changeTypeName&&!p.controlType){U.log.error("sap.ui.fl.registry.ChangeRegistry: ChangeType and/or ControlType required");return;}if(p.controlType&&p.changeTypeName){if(this._registeredItems[p.controlType]){if(Object.keys(this._registeredItems[p.controlType]).length===1){delete this._registeredItems[p.controlType];}else{delete this._registeredItems[p.controlType][p.changeTypeName];}}}else if(p.controlType){if(this._registeredItems[p.controlType]){delete this._registeredItems[p.controlType];}}else if(p.changeTypeName){for(var h in this._registeredItems){var i=this._registeredItems[h];delete i[p.changeTypeName];}}};
g.prototype.getRegistryItems=function(p){if(!p){U.log.error("sap.ui.fl.registry.ChangeRegistry: no parameters passed for getRegistryItems");}var s=p.changeTypeName;var h=p.controlType;if(!s&&!h){U.log.error("sap.ui.fl.registry.ChangeRegistry: Change Type Name and/or Control Type required");}var r=null;if(h&&s){var o=this._getOrLoadChangeHandler(h,s);if(o){r={};r[h]={};r[h][s]=o;}}else if(h){r={};r[h]={};if(this._registeredItems[h]){var i=Object.keys(this._registeredItems[h]);i.forEach(function(s){r[h][s]=this._getOrLoadChangeHandler(h,s);}.bind(this));}for(var k in this._oDefaultActiveChangeHandlers){r[h][k]=this._oDefaultActiveChangeHandlers[k];}}else if(s){r={};for(h in this._registeredItems){if(this._registeredItems[h][s]){r[h]={};r[h][s]=this._getOrLoadChangeHandler(h,s);}}r["defaultActiveForAllControls"]={};for(var j in this._oDefaultActiveChangeHandlers){r["defaultActiveForAllControls"][j]=this._oDefaultActiveChangeHandlers[j];}}this._filterChangeTypes(r,p.layer);return r;};
g.prototype._getOrLoadChangeHandler=function(s,h){var o=this._registeredItems[s];if(o){var i=o[h];if(i){var j=i.getChangeTypeMetadata();var k=j.getChangeHandler();if(typeof k==="string"){q.sap.require(k);k=sap.ui.require(k);j._changeHandler=k;}return i;}}var D=this._oDefaultActiveChangeHandlers[h];if(D){return D;}return null;};
g.prototype.initSettings=function(){this._oSettings=S.getInstanceOrUndef();if(!this._oSettings){this._oSettings=new S({});}};
g.prototype._filterChangeTypes=function(r,l){if(this._oSettings&&l&&r){var i=false;q.each(r,function(s,o){q.each(o,function(h,R){var L=R.getChangeTypeMetadata().getLayers();i=L[l];if(!i){U.log.warning("Change type "+h+" not enabled for layer "+l);delete o[h];}});});}};
g.prototype.getDragInfo=function(s){var h=this._registeredItems[s];if(h){return h.getDragInfo();}return null;};
return g;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeRegistryItem',["sap/ui/fl/Utils","jquery.sap.global"],function(U,q){"use strict";var C=function(p){if(!p.changeTypeMetadata){U.log.error("sap.ui.fl.registry.ChangeRegistryItem: ChangeTypeMetadata required");}if(!p.controlType){U.log.error("sap.ui.fl.registry.ChangeRegistryItem: ControlType required");}this._changeTypeMetadata=p.changeTypeMetadata;this._controlType=p.controlType;if(p.permittedRoles){this._permittedRoles=p.permittedRoles;}if(p.dragTargets){this._dragTargets=p.dragTargets;}};C.prototype._changeTypeMetadata=undefined;C.prototype._controlType=undefined;C.prototype._permittedRoles={};C.prototype._dragTargets=[];
C.prototype.getChangeTypeMetadata=function(){return this._changeTypeMetadata;};
C.prototype.getChangeTypeName=function(){return this._changeTypeMetadata.getName();};
C.prototype.getControlType=function(){return this._controlType;};
C.prototype.getPermittedRoles=function(){return this._permittedRoles;};
C.prototype.getDragTargets=function(){return this._dragTargets;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/ChangeTypeMetadata',["sap/ui/fl/Utils","jquery.sap.global"],function(U,q){"use strict";var C=function(p){if(!p.name){U.log.error("sap.ui.fl.registry.ChangeType: Name required");}if(!p.changeHandler){U.log.error("sap.ui.fl.registry.ChangeType: ChangeHandler required");}this._name=p.name;this._changeHandler=p.changeHandler;this._layers=p.layers;if(p.labelKey){this._labelKey=p.labelKey;}if(p.tooltipKey){this._tooltipKey=p.tooltipKey;}if(p.iconKey){this._iconKey=p.iconKey;}if(p.sortIndex){this._sortIndex=p.sortIndex;}};C.prototype._name="";C.prototype._changeHandler="";C.prototype._layers=[];C.prototype._sortIndex=0;C.prototype._labelKey="";C.prototype._tooltipKey="";C.prototype._iconKey="";
C.prototype.getName=function(){return this._name;};
C.prototype.getChangeHandler=function(){return this._changeHandler;};
C.prototype.getLayers=function(){return this._layers;};
C.prototype.getLabel=function(){return this._labelKey;};
C.prototype.getTooltip=function(){return this._tooltipKey;};
C.prototype.getIcon=function(){return this._iconKey;};
C.prototype.getSortIndex=function(){return this._sortIndex;};
return C;},true);
sap.ui.predefine('sap/ui/fl/registry/Settings',["jquery.sap.global","sap/ui/fl/LrepConnector","sap/ui/fl/Cache","sap/ui/fl/Utils","sap/ui/base/EventProvider"],function(q,L,C,U,E){"use strict";var S=function(s){E.apply(this);if(!s){throw new Error("no flex settings provided");}if(!s.defaultLayerPermissions){s.defaultLayerPermissions={"VENDOR":true,"CUSTOMER_BASE":true,"CUSTOMER":true,"USER":false};}if(!s.developerModeLayerPermissions){s.developerModeLayerPermissions={"VENDOR":true,"CUSTOMER_BASE":true,"CUSTOMER":false,"USER":false};}if(!(S._IS_VARIANT_SHARING_ENABLED in s)){s.isVariantSharingEnabled=true;}this._oSettings=s;this._hasMergeErrorOccured=false;};S.prototype=q.sap.newObject(E.prototype);S.events={flexibilityAdaptationButtonAllowedChanged:"flexibilityAdaptationButtonAllowedChanged",changeModeUpdated:"changeModeUpdated"};S._instance=undefined;S._bFlexChangeMode=true;S._bFlexibilityAdaptationButtonAllowed=false;S._oEventProvider=new E();S._IS_VARIANT_SHARING_ENABLED="isVariantSharingEnabled";
S.fireEvent=function(e,p){S._oEventProvider.fireEvent(e,p);};
S.attachEvent=function(e,c){S._oEventProvider.attachEvent(e,c);};
S.detachEvent=function(e,c){S._oEventProvider.detachEvent(e,c);};
S.getInstance=function(){if(S._instance){return Promise.resolve(S._instance);}var p=C.getFlexDataPromise();if(p){return p.then(function(f){var s={};if(f.changes&&f.changes.settings){s=f.changes.settings;}return S._storeInstance(s);},function(){return S._loadSettings();});}return S._loadSettings();};
S._loadSettings=function(){return L.createConnector().loadSettings().then(function(s){return S._storeInstance(s);});};
S._storeInstance=function(s){if(!S._instance){S._instance=new S(s);}return S._instance;};
S.getInstanceOrUndef=function(){var s;if(S._instance){s=S._instance;}return s;};
S.isFlexChangeMode=function(){var f=this._isFlexChangeModeFromUrl();if(f!==undefined){return f;}return S._bFlexChangeMode;};
S._isFlexChangeModeFromUrl=function(){var f;var u=q.sap.getUriParameters();if(u&&u.mParams&&u.mParams['sap-ui-fl-changeMode']&&u.mParams['sap-ui-fl-changeMode'][0]){if(u.mParams['sap-ui-fl-changeMode'][0]==='true'){f=true;}else if(u.mParams['sap-ui-fl-changeMode'][0]==='false'){f=false;}}return f;};
S.activateFlexChangeMode=function(){var f=true;S._setFlexChangeMode(f);};
S.leaveFlexChangeMode=function(){var f=false;S._setFlexChangeMode(f);};
S._setFlexChangeMode=function(f){if(S._bFlexChangeMode===f){return;}S._bFlexChangeMode=f;var p={bFlexChangeMode:f};S.fireEvent(S.events.changeModeUpdated,p);};
S.isFlexibilityAdaptationButtonAllowed=function(){return S._bFlexibilityAdaptationButtonAllowed;};
S.allowFlexibilityAdaptationButton=function(){var f=true;S.setFlexibilityAdaptationButtonAllowed(f);};
S.disallowFlexibilityAdaptationButton=function(){var f=false;S.setFlexibilityAdaptationButtonAllowed(f);};
S.setFlexibilityAdaptationButtonAllowed=function(f){if(S._bFlexibilityAdaptationButtonAllowed===f){return;}S._bFlexibilityAdaptationButtonAllowed=f;var p={bFlexibilityAdaptationButtonAllowed:f};S.fireEvent(S.events.flexibilityAdaptationButtonAllowedChanged,p);};
S.prototype.isKeyUser=function(){var i=false;if(this._oSettings.isKeyUser){i=this._oSettings.isKeyUser;}return i;};
S.prototype.isModelS=function(){var i=false;if(this._oSettings.isAtoAvailable){i=this._oSettings.isAtoAvailable;}return i;};
S.prototype.isAtoEnabled=function(){var i=false;if(this._oSettings.isAtoEnabled){i=this._oSettings.isAtoEnabled;}return i;};
S.prototype.isAtoAvailable=function(){var i=false;if(this._oSettings.isAtoAvailable){i=this._oSettings.isAtoAvailable;}return i;};
S.prototype.isProductiveSystem=function(){var i=false;if(this._oSettings.isProductiveSystem){i=this._oSettings.isProductiveSystem;}return i;};
S.prototype.isVariantSharingEnabled=function(){return(this._oSettings.isVariantSharingEnabled===true);};
S.prototype.setMergeErrorOccured=function(e){this._hasMergeErrorOccoured=e;};
S.prototype.hasMergeErrorOccured=function(){return this._hasMergeErrorOccured;};
S.prototype.getDefaultLayerPermissions=function(){return this._oSettings.defaultLayerPermissions;};
S.prototype.getDeveloperModeLayerPermissions=function(){return this._oSettings.developerModeLayerPermissions;};
return S;},true);
sap.ui.predefine('sap/ui/fl/registry/SimpleChanges',["jquery.sap.global","sap/ui/fl/changeHandler/HideControl","sap/ui/fl/changeHandler/UnhideControl","sap/ui/fl/changeHandler/StashControl","sap/ui/fl/changeHandler/UnstashControl","sap/ui/fl/changeHandler/MoveElements","sap/ui/fl/changeHandler/MoveControls","sap/ui/fl/changeHandler/PropertyChange","sap/ui/fl/changeHandler/PropertyBindingChange"],function(q,H,U,S,a,M,b,P,c){"use strict";var d={hideControl:{changeType:"hideControl",changeHandler:H},unhideControl:{changeType:"unhideControl",changeHandler:U},stashControl:{changeType:"stashControl",changeHandler:S},unstashControl:{changeType:"unstashControl",changeHandler:a},moveElements:{changeType:"moveElements",changeHandler:M},moveControls:{changeType:"moveControls",changeHandler:b},propertyChange:{changeType:"propertyChange",changeHandler:P},propertyBindingChange:{changeType:"propertyBindingChange",changeHandler:c}};return d;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportDialog',['jquery.sap.global',"sap/m/List","sap/m/InputListItem",'sap/m/Button','sap/m/ComboBox','sap/m/Dialog','sap/m/DialogRenderer','sap/m/Input','sap/m/Label','sap/m/MessageToast','sap/ui/core/ListItem','sap/ui/fl/transport/Transports'],function(q,L,I,B,C,D,a,b,c,M,d,T){"use strict";
var e=D.extend("sap.ui.fl.transport.TransportDialog",{
metadata:{library:"sap.ui.fl",properties:{pkg:{type:"string",group:"Misc",defaultValue:null},transports:{type:"any",group:"Misc",defaultValue:null},lrepObject:{type:"any",group:"Misc",defaultValue:null},hidePackage:{type:"boolean",group:"Misc",defaultValue:null}},events:{ok:{},cancel:{}}},
renderer:a.render
});
e.prototype.init=function(){D.prototype.init.apply(this);this._oResources=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE"));this._oPackageLabel=null;this._oPackage=this._createPackageField();this._oTransport=this._createTransportCombo();this.addContent(this._createContentList());this._createButtons();};
e.prototype._createContentList=function(){this._oPackageListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE"),content:[this._oPackage]});this._oTransportListItem=new I({label:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT"),content:[this._oTransport]});return new L({items:[this._oPackageListItem,this._oTransportListItem]});};
e.prototype._createButtons=function(){var t=this;this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_LOCAL_OBJECT"),press:function(){t._onLocal();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_OK"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_OK"),enabled:false,press:function(){t._onOkay();}}));this.addButton(new B({text:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),tooltip:this._oResources.getText("TRANSPORT_DIALOG_CANCEL"),press:function(){t.fireCancel();t.close();t.destroy();}}));};
e.prototype._onLocal=function(){this.fireOk({selectedTransport:"",selectedPackage:this.getPkg()||"$TMP",dialog:true});this.close();this.destroy();};
e.prototype._onOkay=function(){var t=this._oTransport.getSelectedKey();if(this._checkOkay(t)){this.fireOk({selectedTransport:t,selectedPackage:this.getPkg()||this._oPackage.getValue(),dialog:true});this.close();this.destroy();}else{this.getButtons()[1].setEnabled(false);this._oTransport.setValueState(sap.ui.core.ValueState.Error);this._oTransport.setValueStateText(this.getTitle());}};
e.prototype._checkOkay=function(t){if(t){return true;}return false;};
e.prototype._createTransportCombo=function(){var t=this;return new C({showSecondaryValues:true,enabled:false,tooltip:this._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"),width:"100%",selectionChange:function(){if(t._oPackageListItem.getVisible()&&!t._oPackage.getValue()){return;}t.getButtons()[1].setEnabled(true);t._oTransport.setValueState(sap.ui.core.ValueState.None);},change:function(E){var f=function(i){if((i&&E.mParameters.newValue!==i.getText())||!i){return true;}return false;};if(E&&E.mParameters&&E.mParameters.newValue){if(f(t._oTransport.getSelectedItem())){t.getButtons()[1].setEnabled(false);t._oTransport.setValueState(sap.ui.core.ValueState.Error);t._oTransport.setValueStateText(t._oResources.getText("TRANSPORT_DIALOG_TRANSPORT_TT"));}}}});};
e.prototype._createPackageField=function(){var t=this;return new b({tooltip:this._oResources.getText("TRANSPORT_DIALOG_PACKAGE_TT"),width:"100%",change:function(){var o,p,O;O=t._createObjectInfo();o=new sap.ui.fl.transport.Transports();p=o.getTransports(O);p.then(function(r){t._onPackageChangeSuccess(r);},function(r){t._onPackageChangeError(r);});},liveChange:function(E){if(E.mParameters.liveValue&&E.mParameters.liveValue.length>3){t._oTransport.setEnabled(true);}}});};
e.prototype._createObjectInfo=function(){var o,r={"package":this._oPackage.getValue()||""};o=this.getProperty("lrepObject");if(o){if(o.name){r.name=o.name;}if(o.type){r.type=o.type;}if(o.namespace){r.namespace=o.namespace;}}return r;};
e.prototype._onPackageChangeSuccess=function(t){if(t){if(t.localonly){this._oTransport.setEnabled(false);this.getButtons()[1].setEnabled(true);}else if(t.transports&&t.transports.length>0){this._oTransport.setEnabled(true);this._setTransports(t);}else if(t.errorCode){this.getButtons()[1].setEnabled(false);this._oPackage.setValueState(sap.ui.core.ValueState.Error);this._oPackage.setValueStateText(this._oResources.getText("TRANSPORT_DIALOG_"+t.errorCode));this._setTransports(t);}else{M.show(this._oResources.getText("TRANSPORT_DIALOG_NO_TRANSPORTS"));}}};
e.prototype._setTransports=function(t){var l,f;l=this._hasLock(t.transports);if(l){f=[l];}else{f=t.transports;}this.setTransports(f);if(f&&f.length===1){this._oTransport.setValue(f[0].description,true);this.getButtons()[1].setEnabled(true);}if(!f||f.length===0){this._oTransport.setSelectedKey(null);this._oTransport.setValueState(sap.ui.core.ValueState.None);this.getButtons()[1].setEnabled(false);}};
e.prototype._onPackageChangeError=function(r){M.show(r);this.setTransports([]);};
e.prototype._hasLock=function(t){var o,l=t.length;while(l--){o=t[l];if(o.locked){return o;}}return null;};
e.prototype.setPkg=function(p){if(p&&!this.getProperty("pkg")){this.setProperty("pkg",p);this._oPackage.setValue(p);this._oPackage.setEnabled(false);this._oTransport.setEnabled(true);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));this.getButtons()[0].setVisible(false);}};
e.prototype.setTransports=function(s){var i,l=0,o;if(s){this.setProperty("transports",s);this._oTransport.removeAllItems();l=s.length;for(i=0;i<l;i++){o=s[i];this._oTransport.addItem(new d({key:o.transportId,text:o.transportId,additionalText:o.description}));}if(l===1){this._oTransport.setSelectedKey(s[0].transportId);this.getButtons()[1].setEnabled(true);}if(l>0){this._oTransport.setEnabled(true);}}};
e.prototype.setLrepObject=function(o){if(o&&!this.getProperty("lrepObject")){this.setProperty("lrepObject",o);}};
e.prototype.setHidePackage=function(h){this.setProperty("hidePackage",h);this._oPackageListItem.setVisible(!h);if(h){this.getButtons()[0].setEnabled(h);this.setTitle(this._oResources.getText("TRANSPORT_DIALOG_TITLE_SIMPLE"));}};
return e;},true);
sap.ui.predefine('sap/ui/fl/transport/TransportSelection',["jquery.sap.global","sap/ui/fl/Utils","sap/ui/fl/transport/Transports","sap/ui/fl/transport/TransportDialog","sap/ui/fl/registry/Settings"],function(q,U,T,a,F){"use strict";var b=function(){this.oTransports=new sap.ui.fl.transport.Transports();};
b.prototype.selectTransport=function(o,O,e,c,C,s){var t=this;if(o){var l=U.getCurrentLayer(false);if(l&&l==='CUSTOMER'){F.getInstance().then(function(S){if(S.isAtoEnabled()){var d={transportId:"ATO_NOTIFICATION"};O(t._createEventObject(o,d));}else{t._selectTransport(o,O,e,c,s);}});}else{t._selectTransport(o,O,e,c,s);}}};
b.prototype._selectTransport=function(o,O,e,c,s){var t=this;if(o){this.oTransports.getTransports(o).then(function(g){var d;if(t._checkDialog(g)){t._openDialog({hidePackage:!U.doesSharedVariantRequirePackage(),pkg:o.package,transports:g.transports,lrepObject:t._toLREPObject(o)},O,e,c,s);}else{d=t._getTransport(g);O(t._createEventObject(o,d));}},function(r){e(r);});}};
b.prototype._createEventObject=function(o,t){return{mParameters:{selectedTransport:t.transportId,selectedPackage:o["package"],dialog:false},getParameters:function(){return this.mParameters;},getParameter:function(n){return this.mParameters[n];}};};
b.prototype._toLREPObject=function(o){var O={};if(o.namespace){O.namespace=o.namespace;}if(o.name){O.name=o.name;}if(o.type){O.type=o.type;}return O;};
b.prototype._openDialog=function(c,o,e,C,s){var d=new a(c);d.attachOk(o);d.attachCancel(e);d.addStyleClass(s);if(C){d.addStyleClass("sapUiSizeCompact");}else{d.removeStyleClass("sapUiSizeCompact");}d.open();return d;};
b.prototype._getTransport=function(t){var o;if(!t.localonly){o=this._hasLock(t.transports);}else{o={transportId:""};}return o;};
b.prototype._checkDialog=function(t){if(t){if(t.localonly||this._hasLock(t.transports)){return false;}}return true;};
b.prototype._hasLock=function(t){var l=t.length;while(l--){var o=t[l];if(o.locked){return o;}}return false;};
b.prototype.setTransports=function(c,C){var i=c.length-1;var t=this;var s=function(c,i,C,d,f){if(i>=0){var o=c[i];if(f===true){if(o.getDefinition().packageName!=="$TMP"){o.setRequest(d);}i--;return s(c,i,C,d,f);}else{if(o.getDefinition().packageName!=="$TMP"){return t.openTransportSelection(o,C).then(function(e){o.setRequest(e.transport);if(e.fromDialog===true){d=e.transport;f=true;}i--;return s(c,i,C,d,f);},function(){return null;});}else{i--;return s(c,i,C,d,f);}}}else{return Promise.resolve();}};return s(c,i,C);};
b.prototype.openTransportSelection=function(c,C,s){var t=this;return new Promise(function(r,d){var o=function(R){if(R&&R.getParameters){var f=R.getParameters().selectedTransport;var p=R.getParameters().selectedPackage;var g=R.getParameters().dialog;var h={transport:f,packageName:p,fromDialog:g};r(h);}else{r({});}};var e=function(E){if(E.sId==='cancel'){r();}else{d(E);}};var O={};if(c){O["package"]=c.getPackage();O.namespace=c.getNamespace();O.name=c.getId();O.type=c.getDefinition().fileType;}t.selectTransport(O,o,e,false,C,s);});};
b.prototype.checkTransportInfo=function(t){return t&&t.transport&&t.packageName!=="$TMP";};
b.prototype._prepareChangesForTransport=function(t,A){if(A.length>0){var o=new T();var c=o._convertToChangeTransportData(A);var d={};d.package=t.packageName;d.transportId=t.transport;d.changeIds=c;return o.makeChangesTransportable(d).then(function(){A.forEach(function(C){if(C.getPackage()==='$TMP'){var D=C.getDefinition();D.packageName=t.packageName;C.setResponse(D);}});return Promise.resolve();});}};
return b;},true);
sap.ui.predefine('sap/ui/fl/transport/Transports',["sap/ui/fl/LrepConnector","sap/ui/fl/Utils"],function(L,F){"use strict";var T=function(){};
T.prototype.getTransports=function(p){var u,c,l,P;u='/sap/bc/lrep/actions/gettransports/';if(p['package']){u+='&package='+p['package'];}if(p.name){u+='&name='+p.name;}if(p.namespace){u+='&namespace='+p.namespace;}if(p.type){u+='&type='+p.type;}c=F.getClient();if(c){u+='&sap-client='+c;}u=u.replace('&','?');l=L.createConnector();P=l.send(u);return P.then(function(r){if(r.response){if(!r.response.localonly){r.response.localonly=false;}if(!r.response.errorCode){r.response.errorCode="";}return Promise.resolve(r.response);}else{return Promise.reject('response is empty');}});};
T.prototype.makeChangesTransportable=function(p){var u,c,l;u='/sap/bc/lrep/actions/make_changes_transportable/';c=F.getClient();if(c){u+='?sap-client='+c;}if(!p.transportId){return Promise.reject(new Error("no transportId provided as attribute of mParameters"));}if(!p.changeIds){return Promise.reject(new Error("no changeIds provided as attribute of mParameters"));}l=L.createConnector();return l.send(u,'POST',p);};
T.prototype._convertToChangeTransportData=function(l){var t=[];var a=l.length;for(var i=0;i<a;i++){var c=l[i];var d={};d.namespace=c.getNamespace();d.fileName=c.getId();d.fileType=c.getDefinition().fileType;t.push(d);}return t;};
return T;},true);
sap.ui.predefine('sap/ui/fl/variants/VariantController',["jquery.sap.global","sap/ui/fl/Utils","sap/ui/fl/Change","sap/ui/fl/Variant","sap/ui/fl/Cache"],function(q,U,C,V,a){"use strict";var b=function(c,A,o){this._sComponentName=c||"";this._sAppVersion=A||U.DEFAULT_APP_VERSION;this._mVariantManagement={};this._setChangeFileContent(o,{});this.sVariantTechnicalParameterName="sap-ui-fl-control-variant-id";this._oResourceBundle=sap.ui.getCore().getLibraryResourceBundle("sap.ui.fl");};
b.prototype.getComponentName=function(){return this._sComponentName;};
b.prototype.getAppVersion=function(){return this._sAppVersion;};
b.prototype._setChangeFileContent=function(c,t){var o=a.getEntry(this.getComponentName(),this.getAppVersion());if(Object.keys(this._mVariantManagement).length===0){this._mVariantManagement={};}if(c&&c.changes&&c.changes.variantSection){Object.keys(c.changes.variantSection).forEach(function(v){this._mVariantManagement[v]={};var d=c.changes.variantSection[v];var e=d.variants.concat();var s;var i=-1;e.forEach(function(f,g){if(f.content.fileName===v){i=g;}if(!f.content.content.favorite){f.content.content.favorite=true;}if(!f.content.content.visible){f.content.content.visible=true;}var T=f.content.content.title.match(/.i18n>(\w+)./);if(T){f.content.content.title=this._oResourceBundle.getText(T[1]);}this._applyChangesOnVariant(f);if(t&&Array.isArray(t[this.sVariantTechnicalParameterName])){t[this.sVariantTechnicalParameterName].some(function(u){if(f.content.fileName===u){s=f.content.fileName;return true;}});}}.bind(this));if(i>-1){var S=e.splice(i,1)[0];e.sort(this.compareVariants);e.splice(0,0,S);}this._mVariantManagement[v].variants=e;this._mVariantManagement[v].defaultVariant=v;if(s){this._mVariantManagement[v].currentVariant=s;}this._mVariantManagement[v].variantManagementChanges=c.changes.variantSection[v].variantManagementChanges;this._applyChangesOnVariantManagement(this._mVariantManagement[v]);}.bind(this));o.file.changes.variantSection=this._mVariantManagement;}};
b.prototype._getChangeFileContent=function(){return this._mVariantManagement;};
b.prototype.compareVariants=function(v,o){if(v.content.content.title.toLowerCase()<o.content.content.title.toLowerCase()){return-1;}else if(v.content.content.title.toLowerCase()>o.content.content.title.toLowerCase()){return 1;}else{return 0;}};
b.prototype.getVariants=function(v){var c=this._mVariantManagement[v]&&this._mVariantManagement[v].variants;return c?c:[];};
b.prototype.getVariant=function(v,s){var o;var c=this.getVariants(v);c.some(function(d,i){if(d.content.fileName===s){o=d;return true;}});return o;};
b.prototype.getVariantChanges=function(v,s){var c=s||this._mVariantManagement[v].defaultVariant;var d=this.getVariants(v);var f=d.filter(function(o){return o.content.fileName===c;});return f.reduce(function(r,o){return o.controlChanges?r.concat(o.controlChanges):r;},[]);};
b.prototype._getReferencedChanges=function(v,c){var r=[];if(c.content.variantReference){r=this.getVariantChanges(v,c.content.variantReference);return r.filter(function(R){return U.isLayerAboveCurrentLayer(R.layer)===-1;});}return r;};
b.prototype.setVariantChanges=function(v,s,c){if(!v||!s||!q.isArray(c)){U.log.error("Cannot set variant changes without Variant reference");return;}return this._mVariantManagement[v].variants.some(function(o,i){if(o.content.fileName===s){o.controlChanges=c;return true;}});};
b.prototype._setVariantData=function(c,v,p){var d=this._mVariantManagement[v].variants;var o=d[p];Object.keys(c).forEach(function(P){if(o.content.content[P]){o.content.content[P]=c[P];}});if(o.content.fileName!==v){d.splice(p,1);var s=this._getIndexToSortVariant(d.slice(1),o);d.splice(s+1,0,o);return s+1;}else{d.splice(p,1,o);return p;}};
b.prototype._updateChangesForVariantManagementInMap=function(c,v,A){var o=this._mVariantManagement[v];var s=c.changeType;if(c.fileType==="ctrl_variant_change"){o.variants.some(function(d){if(d.content.fileName===c.selector.id){if(!d.variantChanges[s]){d.variantChanges[s]=[];}if(A){d.variantChanges[s].push(c);}else{d.variantChanges[s].some(function(e,i){if(e.fileName===c.fileName){d.variantChanges[s].splice(i,1);return true;}});}return true;}});}else if(c.fileType==="ctrl_variant_management_change"){if(!o.variantManagementChanges){o.variantManagementChanges={};}if(!o.variantManagementChanges[s]){o.variantManagementChanges[s]=[];}if(A){o.variantManagementChanges[s].push(c);}else{o.variantManagementChanges[s].some(function(e,i){if(e.fileName===c.fileName){o.variantManagementChanges[s].splice(i,1);return true;}});}}};
b.prototype.loadInitialChanges=function(){var i=[];Object.keys(this._mVariantManagement).forEach(function(v){var I=[];var s;if(this._mVariantManagement[v].currentVariant){s=this._mVariantManagement[v].currentVariant;}else{s=this._mVariantManagement[v].defaultVariant;}var c=this.getVariant(v,s).content.content.visible;if(!c){if(this._mVariantManagement[v].currentVariant){this._mVariantManagement[v].currentVariant=v;}else{this._mVariantManagement[v].defaultVariant=v;}s=v;}I=this.getVariantChanges(v,s);i=i.concat(I);}.bind(this));return i;};
b.prototype.getChangesForVariantSwitch=function(v,c,n,m){var d=this.getVariantChanges(v,c);var M=[],e=[];Object.keys(m).forEach(function(f){m[f].forEach(function(o){M=M.concat(o);e=e.concat(o.getId());});});d=d.reduce(function(f,o,i){var g=e.indexOf(o.fileName);if(g>-1){f=f.concat(M[g]);}return f;},[]);var N=this.getVariantChanges(v,n).map(function(o){return new C(o);});var r=[];if(N.length>0){r=d.slice();d.some(function(o){if(N[0]&&o.getId()===N[0].getId()){N.shift();r.shift();}else{return true;}});}else{r=d;}var s={aRevert:r.reverse(),aNew:N};return s;};
b.prototype._applyChangesOnVariant=function(v){var m=v.variantChanges,A;Object.keys(m).forEach(function(c){switch(c){case"setTitle":A=this._getActiveChange(c,m);if(A){v.content.content.title=A.getText("title");}break;case"setFavorite":A=this._getActiveChange(c,m);if(A){v.content.content.favorite=A.getContent().favorite;}break;case"setVisible":A=this._getActiveChange(c,m);if(A){v.content.content.visible=A.getContent().visible;}break;default:U.log.error("No valid changes on variant "+v.content.content.title+" available");}}.bind(this));};
b.prototype._applyChangesOnVariantManagement=function(v){var m=v.variantManagementChanges,A;if(Object.keys(m).length>0){A=this._getActiveChange("setDefault",m);if(A){v.defaultVariant=A.getContent().defaultVariant;}}};
b.prototype._getActiveChange=function(c,m){var l=m[c].length-1;if(l>-1){return new C(m[c][l]);}return false;};
b.prototype._fillVariantModel=function(){var v={};Object.keys(this._mVariantManagement).forEach(function(k){v[k]={defaultVariant:this._mVariantManagement[k].defaultVariant,variants:[]};if(this._mVariantManagement[k].currentVariant){v[k].currentVariant=this._mVariantManagement[k].currentVariant;}this.getVariants(k).forEach(function(o,i){v[k].variants[i]=JSON.parse(JSON.stringify({key:o.content.fileName,title:o.content.content.title,layer:o.content.layer,favorite:o.content.content.favorite,visible:o.content.content.visible}));});}.bind(this));return v;};
b.prototype.updateCurrentVariantInMap=function(v,n){this._mVariantManagement[v].currentVariant=n;};
b.prototype.addChangeToVariant=function(c,v,s){var n=this.getVariantChanges(v,s);var d=n.map(function(c){return c.fileName;});var i=d.indexOf(c.getDefinition().fileName);if(i===-1){n.push(c.getDefinition());return this.setVariantChanges(v,s,n);}return false;};
b.prototype.removeChangeFromVariant=function(c,v,s){var n=this.getVariantChanges(v,s);n.forEach(function(o,i){var d=new C(o);if(d.getId&&(d.getId()===c.getId())){n.splice(i,1);}});return this.setVariantChanges(v,s,n);};
b.prototype.addVariantToVariantManagement=function(v,s){var c=this._mVariantManagement[s].variants.slice().splice(1);var i=this._getIndexToSortVariant(c,v);if(v.content.variantReference){var r=this._getReferencedChanges(s,v);v.controlChanges=r.concat(v.controlChanges);}this._mVariantManagement[s].variants.splice(i+1,0,v);return i+1;};
b.prototype._getIndexToSortVariant=function(v,o){var i=0;v.some(function(e,c){if(this.compareVariants(o,e)<0){i=c;return true;}i=c+1;}.bind(this));return i;};
b.prototype.removeVariantFromVariantManagement=function(v,s){var i;var f=this._mVariantManagement[s].variants.some(function(c,d){var o=new V(c);if(o.getId()===v.getId()){i=d;return true;}});if(f){this._mVariantManagement[s].variants.splice(i,1);}return i;};
return b;},true);
sap.ui.predefine('sap/ui/fl/variants/util/VariantUtil',["jquery.sap.global","sap/ui/core/Component","sap/ui/fl/Utils","sap/ui/core/routing/History","sap/ui/core/routing/HashChanger","sap/base/Log","sap/base/util/equal"],function(q,C,f,H,a,L,e){"use strict";var v="sap-ui-fl-control-variant-id";var V={initializeHashRegister:function(){this._oHashRegister={currentIndex:null,hashParams:[]};V._setOrUnsetCustomNavigationForParameter.call(this,true);},attachHashHandlers:function(){if(this._oHashRegister.currentIndex===null){var h=a.getInstance();h.attachEvent("hashReplaced",V._handleHashReplaced,this);h.attachEvent("hashChanged",V._navigationHandler,this);var o=this.oComponent.destroy;this.oComponent.destroy=function(){V._setOrUnsetCustomNavigationForParameter.call(this,false);h.detachEvent("hashReplaced",V._handleHashReplaced,this);h.detachEvent("hashChanged",V._navigationHandler,this);this.destroy();o.apply(this.oComponent,arguments);}.bind(this);V._navigationHandler.call(this);}},updateHasherEntry:function(p){if(!p||!Array.isArray(p.parameters)){L.info("Variant URL parameters could not be updated since invalid parameters were received");return;}if(p.updateURL){f.setTechnicalURLParameterValues(p.component||this.oComponent,v,p.parameters);}if(!p.ignoreRegisterUpdate){this._oHashRegister.hashParams[this._oHashRegister.currentIndex]=p.parameters;}},_handleHashReplaced:function(E){this._sReplacedHash=E.getParameter("sHash");},_navigationHandler:function(E){var d;var n=E&&E.getParameter("newHash");if(n&&this._sReplacedHash===n){delete this._sReplacedHash;return;}if(this._oHashRegister.currentIndex===null){this._oHashRegister.currentIndex=0;d="NewEntry";}else{d=H.getInstance().getDirection();switch(d){case"Backwards":this._oHashRegister.currentIndex--;break;case"Forwards":case"NewEntry":this._oHashRegister.currentIndex++;break;case"Unknown":this._oHashRegister.currentIndex=0;this._oHashRegister.hashParams=[];this.switchToDefaultVariant();break;default:return;}}if(this._oHashRegister.currentIndex>=0){var b;var p={};if(d==="NewEntry"||d==="Unknown"){var h=f.getParsedURLHash()&&f.getParsedURLHash().params;b=(h&&h[v])||[];var c=this._oHashRegister.hashParams[this._oHashRegister.currentIndex];if(Array.isArray(c)){c.forEach(function(P){this.switchToDefaultVariant(P);}.bind(this));}p={parameters:b};}else{b=this._oHashRegister.hashParams[this._oHashRegister.currentIndex];p={parameters:b,updateURL:true,ignoreRegisterUpdate:true};}}else{p={parameters:[],updateURL:true,ignoreRegisterUpdate:true};}this.updateHasherEntry(p);},_setOrUnsetCustomNavigationForParameter:function(s){var m=s?"registerNavigationFilter":"unregisterNavigationFilter";var u=f.getUshellContainer();if(u){u.getService("ShellNavigation")[m](V._navigationFilter);}},_navigationFilter:function(n,o){var u=f.getUshellContainer();var U=u.getService("URLParsing");var s=u.getService("ShellNavigation");var O=U.parseShellHash(o);var N=U.parseShellHash(n);var S=O&&N&&!e(O.params[v],N.params[v]);if(S){for(var k in O){if(k!=="params"&&k!=="appSpecificRoute"&&O[k]!==N[k]){S=false;break;}}}if(S){S=false;[O,N].forEach(function(p){if(p.params.hasOwnProperty(v)){S=true;if(Object.keys(p.params).length!==1){S=false;}}else if(Object.keys(p.params).length!==0){S=false;}});}if(S){var A=(N.appSpecificRoute||"  ").substring(2);var b=(O.appSpecificRoute||"  ").substring(2);s.hashChanger.fireEvent("hashChanged",{newHash:A,oldHash:b});return{status:s.NavigationFilterStatus.Custom};}return s.NavigationFilterStatus.Continue;},getCurrentHashParamsFromRegister:function(){if(q.isNumeric(this._oHashRegister.currentIndex)){return this._oHashRegister.hashParams[this._oHashRegister.currentIndex];}}};return V;},true);
sap.ui.require.preload({
	"sap/ui/fl/manifest.json":'{"_version":"1.9.0","sap.app":{"id":"sap.ui.fl","type":"library","embeds":["support/apps/contentbrowser"],"applicationVersion":{"version":"1.56.5"},"title":"SAPUI5 library with sap.ui.fl controls.","description":"SAPUI5 library with sap.ui.fl controls.","ach":"CA-UI5-FL","resources":"resources.json","offline":true},"sap.ui":{"technology":"UI5","supportedThemes":["base"]},"sap.ui5":{"dependencies":{"minUI5Version":"1.56","libs":{"sap.ui.core":{"minVersion":"1.56.5"},"sap.m":{"minVersion":"1.56.5"}}},"library":{"i18n":"messagebundle.properties","content":{"controls":["sap.ui.fl.variants.VariantManagement"]}}}}'
},"sap/ui/fl/library-preload"
);
//# sourceMappingURL=library-preload.js.map