/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/core/Control','./Form','./FormContainer','./FormElement','./FormLayout','sap/ui/base/ManagedObjectObserver','sap/ui/layout/library','sap/ui/core/ResizeHandler','./SimpleFormRenderer'],function(q,C,F,a,b,c,M,l,R,S){"use strict";var B=l.BackgroundDesign;var d=l.form.SimpleFormLayout;var e;var f;var g;var G;var h;var m;var n;var o=C.extend("sap.ui.layout.form.SimpleForm",{metadata:{library:"sap.ui.layout",properties:{maxContainerCols:{type:"int",group:"Appearance",defaultValue:2},minWidth:{type:"int",group:"Appearance",defaultValue:-1},width:{type:"sap.ui.core.CSSSize",group:"Dimension",defaultValue:null},editable:{type:"boolean",group:"Misc",defaultValue:null},labelMinWidth:{type:"int",group:"Misc",defaultValue:192},layout:{type:"sap.ui.layout.form.SimpleFormLayout",group:"Misc",defaultValue:d.ResponsiveLayout},labelSpanXL:{type:"int",group:"Misc",defaultValue:-1},labelSpanL:{type:"int",group:"Misc",defaultValue:4},labelSpanM:{type:"int",group:"Misc",defaultValue:2},labelSpanS:{type:"int",group:"Misc",defaultValue:12},adjustLabelSpan:{type:"boolean",group:"Misc",defaultValue:true},emptySpanXL:{type:"int",group:"Misc",defaultValue:-1},emptySpanL:{type:"int",group:"Misc",defaultValue:0},emptySpanM:{type:"int",group:"Misc",defaultValue:0},emptySpanS:{type:"int",group:"Misc",defaultValue:0},columnsXL:{type:"int",group:"Misc",defaultValue:-1},columnsL:{type:"int",group:"Misc",defaultValue:2},columnsM:{type:"int",group:"Misc",defaultValue:1},singleContainerFullSize:{type:"boolean",group:"Misc",defaultValue:true},breakpointXL:{type:"int",group:"Misc",defaultValue:1440},breakpointL:{type:"int",group:"Misc",defaultValue:1024},breakpointM:{type:"int",group:"Misc",defaultValue:600},backgroundDesign:{type:"sap.ui.layout.BackgroundDesign",group:"Appearance",defaultValue:B.Translucent}},defaultAggregation:"content",aggregations:{content:{type:"sap.ui.core.Element",multiple:true,singularName:"content"},form:{type:"sap.ui.layout.form.Form",multiple:false,visibility:"hidden"},title:{type:"sap.ui.core.Title",altTypes:["string"],multiple:false},toolbar:{type:"sap.ui.core.Toolbar",multiple:false}},associations:{ariaLabelledBy:{type:"sap.ui.core.Control",multiple:true,singularName:"ariaLabelledBy"}},designtime:"sap/ui/layout/designtime/form/SimpleForm.designtime"}});o.prototype.init=function(){this._iMaxWeight=8;this._iLabelWeight=3;this._iCurrentWidth=0;var i=new F(this.getId()+"--Form");i.getTitle=function(){return this.getParent().getTitle();};i._origInvalidate=i.invalidate;i.invalidate=function(j){if(this.bOutput){this._origInvalidate(j);}if(this._bIsBeingDestroyed){return;}var k=this.getParent();if(k){k._formInvalidated(j);}};i.getAriaLabelledBy=function(){var j=this.getParent();if(j){return j.getAriaLabelledBy();}else{return null;}};i._origOnLayoutDataChange=i.onLayoutDataChange;i.onLayoutDataChange=function(j){this._origOnLayoutDataChange(j);var k=this.getParent();if(k){k._onLayoutDataChange(j);}};this.setAggregation("form",i);this._aElements=null;this._aLayouts=[];this._changedFormContainers=[];this._changedFormElements=[];this._oObserver=new M(V.bind(this));};o.prototype.exit=function(){var j=this.getAggregation("form");j.invalidate=j._origInvalidate;T.call(this);for(var i=0;i<this._aLayouts.length;i++){var k=sap.ui.getCore().byId(this._aLayouts[i]);if(k&&k.destroy){k.destroy();}}this._aLayouts=[];this._aElements=null;this._changedFormContainers=[];this._changedFormElements=[];this._oObserver.disconnect();this._oObserver=undefined;};o.prototype.onBeforeRendering=function(){T.call(this);var i=this.getAggregation("form");if(!this._bResponsiveLayoutRequested&&!this._bGridLayoutRequested&&!this._bResponsiveGridLayoutRequested&&!this._bColumnLayoutRequested){var j=true;if(!i.getLayout()){j=_.call(this);}if(j){x.call(this);}}};o.prototype.onAfterRendering=function(){if(this.getLayout()==d.ResponsiveLayout){this._bChangedByMe=true;this.$().css("visibility","hidden");this._applyLinebreaks();this._sResizeListenerId=R.register(this.getDomRef(),q.proxy(this._resize,this));this._bChangedByMe=false;}};o.prototype.setEditable=function(i){this._bChangedByMe=true;this.setProperty("editable",i,true);var j=this.getAggregation("form");j.setEditable(i);this._bChangedByMe=false;return this;};o.prototype.setToolbar=function(i){this._bChangedByMe=true;var j=this.getAggregation("form");j.setToolbar(i);this._bChangedByMe=false;return this;};o.prototype.getToolbar=function(){var i=this.getAggregation("form");return i.getToolbar();};o.prototype.destroyToolbar=function(){this._bChangedByMe=true;var i=this.getAggregation("form");i.destroyToolbar();this._bChangedByMe=false;return this;};o.prototype.setLabelMinWidth=function(j){this.setProperty("labelMinWidth",j,true);if(this.getLayout()==d.ResponsiveLayout){this._bLayoutDataChangedByMe=true;var k=this.getContent();for(var i=0;i<k.length;i++){var X=k[i];if(X.isA("sap.ui.core.Label")){var Y=A.call(this,X);if(Y&&Y.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&y.call(this,Y)){Y.setMinWidth(j);}}}this._bLayoutDataChangedByMe=false;}return this;};o.prototype.indexOfContent=function(j){var k=this._aElements;if(k){for(var i=0;i<k.length;i++){if(k[i]==j){return i;}}}return-1;};o.prototype.addContent=function(i){i=this.validateAggregation("content",i,true);if(this.indexOfContent(i)>=0){q.sap.log.warning("SimpleForm.addContent: Content element '"+i+"' already assigned. Please remove before adding!",this);this.removeContent(i);}if(!this._aElements){this._aElements=[];}this._bChangedByMe=true;var j=this._aElements.length;var k;var X=this.getAggregation("form");var Y;var Z;var $;var a1;if(i.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){Y=O.call(this,i);X.addFormContainer(Y);this._changedFormContainers.push(Y);}else if(i.isA("sap.ui.core.Label")){if(j>0){k=this._aElements[j-1];$=k.getParent();if($ instanceof b){Y=$.getParent();}else if($ instanceof a){Y=$;}}if(!Y){Y=O.call(this);X.addFormContainer(Y);this._changedFormContainers.push(Y);}Z=K.call(this,Y,i);}else{if(j>0){k=this._aElements[j-1];$=k.getParent();if($ instanceof b){Y=$.getParent();Z=$;a1=A.call(this,i);if(a1&&a1.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!y.call(this,a1)&&a1.getLinebreak()){Z=K.call(this,Y);}}else if($ instanceof a){Y=$;Z=K.call(this,Y);}}else{Y=O.call(this);X.addFormContainer(Y);this._changedFormContainers.push(Y);Z=K.call(this,Y);}E.call(this,i,5,false,true);Z.addField(i);U(this._changedFormElements,Z);}this._aElements.push(i);this._oObserver.observe(i,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this;};o.prototype.insertContent=function(j,k){j=this.validateAggregation("content",j,true);if(this.indexOfContent(j)>=0){q.sap.log.warning("SimpleForm.insertContent: Content element '"+j+"' already assigned. Please remove before insert!",this);this.removeContent(j);}if(!this._aElements){this._aElements=[];}var X=this._aElements.length;var Y;if(k<0){Y=0;}else if(k>X){Y=X;}else{Y=k;}if(Y!==k){q.sap.log.warning("SimpleForm.insertContent: index '"+k+"' out of range [0,"+X+"], forced to "+Y);}if(Y==X){this.addContent(j);return this;}this._bChangedByMe=true;var Z=this._aElements[Y];var $=this.getAggregation("form");var a1;var b1;var c1;var d1;var e1;var f1=0;var g1;var h1;var i1;var j1;var i=0;var k1;var l1;if(j.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){if(k==0&&!(Z.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"]))){a1=Z.getParent().getParent();if(j.isA("sap.ui.core.Title")){a1.setTitle(j);}else{a1.setToolbar(j);}}else{a1=O.call(this,j);if(Z.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){c1=Z.getParent();e1=$.indexOfFormContainer(c1);}else{d1=Z.getParent();c1=d1.getParent();e1=$.indexOfFormContainer(c1)+1;f1=c1.indexOfFormElement(d1);if(!Z.isA("sap.ui.core.Label")){g1=d1.indexOfField(Z);if(g1>0||d1.getLabel()){b1=K.call(this,a1);this._changedFormElements.push(b1);U(this._changedFormElements,d1);h1=d1.getFields();for(i=g1;i<h1.length;i++){k1=h1[i];b1.addField(k1);}f1++;}}i1=c1.getFormElements();for(i=f1;i<i1.length;i++){a1.addFormElement(i1[i]);}}$.insertFormContainer(a1,e1);}this._changedFormContainers.push(a1);}else if(j.isA("sap.ui.core.Label")){if(Z.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){c1=Z.getParent();e1=$.indexOfFormContainer(c1);j1=$.getFormContainers();if(e1==0){a1=O.call(this);$.insertFormContainer(a1,e1);this._changedFormContainers.push(a1);}else{a1=j1[e1-1];}b1=K.call(this,a1,j);}else if(Z.isA("sap.ui.core.Label")){c1=Z.getParent().getParent();f1=c1.indexOfFormElement(Z.getParent());b1=L.call(this,c1,j,f1);}else{d1=Z.getParent();c1=d1.getParent();f1=c1.indexOfFormElement(d1)+1;g1=d1.indexOfField(Z);if(g1==0&&!d1.getLabel()){b1=d1;b1.setLabel(j);E.call(this,j,this._iLabelWeight,false,true,this.getLabelMinWidth());}else{b1=L.call(this,c1,j,f1);U(this._changedFormElements,d1);h1=d1.getFields();for(i=g1;i<h1.length;i++){k1=h1[i];b1.addField(k1);}}}this._changedFormElements.push(b1);}else{l1=A.call(this,j);if(Z.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){c1=Z.getParent();e1=$.indexOfFormContainer(c1);if(e1==0){a1=O.call(this);$.insertFormContainer(a1,e1);this._changedFormContainers.push(a1);}else{j1=$.getFormContainers();a1=j1[e1-1];}i1=a1.getFormElements();if(i1.length==0){b1=K.call(this,a1);}else if(l1&&l1.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!y.call(this,l1)&&l1.getLinebreak()){b1=K.call(this,a1);}else{b1=i1[i1.length-1];}b1.addField(j);}else if(Z.isA("sap.ui.core.Label")){d1=Z.getParent();a1=d1.getParent();f1=a1.indexOfFormElement(d1);if(f1==0){b1=L.call(this,a1,null,0);}else if(l1&&l1.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!y.call(this,l1)&&l1.getLinebreak()){b1=L.call(this,a1,null,f1);}else{i1=a1.getFormElements();b1=i1[f1-1];}b1.addField(j);}else{b1=Z.getParent();g1=b1.indexOfField(Z);if(l1&&l1.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!y.call(this,l1)&&l1.getLinebreak()&&g1>0){a1=b1.getParent();f1=a1.indexOfFormElement(b1);U(this._changedFormElements,b1);h1=b1.getFields();b1=L.call(this,a1,undefined,f1+1);b1.addField(j);for(i=g1;i<h1.length;i++){k1=h1[i];b1.addField(k1);}}else{b1.insertField(j,g1);}}U(this._changedFormElements,b1);E.call(this,j,5,false,true);}this._aElements.splice(Y,0,j);this._oObserver.observe(j,{properties:["visible"]});this.invalidate();this._bChangedByMe=false;return this;};o.prototype.removeContent=function(j){var k=null;var X=-1;var i=0;if(this._aElements){if(typeof(j)=="string"){j=sap.ui.getCore().byId(j);}if(typeof(j)=="object"){for(i=0;i<this._aElements.length;i++){if(this._aElements[i]==j){j=i;break;}}}if(typeof(j)=="number"){if(j<0||j>=this._aElements.length){q.sap.log.warning("Element.removeAggregation called with invalid index: Items, "+j);}else{X=j;k=this._aElements[X];}}}if(k){this._bChangedByMe=true;var Y=this.getAggregation("form");var Z;var $;var a1;var b1;if(k.isA(["sap.ui.core.Title","sap.ui.core.Toolbar"])){Z=k.getParent();Z.setTitle(null);Z.setToolbar(null);if(X>0){a1=Z.getFormElements();var c1=Y.indexOfFormContainer(Z);var d1=Y.getFormContainers()[c1-1];if(a1.length>0&&!a1[0].getLabel()){var e1=d1.getFormElements();var f1=e1[e1.length-1];b1=a1[0].getFields();for(i=0;i<b1.length;i++){f1.addField(b1[i]);}U(this._changedFormElements,f1);Z.removeFormElement(a1[0]);a1[0].destroy();a1.splice(0,1);}for(i=0;i<a1.length;i++){d1.addFormElement(a1[i]);}U(this._changedFormContainers,d1);Y.removeFormContainer(Z);Z.destroy();}else if(Z.getFormElements().length==0){Y.removeFormContainer(Z);Z.destroy();}}else if(k.isA("sap.ui.core.Label")){$=k.getParent();Z=$.getParent();$.setLabel(null);var g1=Z.indexOfFormElement($);if(g1==0){if($.getFields().length==0){Z.removeFormElement($);$.destroy();if(Z.getFormElements().length==0&&!Z.getTitle()&&!Z.getToolbar()){Y.removeFormContainer(Z);Z.destroy();}}else{U(this._changedFormElements,$);}}else{a1=Z.getFormElements();var h1=a1[g1-1];b1=$.getFields();for(i=0;i<b1.length;i++){h1.addField(b1[i]);}U(this._changedFormElements,h1);Z.removeFormElement($);$.destroy();}}else{$=k.getParent();$.removeField(k);if($.getFields().length==0&&!$.getLabel()){Z=$.getParent();Z.removeFormElement($);$.destroy();if(Z.getFormElements().length==0&&!Z.getTitle()&&!Z.getToolbar()){Y.removeFormContainer(Z);Z.destroy();}}else{U(this._changedFormElements,$);}}this._aElements.splice(X,1);k.setParent(null);this._oObserver.unobserve(k);J.call(this,k);this.invalidate();this._bChangedByMe=false;return k;}return null;};o.prototype.removeAllContent=function(){var i=0;if(this._aElements){this._bChangedByMe=true;var k=this.getAggregation("form");var X=k.getFormContainers();for(i=0;i<X.length;i++){var Y=X[i];Y.setTitle(null);Y.setToolbar(null);var Z=Y.getFormElements();for(var j=0;j<Z.length;j++){var $=Z[j];$.setLabel(null);$.removeAllFields();}Y.destroyFormElements();}k.destroyFormContainers();for(i=0;i<this._aElements.length;i++){var a1=this._aElements[i];J.call(this,a1);this._oObserver.unobserve(a1);}var b1=this._aElements;this._aElements=null;this.invalidate();this._bChangedByMe=false;return b1;}else{return[];}};o.prototype.destroyContent=function(){var j=this.removeAllContent();if(j){this._bChangedByMe=true;for(var i=0;i<j.length;i++){j[i].destroy();}this.invalidate();this._bChangedByMe=false;}return this;};o.prototype.getContent=function(){if(!this._aElements){this._aElements=this.getAggregation("content",[]);}return this._aElements.slice();};o.prototype.setLayout=function(i){var j=this.getLayout();if(i!=j){v.call(this);}this.setProperty("layout",i);if(i!=j){var k=_.call(this);if(k){w.call(this);}}return this;};o.prototype.clone=function(k){this._bChangedByMe=true;var X=C.prototype.clone.apply(this,arguments);var Y=this.getContent();for(var i=0;i<Y.length;i++){var Z=Y[i];var $=Z.getLayoutData();this._oObserver.unobserve(Z);var a1=Z.clone(k);this._oObserver.observe(Z,{properties:["visible"]});if($){if($.isA("sap.ui.core.VariantLayoutData")){var b1=$.getMultipleLayoutData();for(var j=0;j<b1.length;j++){if(y.call(this,b1[j])){X._aLayouts.push(a1.getLayoutData().getMultipleLayoutData()[j].getId());}}}else if(y.call(this,$)){X._aLayouts.push(a1.getLayoutData().getId());}}X.addContent(a1);}this._bChangedByMe=false;return X;};function _(){var i=this.getAggregation("form");if(i.getLayout()){this._bChangedByMe=true;i.destroyLayout();T.call(this);this._bChangedByMe=false;}var j;switch(this.getLayout()){case d.ResponsiveLayout:if((!e||!f)&&!this._bResponsiveLayoutRequested){e=sap.ui.require("sap/ui/layout/form/ResponsiveLayout");f=sap.ui.require("sap/ui/layout/ResponsiveFlowLayoutData");if(!e||!f){sap.ui.require(["sap/ui/layout/form/ResponsiveLayout","sap/ui/layout/ResponsiveFlowLayoutData"],p.bind(this));this._bResponsiveLayoutRequested=true;}}if(e&&f){j=new e(this.getId()+"--Layout");}break;case d.GridLayout:if((!G||!h||!m)&&!this._bGridLayoutRequested){G=sap.ui.require("sap/ui/layout/form/GridLayout");h=sap.ui.require("sap/ui/layout/form/GridContainerData");m=sap.ui.require("sap/ui/layout/form/GridElementData");if(!G||!h||!m){sap.ui.require(["sap/ui/layout/form/GridLayout","sap/ui/layout/form/GridContainerData","sap/ui/layout/form/GridElementData"],r.bind(this));this._bGridLayoutRequested=true;}}if(G&&h&&m){j=new G(this.getId()+"--Layout");}break;case d.ResponsiveGridLayout:if(!g&&!this._bResponsiveGridLayoutRequested){g=sap.ui.require("sap/ui/layout/form/ResponsiveGridLayout");if(!g){sap.ui.require(["sap/ui/layout/form/ResponsiveGridLayout"],s.bind(this));this._bResponsiveGridLayoutRequested=true;}}if(g){j=new g(this.getId()+"--Layout");}break;case d.ColumnLayout:if(!n&&!this._bColumnLayoutRequested){n=sap.ui.require("sap/ui/layout/form/ColumnLayout");if(!n){sap.ui.require(["sap/ui/layout/form/ColumnLayout"],t.bind(this));this._bColumnLayoutRequested=true;}}if(n){j=new n(this.getId()+"--Layout");}break;}if(j){this._bChangedByMe=true;i.setLayout(j);this._bChangedByMe=false;return true;}return false;}function p(i,j){e=i;f=j;this._bResponsiveLayoutRequested=false;if(this.getLayout()==d.ResponsiveLayout){u.call(this);}}function r(i,j,k){G=i;h=j;m=k;this._bGridLayoutRequested=false;if(this.getLayout()==d.GridLayout){u.call(this);}}function s(i){g=i;this._bResponsiveGridLayoutRequested=false;if(this.getLayout()==d.ResponsiveGridLayout){u.call(this);}}function t(i){n=i;this._bColumnLayoutRequested=false;if(this.getLayout()==d.ColumnLayout){u.call(this);}}function u(){if(!this._bIsBeingDestroyed){_.call(this);w.call(this);if(this.getDomRef()){x.call(this);}}}function v(){this._bChangedByMe=true;var X=this.getAggregation("form");var Y=X.getFormContainers();for(var i=0;i<Y.length;i++){var Z=Y[i];U(this._changedFormContainers,Z);if(Z.getLayoutData()){Z.destroyLayoutData();}var $=Z.getFormElements();for(var j=0;j<$.length;j++){var a1=$[j];U(this._changedFormElements,a1);if(a1.getLayoutData()){a1.destroyLayoutData();}var b1=a1.getLabel();if(b1){J.call(this,b1);}var c1=a1.getFields();for(var k=0;k<c1.length;k++){var d1=c1[k];J.call(this,d1);}}}this._bChangedByMe=false;}function w(){this._bChangedByMe=true;var X=this.getAggregation("form");var Y=X.getFormContainers();for(var i=0;i<Y.length;i++){var Z=Y[i];U(this._changedFormContainers,Z);I.call(this,Z);var $=Z.getFormElements();for(var j=0;j<$.length;j++){var a1=$[j];U(this._changedFormElements,a1);H.call(this,a1);var b1=a1.getLabel();if(b1){E.call(this,b1,this._iLabelWeight,false,true,this.getLabelMinWidth());}var c1=a1.getFields();for(var k=0;k<c1.length;k++){var d1=c1[k];E.call(this,d1,5,false,true);}}}this._bChangedByMe=false;}function x(){this._bChangedByMe=true;this._changedFormContainers=[];var j=this.getLayout();var k=this.getAggregation("form").getLayout();k.setBackgroundDesign(this.getBackgroundDesign());switch(j){case d.ResponsiveLayout:this._applyLinebreaks();for(var i=0;i<this._changedFormElements.length;i++){var X=this._changedFormElements[i];P.call(this,X);}break;case d.GridLayout:Q.call(this);break;case d.ResponsiveGridLayout:k.setLabelSpanXL(this.getLabelSpanXL());k.setLabelSpanL(this.getLabelSpanL());k.setLabelSpanM(this.getLabelSpanM());k.setLabelSpanS(this.getLabelSpanS());k.setAdjustLabelSpan(this.getAdjustLabelSpan());k.setEmptySpanXL(this.getEmptySpanXL());k.setEmptySpanL(this.getEmptySpanL());k.setEmptySpanM(this.getEmptySpanM());k.setEmptySpanS(this.getEmptySpanS());k.setColumnsXL(this.getColumnsXL());k.setColumnsL(this.getColumnsL());k.setColumnsM(this.getColumnsM());k.setSingleContainerFullSize(this.getSingleContainerFullSize());k.setBreakpointXL(this.getBreakpointXL());k.setBreakpointL(this.getBreakpointL());k.setBreakpointM(this.getBreakpointM());break;case d.ColumnLayout:k.setColumnsXL(this.getColumnsXL()>0?this.getColumnsXL():this.getColumnsL());k.setColumnsL(this.getColumnsL());k.setColumnsM(this.getColumnsM());k.setLabelCellsLarge(this.getLabelSpanL());k.setEmptyCellsLarge(this.getEmptySpanL());break;}this._changedFormElements=[];this._bChangedByMe=false;}function y(i){var j=i.getId(),k=" "+this._aLayouts.join(" ")+" ";return k.indexOf(" "+j+" ")>-1;}function z(i,j,k,X){var Y=new f({weight:i,linebreak:j===true,linebreakable:k===true});if(X){Y.setMinWidth(X);}this._aLayouts.push(Y.getId());return Y;}function A(i){var j;switch(this.getLayout()){case d.ResponsiveLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.ResponsiveFlowLayoutData");break;case d.GridLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.form.GridElementData");break;case d.ResponsiveGridLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.GridData");break;case d.ColumnLayout:j=c.prototype.getLayoutDataForElement(i,"sap.ui.layout.form.ColumnElementData");break;}return j;}function D(){if(this._bResponsiveLayoutRequested||this._bGridLayoutRequested||this._bResponsiveGridLayoutRequested||this._bColumnLayoutRequested){return false;}if(!this.getAggregation("form").getLayout()){var i=this._bChangedByMe;var j=_.call(this);this._bChangedByMe=i;if(!j){return false;}}return true;}function E(i,j,k,X,Y){if(this.getLayout()!=d.ResponsiveLayout){return;}if(!D.call(this)){return;}this._bLayoutDataChangedByMe=true;var Z=A.call(this,i);if(!Z||!y.call(this,Z)){Z=i.getLayoutData();if(Z&&Z.isA("sap.ui.core.VariantLayoutData")){Z.addMultipleLayoutData(z.call(this,j,k,X,Y));}else if(!Z){i.setLayoutData(z.call(this,j,k,X,Y));}else{q.sap.log.warning("ResponsiveFlowLayoutData can not be set on Field "+i.getId(),"_createFieldLayoutData","SimpleForm");}}this._bLayoutDataChangedByMe=false;}function H(i){if(this.getLayout()!=d.ResponsiveLayout){return;}if(!D.call(this)){return;}this._bLayoutDataChangedByMe=true;i.setLayoutData(new f({linebreak:true,margin:false}));this._bLayoutDataChangedByMe=false;}function I(i){var j=this.getLayout();if(j!=d.ResponsiveLayout&&j!=d.GridLayout){return;}if(!D.call(this)){return;}this._bLayoutDataChangedByMe=true;switch(j){case d.ResponsiveLayout:i.setLayoutData(new f({minWidth:280}));break;case d.GridLayout:if(this.getMaxContainerCols()>1){i.setLayoutData(new h({halfGrid:true}));}else{i.setLayoutData(new h({halfGrid:false}));}break;}this._bLayoutDataChangedByMe=false;}function J(j){this._bLayoutDataChangedByMe=true;var k=A.call(this,j);if(k){var X=k.getId();for(var i=0;i<this._aLayouts.length;i++){var Y=this._aLayouts[i];if(X==Y){k.destroy();this._aLayouts.splice(i,1);break;}}}this._bLayoutDataChangedByMe=false;}function K(i,j){var k=N.call(this,j);i.addFormElement(k);return k;}function L(i,j,k){var X=N.call(this,j);i.insertFormElement(X,k);return X;}function N(j){var k=new b();H.call(this,k);if(j){j.addStyleClass("sapUiFormLabel-CTX");k.setLabel(j);if(!A.call(this,j)){E.call(this,j,this._iLabelWeight,false,true,this.getLabelMinWidth());}}k.isVisible=function(){var X=this.getFields();var Y=false;for(var i=0;i<X.length;i++){var Z=X[i];if(Z.getVisible()){Y=true;break;}}return Y;};return k;}function O(i){var j=new a();I.call(this,j);j.getAriaLabelledBy=function(){var k=this.getToolbar();if(k){return k.getAriaLabelledBy();}else{return[];}};if(i){if(i.isA("sap.ui.core.Title")){j.setTitle(i);}else if(i.isA("sap.ui.core.Toolbar")){j.setToolbar(i);}}return j;}function P(j){var k=this._iMaxWeight;var X=j.getFields();var Y;var Z=X.length;var $=j.getLabel();var a1;var i=0;this._bLayoutDataChangedByMe=true;if($&&A.call(this,$)){k=k-A.call(this,$).getWeight();}for(i=0;i<X.length;i++){Y=X[i];a1=A.call(this,Y);if(a1&&a1.isA("sap.ui.layout.ResponsiveFlowLayoutData")&&!y.call(this,a1)){k=k-a1.getWeight();Z--;}}var b1=Math.floor(k/Z);var c1=k%Z;for(i=0;i<X.length;i++){Y=X[i];a1=A.call(this,Y);var d1=b1;if(!a1){E.call(this,Y,d1,false,i==0);}else if(y.call(this,a1)&&a1.isA("sap.ui.layout.ResponsiveFlowLayoutData")){if(c1>0){d1++;c1--;}a1.setWeight(d1);}}this._bLayoutDataChangedByMe=false;}o.prototype._applyLinebreaks=function(){if(!e||this._bResponsiveLayoutRequested){return;}this._bLayoutDataChangedByMe=true;var j=this.getAggregation("form"),k=j.getFormContainers();var X=this.getDomRef();var Y=this.$();for(var i=1;i<k.length;i++){var Z=k[i],$=Z.getLayoutData();if(!X||Y.outerWidth(true)>this.getMinWidth()){if(i%this.getMaxContainerCols()==0){$.setLinebreak(true);}else{$.setLinebreak(false);}}else{$.setLinebreak(true);}}if(X&&Y.css("visibility")=="hidden"){var a1=this;setTimeout(function(){if(a1.getDomRef()){a1.$().css("visibility","");}},10);}this._bLayoutDataChangedByMe=false;};function Q(){this._bLayoutDataChangedByMe=true;var j=this.getAggregation("form");var k=j.getFormContainers();var X=k.length;for(var i=0;i<X;i++){var Y=k[i];if((this.getMaxContainerCols()<=1)||((i==X-1)&&(X%2>0))){Y.getLayoutData().setHalfGrid(false);}else if(!Y.getLayoutData().getHalfGrid()){Y.getLayoutData().setHalfGrid(true);}}this._bLayoutDataChangedByMe=false;}o.prototype._resize=function(i){this._bChangedByMe=true;if(this._iCurrentWidth==i.size.width){return;}this._iCurrentWidth=i.size.width;this._applyLinebreaks();this._bChangedByMe=false;};function T(){if(this._sResizeListenerId){R.deregister(this._sResizeListenerId);this._sResizeListenerId=null;}}function U(j,k){var X=false;for(var i=0;i<j.length;i++){var Y=j[i];if(Y==k){X=true;break;}}if(!X){j.push(k);}}function V(i){if(i.name=="visible"){var j=i.object.getParent();j.invalidate();}}function W(X){var Y=[];var Z=X.getFormContainers();for(var i=0;i<Z.length;i++){var $=Z[i];var a1=$.getTitle();if(a1){Y.push(a1);}else{var b1=$.getToolbar();if(b1){Y.push(b1);}}var c1=$.getFormElements();for(var j=0;j<c1.length;j++){var d1=c1[j];var e1=d1.getLabel();if(e1){Y.push(e1);}var f1=d1.getFields();for(var k=0;k<f1.length;k++){var g1=f1[k];Y.push(g1);}}}return Y;}o.prototype._formInvalidated=function(k){if(!this._bChangedByMe){var X=W(this.getAggregation("form"));var i=0;var j=0;var Y=false;if(!this._aElements||X.length<this._aElements.length){Y=true;}else{for(i=0;i<X.length;i++){var Z=X[i];var $=this._aElements[j];if(Z===$){j++;}else{var a1=X[i+1];if(a1===$){this.insertContent(Z,i);break;}a1=this._aElements[j+1];if(a1===Z){Y=true;break;}break;}}}if(Y){this.removeAllContent();for(i=0;i<X.length;i++){var b1=X[i];this.addContent(b1);}}}};o.prototype._onLayoutDataChange=function(i){if(!this._bLayoutDataChangedByMe&&!this._bIsBeingDestroyed){switch(this.getLayout()){case d.ResponsiveLayout:var j=i.srcControl;var k=j.getParent();if(k instanceof b){var X=this.indexOfContent(j);this.removeContent(j);this.insertContent(j,X);}break;}}};return o;});
