/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/TreeBinding','sap/ui/model/ChangeReason','sap/ui/model/Filter','sap/ui/model/FilterOperator','sap/ui/model/FilterType','sap/ui/model/Sorter','sap/ui/model/odata/CountMode','sap/ui/model/TreeAutoExpandMode','./odata4analytics','./BatchResponseCollector','./AnalyticalVersionInfo'],function(Q,T,C,F,a,b,S,c,d,f,B,A){"use strict";var t="sap.ui.model.analytics.AnalyticalBinding";function u(o){var e=new f.QueryResultRequest(o.oAnalyticalQueryResult),g,s,D,i,j,m,n,p,h=o.mParameters.select.split(","),E=w(h,o.sPath);e.setAggregationLevel(o.aMaxAggregationLevel);e.setMeasures(o.aMeasureName);Object.keys(o.oDimensionDetailsSet).forEach(function(k){D=o.oDimensionDetailsSet[k];e.includeDimensionKeyTextAttributes(k,true,D.textPropertyName!==undefined,D.aAttributeName);});Object.keys(o.oMeasureDetailsSet).forEach(function(M){m=o.oMeasureDetailsSet[M];e.includeMeasureRawFormattedValueUnit(M,m.rawValuePropertyName!==undefined,m.formattedValuePropertyName!==undefined,m.unitPropertyName!==undefined);});s=e.getURIQueryOptionValue("$select");if(s){g=s.split(",");for(i=0,n=g.length;i<n;i++){p=g[i];j=h.indexOf(p);if(j<0){Q.sap.log.warning("Ignored the 'select' binding parameter, because"+" it does not contain the property '"+p+"'",o.sPath,t);E=true;}else{h.splice(j,1);}}}for(i=0,n=h.length;i<n;i++){p=h[i];D=o.oAnalyticalQueryResult.findDimensionByPropertyName(p);if(D&&o.oDimensionDetailsSet[D.getName()]===undefined){v(o.sPath,p,D);E=true;}m=o.oAnalyticalQueryResult.findMeasureByPropertyName(p);if(m&&o.oMeasureDetailsSet[m.getName()]===undefined){v(o.sPath,p,m);E=true;}}return E?[]:h;}function v(p,s,D){var e=D instanceof sap.ui.model.analytics.odata4analytics.Dimension?"dimension":"measure";if(D.getName()===s){Q.sap.log.warning("Ignored the 'select' binding parameter, because it contains"+" the "+e+" property '"+s+"' which is not contained in the analytical info (see updateAnalyticalInfo)",p,t);}else{Q.sap.log.warning("Ignored the 'select' binding parameter, because the property '"+s+"' is associated with the "+e+" property '"+D.getName()+"' which is not contained in the analytical"+" info (see updateAnalyticalInfo)",p,t);}}function w(s,p){var e,E=false,i,n;for(i=0,n=s.length;i<n;i++){s[i]=s[i].trim();}for(i=s.length-1;i>=0;i--){e=s[i];if(s.indexOf(e)!==i){Q.sap.log.warning("Ignored the 'select' binding parameter, because it"+" contains the property '"+e+"' multiple times",p,t);s.splice(i,1);E=true;}}return E;}var x=T.extend("sap.ui.model.analytics.AnalyticalBinding",{constructor:function(m,p,o,s,e,P){T.call(this,m,p,o,e,P);this.aAdditionalSelects=[];this.sEntitySetName=(P&&P.entitySet)?P.entitySet:undefined;this.bArtificalRootContext=false;this.aApplicationFilter=this._convertDeprecatedFilterObjects(e);this.aControlFilter=undefined;this.aSorter=s?s:[];this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.oPendingRequests={};this.oPendingRequestHandle=[];this.oGroupedRequests={};this.bUseBatchRequests=(P&&P.useBatchRequests===true)?true:false;this.bProvideTotalSize=(P&&P.provideTotalResultSize===false)?false:true;this.bProvideGrandTotals=(P&&P.provideGrandTotals===false)?false:true;this.bReloadSingleUnitMeasures=(P&&P.reloadSingleUnitMeasures===false)?false:true;this.bUseAcceleratedAutoExpand=(P&&P.useAcceleratedAutoExpand===false)?false:true;this.bNoPaging=(P&&P.noPaging===true)?true:false;this.iTotalSize=-1;this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mKeyIndex={};this.mFinalLength=this.mServiceFinalLength;this.mLength={};this.mMultiUnitKey={};this.aMultiUnitLoadFactor={};this.bNeedsUpdate=false;this.bApplySortersToGroups=true;this.sLastAutoExpandMode=undefined;this.mEntityKey={};this.sCustomParams=this.oModel.createCustomParams({custom:this.mParameters.custom});this.oAnalyticalQueryResult=null;this.aAnalyticalInfo=[];this.mAnalyticalInfoByProperty={};this.aBatchRequestQueue=[];if(P&&P.countMode==c.None){Q.sap.log.fatal("requested count mode is ignored; OData requests will include $inlinecout options");}else if(P&&(P.countMode==c.Request||P.countMode==c.Both)){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}else if(this.oModel.sDefaultCountMode==c.Request){Q.sap.log.warning("default count mode is ignored; OData requests will include $inlinecout options");}this.iModelVersion=A.getVersion(this.oModel);if(this.iModelVersion===null){Q.sap.log.error("The AnalyticalBinding does not support Models other than sap.ui.model.odata.ODataModel version 1 or 2.");return;}this.aAllDimensionSortedByName=null;this.aInitialAnalyticalInfo=(P==undefined?[]:P.analyticalInfo);this.bInitial=true;}});function y(o,e){return function(){if(!o.__supportUID){o.__supportUID=Q.sap.uid();}return{type:t,analyticalError:e,analyticalBindingId:o.__supportUID};};}x.prototype.setContext=function(o){var r;if(this.oContext!==o){this.oContext=o;if(!this.isRelative()){return;}this.oDataState=null;this.bApplySortersToGroups=true;r=this.oModel.resolve(this.sPath,this.oContext);if(r){this.resetData();this._initialize();this._fireChange({reason:C.Context});}else{this.bInitial=true;}}};x.prototype.initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()&&this.isInitial()){var i=this.isRelative();if(!i||(i&&this.oContext)){this._initialize();}this._fireRefresh({reason:C.Refresh});}return this;};x.prototype._initialize=function(){if(this.oModel.oMetadata&&this.oModel.oMetadata.isLoaded()){this.bInitial=false;this.oAnalyticalQueryResult=this.oModel.getAnalyticalExtensions().findQueryResultByName(this._getEntitySet());if(!this.oAnalyticalQueryResult){throw("Error in AnalyticalBinding - The QueryResult '"+this._getEntitySet()+"' could not be retrieved. Please check your service definition.");}this.updateAnalyticalInfo(this.aInitialAnalyticalInfo);this.aAllDimensionSortedByName=this.oAnalyticalQueryResult.getAllDimensionNames().concat([]).sort();this._fireRefresh({reason:C.Refresh});}};x.prototype.getRootContexts=function(p){if(this.isInitial()){return[];}var i=(p&&p.numberOfExpandedLevels?p.numberOfExpandedLevels+1:1);var r=null;var R=this._getRequestId(x._requestType.groupMembersQuery,{groupId:null});if(this.bArtificalRootContext&&!this._cleanupGroupingForCompletedRequest(R)){return r;}r=this._getContextsForParentContext(null);if(r.length==1){return r;}if(i<=1){if(i==1){this._considerRequestGrouping([R,this._getRequestId(x._requestType.groupMembersQuery,{groupId:"/"})]);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:0});}}else{var e=this._prepareGroupMembersAutoExpansionRequestIds("/",p.numberOfExpandedLevels);e.push(R);this._considerRequestGrouping(e);this.getNodeContexts(this.getModel().getContext("/"),{startIndex:p.startIndex,length:p.length,threshold:p.threshold,level:0,numberOfExpandedLevels:p.numberOfExpandedLevels});}if(r.length>1){Q.sap.log.fatal("assertion failed: grand total represented by a single entry");}return r;};x.prototype.getNodeContexts=function(o,p){if(this.isInitial()){return[];}var s,l,i,L,n,e;if(typeof p=="object"){s=p.startIndex;l=p.length;i=p.threshold;L=p.level;n=p.numberOfExpandedLevels;e=p.supressRequest;}else{s=arguments[1];l=arguments[2];i=arguments[3];L=arguments[4];n=arguments[5];e=arguments[6];}var g=this._getContextsForParentContext(o,s,l,i,L,n,e);return g;};x.prototype.ContextsAvailabilityStatus={ALL:2,SOME:1,NONE:0};x.prototype.hasAvailableNodeContexts=function(o,l){var g=this._getGroupIdFromContext(o,l);if(this._getKeys(g)!=undefined){if(this.mFinalLength[g]==true){return x.prototype.ContextsAvailabilityStatus.ALL;}else{return x.prototype.ContextsAvailabilityStatus.SOME;}}else{return x.prototype.ContextsAvailabilityStatus.NONE;}};x.prototype.getGroupSize=function(o,l){if(o===undefined){return 0;}var g=this._getGroupIdFromContext(o,l);return this.mFinalLength[g]?this.mLength[g]:-1;};x.prototype.getTotalSize=function(){if(!this.bProvideTotalSize){Q.sap.log.fatal("total size of result explicitly turned off, but getter invoked");}return+this.iTotalSize;};x.prototype.hasChildren=function(o,p){if(o===undefined){return false;}if(o==null){return true;}var i=p.level;if(i==0){return true;}if(this.aAggregationLevel.length<i){return false;}return Q.inArray(this.aAggregationLevel[i-1],this.aMaxAggregationLevel)<this.aMaxAggregationLevel.length-1;};x.prototype.hasMeasures=function(){var h=false;for(var p in this.oMeasureDetailsSet){if(this.oMeasureDetailsSet.hasOwnProperty(p)){h=true;break;}}return h;};x.prototype.getDimensionDetails=function(){return this.oDimensionDetailsSet;};x.prototype.getMeasureDetails=function(){return this.oMeasureDetailsSet;};x.prototype.providesGrandTotal=function(){return this.bProvideGrandTotals;};x.prototype.getProperty=function(p){if(this.isInitial()){return{};}return this.oAnalyticalQueryResult.getEntityType().findPropertyByName(p);};x.prototype.getFilterablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getFilterablePropertyNames();};x.prototype.getSortablePropertyNames=function(){if(this.isInitial()){return[];}return this.oAnalyticalQueryResult.getEntityType().getSortablePropertyNames();};x.prototype.getPropertyLabel=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getLabelOfProperty(p);};x.prototype.getPropertyHeading=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getHeadingOfProperty(p);};x.prototype.getPropertyQuickInfo=function(p){if(this.isInitial()){return"";}return this.oAnalyticalQueryResult.getEntityType().getQuickInfoOfProperty(p);};x.prototype.isMeasure=function(p){return Q.inArray(p,this.aMeasureName)!==-1;};x.prototype.filter=function(e,s){if(!e){e=[];}if(e instanceof F){e=[e];}e=this._convertDeprecatedFilterObjects(e);if(s==b.Application){this.aApplicationFilter=e;}else{this.aControlFilter=e;}this.iTotalSize=-1;this._abortAllPendingRequests();this.resetData();this.bApplySortersToGroups=true;this._fireRefresh({reason:C.Filter});return this;};x.prototype.sort=function(s){if(s instanceof S){s=[s];}this.aSorter=s?s:[];this._abortAllPendingRequests();this.resetData(undefined,{reason:C.Sort});this._fireRefresh({reason:C.Sort});return this;};x.prototype.getGroupName=function(o,l){if(o===undefined){return"";}var g=this.aAggregationLevel[l-1],D=this.oAnalyticalQueryResult.findDimensionByPropertyName(g),V=this.mAnalyticalInfoByProperty[g]&&this.mAnalyticalInfoByProperty[g].formatter,p=o.getProperty(g),e,s,G;if(D&&this.oDimensionDetailsSet[g].textPropertyName){e=D.getTextProperty();}var h,i,j;if(e){h=D.getTextProperty().name;j=this.mAnalyticalInfoByProperty[h]&&this.mAnalyticalInfoByProperty[h].formatter;i=o.getProperty(h);}if(!e){s=V?V(p):p;G=(D.getLabelText?D.getLabelText()+': ':'')+s;}else{s=V?V(p,i):p;G=(D.getLabelText?D.getLabelText()+': ':'')+s;var k=j?j(i,p):i;if(k){G+=' - '+k;}}return G;};x.prototype.updateAnalyticalInfo=function(e,g){var D,E,h,k=this;function l(G){var L=G.level,N=G.name;h=h||E.getAllHierarchyPropertyNames();h.forEach(function(H){var I=k.oAnalyticalQueryResult.findDimensionByPropertyName(H).getHierarchy(),J=null,K=I.getNodeIDProperty().name,O;if(K===N){J=m(I);}else{O=I.getNodeExternalKeyProperty();if(O&&O.name===N){J=m(I);J.nodeExternalKeyName=N;}else{O=E.getTextPropertyOfProperty(K);if(O&&O.name===N){J=m(I);J.nodeTextName=N;}}}if(J&&"level"in G){if(typeof L==="number"){if("level"in J&&J.level!==L){throw new Error("Multiple different level filter for hierarchy '"+K+"' defined");}J.level=L;J.grouped=!!G.grouped;}else{throw new Error("The level of '"+K+"' has to be an integer value");}}});}function m(H){var N=H.getNodeIDProperty().name,G,I=k.mHierarchyDetailsByName[N];if(!I){G=H.getNodeLevelProperty();I={dimensionName:H.getNodeValueProperty().name,nodeIDName:N,nodeLevelName:G&&G.name};k.mHierarchyDetailsByName[N]=I;}return I;}if(!this.oModel.oMetadata||!this.oModel.oMetadata.isLoaded()||this.isInitial()){this.aInitialAnalyticalInfo=e;return;}if(Q.sap.equal(this._aLastChangedAnalyticalInfo,e)){if(g){setTimeout(function(){this._fireChange({reason:C.Change});}.bind(this),0);}return;}E=this.oAnalyticalQueryResult.getEntityType();this._aLastChangedAnalyticalInfo=[];for(var j=0;j<e.length;j++){this._aLastChangedAnalyticalInfo[j]=Q.extend({},e[j]);}var p=this.oDimensionDetailsSet||{},P=this.oMeasureDetailsSet||{};this.mAnalyticalInfoByProperty={};this.aMaxAggregationLevel=[];this.aAggregationLevel=[];this.aMeasureName=[];if(this.iAnalyticalInfoVersionNumber==undefined){this.iAnalyticalInfoVersionNumber=1;}else if(this.iAnalyticalInfoVersionNumber>999){this.iAnalyticalInfoVersionNumber=1;}else{this.iAnalyticalInfoVersionNumber=this.iAnalyticalInfoVersionNumber+1;}this.oMeasureDetailsSet={};this.oDimensionDetailsSet={};this.aAdditionalSelects=[];this.mHierarchyDetailsByName={};for(var i=0;i<e.length;i++){var o=this.oAnalyticalQueryResult.findDimensionByPropertyName(e[i].name);if(o&&(e[i].inResult==true||e[i].visible==true)){e[i].dimensionPropertyName=o.getName();D=this.oDimensionDetailsSet[o.getName()];if(!D){D={};D.name=o.getName();D.aAttributeName=[];D.grouped=false;this.oDimensionDetailsSet[o.getName()]=D;this.aMaxAggregationLevel.push(D.name);if(e[i].grouped==true){this.aAggregationLevel.push(D.name);}}if(e[i].grouped==true){if(Q.inArray(o.getName(),this.getSortablePropertyNames())==-1){Q.sap.log.fatal("property "+o.getName()+" must be sortable in order to be used as grouped dimension");}D.grouped=true;}if(o.getName()==e[i].name){D.keyPropertyName=e[i].name;}var n=o.getTextProperty();if(n&&n.name==e[i].name){D.textPropertyName=e[i].name;}if(o.findAttributeByName(e[i].name)){D.aAttributeName.push(e[i].name);}D.analyticalInfo=e[i];}var M=this.oAnalyticalQueryResult.findMeasureByPropertyName(e[i].name);if(M&&(e[i].inResult==true||e[i].visible==true)){e[i].measurePropertyName=M.getName();var q=this.oMeasureDetailsSet[M.getName()];if(!q){q={};q.name=M.getName();this.oMeasureDetailsSet[M.getName()]=q;this.aMeasureName.push(q.name);}if(M.getRawValueProperty().name==e[i].name){q.rawValuePropertyName=e[i].name;}var r=M.getFormattedValueProperty();if(r&&r.name==e[i].name){q.formattedValuePropertyName=e[i].name;}q.analyticalInfo=e[i];}if(!o&&!M){l(e[i]);}this.mAnalyticalInfoByProperty[e[i].name]=e[i];}Object.keys(this.mHierarchyDetailsByName).forEach(function(N){var H=k.mHierarchyDetailsByName[N];if(!("level"in H)){delete k.mHierarchyDetailsByName[N];if(Q.sap.log.isLoggable(Q.sap.log.Level.INFO,t)){Q.sap.log.info("No level specified for hierarchy node '"+N+"'; ignoring hierarchy","",t);}}else if(!k.oDimensionDetailsSet[N]){k.oDimensionDetailsSet[N]={aAttributeName:[],grouped:H.grouped,isHierarchyDimension:true,name:N};k.aMaxAggregationLevel.push(N);if(H.grouped){k.aAggregationLevel.push(N);}}});for(var s in this.oMeasureDetailsSet){var U=this.oAnalyticalQueryResult.findMeasureByName(s).getUnitProperty();if(U){this.oMeasureDetailsSet[s].unitPropertyName=U.name;}}var z=Object.keys(p).sort().join(";")!==Object.keys(this.oDimensionDetailsSet).sort().join(";");if(z){this.iTotalSize=-1;}if(z||Object.keys(P).sort().join(";")!==Object.keys(this.oMeasureDetailsSet).sort().join(";")){this.bApplySortersToGroups=true;}this.aAnalyticalInfo=e;this.resetData();this.bNeedsUpdate=false;if(this.mParameters.select){this.aAdditionalSelects=u(this);}if(g){this._fireChange({reason:C.Change});}};x.prototype.getAnalyticalInfoForColumn=function(s){return this.mAnalyticalInfoByProperty[s];};x.prototype.loadGroups=function(g){var G=[];for(var s in g){G.push(s);this._resetData(s);var e=g[s];for(var i=0;i<e.length;i++){var o=e[i];this._getContextsForParentGroupId(s,o.startIndex,o.length,o.threshold);}var r=[];for(var j=-1,h;(h=G[++j])!==undefined;){r.push(this._getRequestId(x._requestType.groupMembersQuery,{groupId:h}));}this._considerRequestGrouping(r);}};x.prototype.getAnalyticalQueryResult=function(){return this.oAnalyticalQueryResult;};x._requestType={groupMembersQuery:1,totalSizeQuery:2,groupMembersAutoExpansionQuery:3,levelMembersQuery:4,reloadMeasuresQuery:5};x._artificialRootContextGroupId="artificialRootContext";x._addHierarchyLevelFilters=function(e,o){e.forEach(function(g){o.removeConditions(g.propertyName);o.addCondition(g.propertyName,a.EQ,g.level);});};x.prototype._getContextsForParentContext=function(p,s,l,i,L,n,e){if(p===undefined){return[];}if(p&&p.getPath()=="/"+x._artificialRootContextGroupId){p=this.getModel().getContext("/");}var P=this._getGroupIdFromContext(p,L);return this._getContextsForParentGroupId(P,s,l,i,n,e);};x.prototype._getContextsForParentGroupId=function(p,s,l,e,n,g){if(p===undefined){return[];}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;}if(this.mFinalLength[p]&&this.mLength[p]<s+l){l=this.mLength[p]-s;if(l<0){Q.sap.log.fatal("invalid start index greater than total group length passed");}}if(!e){e=0;}if(!n){n=0;}if(p==null){if(n>0){Q.sap.log.fatal("invalid request to determine nodes of root context");return null;}}else{if(this._getGroupIdLevel(p)>=this.aAggregationLevel.length&&n>0){Q.sap.log.fatal("invalid request to determine nodes of context with group ID "+p);return null;}if(this._getGroupIdLevel(p)+n>this.aAggregationLevel.length){n=this.aAggregationLevel.length-this._getGroupIdLevel(p)-1;}}var h=[],L,G,o,m;var k=p==null?0:this._getGroupIdLevel(p)+1;if(!this.aMultiUnitLoadFactor[k]){this.aMultiUnitLoadFactor[k]=1;}var q=n>0&&p!=null;if(q){var M=this._getGroupIdLevel(p);var r=M+n;var D=true;if(!g){o=this._calculateRequiredGroupExpansion(p,r,s,l+e);D=o.groupId_Missing==null;D=D||o.groupId_Missing.length<p.length||o.groupId_Missing.substring(0,p.length)!=p;}if(D){h=this._getLoadedContextsForGroup(p,s,l);}else{m=l+e;}L=!D;m=Math.ceil(m*this.aMultiUnitLoadFactor[k]);}else{h=this._getLoadedContextsForGroup(p,s,l,g);L=false;if(!g){G=this._calculateRequiredGroupSection(p,s,l,e,h);var P=G.length>0&&l<G.length;L=(h.length!=l&&!(this.mFinalLength[p]&&h.length>=this.mLength[p]-s))||P;G.length=Math.ceil(G.length*this.aMultiUnitLoadFactor[k]);}}if(!L){this._cleanupGroupingForCompletedRequest(this._getRequestId(x._requestType.groupMembersQuery,{groupId:p}));}var E=false;if(this.oModel.getServiceMetadata()){if(L){var N=this.bProvideTotalSize&&this.iTotalSize==-1&&!this._isRequestPending(this._getRequestId(x._requestType.totalSizeQuery));E=true;var z;if(this.bUseBatchRequests){if(q){z=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var i=-1,R;(R=z[++i])!==undefined;){if(this._isRequestPending(R)){E=false;break;}}if(E){this.aBatchRequestQueue.push([x._requestType.groupMembersAutoExpansionQuery,p,o,m,n]);}}else{E=!this._isRequestPending(this._getRequestId(x._requestType.groupMembersQuery,{groupId:p}));if(E){this.aBatchRequestQueue.push([x._requestType.groupMembersQuery,p,G.startIndex,G.length]);z=[this._getRequestId(x._requestType.groupMembersQuery,{groupId:p})];}}if(E&&N){z.push(this._getRequestId(x._requestType.totalSizeQuery));this._considerRequestGrouping(z);this.aBatchRequestQueue.push([x._requestType.totalSizeQuery]);}if(E){if(p==null){this._abortAllPendingRequests();}Promise.resolve().then(x.prototype._processRequestQueue.bind(this));}}else{var H;if(q){z=this._prepareGroupMembersAutoExpansionRequestIds(p,n);for(var j=-1,I;(I=z[++j])!==undefined;){if(this._isRequestPending(I)){E=false;break;}}if(E){H=this._prepareGroupMembersAutoExpansionQueryRequest(x._requestType.groupMembersAutoExpansionQuery,p,o,m,n);}}else{E=!this._isRequestPending(this._getRequestId(x._requestType.groupMembersQuery,{groupId:p}));if(E){H=this._prepareGroupMembersQueryRequest(x._requestType.groupMembersQuery,p,G.startIndex,G.length);z=[H.sRequestId];}}if(E){if(p==null){this._abortAllPendingRequests();}this._executeQueryRequest(H);if(N&&!H.bIsFlatListRequest){z.push(this._getRequestId(x._requestType.totalSizeQuery));this._considerRequestGrouping(z);this._executeQueryRequest(this._prepareTotalSizeQueryRequest(x._requestType.totalSizeQuery));}}}}}return h;};x.prototype._getHierarchyLevelFiltersAndAddRecursiveHierarchy=function(o,g){var h,H=[],e=this;if(g===null){return H;}h=Object.keys(this.mHierarchyDetailsByName);if(h.length>0&&g!=="/"){Q.sap.log.error("Hierarchy cannot be requested for members of a group",g,t);return H;}h.forEach(function(s){var i=e.mHierarchyDetailsByName[s];o.addRecursiveHierarchy(i.dimensionName,!!i.nodeExternalKeyName,!!i.nodeTextName);H.push({propertyName:i.nodeLevelName,level:i.level});});return H;};x.prototype._getNonHierarchyDimensions=function(e){var g=this;return e.filter(function(D){return!g.oDimensionDetailsSet[D].isHierarchyDimension;});};x.prototype._processRequestQueue=function(r){if(r===undefined||r===null){r=this.aBatchRequestQueue||[];}if(r.length==0){return;}var R=[];var e=false;var i,o,g;for(i=-1;(g=r[++i])!==undefined;){if(g[0]==x._requestType.groupMembersQuery){o=x.prototype._prepareGroupMembersQueryRequest.apply(this,g);e=e||o.bIsFlatListRequest;R.push(o);}}for(i=-1;(g=r[++i])!==undefined;){o=null;switch(g[0]){case x._requestType.groupMembersQuery:continue;case x._requestType.totalSizeQuery:if(!e){o=x.prototype._prepareTotalSizeQueryRequest.apply(this,g);R.push(o);}break;case x._requestType.groupMembersAutoExpansionQuery:o=x.prototype._prepareGroupMembersAutoExpansionQueryRequest.apply(this,g);for(var j=-1,l;(l=o.aGroupMembersAutoExpansionRequestDetails[++j])!==undefined;){R.push(l);}break;case x._requestType.reloadMeasuresQuery:{var h=g[1];for(var k=-1,m;(m=h[++k])!==undefined;){R.push(m);}break;}default:Q.sap.log.fatal("unhandled request type "+r[i][0]);continue;}}if(R.length>1){this._executeBatchRequest(R);}else{this._executeQueryRequest(R[0]);}if(r===this.aBatchRequestQueue){this.aBatchRequestQueue=[];}};x.prototype._prepareGroupMembersQueryRequest=function(r,g,s,L){var G=[],e=[],h;var o=new f.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var m=0,p=-1;if(g){G=this._getGroupIdComponents(g);m=p=G.length;var U=0;for(var j=0,q=0;j<m;q++){if(this.oDimensionDetailsSet[this.aMaxAggregationLevel[q]].grouped==false){++U;}else{++j;}}m=p=m+U;if(this.aMaxAggregationLevel.length>0){while(this.oDimensionDetailsSet[this.aMaxAggregationLevel[p]].grouped==false){if(++p==this.aMaxAggregationLevel.length){break;}}}}var I=p>=this.aMaxAggregationLevel.length-1;h=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,g);var z=this.aMaxAggregationLevel.slice(0,p+1);var D=this._getNonHierarchyDimensions(z);o.setAggregationLevel(D);for(var i=0;i<D.length;i++){var E=this.oDimensionDetailsSet[D[i]];var H=(E.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(E.name,true,H,E.aAttributeName);if(E.grouped){e.push({sPath:D[i],bDescending:false});}}var J=o.getFilterExpression();J.clear();if(this.aApplicationFilter){J.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){J.addUI5FilterConditions(this.aControlFilter);}if(m>=1){for(var k=0,l=G.length;k<l;k++){J.removeConditions(this.aAggregationLevel[k]);J.addCondition(this.aAggregationLevel[k],a.EQ,G[k]);}}x._addHierarchyLevelFilters(h,J);var K;var M;var N;var O;var P=[];if(g!=null||this.bProvideGrandTotals||(this._canApplySortersToGroups()&&this.aSorter.length>0)){o.setMeasures(this.aMeasureName);for(var R in this.oMeasureDetailsSet){O=this.oMeasureDetailsSet[R];if(!I&&this.mAnalyticalInfoByProperty[R].total==false){K=false;M=false;N=false;}else{K=(O.rawValuePropertyName!=undefined);M=(O.formattedValuePropertyName!=undefined);N=(O.unitPropertyName!=undefined);if(N){if(Q.inArray(O.unitPropertyName,P)==-1){P.push(O.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(O.name,K,M,N);}for(var n in D){var V;if((V=Q.inArray(D[n],P))!=-1){P.splice(V,1);}}}this._addSorters(o.getSortExpression(),e);if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var W=this._getKeyIndexMapping(g,s);if(!this.bNoPaging){o.setResultPageBoundaries(W.iServiceKeyIndex+1,W.iServiceKeyIndex+L);}o.setRequestOptions(null,!this.mFinalLength[g]);return{iRequestType:r,sRequestId:this._getRequestId(x._requestType.groupMembersQuery,{groupId:g}),oAnalyticalQueryRequest:o,sGroupId:g,aSelectedUnitPropertyName:P,aAggregationLevel:z,bIsFlatListRequest:I&&m==0,bIsLeafGroupsRequest:I,iStartIndex:s,iLength:L,oKeyIndexMapping:W};};x.prototype._prepareTotalSizeQueryRequest=function(r){var h;var o=new f.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());h=this._getHierarchyLevelFiltersAndAddRecursiveHierarchy(o,"/");o.setAggregationLevel(this._getNonHierarchyDimensions(this.aMaxAggregationLevel));o.setMeasures([]);var e=o.getFilterExpression();e.clear();if(this.aApplicationFilter){e.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){e.addUI5FilterConditions(this.aControlFilter);}x._addHierarchyLevelFilters(h,e);o.setRequestOptions(null,null,true);o.setRequestOptions(null,true);return{iRequestType:r,sRequestId:this._getRequestId(x._requestType.totalSizeQuery),oAnalyticalQueryRequest:o};};x.prototype._prepareGroupMembersAutoExpansionQueryRequest=function(r,g,G,L,n){var e=this;var p=function(G,o){var z=[];if(G.groupId_Missing==null){Q.sap.log.fatal("missing group Id not present");return z;}var q=e._getGroupIdComponents(G.groupId_Missing);var s=q.length;if(s>o){Q.sap.log.fatal("the given group ID is too deep for requested level for auto expansion");return z;}var k=[];for(var i=0;i<s;i++){var l=e.aAggregationLevel[i];var V=q[i];var U=e._getFilterOperatorMatchingPropertySortOrder(l);k[i]=new F(l,U,V);}var W=null;if(G.startIndex_Missing>0){var X=e._getKey(G.groupId_Missing,G.startIndex_Missing-1);var Y=e.oModel.getObject("/"+X);var Z=e.aAggregationLevel[s];var $=Y[Z];W=new F(Z,e._getFilterOperatorMatchingPropertySortOrder(Z,false),$);}for(var E=0;E<o;E++){var _=[];var a1=Math.min(s,E+1);for(var b1=0;b1<a1;b1++){var c1=[];var d1=Math.min(s,b1+1);var e1=G.startIndex_Missing>0;for(var f1=0;f1<d1;f1++){var g1=new F("x",a.EQ,"x");g1=Q.extend(true,g1,k[f1]);if(d1>1&&f1<d1-1){g1.sOperator=a.EQ;}if(f1==s-1&&E>s-1&&!e1){if(g1.sOperator==a.GT){g1.sOperator=a.GE;}else{g1.sOperator=a.LE;}}c1.push(g1);}if(c1.length>0){_.push(new F(c1,true));if(E>s-1&&b1==s-1&&e1){var h1=[];for(var j=0;j<c1.length;j++){var i1=new F("x",a.EQ,"x");i1=Q.extend(true,i1,c1[j]);h1.push(i1);}h1[s-1].sOperator=a.EQ;h1.push(W);_.push(new F(h1,true));break;}}}if(_.length>0){z[E]=new F(_,false);}else{z[E]=null;}}return z;};var h=function(r,g,E,U,H,L,V,W){var X;var Y=new f.QueryResultRequest(e.oAnalyticalQueryResult);Y.setResourcePath(e._getResourcePath());Y.getSortExpression().clear();var Z=0,$=-1;Z=$=E-1;var _=0;for(var i=0,a1=0;i<Z;a1++){if(e.oDimensionDetailsSet[e.aMaxAggregationLevel[a1]].grouped==false){++_;}else{++i;}}Z=$=Z+_;if(e.aMaxAggregationLevel.length>0){while(e.oDimensionDetailsSet[e.aMaxAggregationLevel[$]].grouped==false){if(++$==e.aMaxAggregationLevel.length){break;}}}var b1=$>=e.aMaxAggregationLevel.length-1;X=e._getHierarchyLevelFiltersAndAddRecursiveHierarchy(Y,g);var c1=e.aMaxAggregationLevel.slice(0,$+1);Y.setAggregationLevel(c1);for(var l=0;l<c1.length;l++){var d1=e.oDimensionDetailsSet[c1[l]];var e1=(d1.textPropertyName!=undefined);Y.includeDimensionKeyTextAttributes(d1.name,true,e1,d1.aAttributeName);if(d1.grouped){Y.getSortExpression().addSorter(c1[l],f.SortOrder.Ascending);}}var f1=Y.getFilterExpression();f1.clear();if(e.aApplicationFilter){f1.addUI5FilterConditions(e.aApplicationFilter);}if(e.aControlFilter){f1.addUI5FilterConditions(e.aControlFilter);}if(U){f1.addUI5FilterConditions([U]);}x._addHierarchyLevelFilters(X,f1);var g1;var h1;var i1;var j1;var k1=[];Y.setMeasures(e.aMeasureName);for(var l1 in e.oMeasureDetailsSet){j1=e.oMeasureDetailsSet[l1];if(!b1&&e.mAnalyticalInfoByProperty[l1].total==false){g1=false;h1=false;i1=false;}else{g1=(j1.rawValuePropertyName!=undefined);h1=(j1.formattedValuePropertyName!=undefined);i1=(j1.unitPropertyName!=undefined);if(i1){if(Q.inArray(j1.unitPropertyName,k1)==-1){k1.push(j1.unitPropertyName);}}}Y.includeMeasureRawFormattedValueUnit(j1.name,g1,h1,i1);}for(var j in c1){var m1;if((m1=Q.inArray(c1[j],k1))!=-1){k1.splice(m1,1);}}var n1=Y.getSortExpression();for(var k=0;k<e.aSorter.length;k++){if(e.aSorter[k]){n1.addSorter(e.aSorter[k].sPath,e.aSorter[k].bDescending?f.SortOrder.Descending:f.SortOrder.Ascending);}}if(L==0){Q.sap.log.fatal("unhandled case: load 0 entities of sub group");}var o1=H;if(!W){o1=0;}else{var p1=0;for(var q1 in e.mServiceKey){if(q1.split("/").length===E+1){p1+=e.mServiceKey[q1].length;}}o1=Math.max(o1,p1);}if(!e.bNoPaging){Y.setResultPageBoundaries(o1+1,L);}return{iRequestType:r,sRequestId:null,oAnalyticalQueryRequest:Y,iLevel:E,aSelectedUnitPropertyName:k1,aAggregationLevel:c1,bIsFlatListRequest:b1,bIsLeafGroupsRequest:b1,iStartIndex:H,iLength:L,bAvoidLengthUpdate:V};};var m=[];var R=[];if(!G){Q.sap.log.fatal("no first missing group member specified");}var o=this._getGroupIdLevel(g)+n+1;var q=e._getGroupIdComponents(G.groupId_Missing);var s=q.length;var z=p(G,o);var D;for(var E=1;E<=o;E++){var H;if(E>=s+2){H=0;D=undefined;}else if(E==s+1){H=G.startIndex_Missing;D=G.groupId_Missing;}else if(s>0){if(E==s){D=G.groupId_Missing;}else{D=this._getGroupIdAncestors(G.groupId_Missing,-(s-E))[0];}var I=this._getGroupIdAncestors(G.groupId_Missing,-(s-E+1))[0];if(!I){Q.sap.log.fatal("failed to determine group id at parent level; group ID = "+g+", level = "+E);}H=this._findKeyIndex(I,this.mEntityKey[D]);if(H==-1){Q.sap.log.fatal("failed to determine position of value "+D+" in group "+I);}D=I;H++;}var J=L>E?Math.ceil((L-E)/(o-E+1)):L;var K=z[E-1];if(this.bUseAcceleratedAutoExpand){var M=h(x._requestType.levelMembersQuery,g,E,K,H,J,false,K==null?true:false);M.sGroupId_Missing_AtLevel=D;M.sRequestId=this._getRequestId(x._requestType.levelMembersQuery,{groupId:g,level:E});m.push(M);R.push(M.sRequestId);}else if(K&&K.aFilters.length>0){if(!K._bMultiFilter||K.bAnd){Q.sap.log.fatal("level filter in wrong shape; cannot break it up");}for(var i=0;i<K.aFilters.length;i++){var N=K.aFilters[i];var O=h(x._requestType.levelMembersQuery,g,E,N,H,J,false,K==null?true:false);O.sGroupId_Missing_AtLevel=D;O.sRequestId=this._getRequestId(x._requestType.levelMembersQuery,{groupId:g,level:E,tupleIndex:i});m.push(O);R.push(O.sRequestId);}}else{var P=h(x._requestType.levelMembersQuery,g,E,null,H,J,false,K==null?true:false);P.sGroupId_Missing_AtLevel=D;P.sRequestId=this._getRequestId(x._requestType.levelMembersQuery,{groupId:g,level:E});m.push(P);R.push(P.sRequestId);}}return{iRequestType:r,aRequestId:R,aGroupMembersAutoExpansionRequestDetails:m,sGroupId:g,iLength:L};};x.prototype._prepareReloadMeasurePropertiesQueryRequest=function(r,g,m){var o=new f.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());o.getSortExpression().clear();var e=g.aAggregationLevel;o.setAggregationLevel(e);var I=g.bIsLeafGroupsRequest;var h=o.getFilterExpression();h.clear();if(this.aApplicationFilter){h.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){h.addUI5FilterConditions(this.aControlFilter);}var k=[];for(var i=0;i<e.length;i++){var l=new F(e[i],a.EQ,m.oEntry[e[i]]);k.push(l);}h.addUI5FilterConditions(k);var n;var p;var q;var M;var s=[];o.setMeasures(m.aReloadMeasurePropertyName);for(var z in this.oMeasureDetailsSet){M=this.oMeasureDetailsSet[z];if(Q.inArray(M.name,m.aReloadMeasurePropertyName)==-1){continue;}if(!I&&this.mAnalyticalInfoByProperty[z].total==false){n=false;p=false;q=false;}else{n=(M.rawValuePropertyName!=undefined);p=(M.formattedValuePropertyName!=undefined);q=(M.unitPropertyName!=undefined);if(q){if(Q.inArray(M.unitPropertyName,s)==-1){s.push(M.unitPropertyName);}}}o.includeMeasureRawFormattedValueUnit(M.name,n,p,q);}for(var j in e){var D;if((D=Q.inArray(e[j],s))!=-1){s.splice(D,1);}}return{iRequestType:r,sRequestId:this._getRequestId(x._requestType.reloadMeasuresQuery,{multiUnitEntryKey:this.oModel.getKey(m.oEntry)}),oAnalyticalQueryRequest:o,aSelectedUnitPropertyName:s,aAggregationLevel:e,oMultiUnitRepresentative:m};};x.prototype._prepareGroupMembersAutoExpansionRequestIds=function(g,n){var m=this._getGroupIdLevel(g)+1;var i=m+n;var r=[];for(var l=m;l<=i;l++){r.push(this._getRequestId(x._requestType.levelMembersQuery,{groupId:g,level:l}));}return r;};x.prototype._getQueryODataRequestOptions=function(o,g,p){var i;p=p||{};try{o.getFilterExpression().checkValidity();}catch(e){Q.sap.log.fatal("filter expression is not valid",e.toString());return undefined;}var s=o.getURIQueryOptionValue("$select");var h=o.getURIQueryOptionValue("$filter");var O=o.getURIQueryOptionValue("$orderby");var j=o.getURIQueryOptionValue("$skip");var k=o.getURIQueryOptionValue("$top");var I=o.getURIQueryOptionValue("$inlinecount");if(g&&this.aAdditionalSelects.length>0){s=(s?s.split(","):[]).concat(this.aAdditionalSelects).join(",");}if(this.mParameters&&this.mParameters["filter"]){if(h===null){h=this.mParameters["filter"];}else{h+="and ("+this.mParameters["filter"]+")";}}var P=[];if(s!==null){P.push("$select="+s);}if(h!==null){P.push("$filter="+h);}if(O!==null){P.push("$orderby="+O);}if(j!==null){P.push("$skip="+j);}if(k!==null){P.push("$top="+k);}if(I!==null){P.push("$inlinecount="+I);}if(p.encode===true){for(i=0;i<P.length;i++){P[i]=P[i].replace(/\ /g,"%20");}}return P;};x.prototype._executeBatchRequest=function(r){var e=this.iAnalyticalInfoVersionNumber,R,g=this;var h=[],E=[];function l(){g.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}var o=new B();function s(j,k){o.success(k);}function m(j,k){o.error(k||j);}this.bNeedsUpdate=true;for(var D=0;D<r.length;D++){var n=r[D];if(n.aAggregationLevel&&n.aAggregationLevel.length>0){this.bNeedsUpdate=false;}}for(var i=-1,p;(p=r[++i])!==undefined;){var q=p.oAnalyticalQueryRequest,G=p.sGroupId;if(q.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),x._artificialRootContextGroupId);setTimeout(l);this.bArtificalRootContext=true;continue;}var P=q.getURIToQueryResultEntries();if(!this.oContext&&P[0]!=="/"){P="/"+P;}if(!this._isRequestPending(p.sRequestId)){this._registerNewRequest(p.sRequestId);if(this.iModelVersion===A.V1){h.push(this.oModel.createBatchOperation(P.replace(/\ /g,"%20"),"GET"));}else if(this.iModelVersion===A.V2){var U=this._getQueryODataRequestOptions(q,p.bIsLeafGroupsRequest,{encode:true});if(this.sCustomParams){U.push(this.sCustomParams);}var z=this.oModel.read(P.replace(/\ /g,"%20"),{success:s,error:m,context:this.oContext,urlParameters:U});h.push(z);}E.push(p);}}if(h.length>0){Q.sap.log.debug("AnalyticalBinding: executing batch request with "+E.length+" operations");var H;R=this._getIdForNewRequestHandle();this.fireDataRequested();if(this.iModelVersion===A.V1){this.oModel.addBatchReadOperations(h);H=this.oModel.submitBatch(I,J,true,true);this.oModel.fireRequestSent({url:this.oModel.sServiceUrl+"/$batch",type:"POST",async:true,info:"",infoObject:{}});}else{H={abort:function(){for(var j=0;j<h.length;j++){h[j].abort();}}};o.setup({executedRequests:E,binding:this,success:I,error:J});}this._registerNewRequestHandle(R,H);}function I(K,L){g._deregisterHandleOfCompletedRequest(R);if(E.length!=K.__batchResponses.length){Q.sap.log.fatal("assertion failed: received "+K.__batchResponses.length+" responses for "+E.length+" read operations in the batch request");}if(e!=g.iAnalyticalInfoVersionNumber){for(var j=0;j<E.length;j++){var M=E[j].sRequestId;if(M!==undefined){g._deregisterCompletedRequest(M);g._cleanupGroupingForCompletedRequest(M);}}g.fireDataReceived({data:[]});return;}var N=0;for(var k=0;k<K.__batchResponses.length;k++){if(K.__batchResponses[k].data!=undefined){if(K.__batchResponses[k].data.results.length==0){N++;}switch(E[k].iRequestType){case x._requestType.groupMembersQuery:g._processGroupMembersQueryResponse(E[k],K.__batchResponses[k].data);break;case x._requestType.totalSizeQuery:g._processTotalSizeQueryResponse(E[k],K.__batchResponses[k].data);break;case x._requestType.levelMembersQuery:g._processLevelMembersQueryResponse(E[k],K.__batchResponses[k].data);break;case x._requestType.reloadMeasuresQuery:g._processReloadMeasurePropertiesQueryResponse(E[k],K.__batchResponses[k].data);break;default:Q.sap.log.fatal("invalid request type "+E[k].iRequestType);continue;}}g._deregisterCompletedRequest(E[k].sRequestId);g._cleanupGroupingForCompletedRequest(E[k].sRequestId);}if(g.mParameters&&g.mParameters.numberOfExpandedLevels>0){if(N==K.__batchResponses.length){g.mLength["/"]=0;g.mFinalLength["/"]=true;}}var O=true;var V;g.fireDataReceived({data:K});var W={};if(g.iModelVersion===A.V1){V=g.oModel._getBatchErrors(K);if(V.length>0){O=false;W=g.oModel._handleError(V[0]);}g.oModel.fireRequestCompleted({url:L.requestUri,type:"POST",async:true,info:"",infoObject:{},success:O,errorobject:O?{}:W});if(O){g.oModel.checkUpdate();}}}function J(k){if(k&&k.statusText!="abort"){g._deregisterHandleOfCompletedRequest(R);for(var j=-1,K;(K=E[++j])!==undefined;){g._deregisterCompletedRequest(K.sRequestId);g._cleanupGroupingForCompletedRequest(K.sRequestId);}}if(e!=g.iAnalyticalInfoVersionNumber){return;}var V=k;if(g.iModelVersion===A.V1){V=g.oModel._handleError(k);}g.oModel.fireRequestCompleted({url:"",type:"POST",async:true,info:"",infoObject:{},success:false,errorobject:V});if(g.iModelVersion===A.V1){g.oModel.fireRequestFailed(V);}g.fireDataReceived();}};x.prototype._executeQueryRequest=function(r){if(r.iRequestType==x._requestType.groupMembersAutoExpansionQuery){for(var i=-1,o;(o=r.aGroupMembersAutoExpansionRequestDetails[++i])!==undefined;){this._executeQueryRequest(o);}return;}var e=this.iAnalyticalInfoVersionNumber;var g=r.oAnalyticalQueryRequest,G=r.sGroupId;var p=g.getURIToQueryResultEntitySet();var P=this._getQueryODataRequestOptions(g,r.bIsLeafGroupsRequest);if(!P){return;}var h=this;if(g.getURIQueryOptionValue("$select")==null){this.fireDataRequested({__simulateAsyncAnalyticalBinding:true});G=null;this.mServiceLength[G]=this.mLength[G]=1;this.mServiceFinalLength[G]=true;this._setServiceKey(this._getKeyIndexMapping(G,0),x._artificialRootContextGroupId);this.bNeedsUpdate=true;setTimeout(function(){if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({__simulateAsyncAnalyticalBinding:true});}});this.bArtificalRootContext=true;return;}this._registerNewRequest(r.sRequestId);this.fireDataRequested();for(var j=0;j<P.length;j++){P[j]=P[j].replace(/\ /g,"%20");}Q.sap.log.debug("AnalyticalBinding: executing query request");var R=this._getIdForNewRequestHandle();if(this.iModelVersion===A.V1){this.oModel._loadData(p,P,s,E,false,U,l);}else{if(this.sCustomParams){P.push(this.sCustomParams);}var k=this.oModel.read(p,{success:s,error:E,context:this.oContext,urlParameters:P});h._registerNewRequestHandle(R,k);}function s(D){h._deregisterHandleOfCompletedRequest(R);if(e!=h.iAnalyticalInfoVersionNumber){h._deregisterCompletedRequest(r.sRequestId);return;}switch(r.iRequestType){case x._requestType.groupMembersQuery:h._processGroupMembersQueryResponse(r,D);break;case x._requestType.totalSizeQuery:h._processTotalSizeQueryResponse(r,D);break;case x._requestType.levelMembersQuery:h._processLevelMembersQueryResponse(r,D);break;case x._requestType.reloadMeasuresQuery:h._processReloadMeasurePropertiesQueryResponse(r,D);break;default:Q.sap.log.fatal("invalid request type "+r.iRequestType);break;}h._deregisterCompletedRequest(r.sRequestId);if(h.iModelVersion===A.V2){l(D);}}function l(D){if(e!=h.iAnalyticalInfoVersionNumber){return;}if(h._cleanupGroupingForCompletedRequest(r.sRequestId)){h.fireDataReceived({data:D});}}function E(m){if(m&&m.statusText=="abort"){h.fireDataReceived();return;}h._deregisterHandleOfCompletedRequest(R);h._deregisterCompletedRequest(r.sRequestId);h._cleanupGroupingForCompletedRequest(r.sRequestId);if(e!=h.iAnalyticalInfoVersionNumber){return;}h.fireDataReceived();}function U(k){h._registerNewRequestHandle(R,k);}};x.prototype._abortAllPendingRequests=function(){this._abortAllPendingRequestsByHandle();this._clearAllPendingRequests();};x.prototype._processGroupMembersQueryResponse=function(R,D){var e,G=R.sGroupId,H=this.aSorter.length>0,s=R.aSelectedUnitPropertyName,n=R.aAggregationLevel,z=R.oKeyIndexMapping.iIndex,E=R.oKeyIndexMapping.iServiceKeyIndex,L=R.iLength,K=R.oKeyIndexMapping,I=G==null?0:this._getGroupIdLevel(G)+1,U=(s.length>0),P,J,M,N=0,O,V,W=[];var X=D.results.length;if(G===null&&X>1&&this._canApplySortersToGroups()){this._warnNoSortingOfGroups(H?"binding is refreshed":undefined);if(H){setTimeout(this.refresh.bind(this),0);return;}}var Y=this._getServiceKeys(G,K.iIndex-1);P=undefined;if(Y&&Y.length>0){for(var i=0,Z=Y.length;i<Z;i++){D.results[i-Z]=this.oModel.getObject("/"+Y[i]);}var $=D.results[-Y.length];P="";for(var j=0;j<n.length;j++){P+=$[n[j]]+"|";}}O=Y&&Y.length==1;for(var h=0;h<X;h++){var _=D.results[h];if(U){J="";for(var g=0;g<n.length;g++){J+=_[n[g]]+"|";}if(P==J){this._warnNoSortingOfGroups();if(M===undefined){if(h==0){M=-Y.length;K.iServiceKeyIndex-=Y.length-1;}else{M=h-1;}}var a1=-1,b1=D.results[h-1];for(var k=0;k<s.length;k++){if(b1[s[k]]!=_[s[k]]){a1=k;break;}}if(a1==-1){Q.sap.log.fatal("assertion failed: no deviating units found for result entries "+(h-1)+" and "+h,null,null,y(this,"NO_DEVIATING_UNITS"));}}if((P!=J||h==X-1)&&M!==undefined){var c1=[];for(var l=M;l<h;l++){c1.push(D.results[l]);}if(P==J){c1.push(D.results[h]);}var d1=[];for(var m=0;m<s.length;m++){var e1=s[m];for(var o=1;o<c1.length;o++){if(c1[o-1][e1]!=c1[o][e1]){d1.push(e1);break;}}}var f1=this._createMultiUnitRepresentativeEntry(G,D.results[M],s,d1,R.bIsFlatListRequest);if(f1.aReloadMeasurePropertyName.length>0){V=this._prepareReloadMeasurePropertiesQueryRequest(x._requestType.reloadMeasuresQuery,R,f1);if(V.oAnalyticalQueryRequest&&V.oAnalyticalQueryRequest.getURIQueryOptionValue("$select")!=null){W.push(V);}}var g1=this._setAdjacentMultiUnitKeys(K,f1,c1);var h1;if(f1.bIsNewEntry){h1=c1.length-1;}else{h1=g1;}if(O){O=false;}if(h1<0){Q.sap.log.fatal("assertion failed: iDiscardedEntriesCount must be non-negative");}N+=h1;var i1=this.oModel._getKey(f1.oEntry);var j1=this.oModel.getContext('/'+i1);this._getGroupIdFromContext(j1,I);this.mEntityKey[e]=i1;M=undefined;if(P!=J){O=this._setServiceKey(K,this.oModel._getKey(_));}}else if(P!=J){O=this._setServiceKey(K,this.oModel._getKey(_));}P=J;}else{this._setServiceKey(K,this.oModel._getKey(_));}if(!R.bIsLeafGroupsRequest){var k1=this._getKey(G,K.iIndex-1);e=this._getGroupIdFromContext(this.oModel.getContext('/'+k1),I);this.mEntityKey[e]=k1;}}var l1=[];if(this.bReloadSingleUnitMeasures&&W.length>0){if(this.bUseBatchRequests){this.aBatchRequestQueue.push([x._requestType.reloadMeasuresQuery,W]);Promise.resolve().then(x.prototype._processRequestQueue.bind(this));}else{for(var q=0;q<W.length;q++){var m1=W[q];this._executeQueryRequest(m1);}}for(var p=0;p<W.length;p++){var n1=W[p];l1.push(n1.sRequestId);}this._considerRequestGrouping(l1);}if(Y&&Y.length>0){for(var r=0,o1=Y.length;r<o1;r++){delete D.results[r-o1];}}if(U){N+=this._mergeLoadedKeyIndexWithSubsequentIndexes(K,n,s,R.bIsFlatListRequest);}if(!R.bAvoidLengthUpdate){var p1=false;if(D.__count){this.mServiceLength[G]=parseInt(D.__count,10);this.mLength[G]=this.mServiceLength[G]-N;this.mFinalLength[G]=true;if(R.bIsFlatListRequest){this.iTotalSize=D.__count;}p1=true;}if(this.mServiceLength[G]<E+X){this.mServiceLength[G]=E+X;this.mLength[G]=z+X-N;this.mFinalLength[G]=false;}if(X<L||L===undefined){this.mServiceLength[G]=E+X;this.mLength[G]=z+K.iIndex-z;this.mFinalLength[G]=true;p1=true;}if(X==0){this.mLength[G]=this.mServiceLength[G]=0;this.mFinalLength[G]=true;p1=true;}if(!p1&&this.mLength[G]!==undefined&&N>0){this.mLength[G]-=N;}}this.bNeedsUpdate=true;if(N>0){if(D.results.length-N>0){this.aMultiUnitLoadFactor[n.length]=D.results.length/(D.results.length-N);}if(this.aMultiUnitLoadFactor[n.length]<1.5){this.aMultiUnitLoadFactor[n.length]=2;}}Q.sap.log.info("MultiUnit Situation in Group ("+G+"), discarded: "+N+", load-factor is now: "+this.aMultiUnitLoadFactor[n.length]);};x.prototype._processTotalSizeQueryResponse=function(r,D){if(D.__count==undefined){Q.sap.log.fatal("missing entity count in query result");return;}this.iTotalSize=D.__count;};x.prototype._processLevelMembersQueryResponse=function(r,D){var e=this;var p,P;var g=function(h,I){var G={iRequestType:x._requestType.groupMembersQuery,sRequestId:e._getRequestId(x._requestType.groupMembersQuery,{groupId:p}),oAnalyticalQueryRequest:r.oAnalyticalQueryRequest,sGroupId:p,aSelectedUnitPropertyName:r.aSelectedUnitPropertyName,aAggregationLevel:r.aAggregationLevel,bIsFlatListRequest:r.bIsFlatListRequest,bIsLeafGroupsRequest:r.bIsLeafGroupsRequest,iStartIndex:h?r.iStartIndex:0,iLength:r.iLength,bAvoidLengthUpdate:r.bAvoidLengthUpdate};if(h&&r.iStartIndex>0&&(r.sGroupId_Missing_AtLevel!=G.sGroupId||e._getKeys(G.sGroupId)===undefined)){var s=e._getParentGroupId(G.sGroupId);var j=e._findKeyIndex(s,e.mEntityKey[G.sGroupId]);if(j==-1){Q.sap.log.fatal("assertion failed: failed to determine position of "+G.sGroupId+" in group "+s);}if(j>0&&e._getKey(s,j-1)!==undefined){var k=e._getKey(s,j-1);var l=e._getGroupIdFromContext(e.oModel.getContext('/'+k),e._getGroupIdLevel(G.sGroupId));e.mFinalLength[l]=true;G.iStartIndex=0;}}if(I){G.iLength=P.length;}G.oKeyIndexMapping=e._getKeyIndexMapping(G.sGroupId,G.iStartIndex);var m=Q.extend(true,{},D);m.results=P;e._processGroupMembersQueryResponse(G,m);};if(D.results.length==0){return;}p=this._getGroupIdFromContext(this.oModel.getContext("/"+this.oModel._getKey(D.results[0])),r.iLevel-1);P=[];var h=true;for(var i=0;i<D.results.length;i++){var E=D.results[i];var o=this.oModel.getContext("/"+this.oModel._getKey(D.results[i]));var s=this._getGroupIdFromContext(o,r.iLevel-1);if(p==s){P.push(E);if(i<D.results.length-1){continue;}}g(h,D.results.length==r.iLength&&i==D.results.length-1);h=false;if(p!=s){P=[E];}p=s;}if(D.results.length>1&&P.length==1){g(h,D.results.length==r.iLength);}};x.prototype._processReloadMeasurePropertiesQueryResponse=function(r,D){var m=r.oMultiUnitRepresentative;var M=this.oModel.getKey(m.oEntry);if(D.results.length!=1){Q.sap.log.fatal("assertion failed: more than one entity for reloaded measure properties of entity with key "+M);return;}var R=D.results[0];var o=this.oModel.getObject("/"+M);if(!o){Q.sap.log.fatal("assertion failed: no entity found with key "+M);return;}var e=m.aReloadMeasurePropertyName;for(var i=0;i<e.length;i++){o[e[i]]=R[e[i]];}};x.prototype._getLoadedContextsForGroup=function(g,s,l,e){var h=[],o,i,k=this._getKeys(g),K;if(!k){return h;}if(!s){s=0;}if(!l){l=this.oModel.iSizeLimit;if(this.mFinalLength[g]){l=this.mLength[g];}}if(e){i=s||0;K=k(i);while(K){o=this.oModel.getContext('/'+K);h.push(o);i++;K=k(i);}return h;}for(i=s;i<s+l;i++){K=k(i);if(!K){break;}o=this.oModel.getContext('/'+K);h.push(o);}return h;};x.prototype._calculateRequiredGroupSection=function(g,s,l,e,h){var k,m,p,P,r,o={},K=this._getKeys(g),n;m=s;k=0;if(!K){P=s;p=s+l;}else{for(var i=s-1;i>=Math.max(s-e,0);i--){n=K(i);if(!n){P=i+1;break;}}for(var j=s+l;j<s+l+e;j++){n=K(j);if(!n){p=j;break;}}}r=s-P;if(P&&s>e&&r<e){if(h.length!==l){m=s-e;}else{m=P-e;}k=e;}m=Math.max(m,0);if(m===s){m+=h.length;}if(h.length!==l){k+=l-h.length;}r=p-s-l;if(r==0){k+=e;}if(p&&r<e&&r>0){if(m>s){m=p;k+=e;}}if(this.mFinalLength[g]&&this.mLength[g]<(k+m)){k=this.mLength[g]-m;}o.startIndex=m;o.length=k;return o;};x.prototype._calculateRequiredGroupExpansion=function(g,e,s,l){var n={groupId_Missing:null,length_Missing:0};var h=this;var j=function(g,e,s,l){var L=h._getGroupIdLevel(g);if(L==e){var z=h._getLoadedContextsForGroup(g,s,l);var D=s+z.length-1;if(z.length>=l){return n;}else if(h.mFinalLength[g]){if(z.length>=h.mLength[g]){return{groupId_Missing:null,length_Missing:l-z.length};}else{return{groupId_Missing:g,startIndex_Missing:D+1,length_Missing:l-z.length};}}else{return{groupId_Missing:g,startIndex_Missing:D+1,length_Missing:l-z.length};}}var E=h._getLoadedContextsForGroup(g,s,l);var k=l,H=s+E.length-1;for(var i=-1,I;(I=E[++i])!==undefined;){k--;var G=j(h._getGroupIdFromContext(I,L+1),e,0,k);if(G.groupId_Missing==null){if(G.length_Missing==0){return G;}else{k=G.length_Missing;}}else{return G;}if(k==0){break;}}if(h.mFinalLength[g]||k==0){return{groupId_Missing:null,length_Missing:k};}else{return{groupId_Missing:g,startIndex_Missing:H+1,length_Missing:k};}};var L=this._getGroupIdLevel(g);if(L==e+1){g=this._getParentGroupId(g);--L;}if(g==null||L>e){return n;}var k=l,m=s;while(g!=null){var G=j(g,e,m,k);if(G.groupId_Missing!=null){return G;}else if(G.length_Missing==0){return G;}else{var o=false;while(!o){var p=this._getParentGroupId(g);if(p==null){g=p;--L;break;}var q=this.mEntityKey[g];if(!q){return n;}var r=this._findKeyIndex(p,q);if(r==-1){return n;}if(r==this._getKeyCount(p)-1){if(this.mFinalLength[p]){g=p;--L;continue;}else{return{groupId_Missing:p,startIndex_Missing:r+1,length_Missing:k};}}else{q=this._getKey(p,r+1);g=this._getGroupIdFromContext(this.oModel.getContext('/'+q),L);o=true;}}m=0;k=G.length_Missing;}}return{groupId_Missing:null,length_Missing:k};};x.prototype._getResourcePath=function(){return this.isRelative()?this.oModel.resolve(this.sPath,this.getContext()):this.sPath;};x.prototype._getEntitySet=function(){var e=this.sEntitySetName;if(!e){e=this.sPath.split("/")[1];if(e.indexOf("(")!=-1){e=e.split("(")[0]+"Results";}}return e;};x.prototype._getEffectiveSortOrder=function(p){for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]&&this.aSorter[i].sPath==p){return this.aSorter[i].bDescending?f.SortOrder.Descending:f.SortOrder.Ascending;}}return null;};x.prototype._getFilterOperatorMatchingPropertySortOrder=function(p,W){var s;switch(this._getEffectiveSortOrder(p)){case f.SortOrder.Ascending:if(W){s=a.GE;}else{s=a.GT;}break;case f.SortOrder.Descending:if(W){s=a.LE;}else{s=a.LT;}break;default:s=a.GT;}return s;};x.prototype._convertDeprecatedFilterObjects=function(e){if(!e){return e;}var O=sap.ui.require("sap/ui/model/odata/Filter");if(typeof O==='function'){for(var i=0,l=e.length;i<l;i++){if(e[i]instanceof O){e[i]=e[i].convert();}}}return e;};x.prototype._getGroupIdFromContext=function(o,l){if(!o){return null;}var g="/";var D=null;if(l>this.aAggregationLevel.length){Q.sap.log.fatal("assertion failed: aggregation level deeper than number of current aggregation levels");}for(var i=0;i<l;i++){D=o.getProperty(this.aAggregationLevel[i]);if(D!=null){g+=encodeURIComponent(D)+"/";}else{g+="@/";}}return g;};x.prototype._getGroupIdLevel=function(g){if(g==null){Q.sap.log.fatal("assertion failed: no need to determine level of group ID = null");return-1;}return g.split("/").length-2;};x.prototype._getGroupIdComponents=function(g){if(g==null){return null;}var G=g.split("/");var D=[];for(var i=1;i<G.length-1;i++){if(G[i]=="@"){D[i-1]=null;}else{D[i-1]=decodeURIComponent(G[i]);}}return D;};x.prototype._getGroupIdAncestors=function(g,n){if(!n){return[];}if(g==null){Q.sap.log.fatal("group ID null does not have ancestors");return[];}if(g=="/"){if(Math.abs(n)==1){return[null];}else{Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);return[];}}var G=g.split("/");var e=[],s="";var h=0,k=G.length-3;if(n>0){if(n-1>k){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{k=n-1;}}else if(-(n+1)>k){Q.sap.log.fatal("invalid level count "+n+" for ancestors of groupId "+g);}else{h=k+1+n;for(var i=0;i<h;i++){s+=G[i]+"/";}}for(var j=h;j<=k;j++){s+=G[j]+"/";e.push(s);}return e;};x.prototype._getParentGroupId=function(g){return this._getGroupIdAncestors(g,-1)[0];};x.prototype._removeDuplicatesFromStringArray=function(e){var o={};for(var i=0;i<e.length;i++){o[e[i]]=true;}var U=[];for(var s in o){U.push(s);}return U;};x.prototype._getIdForNewRequestHandle=function(){if(this.oPendingRequestHandle===undefined){this.oPendingRequestHandle=[];}for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]===undefined){return i;}}this.oPendingRequestHandle[this.oPendingRequestHandle.length]=undefined;return this.oPendingRequestHandle.length-1;};x.prototype._registerNewRequestHandle=function(r,R){if(this.oPendingRequestHandle[r]!==undefined){Q.sap.log.fatal("request handle ID already in use");}this.oPendingRequestHandle[r]=R;};x.prototype._deregisterHandleOfCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequestHandle)){Q.sap.log.warning("No request handles to be cleared. Previous abort/resetData?");return;}if(this.oPendingRequestHandle[r]===undefined){Q.sap.log.fatal("no handle found for this request ID");}this.oPendingRequestHandle[r]=undefined;};x.prototype._abortAllPendingRequestsByHandle=function(){for(var i=0;i<this.oPendingRequestHandle.length;i++){if(this.oPendingRequestHandle[i]){if(this.oPendingRequestHandle[i]!==undefined){this.oPendingRequestHandle[i].abort();}}}this.oPendingRequestHandle=[];};x.prototype._getRequestId=function(r,p){switch(r){case x._requestType.groupMembersQuery:if(p.groupId===undefined){Q.sap.log.fatal("missing group ID");}return x._requestType.groupMembersQuery+(p.groupId==null?"":p.groupId);case x._requestType.levelMembersQuery:if(p.level===undefined){Q.sap.log.fatal("missing level");}if(p.groupId===undefined){Q.sap.log.fatal("missing groupId");}return""+x._requestType.levelMembersQuery+p.level+(p.tupleIndex?"-"+p.tupleIndex:"");case x._requestType.totalSizeQuery:return x._requestType.totalSizeQuery;case x._requestType.reloadMeasuresQuery:if(!p.multiUnitEntryKey){Q.sap.log.fatal("missing multi unit entry key");}return x._requestType.reloadMeasuresQuery+p.multiUnitEntryKey;default:Q.sap.log.fatal("invalid request type "+r);return-1;}};x.prototype._registerNewRequest=function(r){if(r==undefined||r==""){Q.sap.log.fatal("missing request ID");return;}if(!this.oPendingRequests[r]){this.oPendingRequests[r]=1;}else{++this.oPendingRequests[r];}};x.prototype._considerRequestGrouping=function(r){for(var i=-1,R;(R=r[++i])!==undefined;){if(this.oGroupedRequests[R]===undefined){this.oGroupedRequests[R]={};}var g=this.oGroupedRequests[R];for(var j=0;j<r.length;j++){g[r[j]]=true;}}};x.prototype._isRequestPending=function(r){return this.oPendingRequests[r]!=undefined&&this.oPendingRequests[r]>0;};x.prototype._deregisterCompletedRequest=function(r){if(Q.isEmptyObject(this.oPendingRequests)){Q.sap.log.warning("There are no pending requests which could be set to 'completed'.");return;}if(!this.oPendingRequests[r]){Q.sap.log.fatal("assertion failed: there is no pending request ID "+r);}if(this.oPendingRequests[r]==1){delete this.oPendingRequests[r];}else{--this.oPendingRequests[r];}};x.prototype._cleanupGroupingForCompletedRequest=function(r){if(this._isRequestPending(r)){return false;}var g=true;if(this.oGroupedRequests[r]!=undefined){for(var o in this.oGroupedRequests[r]){if(this.oPendingRequests[o]){g=false;break;}}}if(g){var R=this.oGroupedRequests[r];delete this.oGroupedRequests[r];for(var O in R){if(O!=r){this._cleanupGroupingForCompletedRequest(O);}}}return g;};x.prototype._getKeyIndexMapping=function(g,s){var k=this.mKeyIndex[g];var e=this.mServiceKey[g];var i=s;if(k!==undefined){var l=s;if(l>0){while(--l>0){if(k[l]!==undefined){break;}}}var L;if(l==0){L=0;}else{if(k[l]>=0){L=k[l];}else if(k[l+1]===undefined){L=k[l]=="ZERO"?0:-k[l];while(e[L+1]!==undefined){++L;}}else{L=Math.abs(k[l+1])-1;}if(e[L]===undefined){Q.sap.log.fatal("assertion failed: no service key at iLastOccupiedServiceKeyIndex = "+L);}}var D=s-l;i=L+D;}var K={sGroupId:g,iIndex:s,iServiceKeyIndex:i};return K;};x.prototype._moveKeyIndexMapping=function(k,i){return this._getKeyIndexMapping(k.sGroupId,k.iIndex+i);};x.prototype._getKey=function(g,i){var s=this.mKeyIndex[g][i];if(s===undefined){return undefined;}if(s>=0){return this.mServiceKey[g][s];}if(this.mMultiUnitKey[g]===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g);return null;}var k=this.mMultiUnitKey[g][i];if(k===undefined){Q.sap.log.fatal("assertion failed: missing expected multi currency key for group with ID "+g+" at pos "+i);return null;}return k;};x.prototype._getKeys=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}var e=this;return function(i){return e._getKey(g,i);};};x.prototype._getServiceKeys=function(g,I){var k=this.mKeyIndex[g];if(k===undefined){return undefined;}var s=this.mServiceKey[g],e=k[I];if(e===undefined){return undefined;}if(e>=0){return[s[e]];}var G=[];if(k[I+1]===undefined){e=k[I]=="ZERO"?0:-k[I];while(s[e]!==undefined){G.push(s[e++]);}}else{e=k[I]=="ZERO"?0:-k[I];for(var i=e,n=Math.abs(k[I+1]);i<n;i++){G.push(s[i]);}}return G;};x.prototype._getKeyCount=function(g){if(this.mKeyIndex[g]===undefined){return undefined;}return this.mKeyIndex[g].length;};x.prototype._findKeyIndex=function(g,k){var K=this.mKeyIndex[g];var s=this.mServiceKey[g];var m=this.mMultiUnitKey[g];for(var i=0;i<this.mLength[g];i++){if(K[i]<0){if(m[i]==k){return i;}}else if(s[K[i]]==k){return i;}}return-1;};x.prototype._setServiceKey=function(k,s){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}var n=this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]===undefined;this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=s;this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex-1;return n;};x.prototype._setAdjacentMultiUnitKeys=function(k,m,M){if(!this.mServiceKey[k.sGroupId]){this.mServiceKey[k.sGroupId]=[];}if(!this.mKeyIndex[k.sGroupId]){this.mKeyIndex[k.sGroupId]=[];}if(!this.mMultiUnitKey[k.sGroupId]){this.mMultiUnitKey[k.sGroupId]=[];}--k.iIndex;--k.iServiceKeyIndex;this.mMultiUnitKey[k.sGroupId][k.iIndex]=this.oModel._getKey(m.oEntry);this.mKeyIndex[k.sGroupId][k.iIndex++]=k.iServiceKeyIndex>0?-k.iServiceKeyIndex:"ZERO";var n=0;for(var i=0;i<M.length;i++){if(!this.mServiceKey[k.sGroupId][k.iServiceKeyIndex]){++n;}this.mServiceKey[k.sGroupId][k.iServiceKeyIndex++]=this.oModel._getKey(M[i]);}return n;};x.prototype._mergeLoadedKeyIndexWithSubsequentIndexes=function(k,e,s,I){var K=this.mKeyIndex[k.sGroupId],g=this.mServiceKey[k.sGroupId],m=this.mMultiUnitKey[k.sGroupId],D=0,n=k.iServiceKeyIndex,h=k.iIndex;var M,o;if(K===undefined){return D;}var N=false;var p=g[n-1],j=g[n];if(j===undefined){return D;}if(p===undefined){Q.sap.log.fatal("assertion failed: missing expected entry before given key index");return D;}var P=this.oModel.getObject("/"+p);var l=this.oModel.getObject("/"+j);var q="",r="";for(var i=0;i<e.length;i++){q+=P[e[i]]+"|";r+=l[e[i]]+"|";}N=q==r;var z=h;if(z>=this.mLength[k.sGroupId]){Q.sap.log.fatal("assertion failed: service key exists,but no corresponding key index found");return D;}while(K[z]===undefined||Math.abs(K[z])<n){++z;}if(N){if(Math.abs(K[z])==n&&K[z]<0){if(z>h){if(K[h-1]<0){m[z]=undefined;K.splice(h,z-h+1);m.splice(h,z-h+1);}else{K[h-1]=-K[h-1];m[h-1]=m[z];m[z]=undefined;K.splice(h,z-h+1);m.splice(h,z-h+1);D=1;}}}else if(Math.abs(K[z])>n){var E=z-1;if(K[E]>0){M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);K[E]=-K[E];m[E]=o;if(E>h){K.splice(h,E-h);m.splice(h,E-h);}if(M.bIsNewEntry){D=1;}else{D=0;}}else if(K[h-1]<0){if(z>h){m[E]=undefined;K.splice(h,E-h+1);m.splice(h,E-h+1);}}else{K[h-1]=-K[h-1];m[h-1]=m[E];m[E]=undefined;K.splice(h,E-h+1);m.splice(h,E-h+1);}}else if(K[z]==n){if(z>h){if(K[h-1]<0){K.splice(h,z-h+1);m.splice(h,z-h+1);D=1;}else{M=this._createMultiUnitRepresentativeEntry(k.sGroupId,P,s,undefined,I);o=this.oModel._getKey(M.oEntry);if(!M.bIsNewEntry){Q.sap.log.fatal("assertion failed: multi-unit entry already existed before");}K[h-1]=-K[h-1];m[h-1]=o;K.splice(h,z-h+1);m.splice(h,z-h+1);D=1;}}}else{Q.sap.log.fatal("assertion failed: uncovered case detected");return D;}}else if(K[z]>n){Q.sap.log.fatal("unstable query result for group ID "+k.sGroupId+": entries have been removed or added. Complete reload required");}else if(z-h>0){K.splice(h,z-h);m.splice(h,z-h);}return D;};x.prototype._createMultiUnitRepresentativeEntry=function(g,r,s,D,i){var m=Q.extend(true,{},r);var R=[];for(var M in this.oMeasureDetailsSet){var o=this.oMeasureDetailsSet[M];if(!i&&!this.mAnalyticalInfoByProperty[M].total){if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=undefined;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]=undefined;}}else{if(o.rawValuePropertyName!=undefined){m[o.rawValuePropertyName]=null;}if(o.formattedValuePropertyName!=undefined){m[o.formattedValuePropertyName]="*";}}if(D){if(!o.unitPropertyName||Q.inArray(o.unitPropertyName,D)==-1){R.push(o.rawValuePropertyName);}}}for(var k=0;k<s.length;k++){if(Q.inArray(s[k],D)!=-1){m[s[k]]="*";}}var e="";for(var l=0;l<this.aAllDimensionSortedByName.length;l++){var h=m[this.aAllDimensionSortedByName[l]];var j=h===""?'""':h;j=j===undefined?"":j;e+=(encodeURIComponent(j)+",");}e+="-multiple-units-not-dereferencable";var n;if(this.mMultiUnitKey[g]&&(n=Q.inArray(e,this.mMultiUnitKey[g]))!=-1){return{oEntry:this.oModel.getObject("/"+e),bIsNewEntry:false,iIndex:n,aReloadMeasurePropertyName:R};}m.__metadata.uri=e;delete m.__metadata["self"];delete m.__metadata["self_link_extensions"];m["^~volatile"]=true;this.oModel._importData(m,{},{});var p=this.oModel._getKey(m);this.oModel.getContext('/'+p)["_volatile"]=true;return{oEntry:m,bIsNewEntry:true,aReloadMeasurePropertyName:R};};x.prototype._clearAllPendingRequests=function(){this.oPendingRequests={};this.oGroupedRequests={};};x.prototype.resetData=function(o){var g=o?o.getPath():undefined;this._resetData(g);};x.prototype._resetData=function(g){if(g){delete this.mServiceKey[g];delete this.mServiceLength[g];delete this.mServiceFinalLength[g];delete this.mKeyIndex[g];delete this.mLength[g];delete this.mMultiUnitKey[g];delete this.mEntityKey[g];}else{this.mServiceKey={};this.mServiceLength={};this.mServiceFinalLength={};this.mFinalLength=this.mServiceFinalLength;this.mKeyIndex={};this.mLength={};this.mMultiUnitKey={};this.mEntityKey={};}};x.prototype.refresh=function(e){x.prototype._refresh.apply(this,arguments);};x.prototype._refresh=function(e,m,E){var g=false;if(!e){if(E){var r=this.oModel.resolve(this.sPath,this.oContext);var o=this.oModel.oMetadata._getEntityTypeByPath(r);if(o&&(o.entityType in E)){g=true;}}if(m&&!g){Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}if(!m&&!E){g=true;}}if(e||g){this._abortAllPendingRequests();this.resetData();this.bNeedsUpdate=false;this._fireRefresh({reason:C.Refresh});}};x.prototype.checkUpdate=function(e,m){var g=false;if(!e){if(this.bNeedsUpdate||!m){g=true;}else{Q.each(this.mServiceKey,function(i,n){Q.each(n,function(i,k){if(k in m){g=true;return false;}});if(g){return false;}});}}if(e||g){this.bNeedsUpdate=false;this._fireChange({reason:C.Change});}};x.prototype.getDownloadUrl=function(s){var e,p,z;var o=new f.QueryResultRequest(this.oAnalyticalQueryResult);o.setResourcePath(this._getResourcePath());var g=[];var h=[];for(var D in this.oDimensionDetailsSet){g.push(D);}o.setAggregationLevel(g);for(var n in this.oDimensionDetailsSet){var q=this.oDimensionDetailsSet[n];var I=(q.textPropertyName!=undefined);o.includeDimensionKeyTextAttributes(q.name,true,I,q.aAttributeName);}for(var M in this.oMeasureDetailsSet){h.push(M);}o.setMeasures(h);for(var r in this.oMeasureDetailsSet){var E=this.oMeasureDetailsSet[r];var G=(E.rawValuePropertyName!=undefined);var H=(E.formattedValuePropertyName!=undefined);var J=(E.unitPropertyName!=undefined);o.includeMeasureRawFormattedValueUnit(E.name,G,H,J);}var K=o.getSortExpression();K.clear();for(var i=0;i<this.aSorter.length;i++){if(this.aSorter[i]){K.addSorter(this.aSorter[i].sPath,this.aSorter[i].bDescending?f.SortOrder.Descending:f.SortOrder.Ascending);}}var L=o.getFilterExpression();L.clear();if(this.aApplicationFilter){L.addUI5FilterConditions(this.aApplicationFilter);}if(this.aControlFilter){L.addUI5FilterConditions(this.aControlFilter);}var P=o.getURIToQueryResultEntitySet();var N=this._getQueryODataRequestOptions(o,true);if(!N){return undefined;}var O=[];for(var k=0,m=this.aAnalyticalInfo.length;k<m;k++){var R=this.aAnalyticalInfo[k];if((R.visible||R.inResult)&&R.name!==""&&R.name!==O[O.length-1]){O.push(R.name);if(this.oMeasureDetailsSet[R.name]!=undefined&&this.oMeasureDetailsSet[R.name].unitPropertyName!=undefined){O.push(this.oMeasureDetailsSet[R.name].unitPropertyName);}}}for(var j=0,l=N.length;j<l;j++){if(/^\$select/i.test(N[j])){if(this.mParameters.select){e=N[j].slice(8).split(",");for(z=0;z<e.length;z++){p=e[z];if(O.indexOf(p)===-1){O.push(p);}}}N[j]="$select="+O.join(",");break;}}if(s){N.splice(0,0,"$format="+encodeURIComponent(s));}if(this.sCustomParams){N.push(this.sCustomParams);}if(P){return this.oModel._createRequestUrl(P,null,N).replace(/ /g,"%20");}};x.prototype._addSorters=function(s,g){var e=this._canApplySortersToGroups()?[].concat(this.aSorter).concat(g):[].concat(g).concat(this.aSorter);e.forEach(function(o){s.addSorter(o.sPath,o.bDescending?f.SortOrder.Descending:f.SortOrder.Ascending);});};x.prototype._canApplySortersToGroups=function(){var s=this._autoExpandMode;if(this.bApplySortersToGroups){if(this.aSorter.length>0){if(s!==this.sLastAutoExpandMode&&s!==d.Sequential){Q.sap.log.warning("Applying sorters to groups is only possible with auto"+" expand mode 'Sequential'; current mode is: "+s,this.sPath,t);}this.sLastAutoExpandMode=s;}return s===d.Sequential;}return false;};x.prototype._warnNoSortingOfGroups=function(D){var m;if(this.bApplySortersToGroups){m="Detected a multi-unit case, so sorting is only possible on leaves";if(D){m+="; "+D;}Q.sap.log.warning(m,this.sPath,t);}this.bApplySortersToGroups=false;};return x;});
