/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(['jquery.sap.global','sap/ui/model/BindingMode','sap/ui/model/Context','sap/ui/model/Model','./ODataUtils','./CountMode','./ODataContextBinding','./ODataListBinding','./ODataMetadata','./ODataPropertyBinding','./ODataTreeBinding','sap/ui/model/odata/ODataMetaModel','sap/ui/thirdparty/URI','sap/ui/thirdparty/datajs'],function(q,B,C,M,O,a,b,c,d,e,f,g,U,h){"use strict";var m=M.extend("sap.ui.model.odata.ODataModel",{constructor:function(s,j,u,p,H,t,w,l){M.apply(this,arguments);var i,r,k,A=null,L,n,D,S,o,v,x=this;if(typeof(s)==="object"){j=s;s=j.serviceUrl;}if(typeof j==="object"){u=j.user;p=j.password;H=j.headers;t=j.tokenHandling;l=j.loadMetadataAsync;w=j.withCredentials;k=j.maxDataServiceVersion;i=j.useBatch;r=j.refreshAfterChange;A=j.annotationURI;L=j.loadAnnotationsJoined;D=j.defaultCountMode;n=j.metadataNamespaces;S=j.serviceUrlParams;o=j.metadataUrlParams;v=j.skipMetadataAnnotationParsing;j=j.json;}this.oServiceData={};this.sDefaultBindingMode=B.OneWay;this.mSupportedBindingModes={"OneWay":true,"OneTime":true,"TwoWay":true};this.mUnsupportedFilterOperators={"Any":true,"All":true};this.bCountSupported=true;this.bJSON=j;this.bCache=true;this.aPendingRequestHandles=[];this.oRequestQueue={};this.aBatchOperations=[];this.oHandler;this.bTokenHandling=t!==false;this.bWithCredentials=w===true;this.bUseBatch=i===true;this.bRefreshAfterChange=r!==false;this.sMaxDataServiceVersion=k;this.bLoadMetadataAsync=!!l;this.bLoadAnnotationsJoined=L===undefined?true:L;this.sAnnotationURI=A;this.sDefaultCountMode=D||a.Both;this.oMetadataLoadEvent=null;this.oMetadataFailedEvent=null;this.bSkipMetadataAnnotationParsing=v;this.oHeaders={};this.setHeaders(H);this.oData={};this.oMetadata=null;this.oAnnotations=null;this.aUrlParams=[];if(s.indexOf("?")==-1){this.sServiceUrl=s;}else{var y=s.split("?");this.sServiceUrl=y[0];if(y[1]){this.aUrlParams.push(y[1]);}}if(sap.ui.getCore().getConfiguration().getStatistics()){this.aUrlParams.push("sap-statistics=true");}this.sServiceUrl=this.sServiceUrl.replace(/\/$/,"");var z=this._createRequestUrl("$metadata",undefined,o);if(!m.mServiceData[z]){m.mServiceData[z]={};}this.oServiceData=m.mServiceData[z];if(this.bTokenHandling&&this.oServiceData.securityToken){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}this.sUser=u;this.sPassword=p;this.oHeaders["Accept-Language"]=sap.ui.getCore().getConfiguration().getLanguageTag();if(!this.oServiceData.oMetadata){this.oServiceData.oMetadata=new d(z,{async:this.bLoadMetadataAsync,user:this.sUser,password:this.sPassword,headers:this.mCustomHeaders,namespaces:n,withCredentials:this.bWithCredentials});}this.oMetadata=this.oServiceData.oMetadata;this.pAnnotationsLoaded=this.oMetadata.loaded();if(this.sAnnotationURI||!this.bSkipMetadataAnnotationParsing){var E=this._getAnnotationParser();if(!this.bSkipMetadataAnnotationParsing){if(!this.bLoadMetadataAsync){this.addAnnotationXML(this.oMetadata.sMetadataBody,!!this.sAnnotationURI);}else{this.pAnnotationsLoaded=this.oMetadata.loaded().then(function(F,P){if(this.bDestroyed){return Promise.reject();}return this.addAnnotationXML(P["metadataString"],F);}.bind(this,!!this.sAnnotationURI));}}if(this.sAnnotationURI){if(this.bLoadMetadataAsync){this.pAnnotationsLoaded=this.pAnnotationsLoaded.then(E.addUrl.bind(E,this.sAnnotationURI));}else{this.pAnnotationsLoaded=Promise.all([this.pAnnotationsLoaded,E.addUrl(this.sAnnotationURI)]);}}}if(S){this.aUrlParams=this.aUrlParams.concat(O._createUrlParamsArray(S));}this.onMetadataLoaded=function(F){x._initializeMetadata();x.initialize();};this.onMetadataFailed=function(F){x.fireMetadataFailed(F.getParameters());};if(!this.oMetadata.isLoaded()){this.oMetadata.attachLoaded(this.onMetadataLoaded);this.oMetadata.attachFailed(this.onMetadataFailed);}if(this.oMetadata.isFailed()){this.refreshMetadata();}if(this.oMetadata.isLoaded()){this._initializeMetadata(true);}if(this.bJSON){if(this.sMaxDataServiceVersion==="3.0"){this.oHeaders["Accept"]="application/json;odata=fullmetadata";}else{this.oHeaders["Accept"]="application/json";}this.oHandler=h.jsonHandler;}else{this.oHeaders["Accept"]="application/atom+xml,application/atomsvc+xml,application/xml";this.oHandler=h.atomHandler;}this.oHeaders["MaxDataServiceVersion"]="2.0";if(this.sMaxDataServiceVersion){this.oHeaders["MaxDataServiceVersion"]=this.sMaxDataServiceVersion;}this.oHeaders["DataServiceVersion"]="2.0";},metadata:{publicMethods:["create","remove","update","submitChanges","getServiceMetadata","read","hasPendingChanges","refresh","refreshMetadata","resetChanges","isCountSupported","setCountSupported","setDefaultCountMode","getDefaultCountMode","forceNoCache","setProperty","getSecurityToken","refreshSecurityToken","setHeaders","getHeaders","setUseBatch"]}});m.M_EVENTS={RejectChange:"rejectChange",MetadataLoaded:"metadataLoaded",MetadataFailed:"metadataFailed",AnnotationsLoaded:"annotationsLoaded",AnnotationsFailed:"annotationsFailed"};m.mServiceData={};m.prototype.fireRejectChange=function(A){this.fireEvent("rejectChange",A);return this;};m.prototype.attachRejectChange=function(D,F,l){this.attachEvent("rejectChange",D,F,l);return this;};m.prototype.detachRejectChange=function(F,l){this.detachEvent("rejectChange",F,l);return this;};m.prototype._initializeMetadata=function(D){var t=this;this.bUseBatch=this.bUseBatch||this.oMetadata.getUseBatch();var i=function(j){if(!!j){t.metadataLoadEvent=q.sap.delayedCall(0,t,i);}else{if(t.oMetadata){t.fireMetadataLoaded({metadata:t.oMetadata});q.sap.log.debug("ODataModel fired metadataloaded");}}};if(this.sAnnotationURI&&this.bLoadAnnotationsJoined){if(this.oAnnotations&&(this.oAnnotations.bInitialized||this.oAnnotations.isFailed())){i(!this.bLoadMetadataAsync);}else{this.oAnnotations.attachEventOnce("loaded",function(){i(true);});}}else{i(D);}};m.prototype.fireAnnotationsLoaded=function(A){if(!this.bLoadMetadataAsync){setTimeout(this.fireEvent.bind(this,"annotationsLoaded",A),0);}else{this.fireEvent("annotationsLoaded",A);}return this;};m.prototype.attachAnnotationsLoaded=function(D,F,l){this.attachEvent("annotationsLoaded",D,F,l);return this;};m.prototype.detachAnnotationsLoaded=function(F,l){this.detachEvent("annotationsLoaded",F,l);return this;};m.prototype.fireAnnotationsFailed=function(A){if(!this.bLoadMetadataAsync){setTimeout(this.fireEvent.bind(this,"annotationsFailed",A),0);}else{this.fireEvent("annotationsFailed",A);}q.sap.log.debug("ODataModel fired annotationsfailed");return this;};m.prototype.attachAnnotationsFailed=function(D,F,l){this.attachEvent("annotationsFailed",D,F,l);return this;};m.prototype.detachAnnotationsFailed=function(F,l){this.detachEvent("annotationsFailed",F,l);return this;};m.prototype.fireMetadataLoaded=function(A){this.fireEvent("metadataLoaded",A);return this;};m.prototype.attachMetadataLoaded=function(D,F,l){this.attachEvent("metadataLoaded",D,F,l);return this;};m.prototype.detachMetadataLoaded=function(F,l){this.detachEvent("metadataLoaded",F,l);return this;};m.prototype.fireMetadataFailed=function(A){this.fireEvent("metadataFailed",A);return this;};m.prototype.attachMetadataFailed=function(D,F,l){this.attachEvent("metadataFailed",D,F,l);return this;};m.prototype.detachMetadataFailed=function(F,l){this.detachEvent("metadataFailed",F,l);return this;};m.prototype.refreshMetadata=function(){if(this.oMetadata&&this.oMetadata.refresh){this.oMetadata.refresh();}};m.prototype._createRequestUrl=function(p,o,u,i,j){var k,r,s,l="";if(p&&p.indexOf('?')!=-1){s=p.substr(p.indexOf('?')+1);p=p.substr(0,p.indexOf('?'));}r=this._normalizePath(p,o);if(!i){l=this.sServiceUrl+r;}else{l=r.substr(r.indexOf('/')+1);}k=O._createUrlParamsArray(u);if(this.aUrlParams){k=k.concat(this.aUrlParams);}if(s){k.push(s);}if(k.length>0){l+="?"+k.join("&");}if(j===undefined){j=true;}if(j===false){var t=q.now();var n=l.replace(/([?&])_=[^&]*/,"$1_="+t);l=n+((n===l)?(/\?/.test(l)?"&":"?")+"_="+t:"");}return l;};m.prototype._loadData=function(p,P,s,E,i,H,j){var r,R,t=this;function _(D,o){var v=D,w={};if(o.statusCode==204){if(s){s(null);}if(j){j(null);}t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:true});return;}if(!v){q.sap.log.fatal("The following problem occurred: No data was retrieved by service: "+o.requestUri);t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:false});return false;}if(t.bUseBatch){var x=t._getBatchErrors(D);if(x.length>0){k(x[0]);return false;}if(v.__batchResponses&&v.__batchResponses.length>0){v=v.__batchResponses[0].data;}else{q.sap.log.fatal("The following problem occurred: No data was retrieved by service: "+o.requestUri);}}n=n.concat(v.results);if(v.__next){var y=new U(v.__next);R.requestUri=y.absoluteTo(o.requestUri).toString();l(R);}else{q.sap.extend(v.results,n);if(v.results&&!Array.isArray(v.results)){v=v.results;}t._importData(v,w);if(t.sChangeKey&&w){var z=t.sChangeKey.substr(t.sChangeKey.lastIndexOf('/')+1);if(w[z]){delete t.oRequestQueue[t.sChangeKey];t.sChangeKey=null;}}if(s){s(v);}t.checkUpdate(false,false,w);if(j){j(v);}t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:true});}}function k(o){if(t.bTokenHandling&&o.response){var T=t._getHeader("x-csrf-token",o.response.headers);if(!R.bTokenReset&&o.response.statusCode=='403'&&T&&T.toLowerCase()=="required"){t.resetSecurityToken();R.bTokenReset=true;l();return;}}var v=t._handleError(o);if(E){E(o,r&&r.bAborted);}t.fireRequestCompleted({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+t.oHeaders["Accept"],infoObject:{acceptHeaders:t.oHeaders["Accept"]},success:false,errorobject:v});if(!r||!r.bAborted){v.url=R.requestUri;t.fireRequestFailed(v);}}function l(){if(t.bUseBatch){t.updateSecurityToken();var o=U.parse(R.requestUri).query;var v=t._createRequestUrl(p,null,o,t.bUseBatch);R=t._createRequest(v,"GET",true);var w=t._createBatchRequest([R],true);r=t._request(w,_,k,h.batchHandler,undefined,t.getServiceMetadata());}else{r=t._request(R,_,k,t.oHandler,undefined,t.getServiceMetadata());}if(H){var W={abort:function(){r.bAborted=true;r.abort();}};H(W);}}var n=[];var u=this._createRequestUrl(p,null,P,null,i||this.bCache);R=this._createRequest(u,"GET",true);this.fireRequestSent({url:R.requestUri,type:"GET",async:R.async,info:"Accept headers:"+this.oHeaders["Accept"],infoObject:{acceptHeaders:this.oHeaders["Accept"]}});l();};m.prototype._importData=function(D,k){var t=this,l,K,r,E;if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._importData(j,k));});return l;}else{K=this._getKey(D);E=this.oData[K];if(!E){E=D;this.oData[K]=E;}q.each(D,function(n,p){if(p&&(p.__metadata&&p.__metadata.uri||p.results)&&!p.__deferred){r=t._importData(p,k);if(Array.isArray(r)){E[n]={__list:r};}else{E[n]={__ref:r};}}else if(!p||!p.__deferred){E[n]=p;}});k[K]=true;return K;}};m.prototype._removeReferences=function(D){var t=this,l;if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._removeReferences(j));});return l;}else{q.each(D,function(p,o){if(o){if(o["__ref"]||o["__list"]){delete D[p];}}});return D;}};m.prototype._restoreReferences=function(D){var t=this,l,r=[];if(D.results){l=[];q.each(D.results,function(i,j){l.push(t._restoreReferences(j));});return l;}else{q.each(D,function(p,o){if(o&&o["__ref"]){var i=t._getObject("/"+o["__ref"]);if(i){delete o["__ref"];D[p]=i;t._restoreReferences(i);}}else if(o&&o["__list"]){q.each(o["__list"],function(j,E){var i=t._getObject("/"+o["__list"][j]);if(i){r.push(i);t._restoreReferences(i);}});delete o["__list"];o.results=r;r=[];}});return D;}};m.prototype.removeData=function(){this.oData={};};m.prototype.initialize=function(){var i=this.aBindings.slice(0);q.each(i,function(I,o){o.initialize();});};m.prototype.refresh=function(F,r){if(r){this.removeData();}this._refresh(F);};m.prototype._refresh=function(F,i,E){var j=this.aBindings.slice(0);q.each(j,function(I,o){o.refresh(F,i,E);});};m.prototype.checkUpdate=function(F,A,i,j){if(A){if(!this.sUpdateTimer){this.sUpdateTimer=q.sap.delayedCall(0,this,function(){this.checkUpdate(F,false,i);});}return;}if(this.sUpdateTimer){q.sap.clearDelayedCall(this.sUpdateTimer);this.sUpdateTimer=null;}var k=this.aBindings.slice(0);q.each(k,function(I,o){if(!j||this.isMetaModelPath(o.getPath())){o.checkUpdate(F,i);}}.bind(this));};m.prototype.bindProperty=function(p,o,P){var i=new e(this,p,o,P);return i;};m.prototype.bindList=function(p,o,s,F,P){var i=new c(this,p,o,s,F,P);return i;};m.prototype.bindTree=function(p,o,F,P){var i=new f(this,p,o,F,P);return i;};m.prototype.createBindingContext=function(p,o,P,i,r){var r=!!r,F=this.resolve(p,o);if(typeof o=="function"){i=o;o=null;}if(typeof P=="function"){i=P;P=null;}if(!F){if(i){i(null);}return null;}var D=this._getObject(p,o),k,n,t=this;if(!r){r=this._isReloadNeeded(F,D,P);}if(!r){k=this._getKey(D);n=this.getContext('/'+k);if(i){i(n);}return n;}if(i){var I=!q.sap.startsWith(p,"/");if(F){var j=[],s=this.createCustomParams(P);if(s){j.push(s);}this._loadData(F,j,function(D){k=D?t._getKey(D):undefined;if(k&&o&&I){var l=o.getPath();l=l.substr(1);if(t.oData[l]){t.oData[l][p]={__ref:k};}}n=t.getContext('/'+k);i(n);},function(){i(null);});}else{i(null);}}};m.prototype._isReloadNeeded=function(F,D,p){var n,N=[],s,S=[];if(!F){return false;}if(!D){return true;}if(p&&p["expand"]){n=p["expand"].replace(/\s/g,"");N=n.split(',');}if(N){for(var i=0;i<N.length;i++){var j=N[i].indexOf("/");if(j!==-1){var k=N[i].slice(0,j);var l=N[i].slice(j+1);N[i]=[k,l];}}}for(var i=0;i<N.length;i++){var o=N[i];if(Array.isArray(o)){var r=D[o[0]];var t=o[1];if(!r||(r&&r.__deferred)){return true;}else{if(r){if(r.__list&&r.__list.length>0){for(var u=0;u<r.__list.length;u++){var P="/"+r.__list[u];var v=this.getObject(P);var R=this._isReloadNeeded(P,v,{expand:t});if(R){return true;}}}else if(r.__ref){var P="/"+r.__ref;var v=this.getObject(P);var R=this._isReloadNeeded(P,v,{expand:t});if(R){return true;}}}}}else{if(D[o]===undefined||(D[o]&&D[o].__deferred)){return true;}}}if(p&&p["select"]){s=p["select"].replace(/\s/g,"");S=s.split(',');}for(var i=0;i<S.length;i++){if(D[S[i]]===undefined){return true;}}if(S.length==0){var E=this.oMetadata._getEntityTypeByPath(F);if(!E){return false;}else{for(var i=0;i<E.property.length;i++){if(D[E.property[i].name]===undefined){return true;}}}}return false;};m.prototype.destroyBindingContext=function(o){};m.prototype.createCustomParams=function(p){var i=[],j,s={expand:true,select:true};for(var n in p){if(n in s){i.push("$"+n+"="+q.sap.encodeURL(p[n]));}if(n=="custom"){j=p[n];for(var n in j){if(n.indexOf("$")==0){q.sap.log.warning("Trying to set OData parameter "+n+" as custom query option!");}else{i.push(n+"="+q.sap.encodeURL(j[n]));}}}}return i.join("&");};m.prototype.bindContext=function(p,o,P){var i=new b(this,p,o,P);return i;};m.prototype.setCountSupported=function(i){this.bCountSupported=i;};m.prototype.isCountSupported=function(){return this.bCountSupported;};m.prototype.setDefaultCountMode=function(s){this.sDefaultCountMode=s;};m.prototype.getDefaultCountMode=function(){return this.sDefaultCountMode;};m.prototype._getKey=function(o,D){var k,u;if(o instanceof C){k=o.getPath().substr(1);}else if(o&&o.__metadata&&o.__metadata.uri){u=o.__metadata.uri;k=u.substr(u.lastIndexOf("/")+1);}if(D){k=decodeURIComponent(k);}return k;};m.prototype.getKey=function(o,D){return this._getKey(o,D);};m.prototype.createKey=function(s,k,D){var E=this.oMetadata._getEntityTypeByPath(s),K=s,t=this,n,v,p;K+="(";if(E.key.propertyRef.length==1){n=E.key.propertyRef[0].name;p=this.oMetadata._getPropertyMetadata(E,n);v=O.formatValue(k[n],p.type);K+=D?v:encodeURIComponent(v);}else{q.each(E.key.propertyRef,function(i,P){if(i>0){K+=",";}n=P.name;p=t.oMetadata._getPropertyMetadata(E,n);v=O.formatValue(k[n],p.type);K+=n;K+="=";K+=D?v:encodeURIComponent(v);});}K+=")";return K;};m.prototype.getProperty=function(p,o,i){var v=this._getObject(p,o);if(i==null||i==undefined){return v;}if(!q.isPlainObject(v)){return v;}v=q.sap.extend(true,{},v);if(i==true){return this._restoreReferences(v);}else{return this._removeReferences(v);}};m.prototype._getObject=function(p,o){var n=this.isLegacySyntax()?this.oData:null,r=this.resolve(p,o),s,D,i,j,k,l;if(this.oMetadata&&r&&r.indexOf('/#')>-1){if(this.isMetaModelPath(r)){s=r.indexOf('/##');l=this.getMetaModel();if(!this.bMetaModelLoaded){return null;}D=r.substr(0,s);i=r.substr(s+3);j=l.getMetaContext(D);n=l.getProperty(i,j);}else{n=this.oMetadata._getAnnotation(r);}}else{if(o){k=o.getPath();k=k.substr(1);n=this.oData[k];}if(!p){return n;}var P=p.split("/"),I=0;if(!P[0]){n=this.oData;I++;}while(n&&P[I]){n=n[P[I]];if(n){if(n.__ref){n=this.oData[n.__ref];}else if(n.__list){n=n.__list;}else if(n.__deferred){n=undefined;}}I++;}}return n;};m.prototype.updateSecurityToken=function(){if(this.bTokenHandling){if(!this.oServiceData.securityToken){this.refreshSecurityToken();}if(this.bTokenHandling){this.oHeaders["x-csrf-token"]=this.oServiceData.securityToken;}}};m.prototype.resetSecurityToken=function(){delete this.oServiceData.securityToken;delete this.oHeaders["x-csrf-token"];};m.prototype.getSecurityToken=function(){var t=this.oServiceData.securityToken;if(!t){this.refreshSecurityToken();t=this.oServiceData.securityToken;}return t;};m.prototype.refreshSecurityToken=function(s,E,A){var t=this,u,T;A=A===true;u=this._createRequestUrl("/");var r=this._createRequest(u,"GET",A);r.headers["x-csrf-token"]="Fetch";function _(D,R){if(R){T=t._getHeader("x-csrf-token",R.headers);if(T){t.oServiceData.securityToken=T;t.oHeaders["x-csrf-token"]=T;}else{t.resetSecurityToken();t.bTokenHandling=false;}}if(s){s(D,R);}}function i(o){t.resetSecurityToken();t.bTokenHandling=false;t._handleError(o);if(E){E(o);}}return this._request(r,_,i,undefined,undefined,this.getServiceMetadata());};m.prototype._submitRequest=function(r,i,s,E,H,I){var t=this,R,j={};function _(D,o){if(i&&H){var n=t._getBatchErrors(D);if(n.length>0){k(n[0]);return false;}if(D.__batchResponses&&D.__batchResponses.length>0){R=D.__batchResponses[0].data;if(!R&&D.__batchResponses[0].__changeResponses){R=D.__batchResponses[0].__changeResponses[0].data;}}D=R;}if(I){if(D&&D.__batchResponses){q.each(D.__batchResponses,function(p,o){if(o&&o.data){t._importData(o.data,j);}});}}t._handleETag(r,o,i);t._updateRequestQueue(r,i);if(t._isRefreshNeeded(r,o)){t._refresh(false,r.keys,r.entityTypes);}if(s){s(D,o);}}function k(o){if(t.bTokenHandling&&o.response){var T=t._getHeader("x-csrf-token",o.response.headers);if(!r.bTokenReset&&o.response.statusCode=='403'&&T&&T.toLowerCase()=="required"){t.resetSecurityToken();r.bTokenReset=true;l();return;}}t._handleError(o);if(E){E(o);}}function l(){if(t.bTokenHandling&&r.method!=="GET"){t.updateSecurityToken();if(t.bTokenHandling){r.headers["x-csrf-token"]=t.oServiceData.securityToken;}}if(i){return t._request(r,_,k,h.batchHandler,undefined,t.getServiceMetadata());}else{return t._request(r,_,k,t.oHandler,undefined,t.getServiceMetadata());}}return l();};m.prototype._createBatchRequest=function(n,A){var u,r,o={},p={},K={},E={};p.__batchRequests=n;u=this.sServiceUrl+"/$batch";if(this.aUrlParams.length>0){u+="?"+this.aUrlParams.join("&");}q.extend(o,this.mCustomHeaders,this.oHeaders);delete o["Content-Type"];r={headers:o,requestUri:u,method:"POST",data:p,user:this.sUser,password:this.sPassword,async:A};if(A){r.withCredentials=this.bWithCredentials;}q.each(n,function(i,s){if(s["__changeRequests"]){q.each(s["__changeRequests"],function(j,t){if(t.keys&&t.method!="POST"){q.each(t.keys,function(k,l){K[k]=l;});}else if(t.entityTypes&&t.method=="POST"){q.each(t.entityTypes,function(l,k){E[l]=k;});}});}});r.keys=K;r.entityTypes=E;return r;};m.prototype._handleETag=function(r,R,k){var u,E,l,n,o,p;if(k){o=r.data.__batchRequests;p=R.data.__batchResponses;if(p&&o){for(var i=0;i<o.length;i++){l=o[i].__changeRequests;if(p[i]){n=p[i].__changeResponses;if(l&&n){for(var j=0;j<l.length;j++){if(l[j].method=="MERGE"||l[j].method=="PUT"){u=l[j].requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u);if(E&&E.__metadata&&n[j].headers&&n[j].headers.ETag){E.__metadata.etag=n[j].headers.ETag;}}}}}else{q.sap.log.warning("could not update ETags for batch request: corresponding response for request missing");}}}else{q.sap.log.warning("could not update ETags for batch request: no batch responses/requests available");}}else{u=r.requestUri.replace(this.sServiceUrl+'/','');if(!q.sap.startsWith(u,"/")){u="/"+u;}E=this._getObject(u);if(E&&E.__metadata&&R.headers.ETag){E.__metadata.etag=R.headers.ETag;}}};m.prototype._handleBatchErrors=function(r,D){this._getBatchErrors(D);this._handleETag();};m.prototype._getBatchErrors=function(D){var E=[],s;q.each(D.__batchResponses,function(i,o){if(o.message){s="The following problem occurred: "+o.message;if(o.response){s+=o.response.statusCode+","+o.response.statusText+","+o.response.body;}E.push(o);q.sap.log.fatal(s);}if(o.__changeResponses){q.each(o.__changeResponses,function(i,j){if(j.message){s="The following problem occurred: "+j.message;if(j.response){s+=j.response.statusCode+","+j.response.statusText+","+j.response.body;}E.push(j);q.sap.log.fatal(s);}});}});return E;};m.prototype._handleError=function(E){var p={},t;var s="The following problem occurred: "+E.message;p.message=E.message;if(E.response){if(this.bTokenHandling){t=this._getHeader("x-csrf-token",E.response.headers);if(E.response.statusCode=='403'&&t&&t.toLowerCase()=="required"){this.resetSecurityToken();}}s+=E.response.statusCode+","+E.response.statusText+","+E.response.body;p.statusCode=E.response.statusCode;p.statusText=E.response.statusText;p.responseText=E.response.body;}q.sap.log.fatal(s);return p;};m.prototype.getData=function(p,o,i){return this.getProperty(p,o,i);};m.prototype._getETag=function(p,P,E){var s,i,I;if(E){s=E;}else{if(P&&P.__metadata){s=P.__metadata.etag;}else if(p){i=p.replace(this.sServiceUrl+'/','');I=i.indexOf("?");if(I>-1){i=i.substr(0,I);}if(this.oData.hasOwnProperty(i)){s=this.getProperty('/'+i+'/__metadata/etag');}}}return s;};m.prototype._createRequest=function(u,s,A,p,E){var o={},i;q.extend(o,this.mCustomHeaders,this.oHeaders);i=this._getETag(u,p,E);if(i&&s!="GET"){o["If-Match"]=i;}if(this.bJSON&&s!="DELETE"&&this.sMaxDataServiceVersion==="2.0"){o["Content-Type"]="application/json";}if(s=="MERGE"&&!this.bUseBatch){o["x-http-method"]="MERGE";s="POST";}var r={headers:o,requestUri:u,method:s,user:this.sUser,password:this.sPassword,async:A};if(p){r.data=p;}if(A){r.withCredentials=this.bWithCredentials;}return r;};m.prototype._isRefreshNeeded=function(r,R){var i=false,E,j=[],t=this;if(!this.bRefreshAfterChange){return i;}if(r.data&&Array.isArray(r.data.__batchRequests)){if(R){j=t._getBatchErrors(R.data);q.each(j,function(I,o){if(o.response&&o.response.statusCode=="412"){E=o.response.statusCode;return false;}});if(!!E){return false;}}q.each(r.data.__batchRequests,function(I,o){if(Array.isArray(o.__changeRequests)){q.each(o.__changeRequests,function(I,k){i=i||t._isRefreshNeeded(k);return!i;});}return!i;});}else{if(r.method==="GET"){return false;}else{if(R&&R.statusCode=="412"){i=false;}else{i=true;}}}return i;};m.prototype.update=function(p,D,P){var s,E,i,r,u,o,j,R,k,S,K,l,A=false;if(P instanceof C||arguments.length>3){o=P;s=arguments[3];E=arguments[4];i=arguments[5];}else{o=P.context||P.oContext;s=P.success||P.fnSuccess;E=P.error||P.fnError;j=P.eTag||P.sETag;i=typeof(P.merge)=="undefined"?P.bMerge===true:P.merge===true;A=typeof(P.async)=="undefined"?P.bAsync===true:P.async===true;l=P.urlParameters;}u=this._createRequestUrl(p,o,l,this.bUseBatch);if(i){r=this._createRequest(u,"MERGE",A,D,j);}else{r=this._createRequest(u,"PUT",A,D,j);}p=this._normalizePath(p,o);S=this._getObject(p);r.keys={};if(S){K=this._getKey(S);r.keys[K]=true;}if(this.bUseBatch){k=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(k,this.bUseBatch,s,E,true);}else{R=this._submitRequest(r,this.bUseBatch,s,E);}return R;};m.prototype.create=function(p,D,P){var r,o,u,R,E,i,s,j,A=false,k;if(P&&typeof(P)=="object"&&!(P instanceof C)){i=P.context;s=P.success;k=P.urlParameters;j=P.error;A=P.async===true;}else{i=P;s=arguments[3];j=arguments[4];}u=this._createRequestUrl(p,i,k,this.bUseBatch);r=this._createRequest(u,"POST",A,D);p=this._normalizePath(p,i);E=this.oMetadata._getEntityTypeByPath(p);r.entityTypes={};if(E){r.entityTypes[E.entityType]=true;}if(this.bUseBatch){o=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(o,this.bUseBatch,s,j,true);}else{R=this._submitRequest(r,this.bUseBatch,s,j);}return R;};m.prototype.remove=function(p,P){var o,E,s,S,i,r,u,j,k,l,_,n,R,t,A=false,v=this;if((P instanceof C)||arguments[2]){o=P;S=arguments[2];i=arguments[3];}else if(P){o=P.context||P.oContext;S=P.success||P.fnSuccess;i=P.error||P.fnError;j=P.eTag||P.sETag;l=P.payload||P.oPayload;A=typeof(P.async)=="undefined"?P.bAsync===true:P.async===true;t=P.urlParameters;}_=function(D,w){E=u.substr(u.lastIndexOf('/')+1);if(E.indexOf('?')!=-1){E=E.substr(0,E.indexOf('?'));}delete v.oData[E];delete v.mContexts["/"+E];if(S){S(D,w);}};u=this._createRequestUrl(p,o,t,this.bUseBatch);r=this._createRequest(u,"DELETE",A,l,j);p=this._normalizePath(p,o);s=this._getObject(p);r.keys={};if(s){k=this._getKey(s);r.keys[k]=true;}if(this.bUseBatch){n=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(n,this.bUseBatch,_,i,true);}else{R=this._submitRequest(r,this.bUseBatch,_,i);}return R;};m.prototype.callFunction=function(F,p){var r,o,u,R,i,P,j,s,E,A,k="GET",l={},t=this;if(p&&typeof(p)=="object"){k=p.method?p.method:k;P=p.urlParameters;j=p.context;s=p.success;E=p.error;A=p.async===true;}else{k=p;P=arguments[2];j=arguments[3];s=arguments[4];E=arguments[5];A=arguments[6]===true;}i=this.oMetadata._getFunctionImportMetadata(F,k);if(i){u=this._createRequestUrl(F,j,null,this.bUseBatch);var n=U(u);if(i.parameter!=null){q.each(P,function(v,w){var x=i.parameter.filter(function(z){return z.name==v&&z.mode=="In";});if(x.length>0){var y=x[0];l[v]=O.formatValue(w,y.type);}else{q.sap.log.warning("Parameter "+v+" is not defined for function call "+F+"!");}});}if(k==="GET"){return t.read(F,j,l,true,s,E);}else{q.each(l,function(v,w){n.addQuery(v,w);});r=this._createRequest(n.toString(),k,A);if(this.bUseBatch){o=this._createBatchRequest([{__changeRequests:[r]}],A);R=this._submitRequest(o,this.bUseBatch,s,E,true);}else{R=this._submitRequest(r,this.bUseBatch,s,E);}return R;}}};m.prototype.read=function(p,P){var r,u,R,o,i,j,A,s,E,F,S,k,l,n,t,v;if(P&&typeof(P)=="object"&&!(P instanceof C)){i=P.context;j=P.urlParameters;A=P.async!==false;s=P.success;E=P.error;F=P.filters;S=P.sorters;}else{i=P;j=arguments[2];A=arguments[3]!==false;s=arguments[4];E=arguments[5];}A=A!==false;v=O._createUrlParamsArray(j);l=O.createSortParams(S);if(l){v.push(l);}if(F&&!this.oMetadata){q.sap.log.fatal("Tried to use filters in read method before metadata is available.");}else{t=this._normalizePath(p,i);n=this.oMetadata&&this.oMetadata._getEntityTypeByPath(t);k=O.createFilterParams(F,this.oMetadata,n);if(k){v.push(k);}}u=this._createRequestUrl(p,i,v,this.bUseBatch);r=this._createRequest(u,"GET",A);if(this.bUseBatch){o=this._createBatchRequest([r],A);R=this._submitRequest(o,this.bUseBatch,s,E,true);}else{R=this._submitRequest(r,this.bUseBatch,s,E);}return R;};m.prototype.createBatchOperation=function(p,s,D,P){var o={},E,S,k,i;q.extend(o,this.mCustomHeaders,this.oHeaders);if(q.sap.startsWith(p,"/")){p=p.substr(1);}if(P){E=P.sETag;}if(s!="GET"){E=this._getETag(p,D,E);if(E){o["If-Match"]=E;}}if(this.bJSON){if(s!="DELETE"&&s!="GET"&&this.sMaxDataServiceVersion==="2.0"){o["Content-Type"]="application/json";}}else{o["Content-Type"]="application/atom+xml";}var r={requestUri:p,method:s.toUpperCase(),headers:o};if(D){r.data=D;}if(s!="GET"&&s!="POST"){if(p&&p.indexOf("/")!=0){p='/'+p;}S=this._getObject(p);if(S){k=this._getKey(S);r.keys={};r.keys[k]=true;}}else if(s=="POST"){var n=p;if(p.indexOf('?')!=-1){n=p.substr(0,p.indexOf('?'));}i=this.oMetadata._getEntityTypeByPath(n);if(i){r.entityTypes={};r.entityTypes[i.entityType]=true;}}return r;};m.prototype.addBatchReadOperations=function(r){if(!Array.isArray(r)||r.length<=0){q.sap.log.warning("No array with batch operations provided!");return false;}var t=this;q.each(r,function(i,R){if(R.method!="GET"){q.sap.log.warning("Batch operation should be a GET operation!");return false;}t.aBatchOperations.push(R);});};m.prototype.addBatchChangeOperations=function(i){if(!Array.isArray(i)||i.length<=0){return false;}q.each(i,function(I,o){if(o.method!="POST"&&o.method!="PUT"&&o.method!="MERGE"&&o.method!="DELETE"){q.sap.log.warning("Batch operation should be a POST/PUT/MERGE/DELETE operation!");return false;}});this.aBatchOperations.push({__changeRequests:i});};m.prototype.clearBatch=function(){this.aBatchOperations=[];};m.prototype.submitBatch=function(s,E,A,i){var r,R,t=this;function _(D,k){if(s){s(D,k,t._getBatchErrors(D));}}if(!(typeof(s)=="function")){var o=A;var j=E;A=s;s=j;E=o;}A=A!==false;if(this.aBatchOperations.length<=0){q.sap.log.warning("No batch operations in batch. No request will be triggered!");return false;}r=this._createBatchRequest(this.aBatchOperations,A);R=this._submitRequest(r,true,_,E,false,i);this.clearBatch();return R;};m.prototype.getServiceMetadata=function(){if(this.oMetadata&&this.oMetadata.isLoaded()){return this.oMetadata.getServiceMetadata();}};m.prototype.getServiceAnnotations=function(){if(this.oAnnotations&&this.oAnnotations.getAnnotationsData){return this.oAnnotations.getAnnotationsData();}};m.prototype.submitChanges=function(s,E,p){var r,P,t=this,i,j,T,k,S,K;if(this.sChangeKey){i=this.sChangeKey.replace(this.sServiceUrl,'');S=this._getObject(i);P=S;if(q.isPlainObject(S)){P=q.sap.extend(true,{},S);if(P.__metadata){T=P.__metadata.type;k=P.__metadata.etag;delete P.__metadata;if(T||k){P.__metadata={};}if(T){P.__metadata.type=T;}if(!!k){P.__metadata.etag=k;}}q.each(P,function(u,v){if(v&&v.__deferred){delete P[u];}});var o=this.oMetadata._getEntityTypeByPath(i);if(o){var n=this.oMetadata._getNavigationPropertyNames(o);q.each(n,function(I,N){delete P[N];});}P=this._removeReferences(P);}if(p&&p.sETag){j=p.sETag;}r=this._createRequest(this.sChangeKey,"MERGE",true,P,j);if(this.sUrlParams){r.requestUri+="?"+this.sUrlParams;}r.keys={};if(S){K=this._getKey(S);r.keys[K]=true;}this.oRequestQueue[this.sChangeKey]=r;}if(q.isEmptyObject(this.oRequestQueue)){return undefined;}if(this.bUseBatch){var l=[];q.each(this.oRequestQueue,function(K,u){delete u._oRef;var R=q.sap.extend(true,{},u);u._oRef=R;R.requestUri=R.requestUri.replace(t.sServiceUrl+'/','');R.data._bCreate?delete R.data._bCreate:false;l.push(R);});r=this._createBatchRequest([{__changeRequests:l}],true);this._submitRequest(r,this.bUseBatch,s,E,true);}else{q.each(this.oRequestQueue,function(K,u){delete u._oRef;var R=q.sap.extend(true,{},u);u._oRef=R;if(R.data&&R.data._bCreate){delete R.data._bCreate;}t._submitRequest(R,this.bUseBatch,s,E,true);});}return undefined;};m.prototype._updateRequestQueue=function(r,k){var l,n,o,t=this;if(k){l=r.data.__batchRequests;if(l){for(var i=0;i<l.length;i++){n=l[i].__changeRequests;if(n){for(var j=0;j<n.length;j++){o=n[j];q.each(this.oRequestQueue,function(K,p){if(p._oRef===o&&K!==t.sChangeKey){delete t.oRequestQueue[K];delete t.oData[K];delete t.mContexts["/"+K];}else if(t.sChangeKey&&K===t.sChangeKey){delete t.oRequestQueue[K];t.sChangeKey=null;}});}}}}}else{q.each(this.oRequestQueue,function(K,p){if(p._oRef===r&&K!==t.sChangeKey){delete t.oRequestQueue[K];delete t.oData[K];delete t.mContexts["/"+K];}else if(t.sChangeKey&&K===t.sChangeKey){delete t.oRequestQueue[K];t.sChangeKey=null;}});}};m.prototype.resetChanges=function(s,E){var p;if(this.sChangeKey){p=this.sChangeKey.replace(this.sServiceUrl,'');this._loadData(p,null,s,E);}};m.prototype.setProperty=function(p,v,o,A){var P,E={},D={},s=this._createRequestUrl(p,o),j=p.substring(0,p.lastIndexOf("/")),k,l,n={},r=false;if(!this.resolve(p,o)){return false;}s=s.replace(this.sServiceUrl+'/','');s=s.substring(0,s.indexOf("/"));s=this.sServiceUrl+'/'+s;P=p.substr(p.lastIndexOf("/")+1);D=this._getObject(j,o);if(!D){return false;}l=j.split("/");for(var i=l.length-1;i>=0;i--){E=this._getObject(l.join("/"),o);if(E){k=this._getKey(E);if(k){break;}}l.splice(i-1,1);}if(!k){k=this._getKey(o);}if(k){n[k]=true;}if(D._bCreate){D[P]=v;r=true;this.checkUpdate(false,A,n);}else{if(!this.sChangeKey){this.sChangeKey=s;}if(this.sChangeKey==s){D[P]=v;r=true;this.checkUpdate(false,A,n);}else{this.fireRejectChange({rejectedValue:v,oldValue:D[P]});}}return r;};m.prototype._isHeaderPrivate=function(H){switch(H.toLowerCase()){case"accept":case"accept-language":case"maxdataserviceversion":case"dataserviceversion":return true;case"x-csrf-token":return this.bTokenHandling;default:return false;}};m.prototype.setHeaders=function(H){var i={},t=this;if(H){q.each(H,function(s,j){if(t._isHeaderPrivate(s)){q.sap.log.warning("Not allowed to modify private header: "+s);}else{i[s]=j;}});this.mCustomHeaders=i;}else{this.mCustomHeaders={};}if(this.oAnnotations){this.oAnnotations.setHeaders(this.mCustomHeaders);}};m.prototype.getHeaders=function(){return q.extend({},this.mCustomHeaders,this.oHeaders);};m.prototype._getHeader=function(F,H){var s;for(s in H){if(s.toLowerCase()===F.toLowerCase()){return H[s];}}return null;};m.prototype.hasPendingChanges=function(){return this.sChangeKey!=null;};m.prototype.updateBindings=function(F){this.checkUpdate(F);};m.prototype.forceNoCache=function(F){this.bCache=!F;};m.prototype.setTokenHandlingEnabled=function(t){this.bTokenHandling=t;};m.prototype.setUseBatch=function(u){this.bUseBatch=u;};m.prototype.formatValue=function(v,t){return O.formatValue(v,t);};m.prototype.deleteCreatedEntry=function(o){if(o){var p=o.getPath();delete this.mContexts[p];if(q.sap.startsWith(p,"/")){p=p.substr(1);}delete this.oRequestQueue[p];delete this.oData[p];}};m.prototype.createEntry=function(p,P){var E={},k,u,r;if(!q.sap.startsWith(p,"/")){p="/"+p;}var o=this.oMetadata._getEntityTypeByPath(p);if(!o){return undefined;}if(typeof P==="object"&&!Array.isArray(P)){E=P;}else{for(var i=0;i<o.property.length;i++){var j=o.property[i];var l=q.inArray(j.name,P)>-1;if(!P||l){E[j.name]=this._createPropertyValue(j.type);if(l){P.splice(P.indexOf(j.name),1);}}}if(P){}}E._bCreate=true;k=p.substring(1)+"('"+q.sap.uid()+"')";this.oData[k]=E;E.__metadata={type:""+o.entityType};u=this._createRequestUrl(p);r=this._createRequest(u,"POST",true,E);r.entityTypes={};r.entityTypes[o.entityType]=true;this.oRequestQueue[k]=r;return this.getContext("/"+k);};m.prototype._createPropertyValue=function(t){var T=this.oMetadata._splitName(t);var n=T.namespace;var s=T.name;if(n.toUpperCase()!=='EDM'){var o={};var j=this.oMetadata._getObjectMetadata("complexType",s,n);for(var i=0;i<j.property.length;i++){var p=j.property[i];o[p.name]=this._createPropertyValue(p.type);}return o;}else{return this._getDefaultPropertyValue(s,n);}};m.prototype._getDefaultPropertyValue=function(t,n){return undefined;};m.prototype._normalizePath=function(p,o){if(p&&p.indexOf('?')!=-1){p=p.substr(0,p.indexOf('?'));}if(!o&&!q.sap.startsWith(p,"/")){p='/'+p;q.sap.log.warning(this+" path "+p+" should be absolute if no Context is set");}return this.resolve(p,o);};m.prototype.setRefreshAfterChange=function(r){this.bRefreshAfterChange=r;};m.prototype.isList=function(p,o){var p=this.resolve(p,o);return p&&p.substr(p.lastIndexOf("/")).indexOf("(")===-1;};m.prototype.isMetaModelPath=function(p){return p.indexOf("##")==0||p.indexOf("/##")>-1;};m.prototype._request=function(r,s,E,H,o,i){if(this.bDestroyed){return{abort:function(){}};}var t=this;function w(j){return function(){var I=q.inArray(R,t.aPendingRequestHandles);if(I>-1){t.aPendingRequestHandles.splice(I,1);}if(!(R&&R.bSuppressErrorHandlerCall)){j.apply(this,arguments);}};}var R=h.request(r,w(s||h.defaultSuccess),w(E||h.defaultError),H,o,i);if(r.async!==false){this.aPendingRequestHandles.push(R);}return R;};m.prototype.destroy=function(){this.bDestroyed=true;if(this.aPendingRequestHandles){for(var i=this.aPendingRequestHandles.length-1;i>=0;i--){var r=this.aPendingRequestHandles[i];if(r&&r.abort){r.bSuppressErrorHandlerCall=true;r.abort();}}delete this.aPendingRequestHandles;}if(!!this.oMetadataLoadEvent){q.sap.clearDelayedCall(this.oMetadataLoadEvent);}if(!!this.oMetadataFailedEvent){q.sap.clearDelayedCall(this.oMetadataFailedEvent);}if(this.oMetadata){this.oMetadata.detachLoaded(this.onMetadataLoaded);this.oMetadata.detachFailed(this.onMetadataFailed);if(!this.oMetadata.isLoaded()&&!this.oMetadata.hasListeners("loaded")){this.oMetadata.destroy();delete this.oServiceData.oMetadata;}delete this.oMetadata;}if(this.oAnnotations){this.oAnnotations.detachFailed(this.onAnnotationsFailed);this.oAnnotations.detachLoaded(this.onAnnotationsLoaded);this.oAnnotations.destroy();delete this.oAnnotations;}M.prototype.destroy.apply(this,arguments);};m.prototype._getAnnotationParser=function(A){if(!this.oAnnotations){var i=sap.ui.requireSync("sap/ui/model/odata/ODataAnnotations");this.oAnnotations=new i({annotationData:A,url:null,metadata:this.oMetadata,async:this.bLoadMetadataAsync,headers:this.mCustomHeaders});this.oAnnotations.attachFailed(this.onAnnotationsFailed,this);this.oAnnotations.attachLoaded(this.onAnnotationsLoaded,this);}return this.oAnnotations;};m.prototype.onAnnotationsFailed=function(E){this.fireAnnotationsFailed(E.getParameters());};m.prototype.onAnnotationsLoaded=function(E){this.fireAnnotationsLoaded(E.getParameters());};m.prototype.addAnnotationUrl=function(u){var j=[].concat(u),k=[],A=[],E=[],t=this;q.each(j,function(i,s){var I=s.indexOf("$metadata");if(I>=0){if(I==0){s=t.sServiceUrl+'/'+s;}k.push(s);}else{A.push(s);}});return this.oMetadata._addUrl(k).then(function(p){return Promise.all(q.map(p,function(P){E=E.concat(P.entitySets);return t.addAnnotationXML(P["metadataString"]);}));}).then(function(){return t._getAnnotationParser().addUrl(A);}).then(function(p){return{annotations:p.annotations,entitySets:E};});};m.prototype.addAnnotationXML=function(x,s){return new Promise(function(r,i){this._getAnnotationParser().setXML(null,x,{success:r,error:i,fireEvents:!s});}.bind(this));};m.prototype.getMetaModel=function(){var t=this;if(!this.oMetaModel){this.oMetaModel=new g(this.oMetadata,this.oAnnotations,{addAnnotationUrl:this.addAnnotationUrl.bind(this),annotationsLoadedPromise:this.oMetadata.isLoaded()&&(!this.oAnnotations||this.oAnnotations.isLoaded())?null:this.pAnnotationsLoaded});this.oMetaModel.loaded().then(function(){t.bMetaModelLoaded=true;t.checkUpdate(false,false,null,true);});}return this.oMetaModel;};return m;});
