/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/SyncPromise","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/ContextBinding","./Context","./lib/_Cache","./lib/_Helper","./ODataParentBinding"],function(q,S,B,C,a,b,_,c,d){"use strict";var s="sap.ui.model.odata.v4.ODataContextBinding",m={AggregatedDataStateChange:true,change:true,dataReceived:true,dataRequested:true,DataStateChange:true};var O=a.extend("sap.ui.model.odata.v4.ODataContextBinding",{constructor:function(M,p,o,P){var i=p.indexOf("(...)");a.call(this,M,p);if(p.slice(-1)==="/"){throw new Error("Invalid path: "+p);}this.mAggregatedQueryOptions={};this.bAggregatedQueryOptionsInitial=true;this.oCachePromise=S.resolve();this.mCacheByContext=undefined;this.sGroupId=undefined;this.bInheritExpandSelect=false;this.oOperation=undefined;this.aChildCanUseCachePromises=[];this.oReturnValueContext=null;this.sUpdateGroupId=undefined;if(i>=0){this.oOperation={bAction:undefined,mParameters:{},sResourcePath:undefined};if(i!==this.sPath.length-5){throw new Error("The path must not continue after a deferred operation: "+this.sPath);}}this.applyParameters(q.extend(true,{},P));this.oElementContext=this.bRelative?null:b.create(this.oModel,this,p);this.setContext(o);M.bindingCreated(this);},metadata:{publicMethods:[]}});d(O.prototype);O.prototype._delete=function(g,e){var t=this;if(this.sPath===""&&this.oContext["delete"]){return this.oContext._delete(g);}if(this.hasPendingChanges()){throw new Error("Cannot delete due to pending changes");}return this.deleteFromCache(g,e,"",function(){t.oElementContext.destroy();t.oElementContext=null;if(t.oReturnValueContext){t.oReturnValueContext.destroy();t.oReturnValueContext=null;}t._fireChange({reason:C.Remove});});};O.prototype._execute=function(g){var M=this.oModel.getMetaModel(),o,p,r=this.oModel.resolve(this.sPath,this.oContext),t=this;function f(){t._fireChange({reason:C.Change});t.oModel.getDependentBindings(t).forEach(function(D){D.refreshInternal(g.getGroupId(),true);});}g.setGroupId(this.getGroupId());p=M.fetchObject(M.getMetaPath(r)+"/@$ui5.overload").then(function(e){var G,i,P;if(!e){throw new Error("Unknown operation: "+r);}if(e.length!==1){throw new Error("Unsupported overloads for "+r);}if(t.bRelative&&t.oContext.getBinding){i=t.sPath.lastIndexOf("/");P=i>=0?t.sPath.slice(0,i):"";G=t.oContext.getObject.bind(t.oContext,P);}o=e[0];return t.createCacheAndRequest(g,r,o,G);}).then(function(R){f();if(t.hasReturnValueContext(o)){if(t.oReturnValueContext){t.oReturnValueContext.destroy();}t.oReturnValueContext=b.create(t.oModel,t,r.slice(0,r.indexOf("("))+c.getPrivateAnnotation(R,"predicate"));return t.oReturnValueContext;}},function(e){f();throw e;})["catch"](function(e){g.unlock(true);if(t.oReturnValueContext){t.oReturnValueContext.destroy();t.oReturnValueContext=null;}t.oModel.reportError("Failed to execute "+r,s,e);throw e;});return Promise.resolve(p);};O.prototype.applyParameters=function(p,e){var o=this.oModel.buildBindingParameters(p,["$$groupId","$$inheritExpandSelect","$$ownRequest","$$updateGroupId"]);if(o.$$inheritExpandSelect){if(!this.oOperation){throw new Error("Unsupported binding parameter $$inheritExpandSelect: "+"binding is not an operation binding");}if(o.$expand||o.$select){throw new Error("Must not set parameter $$inheritExpandSelect on binding which has "+"$expand or $select");}}this.sGroupId=o.$$groupId;this.sUpdateGroupId=o.$$updateGroupId;this.bInheritExpandSelect=o.$$inheritExpandSelect;this.mQueryOptions=this.oModel.buildQueryOptions(p,true);this.mParameters=p;if(!this.oOperation){this.fetchCache(this.oContext);if(e){this.refreshInternal(undefined,true);}else{this.checkUpdate();}}else if(this.oOperation.bAction===false){this.execute();}};O.prototype.attachEvent=function(e){if(!(e in m)){throw new Error("Unsupported event '"+e+"': v4.ODataContextBinding#attachEvent");}return a.prototype.attachEvent.apply(this,arguments);};O.prototype.createCacheAndRequest=function(g,p,o,G){var A=o.$kind==="Action",e,E=G,f,h=this.hasReturnValueContext(o),M=this.oModel,i=M.getMetaModel().getMetaPath(p)+"/@$ui5.overload/0/$ReturnType",P=q.extend({},this.oOperation.mParameters),j,r=M.oRequestor,Q=q.extend({},M.mUriParameters,this.mQueryOptions);if(!A&&o.$kind!=="Function"){throw new Error("Not an operation: "+p);}if(this.bInheritExpandSelect){if(h){j=this.oContext.getBinding().mCacheQueryOptions;if("$select"in j){Q.$select=j.$select;}if("$expand"in j){Q.$expand=j.$expand;}}else{throw new Error("Must not set parameter $$inheritExpandSelect on binding which has "+"no return value context");}}this.oOperation.bAction=A;if(A&&G){E=G();f=E&&E["@odata.etag"];}p=r.getPathAndAddQueryOptions(p,o,P,Q,E);this.mCacheQueryOptions=Q;e=_.createSingle(r,p,Q,M.bAutoExpandSelect,A,i,h);this.oCachePromise=S.resolve(e);return A?e.post(g,P,f):e.fetchValue(g);};O.prototype.destroy=function(){if(this.oElementContext){this.oElementContext.destroy();}if(this.oReturnValueContext){this.oReturnValueContext.destroy();}this.oModel.bindingDestroyed(this);this.oCachePromise=undefined;this.oContext=undefined;a.prototype.destroy.apply(this);};O.prototype.doCreateCache=function(r,Q){return _.createSingle(this.oModel.oRequestor,r,Q,this.oModel.bAutoExpandSelect);};O.prototype.doFetchQueryOptions=function(){return S.resolve(this.mQueryOptions);};O.prototype.execute=function(g){var r=this.oModel.resolve(this.sPath,this.oContext);this.checkSuspended();this.oModel.checkGroupId(g);if(!this.oOperation){throw new Error("The binding must be deferred: "+this.sPath);}if(this.bRelative){if(!r){throw new Error("Unresolved binding: "+this.sPath);}if(this.oContext.isTransient&&this.oContext.isTransient()){throw new Error("Execute for transient context not allowed: "+r);}if(this.oContext.getPath().indexOf("(...)")>=0){throw new Error("Nested deferred operation bindings not supported: "+r);}}return this._execute(this.oModel.lockGroup(g,true));};O.prototype.fetchValue=function(p,l){var e,g,r=this.getRootBinding(),t=this;if(r&&r.isSuspended()){e=new Error("Suspended binding provides no value");e.canceled="noDebugLog";throw e;}return this.oCachePromise.then(function(o){var D=false,R;if(o){R=t.getRelativePath(p);if(R!==undefined){g=t.oModel.lockGroup(t.getGroupId(),t.oRefreshGroupLock);t.oRefreshGroupLock=undefined;return o.fetchValue(g,R,function(){D=true;t.fireDataRequested();},l).then(function(v){if(D){t.fireDataReceived({data:{}});}return v;},function(e){g.unlock(true);if(D){t.oModel.reportError("Failed to read path "+t.sPath,s,e);t.fireDataReceived(e.canceled?{data:{}}:{error:e});}throw e;});}}if(!t.oOperation&&t.oContext&&t.oContext.fetchValue){return t.oContext.fetchValue(p,l);}});};O.prototype.hasReturnValueContext=function(M){var o=this.oModel.getMetaModel(),e=o.getMetaPath(this.oModel.resolve(this.sPath,this.oContext)).split("/");return M.$IsBound&&M.$ReturnType&&!M.$ReturnType.$isCollection&&M.$EntitySetPath&&M.$EntitySetPath.indexOf("/")<0&&this.bRelative&&this.oContext&&this.oContext.getBinding&&e.length===3&&o.getObject("/"+e[1]).$kind==="EntitySet";};O.prototype.refreshInternal=function(g,e){var t=this;if(this.oOperation&&this.oOperation.bAction!==false){return;}this.createRefreshGroupLock(g,this.isRefreshable());this.oCachePromise.then(function(o){if(!t.oElementContext){t.oElementContext=b.create(t.oModel,t,t.oModel.resolve(t.sPath,t.oContext));if(!o){t._fireChange({reason:C.Refresh});}}if(!t.oOperation){if(o){t.mCacheByContext=undefined;t.fetchCache(t.oContext);}t.oModel.getDependentBindings(t).forEach(function(D){D.refreshInternal(g,e);});}else{t._execute(t.oRefreshGroupLock);t.oRefreshGroupLock=undefined;}});};O.prototype.resumeInternal=function(e){if(!this.oOperation){this.mAggregatedQueryOptions={};this.bAggregatedQueryOptionsInitial=true;this.mCacheByContext=undefined;this.fetchCache(this.oContext);this.oModel.getDependentBindings(this).forEach(function(D){D.resumeInternal(e);});this._fireChange({reason:C.Change});}else if(this.oOperation.bAction===false){this.execute();}};O.prototype.setContext=function(o){if(this.oContext!==o){if(this.bRelative&&(this.oContext||o)){if(this.oElementContext){this.oElementContext.destroy();this.oElementContext=null;}if(this.oReturnValueContext){this.oReturnValueContext.destroy();this.oReturnValueContext=null;}this.fetchCache(o);if(o){this.oElementContext=b.create(this.oModel,this,this.oModel.resolve(this.sPath,o));}B.prototype.setContext.call(this,o);}else{this.oContext=o;}}};O.prototype.setParameter=function(p,v){if(!this.oOperation){throw new Error("The binding must be deferred: "+this.sPath);}if(!p){throw new Error("Missing parameter name");}if(v===undefined){throw new Error("Missing value for parameter: "+p);}this.oOperation.mParameters[p]=v;this.oOperation.bAction=undefined;return this;};return O;});
