/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/SyncPromise","sap/ui/model/Binding","sap/ui/model/ChangeReason","sap/ui/model/FilterOperator","sap/ui/model/FilterType","sap/ui/model/ListBinding","sap/ui/model/Sorter","sap/ui/model/odata/OperationMode","./Context","./lib/_AggregationCache","./lib/_Cache","./lib/_GroupLock","./lib/_Helper","./ODataParentBinding"],function(q,S,B,C,F,a,L,b,O,c,_,d,e,f,g){"use strict";var s="sap.ui.model.odata.v4.ODataListBinding",m={AggregatedDataStateChange:true,change:true,dataReceived:true,dataRequested:true,DataStateChange:true,refresh:true};var h=L.extend("sap.ui.model.odata.v4.ODataListBinding",{constructor:function(M,p,o,v,i,P){L.call(this,M,p);if(p.slice(-1)==="/"){throw new Error("Invalid path: "+p);}this.oAggregation=null;this.mAggregatedQueryOptions={};this.bAggregatedQueryOptionsInitial=true;this.aApplicationFilters=f.toArray(i);h.checkCaseSensitiveFilters(this.aApplicationFilters);this.oCachePromise=S.resolve();this.sChangeReason=M.bAutoExpandSelect?"AddVirtualContext":undefined;this.aChildCanUseCachePromises=[];this.oDiff=undefined;this.aFilters=[];this.mPreviousContextsByPath={};this.aPreviousData=[];this.oRefreshGroupLock=undefined;this.aSorters=f.toArray(v);this.applyParameters(q.extend(true,{},P));this.oHeaderContext=this.bRelative?null:c.create(this.oModel,this,p);this.setContext(o);M.bindingCreated(this);}});g(h.prototype);h.checkCaseSensitiveFilters=function(i){function j(o){if(o.bCaseSensitive===false){throw new Error("Filter for path '"+o.sPath+"' has unsupported value for 'caseSensitive' : false");}if(o.aFilters){h.checkCaseSensitiveFilters(o.aFilters);}if(o.oCondition){j(o.oCondition);}}i.forEach(j);};h.prototype._delete=function(G,E,o){var t=this;if(!o.isTransient()&&this.hasPendingChanges()){throw new Error("Cannot delete due to pending changes");}return this.deleteFromCache(G,E,String(o.iIndex),function(I,j){var k,i,p,r;if(I===-1){o.destroy();delete t.aContexts[-1];}else{for(i=I;i<t.aContexts.length;i+=1){o=t.aContexts[i];if(o){t.mPreviousContextsByPath[o.getPath()]=o;}}r=t.oModel.resolve(t.sPath,t.oContext);t.aContexts.splice(I,1);for(i=I;i<t.aContexts.length;i+=1){if(t.aContexts[i]){p=f.getPrivateAnnotation(j[i],"predicate");k=r+(p||"/"+i);o=t.mPreviousContextsByPath[k];if(o){delete t.mPreviousContextsByPath[k];if(o.getIndex()===i){o.checkUpdate();}else{o.setIndex(i);}}else{o=c.create(t.oModel,t,k,i);}t.aContexts[i]=o;}}}t.iMaxLength-=1;t._fireChange({reason:C.Remove});});};h.prototype.applyParameters=function(p,i){var A,o=this.oModel.buildBindingParameters(p,["$$aggregation","$$groupId","$$operationMode","$$ownRequest","$$updateGroupId"]),j;j=o.$$operationMode||this.oModel.sOperationMode;if(!j&&(this.aSorters.length||this.aApplicationFilters.length)){throw new Error("Unsupported operation mode: "+j);}this.sOperationMode=j;this.sGroupId=o.$$groupId;this.sUpdateGroupId=o.$$updateGroupId;this.mQueryOptions=this.oModel.buildQueryOptions(p,true);this.mParameters=p;if("$$aggregation"in o){if("$apply"in this.mQueryOptions){throw new Error("Cannot combine $$aggregation and $apply");}A=f.clone(o.$$aggregation);this.mQueryOptions.$apply=f.buildApply(A);this.oAggregation=A;}this.mCacheByContext=undefined;this.fetchCache(this.oContext);this.reset(i);};h.prototype.attachEvent=function(E){if(!(E in m)){throw new Error("Unsupported event '"+E+"': v4.ODataListBinding#attachEvent");}return L.prototype.attachEvent.apply(this,arguments);};h.prototype.create=function(i){var o,v,j,G,r=this.oModel.resolve(this.sPath,this.oContext),t=this;if(!r){throw new Error("Binding is not yet resolved: "+this);}if(this.aContexts[-1]){throw new Error("Must not create twice");}this.checkSuspended();v=r.slice(1);if(this.bRelative&&this.oContext.fetchCanonicalPath){v=this.oContext.fetchCanonicalPath().then(function(k){return f.buildPath(k,t.sPath).slice(1);});}G=this.oModel.lockGroup(this.getUpdateGroupId(),true);j=this.createInCache(G,v,"",i,function(){o.destroy();delete t.aContexts[-1];t._fireChange({reason:C.Remove});}).then(function(){var k;t.iMaxLength+=1;if(t.isRefreshable()){k=t.getGroupId();if(!t.oModel.isDirectGroup(k)&&!t.oModel.isAutoGroup(k)){k="$auto";}return t.refreshSingle(o,t.oModel.lockGroup(k));}},function(E){G.unlock(true);throw E;});o=c.create(this.oModel,this,r+"/-1",-1,j);this.aContexts[-1]=o;this._fireChange({reason:C.Add});return o;};h.prototype.createContexts=function(j,l,r){var k=false,o=this.oContext,n,i,p=r.$count,I=this.aContexts.length,t=this.bLengthFinal,M=this.oModel,P=M.resolve(this.sPath,o),u,v=this;function w(N){var i;for(i=N;i<v.aContexts.length;i+=1){if(v.aContexts[i]){v.aContexts[i].destroy();}}while(N>0&&!v.aContexts[N-1]){N-=1;}v.aContexts.length=N;k=true;}for(i=j;i<j+r.length;i+=1){if(this.aContexts[i]===undefined){k=true;u=f.getPrivateAnnotation(r[i-j],"predicate");n=P+(u||"/"+i);if(n in this.mPreviousContextsByPath){this.aContexts[i]=this.mPreviousContextsByPath[n];delete this.mPreviousContextsByPath[n];this.aContexts[i].setIndex(i);this.aContexts[i].checkUpdate();}else{this.aContexts[i]=c.create(M,this,n,i);}}}if(Object.keys(this.mPreviousContextsByPath).length){sap.ui.getCore().addPrerenderingTask(function(){Object.keys(v.mPreviousContextsByPath).forEach(function(P){v.mPreviousContextsByPath[P].destroy();delete v.mPreviousContextsByPath[P];});});}if(p!==undefined){if(this.aContexts.length>p){w(p);}this.iMaxLength=p;this.bLengthFinal=true;}else{if(this.aContexts.length>this.iMaxLength){this.iMaxLength=Infinity;}if(r.length<l){this.iMaxLength=j+r.length;if(this.aContexts.length>this.iMaxLength){w(this.iMaxLength);}}if(!(j>I&&r.length===0)){this.bLengthFinal=this.aContexts.length===this.iMaxLength;}}if(this.bLengthFinal!==t){k=true;}return k;};h.prototype.destroy=function(){this.aContexts.forEach(function(o){o.destroy();});if(this.oHeaderContext){this.oHeaderContext.destroy();}if(this.aContexts[-1]){this.aContexts[-1].destroy();}this.oModel.bindingDestroyed(this);this.oCachePromise=undefined;this.oContext=undefined;L.prototype.destroy.apply(this);};h.prototype.doCreateCache=function(r,Q,o){var A=this.oAggregation&&(this.oAggregation.groupLevels.length||f.hasMinOrMax(this.oAggregation.aggregate));Q=this.inheritQueryOptions(Q,o);return A?_.create(this.oModel.oRequestor,r,this.oAggregation,Q,this.oModel.bAutoExpandSelect):d.create(this.oModel.oRequestor,r,Q,this.oModel.bAutoExpandSelect);};h.prototype.doFetchQueryOptions=function(o){var i=this.getOrderby(this.mQueryOptions.$orderby),t=this;return this.fetchFilter(o,this.mQueryOptions.$filter).then(function(j){return t.mergeQueryOptions(t.mQueryOptions,i,j);});};h.prototype.enableExtendedChangeDetection=function(D,k){if(k!==undefined){throw new Error("Unsupported property 'key' with value '"+k+"' in binding info for "+this);}return L.prototype.enableExtendedChangeDetection.apply(this,arguments);};h.prototype.fetchFilter=function(o,i){var n=[],t=this;function j(u,v){var w=u.join(v);return u.length>1?"("+w+")":w;}function k(u,E){var v,V=f.formatLiteral(u.oValue1,E),w=decodeURIComponent(u.sPath);switch(u.sOperator){case F.BT:v=w+" ge "+V+" and "+w+" le "+f.formatLiteral(u.oValue2,E);break;case F.EQ:case F.GE:case F.GT:case F.LE:case F.LT:case F.NE:v=w+" "+u.sOperator.toLowerCase()+" "+V;break;case F.Contains:case F.EndsWith:case F.StartsWith:v=u.sOperator.toLowerCase()+"("+w+","+V+")";break;default:throw new Error("Unsupported operator: "+u.sOperator);}return v;}function l(u,A,v){var w=[],x={};u.forEach(function(y){x[y.sPath]=x[y.sPath]||[];x[y.sPath].push(y);});u.forEach(function(y){var z;if(y.aFilters){w.push(l(y.aFilters,y.bAnd,v).then(function(D){return"("+D+")";}));return;}z=x[y.sPath];if(!z){return;}delete x[y.sPath];w.push(p(z,v));});return S.all(w).then(function(y){return y.join(A?" and ":" or ");});}function p(G,u){var M=t.oModel.getMetaModel(),v=M.getMetaContext(t.oModel.resolve(t.sPath,o)),P=M.fetchObject(r(G[0].sPath,u),v);return P.then(function(w){var x;if(!w){throw new Error("Type cannot be determined, no metadata for path: "+v.getPath());}x=G.map(function(y){var z,A,D=y.sOperator;if(D===F.All||D===F.Any){z=y.oCondition;A=y.sVariable;if(D===F.Any&&!z){return y.sPath+"/any()";}u=q.extend({},u);u[A]=r(y.sPath,u);return(z.aFilters?l(z.aFilters,z.bAnd,u):p([z],u)).then(function(E){return y.sPath+"/"+y.sOperator.toLowerCase()+"("+A+":"+E+")";});}return k(y,w.$Type);});return S.all(x).then(function(R){return j(R," or ");});});}function r(P,u){var v=P.split("/");v[0]=u[v[0]];return v[0]?v.join("/"):P;}return S.all([l(this.aApplicationFilters,true,{}),l(this.aFilters,true,{})]).then(function(u){if(u[0]){n.push(u[0]);}if(u[1]){n.push(u[1]);}if(i){n.push(i);}return j(n,") and (");});};h.prototype.fetchValue=function(p,l){var t=this;return this.oCachePromise.then(function(o){var r;if(o){r=t.getRelativePath(p);if(r!==undefined){return o.fetchValue(e.$cached,r,undefined,l);}}if(t.oContext){return t.oContext.fetchValue(p,l);}});};h.prototype.filter=function(v,i){var j=f.toArray(v);h.checkCaseSensitiveFilters(j);this.checkSuspended();if(this.sOperationMode!==O.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server");}if(this.hasPendingChanges()){throw new Error("Cannot filter due to pending changes");}this.createRefreshGroupLock(this.getGroupId(),true);if(i===a.Control){this.aFilters=j;}else{this.aApplicationFilters=j;}this.mCacheByContext=undefined;this.fetchCache(this.oContext);this.reset(C.Filter);return this;};h.prototype.getContexts=function(i,l,M){var j,o=this.oContext,k,D=false,n=false,G,p,r=!!this.sChangeReason,t,v,u=this;q.sap.log.debug(this+"#getContexts("+i+", "+l+", "+M+")",undefined,s);this.checkSuspended();if(i!==0&&this.bUseExtendedChangeDetection){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" first parameter must be 0 if extended change detection is enabled, but is "+i);}if(M!==undefined&&this.bUseExtendedChangeDetection){throw new Error("Unsupported operation: v4.ODataListBinding#getContexts,"+" third parameter must not be set if extended change detection is enabled");}if(this.bRelative&&!o){this.aPreviousData=[];return[];}j=this.sChangeReason||C.Change;this.sChangeReason=undefined;if(j==="AddVirtualContext"){sap.ui.getCore().addPrerenderingTask(function(){u.sChangeReason="RemoveVirtualContext";u._fireChange({reason:C.Change});u.reset(C.Refresh);},true);v=c.create(this.oModel,this,this.oModel.resolve(this.sPath,this.oContext)+"/-2",-2);return[v];}if(j==="RemoveVirtualContext"){return[];}i=i||0;l=l||this.oModel.iSizeLimit;if(!M||M<0){M=0;}t=this.aContexts[-1]?i-1:i;G=this.oRefreshGroupLock;this.oRefreshGroupLock=undefined;if(!this.bUseExtendedChangeDetection||!this.oDiff){p=this.oCachePromise.then(function(w){if(w){G=u.oModel.lockGroup(u.getGroupId(),G);return w.read(t,l,M,G,function(){D=true;u.fireDataRequested();});}else{if(G){G.unlock();}return o.fetchValue(u.sPath).then(function(R){var x;R=R||[];x=R.$count;if(t<0){R=[R[-1]].concat(R.slice(0,l-1));}else{R=R.slice(t,t+l);}R.$count=x;return{value:R};});}});if(p.isFulfilled()&&r){p=Promise.resolve(p);}p.then(function(R){var w;if(!u.bRelative||u.oContext===o){w=u.createContexts(t,l,R.value);if(u.bUseExtendedChangeDetection){u.oDiff={aDiff:u.getDiff(R.value,t),iLength:l};}if(n){if(w){u._fireChange({reason:j});}else{u.oDiff=undefined;}}}if(D){u.fireDataReceived({data:{}});}},function(E){if(D){u.fireDataReceived(E.canceled?{data:{}}:{error:E});}throw E;})["catch"](function(E){if(G){G.unlock(true);}u.oModel.reportError("Failed to get contexts for "+u.oModel.sServiceUrl+u.oModel.resolve(u.sPath,u.oContext).slice(1)+" with start index "+i+" and length "+l,s,E);});n=true;}this.iCurrentBegin=t;this.iCurrentEnd=t+l;if(t===-1){k=this.aContexts.slice(0,t+l);k.unshift(this.aContexts[-1]);}else{k=this.aContexts.slice(t,t+l);}if(this.bUseExtendedChangeDetection){if(this.oDiff&&l!==this.oDiff.iLength){throw new Error("Extended change detection protocol violation: Expected "+"getContexts(0,"+this.oDiff.iLength+"), but got getContexts(0,"+l+")");}k.dataRequested=!this.oDiff;k.diff=this.oDiff?this.oDiff.aDiff:[];}this.oDiff=undefined;return k;};h.prototype.getCurrentContexts=function(){var i,l=Math.min(this.iCurrentEnd,this.iMaxLength)-this.iCurrentBegin;if(this.iCurrentBegin===-1){i=this.aContexts.slice(0,this.iCurrentBegin+l);i.unshift(this.aContexts[-1]);}else{i=this.aContexts.slice(this.iCurrentBegin,this.iCurrentBegin+l);}while(i.length<l){i.push(undefined);}return i;};h.prototype.getDiff=function(r,j){var D,n,t=this;n=r.map(function(E,i){return t.bDetectUpdates?JSON.stringify(E):t.aContexts[j+i].getPath();});D=q.sap.arraySymbolDiff(this.aPreviousData,n);this.aPreviousData=n;return D;};h.prototype.getDistinctValues=function(){throw new Error("Unsupported operation: v4.ODataListBinding#getDistinctValues");};h.prototype.getHeaderContext=function(){return(this.bRelative&&!this.oContext)?null:this.oHeaderContext;};h.prototype.getLength=function(){var l=this.bLengthFinal?this.iMaxLength:this.aContexts.length+10;if(this.aContexts[-1]){l+=1;}return l;};h.prototype.getOrderby=function(o){var i=[],t=this;this.aSorters.forEach(function(j){if(j instanceof b){i.push(j.sPath+(j.bDescending?" desc":""));}else{throw new Error("Unsupported sorter: "+j+" - "+t);}});if(o){i.push(o);}return i.join(',');};h.prototype.inheritQueryOptions=function(Q,o){var i;if(!Object.keys(this.mParameters).length){i=this.getQueryOptionsForPath("",o);if(Q.$orderby&&i.$orderby){Q.$orderby+=","+i.$orderby;}if(Q.$filter&&i.$filter){Q.$filter="("+Q.$filter+") and ("+i.$filter+")";}Q=q.extend({},i,Q);}return Q;};h.prototype.isLengthFinal=function(){return this.bLengthFinal;};h.prototype.mergeQueryOptions=function(Q,o,i){var r;function j(p,v){if(v&&(!Q||Q[p]!==v)){if(!r){r=Q?f.clone(Q):{};}r[p]=v;}}j("$orderby",o);j("$filter",i);return r||Q;};h.prototype.refreshInternal=function(G){var t=this;this.createRefreshGroupLock(G,this.isRefreshable());this.oCachePromise.then(function(o){if(o){t.mCacheByContext=undefined;t.fetchCache(t.oContext);}t.reset(C.Refresh);t.oModel.getDependentBindings(t).forEach(function(D){D.refreshInternal(G,false);});});};h.prototype.refreshSingle=function(o,G,A){var t=this;if(!this.isRefreshable()){throw new Error("Binding is not refreshable; cannot refresh entity: "+o);}if(this.hasPendingChangesForPath(o.getPath())){throw new Error("Cannot refresh entity due to pending changes: "+o);}return this.oCachePromise.then(function(j){var D=false,p;function k(i){if(D){t.fireDataReceived(i);}}function l(){D=true;t.fireDataRequested();}function r(){t.oModel.getDependentBindings(o).forEach(function(i){i.refreshInternal(G.getGroupId(),false);});}function n(I){var u=t.aContexts[I],i;if(I===-1){delete t.aContexts[-1];}else{t.aContexts.splice(I,1);for(i=I;i<t.aContexts.length;i+=1){if(t.aContexts[i]){t.aContexts[i].setIndex(i);}}}u.destroy();t.iMaxLength-=1;t._fireChange({reason:C.Remove});}G.setGroupId(t.getGroupId());p=(A?j.refreshSingleWithRemove(G,o.iIndex,l,n):j.refreshSingle(G,o.iIndex,l)).then(function(){k({data:{}});if(o.oBinding){o.checkUpdate();if(A){r();}}},function(E){k({error:E});throw E;})["catch"](function(E){G.unlock(true);t.oModel.reportError("Failed to refresh entity: "+o,s,E);});if(!A){r();}return p;});};h.prototype.reset=function(i){var E=this.iCurrentEnd===0,t=this;if(this.aContexts){this.aContexts.forEach(function(o){t.mPreviousContextsByPath[o.getPath()]=o;});if(this.aContexts[-1]){this.aContexts[-1].destroy();}}this.aContexts=[];this.iCurrentBegin=this.iCurrentEnd=0;this.iMaxLength=Infinity;this.bLengthFinal=false;if(i&&!(E&&i===C.Change)){this.sChangeReason=i;this._fireRefresh({reason:i});}if(this.getHeaderContext()){this.oModel.getDependentBindings(this.oHeaderContext).forEach(function(o){o.checkUpdate();});}};h.prototype.resumeInternal=function(){this.reset();this.fetchCache(this.oContext);this.oModel.getDependentBindings(this).forEach(function(D){D.resumeInternal(false);});this._fireChange({reason:C.Change});};h.prototype.setAggregation=function(A){this.checkSuspended();if(this.hasPendingChanges()){throw new Error("Cannot set $$aggregation due to pending changes");}if(!this.oAggregation&&"$apply"in this.mQueryOptions){throw new Error("Cannot override existing $apply : '"+this.mQueryOptions.$apply+"'");}A=f.clone(A);this.mQueryOptions.$apply=f.buildApply(A);this.oAggregation=A;this.mCacheByContext=undefined;this.fetchCache(this.oContext);this.reset(C.Change);};h.prototype.setContext=function(o){var r;if(this.oContext!==o){if(this.bRelative){if(this.aContexts[-1]&&this.aContexts[-1].isTransient()){throw new Error("setContext on relative binding is forbidden if a transient "+"entity exists: "+this);}this.reset();this.fetchCache(o);if(o){r=this.oModel.resolve(this.sPath,o);if(this.oHeaderContext&&this.oHeaderContext.getPath()!==r){this.oHeaderContext.destroy();this.oHeaderContext=null;}if(!this.oHeaderContext){this.oHeaderContext=c.create(this.oModel,this,r);}}B.prototype.setContext.call(this,o);}else{this.oContext=o;}}};h.prototype.sort=function(v){this.checkSuspended();if(this.sOperationMode!==O.Server){throw new Error("Operation mode has to be sap.ui.model.odata.OperationMode.Server");}if(this.hasPendingChanges()){throw new Error("Cannot sort due to pending changes");}this.aSorters=f.toArray(v);this.mCacheByContext=undefined;this.createRefreshGroupLock(this.getGroupId(),true);this.fetchCache(this.oContext);this.reset(C.Sort);return this;};h.prototype.updateAnalyticalInfo=function(A){var o={aggregate:{},group:{}},H=false;A.forEach(function(i){var D={};if("total"in i){if("grouped"in i){throw new Error("Both dimension and measure: "+i.name);}if(i.as){D.name=i.name;o.aggregate[i.as]=D;}else{o.aggregate[i.name]=D;}if(i.min){D.min=true;H=true;}if(i.max){D.max=true;H=true;}if(i.with){D.with=i.with;}}else if(!("grouped"in i)||i.inResult||i.visible){o.group[i.name]=D;}});this.oAggregation=o;this.changeParameters({$apply:f.buildApply(o)});if(H){return{measureRangePromise:Promise.resolve(this.oCachePromise.then(function(i){return i.getMeasureRangePromise();}))};}};return h;});
