/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/SyncPromise","sap/ui/model/BindingMode","sap/ui/model/ChangeReason","sap/ui/model/ClientListBinding","sap/ui/model/ContextBinding","sap/ui/model/Context","sap/ui/model/MetaModel","sap/ui/model/odata/OperationMode","sap/ui/model/odata/type/Int64","sap/ui/model/odata/type/Raw","sap/ui/model/PropertyBinding","sap/ui/thirdparty/URI","./lib/_Helper","./ValueListType"],function(q,S,B,C,a,b,c,M,O,I,R,P,U,_,V){"use strict";var d,D=q.sap.log.Level.DEBUG,f,g,s="sap.ui.model.odata.v4.ODataMetaModel",h,r=/^-?\d+$/,j=new R(),m={messageChange:true},u={"Edm.Boolean":{type:"sap.ui.model.odata.type.Boolean"},"Edm.Byte":{type:"sap.ui.model.odata.type.Byte"},"Edm.Date":{type:"sap.ui.model.odata.type.Date"},"Edm.DateTimeOffset":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.DateTimeOffset"},"Edm.Decimal":{constraints:{"@Org.OData.Validation.V1.Minimum/$Decimal":"minimum","@Org.OData.Validation.V1.Minimum@Org.OData.Validation.V1.Exclusive":"minimumExclusive","@Org.OData.Validation.V1.Maximum/$Decimal":"maximum","@Org.OData.Validation.V1.Maximum@Org.OData.Validation.V1.Exclusive":"maximumExclusive","$Precision":"precision","$Scale":"scale"},type:"sap.ui.model.odata.type.Decimal"},"Edm.Double":{type:"sap.ui.model.odata.type.Double"},"Edm.Guid":{type:"sap.ui.model.odata.type.Guid"},"Edm.Int16":{type:"sap.ui.model.odata.type.Int16"},"Edm.Int32":{type:"sap.ui.model.odata.type.Int32"},"Edm.Int64":{type:"sap.ui.model.odata.type.Int64"},"Edm.SByte":{type:"sap.ui.model.odata.type.SByte"},"Edm.Single":{type:"sap.ui.model.odata.type.Single"},"Edm.Stream":{type:"sap.ui.model.odata.type.Stream"},"Edm.String":{constraints:{"@com.sap.vocabularies.Common.v1.IsDigitSequence":"isDigitSequence","$MaxLength":"maxLength"},type:"sap.ui.model.odata.type.String"},"Edm.TimeOfDay":{constraints:{"$Precision":"precision"},type:"sap.ui.model.odata.type.TimeOfDay"}},k={},v="@com.sap.vocabularies.Common.v1.ValueListMapping",l={},p="@com.sap.vocabularies.Common.v1.ValueListReferences",t="@com.sap.vocabularies.Common.v1.ValueListWithFixedValues",W=q.sap.log.Level.WARNING;function w(o,e,i,n){var G,H=o.mSchema2MetadataUrl[e];if(!H){H=o.mSchema2MetadataUrl[e]={};H[i]=false;}else if(!(i in H)){G=Object.keys(H)[0];if(H[G]){z("A schema cannot span more than one document: "+e+" - expected reference URI "+G+" but instead saw "+i,n);}H[i]=false;}}function x(o,e,i,L){var n,G,H,J;function K(N){var Q,T;if(!(i in N)){L(W,G," does not contain ",i);return;}L(D,"Including ",i," from ",G);for(T in N){if(T[0]!=="$"&&E(T)===i){Q=N[T];e[T]=Q;A(Q,e.$Annotations);}}}if(i in e){return e[i];}J=o.mSchema2MetadataUrl[i];if(J){H=Object.keys(J);if(H.length>1){z("A schema cannot span more than one document: schema is referenced"+" by following URLs: "+H.join(", "),i);}G=H[0];J[G]=true;L(D,"Namespace ",i," found in $Include of ",G);n=o.mMetadataUrl2Promise[G];if(!n){L(D,"Reading ",G);n=o.mMetadataUrl2Promise[G]=S.resolve(o.oRequestor.read(G)).then(o.validate.bind(o,G));}n=n.then(K);if(i in e){return e[i];}e[i]=n;return n;}}function y(T,e){if(T===e){return"";}if(T.indexOf(e)===0&&T[e.length]==="#"&&T.indexOf("@",e.length)<0){return T.slice(e.length+1);}}function z(e,i){q.sap.log.error(e,i,s);throw new Error(i+": "+e);}function A(o,e,i){var T;function n(G,H){var N;for(N in H){if(i||!(N in G)){G[N]=H[N];}}}for(T in o.$Annotations){if(!(T in e)){e[T]={};}n(e[T],o.$Annotations[T]);}delete o.$Annotations;}function E(Q){return Q.slice(0,Q.lastIndexOf(".")+1);}f=b.extend("sap.ui.model.odata.v4.ODataMetaContextBinding",{constructor:function(o,e,i){b.call(this,o,e,i);},initialize:function(){var e=this.oModel.createBindingContext(this.sPath,this.oContext);this.bInitial=false;if(e!==this.oElementContext){this.oElementContext=e;this._fireChange();}},setContext:function(o){if(o!==this.oContext){this.oContext=o;if(!this.bInitial){this.initialize();}}}});g=a.extend("sap.ui.model.odata.v4.ODataMetaListBinding",{constructor:function(){a.apply(this,arguments);},_fireFilter:function(){},_fireSort:function(){},checkUpdate:function(e){var i=this.oList.length;this.update();if(e||this.oList.length!==i){this._fireChange({reason:C.Change});}},fetchContexts:function(){var i,e=this.oModel.resolve(this.sPath,this.oContext),n=this;if(!e){return S.resolve([]);}i=e.slice(-1)==="@";if(!i&&e!=="/"){e+="/";}return this.oModel.fetchObject(e).then(function(o){if(!o){return[];}if(i){e=e.slice(0,-1);}return Object.keys(o).filter(function(K){return K[0]!=="$"&&i!==(K[0]!=="@");}).map(function(K){return new c(n.oModel,e+K);});});},getContexts:function(i,L){this.iCurrentStart=i||0;this.iCurrentLength=Math.min(L||Infinity,this.iLength,this.oModel.iSizeLimit);return this.getCurrentContexts();},getCurrentContexts:function(){var e=[],i,n=this.iCurrentStart+this.iCurrentLength;for(i=this.iCurrentStart;i<n;i++){e.push(this.oList[this.aIndices[i]]);}return e;},setContexts:function(e){this.oList=e;this.updateIndices();this.applyFilter();this.applySort();this.iLength=this._getLength();},update:function(){var e=[],o=this.fetchContexts(),i=this;if(o.isFulfilled()){e=o.getResult();}else{o.then(function(e){i.setContexts(e);i._fireChange({reason:C.Change});});}this.setContexts(e);}});h=P.extend("sap.ui.model.odata.v4.ODataMetaPropertyBinding",{constructor:function(){P.apply(this,arguments);this.vValue=undefined;},checkUpdate:function(e,i){var n=this;this.oModel.fetchObject(this.sPath,this.oContext,this.mParameters).then(function(o){if(e||o!==n.vValue){n.vValue=o;n._fireChange({reason:i||C.Change});}});},getValue:function(){return this.vValue;},setContext:function(o){if(this.oContext!=o){this.oContext=o;if(this.bRelative){this.checkUpdate(false,C.Context);}}},setValue:function(){throw new Error("Unsupported operation: ODataMetaPropertyBinding#setValue");}});var F=M.extend("sap.ui.model.odata.v4.ODataMetaModel",{constructor:function(o,e,i,n,G){M.call(this);this.aAnnotationUris=i&&!Array.isArray(i)?[i]:i;this.sDefaultBindingMode=B.OneTime;this.mETags={};this.dLastModified=new Date(0);this.oMetadataPromise=null;this.oModel=n;this.mMetadataUrl2Promise={};this.oRequestor=o;this.mSchema2MetadataUrl={};this.mSupportedBindingModes={"OneTime":true,"OneWay":true};this.bSupportReferences=G!==false;this.sUrl=e;}});F.prototype._mergeAnnotations=function(e,n){var o=this;this.validate(this.sUrl,e);e.$Annotations={};Object.keys(e).forEach(function(i){if(e[i].$kind==="Schema"){w(o,i,o.sUrl);A(e[i],e.$Annotations);}});n.forEach(function(G,i){var H,Q;o.validate(o.aAnnotationUris[i],G);for(Q in G){if(Q[0]!=="$"){if(Q in e){z("A schema cannot span more than one document: "+Q,o.aAnnotationUris[i]);}H=G[Q];e[Q]=H;if(H.$kind==="Schema"){w(o,Q,o.aAnnotationUris[i]);A(H,e.$Annotations,true);}}}});};F.prototype.attachEvent=function(e){if(!(e in m)){throw new Error("Unsupported event '"+e+"': v4.ODataMetaModel#attachEvent");}return M.prototype.attachEvent.apply(this,arguments);};F.prototype.bindContext=function(e,o){return new f(this,e,o);};F.prototype.bindList=function(e,o,i,n){return new g(this,e,o,i,n);};F.prototype.bindProperty=function(e,o,i){return new h(this,e,o,i);};F.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#bindTree");};F.prototype.fetchCanonicalPath=function(o){return this.fetchUpdateData("",o).then(function(e){if(e.propertyPath){throw new Error("Context "+o.getPath()+" does not point to an entity. It should be "+e.entityPath);}return"/"+e.editUrl;});};F.prototype.fetchEntityContainer=function(e){var i,n=this;if(!this.oMetadataPromise){i=[S.resolve(this.oRequestor.read(this.sUrl,false,e))];if(this.aAnnotationUris){this.aAnnotationUris.forEach(function(o){i.push(S.resolve(n.oRequestor.read(o,true,e)));});}if(!e){this.oMetadataPromise=S.all(i).then(function(o){var G=o[0];n._mergeAnnotations(G,o.slice(1));return G;});}}return this.oMetadataPromise;};F.prototype.fetchModule=function(e){var i;e=e.replace(/\./g,"/");i=sap.ui.require(e);if(i){return S.resolve(i);}return S.resolve(new Promise(function(n,o){sap.ui.require([e],n);}));};F.prototype.fetchObject=function(n,G,H){var J=this.resolve(n,G),K=this;if(!J){q.sap.log.error("Invalid relative path w/o context",n,s);return S.resolve(null);}return this.fetchEntityContainer().then(function(L){var N,Q,T,X=true,Y,Z,$,a1=L;function b1(i,n){var o,i1=i.indexOf("@",2);if(i1>-1){return e1(W,"Unsupported path after ",i.slice(0,i1));}i=i.slice(2);o=i[0]==="."?q.sap.getObject(i.slice(1),undefined,H.scope):q.sap.getObject(i);if(typeof o!=="function"){return e1(W,i," is not a function but: "+o);}try{a1=o(a1,{context:new c(K,n),schemaChildName:Z});}catch(e){e1(W,"Error calling ",i,": ",e);}return false;}function c1(o){return o.$kind!=="Action"||(!o.$IsBound&&N===k||o.$IsBound&&N===o.$Parameter[0].$Type);}function d1(o){return o&&typeof o.then==="function";}function e1(i){var e;if(q.sap.log.isLoggable(i,s)){e=Array.isArray(Q)?Q.join("/"):Q;q.sap.log[i===D?"debug":"warning"](Array.prototype.slice.call(arguments,1).join("")+(e?" at /"+e:""),J,s);}if(i===W){a1=undefined;}return false;}function f1(e,i){var o;function i1(){Q=Q||$&&i&&$+"/"+i;return e1.apply(this,arguments);}N=a1&&a1.$Type;if(K.bSupportReferences&&!(e in L)){o=E(e);a1=x(K,L,o,i1);}if(e in L){$=T=Z=e;a1=Y=L[Z];if(!d1(a1)){return true;}}if(d1(a1)&&a1.isPending()){return i1(D,"Waiting for ",o);}return i1(W,"Unknown qualified name ",e);}function g1(e,i,o){var i1,j1;if(e==="$Annotations"){return e1(W,"Invalid segment: $Annotations");}if(a1!==L&&typeof a1==="object"&&e in a1){if(e[0]==="$"||r.test(e)){X=false;}}else{i1=e.indexOf("@@");if(i1<0){if(e.length>11&&e.slice(-11)==="@sapui.name"){i1=e.length-11;}else{i1=e.indexOf("@");}}if(i1>0){if(!g1(e.slice(0,i1),i,o)){return false;}e=e.slice(i1);j1=true;}if(typeof a1==="string"&&!(j1&&e[0]==="@"&&(e==="@sapui.name"||e[1]==="@"))&&!h1(a1,o.slice(0,i))){return false;}if(X){if(e[0]==="$"||r.test(e)){X=false;}else if(!j1){if(e[0]!=="@"&&e.indexOf(".")>0){return f1(e);}else if(a1&&"$Type"in a1){if(!f1(a1.$Type,"$Type")){return false;}}else if(a1&&"$Action"in a1){if(!f1(a1.$Action,"$Action")){return false;}N=k;}else if(a1&&"$Function"in a1){if(!f1(a1.$Function,"$Function")){return false;}}else if(i===0){$=T=Z=Z||L.$EntityContainer;a1=Y=Y||L[Z];if(e&&e[0]!=="@"&&!(e in Y)){return e1(W,"Unknown child ",e," of ",Z);}}if(Array.isArray(a1)){a1=a1.filter(c1);if(e==="@$ui5.overload"){return true;}if(a1.length!==1){return e1(W,"Unsupported overloads");}a1=a1[0].$ReturnType;$=$+"/0/$ReturnType";if(a1){if(e==="value"&&!(L[a1.$Type]&&L[a1.$Type].value)){T=undefined;return true;}if(!f1(a1.$Type,"$Type")){return false;}}}}}if(!e){return i+1>=o.length||e1(W,"Invalid empty segment");}if(e[0]==="@"){if(e==="@sapui.name"){a1=T;if(a1===undefined){e1(W,"Unsupported path before @sapui.name");}else if(i+1<o.length){e1(W,"Unsupported path after @sapui.name");}return false;}if(e[1]==="@"){if(i+1<o.length){return e1(W,"Unsupported path after ",e);}return b1(e,"/"+o.slice(0,i).join("/")+"/"+o[i].slice(0,i1));}}if(!a1||typeof a1!=="object"){a1=undefined;return e1(D,"Invalid segment: ",e);}if(X&&e[0]==="@"){a1=(L.$Annotations||{})[$]||{};X=false;}}if(e!=="@"){T=X||e[0]==="@"?e:undefined;$=X?$+"/"+e:undefined;a1=a1[e];}return true;}function h1(e,i){var o;if(Q){return e1(W,"Invalid recursion");}Q=i;X=true;a1=L;o=e.split("/").every(g1);Q=undefined;return o;}h1(J.slice(1));if(d1(a1)){a1=a1.then(function(){return K.fetchObject(n,G,H);});}return a1;});};F.prototype.fetchUI5Type=function(e){var o=this.getMetaContext(e),i=this;if(q.sap.endsWith(e,"/$count")){d=d||new I();return S.resolve(d);}return this.fetchObject(undefined,o).then(function(n){var G,H,T,J,K=j.getName();function L(N,Q){if(Q!==undefined){G=G||{};G[N]=Q;}}if(!n){q.sap.log.warning("No metadata for path '"+e+"', using "+K,undefined,s);return j;}T=n["$ui5.type"];if(T){return T;}if(n.$isCollection){q.sap.log.warning("Unsupported collection type, using "+K,e,s);}else{J=u[n.$Type];if(J){K=J.type;for(H in J.constraints){L(J.constraints[H],H[0]==="@"?i.getObject(H,o):n[H]);}if(n.$Nullable===false){L("nullable",false);}}else{q.sap.log.warning("Unsupported type '"+n.$Type+"', using "+K,e,s);}}if(K===j.getName()){n["$ui5.type"]=j;}else{n["$ui5.type"]=i.fetchModule(K).then(function(N){T=new N(undefined,G);n["$ui5.type"]=T;return T;});}return n["$ui5.type"];});};F.prototype.fetchUpdateData=function(e,o){var n=o.getModel(),G=n.resolve(e,o),H=this;function J(i){var K=new Error(G+": "+i);n.reportError(i,s,K);throw K;}return this.fetchObject(this.getMetaPath(G)).then(function(){return H.fetchEntityContainer();}).then(function(K){var L,N=K[K.$EntityContainer],Q,T,X,Y,Z,$,a1=false,b1;function c1(){L.push({path:Y,prefix:L.pop(),type:b1});}function d1(f1){var i=f1.indexOf("(");return i>=0?f1.slice(i):"";}function e1(f1){var i=f1.indexOf("(");return i>=0?f1.slice(0,i):f1;}$=G.slice(1).split("/");L=[$.shift()];Y="/"+L[0];Q=Y;X=decodeURIComponent(e1(L[0]));T=N[X];if(!T){J("Not an entity set: "+X);}b1=K[T.$Type];e="";Z="";$.forEach(function(i){var f1,g1;Y+="/"+i;if(r.test(i)){c1();Q+="/"+i;}else{g1=decodeURIComponent(e1(i));Z=_.buildPath(Z,g1);f1=b1[g1];if(!f1){J("Not a (navigation) property: "+g1);}b1=K[f1.$Type];if(f1.$kind==="NavigationProperty"){if(Z in T.$NavigationPropertyBinding){X=T.$NavigationPropertyBinding[Z];T=N[X];Z="";L=[encodeURIComponent(X)+d1(i)];if(!f1.$isCollection){c1();}}else{L.push(i);}Q=Y;e="";}else{e=_.buildPath(e,i);}}});return S.all(L.map(function(i){if(typeof i==="string"){return i;}return o.fetchValue(i.path).then(function(f1){var g1;if(!f1){J("No instance to calculate key predicate at "+i.path);}if(_.hasPrivateAnnotation(f1,"transient")){a1=true;return undefined;}g1=_.getPrivateAnnotation(f1,"predicate");if(!g1){J("No key predicate known at "+i.path);}return i.prefix+g1;},function(f1){J(f1.message+" at "+i.path);});})).then(function(i){return{editUrl:a1?undefined:i.join("/"),entityPath:Q,propertyPath:e};});});};F.prototype.fetchValueListMappings=function(o,n,e){var i=this,G=o.getMetaModel();return G.fetchEntityContainer().then(function(H){var J,K=H.$Annotations,L={},N=i===G,T;T=Object.keys(K).filter(function(Q){if(_.namespace(Q)===n){if(i.getObject("/"+Q)===e){return true;}if(!N){throw new Error("Unexpected annotation target '"+Q+"' with namespace of data service in "+o.sServiceUrl);}}return false;});if(!T.length){throw new Error("No annotation '"+v.slice(1)+"' in "+o.sServiceUrl);}J=K[T[0]];Object.keys(J).forEach(function(Q){var X=y(Q,v);if(X!==undefined){L[X]=J[Q];}else if(!N){throw new Error("Unexpected annotation '"+Q.slice(1)+"' for target '"+T[0]+"' with namespace of data service in "+o.sServiceUrl);}});return L;});};F.prototype.fetchValueListType=function(e){var o=this.getMetaContext(e),i=this;return this.fetchObject(undefined,o).then(function(n){var G,T;if(!n){throw new Error("No metadata for "+e);}G=i.getObject("@",o);if(G[t]){return V.Fixed;}for(T in G){if(y(T,p)!==undefined||y(T,v)!==undefined){return V.Standard;}}return V.None;});};F.prototype.getAdapterFactoryModulePath=function(){return"sap/ui/model/odata/v4/meta/ODataAdapterFactory";};F.prototype.getETags=function(){return this.mETags;};F.prototype.getLastModified=function(){return this.dLastModified;};F.prototype.getMetaContext=function(e){return new c(this,this.getMetaPath(e));};F.prototype.getMetaPath=function(e){return _.getMetaPath(e);};F.prototype.getOrCreateValueListModel=function(e){var i=new U(this.sUrl).absoluteTo(document.baseURI).pathname().toString(),o,n;n=new U(e).absoluteTo(i).filename("").toString();o=l[n];if(!o){o=new this.oModel.constructor({operationMode:O.Server,serviceUrl:n,synchronizationMode:"None"});o.setDefaultBindingMode(B.OneWay);l[n]=o;o.oRequestor.mHeaders["X-CSRF-Token"]=this.oModel.oRequestor.mHeaders["X-CSRF-Token"];}return o;};F.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#getOriginalProperty");};F.prototype.getObject=_.createGetMethod("fetchObject");F.prototype.getProperty=F.prototype.getObject;F.prototype.getUI5Type=_.createGetMethod("fetchUI5Type",true);F.prototype.getValueListType=_.createGetMethod("fetchValueListType",true);F.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#isList");};F.prototype.refresh=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#refresh");};F.prototype.requestObject=_.createRequestMethod("fetchObject");F.prototype.requestUI5Type=_.createRequestMethod("fetchUI5Type");F.prototype.requestValueListType=_.createRequestMethod("fetchValueListType");F.prototype.requestValueListInfo=function(e){var i=this.getMetaPath(e),T=i.slice(0,i.lastIndexOf("/")+1),n=this;return Promise.all([this.requestObject(T+"@sapui.name"),this.requestObject(i),this.requestObject(i+"@"),this.requestObject(i+t)]).then(function(o){var G=o[2],H=o[3],J={},N=_.namespace(o[0]),K=o[1],L={};function Q(X,Y,Z,$){if(J[Y]){throw new Error("Annotations '"+v.slice(1)+"' with identical qualifier '"+Y+"' for property "+e+" in "+J[Y]+" and "+Z);}if(H&&L[""]){throw new Error("Annotation '"+t.slice(1)+"' but multiple '"+v.slice(1)+"' for property "+e);}J[Y]=Z;L[H?"":Y]=q.extend(true,{$model:$},X);}if(!K){throw new Error("No metadata for "+e);}Object.keys(G).filter(function(X){return y(X,v)!==undefined;}).forEach(function(X){Q(G[X],y(X,v),n.sUrl,n.oModel);});return Promise.all(Object.keys(G).filter(function(X){return y(X,p)!==undefined;}).map(function(X){var Y=G[X];return Promise.all(Y.map(function(Z){var $=n.getOrCreateValueListModel(Z);return n.fetchValueListMappings($,N,K).then(function(a1){Object.keys(a1).forEach(function(b1){Q(a1[b1],b1,Z,$);});});}));})).then(function(){if(!Object.keys(L).length){throw new Error("No annotation '"+p.slice(1)+"' for "+e);}return L;});});};F.prototype.resolve=function(e,o){var i,n;if(!e){return o?o.getPath():undefined;}n=e[0];if(n==="/"){return e;}if(!o){return undefined;}if(n==="."){if(e[1]!=="/"){throw new Error("Unsupported relative path: "+e);}e=e.slice(2);}i=o.getPath();return n==="@"||i.slice(-1)==="/"?i+e:i+"/"+e;};F.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataMetaModel#setLegacySyntax");};F.prototype.toString=function(){return s+": "+this.sUrl;};F.prototype.validate=function(e,n){var i,o,L,G,H,J;if(!this.bSupportReferences){return n;}for(J in n.$Reference){H=n.$Reference[J];J=new U(J).absoluteTo(this.sUrl).toString();if("$IncludeAnnotations"in H){z("Unsupported IncludeAnnotations",e);}for(i in H.$Include){G=H.$Include[i];if(G in n){z("A schema cannot span more than one document: "+G+" - is both included and defined",e);}w(this,G,J,e);}}L=n.$LastModified?new Date(n.$LastModified):null;this.mETags[e]=n.$ETag?n.$ETag:L;o=n.$Date?new Date(n.$Date):new Date();L=L||o;if(this.dLastModified<L){this.dLastModified=L;}delete n.$Date;delete n.$ETag;delete n.$LastModified;return n;};return F;});
