/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/SyncPromise","sap/ui/core/message/Message","sap/ui/model/BindingMode","sap/ui/model/Context","sap/ui/model/Model","sap/ui/model/odata/OperationMode","sap/ui/thirdparty/URI","./lib/_GroupLock","./lib/_MetadataRequestor","./lib/_Requestor","./lib/_Parser","./ODataContextBinding","./ODataListBinding","./ODataMetaModel","./ODataPropertyBinding","./SubmitMode"],function(q,S,M,B,a,b,O,U,_,c,d,e,f,g,h,i,j){"use strict";var C="sap.ui.model.odata.v4.ODataModel",r=/^\w+$/,k=/^(\$auto|\$direct|\w+)$/,s={messageChange:true},m={annotationURI:true,autoExpandSelect:true,earlyRequests:true,groupId:true,groupProperties:true,odataVersion:true,operationMode:true,serviceUrl:true,supportReferences:true,synchronizationMode:true,updateGroupId:true},l=["$apply","$count","$expand","$filter","$orderby","$search","$select"],E=["$count","$expand","$filter","$levels","$orderby","$search","$select"];var n=b.extend("sap.ui.model.odata.v4.ODataModel",{constructor:function(p){var G,o,H={"Accept-Language":sap.ui.getCore().getConfiguration().getLanguageTag()},t,P,u,v,w=this;b.apply(this);if(!p||p.synchronizationMode!=="None"){throw new Error("Synchronization mode must be 'None'");}t=p.odataVersion||"4.0";this.sODataVersion=t;if(t!=="4.0"&&t!=="2.0"){throw new Error("Unsupported value for parameter odataVersion: "+t);}for(P in p){if(!(P in m)){throw new Error("Unsupported parameter: "+P);}}u=p.serviceUrl;if(!u){throw new Error("Missing service root URL");}v=new U(u);if(v.path()[v.path().length-1]!=="/"){throw new Error("Service root URL must end with '/'");}if(p.operationMode&&p.operationMode!==O.Server){throw new Error("Unsupported operation mode: "+p.operationMode);}this.sOperationMode=p.operationMode;this.mUriParameters=this.buildQueryOptions(v.query(true),false,true);this.sServiceUrl=v.query("").toString();this.sGroupId=p.groupId;if(this.sGroupId===undefined){this.sGroupId="$auto";}if(this.sGroupId!=="$auto"&&this.sGroupId!=="$direct"){throw new Error("Group ID must be '$auto' or '$direct'");}this.checkGroupId(p.updateGroupId,false,"Invalid update group ID: ");this.sUpdateGroupId=p.updateGroupId||this.getGroupId();this.aLockedGroupLocks=[];this.mGroupProperties={};for(G in p.groupProperties){w.checkGroupId(G,true);o=p.groupProperties[G];if(typeof o!=="object"||Object.keys(o).length!==1||!(o.submit in j)){throw new Error("Group '"+G+"' has invalid properties: '"+o+"'");}}this.mGroupProperties=q.extend({"$auto":{submit:j.Auto},"$direct":{submit:j.Direct}},p.groupProperties);if(p.autoExpandSelect!==undefined&&typeof p.autoExpandSelect!=="boolean"){throw new Error("Value for autoExpandSelect must be true or false");}this.bAutoExpandSelect=p.autoExpandSelect===true;this.oMetaModel=new h(c.create(H,t,this.mUriParameters),this.sServiceUrl+"$metadata",p.annotationURI,this,p.supportReferences);this.oRequestor=d.create(this.sServiceUrl,{fnFetchEntityContainer:this.oMetaModel.fetchEntityContainer.bind(this.oMetaModel),fnFetchMetadata:this.oMetaModel.fetchObject.bind(this.oMetaModel),fnGetGroupProperty:this.getGroupProperty.bind(this),fnOnCreateGroup:function(G){if(w.isAutoGroup(G)){sap.ui.getCore().addPrerenderingTask(w._submitBatch.bind(w,G));}}},H,this.mUriParameters,t);if(p.earlyRequests){this.oMetaModel.fetchEntityContainer(true);this.initializeSecurityToken();}this.aAllBindings=[];this.sDefaultBindingMode=B.TwoWay;this.mSupportedBindingModes={OneTime:true,OneWay:true,TwoWay:true};}});n.prototype._submitBatch=function(G){var o,p,t=this;p=S.all(this.aLockedGroupLocks.map(function(u){return u.waitFor(G);}));o=p.isPending();if(o){q.sap.log.info("submitBatch('"+G+"') is waiting for locks",null,C);}return Promise.resolve(p.then(function(){if(o){q.sap.log.info("submitBatch('"+G+"') continues",null,C);}t.aLockedGroupLocks=t.aLockedGroupLocks.filter(function(u){return u.isLocked();});return t.oRequestor.submitBatch(G).catch(function(u){t.reportError("$batch failed",C,u.message);throw u;});}));};n.prototype.attachEvent=function(o){if(!(o in s)){throw new Error("Unsupported event '"+o+"': v4.ODataModel#attachEvent");}return b.prototype.attachEvent.apply(this,arguments);};n.prototype.bindContext=function(p,o,P){return new f(this,p,o,P);};n.prototype.bindingCreated=function(o){this.aAllBindings.push(o);};n.prototype.bindingDestroyed=function(o){var I=this.aAllBindings.indexOf(o);if(I<0){throw new Error("Unknown "+o);}this.aAllBindings.splice(I,1);};n.prototype.bindList=function(p,o,v,F,P){return new g(this,p,o,v,F,P);};n.prototype.bindProperty=function(p,o,P){return new i(this,p,o,P);};n.prototype.bindTree=function(){throw new Error("Unsupported operation: v4.ODataModel#bindTree");};n.prototype.buildBindingParameters=function(p,A){var R={},t=this;if(p){Object.keys(p).forEach(function(K){var v=p[K];if(K.indexOf("$$")!==0){return;}if(!A||A.indexOf(K)<0){throw new Error("Unsupported binding parameter: "+K);}switch(K){case"$$aggregation":break;case"$$groupId":case"$$updateGroupId":t.checkGroupId(v,false,"Unsupported value for binding parameter '"+K+"': ");break;case"$$inheritExpandSelect":if(v!==true&&v!==false){throw new Error("Unsupported value for binding parameter "+"'$$inheritExpandSelect': "+v);}break;case"$$operationMode":if(v!==O.Server){throw new Error("Unsupported operation mode: "+v);}break;case"$$ownRequest":if(v!==true){throw new Error("Unsupported value for binding parameter "+"'$$ownRequest': "+v);}break;default:throw new Error("Unknown binding-specific parameter: "+K);}R[K]=v;});}return R;};n.prototype.buildQueryOptions=function(p,o,t){var P,T=q.extend(true,{},p);function u(v,w,A){var x,y,z,V=v[w];if(!o||A.indexOf(w)<0){throw new Error("System query option "+w+" is not supported");}if((w==="$expand"||w==="$select")&&typeof V==="string"){V=e.parseSystemQueryOption(w+"="+V)[w];v[w]=V;}if(w==="$expand"){for(z in V){y=V[z];if(y===null||typeof y!=="object"){y=V[z]={};}for(x in y){u(y,x,E);}}}else if(w==="$count"){if(typeof V==="boolean"){if(!V){delete v.$count;}}else{switch(typeof V==="string"&&V.toLowerCase()){case"false":delete v.$count;break;case"true":v.$count=true;break;default:throw new Error("Invalid value for $count: "+V);}}}}if(p){for(P in p){if(P.indexOf("$$")===0){delete T[P];}else if(P[0]==="@"){throw new Error("Parameter "+P+" is not supported");}else if(P[0]==="$"){u(T,P,l);}else if(!t&&P.indexOf("sap-")===0){throw new Error("Custom query option "+P+" is not supported");}}}return T;};n.prototype.checkDeferredGroupId=function(G){this.checkGroupId(G,true,"Invalid deferred group ID: ");if(this.isAutoGroup(G)||this.isDirectGroup(G)){throw new Error("Group ID is not deferred: "+G);}};n.prototype.checkGroupId=function(G,A,o){if(!A&&G===undefined||typeof G==="string"&&(A?r:k).test(G)){return;}throw new Error((o||"Invalid group ID: ")+G);};n.prototype.createBindingContext=function(p,o){var D,t,u,R,v;function w(u){var x=u.indexOf("."),y=u.indexOf("/");return x>0&&(y<0||x<y);}if(arguments.length>2){throw new Error("Only the parameters sPath and oContext are supported");}if(o&&o.getBinding){throw new Error("Unsupported type: oContext must be of type sap.ui.model.Context, "+"but was sap.ui.model.odata.v4.Context");}R=this.resolve(p,o);if(R===undefined){throw new Error("Cannot create binding context from relative path '"+p+"' without context");}v=R.indexOf('#');if(v>=0){D=R.slice(0,v);u=R.slice(v+1);if(u[0]==="#"){u=u.slice(1);}else if(D.length>1&&u[0]!=="@"&&w(u)){return new a(this,R);}if(u[0]==="/"){u="."+u;}t=this.oMetaModel.getMetaContext(D);return this.oMetaModel.createBindingContext(u,t);}return new a(this,R);};n.prototype.destroy=function(){this.oMetaModel.destroy();return b.prototype.destroy.apply(this,arguments);};n.prototype.destroyBindingContext=function(){throw new Error("Unsupported operation: v4.ODataModel#destroyBindingContext");};n.prototype.getContext=function(){throw new Error("Unsupported operation: v4.ODataModel#getContext");};n.prototype.getDependentBindings=function(p){return this.aAllBindings.filter(function(o){var t=o.getContext();return o.isRelative()&&(t===p||t&&t.getBinding&&t.getBinding()===p);});};n.prototype.getGroupId=function(){return this.sGroupId;};n.prototype.getGroupProperty=function(G,p){switch(p){case"submit":return this.mGroupProperties[G]?this.mGroupProperties[G].submit:j.API;default:throw new Error("Unsupported group property: '"+p+"'");}};n.prototype.getMetaModel=function(){return this.oMetaModel;};n.prototype.getObject=function(){throw new Error("Unsupported operation: v4.ODataModel#getObject");};n.prototype.getODataVersion=function(){return this.sODataVersion;};n.prototype.getOriginalProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getOriginalProperty");};n.prototype.getProperty=function(){throw new Error("Unsupported operation: v4.ODataModel#getProperty");};n.prototype.getUpdateGroupId=function(){return this.sUpdateGroupId;};n.prototype.hasPendingChanges=function(){return this.oRequestor.hasPendingChanges();};n.prototype.initializeSecurityToken=function(){this.oRequestor.refreshSecurityToken();};n.prototype.isList=function(){throw new Error("Unsupported operation: v4.ODataModel#isList");};n.prototype.isAutoGroup=function(G){return this.mGroupProperties[G]&&this.mGroupProperties[G].submit===j.Auto;};n.prototype.isDirectGroup=function(G){return this.mGroupProperties[G]&&this.mGroupProperties[G].submit===j.Direct;};n.prototype.lockGroup=function(G,L){var o;if(L instanceof _){L.setGroupId(G);return L;}o=new _(G,L);if(o.isLocked()){this.aLockedGroupLocks.push(o);}return o;};n.prototype.refresh=function(G){this.checkGroupId(G);this.aBindings.slice().forEach(function(o){if(o.isRefreshable()){o.refresh(G);}});};n.prototype.reportError=function(L,R,o){var D;if(o.canceled==="noDebugLog"){return;}D=o.stack||o.message;if(D.indexOf(o.message)<0){D=o.message+"\n"+o.stack;}if(o.canceled){q.sap.log.debug(L,D,R);return;}q.sap.log.error(L,D,R);if(o.$reported){return;}o.$reported=true;sap.ui.getCore().getMessageManager().addMessages(new M({message:o.message,processor:this,technical:true,type:"Error"}));};n.prototype.requestCanonicalPath=function(o){return o.requestCanonicalPath();};n.prototype.resetChanges=function(G){G=G||this.sUpdateGroupId;this.checkDeferredGroupId(G);this.oRequestor.cancelChanges(G);this.aAllBindings.forEach(function(o){if(G===o.getUpdateGroupId()){o.resetInvalidDataState();}});};n.prototype.resolve=function(p,o){var R;if(p&&p[0]==="/"){R=p;}else if(o){if(p){if(o.getPath().slice(-1)==="/"){R=o.getPath()+p;}else{R=o.getPath()+"/"+p;}}else{R=o.getPath();}}if(R&&R!=="/"&&R[R.length-1]==="/"&&R.indexOf("#")<0){R=R.slice(0,R.length-1);}return R;};n.prototype.setLegacySyntax=function(){throw new Error("Unsupported operation: v4.ODataModel#setLegacySyntax");};n.prototype.submitBatch=function(G){var t=this;this.checkDeferredGroupId(G);return new Promise(function(o){sap.ui.getCore().addPrerenderingTask(function(){o(t._submitBatch(G));});});};n.prototype.toString=function(){return C+": "+this.sServiceUrl;};return n;});
