/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/SyncPromise","./_Batch","./_GroupLock","./_Helper","./_V2Requestor"],function(q,S,_,a,b,c){"use strict";var B={"Accept":"multipart/mixed"},d;function e(r,G){var f=r.mBatchQueue[G];if(f[0].length===0&&f.length===1){delete r.mBatchQueue[G];}}function g(h){var r;h=h.toLowerCase();for(r in this.headers){if(r.toLowerCase()===h){return this.headers[r];}}}function R(s,h,Q,m){this.mBatchQueue={};this.mHeaders=h||{};this.oModelInterface=m;this.sQueryParams=b.buildQuery(Q);this.mRunningChangeRequests={};this.oSecurityTokenPromise=null;this.sServiceUrl=s;}R.prototype.mFinalHeaders={"Content-Type":"application/json;charset=UTF-8;IEEE754Compatible=true"};R.prototype.mPredefinedPartHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true"};R.prototype.mPredefinedRequestHeaders={"Accept":"application/json;odata.metadata=minimal;IEEE754Compatible=true","OData-MaxVersion":"4.0","OData-Version":"4.0","X-CSRF-Token":"Fetch"};R.prototype.batchRequestSent=function(G,h){if(h){if(G in this.mRunningChangeRequests){this.mRunningChangeRequests[G]+=1;}else{this.mRunningChangeRequests[G]=1;}}};R.prototype.batchResponseReceived=function(G,h){if(h){this.mRunningChangeRequests[G]-=1;if(this.mRunningChangeRequests[G]===0){delete this.mRunningChangeRequests[G];}}};R.prototype.buildQueryString=function(m,Q,D,s){return b.buildQuery(this.convertQueryOptions(m,Q,D,s));};R.prototype.cancelChanges=function(G){if(this.mRunningChangeRequests[G]){throw new Error("Cannot cancel the changes for group '"+G+"', the batch request is running");}this.cancelChangesByFilter(function(){return true;},G);};R.prototype.cancelChangesByFilter=function(f,G){var C=false,t=this;function h(s){var j=t.mBatchQueue[s],o,k,E,i;k=j[0];for(i=k.length-1;i>=0;i--){o=k[i];if(o.$cancel&&f(o)){o.$cancel();E=new Error("Request canceled: "+o.method+" "+o.url+"; group: "+s);E.canceled=true;o.$reject(E);k.splice(i,1);C=true;}}e(t,s);}if(G){if(this.mBatchQueue[G]){h(G);}}else{for(G in this.mBatchQueue){h(G);}}return C;};R.prototype.convertExpand=function(E,s){var k,r=[],t=this;if(!E||typeof E!=="object"){throw new Error("$expand must be a valid object");}k=Object.keys(E);if(s){k=k.sort();}k.forEach(function(f){var v=E[f];if(v&&typeof v==="object"){r.push(t.convertExpandOptions(f,v,s));}else{r.push(f);}});return r.join(",");};R.prototype.convertExpandOptions=function(E,v,s){var f=[];this.doConvertSystemQueryOptions(undefined,v,function(o,O){f.push(o+'='+O);},undefined,s);return f.length?E+"("+f.join(";")+")":E;};R.prototype.convertQueryOptions=function(m,Q,D,s){var C={};if(!Q){return undefined;}this.doConvertSystemQueryOptions(m,Q,function(k,v){C[k]=v;},D,s);return C;};R.prototype.convertResourcePath=function(r){return r;};R.prototype.doCheckVersionHeader=function(G,r,v){var o=G("OData-Version"),D=!o&&G("DataServiceVersion");if(D){throw new Error("Expected 'OData-Version' header with value '4.0' but received"+" 'DataServiceVersion' header with value '"+D+"' in response for "+this.sServiceUrl+r);}if(o==="4.0"||!o&&v){return;}throw new Error("Expected 'OData-Version' header with value '4.0' but received value '"+o+"' in response for "+this.sServiceUrl+r);};R.prototype.doConvertSystemQueryOptions=function(m,Q,r,D,s){var t=this;Object.keys(Q).forEach(function(k){var v=Q[k];if(D&&k[0]==='$'){return;}switch(k){case"$expand":v=t.convertExpand(v,s);break;case"$select":if(Array.isArray(v)){v=s?v.sort().join(","):v.join(",");}break;default:}r(k,v);});};R.prototype.doConvertResponse=function(r,m){return r;};R.prototype.fetchTypeForPath=function(m,A){return this.oModelInterface.fnFetchMetadata(m+(A?"/$Type":"/"));};R.prototype.formatPropertyAsLiteral=function(v,p){return b.formatLiteral(v,p.$Type);};R.prototype.getGroupSubmitMode=function(G){return this.oModelInterface.fnGetGroupProperty(G,"submit");};R.prototype.getPathAndAddQueryOptions=function(p,o,P){var A=[],n,N={},f,t=this;p=p.slice(1,-5);if(o.$Parameter){o.$Parameter.forEach(function(f){N[f.$Name]=f;});}if(o.$kind==="Function"){for(n in P){f=N[n];if(f){if(f.$IsCollection){throw new Error("Unsupported collection-valued parameter: "+n);}A.push(encodeURIComponent(n)+"="+encodeURIComponent(t.formatPropertyAsLiteral(P[n],f)));}}p+="("+A.join(",")+")";}else{for(n in P){if(!(n in N)){delete P[n];}}}return p;};R.prototype.getServiceUrl=function(){return this.sServiceUrl;};R.prototype.hasPendingChanges=function(){var G,p;for(G in this.mBatchQueue){p=this.mBatchQueue[G][0].some(function(r){return r.$cancel;});if(p){return true;}}return Object.keys(this.mRunningChangeRequests).length>0;};R.prototype.isActionBodyOptional=function(){return false;};R.prototype.isChangeSetOptional=function(){return true;};R.prototype.ready=function(){return S.resolve();};R.prototype.refreshSecurityToken=function(o){var t=this;if(!this.oSecurityTokenPromise){if(o!==this.mHeaders["X-CSRF-Token"]){return Promise.resolve();}this.oSecurityTokenPromise=new Promise(function(r,f){q.ajax(t.sServiceUrl+t.sQueryParams,{method:"HEAD",headers:{"X-CSRF-Token":"Fetch"}}).then(function(D,T,j){t.mHeaders["X-CSRF-Token"]=j.getResponseHeader("X-CSRF-Token");t.oSecurityTokenPromise=null;r();},function(j,T,E){t.oSecurityTokenPromise=null;f(b.createError(j));});});}return this.oSecurityTokenPromise;};R.prototype.removePatch=function(p){var C=this.cancelChangesByFilter(function(o){return o.$promise===p;});if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.removePost=function(G,o){var C=this.cancelChangesByFilter(function(f){return f.body===o;},G);if(!C){throw new Error("Cannot reset the changes, the batch request is running");}};R.prototype.request=function(m,r,G,h,p,s,C,M){var f=G&&G.getGroupId()||"$direct",P,o,t=this;if(f==="$cached"){throw new Error("Unexpected request: "+m+" "+r);}if(G){G.unlock();}r=this.convertResourcePath(r);if(this.getGroupSubmitMode(f)!=="Direct"){P=new Promise(function(i,j){var k=t.mBatchQueue[f];if(!k){k=t.mBatchQueue[f]=[[]];if(t.oModelInterface.fnOnCreateGroup){t.oModelInterface.fnOnCreateGroup(f);}}o={method:m,url:r,headers:q.extend({},t.mPredefinedPartHeaders,t.mHeaders,h,t.mFinalHeaders),body:p,$cancel:C,$metaPath:M,$reject:j,$resolve:i,$submit:s};if(m==="GET"){k.push(o);}else{k[0].push(o);}});o.$promise=P;return P;}if(s){s();}return this.sendRequest(m,r,q.extend({},h,this.mFinalHeaders),JSON.stringify(d.cleanPayload(p))).then(function(i){return t.doConvertResponse(i.body,M);});};R.prototype.relocate=function(C,o,n){var r=this.mBatchQueue[C],t=this,f=r&&r[0].some(function(h,i){if(h.body===o){t.request(h.method,h.url,new a(n),h.headers,o,h.$submit,h.$cancel).then(h.$resolve,h.$reject);r[0].splice(i,1);e(t,C);return true;}});if(!f){throw new Error("Request not found in group '"+C+"'");}};R.prototype.sendBatch=function(r){var o=_.serializeBatchRequest(r);return this.sendRequest("POST","$batch"+this.sQueryParams,q.extend(o.headers,B),o.body).then(function(f){return _.deserializeBatchResponse(f.contentType,f.body);});};R.prototype.sendRequest=function(m,r,h,p){var s=this.sServiceUrl+r,t=this;return new Promise(function(f,i){function j(I){var o=t.mHeaders["X-CSRF-Token"];return q.ajax(s,{data:p,headers:q.extend({},t.mPredefinedRequestHeaders,t.mHeaders,h),method:m}).then(function(k,T,l){try{t.doCheckVersionHeader(l.getResponseHeader,r,!k);}catch(E){i(E);return;}t.mHeaders["X-CSRF-Token"]=l.getResponseHeader("X-CSRF-Token")||t.mHeaders["X-CSRF-Token"];f({body:k,contentType:l.getResponseHeader("Content-Type")});},function(k,T,E){var C=k.getResponseHeader("X-CSRF-Token");if(!I&&k.status===403&&C&&C.toLowerCase()==="required"){t.refreshSecurityToken(o).then(function(){j(true);},i);}else{i(b.createError(k));}});}if(t.oSecurityTokenPromise&&m!=="GET"){return t.oSecurityTokenPromise.then(j);}return j();});};R.prototype.submitBatch=function(G){var C=[],h,p,r=this.mBatchQueue[G],t=this;function m(p,i){var j,P,s;if(p&&p.method==="PATCH"&&i.method==="PATCH"&&p.url===i.url&&q.sap.equal(p.headers,i.headers)){P=p.body;j=i.body;for(s in P){if(P[s]===null&&j[s]&&typeof j[s]==="object"){return undefined;}}return q.extend(true,P,j);}return undefined;}function v(r,i){var j;r.forEach(function(k,l){var E,n,s=i[l];if(Array.isArray(s)){v(k,s);}else if(!s){E=new Error("HTTP request was not processed because the previous request failed");E.cause=j;k.$reject(E);}else if(s.status>=400){s.getResponseHeader=g;j=b.createError(s);f(j,k);}else if(s.responseText){n=JSON.parse(s.responseText);try{t.doCheckVersionHeader(g.bind(s),k.url,true);k.$resolve(t.doConvertResponse(n,k.$metaPath));}catch(u){k.$reject(u);}}else{k.$resolve();}});}function o(i){if(Array.isArray(i)){i.forEach(o);}else if(i.$submit){i.$submit();}}function f(E,i){if(Array.isArray(i)){i.forEach(f.bind(null,E));}else{i.$reject(E);}}if(!r){return Promise.resolve();}delete this.mBatchQueue[G];o(r);r[0].forEach(function(i){var M=m(p,i);if(M){p.body=M;i.$resolve(p.$promise);}else{C.push(i);p=i;}});if(C.length===0){r.splice(0,1);}else if(C.length===1&&this.isChangeSetOptional()){r[0]=C[0];}else{r[0]=C;}h=C.length>0;this.batchRequestSent(G,h);return this.sendBatch(d.cleanBatch(r)).then(function(i){t.batchResponseReceived(G,h);v(r,i);}).catch(function(E){var i=new Error("HTTP request was not processed because $batch failed");function j(r){r.forEach(function(k){if(Array.isArray(k)){j(k);}else{k.$reject(i);}});}t.batchResponseReceived(G,h);i.cause=E;j(r);throw E;});};d={cleanBatch:function(r){r.forEach(function(o){if(Array.isArray(o)){d.cleanBatch(o);}else{o.body=d.cleanPayload(o.body);}});return r;},cleanPayload:function(p){var r=p;if(r){Object.keys(r).forEach(function(k){if(k.indexOf("@$ui5.")===0){if(r===p){r=q.extend({},p);}delete r[k];}});}return r;},create:function(s,m,h,Q,o){var r=new R(s,h,Q,m);if(o==="2.0"){c(r);}return r;}};return d;},false);
