/*!
 * UI development toolkit for HTML5 (OpenUI5)
 * (c) Copyright 2009-2018 SAP SE or an SAP affiliate company.
 * Licensed under the Apache License, Version 2.0 - see LICENSE.txt.
 */
sap.ui.define(["jquery.sap.global","sap/ui/base/ManagedObject","sap/ui/rta/toolbar/Fiori","sap/ui/rta/toolbar/Standalone","sap/ui/rta/toolbar/Personalization","sap/ui/dt/DesignTime","sap/ui/dt/Overlay","sap/ui/rta/command/Stack","sap/ui/rta/command/CommandFactory","sap/ui/rta/command/LREPSerializer","sap/ui/rta/plugin/Rename","sap/ui/rta/plugin/DragDrop","sap/ui/rta/plugin/RTAElementMover","sap/ui/rta/plugin/CutPaste","sap/ui/rta/plugin/Remove","sap/ui/rta/plugin/CreateContainer","sap/ui/rta/plugin/additionalElements/AdditionalElementsPlugin","sap/ui/rta/plugin/additionalElements/AddElementsDialog","sap/ui/rta/plugin/additionalElements/AdditionalElementsAnalyzer","sap/ui/rta/plugin/Combine","sap/ui/rta/plugin/Split","sap/ui/rta/plugin/Selection","sap/ui/rta/plugin/Settings","sap/ui/rta/plugin/ControlVariant","sap/ui/dt/plugin/ContextMenu","sap/ui/dt/plugin/TabHandling","sap/ui/fl/FlexControllerFactory","sap/ui/rta/Utils","sap/ui/dt/Util","sap/ui/fl/Utils","sap/ui/fl/registry/Settings","sap/m/MessageBox","sap/m/MessageToast","sap/ui/rta/util/PopupManager","sap/ui/core/BusyIndicator","sap/ui/dt/DOMUtil","sap/ui/rta/util/StylesLoader","sap/ui/rta/util/UrlParser","sap/ui/rta/appVariant/Feature","sap/ui/Device","sap/ui/rta/service/index","sap/ui/rta/util/ServiceEventBus","sap/ui/dt/OverlayRegistry"],function(q,M,F,S,P,D,O,C,a,L,R,b,c,d,e,f,A,g,h,j,k,l,m,n,o,T,p,U,r,s,t,u,v,w,B,x,y,z,E,G,H,I,J){"use strict";var K="sap-ui-fl-max-layer";var N="starting";var Q="started";var V="failed";var W=M.extend("sap.ui.rta.RuntimeAuthoring",{metadata:{library:"sap.ui.rta",associations:{"rootControl":{type:"sap.ui.core.Control"}},properties:{"customFieldUrl":"string","showCreateCustomField":"boolean","showToolbars":{type:"boolean",defaultValue:true},"triggeredFromDialog":{type:"boolean",defaultValue:false},"showWindowUnloadDialog":{type:"boolean",defaultValue:true},"commandStack":{type:"any"},"plugins":{type:"any",defaultValue:{}},"flexSettings":{type:"object",defaultValue:{layer:"CUSTOMER",developerMode:true}},"mode":{type:"string",defaultValue:"adaptation"},"metadataScope":{type:"string",defaultValue:"default"}},events:{"start":{parameters:{editablePluginsCount:{type:"int"}}},"stop":{},"failed":{},"selectionChange":{parameters:{selection:{type:"sap.ui.dt.Overlay[]"}}},"modeChanged":{},"undoRedoStackModified":{}}},_sAppTitle:null,_dependents:null,constructor:function(){M.apply(this,arguments);this._dependents={};this._mServices={};this._mCustomServicesDictinary={};this.iEditableOverlaysCount=0;this.addDependent(new w(),'popupManager');if(this.getShowToolbars()){this.getPopupManager().attachOpen(this.onPopupOpen,this);this.getPopupManager().attachClose(this.onPopupClose,this);}if(window.parent!==window){this.startService('receiver');}},_RESTART:{NOT_NEEDED:"no restart",VIA_HASH:"without max layer",RELOAD_PAGE:"reload"}});W.prototype.getDefaultPlugins=function(){if(!this._mDefaultPlugins){var i=new a({flexSettings:this.getFlexSettings()});this._mDefaultPlugins={};this._mDefaultPlugins["selection"]=new l({commandFactory:i,multiSelectionRequiredPlugins:[j.getMetadata().getName(),e.getMetadata().getName()],elementEditableChange:this._onElementEditableChange.bind(this)});var Z=new c({commandFactory:i});this._mDefaultPlugins["dragDrop"]=new b({elementMover:Z,commandFactory:i,dragStarted:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["rename"]=new R({commandFactory:i,editable:this._handleStopCutPaste.bind(this)});this._mDefaultPlugins["additionalElements"]=new A({commandFactory:i,analyzer:h,dialog:new g()});this._mDefaultPlugins["createContainer"]=new f({commandFactory:i});this._mDefaultPlugins["remove"]=new e({commandFactory:i});this._mDefaultPlugins["cutPaste"]=new d({elementMover:Z,commandFactory:i});this._mDefaultPlugins["settings"]=new m({commandFactory:i});this._mDefaultPlugins["combine"]=new j({commandFactory:i});this._mDefaultPlugins["split"]=new k({commandFactory:i});this._mDefaultPlugins["contextMenu"]=new o({styleClass:U.getRtaStyleClassName()});this._mDefaultPlugins["tabHandling"]=new T();this._mDefaultPlugins["controlVariant"]=new n({commandFactory:i});}return q.extend({},this._mDefaultPlugins);};W.prototype.addDependent=function(i,Z,$){$=typeof $==='undefined'?true:!!$;if(!(Z in this._dependents)){if(Z&&$){this['get'+q.sap.charToUpperCase(Z,0)]=this.getDependent.bind(this,Z);}this._dependents[Z||i.getId()]=i;}else{throw r.createError("RuntimeAuthoring#addDependent",r.printf("Can't add dependency with same key '{0}'",Z),"sap.ui.rta");}};W.prototype.getDependent=function(i){return this._dependents[i];};W.prototype.getDependents=function(){return this._dependents;};W.prototype.removeDependent=function(i){delete this._dependents[i];};W.prototype._destroyDefaultPlugins=function(i){for(var Z in this._mDefaultPlugins){var $=this._mDefaultPlugins[Z];if($&&!$.bIsDestroyed){if(!i||i[Z]!==$){$.destroy();}}}if(!i){this._mDefaultPlugins=null;}};W.prototype.onPopupOpen=function(i){if(i.getParameters()instanceof sap.m.Dialog&&this.getToolbar()instanceof F){this.getToolbar().setColor("contrast");}this.getToolbar().bringToFront();};W.prototype.onPopupClose=function(i){if(i.getParameters()instanceof sap.m.Dialog){this.getToolbar().setColor();}};W.prototype.setPlugins=function(i){if(this._oDesignTime){throw new Error('Cannot replace plugins: runtime authoring already started');}this.setProperty("plugins",i);};W.prototype.setFlexSettings=function(i){var Z=q.sap.getUriParameters();var $=Z.mParams["sap-ui-layer"];i=q.extend({},this.getFlexSettings(),i);if($&&$.length>0){i.layer=$[0];}if(i.scenario||i.baseId){var _=s.buildLrepRootNamespace(i.baseId,i.scenario,i.projectId);i.rootNamespace=_;i.namespace=_+"changes/";}U.setRtaStyleClassName(i.layer);this.setProperty("flexSettings",i);};W.prototype.getLayer=function(i){return this.getFlexSettings().layer;};W.prototype._getFlexController=function(){var i=this._oRootControl||sap.ui.getCore().byId(this.getRootControl());return p.createForControl(i);};W.prototype._getTextResources=function(){return sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");};W.prototype.start=function(){var i;if(!this._oDesignTime){this._oRootControl=sap.ui.getCore().byId(this.getRootControl());if(!this._oRootControl){var Z="Could not start Runtime Adaptation: Root control not found";s.log.error(Z);return Promise.reject(Z);}return this._handlePersonalizationChangesOnStart().then(function($){if($){return Promise.reject("Reload triggered");}if(!this.getPlugins()||!Object.keys(this.getPlugins()).length){this.setPlugins(this.getDefaultPlugins());}this._destroyDefaultPlugins(this.getPlugins());Object.keys(this.getPlugins()).forEach(function(b1){if(this.getPlugins()[b1].attachElementModified){this.getPlugins()[b1].attachElementModified(this._handleElementModified,this);}}.bind(this));if(this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(this.getCommandStack());}this._oSerializer=new L({commandStack:this.getCommandStack(),rootControl:this.getRootControl()});var _=Object.keys(this.getPlugins());var a1=_.map(function(b1){return this.getPlugins()[b1];},this);i=new Promise(function(b1,c1){q.sap.measure.start("rta.dt.startup","Measurement of RTA: DesignTime start up");this._oDesignTime=new D({scope:this.getMetadataScope(),plugins:a1});this._oDesignTime.addRootElement(this._oRootControl);q(O.getOverlayContainer()).addClass("sapUiRta");if(this.getLayer()==="USER"){q(O.getOverlayContainer()).addClass("sapUiRtaPersonalize");}this._oRootControl.addStyleClass("sapUiRtaRoot");this._oDesignTime.attachSelectionChange(function(d1){this.fireSelectionChange({selection:d1.getParameter("selection")});},this);this._oDesignTime.attachEventOnce("synced",function(){b1();q.sap.measure.end("rta.dt.startup","Measurement of RTA: DesignTime start up");},this);this._oDesignTime.attachEventOnce("syncFailed",c1);}.bind(this));this._oldUnloadHandler=window.onbeforeunload;window.onbeforeunload=this._onUnload.bind(this);}.bind(this)).then(function(){if(this.getShowToolbars()){return this._getPublishAndAppVariantSupportVisibility().then(function($){var _=$[0];var a1=$[1];this._createToolsMenu(_,a1);return this.getToolbar().show();}.bind(this));}}.bind(this)).then(function(){this._onStackModified();this.fnKeyDown=this._onKeyDown.bind(this);q(document).on("keydown",this.fnKeyDown);}.bind(this)).then(function(){this.getPopupManager().setRta(this);var $=this.getPopupManager().getRelevantPopups();if($.aDialogs||$.aPopovers){return this.getShowToolbars()&&this.getToolbar().bringToFront();}}.bind(this)).then(function(){y.loadStyles('InPageStyles').then(function($){var _=$.replace(/%scrollWidth%/g,x.getScrollbarWidth()+'px');x.insertStyles(_);});}).then(function(){return i;}).then(function(){this.fireStart({editablePluginsCount:this.iEditableOverlaysCount});}.bind(this),function(Z){if(Z!=="Reload triggered"){this.fireFailed(Z);}if(Z){return Promise.reject(Z);}}.bind(this));}};W.prototype._getPublishAndAppVariantSupportVisibility=function(){return t.getInstance().then(function(i){var Z=E.isPlatFormEnabled(this._oRootControl,this.getLayer(),this._oSerializer);return[!i.isProductiveSystem()&&!i.hasMergeErrorOccured(),!i.isProductiveSystem()&&Z];}.bind(this)).catch(function(i){return false;});};var X=function(Z){B.hide();var $="";if(Z.messages&&Array.isArray(Z.messages)){for(var i=0;i<Z.messages.length;i++){$=(Z.messages[i].severity==="Error")?$+Z.messages[i].text+"\n":$;}}else{$=Z.stack||Z.message||Z.status||Z;}var _=sap.ui.getCore().getLibraryResourceBundle("sap.ui.rta");q.sap.log.error("Failed to transfer runtime adaptation changes to layered repository",$);var a1=_.getText("MSG_LREP_TRANSFER_ERROR")+"\n"+_.getText("MSG_ERROR_REASON",$);u.error(a1,{styleClass:U.getRtaStyleClassName()});};W.prototype.setCommandStack=function(i){var Z=this.getProperty("commandStack");if(Z){Z.detachModified(this._onStackModified,this);}if(this._oInternalCommandStack){this._oInternalCommandStack.destroy();delete this._oInternalCommandStack;}var $=this.setProperty("commandStack",i);if(i){i.attachModified(this._onStackModified,this);}if(this.getPlugins()&&this.getPlugins()["settings"]){this.getPlugins()["settings"].setCommandStack(i);}return $;};W.prototype.getCommandStack=function(){var i=this.getProperty("commandStack");if(!i){i=new C();this._oInternalCommandStack=i;this.setCommandStack(i);}return i;};W.prototype._onStackModified=function(){var i=this.getCommandStack();var Z=i.canUndo();var $=i.canRedo();var _=U.getUshellContainer();if(this.getShowToolbars()){this.getToolbar().setUndoRedoEnabled(Z,$);this.getToolbar().setPublishEnabled(this._bChangesExist||Z);this.getToolbar().setRestoreEnabled(this._bChangesExist||Z);}this.fireUndoRedoStackModified();if(_){if(Z){_.setDirtyFlag(true);}else{_.setDirtyFlag(false);}}};W.prototype._closeToolbar=function(){if(this.getShowToolbars()&&this.getToolbar){return this.getToolbar().hide();}};W.prototype.getSelection=function(){if(this._oDesignTime){return this._oDesignTime.getSelectionManager().get();}else{return[];}};W.prototype.stop=function(i,Z){return((Z)?Promise.resolve(this._RESTART.NOT_NEEDED):this._handleReloadOnExit()).then(function($){return((i)?Promise.resolve():this._serializeToLrep(this)).then(this._closeToolbar.bind(this)).then(function(){this.fireStop();if($!==this._RESTART.NOT_NEEDED){this._removeMaxLayerParameter();if($===this._RESTART.RELOAD_PAGE){this._reloadPage();}}}.bind(this));}.bind(this))['catch'](X);};W.prototype.restore=function(){this._onRestore();};W.prototype.transport=function(){return this._onTransport();};W.prototype.undo=function(){return this._onUndo();};W.prototype.redo=function(){return this._onRedo();};W.prototype.canUndo=function(){return this.getCommandStack().canUndo();};W.prototype.canRedo=function(){return this.getCommandStack().canRedo();};W.prototype._onKeyDown=function(i){var Z=G.os.macintosh;var $=O.getOverlayContainer().get(0).contains(document.activeElement);var _=this.getShowToolbars()&&this.getToolbar().getDomRef().contains(document.activeElement);var a1=document.body===document.activeElement;var b1=q(document.activeElement).parents('.sapUiRtaEditableField').length>0;if(($||_||a1)&&!b1){var c1=Z?i.metaKey:i.ctrlKey;if(i.keyCode===q.sap.KeyCodes.Z&&i.shiftKey===false&&i.altKey===false&&c1===true){this._onUndo().then(i.stopPropagation.bind(i));}else if(((Z&&i.keyCode===q.sap.KeyCodes.Z&&i.shiftKey===true)||(!Z&&i.keyCode===q.sap.KeyCodes.Y&&i.shiftKey===false))&&i.altKey===false&&c1===true){this._onRedo().then(i.stopPropagation.bind(i));}}};W.prototype._onUnload=function(){var i=this.getCommandStack();var Z=i.canUndo()||i.canRedo();if(Z&&this.getShowWindowUnloadDialog()){var $=this._getTextResources().getText("MSG_UNSAVED_CHANGES");return $;}else{window.onbeforeunload=this._oldUnloadHandler;}};W.prototype._serializeToLrep=function(){return this._oSerializer.saveCommands();};W.prototype._onUndo=function(){this._handleStopCutPaste();return this.getCommandStack().undo();};W.prototype._onRedo=function(){this._handleStopCutPaste();return this.getCommandStack().redo();};W.prototype._createToolsMenu=function(i,Z){if(!this.getDependent('toolbar')){var $;if(this.getLayer()==="USER"){$=P;}else if(U.getFiori2Renderer()){$=F;}else{$=S;}if(this.getLayer()==="USER"){this.addDependent(new $({textResources:this._getTextResources(),exit:this.stop.bind(this,false,true),restore:this._onRestore.bind(this)}),'toolbar');}else{this.addDependent(new $({modeSwitcher:this.getMode(),publishVisible:i,textResources:this._getTextResources(),exit:this.stop.bind(this,false,false),transport:this._onTransport.bind(this),restore:this._onRestore.bind(this),undo:this._onUndo.bind(this),redo:this._onRedo.bind(this),modeChange:this._onModeChange.bind(this),manageApps:E.onGetOverview.bind(null,true),appVariantOverview:this._onGetAppVariantOverview.bind(this),saveAs:E.onSaveAsFromRtaToolbar.bind(null,true,true)}),'toolbar');}var _;if(Z){this.getToolbar().getControl('saveAs').setVisible(Z);_=E.isOverviewExtended();if(_){this.getToolbar().getControl('appVariantOverview').setVisible(Z);}else{this.getToolbar().getControl('manageApps').setVisible(Z);}E.isManifestSupported().then(function(a1){if(_){this.getToolbar().getControl('appVariantOverview').setEnabled(a1);}else{this.getToolbar().getControl('manageApps').setEnabled(a1);}this.getToolbar().getControl('saveAs').setEnabled(a1);}.bind(this));}this._checkChangesExist().then(function(a1){if(!this.bIsDestroyed){this._bChangesExist=a1;this.getToolbar().setPublishEnabled(a1);this.getToolbar().setRestoreEnabled(a1);}}.bind(this));}};W.prototype._onGetAppVariantOverview=function(i){var Z=i.getParameter("item");var $=Z.getId()==='keyUser';return E.onGetOverview($);};W.prototype.destroy=function(){q.map(this._dependents,function(Z,$){this.removeDependent($);Z.destroy(true);}.bind(this));Object.keys(this._mServices).forEach(function(Z){this.stopService(Z);},this);if(this._oDesignTime){this._oDesignTime.destroy();this._oDesignTime=null;q(document).off("keydown",this.fnKeyDown);this._destroyDefaultPlugins();this.setPlugins(null);}if(this._oRootControl){this._oRootControl.removeStyleClass("sapUiRtaRoot");}this.setCommandStack(null);var i=U.getUshellContainer();if(i){i.setDirtyFlag(false);}if(this._oServiceEventBus){this._oServiceEventBus.destroy();}window.onbeforeunload=this._oldUnloadHandler;M.prototype.destroy.apply(this,arguments);};W.prototype._onTransport=function(){this._handleStopCutPaste();B.show(500);return this._serializeToLrep().then(function(){B.hide();return this._getFlexController()._oChangePersistence.transportAllUIChanges(this._oRootControl,U.getRtaStyleClassName(),this.getLayer()).then(function(i){if(i!=="Error"&&i!=="Cancel"){this._showMessageToast("MSG_TRANSPORT_SUCCESS");}}.bind(this));}.bind(this))['catch'](X);};W.prototype._deleteChanges=function(){return this._getFlexController().resetChanges(this.getLayer(),"Change.createInitialFileContent",s.getAppComponentForControl(this._oRootControl||sap.ui.getCore().byId(this.getRootControl()))).then(function(){this._reloadPage();}.bind(this))["catch"](function(i){return U._showMessageBox(u.Icon.ERROR,"HEADER_RESTORE_FAILED","MSG_RESTORE_FAILED",i);});};W.prototype._reloadPage=function(){window.location.reload();};W.prototype._showMessageToast=function(i){var Z=this._getTextResources().getText(i);v.show(Z);};W.needsRestart=function(i){var Z=!!window.localStorage.getItem("sap.ui.rta.restart."+i);return Z;};W.enableRestart=function(i){window.localStorage.setItem("sap.ui.rta.restart."+i,true);};W.disableRestart=function(i){window.localStorage.removeItem("sap.ui.rta.restart."+i);};W.prototype._onRestore=function(){var i=this.getLayer()==="USER"?this._getTextResources().getText("FORM_PERS_RESET_MESSAGE_PERSONALIZATION"):this._getTextResources().getText("FORM_PERS_RESET_MESSAGE");var Z=this.getLayer()==="USER"?this._getTextResources().getText("BTN_RESTORE"):this._getTextResources().getText("FORM_PERS_RESET_TITLE");var $=function(_){if(_==="OK"){W.enableRestart(this.getLayer());this._deleteChanges();this.getCommandStack().removeAllCommands();}}.bind(this);this._handleStopCutPaste();u.confirm(i,{icon:u.Icon.WARNING,title:Z,onClose:$,styleClass:U.getRtaStyleClassName()});};W.prototype._scheduleRenameOnCreatedContainer=function(i,Z){var $=function(c1){var d1=this.getPlugins()["createContainer"].getCreatedContainerId(i,c1.getElement().getId());var e1=J.getOverlay(d1);e1.setSelected(true);this.getPlugins()["rename"].startEdit(e1);};var _=function(c1){var d1=c1.getSource();if(d1.getGeometry()&&d1.getGeometry().visible){$.call(this,d1);d1.detachEvent('geometryChanged',_,this);}};var a1=function(c1){var d1=c1.getSource();if(!d1.getGeometry()||!d1.getGeometry().visible){d1.attachEvent('geometryChanged',_,this);}else{$.call(this,d1);}d1.detachEvent('afterRendering',a1,this);};var b1=function(c1){var d1=c1.getParameter("elementOverlay");if(d1.getElement().getId()===Z){this._oDesignTime.detachEvent("elementOverlayCreated",b1,this);d1.attachEvent('afterRendering',a1,this);}};this._oDesignTime.attachEvent("elementOverlayCreated",b1,this);};W.prototype._handleElementModified=function(i){this._handleStopCutPaste();var Z=i.getParameter("action");var $=i.getParameter("newControlId");var _=i.getParameter("command");if(_ instanceof sap.ui.rta.command.BaseCommand){if(Z&&$){this._scheduleRenameOnCreatedContainer(Z,$);}return this.getCommandStack().pushAndExecute(_).catch(function(a1){throw new Error(a1);});}return Promise.resolve();};W.prototype._onElementEditableChange=function(i){var Z=i.getParameter("editable");if(Z){this.iEditableOverlaysCount+=1;}else{this.iEditableOverlaysCount-=1;}};W.prototype._handleStopCutPaste=function(){if(this.getPlugins()["cutPaste"]){this.getPlugins()["cutPaste"].stopCutAndPaste();}};W.prototype._checkChangesExist=function(){if(this._getFlexController().getComponentName().length>0){return this._getFlexController().getComponentChanges({currentLayer:this.getLayer(),includeCtrlVariants:true}).then(function(i){return i.length>0;});}else{return Promise.resolve(false);}};W.prototype._getURLParsedHash=function(){var i=sap.ushell.Container.getService("URLParsing");if(i.parseShellHash&&i.getHash){return i.parseShellHash(i.getHash(window.location.href));}};W.prototype._buildNavigationArguments=function(i){return{target:{semanticObject:i.semanticObject,action:i.action,context:i.contextRaw},params:i.params,appSpecificRoute:i.appSpecificRoute,writeHistory:false};};W.prototype._hasCustomerLayerParameter=function(i){return i.params&&i.params[K]&&i.params[K][0]==="CUSTOMER";};W.prototype._reloadWithoutPersonalizationChanges=function(i,Z){if(!this._hasCustomerLayerParameter(i)){if(!i.params){i.params={};}i.params[K]=["CUSTOMER"];W.enableRestart("CUSTOMER");Z.toExternal(this._buildNavigationArguments(i));return Promise.resolve(true);}};W.prototype._removeMaxLayerParameter=function(){if(U.getUshellContainer()&&this.getLayer()!=="USER"){var i=U.getUshellContainer().getService("CrossApplicationNavigation");var Z=this._getURLParsedHash();if(i.toExternal&&Z){if(this._hasCustomerLayerParameter(Z)){delete Z.params[K];i.toExternal(this._buildNavigationArguments(Z));}}}};W.prototype._handlePersonalizationMessageBoxOnStart=function(){return U._showMessageBox(u.Icon.INFORMATION,"HEADER_PERSONALIZATION_EXISTS","MSG_PERSONALIZATION_EXISTS");};W.prototype._handleReloadMessageBox=function(i){return U._showMessageBox(u.Icon.INFORMATION,"HEADER_RELOAD_NEEDED",i,undefined,"BUTTON_RELOAD_NEEDED");};W.prototype._handlePersonalizationChangesOnStart=function(){var i=U.getUshellContainer();if(i&&this.getLayer()!=="USER"){var Z=this._getURLParsedHash();return this._getFlexController().isPersonalized({ignoreMaxLayerParameter:false}).then(function($){if($){return this._handlePersonalizationMessageBoxOnStart().then(function(){var _=sap.ushell.Container.getService("CrossApplicationNavigation");if(_.toExternal&&Z){return this._reloadWithoutPersonalizationChanges(Z,_);}}.bind(this));}}.bind(this));}else{return Promise.resolve(false);}};W.prototype._handleReloadOnExit=function(){return Promise.all([this._oSerializer.needsReload(),this._getFlexController().isPersonalized({ignoreMaxLayerParameter:true})]).then(function(i){var Z=i[0],$=i[1];if(Z||$){var _=this._RESTART.RELOAD_PAGE;var a1;if($){a1="MSG_RELOAD_WITH_PERSONALIZATION";if(!Z){_=this._RESTART.VIA_HASH;}}else if(Z){a1="MSG_RELOAD_NEEDED";}return this._handleReloadMessageBox(a1).then(function(){return _;});}else{return this._RESTART.NOT_NEEDED;}}.bind(this));};W.prototype._onModeChange=function(i){this.setMode(i.getParameter('key'));};W.prototype.setMode=function(i){if(this.getProperty('mode')!==i){var Z=this.getShowToolbars()&&this.getToolbar().getControl('modeSwitcher');var $=i==='adaptation';if(Z){Z.setSelectedButton(Z.getItems().filter(function(_){return _.getKey()===i;}).pop().getId());}this._oDesignTime.setEnabled($);this.getPlugins()['tabHandling'][$?'removeTabIndex':'restoreTabIndex']();this.setProperty('mode',i);this.fireModeChanged({mode:i});}};W.prototype.setMetadataScope=function(i){if(this._oDesignTime){q.sap.log.error("sap.ui.rta: Failed to set metadata scope on RTA instance after RTA is started");return;}this.setProperty('metadataScope',i);};function Y(i){if(H.hasOwnProperty(i)){return H[i].replace(/\./g,'/');}}W.prototype.startService=function(i){var Z=Y(i);var $;if(!Z){return Promise.reject(r.createError("RuntimeAuthoring#stopService",r.printf("Unknown service. Can't find any registered service by name '{0}'",i),"sap.ui.rta"));}else{$=this._mServices[i];if($){switch($.status){case'started':{return Promise.resolve($.exports);}case'starting':{return $.initPromise;}case'failed':{return $.initPromise;}default:{return Promise.reject(r.createError("RuntimeAuthoring#getService",r.printf("Unknown service status. Service name = '{0}'",i),"sap.ui.rta"));}}}else{$={status:N,location:Z,initPromise:new Promise(function(_,a1){sap.ui.require([Z],function(b1){$.factory=b1;if(!this._oServiceEventBus){this._oServiceEventBus=new I();}r.wrapIntoPromise(b1)(this,this._oServiceEventBus.publish.bind(this._oServiceEventBus,i)).then(function(c1){if(this.bIsDestroyed){throw r.createError("RuntimeAuthoring#getService",r.printf("RuntimeAuthoring instance is destroyed while initialising the service '{0}'",i),"sap.ui.rta");}if(!q.isPlainObject(c1)){throw r.createError("RuntimeAuthoring#getService",r.printf("Invalid service format. Service should return simple javascript object after initialisation. Service name = '{0}'",i),"sap.ui.rta");}$.service=c1;$.exports={};if(Array.isArray(c1.events)&&c1.events.length>0){q.extend($.exports,{attachEvent:this._oServiceEventBus.subscribe.bind(this._oServiceEventBus,i),detachEvent:this._oServiceEventBus.unsubscribe.bind(this._oServiceEventBus,i),attachEventOnce:this._oServiceEventBus.subscribeOnce.bind(this._oServiceEventBus,i)});}var d1=c1.exports||{};q.extend($.exports,Object.keys(d1).reduce(function(e1,f1){var g1=d1[f1];e1[f1]=typeof g1==="function"?r.wrapIntoPromise(g1):g1;return e1;},{}));$.status=Q;_(Object.freeze($.exports));}.bind(this)).catch(a1);}.bind(this),function(b1){$.status=V;a1(r.propagateError(b1,"RuntimeAuthoring#getService",r.printf("Can't load service '{0}' by its name: {1}",i,Z),"sap.ui.rta"));});}.bind(this)).catch(function(_){$.status=V;return Promise.reject(r.propagateError(_,"RuntimeAuthoring#getService",r.printf("Error during service '{0}' initialisation.",i),"sap.ui.rta"));})};this._mServices[i]=$;return $.initPromise;}}};W.prototype.stopService=function(i){var Z=this._mServices[i];if(Z){if(Z.status===Q){if(q.isFunction(Z.service.destroy)){Z.service.destroy();}}delete this._mServices[i];}else{throw r.createError("RuntimeAuthoring#stopService",r.printf("Can't destroy service: unable to find service with name '{0}'",i),"sap.ui.rta");}};W.prototype.getService=function(i){return this.startService(i);};return W;},true);
